/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.info.ContactImpl;
import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.api.models.info.LicenseImpl;
import io.smallrye.openapi.api.models.servers.ServerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.servers.Server;

public class ConfigUtil {
    private ConfigUtil() {
    }

    public static final void applyConfig(OpenApiConfig config, OpenAPI oai, boolean defaultRequiredProperties) {
        ConfigUtil.configureServers(config, oai);
        ConfigUtil.configureVersion(config, oai, defaultRequiredProperties);
        ConfigUtil.configureInfo(config, oai);
    }

    protected static final void configureVersion(OpenApiConfig config, OpenAPI oai, boolean defaultRequiredProperties) {
        String versionInConfig = config.getOpenApiVersion();
        if (versionInConfig != null && !versionInConfig.isEmpty()) {
            oai.setOpenapi(versionInConfig);
        } else if (defaultRequiredProperties && (oai.getOpenapi() == null || oai.getOpenapi().isEmpty())) {
            oai.setOpenapi("3.0.3");
        }
    }

    protected static final void configureInfo(OpenApiConfig config, OpenAPI oai) {
        if (!ConfigUtil.defaultIfNecessary(oai.getInfo(), InfoImpl::new, arg_0 -> ((OpenAPI)oai).setInfo(arg_0), config.getInfoTitle(), config.getInfoVersion(), config.getInfoDescription(), config.getInfoTermsOfService(), config.getInfoContactName(), config.getInfoContactEmail(), config.getInfoContactUrl(), config.getInfoLicenseName(), config.getInfoLicenseUrl())) {
            return;
        }
        ConfigUtil.setIfPresent(config.getInfoTitle(), arg_0 -> ((Info)oai.getInfo()).setTitle(arg_0));
        ConfigUtil.setIfPresent(config.getInfoVersion(), arg_0 -> ((Info)oai.getInfo()).setVersion(arg_0));
        ConfigUtil.setIfPresent(config.getInfoDescription(), arg_0 -> ((Info)oai.getInfo()).setDescription(arg_0));
        ConfigUtil.setIfPresent(config.getInfoTermsOfService(), arg_0 -> ((Info)oai.getInfo()).setTermsOfService(arg_0));
        if (ConfigUtil.defaultIfNecessary(oai.getInfo().getContact(), ContactImpl::new, arg_0 -> ((Info)oai.getInfo()).setContact(arg_0), config.getInfoContactName(), config.getInfoContactEmail(), config.getInfoContactUrl())) {
            ConfigUtil.setIfPresent(config.getInfoContactName(), arg_0 -> ((Contact)oai.getInfo().getContact()).setName(arg_0));
            ConfigUtil.setIfPresent(config.getInfoContactEmail(), arg_0 -> ((Contact)oai.getInfo().getContact()).setEmail(arg_0));
            ConfigUtil.setIfPresent(config.getInfoContactUrl(), arg_0 -> ((Contact)oai.getInfo().getContact()).setUrl(arg_0));
        }
        if (ConfigUtil.defaultIfNecessary(oai.getInfo().getLicense(), LicenseImpl::new, arg_0 -> ((Info)oai.getInfo()).setLicense(arg_0), config.getInfoLicenseName(), config.getInfoLicenseUrl())) {
            ConfigUtil.setIfPresent(config.getInfoLicenseName(), arg_0 -> ((License)oai.getInfo().getLicense()).setName(arg_0));
            ConfigUtil.setIfPresent(config.getInfoLicenseUrl(), arg_0 -> ((License)oai.getInfo().getLicense()).setUrl(arg_0));
        }
    }

    private static <T> boolean defaultIfNecessary(T value, Supplier<T> factory, Consumer<T> mutator, Object ... sources) {
        if (Stream.of(sources).anyMatch(Objects::nonNull)) {
            if (value == null) {
                mutator.accept(factory.get());
            }
            return true;
        }
        return false;
    }

    private static <T> void setIfPresent(T value, Consumer<T> mutator) {
        if (value != null) {
            mutator.accept(value);
        }
    }

    protected static final void configureServers(OpenApiConfig config, OpenAPI oai) {
        List<String> servers = config.servers();
        if (servers != null && !servers.isEmpty()) {
            oai.servers(new ArrayList());
            for (String server : servers) {
                ServerImpl s = new ServerImpl();
                s.setUrl(server);
                oai.addServer((Server)s);
            }
        }
        Optional.ofNullable(oai.getPaths()).map(Paths::getPathItems).ifPresent(pathItems -> pathItems.forEach((key, value) -> ConfigUtil.configureServers(config, key, value)));
    }

    protected static void configureServers(OpenApiConfig config, String pathName, PathItem pathItem) {
        if (pathItem == null) {
            return;
        }
        List<String> pathServers = config.pathServers(pathName);
        if (pathServers != null && !pathServers.isEmpty()) {
            pathItem.servers(new ArrayList());
            for (String pathServer : pathServers) {
                ServerImpl server = new ServerImpl();
                server.setUrl(pathServer);
                pathItem.addServer((Server)server);
            }
        }
        ConfigUtil.configureServers(config, pathItem.getGET());
        ConfigUtil.configureServers(config, pathItem.getPUT());
        ConfigUtil.configureServers(config, pathItem.getPOST());
        ConfigUtil.configureServers(config, pathItem.getDELETE());
        ConfigUtil.configureServers(config, pathItem.getHEAD());
        ConfigUtil.configureServers(config, pathItem.getOPTIONS());
        ConfigUtil.configureServers(config, pathItem.getPATCH());
        ConfigUtil.configureServers(config, pathItem.getTRACE());
    }

    protected static void configureServers(OpenApiConfig config, Operation operation) {
        if (operation == null) {
            return;
        }
        if (operation.getOperationId() == null) {
            return;
        }
        List<String> operationServers = config.operationServers(operation.getOperationId());
        if (operationServers != null && !operationServers.isEmpty()) {
            operation.servers(new ArrayList());
            for (String operationServer : operationServers) {
                ServerImpl server = new ServerImpl();
                server.setUrl(operationServer);
                operation.addServer((Server)server);
            }
        }
    }
}

