/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.metadata;

import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sessions.Session;

public class NamespaceURITransformer
implements FieldTransformer {
    private static final char HASH = '#';
    AbstractTransformationMapping transformationMapping;
    private NamespaceResolver namespaceResolver;

    @Override
    public void initialize(AbstractTransformationMapping mapping) {
        this.transformationMapping = mapping;
        this.namespaceResolver = ((XMLDescriptor)mapping.getDescriptor()).getNamespaceResolver();
    }

    @Override
    public Object buildFieldValue(Object instance, String fieldName, Session session) {
        if (null == instance) {
            return null;
        }
        String value = (String)this.transformationMapping.getAttributeValueFromObject(instance);
        if (value == null) {
            return null;
        }
        int index = value.lastIndexOf(35);
        if (index > -1) {
            String namespaceURI = value.substring(0, index);
            if (null == this.namespaceResolver) {
                return namespaceURI;
            }
            String prefix = this.namespaceResolver.resolveNamespaceURI(namespaceURI);
            if (prefix == null) {
                return namespaceURI;
            }
            return null;
        }
        return null;
    }
}

