/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

final class TimeoutExecution {
    private static final int STATE_RUNNING = 0;
    private static final int STATE_FINISHED = 1;
    private static final int STATE_TIMED_OUT = 2;
    private static final VarHandle STATE = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "state", VarHandle.class, TimeoutExecution.class, Integer.TYPE);
    private volatile int state = 0;
    private final Thread executingThread;
    private final Runnable timeoutAction;

    TimeoutExecution(Thread executingThread, Runnable timeoutAction) {
        this.executingThread = executingThread;
        this.timeoutAction = timeoutAction;
    }

    boolean isRunning() {
        return this.state == 0;
    }

    boolean hasFinished() {
        return this.state == 1;
    }

    boolean hasTimedOut() {
        return this.state == 2;
    }

    void finish(Runnable ifFinished) {
        if (STATE.compareAndSet(this, 0, 1)) {
            ifFinished.run();
        }
    }

    void timeoutAndInterrupt() {
        if (STATE.compareAndSet(this, 0, 2)) {
            if (this.executingThread != null) {
                this.executingThread.interrupt();
            }
            if (this.timeoutAction != null) {
                this.timeoutAction.run();
            }
        }
    }
}

