/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.pbe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fulcrum.jce.crypto.CryptoParameters;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactory;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactoryImpl;
import org.apache.fulcrum.jce.crypto.CryptoUtil;
import org.apache.fulcrum.jce.crypto.HexConverter;
import org.apache.fulcrum.jce.crypto.PasswordFactory;
import org.apache.fulcrum.jce.crypto.PasswordParameters;
import org.apache.fulcrum.pbe.PBEService;

public class PBEServiceImpl
extends AbstractLogEnabled
implements PBEService,
Configurable {
    private CryptoStreamFactory cryptoStreamFactory;
    private byte[] passwordSalt;
    private int passwordCount;
    private char[] defaultPassword;

    public void configure(Configuration configuration) throws ConfigurationException {
        byte[] cryptoSalt = CryptoParameters.SALT;
        int cryptoCount = configuration.getChild("cyrptoCount").getValueAsInteger(20);
        String tempCryptoSalt = configuration.getChild("cryptoSalt").getValue("");
        if (tempCryptoSalt.length() > 0) {
            cryptoSalt = HexConverter.toBytes((String)tempCryptoSalt);
        }
        this.cryptoStreamFactory = new CryptoStreamFactoryImpl(cryptoSalt, cryptoCount);
        this.passwordSalt = PasswordParameters.SALT;
        this.passwordCount = configuration.getChild("passwordCount").getValueAsInteger(20);
        this.defaultPassword = PasswordParameters.DEFAULTPASSWORD;
    }

    public char[] createPassword() throws Exception {
        return PasswordFactory.create((char[])this.defaultPassword, (byte[])this.passwordSalt, (int)this.passwordCount);
    }

    public char[] createPassword(char[] seed) throws Exception {
        return PasswordFactory.create((char[])seed, (byte[])this.passwordSalt, (int)this.passwordCount);
    }

    public String decryptString(String cipherText, char[] password) throws GeneralSecurityException, IOException {
        return CryptoUtil.decryptString((CryptoStreamFactory)this.getCryptoStreamFactory(), (String)cipherText, (char[])password);
    }

    public String encryptString(String plainText, char[] password) throws GeneralSecurityException, IOException {
        return CryptoUtil.encryptString((CryptoStreamFactory)this.getCryptoStreamFactory(), (String)plainText, (char[])password);
    }

    public InputStream getInputStream(InputStream is, char[] password) throws GeneralSecurityException, IOException {
        return this.getCryptoStreamFactory().getInputStream(is, password);
    }

    public InputStream getSmartInputStream(InputStream is, char[] password) throws GeneralSecurityException, IOException {
        return this.getCryptoStreamFactory().getSmartInputStream(is, password);
    }

    public OutputStream getOutputStream(OutputStream os, char[] password) throws GeneralSecurityException, IOException {
        return this.getCryptoStreamFactory().getOutputStream(os, password);
    }

    public void decrypt(Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        CryptoUtil.decrypt((CryptoStreamFactory)this.getCryptoStreamFactory(), (Object)source, (Object)target, (char[])password);
    }

    public void encrypt(Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        CryptoUtil.encrypt((CryptoStreamFactory)this.getCryptoStreamFactory(), (Object)source, (Object)target, (char[])password);
    }

    private CryptoStreamFactory getCryptoStreamFactory() {
        return this.cryptoStreamFactory;
    }
}

