/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cde.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.cde.IRutaConstraint;
import org.apache.uima.ruta.cde.IRutaRuleConstraint;
import org.apache.uima.ruta.cde.ui.ConstraintSelectComposite;
import org.apache.uima.ruta.cde.ui.ConstraintSelectView;
import org.apache.uima.ruta.cde.ui.DocumentSelectComposite;
import org.apache.uima.ruta.cde.ui.DocumentView;
import org.apache.uima.ruta.cde.utils.ConstraintData;
import org.apache.uima.ruta.cde.utils.DocumentData;
import org.apache.uima.ruta.cde.utils.EvaluationMeasures;
import org.apache.uima.ruta.testing.evaluator.ICasEvaluator;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class DocumentViewRunHandler
implements IHandler {
    private void updateUI(final DocumentSelectComposite composite) {
        composite.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    composite.getViewer().refresh();
                    ArrayList<Double[]> results = new ArrayList<Double[]>();
                    if (composite.getTestDataPath() != null) {
                        for (DocumentData data : composite.getDocumentList()) {
                            double result = data.getAugmentedResult();
                            double score = data.getFMeasure();
                            results.add(new Double[]{result, score});
                        }
                    }
                    composite.updateMeasureReport("" + EvaluationMeasures.getMeasureReport(results));
                }
                catch (Exception e) {
                    RutaAddonsPlugin.error(e);
                }
                composite.getViewer().refresh();
                composite.update();
            }
        });
    }

    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ConstraintSelectView constraintView = (ConstraintSelectView)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.apache.uima.ruta.cde.ui.ConstraintSelectView");
            ConstraintSelectComposite composite = constraintView.getComposite();
            List<ConstraintData> constraintList = composite.getConstraintList();
            DocumentView docView = (DocumentView)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.apache.uima.ruta.cde.ui.DocumentView");
            DocumentSelectComposite docComposite = docView.getDocComposite();
            ArrayList<DocumentData> documents = docComposite.getDocumentList();
            if (documents.isEmpty()) {
                docComposite.setDocumentsByDir();
            }
            File typeSystem = docComposite.getTypeSystem();
            DocumentViewRunHandlerJob job = new DocumentViewRunHandlerJob(event, constraintList, documents, typeSystem, docComposite.getTestDataPath(), docComposite);
            job.addJobChangeListener((IJobChangeListener)new DocumentViewRunJobChangeAdapter(docComposite));
            job.schedule();
        }
        catch (PartInitException e) {
            RutaAddonsPlugin.error(e);
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }

    private double calculateF1(CAS resultCas) {
        TypeSystem ts = resultCas.getTypeSystem();
        Type falsePositiveType = ts.getType("org.apache.uima.ruta.type.FalsePositive");
        Type falseNegativeType = ts.getType("org.apache.uima.ruta.type.FalseNegative");
        Type truePositiveType = ts.getType("org.apache.uima.ruta.type.TruePositive");
        int falsePositiveCount = resultCas.getAnnotationIndex(falsePositiveType).size();
        int falseNegativeCount = resultCas.getAnnotationIndex(falseNegativeType).size();
        int truePositiveCount = resultCas.getAnnotationIndex(truePositiveType).size();
        double a = falsePositiveCount;
        double b = falseNegativeCount;
        double c = truePositiveCount;
        double precision = c / (c + a);
        double recall = c / (c + b);
        double fMeasure = 2.0 * (precision * recall) / (precision + recall);
        fMeasure *= 10000.0;
        fMeasure = Math.round(fMeasure);
        return fMeasure /= 10000.0;
    }

    public HashMap<String, String> createFileMap(String directoryFolderPath) {
        HashMap<String, String> filesMap = new HashMap<String, String>();
        File folder = new File(directoryFolderPath);
        if (folder.isDirectory()) {
            String[] files;
            for (String fileName : files = folder.list(null)) {
                String fullPath = folder + System.getProperty("file.separator") + fileName;
                String fileNameWithoutExtension = this.getFileNameWithoutExtensions(fullPath);
                if (StringUtils.isBlank((CharSequence)fileNameWithoutExtension)) continue;
                filesMap.put(fileNameWithoutExtension, fullPath);
            }
        }
        return filesMap;
    }

    public String getFileNameWithoutExtensions(String path) {
        File f = new File(path);
        String fileNameNoExtension = "";
        if (f.exists() && f.isFile()) {
            if (path.contains(".")) {
                int beginOfFileName = path.lastIndexOf(System.getProperty("file.separator")) + 1;
                int endOfFileName = path.indexOf(".");
                fileNameNoExtension = path.substring(beginOfFileName, endOfFileName);
            } else {
                int beginOfFileName = path.lastIndexOf(System.getProperty("file.separator"));
                fileNameNoExtension = path.substring(beginOfFileName);
            }
        }
        return fileNameNoExtension;
    }

    private class DocumentViewRunHandlerJob
    extends Job {
        private List<ConstraintData> constraints;
        private List<DocumentData> documents;
        private File typeSystem;
        private String testDataPath;
        private final DocumentSelectComposite composite;

        DocumentViewRunHandlerJob(ExecutionEvent event, List<ConstraintData> constraints, ArrayList<DocumentData> documents, File typeSystem, String testDataPath, DocumentSelectComposite composite) {
            super("UIMA Ruta CDE");
            this.constraints = constraints;
            this.documents = documents;
            this.typeSystem = typeSystem;
            this.testDataPath = testDataPath;
            this.composite = composite;
        }

        public IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("UIMA Ruta CDE", this.constraints.size() * this.documents.size());
            CAS inputCAS = null;
            CAS testCas = null;
            try {
                URL tpUrl = ((Object)((Object)this)).getClass().getResource("/org/apache/uima/ruta/engine/TypePriorities.xml");
                TypePriorities typePriorities = UIMAFramework.getXMLParser().parseTypePriorities(new XMLInputSource(tpUrl));
                TypeSystemDescription descriptor = (TypeSystemDescription)UIMAFramework.getXMLParser().parse(new XMLInputSource(this.typeSystem));
                inputCAS = CasCreationUtils.createCas((TypeSystemDescription)descriptor, (TypePriorities)typePriorities, (FsIndexDescription[])new FsIndexDescription[0]);
                testCas = CasCreationUtils.createCas((TypeSystemDescription)descriptor, null, (FsIndexDescription[])new FsIndexDescription[0]);
            }
            catch (Exception e) {
                RutaAddonsPlugin.error(e);
            }
            for (DocumentData document : this.documents) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                double count = 0.0;
                double augResult = 0.0;
                document.setResults(new ArrayList<String[]>());
                if (this.constraints.size() > 0) {
                    monitor.setTaskName("UIMA Ruta CDE: " + document.getDocument().getName());
                    try {
                        String documentFileName;
                        HashMap<String, String> testFilesMap;
                        inputCAS.reset();
                        XmiCasDeserializer.deserialize((InputStream)new FileInputStream(document.getDocument()), (CAS)inputCAS, (boolean)true);
                        for (ConstraintData constraintData : this.constraints) {
                            Double partResult;
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            String[] partialResult = new String[2];
                            IRutaConstraint constraint = constraintData.getConstraint();
                            if (constraint instanceof IRutaRuleConstraint) {
                                ((IRutaRuleConstraint)constraint).setTypeSystemLocation(this.typeSystem.getAbsolutePath());
                            }
                            if ((partResult = constraint.processConstraint(inputCAS)) != null) {
                                partialResult[0] = constraint.getDescription();
                                partialResult[1] = String.valueOf(partResult);
                                int weight = constraintData.getWeight();
                                count += (double)weight;
                                double weightedResult = partResult * (double)weight;
                                augResult += weightedResult;
                                document.getResults().add(partialResult);
                            }
                            monitor.worked(1);
                        }
                        if (this.testDataPath != null && (testFilesMap = DocumentViewRunHandler.this.createFileMap(this.testDataPath)).get(documentFileName = DocumentViewRunHandler.this.getFileNameWithoutExtensions(document.getDocument().getAbsolutePath())) != null) {
                            File testFile = new File(testFilesMap.get(documentFileName));
                            testCas.reset();
                            XmiCasDeserializer.deserialize((InputStream)new FileInputStream(testFile), (CAS)testCas, (boolean)true);
                            IPreferenceStore store = RutaAddonsPlugin.getDefault().getPreferenceStore();
                            String factoryName = store.getString("EVALUATOR_FACTORY");
                            boolean includeSubtypes = store.getBoolean("INCLUDE_SUBTYPES");
                            boolean useAllTypes = store.getBoolean("ALL_TYPES");
                            ICasEvaluator evaluator = RutaAddonsPlugin.getCasEvaluatorFactoryById(factoryName).createEvaluator();
                            ArrayList<String> excludedTypes = new ArrayList<String>();
                            CAS resultCas = evaluator.evaluate(testCas, inputCAS, excludedTypes, includeSubtypes, useAllTypes);
                            document.setFMeasure(DocumentViewRunHandler.this.calculateF1(resultCas));
                        }
                    }
                    catch (Exception e) {
                        RutaAddonsPlugin.error(e);
                    }
                }
                if (count != 0.0) {
                    augResult /= count;
                }
                document.setAugmentedResult(augResult);
                DocumentViewRunHandler.this.updateUI(this.composite);
            }
            inputCAS.release();
            testCas.release();
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    private class DocumentViewRunJobChangeAdapter
    extends JobChangeAdapter {
        private DocumentSelectComposite composite;

        DocumentViewRunJobChangeAdapter(DocumentSelectComposite composite) {
            this.composite = composite;
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().isOK()) {
                DocumentViewRunHandler.this.updateUI(this.composite);
            }
        }
    }
}

