/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.ShufflePartitionedData;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.guava.annotations.VisibleForTesting;
import org.apache.uniffle.guava.collect.Lists;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleFlushManager;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleBuffer.class);
    private final long capacity;
    private long size;
    private List<ShufflePartitionedBlock> blocks;
    private Map<Long, List<ShufflePartitionedBlock>> inFlushBlockMap;

    public ShuffleBuffer(long capacity) {
        this.capacity = capacity;
        this.size = 0L;
        this.blocks = new LinkedList<ShufflePartitionedBlock>();
        this.inFlushBlockMap = JavaUtils.newConcurrentMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long append(ShufflePartitionedData data) {
        long mSize = 0L;
        ShuffleBuffer shuffleBuffer = this;
        synchronized (shuffleBuffer) {
            for (ShufflePartitionedBlock block : data.getBlockList()) {
                this.blocks.add(block);
                mSize += block.getSize();
            }
            this.size += mSize;
        }
        return mSize;
    }

    public synchronized ShuffleDataFlushEvent toFlushEvent(String appId, int shuffleId, int startPartition, int endPartition, Supplier<Boolean> isValid, ShuffleDataDistributionType dataDistributionType) {
        LinkedList<ShufflePartitionedBlock> spBlocks;
        if (this.blocks.isEmpty()) {
            return null;
        }
        LinkedList<ShufflePartitionedBlock> inFlushedQueueBlocks = spBlocks = new LinkedList<ShufflePartitionedBlock>(this.blocks);
        if (dataDistributionType == ShuffleDataDistributionType.LOCAL_ORDER) {
            inFlushedQueueBlocks = new LinkedList<ShufflePartitionedBlock>(spBlocks);
            spBlocks.sort(Comparator.comparingLong(ShufflePartitionedBlock::getTaskAttemptId));
        }
        long eventId = ShuffleFlushManager.ATOMIC_EVENT_ID.getAndIncrement();
        ShuffleDataFlushEvent event = new ShuffleDataFlushEvent(eventId, appId, shuffleId, startPartition, endPartition, this.size, spBlocks, isValid, this);
        event.addCleanupCallback(() -> {
            this.clearInFlushBuffer(event.getEventId());
            spBlocks.forEach(spb -> spb.getData().release());
        });
        this.inFlushBlockMap.put(eventId, inFlushedQueueBlocks);
        this.blocks.clear();
        this.size = 0L;
        return event;
    }

    public synchronized ShuffleDataFlushEvent toFlushEvent(String appId, int shuffleId, int startPartition, int endPartition, Supplier<Boolean> isValid) {
        return this.toFlushEvent(appId, shuffleId, startPartition, endPartition, isValid, ShuffleDataDistributionType.NORMAL);
    }

    public List<ShufflePartitionedBlock> getBlocks() {
        return this.blocks;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFull() {
        return this.size > this.capacity;
    }

    public synchronized void clearInFlushBuffer(long eventId) {
        this.inFlushBlockMap.remove(eventId);
    }

    @VisibleForTesting
    public Map<Long, List<ShufflePartitionedBlock>> getInFlushBlockMap() {
        return this.inFlushBlockMap;
    }

    public synchronized ShuffleDataResult getShuffleData(long lastBlockId, int readBufferSize) {
        return this.getShuffleData(lastBlockId, readBufferSize, null);
    }

    public synchronized ShuffleDataResult getShuffleData(long lastBlockId, int readBufferSize, Roaring64NavigableMap expectedTaskIds) {
        try {
            ArrayList<BufferSegment> bufferSegments = Lists.newArrayList();
            ArrayList<ShufflePartitionedBlock> readBlocks = Lists.newArrayList();
            this.updateBufferSegmentsAndResultBlocks(lastBlockId, readBufferSize, bufferSegments, readBlocks, expectedTaskIds);
            if (!bufferSegments.isEmpty()) {
                CompositeByteBuf byteBuf = new CompositeByteBuf(ByteBufAllocator.DEFAULT, true, 1024);
                this.updateShuffleData(readBlocks, byteBuf);
                return new ShuffleDataResult((ByteBuf)byteBuf, bufferSegments);
            }
        }
        catch (Exception e) {
            LOG.error("Exception happened when getShuffleData in buffer", (Throwable)e);
        }
        return new ShuffleDataResult();
    }

    private void updateBufferSegmentsAndResultBlocks(long lastBlockId, long readBufferSize, List<BufferSegment> bufferSegments, List<ShufflePartitionedBlock> resultBlocks, Roaring64NavigableMap expectedTaskIds) {
        long nextBlockId = lastBlockId;
        List<Long> sortedEventId = this.sortFlushingEventId();
        int offset = 0;
        boolean hasLastBlockId = false;
        if (!this.inFlushBlockMap.isEmpty()) {
            for (Long eventId : sortedEventId) {
                if (nextBlockId == -1L) {
                    this.updateSegmentsWithoutBlockId(offset, this.inFlushBlockMap.get(eventId), readBufferSize, bufferSegments, resultBlocks, expectedTaskIds);
                    hasLastBlockId = true;
                } else {
                    hasLastBlockId = this.updateSegmentsWithBlockId(offset, this.inFlushBlockMap.get(eventId), readBufferSize, nextBlockId, bufferSegments, resultBlocks, expectedTaskIds);
                    if (hasLastBlockId) {
                        nextBlockId = -1L;
                    }
                }
                if (!bufferSegments.isEmpty()) {
                    offset = this.calculateDataLength(bufferSegments);
                }
                if ((long)offset < readBufferSize) continue;
                break;
            }
        }
        if (this.blocks.size() > 0 && (long)offset < readBufferSize) {
            if (nextBlockId == -1L) {
                this.updateSegmentsWithoutBlockId(offset, this.blocks, readBufferSize, bufferSegments, resultBlocks, expectedTaskIds);
                hasLastBlockId = true;
            } else {
                hasLastBlockId = this.updateSegmentsWithBlockId(offset, this.blocks, readBufferSize, nextBlockId, bufferSegments, resultBlocks, expectedTaskIds);
            }
        }
        if (!(this.inFlushBlockMap.isEmpty() && this.blocks.size() <= 0 || offset != 0 || hasLastBlockId)) {
            this.updateBufferSegmentsAndResultBlocks(-1L, readBufferSize, bufferSegments, resultBlocks, expectedTaskIds);
        }
    }

    private int calculateDataLength(List<BufferSegment> bufferSegments) {
        BufferSegment bufferSegment = bufferSegments.get(bufferSegments.size() - 1);
        return bufferSegment.getOffset() + bufferSegment.getLength();
    }

    private void updateShuffleData(List<ShufflePartitionedBlock> readBlocks, CompositeByteBuf data) {
        int offset = 0;
        for (ShufflePartitionedBlock block : readBlocks) {
            try {
                data.addComponent(true, block.getData().retain());
            }
            catch (Exception e) {
                LOG.error("Unexpected exception for System.arraycopy, length[" + block.getLength() + "], offset[" + offset + "], dataLength[" + data.capacity() + "]", (Throwable)e);
                throw e;
            }
            offset += block.getLength();
        }
    }

    private List<Long> sortFlushingEventId() {
        ArrayList<Long> eventIdList = Lists.newArrayList(this.inFlushBlockMap.keySet());
        eventIdList.sort((id1, id2) -> {
            if (id1 > id2) {
                return 1;
            }
            return -1;
        });
        return eventIdList;
    }

    private void updateSegmentsWithoutBlockId(int offset, List<ShufflePartitionedBlock> cachedBlocks, long readBufferSize, List<BufferSegment> bufferSegments, List<ShufflePartitionedBlock> readBlocks, Roaring64NavigableMap expectedTaskIds) {
        int currentOffset = offset;
        for (ShufflePartitionedBlock block : cachedBlocks) {
            if (expectedTaskIds != null && !expectedTaskIds.contains(block.getTaskAttemptId())) continue;
            bufferSegments.add(new BufferSegment(block.getBlockId(), (long)currentOffset, block.getLength(), block.getUncompressLength(), block.getCrc(), block.getTaskAttemptId()));
            readBlocks.add(block);
            if ((long)(currentOffset += block.getLength()) < readBufferSize) continue;
            break;
        }
    }

    private boolean updateSegmentsWithBlockId(int offset, List<ShufflePartitionedBlock> cachedBlocks, long readBufferSize, long lastBlockId, List<BufferSegment> bufferSegments, List<ShufflePartitionedBlock> readBlocks, Roaring64NavigableMap expectedTaskIds) {
        int currentOffset = offset;
        boolean foundBlockId = false;
        for (ShufflePartitionedBlock block : cachedBlocks) {
            if (!foundBlockId) {
                if (block.getBlockId() != lastBlockId) continue;
                foundBlockId = true;
                continue;
            }
            if (expectedTaskIds != null && !expectedTaskIds.contains(block.getTaskAttemptId())) continue;
            bufferSegments.add(new BufferSegment(block.getBlockId(), (long)currentOffset, block.getLength(), block.getUncompressLength(), block.getCrc(), block.getTaskAttemptId()));
            readBlocks.add(block);
            if ((long)(currentOffset += block.getLength()) < readBufferSize) continue;
            break;
        }
        return foundBlockId;
    }
}

