/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.io.netty.handler.codec.compression;

import org.apache.uniffle.io.netty.buffer.ByteBuf;
import org.apache.uniffle.io.netty.channel.ChannelHandlerContext;
import org.apache.uniffle.io.netty.handler.codec.ByteToMessageDecoder;
import org.apache.uniffle.io.netty.handler.codec.compression.DecompressionException;
import org.apache.uniffle.io.netty.util.internal.ObjectUtil;

public abstract class ZlibDecoder
extends ByteToMessageDecoder {
    protected final int maxAllocation;

    public ZlibDecoder() {
        this(0);
    }

    public ZlibDecoder(int maxAllocation) {
        this.maxAllocation = ObjectUtil.checkPositiveOrZero(maxAllocation, "maxAllocation");
    }

    public abstract boolean isClosed();

    protected ByteBuf prepareDecompressBuffer(ChannelHandlerContext ctx, ByteBuf buffer, int preferredSize) {
        if (buffer == null) {
            if (this.maxAllocation == 0) {
                return ctx.alloc().heapBuffer(preferredSize);
            }
            return ctx.alloc().heapBuffer(Math.min(preferredSize, this.maxAllocation), this.maxAllocation);
        }
        if (buffer.ensureWritable(preferredSize, true) == 1) {
            this.decompressionBufferExhausted(buffer.duplicate());
            buffer.skipBytes(buffer.readableBytes());
            throw new DecompressionException("Decompression buffer has reached maximum size: " + buffer.maxCapacity());
        }
        return buffer;
    }

    protected void decompressionBufferExhausted(ByteBuf buffer) {
    }
}

