/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RssMRConfig;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.factory.ShuffleClientFactory;
import org.apache.uniffle.com.google.common.collect.Sets;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssMRUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RssMRUtils.class);
    private static final int MAX_ATTEMPT_LENGTH = 6;
    private static final long MAX_ATTEMPT_ID = 63L;

    public static long convertTaskAttemptIdToLong(TaskAttemptID taskAttemptID, int appAttemptId) {
        long lowBytes = taskAttemptID.getTaskID().getId();
        if (lowBytes > 0x1FFFFFL) {
            throw new RssException("TaskAttempt " + taskAttemptID + " low bytes " + lowBytes + " exceed");
        }
        if (appAttemptId < 1) {
            throw new RssException("appAttemptId " + appAttemptId + " is wrong");
        }
        long highBytes = (long)taskAttemptID.getId() - (long)((appAttemptId - 1) * 1000);
        if (highBytes > 63L || highBytes < 0L) {
            throw new RssException("TaskAttempt " + taskAttemptID + " high bytes " + highBytes + " exceed");
        }
        return (highBytes << 45) + lowBytes;
    }

    public static TaskAttemptID createMRTaskAttemptId(JobID jobID, TaskType taskType, long rssTaskAttemptId, int appAttemptId) {
        if (appAttemptId < 1) {
            throw new RssException("appAttemptId " + appAttemptId + " is wrong");
        }
        TaskID taskID = new TaskID(jobID, taskType, (int)(rssTaskAttemptId & 0x1FFFFFL));
        return new TaskAttemptID(taskID, (int)(rssTaskAttemptId >> 45) + 1000 * (appAttemptId - 1));
    }

    public static ShuffleWriteClient createShuffleClient(JobConf jobConf) {
        int heartBeatThreadNum = jobConf.getInt("mapreduce.rss.client.heartBeat.threadNum", 4);
        int retryMax = jobConf.getInt("mapreduce.rss.client.retry.max", 50);
        long retryIntervalMax = jobConf.getLong("mapreduce.rss.client.retry.interval.max", 10000L);
        String clientType = jobConf.get("mapreduce.rss.client.type", "GRPC");
        int replicaWrite = jobConf.getInt("mapreduce.rss.data.replica.write", 1);
        int replicaRead = jobConf.getInt("mapreduce.rss.data.replica.read", 1);
        int replica = jobConf.getInt("mapreduce.rss.data.replica", 1);
        boolean replicaSkipEnabled = jobConf.getBoolean("mapreduce.rss.data.replica.skip.enabled", true);
        int dataTransferPoolSize = jobConf.getInt("mapreduce.rss.client.data.transfer.pool.size", RssMRConfig.RSS_DATA_TRANSFER_POOL_SIZE_DEFAULT_VALUE);
        int dataCommitPoolSize = jobConf.getInt("mapreduce.rss.client.data.commit.pool.size", -1);
        ShuffleWriteClient client = ShuffleClientFactory.getInstance().createShuffleWriteClient(clientType, retryMax, retryIntervalMax, heartBeatThreadNum, replica, replicaWrite, replicaRead, replicaSkipEnabled, dataTransferPoolSize, dataCommitPoolSize, RssMRConfig.toRssConf((Configuration)jobConf));
        return client;
    }

    public static Set<ShuffleServerInfo> getAssignedServers(Configuration jobConf, int reduceID) {
        String servers = jobConf.get("mapreduce.rss.assignment.partition." + String.valueOf(reduceID));
        String[] splitServers = servers.split(",");
        HashSet<ShuffleServerInfo> assignServers = Sets.newHashSet();
        RssMRUtils.buildAssignServers(reduceID, splitServers, assignServers);
        return assignServers;
    }

    public static ApplicationAttemptId getApplicationAttemptId() {
        String containerIdStr = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
        ContainerId containerId = ContainerId.fromString((String)containerIdStr);
        return containerId.getApplicationAttemptId();
    }

    public static void applyClientConf(Configuration jobConf, JobConf mrJobConf) {
        if (jobConf == null) {
            LOG.warn("Job conf is null");
            return;
        }
        if (mrJobConf == null) {
            LOG.warn("Empty conf items");
            return;
        }
        Iterator iterator = mrJobConf.iterator();
        HashMap confItems = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("mapreduce.rss.")) continue;
            confItems.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry kv : confItems.entrySet()) {
            String mrConfKey = (String)kv.getKey();
            String mrConfVal = (String)kv.getValue();
            if (!StringUtils.isEmpty((CharSequence)jobConf.get(mrConfKey, ""))) continue;
            LOG.warn("Use conf client conf {} = {}", (Object)mrConfKey, (Object)mrConfVal);
            jobConf.set(mrConfKey, mrConfVal);
        }
    }

    public static void applyDynamicClientConf(Configuration jobConf, Map<String, String> confItems) {
        if (jobConf == null) {
            LOG.warn("Job conf is null");
            return;
        }
        if (confItems == null || confItems.isEmpty()) {
            LOG.warn("Empty conf items");
            return;
        }
        for (Map.Entry<String, String> kv : confItems.entrySet()) {
            String mrConfKey = kv.getKey();
            if (!mrConfKey.startsWith("mapreduce.")) {
                mrConfKey = "mapreduce." + mrConfKey;
            }
            String mrConfVal = kv.getValue();
            if (!StringUtils.isEmpty((CharSequence)jobConf.get(mrConfKey, "")) && !RssMRConfig.RSS_MANDATORY_CLUSTER_CONF.contains(mrConfKey)) continue;
            LOG.warn("Use conf dynamic conf {} = {}", (Object)mrConfKey, (Object)mrConfVal);
            jobConf.set(mrConfKey, mrConfVal);
        }
    }

    public static int getInt(Configuration rssJobConf, String key, int defaultValue) {
        return rssJobConf.getInt(key, defaultValue);
    }

    public static long getLong(Configuration rssJobConf, String key, long defaultValue) {
        return rssJobConf.getLong(key, defaultValue);
    }

    public static boolean getBoolean(Configuration rssJobConf, String key, boolean defaultValue) {
        return rssJobConf.getBoolean(key, defaultValue);
    }

    public static double getDouble(Configuration rssJobConf, String key, double defaultValue) {
        return rssJobConf.getDouble(key, defaultValue);
    }

    public static String getString(Configuration rssJobConf, String key) {
        return rssJobConf.get(key, "");
    }

    public static String getString(Configuration rssJobConf, String key, String defaultValue) {
        return rssJobConf.get(key, defaultValue);
    }

    public static long getBlockId(long partitionId, long taskAttemptId, int nextSeqNo) {
        long attemptId = taskAttemptId >> 45;
        if (attemptId < 0L || attemptId > 63L) {
            throw new RssException("Can't support attemptId [" + attemptId + "], the max value should be " + 63L);
        }
        long atomicInt = (long)(nextSeqNo << 6) + attemptId;
        if (atomicInt < 0L || atomicInt > 262143L) {
            throw new RssException("Can't support sequence [" + atomicInt + "], the max value should be " + 262143L);
        }
        if (partitionId < 0L || partitionId > 0xFFFFFFL) {
            throw new RssException("Can't support partitionId[" + partitionId + "], the max value should be " + 0xFFFFFFL);
        }
        long taskId = taskAttemptId - (attemptId << 45);
        if (taskId < 0L || taskId > 0x1FFFFFL) {
            throw new RssException("Can't support taskId[" + taskId + "], the max value should be " + 0x1FFFFFL);
        }
        return (atomicInt << 45) + (partitionId << 21) + taskId;
    }

    public static long getTaskAttemptId(long blockId) {
        long mapId = blockId & 0x1FFFFFL;
        long attemptId = blockId >> 45 & 0x3FL;
        return (attemptId << 45) + mapId;
    }

    public static int estimateTaskConcurrency(JobConf jobConf) {
        int estimateReduceNum;
        double dynamicFactor = jobConf.getDouble("mapreduce.rss.estimate.task.concurrency.dynamic.factor", 1.0);
        double slowStart = jobConf.getDouble("mapreduce.job.reduce.slowstart.completedmaps", 0.05);
        int mapNum = jobConf.getNumMapTasks();
        int reduceNum = jobConf.getNumReduceTasks();
        int mapLimit = jobConf.getInt("mapreduce.job.running.map.limit", 0);
        int reduceLimit = jobConf.getInt("mapreduce.job.running.reduce.limit", 0);
        int estimateMapNum = mapLimit > 0 ? Math.min(mapNum, mapLimit) : mapNum;
        int n = estimateReduceNum = reduceLimit > 0 ? Math.min(reduceNum, reduceLimit) : reduceNum;
        if (slowStart == 1.0) {
            return (int)((double)Math.max(estimateMapNum, estimateReduceNum) * dynamicFactor);
        }
        return (int)(((1.0 - slowStart) * (double)estimateMapNum + (double)estimateReduceNum) * dynamicFactor);
    }

    public static int getRequiredShuffleServerNumber(JobConf jobConf) {
        int requiredShuffleServerNumber = jobConf.getInt("rss.client.assignment.shuffle.nodes.max", -1);
        boolean enabledEstimateServer = jobConf.getBoolean("mapreduce.rss.estimate.server.assignment.enabled", false);
        if (!enabledEstimateServer || requiredShuffleServerNumber > 0) {
            return requiredShuffleServerNumber;
        }
        int taskConcurrency = RssMRUtils.estimateTaskConcurrency(jobConf);
        int taskConcurrencyPerServer = jobConf.getInt("mapreduce.rss.estimate.task.concurrency.per.server", 80);
        return (int)Math.ceil((double)taskConcurrency * 1.0 / (double)taskConcurrencyPerServer);
    }

    public static void validateRssClientConf(Configuration rssJobConf) {
        long sendCheckTimeout;
        int retryMax = RssMRUtils.getInt(rssJobConf, "mapreduce.rss.client.retry.max", 50);
        long retryIntervalMax = RssMRUtils.getLong(rssJobConf, "mapreduce.rss.client.retry.interval.max", 10000L);
        if (retryIntervalMax * (long)retryMax > (sendCheckTimeout = RssMRUtils.getLong(rssJobConf, "mapreduce.rss.client.send.check.timeout.ms", 600000L))) {
            throw new IllegalArgumentException(String.format("%s(%s) * %s(%s) should not bigger than %s(%s)", "mapreduce.rss.client.retry.max", retryMax, "mapreduce.rss.client.retry.interval.max", retryIntervalMax, "mapreduce.rss.client.send.check.timeout.ms", sendCheckTimeout));
        }
    }

    public static void buildAssignServers(int reduceId, String[] splitServers, Collection<ShuffleServerInfo> assignServers) {
        for (String splitServer : splitServers) {
            Object[] serverInfo = splitServer.split(":");
            if (serverInfo.length != 2 && serverInfo.length != 3) {
                throw new RssException("partition " + reduceId + " server info isn't right");
            }
            ShuffleServerInfo server = serverInfo.length == 2 ? new ShuffleServerInfo(StringUtils.join((Object[])serverInfo, (String)"-"), (String)serverInfo[0], Integer.parseInt((String)serverInfo[1])) : new ShuffleServerInfo(StringUtils.join((Object[])serverInfo, (String)"-"), (String)serverInfo[0], Integer.parseInt((String)serverInfo[1]), Integer.parseInt((String)serverInfo[2]));
            assignServers.add(server);
        }
    }
}

