# Generic makefile.
# $Id: mktargs.mk,v 1.5 2004/10/01 23:29:22 jlinoff Exp $

# ================================================================
# All
# ================================================================
all: _all

# ================================================================
# Backup
# ================================================================
backup: ; ${MAKE} -f Makefile $@

# ================================================================
# Build
# ================================================================
bld: _bld

# ================================================================
# Clean up for a specific architecture
# ================================================================
clean:
	@rm -rf *~ ../*/*~ ../*/*/*~ ../*/*/*/*~
	@rm -rf ${BIN_DIR}/*
	@rm -rf ../test/logs
	@rm -rf ../*.tar
	@rm -rf ../*.taz
	@rm -rf ../*.tgz
	@rm -rf ../*.gz
	@rm -rf *.pdb

# ================================================================
# Clean up everything
# ================================================================
cleanall: clean
	@rm -rf ../bin*

# ================================================================
# Help
# ================================================================
help: ; ${MAKE} -f Makefile $@

# ================================================================
# Doc
# ================================================================
doc: _doc

# ================================================================
# Dtree
# ================================================================
dtree:
	cd .. ; ${PERL} ./utils/dtree.pl -c .

# ================================================================
# Dependencies
# ================================================================
depend: ; ${MAKE} -f Makefile $@

# ================================================================
# Insert the copyrights and help text into the source code.
# ================================================================
insert: ; ${MAKE} -f Makefile $@

# ================================================================
# Insert the help text into the system. It is organized this
# way so that the help text is easy to modify and export.
# ================================================================
insert_help: ; ${MAKE} -f Makefile $@

# ================================================================
# Insert the copyright text into the system. It is organized this
# way so that the copyright text is easy to modify and export.
# ================================================================
insert_copyright: ; ${MAKE} -f Makefile $@

# ================================================================
# Release.
# ================================================================
release: ; ${MAKE} -f Makefile $@
rel: ; ${MAKE} -f Makefile $@
release_info: ; ${MAKE} -f Makefile $@
relinfo: ; ${MAKE} -f Makefile $@

# ================================================================
# Test
# ================================================================
test: _test

# verbose tests
testv: _testv

# ================================================================
# Include the dependencies.
# ================================================================
include mkdepend.mk

# ================================================================
# Targets that must occur after the dependencies.
# ================================================================
_all: _test

_bld: ${LINK_TARG}

${LINK_TARG} : ${BIN_DIR} ${OBJS}
	@echo "================================================"
	@echo "Linking $@"
	${LINK_PREFIX} \
	${LINK} ${LINK_FLAGS} ${LINK_OUT}$@ ${OBJS} ${LINK_SUFFIX_FLAGS}

${BIN_DIR} : ; @mkdir $@

_doc: _bld ../doc/webdocs
	@echo "================================================"
	@echo "Generating documentation"
	@rm -f ../doc/webdocs/ccdoc.db
	@rm -f ../doc/webdocs/*.html
	${LINK_TARG} -v -db ../doc/webdocs/ccdoc.db -pkg UTILS \
		exceptions.h \
		log.h \
		strmgr.h \
		switches.h
	${LINK_TARG} -db ../doc/webdocs/ccdoc.db -pkg PHASE1 phase1*.h
	${LINK_TARG} -db ../doc/webdocs/ccdoc.db -pkg PHASE2 phase2*.h
	${LINK_TARG} -db ../doc/webdocs/ccdoc.db -pkg PHASE3 phase3*.h
	${LINK_TARG} -db ../doc/webdocs/ccdoc.db -pkg DATABASE database.h
	${LINK_TARG} -db ../doc/webdocs/ccdoc.db -pkg STATEMENT statement.h
	${LINK_TARG} -db ../doc/webdocs/ccdoc.db v0_8.txt
	${LINK_TARG} -db ../doc/webdocs/ccdoc.db -index
	${LINK_TARG} -db ../doc/webdocs/ccdoc.db \
		-rptfwcf \
		-html ../doc/webdocs/ \
		-header v0_8_hdr.txt \
		-srcurl ../../src/ \
		-root CCDOC \
		-rooturl ../index.html

../doc/webdocs : ; @-mkdir $@

_test: _bld ../test/test.pl
	@echo "================================================"
	@echo "Testing"
	@rm -rf ../test/logs
	@${PERL} ../test/test.pl ${LINK_TARG}

_testv: _bld ../test/test.pl
	@echo "================================================"
	@echo "Testing"
	@rm -rf ../test/logs
	@${PERL} ../test/test.pl -v ${LINK_TARG}
