#!perl
# $Id: set_release_info.pl,v 1.5 2004/09/30 07:34:13 jlinoff Exp $
#
# This script automatically updates the release information
# from the release.txt file.
#
use strict;
&Main;

# ================================================
# MAIN
# ================================================
sub Main
{
    # ================================================
    # Read the release.txt file contents.
    # ================================================
    my $file = "../src/release.txt";
    if( ! -e $file ) {
	print STDERR "ERROR: Can't read release.txt.\n";
	exit 1;
    }
    my $rev = "";
    my $date = "";
    open HND,"$file" || die "ERROR: Can't read '$file'.\n";
    while( <HND> ) {
	chop;
	next if ( /^\s*\#/ );
	if( /(\S+)\s+(\S+)/ ) {
	    $rev = $1;
	    $date = $2;
	    last;
	}
    }
    close HND;
    if( $rev eq "" || $date eq "" ) {
	print STDERR "ERROR: Invalid syntax in release.txt,\n";
	print STDERR "       Expected: <rev> <date>\n";
	exit 1;
    }
    my $relname = "ccdoc${rev}";
    print "Setting release info for $relname ...\n";

    # ================================================
    # Update switches.cc
    # ================================================
    my $file = "switches.cc";
    print "Updating ${file} ...\n";
    open IFILE,"${file}" || die "ERROR: Can't read ${file}\n";
    open OFILE,">${file}x" || die "ERROR: Can't write ${file}x\n";
    while( <IFILE> ) {
	if( /^\#define CCDOC_VERSION/ ) {
	    print OFILE "#define CCDOC_VERSION \"$rev $date\"\n";
	}
	else {
	    print OFILE $_;
	}
    }
    close OFILE;
    close IFILE;
    unlink("${file}");
    rename("${file}x","${file}");

    # ================================================
    # v0_8_hdr.txt
    # ================================================
    $file = "v0_8_hdr.txt";
    print "Updating ${file} ...\n";
    open IFILE,"${file}" || die "ERROR: Can't read ${file}\n";
    open OFILE,">${file}x" || die "ERROR: Can't write ${file}x\n";
    while( <IFILE> ) {
	if( /^\s*<!-- REVISION -->/ ) {
	    print OFILE "  <!-- REVISION -->\n";
	    print OFILE "  ${rev}<br>${date}\n";
	    my $skip = <IFILE>;
	}
	else {
	    print OFILE $_;
	}
    }
    close OFILE;
    close IFILE;
    unlink("${file}");
    rename("${file}x","${file}");

    # ================================================
    # Update help.txt
    # ================================================
    $file = "help.txt";
    print "Updating ${file} ...\n";
    open IFILE,"${file}" || die "ERROR: Can't read ${file}\n";
    open OFILE,">${file}x" || die "ERROR: Can't write ${file}x\n";
    while( <IFILE> ) {
	if( /^(\s+)ccdoc v(\S+)\s+(\S+)\s+(\S+)/ ) {
	    print OFILE "${1}ccdoc ${rev} ${date} ${4}\n";
	}
	else {
	    print OFILE $_;
	}
    }
    close OFILE;
    close IFILE;
    unlink("${file}");
    rename("${file}x","${file}");
    system("gmake insert_help");

    # ================================================
    # Update ../doc/index.html
    # ================================================
    $file = "../doc/index.html";
    print "Updating ${file} ...\n";
    open IFILE,"${file}" || die "ERROR: Can't read ${file}\n";
    open OFILE,">${file}x" || die "ERROR: Can't write ${file}x\n";
    while( <IFILE> ) {
	if( /^(\s+)<font size=\"-1\">v(\S+)\s+(\S+)/ ) {
	    print OFILE "${1}<font size=\"-1\">${rev} ${date}<br>\n";
	}
	else {
	    print OFILE $_;
	}
    }
    close OFILE;
    close IFILE;
    unlink("${file}");
    rename("${file}x","${file}");


    # ================================================
    # Update ../doc/htdocs/downloads.htm
    # ================================================
    $file = "../doc/htdocs/downloads.htm";
    print "Updating ${file} ...\n";
    open IFILE,"${file}" || die "ERROR: Can't read ${file}\n";
    open OFILE,">${file}x" || die "ERROR: Can't write ${file}x\n";
    while( <IFILE> ) {
	if( /^(\s+)<font size=\"5\">CcDoc Downloads<\/font><font size=\"2\"><br>/ ) {
	    print OFILE "${1}<font size=\"5\">CcDoc Downloads<\/font><font size=\"2\"><br>\n";
	    print OFILE "${1}${rev} ${date}<br>\n";
	    my $tmp = <IFILE>;
	}
	else {
	    print OFILE $_;
	}
    }
    close OFILE;
    close IFILE;
    unlink("${file}");
    rename("${file}x","${file}");

    exit 0;
}
