/* HomeTimeline.c generated by valac 0.26.2, the Vala compiler
 * generated from HomeTimeline.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_ITIMELINE (itimeline_get_type ())
#define ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITIMELINE, ITimeline))
#define IS_ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITIMELINE))
#define ITIMELINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITIMELINE, ITimelineIface))

typedef struct _ITimeline ITimeline;
typedef struct _ITimelineIface ITimelineIface;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_BADGE_RADIO_TOOL_BUTTON (badge_radio_tool_button_get_type ())
#define BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButton))
#define BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))
#define IS_BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define IS_BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define BADGE_RADIO_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))

typedef struct _BadgeRadioToolButton BadgeRadioToolButton;
typedef struct _BadgeRadioToolButtonClass BadgeRadioToolButtonClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_HOME_TIMELINE (home_timeline_get_type ())
#define HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HOME_TIMELINE, HomeTimeline))
#define HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HOME_TIMELINE, HomeTimelineClass))
#define IS_HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HOME_TIMELINE))
#define IS_HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HOME_TIMELINE))
#define HOME_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HOME_TIMELINE, HomeTimelineClass))

typedef struct _HomeTimeline HomeTimeline;
typedef struct _HomeTimelineClass HomeTimelineClass;
typedef struct _HomeTimelinePrivate HomeTimelinePrivate;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

struct _ITimelineIface {
	GTypeInterface parent_iface;
	gint64 (*get_lowest_id) (ITimeline* self);
	void (*set_lowest_id) (ITimeline* self, gint64 value);
	gint64 (*get_max_id) (ITimeline* self);
	void (*set_max_id) (ITimeline* self, gint64 value);
	TweetListBox* (*get_tweet_list) (ITimeline* self);
	void (*set_tweet_list) (ITimeline* self, TweetListBox* value);
	gint (*get_unread_count) (ITimeline* self);
	void (*set_unread_count) (ITimeline* self, gint value);
	DeltaUpdater* (*get_delta_updater) (ITimeline* self);
	void (*set_delta_updater) (ITimeline* self, DeltaUpdater* value);
	const gchar* (*get_function) (ITimeline* self);
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	BadgeRadioToolButton* tool_button;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, Bundle* args);
	void (*on_leave) (DefaultTimeline* self);
	void (*load_cached) (DefaultTimeline* self);
	void (*load_newest) (DefaultTimeline* self);
	void (*load_older) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_tool_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _HomeTimeline {
	DefaultTimeline parent_instance;
	HomeTimelinePrivate * priv;
};

struct _HomeTimelineClass {
	DefaultTimelineClass parent_class;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	gint64 id;
	gint64 rt_id;
	gchar* text;
	gint64 user_id;
	gchar* user_name;
	gchar* retweeted_by;
	gchar* rt_by_screen_name;
	gint64 rt_by_id;
	gboolean is_retweet;
	GdkPixbuf* inline_media;
	gchar* time_delta;
	gchar* avatar_url;
	gchar* avatar_name;
	gchar* screen_name;
	gint64 created_at;
	gint64 rt_created_at;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gint64 reply_id;
	Media** medias;
	gint medias_length1;
	gint retweet_count;
	gint favorite_count;
	gchar** mentions;
	gint mentions_length1;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
	gboolean (*get_seen) (ITwitterItem* self);
	void (*set_seen) (ITwitterItem* self, gboolean value);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	gchar* notification_id;
	Tweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};


static gpointer home_timeline_parent_class = NULL;
static IMessageReceiverIface* home_timeline_imessage_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType itimeline_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType badge_radio_tool_button_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType home_timeline_get_type (void) G_GNUC_CONST;
enum  {
	HOME_TIMELINE_DUMMY_PROPERTY,
	HOME_TIMELINE_FUNCTION
};
HomeTimeline* home_timeline_new (gint id);
HomeTimeline* home_timeline_construct (GType object_type, gint id);
DefaultTimeline* default_timeline_construct (GType object_type, gint id);
static void home_timeline_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root);
static void home_timeline_add_tweet (HomeTimeline* self, JsonNode* obj);
void default_timeline_delete_tweet (DefaultTimeline* self, gint64 tweet_id);
Account* ipage_get_account (IPage* self);
gint64 account_get_id (Account* self);
void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode);
void home_timeline_hide_tweets_from (HomeTimeline* self, gint64 user_id);
void home_timeline_show_tweets_from (HomeTimeline* self, gint64 user_id);
GType tweet_get_type (void) G_GNUC_CONST;
Tweet* tweet_new (void);
Tweet* tweet_construct (GType object_type);
void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account);
GType media_get_type (void) G_GNUC_CONST;
gint64 itimeline_get_max_id (ITimeline* self);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
MainWindow* ipage_get_main_window (IPage* self);
TweetListEntry* tweet_list_entry_new (Tweet* tweet, MainWindow* window, Account* account);
TweetListEntry* tweet_list_entry_construct (GType object_type, Tweet* tweet, MainWindow* window, Account* account);
gboolean default_timeline_should_display_retweet (DefaultTimeline* self, Tweet* t);
gboolean account_blocked_or_muted (Account* self, gint64 user_id);
gboolean account_filter_matches (Account* self, Tweet* t);
gboolean settings_auto_scroll_on_new_tweets (void);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define TOP 1
gboolean scroll_widget_get_scrolled_up (ScrollWidget* self);
gint main_window_get_cur_page_id (MainWindow* self);
gint ipage_get_id (IPage* self);
GType itwitter_item_get_type (void) G_GNUC_CONST;
void itwitter_item_set_seen (ITwitterItem* self, gboolean value);
DeltaUpdater* itimeline_get_delta_updater (ITimeline* self);
void delta_updater_add (DeltaUpdater* self, ITwitterItem* entry);
TweetListBox* itimeline_get_tweet_list (ITimeline* self);
GtkWidget* tweet_list_box_get_first_visible_row (TweetListBox* self);
void default_timeline_scroll_up (DefaultTimeline* self, Tweet* t);
void default_timeline_postprocess_tweet (DefaultTimeline* self, TweetListEntry* tle);
gint settings_get_tweet_stack_count (void);
void notification_manager_notify (Account* acc, const gchar* summary, const gchar* body, const gchar* icon);
gchar* tweet_get_real_text (Tweet* self);
gchar* dirs_cache (const gchar* path);
gint itimeline_get_unread_count (ITimeline* self);
void home_timeline_hide_retweets_from (HomeTimeline* self, gint64 user_id);
void home_timeline_show_retweets_from (HomeTimeline* self, gint64 user_id);
static gchar* home_timeline_real_get_title (DefaultTimeline* base);
const gchar* account_get_screen_name (Account* self);
static void home_timeline_real_load_newest (DefaultTimeline* base);
void itimeline_load_newest_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void itimeline_load_newest_internal_finish (ITimeline* self, GAsyncResult* _res_);
static void __lambda99_ (HomeTimeline* self);
static void ___lambda99__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void home_timeline_real_load_older (DefaultTimeline* base);
#define BOTTOM 2
void itimeline_load_older_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void itimeline_load_older_internal_finish (ITimeline* self, GAsyncResult* _res_);
static void __lambda100_ (HomeTimeline* self);
static void ___lambda100__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void home_timeline_real_create_tool_button (DefaultTimeline* base, GtkRadioButton* group);
BadgeRadioToolButton* badge_radio_tool_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioToolButton* badge_radio_tool_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
const gchar* default_timeline_get_function (DefaultTimeline* self);
static void _vala_home_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


HomeTimeline* home_timeline_construct (GType object_type, gint id) {
	HomeTimeline * self = NULL;
	gint _tmp0_ = 0;
	_tmp0_ = id;
	self = (HomeTimeline*) default_timeline_construct (object_type, _tmp0_);
	return self;
}


HomeTimeline* home_timeline_new (gint id) {
	return home_timeline_construct (TYPE_HOME_TIMELINE, id);
}


static void home_timeline_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root) {
	HomeTimeline * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_TWEET) {
		JsonNode* _tmp1_ = NULL;
		_tmp1_ = root;
		home_timeline_add_tweet (self, _tmp1_);
	} else {
		StreamMessageType _tmp2_ = 0;
		_tmp2_ = type;
		if (_tmp2_ == STREAM_MESSAGE_TYPE_DELETE) {
			gint64 id = 0LL;
			JsonNode* _tmp3_ = NULL;
			JsonObject* _tmp4_ = NULL;
			JsonObject* _tmp5_ = NULL;
			JsonObject* _tmp6_ = NULL;
			gint64 _tmp7_ = 0LL;
			gint64 _tmp8_ = 0LL;
			_tmp3_ = root;
			_tmp4_ = json_node_get_object (_tmp3_);
			_tmp5_ = json_object_get_object_member (_tmp4_, "delete");
			_tmp6_ = json_object_get_object_member (_tmp5_, "status");
			_tmp7_ = json_object_get_int_member (_tmp6_, "id");
			id = _tmp7_;
			_tmp8_ = id;
			default_timeline_delete_tweet (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp8_);
		} else {
			StreamMessageType _tmp9_ = 0;
			_tmp9_ = type;
			if (_tmp9_ == STREAM_MESSAGE_TYPE_EVENT_FAVORITE) {
				gint64 id = 0LL;
				JsonNode* _tmp10_ = NULL;
				JsonObject* _tmp11_ = NULL;
				JsonObject* _tmp12_ = NULL;
				gint64 _tmp13_ = 0LL;
				gint64 source_id = 0LL;
				JsonNode* _tmp14_ = NULL;
				JsonObject* _tmp15_ = NULL;
				JsonObject* _tmp16_ = NULL;
				gint64 _tmp17_ = 0LL;
				gint64 _tmp18_ = 0LL;
				Account* _tmp19_ = NULL;
				Account* _tmp20_ = NULL;
				gint64 _tmp21_ = 0LL;
				gint64 _tmp22_ = 0LL;
				_tmp10_ = root;
				_tmp11_ = json_node_get_object (_tmp10_);
				_tmp12_ = json_object_get_object_member (_tmp11_, "target_object");
				_tmp13_ = json_object_get_int_member (_tmp12_, "id");
				id = _tmp13_;
				_tmp14_ = root;
				_tmp15_ = json_node_get_object (_tmp14_);
				_tmp16_ = json_object_get_object_member (_tmp15_, "source");
				_tmp17_ = json_object_get_int_member (_tmp16_, "id");
				source_id = _tmp17_;
				_tmp18_ = source_id;
				_tmp19_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
				_tmp20_ = _tmp19_;
				_tmp21_ = account_get_id (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp18_ == _tmp22_) {
					gint64 _tmp23_ = 0LL;
					_tmp23_ = id;
					default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp23_, TRUE);
				}
			} else {
				StreamMessageType _tmp24_ = 0;
				_tmp24_ = type;
				if (_tmp24_ == STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE) {
					gint64 id = 0LL;
					JsonNode* _tmp25_ = NULL;
					JsonObject* _tmp26_ = NULL;
					JsonObject* _tmp27_ = NULL;
					gint64 _tmp28_ = 0LL;
					gint64 source_id = 0LL;
					JsonNode* _tmp29_ = NULL;
					JsonObject* _tmp30_ = NULL;
					JsonObject* _tmp31_ = NULL;
					gint64 _tmp32_ = 0LL;
					gint64 _tmp33_ = 0LL;
					Account* _tmp34_ = NULL;
					Account* _tmp35_ = NULL;
					gint64 _tmp36_ = 0LL;
					gint64 _tmp37_ = 0LL;
					_tmp25_ = root;
					_tmp26_ = json_node_get_object (_tmp25_);
					_tmp27_ = json_object_get_object_member (_tmp26_, "target_object");
					_tmp28_ = json_object_get_int_member (_tmp27_, "id");
					id = _tmp28_;
					_tmp29_ = root;
					_tmp30_ = json_node_get_object (_tmp29_);
					_tmp31_ = json_object_get_object_member (_tmp30_, "source");
					_tmp32_ = json_object_get_int_member (_tmp31_, "id");
					source_id = _tmp32_;
					_tmp33_ = source_id;
					_tmp34_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
					_tmp35_ = _tmp34_;
					_tmp36_ = account_get_id (_tmp35_);
					_tmp37_ = _tmp36_;
					if (_tmp33_ == _tmp37_) {
						gint64 _tmp38_ = 0LL;
						_tmp38_ = id;
						default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp38_, FALSE);
					}
				} else {
					StreamMessageType _tmp39_ = 0;
					_tmp39_ = type;
					if (_tmp39_ == STREAM_MESSAGE_TYPE_EVENT_BLOCK) {
						gint64 user_id = 0LL;
						JsonNode* _tmp40_ = NULL;
						JsonObject* _tmp41_ = NULL;
						JsonObject* _tmp42_ = NULL;
						gint64 _tmp43_ = 0LL;
						gint64 _tmp44_ = 0LL;
						_tmp40_ = root;
						_tmp41_ = json_node_get_object (_tmp40_);
						_tmp42_ = json_object_get_object_member (_tmp41_, "target");
						_tmp43_ = json_object_get_int_member (_tmp42_, "id");
						user_id = _tmp43_;
						_tmp44_ = user_id;
						home_timeline_hide_tweets_from (self, _tmp44_);
					} else {
						StreamMessageType _tmp45_ = 0;
						_tmp45_ = type;
						if (_tmp45_ == STREAM_MESSAGE_TYPE_EVENT_UNBLOCK) {
							gint64 user_id = 0LL;
							JsonNode* _tmp46_ = NULL;
							JsonObject* _tmp47_ = NULL;
							JsonObject* _tmp48_ = NULL;
							gint64 _tmp49_ = 0LL;
							gint64 _tmp50_ = 0LL;
							_tmp46_ = root;
							_tmp47_ = json_node_get_object (_tmp46_);
							_tmp48_ = json_object_get_object_member (_tmp47_, "target");
							_tmp49_ = json_object_get_int_member (_tmp48_, "id");
							user_id = _tmp49_;
							_tmp50_ = user_id;
							home_timeline_show_tweets_from (self, _tmp50_);
						}
					}
				}
			}
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void home_timeline_add_tweet (HomeTimeline* self, JsonNode* obj) {
	GDateTime* now = NULL;
	GDateTime* _tmp0_ = NULL;
	Tweet* t = NULL;
	Tweet* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	JsonNode* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	Account* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	Tweet* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	TweetListEntry* entry = NULL;
	Tweet* _tmp15_ = NULL;
	Tweet* _tmp16_ = NULL;
	MainWindow* _tmp17_ = NULL;
	MainWindow* _tmp18_ = NULL;
	Account* _tmp19_ = NULL;
	Account* _tmp20_ = NULL;
	TweetListEntry* _tmp21_ = NULL;
	TweetListEntry* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	Tweet* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp29_ = FALSE;
	Account* _tmp30_ = NULL;
	Account* _tmp31_ = NULL;
	Tweet* _tmp32_ = NULL;
	gint64 _tmp33_ = 0LL;
	gboolean _tmp34_ = FALSE;
	Account* _tmp44_ = NULL;
	Account* _tmp45_ = NULL;
	Tweet* _tmp46_ = NULL;
	gboolean _tmp47_ = FALSE;
	gboolean auto_scroll = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	Tweet* _tmp52_ = NULL;
	gint64 _tmp53_ = 0LL;
	Account* _tmp54_ = NULL;
	Account* _tmp55_ = NULL;
	gint64 _tmp56_ = 0LL;
	gint64 _tmp57_ = 0LL;
	TweetListEntry* _tmp75_ = NULL;
	DeltaUpdater* _tmp76_ = NULL;
	DeltaUpdater* _tmp77_ = NULL;
	TweetListEntry* _tmp78_ = NULL;
	gboolean _tmp79_ = FALSE;
	TweetListBox* _tmp80_ = NULL;
	TweetListBox* _tmp81_ = NULL;
	GtkWidget* _tmp82_ = NULL;
	GtkWidget* _tmp83_ = NULL;
	gboolean _tmp84_ = FALSE;
	gboolean _tmp85_ = FALSE;
	gboolean _tmp86_ = FALSE;
	gboolean should_focus = FALSE;
	TweetListBox* _tmp89_ = NULL;
	TweetListBox* _tmp90_ = NULL;
	TweetListEntry* _tmp91_ = NULL;
	gboolean _tmp92_ = FALSE;
	TweetListEntry* _tmp94_ = NULL;
	gboolean _tmp95_ = FALSE;
	gboolean _tmp96_ = FALSE;
	TweetListEntry* _tmp98_ = NULL;
	gint stack_size = 0;
	gint _tmp99_ = 0;
	gboolean _tmp100_ = FALSE;
	Tweet* _tmp101_ = NULL;
	gint64 _tmp102_ = 0LL;
	Account* _tmp103_ = NULL;
	Account* _tmp104_ = NULL;
	gint64 _tmp105_ = 0LL;
	gint64 _tmp106_ = 0LL;
	gboolean _tmp108_ = FALSE;
	gint _tmp109_ = 0;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	g_return_if_fail (obj != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = tweet_new ();
	t = _tmp1_;
	_tmp2_ = t;
	_tmp3_ = obj;
	_tmp4_ = now;
	_tmp5_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp6_ = _tmp5_;
	tweet_load_from_json (_tmp2_, _tmp3_, _tmp4_, _tmp6_);
	_tmp7_ = t;
	_tmp8_ = _tmp7_->id;
	_tmp9_ = itimeline_get_max_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp10_ = _tmp9_;
	if (_tmp8_ <= _tmp10_) {
		Tweet* _tmp11_ = NULL;
		gint64 _tmp12_ = 0LL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp11_ = t;
		_tmp12_ = _tmp11_->id;
		_tmp13_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp12_);
		_tmp14_ = _tmp13_;
		g_warning ("HomeTimeline.vala:61: Tweet with ID %s already seen.", _tmp14_);
		_g_free0 (_tmp14_);
		_g_object_unref0 (t);
		_g_date_time_unref0 (now);
		return;
	}
	_tmp15_ = t;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_tmp17_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp18_ = _tmp17_;
	_tmp19_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp20_ = _tmp19_;
	_tmp21_ = tweet_list_entry_new (_tmp16_, _tmp18_, _tmp20_);
	g_object_ref_sink (_tmp21_);
	entry = _tmp21_;
	_tmp22_ = entry;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp24_ = t;
	_tmp25_ = _tmp24_->is_retweet;
	if (_tmp25_) {
		Tweet* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		_tmp26_ = t;
		_tmp27_ = default_timeline_should_display_retweet (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp26_);
		_tmp23_ = !_tmp27_;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		TweetListEntry* _tmp28_ = NULL;
		_tmp28_ = entry;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_tmp30_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp31_ = _tmp30_;
	_tmp32_ = t;
	_tmp33_ = _tmp32_->user_id;
	_tmp34_ = account_blocked_or_muted (_tmp31_, _tmp33_);
	if (_tmp34_) {
		_tmp29_ = TRUE;
	} else {
		gboolean _tmp35_ = FALSE;
		Tweet* _tmp36_ = NULL;
		gboolean _tmp37_ = FALSE;
		_tmp36_ = t;
		_tmp37_ = _tmp36_->is_retweet;
		if (_tmp37_) {
			Account* _tmp38_ = NULL;
			Account* _tmp39_ = NULL;
			Tweet* _tmp40_ = NULL;
			gint64 _tmp41_ = 0LL;
			gboolean _tmp42_ = FALSE;
			_tmp38_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp39_ = _tmp38_;
			_tmp40_ = t;
			_tmp41_ = _tmp40_->rt_by_id;
			_tmp42_ = account_blocked_or_muted (_tmp39_, _tmp41_);
			_tmp35_ = _tmp42_;
		} else {
			_tmp35_ = FALSE;
		}
		_tmp29_ = _tmp35_;
	}
	if (_tmp29_) {
		TweetListEntry* _tmp43_ = NULL;
		_tmp43_ = entry;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_tmp44_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp45_ = _tmp44_;
	_tmp46_ = t;
	_tmp47_ = account_filter_matches (_tmp45_, _tmp46_);
	if (_tmp47_) {
		TweetListEntry* _tmp48_ = NULL;
		_tmp48_ = entry;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_tmp49_ = settings_auto_scroll_on_new_tweets ();
	auto_scroll = _tmp49_;
	scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), TOP);
	_tmp52_ = t;
	_tmp53_ = _tmp52_->user_id;
	_tmp54_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp55_ = _tmp54_;
	_tmp56_ = account_get_id (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp53_ == _tmp57_) {
		_tmp51_ = TRUE;
	} else {
		Tweet* _tmp58_ = NULL;
		gint64 _tmp59_ = 0LL;
		Account* _tmp60_ = NULL;
		Account* _tmp61_ = NULL;
		gint64 _tmp62_ = 0LL;
		gint64 _tmp63_ = 0LL;
		_tmp58_ = t;
		_tmp59_ = _tmp58_->rt_by_id;
		_tmp60_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp61_ = _tmp60_;
		_tmp62_ = account_get_id (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp51_ = _tmp59_ == _tmp63_;
	}
	if (_tmp51_) {
		_tmp50_ = TRUE;
	} else {
		gboolean _tmp64_ = FALSE;
		gboolean _tmp65_ = FALSE;
		gboolean _tmp66_ = FALSE;
		gboolean _tmp67_ = FALSE;
		_tmp66_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
		_tmp67_ = _tmp66_;
		if (_tmp67_) {
			MainWindow* _tmp68_ = NULL;
			MainWindow* _tmp69_ = NULL;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			_tmp68_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp69_ = _tmp68_;
			_tmp70_ = main_window_get_cur_page_id (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp73_ = _tmp72_;
			_tmp65_ = _tmp71_ == _tmp73_;
		} else {
			_tmp65_ = FALSE;
		}
		if (_tmp65_) {
			gboolean _tmp74_ = FALSE;
			_tmp74_ = auto_scroll;
			_tmp64_ = _tmp74_;
		} else {
			_tmp64_ = FALSE;
		}
		_tmp50_ = _tmp64_;
	}
	_tmp75_ = entry;
	itwitter_item_set_seen (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, TYPE_ITWITTER_ITEM, ITwitterItem), _tmp50_);
	_tmp76_ = itimeline_get_delta_updater (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp77_ = _tmp76_;
	_tmp78_ = entry;
	delta_updater_add (_tmp77_, G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, TYPE_ITWITTER_ITEM, ITwitterItem));
	_tmp80_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp81_ = _tmp80_;
	_tmp82_ = tweet_list_box_get_first_visible_row (_tmp81_);
	_tmp83_ = _tmp82_;
	g_object_get (_tmp83_, "is-focus", &_tmp84_, NULL);
	_tmp85_ = _tmp84_;
	_tmp86_ = _tmp85_;
	_g_object_unref0 (_tmp83_);
	if (_tmp86_) {
		gboolean _tmp87_ = FALSE;
		gboolean _tmp88_ = FALSE;
		_tmp87_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
		_tmp88_ = _tmp87_;
		_tmp79_ = _tmp88_;
	} else {
		_tmp79_ = FALSE;
	}
	should_focus = _tmp79_;
	_tmp89_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp90_ = _tmp89_;
	_tmp91_ = entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, gtk_widget_get_type (), GtkWidget));
	_tmp92_ = should_focus;
	if (_tmp92_) {
		TweetListEntry* _tmp93_ = NULL;
		_tmp93_ = entry;
		gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp94_ = entry;
	_tmp95_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, gtk_widget_get_type (), GtkWidget));
	_tmp96_ = _tmp95_;
	if (_tmp96_) {
		Tweet* _tmp97_ = NULL;
		_tmp97_ = t;
		default_timeline_scroll_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp97_);
	}
	_tmp98_ = entry;
	default_timeline_postprocess_tweet (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp98_);
	_tmp99_ = settings_get_tweet_stack_count ();
	stack_size = _tmp99_;
	_tmp101_ = t;
	_tmp102_ = _tmp101_->user_id;
	_tmp103_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp104_ = _tmp103_;
	_tmp105_ = account_get_id (_tmp104_);
	_tmp106_ = _tmp105_;
	if (_tmp102_ == _tmp106_) {
		_tmp100_ = TRUE;
	} else {
		gboolean _tmp107_ = FALSE;
		_tmp107_ = auto_scroll;
		_tmp100_ = _tmp107_;
	}
	if (_tmp100_) {
		_g_object_unref0 (entry);
		_g_object_unref0 (t);
		_g_date_time_unref0 (now);
		return;
	}
	_tmp109_ = stack_size;
	if (_tmp109_ == 1) {
		gboolean _tmp110_ = FALSE;
		_tmp110_ = auto_scroll;
		_tmp108_ = !_tmp110_;
	} else {
		_tmp108_ = FALSE;
	}
	if (_tmp108_) {
		gchar* summary = NULL;
		gchar* _tmp111_ = NULL;
		Tweet* _tmp112_ = NULL;
		gboolean _tmp113_ = FALSE;
		Account* _tmp124_ = NULL;
		Account* _tmp125_ = NULL;
		const gchar* _tmp126_ = NULL;
		Tweet* _tmp127_ = NULL;
		gchar* _tmp128_ = NULL;
		gchar* _tmp129_ = NULL;
		Tweet* _tmp130_ = NULL;
		const gchar* _tmp131_ = NULL;
		gchar* _tmp132_ = NULL;
		gchar* _tmp133_ = NULL;
		gchar* _tmp134_ = NULL;
		gchar* _tmp135_ = NULL;
		_tmp111_ = g_strdup ("");
		summary = _tmp111_;
		_tmp112_ = t;
		_tmp113_ = _tmp112_->is_retweet;
		if (_tmp113_) {
			const gchar* _tmp114_ = NULL;
			Tweet* _tmp115_ = NULL;
			const gchar* _tmp116_ = NULL;
			Tweet* _tmp117_ = NULL;
			const gchar* _tmp118_ = NULL;
			gchar* _tmp119_ = NULL;
			_tmp114_ = _ ("%s retweeted %s");
			_tmp115_ = t;
			_tmp116_ = _tmp115_->retweeted_by;
			_tmp117_ = t;
			_tmp118_ = _tmp117_->user_name;
			_tmp119_ = g_strdup_printf (_tmp114_, _tmp116_, _tmp118_);
			_g_free0 (summary);
			summary = _tmp119_;
		} else {
			const gchar* _tmp120_ = NULL;
			Tweet* _tmp121_ = NULL;
			const gchar* _tmp122_ = NULL;
			gchar* _tmp123_ = NULL;
			_tmp120_ = _ ("%s tweeted");
			_tmp121_ = t;
			_tmp122_ = _tmp121_->user_name;
			_tmp123_ = g_strdup_printf (_tmp120_, _tmp122_);
			_g_free0 (summary);
			summary = _tmp123_;
		}
		_tmp124_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp125_ = _tmp124_;
		_tmp126_ = summary;
		_tmp127_ = t;
		_tmp128_ = tweet_get_real_text (_tmp127_);
		_tmp129_ = _tmp128_;
		_tmp130_ = t;
		_tmp131_ = _tmp130_->avatar_name;
		_tmp132_ = g_strconcat ("assets/avatars/", _tmp131_, NULL);
		_tmp133_ = _tmp132_;
		_tmp134_ = dirs_cache (_tmp133_);
		_tmp135_ = _tmp134_;
		notification_manager_notify (_tmp125_, _tmp126_, _tmp129_, _tmp135_);
		_g_free0 (_tmp135_);
		_g_free0 (_tmp133_);
		_g_free0 (_tmp129_);
		_g_free0 (summary);
	} else {
		gboolean _tmp136_ = FALSE;
		gboolean _tmp137_ = FALSE;
		gint _tmp138_ = 0;
		_tmp138_ = stack_size;
		if (_tmp138_ != 0) {
			gint _tmp139_ = 0;
			gint _tmp140_ = 0;
			gint _tmp141_ = 0;
			_tmp139_ = itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
			_tmp140_ = _tmp139_;
			_tmp141_ = stack_size;
			_tmp137_ = (_tmp140_ % _tmp141_) == 0;
		} else {
			_tmp137_ = FALSE;
		}
		if (_tmp137_) {
			gint _tmp142_ = 0;
			gint _tmp143_ = 0;
			_tmp142_ = itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
			_tmp143_ = _tmp142_;
			_tmp136_ = _tmp143_ > 0;
		} else {
			_tmp136_ = FALSE;
		}
		if (_tmp136_) {
			gchar* summary = NULL;
			gint _tmp144_ = 0;
			gint _tmp145_ = 0;
			const gchar* _tmp146_ = NULL;
			gint _tmp147_ = 0;
			gint _tmp148_ = 0;
			gchar* _tmp149_ = NULL;
			Account* _tmp150_ = NULL;
			Account* _tmp151_ = NULL;
			const gchar* _tmp152_ = NULL;
			_tmp144_ = itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
			_tmp145_ = _tmp144_;
			_tmp146_ = ngettext ("%d new Tweet!", "%d new Tweets!", (gulong) _tmp145_);
			_tmp147_ = itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
			_tmp148_ = _tmp147_;
			_tmp149_ = g_strdup_printf (_tmp146_, _tmp148_);
			summary = _tmp149_;
			_tmp150_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp151_ = _tmp150_;
			_tmp152_ = summary;
			notification_manager_notify (_tmp151_, _tmp152_, "", NULL);
			_g_free0 (summary);
		}
	}
	_g_object_unref0 (entry);
	_g_object_unref0 (t);
	_g_date_time_unref0 (now);
}


void home_timeline_hide_tweets_from (HomeTimeline* self, gint64 user_id) {
	GList* children = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer));
	children = _tmp2_;
	_tmp3_ = children;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp3_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp4_ = NULL;
			GtkWidget* w = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp4_;
			{
				GtkWidget* _tmp5_ = NULL;
				TweetListEntry* tle = NULL;
				GtkWidget* _tmp6_ = NULL;
				TweetListEntry* _tmp7_ = NULL;
				TweetListEntry* _tmp8_ = NULL;
				Tweet* _tmp9_ = NULL;
				gint64 _tmp10_ = 0LL;
				gint64 _tmp11_ = 0LL;
				_tmp5_ = w;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_TWEET_LIST_ENTRY)) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp6_ = w;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
				tle = _tmp7_;
				_tmp8_ = tle;
				_tmp9_ = _tmp8_->tweet;
				_tmp10_ = _tmp9_->user_id;
				_tmp11_ = user_id;
				if (_tmp10_ == _tmp11_) {
					TweetListEntry* _tmp12_ = NULL;
					_tmp12_ = tle;
					gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
				} else {
					gboolean _tmp13_ = FALSE;
					TweetListEntry* _tmp14_ = NULL;
					Tweet* _tmp15_ = NULL;
					gint64 _tmp16_ = 0LL;
					gint64 _tmp17_ = 0LL;
					_tmp14_ = tle;
					_tmp15_ = _tmp14_->tweet;
					_tmp16_ = _tmp15_->user_id;
					_tmp17_ = user_id;
					if (_tmp16_ == _tmp17_) {
						TweetListEntry* _tmp18_ = NULL;
						Tweet* _tmp19_ = NULL;
						gboolean _tmp20_ = FALSE;
						_tmp18_ = tle;
						_tmp19_ = _tmp18_->tweet;
						_tmp20_ = _tmp19_->is_retweet;
						_tmp13_ = _tmp20_;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						TweetListEntry* _tmp21_ = NULL;
						_tmp21_ = tle;
						gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
					}
				}
				_g_object_unref0 (tle);
				_g_object_unref0 (w);
			}
		}
	}
	_g_list_free0 (children);
}


void home_timeline_show_tweets_from (HomeTimeline* self, gint64 user_id) {
	GList* children = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer));
	children = _tmp2_;
	_tmp3_ = children;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp3_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp4_ = NULL;
			GtkWidget* w = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp4_;
			{
				GtkWidget* _tmp5_ = NULL;
				TweetListEntry* tle = NULL;
				GtkWidget* _tmp6_ = NULL;
				TweetListEntry* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				TweetListEntry* _tmp9_ = NULL;
				Tweet* _tmp10_ = NULL;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				_tmp5_ = w;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_TWEET_LIST_ENTRY)) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp6_ = w;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
				tle = _tmp7_;
				_tmp9_ = tle;
				_tmp10_ = _tmp9_->tweet;
				_tmp11_ = _tmp10_->user_id;
				_tmp12_ = user_id;
				if (_tmp11_ == _tmp12_) {
					TweetListEntry* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					gboolean _tmp15_ = FALSE;
					_tmp13_ = tle;
					_tmp14_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
					_tmp15_ = _tmp14_;
					_tmp8_ = !_tmp15_;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					TweetListEntry* _tmp16_ = NULL;
					_tmp16_ = tle;
					gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
				}
				_g_object_unref0 (tle);
				_g_object_unref0 (w);
			}
		}
	}
	_g_list_free0 (children);
}


void home_timeline_hide_retweets_from (HomeTimeline* self, gint64 user_id) {
	GList* children = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer));
	children = _tmp2_;
	_tmp3_ = children;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp3_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp4_ = NULL;
			GtkWidget* w = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp4_;
			{
				GtkWidget* _tmp5_ = NULL;
				TweetListEntry* tle = NULL;
				GtkWidget* _tmp6_ = NULL;
				TweetListEntry* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				TweetListEntry* _tmp9_ = NULL;
				Tweet* _tmp10_ = NULL;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				_tmp5_ = w;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_TWEET_LIST_ENTRY)) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp6_ = w;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
				tle = _tmp7_;
				_tmp9_ = tle;
				_tmp10_ = _tmp9_->tweet;
				_tmp11_ = _tmp10_->rt_by_id;
				_tmp12_ = user_id;
				if (_tmp11_ == _tmp12_) {
					TweetListEntry* _tmp13_ = NULL;
					Tweet* _tmp14_ = NULL;
					gboolean _tmp15_ = FALSE;
					_tmp13_ = tle;
					_tmp14_ = _tmp13_->tweet;
					_tmp15_ = _tmp14_->is_retweet;
					_tmp8_ = _tmp15_;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					TweetListEntry* _tmp16_ = NULL;
					_tmp16_ = tle;
					gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
				}
				_g_object_unref0 (tle);
				_g_object_unref0 (w);
			}
		}
	}
	_g_list_free0 (children);
}


void home_timeline_show_retweets_from (HomeTimeline* self, gint64 user_id) {
	GList* children = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer));
	children = _tmp2_;
	_tmp3_ = children;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp3_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp4_ = NULL;
			GtkWidget* w = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp4_;
			{
				GtkWidget* _tmp5_ = NULL;
				TweetListEntry* tle = NULL;
				GtkWidget* _tmp6_ = NULL;
				TweetListEntry* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				TweetListEntry* _tmp10_ = NULL;
				Tweet* _tmp11_ = NULL;
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				_tmp5_ = w;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_TWEET_LIST_ENTRY)) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp6_ = w;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
				tle = _tmp7_;
				_tmp10_ = tle;
				_tmp11_ = _tmp10_->tweet;
				_tmp12_ = _tmp11_->rt_by_id;
				_tmp13_ = user_id;
				if (_tmp12_ == _tmp13_) {
					TweetListEntry* _tmp14_ = NULL;
					Tweet* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					_tmp14_ = tle;
					_tmp15_ = _tmp14_->tweet;
					_tmp16_ = _tmp15_->is_retweet;
					_tmp9_ = _tmp16_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					TweetListEntry* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					_tmp17_ = tle;
					_tmp18_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
					_tmp19_ = _tmp18_;
					_tmp8_ = !_tmp19_;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					TweetListEntry* _tmp20_ = NULL;
					_tmp20_ = tle;
					gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
				}
				_g_object_unref0 (tle);
				_g_object_unref0 (w);
			}
		}
	}
	_g_list_free0 (children);
}


static gchar* home_timeline_real_get_title (DefaultTimeline* base) {
	HomeTimeline * self;
	gchar* result = NULL;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = account_get_screen_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("@", _tmp3_, NULL);
	result = _tmp4_;
	return result;
}


static void __lambda99_ (HomeTimeline* self) {
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->loading = FALSE;
}


static void ___lambda99__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda99_ ((HomeTimeline*) self);
	g_object_unref (self);
}


static void home_timeline_real_load_newest (DefaultTimeline* base) {
	HomeTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->loading = TRUE;
	itimeline_load_newest_internal (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), ___lambda99__gasync_ready_callback, g_object_ref (self));
}


static void __lambda100_ (HomeTimeline* self) {
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->loading = FALSE;
}


static void ___lambda100__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda100_ ((HomeTimeline*) self);
	g_object_unref (self);
}


static void home_timeline_real_load_older (DefaultTimeline* base) {
	HomeTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), BOTTOM);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->loading = TRUE;
	itimeline_load_older_internal (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), ___lambda100__gasync_ready_callback, g_object_ref (self));
}


static void home_timeline_real_create_tool_button (DefaultTimeline* base, GtkRadioButton* group) {
	HomeTimeline * self;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	BadgeRadioToolButton* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = _ ("Home");
	_tmp2_ = badge_radio_tool_button_new (_tmp0_, "user-home-symbolic", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tool_button);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tool_button = _tmp2_;
}


static const gchar* home_timeline_real_get_function (DefaultTimeline* base) {
	const gchar* result;
	HomeTimeline* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	result = "1.1/statuses/home_timeline.json";
	return result;
}


static void home_timeline_class_init (HomeTimelineClass * klass) {
	home_timeline_parent_class = g_type_class_peek_parent (klass);
	((DefaultTimelineClass *) klass)->get_title = home_timeline_real_get_title;
	((DefaultTimelineClass *) klass)->load_newest = home_timeline_real_load_newest;
	((DefaultTimelineClass *) klass)->load_older = home_timeline_real_load_older;
	((DefaultTimelineClass *) klass)->create_tool_button = home_timeline_real_create_tool_button;
	DEFAULT_TIMELINE_CLASS (klass)->get_function = home_timeline_real_get_function;
	G_OBJECT_CLASS (klass)->get_property = _vala_home_timeline_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), HOME_TIMELINE_FUNCTION, g_param_spec_string ("function", "function", "function", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void home_timeline_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	home_timeline_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) home_timeline_real_stream_message_received;
}


static void home_timeline_instance_init (HomeTimeline * self) {
}


GType home_timeline_get_type (void) {
	static volatile gsize home_timeline_type_id__volatile = 0;
	if (g_once_init_enter (&home_timeline_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HomeTimelineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) home_timeline_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HomeTimeline), 0, (GInstanceInitFunc) home_timeline_instance_init, NULL };
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) home_timeline_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType home_timeline_type_id;
		home_timeline_type_id = g_type_register_static (TYPE_DEFAULT_TIMELINE, "HomeTimeline", &g_define_type_info, 0);
		g_type_add_interface_static (home_timeline_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&home_timeline_type_id__volatile, home_timeline_type_id);
	}
	return home_timeline_type_id__volatile;
}


static void _vala_home_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	HomeTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HOME_TIMELINE, HomeTimeline);
	switch (property_id) {
		case HOME_TIMELINE_FUNCTION:
		g_value_set_string (value, default_timeline_get_function (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



