/* ITimeline.c generated by valac 0.26.2, the Vala compiler
 * generated from ITimeline.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo.h>


#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_ITIMELINE (itimeline_get_type ())
#define ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITIMELINE, ITimeline))
#define IS_ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITIMELINE))
#define ITIMELINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITIMELINE, ITimelineIface))

typedef struct _ITimeline ITimeline;
typedef struct _ITimelineIface ITimelineIface;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

#define TWEET_UTILS_TYPE_WORKER_RESULT (tweet_utils_worker_result_get_type ())
typedef struct _TweetUtilsWorkerResult TweetUtilsWorkerResult;
typedef struct _ItimelineLoadNewestInternalData ItimelineLoadNewestInternalData;
typedef struct _ItimelineLoadOlderInternalData ItimelineLoadOlderInternalData;
typedef struct _Block13Data Block13Data;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

struct _ITimelineIface {
	GTypeInterface parent_iface;
	gint64 (*get_lowest_id) (ITimeline* self);
	void (*set_lowest_id) (ITimeline* self, gint64 value);
	gint64 (*get_max_id) (ITimeline* self);
	void (*set_max_id) (ITimeline* self, gint64 value);
	TweetListBox* (*get_tweet_list) (ITimeline* self);
	void (*set_tweet_list) (ITimeline* self, TweetListBox* value);
	gint (*get_unread_count) (ITimeline* self);
	void (*set_unread_count) (ITimeline* self, gint value);
	DeltaUpdater* (*get_delta_updater) (ITimeline* self);
	void (*set_delta_updater) (ITimeline* self, DeltaUpdater* value);
	const gchar* (*get_function) (ITimeline* self);
};

struct _TweetUtilsWorkerResult {
	gint64 max_id;
	gint64 min_id;
};

struct _ItimelineLoadNewestInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ITimeline* self;
	gint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp0_;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	RestProxyCall* _tmp13_;
	RestProxyCall* _tmp14_;
	RestProxyCall* _tmp15_;
	gint64 _tmp16_;
	gint64 _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	JsonNode* root_node;
	RestProxyCall* _tmp20_;
	JsonNode* _tmp21_;
	JsonNode* _tmp22_;
	TweetListBox* _tmp23_;
	TweetListBox* _tmp24_;
	const gchar* _tmp25_;
	TweetListBox* _tmp26_;
	TweetListBox* _tmp27_;
	JsonArray* root;
	JsonNode* _tmp28_;
	JsonArray* _tmp29_;
	JsonArray* _tmp30_;
	JsonArray* _tmp31_;
	guint _tmp32_;
	TweetListBox* _tmp33_;
	TweetListBox* _tmp34_;
	TweetUtilsWorkerResult res;
	JsonArray* _tmp35_;
	gint _tmp36_;
	DeltaUpdater* _tmp37_;
	DeltaUpdater* _tmp38_;
	TweetListBox* _tmp39_;
	TweetListBox* _tmp40_;
	MainWindow* _tmp41_;
	MainWindow* _tmp42_;
	Account* _tmp43_;
	Account* _tmp44_;
	TweetUtilsWorkerResult _tmp45_;
	TweetUtilsWorkerResult _tmp46_;
	gint64 _tmp47_;
	gint64 _tmp48_;
	gint64 _tmp49_;
	TweetUtilsWorkerResult _tmp50_;
	gint64 _tmp51_;
	TweetUtilsWorkerResult _tmp52_;
	gint64 _tmp53_;
	gint64 _tmp54_;
	gint64 _tmp55_;
	TweetUtilsWorkerResult _tmp56_;
	gint64 _tmp57_;
};

struct _ItimelineLoadOlderInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ITimeline* self;
	gint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp0_;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	RestProxyCall* _tmp13_;
	RestProxyCall* _tmp14_;
	gint64 _tmp15_;
	gint64 _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	JsonNode* root_node;
	RestProxyCall* _tmp19_;
	JsonNode* _tmp20_;
	JsonNode* _tmp21_;
	JsonArray* root;
	JsonNode* _tmp22_;
	JsonArray* _tmp23_;
	JsonArray* _tmp24_;
	JsonArray* _tmp25_;
	guint _tmp26_;
	TweetListBox* _tmp27_;
	TweetListBox* _tmp28_;
	TweetUtilsWorkerResult res;
	JsonArray* _tmp29_;
	gint _tmp30_;
	DeltaUpdater* _tmp31_;
	DeltaUpdater* _tmp32_;
	TweetListBox* _tmp33_;
	TweetListBox* _tmp34_;
	MainWindow* _tmp35_;
	MainWindow* _tmp36_;
	Account* _tmp37_;
	Account* _tmp38_;
	TweetUtilsWorkerResult _tmp39_;
	TweetUtilsWorkerResult _tmp40_;
	gint64 _tmp41_;
	gint64 _tmp42_;
	gint64 _tmp43_;
	TweetUtilsWorkerResult _tmp44_;
	gint64 _tmp45_;
};

struct _Block13Data {
	int _ref_count_;
	ITimeline* self;
	gdouble value;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
	gboolean (*get_seen) (ITwitterItem* self);
	void (*set_seen) (ITwitterItem* self, gboolean value);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	gchar* notification_id;
	Tweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};



GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType itimeline_get_type (void) G_GNUC_CONST;
static void itimeline_load_newest_internal_data_free (gpointer _data);
void itimeline_load_newest_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void itimeline_load_newest_internal_finish (ITimeline* self, GAsyncResult* _res_);
static gboolean itimeline_load_newest_internal_co (ItimelineLoadNewestInternalData* _data_);
Account* ipage_get_account (IPage* self);
OAuthProxy* account_get_proxy (Account* self);
const gchar* itimeline_get_function (ITimeline* self);
gint64 itimeline_get_lowest_id (ITimeline* self);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_);
static void itimeline_load_newest_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TweetListBox* itimeline_get_tweet_list (ITimeline* self);
void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg);
void tweet_list_box_set_empty (TweetListBox* self);
static void _vala_JsonNode_free (JsonNode* self);
GType tweet_utils_worker_result_get_type (void) G_GNUC_CONST;
TweetUtilsWorkerResult* tweet_utils_worker_result_dup (const TweetUtilsWorkerResult* self);
void tweet_utils_worker_result_free (TweetUtilsWorkerResult* self);
void tweet_utils_work_array (JsonArray* json_array, guint requested_tweet_count, DeltaUpdater* delta_updater, TweetListBox* tweet_list, MainWindow* main_window, Account* account, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_work_array_finish (GAsyncResult* _res_, TweetUtilsWorkerResult* result);
DeltaUpdater* itimeline_get_delta_updater (ITimeline* self);
MainWindow* ipage_get_main_window (IPage* self);
void itimeline_set_lowest_id (ITimeline* self, gint64 value);
gint64 itimeline_get_max_id (ITimeline* self);
void itimeline_set_max_id (ITimeline* self, gint64 value);
static void itimeline_load_older_internal_data_free (gpointer _data);
void itimeline_load_older_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void itimeline_load_older_internal_finish (ITimeline* self, GAsyncResult* _res_);
static gboolean itimeline_load_older_internal_co (ItimelineLoadOlderInternalData* _data_);
static void itimeline_load_older_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void itimeline_mark_seen_on_scroll (ITimeline* self, gdouble value);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
gint itimeline_get_unread_count (ITimeline* self);
static void __lambda92_ (Block13Data* _data13_, GtkWidget* w);
GType itwitter_item_get_type (void) G_GNUC_CONST;
gboolean itwitter_item_get_seen (ITwitterItem* self);
void itwitter_item_set_seen (ITwitterItem* self, gboolean value);
void itimeline_set_unread_count (ITimeline* self, gint value);
static void ___lambda92__gtk_callback (GtkWidget* widget, gpointer self);
void itimeline_rerun_filters (ITimeline* self);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
gboolean account_filter_matches (Account* self, Tweet* t);
#define ITIMELINE_REST 25
void itimeline_set_tweet_list (ITimeline* self, TweetListBox* value);
void itimeline_set_delta_updater (ITimeline* self, DeltaUpdater* value);


static void itimeline_load_newest_internal_data_free (gpointer _data) {
	ItimelineLoadNewestInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ItimelineLoadNewestInternalData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void itimeline_load_newest_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ItimelineLoadNewestInternalData* _data_;
	ITimeline* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ItimelineLoadNewestInternalData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, itimeline_load_newest_internal);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, itimeline_load_newest_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	itimeline_load_newest_internal_co (_data_);
}


void itimeline_load_newest_internal_finish (ITimeline* self, GAsyncResult* _res_) {
	ItimelineLoadNewestInternalData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Default implementation for loading the newest tweets
   * from the given function of the twitter api.
   */
static void itimeline_load_newest_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ItimelineLoadNewestInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	itimeline_load_newest_internal_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gboolean itimeline_load_newest_internal_co (ItimelineLoadNewestInternalData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->requested_tweet_count = 28;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = account_get_proxy (_data_->_tmp1_);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = itimeline_get_function (_data_->self);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	rest_proxy_call_set_function (_data_->_tmp5_, _data_->_tmp7_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp8_, "GET");
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->call;
	_data_->_tmp10_ = 0;
	_data_->_tmp10_ = _data_->requested_tweet_count;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = g_strdup_printf ("%i", _data_->_tmp10_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_;
	rest_proxy_call_add_param (_data_->_tmp9_, "count", _data_->_tmp12_);
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp13_, "contributor_details", "true");
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp14_, "include_my_retweet", "true");
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->call;
	_data_->_tmp16_ = 0LL;
	_data_->_tmp16_ = itimeline_get_lowest_id (_data_->self);
	_data_->_tmp17_ = 0LL;
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp17_ - 1);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->_tmp18_;
	rest_proxy_call_add_param (_data_->_tmp15_, "max_id", _data_->_tmp19_);
	_g_free0 (_data_->_tmp19_);
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->call;
	_data_->_state_ = 1;
	tweet_utils_load_threaded (_data_->_tmp20_, itimeline_load_newest_internal_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = tweet_utils_load_threaded_finish (_data_->_res_);
	_data_->root_node = _data_->_tmp21_;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->root_node;
	if (_data_->_tmp22_ == NULL) {
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = itimeline_get_tweet_list (_data_->self);
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _ ("Could not load tweets");
		tweet_list_box_set_error (_data_->_tmp24_, _data_->_tmp25_);
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = itimeline_get_tweet_list (_data_->self);
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->_tmp26_;
		tweet_list_box_set_empty (_data_->_tmp27_);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->root_node;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = json_node_get_array (_data_->_tmp28_);
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _json_array_ref0 (_data_->_tmp29_);
	_data_->root = _data_->_tmp30_;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->root;
	_data_->_tmp32_ = 0U;
	_data_->_tmp32_ = json_array_get_length (_data_->_tmp31_);
	if (_data_->_tmp32_ == ((guint) 0)) {
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = itimeline_get_tweet_list (_data_->self);
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->_tmp33_;
		tweet_list_box_set_empty (_data_->_tmp34_);
		_json_array_unref0 (_data_->root);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->root;
	_data_->_tmp36_ = 0;
	_data_->_tmp36_ = _data_->requested_tweet_count;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = itimeline_get_delta_updater (_data_->self);
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = _data_->_tmp37_;
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = itimeline_get_tweet_list (_data_->self);
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = _data_->_tmp41_;
	_data_->_tmp43_ = NULL;
	_data_->_tmp43_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp44_ = NULL;
	_data_->_tmp44_ = _data_->_tmp43_;
	memset (&_data_->_tmp45_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_state_ = 2;
	tweet_utils_work_array (_data_->_tmp35_, (guint) _data_->_tmp36_, _data_->_tmp38_, _data_->_tmp40_, _data_->_tmp42_, _data_->_tmp44_, itimeline_load_newest_internal_ready, _data_);
	return FALSE;
	_state_2:
	tweet_utils_work_array_finish (_data_->_res_, &_data_->_tmp45_);
	_data_->res = _data_->_tmp45_;
	memset (&_data_->_tmp46_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_tmp46_ = _data_->res;
	_data_->_tmp47_ = 0LL;
	_data_->_tmp47_ = _data_->_tmp46_.min_id;
	_data_->_tmp48_ = 0LL;
	_data_->_tmp48_ = itimeline_get_lowest_id (_data_->self);
	_data_->_tmp49_ = 0LL;
	_data_->_tmp49_ = _data_->_tmp48_;
	if (_data_->_tmp47_ < _data_->_tmp49_) {
		memset (&_data_->_tmp50_, 0, sizeof (TweetUtilsWorkerResult));
		_data_->_tmp50_ = _data_->res;
		_data_->_tmp51_ = 0LL;
		_data_->_tmp51_ = _data_->_tmp50_.min_id;
		itimeline_set_lowest_id (_data_->self, _data_->_tmp51_);
	}
	memset (&_data_->_tmp52_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_tmp52_ = _data_->res;
	_data_->_tmp53_ = 0LL;
	_data_->_tmp53_ = _data_->_tmp52_.max_id;
	_data_->_tmp54_ = 0LL;
	_data_->_tmp54_ = itimeline_get_max_id (_data_->self);
	_data_->_tmp55_ = 0LL;
	_data_->_tmp55_ = _data_->_tmp54_;
	if (_data_->_tmp53_ > _data_->_tmp55_) {
		memset (&_data_->_tmp56_, 0, sizeof (TweetUtilsWorkerResult));
		_data_->_tmp56_ = _data_->res;
		_data_->_tmp57_ = 0LL;
		_data_->_tmp57_ = _data_->_tmp56_.max_id;
		itimeline_set_max_id (_data_->self, _data_->_tmp57_);
	}
	_json_array_unref0 (_data_->root);
	__vala_JsonNode_free0 (_data_->root_node);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void itimeline_load_older_internal_data_free (gpointer _data) {
	ItimelineLoadOlderInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ItimelineLoadOlderInternalData, _data_);
}


void itimeline_load_older_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ItimelineLoadOlderInternalData* _data_;
	ITimeline* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ItimelineLoadOlderInternalData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, itimeline_load_older_internal);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, itimeline_load_older_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	itimeline_load_older_internal_co (_data_);
}


void itimeline_load_older_internal_finish (ITimeline* self, GAsyncResult* _res_) {
	ItimelineLoadOlderInternalData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Default implementation to load older tweets.
   *
   */
static void itimeline_load_older_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ItimelineLoadOlderInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	itimeline_load_older_internal_co (_data_);
}


static gboolean itimeline_load_older_internal_co (ItimelineLoadOlderInternalData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->requested_tweet_count = 28;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = account_get_proxy (_data_->_tmp1_);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = itimeline_get_function (_data_->self);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	rest_proxy_call_set_function (_data_->_tmp5_, _data_->_tmp7_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp8_, "GET");
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->call;
	_data_->_tmp10_ = 0;
	_data_->_tmp10_ = _data_->requested_tweet_count;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = g_strdup_printf ("%i", _data_->_tmp10_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_;
	rest_proxy_call_add_param (_data_->_tmp9_, "count", _data_->_tmp12_);
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp13_, "include_my_retweet", "true");
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->call;
	_data_->_tmp15_ = 0LL;
	_data_->_tmp15_ = itimeline_get_lowest_id (_data_->self);
	_data_->_tmp16_ = 0LL;
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp16_ - 1);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->_tmp17_;
	rest_proxy_call_add_param (_data_->_tmp14_, "max_id", _data_->_tmp18_);
	_g_free0 (_data_->_tmp18_);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->call;
	_data_->_state_ = 1;
	tweet_utils_load_threaded (_data_->_tmp19_, itimeline_load_older_internal_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = tweet_utils_load_threaded_finish (_data_->_res_);
	_data_->root_node = _data_->_tmp20_;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->root_node;
	if (_data_->_tmp21_ == NULL) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->root_node;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = json_node_get_array (_data_->_tmp22_);
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _json_array_ref0 (_data_->_tmp23_);
	_data_->root = _data_->_tmp24_;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->root;
	_data_->_tmp26_ = 0U;
	_data_->_tmp26_ = json_array_get_length (_data_->_tmp25_);
	if (_data_->_tmp26_ == ((guint) 0)) {
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = itimeline_get_tweet_list (_data_->self);
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->_tmp27_;
		tweet_list_box_set_empty (_data_->_tmp28_);
		_json_array_unref0 (_data_->root);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->root;
	_data_->_tmp30_ = 0;
	_data_->_tmp30_ = _data_->requested_tweet_count;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = itimeline_get_delta_updater (_data_->self);
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = itimeline_get_tweet_list (_data_->self);
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->_tmp33_;
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = _data_->_tmp37_;
	memset (&_data_->_tmp39_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_state_ = 2;
	tweet_utils_work_array (_data_->_tmp29_, (guint) _data_->_tmp30_, _data_->_tmp32_, _data_->_tmp34_, _data_->_tmp36_, _data_->_tmp38_, itimeline_load_older_internal_ready, _data_);
	return FALSE;
	_state_2:
	tweet_utils_work_array_finish (_data_->_res_, &_data_->_tmp39_);
	_data_->res = _data_->_tmp39_;
	memset (&_data_->_tmp40_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_tmp40_ = _data_->res;
	_data_->_tmp41_ = 0LL;
	_data_->_tmp41_ = _data_->_tmp40_.min_id;
	_data_->_tmp42_ = 0LL;
	_data_->_tmp42_ = itimeline_get_lowest_id (_data_->self);
	_data_->_tmp43_ = 0LL;
	_data_->_tmp43_ = _data_->_tmp42_;
	if (_data_->_tmp41_ < _data_->_tmp43_) {
		memset (&_data_->_tmp44_, 0, sizeof (TweetUtilsWorkerResult));
		_data_->_tmp44_ = _data_->res;
		_data_->_tmp45_ = 0LL;
		_data_->_tmp45_ = _data_->_tmp44_.min_id;
		itimeline_set_lowest_id (_data_->self, _data_->_tmp45_);
	}
	_json_array_unref0 (_data_->root);
	__vala_JsonNode_free0 (_data_->root_node);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Mark the TweetListEntries the user has already seen.
   *
   * @param value The scrolling value as from Gtk.Adjustment
   */
static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (void * _userdata_) {
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		ITimeline* self;
		self = _data13_->self;
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}


static void __lambda92_ (Block13Data* _data13_, GtkWidget* w) {
	ITimeline* self;
	ITwitterItem* tle = NULL;
	GtkWidget* _tmp0_ = NULL;
	ITwitterItem* _tmp1_ = NULL;
	ITwitterItem* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkAllocation alloc = {0};
	ITwitterItem* _tmp5_ = NULL;
	GtkAllocation _tmp6_ = {0};
	GtkAllocation _tmp7_ = {0};
	gint _tmp8_ = 0;
	GtkAllocation _tmp9_ = {0};
	gint _tmp10_ = 0;
	gdouble _tmp11_ = 0.0;
	self = _data13_->self;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ITWITTER_ITEM, ITwitterItem));
	tle = _tmp1_;
	_tmp2_ = tle;
	_tmp3_ = itwitter_item_get_seen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_g_object_unref0 (tle);
		return;
	}
	_tmp5_ = tle;
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), &_tmp6_);
	alloc = _tmp6_;
	_tmp7_ = alloc;
	_tmp8_ = _tmp7_.y;
	_tmp9_ = alloc;
	_tmp10_ = _tmp9_.height;
	_tmp11_ = _data13_->value;
	if ((_tmp8_ + (_tmp10_ / 2.0)) >= _tmp11_) {
		ITwitterItem* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp12_ = tle;
		itwitter_item_set_seen (_tmp12_, TRUE);
		_tmp13_ = itimeline_get_unread_count (self);
		_tmp14_ = _tmp13_;
		itimeline_set_unread_count (self, _tmp14_ - 1);
	}
	_g_object_unref0 (tle);
}


static void ___lambda92__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda92_ (self, widget);
}


void itimeline_mark_seen_on_scroll (ITimeline* self, gdouble value) {
	Block13Data* _data13_;
	gdouble _tmp0_ = 0.0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	TweetListBox* _tmp3_ = NULL;
	TweetListBox* _tmp4_ = NULL;
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = value;
	_data13_->value = _tmp0_;
	_tmp1_ = itimeline_get_unread_count (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		block13_data_unref (_data13_);
		_data13_ = NULL;
		return;
	}
	_tmp3_ = itimeline_get_tweet_list (self);
	_tmp4_ = _tmp3_;
	GTK_CONTAINER_GET_CLASS (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer))->forall (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer), FALSE, ___lambda92__gtk_callback, _data13_);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}


void itimeline_rerun_filters (ITimeline* self) {
	GList* children = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	_tmp0_ = itimeline_get_tweet_list (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer));
	children = _tmp2_;
	_tmp3_ = children;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp3_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp4_ = NULL;
			GtkWidget* w = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp4_;
			{
				GtkWidget* _tmp5_ = NULL;
				TweetListEntry* tle = NULL;
				GtkWidget* _tmp6_ = NULL;
				TweetListEntry* _tmp7_ = NULL;
				Account* _tmp8_ = NULL;
				Account* _tmp9_ = NULL;
				TweetListEntry* _tmp10_ = NULL;
				Tweet* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				_tmp5_ = w;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_TWEET_LIST_ENTRY)) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp6_ = w;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
				tle = _tmp7_;
				_tmp8_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
				_tmp9_ = _tmp8_;
				_tmp10_ = tle;
				_tmp11_ = _tmp10_->tweet;
				_tmp12_ = account_filter_matches (_tmp9_, _tmp11_);
				if (_tmp12_) {
					TweetListEntry* _tmp13_ = NULL;
					_tmp13_ = tle;
					gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
				} else {
					TweetListEntry* _tmp14_ = NULL;
					_tmp14_ = tle;
					gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
				}
				_g_object_unref0 (tle);
				_g_object_unref0 (w);
			}
		}
	}
	_g_list_free0 (children);
}


gint64 itimeline_get_lowest_id (ITimeline* self) {
	g_return_val_if_fail (IS_ITIMELINE (self), 0LL);
	return ITIMELINE_GET_INTERFACE (self)->get_lowest_id (self);
}


void itimeline_set_lowest_id (ITimeline* self, gint64 value) {
	g_return_if_fail (IS_ITIMELINE (self));
	ITIMELINE_GET_INTERFACE (self)->set_lowest_id (self, value);
}


gint64 itimeline_get_max_id (ITimeline* self) {
	g_return_val_if_fail (IS_ITIMELINE (self), 0LL);
	return ITIMELINE_GET_INTERFACE (self)->get_max_id (self);
}


void itimeline_set_max_id (ITimeline* self, gint64 value) {
	g_return_if_fail (IS_ITIMELINE (self));
	ITIMELINE_GET_INTERFACE (self)->set_max_id (self, value);
}


TweetListBox* itimeline_get_tweet_list (ITimeline* self) {
	g_return_val_if_fail (IS_ITIMELINE (self), NULL);
	return ITIMELINE_GET_INTERFACE (self)->get_tweet_list (self);
}


void itimeline_set_tweet_list (ITimeline* self, TweetListBox* value) {
	g_return_if_fail (IS_ITIMELINE (self));
	ITIMELINE_GET_INTERFACE (self)->set_tweet_list (self, value);
}


gint itimeline_get_unread_count (ITimeline* self) {
	g_return_val_if_fail (IS_ITIMELINE (self), 0);
	return ITIMELINE_GET_INTERFACE (self)->get_unread_count (self);
}


void itimeline_set_unread_count (ITimeline* self, gint value) {
	g_return_if_fail (IS_ITIMELINE (self));
	ITIMELINE_GET_INTERFACE (self)->set_unread_count (self, value);
}


DeltaUpdater* itimeline_get_delta_updater (ITimeline* self) {
	g_return_val_if_fail (IS_ITIMELINE (self), NULL);
	return ITIMELINE_GET_INTERFACE (self)->get_delta_updater (self);
}


void itimeline_set_delta_updater (ITimeline* self, DeltaUpdater* value) {
	g_return_if_fail (IS_ITIMELINE (self));
	ITIMELINE_GET_INTERFACE (self)->set_delta_updater (self, value);
}


const gchar* itimeline_get_function (ITimeline* self) {
	g_return_val_if_fail (IS_ITIMELINE (self), NULL);
	return ITIMELINE_GET_INTERFACE (self)->get_function (self);
}


static void itimeline_base_init (ITimelineIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/** The lowest id of any tweet in this timeline */
		g_object_interface_install_property (iface, g_param_spec_int64 ("lowest-id", "lowest-id", "lowest-id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int64 ("max-id", "max-id", "max-id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("tweet-list", "tweet-list", "tweet-list", TYPE_TWEET_LIST_BOX, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("delta-updater", "delta-updater", "delta-updater", TYPE_DELTA_UPDATER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("function", "function", "function", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


/**
 * Describes everything a timeline should provide, in an abstract way.
 * Default implementations are given through the *_internal methods.
 */
GType itimeline_get_type (void) {
	static volatile gsize itimeline_type_id__volatile = 0;
	if (g_once_init_enter (&itimeline_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ITimelineIface), (GBaseInitFunc) itimeline_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType itimeline_type_id;
		itimeline_type_id = g_type_register_static (G_TYPE_INTERFACE, "ITimeline", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (itimeline_type_id, gtk_widget_get_type ());
		g_type_interface_add_prerequisite (itimeline_type_id, TYPE_IPAGE);
		g_once_init_leave (&itimeline_type_id__volatile, itimeline_type_id);
	}
	return itimeline_type_id__volatile;
}



