/* Tweet.c generated by valac 0.26.2, the Vala compiler
 * generated from Tweet.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <json-glib/json-glib.h>


#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;

#define TWEET_UTILS_TYPE_SEQUENCE (tweet_utils_sequence_get_type ())
typedef struct _TweetUtilsSequence TweetUtilsSequence;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_slist_free__tweet_utils_sequence_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__tweet_utils_sequence_free0_ (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _Block14Data Block14Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MediaPrivate MediaPrivate;

#define TYPE_MEDIA_TYPE (media_type_get_type ())
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

#define TYPE_USER_COUNTER (user_counter_get_type ())
#define USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COUNTER, UserCounter))
#define USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COUNTER, UserCounterClass))
#define IS_USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COUNTER))
#define IS_USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COUNTER))
#define USER_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COUNTER, UserCounterClass))

typedef struct _UserCounter UserCounter;
typedef struct _UserCounterClass UserCounterClass;

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	gint64 id;
	gint64 rt_id;
	gchar* text;
	gint64 user_id;
	gchar* user_name;
	gchar* retweeted_by;
	gchar* rt_by_screen_name;
	gint64 rt_by_id;
	gboolean is_retweet;
	GdkPixbuf* inline_media;
	gchar* time_delta;
	gchar* avatar_url;
	gchar* avatar_name;
	gchar* screen_name;
	gint64 created_at;
	gint64 rt_created_at;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gint64 reply_id;
	Media** medias;
	gint medias_length1;
	gint retweet_count;
	gint favorite_count;
	gchar** mentions;
	gint mentions_length1;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _TweetUtilsSequence {
	gint start;
	gint end;
	gchar* url;
	gchar* display_url;
	gboolean visual_display_url;
	gchar* title;
};

struct _TweetPrivate {
	gboolean _retweeted;
	gboolean _favorited;
	GdkPixbuf* _avatar;
	GSList* urls;
};

struct _Block14Data {
	int _ref_count_;
	Tweet* self;
	gint real_media_count;
	gint real_mentions;
	Account* account;
};

typedef enum  {
	MEDIA_TYPE_IMAGE,
	MEDIA_TYPE_VINE,
	MEDIA_TYPE_GIF,
	MEDIA_TYPE_ANIMATED_GIF,
	MEDIA_TYPE_TWITTER_VIDEO,
	MEDIA_TYPE_UNKNOWN
} MediaType;

struct _Media {
	GObject parent_instance;
	MediaPrivate * priv;
	gint64 id;
	gchar* path;
	gchar* thumb_path;
	gchar* url;
	MediaType type;
	GdkPixbuf* thumbnail;
	gboolean loaded;
	gboolean invalid;
};

struct _MediaClass {
	GObjectClass parent_class;
};

typedef void (*TwitterAvatarDownloadedFunc) (GdkPixbuf* avatar, void* user_data);

static gpointer tweet_parent_class = NULL;
extern GdkPixbuf* twitter_no_avatar;

GType tweet_get_type (void) G_GNUC_CONST;
GType media_get_type (void) G_GNUC_CONST;
GType tweet_utils_sequence_get_type (void) G_GNUC_CONST;
TweetUtilsSequence* tweet_utils_sequence_dup (const TweetUtilsSequence* self);
void tweet_utils_sequence_free (TweetUtilsSequence* self);
void tweet_utils_sequence_copy (const TweetUtilsSequence* self, TweetUtilsSequence* dest);
void tweet_utils_sequence_destroy (TweetUtilsSequence* self);
#define TWEET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET, TweetPrivate))
enum  {
	TWEET_DUMMY_PROPERTY,
	TWEET_RETWEETED,
	TWEET_FAVORITED,
	TWEET_AVATAR,
	TWEET_HAS_INLINE_MEDIA
};
static void _tweet_utils_sequence_free0_ (gpointer var);
static void _g_slist_free__tweet_utils_sequence_free0_ (GSList* self);
#define TWEET_MAX_LENGTH 140
Tweet* tweet_new (void);
Tweet* tweet_construct (GType object_type);
void tweet_set_avatar (Tweet* self, GdkPixbuf* value);
GType account_get_type (void) G_GNUC_CONST;
void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
void tweet_set_favorited (Tweet* self, gboolean value);
void tweet_set_retweeted (Tweet* self, gboolean value);
GDateTime* utils_parse_date (const gchar* input);
gchar* utils_get_avatar_name (const gchar* path);
gint utils_get_json_array_size (JsonObject* node, const gchar* object_name);
static void __lambda28_ (Block14Data* _data14_, JsonArray* arr, guint index, JsonNode* node);
gboolean inline_media_downloader_is_media_candidate (const gchar* url);
Media* media_new (void);
Media* media_construct (GType object_type);
GType media_type_get_type (void) G_GNUC_CONST;
MediaType media_type_from_url (const gchar* url);
static void ___lambda28__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void __lambda29_ (Tweet* self, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda29__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void __lambda30_ (Block14Data* _data14_, JsonArray* arr, guint index, JsonNode* node);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
const gchar* account_get_screen_name (Account* self);
GType user_counter_get_type (void) G_GNUC_CONST;
UserCounter* account_get_user_counter (Account* self);
void user_counter_user_seen (UserCounter* self, gint64 id, const gchar* screen_name, const gchar* name);
static void ___lambda30__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda31_ (Block14Data* _data14_, JsonArray* arr, guint index, JsonNode* node);
void media_set_target_url (Media* self, const gchar* value);
static void ____lambda31__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda32_ (Block14Data* _data14_, JsonArray* arr, guint index, JsonNode* node);
MediaType media_type_from_string (const gchar* s);
void media_set_thumb_url (Media* self, const gchar* value);
static void ____lambda32__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void inline_media_downloader_load_all_media (Tweet* t, Media** medias, int medias_length1);
static gint __lambda42_ (TweetUtilsSequence* a, TweetUtilsSequence* b);
static gint ___lambda42__gcompare_func (gconstpointer a, gconstpointer b);
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
GdkPixbuf* twitter_get_avatar (Twitter* self, const gchar* url, TwitterAvatarDownloadedFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static void __lambda43_ (Tweet* self, GdkPixbuf* a);
static void ___lambda43__twitter_avatar_downloaded_func (GdkPixbuf* avatar, gpointer self);
gchar* tweet_get_formatted_text (Tweet* self);
gchar* tweet_utils_get_formatted_text (const gchar* tweet_text, GSList* urls);
gchar* tweet_get_real_text (Tweet* self);
gchar* tweet_utils_get_real_text (const gchar* tweet_text, GSList* urls);
gchar* tweet_get_trimmed_text (Tweet* self);
gchar* tweet_utils_get_trimmed_text (const gchar* tweet_text, GSList* urls, gint media_count);
gboolean tweet_get_retweeted (Tweet* self);
gboolean tweet_get_favorited (Tweet* self);
GdkPixbuf* tweet_get_avatar (Tweet* self);
gboolean tweet_get_has_inline_media (Tweet* self);
static void tweet_finalize (GObject* obj);
static void _vala_tweet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tweet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _tweet_utils_sequence_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tweet_utils_sequence_free (var), NULL));
}


static void _g_slist_free__tweet_utils_sequence_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _tweet_utils_sequence_free0_, NULL);
	g_slist_free (self);
}


Tweet* tweet_construct (GType object_type) {
	Tweet * self = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	self = (Tweet*) g_object_new (object_type, NULL);
	_tmp0_ = twitter_no_avatar;
	tweet_set_avatar (self, _tmp0_);
	return self;
}


Tweet* tweet_new (void) {
	return tweet_construct (TYPE_TWEET);
}


/**
   * Fills all the data of this tweet from Json data.
   * @param status The Json object to get the data from
   * @param now The current time
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (void * _userdata_) {
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		Tweet* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->account);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally9;
	__catch9_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _tweet_utils_sequence_dup0 (gpointer self) {
	return self ? tweet_utils_sequence_dup (self) : NULL;
}


static void __lambda28_ (Block14Data* _data14_, JsonArray* arr, guint index, JsonNode* node) {
	Tweet* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	JsonArray* indices = NULL;
	JsonObject* _tmp23_ = NULL;
	JsonArray* _tmp24_ = NULL;
	JsonArray* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gint64 _tmp28_ = 0LL;
	gint64 _tmp29_ = 0LL;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	JsonObject* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	TweetUtilsSequence _tmp35_ = {0};
	TweetUtilsSequence _tmp36_ = {0};
	TweetUtilsSequence* _tmp37_ = NULL;
	self = _data14_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = url;
	_tmp4_ = json_object_get_string_member (_tmp3_, "expanded_url");
	_tmp5_ = g_strdup (_tmp4_);
	expanded_url = _tmp5_;
	_tmp6_ = expanded_url;
	_tmp7_ = inline_media_downloader_is_media_candidate (_tmp6_);
	if (_tmp7_) {
		Media* m = NULL;
		Media* _tmp8_ = NULL;
		Media* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		Media* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		Media* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		MediaType _tmp16_ = 0;
		Media** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gint _tmp18_ = 0;
		Media* _tmp19_ = NULL;
		Media* _tmp20_ = NULL;
		Media* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		_tmp8_ = media_new ();
		m = _tmp8_;
		_tmp9_ = m;
		_tmp10_ = expanded_url;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (_tmp9_->url);
		_tmp9_->url = _tmp11_;
		_tmp12_ = m;
		_tmp13_ = _data14_->real_media_count;
		_tmp12_->id = (gint64) _tmp13_;
		_tmp14_ = m;
		_tmp15_ = expanded_url;
		_tmp16_ = media_type_from_url (_tmp15_);
		_tmp14_->type = _tmp16_;
		_tmp17_ = self->medias;
		_tmp17__length1 = self->medias_length1;
		_tmp18_ = _data14_->real_media_count;
		_tmp19_ = m;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_g_object_unref0 (_tmp17_[_tmp18_]);
		_tmp17_[_tmp18_] = _tmp20_;
		_tmp21_ = _tmp17_[_tmp18_];
		_tmp22_ = _data14_->real_media_count;
		_data14_->real_media_count = _tmp22_ + 1;
		_g_object_unref0 (m);
	}
	_tmp23_ = url;
	_tmp24_ = json_object_get_array_member (_tmp23_, "indices");
	_tmp25_ = _json_array_ref0 (_tmp24_);
	indices = _tmp25_;
	_tmp26_ = expanded_url;
	_tmp27_ = string_replace (_tmp26_, "&", "&amp;");
	_g_free0 (expanded_url);
	expanded_url = _tmp27_;
	_tmp28_ = json_array_get_int_element (indices, (guint) 0);
	_tmp29_ = json_array_get_int_element (indices, (guint) 1);
	_tmp30_ = expanded_url;
	_tmp31_ = g_strdup (_tmp30_);
	_tmp32_ = url;
	_tmp33_ = json_object_get_string_member (_tmp32_, "display_url");
	_tmp34_ = g_strdup (_tmp33_);
	memset (&_tmp35_, 0, sizeof (TweetUtilsSequence));
	_tmp35_.start = (gint) _tmp28_;
	_tmp35_.end = (gint) _tmp29_;
	_g_free0 (_tmp35_.url);
	_tmp35_.url = _tmp31_;
	_g_free0 (_tmp35_.display_url);
	_tmp35_.display_url = _tmp34_;
	_tmp35_.visual_display_url = FALSE;
	_tmp36_ = _tmp35_;
	_tmp37_ = _tweet_utils_sequence_dup0 (&_tmp36_);
	self->priv->urls = g_slist_prepend (self->priv->urls, _tmp37_);
	tweet_utils_sequence_destroy (&_tmp36_);
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ___lambda28__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda28_ (self, array, index_, element_node);
}


static void __lambda29_ (Tweet* self, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* hashtag = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp3_ = NULL;
	JsonArray* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	TweetUtilsSequence _tmp11_ = {0};
	TweetUtilsSequence _tmp12_ = {0};
	TweetUtilsSequence* _tmp13_ = NULL;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	hashtag = _tmp2_;
	_tmp3_ = json_object_get_array_member (hashtag, "indices");
	_tmp4_ = _json_array_ref0 (_tmp3_);
	indices = _tmp4_;
	_tmp5_ = json_array_get_int_element (indices, (guint) 0);
	_tmp6_ = json_array_get_int_element (indices, (guint) 1);
	_tmp7_ = json_object_get_string_member (hashtag, "text");
	_tmp8_ = g_strconcat ("#", _tmp7_, NULL);
	_tmp9_ = json_object_get_string_member (hashtag, "text");
	_tmp10_ = g_strconcat ("#", _tmp9_, NULL);
	memset (&_tmp11_, 0, sizeof (TweetUtilsSequence));
	_tmp11_.start = (gint) _tmp5_;
	_tmp11_.end = (gint) _tmp6_;
	_g_free0 (_tmp11_.url);
	_tmp11_.url = _tmp8_;
	_g_free0 (_tmp11_.display_url);
	_tmp11_.display_url = _tmp10_;
	_tmp11_.visual_display_url = FALSE;
	_tmp12_ = _tmp11_;
	_tmp13_ = _tweet_utils_sequence_dup0 (&_tmp12_);
	self->priv->urls = g_slist_prepend (self->priv->urls, _tmp13_);
	tweet_utils_sequence_destroy (&_tmp12_);
	_json_array_unref0 (indices);
	_json_object_unref0 (hashtag);
}


static void ___lambda29__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda29_ ((Tweet*) self, array, index_, element_node);
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void __lambda30_ (Block14Data* _data14_, JsonArray* arr, guint index, JsonNode* node) {
	Tweet* self;
	JsonObject* mention = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonArray* indices = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonArray* _tmp4_ = NULL;
	JsonArray* _tmp5_ = NULL;
	gchar* screen_name = NULL;
	JsonObject* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gchar* name = NULL;
	JsonObject* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gint64 id = 0LL;
	JsonObject* _tmp31_ = NULL;
	gint64 _tmp32_ = 0LL;
	Account* _tmp33_ = NULL;
	UserCounter* _tmp34_ = NULL;
	UserCounter* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	JsonArray* _tmp37_ = NULL;
	gint64 _tmp38_ = 0LL;
	JsonArray* _tmp39_ = NULL;
	gint64 _tmp40_ = 0LL;
	JsonObject* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	JsonObject* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	TweetUtilsSequence _tmp54_ = {0};
	TweetUtilsSequence _tmp55_ = {0};
	TweetUtilsSequence* _tmp56_ = NULL;
	self = _data14_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	mention = _tmp2_;
	_tmp3_ = mention;
	_tmp4_ = json_object_get_array_member (_tmp3_, "indices");
	_tmp5_ = _json_array_ref0 (_tmp4_);
	indices = _tmp5_;
	_tmp6_ = mention;
	_tmp7_ = json_object_get_string_member (_tmp6_, "screen_name");
	_tmp8_ = g_strdup (_tmp7_);
	screen_name = _tmp8_;
	_tmp12_ = screen_name;
	_tmp13_ = self->mentions;
	_tmp13__length1 = self->mentions_length1;
	if (!_vala_string_array_contains (_tmp13_, _tmp13__length1, _tmp12_)) {
		const gchar* _tmp14_ = NULL;
		Account* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp14_ = screen_name;
		_tmp15_ = _data14_->account;
		_tmp16_ = account_get_screen_name (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp11_ = g_strcmp0 (_tmp14_, _tmp17_) != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp18_ = screen_name;
		_tmp19_ = self->rt_by_screen_name;
		_tmp10_ = g_strcmp0 (_tmp18_, _tmp19_) != 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_tmp20_ = screen_name;
		_tmp21_ = self->screen_name;
		_tmp9_ = g_strcmp0 (_tmp20_, _tmp21_) != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar** _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		gint _tmp23_ = 0;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		_tmp22_ = self->mentions;
		_tmp22__length1 = self->mentions_length1;
		_tmp23_ = _data14_->real_mentions;
		_tmp24_ = screen_name;
		_tmp25_ = g_strconcat ("@", _tmp24_, NULL);
		_g_free0 (_tmp22_[_tmp23_]);
		_tmp22_[_tmp23_] = _tmp25_;
		_tmp26_ = _tmp22_[_tmp23_];
		_tmp27_ = _data14_->real_mentions;
		_data14_->real_mentions = _tmp27_ + 1;
	}
	_tmp28_ = mention;
	_tmp29_ = json_object_get_string_member (_tmp28_, "name");
	_tmp30_ = g_strdup (_tmp29_);
	name = _tmp30_;
	_tmp31_ = mention;
	_tmp32_ = json_object_get_int_member (_tmp31_, "id");
	id = _tmp32_;
	_tmp33_ = _data14_->account;
	_tmp34_ = account_get_user_counter (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = screen_name;
	user_counter_user_seen (_tmp35_, id, _tmp36_, name);
	_tmp37_ = indices;
	_tmp38_ = json_array_get_int_element (_tmp37_, (guint) 0);
	_tmp39_ = indices;
	_tmp40_ = json_array_get_int_element (_tmp39_, (guint) 1);
	_tmp41_ = mention;
	_tmp42_ = json_object_get_string_member (_tmp41_, "id_str");
	_tmp43_ = g_strconcat ("@", _tmp42_, NULL);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_strconcat (_tmp44_, "/", NULL);
	_tmp46_ = _tmp45_;
	_tmp47_ = screen_name;
	_tmp48_ = g_strconcat (_tmp46_, _tmp47_, NULL);
	_tmp49_ = screen_name;
	_tmp50_ = g_strconcat ("@", _tmp49_, NULL);
	_tmp51_ = mention;
	_tmp52_ = json_object_get_string_member (_tmp51_, "name");
	_tmp53_ = g_strdup (_tmp52_);
	memset (&_tmp54_, 0, sizeof (TweetUtilsSequence));
	_tmp54_.start = (gint) _tmp38_;
	_tmp54_.end = (gint) _tmp40_;
	_g_free0 (_tmp54_.url);
	_tmp54_.url = _tmp48_;
	_g_free0 (_tmp54_.display_url);
	_tmp54_.display_url = _tmp50_;
	_tmp54_.visual_display_url = TRUE;
	_g_free0 (_tmp54_.title);
	_tmp54_.title = _tmp53_;
	_tmp55_ = _tmp54_;
	_tmp56_ = _tweet_utils_sequence_dup0 (&_tmp55_);
	self->priv->urls = g_slist_prepend (self->priv->urls, _tmp56_);
	tweet_utils_sequence_destroy (&_tmp55_);
	_g_free0 (_tmp46_);
	_g_free0 (_tmp44_);
	_g_free0 (name);
	_g_free0 (screen_name);
	_json_array_unref0 (indices);
	_json_object_unref0 (mention);
}


static void ___lambda30__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda30_ (self, array, index_, element_node);
}


static void ___lambda31_ (Block14Data* _data14_, JsonArray* arr, guint index, JsonNode* node) {
	Tweet* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	JsonArray* indices = NULL;
	JsonObject* _tmp8_ = NULL;
	JsonArray* _tmp9_ = NULL;
	JsonArray* _tmp10_ = NULL;
	JsonArray* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	JsonArray* _tmp13_ = NULL;
	gint64 _tmp14_ = 0LL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	JsonObject* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	TweetUtilsSequence _tmp20_ = {0};
	TweetUtilsSequence _tmp21_ = {0};
	TweetUtilsSequence* _tmp22_ = NULL;
	gchar* media_url = NULL;
	JsonObject* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	self = _data14_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = url;
	_tmp4_ = json_object_get_string_member (_tmp3_, "expanded_url");
	_tmp5_ = g_strdup (_tmp4_);
	expanded_url = _tmp5_;
	_tmp6_ = expanded_url;
	_tmp7_ = string_replace (_tmp6_, "&", "&amp;");
	_g_free0 (expanded_url);
	expanded_url = _tmp7_;
	_tmp8_ = url;
	_tmp9_ = json_object_get_array_member (_tmp8_, "indices");
	_tmp10_ = _json_array_ref0 (_tmp9_);
	indices = _tmp10_;
	_tmp11_ = indices;
	_tmp12_ = json_array_get_int_element (_tmp11_, (guint) 0);
	_tmp13_ = indices;
	_tmp14_ = json_array_get_int_element (_tmp13_, (guint) 1);
	_tmp15_ = expanded_url;
	_tmp16_ = g_strdup (_tmp15_);
	_tmp17_ = url;
	_tmp18_ = json_object_get_string_member (_tmp17_, "display_url");
	_tmp19_ = g_strdup (_tmp18_);
	memset (&_tmp20_, 0, sizeof (TweetUtilsSequence));
	_tmp20_.start = (gint) _tmp12_;
	_tmp20_.end = (gint) _tmp14_;
	_g_free0 (_tmp20_.url);
	_tmp20_.url = _tmp16_;
	_g_free0 (_tmp20_.display_url);
	_tmp20_.display_url = _tmp19_;
	_tmp20_.visual_display_url = FALSE;
	_tmp21_ = _tmp20_;
	_tmp22_ = _tweet_utils_sequence_dup0 (&_tmp21_);
	self->priv->urls = g_slist_prepend (self->priv->urls, _tmp22_);
	tweet_utils_sequence_destroy (&_tmp21_);
	_tmp23_ = url;
	_tmp24_ = json_object_get_string_member (_tmp23_, "media_url");
	_tmp25_ = g_strdup (_tmp24_);
	media_url = _tmp25_;
	_tmp26_ = media_url;
	_tmp27_ = inline_media_downloader_is_media_candidate (_tmp26_);
	if (_tmp27_) {
		Media* m = NULL;
		Media* _tmp28_ = NULL;
		Media* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		Media* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		Media** _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		gint _tmp37_ = 0;
		Media* _tmp38_ = NULL;
		Media* _tmp39_ = NULL;
		Media* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		_tmp28_ = media_new ();
		m = _tmp28_;
		_tmp29_ = m;
		_tmp30_ = media_url;
		_tmp31_ = g_strdup (_tmp30_);
		_g_free0 (_tmp29_->url);
		_tmp29_->url = _tmp31_;
		_tmp32_ = m;
		_tmp33_ = media_url;
		_tmp34_ = g_strconcat (_tmp33_, ":large", NULL);
		_tmp35_ = _tmp34_;
		media_set_target_url (_tmp32_, _tmp35_);
		_g_free0 (_tmp35_);
		_tmp36_ = self->medias;
		_tmp36__length1 = self->medias_length1;
		_tmp37_ = _data14_->real_media_count;
		_tmp38_ = m;
		_tmp39_ = _g_object_ref0 (_tmp38_);
		_g_object_unref0 (_tmp36_[_tmp37_]);
		_tmp36_[_tmp37_] = _tmp39_;
		_tmp40_ = _tmp36_[_tmp37_];
		_tmp41_ = _data14_->real_media_count;
		_data14_->real_media_count = _tmp41_ + 1;
		_g_object_unref0 (m);
	}
	_g_free0 (media_url);
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ____lambda31__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda31_ (self, array, index_, element_node);
}


static void ___lambda32_ (Block14Data* _data14_, JsonArray* arr, guint index, JsonNode* node) {
	Tweet* self;
	JsonObject* media_obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* media_type = NULL;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	self = _data14_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	media_obj = _tmp2_;
	_tmp3_ = media_obj;
	_tmp4_ = json_object_get_string_member (_tmp3_, "type");
	_tmp5_ = g_strdup (_tmp4_);
	media_type = _tmp5_;
	_tmp6_ = media_type;
	if (g_strcmp0 (_tmp6_, "photo") == 0) {
		gchar* url = NULL;
		JsonObject* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		Media** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		const gchar* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		_tmp7_ = media_obj;
		_tmp8_ = json_object_get_string_member (_tmp7_, "media_url");
		_tmp9_ = g_strdup (_tmp8_);
		url = _tmp9_;
		_tmp10_ = self->medias;
		_tmp10__length1 = self->medias_length1;
		{
			Media** m_collection = NULL;
			gint m_collection_length1 = 0;
			gint _m_collection_size_ = 0;
			gint m_it = 0;
			m_collection = _tmp10_;
			m_collection_length1 = _tmp10__length1;
			for (m_it = 0; m_it < _tmp10__length1; m_it = m_it + 1) {
				Media* _tmp11_ = NULL;
				Media* m = NULL;
				_tmp11_ = _g_object_ref0 (m_collection[m_it]);
				m = _tmp11_;
				{
					gboolean _tmp12_ = FALSE;
					Media* _tmp13_ = NULL;
					_tmp13_ = m;
					if (_tmp13_ != NULL) {
						Media* _tmp14_ = NULL;
						const gchar* _tmp15_ = NULL;
						const gchar* _tmp16_ = NULL;
						_tmp14_ = m;
						_tmp15_ = _tmp14_->url;
						_tmp16_ = url;
						_tmp12_ = g_strcmp0 (_tmp15_, _tmp16_) == 0;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						_g_object_unref0 (m);
						_g_free0 (url);
						_g_free0 (media_type);
						_json_object_unref0 (media_obj);
						return;
					}
					_g_object_unref0 (m);
				}
			}
		}
		_tmp17_ = url;
		_tmp18_ = inline_media_downloader_is_media_candidate (_tmp17_);
		if (_tmp18_) {
			Media* m = NULL;
			Media* _tmp19_ = NULL;
			Media* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			Media* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			Media* _tmp27_ = NULL;
			JsonObject* _tmp28_ = NULL;
			gint64 _tmp29_ = 0LL;
			Media* _tmp30_ = NULL;
			JsonObject* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			MediaType _tmp33_ = 0;
			Media** _tmp34_ = NULL;
			gint _tmp34__length1 = 0;
			gint _tmp35_ = 0;
			Media* _tmp36_ = NULL;
			Media* _tmp37_ = NULL;
			Media* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			_tmp19_ = media_new ();
			m = _tmp19_;
			_tmp20_ = m;
			_tmp21_ = url;
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (_tmp20_->url);
			_tmp20_->url = _tmp22_;
			_tmp23_ = m;
			_tmp24_ = url;
			_tmp25_ = g_strconcat (_tmp24_, ":large", NULL);
			_tmp26_ = _tmp25_;
			media_set_target_url (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			_tmp27_ = m;
			_tmp28_ = media_obj;
			_tmp29_ = json_object_get_int_member (_tmp28_, "id");
			_tmp27_->id = _tmp29_;
			_tmp30_ = m;
			_tmp31_ = media_obj;
			_tmp32_ = json_object_get_string_member (_tmp31_, "type");
			_tmp33_ = media_type_from_string (_tmp32_);
			_tmp30_->type = _tmp33_;
			_tmp34_ = self->medias;
			_tmp34__length1 = self->medias_length1;
			_tmp35_ = _data14_->real_media_count;
			_tmp36_ = m;
			_tmp37_ = _g_object_ref0 (_tmp36_);
			_g_object_unref0 (_tmp34_[_tmp35_]);
			_tmp34_[_tmp35_] = _tmp37_;
			_tmp38_ = _tmp34_[_tmp35_];
			_tmp39_ = _data14_->real_media_count;
			_data14_->real_media_count = _tmp39_ + 1;
			_g_object_unref0 (m);
		}
		_g_free0 (url);
	} else {
		gboolean _tmp40_ = FALSE;
		const gchar* _tmp41_ = NULL;
		_tmp41_ = media_type;
		if (g_strcmp0 (_tmp41_, "video") == 0) {
			_tmp40_ = TRUE;
		} else {
			const gchar* _tmp42_ = NULL;
			_tmp42_ = media_type;
			_tmp40_ = g_strcmp0 (_tmp42_, "animated_gif") == 0;
		}
		if (_tmp40_) {
			JsonObject* variant = NULL;
			JsonObject* _tmp43_ = NULL;
			JsonObject* _tmp44_ = NULL;
			JsonArray* _tmp45_ = NULL;
			JsonObject* _tmp46_ = NULL;
			JsonObject* _tmp47_ = NULL;
			Media* m = NULL;
			Media* _tmp48_ = NULL;
			Media* _tmp49_ = NULL;
			JsonObject* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			Media* _tmp53_ = NULL;
			JsonObject* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			Media* _tmp56_ = NULL;
			Media* _tmp57_ = NULL;
			JsonObject* _tmp58_ = NULL;
			gint64 _tmp59_ = 0LL;
			Media** _tmp60_ = NULL;
			gint _tmp60__length1 = 0;
			gint _tmp61_ = 0;
			Media* _tmp62_ = NULL;
			Media* _tmp63_ = NULL;
			Media* _tmp64_ = NULL;
			gint _tmp65_ = 0;
			_tmp43_ = media_obj;
			_tmp44_ = json_object_get_object_member (_tmp43_, "video_info");
			_tmp45_ = json_object_get_array_member (_tmp44_, "variants");
			_tmp46_ = json_array_get_object_element (_tmp45_, (guint) 0);
			_tmp47_ = _json_object_ref0 (_tmp46_);
			variant = _tmp47_;
			_tmp48_ = media_new ();
			m = _tmp48_;
			_tmp49_ = m;
			_tmp50_ = variant;
			_tmp51_ = json_object_get_string_member (_tmp50_, "url");
			_tmp52_ = g_strdup (_tmp51_);
			_g_free0 (_tmp49_->url);
			_tmp49_->url = _tmp52_;
			_tmp53_ = m;
			_tmp54_ = media_obj;
			_tmp55_ = json_object_get_string_member (_tmp54_, "media_url");
			media_set_thumb_url (_tmp53_, _tmp55_);
			_tmp56_ = m;
			_tmp56_->type = MEDIA_TYPE_TWITTER_VIDEO;
			_tmp57_ = m;
			_tmp58_ = media_obj;
			_tmp59_ = json_object_get_int_member (_tmp58_, "id");
			_tmp57_->id = _tmp59_;
			_tmp60_ = self->medias;
			_tmp60__length1 = self->medias_length1;
			_tmp61_ = _data14_->real_media_count;
			_tmp62_ = m;
			_tmp63_ = _g_object_ref0 (_tmp62_);
			_g_object_unref0 (_tmp60_[_tmp61_]);
			_tmp60_[_tmp61_] = _tmp63_;
			_tmp64_ = _tmp60_[_tmp61_];
			_tmp65_ = _data14_->real_media_count;
			_data14_->real_media_count = _tmp65_ + 1;
			_g_object_unref0 (m);
			_json_object_unref0 (variant);
		}
	}
	_g_free0 (media_type);
	_json_object_unref0 (media_obj);
}


static void ____lambda32__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda32_ (self, array, index_, element_node);
}


static gint __lambda42_ (TweetUtilsSequence* a, TweetUtilsSequence* b) {
	gint result = 0;
	TweetUtilsSequence* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	TweetUtilsSequence* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	_tmp0_ = a;
	_tmp1_ = (*_tmp0_).start;
	_tmp2_ = b;
	_tmp3_ = (*_tmp2_).start;
	if (_tmp1_ < _tmp3_) {
		result = -1;
		return result;
	}
	result = 1;
	return result;
}


static gint ___lambda42__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = __lambda42_ ((TweetUtilsSequence*) a, (TweetUtilsSequence*) b);
	return result;
}


static void __lambda43_ (Tweet* self, GdkPixbuf* a) {
	GdkPixbuf* _tmp0_ = NULL;
	g_return_if_fail (GDK_IS_PIXBUF (a));
	_tmp0_ = a;
	tweet_set_avatar (self, _tmp0_);
}


static void ___lambda43__twitter_avatar_downloaded_func (GdkPixbuf* avatar, gpointer self) {
	__lambda43_ ((Tweet*) self, avatar);
}


void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account) {
	Block14Data* _data14_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	JsonObject* status = NULL;
	JsonNode* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	JsonObject* user = NULL;
	JsonObject* _tmp5_ = NULL;
	JsonObject* _tmp6_ = NULL;
	JsonObject* _tmp7_ = NULL;
	JsonObject* entities = NULL;
	JsonObject* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	JsonObject* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	JsonObject* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	JsonObject* _tmp14_ = NULL;
	gint64 _tmp15_ = 0LL;
	JsonObject* _tmp16_ = NULL;
	gint64 _tmp17_ = 0LL;
	JsonObject* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GDateTime* _tmp20_ = NULL;
	GDateTime* _tmp21_ = NULL;
	gint64 _tmp22_ = 0LL;
	JsonObject* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	JsonObject* _tmp96_ = NULL;
	gboolean _tmp97_ = FALSE;
	const gchar* _tmp101_ = NULL;
	gchar* _tmp102_ = NULL;
	gchar* _tmp103_ = NULL;
	gchar* _tmp104_ = NULL;
	const gchar* _tmp105_ = NULL;
	gchar* _tmp106_ = NULL;
	JsonArray* urls = NULL;
	JsonObject* _tmp107_ = NULL;
	JsonArray* _tmp108_ = NULL;
	JsonArray* _tmp109_ = NULL;
	JsonArray* hashtags = NULL;
	JsonObject* _tmp110_ = NULL;
	JsonArray* _tmp111_ = NULL;
	JsonArray* _tmp112_ = NULL;
	JsonArray* user_mentions = NULL;
	JsonObject* _tmp113_ = NULL;
	JsonArray* _tmp114_ = NULL;
	JsonArray* _tmp115_ = NULL;
	JsonArray* _tmp116_ = NULL;
	guint _tmp117_ = 0U;
	gchar** _tmp118_ = NULL;
	gint media_count = 0;
	JsonObject* _tmp119_ = NULL;
	gint _tmp120_ = 0;
	JsonObject* _tmp121_ = NULL;
	gboolean _tmp122_ = FALSE;
	gint _tmp127_ = 0;
	JsonArray* _tmp128_ = NULL;
	guint _tmp129_ = 0U;
	gint _tmp130_ = 0;
	Media** _tmp131_ = NULL;
	JsonArray* _tmp132_ = NULL;
	JsonArray* _tmp133_ = NULL;
	JsonArray* _tmp134_ = NULL;
	gint _tmp135_ = 0;
	gint _tmp136_ = 0;
	JsonObject* _tmp137_ = NULL;
	gboolean _tmp138_ = FALSE;
	JsonObject* _tmp143_ = NULL;
	gboolean _tmp144_ = FALSE;
	gint _tmp152_ = 0;
	gint _tmp153_ = 0;
	Media** _tmp154_ = NULL;
	gint _tmp154__length1 = 0;
	gint64 _tmp155_ = 0LL;
	gboolean _tmp156_ = FALSE;
	GDateTime* dt = NULL;
	GDateTime* _tmp159_ = NULL;
	GDateTime* _tmp160_ = NULL;
	gchar* _tmp161_ = NULL;
	Twitter* _tmp162_ = NULL;
	Twitter* _tmp163_ = NULL;
	const gchar* _tmp164_ = NULL;
	GdkPixbuf* _tmp165_ = NULL;
	GdkPixbuf* _tmp166_ = NULL;
	g_return_if_fail (IS_TWEET (self));
	g_return_if_fail (status_node != NULL);
	g_return_if_fail (now != NULL);
	g_return_if_fail (IS_ACCOUNT (account));
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data14_->account);
	_data14_->account = _tmp1_;
	_tmp2_ = status_node;
	_tmp3_ = json_node_get_object (_tmp2_);
	_tmp4_ = _json_object_ref0 (_tmp3_);
	status = _tmp4_;
	_tmp5_ = status;
	_tmp6_ = json_object_get_object_member (_tmp5_, "user");
	_tmp7_ = _json_object_ref0 (_tmp6_);
	user = _tmp7_;
	_tmp8_ = status;
	_tmp9_ = json_object_get_int_member (_tmp8_, "id");
	self->id = _tmp9_;
	_tmp10_ = status;
	_tmp11_ = json_object_get_boolean_member (_tmp10_, "favorited");
	tweet_set_favorited (self, _tmp11_);
	_tmp12_ = status;
	_tmp13_ = json_object_get_boolean_member (_tmp12_, "retweeted");
	tweet_set_retweeted (self, _tmp13_);
	_tmp14_ = status;
	_tmp15_ = json_object_get_int_member (_tmp14_, "retweet_count");
	self->retweet_count = (gint) _tmp15_;
	_tmp16_ = status;
	_tmp17_ = json_object_get_int_member (_tmp16_, "favorite_count");
	self->favorite_count = (gint) _tmp17_;
	_tmp18_ = status;
	_tmp19_ = json_object_get_string_member (_tmp18_, "created_at");
	_tmp20_ = utils_parse_date (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_date_time_to_unix (_tmp21_);
	self->created_at = _tmp22_;
	_g_date_time_unref0 (_tmp21_);
	_tmp23_ = status;
	_tmp24_ = json_object_has_member (_tmp23_, "retweeted_status");
	if (_tmp24_) {
		JsonObject* rt = NULL;
		JsonObject* _tmp25_ = NULL;
		JsonObject* _tmp26_ = NULL;
		JsonObject* _tmp27_ = NULL;
		JsonObject* rt_user = NULL;
		JsonObject* _tmp28_ = NULL;
		JsonObject* _tmp29_ = NULL;
		JsonObject* _tmp30_ = NULL;
		JsonObject* _tmp31_ = NULL;
		JsonObject* _tmp32_ = NULL;
		JsonObject* _tmp33_ = NULL;
		JsonObject* _tmp34_ = NULL;
		gint64 _tmp35_ = 0LL;
		JsonObject* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		JsonObject* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		JsonObject* _tmp42_ = NULL;
		gint64 _tmp43_ = 0LL;
		JsonObject* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		JsonObject* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		JsonObject* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		JsonObject* _tmp53_ = NULL;
		gint64 _tmp54_ = 0LL;
		JsonObject* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		JsonObject* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		GDateTime* _tmp60_ = NULL;
		GDateTime* _tmp61_ = NULL;
		gint64 _tmp62_ = 0LL;
		JsonObject* _tmp63_ = NULL;
		gboolean _tmp64_ = FALSE;
		JsonObject* _tmp65_ = NULL;
		gboolean _tmp66_ = FALSE;
		JsonObject* _tmp67_ = NULL;
		gboolean _tmp68_ = FALSE;
		_tmp25_ = status;
		_tmp26_ = json_object_get_object_member (_tmp25_, "retweeted_status");
		_tmp27_ = _json_object_ref0 (_tmp26_);
		rt = _tmp27_;
		_tmp28_ = rt;
		_tmp29_ = json_object_get_object_member (_tmp28_, "user");
		_tmp30_ = _json_object_ref0 (_tmp29_);
		rt_user = _tmp30_;
		_tmp31_ = rt;
		_tmp32_ = json_object_get_object_member (_tmp31_, "entities");
		_tmp33_ = _json_object_ref0 (_tmp32_);
		_json_object_unref0 (entities);
		entities = _tmp33_;
		self->is_retweet = TRUE;
		_tmp34_ = rt;
		_tmp35_ = json_object_get_int_member (_tmp34_, "id");
		self->rt_id = _tmp35_;
		_tmp36_ = user;
		_tmp37_ = json_object_get_string_member (_tmp36_, "name");
		_tmp38_ = string_replace (_tmp37_, "&", "&amp;");
		_g_free0 (self->retweeted_by);
		self->retweeted_by = _tmp38_;
		_tmp39_ = user;
		_tmp40_ = json_object_get_string_member (_tmp39_, "screen_name");
		_tmp41_ = g_strdup (_tmp40_);
		_g_free0 (self->rt_by_screen_name);
		self->rt_by_screen_name = _tmp41_;
		_tmp42_ = user;
		_tmp43_ = json_object_get_int_member (_tmp42_, "id");
		self->rt_by_id = _tmp43_;
		_tmp44_ = rt;
		_tmp45_ = json_object_get_string_member (_tmp44_, "text");
		_tmp46_ = g_strdup (_tmp45_);
		_g_free0 (self->text);
		self->text = _tmp46_;
		_tmp47_ = rt_user;
		_tmp48_ = json_object_get_string_member (_tmp47_, "name");
		_tmp49_ = g_strdup (_tmp48_);
		_g_free0 (self->user_name);
		self->user_name = _tmp49_;
		_tmp50_ = rt_user;
		_tmp51_ = json_object_get_string_member (_tmp50_, "profile_image_url");
		_tmp52_ = g_strdup (_tmp51_);
		_g_free0 (self->avatar_url);
		self->avatar_url = _tmp52_;
		_tmp53_ = rt_user;
		_tmp54_ = json_object_get_int_member (_tmp53_, "id");
		self->user_id = _tmp54_;
		_tmp55_ = rt_user;
		_tmp56_ = json_object_get_string_member (_tmp55_, "screen_name");
		_tmp57_ = g_strdup (_tmp56_);
		_g_free0 (self->screen_name);
		self->screen_name = _tmp57_;
		_tmp58_ = rt;
		_tmp59_ = json_object_get_string_member (_tmp58_, "created_at");
		_tmp60_ = utils_parse_date (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_date_time_to_unix (_tmp61_);
		self->rt_created_at = _tmp62_;
		_g_date_time_unref0 (_tmp61_);
		_tmp63_ = rt_user;
		_tmp64_ = json_object_get_boolean_member (_tmp63_, "verified");
		self->verified = _tmp64_;
		_tmp65_ = rt_user;
		_tmp66_ = json_object_get_boolean_member (_tmp65_, "protected");
		self->protected = _tmp66_;
		_tmp67_ = rt;
		_tmp68_ = json_object_get_null_member (_tmp67_, "in_reply_to_status_id");
		if (!_tmp68_) {
			JsonObject* _tmp69_ = NULL;
			gint64 _tmp70_ = 0LL;
			_tmp69_ = rt;
			_tmp70_ = json_object_get_int_member (_tmp69_, "in_reply_to_status_id");
			self->reply_id = _tmp70_;
		}
		_json_object_unref0 (rt_user);
		_json_object_unref0 (rt);
	} else {
		JsonObject* _tmp71_ = NULL;
		JsonObject* _tmp72_ = NULL;
		JsonObject* _tmp73_ = NULL;
		JsonObject* _tmp74_ = NULL;
		const gchar* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		JsonObject* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
		gchar* _tmp79_ = NULL;
		JsonObject* _tmp80_ = NULL;
		gint64 _tmp81_ = 0LL;
		JsonObject* _tmp82_ = NULL;
		const gchar* _tmp83_ = NULL;
		gchar* _tmp84_ = NULL;
		JsonObject* _tmp85_ = NULL;
		const gchar* _tmp86_ = NULL;
		gchar* _tmp87_ = NULL;
		JsonObject* _tmp88_ = NULL;
		gboolean _tmp89_ = FALSE;
		JsonObject* _tmp90_ = NULL;
		gboolean _tmp91_ = FALSE;
		JsonObject* _tmp92_ = NULL;
		gboolean _tmp93_ = FALSE;
		_tmp71_ = status;
		_tmp72_ = json_object_get_object_member (_tmp71_, "entities");
		_tmp73_ = _json_object_ref0 (_tmp72_);
		_json_object_unref0 (entities);
		entities = _tmp73_;
		_tmp74_ = status;
		_tmp75_ = json_object_get_string_member (_tmp74_, "text");
		_tmp76_ = g_strdup (_tmp75_);
		_g_free0 (self->text);
		self->text = _tmp76_;
		_tmp77_ = user;
		_tmp78_ = json_object_get_string_member (_tmp77_, "name");
		_tmp79_ = g_strdup (_tmp78_);
		_g_free0 (self->user_name);
		self->user_name = _tmp79_;
		_tmp80_ = user;
		_tmp81_ = json_object_get_int_member (_tmp80_, "id");
		self->user_id = _tmp81_;
		_tmp82_ = user;
		_tmp83_ = json_object_get_string_member (_tmp82_, "screen_name");
		_tmp84_ = g_strdup (_tmp83_);
		_g_free0 (self->screen_name);
		self->screen_name = _tmp84_;
		_tmp85_ = user;
		_tmp86_ = json_object_get_string_member (_tmp85_, "profile_image_url");
		_tmp87_ = g_strdup (_tmp86_);
		_g_free0 (self->avatar_url);
		self->avatar_url = _tmp87_;
		_tmp88_ = user;
		_tmp89_ = json_object_get_boolean_member (_tmp88_, "verified");
		self->verified = _tmp89_;
		_tmp90_ = user;
		_tmp91_ = json_object_get_boolean_member (_tmp90_, "protected");
		self->protected = _tmp91_;
		_tmp92_ = status;
		_tmp93_ = json_object_get_null_member (_tmp92_, "in_reply_to_status_id");
		if (!_tmp93_) {
			JsonObject* _tmp94_ = NULL;
			gint64 _tmp95_ = 0LL;
			_tmp94_ = status;
			_tmp95_ = json_object_get_int_member (_tmp94_, "in_reply_to_status_id");
			self->reply_id = _tmp95_;
		}
	}
	_tmp96_ = status;
	_tmp97_ = json_object_has_member (_tmp96_, "current_user_retweet");
	if (_tmp97_) {
		JsonObject* _tmp98_ = NULL;
		JsonObject* _tmp99_ = NULL;
		gint64 _tmp100_ = 0LL;
		_tmp98_ = status;
		_tmp99_ = json_object_get_object_member (_tmp98_, "current_user_retweet");
		_tmp100_ = json_object_get_int_member (_tmp99_, "id");
		self->my_retweet = _tmp100_;
		tweet_set_retweeted (self, TRUE);
	}
	_tmp101_ = self->user_name;
	_tmp102_ = string_replace (_tmp101_, "&", "&amp;");
	_tmp103_ = _tmp102_;
	_tmp104_ = string_strip (_tmp103_);
	_g_free0 (self->user_name);
	self->user_name = _tmp104_;
	_g_free0 (_tmp103_);
	_tmp105_ = self->avatar_url;
	_tmp106_ = utils_get_avatar_name (_tmp105_);
	_g_free0 (self->avatar_name);
	self->avatar_name = _tmp106_;
	_tmp107_ = entities;
	_tmp108_ = json_object_get_array_member (_tmp107_, "urls");
	_tmp109_ = _json_array_ref0 (_tmp108_);
	urls = _tmp109_;
	_tmp110_ = entities;
	_tmp111_ = json_object_get_array_member (_tmp110_, "hashtags");
	_tmp112_ = _json_array_ref0 (_tmp111_);
	hashtags = _tmp112_;
	_tmp113_ = entities;
	_tmp114_ = json_object_get_array_member (_tmp113_, "user_mentions");
	_tmp115_ = _json_array_ref0 (_tmp114_);
	user_mentions = _tmp115_;
	_tmp116_ = user_mentions;
	_tmp117_ = json_array_get_length (_tmp116_);
	_tmp118_ = g_new0 (gchar*, _tmp117_ + 1);
	self->mentions = (_vala_array_free (self->mentions, self->mentions_length1, (GDestroyNotify) g_free), NULL);
	self->mentions = _tmp118_;
	self->mentions_length1 = _tmp117_;
	__g_slist_free__tweet_utils_sequence_free0_0 (self->priv->urls);
	self->priv->urls = NULL;
	_tmp119_ = entities;
	_tmp120_ = utils_get_json_array_size (_tmp119_, "media");
	media_count = _tmp120_;
	_tmp121_ = status;
	_tmp122_ = json_object_has_member (_tmp121_, "extended_entities");
	if (_tmp122_) {
		gint _tmp123_ = 0;
		JsonObject* _tmp124_ = NULL;
		JsonObject* _tmp125_ = NULL;
		gint _tmp126_ = 0;
		_tmp123_ = media_count;
		_tmp124_ = status;
		_tmp125_ = json_object_get_object_member (_tmp124_, "extended_entities");
		_tmp126_ = utils_get_json_array_size (_tmp125_, "media");
		media_count = _tmp123_ + _tmp126_;
	}
	_tmp127_ = media_count;
	_tmp128_ = urls;
	_tmp129_ = json_array_get_length (_tmp128_);
	media_count = _tmp127_ + ((gint) _tmp129_);
	_tmp130_ = media_count;
	_tmp131_ = g_new0 (Media*, _tmp130_ + 1);
	self->medias = (_vala_array_free (self->medias, self->medias_length1, (GDestroyNotify) g_object_unref), NULL);
	self->medias = _tmp131_;
	self->medias_length1 = _tmp130_;
	_data14_->real_media_count = 0;
	_tmp132_ = urls;
	json_array_foreach_element (_tmp132_, ___lambda28__json_array_foreach, _data14_);
	_tmp133_ = hashtags;
	json_array_foreach_element (_tmp133_, ___lambda29__json_array_foreach, self);
	_data14_->real_mentions = 0;
	_tmp134_ = user_mentions;
	json_array_foreach_element (_tmp134_, ___lambda30__json_array_foreach, _data14_);
	_tmp135_ = _data14_->real_mentions;
	_tmp136_ = _tmp135_;
	self->mentions = g_renew (gchar*, self->mentions, _tmp135_);
	(_tmp136_ > self->mentions_length1) ? memset (self->mentions + self->mentions_length1, 0, sizeof (gchar*) * (_tmp136_ - self->mentions_length1)) : NULL;
	self->mentions_length1 = _tmp136_;
	_tmp137_ = entities;
	_tmp138_ = json_object_has_member (_tmp137_, "media");
	if (_tmp138_) {
		JsonArray* medias = NULL;
		JsonObject* _tmp139_ = NULL;
		JsonArray* _tmp140_ = NULL;
		JsonArray* _tmp141_ = NULL;
		JsonArray* _tmp142_ = NULL;
		_tmp139_ = entities;
		_tmp140_ = json_object_get_array_member (_tmp139_, "media");
		_tmp141_ = _json_array_ref0 (_tmp140_);
		medias = _tmp141_;
		_tmp142_ = medias;
		json_array_foreach_element (_tmp142_, ____lambda31__json_array_foreach, _data14_);
		_json_array_unref0 (medias);
	}
	_tmp143_ = status;
	_tmp144_ = json_object_has_member (_tmp143_, "extended_entities");
	if (_tmp144_) {
		JsonObject* extended_entities = NULL;
		JsonObject* _tmp145_ = NULL;
		JsonObject* _tmp146_ = NULL;
		JsonObject* _tmp147_ = NULL;
		JsonArray* extended_media = NULL;
		JsonObject* _tmp148_ = NULL;
		JsonArray* _tmp149_ = NULL;
		JsonArray* _tmp150_ = NULL;
		JsonArray* _tmp151_ = NULL;
		_tmp145_ = status;
		_tmp146_ = json_object_get_object_member (_tmp145_, "extended_entities");
		_tmp147_ = _json_object_ref0 (_tmp146_);
		extended_entities = _tmp147_;
		_tmp148_ = extended_entities;
		_tmp149_ = json_object_get_array_member (_tmp148_, "media");
		_tmp150_ = _json_array_ref0 (_tmp149_);
		extended_media = _tmp150_;
		_tmp151_ = extended_media;
		json_array_foreach_element (_tmp151_, ____lambda32__json_array_foreach, _data14_);
		_json_array_unref0 (extended_media);
		_json_object_unref0 (extended_entities);
	}
	_tmp152_ = _data14_->real_media_count;
	_tmp153_ = _tmp152_;
	self->medias = g_renew (Media*, self->medias, _tmp152_);
	(_tmp153_ > self->medias_length1) ? memset (self->medias + self->medias_length1, 0, sizeof (Media*) * (_tmp153_ - self->medias_length1)) : NULL;
	self->medias_length1 = _tmp153_;
	_tmp154_ = self->medias;
	_tmp154__length1 = self->medias_length1;
	inline_media_downloader_load_all_media (self, _tmp154_, _tmp154__length1);
	self->priv->urls = g_slist_sort (self->priv->urls, ___lambda42__gcompare_func);
	_tmp156_ = self->is_retweet;
	if (_tmp156_) {
		gint64 _tmp157_ = 0LL;
		_tmp157_ = self->rt_created_at;
		_tmp155_ = _tmp157_;
	} else {
		gint64 _tmp158_ = 0LL;
		_tmp158_ = self->created_at;
		_tmp155_ = _tmp158_;
	}
	_tmp159_ = g_date_time_new_from_unix_local (_tmp155_);
	dt = _tmp159_;
	_tmp160_ = now;
	_tmp161_ = utils_get_time_delta (dt, _tmp160_);
	_g_free0 (self->time_delta);
	self->time_delta = _tmp161_;
	_tmp162_ = twitter_get ();
	_tmp163_ = _tmp162_;
	_tmp164_ = self->avatar_url;
	_tmp165_ = twitter_get_avatar (_tmp163_, _tmp164_, ___lambda43__twitter_avatar_downloaded_func, g_object_ref (self), g_object_unref);
	_tmp166_ = _tmp165_;
	tweet_set_avatar (self, _tmp166_);
	_g_object_unref0 (_tmp166_);
	_g_object_unref0 (_tmp163_);
	_g_date_time_unref0 (dt);
	_json_array_unref0 (user_mentions);
	_json_array_unref0 (hashtags);
	_json_array_unref0 (urls);
	_json_object_unref0 (entities);
	_json_object_unref0 (user);
	_json_object_unref0 (status);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}


/**
   * Returns the text of this tweet in pango markup form,
   * i.e. formatted with the html tags used by pango.
   *
   * @return The tweet's formatted text.
   */
gchar* tweet_get_formatted_text (Tweet* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), NULL);
	_tmp0_ = self->text;
	_tmp1_ = self->priv->urls;
	_tmp2_ = tweet_utils_get_formatted_text (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
   * Returns the text of this tweet, with its long urls.
   * Twitter automatically shortens them.
   *
   * @return The tweet's text with long urls
   */
gchar* tweet_get_real_text (Tweet* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), NULL);
	_tmp0_ = self->text;
	_tmp1_ = self->priv->urls;
	_tmp2_ = tweet_utils_get_real_text (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


gchar* tweet_get_trimmed_text (Tweet* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	Media** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), NULL);
	_tmp0_ = self->text;
	_tmp1_ = self->priv->urls;
	_tmp2_ = self->medias;
	_tmp2__length1 = self->medias_length1;
	_tmp3_ = tweet_utils_get_trimmed_text (_tmp0_, _tmp1_, _tmp2__length1);
	result = _tmp3_;
	return result;
}


gboolean tweet_get_retweeted (Tweet* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (IS_TWEET (self), FALSE);
	_tmp0_ = self->priv->_retweeted;
	result = _tmp0_;
	return result;
}


void tweet_set_retweeted (Tweet* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_TWEET (self));
	_tmp0_ = value;
	self->priv->_retweeted = _tmp0_;
	g_object_notify ((GObject *) self, "retweeted");
}


gboolean tweet_get_favorited (Tweet* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (IS_TWEET (self), FALSE);
	_tmp0_ = self->priv->_favorited;
	result = _tmp0_;
	return result;
}


void tweet_set_favorited (Tweet* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_TWEET (self));
	_tmp0_ = value;
	self->priv->_favorited = _tmp0_;
	g_object_notify ((GObject *) self, "favorited");
}


GdkPixbuf* tweet_get_avatar (Tweet* self) {
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), NULL);
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


void tweet_set_avatar (Tweet* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_ = NULL;
	g_return_if_fail (IS_TWEET (self));
	_tmp0_ = value;
	self->priv->_avatar = _tmp0_;
	g_object_notify ((GObject *) self, "avatar");
}


gboolean tweet_get_has_inline_media (Tweet* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	Media** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (IS_TWEET (self), FALSE);
	_tmp1_ = self->medias;
	_tmp1__length1 = self->medias_length1;
	if (_tmp1_ != NULL) {
		Media** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		_tmp2_ = self->medias;
		_tmp2__length1 = self->medias_length1;
		_tmp0_ = _tmp2__length1 > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void tweet_class_init (TweetClass * klass) {
	tweet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tweet_set_property;
	G_OBJECT_CLASS (klass)->finalize = tweet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_RETWEETED, g_param_spec_boolean ("retweeted", "retweeted", "retweeted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_FAVORITED, g_param_spec_boolean ("favorited", "favorited", "favorited", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_AVATAR, g_param_spec_object ("avatar", "avatar", "avatar", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_HAS_INLINE_MEDIA, g_param_spec_boolean ("has-inline-media", "has-inline-media", "has-inline-media", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tweet_instance_init (Tweet * self) {
	gchar* _tmp0_ = NULL;
	self->priv = TWEET_GET_PRIVATE (self);
	self->rt_id = (gint64) 0;
	self->priv->_retweeted = FALSE;
	self->priv->_favorited = FALSE;
	_tmp0_ = g_strdup ("-1s");
	self->time_delta = _tmp0_;
	self->verified = FALSE;
	self->reply_id = (gint64) 0;
}


static void tweet_finalize (GObject* obj) {
	Tweet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET, Tweet);
	_g_free0 (self->text);
	_g_free0 (self->user_name);
	_g_free0 (self->retweeted_by);
	_g_free0 (self->rt_by_screen_name);
	_g_object_unref0 (self->inline_media);
	_g_free0 (self->time_delta);
	_g_free0 (self->avatar_url);
	_g_free0 (self->avatar_name);
	_g_free0 (self->screen_name);
	self->medias = (_vala_array_free (self->medias, self->medias_length1, (GDestroyNotify) g_object_unref), NULL);
	__g_slist_free__tweet_utils_sequence_free0_0 (self->priv->urls);
	self->mentions = (_vala_array_free (self->mentions, self->mentions_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (tweet_parent_class)->finalize (obj);
}


GType tweet_get_type (void) {
	static volatile gsize tweet_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tweet), 0, (GInstanceInitFunc) tweet_instance_init, NULL };
		GType tweet_type_id;
		tweet_type_id = g_type_register_static (G_TYPE_OBJECT, "Tweet", &g_define_type_info, 0);
		g_once_init_leave (&tweet_type_id__volatile, tweet_type_id);
	}
	return tweet_type_id__volatile;
}


static void _vala_tweet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Tweet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET, Tweet);
	switch (property_id) {
		case TWEET_RETWEETED:
		g_value_set_boolean (value, tweet_get_retweeted (self));
		break;
		case TWEET_FAVORITED:
		g_value_set_boolean (value, tweet_get_favorited (self));
		break;
		case TWEET_AVATAR:
		g_value_set_object (value, tweet_get_avatar (self));
		break;
		case TWEET_HAS_INLINE_MEDIA:
		g_value_set_boolean (value, tweet_get_has_inline_media (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tweet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Tweet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET, Tweet);
	switch (property_id) {
		case TWEET_RETWEETED:
		tweet_set_retweeted (self, g_value_get_boolean (value));
		break;
		case TWEET_FAVORITED:
		tweet_set_favorited (self, g_value_get_boolean (value));
		break;
		case TWEET_AVATAR:
		tweet_set_avatar (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



