/* HomeTimeline.c generated by valac 0.30.0, the Vala compiler
 * generated from HomeTimeline.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_ITIMELINE (itimeline_get_type ())
#define ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITIMELINE, ITimeline))
#define IS_ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITIMELINE))
#define ITIMELINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITIMELINE, ITimelineIface))

typedef struct _ITimeline ITimeline;
typedef struct _ITimelineIface ITimelineIface;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_BADGE_RADIO_TOOL_BUTTON (badge_radio_tool_button_get_type ())
#define BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButton))
#define BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))
#define IS_BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define IS_BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define BADGE_RADIO_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))

typedef struct _BadgeRadioToolButton BadgeRadioToolButton;
typedef struct _BadgeRadioToolButtonClass BadgeRadioToolButtonClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_HOME_TIMELINE (home_timeline_get_type ())
#define HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HOME_TIMELINE, HomeTimeline))
#define HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HOME_TIMELINE, HomeTimelineClass))
#define IS_HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HOME_TIMELINE))
#define IS_HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HOME_TIMELINE))
#define HOME_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HOME_TIMELINE, HomeTimelineClass))

typedef struct _HomeTimeline HomeTimeline;
typedef struct _HomeTimelineClass HomeTimelineClass;
typedef struct _HomeTimelinePrivate HomeTimelinePrivate;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;
typedef struct _MiniTweetPrivate MiniTweetPrivate;

#define TYPE_USER_IDENTITY (user_identity_get_type ())
typedef struct _UserIdentity UserIdentity;

#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

struct _ITimelineIface {
	GTypeInterface parent_iface;
	TweetListBox* (*get_tweet_list) (ITimeline* self);
	void (*set_tweet_list) (ITimeline* self, TweetListBox* value);
	gint (*get_unread_count) (ITimeline* self);
	void (*set_unread_count) (ITimeline* self, gint value);
	DeltaUpdater* (*get_delta_updater) (ITimeline* self);
	void (*set_delta_updater) (ITimeline* self, DeltaUpdater* value);
	const gchar* (*get_function) (ITimeline* self);
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	BadgeRadioToolButton* tool_button;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, Bundle* args);
	void (*on_leave) (DefaultTimeline* self);
	void (*load_newest) (DefaultTimeline* self);
	void (*load_older) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_tool_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _HomeTimeline {
	DefaultTimeline parent_instance;
	HomeTimelinePrivate * priv;
};

struct _HomeTimelineClass {
	DefaultTimelineClass parent_class;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	guint hidden_flags;
	gint64 id;
	MiniTweet* source_tweet;
	MiniTweet* retweeted_tweet;
	MiniTweet* quoted_tweet;
	gchar* avatar_url;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gchar* notification_id;
	gint64 reply_id;
	gint retweet_count;
	gint favorite_count;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _UserIdentity {
	gint64 id;
	gchar* screen_name;
	gchar* user_name;
};

struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

struct _MiniTweet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MiniTweetPrivate * priv;
	gint64 id;
	gint64 created_at;
	UserIdentity author;
	gchar* text;
	TextEntity* entities;
	gint entities_length1;
	Media** medias;
	gint medias_length1;
};

struct _MiniTweetClass {
	GTypeClass parent_class;
	void (*finalize) (MiniTweet *self);
};


static gpointer home_timeline_parent_class = NULL;
static IMessageReceiverIface* home_timeline_imessage_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType itimeline_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType badge_radio_tool_button_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType home_timeline_get_type (void) G_GNUC_CONST;
enum  {
	HOME_TIMELINE_DUMMY_PROPERTY,
	HOME_TIMELINE_FUNCTION
};
HomeTimeline* home_timeline_new (gint id, Account* account);
HomeTimeline* home_timeline_construct (GType object_type, gint id, Account* account);
DefaultTimeline* default_timeline_construct (GType object_type, gint id);
void ipage_set_account (IPage* self, Account* value);
TweetListBox* itimeline_get_tweet_list (ITimeline* self);
GType tweet_model_get_type (void) G_GNUC_CONST;
static void home_timeline_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root);
static void home_timeline_add_tweet (HomeTimeline* self, JsonNode* obj);
void default_timeline_delete_tweet (DefaultTimeline* self, gint64 tweet_id);
Account* ipage_get_account (IPage* self);
gint64 account_get_id (Account* self);
void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode);
void home_timeline_hide_tweets_from (HomeTimeline* self, gint64 user_id, guint reason);
#define TWEET_HIDDEN_AUTHOR_BLOCKED ((guint) (1 << 6))
void home_timeline_show_tweets_from (HomeTimeline* self, gint64 user_id, guint reason);
GType tweet_get_type (void) G_GNUC_CONST;
Tweet* tweet_new (void);
Tweet* tweet_construct (GType object_type);
void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
guint default_timeline_get_rt_flags (DefaultTimeline* self, Tweet* t);
gboolean account_blocked_or_muted (Account* self, gint64 user_id);
gint64 tweet_get_user_id (Tweet* self);
#define TWEET_HIDDEN_RETWEETER_BLOCKED ((guint) (1 << 7))
GType user_identity_get_type (void) G_GNUC_CONST;
UserIdentity* user_identity_dup (const UserIdentity* self);
void user_identity_free (UserIdentity* self);
void user_identity_copy (const UserIdentity* self, UserIdentity* dest);
void user_identity_destroy (UserIdentity* self);
GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
GType media_get_type (void) G_GNUC_CONST;
gboolean account_filter_matches (Account* self, Tweet* t);
#define TWEET_HIDDEN_FILTERED ((guint) (1 << 2))
gboolean settings_auto_scroll_on_new_tweets (void);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define TOP 1
gboolean scroll_widget_get_scrolled_up (ScrollWidget* self);
MainWindow* ipage_get_main_window (IPage* self);
gint main_window_get_cur_page_id (MainWindow* self);
gint ipage_get_id (IPage* self);
void tweet_set_seen (Tweet* self, gboolean value);
GtkWidget* tweet_list_box_get_first_visible_row (TweetListBox* self);
void tweet_model_add (TweetModel* self, Tweet* tweet);
gboolean tweet_get_is_hidden (Tweet* self);
void default_timeline_scroll_up (DefaultTimeline* self, Tweet* t);
gboolean tweet_get_seen (Tweet* self);
gint itimeline_get_unread_count (ITimeline* self);
void itimeline_set_unread_count (ITimeline* self, gint value);
gint settings_get_tweet_stack_count (void);
void notification_manager_notify (Account* acc, const gchar* summary, const gchar* body, const gchar* icon);
gchar* tweet_get_real_text (Tweet* self);
gchar* dirs_cache (const gchar* path);
gchar* utils_get_avatar_name (const gchar* path);
void tweet_model_toggle_flag_on_tweet (TweetModel* self, gint64 user_id, guint reason, gboolean active);
void home_timeline_hide_retweets_from (HomeTimeline* self, gint64 user_id, guint reason);
void tweet_model_toggle_flag_on_retweet (TweetModel* self, gint64 user_id, guint reason, gboolean active);
void home_timeline_show_retweets_from (HomeTimeline* self, gint64 user_id, guint reason);
static gchar* home_timeline_real_get_title (DefaultTimeline* base);
const gchar* account_get_screen_name (Account* self);
static void home_timeline_real_load_newest (DefaultTimeline* base);
void itimeline_load_newest_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void itimeline_load_newest_internal_finish (ITimeline* self, GAsyncResult* _res_);
static void __lambda91_ (HomeTimeline* self);
static void ___lambda91__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void home_timeline_real_load_older (DefaultTimeline* base);
#define BOTTOM 2
void itimeline_load_older_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void itimeline_load_older_internal_finish (ITimeline* self, GAsyncResult* _res_);
static void __lambda92_ (HomeTimeline* self);
static void ___lambda92__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void home_timeline_real_create_tool_button (DefaultTimeline* base, GtkRadioButton* group);
BadgeRadioToolButton* badge_radio_tool_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioToolButton* badge_radio_tool_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
const gchar* default_timeline_get_function (DefaultTimeline* self);
static void _vala_home_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


HomeTimeline* home_timeline_construct (GType object_type, gint id, Account* account) {
	HomeTimeline * self = NULL;
	gint _tmp0_ = 0;
	Account* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	TweetListBox* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_tmp0_ = id;
	self = (HomeTimeline*) default_timeline_construct (object_type, _tmp0_);
	_tmp1_ = account;
	ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp1_);
	_tmp2_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp3_ = _tmp2_;
	_tmp4_ = account;
	_tmp3_->account = _tmp4_;
	return self;
}


HomeTimeline* home_timeline_new (gint id, Account* account) {
	return home_timeline_construct (TYPE_HOME_TIMELINE, id, account);
}


static void home_timeline_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root) {
	HomeTimeline * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_TWEET) {
		JsonNode* _tmp1_ = NULL;
		_tmp1_ = root;
		home_timeline_add_tweet (self, _tmp1_);
	} else {
		StreamMessageType _tmp2_ = 0;
		_tmp2_ = type;
		if (_tmp2_ == STREAM_MESSAGE_TYPE_DELETE) {
			gint64 id = 0LL;
			JsonNode* _tmp3_ = NULL;
			JsonObject* _tmp4_ = NULL;
			JsonObject* _tmp5_ = NULL;
			JsonObject* _tmp6_ = NULL;
			gint64 _tmp7_ = 0LL;
			gint64 _tmp8_ = 0LL;
			_tmp3_ = root;
			_tmp4_ = json_node_get_object (_tmp3_);
			_tmp5_ = json_object_get_object_member (_tmp4_, "delete");
			_tmp6_ = json_object_get_object_member (_tmp5_, "status");
			_tmp7_ = json_object_get_int_member (_tmp6_, "id");
			id = _tmp7_;
			_tmp8_ = id;
			default_timeline_delete_tweet (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp8_);
		} else {
			StreamMessageType _tmp9_ = 0;
			_tmp9_ = type;
			if (_tmp9_ == STREAM_MESSAGE_TYPE_EVENT_FAVORITE) {
				gint64 id = 0LL;
				JsonNode* _tmp10_ = NULL;
				JsonObject* _tmp11_ = NULL;
				JsonObject* _tmp12_ = NULL;
				gint64 _tmp13_ = 0LL;
				gint64 source_id = 0LL;
				JsonNode* _tmp14_ = NULL;
				JsonObject* _tmp15_ = NULL;
				JsonObject* _tmp16_ = NULL;
				gint64 _tmp17_ = 0LL;
				gint64 _tmp18_ = 0LL;
				Account* _tmp19_ = NULL;
				Account* _tmp20_ = NULL;
				gint64 _tmp21_ = 0LL;
				gint64 _tmp22_ = 0LL;
				_tmp10_ = root;
				_tmp11_ = json_node_get_object (_tmp10_);
				_tmp12_ = json_object_get_object_member (_tmp11_, "target_object");
				_tmp13_ = json_object_get_int_member (_tmp12_, "id");
				id = _tmp13_;
				_tmp14_ = root;
				_tmp15_ = json_node_get_object (_tmp14_);
				_tmp16_ = json_object_get_object_member (_tmp15_, "source");
				_tmp17_ = json_object_get_int_member (_tmp16_, "id");
				source_id = _tmp17_;
				_tmp18_ = source_id;
				_tmp19_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
				_tmp20_ = _tmp19_;
				_tmp21_ = account_get_id (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp18_ == _tmp22_) {
					gint64 _tmp23_ = 0LL;
					_tmp23_ = id;
					default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp23_, TRUE);
				}
			} else {
				StreamMessageType _tmp24_ = 0;
				_tmp24_ = type;
				if (_tmp24_ == STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE) {
					gint64 id = 0LL;
					JsonNode* _tmp25_ = NULL;
					JsonObject* _tmp26_ = NULL;
					JsonObject* _tmp27_ = NULL;
					gint64 _tmp28_ = 0LL;
					gint64 source_id = 0LL;
					JsonNode* _tmp29_ = NULL;
					JsonObject* _tmp30_ = NULL;
					JsonObject* _tmp31_ = NULL;
					gint64 _tmp32_ = 0LL;
					gint64 _tmp33_ = 0LL;
					Account* _tmp34_ = NULL;
					Account* _tmp35_ = NULL;
					gint64 _tmp36_ = 0LL;
					gint64 _tmp37_ = 0LL;
					_tmp25_ = root;
					_tmp26_ = json_node_get_object (_tmp25_);
					_tmp27_ = json_object_get_object_member (_tmp26_, "target_object");
					_tmp28_ = json_object_get_int_member (_tmp27_, "id");
					id = _tmp28_;
					_tmp29_ = root;
					_tmp30_ = json_node_get_object (_tmp29_);
					_tmp31_ = json_object_get_object_member (_tmp30_, "source");
					_tmp32_ = json_object_get_int_member (_tmp31_, "id");
					source_id = _tmp32_;
					_tmp33_ = source_id;
					_tmp34_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
					_tmp35_ = _tmp34_;
					_tmp36_ = account_get_id (_tmp35_);
					_tmp37_ = _tmp36_;
					if (_tmp33_ == _tmp37_) {
						gint64 _tmp38_ = 0LL;
						_tmp38_ = id;
						default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp38_, FALSE);
					}
				} else {
					StreamMessageType _tmp39_ = 0;
					_tmp39_ = type;
					if (_tmp39_ == STREAM_MESSAGE_TYPE_EVENT_BLOCK) {
						gint64 user_id = 0LL;
						JsonNode* _tmp40_ = NULL;
						JsonObject* _tmp41_ = NULL;
						JsonObject* _tmp42_ = NULL;
						gint64 _tmp43_ = 0LL;
						gint64 _tmp44_ = 0LL;
						_tmp40_ = root;
						_tmp41_ = json_node_get_object (_tmp40_);
						_tmp42_ = json_object_get_object_member (_tmp41_, "target");
						_tmp43_ = json_object_get_int_member (_tmp42_, "id");
						user_id = _tmp43_;
						_tmp44_ = user_id;
						home_timeline_hide_tweets_from (self, _tmp44_, TWEET_HIDDEN_AUTHOR_BLOCKED);
					} else {
						StreamMessageType _tmp45_ = 0;
						_tmp45_ = type;
						if (_tmp45_ == STREAM_MESSAGE_TYPE_EVENT_UNBLOCK) {
							gint64 user_id = 0LL;
							JsonNode* _tmp46_ = NULL;
							JsonObject* _tmp47_ = NULL;
							JsonObject* _tmp48_ = NULL;
							gint64 _tmp49_ = 0LL;
							gint64 _tmp50_ = 0LL;
							_tmp46_ = root;
							_tmp47_ = json_node_get_object (_tmp46_);
							_tmp48_ = json_object_get_object_member (_tmp47_, "target");
							_tmp49_ = json_object_get_int_member (_tmp48_, "id");
							user_id = _tmp49_;
							_tmp50_ = user_id;
							home_timeline_show_tweets_from (self, _tmp50_, TWEET_HIDDEN_AUTHOR_BLOCKED);
						}
					}
				}
			}
		}
	}
}


static void home_timeline_add_tweet (HomeTimeline* self, JsonNode* obj) {
	GDateTime* now = NULL;
	GDateTime* _tmp0_ = NULL;
	Tweet* t = NULL;
	Tweet* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	JsonNode* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	Account* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	Tweet* _tmp7_ = NULL;
	MiniTweet* _tmp8_ = NULL;
	Account* _tmp14_ = NULL;
	Account* _tmp15_ = NULL;
	Tweet* _tmp16_ = NULL;
	gint64 _tmp17_ = 0LL;
	gint64 _tmp18_ = 0LL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp23_ = FALSE;
	Tweet* _tmp24_ = NULL;
	MiniTweet* _tmp25_ = NULL;
	Account* _tmp36_ = NULL;
	Account* _tmp37_ = NULL;
	Tweet* _tmp38_ = NULL;
	gboolean _tmp39_ = FALSE;
	gboolean auto_scroll = FALSE;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	Tweet* _tmp46_ = NULL;
	gint64 _tmp47_ = 0LL;
	gint64 _tmp48_ = 0LL;
	Account* _tmp49_ = NULL;
	Account* _tmp50_ = NULL;
	gint64 _tmp51_ = 0LL;
	gint64 _tmp52_ = 0LL;
	Tweet* _tmp75_ = NULL;
	gboolean _tmp76_ = FALSE;
	TweetListBox* _tmp77_ = NULL;
	TweetListBox* _tmp78_ = NULL;
	GtkWidget* _tmp79_ = NULL;
	GtkWidget* _tmp80_ = NULL;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	gboolean should_focus = FALSE;
	TweetListBox* _tmp86_ = NULL;
	TweetListBox* _tmp87_ = NULL;
	TweetModel* _tmp88_ = NULL;
	Tweet* _tmp89_ = NULL;
	gboolean _tmp90_ = FALSE;
	Tweet* _tmp95_ = NULL;
	gboolean _tmp96_ = FALSE;
	gboolean _tmp97_ = FALSE;
	gint stack_size = 0;
	gint _tmp104_ = 0;
	gboolean _tmp105_ = FALSE;
	Tweet* _tmp106_ = NULL;
	gint64 _tmp107_ = 0LL;
	gint64 _tmp108_ = 0LL;
	Account* _tmp109_ = NULL;
	Account* _tmp110_ = NULL;
	gint64 _tmp111_ = 0LL;
	gint64 _tmp112_ = 0LL;
	gboolean _tmp114_ = FALSE;
	gint _tmp115_ = 0;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	g_return_if_fail (obj != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = tweet_new ();
	t = _tmp1_;
	_tmp2_ = t;
	_tmp3_ = obj;
	_tmp4_ = now;
	_tmp5_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp6_ = _tmp5_;
	tweet_load_from_json (_tmp2_, _tmp3_, _tmp4_, _tmp6_);
	_tmp7_ = t;
	_tmp8_ = _tmp7_->retweeted_tweet;
	if (_tmp8_ != NULL) {
		Tweet* _tmp9_ = NULL;
		Tweet* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		Tweet* _tmp12_ = NULL;
		guint _tmp13_ = 0U;
		_tmp9_ = t;
		_tmp10_ = t;
		_tmp11_ = _tmp10_->hidden_flags;
		_tmp12_ = t;
		_tmp13_ = default_timeline_get_rt_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp12_);
		_tmp10_->hidden_flags = _tmp11_ | _tmp13_;
	}
	_tmp14_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp15_ = _tmp14_;
	_tmp16_ = t;
	_tmp17_ = tweet_get_user_id (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = account_blocked_or_muted (_tmp15_, _tmp18_);
	if (_tmp19_) {
		Tweet* _tmp20_ = NULL;
		Tweet* _tmp21_ = NULL;
		guint _tmp22_ = 0U;
		_tmp20_ = t;
		_tmp21_ = t;
		_tmp22_ = _tmp21_->hidden_flags;
		_tmp21_->hidden_flags = _tmp22_ | TWEET_HIDDEN_RETWEETER_BLOCKED;
	}
	_tmp24_ = t;
	_tmp25_ = _tmp24_->retweeted_tweet;
	if (_tmp25_ != NULL) {
		Account* _tmp26_ = NULL;
		Account* _tmp27_ = NULL;
		Tweet* _tmp28_ = NULL;
		MiniTweet* _tmp29_ = NULL;
		UserIdentity _tmp30_ = {0};
		gint64 _tmp31_ = 0LL;
		gboolean _tmp32_ = FALSE;
		_tmp26_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp27_ = _tmp26_;
		_tmp28_ = t;
		_tmp29_ = _tmp28_->retweeted_tweet;
		_tmp30_ = _tmp29_->author;
		_tmp31_ = _tmp30_.id;
		_tmp32_ = account_blocked_or_muted (_tmp27_, _tmp31_);
		_tmp23_ = _tmp32_;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		Tweet* _tmp33_ = NULL;
		Tweet* _tmp34_ = NULL;
		guint _tmp35_ = 0U;
		_tmp33_ = t;
		_tmp34_ = t;
		_tmp35_ = _tmp34_->hidden_flags;
		_tmp34_->hidden_flags = _tmp35_ | TWEET_HIDDEN_AUTHOR_BLOCKED;
	}
	_tmp36_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp37_ = _tmp36_;
	_tmp38_ = t;
	_tmp39_ = account_filter_matches (_tmp37_, _tmp38_);
	if (_tmp39_) {
		Tweet* _tmp40_ = NULL;
		Tweet* _tmp41_ = NULL;
		guint _tmp42_ = 0U;
		_tmp40_ = t;
		_tmp41_ = t;
		_tmp42_ = _tmp41_->hidden_flags;
		_tmp41_->hidden_flags = _tmp42_ | TWEET_HIDDEN_FILTERED;
	}
	_tmp43_ = settings_auto_scroll_on_new_tweets ();
	auto_scroll = _tmp43_;
	scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), TOP);
	_tmp46_ = t;
	_tmp47_ = tweet_get_user_id (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp50_ = _tmp49_;
	_tmp51_ = account_get_id (_tmp50_);
	_tmp52_ = _tmp51_;
	if (_tmp48_ == _tmp52_) {
		_tmp45_ = TRUE;
	} else {
		gboolean _tmp53_ = FALSE;
		Tweet* _tmp54_ = NULL;
		MiniTweet* _tmp55_ = NULL;
		_tmp54_ = t;
		_tmp55_ = _tmp54_->retweeted_tweet;
		if (_tmp55_ != NULL) {
			Tweet* _tmp56_ = NULL;
			MiniTweet* _tmp57_ = NULL;
			UserIdentity _tmp58_ = {0};
			gint64 _tmp59_ = 0LL;
			Account* _tmp60_ = NULL;
			Account* _tmp61_ = NULL;
			gint64 _tmp62_ = 0LL;
			gint64 _tmp63_ = 0LL;
			_tmp56_ = t;
			_tmp57_ = _tmp56_->retweeted_tweet;
			_tmp58_ = _tmp57_->author;
			_tmp59_ = _tmp58_.id;
			_tmp60_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp61_ = _tmp60_;
			_tmp62_ = account_get_id (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp53_ = _tmp59_ == _tmp63_;
		} else {
			_tmp53_ = FALSE;
		}
		_tmp45_ = _tmp53_;
	}
	if (_tmp45_) {
		_tmp44_ = TRUE;
	} else {
		gboolean _tmp64_ = FALSE;
		gboolean _tmp65_ = FALSE;
		gboolean _tmp66_ = FALSE;
		gboolean _tmp67_ = FALSE;
		_tmp66_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
		_tmp67_ = _tmp66_;
		if (_tmp67_) {
			MainWindow* _tmp68_ = NULL;
			MainWindow* _tmp69_ = NULL;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			_tmp68_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp69_ = _tmp68_;
			_tmp70_ = main_window_get_cur_page_id (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp73_ = _tmp72_;
			_tmp65_ = _tmp71_ == _tmp73_;
		} else {
			_tmp65_ = FALSE;
		}
		if (_tmp65_) {
			gboolean _tmp74_ = FALSE;
			_tmp74_ = auto_scroll;
			_tmp64_ = _tmp74_;
		} else {
			_tmp64_ = FALSE;
		}
		_tmp44_ = _tmp64_;
	}
	_tmp75_ = t;
	tweet_set_seen (_tmp75_, _tmp44_);
	_tmp77_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp78_ = _tmp77_;
	_tmp79_ = tweet_list_box_get_first_visible_row (_tmp78_);
	_tmp80_ = _tmp79_;
	g_object_get (_tmp80_, "is-focus", &_tmp81_, NULL);
	_tmp82_ = _tmp81_;
	_tmp83_ = _tmp82_;
	_g_object_unref0 (_tmp80_);
	if (_tmp83_) {
		gboolean _tmp84_ = FALSE;
		gboolean _tmp85_ = FALSE;
		_tmp84_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
		_tmp85_ = _tmp84_;
		_tmp76_ = _tmp85_;
	} else {
		_tmp76_ = FALSE;
	}
	should_focus = _tmp76_;
	_tmp86_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp87_ = _tmp86_;
	_tmp88_ = _tmp87_->model;
	_tmp89_ = t;
	tweet_model_add (_tmp88_, _tmp89_);
	_tmp90_ = should_focus;
	if (_tmp90_) {
		TweetListBox* _tmp91_ = NULL;
		TweetListBox* _tmp92_ = NULL;
		GtkWidget* _tmp93_ = NULL;
		GtkWidget* _tmp94_ = NULL;
		_tmp91_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
		_tmp92_ = _tmp91_;
		_tmp93_ = tweet_list_box_get_first_visible_row (_tmp92_);
		_tmp94_ = _tmp93_;
		gtk_widget_grab_focus (_tmp94_);
		_g_object_unref0 (_tmp94_);
	}
	_tmp95_ = t;
	_tmp96_ = tweet_get_is_hidden (_tmp95_);
	_tmp97_ = _tmp96_;
	if (!_tmp97_) {
		Tweet* _tmp98_ = NULL;
		Tweet* _tmp99_ = NULL;
		gboolean _tmp100_ = FALSE;
		gboolean _tmp101_ = FALSE;
		_tmp98_ = t;
		default_timeline_scroll_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp98_);
		_tmp99_ = t;
		_tmp100_ = tweet_get_seen (_tmp99_);
		_tmp101_ = _tmp100_;
		if (!_tmp101_) {
			gint _tmp102_ = 0;
			gint _tmp103_ = 0;
			_tmp102_ = itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
			_tmp103_ = _tmp102_;
			itimeline_set_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), _tmp103_ + 1);
		}
	}
	_tmp104_ = settings_get_tweet_stack_count ();
	stack_size = _tmp104_;
	_tmp106_ = t;
	_tmp107_ = tweet_get_user_id (_tmp106_);
	_tmp108_ = _tmp107_;
	_tmp109_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp110_ = _tmp109_;
	_tmp111_ = account_get_id (_tmp110_);
	_tmp112_ = _tmp111_;
	if (_tmp108_ == _tmp112_) {
		_tmp105_ = TRUE;
	} else {
		gboolean _tmp113_ = FALSE;
		_tmp113_ = auto_scroll;
		_tmp105_ = _tmp113_;
	}
	if (_tmp105_) {
		_g_object_unref0 (t);
		_g_date_time_unref0 (now);
		return;
	}
	_tmp115_ = stack_size;
	if (_tmp115_ == 1) {
		gboolean _tmp116_ = FALSE;
		_tmp116_ = auto_scroll;
		_tmp114_ = !_tmp116_;
	} else {
		_tmp114_ = FALSE;
	}
	if (_tmp114_) {
		gchar* summary = NULL;
		gchar* _tmp117_ = NULL;
		Tweet* _tmp118_ = NULL;
		MiniTweet* _tmp119_ = NULL;
		Account* _tmp136_ = NULL;
		Account* _tmp137_ = NULL;
		const gchar* _tmp138_ = NULL;
		Tweet* _tmp139_ = NULL;
		gchar* _tmp140_ = NULL;
		gchar* _tmp141_ = NULL;
		Tweet* _tmp142_ = NULL;
		const gchar* _tmp143_ = NULL;
		gchar* _tmp144_ = NULL;
		gchar* _tmp145_ = NULL;
		gchar* _tmp146_ = NULL;
		gchar* _tmp147_ = NULL;
		gchar* _tmp148_ = NULL;
		gchar* _tmp149_ = NULL;
		_tmp117_ = g_strdup ("");
		summary = _tmp117_;
		_tmp118_ = t;
		_tmp119_ = _tmp118_->retweeted_tweet;
		if (_tmp119_ != NULL) {
			const gchar* _tmp120_ = NULL;
			Tweet* _tmp121_ = NULL;
			MiniTweet* _tmp122_ = NULL;
			UserIdentity _tmp123_ = {0};
			const gchar* _tmp124_ = NULL;
			Tweet* _tmp125_ = NULL;
			MiniTweet* _tmp126_ = NULL;
			UserIdentity _tmp127_ = {0};
			const gchar* _tmp128_ = NULL;
			gchar* _tmp129_ = NULL;
			_tmp120_ = _ ("%s retweeted %s");
			_tmp121_ = t;
			_tmp122_ = _tmp121_->source_tweet;
			_tmp123_ = _tmp122_->author;
			_tmp124_ = _tmp123_.user_name;
			_tmp125_ = t;
			_tmp126_ = _tmp125_->retweeted_tweet;
			_tmp127_ = _tmp126_->author;
			_tmp128_ = _tmp127_.user_name;
			_tmp129_ = g_strdup_printf (_tmp120_, _tmp124_, _tmp128_);
			_g_free0 (summary);
			summary = _tmp129_;
		} else {
			const gchar* _tmp130_ = NULL;
			Tweet* _tmp131_ = NULL;
			MiniTweet* _tmp132_ = NULL;
			UserIdentity _tmp133_ = {0};
			const gchar* _tmp134_ = NULL;
			gchar* _tmp135_ = NULL;
			_tmp130_ = _ ("%s tweeted");
			_tmp131_ = t;
			_tmp132_ = _tmp131_->source_tweet;
			_tmp133_ = _tmp132_->author;
			_tmp134_ = _tmp133_.user_name;
			_tmp135_ = g_strdup_printf (_tmp130_, _tmp134_);
			_g_free0 (summary);
			summary = _tmp135_;
		}
		_tmp136_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp137_ = _tmp136_;
		_tmp138_ = summary;
		_tmp139_ = t;
		_tmp140_ = tweet_get_real_text (_tmp139_);
		_tmp141_ = _tmp140_;
		_tmp142_ = t;
		_tmp143_ = _tmp142_->avatar_url;
		_tmp144_ = utils_get_avatar_name (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = g_strconcat ("assets/avatars/", _tmp145_, NULL);
		_tmp147_ = _tmp146_;
		_tmp148_ = dirs_cache (_tmp147_);
		_tmp149_ = _tmp148_;
		notification_manager_notify (_tmp137_, _tmp138_, _tmp141_, _tmp149_);
		_g_free0 (_tmp149_);
		_g_free0 (_tmp147_);
		_g_free0 (_tmp145_);
		_g_free0 (_tmp141_);
		_g_free0 (summary);
	} else {
		gboolean _tmp150_ = FALSE;
		gboolean _tmp151_ = FALSE;
		gint _tmp152_ = 0;
		_tmp152_ = stack_size;
		if (_tmp152_ != 0) {
			gint _tmp153_ = 0;
			gint _tmp154_ = 0;
			gint _tmp155_ = 0;
			_tmp153_ = itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
			_tmp154_ = _tmp153_;
			_tmp155_ = stack_size;
			_tmp151_ = (_tmp154_ % _tmp155_) == 0;
		} else {
			_tmp151_ = FALSE;
		}
		if (_tmp151_) {
			gint _tmp156_ = 0;
			gint _tmp157_ = 0;
			_tmp156_ = itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
			_tmp157_ = _tmp156_;
			_tmp150_ = _tmp157_ > 0;
		} else {
			_tmp150_ = FALSE;
		}
		if (_tmp150_) {
			gchar* summary = NULL;
			gint _tmp158_ = 0;
			gint _tmp159_ = 0;
			const gchar* _tmp160_ = NULL;
			gint _tmp161_ = 0;
			gint _tmp162_ = 0;
			gchar* _tmp163_ = NULL;
			Account* _tmp164_ = NULL;
			Account* _tmp165_ = NULL;
			const gchar* _tmp166_ = NULL;
			_tmp158_ = itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
			_tmp159_ = _tmp158_;
			_tmp160_ = ngettext ("%d new Tweet!", "%d new Tweets!", (gulong) _tmp159_);
			_tmp161_ = itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
			_tmp162_ = _tmp161_;
			_tmp163_ = g_strdup_printf (_tmp160_, _tmp162_);
			summary = _tmp163_;
			_tmp164_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp165_ = _tmp164_;
			_tmp166_ = summary;
			notification_manager_notify (_tmp165_, _tmp166_, "", NULL);
			_g_free0 (summary);
		}
	}
	_g_object_unref0 (t);
	_g_date_time_unref0 (now);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void home_timeline_hide_tweets_from (HomeTimeline* self, gint64 user_id, guint reason) {
	TweetModel* tm = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	TweetModel* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	guint _tmp5_ = 0U;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->model;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_TWEET_MODEL, TweetModel));
	tm = _tmp3_;
	_tmp4_ = user_id;
	_tmp5_ = reason;
	tweet_model_toggle_flag_on_tweet (tm, _tmp4_, _tmp5_, TRUE);
	_g_object_unref0 (tm);
}


void home_timeline_show_tweets_from (HomeTimeline* self, gint64 user_id, guint reason) {
	TweetModel* tm = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	TweetModel* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	guint _tmp5_ = 0U;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->model;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_TWEET_MODEL, TweetModel));
	tm = _tmp3_;
	_tmp4_ = user_id;
	_tmp5_ = reason;
	tweet_model_toggle_flag_on_tweet (tm, _tmp4_, _tmp5_, FALSE);
	_g_object_unref0 (tm);
}


void home_timeline_hide_retweets_from (HomeTimeline* self, gint64 user_id, guint reason) {
	TweetModel* tm = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	TweetModel* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	guint _tmp5_ = 0U;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->model;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_TWEET_MODEL, TweetModel));
	tm = _tmp3_;
	_tmp4_ = user_id;
	_tmp5_ = reason;
	tweet_model_toggle_flag_on_retweet (tm, _tmp4_, _tmp5_, TRUE);
	_g_object_unref0 (tm);
}


void home_timeline_show_retweets_from (HomeTimeline* self, gint64 user_id, guint reason) {
	TweetModel* tm = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	TweetModel* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	guint _tmp5_ = 0U;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->model;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_TWEET_MODEL, TweetModel));
	tm = _tmp3_;
	_tmp4_ = user_id;
	_tmp5_ = reason;
	tweet_model_toggle_flag_on_retweet (tm, _tmp4_, _tmp5_, FALSE);
	_g_object_unref0 (tm);
}


static gchar* home_timeline_real_get_title (DefaultTimeline* base) {
	HomeTimeline * self;
	gchar* result = NULL;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = account_get_screen_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("@", _tmp3_, NULL);
	result = _tmp4_;
	return result;
}


static void __lambda91_ (HomeTimeline* self) {
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->loading = FALSE;
}


static void ___lambda91__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda91_ ((HomeTimeline*) self);
	g_object_unref (self);
}


static void home_timeline_real_load_newest (DefaultTimeline* base) {
	HomeTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->loading = TRUE;
	itimeline_load_newest_internal (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), ___lambda91__gasync_ready_callback, g_object_ref (self));
}


static void __lambda92_ (HomeTimeline* self) {
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->loading = FALSE;
}


static void ___lambda92__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda92_ ((HomeTimeline*) self);
	g_object_unref (self);
}


static void home_timeline_real_load_older (DefaultTimeline* base) {
	HomeTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), BOTTOM);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->loading = TRUE;
	itimeline_load_older_internal (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), ___lambda92__gasync_ready_callback, g_object_ref (self));
}


static void home_timeline_real_create_tool_button (DefaultTimeline* base, GtkRadioButton* group) {
	HomeTimeline * self;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	BadgeRadioToolButton* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = _ ("Home");
	_tmp2_ = badge_radio_tool_button_new (_tmp0_, "user-home-symbolic", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tool_button);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tool_button = _tmp2_;
}


static const gchar* home_timeline_real_get_function (DefaultTimeline* base) {
	const gchar* result;
	HomeTimeline* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	result = "1.1/statuses/home_timeline.json";
	return result;
}


static void home_timeline_class_init (HomeTimelineClass * klass) {
	home_timeline_parent_class = g_type_class_peek_parent (klass);
	((DefaultTimelineClass *) klass)->get_title = home_timeline_real_get_title;
	((DefaultTimelineClass *) klass)->load_newest = home_timeline_real_load_newest;
	((DefaultTimelineClass *) klass)->load_older = home_timeline_real_load_older;
	((DefaultTimelineClass *) klass)->create_tool_button = home_timeline_real_create_tool_button;
	DEFAULT_TIMELINE_CLASS (klass)->get_function = home_timeline_real_get_function;
	G_OBJECT_CLASS (klass)->get_property = _vala_home_timeline_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), HOME_TIMELINE_FUNCTION, g_param_spec_string ("function", "function", "function", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void home_timeline_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	home_timeline_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) home_timeline_real_stream_message_received;
}


static void home_timeline_instance_init (HomeTimeline * self) {
}


GType home_timeline_get_type (void) {
	static volatile gsize home_timeline_type_id__volatile = 0;
	if (g_once_init_enter (&home_timeline_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HomeTimelineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) home_timeline_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HomeTimeline), 0, (GInstanceInitFunc) home_timeline_instance_init, NULL };
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) home_timeline_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType home_timeline_type_id;
		home_timeline_type_id = g_type_register_static (TYPE_DEFAULT_TIMELINE, "HomeTimeline", &g_define_type_info, 0);
		g_type_add_interface_static (home_timeline_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&home_timeline_type_id__volatile, home_timeline_type_id);
	}
	return home_timeline_type_id__volatile;
}


static void _vala_home_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	HomeTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HOME_TIMELINE, HomeTimeline);
	switch (property_id) {
		case HOME_TIMELINE_FUNCTION:
		g_value_set_string (value, default_timeline_get_function (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



