/* MainWindow.c generated by valac 0.30.0, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ADD_LIST_ENTRY (add_list_entry_get_type ())
#define ADD_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_LIST_ENTRY, AddListEntry))
#define ADD_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_LIST_ENTRY, AddListEntryClass))
#define IS_ADD_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_LIST_ENTRY))
#define IS_ADD_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_LIST_ENTRY))
#define ADD_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_LIST_ENTRY, AddListEntryClass))

typedef struct _AddListEntry AddListEntry;
typedef struct _AddListEntryClass AddListEntryClass;

#define TYPE_USER_LIST_ENTRY (user_list_entry_get_type ())
#define USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_ENTRY, UserListEntry))
#define USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_ENTRY, UserListEntryClass))
#define IS_USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_ENTRY))
#define IS_USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_ENTRY))
#define USER_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_ENTRY, UserListEntryClass))

typedef struct _UserListEntry UserListEntry;
typedef struct _UserListEntryClass UserListEntryClass;

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_PAGE (page_get_type ())
typedef struct _Block2Data Block2Data;

#define TYPE_ACCOUNT_CREATE_WIDGET (account_create_widget_get_type ())
#define ACCOUNT_CREATE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidget))
#define ACCOUNT_CREATE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidgetClass))
#define IS_ACCOUNT_CREATE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_CREATE_WIDGET))
#define IS_ACCOUNT_CREATE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_CREATE_WIDGET))
#define ACCOUNT_CREATE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidgetClass))

typedef struct _AccountCreateWidget AccountCreateWidget;
typedef struct _AccountCreateWidgetClass AccountCreateWidgetClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;

#define TYPE_ACCOUNT_DIALOG (account_dialog_get_type ())
#define ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_DIALOG, AccountDialog))
#define ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_DIALOG, AccountDialogClass))
#define IS_ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_DIALOG))
#define IS_ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_DIALOG))
#define ACCOUNT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_DIALOG, AccountDialogClass))

typedef struct _AccountDialog AccountDialog;
typedef struct _AccountDialogClass AccountDialogClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define TYPE_ITIMELINE (itimeline_get_type ())
#define ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITIMELINE, ITimeline))
#define IS_ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITIMELINE))
#define ITIMELINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITIMELINE, ITimelineIface))

typedef struct _ITimeline ITimeline;
typedef struct _ITimelineIface ITimelineIface;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MainWindowPrivate {
	GtkHeaderBar* headerbar;
	AvatarWidget* avatar_image;
	GtkListBox* account_list;
	GtkPopover* account_popover;
	GtkBox* header_box;
	GtkToggleButton* account_button;
	GtkMenuButton* app_menu_button;
	Account* _account;
	ComposeTweetWindow* compose_tweet_window;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block2Data {
	int _ref_count_;
	MainWindow* self;
	Account* account;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _ITimelineIface {
	GTypeInterface parent_iface;
	TweetListBox* (*get_tweet_list) (ITimeline* self);
	void (*set_tweet_list) (ITimeline* self, TweetListBox* value);
	gint (*get_unread_count) (ITimeline* self);
	void (*set_unread_count) (ITimeline* self, gint value);
	DeltaUpdater* (*get_delta_updater) (ITimeline* self);
	void (*set_delta_updater) (ITimeline* self, DeltaUpdater* value);
	const gchar* (*get_function) (ITimeline* self);
};


static gpointer main_window_parent_class = NULL;
extern GMenu* corebird_account_menu;

GType main_window_get_type (void) G_GNUC_CONST;
GType main_widget_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW, MainWindowPrivate))
enum  {
	MAIN_WINDOW_DUMMY_PROPERTY,
	MAIN_WINDOW_ACCOUNT,
	MAIN_WINDOW_CUR_PAGE_ID
};
static void main_window_show_hide_compose_window (MainWindow* self);
static void _main_window_show_hide_compose_window_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void settings_toggle_sidebar_visible (void);
static void _settings_toggle_sidebar_visible_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_simple_switch_page (MainWindow* self, GSimpleAction* a, GVariant* param);
static void _main_window_simple_switch_page_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_show_account_dialog (MainWindow* self);
static void _main_window_show_account_dialog_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_show_account_list (MainWindow* self);
static void _main_window_show_account_list_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
MainWindow* main_window_new (GtkApplication* app, Account* account);
MainWindow* main_window_construct (GType object_type, GtkApplication* app, Account* account);
void main_window_change_account (MainWindow* self, Account* account, GApplication* app);
static gint main_window_account_sort_func (MainWindow* self, GtkListBoxRow* a, GtkListBoxRow* b);
static gint _main_window_account_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
GType add_list_entry_get_type (void) G_GNUC_CONST;
AddListEntry* add_list_entry_new (const gchar* label);
AddListEntry* add_list_entry_construct (GType object_type, const gchar* label);
GSList* account_list_accounts (void);
const gchar* account_get_screen_name (Account* self);
#define ACCOUNT_DUMMY "screen_name"
GType user_list_entry_get_type (void) G_GNUC_CONST;
UserListEntry* user_list_entry_new_from_account (Account* acc);
UserListEntry* user_list_entry_construct_from_account (GType object_type, Account* acc);
void user_list_entry_set_show_settings (UserListEntry* self, gboolean value);
static void ____lambda205_ (MainWindow* self);
static void _____lambda205__user_list_entry_action_clicked (UserListEntry* _sender, gpointer self);
GType corebird_get_type (void) G_GNUC_CONST;
static void __lambda206_ (MainWindow* self, Account* new_acc);
gchar* user_list_entry_get_screen_name (UserListEntry* self);
static void __lambda207_ (MainWindow* self);
static void ___lambda207__user_list_entry_action_clicked (UserListEntry* _sender, gpointer self);
static void ___lambda206__corebird_account_added (Corebird* _sender, Account* acc, gpointer self);
static void __lambda208_ (MainWindow* self, Account* acc);
static void ___lambda208__corebird_account_removed (Corebird* _sender, Account* acc, gpointer self);
static gboolean __lambda209_ (MainWindow* self, GdkEventKey* evt);
GType bundle_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
IPage* main_widget_get_page (MainWidget* self, gint page_id);
gint main_widget_get_cur_page_id (MainWidget* self);
static gboolean ___lambda209__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void main_window_add_accels (MainWindow* self);
static void main_window_load_geometry (MainWindow* self);
static gboolean __lambda210_ (MainWindow* self);
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static gboolean ___lambda210__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda211_ (MainWindow* self);
static gboolean ___lambda211__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda212_ (MainWindow* self);
static gboolean ___lambda212__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda213_ (MainWindow* self);
static gboolean ___lambda213__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static void main_window_back_button_clicked_cb (MainWindow* self);
static void _main_window_back_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
Account* main_window_get_account (MainWindow* self);
gint64 account_get_id (Account* self);
static gint64* _int64_dup (gint64* self);
static void main_window_account_info_changed (MainWindow* self, const gchar* screen_name, const gchar* name, cairo_surface_t* small_avatar, cairo_surface_t* avatar);
static void _main_window_account_info_changed_account_info_changed (Account* _sender, const gchar* screen_name, const gchar* name, cairo_surface_t* avatar_small, cairo_surface_t* avatar, gpointer self);
static void main_window_set_account_app_menu_sensitivity (MainWindow* self, gboolean sensitivity);
static void main_window_set_account (MainWindow* self, Account* value);
void main_widget_stop (MainWidget* self);
MainWidget* main_widget_new (Account* account, MainWindow* parent, Corebird* app);
MainWidget* main_widget_construct (GType object_type, Account* account, MainWindow* parent, Corebird* app);
gchar* ipage_get_title (IPage* self);
cairo_surface_t* account_get_avatar_small (Account* self);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static void ___lambda163_ (Block2Data* _data2_);
static void ____lambda163__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
Account* account_new (gint64 id, const gchar* screen_name, const gchar* name);
Account* account_construct (GType object_type, gint64 id, const gchar* screen_name, const gchar* name);
void account_add_account (Account* acc);
GType account_create_widget_get_type (void) G_GNUC_CONST;
AccountCreateWidget* account_create_widget_new (Account* acc, Corebird* corebird);
AccountCreateWidget* account_create_widget_construct (GType object_type, Account* acc, Corebird* corebird);
static void ___lambda166_ (MainWindow* self, gboolean _result_, Account* acc);
static void ____lambda166__account_create_widget_result_received (AccountCreateWidget* _sender, gboolean _result_, Account* acc, gpointer self);
static void main_window_account_row_activated_cb (MainWindow* self, GtkListBoxRow* row);
gint64 user_list_entry_get_user_id (UserListEntry* self);
gboolean corebird_is_window_open_for_user_id (Corebird* self, gint64 user_id, MainWindow** window);
Account* account_query_account_by_id (gint64 id);
static void _main_window_account_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static gboolean main_window_button_press_event_cb (MainWindow* self, GdkEventButton* evt);
static gboolean _main_window_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode);
static void ___lambda203_ (MainWindow* self);
static void ____lambda203__gtk_widget_hide (GtkWidget* _sender, gpointer self);
static void ___lambda204_ (MainWindow* self);
static void ____lambda204__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
GType account_dialog_get_type (void) G_GNUC_CONST;
AccountDialog* account_dialog_new (Account* account);
AccountDialog* account_dialog_construct (GType object_type, Account* account);
IPage* main_window_get_page (MainWindow* self, gint page_id);
static void main_window_account_button_clicked_cb (MainWindow* self);
static void _main_window_account_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void main_window_account_popover_closed_cb (MainWindow* self);
static void _main_window_account_popover_closed_cb_gtk_popover_closed (GtkPopover* _sender, gpointer self);
static gboolean main_window_window_delete_cb (MainWindow* self, GdkEventAny* evt);
GSettings* settings_get (void);
void main_window_save_geometry (MainWindow* self);
static gboolean _main_window_window_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
void main_window_rerun_filters (MainWindow* self);
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType itimeline_get_type (void) G_GNUC_CONST;
void itimeline_rerun_filters (ITimeline* self);
gint main_window_get_cur_page_id (MainWindow* self);
static void main_window_finalize (GObject* obj);
static void _vala_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry MAIN_WINDOW_win_entries[5] = {{"compose-tweet", _main_window_show_hide_compose_window_gsimple_action_activate_callback}, {"toggle-sidebar", _settings_toggle_sidebar_visible_gsimple_action_activate_callback}, {"switch-page", _main_window_simple_switch_page_gsimple_action_activate_callback, "i"}, {"show-account-dialog", _main_window_show_account_dialog_gsimple_action_activate_callback}, {"show-account-list", _main_window_show_account_list_gsimple_action_activate_callback}};

static void _main_window_show_hide_compose_window_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_show_hide_compose_window ((MainWindow*) self);
}


static void _settings_toggle_sidebar_visible_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	settings_toggle_sidebar_visible ();
}


static void _main_window_simple_switch_page_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_simple_switch_page ((MainWindow*) self, action, parameter);
}


static void _main_window_show_account_dialog_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_show_account_dialog ((MainWindow*) self);
}


static void _main_window_show_account_list_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_show_account_list ((MainWindow*) self);
}


static gint _main_window_account_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = main_window_account_sort_func ((MainWindow*) self, row1, row2);
	return result;
}


static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	default_header_func (row, before);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ____lambda205_ (MainWindow* self) {
	GtkPopover* _tmp0_ = NULL;
	_tmp0_ = self->priv->account_popover;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
}


static void _____lambda205__user_list_entry_action_clicked (UserListEntry* _sender, gpointer self) {
	____lambda205_ ((MainWindow*) self);
}


static void __lambda207_ (MainWindow* self) {
	GtkPopover* _tmp0_ = NULL;
	_tmp0_ = self->priv->account_popover;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
}


static void ___lambda207__user_list_entry_action_clicked (UserListEntry* _sender, gpointer self) {
	__lambda207_ ((MainWindow*) self);
}


static void __lambda206_ (MainWindow* self, Account* new_acc) {
	GList* entries = NULL;
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	UserListEntry* ule = NULL;
	Account* _tmp13_ = NULL;
	UserListEntry* _tmp14_ = NULL;
	UserListEntry* _tmp15_ = NULL;
	UserListEntry* _tmp16_ = NULL;
	GtkListBox* _tmp17_ = NULL;
	UserListEntry* _tmp18_ = NULL;
	UserListEntry* _tmp19_ = NULL;
	g_return_if_fail (IS_ACCOUNT (new_acc));
	_tmp0_ = self->priv->account_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	entries = _tmp1_;
	_tmp2_ = entries;
	{
		GList* ule_collection = NULL;
		GList* ule_it = NULL;
		ule_collection = _tmp2_;
		for (ule_it = ule_collection; ule_it != NULL; ule_it = ule_it->next) {
			GtkWidget* _tmp3_ = NULL;
			GtkWidget* ule = NULL;
			_tmp3_ = _g_object_ref0 ((GtkWidget*) ule_it->data);
			ule = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				GtkWidget* _tmp5_ = NULL;
				_tmp5_ = ule;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_USER_LIST_ENTRY)) {
					Account* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					GtkWidget* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					_tmp6_ = new_acc;
					_tmp7_ = account_get_screen_name (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = ule;
					_tmp10_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_USER_LIST_ENTRY, UserListEntry));
					_tmp11_ = _tmp10_;
					_tmp12_ = _tmp11_;
					_tmp4_ = g_strcmp0 (_tmp8_, _tmp12_) == 0;
					_g_free0 (_tmp12_);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					_g_object_unref0 (ule);
					_g_list_free0 (entries);
					return;
				}
				_g_object_unref0 (ule);
			}
		}
	}
	_tmp13_ = new_acc;
	_tmp14_ = user_list_entry_new_from_account (_tmp13_);
	g_object_ref_sink (_tmp14_);
	ule = _tmp14_;
	_tmp15_ = ule;
	user_list_entry_set_show_settings (_tmp15_, TRUE);
	_tmp16_ = ule;
	g_signal_connect_object (_tmp16_, "action-clicked", (GCallback) ___lambda207__user_list_entry_action_clicked, self, 0);
	_tmp17_ = self->priv->account_list;
	_tmp18_ = ule;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
	_tmp19_ = ule;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ule);
	_g_list_free0 (entries);
}


static void ___lambda206__corebird_account_added (Corebird* _sender, Account* acc, gpointer self) {
	__lambda206_ ((MainWindow*) self, acc);
}


static void __lambda208_ (MainWindow* self, Account* acc) {
	GList* entries = NULL;
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	g_return_if_fail (IS_ACCOUNT (acc));
	_tmp0_ = self->priv->account_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	entries = _tmp1_;
	_tmp2_ = entries;
	{
		GList* ule_collection = NULL;
		GList* ule_it = NULL;
		ule_collection = _tmp2_;
		for (ule_it = ule_collection; ule_it != NULL; ule_it = ule_it->next) {
			GtkWidget* _tmp3_ = NULL;
			GtkWidget* ule = NULL;
			_tmp3_ = _g_object_ref0 ((GtkWidget*) ule_it->data);
			ule = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				GtkWidget* _tmp5_ = NULL;
				_tmp5_ = ule;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_USER_LIST_ENTRY)) {
					Account* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					GtkWidget* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					_tmp6_ = acc;
					_tmp7_ = account_get_screen_name (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = ule;
					_tmp10_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_USER_LIST_ENTRY, UserListEntry));
					_tmp11_ = _tmp10_;
					_tmp12_ = _tmp11_;
					_tmp4_ = g_strcmp0 (_tmp8_, _tmp12_) == 0;
					_g_free0 (_tmp12_);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					GtkListBox* _tmp13_ = NULL;
					GtkWidget* _tmp14_ = NULL;
					_tmp13_ = self->priv->account_list;
					_tmp14_ = ule;
					gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_container_get_type (), GtkContainer), _tmp14_);
					_g_object_unref0 (ule);
					break;
				}
				_g_object_unref0 (ule);
			}
		}
	}
	_g_list_free0 (entries);
}


static void ___lambda208__corebird_account_removed (Corebird* _sender, Account* acc, gpointer self) {
	__lambda208_ ((MainWindow*) self, acc);
}


static gboolean __lambda209_ (MainWindow* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Down)) {
		MainWidget* _tmp3_ = NULL;
		_tmp3_ = self->main_widget;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		MainWidget* _tmp4_ = NULL;
		MainWidget* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		IPage* _tmp8_ = NULL;
		IPage* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp4_ = self->main_widget;
		_tmp5_ = self->main_widget;
		_tmp6_ = main_widget_get_cur_page_id (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = main_widget_get_page (_tmp4_, _tmp7_);
		_tmp9_ = _tmp8_;
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), "focus", GTK_DIR_RIGHT, &_tmp10_);
		_g_object_unref0 (_tmp9_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda209__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = __lambda209_ ((MainWindow*) self, event);
	return result;
}


MainWindow* main_window_construct (GType object_type, GtkApplication* app, Account* account) {
	MainWindow * self = NULL;
	Account* _tmp0_ = NULL;
	GtkApplication* _tmp1_ = NULL;
	GtkListBox* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	AddListEntry* add_entry = NULL;
	const gchar* _tmp4_ = NULL;
	AddListEntry* _tmp5_ = NULL;
	AddListEntry* _tmp6_ = NULL;
	GtkListBox* _tmp7_ = NULL;
	AddListEntry* _tmp8_ = NULL;
	GSList* _tmp9_ = NULL;
	GtkApplication* _tmp20_ = NULL;
	GtkApplication* _tmp21_ = NULL;
	GtkHeaderBar* _tmp22_ = NULL;
	g_return_val_if_fail (GTK_IS_APPLICATION (app), NULL);
	g_return_val_if_fail ((account == NULL) || IS_ACCOUNT (account), NULL);
	self = (MainWindow*) g_object_new (object_type, NULL);
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), 480, 700);
	_tmp0_ = account;
	_tmp1_ = app;
	main_window_change_account (self, _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_application_get_type (), GApplication));
	_tmp2_ = self->priv->account_list;
	gtk_list_box_set_sort_func (_tmp2_, _main_window_account_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp3_ = self->priv->account_list;
	gtk_list_box_set_header_func (_tmp3_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp4_ = _ ("Add new Account");
	_tmp5_ = add_list_entry_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	add_entry = _tmp5_;
	_tmp6_ = add_entry;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = self->priv->account_list;
	_tmp8_ = add_entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = account_list_accounts ();
	{
		GSList* acc_collection = NULL;
		GSList* acc_it = NULL;
		acc_collection = _tmp9_;
		for (acc_it = acc_collection; acc_it != NULL; acc_it = acc_it->next) {
			Account* _tmp10_ = NULL;
			Account* acc = NULL;
			_tmp10_ = _g_object_ref0 ((Account*) acc_it->data);
			acc = _tmp10_;
			{
				Account* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				UserListEntry* e = NULL;
				Account* _tmp14_ = NULL;
				UserListEntry* _tmp15_ = NULL;
				UserListEntry* _tmp16_ = NULL;
				UserListEntry* _tmp17_ = NULL;
				GtkListBox* _tmp18_ = NULL;
				UserListEntry* _tmp19_ = NULL;
				_tmp11_ = acc;
				_tmp12_ = account_get_screen_name (_tmp11_);
				_tmp13_ = _tmp12_;
				if (g_strcmp0 (_tmp13_, ACCOUNT_DUMMY) == 0) {
					_g_object_unref0 (acc);
					continue;
				}
				_tmp14_ = acc;
				_tmp15_ = user_list_entry_new_from_account (_tmp14_);
				g_object_ref_sink (_tmp15_);
				e = _tmp15_;
				_tmp16_ = e;
				user_list_entry_set_show_settings (_tmp16_, TRUE);
				_tmp17_ = e;
				g_signal_connect_object (_tmp17_, "action-clicked", (GCallback) _____lambda205__user_list_entry_action_clicked, self, 0);
				_tmp18_ = self->priv->account_list;
				_tmp19_ = e;
				gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (e);
				_g_object_unref0 (acc);
			}
		}
	}
	_tmp20_ = app;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_COREBIRD, Corebird), "account-added", (GCallback) ___lambda206__corebird_account_added, self, 0);
	_tmp21_ = app;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_COREBIRD, Corebird), "account-removed", (GCallback) ___lambda208__corebird_account_removed, self, 0);
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), MAIN_WINDOW_win_entries, G_N_ELEMENTS (MAIN_WINDOW_win_entries), self);
	_tmp22_ = self->priv->headerbar;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) ___lambda209__gtk_widget_key_press_event, self, 0);
	main_window_add_accels (self);
	main_window_load_geometry (self);
	_g_object_unref0 (add_entry);
	return self;
}


MainWindow* main_window_new (GtkApplication* app, Account* account) {
	return main_window_construct (TYPE_MAIN_WINDOW, app, account);
}


/**
   * Adds the accelerators to the GtkWindow
   */
static gboolean __lambda210_ (MainWindow* self) {
	gboolean result = FALSE;
	MainWidget* _tmp0_ = NULL;
	_tmp0_ = self->main_widget;
	main_widget_switch_page (_tmp0_, (gint) PAGE_PREVIOUS, NULL);
	result = TRUE;
	return result;
}


static gboolean ___lambda210__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda210_ ((MainWindow*) self);
	return result;
}


static gboolean __lambda211_ (MainWindow* self) {
	gboolean result = FALSE;
	MainWidget* _tmp0_ = NULL;
	_tmp0_ = self->main_widget;
	main_widget_switch_page (_tmp0_, (gint) PAGE_NEXT, NULL);
	result = TRUE;
	return result;
}


static gboolean ___lambda211__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda211_ ((MainWindow*) self);
	return result;
}


static gboolean __lambda212_ (MainWindow* self) {
	gboolean result = FALSE;
	MainWidget* _tmp0_ = NULL;
	_tmp0_ = self->main_widget;
	main_widget_switch_page (_tmp0_, (gint) PAGE_PREVIOUS, NULL);
	result = TRUE;
	return result;
}


static gboolean ___lambda212__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda212_ ((MainWindow*) self);
	return result;
}


static gboolean __lambda213_ (MainWindow* self) {
	gboolean result = FALSE;
	MainWidget* _tmp0_ = NULL;
	_tmp0_ = self->main_widget;
	main_widget_switch_page (_tmp0_, (gint) PAGE_NEXT, NULL);
	result = TRUE;
	return result;
}


static gboolean ___lambda213__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda213_ ((MainWindow*) self);
	return result;
}


static void main_window_add_accels (MainWindow* self) {
	GtkAccelGroup* ag = NULL;
	GtkAccelGroup* _tmp0_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = gtk_accel_group_new ();
	ag = _tmp0_;
	gtk_accel_group_connect (ag, (guint) GDK_KEY_Left, GDK_MOD1_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda210__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda210__gtk_accel_group_activate, g_object_ref (self), g_object_unref)));
	gtk_accel_group_connect (ag, (guint) GDK_KEY_Right, GDK_MOD1_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda211__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda211__gtk_accel_group_activate, g_object_ref (self), g_object_unref)));
	gtk_accel_group_connect (ag, (guint) GDK_KEY_Back, 0, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda212__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda212__gtk_accel_group_activate, g_object_ref (self), g_object_unref)));
	gtk_accel_group_connect (ag, (guint) GDK_KEY_Forward, 0, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda213__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda213__gtk_accel_group_activate, g_object_ref (self), g_object_unref)));
	gtk_window_add_accel_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), ag);
	_g_object_unref0 (ag);
}


static void main_window_back_button_clicked_cb (MainWindow* self) {
	MainWidget* _tmp0_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->main_widget;
	main_widget_switch_page (_tmp0_, (gint) PAGE_PREVIOUS, NULL);
}


static void _main_window_back_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	main_window_back_button_clicked_cb ((MainWindow*) self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		MainWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->account);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gint64* _int64_dup (gint64* self) {
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}


static gpointer __int64_dup0 (gpointer self) {
	return self ? _int64_dup (self) : NULL;
}


static void _main_window_account_info_changed_account_info_changed (Account* _sender, const gchar* screen_name, const gchar* name, cairo_surface_t* avatar_small, cairo_surface_t* avatar, gpointer self) {
	main_window_account_info_changed ((MainWindow*) self, screen_name, name, avatar_small, avatar);
}


static void ___lambda163_ (Block2Data* _data2_) {
	MainWindow* self;
	AvatarWidget* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	self = _data2_->self;
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = _data2_->account;
	_tmp2_ = account_get_avatar_small (_tmp1_);
	_tmp3_ = _tmp2_;
	avatar_widget_set_surface (_tmp0_, _tmp3_);
}


static void ____lambda163__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda163_ (self);
}


static void ___lambda166_ (MainWindow* self, gboolean _result_, Account* acc) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_ACCOUNT (acc));
	_tmp0_ = _result_;
	if (_tmp0_) {
		Account* _tmp1_ = NULL;
		GApplication* _tmp2_ = NULL;
		_tmp1_ = acc;
		_tmp2_ = g_application_get_default ();
		main_window_change_account (self, _tmp1_, _tmp2_);
	} else {
	}
}


static void ____lambda166__account_create_widget_result_received (AccountCreateWidget* _sender, gboolean _result_, Account* acc, gpointer self) {
	___lambda166_ ((MainWindow*) self, _result_, acc);
}


void main_window_change_account (MainWindow* self, Account* account, GApplication* app) {
	Block2Data* _data2_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	gint64* old_user_id = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp9_ = NULL;
	MainWidget* _tmp10_ = NULL;
	GtkWidget* _tmp12_ = NULL;
	GtkBox* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	Corebird* cb = NULL;
	GApplication* _tmp18_ = NULL;
	Corebird* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	Account* _tmp21_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail ((account == NULL) || IS_ACCOUNT (account));
	g_return_if_fail (G_IS_APPLICATION (app));
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data2_->account);
	_data2_->account = _tmp1_;
	old_user_id = NULL;
	_tmp2_ = self->priv->_account;
	if (_tmp2_ != NULL) {
		Account* _tmp3_ = NULL;
		gint64 _tmp4_ = 0LL;
		gint64 _tmp5_ = 0LL;
		gint64* _tmp6_ = NULL;
		Account* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		_tmp3_ = self->priv->_account;
		_tmp4_ = account_get_id (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = __int64_dup0 (&_tmp5_);
		_g_free0 (old_user_id);
		old_user_id = _tmp6_;
		_tmp7_ = self->priv->_account;
		g_signal_parse_name ("info-changed", TYPE_ACCOUNT, &_tmp8_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _main_window_account_info_changed_account_info_changed, self);
		main_window_set_account_app_menu_sensitivity (self, TRUE);
	}
	_tmp9_ = _data2_->account;
	main_window_set_account (self, _tmp9_);
	_tmp10_ = self->main_widget;
	if (_tmp10_ != NULL) {
		MainWidget* _tmp11_ = NULL;
		_tmp11_ = self->main_widget;
		main_widget_stop (_tmp11_);
	}
	_tmp12_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_bin_get_type (), GtkBin));
	if (_tmp12_ != NULL) {
		GtkWidget* _tmp13_ = NULL;
		_tmp13_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_bin_get_type (), GtkBin));
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), _tmp13_);
	}
	_tmp14_ = self->priv->header_box;
	_tmp15_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	_tmp16_ = _tmp15_;
	if (!_tmp16_) {
		GtkBox* _tmp17_ = NULL;
		_tmp17_ = self->priv->header_box;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), TRUE);
	}
	_tmp18_ = app;
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_COREBIRD, Corebird));
	cb = _tmp19_;
	_tmp21_ = _data2_->account;
	if (_tmp21_ != NULL) {
		Account* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp22_ = _data2_->account;
		_tmp23_ = account_get_screen_name (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_ = g_strcmp0 (_tmp24_, ACCOUNT_DUMMY) != 0;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		Account* _tmp25_ = NULL;
		Corebird* _tmp26_ = NULL;
		MainWidget* _tmp27_ = NULL;
		MainWidget* _tmp28_ = NULL;
		MainWidget* _tmp29_ = NULL;
		MainWidget* _tmp30_ = NULL;
		MainWidget* _tmp31_ = NULL;
		IPage* _tmp32_ = NULL;
		IPage* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		AvatarWidget* _tmp36_ = NULL;
		Account* _tmp37_ = NULL;
		cairo_surface_t* _tmp38_ = NULL;
		cairo_surface_t* _tmp39_ = NULL;
		Account* _tmp40_ = NULL;
		Account* _tmp41_ = NULL;
		Corebird* _tmp42_ = NULL;
		gint64* _tmp43_ = NULL;
		Account* _tmp44_ = NULL;
		gint64 _tmp45_ = 0LL;
		gint64 _tmp46_ = 0LL;
		GtkSettings* _tmp47_ = NULL;
		gboolean _tmp48_ = FALSE;
		gboolean _tmp49_ = FALSE;
		_tmp25_ = _data2_->account;
		_tmp26_ = cb;
		_tmp27_ = main_widget_new (_tmp25_, self, _tmp26_);
		g_object_ref_sink (_tmp27_);
		_g_object_unref0 (self->main_widget);
		self->main_widget = _tmp27_;
		_tmp28_ = self->main_widget;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget));
		_tmp29_ = self->main_widget;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
		_tmp30_ = self->main_widget;
		main_widget_switch_page (_tmp30_, 0, NULL);
		_tmp31_ = self->main_widget;
		_tmp32_ = main_widget_get_page (_tmp31_, 0);
		_tmp33_ = _tmp32_;
		_tmp34_ = ipage_get_title (_tmp33_);
		_tmp35_ = _tmp34_;
		gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp35_);
		_g_free0 (_tmp35_);
		_g_object_unref0 (_tmp33_);
		_tmp36_ = self->priv->avatar_image;
		_tmp37_ = _data2_->account;
		_tmp38_ = account_get_avatar_small (_tmp37_);
		_tmp39_ = _tmp38_;
		avatar_widget_set_surface (_tmp36_, _tmp39_);
		_tmp40_ = _data2_->account;
		g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, G_TYPE_OBJECT, GObject), "notify::avatar-small", (GCallback) ____lambda163__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		main_window_set_account_app_menu_sensitivity (self, FALSE);
		_tmp41_ = _data2_->account;
		g_signal_connect_object (_tmp41_, "info-changed", (GCallback) _main_window_account_info_changed_account_info_changed, self, 0);
		_tmp42_ = cb;
		_tmp43_ = old_user_id;
		_tmp44_ = _data2_->account;
		_tmp45_ = account_get_id (_tmp44_);
		_tmp46_ = _tmp45_;
		g_signal_emit_by_name (_tmp42_, "account-window-changed", _tmp43_, _tmp46_);
		_tmp47_ = gtk_settings_get_default ();
		g_object_get (_tmp47_, "gtk-shell-shows-app-menu", &_tmp48_, NULL);
		_tmp49_ = _tmp48_;
		if (!_tmp49_) {
			GtkMenuButton* _tmp50_ = NULL;
			_tmp50_ = self->priv->app_menu_button;
			if (_tmp50_ == NULL) {
				GtkMenuButton* _tmp51_ = NULL;
				GtkMenuButton* _tmp52_ = NULL;
				GtkImage* _tmp53_ = NULL;
				GtkImage* _tmp54_ = NULL;
				GtkMenuButton* _tmp55_ = NULL;
				GtkStyleContext* _tmp56_ = NULL;
				GtkMenuButton* _tmp57_ = NULL;
				GApplication* _tmp58_ = NULL;
				GMenuModel* _tmp59_ = NULL;
				GMenuModel* _tmp60_ = NULL;
				GtkHeaderBar* _tmp61_ = NULL;
				GtkMenuButton* _tmp62_ = NULL;
				_tmp51_ = (GtkMenuButton*) gtk_menu_button_new ();
				g_object_ref_sink (_tmp51_);
				_g_object_unref0 (self->priv->app_menu_button);
				self->priv->app_menu_button = _tmp51_;
				_tmp52_ = self->priv->app_menu_button;
				_tmp53_ = (GtkImage*) gtk_image_new_from_icon_name ("emblem-system-symbolic", GTK_ICON_SIZE_MENU);
				g_object_ref_sink (_tmp53_);
				_tmp54_ = _tmp53_;
				gtk_button_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_button_get_type (), GtkButton), G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (_tmp54_);
				_tmp55_ = self->priv->app_menu_button;
				_tmp56_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_widget_get_type (), GtkWidget));
				gtk_style_context_add_class (_tmp56_, "image-button");
				_tmp57_ = self->priv->app_menu_button;
				_tmp58_ = app;
				_tmp59_ = gtk_application_get_app_menu (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_application_get_type (), GtkApplication));
				_tmp60_ = _tmp59_;
				gtk_menu_button_set_menu_model (_tmp57_, _tmp60_);
				_tmp61_ = self->priv->headerbar;
				_tmp62_ = self->priv->app_menu_button;
				gtk_header_bar_pack_end (_tmp61_, G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_widget_get_type (), GtkWidget));
			} else {
				GtkMenuButton* _tmp63_ = NULL;
				_tmp63_ = self->priv->app_menu_button;
				gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_widget_get_type (), GtkWidget));
			}
		}
	} else {
		GtkBox* _tmp64_ = NULL;
		GtkMenuButton* _tmp65_ = NULL;
		Account* acc_ = NULL;
		Account* _tmp67_ = NULL;
		Account* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
		Account* _tmp73_ = NULL;
		AccountCreateWidget* create_widget = NULL;
		Account* _tmp74_ = NULL;
		Corebird* _tmp75_ = NULL;
		AccountCreateWidget* _tmp76_ = NULL;
		AccountCreateWidget* _tmp77_ = NULL;
		AccountCreateWidget* _tmp78_ = NULL;
		_tmp64_ = self->priv->header_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_widget_get_type (), GtkWidget));
		_tmp65_ = self->priv->app_menu_button;
		if (_tmp65_ != NULL) {
			GtkMenuButton* _tmp66_ = NULL;
			_tmp66_ = self->priv->app_menu_button;
			gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, gtk_widget_get_type (), GtkWidget));
		}
		_tmp67_ = _data2_->account;
		if (_tmp67_ == NULL) {
			Account* _tmp68_ = NULL;
			_tmp68_ = account_new ((gint64) 0, ACCOUNT_DUMMY, "name");
			_g_object_unref0 (acc_);
			acc_ = _tmp68_;
		} else {
			Account* _tmp69_ = NULL;
			Account* _tmp70_ = NULL;
			_tmp69_ = _data2_->account;
			_tmp70_ = _g_object_ref0 (_tmp69_);
			_g_object_unref0 (acc_);
			acc_ = _tmp70_;
		}
		_tmp71_ = acc_;
		main_window_set_account (self, _tmp71_);
		_tmp72_ = _ ("Corebird");
		gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp72_);
		_tmp73_ = acc_;
		account_add_account (_tmp73_);
		_tmp74_ = acc_;
		_tmp75_ = cb;
		_tmp76_ = account_create_widget_new (_tmp74_, _tmp75_);
		g_object_ref_sink (_tmp76_);
		create_widget = _tmp76_;
		_tmp77_ = create_widget;
		g_signal_connect_object (_tmp77_, "result-received", (GCallback) ____lambda166__account_create_widget_result_received, self, 0);
		_tmp78_ = create_widget;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (create_widget);
		_g_object_unref0 (acc_);
	}
	_g_object_unref0 (cb);
	_g_free0 (old_user_id);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void main_window_account_row_activated_cb (MainWindow* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	UserListEntry* e = NULL;
	GtkListBoxRow* _tmp10_ = NULL;
	UserListEntry* _tmp11_ = NULL;
	gint64 user_id = 0LL;
	UserListEntry* _tmp12_ = NULL;
	gint64 _tmp13_ = 0LL;
	gint64 _tmp14_ = 0LL;
	Corebird* cb = NULL;
	GtkApplication* _tmp15_ = NULL;
	Corebird* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gint64 _tmp18_ = 0LL;
	Account* _tmp19_ = NULL;
	gint64 _tmp20_ = 0LL;
	gint64 _tmp21_ = 0LL;
	Account* acc = NULL;
	gint64 _tmp26_ = 0LL;
	Account* _tmp27_ = NULL;
	Account* _tmp28_ = NULL;
	Account* _tmp29_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_ADD_LIST_ENTRY)) {
		GtkPopover* _tmp1_ = NULL;
		Account* dummy_acc = NULL;
		Account* _tmp2_ = NULL;
		MainWindow* window = NULL;
		GtkApplication* _tmp3_ = NULL;
		GtkApplication* _tmp4_ = NULL;
		Account* _tmp5_ = NULL;
		MainWindow* _tmp6_ = NULL;
		GtkApplication* _tmp7_ = NULL;
		MainWindow* _tmp8_ = NULL;
		MainWindow* _tmp9_ = NULL;
		_tmp1_ = self->priv->account_popover;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
		_tmp2_ = account_new ((gint64) 0, ACCOUNT_DUMMY, "name");
		dummy_acc = _tmp2_;
		_tmp3_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_tmp4_ = _tmp3_;
		_tmp5_ = dummy_acc;
		_tmp6_ = main_window_new (_tmp4_, _tmp5_);
		g_object_ref_sink (_tmp6_);
		window = _tmp6_;
		_tmp7_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_tmp8_ = window;
		gtk_application_add_window (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_window_get_type (), GtkWindow));
		_tmp9_ = window;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (window);
		_g_object_unref0 (dummy_acc);
		return;
	}
	_tmp10_ = row;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_USER_LIST_ENTRY, UserListEntry));
	e = _tmp11_;
	_tmp12_ = e;
	_tmp13_ = user_list_entry_get_user_id (_tmp12_);
	_tmp14_ = _tmp13_;
	user_id = _tmp14_;
	_tmp15_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_COREBIRD, Corebird));
	cb = _tmp16_;
	_tmp18_ = user_id;
	_tmp19_ = self->priv->_account;
	_tmp20_ = account_get_id (_tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp18_ == _tmp21_) {
		_tmp17_ = TRUE;
	} else {
		Corebird* _tmp22_ = NULL;
		gint64 _tmp23_ = 0LL;
		gboolean _tmp24_ = FALSE;
		_tmp22_ = cb;
		_tmp23_ = user_id;
		_tmp24_ = corebird_is_window_open_for_user_id (_tmp22_, _tmp23_, NULL);
		_tmp17_ = _tmp24_;
	}
	if (_tmp17_) {
		GtkPopover* _tmp25_ = NULL;
		_tmp25_ = self->priv->account_popover;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (cb);
		_g_object_unref0 (e);
		return;
	}
	_tmp26_ = user_id;
	_tmp27_ = account_query_account_by_id (_tmp26_);
	_tmp28_ = _g_object_ref0 (_tmp27_);
	acc = _tmp28_;
	_tmp29_ = acc;
	if (_tmp29_ != NULL) {
		Account* _tmp30_ = NULL;
		GApplication* _tmp31_ = NULL;
		GtkPopover* _tmp32_ = NULL;
		_tmp30_ = acc;
		_tmp31_ = g_application_get_default ();
		main_window_change_account (self, _tmp30_, _tmp31_);
		_tmp32_ = self->priv->account_popover;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget));
	} else {
		g_warning ("MainWindow.vala:247: account == null");
	}
	_g_object_unref0 (acc);
	_g_object_unref0 (cb);
	_g_object_unref0 (e);
}


static void _main_window_account_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	main_window_account_row_activated_cb ((MainWindow*) self, row);
}


static gboolean main_window_button_press_event_cb (MainWindow* self, GdkEventButton* evt) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = evt;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ == ((guint) 9)) {
		MainWidget* _tmp2_ = NULL;
		_tmp2_ = self->main_widget;
		main_widget_switch_page (_tmp2_, (gint) PAGE_NEXT, NULL);
		result = TRUE;
		return result;
	} else {
		GdkEventButton* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		_tmp3_ = evt;
		_tmp4_ = _tmp3_->button;
		if (_tmp4_ == ((guint) 8)) {
			MainWidget* _tmp5_ = NULL;
			_tmp5_ = self->main_widget;
			main_widget_switch_page (_tmp5_, (gint) PAGE_PREVIOUS, NULL);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean _main_window_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = main_window_button_press_event_cb ((MainWindow*) self, event);
	return result;
}


static void ___lambda203_ (MainWindow* self) {
	GtkToggleButton* _tmp0_ = NULL;
	_tmp0_ = self->compose_tweet_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
}


static void ____lambda203__gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	___lambda203_ ((MainWindow*) self);
}


static void ___lambda204_ (MainWindow* self) {
	_g_object_unref0 (self->priv->compose_tweet_window);
	self->priv->compose_tweet_window = NULL;
}


static void ____lambda204__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	___lambda204_ ((MainWindow*) self);
}


static void main_window_show_hide_compose_window (MainWindow* self) {
	ComposeTweetWindow* _tmp0_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->compose_tweet_window;
	if (_tmp0_ == NULL) {
		Account* _tmp1_ = NULL;
		ComposeTweetWindow* _tmp2_ = NULL;
		ComposeTweetWindow* _tmp3_ = NULL;
		ComposeTweetWindow* _tmp4_ = NULL;
		ComposeTweetWindow* _tmp5_ = NULL;
		_tmp1_ = self->priv->_account;
		_tmp2_ = compose_tweet_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp1_, NULL, COMPOSE_TWEET_WINDOW_MODE_NORMAL);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->compose_tweet_window);
		self->priv->compose_tweet_window = _tmp2_;
		_tmp3_ = self->priv->compose_tweet_window;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
		_tmp4_ = self->priv->compose_tweet_window;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), "hide", (GCallback) ____lambda203__gtk_widget_hide, self, 0);
		_tmp5_ = self->priv->compose_tweet_window;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), "destroy", (GCallback) ____lambda204__gtk_widget_destroy, self, 0);
	} else {
		ComposeTweetWindow* _tmp6_ = NULL;
		ComposeTweetWindow* _tmp7_ = NULL;
		_tmp6_ = self->priv->compose_tweet_window;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
		_tmp7_ = self->priv->compose_tweet_window;
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	}
}


/**
   * GSimpleActionActivateCallback version of switch_page, used
   * for keyboard accelerators.
   */
static void main_window_simple_switch_page (MainWindow* self, GSimpleAction* a, GVariant* param) {
	MainWidget* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	gint32 _tmp2_ = 0;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = self->main_widget;
	_tmp1_ = param;
	_tmp2_ = g_variant_get_int32 (_tmp1_);
	main_widget_switch_page (_tmp0_, (gint) _tmp2_, NULL);
}


static void main_window_show_account_dialog (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_ = NULL;
	AccountDialog* dialog = NULL;
	Account* _tmp5_ = NULL;
	AccountDialog* _tmp6_ = NULL;
	AccountDialog* _tmp7_ = NULL;
	AccountDialog* _tmp8_ = NULL;
	AccountDialog* _tmp9_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->priv->_account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = self->priv->_account;
		_tmp3_ = account_get_screen_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = self->priv->_account;
	_tmp6_ = account_dialog_new (_tmp5_);
	g_object_ref_sink (_tmp6_);
	dialog = _tmp6_;
	_tmp7_ = dialog;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp8_ = dialog;
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_window_get_type (), GtkWindow), TRUE);
	_tmp9_ = dialog;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (dialog);
}


static void main_window_show_account_list (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->priv->_account;
	if (_tmp1_ != NULL) {
		Account* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = self->priv->_account;
		_tmp3_ = account_get_screen_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, ACCOUNT_DUMMY) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkPopover* _tmp5_ = NULL;
		_tmp5_ = self->priv->account_popover;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	}
}


IPage* main_window_get_page (MainWindow* self, gint page_id) {
	IPage* result = NULL;
	MainWidget* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	IPage* _tmp2_ = NULL;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->main_widget;
	_tmp1_ = page_id;
	_tmp2_ = main_widget_get_page (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static void main_window_account_button_clicked_cb (MainWindow* self) {
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->account_popover;
	_tmp1_ = self->priv->account_popover;
	_tmp2_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = _tmp2_;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), !_tmp3_);
}


static void _main_window_account_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	main_window_account_button_clicked_cb ((MainWindow*) self);
}


static void main_window_account_popover_closed_cb (MainWindow* self) {
	GtkToggleButton* _tmp0_ = NULL;
	GtkPopover* _tmp1_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->account_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
	_tmp1_ = self->priv->account_popover;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
}


static void _main_window_account_popover_closed_cb_gtk_popover_closed (GtkPopover* _sender, gpointer self) {
	main_window_account_popover_closed_cb ((MainWindow*) self);
}


static gboolean main_window_window_delete_cb (MainWindow* self, GdkEventAny* evt) {
	gboolean result = FALSE;
	MainWidget* _tmp0_ = NULL;
	Account* _tmp2_ = NULL;
	GList* ws = NULL;
	GtkApplication* _tmp3_ = NULL;
	GtkApplication* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gchar** startup_accounts = NULL;
	GSettings* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gboolean _tmp13_ = FALSE;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint n_main_windows = 0;
	GList* _tmp19_ = NULL;
	gint _tmp31_ = 0;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = self->main_widget;
	if (_tmp0_ != NULL) {
		MainWidget* _tmp1_ = NULL;
		_tmp1_ = self->main_widget;
		main_widget_stop (_tmp1_);
	}
	_tmp2_ = self->priv->_account;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_application_get_windows (_tmp4_);
	ws = _tmp5_;
	_tmp6_ = ws;
	_tmp7_ = g_list_length (_tmp6_);
	g_debug ("MainWindow.vala:333: Windows: %u", _tmp7_);
	main_window_set_account_app_menu_sensitivity (self, TRUE);
	_tmp8_ = settings_get ();
	_tmp9_ = _tmp8_;
	_tmp11_ = _tmp10_ = g_settings_get_strv (_tmp9_, "startup-accounts");
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _vala_array_length (_tmp10_);
	_g_object_unref0 (_tmp9_);
	startup_accounts = _tmp12_;
	startup_accounts_length1 = _tmp12__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp14_ = startup_accounts;
	_tmp14__length1 = startup_accounts_length1;
	if (_tmp14__length1 == 1) {
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		const gchar* _tmp16_ = NULL;
		_tmp15_ = startup_accounts;
		_tmp15__length1 = startup_accounts_length1;
		_tmp16_ = _tmp15_[0];
		_tmp13_ = g_strcmp0 (_tmp16_, "") == 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gint _tmp17_ = 0;
		_tmp17_ = 0;
		startup_accounts = g_renew (gchar*, startup_accounts, 0);
		(_tmp17_ > startup_accounts_length1) ? memset (startup_accounts + startup_accounts_length1, 0, sizeof (gchar*) * (_tmp17_ - startup_accounts_length1)) : NULL;
		startup_accounts_length1 = _tmp17_;
		_startup_accounts_size_ = _tmp17_;
	}
	main_window_save_geometry (self);
	_tmp18_ = startup_accounts;
	_tmp18__length1 = startup_accounts_length1;
	if (_tmp18__length1 > 0) {
		result = FALSE;
		startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	n_main_windows = 0;
	_tmp19_ = ws;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp19_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* _tmp20_ = NULL;
			GtkWindow* win = NULL;
			_tmp20_ = _g_object_ref0 ((GtkWindow*) win_it->data);
			win = _tmp20_;
			{
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				GtkWindow* _tmp23_ = NULL;
				_tmp23_ = win;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, TYPE_MAIN_WINDOW)) {
					GtkWindow* _tmp24_ = NULL;
					Account* _tmp25_ = NULL;
					_tmp24_ = win;
					_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_MAIN_WINDOW, MainWindow)->priv->_account;
					_tmp22_ = _tmp25_ != NULL;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					GtkWindow* _tmp26_ = NULL;
					Account* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					_tmp26_ = win;
					_tmp27_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_MAIN_WINDOW, MainWindow)->priv->_account;
					_tmp28_ = account_get_screen_name (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = g_strcmp0 (_tmp29_, ACCOUNT_DUMMY) != 0;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					gint _tmp30_ = 0;
					_tmp30_ = n_main_windows;
					n_main_windows = _tmp30_ + 1;
				}
				_g_object_unref0 (win);
			}
		}
	}
	_tmp31_ = n_main_windows;
	if (_tmp31_ == 1) {
		gchar** new_startup_accounts = NULL;
		gchar** _tmp32_ = NULL;
		gint new_startup_accounts_length1 = 0;
		gint _new_startup_accounts_size_ = 0;
		gchar** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		GList* _tmp34_ = NULL;
		gconstpointer _tmp35_ = NULL;
		Account* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		GSettings* _tmp41_ = NULL;
		GSettings* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		GList* _tmp44_ = NULL;
		gconstpointer _tmp45_ = NULL;
		Account* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		_tmp32_ = g_new0 (gchar*, 1 + 1);
		new_startup_accounts = _tmp32_;
		new_startup_accounts_length1 = 1;
		_new_startup_accounts_size_ = new_startup_accounts_length1;
		_tmp33_ = new_startup_accounts;
		_tmp33__length1 = new_startup_accounts_length1;
		_tmp34_ = ws;
		_tmp35_ = g_list_nth_data (_tmp34_, (guint) 0);
		_tmp36_ = G_TYPE_CHECK_INSTANCE_CAST ((GtkWindow*) _tmp35_, TYPE_MAIN_WINDOW, MainWindow)->priv->_account;
		_tmp37_ = account_get_screen_name (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strdup (_tmp38_);
		_g_free0 (_tmp33_[0]);
		_tmp33_[0] = _tmp39_;
		_tmp40_ = _tmp33_[0];
		_tmp41_ = settings_get ();
		_tmp42_ = _tmp41_;
		_tmp43_ = new_startup_accounts;
		_tmp43__length1 = new_startup_accounts_length1;
		g_settings_set_strv (_tmp42_, "startup-accounts", _tmp43_);
		_g_object_unref0 (_tmp42_);
		_tmp44_ = ws;
		_tmp45_ = g_list_nth_data (_tmp44_, (guint) 0);
		_tmp46_ = G_TYPE_CHECK_INSTANCE_CAST ((GtkWindow*) _tmp45_, TYPE_MAIN_WINDOW, MainWindow)->priv->_account;
		_tmp47_ = account_get_screen_name (_tmp46_);
		_tmp48_ = _tmp47_;
		g_debug ("MainWindow.vala:360: Saving the account %s", _tmp48_);
		new_startup_accounts = (_vala_array_free (new_startup_accounts, new_startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	}
	result = FALSE;
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean _main_window_window_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = main_window_window_delete_cb ((MainWindow*) self, event);
	return result;
}


static void main_window_account_info_changed (MainWindow* self, const gchar* screen_name, const gchar* name, cairo_surface_t* small_avatar, cairo_surface_t* avatar) {
	MainWidget* _tmp0_ = NULL;
	MainWidget* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	IPage* _tmp4_ = NULL;
	IPage* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (screen_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (small_avatar != NULL);
	g_return_if_fail (avatar != NULL);
	_tmp0_ = self->main_widget;
	_tmp1_ = self->main_widget;
	_tmp2_ = main_widget_get_cur_page_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = main_widget_get_page (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = ipage_get_title (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp7_);
	_g_free0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
}


/**
   *
   */
static void main_window_load_geometry (MainWindow* self) {
	Account* _tmp0_ = NULL;
	GVariant* win_geom = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	GVariant* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gint _tmp14_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->_account;
	if (_tmp0_ == NULL) {
		g_debug ("MainWindow.vala:378: Could not load geometry, account == null");
		return;
	}
	_tmp1_ = settings_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_settings_get_value (_tmp2_, "window-geometry");
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	win_geom = _tmp4_;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	_tmp5_ = win_geom;
	_tmp6_ = self->priv->_account;
	_tmp7_ = account_get_screen_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_variant_lookup (_tmp5_, _tmp8_, "(iiii)", &x, &y, &w, &h, NULL);
	if (!_tmp9_) {
		Account* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp10_ = self->priv->_account;
		_tmp11_ = account_get_screen_name (_tmp10_);
		_tmp12_ = _tmp11_;
		g_warning ("MainWindow.vala:388: Couldn't load window geometry for screen_name `%s" \
"'", _tmp12_);
		_g_variant_unref0 (win_geom);
		return;
	}
	_tmp14_ = w;
	if (_tmp14_ == 0) {
		_tmp13_ = TRUE;
	} else {
		gint _tmp15_ = 0;
		_tmp15_ = h;
		_tmp13_ = _tmp15_ == 0;
	}
	if (_tmp13_) {
		_g_variant_unref0 (win_geom);
		return;
	}
	_tmp16_ = x;
	_tmp17_ = y;
	gtk_window_move (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp16_, _tmp17_);
	_tmp18_ = w;
	_tmp19_ = h;
	gtk_window_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp18_, _tmp19_);
	_g_variant_unref0 (win_geom);
}


/**
   * Saves this window's geometry in the window-geometry gsettings key.
   */
void main_window_save_geometry (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_ = NULL;
	GVariant* win_geom = NULL;
	GSettings* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GVariant* new_geom = NULL;
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp9_ = NULL;
	GVariantType* _tmp10_ = NULL;
	GVariantBuilder* _tmp11_ = NULL;
	GVariantBuilder* _tmp12_ = NULL;
	GVariantIter* iter = NULL;
	GVariant* _tmp13_ = NULL;
	GVariantIter* _tmp14_ = NULL;
	gchar* key = NULL;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	GVariantBuilder* _tmp31_ = NULL;
	Account* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	GVariantBuilder* _tmp39_ = NULL;
	GVariant* _tmp40_ = NULL;
	Account* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	GSettings* _tmp48_ = NULL;
	GSettings* _tmp49_ = NULL;
	GVariant* _tmp50_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->priv->_account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = self->priv->_account;
		_tmp3_ = account_get_screen_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = settings_get ();
	_tmp6_ = _tmp5_;
	_tmp7_ = g_settings_get_value (_tmp6_, "window-geometry");
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	win_geom = _tmp8_;
	_tmp9_ = g_variant_type_new ("a{s(iiii)}");
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_builder_new (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_variant_type_free0 (_tmp10_);
	builder = _tmp12_;
	_tmp13_ = win_geom;
	_tmp14_ = g_variant_iter_new (_tmp13_);
	iter = _tmp14_;
	key = NULL;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	while (TRUE) {
		GVariantIter* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		const gchar* _tmp17_ = NULL;
		Account* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		_tmp15_ = iter;
		_tmp16_ = g_variant_iter_next (_tmp15_, "{s(iiii)}", &key, &x, &y, &w, &h, NULL);
		if (!_tmp16_) {
			break;
		}
		_tmp17_ = key;
		_tmp18_ = self->priv->_account;
		_tmp19_ = account_get_screen_name (_tmp18_);
		_tmp20_ = _tmp19_;
		if (g_strcmp0 (_tmp17_, _tmp20_) != 0) {
			GVariantBuilder* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			_tmp21_ = builder;
			_tmp22_ = key;
			_tmp23_ = x;
			_tmp24_ = y;
			_tmp25_ = w;
			_tmp26_ = h;
			g_variant_builder_add (_tmp21_, "{s(iiii)}", _tmp22_, _tmp23_, _tmp24_, _tmp25_, _tmp26_, NULL);
		}
		_g_free0 (key);
		key = NULL;
	}
	gtk_window_get_position (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp27_, &_tmp28_);
	x = _tmp27_;
	y = _tmp28_;
	_tmp29_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	w = _tmp29_;
	_tmp30_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	h = _tmp30_;
	_tmp31_ = builder;
	_tmp32_ = self->priv->_account;
	_tmp33_ = account_get_screen_name (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = x;
	_tmp36_ = y;
	_tmp37_ = w;
	_tmp38_ = h;
	g_variant_builder_add (_tmp31_, "{s(iiii)}", _tmp34_, _tmp35_, _tmp36_, _tmp37_, _tmp38_, NULL);
	_tmp39_ = builder;
	_tmp40_ = g_variant_builder_end (_tmp39_);
	g_variant_ref_sink (_tmp40_);
	_g_variant_unref0 (new_geom);
	new_geom = _tmp40_;
	_tmp41_ = self->priv->_account;
	_tmp42_ = account_get_screen_name (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = x;
	_tmp45_ = y;
	_tmp46_ = w;
	_tmp47_ = h;
	g_debug ("MainWindow.vala:427: Saving geomentry for %s: %d,%d,%d,%d", _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_);
	_tmp48_ = settings_get ();
	_tmp49_ = _tmp48_;
	_tmp50_ = new_geom;
	g_settings_set_value (_tmp49_, "window-geometry", _tmp50_);
	_g_object_unref0 (_tmp49_);
	_g_free0 (key);
	_g_variant_iter_free0 (iter);
	_g_variant_builder_unref0 (builder);
	_g_variant_unref0 (new_geom);
	_g_variant_unref0 (win_geom);
}


static gint main_window_account_sort_func (MainWindow* self, GtkListBoxRow* a, GtkListBoxRow* b) {
	gint result = 0;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkListBoxRow* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), 0);
	g_return_val_if_fail (GTK_IS_LIST_BOX_ROW (a), 0);
	g_return_val_if_fail (GTK_IS_LIST_BOX_ROW (b), 0);
	_tmp0_ = a;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_ADD_LIST_ENTRY)) {
		result = 1;
		return result;
	}
	_tmp1_ = a;
	_tmp2_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = b;
	_tmp6_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = g_ascii_strcasecmp (_tmp4_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp4_);
	result = _tmp10_;
	return result;
}


void main_window_rerun_filters (MainWindow* self) {
	IPage* _tmp0_ = NULL;
	ITimeline* _tmp1_ = NULL;
	IPage* _tmp2_ = NULL;
	ITimeline* _tmp3_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = main_window_get_page (self, (gint) PAGE_STREAM);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ITIMELINE, ITimeline);
	itimeline_rerun_filters (_tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = main_window_get_page (self, (gint) PAGE_MENTIONS);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_ITIMELINE, ITimeline);
	itimeline_rerun_filters (_tmp3_);
	_g_object_unref0 (_tmp3_);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void main_window_set_account_app_menu_sensitivity (MainWindow* self, gboolean sensitivity) {
	GMenu* acc_menu = NULL;
	GMenu* _tmp0_ = NULL;
	GMenu* _tmp1_ = NULL;
	gchar* ref_action_name = NULL;
	Account* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GtkApplication* app = NULL;
	GApplication* _tmp9_ = NULL;
	GtkApplication* _tmp10_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = corebird_account_menu;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_menu_get_type (), GMenu));
	acc_menu = _tmp1_;
	_tmp2_ = self->priv->_account;
	_tmp3_ = account_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("app.show-", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	ref_action_name = _tmp8_;
	_tmp9_ = g_application_get_default ();
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_application_get_type (), GtkApplication));
	app = _tmp10_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				GMenu* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				GVariant* action_name = NULL;
				GMenu* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				const GVariantType* _tmp18_ = NULL;
				GVariant* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				GVariant* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = acc_menu;
				_tmp15_ = g_menu_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_menu_model_get_type (), GMenuModel));
				if (!(_tmp13_ < _tmp15_)) {
					break;
				}
				_tmp16_ = acc_menu;
				_tmp17_ = i;
				_tmp18_ = G_VARIANT_TYPE_STRING;
				_tmp19_ = g_menu_model_get_item_attribute_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, g_menu_model_get_type (), GMenuModel), _tmp17_, G_MENU_ATTRIBUTE_ACTION, _tmp18_);
				action_name = _tmp19_;
				_tmp20_ = ref_action_name;
				_tmp21_ = action_name;
				_tmp22_ = g_variant_get_string (_tmp21_, NULL);
				if (g_strcmp0 (_tmp20_, _tmp22_) == 0) {
					GSimpleAction* action = NULL;
					GtkApplication* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					GAction* _tmp27_ = NULL;
					GSimpleAction* _tmp28_ = NULL;
					GSimpleAction* _tmp29_ = NULL;
					GSimpleAction* _tmp30_ = NULL;
					_tmp23_ = app;
					_tmp24_ = ref_action_name;
					_tmp25_ = string_substring (_tmp24_, (glong) 4, (glong) -1);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, g_action_map_get_type (), GActionMap), _tmp26_);
					_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, g_simple_action_get_type (), GSimpleAction));
					_tmp29_ = _tmp28_;
					_g_free0 (_tmp26_);
					action = _tmp29_;
					_tmp30_ = action;
					if (_tmp30_ != NULL) {
						GSimpleAction* _tmp31_ = NULL;
						gboolean _tmp32_ = FALSE;
						_tmp31_ = action;
						_tmp32_ = sensitivity;
						g_simple_action_set_enabled (_tmp31_, _tmp32_);
						_g_object_unref0 (action);
						_g_variant_unref0 (action_name);
						_g_object_unref0 (app);
						_g_free0 (ref_action_name);
						_g_object_unref0 (acc_menu);
						return;
					}
					_g_object_unref0 (action);
				}
				_g_variant_unref0 (action_name);
			}
		}
	}
	_g_object_unref0 (app);
	_g_free0 (ref_action_name);
	_g_object_unref0 (acc_menu);
}


Account* main_window_get_account (MainWindow* self) {
	Account* result;
	Account* _tmp0_ = NULL;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void main_window_set_account (MainWindow* self, Account* value) {
	Account* _tmp0_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = value;
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


gint main_window_get_cur_page_id (MainWindow* self) {
	gint result;
	MainWidget* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), 0);
	_tmp0_ = self->main_widget;
	_tmp1_ = main_widget_get_cur_page_id (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void main_window_class_init (MainWindowClass * klass) {
	gint MainWindow_private_offset;
	main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_main_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_CUR_PAGE_ID, g_param_spec_int ("cur-page-id", "cur-page-id", "cur-page-id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	MainWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/main-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "account_list", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, account_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "account_popover", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, account_popover));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_box", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, header_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "account_button", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, account_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, G_STRUCT_OFFSET (MainWindow, back_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "compose_tweet_button", FALSE, G_STRUCT_OFFSET (MainWindow, compose_tweet_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "back_button_clicked_cb", G_CALLBACK(_main_window_back_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "account_row_activated_cb", G_CALLBACK(_main_window_account_row_activated_cb_gtk_list_box_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "button_press_event_cb", G_CALLBACK(_main_window_button_press_event_cb_gtk_widget_button_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "account_button_clicked_cb", G_CALLBACK(_main_window_account_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "account_popover_closed_cb", G_CALLBACK(_main_window_account_popover_closed_cb_gtk_popover_closed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "window_delete_cb", G_CALLBACK(_main_window_window_delete_cb_gtk_widget_delete_event));
}


static void main_window_instance_init (MainWindow * self) {
	self->priv = MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->app_menu_button = NULL;
	self->priv->compose_tweet_window = NULL;
	g_type_ensure (TYPE_AVATAR_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void main_window_finalize (GObject* obj) {
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->account_list);
	_g_object_unref0 (self->priv->account_popover);
	_g_object_unref0 (self->priv->header_box);
	_g_object_unref0 (self->priv->account_button);
	_g_object_unref0 (self->back_button);
	_g_object_unref0 (self->compose_tweet_button);
	_g_object_unref0 (self->priv->app_menu_button);
	_g_object_unref0 (self->main_widget);
	_g_object_unref0 (self->priv->compose_tweet_window);
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
}


GType main_window_get_type (void) {
	static volatile gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
		GType main_window_type_id;
		main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "MainWindow", &g_define_type_info, 0);
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}


static void _vala_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
	switch (property_id) {
		case MAIN_WINDOW_ACCOUNT:
		g_value_set_object (value, main_window_get_account (self));
		break;
		case MAIN_WINDOW_CUR_PAGE_ID:
		g_value_set_int (value, main_window_get_cur_page_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
	switch (property_id) {
		case MAIN_WINDOW_ACCOUNT:
		main_window_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



