/* Database.c generated by valac 0.30.0, the Vala compiler
 * generated from Database.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <glib/gstdio.h>
#include <stdarg.h>
#include <gobject/gvaluecollector.h>


#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;
typedef struct _SqlDatabasePrivate SqlDatabasePrivate;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
typedef struct _Block87Data Block87Data;
#define _sql_database_unref0(var) ((var == NULL) ? NULL : (var = (sql_database_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;

#define SQL_TYPE_ISTATEMENT (sql_istatement_get_type ())
#define SQL_ISTATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_ISTATEMENT, SqlIStatement))
#define SQL_IS_ISTATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_ISTATEMENT))
#define SQL_ISTATEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SQL_TYPE_ISTATEMENT, SqlIStatementIface))

typedef struct _SqlIStatement SqlIStatement;
typedef struct _SqlIStatementIface SqlIStatementIface;
#define _sql_insert_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_insert_statement_unref (var), NULL)))

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
#define _sql_select_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_select_statement_unref (var), NULL)))

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
#define _sql_update_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_update_statement_unref (var), NULL)))
typedef struct _SqlParamSpecDatabase SqlParamSpecDatabase;

struct _SqlDatabase {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SqlDatabasePrivate * priv;
};

struct _SqlDatabaseClass {
	GTypeClass parent_class;
	void (*finalize) (SqlDatabase *self);
};

struct _SqlDatabasePrivate {
	sqlite3* db;
};

struct _Block87Data {
	int _ref_count_;
	SqlDatabase* self;
	gint user_version;
};

struct _SqlIStatementIface {
	GTypeInterface parent_iface;
	sqlite3* (*get_db) (SqlIStatement* self);
	void (*set_db) (SqlIStatement* self, sqlite3* value);
};

struct _SqlParamSpecDatabase {
	GParamSpec parent_instance;
};


static gpointer sql_database_parent_class = NULL;

#define DATADIR "/usr/share/corebird/"
#define SQL_COREBIRD_INIT_FILE DATADIR "/sql/init/Create.%d.sql"
#define SQL_ACCOUNTS_INIT_FILE DATADIR "/sql/accounts/Create.%d.sql"
#define SQL_STOP -1
#define SQL_CONTINUE 0
gpointer sql_database_ref (gpointer instance);
void sql_database_unref (gpointer instance);
GParamSpec* sql_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_database (GValue* value, gpointer v_object);
void sql_value_take_database (GValue* value, gpointer v_object);
gpointer sql_value_get_database (const GValue* value);
GType sql_database_get_type (void) G_GNUC_CONST;
#define SQL_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_TYPE_DATABASE, SqlDatabasePrivate))
enum  {
	SQL_DATABASE_DUMMY_PROPERTY
};
SqlDatabase* sql_database_new (const gchar* filename, const gchar* init_file);
SqlDatabase* sql_database_construct (GType object_type, const gchar* filename, const gchar* init_file);
static Block87Data* block87_data_ref (Block87Data* _data87_);
static void block87_data_unref (void * _userdata_);
void sql_database_exec (SqlDatabase* self, const gchar* sql, sqlite3_callback callback, void* callback_target);
static gint __lambda4_ (Block87Data* _data87_, gint n_cols, gchar** vals, int vals_length1);
static gint ___lambda4__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names);
static gint ___lambda5_ (Block87Data* _data87_, gint n_cols, gchar** vals, int vals_length1);
static gint ____lambda5__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names);
gint64 sql_database_exec_insert (SqlDatabase* self, const gchar* sql);
void sql_database_execf (SqlDatabase* self, const gchar* sql, const gchar* first_param, ...);
gpointer sql_insert_statement_ref (gpointer instance);
void sql_insert_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_insert_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_insert_statement (GValue* value, gpointer v_object);
void sql_value_take_insert_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_insert_statement (const GValue* value);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_new (const gchar* table_name, gboolean replace);
SqlInsertStatement* sql_insert_statement_construct (GType object_type, const gchar* table_name, gboolean replace);
GType sql_istatement_get_type (void) G_GNUC_CONST;
void sql_istatement_set_db (SqlIStatement* self, sqlite3* value);
SqlInsertStatement* sql_database_replace (SqlDatabase* self, const gchar* table_name);
gpointer sql_select_statement_ref (gpointer instance);
void sql_select_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_select_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_select_statement (GValue* value, gpointer v_object);
void sql_value_take_select_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_select_statement (const GValue* value);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_new (const gchar* table_name);
SqlSelectStatement* sql_select_statement_construct (GType object_type, const gchar* table_name);
gpointer sql_update_statement_ref (gpointer instance);
void sql_update_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_update_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_update_statement (GValue* value, gpointer v_object);
void sql_value_take_update_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_update_statement (const GValue* value);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_new (const gchar* table_name);
SqlUpdateStatement* sql_update_statement_construct (GType object_type, const gchar* table_name);
void sql_database_begin_transaction (SqlDatabase* self);
void sql_database_end_transaction (SqlDatabase* self);
static void sql_database_finalize (SqlDatabase* obj);


static Block87Data* block87_data_ref (Block87Data* _data87_) {
	g_atomic_int_inc (&_data87_->_ref_count_);
	return _data87_;
}


static void block87_data_unref (void * _userdata_) {
	Block87Data* _data87_;
	_data87_ = (Block87Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data87_->_ref_count_)) {
		SqlDatabase* self;
		self = _data87_->self;
		_sql_database_unref0 (self);
		g_slice_free (Block87Data, _data87_);
	}
}


static gint __lambda4_ (Block87Data* _data87_, gint n_cols, gchar** vals, int vals_length1) {
	SqlDatabase* self;
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	self = _data87_->self;
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = atoi (_tmp1_);
	_data87_->user_version = _tmp2_;
	result = SQL_STOP;
	return result;
}


static gint ___lambda4__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names) {
	gint result;
	result = __lambda4_ (self, n_columns, values, -1);
	return result;
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3_callback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


static gint ___lambda5_ (Block87Data* _data87_, gint n_cols, gchar** vals, int vals_length1) {
	SqlDatabase* self;
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	self = _data87_->self;
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = atoi (_tmp1_);
	_data87_->user_version = _tmp2_;
	result = SQL_STOP;
	return result;
}


static gint ____lambda5__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names) {
	gint result;
	result = ___lambda5_ (self, n_columns, values, -1);
	return result;
}


SqlDatabase* sql_database_construct (GType object_type, const gchar* filename, const gchar* init_file) {
	SqlDatabase* self = NULL;
	Block87Data* _data87_;
	gint err = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	const gchar* _tmp7_ = NULL;
	gchar* next_version_file = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (SqlDatabase*) g_type_create_instance (object_type);
	_data87_ = g_slice_new0 (Block87Data);
	_data87_->_ref_count_ = 1;
	_data87_->self = sql_database_ref (self);
	_tmp0_ = filename;
	_tmp2_ = sqlite3_open (_tmp0_, &_tmp1_);
	_sqlite3_close0 (self->priv->db);
	self->priv->db = _tmp1_;
	err = _tmp2_;
	_tmp3_ = err;
	if (_tmp3_ == 1) {
		const gchar* _tmp4_ = NULL;
		sqlite3* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = filename;
		_tmp5_ = self->priv->db;
		_tmp6_ = sqlite3_errmsg (_tmp5_);
		g_critical ("Database.vala:35: Error when opening the database '%s': %s", _tmp4_, _tmp6_);
	}
	sql_database_exec (self, "PRAGMA journal_mode = MEMORY;", NULL, NULL);
	_tmp7_ = init_file;
	if (_tmp7_ == NULL) {
		block87_data_unref (_data87_);
		_data87_ = NULL;
		return self;
	}
	_data87_->user_version = -1;
	sql_database_exec (self, "pragma user_version;", ___lambda4__sqlite3_callback, _data87_);
	_tmp8_ = init_file;
	_tmp9_ = _data87_->user_version;
	_tmp10_ = g_strdup_printf (_tmp8_, _tmp9_ + 1);
	next_version_file = _tmp10_;
	_tmp11_ = filename;
	_tmp12_ = _data87_->user_version;
	g_debug ("Database.vala:45: %s User version: %d", _tmp11_, _tmp12_);
	while (TRUE) {
		const gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		gchar* sql_content = NULL;
		sqlite3* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gchar* _tmp26_ = NULL;
		_tmp13_ = next_version_file;
		_tmp14_ = g_file_test (_tmp13_, G_FILE_TEST_EXISTS);
		if (!_tmp14_) {
			break;
		}
		{
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			_tmp15_ = next_version_file;
			g_debug ("Database.vala:49: Applying file '%s'", _tmp15_);
			_tmp16_ = next_version_file;
			g_file_get_contents (_tmp16_, &_tmp17_, NULL, &_inner_error_);
			_g_free0 (sql_content);
			sql_content = _tmp17_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch114_g_file_error;
				}
				_g_free0 (sql_content);
				_g_free0 (next_version_file);
				block87_data_unref (_data87_);
				_data87_ = NULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		goto __finally114;
		__catch114_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			g_critical ("Database.vala:52: %s", _tmp19_);
			_g_error_free0 (e);
			_g_free0 (sql_content);
			_g_free0 (next_version_file);
			block87_data_unref (_data87_);
			_data87_ = NULL;
			return self;
		}
		__finally114:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (sql_content);
			_g_free0 (next_version_file);
			block87_data_unref (_data87_);
			_data87_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp20_ = self->priv->db;
		_tmp21_ = sql_content;
		_sqlite3_exec (_tmp20_, _tmp21_, NULL, NULL, NULL);
		_tmp22_ = next_version_file;
		_tmp23_ = filename;
		g_debug ("Database.vala:56: Executed init file '%s' for database '%s'", _tmp22_, _tmp23_);
		sql_database_exec (self, "pragma user_version;", ____lambda5__sqlite3_callback, _data87_);
		_tmp24_ = init_file;
		_tmp25_ = _data87_->user_version;
		_tmp26_ = g_strdup_printf (_tmp24_, _tmp25_ + 1);
		_g_free0 (next_version_file);
		next_version_file = _tmp26_;
		_g_free0 (sql_content);
	}
	_g_free0 (next_version_file);
	block87_data_unref (_data87_);
	_data87_ = NULL;
	return self;
}


SqlDatabase* sql_database_new (const gchar* filename, const gchar* init_file) {
	return sql_database_construct (SQL_TYPE_DATABASE, filename, init_file);
}


gint64 sql_database_exec_insert (SqlDatabase* self, const gchar* sql) {
	gint64 result = 0LL;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	sqlite3* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	g_return_val_if_fail (SQL_IS_DATABASE (self), 0LL);
	g_return_val_if_fail (sql != NULL, 0LL);
	_tmp0_ = self->priv->db;
	_tmp1_ = sql;
	_sqlite3_exec (_tmp0_, _tmp1_, NULL, NULL, NULL);
	_tmp2_ = self->priv->db;
	_tmp3_ = sqlite3_last_insert_rowid (_tmp2_);
	result = _tmp3_;
	return result;
}


void sql_database_exec (SqlDatabase* self, const gchar* sql, sqlite3_callback callback, void* callback_target) {
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	sqlite3_callback _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	g_return_if_fail (SQL_IS_DATABASE (self));
	g_return_if_fail (sql != NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = sql;
	_tmp2_ = callback;
	_tmp2__target = callback_target;
	_sqlite3_exec (_tmp0_, _tmp1_, _tmp2_, _tmp2__target, NULL);
}


void sql_database_execf (SqlDatabase* self, const gchar* sql, const gchar* first_param, ...) {
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	va_list _tmp3_ = {0};
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (SQL_IS_DATABASE (self));
	g_return_if_fail (sql != NULL);
	g_return_if_fail (first_param != NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = sql;
	_tmp2_ = first_param;
	va_start (_tmp3_, first_param);
	_tmp4_ = g_strdup_printf (_tmp1_, _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_sqlite3_exec (_tmp0_, _tmp5_, NULL, NULL, NULL);
	_g_free0 (_tmp5_);
	va_end (_tmp3_);
}


SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name) {
	SqlInsertStatement* result = NULL;
	SqlInsertStatement* stmt = NULL;
	const gchar* _tmp0_ = NULL;
	SqlInsertStatement* _tmp1_ = NULL;
	sqlite3* _tmp2_ = NULL;
	g_return_val_if_fail (SQL_IS_DATABASE (self), NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	_tmp0_ = table_name;
	_tmp1_ = sql_insert_statement_new (_tmp0_, FALSE);
	stmt = _tmp1_;
	_tmp2_ = self->priv->db;
	sql_istatement_set_db (G_TYPE_CHECK_INSTANCE_CAST (stmt, SQL_TYPE_ISTATEMENT, SqlIStatement), _tmp2_);
	result = stmt;
	return result;
}


SqlInsertStatement* sql_database_replace (SqlDatabase* self, const gchar* table_name) {
	SqlInsertStatement* result = NULL;
	SqlInsertStatement* stmt = NULL;
	const gchar* _tmp0_ = NULL;
	SqlInsertStatement* _tmp1_ = NULL;
	sqlite3* _tmp2_ = NULL;
	g_return_val_if_fail (SQL_IS_DATABASE (self), NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	_tmp0_ = table_name;
	_tmp1_ = sql_insert_statement_new (_tmp0_, TRUE);
	stmt = _tmp1_;
	_tmp2_ = self->priv->db;
	sql_istatement_set_db (G_TYPE_CHECK_INSTANCE_CAST (stmt, SQL_TYPE_ISTATEMENT, SqlIStatement), _tmp2_);
	result = stmt;
	return result;
}


SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name) {
	SqlSelectStatement* result = NULL;
	SqlSelectStatement* stmt = NULL;
	const gchar* _tmp0_ = NULL;
	SqlSelectStatement* _tmp1_ = NULL;
	sqlite3* _tmp2_ = NULL;
	g_return_val_if_fail (SQL_IS_DATABASE (self), NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	_tmp0_ = table_name;
	_tmp1_ = sql_select_statement_new (_tmp0_);
	stmt = _tmp1_;
	_tmp2_ = self->priv->db;
	sql_istatement_set_db (G_TYPE_CHECK_INSTANCE_CAST (stmt, SQL_TYPE_ISTATEMENT, SqlIStatement), _tmp2_);
	result = stmt;
	return result;
}


SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name) {
	SqlUpdateStatement* result = NULL;
	SqlUpdateStatement* stmt = NULL;
	const gchar* _tmp0_ = NULL;
	SqlUpdateStatement* _tmp1_ = NULL;
	sqlite3* _tmp2_ = NULL;
	g_return_val_if_fail (SQL_IS_DATABASE (self), NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	_tmp0_ = table_name;
	_tmp1_ = sql_update_statement_new (_tmp0_);
	stmt = _tmp1_;
	_tmp2_ = self->priv->db;
	sql_istatement_set_db (G_TYPE_CHECK_INSTANCE_CAST (stmt, SQL_TYPE_ISTATEMENT, SqlIStatement), _tmp2_);
	result = stmt;
	return result;
}


void sql_database_begin_transaction (SqlDatabase* self) {
	sqlite3* _tmp0_ = NULL;
	g_return_if_fail (SQL_IS_DATABASE (self));
	_tmp0_ = self->priv->db;
	_sqlite3_exec (_tmp0_, "BEGIN TRANSACTION;", NULL, NULL, NULL);
}


void sql_database_end_transaction (SqlDatabase* self) {
	sqlite3* _tmp0_ = NULL;
	g_return_if_fail (SQL_IS_DATABASE (self));
	_tmp0_ = self->priv->db;
	_sqlite3_exec (_tmp0_, "END TRANSACTION;", NULL, NULL, NULL);
}


static void sql_value_database_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void sql_value_database_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sql_database_unref (value->data[0].v_pointer);
	}
}


static void sql_value_database_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sql_database_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer sql_value_database_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* sql_value_database_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SqlDatabase* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sql_database_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* sql_value_database_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SqlDatabase** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sql_database_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* sql_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SqlParamSpecDatabase* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SQL_TYPE_DATABASE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer sql_value_get_database (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SQL_TYPE_DATABASE), NULL);
	return value->data[0].v_pointer;
}


void sql_value_set_database (GValue* value, gpointer v_object) {
	SqlDatabase* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SQL_TYPE_DATABASE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SQL_TYPE_DATABASE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sql_database_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sql_database_unref (old);
	}
}


void sql_value_take_database (GValue* value, gpointer v_object) {
	SqlDatabase* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SQL_TYPE_DATABASE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SQL_TYPE_DATABASE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sql_database_unref (old);
	}
}


static void sql_database_class_init (SqlDatabaseClass * klass) {
	sql_database_parent_class = g_type_class_peek_parent (klass);
	((SqlDatabaseClass *) klass)->finalize = sql_database_finalize;
	g_type_class_add_private (klass, sizeof (SqlDatabasePrivate));
}


static void sql_database_instance_init (SqlDatabase * self) {
	self->priv = SQL_DATABASE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void sql_database_finalize (SqlDatabase* obj) {
	SqlDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SQL_TYPE_DATABASE, SqlDatabase);
	g_signal_handlers_destroy (self);
	_sqlite3_close0 (self->priv->db);
}


GType sql_database_get_type (void) {
	static volatile gsize sql_database_type_id__volatile = 0;
	if (g_once_init_enter (&sql_database_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { sql_value_database_init, sql_value_database_free_value, sql_value_database_copy_value, sql_value_database_peek_pointer, "p", sql_value_database_collect_value, "p", sql_value_database_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SqlDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SqlDatabase), 0, (GInstanceInitFunc) sql_database_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sql_database_type_id;
		sql_database_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SqlDatabase", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sql_database_type_id__volatile, sql_database_type_id);
	}
	return sql_database_type_id__volatile;
}


gpointer sql_database_ref (gpointer instance) {
	SqlDatabase* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void sql_database_unref (gpointer instance) {
	SqlDatabase* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SQL_DATABASE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



