/* PixbufButton.c generated by valac 0.30.0, the Vala compiler
 * generated from PixbufButton.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_PIXBUF_BUTTON (pixbuf_button_get_type ())
#define PIXBUF_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXBUF_BUTTON, PixbufButton))
#define PIXBUF_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXBUF_BUTTON, PixbufButtonClass))
#define IS_PIXBUF_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXBUF_BUTTON))
#define IS_PIXBUF_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXBUF_BUTTON))
#define PIXBUF_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXBUF_BUTTON, PixbufButtonClass))

typedef struct _PixbufButton PixbufButton;
typedef struct _PixbufButtonClass PixbufButtonClass;
typedef struct _PixbufButtonPrivate PixbufButtonPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _PixbufButton {
	GtkButton parent_instance;
	PixbufButtonPrivate * priv;
};

struct _PixbufButtonClass {
	GtkButtonClass parent_class;
};

struct _PixbufButtonPrivate {
	cairo_surface_t* bg;
	GtkMenu* menu;
	gchar* menu_string;
	gboolean _round;
};


static gpointer pixbuf_button_parent_class = NULL;

GType pixbuf_button_get_type (void) G_GNUC_CONST;
#define PIXBUF_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PIXBUF_BUTTON, PixbufButtonPrivate))
enum  {
	PIXBUF_BUTTON_DUMMY_PROPERTY,
	PIXBUF_BUTTON_ROUND
};
PixbufButton* pixbuf_button_new (gboolean show_menu, const gchar* menu_string);
PixbufButton* pixbuf_button_construct (GType object_type, gboolean show_menu, const gchar* menu_string);
static gboolean pixbuf_button_button_release_cb (PixbufButton* self, GdkEventButton* evt);
static gboolean _pixbuf_button_button_release_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void pixbuf_button_source_link_item_activate_cb (PixbufButton* self);
static void _pixbuf_button_source_link_item_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gboolean pixbuf_button_real_draw (GtkWidget* base, cairo_t* ct);
void pixbuf_button_set_bg (PixbufButton* self, cairo_surface_t* bg);
void pixbuf_button_set_pixbuf (PixbufButton* self, GdkPixbuf* pixbuf);
gboolean pixbuf_button_get_round (PixbufButton* self);
void pixbuf_button_set_round (PixbufButton* self, gboolean value);
static GObject * pixbuf_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void pixbuf_button_finalize (GObject* obj);
static void _vala_pixbuf_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_pixbuf_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gboolean _pixbuf_button_button_release_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = pixbuf_button_button_release_cb ((PixbufButton*) self, event);
	return result;
}


PixbufButton* pixbuf_button_construct (GType object_type, gboolean show_menu, const gchar* menu_string) {
	PixbufButton * self = NULL;
	gboolean _tmp0_ = FALSE;
	self = (PixbufButton*) g_object_new (object_type, NULL);
	_tmp0_ = show_menu;
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _pixbuf_button_button_release_cb_gtk_widget_button_press_event, self, 0);
		_tmp1_ = menu_string;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (self->priv->menu_string);
		self->priv->menu_string = _tmp2_;
	}
	return self;
}


PixbufButton* pixbuf_button_new (gboolean show_menu, const gchar* menu_string) {
	return pixbuf_button_construct (TYPE_PIXBUF_BUTTON, show_menu, menu_string);
}


static void _pixbuf_button_source_link_item_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	pixbuf_button_source_link_item_activate_cb ((PixbufButton*) self);
}


static gboolean pixbuf_button_button_release_cb (PixbufButton* self, GdkEventButton* evt) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (IS_PIXBUF_BUTTON (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = evt;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ == ((guint) GDK_BUTTON_SECONDARY)) {
		GtkMenu* _tmp2_ = NULL;
		GtkMenuItem* source_link_item = NULL;
		const gchar* _tmp3_ = NULL;
		GtkMenuItem* _tmp4_ = NULL;
		GtkMenuItem* _tmp5_ = NULL;
		GtkMenu* _tmp6_ = NULL;
		GtkMenuItem* _tmp7_ = NULL;
		GtkMenu* _tmp8_ = NULL;
		GtkMenu* _tmp9_ = NULL;
		GdkEventButton* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		GdkEventButton* _tmp12_ = NULL;
		guint32 _tmp13_ = 0U;
		_tmp2_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->menu);
		self->priv->menu = _tmp2_;
		_tmp3_ = _ ("Copy link");
		_tmp4_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp3_);
		g_object_ref_sink (_tmp4_);
		source_link_item = _tmp4_;
		_tmp5_ = source_link_item;
		g_signal_connect_object (_tmp5_, "activate", (GCallback) _pixbuf_button_source_link_item_activate_cb_gtk_menu_item_activate, self, 0);
		_tmp6_ = self->priv->menu;
		_tmp7_ = source_link_item;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
		_tmp8_ = self->priv->menu;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		_tmp9_ = self->priv->menu;
		_tmp10_ = evt;
		_tmp11_ = _tmp10_->button;
		_tmp12_ = evt;
		_tmp13_ = _tmp12_->time;
		gtk_menu_popup (_tmp9_, NULL, NULL, NULL, NULL, _tmp11_, _tmp13_);
		result = TRUE;
		_g_object_unref0 (source_link_item);
		return result;
	}
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void pixbuf_button_source_link_item_activate_cb (PixbufButton* self) {
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp0_ = NULL;
	GtkClipboard* _tmp1_ = NULL;
	GtkClipboard* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (IS_PIXBUF_BUTTON (self));
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gtk_clipboard_get_for_display (_tmp0_, GDK_SELECTION_CLIPBOARD);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clipboard = _tmp2_;
	_tmp3_ = self->priv->menu_string;
	gtk_clipboard_set_text (clipboard, _tmp3_, -1);
	_g_object_unref0 (clipboard);
}


static gboolean pixbuf_button_real_draw (GtkWidget* base, cairo_t* ct) {
	PixbufButton * self;
	gboolean result = FALSE;
	GtkStyleContext* sc = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	gint widget_width = 0;
	gint _tmp2_ = 0;
	gint widget_height = 0;
	gint _tmp3_ = 0;
	cairo_surface_t* _tmp4_ = NULL;
	cairo_t* _tmp47_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PIXBUF_BUTTON, PixbufButton);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sc = _tmp1_;
	_tmp2_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_width = _tmp2_;
	_tmp3_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_height = _tmp3_;
	_tmp4_ = self->priv->bg;
	if (_tmp4_ != NULL) {
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp5_ = NULL;
		cairo_surface_t* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		cairo_surface_t* _tmp9_ = NULL;
		cairo_t* ctx = NULL;
		cairo_surface_t* _tmp10_ = NULL;
		cairo_t* _tmp11_ = NULL;
		cairo_t* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gdouble scale_x = 0.0;
		gint _tmp15_ = 0;
		cairo_surface_t* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gdouble scale_y = 0.0;
		gint _tmp18_ = 0;
		cairo_surface_t* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		cairo_t* _tmp21_ = NULL;
		cairo_t* _tmp22_ = NULL;
		gdouble _tmp23_ = 0.0;
		gdouble _tmp24_ = 0.0;
		cairo_t* _tmp25_ = NULL;
		cairo_surface_t* _tmp26_ = NULL;
		cairo_t* _tmp27_ = NULL;
		cairo_t* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
		cairo_t* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		cairo_t* _tmp44_ = NULL;
		cairo_surface_t* _tmp45_ = NULL;
		cairo_t* _tmp46_ = NULL;
		_tmp5_ = ct;
		_tmp6_ = cairo_get_target (_tmp5_);
		_tmp7_ = widget_width;
		_tmp8_ = widget_height;
		_tmp9_ = cairo_surface_create_similar (_tmp6_, CAIRO_CONTENT_COLOR_ALPHA, _tmp7_, _tmp8_);
		surface = _tmp9_;
		_tmp10_ = surface;
		_tmp11_ = cairo_create (_tmp10_);
		ctx = _tmp11_;
		_tmp12_ = ctx;
		_tmp13_ = widget_width;
		_tmp14_ = widget_height;
		cairo_rectangle (_tmp12_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp13_, (gdouble) _tmp14_);
		_tmp15_ = widget_width;
		_tmp16_ = self->priv->bg;
		_tmp17_ = cairo_image_surface_get_width (_tmp16_);
		scale_x = ((gdouble) _tmp15_) / _tmp17_;
		_tmp18_ = widget_height;
		_tmp19_ = self->priv->bg;
		_tmp20_ = cairo_image_surface_get_height (_tmp19_);
		scale_y = ((gdouble) _tmp18_) / _tmp20_;
		_tmp21_ = ctx;
		cairo_save (_tmp21_);
		_tmp22_ = ctx;
		_tmp23_ = scale_x;
		_tmp24_ = scale_y;
		cairo_scale (_tmp22_, _tmp23_, _tmp24_);
		_tmp25_ = ctx;
		_tmp26_ = self->priv->bg;
		cairo_set_source_surface (_tmp25_, _tmp26_, (gdouble) 0, (gdouble) 0);
		_tmp27_ = ctx;
		cairo_fill (_tmp27_);
		_tmp28_ = ctx;
		cairo_restore (_tmp28_);
		_tmp29_ = self->priv->_round;
		if (_tmp29_) {
			cairo_t* _tmp30_ = NULL;
			cairo_t* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			cairo_t* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			cairo_t* _tmp36_ = NULL;
			GtkStyleContext* _tmp37_ = NULL;
			cairo_t* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			_tmp30_ = ctx;
			cairo_set_operator (_tmp30_, CAIRO_OPERATOR_DEST_IN);
			_tmp31_ = ctx;
			_tmp32_ = widget_width;
			_tmp33_ = widget_height;
			cairo_translate (_tmp31_, (gdouble) (_tmp32_ / 2), (gdouble) (_tmp33_ / 2));
			_tmp34_ = ctx;
			_tmp35_ = widget_width;
			cairo_arc (_tmp34_, (gdouble) 0, (gdouble) 0, (gdouble) (_tmp35_ / 2), (gdouble) 0, 2 * G_PI);
			_tmp36_ = ctx;
			cairo_fill (_tmp36_);
			_tmp37_ = sc;
			_tmp38_ = ct;
			_tmp39_ = widget_width;
			_tmp40_ = widget_height;
			gtk_render_frame (_tmp37_, _tmp38_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp39_, (gdouble) _tmp40_);
		}
		_tmp41_ = ct;
		_tmp42_ = widget_width;
		_tmp43_ = widget_height;
		cairo_rectangle (_tmp41_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp42_, (gdouble) _tmp43_);
		_tmp44_ = ct;
		_tmp45_ = surface;
		cairo_set_source_surface (_tmp44_, _tmp45_, (gdouble) 0, (gdouble) 0);
		_tmp46_ = ct;
		cairo_fill (_tmp46_);
		_cairo_destroy0 (ctx);
		_cairo_surface_destroy0 (surface);
	}
	_tmp47_ = ct;
	GTK_WIDGET_CLASS (pixbuf_button_parent_class)->draw (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), gtk_widget_get_type (), GtkWidget), _tmp47_);
	result = G_SOURCE_CONTINUE;
	_g_object_unref0 (sc);
	return result;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


void pixbuf_button_set_bg (PixbufButton* self, cairo_surface_t* bg) {
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	cairo_surface_t* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_if_fail (IS_PIXBUF_BUTTON (self));
	g_return_if_fail (bg != NULL);
	_tmp0_ = bg;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	_cairo_surface_destroy0 (self->priv->bg);
	self->priv->bg = _tmp1_;
	_tmp2_ = bg;
	_tmp3_ = cairo_image_surface_get_width (_tmp2_);
	_tmp4_ = bg;
	_tmp5_ = cairo_image_surface_get_height (_tmp4_);
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp3_, _tmp5_);
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


void pixbuf_button_set_pixbuf (PixbufButton* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	g_return_if_fail (IS_PIXBUF_BUTTON (self));
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
	_tmp0_ = pixbuf;
	_tmp1_ = gdk_cairo_surface_create_from_pixbuf (_tmp0_, 1, NULL);
	_cairo_surface_destroy0 (self->priv->bg);
	self->priv->bg = (cairo_surface_t*) _tmp1_;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


gboolean pixbuf_button_get_round (PixbufButton* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (IS_PIXBUF_BUTTON (self), FALSE);
	_tmp0_ = self->priv->_round;
	result = _tmp0_;
	return result;
}


void pixbuf_button_set_round (PixbufButton* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_PIXBUF_BUTTON (self));
	_tmp0_ = value;
	if (_tmp0_) {
		GtkStyleContext* _tmp1_ = NULL;
		_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp1_, "pixbuf-button-round");
	} else {
		GtkStyleContext* _tmp2_ = NULL;
		_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_remove_class (_tmp2_, "pixbuf-button-round");
	}
	_tmp3_ = value;
	self->priv->_round = _tmp3_;
	g_object_notify ((GObject *) self, "round");
}


static GObject * pixbuf_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	PixbufButton * self;
	GtkStyleContext* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (pixbuf_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXBUF_BUTTON, PixbufButton);
	gtk_container_set_border_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), (guint) 0);
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp0_, "pixbuf-button");
	return obj;
}


static void pixbuf_button_class_init (PixbufButtonClass * klass) {
	pixbuf_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PixbufButtonPrivate));
	((GtkWidgetClass *) klass)->draw = pixbuf_button_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_pixbuf_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pixbuf_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = pixbuf_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = pixbuf_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PIXBUF_BUTTON_ROUND, g_param_spec_boolean ("round", "round", "round", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void pixbuf_button_instance_init (PixbufButton * self) {
	self->priv = PIXBUF_BUTTON_GET_PRIVATE (self);
	self->priv->_round = FALSE;
}


static void pixbuf_button_finalize (GObject* obj) {
	PixbufButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXBUF_BUTTON, PixbufButton);
	_cairo_surface_destroy0 (self->priv->bg);
	_g_object_unref0 (self->priv->menu);
	_g_free0 (self->priv->menu_string);
	G_OBJECT_CLASS (pixbuf_button_parent_class)->finalize (obj);
}


GType pixbuf_button_get_type (void) {
	static volatile gsize pixbuf_button_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PixbufButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufButton), 0, (GInstanceInitFunc) pixbuf_button_instance_init, NULL };
		GType pixbuf_button_type_id;
		pixbuf_button_type_id = g_type_register_static (gtk_button_get_type (), "PixbufButton", &g_define_type_info, 0);
		g_once_init_leave (&pixbuf_button_type_id__volatile, pixbuf_button_type_id);
	}
	return pixbuf_button_type_id__volatile;
}


static void _vala_pixbuf_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PixbufButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PIXBUF_BUTTON, PixbufButton);
	switch (property_id) {
		case PIXBUF_BUTTON_ROUND:
		g_value_set_boolean (value, pixbuf_button_get_round (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_pixbuf_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PixbufButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PIXBUF_BUTTON, PixbufButton);
	switch (property_id) {
		case PIXBUF_BUTTON_ROUND:
		pixbuf_button_set_round (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



