/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import gnu.java.lang.reflect.TypeImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

final class UnresolvedTypeVariable
extends TypeImpl
implements Type {
    private GenericDeclaration decl;
    private String name;

    UnresolvedTypeVariable(GenericDeclaration decl, String name) {
        this.decl = decl;
        this.name = name;
    }

    Type resolve() {
        GenericDeclaration d = this.decl;
        while (d != null) {
            TypeVariable<?>[] typeVariableArray = d.getTypeParameters();
            int n = typeVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeVariable<?> t = typeVariableArray[n2];
                if (t.getName().equals(this.name)) {
                    return t;
                }
                ++n2;
            }
            d = UnresolvedTypeVariable.getParent(d);
        }
        throw new MalformedParameterizedTypeException();
    }

    private static GenericDeclaration getParent(GenericDeclaration d) {
        if (d instanceof Class) {
            Method m = ((Class)d).getEnclosingMethod();
            if (m != null) {
                return m;
            }
            Constructor c = ((Class)d).getEnclosingConstructor();
            if (c != null) {
                return c;
            }
            return ((Class)d).getEnclosingClass();
        }
        if (d instanceof Method) {
            return ((Method)d).getDeclaringClass();
        }
        if (d instanceof Constructor) {
            return ((Constructor)d).getDeclaringClass();
        }
        throw new Error();
    }
}

