/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialContext
implements Context {
    protected Context defaultInitCtx;
    protected boolean gotDefault = false;
    protected Hashtable<Object, Object> myProps;
    static final HashSet<String> colon_list = new HashSet();
    static final String[] use_properties;

    static {
        colon_list.add("java.naming.factory.object");
        colon_list.add("java.naming.factory.url.pkgs");
        colon_list.add("java.naming.factory.state");
        use_properties = new String[]{"java.naming.dns.url", "java.naming.factory.initial", "java.naming.factory.object", "java.naming.provider.url", "java.naming.factory.state", "java.naming.factory.url.pkgs"};
    }

    public InitialContext(Hashtable<?, ?> environment) throws NamingException {
        this.init(environment);
    }

    protected InitialContext(boolean lazy) throws NamingException {
        if (!lazy) {
            this.init(null);
        }
    }

    public InitialContext() throws NamingException {
        this.init(null);
    }

    protected void init(Hashtable<?, ?> environment) throws NamingException {
        InputStream is;
        Properties p;
        Object url;
        this.myProps = environment != null ? environment : new Hashtable();
        Applet napplet = (Applet)this.myProps.get("java.naming.applet");
        Properties pApplet = null;
        if (napplet != null) {
            pApplet = new Properties();
        }
        Properties pSystem = new Properties();
        int i = use_properties.length - 1;
        while (i >= 0) {
            String value;
            String key = use_properties[i];
            if (napplet != null && (value = napplet.getParameter(key)) != null) {
                pApplet.put(key, value);
            }
            if ((value = System.getProperty(key)) != null) {
                pSystem.put(key, value);
            }
            --i;
        }
        InitialContext.merge(this.myProps, pSystem);
        if (pApplet != null) {
            InitialContext.merge(this.myProps, pApplet);
        }
        try {
            Enumeration<URL> ep = Thread.currentThread().getContextClassLoader().getResources("jndi.properties");
            while (ep.hasMoreElements()) {
                url = ep.nextElement();
                p = new Properties();
                try {
                    is = ((URL)url).openStream();
                    p.load(is);
                    is.close();
                }
                catch (IOException iOException) {}
                InitialContext.merge(this.myProps, p);
            }
        }
        catch (IOException iOException) {}
        String home = System.getProperty("gnu.classpath.home.url");
        if (home != null) {
            url = String.valueOf(home) + "/jndi.properties";
            p = new Properties();
            try {
                is = new URL((String)url).openStream();
                p.load(is);
                is.close();
            }
            catch (IOException iOException) {}
            InitialContext.merge(this.myProps, p);
        }
    }

    static void merge(Hashtable<Object, Object> primary, Hashtable<Object, Object> additional) {
        Enumeration<Object> en = additional.keys();
        while (en.hasMoreElements()) {
            String key2 = (String)en.nextElement();
            Object value1 = primary.get(key2);
            if (value1 == null) {
                primary.put(key2, additional.get(key2));
                continue;
            }
            if (!colon_list.contains(key2)) continue;
            String value2 = (String)additional.get(key2);
            primary.put(key2, String.valueOf((String)value1) + ":" + value2);
        }
    }

    protected Context getDefaultInitCtx() throws NamingException {
        if (!this.gotDefault) {
            this.defaultInitCtx = NamingManager.getInitialContext(this.myProps);
            this.gotDefault = true;
        }
        return this.defaultInitCtx;
    }

    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        if (name.size() > 0) {
            return this.getURLOrDefaultInitCtx(name.get(0));
        }
        return this.getDefaultInitCtx();
    }

    protected Context getURLOrDefaultInitCtx(String name) throws NamingException {
        Context context;
        String scheme = null;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        int colon = name.indexOf(58);
        int slash = name.indexOf(47);
        if (colon > 0 && (slash == -1 || colon < slash)) {
            scheme = name.substring(0, colon);
        }
        if (scheme != null && (context = NamingManager.getURLContext(scheme, this.myProps)) != null) {
            return context;
        }
        return this.getDefaultInitCtx();
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, obj);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        try {
            return this.getURLOrDefaultInitCtx(name).lookup(name);
        }
        catch (CannotProceedException cpe) {
            Context ctx = NamingManager.getContinuationContext(cpe);
            return ctx.lookup(cpe.getRemainingName());
        }
    }

    @Override
    public Object lookup(String name) throws NamingException {
        try {
            return this.getURLOrDefaultInitCtx(name).lookup(name);
        }
        catch (CannotProceedException cpe) {
            Context ctx = NamingManager.getContinuationContext(cpe);
            return ctx.lookup(cpe.getRemainingName());
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.getURLOrDefaultInitCtx(oldName).rename(oldName, newName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.getURLOrDefaultInitCtx(oldName).rename(oldName, newName);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).composeName(name, prefix);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.myProps.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.myProps.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.myProps;
    }

    @Override
    public void close() throws NamingException {
        this.myProps = null;
        this.defaultInitCtx = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }
}

