/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jarsigner;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.classpath.tools.common.CallbackUtil;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.common.ProviderUtil;
import gnu.classpath.tools.getopt.FileArgumentCallback;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.jarsigner.JarSigner;
import gnu.classpath.tools.jarsigner.JarVerifier;
import gnu.classpath.tools.jarsigner.Messages;
import gnu.java.security.OID;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class Main {
    protected static final Logger log = Logger.getLogger(Main.class.getName());
    static final String KEYTOOL_TOOL = "jarsigner";
    private static final Locale EN_US_LOCALE = new Locale("en", "US");
    static final String DIGEST = "SHA1-Digest";
    static final String DIGEST_MANIFEST = "SHA1-Digest-Manifest";
    static final Attributes.Name DIGEST_ATTR = new Attributes.Name("SHA1-Digest");
    static final Attributes.Name DIGEST_MANIFEST_ATTR = new Attributes.Name("SHA1-Digest-Manifest");
    static final OID DSA_SIGNATURE_OID = new OID("1.2.840.10040.4.1");
    static final OID RSA_SIGNATURE_OID = new OID("1.2.840.113549.1.1.1");
    protected boolean verify;
    protected String ksURL;
    protected String ksType;
    protected String password;
    protected String ksPassword;
    protected String sigFileName;
    protected String signedJarFileName;
    protected boolean verbose;
    protected boolean certs;
    protected boolean internalSF;
    protected boolean sectionsOnly;
    protected String providerClassName;
    protected String jarFileName;
    protected String alias;
    protected Provider provider;
    private boolean providerInstalled;
    private char[] ksPasswordChars;
    private KeyStore store;
    private char[] passwordChars;
    private PrivateKey signerPrivateKey;
    private Certificate[] signerCertificateChain;
    private CallbackHandler handler;
    private ToolParser cmdLineParser;
    protected ArrayList<String> fileAndAlias = new ArrayList();

    private Main() {
    }

    public static final void main(String[] args) {
        int result;
        block11: {
            block10: {
                if (Configuration.DEBUG) {
                    log.entering(Main.class.getName(), "main", args);
                }
                Main tool = new Main();
                result = 1;
                try {
                    tool.processArgs(args);
                    tool.start();
                    result = 0;
                }
                catch (SecurityException x) {
                    if (Configuration.DEBUG) {
                        log.throwing(Main.class.getName(), "main", x);
                    }
                    System.err.println(String.valueOf(Messages.getString("Main.7")) + x.getMessage());
                    tool.teardown();
                    break block10;
                }
                catch (Exception x) {
                    try {
                        if (Configuration.DEBUG) {
                            log.throwing(Main.class.getName(), "main", x);
                        }
                        System.err.println(String.valueOf(Messages.getString("Main.9")) + x);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        tool.teardown();
                    }
                }
                tool.teardown();
            }
            if (!Configuration.DEBUG) break block11;
            log.exiting(Main.class.getName(), "main", result);
        }
        System.exit(result);
    }

    private void processArgs(String[] args) throws Exception {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "processArgs", args);
        }
        this.cmdLineParser = new ToolParser();
        this.cmdLineParser.initializeParser();
        this.cmdLineParser.parse(args, new ToolParserCallback());
        this.setupCommonParams();
        if (this.verify) {
            if (Configuration.DEBUG) {
                log.fine("Will verify with the following parameters:");
                log.fine("     jar-file = '" + this.jarFileName + "'");
                log.fine("Options:");
                log.fine("     provider = '" + this.providerClassName + "'");
                log.fine("      verbose ? " + this.verbose);
                log.fine("        certs ? " + this.certs);
                log.fine("   internalsf ? " + this.internalSF);
                log.fine(" sectionsonly ? " + this.sectionsOnly);
            }
        } else {
            this.setupSigningParams();
            if (Configuration.DEBUG) {
                log.fine("Will sign with the following parameters:");
                log.fine("     jar-file = '" + this.jarFileName + "'");
                log.fine("        alias = '" + this.alias + "'");
                log.fine("Options:");
                log.fine("     keystore = '" + this.ksURL + "'");
                log.fine("    storetype = '" + this.ksType + "'");
                log.fine("    storepass = '" + this.ksPassword + "'");
                log.fine("      keypass = '" + this.password + "'");
                log.fine("      sigfile = '" + this.sigFileName + "'");
                log.fine("    signedjar = '" + this.signedJarFileName + "'");
                log.fine("     provider = '" + this.providerClassName + "'");
                log.fine("      verbose ? " + this.verbose);
                log.fine("   internalsf ? " + this.internalSF);
                log.fine(" sectionsonly ? " + this.sectionsOnly);
            }
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "processArgs");
        }
    }

    private void start() throws Exception {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        if (this.verify) {
            JarVerifier jv = new JarVerifier(this);
            jv.start();
        } else {
            JarSigner js = new JarSigner(this);
            js.start();
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    private void teardown() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "teardown");
        }
        if (this.providerInstalled) {
            ProviderUtil.removeProvider(this.provider.getName());
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "teardown");
        }
    }

    private void setupCommonParams() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        File jar;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "setupCommonParams");
        }
        if (!(jar = new File(this.jarFileName)).exists()) {
            throw new FileNotFoundException(this.jarFileName);
        }
        if (jar.isDirectory()) {
            throw new IOException(Messages.getFormattedString("Main.70", this.jarFileName));
        }
        if (!jar.canRead()) {
            throw new IOException(Messages.getFormattedString("Main.72", this.jarFileName));
        }
        if (this.providerClassName != null && this.providerClassName.length() > 0) {
            this.provider = (Provider)Class.forName(this.providerClassName).newInstance();
            String providerName = this.provider.getName();
            Provider installedProvider = Security.getProvider(providerName);
            if (installedProvider != null) {
                if (Configuration.DEBUG) {
                    log.finer("Provider " + providerName + " is already installed");
                }
            } else {
                this.installNewProvider();
            }
        }
        if (!this.verbose && this.certs) {
            if (Configuration.DEBUG) {
                log.fine("Option <certs> is set but <verbose> is not. Ignored");
            }
            this.certs = false;
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "setupCommonParams");
        }
    }

    private void installNewProvider() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "installNewProvider");
        }
        boolean bl = this.providerInstalled = ProviderUtil.addProvider(this.provider) != -1;
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "installNewProvider");
        }
    }

    private void setupSigningParams() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnsupportedCallbackException, UnrecoverableKeyException {
        Key key;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "setupSigningParams");
        }
        if (this.ksURL == null || this.ksURL.trim().length() == 0) {
            String userHome = SystemProperties.getProperty((String)"user.home");
            if (userHome == null || userHome.trim().length() == 0) {
                throw new SecurityException(Messages.getString("Main.85"));
            }
            this.ksURL = "file:" + userHome.trim() + "/.keystore";
        } else {
            this.ksURL = this.ksURL.trim();
            if (this.ksURL.indexOf(":") == -1) {
                this.ksURL = "file:" + this.ksURL;
            }
        }
        this.ksType = this.ksType == null || this.ksType.trim().length() == 0 ? KeyStore.getDefaultType() : this.ksType.trim();
        this.store = KeyStore.getInstance(this.ksType);
        if (this.ksPassword == null) {
            PasswordCallback pcb = new PasswordCallback(Messages.getString("Main.92"), false);
            this.getCallbackHandler().handle(new Callback[]{pcb});
            this.ksPasswordChars = pcb.getPassword();
        } else {
            this.ksPasswordChars = this.ksPassword.toCharArray();
        }
        URL url = new URL(this.ksURL);
        InputStream stream = url.openStream();
        this.store.load(stream, this.ksPasswordChars);
        if (!this.store.containsAlias(this.alias)) {
            throw new SecurityException(Messages.getFormattedString("Main.6", this.alias));
        }
        if (!this.store.isKeyEntry(this.alias)) {
            throw new SecurityException(Messages.getFormattedString("Main.95", this.alias));
        }
        if (this.password == null) {
            this.passwordChars = this.ksPasswordChars;
            try {
                key = this.store.getKey(this.alias, this.passwordChars);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                String prompt = Messages.getFormattedString("Main.97", this.alias);
                PasswordCallback pcb = new PasswordCallback(prompt, false);
                this.getCallbackHandler().handle(new Callback[]{pcb});
                this.passwordChars = pcb.getPassword();
                key = this.store.getKey(this.alias, this.passwordChars);
            }
        } else {
            this.passwordChars = this.password.toCharArray();
            key = this.store.getKey(this.alias, this.passwordChars);
        }
        if (!(key instanceof PrivateKey)) {
            throw new SecurityException(Messages.getFormattedString("Main.99", this.alias));
        }
        this.signerPrivateKey = (PrivateKey)key;
        this.signerCertificateChain = this.store.getCertificateChain(this.alias);
        if (Configuration.DEBUG) {
            log.fine(String.valueOf(this.signerCertificateChain));
        }
        if (this.sigFileName == null) {
            this.sigFileName = this.alias;
        }
        this.sigFileName = this.sigFileName.toUpperCase(EN_US_LOCALE);
        if (this.sigFileName.length() > 8) {
            this.sigFileName = this.sigFileName.substring(0, 8);
        }
        char[] chars = this.sigFileName.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_' && c != '-') {
                chars[i] = 95;
            }
            ++i;
        }
        this.sigFileName = new String(chars);
        if (this.signedJarFileName == null) {
            this.signedJarFileName = this.jarFileName;
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "setupSigningParams");
        }
    }

    boolean isVerbose() {
        return this.verbose;
    }

    boolean isCerts() {
        return this.certs;
    }

    String getSigFileName() {
        return this.sigFileName;
    }

    String getJarFileName() {
        return this.jarFileName;
    }

    boolean isSectionsOnly() {
        return this.sectionsOnly;
    }

    boolean isInternalSF() {
        return this.internalSF;
    }

    PrivateKey getSignerPrivateKey() {
        return this.signerPrivateKey;
    }

    Certificate[] getSignerCertificateChain() {
        return this.signerCertificateChain;
    }

    String getSignedJarFileName() {
        return this.signedJarFileName;
    }

    protected CallbackHandler getCallbackHandler() {
        if (this.handler == null) {
            this.handler = CallbackUtil.getConsoleHandler();
        }
        return this.handler;
    }

    private class ToolParser
    extends ClasspathToolParser {
        public ToolParser() {
            super(Main.KEYTOOL_TOOL, true);
        }

        protected void validate() throws OptionException {
            if (Main.this.fileAndAlias.size() < 1) {
                throw new OptionException(Messages.getString("Main.133"));
            }
            Main.this.jarFileName = Main.this.fileAndAlias.get(0);
            if (!Main.this.verify) {
                if (Main.this.fileAndAlias.size() < 2) {
                    if (Configuration.DEBUG) {
                        log.fine("Missing ALIAS argument. Will use [mykey] instead");
                    }
                    Main.this.alias = "mykey";
                } else {
                    Main.this.alias = Main.this.fileAndAlias.get(1);
                }
            }
        }

        public void initializeParser() {
            this.setHeader(Messages.getString("Main.2"));
            this.setFooter(Messages.getString("Main.1"));
            OptionGroup signGroup = new OptionGroup(Messages.getString("Main.0"));
            signGroup.add(new Option(this, "keystore", Messages.getString("Main.101"), Messages.getString("Main.102")){
                final /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                public void parsed(String argument) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).ksURL = argument;
                }
            });
            signGroup.add(new Option(this, "storetype", Messages.getString("Main.104"), Messages.getString("Main.105")){
                final /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                public void parsed(String argument) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).ksType = argument;
                }
            });
            signGroup.add(new Option(this, "storepass", Messages.getString("Main.107"), Messages.getString("Main.108")){
                final /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                public void parsed(String argument) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).ksPassword = argument;
                }
            });
            signGroup.add(new Option(this, "keypass", Messages.getString("Main.110"), Messages.getString("Main.111")){
                final /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                public void parsed(String argument) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).password = argument;
                }
            });
            signGroup.add(new Option(this, "sigfile", Messages.getString("Main.113"), Messages.getString("Main.114")){
                final /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                public void parsed(String argument) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).sigFileName = argument;
                }
            });
            signGroup.add(new Option(this, "signedjar", Messages.getString("Main.116"), Messages.getString("Main.117")){
                final /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                public void parsed(String argument) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).signedJarFileName = argument;
                }
            });
            this.add(signGroup);
            OptionGroup verifyGroup = new OptionGroup(Messages.getString("Main.118"));
            verifyGroup.add(new Option(this, "verify", Messages.getString("Main.120")){
                final /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super($anonymous0, $anonymous1);
                }

                public void parsed(String argument) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).verify = true;
                }
            });
            verifyGroup.add(new Option(this, "certs", Messages.getString("Main.122")){
                final /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super($anonymous0, $anonymous1);
                }

                public void parsed(String argument) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).certs = true;
                }
            });
            this.add(verifyGroup);
            OptionGroup commonGroup = new OptionGroup(Messages.getString("Main.123"));
            commonGroup.add(new Option(this, "verbose", Messages.getString("Main.125")){
                final /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super($anonymous0, $anonymous1);
                }

                public void parsed(String argument) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).verbose = true;
                }
            });
            commonGroup.add(new Option(this, "internalsf", Messages.getString("Main.127")){
                final /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super($anonymous0, $anonymous1);
                }

                public void parsed(String argument) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).internalSF = true;
                }
            });
            commonGroup.add(new Option(this, "sectionsonly", Messages.getString("Main.129")){
                final /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super($anonymous0, $anonymous1);
                }

                public void parsed(String argument) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).sectionsOnly = true;
                }
            });
            commonGroup.add(new Option(this, "provider", Messages.getString("Main.131"), Messages.getString("Main.132")){
                final /* synthetic */ ToolParser this$1;
                {
                    this.this$1 = toolParser;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                public void parsed(String argument) throws OptionException {
                    ToolParser.access$0((ToolParser)this.this$1).providerClassName = argument;
                }
            });
            this.add(commonGroup);
        }

        static /* synthetic */ Main access$0(ToolParser toolParser) {
            return toolParser.Main.this;
        }
    }

    private class ToolParserCallback
    extends FileArgumentCallback {
        private ToolParserCallback() {
        }

        public void notifyFile(String fileArgument) {
            Main.this.fileAndAlias.add(fileArgument);
        }
    }
}

