/*
 * $Id: ioperm.c,v 1.4 2003/01/31 14:58:57 telka Exp $
 *
 * ioperm()/iopl() implementation
 * Copyright (C) 2002, 2003 ETC s.r.o.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * Written by Marcel Telka <marcel@telka.sk>, 2002, 2003.
 *
 */

#include <windows.h>
#include <winioctl.h>

#include <errno.h>

#define	IOCTL_IOPERM	CTL_CODE( FILE_DEVICE_UNKNOWN, 0xA00, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define	IOCTL_IOPL	CTL_CODE( FILE_DEVICE_UNKNOWN, 0xA01, METHOD_BUFFERED, FILE_ANY_ACCESS )

struct ioperm_data {
	unsigned long from;
	unsigned long num;
	int turn_on;
};

struct iopl_data {
	int value;
};

int __declspec(dllexport)
ioperm( unsigned long from, unsigned long num, int turn_on )
{
	HANDLE h;
	struct ioperm_data ioperm_data;
	DWORD BytesReturned;
	BOOL r;
	OSVERSIONINFO version;

	version.dwOSVersionInfoSize = sizeof version;
	if (!GetVersionEx( &version )) {
		errno = EINVAL;
		return -1;
	}
	if (version.dwPlatformId != VER_PLATFORM_WIN32_NT)
		return 0;

	h = CreateFile( "\\\\.\\ioperm", GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
	if (h == INVALID_HANDLE_VALUE) {
		errno = ENODEV;
		return -1;
	}

	ioperm_data.from = from;
	ioperm_data.num = num;
	ioperm_data.turn_on = turn_on;

	r = DeviceIoControl( h, IOCTL_IOPERM, &ioperm_data, sizeof ioperm_data, NULL, 0, &BytesReturned, NULL );
	if (!r)
		errno = EPERM;

	CloseHandle( h );

	return r ? 0 : -1;
}

int __declspec(dllexport)
iopl( int value )
{
	HANDLE h;
	struct iopl_data iopl_data;
	DWORD BytesReturned;
	BOOL r;
	OSVERSIONINFO version;

	if ((value < 0) || (value > 3)) {
		errno = EINVAL;
		return -1;
	}

	version.dwOSVersionInfoSize = sizeof version;
	if (!GetVersionEx( &version )) {
		errno = EINVAL;
		return -1;
	}
	if (version.dwPlatformId != VER_PLATFORM_WIN32_NT)
		return 0;

	h = CreateFile( "\\\\.\\ioperm", GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
	if (h == INVALID_HANDLE_VALUE) {
		errno = ENODEV;
		return -1;
	}

	iopl_data.value = value;

	r = DeviceIoControl( h, IOCTL_IOPL, &iopl_data, sizeof iopl_data, NULL, 0, &BytesReturned, NULL );
	if (!r)
		errno = EPERM;

	CloseHandle( h );

	return r ? 0 : -1;
}
