/* key-event.c generated by valac 0.26.2, the Vala compiler
 * generated from key-event.vala, do not modify */

/*
 * Copyright (C) 2011-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define KKC_TYPE_MODIFIER_TYPE (kkc_modifier_type_get_type ())

#define KKC_TYPE_KEY_EVENT (kkc_key_event_get_type ())
#define KKC_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEvent))
#define KKC_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))
#define KKC_IS_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEY_EVENT))
#define KKC_IS_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEY_EVENT))
#define KKC_KEY_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))

typedef struct _KkcKeyEvent KkcKeyEvent;
typedef struct _KkcKeyEventClass KkcKeyEventClass;
typedef struct _KkcKeyEventPrivate KkcKeyEventPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED,
	KKC_KEY_EVENT_FORMAT_ERROR_KEYSYM_NOT_FOUND
} KkcKeyEventFormatError;
#define KKC_KEY_EVENT_FORMAT_ERROR kkc_key_event_format_error_quark ()
typedef enum  {
	KKC_MODIFIER_TYPE_NONE = 0,
	KKC_MODIFIER_TYPE_SHIFT_MASK = 1 << 0,
	KKC_MODIFIER_TYPE_LOCK_MASK = 1 << 1,
	KKC_MODIFIER_TYPE_CONTROL_MASK = 1 << 2,
	KKC_MODIFIER_TYPE_MOD1_MASK = 1 << 3,
	KKC_MODIFIER_TYPE_MOD2_MASK = 1 << 4,
	KKC_MODIFIER_TYPE_MOD3_MASK = 1 << 5,
	KKC_MODIFIER_TYPE_MOD4_MASK = 1 << 6,
	KKC_MODIFIER_TYPE_MOD5_MASK = 1 << 7,
	KKC_MODIFIER_TYPE_LSHIFT_MASK = 1 << 22,
	KKC_MODIFIER_TYPE_RSHIFT_MASK = 1 << 23,
	KKC_MODIFIER_TYPE_SUPER_MASK = 1 << 26,
	KKC_MODIFIER_TYPE_HYPER_MASK = 1 << 27,
	KKC_MODIFIER_TYPE_META_MASK = 1 << 28,
	KKC_MODIFIER_TYPE_RELEASE_MASK = 1 << 30
} KkcModifierType;

struct _KkcKeyEvent {
	GObject parent_instance;
	KkcKeyEventPrivate * priv;
};

struct _KkcKeyEventClass {
	GObjectClass parent_class;
};

struct _KkcKeyEventPrivate {
	gchar* _name;
	gunichar _unicode;
	guint _keyval;
	guint _keycode;
	KkcModifierType _modifiers;
};


static gpointer kkc_key_event_parent_class = NULL;

GQuark kkc_key_event_format_error_quark (void);
GType kkc_modifier_type_get_type (void) G_GNUC_CONST;
GType kkc_key_event_get_type (void) G_GNUC_CONST;
#define KKC_KEY_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_KEY_EVENT, KkcKeyEventPrivate))
enum  {
	KKC_KEY_EVENT_DUMMY_PROPERTY,
	KKC_KEY_EVENT_NAME,
	KKC_KEY_EVENT_UNICODE,
	KKC_KEY_EVENT_KEYVAL,
	KKC_KEY_EVENT_KEYCODE,
	KKC_KEY_EVENT_MODIFIERS
};
KkcKeyEvent* kkc_key_event_new_from_string (const gchar* key, GError** error);
KkcKeyEvent* kkc_key_event_construct_from_string (GType object_type, const gchar* key, GError** error);
#define KKC_KEYSYMS_VoidSymbol ((guint) 0xffffff)
guint kkc_key_event_utils_keyval_from_name (const gchar* name);
KkcKeyEvent* kkc_key_event_new_from_x_event (guint keyval, guint keycode, KkcModifierType modifiers);
KkcKeyEvent* kkc_key_event_construct_from_x_event (GType object_type, guint keyval, guint keycode, KkcModifierType modifiers);
gchar* kkc_key_event_to_string (KkcKeyEvent* self);
const gchar* kkc_key_event_get_name (KkcKeyEvent* self);
gunichar kkc_key_event_get_unicode (KkcKeyEvent* self);
KkcModifierType kkc_key_event_get_modifiers (KkcKeyEvent* self);
KkcKeyEvent* kkc_key_event_new (guint keyval, guint keycode, KkcModifierType modifiers);
KkcKeyEvent* kkc_key_event_construct (GType object_type, guint keyval, guint keycode, KkcModifierType modifiers);
gchar* kkc_key_event_utils_keyval_name (guint keyval);
void kkc_key_event_set_name (KkcKeyEvent* self, const gchar* value);
gunichar kkc_key_event_utils_keyval_unicode (guint keyval);
void kkc_key_event_set_unicode (KkcKeyEvent* self, gunichar value);
void kkc_key_event_set_keyval (KkcKeyEvent* self, guint value);
void kkc_key_event_set_keycode (KkcKeyEvent* self, guint value);
void kkc_key_event_set_modifiers (KkcKeyEvent* self, KkcModifierType value);
guint kkc_key_event_get_keyval (KkcKeyEvent* self);
guint kkc_key_event_get_keycode (KkcKeyEvent* self);
static void kkc_key_event_finalize (GObject* obj);
static void _vala_kkc_key_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_kkc_key_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark kkc_key_event_format_error_quark (void) {
	return g_quark_from_static_string ("kkc_key_event_format_error-quark");
}


/**
     * A set of bit-flags to indicate the state of modifier keys.
     */
GType kkc_modifier_type_get_type (void) {
	static volatile gsize kkc_modifier_type_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_modifier_type_type_id__volatile)) {
		static const GFlagsValue values[] = {{KKC_MODIFIER_TYPE_NONE, "KKC_MODIFIER_TYPE_NONE", "none"}, {KKC_MODIFIER_TYPE_SHIFT_MASK, "KKC_MODIFIER_TYPE_SHIFT_MASK", "shift-mask"}, {KKC_MODIFIER_TYPE_LOCK_MASK, "KKC_MODIFIER_TYPE_LOCK_MASK", "lock-mask"}, {KKC_MODIFIER_TYPE_CONTROL_MASK, "KKC_MODIFIER_TYPE_CONTROL_MASK", "control-mask"}, {KKC_MODIFIER_TYPE_MOD1_MASK, "KKC_MODIFIER_TYPE_MOD1_MASK", "mod1-mask"}, {KKC_MODIFIER_TYPE_MOD2_MASK, "KKC_MODIFIER_TYPE_MOD2_MASK", "mod2-mask"}, {KKC_MODIFIER_TYPE_MOD3_MASK, "KKC_MODIFIER_TYPE_MOD3_MASK", "mod3-mask"}, {KKC_MODIFIER_TYPE_MOD4_MASK, "KKC_MODIFIER_TYPE_MOD4_MASK", "mod4-mask"}, {KKC_MODIFIER_TYPE_MOD5_MASK, "KKC_MODIFIER_TYPE_MOD5_MASK", "mod5-mask"}, {KKC_MODIFIER_TYPE_LSHIFT_MASK, "KKC_MODIFIER_TYPE_LSHIFT_MASK", "lshift-mask"}, {KKC_MODIFIER_TYPE_RSHIFT_MASK, "KKC_MODIFIER_TYPE_RSHIFT_MASK", "rshift-mask"}, {KKC_MODIFIER_TYPE_SUPER_MASK, "KKC_MODIFIER_TYPE_SUPER_MASK", "super-mask"}, {KKC_MODIFIER_TYPE_HYPER_MASK, "KKC_MODIFIER_TYPE_HYPER_MASK", "hyper-mask"}, {KKC_MODIFIER_TYPE_META_MASK, "KKC_MODIFIER_TYPE_META_MASK", "meta-mask"}, {KKC_MODIFIER_TYPE_RELEASE_MASK, "KKC_MODIFIER_TYPE_RELEASE_MASK", "release-mask"}, {0, NULL, NULL}};
		GType kkc_modifier_type_type_id;
		kkc_modifier_type_type_id = g_flags_register_static ("KkcModifierType", values);
		g_once_init_leave (&kkc_modifier_type_type_id__volatile, kkc_modifier_type_type_id);
	}
	return kkc_modifier_type_type_id__volatile;
}


/**
         * Create a key event from string.
         *
         * @param key a string representation of a key event
         *
         * @return a new KeyEvent
         */
static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


KkcKeyEvent* kkc_key_event_construct_from_string (GType object_type, const gchar* key, GError** error) {
	KkcKeyEvent * self = NULL;
	KkcModifierType _modifiers = 0;
	guint _keyval = 0U;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	guint _tmp96_ = 0U;
	KkcModifierType _tmp97_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	_modifiers = 0;
	_keyval = KKC_KEYSYMS_VoidSymbol;
	_tmp1_ = key;
	_tmp2_ = g_str_has_prefix (_tmp1_, "(");
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = key;
		_tmp4_ = g_str_has_suffix (_tmp3_, ")");
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** strv = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		gint strv_length1 = 0;
		gint _strv_size_ = 0;
		gint index = 0;
		gchar** _tmp55_ = NULL;
		gint _tmp55__length1 = 0;
		gint _tmp56_ = 0;
		const gchar* _tmp57_ = NULL;
		guint _tmp58_ = 0U;
		guint _tmp59_ = 0U;
		_tmp5_ = key;
		_tmp6_ = string_slice (_tmp5_, (glong) 1, (glong) (-1));
		_tmp7_ = _tmp6_;
		_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, " ", 0);
		_tmp10_ = _tmp9_;
		_tmp10__length1 = _vala_array_length (_tmp8_);
		_g_free0 (_tmp7_);
		strv = _tmp10_;
		strv_length1 = _tmp10__length1;
		_strv_size_ = strv_length1;
		index = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gchar** _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				gint _tmp16_ = 0;
				const gchar* _tmp17_ = NULL;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = index;
					index = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = index;
				_tmp14_ = strv;
				_tmp14__length1 = strv_length1;
				if (!(_tmp13_ < (_tmp14__length1 - 1))) {
					break;
				}
				_tmp15_ = strv;
				_tmp15__length1 = strv_length1;
				_tmp16_ = index;
				_tmp17_ = _tmp15_[_tmp16_];
				if (g_strcmp0 (_tmp17_, "shift") == 0) {
					KkcModifierType _tmp18_ = 0;
					_tmp18_ = _modifiers;
					_modifiers = _tmp18_ | KKC_MODIFIER_TYPE_SHIFT_MASK;
				} else {
					gchar** _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					gint _tmp20_ = 0;
					const gchar* _tmp21_ = NULL;
					_tmp19_ = strv;
					_tmp19__length1 = strv_length1;
					_tmp20_ = index;
					_tmp21_ = _tmp19_[_tmp20_];
					if (g_strcmp0 (_tmp21_, "control") == 0) {
						KkcModifierType _tmp22_ = 0;
						_tmp22_ = _modifiers;
						_modifiers = _tmp22_ | KKC_MODIFIER_TYPE_CONTROL_MASK;
					} else {
						gchar** _tmp23_ = NULL;
						gint _tmp23__length1 = 0;
						gint _tmp24_ = 0;
						const gchar* _tmp25_ = NULL;
						_tmp23_ = strv;
						_tmp23__length1 = strv_length1;
						_tmp24_ = index;
						_tmp25_ = _tmp23_[_tmp24_];
						if (g_strcmp0 (_tmp25_, "meta") == 0) {
							KkcModifierType _tmp26_ = 0;
							_tmp26_ = _modifiers;
							_modifiers = _tmp26_ | KKC_MODIFIER_TYPE_META_MASK;
						} else {
							gchar** _tmp27_ = NULL;
							gint _tmp27__length1 = 0;
							gint _tmp28_ = 0;
							const gchar* _tmp29_ = NULL;
							_tmp27_ = strv;
							_tmp27__length1 = strv_length1;
							_tmp28_ = index;
							_tmp29_ = _tmp27_[_tmp28_];
							if (g_strcmp0 (_tmp29_, "hyper") == 0) {
								KkcModifierType _tmp30_ = 0;
								_tmp30_ = _modifiers;
								_modifiers = _tmp30_ | KKC_MODIFIER_TYPE_HYPER_MASK;
							} else {
								gchar** _tmp31_ = NULL;
								gint _tmp31__length1 = 0;
								gint _tmp32_ = 0;
								const gchar* _tmp33_ = NULL;
								_tmp31_ = strv;
								_tmp31__length1 = strv_length1;
								_tmp32_ = index;
								_tmp33_ = _tmp31_[_tmp32_];
								if (g_strcmp0 (_tmp33_, "super") == 0) {
									KkcModifierType _tmp34_ = 0;
									_tmp34_ = _modifiers;
									_modifiers = _tmp34_ | KKC_MODIFIER_TYPE_SUPER_MASK;
								} else {
									gchar** _tmp35_ = NULL;
									gint _tmp35__length1 = 0;
									gint _tmp36_ = 0;
									const gchar* _tmp37_ = NULL;
									_tmp35_ = strv;
									_tmp35__length1 = strv_length1;
									_tmp36_ = index;
									_tmp37_ = _tmp35_[_tmp36_];
									if (g_strcmp0 (_tmp37_, "alt") == 0) {
										KkcModifierType _tmp38_ = 0;
										_tmp38_ = _modifiers;
										_modifiers = _tmp38_ | KKC_MODIFIER_TYPE_MOD1_MASK;
									} else {
										gchar** _tmp39_ = NULL;
										gint _tmp39__length1 = 0;
										gint _tmp40_ = 0;
										const gchar* _tmp41_ = NULL;
										_tmp39_ = strv;
										_tmp39__length1 = strv_length1;
										_tmp40_ = index;
										_tmp41_ = _tmp39_[_tmp40_];
										if (g_strcmp0 (_tmp41_, "lshift") == 0) {
											KkcModifierType _tmp42_ = 0;
											_tmp42_ = _modifiers;
											_modifiers = _tmp42_ | KKC_MODIFIER_TYPE_LSHIFT_MASK;
										} else {
											gchar** _tmp43_ = NULL;
											gint _tmp43__length1 = 0;
											gint _tmp44_ = 0;
											const gchar* _tmp45_ = NULL;
											_tmp43_ = strv;
											_tmp43__length1 = strv_length1;
											_tmp44_ = index;
											_tmp45_ = _tmp43_[_tmp44_];
											if (g_strcmp0 (_tmp45_, "rshift") == 0) {
												KkcModifierType _tmp46_ = 0;
												_tmp46_ = _modifiers;
												_modifiers = _tmp46_ | KKC_MODIFIER_TYPE_RSHIFT_MASK;
											} else {
												gchar** _tmp47_ = NULL;
												gint _tmp47__length1 = 0;
												gint _tmp48_ = 0;
												const gchar* _tmp49_ = NULL;
												_tmp47_ = strv;
												_tmp47__length1 = strv_length1;
												_tmp48_ = index;
												_tmp49_ = _tmp47_[_tmp48_];
												if (g_strcmp0 (_tmp49_, "release") == 0) {
													KkcModifierType _tmp50_ = 0;
													_tmp50_ = _modifiers;
													_modifiers = _tmp50_ | KKC_MODIFIER_TYPE_RELEASE_MASK;
												} else {
													gchar** _tmp51_ = NULL;
													gint _tmp51__length1 = 0;
													gint _tmp52_ = 0;
													const gchar* _tmp53_ = NULL;
													GError* _tmp54_ = NULL;
													_tmp51_ = strv;
													_tmp51__length1 = strv_length1;
													_tmp52_ = index;
													_tmp53_ = _tmp51_[_tmp52_];
													_tmp54_ = g_error_new (KKC_KEY_EVENT_FORMAT_ERROR, KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown modifier %s", _tmp53_);
													_inner_error_ = _tmp54_;
													if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
														g_propagate_error (error, _inner_error_);
														strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
														_g_object_unref0 (self);
														return NULL;
													} else {
														strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp55_ = strv;
		_tmp55__length1 = strv_length1;
		_tmp56_ = index;
		_tmp57_ = _tmp55_[_tmp56_];
		_tmp58_ = kkc_key_event_utils_keyval_from_name (_tmp57_);
		_keyval = _tmp58_;
		_tmp59_ = _keyval;
		if (_tmp59_ == KKC_KEYSYMS_VoidSymbol) {
			gchar** _tmp60_ = NULL;
			gint _tmp60__length1 = 0;
			gint _tmp61_ = 0;
			const gchar* _tmp62_ = NULL;
			GError* _tmp63_ = NULL;
			_tmp60_ = strv;
			_tmp60__length1 = strv_length1;
			_tmp61_ = index;
			_tmp62_ = _tmp60_[_tmp61_];
			_tmp63_ = g_error_new (KKC_KEY_EVENT_FORMAT_ERROR, KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown keyval %s", _tmp62_);
			_inner_error_ = _tmp63_;
			if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
				g_propagate_error (error, _inner_error_);
				strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (self);
				return NULL;
			} else {
				strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gint index = 0;
		const gchar* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		gchar* _name = NULL;
		gint _tmp66_ = 0;
		const gchar* _tmp91_ = NULL;
		guint _tmp92_ = 0U;
		guint _tmp93_ = 0U;
		_tmp64_ = key;
		_tmp65_ = string_last_index_of (_tmp64_, "-", 0);
		index = _tmp65_;
		_name = NULL;
		_tmp66_ = index;
		if (_tmp66_ > 0) {
			gchar** mods = NULL;
			const gchar* _tmp67_ = NULL;
			gint _tmp68_ = 0;
			gchar* _tmp69_ = NULL;
			gchar* _tmp70_ = NULL;
			gchar** _tmp71_ = NULL;
			gchar** _tmp72_ = NULL;
			gchar** _tmp73_ = NULL;
			gint _tmp73__length1 = 0;
			gint mods_length1 = 0;
			gint _mods_size_ = 0;
			gchar** _tmp74_ = NULL;
			gint _tmp74__length1 = 0;
			const gchar* _tmp86_ = NULL;
			gint _tmp87_ = 0;
			gchar* _tmp88_ = NULL;
			_tmp67_ = key;
			_tmp68_ = index;
			_tmp69_ = string_substring (_tmp67_, (glong) 0, (glong) _tmp68_);
			_tmp70_ = _tmp69_;
			_tmp72_ = _tmp71_ = g_strsplit (_tmp70_, "-", 0);
			_tmp73_ = _tmp72_;
			_tmp73__length1 = _vala_array_length (_tmp71_);
			_g_free0 (_tmp70_);
			mods = _tmp73_;
			mods_length1 = _tmp73__length1;
			_mods_size_ = mods_length1;
			_tmp74_ = mods;
			_tmp74__length1 = mods_length1;
			{
				gchar** mod_collection = NULL;
				gint mod_collection_length1 = 0;
				gint _mod_collection_size_ = 0;
				gint mod_it = 0;
				mod_collection = _tmp74_;
				mod_collection_length1 = _tmp74__length1;
				for (mod_it = 0; mod_it < _tmp74__length1; mod_it = mod_it + 1) {
					gchar* _tmp75_ = NULL;
					gchar* mod = NULL;
					_tmp75_ = g_strdup (mod_collection[mod_it]);
					mod = _tmp75_;
					{
						const gchar* _tmp76_ = NULL;
						_tmp76_ = mod;
						if (g_strcmp0 (_tmp76_, "S") == 0) {
							KkcModifierType _tmp77_ = 0;
							_tmp77_ = _modifiers;
							_modifiers = _tmp77_ | KKC_MODIFIER_TYPE_SHIFT_MASK;
						} else {
							const gchar* _tmp78_ = NULL;
							_tmp78_ = mod;
							if (g_strcmp0 (_tmp78_, "C") == 0) {
								KkcModifierType _tmp79_ = 0;
								_tmp79_ = _modifiers;
								_modifiers = _tmp79_ | KKC_MODIFIER_TYPE_CONTROL_MASK;
							} else {
								const gchar* _tmp80_ = NULL;
								_tmp80_ = mod;
								if (g_strcmp0 (_tmp80_, "A") == 0) {
									KkcModifierType _tmp81_ = 0;
									_tmp81_ = _modifiers;
									_modifiers = _tmp81_ | KKC_MODIFIER_TYPE_MOD1_MASK;
								} else {
									const gchar* _tmp82_ = NULL;
									_tmp82_ = mod;
									if (g_strcmp0 (_tmp82_, "M") == 0) {
										KkcModifierType _tmp83_ = 0;
										_tmp83_ = _modifiers;
										_modifiers = _tmp83_ | KKC_MODIFIER_TYPE_META_MASK;
									} else {
										const gchar* _tmp84_ = NULL;
										_tmp84_ = mod;
										if (g_strcmp0 (_tmp84_, "G") == 0) {
											KkcModifierType _tmp85_ = 0;
											_tmp85_ = _modifiers;
											_modifiers = _tmp85_ | KKC_MODIFIER_TYPE_MOD5_MASK;
										}
									}
								}
							}
						}
						_g_free0 (mod);
					}
				}
			}
			_tmp86_ = key;
			_tmp87_ = index;
			_tmp88_ = string_substring (_tmp86_, (glong) (_tmp87_ + 1), (glong) (-1));
			_g_free0 (_name);
			_name = _tmp88_;
			mods = (_vala_array_free (mods, mods_length1, (GDestroyNotify) g_free), NULL);
		} else {
			const gchar* _tmp89_ = NULL;
			gchar* _tmp90_ = NULL;
			_modifiers = KKC_MODIFIER_TYPE_NONE;
			_tmp89_ = key;
			_tmp90_ = g_strdup (_tmp89_);
			_g_free0 (_name);
			_name = _tmp90_;
		}
		_tmp91_ = _name;
		_tmp92_ = kkc_key_event_utils_keyval_from_name (_tmp91_);
		_keyval = _tmp92_;
		_tmp93_ = _keyval;
		if (_tmp93_ == KKC_KEYSYMS_VoidSymbol) {
			const gchar* _tmp94_ = NULL;
			GError* _tmp95_ = NULL;
			_tmp94_ = _name;
			_tmp95_ = g_error_new (KKC_KEY_EVENT_FORMAT_ERROR, KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown keyval %s", _tmp94_);
			_inner_error_ = _tmp95_;
			if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_name);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_g_free0 (_name);
	}
	_tmp96_ = _keyval;
	_tmp97_ = _modifiers;
	self = (KkcKeyEvent*) kkc_key_event_construct_from_x_event (object_type, _tmp96_, (guint) 0, _tmp97_);
	return self;
}


KkcKeyEvent* kkc_key_event_new_from_string (const gchar* key, GError** error) {
	return kkc_key_event_construct_from_string (KKC_TYPE_KEY_EVENT, key, error);
}


/**
         * Convert the KeyEvent to string.
         *
         * @return a string representing the KeyEvent
         */
static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == (-1)) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != (-1)) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == (-1)) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


gchar* kkc_key_event_to_string (KkcKeyEvent* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _base = NULL;
	gchar* _tmp6_ = NULL;
	KkcModifierType _tmp7_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_name;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = self->priv->_name;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gunichar _tmp4_ = 0U;
		gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->_unicode;
		_tmp5_ = g_unichar_to_string (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp0_);
	_base = _tmp6_;
	_tmp7_ = self->priv->_modifiers;
	if (_tmp7_ != 0) {
		GeeArrayList* elements = NULL;
		GeeArrayList* _tmp8_ = NULL;
		KkcModifierType _tmp9_ = 0;
		KkcModifierType _tmp11_ = 0;
		KkcModifierType _tmp13_ = 0;
		KkcModifierType _tmp15_ = 0;
		KkcModifierType _tmp17_ = 0;
		KkcModifierType _tmp19_ = 0;
		KkcModifierType _tmp21_ = 0;
		KkcModifierType _tmp23_ = 0;
		KkcModifierType _tmp25_ = 0;
		GeeArrayList* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		GeeArrayList* _tmp29_ = NULL;
		gchar** array = NULL;
		GeeArrayList* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gpointer* _tmp32_ = NULL;
		gint array_length1 = 0;
		gint _array_size_ = 0;
		gint _tmp33_ = 0;
		gchar** _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		elements = _tmp8_;
		_tmp9_ = self->priv->_modifiers;
		if ((_tmp9_ & KKC_MODIFIER_TYPE_SHIFT_MASK) != 0) {
			GeeArrayList* _tmp10_ = NULL;
			_tmp10_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "shift");
		}
		_tmp11_ = self->priv->_modifiers;
		if ((_tmp11_ & KKC_MODIFIER_TYPE_CONTROL_MASK) != 0) {
			GeeArrayList* _tmp12_ = NULL;
			_tmp12_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "control");
		}
		_tmp13_ = self->priv->_modifiers;
		if ((_tmp13_ & KKC_MODIFIER_TYPE_META_MASK) != 0) {
			GeeArrayList* _tmp14_ = NULL;
			_tmp14_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "meta");
		}
		_tmp15_ = self->priv->_modifiers;
		if ((_tmp15_ & KKC_MODIFIER_TYPE_HYPER_MASK) != 0) {
			GeeArrayList* _tmp16_ = NULL;
			_tmp16_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, "hyper");
		}
		_tmp17_ = self->priv->_modifiers;
		if ((_tmp17_ & KKC_MODIFIER_TYPE_SUPER_MASK) != 0) {
			GeeArrayList* _tmp18_ = NULL;
			_tmp18_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, "super");
		}
		_tmp19_ = self->priv->_modifiers;
		if ((_tmp19_ & KKC_MODIFIER_TYPE_MOD1_MASK) != 0) {
			GeeArrayList* _tmp20_ = NULL;
			_tmp20_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, "alt");
		}
		_tmp21_ = self->priv->_modifiers;
		if ((_tmp21_ & KKC_MODIFIER_TYPE_LSHIFT_MASK) != 0) {
			GeeArrayList* _tmp22_ = NULL;
			_tmp22_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, "lshift");
		}
		_tmp23_ = self->priv->_modifiers;
		if ((_tmp23_ & KKC_MODIFIER_TYPE_RSHIFT_MASK) != 0) {
			GeeArrayList* _tmp24_ = NULL;
			_tmp24_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, "rshift");
		}
		_tmp25_ = self->priv->_modifiers;
		if ((_tmp25_ & KKC_MODIFIER_TYPE_RELEASE_MASK) != 0) {
			GeeArrayList* _tmp26_ = NULL;
			_tmp26_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, "release");
		}
		_tmp27_ = elements;
		_tmp28_ = _base;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
		_tmp29_ = elements;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, NULL);
		_tmp30_ = elements;
		_tmp32_ = gee_collection_to_array ((GeeCollection*) _tmp30_, &_tmp31_);
		array = _tmp32_;
		array_length1 = _tmp31_;
		_array_size_ = array_length1;
		array_length1 = -1;
		_tmp33_ = array_length1;
		_tmp34_ = array;
		_tmp34__length1 = array_length1;
		_tmp35_ = _vala_g_strjoinv (" ", _tmp34_, _tmp34__length1);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat ("(", _tmp36_, NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat (_tmp38_, ")", NULL);
		_tmp40_ = _tmp39_;
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		result = _tmp40_;
		array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (elements);
		_g_free0 (_base);
		_g_free0 (_tmp0_);
		return result;
	} else {
		result = _base;
		_g_free0 (_tmp0_);
		return result;
	}
	_g_free0 (_base);
	_g_free0 (_tmp0_);
}


KkcKeyEvent* kkc_key_event_construct_from_x_event (GType object_type, guint keyval, guint keycode, KkcModifierType modifiers) {
	KkcKeyEvent * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	KkcModifierType _tmp2_ = 0;
	_tmp0_ = keyval;
	_tmp1_ = keycode;
	_tmp2_ = modifiers;
	self = (KkcKeyEvent*) kkc_key_event_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


KkcKeyEvent* kkc_key_event_new_from_x_event (guint keyval, guint keycode, KkcModifierType modifiers) {
	return kkc_key_event_construct_from_x_event (KKC_TYPE_KEY_EVENT, keyval, keycode, modifiers);
}


/**
         * Create a key event from an X event.
         *
         * @param keyval an X keysym
         * @param keycode an X keycode
         * @param modifiers modifier mask
         *
         * @return a new KeyEvent
         */
KkcKeyEvent* kkc_key_event_construct (GType object_type, guint keyval, guint keycode, KkcModifierType modifiers) {
	KkcKeyEvent * self = NULL;
	guint _tmp0_ = 0U;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gunichar _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	guint _tmp6_ = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	KkcModifierType _tmp11_ = 0;
	self = (KkcKeyEvent*) g_object_new (object_type, NULL);
	_tmp0_ = keyval;
	_tmp1_ = kkc_key_event_utils_keyval_name (_tmp0_);
	_tmp2_ = _tmp1_;
	kkc_key_event_set_name (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = keyval;
	_tmp4_ = kkc_key_event_utils_keyval_unicode (_tmp3_);
	kkc_key_event_set_unicode (self, _tmp4_);
	_tmp6_ = keyval;
	if (((guint) 0x21) <= _tmp6_) {
		guint _tmp7_ = 0U;
		_tmp7_ = keyval;
		_tmp5_ = _tmp7_ < ((guint) 0x7F);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		KkcModifierType _tmp8_ = 0;
		_tmp8_ = modifiers;
		modifiers = _tmp8_ & (~(KKC_MODIFIER_TYPE_SHIFT_MASK | KKC_MODIFIER_TYPE_MOD5_MASK));
	}
	_tmp9_ = keyval;
	kkc_key_event_set_keyval (self, _tmp9_);
	_tmp10_ = keycode;
	kkc_key_event_set_keycode (self, _tmp10_);
	_tmp11_ = modifiers;
	kkc_key_event_set_modifiers (self, _tmp11_);
	return self;
}


KkcKeyEvent* kkc_key_event_new (guint keyval, guint keycode, KkcModifierType modifiers) {
	return kkc_key_event_construct (KKC_TYPE_KEY_EVENT, keyval, keycode, modifiers);
}


const gchar* kkc_key_event_get_name (KkcKeyEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void kkc_key_event_set_name (KkcKeyEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


gunichar kkc_key_event_get_unicode (KkcKeyEvent* self) {
	gunichar result;
	gunichar _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_unicode;
	result = _tmp0_;
	return result;
}


void kkc_key_event_set_unicode (KkcKeyEvent* self, gunichar value) {
	gunichar _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_unicode = _tmp0_;
	g_object_notify ((GObject *) self, "unicode");
}


guint kkc_key_event_get_keyval (KkcKeyEvent* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_keyval;
	result = _tmp0_;
	return result;
}


void kkc_key_event_set_keyval (KkcKeyEvent* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_keyval = _tmp0_;
	g_object_notify ((GObject *) self, "keyval");
}


guint kkc_key_event_get_keycode (KkcKeyEvent* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_keycode;
	result = _tmp0_;
	return result;
}


void kkc_key_event_set_keycode (KkcKeyEvent* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_keycode = _tmp0_;
	g_object_notify ((GObject *) self, "keycode");
}


KkcModifierType kkc_key_event_get_modifiers (KkcKeyEvent* self) {
	KkcModifierType result;
	KkcModifierType _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}


void kkc_key_event_set_modifiers (KkcKeyEvent* self, KkcModifierType value) {
	KkcModifierType _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_modifiers = _tmp0_;
	g_object_notify ((GObject *) self, "modifiers");
}


static void kkc_key_event_class_init (KkcKeyEventClass * klass) {
	kkc_key_event_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcKeyEventPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_key_event_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_kkc_key_event_set_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_key_event_finalize;
	/**
	         * The base name of the KeyEvent.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_KEY_EVENT_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	         * The base unicode output of the KeyEvent.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_KEY_EVENT_UNICODE, g_param_spec_uint ("unicode", "unicode", "unicode", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	         * X keyval.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_KEY_EVENT_KEYVAL, g_param_spec_uint ("keyval", "keyval", "keyval", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	         * X keycode.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_KEY_EVENT_KEYCODE, g_param_spec_uint ("keycode", "keycode", "keycode", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	         * Modifier mask.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_KEY_EVENT_MODIFIERS, g_param_spec_flags ("modifiers", "modifiers", "modifiers", KKC_TYPE_MODIFIER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void kkc_key_event_instance_init (KkcKeyEvent * self) {
	self->priv = KKC_KEY_EVENT_GET_PRIVATE (self);
}


static void kkc_key_event_finalize (GObject* obj) {
	KkcKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_KEY_EVENT, KkcKeyEvent);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (kkc_key_event_parent_class)->finalize (obj);
}


/**
     * Object representing a key event.
     */
GType kkc_key_event_get_type (void) {
	static volatile gsize kkc_key_event_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_key_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcKeyEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_key_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcKeyEvent), 0, (GInstanceInitFunc) kkc_key_event_instance_init, NULL };
		GType kkc_key_event_type_id;
		kkc_key_event_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcKeyEvent", &g_define_type_info, 0);
		g_once_init_leave (&kkc_key_event_type_id__volatile, kkc_key_event_type_id);
	}
	return kkc_key_event_type_id__volatile;
}


static void _vala_kkc_key_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_KEY_EVENT, KkcKeyEvent);
	switch (property_id) {
		case KKC_KEY_EVENT_NAME:
		g_value_set_string (value, kkc_key_event_get_name (self));
		break;
		case KKC_KEY_EVENT_UNICODE:
		g_value_set_uint (value, kkc_key_event_get_unicode (self));
		break;
		case KKC_KEY_EVENT_KEYVAL:
		g_value_set_uint (value, kkc_key_event_get_keyval (self));
		break;
		case KKC_KEY_EVENT_KEYCODE:
		g_value_set_uint (value, kkc_key_event_get_keycode (self));
		break;
		case KKC_KEY_EVENT_MODIFIERS:
		g_value_set_flags (value, kkc_key_event_get_modifiers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_kkc_key_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	KkcKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_KEY_EVENT, KkcKeyEvent);
	switch (property_id) {
		case KKC_KEY_EVENT_NAME:
		kkc_key_event_set_name (self, g_value_get_string (value));
		break;
		case KKC_KEY_EVENT_UNICODE:
		kkc_key_event_set_unicode (self, g_value_get_uint (value));
		break;
		case KKC_KEY_EVENT_KEYVAL:
		kkc_key_event_set_keyval (self, g_value_get_uint (value));
		break;
		case KKC_KEY_EVENT_KEYCODE:
		kkc_key_event_set_keycode (self, g_value_get_uint (value));
		break;
		case KKC_KEY_EVENT_MODIFIERS:
		kkc_key_event_set_modifiers (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



