/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* DAG Instruction Selector for the AMDGPU target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// *** NOTE: This file is #included into the middle of the target
// *** instruction selector class.  These functions are really methods.

// The main instruction selector code.
SDNode *SelectCode(SDNode *N) {
  // Some target values are emitted as 2 bytes, TARGET_VAL handles
  // this.
  #define TARGET_VAL(X) X & 255, unsigned(X) >> 8
  static const unsigned char MatcherTable[] = {
/*0*/       OPC_SwitchOpcode /*139 cases */, 35|128,10/*1315*/, TARGET_VAL(ISD::STORE),// ->1320
/*5*/         OPC_RecordMemRef,
/*6*/         OPC_RecordNode, // #0 = 'SIst_local' chained node
/*7*/         OPC_Scope, 33, /*->42*/ // 4 children in Scope
/*9*/           OPC_CaptureGlueInput,
/*10*/          OPC_RecordChild1, // #1 = $value
/*11*/          OPC_CheckChild1Type, MVT::v2i32,
/*13*/          OPC_RecordChild2, // #2 = $DS1Addr1Offset:ptr:offset
/*14*/          OPC_CheckPredicate, 0, // Predicate_si_st_local
/*16*/          OPC_CheckPredicate, 1, // Predicate_si_store_local
/*18*/          OPC_CheckPredicate, 2, // Predicate_si_store_local_align8
/*20*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22*/          OPC_CheckComplexPat, /*CP*/0, /*#*/2, // SelectDS1Addr1Offset:$ #3 #4
/*25*/          OPC_EmitMergeInputChains1_0,
/*26*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*29*/          OPC_EmitInteger, MVT::i1, 0, 
/*32*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_WRITE_B64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                    0/*#VTs*/, 4/*#Ops*/, 3, 1, 5, 6, 
                // Src: (SIst_local v2i32:v2i32:$value, (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset))<<P:Predicate_si_st_local>><<P:Predicate_si_store_local>><<P:Predicate_si_store_local_align8>> - Complexity = 113
                // Dst: (DS_WRITE_B64 ?:i32:$ptr, ?:v2i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*42*/        /*Scope*/ 64|128,3/*448*/, /*->492*/
/*44*/          OPC_RecordChild1, // #1 = $vdata
/*45*/          OPC_Scope, 15|128,2/*271*/, /*->319*/ // 3 children in Scope
/*48*/            OPC_CheckChild1Type, MVT::i32,
/*50*/            OPC_RecordChild2, // #2 = $MUBUFAddr64:srsrc:vaddr:soffset:offset:glc:slc:tfe
/*51*/            OPC_CheckPredicate, 3, // Predicate_unindexedstore
/*53*/            OPC_Scope, 54, /*->109*/ // 6 children in Scope
/*55*/              OPC_CheckPredicate, 4, // Predicate_truncstore
/*57*/              OPC_Scope, 24, /*->83*/ // 2 children in Scope
/*59*/                OPC_CheckPredicate, 5, // Predicate_truncstorei8
/*61*/                OPC_CheckPredicate, 6, // Predicate_truncstorei8_global
/*63*/                OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*65*/                OPC_CheckComplexPat, /*CP*/1, /*#*/2, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7 #8 #9
/*68*/                OPC_EmitMergeInputChains1_0,
/*69*/                OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_BYTE_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 8/*#Ops*/, 1, 4, 3, 5, 6, 7, 8, 9, 
                      // Src: (st i32:i32:$vdata, (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedstore>><<P:Predicate_truncstore>><<P:Predicate_truncstorei8>><<P:Predicate_truncstorei8_global>> - Complexity = 28
                      // Dst: (BUFFER_STORE_BYTE_ADDR64 i32:i32:$vdata, i64:i64:$vaddr, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*83*/              /*Scope*/ 24, /*->108*/
/*84*/                OPC_CheckPredicate, 7, // Predicate_truncstorei16
/*86*/                OPC_CheckPredicate, 8, // Predicate_truncstorei16_global
/*88*/                OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*90*/                OPC_CheckComplexPat, /*CP*/1, /*#*/2, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7 #8 #9
/*93*/                OPC_EmitMergeInputChains1_0,
/*94*/                OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_SHORT_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 8/*#Ops*/, 1, 4, 3, 5, 6, 7, 8, 9, 
                      // Src: (st i32:i32:$vdata, (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedstore>><<P:Predicate_truncstore>><<P:Predicate_truncstorei16>><<P:Predicate_truncstorei16_global>> - Complexity = 28
                      // Dst: (BUFFER_STORE_SHORT_ADDR64 i32:i32:$vdata, i64:i64:$vaddr, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*108*/             0, /*End of Scope*/
/*109*/           /*Scope*/ 24, /*->134*/
/*110*/             OPC_CheckPredicate, 9, // Predicate_store
/*112*/             OPC_CheckPredicate, 10, // Predicate_global_store
/*114*/             OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*116*/             OPC_CheckComplexPat, /*CP*/1, /*#*/2, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7 #8 #9
/*119*/             OPC_EmitMergeInputChains1_0,
/*120*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_DWORD_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                        0/*#VTs*/, 8/*#Ops*/, 1, 4, 3, 5, 6, 7, 8, 9, 
                    // Src: (st i32:i32:$vdata, (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 28
                    // Dst: (BUFFER_STORE_DWORD_ADDR64 i32:i32:$vdata, i64:i64:$vaddr, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*134*/           /*Scope*/ 52, /*->187*/
/*135*/             OPC_CheckPredicate, 4, // Predicate_truncstore
/*137*/             OPC_Scope, 23, /*->162*/ // 2 children in Scope
/*139*/               OPC_CheckPredicate, 5, // Predicate_truncstorei8
/*141*/               OPC_CheckPredicate, 6, // Predicate_truncstorei8_global
/*143*/               OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*145*/               OPC_CheckComplexPat, /*CP*/2, /*#*/2, // SelectMUBUFOffset:$ #3 #4 #5 #6 #7 #8
/*148*/               OPC_EmitMergeInputChains1_0,
/*149*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_BYTE_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 7/*#Ops*/, 1, 3, 4, 5, 6, 7, 8, 
                      // Src: (st i32:i32:$vdata, (MUBUFOffset:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedstore>><<P:Predicate_truncstore>><<P:Predicate_truncstorei8>><<P:Predicate_truncstorei8_global>> - Complexity = 25
                      // Dst: (BUFFER_STORE_BYTE_OFFSET i32:i32:$vdata, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*162*/             /*Scope*/ 23, /*->186*/
/*163*/               OPC_CheckPredicate, 7, // Predicate_truncstorei16
/*165*/               OPC_CheckPredicate, 8, // Predicate_truncstorei16_global
/*167*/               OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*169*/               OPC_CheckComplexPat, /*CP*/2, /*#*/2, // SelectMUBUFOffset:$ #3 #4 #5 #6 #7 #8
/*172*/               OPC_EmitMergeInputChains1_0,
/*173*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_SHORT_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 7/*#Ops*/, 1, 3, 4, 5, 6, 7, 8, 
                      // Src: (st i32:i32:$vdata, (MUBUFOffset:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedstore>><<P:Predicate_truncstore>><<P:Predicate_truncstorei16>><<P:Predicate_truncstorei16_global>> - Complexity = 25
                      // Dst: (BUFFER_STORE_SHORT_OFFSET i32:i32:$vdata, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*186*/             0, /*End of Scope*/
/*187*/           /*Scope*/ 23, /*->211*/
/*188*/             OPC_CheckPredicate, 9, // Predicate_store
/*190*/             OPC_CheckPredicate, 10, // Predicate_global_store
/*192*/             OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*194*/             OPC_CheckComplexPat, /*CP*/2, /*#*/2, // SelectMUBUFOffset:$ #3 #4 #5 #6 #7 #8
/*197*/             OPC_EmitMergeInputChains1_0,
/*198*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_DWORD_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                        0/*#VTs*/, 7/*#Ops*/, 1, 3, 4, 5, 6, 7, 8, 
                    // Src: (st i32:i32:$vdata, (MUBUFOffset:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 25
                    // Dst: (BUFFER_STORE_DWORD_OFFSET i32:i32:$vdata, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*211*/           /*Scope*/ 72, /*->284*/
/*212*/             OPC_CheckPredicate, 4, // Predicate_truncstore
/*214*/             OPC_Scope, 33, /*->249*/ // 2 children in Scope
/*216*/               OPC_CheckPredicate, 5, // Predicate_truncstorei8
/*218*/               OPC_CheckPredicate, 11, // Predicate_truncstorei8_private
/*220*/               OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*222*/               OPC_CheckComplexPat, /*CP*/3, /*#*/2, // SelectMUBUFScratch:$ #3 #4 #5 #6
/*225*/               OPC_EmitMergeInputChains1_0,
/*226*/               OPC_EmitInteger, MVT::i1, 0, 
/*229*/               OPC_EmitInteger, MVT::i1, 0, 
/*232*/               OPC_EmitInteger, MVT::i1, 0, 
/*235*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_BYTE_OFFEN), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 8/*#Ops*/, 1, 4, 3, 5, 6, 7, 8, 9, 
                      // Src: (st i32:i32:$value, (MUBUFScratch:iPTR v4i32:v4i32:$srsrc, i32:i32:$vaddr, i32:i32:$soffset, u16imm:i16:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_truncstore>><<P:Predicate_truncstorei8>><<P:Predicate_truncstorei8_private>> - Complexity = 19
                      // Dst: (BUFFER_STORE_BYTE_OFFEN ?:i32:$value, ?:i32:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, 0:i1, 0:i1, 0:i1)
/*249*/             /*Scope*/ 33, /*->283*/
/*250*/               OPC_CheckPredicate, 7, // Predicate_truncstorei16
/*252*/               OPC_CheckPredicate, 12, // Predicate_truncstorei16_private
/*254*/               OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*256*/               OPC_CheckComplexPat, /*CP*/3, /*#*/2, // SelectMUBUFScratch:$ #3 #4 #5 #6
/*259*/               OPC_EmitMergeInputChains1_0,
/*260*/               OPC_EmitInteger, MVT::i1, 0, 
/*263*/               OPC_EmitInteger, MVT::i1, 0, 
/*266*/               OPC_EmitInteger, MVT::i1, 0, 
/*269*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_SHORT_OFFEN), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 8/*#Ops*/, 1, 4, 3, 5, 6, 7, 8, 9, 
                      // Src: (st i32:i32:$value, (MUBUFScratch:iPTR v4i32:v4i32:$srsrc, i32:i32:$vaddr, i32:i32:$soffset, u16imm:i16:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_truncstore>><<P:Predicate_truncstorei16>><<P:Predicate_truncstorei16_private>> - Complexity = 19
                      // Dst: (BUFFER_STORE_SHORT_OFFEN ?:i32:$value, ?:i32:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, 0:i1, 0:i1, 0:i1)
/*283*/             0, /*End of Scope*/
/*284*/           /*Scope*/ 33, /*->318*/
/*285*/             OPC_CheckPredicate, 9, // Predicate_store
/*287*/             OPC_CheckPredicate, 13, // Predicate_store_private
/*289*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*291*/             OPC_CheckComplexPat, /*CP*/3, /*#*/2, // SelectMUBUFScratch:$ #3 #4 #5 #6
/*294*/             OPC_EmitMergeInputChains1_0,
/*295*/             OPC_EmitInteger, MVT::i1, 0, 
/*298*/             OPC_EmitInteger, MVT::i1, 0, 
/*301*/             OPC_EmitInteger, MVT::i1, 0, 
/*304*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_DWORD_OFFEN), 0|OPFL_Chain|OPFL_MemRefs,
                        0/*#VTs*/, 8/*#Ops*/, 1, 4, 3, 5, 6, 7, 8, 9, 
                    // Src: (st i32:i32:$value, (MUBUFScratch:iPTR v4i32:v4i32:$srsrc, i32:i32:$vaddr, i32:i32:$soffset, u16imm:i16:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_store_private>> - Complexity = 19
                    // Dst: (BUFFER_STORE_DWORD_OFFEN ?:i32:$value, ?:i32:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, 0:i1, 0:i1, 0:i1)
/*318*/           0, /*End of Scope*/
/*319*/         /*Scope*/ 85, /*->405*/
/*320*/           OPC_CheckChild1Type, MVT::v2i32,
/*322*/           OPC_RecordChild2, // #2 = $MUBUFAddr64:srsrc:vaddr:soffset:offset:glc:slc:tfe
/*323*/           OPC_CheckPredicate, 3, // Predicate_unindexedstore
/*325*/           OPC_CheckPredicate, 9, // Predicate_store
/*327*/           OPC_Scope, 43, /*->372*/ // 2 children in Scope
/*329*/             OPC_CheckPredicate, 10, // Predicate_global_store
/*331*/             OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*333*/             OPC_Scope, 18, /*->353*/ // 2 children in Scope
/*335*/               OPC_CheckComplexPat, /*CP*/1, /*#*/2, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7 #8 #9
/*338*/               OPC_EmitMergeInputChains1_0,
/*339*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_DWORDX2_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 8/*#Ops*/, 1, 4, 3, 5, 6, 7, 8, 9, 
                      // Src: (st v2i32:v2i32:$vdata, (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 28
                      // Dst: (BUFFER_STORE_DWORDX2_ADDR64 v2i32:v2i32:$vdata, i64:i64:$vaddr, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*353*/             /*Scope*/ 17, /*->371*/
/*354*/               OPC_CheckComplexPat, /*CP*/2, /*#*/2, // SelectMUBUFOffset:$ #3 #4 #5 #6 #7 #8
/*357*/               OPC_EmitMergeInputChains1_0,
/*358*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_DWORDX2_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 7/*#Ops*/, 1, 3, 4, 5, 6, 7, 8, 
                      // Src: (st v2i32:v2i32:$vdata, (MUBUFOffset:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 25
                      // Dst: (BUFFER_STORE_DWORDX2_OFFSET v2i32:v2i32:$vdata, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*371*/             0, /*End of Scope*/
/*372*/           /*Scope*/ 31, /*->404*/
/*373*/             OPC_CheckPredicate, 13, // Predicate_store_private
/*375*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*377*/             OPC_CheckComplexPat, /*CP*/3, /*#*/2, // SelectMUBUFScratch:$ #3 #4 #5 #6
/*380*/             OPC_EmitMergeInputChains1_0,
/*381*/             OPC_EmitInteger, MVT::i1, 0, 
/*384*/             OPC_EmitInteger, MVT::i1, 0, 
/*387*/             OPC_EmitInteger, MVT::i1, 0, 
/*390*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_DWORDX2_OFFEN), 0|OPFL_Chain|OPFL_MemRefs,
                        0/*#VTs*/, 8/*#Ops*/, 1, 4, 3, 5, 6, 7, 8, 9, 
                    // Src: (st v2i32:v2i32:$value, (MUBUFScratch:iPTR v4i32:v4i32:$srsrc, i32:i32:$vaddr, i32:i32:$soffset, u16imm:i16:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_store_private>> - Complexity = 19
                    // Dst: (BUFFER_STORE_DWORDX2_OFFEN ?:v2i32:$value, ?:i32:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, 0:i1, 0:i1, 0:i1)
/*404*/           0, /*End of Scope*/
/*405*/         /*Scope*/ 85, /*->491*/
/*406*/           OPC_CheckChild1Type, MVT::v4i32,
/*408*/           OPC_RecordChild2, // #2 = $MUBUFAddr64:srsrc:vaddr:soffset:offset:glc:slc:tfe
/*409*/           OPC_CheckPredicate, 3, // Predicate_unindexedstore
/*411*/           OPC_CheckPredicate, 9, // Predicate_store
/*413*/           OPC_Scope, 43, /*->458*/ // 2 children in Scope
/*415*/             OPC_CheckPredicate, 10, // Predicate_global_store
/*417*/             OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*419*/             OPC_Scope, 18, /*->439*/ // 2 children in Scope
/*421*/               OPC_CheckComplexPat, /*CP*/1, /*#*/2, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7 #8 #9
/*424*/               OPC_EmitMergeInputChains1_0,
/*425*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_DWORDX4_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 8/*#Ops*/, 1, 4, 3, 5, 6, 7, 8, 9, 
                      // Src: (st v4i32:v4i32:$vdata, (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 28
                      // Dst: (BUFFER_STORE_DWORDX4_ADDR64 v4i32:v4i32:$vdata, i64:i64:$vaddr, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*439*/             /*Scope*/ 17, /*->457*/
/*440*/               OPC_CheckComplexPat, /*CP*/2, /*#*/2, // SelectMUBUFOffset:$ #3 #4 #5 #6 #7 #8
/*443*/               OPC_EmitMergeInputChains1_0,
/*444*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_DWORDX4_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 7/*#Ops*/, 1, 3, 4, 5, 6, 7, 8, 
                      // Src: (st v4i32:v4i32:$vdata, (MUBUFOffset:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 25
                      // Dst: (BUFFER_STORE_DWORDX4_OFFSET v4i32:v4i32:$vdata, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*457*/             0, /*End of Scope*/
/*458*/           /*Scope*/ 31, /*->490*/
/*459*/             OPC_CheckPredicate, 13, // Predicate_store_private
/*461*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*463*/             OPC_CheckComplexPat, /*CP*/3, /*#*/2, // SelectMUBUFScratch:$ #3 #4 #5 #6
/*466*/             OPC_EmitMergeInputChains1_0,
/*467*/             OPC_EmitInteger, MVT::i1, 0, 
/*470*/             OPC_EmitInteger, MVT::i1, 0, 
/*473*/             OPC_EmitInteger, MVT::i1, 0, 
/*476*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_STORE_DWORDX4_OFFEN), 0|OPFL_Chain|OPFL_MemRefs,
                        0/*#VTs*/, 8/*#Ops*/, 1, 4, 3, 5, 6, 7, 8, 9, 
                    // Src: (st v4i32:v4i32:$value, (MUBUFScratch:iPTR v4i32:v4i32:$srsrc, i32:i32:$vaddr, i32:i32:$soffset, u16imm:i16:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_store_private>> - Complexity = 19
                    // Dst: (BUFFER_STORE_DWORDX4_OFFEN ?:v4i32:$value, ?:i32:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, 0:i1, 0:i1, 0:i1)
/*490*/           0, /*End of Scope*/
/*491*/         0, /*End of Scope*/
/*492*/       /*Scope*/ 17|128,1/*145*/, /*->639*/
/*494*/         OPC_CaptureGlueInput,
/*495*/         OPC_RecordChild1, // #1 = $value
/*496*/         OPC_Scope, 52, /*->550*/ // 2 children in Scope
/*498*/           OPC_CheckChild1Type, MVT::v2i32,
/*500*/           OPC_RecordChild2, // #2 = $DS64Bit4ByteAligned:ptr:offset0:offset1
/*501*/           OPC_CheckPredicate, 0, // Predicate_si_st_local
/*503*/           OPC_CheckPredicate, 1, // Predicate_si_store_local
/*505*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*507*/           OPC_CheckComplexPat, /*CP*/4, /*#*/2, // SelectDS64Bit4ByteAligned:$ #3 #4 #5
/*510*/           OPC_EmitMergeInputChains1_0,
/*511*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*514*/           OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 6,  // Results = #7
/*523*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*526*/           OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 8,  // Results = #9
/*535*/           OPC_EmitInteger, MVT::i1, 0, 
/*538*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_WRITE2_B32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      0/*#VTs*/, 6/*#Ops*/, 3, 7, 9, 4, 5, 10, 
                  // Src: (SIst_local v2i32:v2i32:$value, (DS64Bit4ByteAligned:iPTR i32:i32:$ptr, i8:i8:$offset0, i8:i8:$offset1))<<P:Predicate_si_st_local>><<P:Predicate_si_store_local>> - Complexity = 16
                  // Dst: (DS_WRITE2_B32 ?:i32:$ptr, (EXTRACT_SUBREG:i32 ?:v2i32:$value, sub0:i32), (EXTRACT_SUBREG:i32 ?:v2i32:$value, sub1:i32), ?:i8:$offset0, ?:i8:$offset1, 0:i1)
/*550*/         /*Scope*/ 87, /*->638*/
/*551*/           OPC_CheckChild1Type, MVT::i32,
/*553*/           OPC_RecordChild2, // #2 = $DS1Addr1Offset:ptr:offset
/*554*/           OPC_CheckPredicate, 0, // Predicate_si_st_local
/*556*/           OPC_Scope, 54, /*->612*/ // 2 children in Scope
/*558*/             OPC_CheckPredicate, 14, // Predicate_si_truncstore_local
/*560*/             OPC_Scope, 24, /*->586*/ // 2 children in Scope
/*562*/               OPC_CheckPredicate, 15, // Predicate_si_truncstore_local_i8
/*564*/               OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*566*/               OPC_CheckComplexPat, /*CP*/0, /*#*/2, // SelectDS1Addr1Offset:$ #3 #4
/*569*/               OPC_EmitMergeInputChains1_0,
/*570*/               OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*573*/               OPC_EmitInteger, MVT::i1, 0, 
/*576*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_WRITE_B8), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                          0/*#VTs*/, 4/*#Ops*/, 3, 1, 5, 6, 
                      // Src: (SIst_local i32:i32:$value, (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset))<<P:Predicate_si_st_local>><<P:Predicate_si_truncstore_local>><<P:Predicate_si_truncstore_local_i8>> - Complexity = 13
                      // Dst: (DS_WRITE_B8 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*586*/             /*Scope*/ 24, /*->611*/
/*587*/               OPC_CheckPredicate, 16, // Predicate_si_truncstore_local_i16
/*589*/               OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*591*/               OPC_CheckComplexPat, /*CP*/0, /*#*/2, // SelectDS1Addr1Offset:$ #3 #4
/*594*/               OPC_EmitMergeInputChains1_0,
/*595*/               OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*598*/               OPC_EmitInteger, MVT::i1, 0, 
/*601*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_WRITE_B16), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                          0/*#VTs*/, 4/*#Ops*/, 3, 1, 5, 6, 
                      // Src: (SIst_local i32:i32:$value, (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset))<<P:Predicate_si_st_local>><<P:Predicate_si_truncstore_local>><<P:Predicate_si_truncstore_local_i16>> - Complexity = 13
                      // Dst: (DS_WRITE_B16 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*611*/             0, /*End of Scope*/
/*612*/           /*Scope*/ 24, /*->637*/
/*613*/             OPC_CheckPredicate, 1, // Predicate_si_store_local
/*615*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*617*/             OPC_CheckComplexPat, /*CP*/0, /*#*/2, // SelectDS1Addr1Offset:$ #3 #4
/*620*/             OPC_EmitMergeInputChains1_0,
/*621*/             OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*624*/             OPC_EmitInteger, MVT::i1, 0, 
/*627*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_WRITE_B32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                        0/*#VTs*/, 4/*#Ops*/, 3, 1, 5, 6, 
                    // Src: (SIst_local i32:i32:$value, (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset))<<P:Predicate_si_st_local>><<P:Predicate_si_store_local>> - Complexity = 13
                    // Dst: (DS_WRITE_B32 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*637*/           0, /*End of Scope*/
/*638*/         0, /*End of Scope*/
/*639*/       /*Scope*/ 38|128,5/*678*/, /*->1319*/
/*641*/         OPC_RecordChild1, // #1 = $src1
/*642*/         OPC_Scope, 42|128,3/*426*/, /*->1071*/ // 4 children in Scope
/*645*/           OPC_CheckChild1Type, MVT::i32,
/*647*/           OPC_RecordChild2, // #2 = $src0
/*648*/           OPC_Scope, 105|128,1/*233*/, /*->884*/ // 2 children in Scope
/*651*/             OPC_CheckChild2Type, MVT::i32,
/*653*/             OPC_CheckPredicate, 3, // Predicate_unindexedstore
/*655*/             OPC_Scope, 61, /*->718*/ // 3 children in Scope
/*657*/               OPC_CheckPredicate, 9, // Predicate_store
/*659*/               OPC_CheckPredicate, 17, // Predicate_local_store
/*661*/               OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*663*/               OPC_EmitMergeInputChains1_0,
/*664*/               OPC_EmitInteger, MVT::i32, 0, 
/*667*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*679*/               OPC_EmitInteger, MVT::i32, 0, 
/*682*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*694*/               OPC_EmitInteger, MVT::i32, 1, 
/*697*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*700*/               OPC_EmitInteger, MVT::i32, 0, 
/*703*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_WRITE), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 9/*#Ops*/, 2, 3, 4, 1, 5, 6, 7, 8, 9, 
                      // Src: (st R600_Reg32:i32:$src1, R600_Reg32:i32:$src0)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_local_store>> - Complexity = 4
                      // Dst: (LDS_WRITE R600_Reg32:i32:$src0, R600_Reg32:i32:$src1)
/*718*/             /*Scope*/ 0|128,1/*128*/, /*->848*/
/*720*/               OPC_CheckPredicate, 4, // Predicate_truncstore
/*722*/               OPC_Scope, 61, /*->785*/ // 2 children in Scope
/*724*/                 OPC_CheckPredicate, 5, // Predicate_truncstorei8
/*726*/                 OPC_CheckPredicate, 18, // Predicate_truncstorei8_local
/*728*/                 OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*730*/                 OPC_EmitMergeInputChains1_0,
/*731*/                 OPC_EmitInteger, MVT::i32, 0, 
/*734*/                 OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*746*/                 OPC_EmitInteger, MVT::i32, 0, 
/*749*/                 OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*761*/                 OPC_EmitInteger, MVT::i32, 1, 
/*764*/                 OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*767*/                 OPC_EmitInteger, MVT::i32, 0, 
/*770*/                 OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_BYTE_WRITE), 0|OPFL_Chain|OPFL_MemRefs,
                            0/*#VTs*/, 9/*#Ops*/, 2, 3, 4, 1, 5, 6, 7, 8, 9, 
                        // Src: (st i32:i32:$src1, i32:i32:$src0)<<P:Predicate_unindexedstore>><<P:Predicate_truncstore>><<P:Predicate_truncstorei8>><<P:Predicate_truncstorei8_local>> - Complexity = 4
                        // Dst: (LDS_BYTE_WRITE i32:i32:$src0, i32:i32:$src1)
/*785*/               /*Scope*/ 61, /*->847*/
/*786*/                 OPC_CheckPredicate, 7, // Predicate_truncstorei16
/*788*/                 OPC_CheckPredicate, 19, // Predicate_truncstorei16_local
/*790*/                 OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*792*/                 OPC_EmitMergeInputChains1_0,
/*793*/                 OPC_EmitInteger, MVT::i32, 0, 
/*796*/                 OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*808*/                 OPC_EmitInteger, MVT::i32, 0, 
/*811*/                 OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*823*/                 OPC_EmitInteger, MVT::i32, 1, 
/*826*/                 OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*829*/                 OPC_EmitInteger, MVT::i32, 0, 
/*832*/                 OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_SHORT_WRITE), 0|OPFL_Chain|OPFL_MemRefs,
                            0/*#VTs*/, 9/*#Ops*/, 2, 3, 4, 1, 5, 6, 7, 8, 9, 
                        // Src: (st i32:i32:$src1, i32:i32:$src0)<<P:Predicate_unindexedstore>><<P:Predicate_truncstore>><<P:Predicate_truncstorei16>><<P:Predicate_truncstorei16_local>> - Complexity = 4
                        // Dst: (LDS_SHORT_WRITE i32:i32:$src0, i32:i32:$src1)
/*847*/               0, /*End of Scope*/
/*848*/             /*Scope*/ 34, /*->883*/
/*849*/               OPC_CheckPredicate, 9, // Predicate_store
/*851*/               OPC_CheckPredicate, 10, // Predicate_global_store
/*853*/               OPC_Scope, 11, /*->866*/ // 2 children in Scope
/*855*/                 OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*857*/                 OPC_EmitMergeInputChains1_0,
/*858*/                 OPC_MorphNodeTo, TARGET_VAL(AMDGPU::RAT_STORE_DWORD32), 0|OPFL_Chain|OPFL_MemRefs,
                            0/*#VTs*/, 2/*#Ops*/, 1, 2, 
                        // Src: (st i32:i32:$rw_gpr, i32:i32:$index_gpr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 4
                        // Dst: (RAT_STORE_DWORD32 i32:i32:$rw_gpr, i32:i32:$index_gpr)
/*866*/               /*Scope*/ 15, /*->882*/
/*867*/                 OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*869*/                 OPC_EmitMergeInputChains1_0,
/*870*/                 OPC_EmitInteger, MVT::i32, 0, 
/*873*/                 OPC_MorphNodeTo, TARGET_VAL(AMDGPU::RAT_WRITE_CACHELESS_32_eg), 0|OPFL_Chain|OPFL_MemRefs,
                            0/*#VTs*/, 3/*#Ops*/, 1, 2, 3, 
                        // Src: (st i32:i32:$rw_gpr, i32:i32:$index_gpr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 4
                        // Dst: (RAT_WRITE_CACHELESS_32_eg i32:i32:$rw_gpr, i32:i32:$index_gpr)
/*882*/               0, /*End of Scope*/
/*883*/             0, /*End of Scope*/
/*884*/           /*Scope*/ 56|128,1/*184*/, /*->1070*/
/*886*/             OPC_CheckChild2Type, MVT::i64,
/*888*/             OPC_CheckPredicate, 3, // Predicate_unindexedstore
/*890*/             OPC_Scope, 60, /*->952*/ // 4 children in Scope
/*892*/               OPC_CheckPredicate, 4, // Predicate_truncstore
/*894*/               OPC_Scope, 27, /*->923*/ // 2 children in Scope
/*896*/                 OPC_CheckPredicate, 5, // Predicate_truncstorei8
/*898*/                 OPC_CheckPredicate, 20, // Predicate_truncstorei8_flat
/*900*/                 OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*902*/                 OPC_EmitMergeInputChains1_0,
/*903*/                 OPC_EmitInteger, MVT::i1, 0, 
/*906*/                 OPC_EmitInteger, MVT::i1, 0, 
/*909*/                 OPC_EmitInteger, MVT::i1, 0, 
/*912*/                 OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_STORE_BYTE), 0|OPFL_Chain|OPFL_MemRefs,
                            0/*#VTs*/, 5/*#Ops*/, 1, 2, 3, 4, 5, 
                        // Src: (st i32:i32:$value, i64:i64:$ptr)<<P:Predicate_unindexedstore>><<P:Predicate_truncstore>><<P:Predicate_truncstorei8>><<P:Predicate_truncstorei8_flat>> - Complexity = 4
                        // Dst: (FLAT_STORE_BYTE ?:i32:$value, ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*923*/               /*Scope*/ 27, /*->951*/
/*924*/                 OPC_CheckPredicate, 7, // Predicate_truncstorei16
/*926*/                 OPC_CheckPredicate, 21, // Predicate_truncstorei16_flat
/*928*/                 OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*930*/                 OPC_EmitMergeInputChains1_0,
/*931*/                 OPC_EmitInteger, MVT::i1, 0, 
/*934*/                 OPC_EmitInteger, MVT::i1, 0, 
/*937*/                 OPC_EmitInteger, MVT::i1, 0, 
/*940*/                 OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_STORE_SHORT), 0|OPFL_Chain|OPFL_MemRefs,
                            0/*#VTs*/, 5/*#Ops*/, 1, 2, 3, 4, 5, 
                        // Src: (st i32:i32:$value, i64:i64:$ptr)<<P:Predicate_unindexedstore>><<P:Predicate_truncstore>><<P:Predicate_truncstorei16>><<P:Predicate_truncstorei16_flat>> - Complexity = 4
                        // Dst: (FLAT_STORE_SHORT ?:i32:$value, ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*951*/               0, /*End of Scope*/
/*952*/             /*Scope*/ 27, /*->980*/
/*953*/               OPC_CheckPredicate, 9, // Predicate_store
/*955*/               OPC_CheckPredicate, 22, // Predicate_flat_store
/*957*/               OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*959*/               OPC_EmitMergeInputChains1_0,
/*960*/               OPC_EmitInteger, MVT::i1, 0, 
/*963*/               OPC_EmitInteger, MVT::i1, 0, 
/*966*/               OPC_EmitInteger, MVT::i1, 0, 
/*969*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_STORE_DWORD), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 5/*#Ops*/, 1, 2, 3, 4, 5, 
                      // Src: (st i32:i32:$value, i64:i64:$ptr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_flat_store>> - Complexity = 4
                      // Dst: (FLAT_STORE_DWORD ?:i32:$value, ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*980*/             /*Scope*/ 60, /*->1041*/
/*981*/               OPC_CheckPredicate, 4, // Predicate_truncstore
/*983*/               OPC_Scope, 27, /*->1012*/ // 2 children in Scope
/*985*/                 OPC_CheckPredicate, 5, // Predicate_truncstorei8
/*987*/                 OPC_CheckPredicate, 6, // Predicate_truncstorei8_global
/*989*/                 OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*991*/                 OPC_EmitMergeInputChains1_0,
/*992*/                 OPC_EmitInteger, MVT::i1, 0, 
/*995*/                 OPC_EmitInteger, MVT::i1, 0, 
/*998*/                 OPC_EmitInteger, MVT::i1, 0, 
/*1001*/                OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_STORE_BYTE), 0|OPFL_Chain|OPFL_MemRefs,
                            0/*#VTs*/, 5/*#Ops*/, 1, 2, 3, 4, 5, 
                        // Src: (st i32:i32:$data, i64:i64:$addr)<<P:Predicate_unindexedstore>><<P:Predicate_truncstore>><<P:Predicate_truncstorei8>><<P:Predicate_truncstorei8_global>> - Complexity = 4
                        // Dst: (FLAT_STORE_BYTE ?:i32:$data, ?:i64:$addr, 0:i1, 0:i1, 0:i1)
/*1012*/              /*Scope*/ 27, /*->1040*/
/*1013*/                OPC_CheckPredicate, 7, // Predicate_truncstorei16
/*1015*/                OPC_CheckPredicate, 8, // Predicate_truncstorei16_global
/*1017*/                OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*1019*/                OPC_EmitMergeInputChains1_0,
/*1020*/                OPC_EmitInteger, MVT::i1, 0, 
/*1023*/                OPC_EmitInteger, MVT::i1, 0, 
/*1026*/                OPC_EmitInteger, MVT::i1, 0, 
/*1029*/                OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_STORE_SHORT), 0|OPFL_Chain|OPFL_MemRefs,
                            0/*#VTs*/, 5/*#Ops*/, 1, 2, 3, 4, 5, 
                        // Src: (st i32:i32:$data, i64:i64:$addr)<<P:Predicate_unindexedstore>><<P:Predicate_truncstore>><<P:Predicate_truncstorei16>><<P:Predicate_truncstorei16_global>> - Complexity = 4
                        // Dst: (FLAT_STORE_SHORT ?:i32:$data, ?:i64:$addr, 0:i1, 0:i1, 0:i1)
/*1040*/              0, /*End of Scope*/
/*1041*/            /*Scope*/ 27, /*->1069*/
/*1042*/              OPC_CheckPredicate, 9, // Predicate_store
/*1044*/              OPC_CheckPredicate, 10, // Predicate_global_store
/*1046*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*1048*/              OPC_EmitMergeInputChains1_0,
/*1049*/              OPC_EmitInteger, MVT::i1, 0, 
/*1052*/              OPC_EmitInteger, MVT::i1, 0, 
/*1055*/              OPC_EmitInteger, MVT::i1, 0, 
/*1058*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_STORE_DWORD), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 5/*#Ops*/, 1, 2, 3, 4, 5, 
                      // Src: (st i32:i32:$data, i64:i64:$addr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 4
                      // Dst: (FLAT_STORE_DWORD ?:i32:$data, ?:i64:$addr, 0:i1, 0:i1, 0:i1)
/*1069*/            0, /*End of Scope*/
/*1070*/          0, /*End of Scope*/
/*1071*/        /*Scope*/ 105, /*->1177*/
/*1072*/          OPC_CheckChild1Type, MVT::v2i32,
/*1074*/          OPC_RecordChild2, // #2 = $index_gpr
/*1075*/          OPC_Scope, 38, /*->1115*/ // 2 children in Scope
/*1077*/            OPC_CheckChild2Type, MVT::i32,
/*1079*/            OPC_CheckPredicate, 3, // Predicate_unindexedstore
/*1081*/            OPC_CheckPredicate, 9, // Predicate_store
/*1083*/            OPC_CheckPredicate, 10, // Predicate_global_store
/*1085*/            OPC_Scope, 11, /*->1098*/ // 2 children in Scope
/*1087*/              OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*1089*/              OPC_EmitMergeInputChains1_0,
/*1090*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::RAT_STORE_DWORD64), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 2/*#Ops*/, 1, 2, 
                      // Src: (st v2i32:v2i32:$rw_gpr, i32:i32:$index_gpr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 4
                      // Dst: (RAT_STORE_DWORD64 v2i32:v2i32:$rw_gpr, i32:i32:$index_gpr)
/*1098*/            /*Scope*/ 15, /*->1114*/
/*1099*/              OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*1101*/              OPC_EmitMergeInputChains1_0,
/*1102*/              OPC_EmitInteger, MVT::i32, 0, 
/*1105*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::RAT_WRITE_CACHELESS_64_eg), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (st v2i32:v2i32:$rw_gpr, i32:i32:$index_gpr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 4
                      // Dst: (RAT_WRITE_CACHELESS_64_eg v2i32:v2i32:$rw_gpr, i32:i32:$index_gpr)
/*1114*/            0, /*End of Scope*/
/*1115*/          /*Scope*/ 60, /*->1176*/
/*1116*/            OPC_CheckChild2Type, MVT::i64,
/*1118*/            OPC_CheckPredicate, 3, // Predicate_unindexedstore
/*1120*/            OPC_CheckPredicate, 9, // Predicate_store
/*1122*/            OPC_Scope, 25, /*->1149*/ // 2 children in Scope
/*1124*/              OPC_CheckPredicate, 22, // Predicate_flat_store
/*1126*/              OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*1128*/              OPC_EmitMergeInputChains1_0,
/*1129*/              OPC_EmitInteger, MVT::i1, 0, 
/*1132*/              OPC_EmitInteger, MVT::i1, 0, 
/*1135*/              OPC_EmitInteger, MVT::i1, 0, 
/*1138*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_STORE_DWORDX2), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 5/*#Ops*/, 1, 2, 3, 4, 5, 
                      // Src: (st v2i32:v2i32:$value, i64:i64:$ptr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_flat_store>> - Complexity = 4
                      // Dst: (FLAT_STORE_DWORDX2 ?:v2i32:$value, ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*1149*/            /*Scope*/ 25, /*->1175*/
/*1150*/              OPC_CheckPredicate, 10, // Predicate_global_store
/*1152*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*1154*/              OPC_EmitMergeInputChains1_0,
/*1155*/              OPC_EmitInteger, MVT::i1, 0, 
/*1158*/              OPC_EmitInteger, MVT::i1, 0, 
/*1161*/              OPC_EmitInteger, MVT::i1, 0, 
/*1164*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_STORE_DWORDX2), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 5/*#Ops*/, 1, 2, 3, 4, 5, 
                      // Src: (st v2i32:v2i32:$data, i64:i64:$addr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 4
                      // Dst: (FLAT_STORE_DWORDX2 ?:v2i32:$data, ?:i64:$addr, 0:i1, 0:i1, 0:i1)
/*1175*/            0, /*End of Scope*/
/*1176*/          0, /*End of Scope*/
/*1177*/        /*Scope*/ 105, /*->1283*/
/*1178*/          OPC_CheckChild1Type, MVT::v4i32,
/*1180*/          OPC_RecordChild2, // #2 = $index_gpr
/*1181*/          OPC_Scope, 38, /*->1221*/ // 2 children in Scope
/*1183*/            OPC_CheckChild2Type, MVT::i32,
/*1185*/            OPC_CheckPredicate, 3, // Predicate_unindexedstore
/*1187*/            OPC_CheckPredicate, 9, // Predicate_store
/*1189*/            OPC_CheckPredicate, 10, // Predicate_global_store
/*1191*/            OPC_Scope, 11, /*->1204*/ // 2 children in Scope
/*1193*/              OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*1195*/              OPC_EmitMergeInputChains1_0,
/*1196*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::RAT_STORE_DWORD128), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 2/*#Ops*/, 1, 2, 
                      // Src: (st v4i32:v4i32:$rw_gpr, i32:i32:$index_gpr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 4
                      // Dst: (RAT_STORE_DWORD128 v4i32:v4i32:$rw_gpr, i32:i32:$index_gpr)
/*1204*/            /*Scope*/ 15, /*->1220*/
/*1205*/              OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*1207*/              OPC_EmitMergeInputChains1_0,
/*1208*/              OPC_EmitInteger, MVT::i32, 0, 
/*1211*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::RAT_WRITE_CACHELESS_128_eg), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 3/*#Ops*/, 1, 2, 3, 
                      // Src: (st v4i32:v4i32:$rw_gpr, i32:i32:$index_gpr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 4
                      // Dst: (RAT_WRITE_CACHELESS_128_eg v4i32:v4i32:$rw_gpr, i32:i32:$index_gpr)
/*1220*/            0, /*End of Scope*/
/*1221*/          /*Scope*/ 60, /*->1282*/
/*1222*/            OPC_CheckChild2Type, MVT::i64,
/*1224*/            OPC_CheckPredicate, 3, // Predicate_unindexedstore
/*1226*/            OPC_CheckPredicate, 9, // Predicate_store
/*1228*/            OPC_Scope, 25, /*->1255*/ // 2 children in Scope
/*1230*/              OPC_CheckPredicate, 22, // Predicate_flat_store
/*1232*/              OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*1234*/              OPC_EmitMergeInputChains1_0,
/*1235*/              OPC_EmitInteger, MVT::i1, 0, 
/*1238*/              OPC_EmitInteger, MVT::i1, 0, 
/*1241*/              OPC_EmitInteger, MVT::i1, 0, 
/*1244*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_STORE_DWORDX4), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 5/*#Ops*/, 1, 2, 3, 4, 5, 
                      // Src: (st v4i32:v4i32:$value, i64:i64:$ptr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_flat_store>> - Complexity = 4
                      // Dst: (FLAT_STORE_DWORDX4 ?:v4i32:$value, ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*1255*/            /*Scope*/ 25, /*->1281*/
/*1256*/              OPC_CheckPredicate, 10, // Predicate_global_store
/*1258*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*1260*/              OPC_EmitMergeInputChains1_0,
/*1261*/              OPC_EmitInteger, MVT::i1, 0, 
/*1264*/              OPC_EmitInteger, MVT::i1, 0, 
/*1267*/              OPC_EmitInteger, MVT::i1, 0, 
/*1270*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_STORE_DWORDX4), 0|OPFL_Chain|OPFL_MemRefs,
                          0/*#VTs*/, 5/*#Ops*/, 1, 2, 3, 4, 5, 
                      // Src: (st v4i32:v4i32:$data, i64:i64:$addr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_global_store>> - Complexity = 4
                      // Dst: (FLAT_STORE_DWORDX4 ?:v4i32:$data, ?:i64:$addr, 0:i1, 0:i1, 0:i1)
/*1281*/            0, /*End of Scope*/
/*1282*/          0, /*End of Scope*/
/*1283*/        /*Scope*/ 34, /*->1318*/
/*1284*/          OPC_CheckChild1Type, MVT::i64,
/*1286*/          OPC_RecordChild2, // #2 = $ptr
/*1287*/          OPC_CheckChild2Type, MVT::i64,
/*1289*/          OPC_CheckPredicate, 3, // Predicate_unindexedstore
/*1291*/          OPC_CheckPredicate, 9, // Predicate_store
/*1293*/          OPC_CheckPredicate, 22, // Predicate_flat_store
/*1295*/          OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*1297*/          OPC_EmitMergeInputChains1_0,
/*1298*/          OPC_EmitInteger, MVT::i1, 0, 
/*1301*/          OPC_EmitInteger, MVT::i1, 0, 
/*1304*/          OPC_EmitInteger, MVT::i1, 0, 
/*1307*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_STORE_DWORDX2), 0|OPFL_Chain|OPFL_MemRefs,
                      0/*#VTs*/, 5/*#Ops*/, 1, 2, 3, 4, 5, 
                  // Src: (st i64:i64:$value, i64:i64:$ptr)<<P:Predicate_unindexedstore>><<P:Predicate_store>><<P:Predicate_flat_store>> - Complexity = 4
                  // Dst: (FLAT_STORE_DWORDX2 ?:i64:$value, ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*1318*/        0, /*End of Scope*/
/*1319*/      0, /*End of Scope*/
/*1320*/    /*SwitchOpcode*/ 64|128,6/*832*/, TARGET_VAL(ISD::INTRINSIC_W_CHAIN),// ->2156
/*1324*/      OPC_RecordNode, // #0 = 'intrinsic_w_chain' chained node
/*1325*/      OPC_Scope, 87|128,5/*727*/, /*->2055*/ // 6 children in Scope
/*1328*/        OPC_CheckChild1Integer, 5|128,39/*4997*/, 
/*1331*/        OPC_RecordChild2, // #1 = $rsrc
/*1332*/        OPC_CheckChild2Type, MVT::v4i32,
/*1334*/        OPC_Scope, 77, /*->1413*/ // 4 children in Scope
/*1336*/          OPC_MoveChild, 3,
/*1338*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1341*/          OPC_CheckType, MVT::i32,
/*1343*/          OPC_MoveParent,
/*1344*/          OPC_RecordChild4, // #2 = $soffset
/*1345*/          OPC_RecordChild5, // #3 = $offset
/*1346*/          OPC_MoveChild, 5,
/*1348*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1351*/          OPC_MoveParent,
/*1352*/          OPC_MoveChild, 6,
/*1354*/          OPC_CheckInteger, 0, 
/*1356*/          OPC_MoveParent,
/*1357*/          OPC_MoveChild, 7,
/*1359*/          OPC_CheckInteger, 0, 
/*1361*/          OPC_MoveParent,
/*1362*/          OPC_MoveChild, 8,
/*1364*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1367*/          OPC_RecordNode, // #4 = $glc
/*1368*/          OPC_MoveParent,
/*1369*/          OPC_MoveChild, 9,
/*1371*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1374*/          OPC_RecordNode, // #5 = $slc
/*1375*/          OPC_MoveParent,
/*1376*/          OPC_MoveChild, 10,
/*1378*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1381*/          OPC_RecordNode, // #6 = $tfe
/*1382*/          OPC_MoveParent,
/*1383*/          OPC_CheckType, MVT::i32,
/*1385*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*1387*/          OPC_EmitMergeInputChains1_0,
/*1388*/          OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*1391*/          OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*1394*/          OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*1397*/          OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*1400*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORD_OFFSET), 0|OPFL_Chain,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 1, 2, 7, 8, 9, 10, 
                  // Src: (intrinsic_w_chain:i32 4997:iPTR, v4i32:v4i32:$rsrc, (imm:i32), i32:i32:$soffset, (imm:i32):$offset, 0:i32, 0:i32, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 33
                  // Dst: (BUFFER_LOAD_DWORD_OFFSET:i32 ?:v4i32:$rsrc, ?:i32:$soffset, (as_i16imm:i16 ?:i32:$offset), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe))
/*1413*/        /*Scope*/ 86|128,1/*214*/, /*->1629*/
/*1415*/          OPC_RecordChild3, // #2 = $vaddr
/*1416*/          OPC_Scope, 8|128,1/*136*/, /*->1555*/ // 2 children in Scope
/*1419*/            OPC_CheckChild3Type, MVT::i32,
/*1421*/            OPC_RecordChild4, // #3 = $soffset
/*1422*/            OPC_RecordChild5, // #4 = $offset
/*1423*/            OPC_MoveChild, 5,
/*1425*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1428*/            OPC_MoveParent,
/*1429*/            OPC_MoveChild, 6,
/*1431*/            OPC_Scope, 60, /*->1493*/ // 2 children in Scope
/*1433*/              OPC_CheckInteger, 1, 
/*1435*/              OPC_MoveParent,
/*1436*/              OPC_MoveChild, 7,
/*1438*/              OPC_CheckInteger, 0, 
/*1440*/              OPC_MoveParent,
/*1441*/              OPC_MoveChild, 8,
/*1443*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1446*/              OPC_RecordNode, // #5 = $glc
/*1447*/              OPC_MoveParent,
/*1448*/              OPC_MoveChild, 9,
/*1450*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1453*/              OPC_RecordNode, // #6 = $slc
/*1454*/              OPC_MoveParent,
/*1455*/              OPC_MoveChild, 10,
/*1457*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1460*/              OPC_RecordNode, // #7 = $tfe
/*1461*/              OPC_MoveParent,
/*1462*/              OPC_CheckType, MVT::i32,
/*1464*/              OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*1466*/              OPC_EmitMergeInputChains1_0,
/*1467*/              OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*1470*/              OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*1473*/              OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*1476*/              OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*1479*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORD_OFFEN), 0|OPFL_Chain,
                          1/*#VTs*/, MVT::i32, 7/*#Ops*/, 2, 1, 3, 8, 9, 10, 11, 
                      // Src: (intrinsic_w_chain:i32 4997:iPTR, v4i32:v4i32:$rsrc, i32:i32:$vaddr, i32:i32:$soffset, (imm:i32):$offset, 1:i32, 0:i32, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 30
                      // Dst: (BUFFER_LOAD_DWORD_OFFEN:i32 ?:i32:$vaddr, ?:v4i32:$rsrc, ?:i32:$soffset, (as_i16imm:i16 ?:i32:$offset), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe))
/*1493*/            /*Scope*/ 60, /*->1554*/
/*1494*/              OPC_CheckInteger, 0, 
/*1496*/              OPC_MoveParent,
/*1497*/              OPC_MoveChild, 7,
/*1499*/              OPC_CheckInteger, 1, 
/*1501*/              OPC_MoveParent,
/*1502*/              OPC_MoveChild, 8,
/*1504*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1507*/              OPC_RecordNode, // #5 = $glc
/*1508*/              OPC_MoveParent,
/*1509*/              OPC_MoveChild, 9,
/*1511*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1514*/              OPC_RecordNode, // #6 = $slc
/*1515*/              OPC_MoveParent,
/*1516*/              OPC_MoveChild, 10,
/*1518*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1521*/              OPC_RecordNode, // #7 = $tfe
/*1522*/              OPC_MoveParent,
/*1523*/              OPC_CheckType, MVT::i32,
/*1525*/              OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*1527*/              OPC_EmitMergeInputChains1_0,
/*1528*/              OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*1531*/              OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*1534*/              OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*1537*/              OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*1540*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORD_IDXEN), 0|OPFL_Chain,
                          1/*#VTs*/, MVT::i32, 7/*#Ops*/, 2, 1, 3, 8, 9, 10, 11, 
                      // Src: (intrinsic_w_chain:i32 4997:iPTR, v4i32:v4i32:$rsrc, i32:i32:$vaddr, i32:i32:$soffset, (imm:i32):$offset, 0:i32, 1:i32, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 30
                      // Dst: (BUFFER_LOAD_DWORD_IDXEN:i32 ?:i32:$vaddr, ?:v4i32:$rsrc, ?:i32:$soffset, (as_i16imm:i16 ?:i32:$offset), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe))
/*1554*/            0, /*End of Scope*/
/*1555*/          /*Scope*/ 72, /*->1628*/
/*1556*/            OPC_CheckChild3Type, MVT::v2i32,
/*1558*/            OPC_RecordChild4, // #3 = $soffset
/*1559*/            OPC_RecordChild5, // #4 = $offset
/*1560*/            OPC_MoveChild, 5,
/*1562*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1565*/            OPC_MoveParent,
/*1566*/            OPC_MoveChild, 6,
/*1568*/            OPC_CheckInteger, 1, 
/*1570*/            OPC_MoveParent,
/*1571*/            OPC_MoveChild, 7,
/*1573*/            OPC_CheckInteger, 1, 
/*1575*/            OPC_MoveParent,
/*1576*/            OPC_MoveChild, 8,
/*1578*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1581*/            OPC_RecordNode, // #5 = $glc
/*1582*/            OPC_MoveParent,
/*1583*/            OPC_MoveChild, 9,
/*1585*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1588*/            OPC_RecordNode, // #6 = $slc
/*1589*/            OPC_MoveParent,
/*1590*/            OPC_MoveChild, 10,
/*1592*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1595*/            OPC_RecordNode, // #7 = $tfe
/*1596*/            OPC_MoveParent,
/*1597*/            OPC_CheckType, MVT::i32,
/*1599*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*1601*/            OPC_EmitMergeInputChains1_0,
/*1602*/            OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*1605*/            OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*1608*/            OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*1611*/            OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*1614*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORD_BOTHEN), 0|OPFL_Chain,
                        1/*#VTs*/, MVT::i32, 7/*#Ops*/, 2, 1, 3, 8, 9, 10, 11, 
                    // Src: (intrinsic_w_chain:i32 4997:iPTR, v4i32:v4i32:$rsrc, v2i32:v2i32:$vaddr, i32:i32:$soffset, (imm:i32):$offset, 1:i32, 1:i32, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 30
                    // Dst: (BUFFER_LOAD_DWORD_BOTHEN:i32 ?:v2i32:$vaddr, ?:v4i32:$rsrc, ?:i32:$soffset, (as_i16imm:i16 ?:i32:$offset), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe))
/*1628*/          0, /*End of Scope*/
/*1629*/        /*Scope*/ 109, /*->1739*/
/*1630*/          OPC_MoveChild, 3,
/*1632*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1635*/          OPC_CheckType, MVT::i32,
/*1637*/          OPC_MoveParent,
/*1638*/          OPC_RecordChild4, // #2 = $soffset
/*1639*/          OPC_RecordChild5, // #3 = $offset
/*1640*/          OPC_MoveChild, 5,
/*1642*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1645*/          OPC_MoveParent,
/*1646*/          OPC_MoveChild, 6,
/*1648*/          OPC_CheckInteger, 0, 
/*1650*/          OPC_MoveParent,
/*1651*/          OPC_MoveChild, 7,
/*1653*/          OPC_CheckInteger, 0, 
/*1655*/          OPC_MoveParent,
/*1656*/          OPC_MoveChild, 8,
/*1658*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1661*/          OPC_RecordNode, // #4 = $glc
/*1662*/          OPC_MoveParent,
/*1663*/          OPC_MoveChild, 9,
/*1665*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1668*/          OPC_RecordNode, // #5 = $slc
/*1669*/          OPC_MoveParent,
/*1670*/          OPC_MoveChild, 10,
/*1672*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1675*/          OPC_RecordNode, // #6 = $tfe
/*1676*/          OPC_MoveParent,
/*1677*/          OPC_SwitchType /*2 cases */, 28, MVT::v2i32,// ->1708
/*1680*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*1682*/            OPC_EmitMergeInputChains1_0,
/*1683*/            OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*1686*/            OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*1689*/            OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*1692*/            OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*1695*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX2_OFFSET), 0|OPFL_Chain,
                        1/*#VTs*/, MVT::v2i32, 6/*#Ops*/, 1, 2, 7, 8, 9, 10, 
                    // Src: (intrinsic_w_chain:v2i32 4997:iPTR, v4i32:v4i32:$rsrc, (imm:i32), i32:i32:$soffset, (imm:i32):$offset, 0:i32, 0:i32, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 33
                    // Dst: (BUFFER_LOAD_DWORDX2_OFFSET:v2i32 ?:v4i32:$rsrc, ?:i32:$soffset, (as_i16imm:i16 ?:i32:$offset), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe))
/*1708*/          /*SwitchType*/ 28, MVT::v4i32,// ->1738
/*1710*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*1712*/            OPC_EmitMergeInputChains1_0,
/*1713*/            OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*1716*/            OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*1719*/            OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*1722*/            OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*1725*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX4_OFFSET), 0|OPFL_Chain,
                        1/*#VTs*/, MVT::v4i32, 6/*#Ops*/, 1, 2, 7, 8, 9, 10, 
                    // Src: (intrinsic_w_chain:v4i32 4997:iPTR, v4i32:v4i32:$rsrc, (imm:i32), i32:i32:$soffset, (imm:i32):$offset, 0:i32, 0:i32, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 33
                    // Dst: (BUFFER_LOAD_DWORDX4_OFFSET:v4i32 ?:v4i32:$rsrc, ?:i32:$soffset, (as_i16imm:i16 ?:i32:$offset), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe))
/*1738*/          0, // EndSwitchType
/*1739*/        /*Scope*/ 57|128,2/*313*/, /*->2054*/
/*1741*/          OPC_RecordChild3, // #2 = $vaddr
/*1742*/          OPC_Scope, 74|128,1/*202*/, /*->1947*/ // 2 children in Scope
/*1745*/            OPC_CheckChild3Type, MVT::i32,
/*1747*/            OPC_RecordChild4, // #3 = $soffset
/*1748*/            OPC_RecordChild5, // #4 = $offset
/*1749*/            OPC_MoveChild, 5,
/*1751*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1754*/            OPC_MoveParent,
/*1755*/            OPC_MoveChild, 6,
/*1757*/            OPC_Scope, 93, /*->1852*/ // 2 children in Scope
/*1759*/              OPC_CheckInteger, 1, 
/*1761*/              OPC_MoveParent,
/*1762*/              OPC_MoveChild, 7,
/*1764*/              OPC_CheckInteger, 0, 
/*1766*/              OPC_MoveParent,
/*1767*/              OPC_MoveChild, 8,
/*1769*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1772*/              OPC_RecordNode, // #5 = $glc
/*1773*/              OPC_MoveParent,
/*1774*/              OPC_MoveChild, 9,
/*1776*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1779*/              OPC_RecordNode, // #6 = $slc
/*1780*/              OPC_MoveParent,
/*1781*/              OPC_MoveChild, 10,
/*1783*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1786*/              OPC_RecordNode, // #7 = $tfe
/*1787*/              OPC_MoveParent,
/*1788*/              OPC_SwitchType /*2 cases */, 29, MVT::v2i32,// ->1820
/*1791*/                OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*1793*/                OPC_EmitMergeInputChains1_0,
/*1794*/                OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*1797*/                OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*1800*/                OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*1803*/                OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*1806*/                OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX2_OFFEN), 0|OPFL_Chain,
                            1/*#VTs*/, MVT::v2i32, 7/*#Ops*/, 2, 1, 3, 8, 9, 10, 11, 
                        // Src: (intrinsic_w_chain:v2i32 4997:iPTR, v4i32:v4i32:$rsrc, i32:i32:$vaddr, i32:i32:$soffset, (imm:i32):$offset, 1:i32, 0:i32, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 30
                        // Dst: (BUFFER_LOAD_DWORDX2_OFFEN:v2i32 ?:i32:$vaddr, ?:v4i32:$rsrc, ?:i32:$soffset, (as_i16imm:i16 ?:i32:$offset), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe))
/*1820*/              /*SwitchType*/ 29, MVT::v4i32,// ->1851
/*1822*/                OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*1824*/                OPC_EmitMergeInputChains1_0,
/*1825*/                OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*1828*/                OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*1831*/                OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*1834*/                OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*1837*/                OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX4_OFFEN), 0|OPFL_Chain,
                            1/*#VTs*/, MVT::v4i32, 7/*#Ops*/, 2, 1, 3, 8, 9, 10, 11, 
                        // Src: (intrinsic_w_chain:v4i32 4997:iPTR, v4i32:v4i32:$rsrc, i32:i32:$vaddr, i32:i32:$soffset, (imm:i32):$offset, 1:i32, 0:i32, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 30
                        // Dst: (BUFFER_LOAD_DWORDX4_OFFEN:v4i32 ?:i32:$vaddr, ?:v4i32:$rsrc, ?:i32:$soffset, (as_i16imm:i16 ?:i32:$offset), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe))
/*1851*/              0, // EndSwitchType
/*1852*/            /*Scope*/ 93, /*->1946*/
/*1853*/              OPC_CheckInteger, 0, 
/*1855*/              OPC_MoveParent,
/*1856*/              OPC_MoveChild, 7,
/*1858*/              OPC_CheckInteger, 1, 
/*1860*/              OPC_MoveParent,
/*1861*/              OPC_MoveChild, 8,
/*1863*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1866*/              OPC_RecordNode, // #5 = $glc
/*1867*/              OPC_MoveParent,
/*1868*/              OPC_MoveChild, 9,
/*1870*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1873*/              OPC_RecordNode, // #6 = $slc
/*1874*/              OPC_MoveParent,
/*1875*/              OPC_MoveChild, 10,
/*1877*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1880*/              OPC_RecordNode, // #7 = $tfe
/*1881*/              OPC_MoveParent,
/*1882*/              OPC_SwitchType /*2 cases */, 29, MVT::v2i32,// ->1914
/*1885*/                OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*1887*/                OPC_EmitMergeInputChains1_0,
/*1888*/                OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*1891*/                OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*1894*/                OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*1897*/                OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*1900*/                OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX2_IDXEN), 0|OPFL_Chain,
                            1/*#VTs*/, MVT::v2i32, 7/*#Ops*/, 2, 1, 3, 8, 9, 10, 11, 
                        // Src: (intrinsic_w_chain:v2i32 4997:iPTR, v4i32:v4i32:$rsrc, i32:i32:$vaddr, i32:i32:$soffset, (imm:i32):$offset, 0:i32, 1:i32, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 30
                        // Dst: (BUFFER_LOAD_DWORDX2_IDXEN:v2i32 ?:i32:$vaddr, ?:v4i32:$rsrc, ?:i32:$soffset, (as_i16imm:i16 ?:i32:$offset), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe))
/*1914*/              /*SwitchType*/ 29, MVT::v4i32,// ->1945
/*1916*/                OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*1918*/                OPC_EmitMergeInputChains1_0,
/*1919*/                OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*1922*/                OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*1925*/                OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*1928*/                OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*1931*/                OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX4_IDXEN), 0|OPFL_Chain,
                            1/*#VTs*/, MVT::v4i32, 7/*#Ops*/, 2, 1, 3, 8, 9, 10, 11, 
                        // Src: (intrinsic_w_chain:v4i32 4997:iPTR, v4i32:v4i32:$rsrc, i32:i32:$vaddr, i32:i32:$soffset, (imm:i32):$offset, 0:i32, 1:i32, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 30
                        // Dst: (BUFFER_LOAD_DWORDX4_IDXEN:v4i32 ?:i32:$vaddr, ?:v4i32:$rsrc, ?:i32:$soffset, (as_i16imm:i16 ?:i32:$offset), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe))
/*1945*/              0, // EndSwitchType
/*1946*/            0, /*End of Scope*/
/*1947*/          /*Scope*/ 105, /*->2053*/
/*1948*/            OPC_CheckChild3Type, MVT::v2i32,
/*1950*/            OPC_RecordChild4, // #3 = $soffset
/*1951*/            OPC_RecordChild5, // #4 = $offset
/*1952*/            OPC_MoveChild, 5,
/*1954*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1957*/            OPC_MoveParent,
/*1958*/            OPC_MoveChild, 6,
/*1960*/            OPC_CheckInteger, 1, 
/*1962*/            OPC_MoveParent,
/*1963*/            OPC_MoveChild, 7,
/*1965*/            OPC_CheckInteger, 1, 
/*1967*/            OPC_MoveParent,
/*1968*/            OPC_MoveChild, 8,
/*1970*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1973*/            OPC_RecordNode, // #5 = $glc
/*1974*/            OPC_MoveParent,
/*1975*/            OPC_MoveChild, 9,
/*1977*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1980*/            OPC_RecordNode, // #6 = $slc
/*1981*/            OPC_MoveParent,
/*1982*/            OPC_MoveChild, 10,
/*1984*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*1987*/            OPC_RecordNode, // #7 = $tfe
/*1988*/            OPC_MoveParent,
/*1989*/            OPC_SwitchType /*2 cases */, 29, MVT::v2i32,// ->2021
/*1992*/              OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*1994*/              OPC_EmitMergeInputChains1_0,
/*1995*/              OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*1998*/              OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*2001*/              OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*2004*/              OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*2007*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX2_BOTHEN), 0|OPFL_Chain,
                          1/*#VTs*/, MVT::v2i32, 7/*#Ops*/, 2, 1, 3, 8, 9, 10, 11, 
                      // Src: (intrinsic_w_chain:v2i32 4997:iPTR, v4i32:v4i32:$rsrc, v2i32:v2i32:$vaddr, i32:i32:$soffset, (imm:i32):$offset, 1:i32, 1:i32, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 30
                      // Dst: (BUFFER_LOAD_DWORDX2_BOTHEN:v2i32 ?:v2i32:$vaddr, ?:v4i32:$rsrc, ?:i32:$soffset, (as_i16imm:i16 ?:i32:$offset), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe))
/*2021*/            /*SwitchType*/ 29, MVT::v4i32,// ->2052
/*2023*/              OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*2025*/              OPC_EmitMergeInputChains1_0,
/*2026*/              OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*2029*/              OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*2032*/              OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*2035*/              OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*2038*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX4_BOTHEN), 0|OPFL_Chain,
                          1/*#VTs*/, MVT::v4i32, 7/*#Ops*/, 2, 1, 3, 8, 9, 10, 11, 
                      // Src: (intrinsic_w_chain:v4i32 4997:iPTR, v4i32:v4i32:$rsrc, v2i32:v2i32:$vaddr, i32:i32:$soffset, (imm:i32):$offset, 1:i32, 1:i32, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 30
                      // Dst: (BUFFER_LOAD_DWORDX4_BOTHEN:v4i32 ?:v2i32:$vaddr, ?:v4i32:$rsrc, ?:i32:$soffset, (as_i16imm:i16 ?:i32:$offset), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe))
/*2052*/            0, // EndSwitchType
/*2053*/          0, /*End of Scope*/
/*2054*/        0, /*End of Scope*/
/*2055*/      /*Scope*/ 23, /*->2079*/
/*2056*/        OPC_CheckChild1Integer, 38|128,39/*5030*/, 
/*2059*/        OPC_RecordChild2, // #1 = $vcc
/*2060*/        OPC_RecordChild3, // #2 = $target
/*2061*/        OPC_MoveChild, 3,
/*2063*/        OPC_CheckOpcode, TARGET_VAL(ISD::BasicBlock),
/*2066*/        OPC_MoveParent,
/*2067*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2069*/        OPC_EmitMergeInputChains1_0,
/*2070*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_IF), 0|OPFL_Chain,
                    1/*#VTs*/, MVT::i64, 2/*#Ops*/, 1, 2, 
                // Src: (intrinsic_w_chain:i64 5030:iPTR, i1:i1:$vcc, (bb:Other):$target) - Complexity = 8
                // Dst: (SI_IF:i64 i1:i1:$vcc, (bb:Other):$target)
/*2079*/      /*Scope*/ 23, /*->2103*/
/*2080*/        OPC_CheckChild1Integer, 6|128,39/*4998*/, 
/*2083*/        OPC_RecordChild2, // #1 = $src
/*2084*/        OPC_RecordChild3, // #2 = $target
/*2085*/        OPC_MoveChild, 3,
/*2087*/        OPC_CheckOpcode, TARGET_VAL(ISD::BasicBlock),
/*2090*/        OPC_MoveParent,
/*2091*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2093*/        OPC_EmitMergeInputChains1_0,
/*2094*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_ELSE), 0|OPFL_Chain,
                    1/*#VTs*/, MVT::i64, 2/*#Ops*/, 1, 2, 
                // Src: (intrinsic_w_chain:i64 4998:iPTR, i64:i64:$src, (bb:Other):$target) - Complexity = 8
                // Dst: (SI_ELSE:i64 i64:i64:$src, (bb:Other):$target)
/*2103*/      /*Scope*/ 15, /*->2119*/
/*2104*/        OPC_CheckChild1Integer, 4|128,39/*4996*/, 
/*2107*/        OPC_RecordChild2, // #1 = $src
/*2108*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2110*/        OPC_EmitMergeInputChains1_0,
/*2111*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_BREAK), 0|OPFL_Chain,
                    1/*#VTs*/, MVT::i64, 1/*#Ops*/, 1, 
                // Src: (intrinsic_w_chain:i64 4996:iPTR, i64:i64:$src) - Complexity = 8
                // Dst: (SI_BREAK:i64 i64:i64:$src)
/*2119*/      /*Scope*/ 17, /*->2137*/
/*2120*/        OPC_CheckChild1Integer, 39|128,39/*5031*/, 
/*2123*/        OPC_RecordChild2, // #1 = $vcc
/*2124*/        OPC_RecordChild3, // #2 = $src
/*2125*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2127*/        OPC_EmitMergeInputChains1_0,
/*2128*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_IF_BREAK), 0|OPFL_Chain,
                    1/*#VTs*/, MVT::i64, 2/*#Ops*/, 1, 2, 
                // Src: (intrinsic_w_chain:i64 5031:iPTR, i1:i1:$vcc, i64:i64:$src) - Complexity = 8
                // Dst: (SI_IF_BREAK:i64 i1:i1:$vcc, i64:i64:$src)
/*2137*/      /*Scope*/ 17, /*->2155*/
/*2138*/        OPC_CheckChild1Integer, 7|128,39/*4999*/, 
/*2141*/        OPC_RecordChild2, // #1 = $src0
/*2142*/        OPC_RecordChild3, // #2 = $src1
/*2143*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2145*/        OPC_EmitMergeInputChains1_0,
/*2146*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_ELSE_BREAK), 0|OPFL_Chain,
                    1/*#VTs*/, MVT::i64, 2/*#Ops*/, 1, 2, 
                // Src: (intrinsic_w_chain:i64 4999:iPTR, i64:i64:$src0, i64:i64:$src1) - Complexity = 8
                // Dst: (SI_ELSE_BREAK:i64 i64:i64:$src0, i64:i64:$src1)
/*2155*/      0, /*End of Scope*/
/*2156*/    /*SwitchOpcode*/ 72|128,3/*456*/, TARGET_VAL(AMDGPUISD::TBUFFER_STORE_FORMAT),// ->2616
/*2160*/      OPC_RecordMemRef,
/*2161*/      OPC_RecordNode, // #0 = 'SItbuffer_store' chained node
/*2162*/      OPC_RecordChild1, // #1 = $rsrc
/*2163*/      OPC_RecordChild2, // #2 = $vdata
/*2164*/      OPC_Scope, 111, /*->2277*/ // 3 children in Scope
/*2166*/        OPC_CheckChild2Type, MVT::i32,
/*2168*/        OPC_CheckChild3Integer, 1, 
/*2170*/        OPC_RecordChild4, // #3 = $vaddr
/*2171*/        OPC_RecordChild5, // #4 = $soffset
/*2172*/        OPC_RecordChild6, // #5 = $inst_offset
/*2173*/        OPC_MoveChild, 6,
/*2175*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2178*/        OPC_MoveParent,
/*2179*/        OPC_RecordChild7, // #6 = $dfmt
/*2180*/        OPC_MoveChild, 7,
/*2182*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2185*/        OPC_MoveParent,
/*2186*/        OPC_MoveChild, 8,
/*2188*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2191*/        OPC_RecordNode, // #7 = $nfmt
/*2192*/        OPC_MoveParent,
/*2193*/        OPC_MoveChild, 9,
/*2195*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2198*/        OPC_RecordNode, // #8 = $offen
/*2199*/        OPC_MoveParent,
/*2200*/        OPC_MoveChild, 10,
/*2202*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2205*/        OPC_RecordNode, // #9 = $idxen
/*2206*/        OPC_MoveParent,
/*2207*/        OPC_MoveChild, 11,
/*2209*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2212*/        OPC_RecordNode, // #10 = $glc
/*2213*/        OPC_MoveParent,
/*2214*/        OPC_MoveChild, 12,
/*2216*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2219*/        OPC_RecordNode, // #11 = $slc
/*2220*/        OPC_MoveParent,
/*2221*/        OPC_MoveChild, 13,
/*2223*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2226*/        OPC_RecordNode, // #12 = $tfe
/*2227*/        OPC_MoveParent,
/*2228*/        OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*2230*/        OPC_EmitMergeInputChains1_0,
/*2231*/        OPC_EmitNodeXForm, 0, 5, // as_i16imm
/*2234*/        OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*2237*/        OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*2240*/        OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*2243*/        OPC_EmitInteger, MVT::i1, 0, 
/*2246*/        OPC_EmitNodeXForm, 2, 6, // as_i8imm
/*2249*/        OPC_EmitNodeXForm, 2, 7, // as_i8imm
/*2252*/        OPC_EmitNodeXForm, 1, 11, // as_i1imm
/*2255*/        OPC_EmitNodeXForm, 1, 12, // as_i1imm
/*2258*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::TBUFFER_STORE_FORMAT_X), 0|OPFL_Chain|OPFL_MemRefs,
                    0/*#VTs*/, 13/*#Ops*/, 2, 13, 14, 15, 16, 17, 18, 19, 3, 1, 20, 21, 4, 
                // Src: (SItbuffer_store v4i32:v4i32:$rsrc, i32:i32:$vdata, 1:i32, i32:i32:$vaddr, i32:i32:$soffset, (imm:i32):$inst_offset, (imm:i32):$dfmt, (imm:i32):$nfmt, (imm:i32):$offen, (imm:i32):$idxen, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 32
                // Dst: (TBUFFER_STORE_FORMAT_X ?:i32:$vdata, (as_i16imm:i16 ?:i32:$inst_offset), (as_i1imm:i1 ?:i32:$offen), (as_i1imm:i1 ?:i32:$idxen), (as_i1imm:i1 ?:i32:$glc), 0:i1, (as_i8imm:i8 ?:i32:$dfmt), (as_i8imm:i8 ?:i32:$nfmt), ?:i32:$vaddr, ?:v4i32:$rsrc, (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe), ?:i32:$soffset)
/*2277*/      /*Scope*/ 111, /*->2389*/
/*2278*/        OPC_CheckChild2Type, MVT::v2i32,
/*2280*/        OPC_CheckChild3Integer, 2, 
/*2282*/        OPC_RecordChild4, // #3 = $vaddr
/*2283*/        OPC_RecordChild5, // #4 = $soffset
/*2284*/        OPC_RecordChild6, // #5 = $inst_offset
/*2285*/        OPC_MoveChild, 6,
/*2287*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2290*/        OPC_MoveParent,
/*2291*/        OPC_RecordChild7, // #6 = $dfmt
/*2292*/        OPC_MoveChild, 7,
/*2294*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2297*/        OPC_MoveParent,
/*2298*/        OPC_MoveChild, 8,
/*2300*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2303*/        OPC_RecordNode, // #7 = $nfmt
/*2304*/        OPC_MoveParent,
/*2305*/        OPC_MoveChild, 9,
/*2307*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2310*/        OPC_RecordNode, // #8 = $offen
/*2311*/        OPC_MoveParent,
/*2312*/        OPC_MoveChild, 10,
/*2314*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2317*/        OPC_RecordNode, // #9 = $idxen
/*2318*/        OPC_MoveParent,
/*2319*/        OPC_MoveChild, 11,
/*2321*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2324*/        OPC_RecordNode, // #10 = $glc
/*2325*/        OPC_MoveParent,
/*2326*/        OPC_MoveChild, 12,
/*2328*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2331*/        OPC_RecordNode, // #11 = $slc
/*2332*/        OPC_MoveParent,
/*2333*/        OPC_MoveChild, 13,
/*2335*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2338*/        OPC_RecordNode, // #12 = $tfe
/*2339*/        OPC_MoveParent,
/*2340*/        OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*2342*/        OPC_EmitMergeInputChains1_0,
/*2343*/        OPC_EmitNodeXForm, 0, 5, // as_i16imm
/*2346*/        OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*2349*/        OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*2352*/        OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*2355*/        OPC_EmitInteger, MVT::i1, 0, 
/*2358*/        OPC_EmitNodeXForm, 2, 6, // as_i8imm
/*2361*/        OPC_EmitNodeXForm, 2, 7, // as_i8imm
/*2364*/        OPC_EmitNodeXForm, 1, 11, // as_i1imm
/*2367*/        OPC_EmitNodeXForm, 1, 12, // as_i1imm
/*2370*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::TBUFFER_STORE_FORMAT_XY), 0|OPFL_Chain|OPFL_MemRefs,
                    0/*#VTs*/, 13/*#Ops*/, 2, 13, 14, 15, 16, 17, 18, 19, 3, 1, 20, 21, 4, 
                // Src: (SItbuffer_store v4i32:v4i32:$rsrc, v2i32:v2i32:$vdata, 2:i32, i32:i32:$vaddr, i32:i32:$soffset, (imm:i32):$inst_offset, (imm:i32):$dfmt, (imm:i32):$nfmt, (imm:i32):$offen, (imm:i32):$idxen, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 32
                // Dst: (TBUFFER_STORE_FORMAT_XY ?:v2i32:$vdata, (as_i16imm:i16 ?:i32:$inst_offset), (as_i1imm:i1 ?:i32:$offen), (as_i1imm:i1 ?:i32:$idxen), (as_i1imm:i1 ?:i32:$glc), 0:i1, (as_i8imm:i8 ?:i32:$dfmt), (as_i8imm:i8 ?:i32:$nfmt), ?:i32:$vaddr, ?:v4i32:$rsrc, (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe), ?:i32:$soffset)
/*2389*/      /*Scope*/ 96|128,1/*224*/, /*->2615*/
/*2391*/        OPC_CheckChild2Type, MVT::v4i32,
/*2393*/        OPC_Scope, 109, /*->2504*/ // 2 children in Scope
/*2395*/          OPC_CheckChild3Integer, 3, 
/*2397*/          OPC_RecordChild4, // #3 = $vaddr
/*2398*/          OPC_RecordChild5, // #4 = $soffset
/*2399*/          OPC_RecordChild6, // #5 = $inst_offset
/*2400*/          OPC_MoveChild, 6,
/*2402*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2405*/          OPC_MoveParent,
/*2406*/          OPC_RecordChild7, // #6 = $dfmt
/*2407*/          OPC_MoveChild, 7,
/*2409*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2412*/          OPC_MoveParent,
/*2413*/          OPC_MoveChild, 8,
/*2415*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2418*/          OPC_RecordNode, // #7 = $nfmt
/*2419*/          OPC_MoveParent,
/*2420*/          OPC_MoveChild, 9,
/*2422*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2425*/          OPC_RecordNode, // #8 = $offen
/*2426*/          OPC_MoveParent,
/*2427*/          OPC_MoveChild, 10,
/*2429*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2432*/          OPC_RecordNode, // #9 = $idxen
/*2433*/          OPC_MoveParent,
/*2434*/          OPC_MoveChild, 11,
/*2436*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2439*/          OPC_RecordNode, // #10 = $glc
/*2440*/          OPC_MoveParent,
/*2441*/          OPC_MoveChild, 12,
/*2443*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2446*/          OPC_RecordNode, // #11 = $slc
/*2447*/          OPC_MoveParent,
/*2448*/          OPC_MoveChild, 13,
/*2450*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2453*/          OPC_RecordNode, // #12 = $tfe
/*2454*/          OPC_MoveParent,
/*2455*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*2457*/          OPC_EmitMergeInputChains1_0,
/*2458*/          OPC_EmitNodeXForm, 0, 5, // as_i16imm
/*2461*/          OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*2464*/          OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*2467*/          OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*2470*/          OPC_EmitInteger, MVT::i1, 0, 
/*2473*/          OPC_EmitNodeXForm, 2, 6, // as_i8imm
/*2476*/          OPC_EmitNodeXForm, 2, 7, // as_i8imm
/*2479*/          OPC_EmitNodeXForm, 1, 11, // as_i1imm
/*2482*/          OPC_EmitNodeXForm, 1, 12, // as_i1imm
/*2485*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::TBUFFER_STORE_FORMAT_XYZ), 0|OPFL_Chain|OPFL_MemRefs,
                      0/*#VTs*/, 13/*#Ops*/, 2, 13, 14, 15, 16, 17, 18, 19, 3, 1, 20, 21, 4, 
                  // Src: (SItbuffer_store v4i32:v4i32:$rsrc, v4i32:v4i32:$vdata, 3:i32, i32:i32:$vaddr, i32:i32:$soffset, (imm:i32):$inst_offset, (imm:i32):$dfmt, (imm:i32):$nfmt, (imm:i32):$offen, (imm:i32):$idxen, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 32
                  // Dst: (TBUFFER_STORE_FORMAT_XYZ ?:v4i32:$vdata, (as_i16imm:i16 ?:i32:$inst_offset), (as_i1imm:i1 ?:i32:$offen), (as_i1imm:i1 ?:i32:$idxen), (as_i1imm:i1 ?:i32:$glc), 0:i1, (as_i8imm:i8 ?:i32:$dfmt), (as_i8imm:i8 ?:i32:$nfmt), ?:i32:$vaddr, ?:v4i32:$rsrc, (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe), ?:i32:$soffset)
/*2504*/        /*Scope*/ 109, /*->2614*/
/*2505*/          OPC_CheckChild3Integer, 4, 
/*2507*/          OPC_RecordChild4, // #3 = $vaddr
/*2508*/          OPC_RecordChild5, // #4 = $soffset
/*2509*/          OPC_RecordChild6, // #5 = $inst_offset
/*2510*/          OPC_MoveChild, 6,
/*2512*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2515*/          OPC_MoveParent,
/*2516*/          OPC_RecordChild7, // #6 = $dfmt
/*2517*/          OPC_MoveChild, 7,
/*2519*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2522*/          OPC_MoveParent,
/*2523*/          OPC_MoveChild, 8,
/*2525*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2528*/          OPC_RecordNode, // #7 = $nfmt
/*2529*/          OPC_MoveParent,
/*2530*/          OPC_MoveChild, 9,
/*2532*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2535*/          OPC_RecordNode, // #8 = $offen
/*2536*/          OPC_MoveParent,
/*2537*/          OPC_MoveChild, 10,
/*2539*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2542*/          OPC_RecordNode, // #9 = $idxen
/*2543*/          OPC_MoveParent,
/*2544*/          OPC_MoveChild, 11,
/*2546*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2549*/          OPC_RecordNode, // #10 = $glc
/*2550*/          OPC_MoveParent,
/*2551*/          OPC_MoveChild, 12,
/*2553*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2556*/          OPC_RecordNode, // #11 = $slc
/*2557*/          OPC_MoveParent,
/*2558*/          OPC_MoveChild, 13,
/*2560*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*2563*/          OPC_RecordNode, // #12 = $tfe
/*2564*/          OPC_MoveParent,
/*2565*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*2567*/          OPC_EmitMergeInputChains1_0,
/*2568*/          OPC_EmitNodeXForm, 0, 5, // as_i16imm
/*2571*/          OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*2574*/          OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*2577*/          OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*2580*/          OPC_EmitInteger, MVT::i1, 0, 
/*2583*/          OPC_EmitNodeXForm, 2, 6, // as_i8imm
/*2586*/          OPC_EmitNodeXForm, 2, 7, // as_i8imm
/*2589*/          OPC_EmitNodeXForm, 1, 11, // as_i1imm
/*2592*/          OPC_EmitNodeXForm, 1, 12, // as_i1imm
/*2595*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::TBUFFER_STORE_FORMAT_XYZW), 0|OPFL_Chain|OPFL_MemRefs,
                      0/*#VTs*/, 13/*#Ops*/, 2, 13, 14, 15, 16, 17, 18, 19, 3, 1, 20, 21, 4, 
                  // Src: (SItbuffer_store v4i32:v4i32:$rsrc, v4i32:v4i32:$vdata, 4:i32, i32:i32:$vaddr, i32:i32:$soffset, (imm:i32):$inst_offset, (imm:i32):$dfmt, (imm:i32):$nfmt, (imm:i32):$offen, (imm:i32):$idxen, (imm:i32):$glc, (imm:i32):$slc, (imm:i32):$tfe) - Complexity = 32
                  // Dst: (TBUFFER_STORE_FORMAT_XYZW ?:v4i32:$vdata, (as_i16imm:i16 ?:i32:$inst_offset), (as_i1imm:i1 ?:i32:$offen), (as_i1imm:i1 ?:i32:$idxen), (as_i1imm:i1 ?:i32:$glc), 0:i1, (as_i8imm:i8 ?:i32:$dfmt), (as_i8imm:i8 ?:i32:$nfmt), ?:i32:$vaddr, ?:v4i32:$rsrc, (as_i1imm:i1 ?:i32:$slc), (as_i1imm:i1 ?:i32:$tfe), ?:i32:$soffset)
/*2614*/        0, /*End of Scope*/
/*2615*/      0, /*End of Scope*/
/*2616*/    /*SwitchOpcode*/ 92|128,24/*3164*/, TARGET_VAL(ISD::LOAD),// ->5784
/*2620*/      OPC_RecordMemRef,
/*2621*/      OPC_RecordNode, // #0 = 'ld' chained node
/*2622*/      OPC_Scope, 53|128,6/*821*/, /*->3446*/ // 12 children in Scope
/*2625*/        OPC_RecordChild1, // #1 = $MUBUFAddr64:srsrc:vaddr:soffset:offset:glc:slc:tfe
/*2626*/        OPC_CheckPredicate, 23, // Predicate_unindexedload
/*2628*/        OPC_CheckType, MVT::i32,
/*2630*/        OPC_Scope, 26, /*->2658*/ // 19 children in Scope
/*2632*/          OPC_CheckPredicate, 24, // Predicate_az_extload
/*2634*/          OPC_CheckPredicate, 25, // Predicate_az_extloadi8
/*2636*/          OPC_CheckPredicate, 26, // Predicate_az_extloadi8_global
/*2638*/          OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2640*/          OPC_CheckComplexPat, /*CP*/1, /*#*/1, // SelectMUBUFAddr64:$ #2 #3 #4 #5 #6 #7 #8
/*2643*/          OPC_EmitMergeInputChains1_0,
/*2644*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_UBYTE_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi8>><<P:Predicate_az_extloadi8_global>> - Complexity = 28
                  // Dst: (BUFFER_LOAD_UBYTE_ADDR64:i32 i64:i64:$vaddr, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*2658*/        /*Scope*/ 26, /*->2685*/
/*2659*/          OPC_CheckPredicate, 27, // Predicate_sextload
/*2661*/          OPC_CheckPredicate, 28, // Predicate_sextloadi8
/*2663*/          OPC_CheckPredicate, 29, // Predicate_sextloadi8_global
/*2665*/          OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2667*/          OPC_CheckComplexPat, /*CP*/1, /*#*/1, // SelectMUBUFAddr64:$ #2 #3 #4 #5 #6 #7 #8
/*2670*/          OPC_EmitMergeInputChains1_0,
/*2671*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_SBYTE_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>><<P:Predicate_sextloadi8_global>> - Complexity = 28
                  // Dst: (BUFFER_LOAD_SBYTE_ADDR64:i32 i64:i64:$vaddr, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*2685*/        /*Scope*/ 26, /*->2712*/
/*2686*/          OPC_CheckPredicate, 24, // Predicate_az_extload
/*2688*/          OPC_CheckPredicate, 30, // Predicate_az_extloadi16
/*2690*/          OPC_CheckPredicate, 31, // Predicate_az_extloadi16_global
/*2692*/          OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2694*/          OPC_CheckComplexPat, /*CP*/1, /*#*/1, // SelectMUBUFAddr64:$ #2 #3 #4 #5 #6 #7 #8
/*2697*/          OPC_EmitMergeInputChains1_0,
/*2698*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_USHORT_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi16>><<P:Predicate_az_extloadi16_global>> - Complexity = 28
                  // Dst: (BUFFER_LOAD_USHORT_ADDR64:i32 i64:i64:$vaddr, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*2712*/        /*Scope*/ 26, /*->2739*/
/*2713*/          OPC_CheckPredicate, 27, // Predicate_sextload
/*2715*/          OPC_CheckPredicate, 32, // Predicate_sextloadi16
/*2717*/          OPC_CheckPredicate, 33, // Predicate_sextloadi16_global
/*2719*/          OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2721*/          OPC_CheckComplexPat, /*CP*/1, /*#*/1, // SelectMUBUFAddr64:$ #2 #3 #4 #5 #6 #7 #8
/*2724*/          OPC_EmitMergeInputChains1_0,
/*2725*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_SSHORT_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>><<P:Predicate_sextloadi16_global>> - Complexity = 28
                  // Dst: (BUFFER_LOAD_SSHORT_ADDR64:i32 i64:i64:$vaddr, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*2739*/        /*Scope*/ 24, /*->2764*/
/*2740*/          OPC_CheckPredicate, 34, // Predicate_load
/*2742*/          OPC_CheckPredicate, 35, // Predicate_global_load
/*2744*/          OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2746*/          OPC_CheckComplexPat, /*CP*/1, /*#*/1, // SelectMUBUFAddr64:$ #2 #3 #4 #5 #6 #7 #8
/*2749*/          OPC_EmitMergeInputChains1_0,
/*2750*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORD_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 28
                  // Dst: (BUFFER_LOAD_DWORD_ADDR64:i32 i64:i64:$vaddr, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*2764*/        /*Scope*/ 26, /*->2791*/
/*2765*/          OPC_CheckPredicate, 27, // Predicate_sextload
/*2767*/          OPC_CheckPredicate, 28, // Predicate_sextloadi8
/*2769*/          OPC_CheckPredicate, 36, // Predicate_sextloadi8_constant
/*2771*/          OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*2773*/          OPC_CheckComplexPat, /*CP*/1, /*#*/1, // SelectMUBUFAddr64:$ #2 #3 #4 #5 #6 #7 #8
/*2776*/          OPC_EmitMergeInputChains1_0,
/*2777*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_SBYTE_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>><<P:Predicate_sextloadi8_constant>> - Complexity = 28
                  // Dst: (BUFFER_LOAD_SBYTE_ADDR64:i32 ?:i64:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, ?:i1:$glc, ?:i1:$slc, ?:i1:$tfe)
/*2791*/        /*Scope*/ 26, /*->2818*/
/*2792*/          OPC_CheckPredicate, 24, // Predicate_az_extload
/*2794*/          OPC_CheckPredicate, 25, // Predicate_az_extloadi8
/*2796*/          OPC_CheckPredicate, 37, // Predicate_az_extloadi8_constant
/*2798*/          OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*2800*/          OPC_CheckComplexPat, /*CP*/1, /*#*/1, // SelectMUBUFAddr64:$ #2 #3 #4 #5 #6 #7 #8
/*2803*/          OPC_EmitMergeInputChains1_0,
/*2804*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_UBYTE_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi8>><<P:Predicate_az_extloadi8_constant>> - Complexity = 28
                  // Dst: (BUFFER_LOAD_UBYTE_ADDR64:i32 ?:i64:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, ?:i1:$glc, ?:i1:$slc, ?:i1:$tfe)
/*2818*/        /*Scope*/ 26, /*->2845*/
/*2819*/          OPC_CheckPredicate, 27, // Predicate_sextload
/*2821*/          OPC_CheckPredicate, 32, // Predicate_sextloadi16
/*2823*/          OPC_CheckPredicate, 38, // Predicate_sextloadi16_constant
/*2825*/          OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*2827*/          OPC_CheckComplexPat, /*CP*/1, /*#*/1, // SelectMUBUFAddr64:$ #2 #3 #4 #5 #6 #7 #8
/*2830*/          OPC_EmitMergeInputChains1_0,
/*2831*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_SSHORT_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>><<P:Predicate_sextloadi16_constant>> - Complexity = 28
                  // Dst: (BUFFER_LOAD_SSHORT_ADDR64:i32 ?:i64:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, ?:i1:$glc, ?:i1:$slc, ?:i1:$tfe)
/*2845*/        /*Scope*/ 53, /*->2899*/
/*2846*/          OPC_CheckPredicate, 24, // Predicate_az_extload
/*2848*/          OPC_Scope, 24, /*->2874*/ // 2 children in Scope
/*2850*/            OPC_CheckPredicate, 30, // Predicate_az_extloadi16
/*2852*/            OPC_CheckPredicate, 39, // Predicate_az_extloadi16_constant
/*2854*/            OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*2856*/            OPC_CheckComplexPat, /*CP*/1, /*#*/1, // SelectMUBUFAddr64:$ #2 #3 #4 #5 #6 #7 #8
/*2859*/            OPC_EmitMergeInputChains1_0,
/*2860*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_USHORT_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                    // Src: (ld:i32 (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi16>><<P:Predicate_az_extloadi16_constant>> - Complexity = 28
                    // Dst: (BUFFER_LOAD_USHORT_ADDR64:i32 ?:i64:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, ?:i1:$glc, ?:i1:$slc, ?:i1:$tfe)
/*2874*/          /*Scope*/ 23, /*->2898*/
/*2875*/            OPC_CheckPredicate, 25, // Predicate_az_extloadi8
/*2877*/            OPC_CheckPredicate, 26, // Predicate_az_extloadi8_global
/*2879*/            OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2881*/            OPC_CheckComplexPat, /*CP*/2, /*#*/1, // SelectMUBUFOffset:$ #2 #3 #4 #5 #6 #7
/*2884*/            OPC_EmitMergeInputChains1_0,
/*2885*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_UBYTE_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                    // Src: (ld:i32 (MUBUFOffset:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi8>><<P:Predicate_az_extloadi8_global>> - Complexity = 25
                    // Dst: (BUFFER_LOAD_UBYTE_OFFSET:i32 v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*2898*/          0, /*End of Scope*/
/*2899*/        /*Scope*/ 25, /*->2925*/
/*2900*/          OPC_CheckPredicate, 27, // Predicate_sextload
/*2902*/          OPC_CheckPredicate, 28, // Predicate_sextloadi8
/*2904*/          OPC_CheckPredicate, 29, // Predicate_sextloadi8_global
/*2906*/          OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2908*/          OPC_CheckComplexPat, /*CP*/2, /*#*/1, // SelectMUBUFOffset:$ #2 #3 #4 #5 #6 #7
/*2911*/          OPC_EmitMergeInputChains1_0,
/*2912*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_SBYTE_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (ld:i32 (MUBUFOffset:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>><<P:Predicate_sextloadi8_global>> - Complexity = 25
                  // Dst: (BUFFER_LOAD_SBYTE_OFFSET:i32 v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*2925*/        /*Scope*/ 25, /*->2951*/
/*2926*/          OPC_CheckPredicate, 24, // Predicate_az_extload
/*2928*/          OPC_CheckPredicate, 30, // Predicate_az_extloadi16
/*2930*/          OPC_CheckPredicate, 31, // Predicate_az_extloadi16_global
/*2932*/          OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2934*/          OPC_CheckComplexPat, /*CP*/2, /*#*/1, // SelectMUBUFOffset:$ #2 #3 #4 #5 #6 #7
/*2937*/          OPC_EmitMergeInputChains1_0,
/*2938*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_USHORT_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (ld:i32 (MUBUFOffset:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi16>><<P:Predicate_az_extloadi16_global>> - Complexity = 25
                  // Dst: (BUFFER_LOAD_USHORT_OFFSET:i32 v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*2951*/        /*Scope*/ 25, /*->2977*/
/*2952*/          OPC_CheckPredicate, 27, // Predicate_sextload
/*2954*/          OPC_CheckPredicate, 32, // Predicate_sextloadi16
/*2956*/          OPC_CheckPredicate, 33, // Predicate_sextloadi16_global
/*2958*/          OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2960*/          OPC_CheckComplexPat, /*CP*/2, /*#*/1, // SelectMUBUFOffset:$ #2 #3 #4 #5 #6 #7
/*2963*/          OPC_EmitMergeInputChains1_0,
/*2964*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_SSHORT_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (ld:i32 (MUBUFOffset:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>><<P:Predicate_sextloadi16_global>> - Complexity = 25
                  // Dst: (BUFFER_LOAD_SSHORT_OFFSET:i32 v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*2977*/        /*Scope*/ 23, /*->3001*/
/*2978*/          OPC_CheckPredicate, 34, // Predicate_load
/*2980*/          OPC_CheckPredicate, 35, // Predicate_global_load
/*2982*/          OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*2984*/          OPC_CheckComplexPat, /*CP*/2, /*#*/1, // SelectMUBUFOffset:$ #2 #3 #4 #5 #6 #7
/*2987*/          OPC_EmitMergeInputChains1_0,
/*2988*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORD_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (ld:i32 (MUBUFOffset:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 25
                  // Dst: (BUFFER_LOAD_DWORD_OFFSET:i32 v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*3001*/        /*Scope*/ 35, /*->3037*/
/*3002*/          OPC_CheckPredicate, 27, // Predicate_sextload
/*3004*/          OPC_CheckPredicate, 28, // Predicate_sextloadi8
/*3006*/          OPC_CheckPredicate, 40, // Predicate_sextloadi8_private
/*3008*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*3010*/          OPC_CheckComplexPat, /*CP*/3, /*#*/1, // SelectMUBUFScratch:$ #2 #3 #4 #5
/*3013*/          OPC_EmitMergeInputChains1_0,
/*3014*/          OPC_EmitInteger, MVT::i1, 0, 
/*3017*/          OPC_EmitInteger, MVT::i1, 0, 
/*3020*/          OPC_EmitInteger, MVT::i1, 0, 
/*3023*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_SBYTE_OFFEN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFScratch:iPTR v4i32:v4i32:$srsrc, i32:i32:$vaddr, i32:i32:$soffset, u16imm:i16:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>><<P:Predicate_sextloadi8_private>> - Complexity = 19
                  // Dst: (BUFFER_LOAD_SBYTE_OFFEN:i32 ?:i32:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, 0:i1, 0:i1, 0:i1)
/*3037*/        /*Scope*/ 35, /*->3073*/
/*3038*/          OPC_CheckPredicate, 24, // Predicate_az_extload
/*3040*/          OPC_CheckPredicate, 25, // Predicate_az_extloadi8
/*3042*/          OPC_CheckPredicate, 41, // Predicate_extloadi8_private
/*3044*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*3046*/          OPC_CheckComplexPat, /*CP*/3, /*#*/1, // SelectMUBUFScratch:$ #2 #3 #4 #5
/*3049*/          OPC_EmitMergeInputChains1_0,
/*3050*/          OPC_EmitInteger, MVT::i1, 0, 
/*3053*/          OPC_EmitInteger, MVT::i1, 0, 
/*3056*/          OPC_EmitInteger, MVT::i1, 0, 
/*3059*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_UBYTE_OFFEN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFScratch:iPTR v4i32:v4i32:$srsrc, i32:i32:$vaddr, i32:i32:$soffset, u16imm:i16:$offset))<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi8>><<P:Predicate_extloadi8_private>> - Complexity = 19
                  // Dst: (BUFFER_LOAD_UBYTE_OFFEN:i32 ?:i32:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, 0:i1, 0:i1, 0:i1)
/*3073*/        /*Scope*/ 35, /*->3109*/
/*3074*/          OPC_CheckPredicate, 27, // Predicate_sextload
/*3076*/          OPC_CheckPredicate, 32, // Predicate_sextloadi16
/*3078*/          OPC_CheckPredicate, 42, // Predicate_sextloadi16_private
/*3080*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*3082*/          OPC_CheckComplexPat, /*CP*/3, /*#*/1, // SelectMUBUFScratch:$ #2 #3 #4 #5
/*3085*/          OPC_EmitMergeInputChains1_0,
/*3086*/          OPC_EmitInteger, MVT::i1, 0, 
/*3089*/          OPC_EmitInteger, MVT::i1, 0, 
/*3092*/          OPC_EmitInteger, MVT::i1, 0, 
/*3095*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_SSHORT_OFFEN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFScratch:iPTR v4i32:v4i32:$srsrc, i32:i32:$vaddr, i32:i32:$soffset, u16imm:i16:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>><<P:Predicate_sextloadi16_private>> - Complexity = 19
                  // Dst: (BUFFER_LOAD_SSHORT_OFFEN:i32 ?:i32:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, 0:i1, 0:i1, 0:i1)
/*3109*/        /*Scope*/ 35, /*->3145*/
/*3110*/          OPC_CheckPredicate, 24, // Predicate_az_extload
/*3112*/          OPC_CheckPredicate, 30, // Predicate_az_extloadi16
/*3114*/          OPC_CheckPredicate, 43, // Predicate_extloadi16_private
/*3116*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*3118*/          OPC_CheckComplexPat, /*CP*/3, /*#*/1, // SelectMUBUFScratch:$ #2 #3 #4 #5
/*3121*/          OPC_EmitMergeInputChains1_0,
/*3122*/          OPC_EmitInteger, MVT::i1, 0, 
/*3125*/          OPC_EmitInteger, MVT::i1, 0, 
/*3128*/          OPC_EmitInteger, MVT::i1, 0, 
/*3131*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_USHORT_OFFEN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFScratch:iPTR v4i32:v4i32:$srsrc, i32:i32:$vaddr, i32:i32:$soffset, u16imm:i16:$offset))<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi16>><<P:Predicate_extloadi16_private>> - Complexity = 19
                  // Dst: (BUFFER_LOAD_USHORT_OFFEN:i32 ?:i32:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, 0:i1, 0:i1, 0:i1)
/*3145*/        /*Scope*/ 33, /*->3179*/
/*3146*/          OPC_CheckPredicate, 34, // Predicate_load
/*3148*/          OPC_CheckPredicate, 44, // Predicate_load_private
/*3150*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*3152*/          OPC_CheckComplexPat, /*CP*/3, /*#*/1, // SelectMUBUFScratch:$ #2 #3 #4 #5
/*3155*/          OPC_EmitMergeInputChains1_0,
/*3156*/          OPC_EmitInteger, MVT::i1, 0, 
/*3159*/          OPC_EmitInteger, MVT::i1, 0, 
/*3162*/          OPC_EmitInteger, MVT::i1, 0, 
/*3165*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORD_OFFEN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                  // Src: (ld:i32 (MUBUFScratch:iPTR v4i32:v4i32:$srsrc, i32:i32:$vaddr, i32:i32:$soffset, u16imm:i16:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_load_private>> - Complexity = 19
                  // Dst: (BUFFER_LOAD_DWORD_OFFEN:i32 ?:i32:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, 0:i1, 0:i1, 0:i1)
/*3179*/        /*Scope*/ 8|128,2/*264*/, /*->3445*/
/*3181*/          OPC_CheckChild1Type, MVT::i32,
/*3183*/          OPC_Scope, 44, /*->3229*/ // 8 children in Scope
/*3185*/            OPC_CheckPredicate, 24, // Predicate_az_extload
/*3187*/            OPC_Scope, 19, /*->3208*/ // 2 children in Scope
/*3189*/              OPC_CheckPredicate, 25, // Predicate_az_extloadi8
/*3191*/              OPC_CheckPredicate, 45, // Predicate_load_param_exti8
/*3193*/              OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*3195*/              OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*3198*/              OPC_EmitMergeInputChains1_0,
/*3199*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_PARAM_8_eg), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
                      // Src: (ld:i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi8>><<P:Predicate_load_param_exti8>> - Complexity = 13
                      // Dst: (VTX_READ_PARAM_8_eg:i32 ADDRVTX_READ:i32:$src_gpr)
/*3208*/            /*Scope*/ 19, /*->3228*/
/*3209*/              OPC_CheckPredicate, 30, // Predicate_az_extloadi16
/*3211*/              OPC_CheckPredicate, 46, // Predicate_load_param_exti16
/*3213*/              OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*3215*/              OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*3218*/              OPC_EmitMergeInputChains1_0,
/*3219*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_PARAM_16_eg), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
                      // Src: (ld:i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi16>><<P:Predicate_load_param_exti16>> - Complexity = 13
                      // Dst: (VTX_READ_PARAM_16_eg:i32 ADDRVTX_READ:i32:$src_gpr)
/*3228*/            0, /*End of Scope*/
/*3229*/          /*Scope*/ 19, /*->3249*/
/*3230*/            OPC_CheckPredicate, 34, // Predicate_load
/*3232*/            OPC_CheckPredicate, 47, // Predicate_load_param
/*3234*/            OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*3236*/            OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*3239*/            OPC_EmitMergeInputChains1_0,
/*3240*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_PARAM_32_eg), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
                    // Src: (ld:i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_load_param>> - Complexity = 13
                    // Dst: (VTX_READ_PARAM_32_eg:i32 ADDRVTX_READ:i32:$src_gpr)
/*3249*/          /*Scope*/ 44, /*->3294*/
/*3250*/            OPC_CheckPredicate, 24, // Predicate_az_extload
/*3252*/            OPC_Scope, 19, /*->3273*/ // 2 children in Scope
/*3254*/              OPC_CheckPredicate, 25, // Predicate_az_extloadi8
/*3256*/              OPC_CheckPredicate, 26, // Predicate_az_extloadi8_global
/*3258*/              OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*3260*/              OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*3263*/              OPC_EmitMergeInputChains1_0,
/*3264*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_GLOBAL_8_eg), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
                      // Src: (ld:i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi8>><<P:Predicate_az_extloadi8_global>> - Complexity = 13
                      // Dst: (VTX_READ_GLOBAL_8_eg:i32 ADDRVTX_READ:i32:$src_gpr)
/*3273*/            /*Scope*/ 19, /*->3293*/
/*3274*/              OPC_CheckPredicate, 30, // Predicate_az_extloadi16
/*3276*/              OPC_CheckPredicate, 31, // Predicate_az_extloadi16_global
/*3278*/              OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*3280*/              OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*3283*/              OPC_EmitMergeInputChains1_0,
/*3284*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_GLOBAL_16_eg), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
                      // Src: (ld:i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi16>><<P:Predicate_az_extloadi16_global>> - Complexity = 13
                      // Dst: (VTX_READ_GLOBAL_16_eg:i32 ADDRVTX_READ:i32:$src_gpr)
/*3293*/            0, /*End of Scope*/
/*3294*/          /*Scope*/ 19, /*->3314*/
/*3295*/            OPC_CheckPredicate, 34, // Predicate_load
/*3297*/            OPC_CheckPredicate, 35, // Predicate_global_load
/*3299*/            OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*3301*/            OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*3304*/            OPC_EmitMergeInputChains1_0,
/*3305*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_GLOBAL_32_eg), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
                    // Src: (ld:i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 13
                    // Dst: (VTX_READ_GLOBAL_32_eg:i32 ADDRVTX_READ:i32:$src_gpr)
/*3314*/          /*Scope*/ 44, /*->3359*/
/*3315*/            OPC_CheckPredicate, 24, // Predicate_az_extload
/*3317*/            OPC_Scope, 19, /*->3338*/ // 2 children in Scope
/*3319*/              OPC_CheckPredicate, 25, // Predicate_az_extloadi8
/*3321*/              OPC_CheckPredicate, 45, // Predicate_load_param_exti8
/*3323*/              OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*3325*/              OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*3328*/              OPC_EmitMergeInputChains1_0,
/*3329*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_PARAM_8_cm), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
                      // Src: (ld:i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi8>><<P:Predicate_load_param_exti8>> - Complexity = 13
                      // Dst: (VTX_READ_PARAM_8_cm:i32 ADDRVTX_READ:i32:$src_gpr)
/*3338*/            /*Scope*/ 19, /*->3358*/
/*3339*/              OPC_CheckPredicate, 30, // Predicate_az_extloadi16
/*3341*/              OPC_CheckPredicate, 46, // Predicate_load_param_exti16
/*3343*/              OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*3345*/              OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*3348*/              OPC_EmitMergeInputChains1_0,
/*3349*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_PARAM_16_cm), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
                      // Src: (ld:i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi16>><<P:Predicate_load_param_exti16>> - Complexity = 13
                      // Dst: (VTX_READ_PARAM_16_cm:i32 ADDRVTX_READ:i32:$src_gpr)
/*3358*/            0, /*End of Scope*/
/*3359*/          /*Scope*/ 19, /*->3379*/
/*3360*/            OPC_CheckPredicate, 34, // Predicate_load
/*3362*/            OPC_CheckPredicate, 47, // Predicate_load_param
/*3364*/            OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*3366*/            OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*3369*/            OPC_EmitMergeInputChains1_0,
/*3370*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_PARAM_32_cm), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
                    // Src: (ld:i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_load_param>> - Complexity = 13
                    // Dst: (VTX_READ_PARAM_32_cm:i32 ADDRVTX_READ:i32:$src_gpr)
/*3379*/          /*Scope*/ 44, /*->3424*/
/*3380*/            OPC_CheckPredicate, 24, // Predicate_az_extload
/*3382*/            OPC_Scope, 19, /*->3403*/ // 2 children in Scope
/*3384*/              OPC_CheckPredicate, 25, // Predicate_az_extloadi8
/*3386*/              OPC_CheckPredicate, 26, // Predicate_az_extloadi8_global
/*3388*/              OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*3390*/              OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*3393*/              OPC_EmitMergeInputChains1_0,
/*3394*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_GLOBAL_8_cm), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
                      // Src: (ld:i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi8>><<P:Predicate_az_extloadi8_global>> - Complexity = 13
                      // Dst: (VTX_READ_GLOBAL_8_cm:i32 ADDRVTX_READ:i32:$src_gpr)
/*3403*/            /*Scope*/ 19, /*->3423*/
/*3404*/              OPC_CheckPredicate, 30, // Predicate_az_extloadi16
/*3406*/              OPC_CheckPredicate, 31, // Predicate_az_extloadi16_global
/*3408*/              OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*3410*/              OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*3413*/              OPC_EmitMergeInputChains1_0,
/*3414*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_GLOBAL_16_cm), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
                      // Src: (ld:i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi16>><<P:Predicate_az_extloadi16_global>> - Complexity = 13
                      // Dst: (VTX_READ_GLOBAL_16_cm:i32 ADDRVTX_READ:i32:$src_gpr)
/*3423*/            0, /*End of Scope*/
/*3424*/          /*Scope*/ 19, /*->3444*/
/*3425*/            OPC_CheckPredicate, 34, // Predicate_load
/*3427*/            OPC_CheckPredicate, 35, // Predicate_global_load
/*3429*/            OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*3431*/            OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*3434*/            OPC_EmitMergeInputChains1_0,
/*3435*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_GLOBAL_32_cm), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 3, 
                    // Src: (ld:i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 13
                    // Dst: (VTX_READ_GLOBAL_32_cm:i32 ADDRVTX_READ:i32:$src_gpr)
/*3444*/          0, /*End of Scope*/
/*3445*/        0, /*End of Scope*/
/*3446*/      /*Scope*/ 13|128,1/*141*/, /*->3589*/
/*3448*/        OPC_CaptureGlueInput,
/*3449*/        OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*3450*/        OPC_CheckPredicate, 48, // Predicate_si_ld_local
/*3452*/        OPC_CheckType, MVT::i32,
/*3454*/        OPC_Scope, 26, /*->3482*/ // 5 children in Scope
/*3456*/          OPC_CheckPredicate, 49, // Predicate_si_sextload_local
/*3458*/          OPC_CheckPredicate, 50, // Predicate_si_sextload_local_i8
/*3460*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*3462*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #2 #3
/*3465*/          OPC_EmitMergeInputChains1_0,
/*3466*/          OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*3469*/          OPC_EmitInteger, MVT::i1, 0, 
/*3472*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_READ_I8), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 3/*#Ops*/, 2, 4, 5, 
                  // Src: (SIld_local:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset))<<P:Predicate_si_ld_local>><<P:Predicate_si_sextload_local>><<P:Predicate_si_sextload_local_i8>> - Complexity = 13
                  // Dst: (DS_READ_I8:i32 ?:i32:$ptr, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*3482*/        /*Scope*/ 26, /*->3509*/
/*3483*/          OPC_CheckPredicate, 51, // Predicate_si_az_extload_local
/*3485*/          OPC_CheckPredicate, 52, // Predicate_si_az_extload_local_i8
/*3487*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*3489*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #2 #3
/*3492*/          OPC_EmitMergeInputChains1_0,
/*3493*/          OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*3496*/          OPC_EmitInteger, MVT::i1, 0, 
/*3499*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_READ_U8), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 3/*#Ops*/, 2, 4, 5, 
                  // Src: (SIld_local:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset))<<P:Predicate_si_ld_local>><<P:Predicate_si_az_extload_local>><<P:Predicate_si_az_extload_local_i8>> - Complexity = 13
                  // Dst: (DS_READ_U8:i32 ?:i32:$ptr, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*3509*/        /*Scope*/ 26, /*->3536*/
/*3510*/          OPC_CheckPredicate, 49, // Predicate_si_sextload_local
/*3512*/          OPC_CheckPredicate, 53, // Predicate_si_sextload_local_i16
/*3514*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*3516*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #2 #3
/*3519*/          OPC_EmitMergeInputChains1_0,
/*3520*/          OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*3523*/          OPC_EmitInteger, MVT::i1, 0, 
/*3526*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_READ_I16), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 3/*#Ops*/, 2, 4, 5, 
                  // Src: (SIld_local:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset))<<P:Predicate_si_ld_local>><<P:Predicate_si_sextload_local>><<P:Predicate_si_sextload_local_i16>> - Complexity = 13
                  // Dst: (DS_READ_I16:i32 ?:i32:$ptr, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*3536*/        /*Scope*/ 26, /*->3563*/
/*3537*/          OPC_CheckPredicate, 51, // Predicate_si_az_extload_local
/*3539*/          OPC_CheckPredicate, 54, // Predicate_si_az_extload_local_i16
/*3541*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*3543*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #2 #3
/*3546*/          OPC_EmitMergeInputChains1_0,
/*3547*/          OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*3550*/          OPC_EmitInteger, MVT::i1, 0, 
/*3553*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_READ_U16), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 3/*#Ops*/, 2, 4, 5, 
                  // Src: (SIld_local:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset))<<P:Predicate_si_ld_local>><<P:Predicate_si_az_extload_local>><<P:Predicate_si_az_extload_local_i16>> - Complexity = 13
                  // Dst: (DS_READ_U16:i32 ?:i32:$ptr, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*3563*/        /*Scope*/ 24, /*->3588*/
/*3564*/          OPC_CheckPredicate, 55, // Predicate_si_load_local
/*3566*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*3568*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #2 #3
/*3571*/          OPC_EmitMergeInputChains1_0,
/*3572*/          OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*3575*/          OPC_EmitInteger, MVT::i1, 0, 
/*3578*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_READ_B32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 3/*#Ops*/, 2, 4, 5, 
                  // Src: (SIld_local:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset))<<P:Predicate_si_ld_local>><<P:Predicate_si_load_local>> - Complexity = 13
                  // Dst: (DS_READ_B32:i32 ?:i32:$ptr, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*3588*/        0, /*End of Scope*/
/*3589*/      /*Scope*/ 11|128,1/*139*/, /*->3730*/
/*3591*/        OPC_MoveChild, 1,
/*3593*/        OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*3596*/        OPC_RecordChild0, // #1 = $sbase
/*3597*/        OPC_RecordChild1, // #2 = $offset
/*3598*/        OPC_MoveChild, 1,
/*3600*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*3603*/        OPC_Scope, 29, /*->3634*/ // 3 children in Scope
/*3605*/          OPC_CheckPredicate, 56, // Predicate_IMM8bitDWORD
/*3607*/          OPC_MoveParent,
/*3608*/          OPC_CheckType, MVT::i64,
/*3610*/          OPC_MoveParent,
/*3611*/          OPC_CheckPredicate, 23, // Predicate_unindexedload
/*3613*/          OPC_CheckPredicate, 34, // Predicate_load
/*3615*/          OPC_CheckPredicate, 57, // Predicate_constant_load
/*3617*/          OPC_CheckType, MVT::i32,
/*3619*/          OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*3621*/          OPC_EmitMergeInputChains1_0,
/*3622*/          OPC_EmitNodeXForm, 3, 2, // as_dword_i32imm
/*3625*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORD_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 3, 
                  // Src: (ld:i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM8bitDWORD>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                  // Dst: (S_LOAD_DWORD_IMM:i32 ?:i64:$sbase, (as_dword_i32imm:i32 ?:i64:$offset))
/*3634*/        /*Scope*/ 29, /*->3664*/
/*3635*/          OPC_CheckPredicate, 58, // Predicate_IMM20bit
/*3637*/          OPC_MoveParent,
/*3638*/          OPC_CheckType, MVT::i64,
/*3640*/          OPC_MoveParent,
/*3641*/          OPC_CheckPredicate, 23, // Predicate_unindexedload
/*3643*/          OPC_CheckPredicate, 34, // Predicate_load
/*3645*/          OPC_CheckPredicate, 57, // Predicate_constant_load
/*3647*/          OPC_CheckType, MVT::i32,
/*3649*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*3651*/          OPC_EmitMergeInputChains1_0,
/*3652*/          OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*3655*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORD_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 3, 
                  // Src: (ld:i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM20bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                  // Dst: (S_LOAD_DWORD_IMM:i32 ?:i64:$sbase, (as_i32imm:i32 ?:i64:$offset))
/*3664*/        /*Scope*/ 64, /*->3729*/
/*3665*/          OPC_CheckPredicate, 59, // Predicate_IMM32bit
/*3667*/          OPC_MoveParent,
/*3668*/          OPC_CheckType, MVT::i64,
/*3670*/          OPC_MoveParent,
/*3671*/          OPC_CheckPredicate, 23, // Predicate_unindexedload
/*3673*/          OPC_CheckPredicate, 34, // Predicate_load
/*3675*/          OPC_CheckPredicate, 57, // Predicate_constant_load
/*3677*/          OPC_CheckType, MVT::i32,
/*3679*/          OPC_Scope, 23, /*->3704*/ // 2 children in Scope
/*3681*/            OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*3683*/            OPC_EmitMergeInputChains1_0,
/*3684*/            OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*3687*/            OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                        1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*3695*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORD_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 4, 
                    // Src: (ld:i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORD_SGPR:i32 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*3704*/          /*Scope*/ 23, /*->3728*/
/*3705*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*3707*/            OPC_EmitMergeInputChains1_0,
/*3708*/            OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*3711*/            OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                        1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*3719*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORD_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 4, 
                    // Src: (ld:i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORD_SGPR:i32 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*3728*/          0, /*End of Scope*/
/*3729*/        0, /*End of Scope*/
/*3730*/      /*Scope*/ 29|128,5/*669*/, /*->4401*/
/*3732*/        OPC_RecordChild1, // #1 = $sbase
/*3733*/        OPC_Scope, 37|128,3/*421*/, /*->4157*/ // 2 children in Scope
/*3736*/          OPC_CheckChild1Type, MVT::i64,
/*3738*/          OPC_CheckPredicate, 23, // Predicate_unindexedload
/*3740*/          OPC_Scope, 40, /*->3782*/ // 11 children in Scope
/*3742*/            OPC_CheckPredicate, 34, // Predicate_load
/*3744*/            OPC_CheckPredicate, 57, // Predicate_constant_load
/*3746*/            OPC_CheckType, MVT::i32,
/*3748*/            OPC_Scope, 15, /*->3765*/ // 2 children in Scope
/*3750*/              OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*3752*/              OPC_EmitMergeInputChains1_0,
/*3753*/              OPC_EmitInteger, MVT::i32, 0, 
/*3756*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORD_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (ld:i32 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                      // Dst: (S_LOAD_DWORD_IMM:i32 ?:i64:$sbase, 0:i32)
/*3765*/            /*Scope*/ 15, /*->3781*/
/*3766*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*3768*/              OPC_EmitMergeInputChains1_0,
/*3769*/              OPC_EmitInteger, MVT::i32, 0, 
/*3772*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORD_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 2, 
                      // Src: (ld:i32 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                      // Dst: (S_LOAD_DWORD_IMM:i32 ?:i64:$sbase, 0:i32)
/*3781*/            0, /*End of Scope*/
/*3782*/          /*Scope*/ 31, /*->3814*/
/*3783*/            OPC_CheckPredicate, 27, // Predicate_sextload
/*3785*/            OPC_CheckPredicate, 28, // Predicate_sextloadi8
/*3787*/            OPC_CheckPredicate, 60, // Predicate_sextloadi8_flat
/*3789*/            OPC_CheckType, MVT::i32,
/*3791*/            OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*3793*/            OPC_EmitMergeInputChains1_0,
/*3794*/            OPC_EmitInteger, MVT::i1, 0, 
/*3797*/            OPC_EmitInteger, MVT::i1, 0, 
/*3800*/            OPC_EmitInteger, MVT::i1, 0, 
/*3803*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_SBYTE), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                    // Src: (ld:i32 i64:i64:$ptr)<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>><<P:Predicate_sextloadi8_flat>> - Complexity = 4
                    // Dst: (FLAT_LOAD_SBYTE:i32 ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*3814*/          /*Scope*/ 31, /*->3846*/
/*3815*/            OPC_CheckPredicate, 24, // Predicate_az_extload
/*3817*/            OPC_CheckPredicate, 25, // Predicate_az_extloadi8
/*3819*/            OPC_CheckPredicate, 61, // Predicate_az_extloadi8_flat
/*3821*/            OPC_CheckType, MVT::i32,
/*3823*/            OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*3825*/            OPC_EmitMergeInputChains1_0,
/*3826*/            OPC_EmitInteger, MVT::i1, 0, 
/*3829*/            OPC_EmitInteger, MVT::i1, 0, 
/*3832*/            OPC_EmitInteger, MVT::i1, 0, 
/*3835*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_UBYTE), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                    // Src: (ld:i32 i64:i64:$ptr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi8>><<P:Predicate_az_extloadi8_flat>> - Complexity = 4
                    // Dst: (FLAT_LOAD_UBYTE:i32 ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*3846*/          /*Scope*/ 31, /*->3878*/
/*3847*/            OPC_CheckPredicate, 27, // Predicate_sextload
/*3849*/            OPC_CheckPredicate, 32, // Predicate_sextloadi16
/*3851*/            OPC_CheckPredicate, 62, // Predicate_sextloadi16_flat
/*3853*/            OPC_CheckType, MVT::i32,
/*3855*/            OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*3857*/            OPC_EmitMergeInputChains1_0,
/*3858*/            OPC_EmitInteger, MVT::i1, 0, 
/*3861*/            OPC_EmitInteger, MVT::i1, 0, 
/*3864*/            OPC_EmitInteger, MVT::i1, 0, 
/*3867*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_SSHORT), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                    // Src: (ld:i32 i64:i64:$ptr)<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>><<P:Predicate_sextloadi16_flat>> - Complexity = 4
                    // Dst: (FLAT_LOAD_SSHORT:i32 ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*3878*/          /*Scope*/ 31, /*->3910*/
/*3879*/            OPC_CheckPredicate, 24, // Predicate_az_extload
/*3881*/            OPC_CheckPredicate, 30, // Predicate_az_extloadi16
/*3883*/            OPC_CheckPredicate, 63, // Predicate_az_extloadi16_flat
/*3885*/            OPC_CheckType, MVT::i32,
/*3887*/            OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*3889*/            OPC_EmitMergeInputChains1_0,
/*3890*/            OPC_EmitInteger, MVT::i1, 0, 
/*3893*/            OPC_EmitInteger, MVT::i1, 0, 
/*3896*/            OPC_EmitInteger, MVT::i1, 0, 
/*3899*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_USHORT), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                    // Src: (ld:i32 i64:i64:$ptr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi16>><<P:Predicate_az_extloadi16_flat>> - Complexity = 4
                    // Dst: (FLAT_LOAD_USHORT:i32 ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*3910*/          /*Scope*/ 56, /*->3967*/
/*3911*/            OPC_CheckPredicate, 34, // Predicate_load
/*3913*/            OPC_CheckPredicate, 64, // Predicate_flat_load
/*3915*/            OPC_SwitchType /*2 cases */, 23, MVT::i32,// ->3941
/*3918*/              OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*3920*/              OPC_EmitMergeInputChains1_0,
/*3921*/              OPC_EmitInteger, MVT::i1, 0, 
/*3924*/              OPC_EmitInteger, MVT::i1, 0, 
/*3927*/              OPC_EmitInteger, MVT::i1, 0, 
/*3930*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_DWORD), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                      // Src: (ld:i32 i64:i64:$ptr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_flat_load>> - Complexity = 4
                      // Dst: (FLAT_LOAD_DWORD:i32 ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*3941*/            /*SwitchType*/ 23, MVT::i64,// ->3966
/*3943*/              OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*3945*/              OPC_EmitMergeInputChains1_0,
/*3946*/              OPC_EmitInteger, MVT::i1, 0, 
/*3949*/              OPC_EmitInteger, MVT::i1, 0, 
/*3952*/              OPC_EmitInteger, MVT::i1, 0, 
/*3955*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_DWORDX2), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i64, 4/*#Ops*/, 1, 2, 3, 4, 
                      // Src: (ld:i64 i64:i64:$ptr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_flat_load>> - Complexity = 4
                      // Dst: (FLAT_LOAD_DWORDX2:i64 ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*3966*/            0, // EndSwitchType
/*3967*/          /*Scope*/ 62, /*->4030*/
/*3968*/            OPC_CheckPredicate, 24, // Predicate_az_extload
/*3970*/            OPC_SwitchType /*2 cases */, 27, MVT::i64,// ->4000
/*3973*/              OPC_CheckPredicate, 65, // Predicate_az_extloadi32
/*3975*/              OPC_CheckPredicate, 66, // Predicate_az_extloadi32_flat
/*3977*/              OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*3979*/              OPC_EmitMergeInputChains1_0,
/*3980*/              OPC_EmitInteger, MVT::i1, 0, 
/*3983*/              OPC_EmitInteger, MVT::i1, 0, 
/*3986*/              OPC_EmitInteger, MVT::i1, 0, 
/*3989*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_DWORDX2), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i64, 4/*#Ops*/, 1, 2, 3, 4, 
                      // Src: (ld:i64 i64:i64:$ptr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi32>><<P:Predicate_az_extloadi32_flat>> - Complexity = 4
                      // Dst: (FLAT_LOAD_DWORDX2:i64 ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*4000*/            /*SwitchType*/ 27, MVT::i32,// ->4029
/*4002*/              OPC_CheckPredicate, 25, // Predicate_az_extloadi8
/*4004*/              OPC_CheckPredicate, 26, // Predicate_az_extloadi8_global
/*4006*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*4008*/              OPC_EmitMergeInputChains1_0,
/*4009*/              OPC_EmitInteger, MVT::i1, 0, 
/*4012*/              OPC_EmitInteger, MVT::i1, 0, 
/*4015*/              OPC_EmitInteger, MVT::i1, 0, 
/*4018*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_UBYTE), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                      // Src: (ld:i32 i64:i64:$addr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi8>><<P:Predicate_az_extloadi8_global>> - Complexity = 4
                      // Dst: (FLAT_LOAD_UBYTE:i32 ?:i64:$addr, 0:i1, 0:i1, 0:i1)
/*4029*/            0, // EndSwitchType
/*4030*/          /*Scope*/ 31, /*->4062*/
/*4031*/            OPC_CheckPredicate, 27, // Predicate_sextload
/*4033*/            OPC_CheckPredicate, 28, // Predicate_sextloadi8
/*4035*/            OPC_CheckPredicate, 29, // Predicate_sextloadi8_global
/*4037*/            OPC_CheckType, MVT::i32,
/*4039*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*4041*/            OPC_EmitMergeInputChains1_0,
/*4042*/            OPC_EmitInteger, MVT::i1, 0, 
/*4045*/            OPC_EmitInteger, MVT::i1, 0, 
/*4048*/            OPC_EmitInteger, MVT::i1, 0, 
/*4051*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_SBYTE), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                    // Src: (ld:i32 i64:i64:$addr)<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>><<P:Predicate_sextloadi8_global>> - Complexity = 4
                    // Dst: (FLAT_LOAD_SBYTE:i32 ?:i64:$addr, 0:i1, 0:i1, 0:i1)
/*4062*/          /*Scope*/ 31, /*->4094*/
/*4063*/            OPC_CheckPredicate, 24, // Predicate_az_extload
/*4065*/            OPC_CheckPredicate, 30, // Predicate_az_extloadi16
/*4067*/            OPC_CheckPredicate, 31, // Predicate_az_extloadi16_global
/*4069*/            OPC_CheckType, MVT::i32,
/*4071*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*4073*/            OPC_EmitMergeInputChains1_0,
/*4074*/            OPC_EmitInteger, MVT::i1, 0, 
/*4077*/            OPC_EmitInteger, MVT::i1, 0, 
/*4080*/            OPC_EmitInteger, MVT::i1, 0, 
/*4083*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_USHORT), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                    // Src: (ld:i32 i64:i64:$addr)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi16>><<P:Predicate_az_extloadi16_global>> - Complexity = 4
                    // Dst: (FLAT_LOAD_USHORT:i32 ?:i64:$addr, 0:i1, 0:i1, 0:i1)
/*4094*/          /*Scope*/ 31, /*->4126*/
/*4095*/            OPC_CheckPredicate, 27, // Predicate_sextload
/*4097*/            OPC_CheckPredicate, 32, // Predicate_sextloadi16
/*4099*/            OPC_CheckPredicate, 33, // Predicate_sextloadi16_global
/*4101*/            OPC_CheckType, MVT::i32,
/*4103*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*4105*/            OPC_EmitMergeInputChains1_0,
/*4106*/            OPC_EmitInteger, MVT::i1, 0, 
/*4109*/            OPC_EmitInteger, MVT::i1, 0, 
/*4112*/            OPC_EmitInteger, MVT::i1, 0, 
/*4115*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_SSHORT), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                    // Src: (ld:i32 i64:i64:$addr)<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>><<P:Predicate_sextloadi16_global>> - Complexity = 4
                    // Dst: (FLAT_LOAD_SSHORT:i32 ?:i64:$addr, 0:i1, 0:i1, 0:i1)
/*4126*/          /*Scope*/ 29, /*->4156*/
/*4127*/            OPC_CheckPredicate, 34, // Predicate_load
/*4129*/            OPC_CheckPredicate, 35, // Predicate_global_load
/*4131*/            OPC_CheckType, MVT::i32,
/*4133*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*4135*/            OPC_EmitMergeInputChains1_0,
/*4136*/            OPC_EmitInteger, MVT::i1, 0, 
/*4139*/            OPC_EmitInteger, MVT::i1, 0, 
/*4142*/            OPC_EmitInteger, MVT::i1, 0, 
/*4145*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_DWORD), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                    // Src: (ld:i32 i64:i64:$addr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 4
                    // Dst: (FLAT_LOAD_DWORD:i32 ?:i64:$addr, 0:i1, 0:i1, 0:i1)
/*4156*/          0, /*End of Scope*/
/*4157*/        /*Scope*/ 113|128,1/*241*/, /*->4400*/
/*4159*/          OPC_CheckChild1Type, MVT::i32,
/*4161*/          OPC_CheckPredicate, 23, // Predicate_unindexedload
/*4163*/          OPC_CheckType, MVT::i32,
/*4165*/          OPC_Scope, 44, /*->4211*/ // 5 children in Scope
/*4167*/            OPC_CheckPredicate, 34, // Predicate_load
/*4169*/            OPC_CheckPredicate, 67, // Predicate_local_load
/*4171*/            OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*4173*/            OPC_EmitMergeInputChains1_0,
/*4174*/            OPC_EmitInteger, MVT::i32, 0, 
/*4177*/            OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*4189*/            OPC_EmitInteger, MVT::i32, 1, 
/*4192*/            OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*4195*/            OPC_EmitInteger, MVT::i32, 0, 
/*4198*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_READ_RET), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                    // Src: (ld:i32 R600_Reg32:i32:$src0)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_local_load>> - Complexity = 4
                    // Dst: (LDS_READ_RET:i32 R600_Reg32:i32:$src0)
/*4211*/          /*Scope*/ 46, /*->4258*/
/*4212*/            OPC_CheckPredicate, 27, // Predicate_sextload
/*4214*/            OPC_CheckPredicate, 28, // Predicate_sextloadi8
/*4216*/            OPC_CheckPredicate, 68, // Predicate_sextloadi8_local
/*4218*/            OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*4220*/            OPC_EmitMergeInputChains1_0,
/*4221*/            OPC_EmitInteger, MVT::i32, 0, 
/*4224*/            OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*4236*/            OPC_EmitInteger, MVT::i32, 1, 
/*4239*/            OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*4242*/            OPC_EmitInteger, MVT::i32, 0, 
/*4245*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_BYTE_READ_RET), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                    // Src: (ld:i32 i32:i32:$src0)<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>><<P:Predicate_sextloadi8_local>> - Complexity = 4
                    // Dst: (LDS_BYTE_READ_RET:i32 i32:i32:$src0)
/*4258*/          /*Scope*/ 46, /*->4305*/
/*4259*/            OPC_CheckPredicate, 24, // Predicate_az_extload
/*4261*/            OPC_CheckPredicate, 25, // Predicate_az_extloadi8
/*4263*/            OPC_CheckPredicate, 69, // Predicate_az_extloadi8_local
/*4265*/            OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*4267*/            OPC_EmitMergeInputChains1_0,
/*4268*/            OPC_EmitInteger, MVT::i32, 0, 
/*4271*/            OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*4283*/            OPC_EmitInteger, MVT::i32, 1, 
/*4286*/            OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*4289*/            OPC_EmitInteger, MVT::i32, 0, 
/*4292*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_UBYTE_READ_RET), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                    // Src: (ld:i32 i32:i32:$src0)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi8>><<P:Predicate_az_extloadi8_local>> - Complexity = 4
                    // Dst: (LDS_UBYTE_READ_RET:i32 i32:i32:$src0)
/*4305*/          /*Scope*/ 46, /*->4352*/
/*4306*/            OPC_CheckPredicate, 27, // Predicate_sextload
/*4308*/            OPC_CheckPredicate, 32, // Predicate_sextloadi16
/*4310*/            OPC_CheckPredicate, 70, // Predicate_sextloadi16_local
/*4312*/            OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*4314*/            OPC_EmitMergeInputChains1_0,
/*4315*/            OPC_EmitInteger, MVT::i32, 0, 
/*4318*/            OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*4330*/            OPC_EmitInteger, MVT::i32, 1, 
/*4333*/            OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*4336*/            OPC_EmitInteger, MVT::i32, 0, 
/*4339*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_SHORT_READ_RET), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                    // Src: (ld:i32 i32:i32:$src0)<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>><<P:Predicate_sextloadi16_local>> - Complexity = 4
                    // Dst: (LDS_SHORT_READ_RET:i32 i32:i32:$src0)
/*4352*/          /*Scope*/ 46, /*->4399*/
/*4353*/            OPC_CheckPredicate, 24, // Predicate_az_extload
/*4355*/            OPC_CheckPredicate, 30, // Predicate_az_extloadi16
/*4357*/            OPC_CheckPredicate, 71, // Predicate_az_extloadi16_local
/*4359*/            OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*4361*/            OPC_EmitMergeInputChains1_0,
/*4362*/            OPC_EmitInteger, MVT::i32, 0, 
/*4365*/            OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*4377*/            OPC_EmitInteger, MVT::i32, 1, 
/*4380*/            OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*4383*/            OPC_EmitInteger, MVT::i32, 0, 
/*4386*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_USHORT_READ_RET), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 6/*#Ops*/, 1, 2, 3, 4, 5, 6, 
                    // Src: (ld:i32 i32:i32:$src0)<<P:Predicate_unindexedload>><<P:Predicate_az_extload>><<P:Predicate_az_extloadi16>><<P:Predicate_az_extloadi16_local>> - Complexity = 4
                    // Dst: (LDS_USHORT_READ_RET:i32 i32:i32:$src0)
/*4399*/          0, /*End of Scope*/
/*4400*/        0, /*End of Scope*/
/*4401*/      /*Scope*/ 11|128,1/*139*/, /*->4542*/
/*4403*/        OPC_MoveChild, 1,
/*4405*/        OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*4408*/        OPC_RecordChild0, // #1 = $sbase
/*4409*/        OPC_RecordChild1, // #2 = $offset
/*4410*/        OPC_MoveChild, 1,
/*4412*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*4415*/        OPC_Scope, 29, /*->4446*/ // 3 children in Scope
/*4417*/          OPC_CheckPredicate, 56, // Predicate_IMM8bitDWORD
/*4419*/          OPC_MoveParent,
/*4420*/          OPC_CheckType, MVT::i64,
/*4422*/          OPC_MoveParent,
/*4423*/          OPC_CheckPredicate, 23, // Predicate_unindexedload
/*4425*/          OPC_CheckPredicate, 34, // Predicate_load
/*4427*/          OPC_CheckPredicate, 57, // Predicate_constant_load
/*4429*/          OPC_CheckType, MVT::f32,
/*4431*/          OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*4433*/          OPC_EmitMergeInputChains1_0,
/*4434*/          OPC_EmitNodeXForm, 3, 2, // as_dword_i32imm
/*4437*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORD_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 1, 3, 
                  // Src: (ld:f32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM8bitDWORD>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                  // Dst: (S_LOAD_DWORD_IMM:f32 ?:i64:$sbase, (as_dword_i32imm:i32 ?:i64:$offset))
/*4446*/        /*Scope*/ 29, /*->4476*/
/*4447*/          OPC_CheckPredicate, 58, // Predicate_IMM20bit
/*4449*/          OPC_MoveParent,
/*4450*/          OPC_CheckType, MVT::i64,
/*4452*/          OPC_MoveParent,
/*4453*/          OPC_CheckPredicate, 23, // Predicate_unindexedload
/*4455*/          OPC_CheckPredicate, 34, // Predicate_load
/*4457*/          OPC_CheckPredicate, 57, // Predicate_constant_load
/*4459*/          OPC_CheckType, MVT::f32,
/*4461*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*4463*/          OPC_EmitMergeInputChains1_0,
/*4464*/          OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*4467*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORD_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 1, 3, 
                  // Src: (ld:f32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM20bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                  // Dst: (S_LOAD_DWORD_IMM:f32 ?:i64:$sbase, (as_i32imm:i32 ?:i64:$offset))
/*4476*/        /*Scope*/ 64, /*->4541*/
/*4477*/          OPC_CheckPredicate, 59, // Predicate_IMM32bit
/*4479*/          OPC_MoveParent,
/*4480*/          OPC_CheckType, MVT::i64,
/*4482*/          OPC_MoveParent,
/*4483*/          OPC_CheckPredicate, 23, // Predicate_unindexedload
/*4485*/          OPC_CheckPredicate, 34, // Predicate_load
/*4487*/          OPC_CheckPredicate, 57, // Predicate_constant_load
/*4489*/          OPC_CheckType, MVT::f32,
/*4491*/          OPC_Scope, 23, /*->4516*/ // 2 children in Scope
/*4493*/            OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*4495*/            OPC_EmitMergeInputChains1_0,
/*4496*/            OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*4499*/            OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                        1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*4507*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORD_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 1, 4, 
                    // Src: (ld:f32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORD_SGPR:f32 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*4516*/          /*Scope*/ 23, /*->4540*/
/*4517*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*4519*/            OPC_EmitMergeInputChains1_0,
/*4520*/            OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*4523*/            OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                        1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*4531*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORD_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 1, 4, 
                    // Src: (ld:f32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORD_SGPR:f32 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*4540*/          0, /*End of Scope*/
/*4541*/        0, /*End of Scope*/
/*4542*/      /*Scope*/ 45, /*->4588*/
/*4543*/        OPC_RecordChild1, // #1 = $sbase
/*4544*/        OPC_CheckChild1Type, MVT::i64,
/*4546*/        OPC_CheckPredicate, 23, // Predicate_unindexedload
/*4548*/        OPC_CheckPredicate, 34, // Predicate_load
/*4550*/        OPC_CheckPredicate, 57, // Predicate_constant_load
/*4552*/        OPC_CheckType, MVT::f32,
/*4554*/        OPC_Scope, 15, /*->4571*/ // 2 children in Scope
/*4556*/          OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*4558*/          OPC_EmitMergeInputChains1_0,
/*4559*/          OPC_EmitInteger, MVT::i32, 0, 
/*4562*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORD_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 1, 2, 
                  // Src: (ld:f32 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                  // Dst: (S_LOAD_DWORD_IMM:f32 ?:i64:$sbase, 0:i32)
/*4571*/        /*Scope*/ 15, /*->4587*/
/*4572*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*4574*/          OPC_EmitMergeInputChains1_0,
/*4575*/          OPC_EmitInteger, MVT::i32, 0, 
/*4578*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORD_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 1, 2, 
                  // Src: (ld:f32 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                  // Dst: (S_LOAD_DWORD_IMM:f32 ?:i64:$sbase, 0:i32)
/*4587*/        0, /*End of Scope*/
/*4588*/      /*Scope*/ 32, /*->4621*/
/*4589*/        OPC_CaptureGlueInput,
/*4590*/        OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*4591*/        OPC_CheckPredicate, 48, // Predicate_si_ld_local
/*4593*/        OPC_CheckPredicate, 55, // Predicate_si_load_local
/*4595*/        OPC_CheckPredicate, 72, // Predicate_si_load_local_align8
/*4597*/        OPC_CheckType, MVT::v2i32,
/*4599*/        OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*4601*/        OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #2 #3
/*4604*/        OPC_EmitMergeInputChains1_0,
/*4605*/        OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*4608*/        OPC_EmitInteger, MVT::i1, 0, 
/*4611*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_READ_B64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                    1/*#VTs*/, MVT::v2i32, 3/*#Ops*/, 2, 4, 5, 
                // Src: (SIld_local:v2i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset))<<P:Predicate_si_ld_local>><<P:Predicate_si_load_local>><<P:Predicate_si_load_local_align8>> - Complexity = 113
                // Dst: (DS_READ_B64:v2i32 ?:i32:$ptr, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*4621*/      /*Scope*/ 37|128,1/*165*/, /*->4788*/
/*4623*/        OPC_RecordChild1, // #1 = $MUBUFAddr64:srsrc:vaddr:soffset:offset:glc:slc:tfe
/*4624*/        OPC_CheckPredicate, 23, // Predicate_unindexedload
/*4626*/        OPC_CheckPredicate, 34, // Predicate_load
/*4628*/        OPC_Scope, 90, /*->4720*/ // 2 children in Scope
/*4630*/          OPC_CheckPredicate, 35, // Predicate_global_load
/*4632*/          OPC_SwitchType /*2 cases */, 41, MVT::v2i32,// ->4676
/*4635*/            OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*4637*/            OPC_Scope, 18, /*->4657*/ // 2 children in Scope
/*4639*/              OPC_CheckComplexPat, /*CP*/1, /*#*/1, // SelectMUBUFAddr64:$ #2 #3 #4 #5 #6 #7 #8
/*4642*/              OPC_EmitMergeInputChains1_0,
/*4643*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX2_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v2i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                      // Src: (ld:v2i32 (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 28
                      // Dst: (BUFFER_LOAD_DWORDX2_ADDR64:v2i32 i64:i64:$vaddr, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*4657*/            /*Scope*/ 17, /*->4675*/
/*4658*/              OPC_CheckComplexPat, /*CP*/2, /*#*/1, // SelectMUBUFOffset:$ #2 #3 #4 #5 #6 #7
/*4661*/              OPC_EmitMergeInputChains1_0,
/*4662*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX2_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v2i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                      // Src: (ld:v2i32 (MUBUFOffset:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 25
                      // Dst: (BUFFER_LOAD_DWORDX2_OFFSET:v2i32 v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*4675*/            0, /*End of Scope*/
/*4676*/          /*SwitchType*/ 41, MVT::v4i32,// ->4719
/*4678*/            OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*4680*/            OPC_Scope, 18, /*->4700*/ // 2 children in Scope
/*4682*/              OPC_CheckComplexPat, /*CP*/1, /*#*/1, // SelectMUBUFAddr64:$ #2 #3 #4 #5 #6 #7 #8
/*4685*/              OPC_EmitMergeInputChains1_0,
/*4686*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX4_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v4i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                      // Src: (ld:v4i32 (MUBUFAddr64:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 28
                      // Dst: (BUFFER_LOAD_DWORDX4_ADDR64:v4i32 i64:i64:$vaddr, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*4700*/            /*Scope*/ 17, /*->4718*/
/*4701*/              OPC_CheckComplexPat, /*CP*/2, /*#*/1, // SelectMUBUFOffset:$ #2 #3 #4 #5 #6 #7
/*4704*/              OPC_EmitMergeInputChains1_0,
/*4705*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX4_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v4i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                      // Src: (ld:v4i32 (MUBUFOffset:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 25
                      // Dst: (BUFFER_LOAD_DWORDX4_OFFSET:v4i32 v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$glc, i1:i1:$slc, i1:i1:$tfe)
/*4718*/            0, /*End of Scope*/
/*4719*/          0, // EndSwitchType
/*4720*/        /*Scope*/ 66, /*->4787*/
/*4721*/          OPC_CheckPredicate, 44, // Predicate_load_private
/*4723*/          OPC_SwitchType /*2 cases */, 29, MVT::v2i32,// ->4755
/*4726*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*4728*/            OPC_CheckComplexPat, /*CP*/3, /*#*/1, // SelectMUBUFScratch:$ #2 #3 #4 #5
/*4731*/            OPC_EmitMergeInputChains1_0,
/*4732*/            OPC_EmitInteger, MVT::i1, 0, 
/*4735*/            OPC_EmitInteger, MVT::i1, 0, 
/*4738*/            OPC_EmitInteger, MVT::i1, 0, 
/*4741*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX2_OFFEN), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v2i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                    // Src: (ld:v2i32 (MUBUFScratch:iPTR v4i32:v4i32:$srsrc, i32:i32:$vaddr, i32:i32:$soffset, u16imm:i16:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_load_private>> - Complexity = 19
                    // Dst: (BUFFER_LOAD_DWORDX2_OFFEN:v2i32 ?:i32:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, 0:i1, 0:i1, 0:i1)
/*4755*/          /*SwitchType*/ 29, MVT::v4i32,// ->4786
/*4757*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*4759*/            OPC_CheckComplexPat, /*CP*/3, /*#*/1, // SelectMUBUFScratch:$ #2 #3 #4 #5
/*4762*/            OPC_EmitMergeInputChains1_0,
/*4763*/            OPC_EmitInteger, MVT::i1, 0, 
/*4766*/            OPC_EmitInteger, MVT::i1, 0, 
/*4769*/            OPC_EmitInteger, MVT::i1, 0, 
/*4772*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_LOAD_DWORDX4_OFFEN), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v4i32, 7/*#Ops*/, 3, 2, 4, 5, 6, 7, 8, 
                    // Src: (ld:v4i32 (MUBUFScratch:iPTR v4i32:v4i32:$srsrc, i32:i32:$vaddr, i32:i32:$soffset, u16imm:i16:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_load_private>> - Complexity = 19
                    // Dst: (BUFFER_LOAD_DWORDX4_OFFEN:v4i32 ?:i32:$vaddr, ?:v4i32:$srsrc, ?:i32:$soffset, ?:i16:$offset, 0:i1, 0:i1, 0:i1)
/*4786*/          0, // EndSwitchType
/*4787*/        0, /*End of Scope*/
/*4788*/      /*Scope*/ 28, /*->4817*/
/*4789*/        OPC_CaptureGlueInput,
/*4790*/        OPC_RecordChild1, // #1 = $DS64Bit4ByteAligned:ptr:offset0:offset1
/*4791*/        OPC_CheckPredicate, 48, // Predicate_si_ld_local
/*4793*/        OPC_CheckPredicate, 55, // Predicate_si_load_local
/*4795*/        OPC_CheckType, MVT::v2i32,
/*4797*/        OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*4799*/        OPC_CheckComplexPat, /*CP*/4, /*#*/1, // SelectDS64Bit4ByteAligned:$ #2 #3 #4
/*4802*/        OPC_EmitMergeInputChains1_0,
/*4803*/        OPC_EmitInteger, MVT::i1, 0, 
/*4806*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_READ2_B32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                    1/*#VTs*/, MVT::v2i32, 4/*#Ops*/, 2, 3, 4, 5, 
                // Src: (SIld_local:v2i32 (DS64Bit4ByteAligned:iPTR i32:i32:$ptr, i8:i8:$offset0, i8:i8:$offset1))<<P:Predicate_si_ld_local>><<P:Predicate_si_load_local>> - Complexity = 16
                // Dst: (DS_READ2_B32:v2i32 ?:i32:$ptr, ?:i8:$offset0, ?:i8:$offset1, 0:i1)
/*4817*/      /*Scope*/ 37|128,1/*165*/, /*->4984*/
/*4819*/        OPC_RecordChild1, // #1 = $src_gpr
/*4820*/        OPC_CheckChild1Type, MVT::i32,
/*4822*/        OPC_CheckPredicate, 23, // Predicate_unindexedload
/*4824*/        OPC_CheckPredicate, 34, // Predicate_load
/*4826*/        OPC_Scope, 38, /*->4866*/ // 4 children in Scope
/*4828*/          OPC_CheckPredicate, 47, // Predicate_load_param
/*4830*/          OPC_SwitchType /*2 cases */, 15, MVT::v2i32,// ->4848
/*4833*/            OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*4835*/            OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*4838*/            OPC_EmitMergeInputChains1_0,
/*4839*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_PARAM_64_eg), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v2i32, 2/*#Ops*/, 2, 3, 
                    // Src: (ld:v2i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_load_param>> - Complexity = 13
                    // Dst: (VTX_READ_PARAM_64_eg:v2i32 ADDRVTX_READ:i32:$src_gpr)
/*4848*/          /*SwitchType*/ 15, MVT::v4i32,// ->4865
/*4850*/            OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*4852*/            OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*4855*/            OPC_EmitMergeInputChains1_0,
/*4856*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_PARAM_128_eg), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v4i32, 2/*#Ops*/, 2, 3, 
                    // Src: (ld:v4i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_load_param>> - Complexity = 13
                    // Dst: (VTX_READ_PARAM_128_eg:v4i32 ADDRVTX_READ:i32:$src_gpr)
/*4865*/          0, // EndSwitchType
/*4866*/        /*Scope*/ 38, /*->4905*/
/*4867*/          OPC_CheckPredicate, 35, // Predicate_global_load
/*4869*/          OPC_SwitchType /*2 cases */, 15, MVT::v2i32,// ->4887
/*4872*/            OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*4874*/            OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*4877*/            OPC_EmitMergeInputChains1_0,
/*4878*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_GLOBAL_64_eg), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v2i32, 2/*#Ops*/, 2, 3, 
                    // Src: (ld:v2i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 13
                    // Dst: (VTX_READ_GLOBAL_64_eg:v2i32 ADDRVTX_READ:i32:$src_gpr)
/*4887*/          /*SwitchType*/ 15, MVT::v4i32,// ->4904
/*4889*/            OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*4891*/            OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*4894*/            OPC_EmitMergeInputChains1_0,
/*4895*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_GLOBAL_128_eg), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v4i32, 2/*#Ops*/, 2, 3, 
                    // Src: (ld:v4i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 13
                    // Dst: (VTX_READ_GLOBAL_128_eg:v4i32 ADDRVTX_READ:i32:$src_gpr)
/*4904*/          0, // EndSwitchType
/*4905*/        /*Scope*/ 38, /*->4944*/
/*4906*/          OPC_CheckPredicate, 47, // Predicate_load_param
/*4908*/          OPC_SwitchType /*2 cases */, 15, MVT::v2i32,// ->4926
/*4911*/            OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*4913*/            OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*4916*/            OPC_EmitMergeInputChains1_0,
/*4917*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_PARAM_64_cm), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v2i32, 2/*#Ops*/, 2, 3, 
                    // Src: (ld:v2i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_load_param>> - Complexity = 13
                    // Dst: (VTX_READ_PARAM_64_cm:v2i32 ADDRVTX_READ:i32:$src_gpr)
/*4926*/          /*SwitchType*/ 15, MVT::v4i32,// ->4943
/*4928*/            OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*4930*/            OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*4933*/            OPC_EmitMergeInputChains1_0,
/*4934*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_PARAM_128_cm), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v4i32, 2/*#Ops*/, 2, 3, 
                    // Src: (ld:v4i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_load_param>> - Complexity = 13
                    // Dst: (VTX_READ_PARAM_128_cm:v4i32 ADDRVTX_READ:i32:$src_gpr)
/*4943*/          0, // EndSwitchType
/*4944*/        /*Scope*/ 38, /*->4983*/
/*4945*/          OPC_CheckPredicate, 35, // Predicate_global_load
/*4947*/          OPC_SwitchType /*2 cases */, 15, MVT::v2i32,// ->4965
/*4950*/            OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*4952*/            OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*4955*/            OPC_EmitMergeInputChains1_0,
/*4956*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_GLOBAL_64_cm), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v2i32, 2/*#Ops*/, 2, 3, 
                    // Src: (ld:v2i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 13
                    // Dst: (VTX_READ_GLOBAL_64_cm:v2i32 ADDRVTX_READ:i32:$src_gpr)
/*4965*/          /*SwitchType*/ 15, MVT::v4i32,// ->4982
/*4967*/            OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*4969*/            OPC_CheckComplexPat, /*CP*/5, /*#*/1, // SelectADDRVTX_READ:$src_gpr #2 #3
/*4972*/            OPC_EmitMergeInputChains1_0,
/*4973*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::VTX_READ_GLOBAL_128_cm), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v4i32, 2/*#Ops*/, 2, 3, 
                    // Src: (ld:v4i32 ADDRVTX_READ:i32:$src_gpr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 13
                    // Dst: (VTX_READ_GLOBAL_128_cm:v4i32 ADDRVTX_READ:i32:$src_gpr)
/*4982*/          0, // EndSwitchType
/*4983*/        0, /*End of Scope*/
/*4984*/      /*Scope*/ 106|128,3/*490*/, /*->5476*/
/*4986*/        OPC_MoveChild, 1,
/*4988*/        OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*4991*/        OPC_RecordChild0, // #1 = $sbase
/*4992*/        OPC_RecordChild1, // #2 = $offset
/*4993*/        OPC_MoveChild, 1,
/*4995*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*4998*/        OPC_Scope, 99, /*->5099*/ // 3 children in Scope
/*5000*/          OPC_CheckPredicate, 56, // Predicate_IMM8bitDWORD
/*5002*/          OPC_MoveParent,
/*5003*/          OPC_CheckType, MVT::i64,
/*5005*/          OPC_MoveParent,
/*5006*/          OPC_CheckPredicate, 23, // Predicate_unindexedload
/*5008*/          OPC_CheckPredicate, 34, // Predicate_load
/*5010*/          OPC_CheckPredicate, 57, // Predicate_constant_load
/*5012*/          OPC_SwitchType /*5 cases */, 15, MVT::v2i32,// ->5030
/*5015*/            OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5017*/            OPC_EmitMergeInputChains1_0,
/*5018*/            OPC_EmitNodeXForm, 3, 2, // as_dword_i32imm
/*5021*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX2_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v2i32, 2/*#Ops*/, 1, 3, 
                    // Src: (ld:v2i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM8bitDWORD>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORDX2_IMM:v2i32 ?:i64:$sbase, (as_dword_i32imm:i32 ?:i64:$offset))
/*5030*/          /*SwitchType*/ 15, MVT::v4i32,// ->5047
/*5032*/            OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5034*/            OPC_EmitMergeInputChains1_0,
/*5035*/            OPC_EmitNodeXForm, 3, 2, // as_dword_i32imm
/*5038*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX4_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v4i32, 2/*#Ops*/, 1, 3, 
                    // Src: (ld:v4i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM8bitDWORD>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORDX4_IMM:v4i32 ?:i64:$sbase, (as_dword_i32imm:i32 ?:i64:$offset))
/*5047*/          /*SwitchType*/ 15, MVT::v32i8,// ->5064
/*5049*/            OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5051*/            OPC_EmitMergeInputChains1_0,
/*5052*/            OPC_EmitNodeXForm, 3, 2, // as_dword_i32imm
/*5055*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX8_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v32i8, 2/*#Ops*/, 1, 3, 
                    // Src: (ld:v32i8 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM8bitDWORD>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORDX8_IMM:v32i8 ?:i64:$sbase, (as_dword_i32imm:i32 ?:i64:$offset))
/*5064*/          /*SwitchType*/ 15, MVT::v8i32,// ->5081
/*5066*/            OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5068*/            OPC_EmitMergeInputChains1_0,
/*5069*/            OPC_EmitNodeXForm, 3, 2, // as_dword_i32imm
/*5072*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX8_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v8i32, 2/*#Ops*/, 1, 3, 
                    // Src: (ld:v8i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM8bitDWORD>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORDX8_IMM:v8i32 ?:i64:$sbase, (as_dword_i32imm:i32 ?:i64:$offset))
/*5081*/          /*SwitchType*/ 15, MVT::v16i32,// ->5098
/*5083*/            OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5085*/            OPC_EmitMergeInputChains1_0,
/*5086*/            OPC_EmitNodeXForm, 3, 2, // as_dword_i32imm
/*5089*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX16_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v16i32, 2/*#Ops*/, 1, 3, 
                    // Src: (ld:v16i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM8bitDWORD>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORDX16_IMM:v16i32 ?:i64:$sbase, (as_dword_i32imm:i32 ?:i64:$offset))
/*5098*/          0, // EndSwitchType
/*5099*/        /*Scope*/ 99, /*->5199*/
/*5100*/          OPC_CheckPredicate, 58, // Predicate_IMM20bit
/*5102*/          OPC_MoveParent,
/*5103*/          OPC_CheckType, MVT::i64,
/*5105*/          OPC_MoveParent,
/*5106*/          OPC_CheckPredicate, 23, // Predicate_unindexedload
/*5108*/          OPC_CheckPredicate, 34, // Predicate_load
/*5110*/          OPC_CheckPredicate, 57, // Predicate_constant_load
/*5112*/          OPC_SwitchType /*5 cases */, 15, MVT::v2i32,// ->5130
/*5115*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5117*/            OPC_EmitMergeInputChains1_0,
/*5118*/            OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5121*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX2_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v2i32, 2/*#Ops*/, 1, 3, 
                    // Src: (ld:v2i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM20bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORDX2_IMM:v2i32 ?:i64:$sbase, (as_i32imm:i32 ?:i64:$offset))
/*5130*/          /*SwitchType*/ 15, MVT::v4i32,// ->5147
/*5132*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5134*/            OPC_EmitMergeInputChains1_0,
/*5135*/            OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5138*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX4_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v4i32, 2/*#Ops*/, 1, 3, 
                    // Src: (ld:v4i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM20bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORDX4_IMM:v4i32 ?:i64:$sbase, (as_i32imm:i32 ?:i64:$offset))
/*5147*/          /*SwitchType*/ 15, MVT::v32i8,// ->5164
/*5149*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5151*/            OPC_EmitMergeInputChains1_0,
/*5152*/            OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5155*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX8_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v32i8, 2/*#Ops*/, 1, 3, 
                    // Src: (ld:v32i8 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM20bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORDX8_IMM:v32i8 ?:i64:$sbase, (as_i32imm:i32 ?:i64:$offset))
/*5164*/          /*SwitchType*/ 15, MVT::v8i32,// ->5181
/*5166*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5168*/            OPC_EmitMergeInputChains1_0,
/*5169*/            OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5172*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX8_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v8i32, 2/*#Ops*/, 1, 3, 
                    // Src: (ld:v8i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM20bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORDX8_IMM:v8i32 ?:i64:$sbase, (as_i32imm:i32 ?:i64:$offset))
/*5181*/          /*SwitchType*/ 15, MVT::v16i32,// ->5198
/*5183*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5185*/            OPC_EmitMergeInputChains1_0,
/*5186*/            OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5189*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX16_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v16i32, 2/*#Ops*/, 1, 3, 
                    // Src: (ld:v16i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM20bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                    // Dst: (S_LOAD_DWORDX16_IMM:v16i32 ?:i64:$sbase, (as_i32imm:i32 ?:i64:$offset))
/*5198*/          0, // EndSwitchType
/*5199*/        /*Scope*/ 18|128,2/*274*/, /*->5475*/
/*5201*/          OPC_CheckPredicate, 59, // Predicate_IMM32bit
/*5203*/          OPC_MoveParent,
/*5204*/          OPC_CheckType, MVT::i64,
/*5206*/          OPC_MoveParent,
/*5207*/          OPC_CheckPredicate, 23, // Predicate_unindexedload
/*5209*/          OPC_CheckPredicate, 34, // Predicate_load
/*5211*/          OPC_CheckPredicate, 57, // Predicate_constant_load
/*5213*/          OPC_SwitchType /*5 cases */, 50, MVT::v2i32,// ->5266
/*5216*/            OPC_Scope, 23, /*->5241*/ // 2 children in Scope
/*5218*/              OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5220*/              OPC_EmitMergeInputChains1_0,
/*5221*/              OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5224*/              OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                          1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*5232*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX2_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v2i32, 2/*#Ops*/, 1, 4, 
                      // Src: (ld:v2i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                      // Dst: (S_LOAD_DWORDX2_SGPR:v2i32 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*5241*/            /*Scope*/ 23, /*->5265*/
/*5242*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5244*/              OPC_EmitMergeInputChains1_0,
/*5245*/              OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5248*/              OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                          1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*5256*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX2_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v2i32, 2/*#Ops*/, 1, 4, 
                      // Src: (ld:v2i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                      // Dst: (S_LOAD_DWORDX2_SGPR:v2i32 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*5265*/            0, /*End of Scope*/
/*5266*/          /*SwitchType*/ 50, MVT::v4i32,// ->5318
/*5268*/            OPC_Scope, 23, /*->5293*/ // 2 children in Scope
/*5270*/              OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5272*/              OPC_EmitMergeInputChains1_0,
/*5273*/              OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5276*/              OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                          1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*5284*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX4_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v4i32, 2/*#Ops*/, 1, 4, 
                      // Src: (ld:v4i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                      // Dst: (S_LOAD_DWORDX4_SGPR:v4i32 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*5293*/            /*Scope*/ 23, /*->5317*/
/*5294*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5296*/              OPC_EmitMergeInputChains1_0,
/*5297*/              OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5300*/              OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                          1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*5308*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX4_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v4i32, 2/*#Ops*/, 1, 4, 
                      // Src: (ld:v4i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                      // Dst: (S_LOAD_DWORDX4_SGPR:v4i32 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*5317*/            0, /*End of Scope*/
/*5318*/          /*SwitchType*/ 50, MVT::v32i8,// ->5370
/*5320*/            OPC_Scope, 23, /*->5345*/ // 2 children in Scope
/*5322*/              OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5324*/              OPC_EmitMergeInputChains1_0,
/*5325*/              OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5328*/              OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                          1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*5336*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX8_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v32i8, 2/*#Ops*/, 1, 4, 
                      // Src: (ld:v32i8 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                      // Dst: (S_LOAD_DWORDX8_SGPR:v32i8 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*5345*/            /*Scope*/ 23, /*->5369*/
/*5346*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5348*/              OPC_EmitMergeInputChains1_0,
/*5349*/              OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5352*/              OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                          1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*5360*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX8_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v32i8, 2/*#Ops*/, 1, 4, 
                      // Src: (ld:v32i8 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                      // Dst: (S_LOAD_DWORDX8_SGPR:v32i8 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*5369*/            0, /*End of Scope*/
/*5370*/          /*SwitchType*/ 50, MVT::v8i32,// ->5422
/*5372*/            OPC_Scope, 23, /*->5397*/ // 2 children in Scope
/*5374*/              OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5376*/              OPC_EmitMergeInputChains1_0,
/*5377*/              OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5380*/              OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                          1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*5388*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX8_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v8i32, 2/*#Ops*/, 1, 4, 
                      // Src: (ld:v8i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                      // Dst: (S_LOAD_DWORDX8_SGPR:v8i32 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*5397*/            /*Scope*/ 23, /*->5421*/
/*5398*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5400*/              OPC_EmitMergeInputChains1_0,
/*5401*/              OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5404*/              OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                          1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*5412*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX8_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v8i32, 2/*#Ops*/, 1, 4, 
                      // Src: (ld:v8i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                      // Dst: (S_LOAD_DWORDX8_SGPR:v8i32 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*5421*/            0, /*End of Scope*/
/*5422*/          /*SwitchType*/ 50, MVT::v16i32,// ->5474
/*5424*/            OPC_Scope, 23, /*->5449*/ // 2 children in Scope
/*5426*/              OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5428*/              OPC_EmitMergeInputChains1_0,
/*5429*/              OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5432*/              OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                          1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*5440*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX16_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v16i32, 2/*#Ops*/, 1, 4, 
                      // Src: (ld:v16i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                      // Dst: (S_LOAD_DWORDX16_SGPR:v16i32 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*5449*/            /*Scope*/ 23, /*->5473*/
/*5450*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5452*/              OPC_EmitMergeInputChains1_0,
/*5453*/              OPC_EmitNodeXForm, 4, 2, // as_i32imm
/*5456*/              OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                          1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*5464*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX16_SGPR), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v16i32, 2/*#Ops*/, 1, 4, 
                      // Src: (ld:v16i32 (add:i64 i64:i64:$sbase, (imm:i64)<<P:Predicate_IMM32bit>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 11
                      // Dst: (S_LOAD_DWORDX16_SGPR:v16i32 ?:i64:$sbase, (S_MOV_B32:i32 (as_i32imm:i32 ?:i64:$offset)))
/*5473*/            0, /*End of Scope*/
/*5474*/          0, // EndSwitchType
/*5475*/        0, /*End of Scope*/
/*5476*/      /*Scope*/ 49|128,2/*305*/, /*->5783*/
/*5478*/        OPC_RecordChild1, // #1 = $sbase
/*5479*/        OPC_CheckChild1Type, MVT::i64,
/*5481*/        OPC_CheckPredicate, 23, // Predicate_unindexedload
/*5483*/        OPC_CheckPredicate, 34, // Predicate_load
/*5485*/        OPC_Scope, 56|128,1/*184*/, /*->5672*/ // 3 children in Scope
/*5488*/          OPC_CheckPredicate, 57, // Predicate_constant_load
/*5490*/          OPC_SwitchType /*5 cases */, 34, MVT::v2i32,// ->5527
/*5493*/            OPC_Scope, 15, /*->5510*/ // 2 children in Scope
/*5495*/              OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5497*/              OPC_EmitMergeInputChains1_0,
/*5498*/              OPC_EmitInteger, MVT::i32, 0, 
/*5501*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX2_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v2i32, 2/*#Ops*/, 1, 2, 
                      // Src: (ld:v2i32 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                      // Dst: (S_LOAD_DWORDX2_IMM:v2i32 ?:i64:$sbase, 0:i32)
/*5510*/            /*Scope*/ 15, /*->5526*/
/*5511*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5513*/              OPC_EmitMergeInputChains1_0,
/*5514*/              OPC_EmitInteger, MVT::i32, 0, 
/*5517*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX2_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v2i32, 2/*#Ops*/, 1, 2, 
                      // Src: (ld:v2i32 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                      // Dst: (S_LOAD_DWORDX2_IMM:v2i32 ?:i64:$sbase, 0:i32)
/*5526*/            0, /*End of Scope*/
/*5527*/          /*SwitchType*/ 34, MVT::v4i32,// ->5563
/*5529*/            OPC_Scope, 15, /*->5546*/ // 2 children in Scope
/*5531*/              OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5533*/              OPC_EmitMergeInputChains1_0,
/*5534*/              OPC_EmitInteger, MVT::i32, 0, 
/*5537*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX4_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v4i32, 2/*#Ops*/, 1, 2, 
                      // Src: (ld:v4i32 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                      // Dst: (S_LOAD_DWORDX4_IMM:v4i32 ?:i64:$sbase, 0:i32)
/*5546*/            /*Scope*/ 15, /*->5562*/
/*5547*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5549*/              OPC_EmitMergeInputChains1_0,
/*5550*/              OPC_EmitInteger, MVT::i32, 0, 
/*5553*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX4_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v4i32, 2/*#Ops*/, 1, 2, 
                      // Src: (ld:v4i32 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                      // Dst: (S_LOAD_DWORDX4_IMM:v4i32 ?:i64:$sbase, 0:i32)
/*5562*/            0, /*End of Scope*/
/*5563*/          /*SwitchType*/ 34, MVT::v32i8,// ->5599
/*5565*/            OPC_Scope, 15, /*->5582*/ // 2 children in Scope
/*5567*/              OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5569*/              OPC_EmitMergeInputChains1_0,
/*5570*/              OPC_EmitInteger, MVT::i32, 0, 
/*5573*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX8_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v32i8, 2/*#Ops*/, 1, 2, 
                      // Src: (ld:v32i8 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                      // Dst: (S_LOAD_DWORDX8_IMM:v32i8 ?:i64:$sbase, 0:i32)
/*5582*/            /*Scope*/ 15, /*->5598*/
/*5583*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5585*/              OPC_EmitMergeInputChains1_0,
/*5586*/              OPC_EmitInteger, MVT::i32, 0, 
/*5589*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX8_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v32i8, 2/*#Ops*/, 1, 2, 
                      // Src: (ld:v32i8 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                      // Dst: (S_LOAD_DWORDX8_IMM:v32i8 ?:i64:$sbase, 0:i32)
/*5598*/            0, /*End of Scope*/
/*5599*/          /*SwitchType*/ 34, MVT::v8i32,// ->5635
/*5601*/            OPC_Scope, 15, /*->5618*/ // 2 children in Scope
/*5603*/              OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5605*/              OPC_EmitMergeInputChains1_0,
/*5606*/              OPC_EmitInteger, MVT::i32, 0, 
/*5609*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX8_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v8i32, 2/*#Ops*/, 1, 2, 
                      // Src: (ld:v8i32 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                      // Dst: (S_LOAD_DWORDX8_IMM:v8i32 ?:i64:$sbase, 0:i32)
/*5618*/            /*Scope*/ 15, /*->5634*/
/*5619*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5621*/              OPC_EmitMergeInputChains1_0,
/*5622*/              OPC_EmitInteger, MVT::i32, 0, 
/*5625*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX8_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v8i32, 2/*#Ops*/, 1, 2, 
                      // Src: (ld:v8i32 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                      // Dst: (S_LOAD_DWORDX8_IMM:v8i32 ?:i64:$sbase, 0:i32)
/*5634*/            0, /*End of Scope*/
/*5635*/          /*SwitchType*/ 34, MVT::v16i32,// ->5671
/*5637*/            OPC_Scope, 15, /*->5654*/ // 2 children in Scope
/*5639*/              OPC_CheckPatternPredicate, 7, // (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
/*5641*/              OPC_EmitMergeInputChains1_0,
/*5642*/              OPC_EmitInteger, MVT::i32, 0, 
/*5645*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX16_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v16i32, 2/*#Ops*/, 1, 2, 
                      // Src: (ld:v16i32 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                      // Dst: (S_LOAD_DWORDX16_IMM:v16i32 ?:i64:$sbase, 0:i32)
/*5654*/            /*Scope*/ 15, /*->5670*/
/*5655*/              OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5657*/              OPC_EmitMergeInputChains1_0,
/*5658*/              OPC_EmitInteger, MVT::i32, 0, 
/*5661*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LOAD_DWORDX16_IMM), 0|OPFL_Chain|OPFL_MemRefs,
                          1/*#VTs*/, MVT::v16i32, 2/*#Ops*/, 1, 2, 
                      // Src: (ld:v16i32 i64:i64:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_constant_load>> - Complexity = 4
                      // Dst: (S_LOAD_DWORDX16_IMM:v16i32 ?:i64:$sbase, 0:i32)
/*5670*/            0, /*End of Scope*/
/*5671*/          0, // EndSwitchType
/*5672*/        /*Scope*/ 54, /*->5727*/
/*5673*/          OPC_CheckPredicate, 64, // Predicate_flat_load
/*5675*/          OPC_SwitchType /*2 cases */, 23, MVT::v2i32,// ->5701
/*5678*/            OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*5680*/            OPC_EmitMergeInputChains1_0,
/*5681*/            OPC_EmitInteger, MVT::i1, 0, 
/*5684*/            OPC_EmitInteger, MVT::i1, 0, 
/*5687*/            OPC_EmitInteger, MVT::i1, 0, 
/*5690*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_DWORDX2), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v2i32, 4/*#Ops*/, 1, 2, 3, 4, 
                    // Src: (ld:v2i32 i64:i64:$ptr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_flat_load>> - Complexity = 4
                    // Dst: (FLAT_LOAD_DWORDX2:v2i32 ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*5701*/          /*SwitchType*/ 23, MVT::v4i32,// ->5726
/*5703*/            OPC_CheckPatternPredicate, 5, // (Subtarget->hasFlatAddressSpace())
/*5705*/            OPC_EmitMergeInputChains1_0,
/*5706*/            OPC_EmitInteger, MVT::i1, 0, 
/*5709*/            OPC_EmitInteger, MVT::i1, 0, 
/*5712*/            OPC_EmitInteger, MVT::i1, 0, 
/*5715*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_DWORDX4), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v4i32, 4/*#Ops*/, 1, 2, 3, 4, 
                    // Src: (ld:v4i32 i64:i64:$ptr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_flat_load>> - Complexity = 4
                    // Dst: (FLAT_LOAD_DWORDX4:v4i32 ?:i64:$ptr, 0:i1, 0:i1, 0:i1)
/*5726*/          0, // EndSwitchType
/*5727*/        /*Scope*/ 54, /*->5782*/
/*5728*/          OPC_CheckPredicate, 35, // Predicate_global_load
/*5730*/          OPC_SwitchType /*2 cases */, 23, MVT::v2i32,// ->5756
/*5733*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5735*/            OPC_EmitMergeInputChains1_0,
/*5736*/            OPC_EmitInteger, MVT::i1, 0, 
/*5739*/            OPC_EmitInteger, MVT::i1, 0, 
/*5742*/            OPC_EmitInteger, MVT::i1, 0, 
/*5745*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_DWORDX2), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v2i32, 4/*#Ops*/, 1, 2, 3, 4, 
                    // Src: (ld:v2i32 i64:i64:$addr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 4
                    // Dst: (FLAT_LOAD_DWORDX2:v2i32 ?:i64:$addr, 0:i1, 0:i1, 0:i1)
/*5756*/          /*SwitchType*/ 23, MVT::v4i32,// ->5781
/*5758*/            OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*5760*/            OPC_EmitMergeInputChains1_0,
/*5761*/            OPC_EmitInteger, MVT::i1, 0, 
/*5764*/            OPC_EmitInteger, MVT::i1, 0, 
/*5767*/            OPC_EmitInteger, MVT::i1, 0, 
/*5770*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_LOAD_DWORDX4), 0|OPFL_Chain|OPFL_MemRefs,
                        1/*#VTs*/, MVT::v4i32, 4/*#Ops*/, 1, 2, 3, 4, 
                    // Src: (ld:v4i32 i64:i64:$addr)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_global_load>> - Complexity = 4
                    // Dst: (FLAT_LOAD_DWORDX4:v4i32 ?:i64:$addr, 0:i1, 0:i1, 0:i1)
/*5781*/          0, // EndSwitchType
/*5782*/        0, /*End of Scope*/
/*5783*/      0, /*End of Scope*/
/*5784*/    /*SwitchOpcode*/ 117|128,9/*1269*/, TARGET_VAL(ISD::INTRINSIC_VOID),// ->7057
/*5788*/      OPC_RecordNode, // #0 = 'intrinsic_void' chained node
/*5789*/      OPC_Scope, 79, /*->5870*/ // 11 children in Scope
/*5791*/        OPC_CheckChild1Integer, 9|128,39/*5001*/, 
/*5794*/        OPC_RecordChild2, // #1 = $en
/*5795*/        OPC_MoveChild, 2,
/*5797*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*5800*/        OPC_MoveParent,
/*5801*/        OPC_RecordChild3, // #2 = $vm
/*5802*/        OPC_MoveChild, 3,
/*5804*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*5807*/        OPC_MoveParent,
/*5808*/        OPC_RecordChild4, // #3 = $done
/*5809*/        OPC_MoveChild, 4,
/*5811*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*5814*/        OPC_MoveParent,
/*5815*/        OPC_RecordChild5, // #4 = $tgt
/*5816*/        OPC_MoveChild, 5,
/*5818*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*5821*/        OPC_MoveParent,
/*5822*/        OPC_RecordChild6, // #5 = $compr
/*5823*/        OPC_MoveChild, 6,
/*5825*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*5828*/        OPC_MoveParent,
/*5829*/        OPC_RecordChild7, // #6 = $src0
/*5830*/        OPC_MoveChild, 8,
/*5832*/        OPC_RecordNode, // #7 = $src1
/*5833*/        OPC_MoveParent,
/*5834*/        OPC_MoveChild, 9,
/*5836*/        OPC_RecordNode, // #8 = $src2
/*5837*/        OPC_MoveParent,
/*5838*/        OPC_MoveChild, 10,
/*5840*/        OPC_RecordNode, // #9 = $src3
/*5841*/        OPC_MoveParent,
/*5842*/        OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*5844*/        OPC_EmitMergeInputChains1_0,
/*5845*/        OPC_EmitConvertToTarget, 1,
/*5847*/        OPC_EmitConvertToTarget, 4,
/*5849*/        OPC_EmitConvertToTarget, 5,
/*5851*/        OPC_EmitConvertToTarget, 3,
/*5853*/        OPC_EmitConvertToTarget, 2,
/*5855*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::EXP), 0|OPFL_Chain,
                    0/*#VTs*/, 9/*#Ops*/, 10, 11, 12, 13, 14, 6, 7, 8, 9, 
                // Src: (intrinsic_void 5001:iPTR, (imm:i32):$en, (imm:i32):$vm, (imm:i32):$done, (imm:i32):$tgt, (imm:i32):$compr, f32:f32:$src0, f32:f32:$src1, f32:f32:$src2, f32:f32:$src3) - Complexity = 23
                // Dst: (EXP (imm:i32):$en, (imm:i32):$tgt, (imm:i32):$compr, (imm:i32):$done, (imm:i32):$vm, ?:f32:$src0, ?:f32:$src1, ?:f32:$src2, ?:f32:$src3)
/*5870*/      /*Scope*/ 77|128,2/*333*/, /*->6205*/
/*5872*/        OPC_CheckChild1Integer, 122|128,38/*4986*/, 
/*5875*/        OPC_RecordChild2, // #1 = $src
/*5876*/        OPC_RecordChild3, // #2 = $arraybase
/*5877*/        OPC_MoveChild, 3,
/*5879*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*5882*/        OPC_MoveParent,
/*5883*/        OPC_Scope, 79, /*->5964*/ // 4 children in Scope
/*5885*/          OPC_CheckChild4Integer, 0, 
/*5887*/          OPC_RecordChild5, // #3 = $mask
/*5888*/          OPC_MoveChild, 5,
/*5890*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*5893*/          OPC_MoveParent,
/*5894*/          OPC_Scope, 33, /*->5929*/ // 2 children in Scope
/*5896*/            OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*5898*/            OPC_EmitMergeInputChains1_0,
/*5899*/            OPC_EmitInteger, MVT::i32, 0, 
/*5902*/            OPC_EmitConvertToTarget, 2,
/*5904*/            OPC_EmitInteger, MVT::i32, 127|128,31/*4095*/, 
/*5908*/            OPC_EmitConvertToTarget, 3,
/*5910*/            OPC_EmitInteger, MVT::i32, 32, 
/*5913*/            OPC_EmitInteger, MVT::i32, 0, 
/*5916*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_ExportBuf), 0|OPFL_Chain,
                        0/*#VTs*/, 7/*#Ops*/, 1, 4, 5, 6, 7, 8, 9, 
                    // Src: (intrinsic_void 4986:iPTR, R600_Reg128:v4f32:$src, (imm:i32):$arraybase, 0:i32, (imm:i32):$mask) - Complexity = 19
                    // Dst: (R600_ExportBuf R600_Reg128:v4f32:$src, 0:i32, (imm:i32):$arraybase, 4095:i32, (imm:i32):$mask, 32:i32, 0:i32)
/*5929*/          /*Scope*/ 33, /*->5963*/
/*5930*/            OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*5932*/            OPC_EmitMergeInputChains1_0,
/*5933*/            OPC_EmitInteger, MVT::i32, 0, 
/*5936*/            OPC_EmitConvertToTarget, 2,
/*5938*/            OPC_EmitInteger, MVT::i32, 127|128,31/*4095*/, 
/*5942*/            OPC_EmitConvertToTarget, 3,
/*5944*/            OPC_EmitInteger, MVT::i32, 64, 
/*5947*/            OPC_EmitInteger, MVT::i32, 0, 
/*5950*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::EG_ExportBuf), 0|OPFL_Chain,
                        0/*#VTs*/, 7/*#Ops*/, 1, 4, 5, 6, 7, 8, 9, 
                    // Src: (intrinsic_void 4986:iPTR, R600_Reg128:v4f32:$src, (imm:i32):$arraybase, 0:i32, (imm:i32):$mask) - Complexity = 19
                    // Dst: (EG_ExportBuf R600_Reg128:v4f32:$src, 0:i32, (imm:i32):$arraybase, 4095:i32, (imm:i32):$mask, 64:i32, 0:i32)
/*5963*/          0, /*End of Scope*/
/*5964*/        /*Scope*/ 79, /*->6044*/
/*5965*/          OPC_CheckChild4Integer, 1, 
/*5967*/          OPC_RecordChild5, // #3 = $mask
/*5968*/          OPC_MoveChild, 5,
/*5970*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*5973*/          OPC_MoveParent,
/*5974*/          OPC_Scope, 33, /*->6009*/ // 2 children in Scope
/*5976*/            OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*5978*/            OPC_EmitMergeInputChains1_0,
/*5979*/            OPC_EmitInteger, MVT::i32, 0, 
/*5982*/            OPC_EmitConvertToTarget, 2,
/*5984*/            OPC_EmitInteger, MVT::i32, 127|128,31/*4095*/, 
/*5988*/            OPC_EmitConvertToTarget, 3,
/*5990*/            OPC_EmitInteger, MVT::i32, 33, 
/*5993*/            OPC_EmitInteger, MVT::i32, 0, 
/*5996*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_ExportBuf), 0|OPFL_Chain,
                        0/*#VTs*/, 7/*#Ops*/, 1, 4, 5, 6, 7, 8, 9, 
                    // Src: (intrinsic_void 4986:iPTR, R600_Reg128:v4f32:$src, (imm:i32):$arraybase, 1:i32, (imm:i32):$mask) - Complexity = 19
                    // Dst: (R600_ExportBuf ?:v4f32:$src, 0:i32, (imm:i32):$arraybase, 4095:i32, (imm:i32):$mask, 33:i32, 0:i32)
/*6009*/          /*Scope*/ 33, /*->6043*/
/*6010*/            OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*6012*/            OPC_EmitMergeInputChains1_0,
/*6013*/            OPC_EmitInteger, MVT::i32, 0, 
/*6016*/            OPC_EmitConvertToTarget, 2,
/*6018*/            OPC_EmitInteger, MVT::i32, 127|128,31/*4095*/, 
/*6022*/            OPC_EmitConvertToTarget, 3,
/*6024*/            OPC_EmitInteger, MVT::i32, 65, 
/*6027*/            OPC_EmitInteger, MVT::i32, 0, 
/*6030*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::EG_ExportBuf), 0|OPFL_Chain,
                        0/*#VTs*/, 7/*#Ops*/, 1, 4, 5, 6, 7, 8, 9, 
                    // Src: (intrinsic_void 4986:iPTR, R600_Reg128:v4f32:$src, (imm:i32):$arraybase, 1:i32, (imm:i32):$mask) - Complexity = 19
                    // Dst: (EG_ExportBuf ?:v4f32:$src, 0:i32, (imm:i32):$arraybase, 4095:i32, (imm:i32):$mask, 65:i32, 0:i32)
/*6043*/          0, /*End of Scope*/
/*6044*/        /*Scope*/ 79, /*->6124*/
/*6045*/          OPC_CheckChild4Integer, 2, 
/*6047*/          OPC_RecordChild5, // #3 = $mask
/*6048*/          OPC_MoveChild, 5,
/*6050*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6053*/          OPC_MoveParent,
/*6054*/          OPC_Scope, 33, /*->6089*/ // 2 children in Scope
/*6056*/            OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*6058*/            OPC_EmitMergeInputChains1_0,
/*6059*/            OPC_EmitInteger, MVT::i32, 0, 
/*6062*/            OPC_EmitConvertToTarget, 2,
/*6064*/            OPC_EmitInteger, MVT::i32, 127|128,31/*4095*/, 
/*6068*/            OPC_EmitConvertToTarget, 3,
/*6070*/            OPC_EmitInteger, MVT::i32, 34, 
/*6073*/            OPC_EmitInteger, MVT::i32, 0, 
/*6076*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_ExportBuf), 0|OPFL_Chain,
                        0/*#VTs*/, 7/*#Ops*/, 1, 4, 5, 6, 7, 8, 9, 
                    // Src: (intrinsic_void 4986:iPTR, R600_Reg128:v4f32:$src, (imm:i32):$arraybase, 2:i32, (imm:i32):$mask) - Complexity = 19
                    // Dst: (R600_ExportBuf ?:v4f32:$src, 0:i32, (imm:i32):$arraybase, 4095:i32, (imm:i32):$mask, 34:i32, 0:i32)
/*6089*/          /*Scope*/ 33, /*->6123*/
/*6090*/            OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*6092*/            OPC_EmitMergeInputChains1_0,
/*6093*/            OPC_EmitInteger, MVT::i32, 0, 
/*6096*/            OPC_EmitConvertToTarget, 2,
/*6098*/            OPC_EmitInteger, MVT::i32, 127|128,31/*4095*/, 
/*6102*/            OPC_EmitConvertToTarget, 3,
/*6104*/            OPC_EmitInteger, MVT::i32, 66, 
/*6107*/            OPC_EmitInteger, MVT::i32, 0, 
/*6110*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::EG_ExportBuf), 0|OPFL_Chain,
                        0/*#VTs*/, 7/*#Ops*/, 1, 4, 5, 6, 7, 8, 9, 
                    // Src: (intrinsic_void 4986:iPTR, R600_Reg128:v4f32:$src, (imm:i32):$arraybase, 2:i32, (imm:i32):$mask) - Complexity = 19
                    // Dst: (EG_ExportBuf ?:v4f32:$src, 0:i32, (imm:i32):$arraybase, 4095:i32, (imm:i32):$mask, 66:i32, 0:i32)
/*6123*/          0, /*End of Scope*/
/*6124*/        /*Scope*/ 79, /*->6204*/
/*6125*/          OPC_CheckChild4Integer, 3, 
/*6127*/          OPC_RecordChild5, // #3 = $mask
/*6128*/          OPC_MoveChild, 5,
/*6130*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6133*/          OPC_MoveParent,
/*6134*/          OPC_Scope, 33, /*->6169*/ // 2 children in Scope
/*6136*/            OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*6138*/            OPC_EmitMergeInputChains1_0,
/*6139*/            OPC_EmitInteger, MVT::i32, 0, 
/*6142*/            OPC_EmitConvertToTarget, 2,
/*6144*/            OPC_EmitInteger, MVT::i32, 127|128,31/*4095*/, 
/*6148*/            OPC_EmitConvertToTarget, 3,
/*6150*/            OPC_EmitInteger, MVT::i32, 35, 
/*6153*/            OPC_EmitInteger, MVT::i32, 0, 
/*6156*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_ExportBuf), 0|OPFL_Chain,
                        0/*#VTs*/, 7/*#Ops*/, 1, 4, 5, 6, 7, 8, 9, 
                    // Src: (intrinsic_void 4986:iPTR, R600_Reg128:v4f32:$src, (imm:i32):$arraybase, 3:i32, (imm:i32):$mask) - Complexity = 19
                    // Dst: (R600_ExportBuf ?:v4f32:$src, 0:i32, (imm:i32):$arraybase, 4095:i32, (imm:i32):$mask, 35:i32, 0:i32)
/*6169*/          /*Scope*/ 33, /*->6203*/
/*6170*/            OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*6172*/            OPC_EmitMergeInputChains1_0,
/*6173*/            OPC_EmitInteger, MVT::i32, 0, 
/*6176*/            OPC_EmitConvertToTarget, 2,
/*6178*/            OPC_EmitInteger, MVT::i32, 127|128,31/*4095*/, 
/*6182*/            OPC_EmitConvertToTarget, 3,
/*6184*/            OPC_EmitInteger, MVT::i32, 67, 
/*6187*/            OPC_EmitInteger, MVT::i32, 0, 
/*6190*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::EG_ExportBuf), 0|OPFL_Chain,
                        0/*#VTs*/, 7/*#Ops*/, 1, 4, 5, 6, 7, 8, 9, 
                    // Src: (intrinsic_void 4986:iPTR, R600_Reg128:v4f32:$src, (imm:i32):$arraybase, 3:i32, (imm:i32):$mask) - Complexity = 19
                    // Dst: (EG_ExportBuf ?:v4f32:$src, 0:i32, (imm:i32):$arraybase, 4095:i32, (imm:i32):$mask, 67:i32, 0:i32)
/*6203*/          0, /*End of Scope*/
/*6204*/        0, /*End of Scope*/
/*6205*/      /*Scope*/ 90|128,1/*218*/, /*->6425*/
/*6207*/        OPC_CheckChild1Integer, 119|128,38/*4983*/, 
/*6210*/        OPC_Scope, 104, /*->6316*/ // 2 children in Scope
/*6212*/          OPC_CheckChild2Integer, 1, 
/*6214*/          OPC_Scope, 49, /*->6265*/ // 2 children in Scope
/*6216*/            OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*6218*/            OPC_EmitMergeInputChains1_0,
/*6219*/            OPC_EmitNode, TARGET_VAL(TargetOpcode::IMPLICIT_DEF), 0,
                        1/*#VTs*/, MVT::v4f32, 0/*#Ops*/,  // Results = #1
/*6226*/            OPC_EmitInteger, MVT::i32, 1, 
/*6229*/            OPC_EmitInteger, MVT::i32, 60, 
/*6232*/            OPC_EmitInteger, MVT::i32, 7, 
/*6235*/            OPC_EmitInteger, MVT::i32, 7, 
/*6238*/            OPC_EmitInteger, MVT::i32, 7, 
/*6241*/            OPC_EmitInteger, MVT::i32, 7, 
/*6244*/            OPC_EmitInteger, MVT::i32, 39, 
/*6247*/            OPC_EmitInteger, MVT::i32, 0, 
/*6250*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_ExportSwz), 0|OPFL_Chain,
                        0/*#VTs*/, 9/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 9, 
                    // Src: (intrinsic_void 4983:iPTR, 1:i32) - Complexity = 13
                    // Dst: (R600_ExportSwz (IMPLICIT_DEF:v4f32), 1:i32, 60:i32, 7:i32, 7:i32, 7:i32, 7:i32, 39:i32, 0:i32)
/*6265*/          /*Scope*/ 49, /*->6315*/
/*6266*/            OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*6268*/            OPC_EmitMergeInputChains1_0,
/*6269*/            OPC_EmitNode, TARGET_VAL(TargetOpcode::IMPLICIT_DEF), 0,
                        1/*#VTs*/, MVT::v4f32, 0/*#Ops*/,  // Results = #1
/*6276*/            OPC_EmitInteger, MVT::i32, 1, 
/*6279*/            OPC_EmitInteger, MVT::i32, 60, 
/*6282*/            OPC_EmitInteger, MVT::i32, 7, 
/*6285*/            OPC_EmitInteger, MVT::i32, 7, 
/*6288*/            OPC_EmitInteger, MVT::i32, 7, 
/*6291*/            OPC_EmitInteger, MVT::i32, 7, 
/*6294*/            OPC_EmitInteger, MVT::i32, 83, 
/*6297*/            OPC_EmitInteger, MVT::i32, 0, 
/*6300*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::EG_ExportSwz), 0|OPFL_Chain,
                        0/*#VTs*/, 9/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 9, 
                    // Src: (intrinsic_void 4983:iPTR, 1:i32) - Complexity = 13
                    // Dst: (EG_ExportSwz (IMPLICIT_DEF:v4f32), 1:i32, 60:i32, 7:i32, 7:i32, 7:i32, 7:i32, 83:i32, 0:i32)
/*6315*/          0, /*End of Scope*/
/*6316*/        /*Scope*/ 107, /*->6424*/
/*6317*/          OPC_RecordChild2, // #1 = $type
/*6318*/          OPC_MoveChild, 2,
/*6320*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*6323*/          OPC_MoveParent,
/*6324*/          OPC_Scope, 48, /*->6374*/ // 2 children in Scope
/*6326*/            OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*6328*/            OPC_EmitMergeInputChains1_0,
/*6329*/            OPC_EmitNode, TARGET_VAL(TargetOpcode::IMPLICIT_DEF), 0,
                        1/*#VTs*/, MVT::v4f32, 0/*#Ops*/,  // Results = #2
/*6336*/            OPC_EmitConvertToTarget, 1,
/*6338*/            OPC_EmitInteger, MVT::i32, 0, 
/*6341*/            OPC_EmitInteger, MVT::i32, 7, 
/*6344*/            OPC_EmitInteger, MVT::i32, 7, 
/*6347*/            OPC_EmitInteger, MVT::i32, 7, 
/*6350*/            OPC_EmitInteger, MVT::i32, 7, 
/*6353*/            OPC_EmitInteger, MVT::i32, 39, 
/*6356*/            OPC_EmitInteger, MVT::i32, 0, 
/*6359*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_ExportSwz), 0|OPFL_Chain,
                        0/*#VTs*/, 9/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 10, 
                    // Src: (intrinsic_void 4983:iPTR, (imm:i32):$type) - Complexity = 11
                    // Dst: (R600_ExportSwz (IMPLICIT_DEF:v4f32), (imm:i32):$type, 0:i32, 7:i32, 7:i32, 7:i32, 7:i32, 39:i32, 0:i32)
/*6374*/          /*Scope*/ 48, /*->6423*/
/*6375*/            OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*6377*/            OPC_EmitMergeInputChains1_0,
/*6378*/            OPC_EmitNode, TARGET_VAL(TargetOpcode::IMPLICIT_DEF), 0,
                        1/*#VTs*/, MVT::v4f32, 0/*#Ops*/,  // Results = #2
/*6385*/            OPC_EmitConvertToTarget, 1,
/*6387*/            OPC_EmitInteger, MVT::i32, 0, 
/*6390*/            OPC_EmitInteger, MVT::i32, 7, 
/*6393*/            OPC_EmitInteger, MVT::i32, 7, 
/*6396*/            OPC_EmitInteger, MVT::i32, 7, 
/*6399*/            OPC_EmitInteger, MVT::i32, 7, 
/*6402*/            OPC_EmitInteger, MVT::i32, 83, 
/*6405*/            OPC_EmitInteger, MVT::i32, 0, 
/*6408*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::EG_ExportSwz), 0|OPFL_Chain,
                        0/*#VTs*/, 9/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 10, 
                    // Src: (intrinsic_void 4983:iPTR, (imm:i32):$type) - Complexity = 11
                    // Dst: (EG_ExportSwz (IMPLICIT_DEF:v4f32), (imm:i32):$type, 0:i32, 7:i32, 7:i32, 7:i32, 7:i32, 83:i32, 0:i32)
/*6423*/          0, /*End of Scope*/
/*6424*/        0, /*End of Scope*/
/*6425*/      /*Scope*/ 25, /*->6451*/
/*6426*/        OPC_CheckChild1Integer, 57|128,38/*4921*/, 
/*6429*/        OPC_Scope, 9, /*->6440*/ // 2 children in Scope
/*6431*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*6433*/          OPC_EmitMergeInputChains1_0,
/*6434*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::GROUP_BARRIER), 0|OPFL_Chain,
                      0/*#VTs*/, 0/*#Ops*/, 
                  // Src: (intrinsic_void 4921:iPTR) - Complexity = 8
                  // Dst: (GROUP_BARRIER)
/*6440*/        /*Scope*/ 9, /*->6450*/
/*6441*/          OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*6443*/          OPC_EmitMergeInputChains1_0,
/*6444*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_BARRIER), 0|OPFL_Chain,
                      0/*#VTs*/, 0/*#Ops*/, 
                  // Src: (intrinsic_void 4921:iPTR) - Complexity = 8
                  // Dst: (S_BARRIER)
/*6450*/        0, /*End of Scope*/
/*6451*/      /*Scope*/ 25, /*->6477*/
/*6452*/        OPC_CheckChild1Integer, 56|128,38/*4920*/, 
/*6455*/        OPC_Scope, 9, /*->6466*/ // 2 children in Scope
/*6457*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*6459*/          OPC_EmitMergeInputChains1_0,
/*6460*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::GROUP_BARRIER), 0|OPFL_Chain,
                      0/*#VTs*/, 0/*#Ops*/, 
                  // Src: (intrinsic_void 4920:iPTR) - Complexity = 8
                  // Dst: (GROUP_BARRIER)
/*6466*/        /*Scope*/ 9, /*->6476*/
/*6467*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*6469*/          OPC_EmitMergeInputChains1_0,
/*6470*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_BARRIER), 0|OPFL_Chain,
                      0/*#VTs*/, 0/*#Ops*/, 
                  // Src: (intrinsic_void 4920:iPTR) - Complexity = 8
                  // Dst: (S_BARRIER)
/*6476*/        0, /*End of Scope*/
/*6477*/      /*Scope*/ 22, /*->6500*/
/*6478*/        OPC_CheckChild1Integer, 84|128,39/*5076*/, 
/*6481*/        OPC_RecordChild2, // #1 = $saved
/*6482*/        OPC_RecordChild3, // #2 = $target
/*6483*/        OPC_MoveChild, 3,
/*6485*/        OPC_CheckOpcode, TARGET_VAL(ISD::BasicBlock),
/*6488*/        OPC_MoveParent,
/*6489*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*6491*/        OPC_EmitMergeInputChains1_0,
/*6492*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_LOOP), 0|OPFL_Chain,
                    0/*#VTs*/, 2/*#Ops*/, 1, 2, 
                // Src: (intrinsic_void 5076:iPTR, i64:i64:$saved, (bb:Other):$target) - Complexity = 8
                // Dst: (SI_LOOP i64:i64:$saved, (bb:Other):$target)
/*6500*/      /*Scope*/ 14, /*->6515*/
/*6501*/        OPC_CheckChild1Integer, 8|128,39/*5000*/, 
/*6504*/        OPC_RecordChild2, // #1 = $saved
/*6505*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*6507*/        OPC_EmitMergeInputChains1_0,
/*6508*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_END_CF), 0|OPFL_Chain,
                    0/*#VTs*/, 1/*#Ops*/, 1, 
                // Src: (intrinsic_void 5000:iPTR, i64:i64:$saved) - Complexity = 8
                // Dst: (SI_END_CF i64:i64:$saved)
/*6515*/      /*Scope*/ 2|128,1/*130*/, /*->6647*/
/*6517*/        OPC_CheckChild1Integer, 80|128,38/*4944*/, 
/*6520*/        OPC_RecordChild2, // #1 = $src
/*6521*/        OPC_Scope, 10, /*->6533*/ // 2 children in Scope
/*6523*/          OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*6525*/          OPC_EmitMergeInputChains1_0,
/*6526*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_KILL), 0|OPFL_Chain,
                      0/*#VTs*/, 1/*#Ops*/, 1, 
                  // Src: (intrinsic_void 4944:iPTR, f32:f32:$src) - Complexity = 8
                  // Dst: (SI_KILL f32:f32:$src)
/*6533*/        /*Scope*/ 112, /*->6646*/
/*6534*/          OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*6536*/          OPC_EmitMergeInputChains1_0,
/*6537*/          OPC_EmitInteger, MVT::i32, 0, 
/*6540*/          OPC_EmitInteger, MVT::i32, 0, 
/*6543*/          OPC_EmitInteger, MVT::i32, 1, 
/*6546*/          OPC_EmitInteger, MVT::i32, 0, 
/*6549*/          OPC_EmitInteger, MVT::i32, 0, 
/*6552*/          OPC_EmitInteger, MVT::i32, 0, 
/*6555*/          OPC_EmitRegister, MVT::f32, AMDGPU::ZERO,
/*6558*/          OPC_EmitInteger, MVT::i32, 0, 
/*6561*/          OPC_EmitInteger, MVT::i32, 0, 
/*6564*/          OPC_EmitInteger, MVT::i32, 0, 
/*6567*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*6579*/          OPC_EmitInteger, MVT::i32, 0, 
/*6582*/          OPC_EmitInteger, MVT::i32, 0, 
/*6585*/          OPC_EmitInteger, MVT::i32, 0, 
/*6588*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*6600*/          OPC_EmitInteger, MVT::i32, 1, 
/*6603*/          OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*6606*/          OPC_EmitInteger, MVT::i32, 0, 
/*6609*/          OPC_EmitInteger, MVT::i32, 0, 
/*6612*/          OPC_EmitNode, TARGET_VAL(AMDGPU::KILLGT), 0|OPFL_Chain,
                      1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 13, 14, 15, 16, 17, 18, 19, 20,  // Results = #21
/*6639*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::MASK_WRITE), 0|OPFL_Chain,
                      0/*#VTs*/, 1/*#Ops*/, 21, 
                  // Src: (intrinsic_void 4944:iPTR, f32:f32:$src0) - Complexity = 8
                  // Dst: (MASK_WRITE (KILLGT:i32 ZERO:f32, ?:f32:$src0))
/*6646*/        0, /*End of Scope*/
/*6647*/      /*Scope*/ 11|128,1/*139*/, /*->6788*/
/*6649*/        OPC_CheckChild1Integer, 81|128,38/*4945*/, 
/*6652*/        OPC_Scope, 17, /*->6671*/ // 2 children in Scope
/*6654*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*6656*/          OPC_EmitMergeInputChains1_0,
/*6657*/          OPC_EmitInteger, MVT::i32, 0|128,0|128,0|128,124|128,11/*3212836864*/, 
/*6664*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_KILL), 0|OPFL_Chain,
                      0/*#VTs*/, 1/*#Ops*/, 1, 
                  // Src: (intrinsic_void 4945:iPTR) - Complexity = 8
                  // Dst: (SI_KILL 3212836864:i32)
/*6671*/        /*Scope*/ 115, /*->6787*/
/*6672*/          OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*6674*/          OPC_EmitMergeInputChains1_0,
/*6675*/          OPC_EmitInteger, MVT::i32, 0, 
/*6678*/          OPC_EmitInteger, MVT::i32, 0, 
/*6681*/          OPC_EmitInteger, MVT::i32, 1, 
/*6684*/          OPC_EmitInteger, MVT::i32, 0, 
/*6687*/          OPC_EmitInteger, MVT::i32, 0, 
/*6690*/          OPC_EmitInteger, MVT::i32, 0, 
/*6693*/          OPC_EmitRegister, MVT::f32, AMDGPU::ONE,
/*6696*/          OPC_EmitInteger, MVT::i32, 0, 
/*6699*/          OPC_EmitInteger, MVT::i32, 0, 
/*6702*/          OPC_EmitInteger, MVT::i32, 0, 
/*6705*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*6717*/          OPC_EmitRegister, MVT::f32, AMDGPU::ZERO,
/*6720*/          OPC_EmitInteger, MVT::i32, 0, 
/*6723*/          OPC_EmitInteger, MVT::i32, 0, 
/*6726*/          OPC_EmitInteger, MVT::i32, 0, 
/*6729*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*6741*/          OPC_EmitInteger, MVT::i32, 1, 
/*6744*/          OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*6747*/          OPC_EmitInteger, MVT::i32, 0, 
/*6750*/          OPC_EmitInteger, MVT::i32, 0, 
/*6753*/          OPC_EmitNode, TARGET_VAL(AMDGPU::KILLGT), 0|OPFL_Chain,
                      1/*#VTs*/, MVT::i32, 20/*#Ops*/, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,  // Results = #21
/*6780*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::MASK_WRITE), 0|OPFL_Chain,
                      0/*#VTs*/, 1/*#Ops*/, 21, 
                  // Src: (intrinsic_void 4945:iPTR) - Complexity = 8
                  // Dst: (MASK_WRITE (KILLGT:i32 ONE:f32, ZERO:f32))
/*6787*/        0, /*End of Scope*/
/*6788*/      /*Scope*/ 4|128,1/*132*/, /*->6922*/
/*6790*/        OPC_CheckChild1Integer, 120|128,38/*4984*/, 
/*6793*/        OPC_RecordChild2, // #1 = $reg
/*6794*/        OPC_Scope, 62, /*->6858*/ // 2 children in Scope
/*6796*/          OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*6798*/          OPC_EmitMergeInputChains1_0,
/*6799*/          OPC_EmitNode, TARGET_VAL(TargetOpcode::IMPLICIT_DEF), 0,
                      1/*#VTs*/, MVT::v4f32, 0/*#Ops*/,  // Results = #2
/*6806*/          OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*6809*/          OPC_EmitNode, TARGET_VAL(TargetOpcode::INSERT_SUBREG), 0,
                      1/*#VTs*/, MVT::v4f32, 3/*#Ops*/, 2, 1, 3,  // Results = #4
/*6819*/          OPC_EmitInteger, MVT::i32, 0, 
/*6822*/          OPC_EmitInteger, MVT::i32, 61, 
/*6825*/          OPC_EmitInteger, MVT::i32, 0, 
/*6828*/          OPC_EmitInteger, MVT::i32, 7, 
/*6831*/          OPC_EmitInteger, MVT::i32, 7, 
/*6834*/          OPC_EmitInteger, MVT::i32, 7, 
/*6837*/          OPC_EmitInteger, MVT::i32, 39, 
/*6840*/          OPC_EmitInteger, MVT::i32, 0, 
/*6843*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_ExportSwz), 0|OPFL_Chain,
                      0/*#VTs*/, 9/*#Ops*/, 4, 5, 6, 7, 8, 9, 10, 11, 12, 
                  // Src: (intrinsic_void 4984:iPTR, R600_Reg32:f32:$reg) - Complexity = 8
                  // Dst: (R600_ExportSwz (INSERT_SUBREG:v4f32 (IMPLICIT_DEF:v4f32), ?:f32:$reg, sub0:i32), 0:i32, 61:i32, 0:i32, 7:i32, 7:i32, 7:i32, 39:i32, 0:i32)
/*6858*/        /*Scope*/ 62, /*->6921*/
/*6859*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*6861*/          OPC_EmitMergeInputChains1_0,
/*6862*/          OPC_EmitNode, TARGET_VAL(TargetOpcode::IMPLICIT_DEF), 0,
                      1/*#VTs*/, MVT::v4f32, 0/*#Ops*/,  // Results = #2
/*6869*/          OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*6872*/          OPC_EmitNode, TARGET_VAL(TargetOpcode::INSERT_SUBREG), 0,
                      1/*#VTs*/, MVT::v4f32, 3/*#Ops*/, 2, 1, 3,  // Results = #4
/*6882*/          OPC_EmitInteger, MVT::i32, 0, 
/*6885*/          OPC_EmitInteger, MVT::i32, 61, 
/*6888*/          OPC_EmitInteger, MVT::i32, 0, 
/*6891*/          OPC_EmitInteger, MVT::i32, 7, 
/*6894*/          OPC_EmitInteger, MVT::i32, 7, 
/*6897*/          OPC_EmitInteger, MVT::i32, 7, 
/*6900*/          OPC_EmitInteger, MVT::i32, 83, 
/*6903*/          OPC_EmitInteger, MVT::i32, 0, 
/*6906*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::EG_ExportSwz), 0|OPFL_Chain,
                      0/*#VTs*/, 9/*#Ops*/, 4, 5, 6, 7, 8, 9, 10, 11, 12, 
                  // Src: (intrinsic_void 4984:iPTR, R600_Reg32:f32:$reg) - Complexity = 8
                  // Dst: (EG_ExportSwz (INSERT_SUBREG:v4f32 (IMPLICIT_DEF:v4f32), ?:f32:$reg, sub0:i32), 0:i32, 61:i32, 0:i32, 7:i32, 7:i32, 7:i32, 83:i32, 0:i32)
/*6921*/        0, /*End of Scope*/
/*6922*/      /*Scope*/ 4|128,1/*132*/, /*->7056*/
/*6924*/        OPC_CheckChild1Integer, 121|128,38/*4985*/, 
/*6927*/        OPC_RecordChild2, // #1 = $reg
/*6928*/        OPC_Scope, 62, /*->6992*/ // 2 children in Scope
/*6930*/          OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*6932*/          OPC_EmitMergeInputChains1_0,
/*6933*/          OPC_EmitNode, TARGET_VAL(TargetOpcode::IMPLICIT_DEF), 0,
                      1/*#VTs*/, MVT::v4f32, 0/*#Ops*/,  // Results = #2
/*6940*/          OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*6943*/          OPC_EmitNode, TARGET_VAL(TargetOpcode::INSERT_SUBREG), 0,
                      1/*#VTs*/, MVT::v4f32, 3/*#Ops*/, 2, 1, 3,  // Results = #4
/*6953*/          OPC_EmitInteger, MVT::i32, 0, 
/*6956*/          OPC_EmitInteger, MVT::i32, 61, 
/*6959*/          OPC_EmitInteger, MVT::i32, 7, 
/*6962*/          OPC_EmitInteger, MVT::i32, 0, 
/*6965*/          OPC_EmitInteger, MVT::i32, 7, 
/*6968*/          OPC_EmitInteger, MVT::i32, 7, 
/*6971*/          OPC_EmitInteger, MVT::i32, 39, 
/*6974*/          OPC_EmitInteger, MVT::i32, 0, 
/*6977*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_ExportSwz), 0|OPFL_Chain,
                      0/*#VTs*/, 9/*#Ops*/, 4, 5, 6, 7, 8, 9, 10, 11, 12, 
                  // Src: (intrinsic_void 4985:iPTR, R600_Reg32:f32:$reg) - Complexity = 8
                  // Dst: (R600_ExportSwz (INSERT_SUBREG:v4f32 (IMPLICIT_DEF:v4f32), ?:f32:$reg, sub0:i32), 0:i32, 61:i32, 7:i32, 0:i32, 7:i32, 7:i32, 39:i32, 0:i32)
/*6992*/        /*Scope*/ 62, /*->7055*/
/*6993*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*6995*/          OPC_EmitMergeInputChains1_0,
/*6996*/          OPC_EmitNode, TARGET_VAL(TargetOpcode::IMPLICIT_DEF), 0,
                      1/*#VTs*/, MVT::v4f32, 0/*#Ops*/,  // Results = #2
/*7003*/          OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*7006*/          OPC_EmitNode, TARGET_VAL(TargetOpcode::INSERT_SUBREG), 0,
                      1/*#VTs*/, MVT::v4f32, 3/*#Ops*/, 2, 1, 3,  // Results = #4
/*7016*/          OPC_EmitInteger, MVT::i32, 0, 
/*7019*/          OPC_EmitInteger, MVT::i32, 61, 
/*7022*/          OPC_EmitInteger, MVT::i32, 7, 
/*7025*/          OPC_EmitInteger, MVT::i32, 0, 
/*7028*/          OPC_EmitInteger, MVT::i32, 7, 
/*7031*/          OPC_EmitInteger, MVT::i32, 7, 
/*7034*/          OPC_EmitInteger, MVT::i32, 83, 
/*7037*/          OPC_EmitInteger, MVT::i32, 0, 
/*7040*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::EG_ExportSwz), 0|OPFL_Chain,
                      0/*#VTs*/, 9/*#Ops*/, 4, 5, 6, 7, 8, 9, 10, 11, 12, 
                  // Src: (intrinsic_void 4985:iPTR, R600_Reg32:f32:$reg) - Complexity = 8
                  // Dst: (EG_ExportSwz (INSERT_SUBREG:v4f32 (IMPLICIT_DEF:v4f32), ?:f32:$reg, sub0:i32), 0:i32, 61:i32, 7:i32, 0:i32, 7:i32, 7:i32, 83:i32, 0:i32)
/*7055*/        0, /*End of Scope*/
/*7056*/      0, /*End of Scope*/
/*7057*/    /*SwitchOpcode*/ 76|128,1/*204*/, TARGET_VAL(ISD::ATOMIC_SWAP),// ->7265
/*7061*/      OPC_RecordMemRef,
/*7062*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*7063*/      OPC_Scope, 45, /*->7110*/ // 3 children in Scope
/*7065*/        OPC_RecordChild1, // #1 = $MUBUFAddr64Atomic:srsrc:vaddr:soffset:offset:slc
/*7066*/        OPC_RecordChild2, // #2 = $vdata_in
/*7067*/        OPC_CheckPredicate, 73, // Predicate_atomic_swap_global
/*7069*/        OPC_CheckType, MVT::i32,
/*7071*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*7073*/        OPC_Scope, 17, /*->7092*/ // 2 children in Scope
/*7075*/          OPC_CheckComplexPat, /*CP*/6, /*#*/1, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7
/*7078*/          OPC_EmitMergeInputChains1_0,
/*7079*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_SWAP_RTN_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (atomic_swap:i32 (MUBUFAddr64Atomic:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_swap_global>> - Complexity = 22
                  // Dst: (BUFFER_ATOMIC_SWAP_RTN_ADDR64:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*7092*/        /*Scope*/ 16, /*->7109*/
/*7093*/          OPC_CheckComplexPat, /*CP*/7, /*#*/1, // SelectMUBUFOffset:$ #3 #4 #5 #6
/*7096*/          OPC_EmitMergeInputChains1_0,
/*7097*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_SWAP_RTN_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 5/*#Ops*/, 2, 3, 4, 5, 6, 
                  // Src: (atomic_swap:i32 (MUBUFOffsetAtomic:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_swap_global>> - Complexity = 19
                  // Dst: (BUFFER_ATOMIC_SWAP_RTN_OFFSET:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*7109*/        0, /*End of Scope*/
/*7110*/      /*Scope*/ 57, /*->7168*/
/*7111*/        OPC_CaptureGlueInput,
/*7112*/        OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*7113*/        OPC_RecordChild2, // #2 = $value
/*7114*/        OPC_CheckPredicate, 74, // Predicate_si_atomic_swap_local
/*7116*/        OPC_SwitchType /*2 cases */, 23, MVT::i32,// ->7142
/*7119*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*7121*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*7124*/          OPC_EmitMergeInputChains1_0,
/*7125*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*7128*/          OPC_EmitInteger, MVT::i1, 0, 
/*7131*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_WRXCHG_RTN_B32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_swap_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i32:i32:$value)<<P:Predicate_si_atomic_swap_local>> - Complexity = 13
                  // Dst: (DS_WRXCHG_RTN_B32:i32 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*7142*/        /*SwitchType*/ 23, MVT::i64,// ->7167
/*7144*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*7146*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*7149*/          OPC_EmitMergeInputChains1_0,
/*7150*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*7153*/          OPC_EmitInteger, MVT::i1, 0, 
/*7156*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_WRXCHG_RTN_B64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i64, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_swap_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i64:i64:$value)<<P:Predicate_si_atomic_swap_local>> - Complexity = 13
                  // Dst: (DS_WRXCHG_RTN_B64:i64 ?:i32:$ptr, ?:i64:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*7167*/        0, // EndSwitchType
/*7168*/      /*Scope*/ 95, /*->7264*/
/*7169*/        OPC_RecordChild1, // #1 = $addr
/*7170*/        OPC_CheckType, MVT::i32,
/*7172*/        OPC_Scope, 25, /*->7199*/ // 2 children in Scope
/*7174*/          OPC_CheckChild1Type, MVT::i64,
/*7176*/          OPC_RecordChild2, // #2 = $data
/*7177*/          OPC_CheckPredicate, 73, // Predicate_atomic_swap_global
/*7179*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*7181*/          OPC_EmitMergeInputChains1_0,
/*7182*/          OPC_EmitInteger, MVT::i1, 0, 
/*7185*/          OPC_EmitInteger, MVT::i1, 0, 
/*7188*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_ATOMIC_SWAP_RTN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                  // Src: (atomic_swap:i32 i64:i64:$addr, i32:i32:$data)<<P:Predicate_atomic_swap_global>> - Complexity = 4
                  // Dst: (FLAT_ATOMIC_SWAP_RTN:i32 ?:i64:$addr, ?:i32:$data, 0:i1, 0:i1)
/*7199*/        /*Scope*/ 63, /*->7263*/
/*7200*/          OPC_CheckChild1Type, MVT::i32,
/*7202*/          OPC_RecordChild2, // #2 = $src1
/*7203*/          OPC_CheckPredicate, 75, // Predicate_atomic_swap_local
/*7205*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*7207*/          OPC_EmitMergeInputChains1_0,
/*7208*/          OPC_EmitInteger, MVT::i32, 0, 
/*7211*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*7223*/          OPC_EmitInteger, MVT::i32, 0, 
/*7226*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*7238*/          OPC_EmitInteger, MVT::i32, 1, 
/*7241*/          OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*7244*/          OPC_EmitInteger, MVT::i32, 0, 
/*7247*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_WRXCHG_RET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 9/*#Ops*/, 1, 3, 4, 2, 5, 6, 7, 8, 9, 
                  // Src: (atomic_swap:i32 i32:i32:$src0, i32:i32:$src1)<<P:Predicate_atomic_swap_local>> - Complexity = 4
                  // Dst: (LDS_WRXCHG_RET:i32 i32:i32:$src0, i32:i32:$src1)
/*7263*/        0, /*End of Scope*/
/*7264*/      0, /*End of Scope*/
/*7265*/    /*SwitchOpcode*/ 49|128,2/*305*/, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),// ->7574
/*7269*/      OPC_RecordMemRef,
/*7270*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*7271*/      OPC_Scope, 45, /*->7318*/ // 3 children in Scope
/*7273*/        OPC_RecordChild1, // #1 = $MUBUFAddr64Atomic:srsrc:vaddr:soffset:offset:slc
/*7274*/        OPC_RecordChild2, // #2 = $vdata_in
/*7275*/        OPC_CheckPredicate, 76, // Predicate_atomic_add_global
/*7277*/        OPC_CheckType, MVT::i32,
/*7279*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*7281*/        OPC_Scope, 17, /*->7300*/ // 2 children in Scope
/*7283*/          OPC_CheckComplexPat, /*CP*/6, /*#*/1, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7
/*7286*/          OPC_EmitMergeInputChains1_0,
/*7287*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_ADD_RTN_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (atomic_load_add:i32 (MUBUFAddr64Atomic:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_add_global>> - Complexity = 22
                  // Dst: (BUFFER_ATOMIC_ADD_RTN_ADDR64:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*7300*/        /*Scope*/ 16, /*->7317*/
/*7301*/          OPC_CheckComplexPat, /*CP*/7, /*#*/1, // SelectMUBUFOffset:$ #3 #4 #5 #6
/*7304*/          OPC_EmitMergeInputChains1_0,
/*7305*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_ADD_RTN_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 5/*#Ops*/, 2, 3, 4, 5, 6, 
                  // Src: (atomic_load_add:i32 (MUBUFOffsetAtomic:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_add_global>> - Complexity = 19
                  // Dst: (BUFFER_ATOMIC_ADD_RTN_OFFSET:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*7317*/        0, /*End of Scope*/
/*7318*/      /*Scope*/ 29|128,1/*157*/, /*->7477*/
/*7320*/        OPC_CaptureGlueInput,
/*7321*/        OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*7322*/        OPC_Scope, 96, /*->7420*/ // 2 children in Scope
/*7324*/          OPC_CheckChild2Integer, 1, 
/*7326*/          OPC_CheckPredicate, 77, // Predicate_si_atomic_load_add_local
/*7328*/          OPC_SwitchType /*2 cases */, 43, MVT::i32,// ->7374
/*7331*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*7333*/            OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #2 #3
/*7336*/            OPC_EmitMergeInputChains1_0,
/*7337*/            OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*7349*/            OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                        1/*#VTs*/, MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*7357*/            OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*7360*/            OPC_EmitInteger, MVT::i1, 0, 
/*7363*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_INC_RTN_U32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 4/*#Ops*/, 2, 5, 6, 7, 
                    // Src: (si_atomic_load_add_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), 1:i32)<<P:Predicate_si_atomic_load_add_local>> - Complexity = 18
                    // Dst: (DS_INC_RTN_U32:i32 ?:i32:$ptr, (S_MOV_B32:i32 -1:i32), (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*7374*/          /*SwitchType*/ 43, MVT::i64,// ->7419
/*7376*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*7378*/            OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #2 #3
/*7381*/            OPC_EmitMergeInputChains1_0,
/*7382*/            OPC_EmitInteger, MVT::i64, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*7394*/            OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B64), 0,
                        1/*#VTs*/, MVT::i64, 1/*#Ops*/, 4,  // Results = #5
/*7402*/            OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*7405*/            OPC_EmitInteger, MVT::i1, 0, 
/*7408*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_INC_RTN_U64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i64, 4/*#Ops*/, 2, 5, 6, 7, 
                    // Src: (si_atomic_load_add_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), 1:i64)<<P:Predicate_si_atomic_load_add_local>> - Complexity = 18
                    // Dst: (DS_INC_RTN_U64:i64 ?:i32:$ptr, (S_MOV_B64:i64 -1:i64), (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*7419*/          0, // EndSwitchType
/*7420*/        /*Scope*/ 55, /*->7476*/
/*7421*/          OPC_RecordChild2, // #2 = $value
/*7422*/          OPC_CheckPredicate, 77, // Predicate_si_atomic_load_add_local
/*7424*/          OPC_SwitchType /*2 cases */, 23, MVT::i32,// ->7450
/*7427*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*7429*/            OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*7432*/            OPC_EmitMergeInputChains1_0,
/*7433*/            OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*7436*/            OPC_EmitInteger, MVT::i1, 0, 
/*7439*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_ADD_RTN_U32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 4/*#Ops*/, 3, 2, 5, 6, 
                    // Src: (si_atomic_load_add_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i32:i32:$value)<<P:Predicate_si_atomic_load_add_local>> - Complexity = 13
                    // Dst: (DS_ADD_RTN_U32:i32 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*7450*/          /*SwitchType*/ 23, MVT::i64,// ->7475
/*7452*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*7454*/            OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*7457*/            OPC_EmitMergeInputChains1_0,
/*7458*/            OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*7461*/            OPC_EmitInteger, MVT::i1, 0, 
/*7464*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_ADD_RTN_U64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i64, 4/*#Ops*/, 3, 2, 5, 6, 
                    // Src: (si_atomic_load_add_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i64:i64:$value)<<P:Predicate_si_atomic_load_add_local>> - Complexity = 13
                    // Dst: (DS_ADD_RTN_U64:i64 ?:i32:$ptr, ?:i64:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*7475*/          0, // EndSwitchType
/*7476*/        0, /*End of Scope*/
/*7477*/      /*Scope*/ 95, /*->7573*/
/*7478*/        OPC_RecordChild1, // #1 = $addr
/*7479*/        OPC_CheckType, MVT::i32,
/*7481*/        OPC_Scope, 25, /*->7508*/ // 2 children in Scope
/*7483*/          OPC_CheckChild1Type, MVT::i64,
/*7485*/          OPC_RecordChild2, // #2 = $data
/*7486*/          OPC_CheckPredicate, 76, // Predicate_atomic_add_global
/*7488*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*7490*/          OPC_EmitMergeInputChains1_0,
/*7491*/          OPC_EmitInteger, MVT::i1, 0, 
/*7494*/          OPC_EmitInteger, MVT::i1, 0, 
/*7497*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_ATOMIC_ADD_RTN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                  // Src: (atomic_load_add:i32 i64:i64:$addr, i32:i32:$data)<<P:Predicate_atomic_add_global>> - Complexity = 4
                  // Dst: (FLAT_ATOMIC_ADD_RTN:i32 ?:i64:$addr, ?:i32:$data, 0:i1, 0:i1)
/*7508*/        /*Scope*/ 63, /*->7572*/
/*7509*/          OPC_CheckChild1Type, MVT::i32,
/*7511*/          OPC_RecordChild2, // #2 = $src1
/*7512*/          OPC_CheckPredicate, 78, // Predicate_atomic_load_add_local
/*7514*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*7516*/          OPC_EmitMergeInputChains1_0,
/*7517*/          OPC_EmitInteger, MVT::i32, 0, 
/*7520*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*7532*/          OPC_EmitInteger, MVT::i32, 0, 
/*7535*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*7547*/          OPC_EmitInteger, MVT::i32, 1, 
/*7550*/          OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*7553*/          OPC_EmitInteger, MVT::i32, 0, 
/*7556*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_ADD_RET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 9/*#Ops*/, 1, 3, 4, 2, 5, 6, 7, 8, 9, 
                  // Src: (atomic_load_add:i32 i32:i32:$src0, i32:i32:$src1)<<P:Predicate_atomic_load_add_local>> - Complexity = 4
                  // Dst: (LDS_ADD_RET:i32 i32:i32:$src0, i32:i32:$src1)
/*7572*/        0, /*End of Scope*/
/*7573*/      0, /*End of Scope*/
/*7574*/    /*SwitchOpcode*/ 49|128,2/*305*/, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),// ->7883
/*7578*/      OPC_RecordMemRef,
/*7579*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*7580*/      OPC_Scope, 45, /*->7627*/ // 3 children in Scope
/*7582*/        OPC_RecordChild1, // #1 = $MUBUFAddr64Atomic:srsrc:vaddr:soffset:offset:slc
/*7583*/        OPC_RecordChild2, // #2 = $vdata_in
/*7584*/        OPC_CheckPredicate, 79, // Predicate_atomic_sub_global
/*7586*/        OPC_CheckType, MVT::i32,
/*7588*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*7590*/        OPC_Scope, 17, /*->7609*/ // 2 children in Scope
/*7592*/          OPC_CheckComplexPat, /*CP*/6, /*#*/1, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7
/*7595*/          OPC_EmitMergeInputChains1_0,
/*7596*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_SUB_RTN_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (atomic_load_sub:i32 (MUBUFAddr64Atomic:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_sub_global>> - Complexity = 22
                  // Dst: (BUFFER_ATOMIC_SUB_RTN_ADDR64:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*7609*/        /*Scope*/ 16, /*->7626*/
/*7610*/          OPC_CheckComplexPat, /*CP*/7, /*#*/1, // SelectMUBUFOffset:$ #3 #4 #5 #6
/*7613*/          OPC_EmitMergeInputChains1_0,
/*7614*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_SUB_RTN_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 5/*#Ops*/, 2, 3, 4, 5, 6, 
                  // Src: (atomic_load_sub:i32 (MUBUFOffsetAtomic:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_sub_global>> - Complexity = 19
                  // Dst: (BUFFER_ATOMIC_SUB_RTN_OFFSET:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*7626*/        0, /*End of Scope*/
/*7627*/      /*Scope*/ 29|128,1/*157*/, /*->7786*/
/*7629*/        OPC_CaptureGlueInput,
/*7630*/        OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*7631*/        OPC_Scope, 96, /*->7729*/ // 2 children in Scope
/*7633*/          OPC_CheckChild2Integer, 1, 
/*7635*/          OPC_CheckPredicate, 80, // Predicate_si_atomic_load_sub_local
/*7637*/          OPC_SwitchType /*2 cases */, 43, MVT::i32,// ->7683
/*7640*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*7642*/            OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #2 #3
/*7645*/            OPC_EmitMergeInputChains1_0,
/*7646*/            OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*7658*/            OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                        1/*#VTs*/, MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*7666*/            OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*7669*/            OPC_EmitInteger, MVT::i1, 0, 
/*7672*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_DEC_RTN_U32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 4/*#Ops*/, 2, 5, 6, 7, 
                    // Src: (si_atomic_load_sub_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), 1:i32)<<P:Predicate_si_atomic_load_sub_local>> - Complexity = 18
                    // Dst: (DS_DEC_RTN_U32:i32 ?:i32:$ptr, (S_MOV_B32:i32 -1:i32), (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*7683*/          /*SwitchType*/ 43, MVT::i64,// ->7728
/*7685*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*7687*/            OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #2 #3
/*7690*/            OPC_EmitMergeInputChains1_0,
/*7691*/            OPC_EmitInteger, MVT::i64, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*7703*/            OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B64), 0,
                        1/*#VTs*/, MVT::i64, 1/*#Ops*/, 4,  // Results = #5
/*7711*/            OPC_EmitNodeXForm, 0, 3, // as_i16imm
/*7714*/            OPC_EmitInteger, MVT::i1, 0, 
/*7717*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_DEC_RTN_U64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i64, 4/*#Ops*/, 2, 5, 6, 7, 
                    // Src: (si_atomic_load_sub_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), 1:i64)<<P:Predicate_si_atomic_load_sub_local>> - Complexity = 18
                    // Dst: (DS_DEC_RTN_U64:i64 ?:i32:$ptr, (S_MOV_B64:i64 -1:i64), (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*7728*/          0, // EndSwitchType
/*7729*/        /*Scope*/ 55, /*->7785*/
/*7730*/          OPC_RecordChild2, // #2 = $value
/*7731*/          OPC_CheckPredicate, 80, // Predicate_si_atomic_load_sub_local
/*7733*/          OPC_SwitchType /*2 cases */, 23, MVT::i32,// ->7759
/*7736*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*7738*/            OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*7741*/            OPC_EmitMergeInputChains1_0,
/*7742*/            OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*7745*/            OPC_EmitInteger, MVT::i1, 0, 
/*7748*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_SUB_RTN_U32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i32, 4/*#Ops*/, 3, 2, 5, 6, 
                    // Src: (si_atomic_load_sub_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i32:i32:$value)<<P:Predicate_si_atomic_load_sub_local>> - Complexity = 13
                    // Dst: (DS_SUB_RTN_U32:i32 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*7759*/          /*SwitchType*/ 23, MVT::i64,// ->7784
/*7761*/            OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*7763*/            OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*7766*/            OPC_EmitMergeInputChains1_0,
/*7767*/            OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*7770*/            OPC_EmitInteger, MVT::i1, 0, 
/*7773*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_SUB_RTN_U64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                        1/*#VTs*/, MVT::i64, 4/*#Ops*/, 3, 2, 5, 6, 
                    // Src: (si_atomic_load_sub_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i64:i64:$value)<<P:Predicate_si_atomic_load_sub_local>> - Complexity = 13
                    // Dst: (DS_SUB_RTN_U64:i64 ?:i32:$ptr, ?:i64:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*7784*/          0, // EndSwitchType
/*7785*/        0, /*End of Scope*/
/*7786*/      /*Scope*/ 95, /*->7882*/
/*7787*/        OPC_RecordChild1, // #1 = $addr
/*7788*/        OPC_CheckType, MVT::i32,
/*7790*/        OPC_Scope, 25, /*->7817*/ // 2 children in Scope
/*7792*/          OPC_CheckChild1Type, MVT::i64,
/*7794*/          OPC_RecordChild2, // #2 = $data
/*7795*/          OPC_CheckPredicate, 79, // Predicate_atomic_sub_global
/*7797*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*7799*/          OPC_EmitMergeInputChains1_0,
/*7800*/          OPC_EmitInteger, MVT::i1, 0, 
/*7803*/          OPC_EmitInteger, MVT::i1, 0, 
/*7806*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_ATOMIC_SUB_RTN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                  // Src: (atomic_load_sub:i32 i64:i64:$addr, i32:i32:$data)<<P:Predicate_atomic_sub_global>> - Complexity = 4
                  // Dst: (FLAT_ATOMIC_SUB_RTN:i32 ?:i64:$addr, ?:i32:$data, 0:i1, 0:i1)
/*7817*/        /*Scope*/ 63, /*->7881*/
/*7818*/          OPC_CheckChild1Type, MVT::i32,
/*7820*/          OPC_RecordChild2, // #2 = $src1
/*7821*/          OPC_CheckPredicate, 81, // Predicate_atomic_load_sub_local
/*7823*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*7825*/          OPC_EmitMergeInputChains1_0,
/*7826*/          OPC_EmitInteger, MVT::i32, 0, 
/*7829*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*7841*/          OPC_EmitInteger, MVT::i32, 0, 
/*7844*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*7856*/          OPC_EmitInteger, MVT::i32, 1, 
/*7859*/          OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*7862*/          OPC_EmitInteger, MVT::i32, 0, 
/*7865*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_SUB_RET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 9/*#Ops*/, 1, 3, 4, 2, 5, 6, 7, 8, 9, 
                  // Src: (atomic_load_sub:i32 i32:i32:$src0, i32:i32:$src1)<<P:Predicate_atomic_load_sub_local>> - Complexity = 4
                  // Dst: (LDS_SUB_RET:i32 i32:i32:$src0, i32:i32:$src1)
/*7881*/        0, /*End of Scope*/
/*7882*/      0, /*End of Scope*/
/*7883*/    /*SwitchOpcode*/ 76|128,1/*204*/, TARGET_VAL(ISD::ATOMIC_LOAD_MIN),// ->8091
/*7887*/      OPC_RecordMemRef,
/*7888*/      OPC_RecordNode, // #0 = 'atomic_load_min' chained node
/*7889*/      OPC_Scope, 45, /*->7936*/ // 3 children in Scope
/*7891*/        OPC_RecordChild1, // #1 = $MUBUFAddr64Atomic:srsrc:vaddr:soffset:offset:slc
/*7892*/        OPC_RecordChild2, // #2 = $vdata_in
/*7893*/        OPC_CheckPredicate, 82, // Predicate_atomic_min_global
/*7895*/        OPC_CheckType, MVT::i32,
/*7897*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*7899*/        OPC_Scope, 17, /*->7918*/ // 2 children in Scope
/*7901*/          OPC_CheckComplexPat, /*CP*/6, /*#*/1, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7
/*7904*/          OPC_EmitMergeInputChains1_0,
/*7905*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_SMIN_RTN_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (atomic_load_min:i32 (MUBUFAddr64Atomic:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_min_global>> - Complexity = 22
                  // Dst: (BUFFER_ATOMIC_SMIN_RTN_ADDR64:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*7918*/        /*Scope*/ 16, /*->7935*/
/*7919*/          OPC_CheckComplexPat, /*CP*/7, /*#*/1, // SelectMUBUFOffset:$ #3 #4 #5 #6
/*7922*/          OPC_EmitMergeInputChains1_0,
/*7923*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_SMIN_RTN_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 5/*#Ops*/, 2, 3, 4, 5, 6, 
                  // Src: (atomic_load_min:i32 (MUBUFOffsetAtomic:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_min_global>> - Complexity = 19
                  // Dst: (BUFFER_ATOMIC_SMIN_RTN_OFFSET:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*7935*/        0, /*End of Scope*/
/*7936*/      /*Scope*/ 57, /*->7994*/
/*7937*/        OPC_CaptureGlueInput,
/*7938*/        OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*7939*/        OPC_RecordChild2, // #2 = $value
/*7940*/        OPC_CheckPredicate, 83, // Predicate_si_atomic_load_min_local
/*7942*/        OPC_SwitchType /*2 cases */, 23, MVT::i32,// ->7968
/*7945*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*7947*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*7950*/          OPC_EmitMergeInputChains1_0,
/*7951*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*7954*/          OPC_EmitInteger, MVT::i1, 0, 
/*7957*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_MIN_RTN_I32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_min_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i32:i32:$value)<<P:Predicate_si_atomic_load_min_local>> - Complexity = 13
                  // Dst: (DS_MIN_RTN_I32:i32 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*7968*/        /*SwitchType*/ 23, MVT::i64,// ->7993
/*7970*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*7972*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*7975*/          OPC_EmitMergeInputChains1_0,
/*7976*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*7979*/          OPC_EmitInteger, MVT::i1, 0, 
/*7982*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_MIN_RTN_I64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i64, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_min_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i64:i64:$value)<<P:Predicate_si_atomic_load_min_local>> - Complexity = 13
                  // Dst: (DS_MIN_RTN_I64:i64 ?:i32:$ptr, ?:i64:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*7993*/        0, // EndSwitchType
/*7994*/      /*Scope*/ 95, /*->8090*/
/*7995*/        OPC_RecordChild1, // #1 = $addr
/*7996*/        OPC_CheckType, MVT::i32,
/*7998*/        OPC_Scope, 25, /*->8025*/ // 2 children in Scope
/*8000*/          OPC_CheckChild1Type, MVT::i64,
/*8002*/          OPC_RecordChild2, // #2 = $data
/*8003*/          OPC_CheckPredicate, 82, // Predicate_atomic_min_global
/*8005*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*8007*/          OPC_EmitMergeInputChains1_0,
/*8008*/          OPC_EmitInteger, MVT::i1, 0, 
/*8011*/          OPC_EmitInteger, MVT::i1, 0, 
/*8014*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_ATOMIC_SMIN_RTN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                  // Src: (atomic_load_min:i32 i64:i64:$addr, i32:i32:$data)<<P:Predicate_atomic_min_global>> - Complexity = 4
                  // Dst: (FLAT_ATOMIC_SMIN_RTN:i32 ?:i64:$addr, ?:i32:$data, 0:i1, 0:i1)
/*8025*/        /*Scope*/ 63, /*->8089*/
/*8026*/          OPC_CheckChild1Type, MVT::i32,
/*8028*/          OPC_RecordChild2, // #2 = $src1
/*8029*/          OPC_CheckPredicate, 84, // Predicate_atomic_load_min_local
/*8031*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*8033*/          OPC_EmitMergeInputChains1_0,
/*8034*/          OPC_EmitInteger, MVT::i32, 0, 
/*8037*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*8049*/          OPC_EmitInteger, MVT::i32, 0, 
/*8052*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*8064*/          OPC_EmitInteger, MVT::i32, 1, 
/*8067*/          OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*8070*/          OPC_EmitInteger, MVT::i32, 0, 
/*8073*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_MIN_INT_RET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 9/*#Ops*/, 1, 3, 4, 2, 5, 6, 7, 8, 9, 
                  // Src: (atomic_load_min:i32 i32:i32:$src0, i32:i32:$src1)<<P:Predicate_atomic_load_min_local>> - Complexity = 4
                  // Dst: (LDS_MIN_INT_RET:i32 i32:i32:$src0, i32:i32:$src1)
/*8089*/        0, /*End of Scope*/
/*8090*/      0, /*End of Scope*/
/*8091*/    /*SwitchOpcode*/ 76|128,1/*204*/, TARGET_VAL(ISD::ATOMIC_LOAD_UMIN),// ->8299
/*8095*/      OPC_RecordMemRef,
/*8096*/      OPC_RecordNode, // #0 = 'atomic_load_umin' chained node
/*8097*/      OPC_Scope, 45, /*->8144*/ // 3 children in Scope
/*8099*/        OPC_RecordChild1, // #1 = $MUBUFAddr64Atomic:srsrc:vaddr:soffset:offset:slc
/*8100*/        OPC_RecordChild2, // #2 = $vdata_in
/*8101*/        OPC_CheckPredicate, 85, // Predicate_atomic_umin_global
/*8103*/        OPC_CheckType, MVT::i32,
/*8105*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*8107*/        OPC_Scope, 17, /*->8126*/ // 2 children in Scope
/*8109*/          OPC_CheckComplexPat, /*CP*/6, /*#*/1, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7
/*8112*/          OPC_EmitMergeInputChains1_0,
/*8113*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_UMIN_RTN_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (atomic_load_umin:i32 (MUBUFAddr64Atomic:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_umin_global>> - Complexity = 22
                  // Dst: (BUFFER_ATOMIC_UMIN_RTN_ADDR64:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*8126*/        /*Scope*/ 16, /*->8143*/
/*8127*/          OPC_CheckComplexPat, /*CP*/7, /*#*/1, // SelectMUBUFOffset:$ #3 #4 #5 #6
/*8130*/          OPC_EmitMergeInputChains1_0,
/*8131*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_UMIN_RTN_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 5/*#Ops*/, 2, 3, 4, 5, 6, 
                  // Src: (atomic_load_umin:i32 (MUBUFOffsetAtomic:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_umin_global>> - Complexity = 19
                  // Dst: (BUFFER_ATOMIC_UMIN_RTN_OFFSET:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*8143*/        0, /*End of Scope*/
/*8144*/      /*Scope*/ 57, /*->8202*/
/*8145*/        OPC_CaptureGlueInput,
/*8146*/        OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*8147*/        OPC_RecordChild2, // #2 = $value
/*8148*/        OPC_CheckPredicate, 86, // Predicate_si_atomic_load_umin_local
/*8150*/        OPC_SwitchType /*2 cases */, 23, MVT::i32,// ->8176
/*8153*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*8155*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*8158*/          OPC_EmitMergeInputChains1_0,
/*8159*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*8162*/          OPC_EmitInteger, MVT::i1, 0, 
/*8165*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_MIN_RTN_U32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_umin_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i32:i32:$value)<<P:Predicate_si_atomic_load_umin_local>> - Complexity = 13
                  // Dst: (DS_MIN_RTN_U32:i32 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*8176*/        /*SwitchType*/ 23, MVT::i64,// ->8201
/*8178*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*8180*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*8183*/          OPC_EmitMergeInputChains1_0,
/*8184*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*8187*/          OPC_EmitInteger, MVT::i1, 0, 
/*8190*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_MIN_RTN_U64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i64, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_umin_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i64:i64:$value)<<P:Predicate_si_atomic_load_umin_local>> - Complexity = 13
                  // Dst: (DS_MIN_RTN_U64:i64 ?:i32:$ptr, ?:i64:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*8201*/        0, // EndSwitchType
/*8202*/      /*Scope*/ 95, /*->8298*/
/*8203*/        OPC_RecordChild1, // #1 = $addr
/*8204*/        OPC_CheckType, MVT::i32,
/*8206*/        OPC_Scope, 25, /*->8233*/ // 2 children in Scope
/*8208*/          OPC_CheckChild1Type, MVT::i64,
/*8210*/          OPC_RecordChild2, // #2 = $data
/*8211*/          OPC_CheckPredicate, 85, // Predicate_atomic_umin_global
/*8213*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*8215*/          OPC_EmitMergeInputChains1_0,
/*8216*/          OPC_EmitInteger, MVT::i1, 0, 
/*8219*/          OPC_EmitInteger, MVT::i1, 0, 
/*8222*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_ATOMIC_UMIN_RTN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                  // Src: (atomic_load_umin:i32 i64:i64:$addr, i32:i32:$data)<<P:Predicate_atomic_umin_global>> - Complexity = 4
                  // Dst: (FLAT_ATOMIC_UMIN_RTN:i32 ?:i64:$addr, ?:i32:$data, 0:i1, 0:i1)
/*8233*/        /*Scope*/ 63, /*->8297*/
/*8234*/          OPC_CheckChild1Type, MVT::i32,
/*8236*/          OPC_RecordChild2, // #2 = $src1
/*8237*/          OPC_CheckPredicate, 87, // Predicate_atomic_load_umin_local
/*8239*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*8241*/          OPC_EmitMergeInputChains1_0,
/*8242*/          OPC_EmitInteger, MVT::i32, 0, 
/*8245*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*8257*/          OPC_EmitInteger, MVT::i32, 0, 
/*8260*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*8272*/          OPC_EmitInteger, MVT::i32, 1, 
/*8275*/          OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*8278*/          OPC_EmitInteger, MVT::i32, 0, 
/*8281*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_MIN_UINT_RET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 9/*#Ops*/, 1, 3, 4, 2, 5, 6, 7, 8, 9, 
                  // Src: (atomic_load_umin:i32 i32:i32:$src0, i32:i32:$src1)<<P:Predicate_atomic_load_umin_local>> - Complexity = 4
                  // Dst: (LDS_MIN_UINT_RET:i32 i32:i32:$src0, i32:i32:$src1)
/*8297*/        0, /*End of Scope*/
/*8298*/      0, /*End of Scope*/
/*8299*/    /*SwitchOpcode*/ 76|128,1/*204*/, TARGET_VAL(ISD::ATOMIC_LOAD_MAX),// ->8507
/*8303*/      OPC_RecordMemRef,
/*8304*/      OPC_RecordNode, // #0 = 'atomic_load_max' chained node
/*8305*/      OPC_Scope, 45, /*->8352*/ // 3 children in Scope
/*8307*/        OPC_RecordChild1, // #1 = $MUBUFAddr64Atomic:srsrc:vaddr:soffset:offset:slc
/*8308*/        OPC_RecordChild2, // #2 = $vdata_in
/*8309*/        OPC_CheckPredicate, 88, // Predicate_atomic_max_global
/*8311*/        OPC_CheckType, MVT::i32,
/*8313*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*8315*/        OPC_Scope, 17, /*->8334*/ // 2 children in Scope
/*8317*/          OPC_CheckComplexPat, /*CP*/6, /*#*/1, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7
/*8320*/          OPC_EmitMergeInputChains1_0,
/*8321*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_SMAX_RTN_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (atomic_load_max:i32 (MUBUFAddr64Atomic:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_max_global>> - Complexity = 22
                  // Dst: (BUFFER_ATOMIC_SMAX_RTN_ADDR64:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*8334*/        /*Scope*/ 16, /*->8351*/
/*8335*/          OPC_CheckComplexPat, /*CP*/7, /*#*/1, // SelectMUBUFOffset:$ #3 #4 #5 #6
/*8338*/          OPC_EmitMergeInputChains1_0,
/*8339*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_SMAX_RTN_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 5/*#Ops*/, 2, 3, 4, 5, 6, 
                  // Src: (atomic_load_max:i32 (MUBUFOffsetAtomic:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_max_global>> - Complexity = 19
                  // Dst: (BUFFER_ATOMIC_SMAX_RTN_OFFSET:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*8351*/        0, /*End of Scope*/
/*8352*/      /*Scope*/ 57, /*->8410*/
/*8353*/        OPC_CaptureGlueInput,
/*8354*/        OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*8355*/        OPC_RecordChild2, // #2 = $value
/*8356*/        OPC_CheckPredicate, 89, // Predicate_si_atomic_load_max_local
/*8358*/        OPC_SwitchType /*2 cases */, 23, MVT::i32,// ->8384
/*8361*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*8363*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*8366*/          OPC_EmitMergeInputChains1_0,
/*8367*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*8370*/          OPC_EmitInteger, MVT::i1, 0, 
/*8373*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_MAX_RTN_I32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_max_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i32:i32:$value)<<P:Predicate_si_atomic_load_max_local>> - Complexity = 13
                  // Dst: (DS_MAX_RTN_I32:i32 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*8384*/        /*SwitchType*/ 23, MVT::i64,// ->8409
/*8386*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*8388*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*8391*/          OPC_EmitMergeInputChains1_0,
/*8392*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*8395*/          OPC_EmitInteger, MVT::i1, 0, 
/*8398*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_MAX_RTN_I64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i64, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_max_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i64:i64:$value)<<P:Predicate_si_atomic_load_max_local>> - Complexity = 13
                  // Dst: (DS_MAX_RTN_I64:i64 ?:i32:$ptr, ?:i64:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*8409*/        0, // EndSwitchType
/*8410*/      /*Scope*/ 95, /*->8506*/
/*8411*/        OPC_RecordChild1, // #1 = $addr
/*8412*/        OPC_CheckType, MVT::i32,
/*8414*/        OPC_Scope, 25, /*->8441*/ // 2 children in Scope
/*8416*/          OPC_CheckChild1Type, MVT::i64,
/*8418*/          OPC_RecordChild2, // #2 = $data
/*8419*/          OPC_CheckPredicate, 88, // Predicate_atomic_max_global
/*8421*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*8423*/          OPC_EmitMergeInputChains1_0,
/*8424*/          OPC_EmitInteger, MVT::i1, 0, 
/*8427*/          OPC_EmitInteger, MVT::i1, 0, 
/*8430*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_ATOMIC_SMAX_RTN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                  // Src: (atomic_load_max:i32 i64:i64:$addr, i32:i32:$data)<<P:Predicate_atomic_max_global>> - Complexity = 4
                  // Dst: (FLAT_ATOMIC_SMAX_RTN:i32 ?:i64:$addr, ?:i32:$data, 0:i1, 0:i1)
/*8441*/        /*Scope*/ 63, /*->8505*/
/*8442*/          OPC_CheckChild1Type, MVT::i32,
/*8444*/          OPC_RecordChild2, // #2 = $src1
/*8445*/          OPC_CheckPredicate, 90, // Predicate_atomic_load_max_local
/*8447*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*8449*/          OPC_EmitMergeInputChains1_0,
/*8450*/          OPC_EmitInteger, MVT::i32, 0, 
/*8453*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*8465*/          OPC_EmitInteger, MVT::i32, 0, 
/*8468*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*8480*/          OPC_EmitInteger, MVT::i32, 1, 
/*8483*/          OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*8486*/          OPC_EmitInteger, MVT::i32, 0, 
/*8489*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_MAX_INT_RET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 9/*#Ops*/, 1, 3, 4, 2, 5, 6, 7, 8, 9, 
                  // Src: (atomic_load_max:i32 i32:i32:$src0, i32:i32:$src1)<<P:Predicate_atomic_load_max_local>> - Complexity = 4
                  // Dst: (LDS_MAX_INT_RET:i32 i32:i32:$src0, i32:i32:$src1)
/*8505*/        0, /*End of Scope*/
/*8506*/      0, /*End of Scope*/
/*8507*/    /*SwitchOpcode*/ 76|128,1/*204*/, TARGET_VAL(ISD::ATOMIC_LOAD_UMAX),// ->8715
/*8511*/      OPC_RecordMemRef,
/*8512*/      OPC_RecordNode, // #0 = 'atomic_load_umax' chained node
/*8513*/      OPC_Scope, 45, /*->8560*/ // 3 children in Scope
/*8515*/        OPC_RecordChild1, // #1 = $MUBUFAddr64Atomic:srsrc:vaddr:soffset:offset:slc
/*8516*/        OPC_RecordChild2, // #2 = $vdata_in
/*8517*/        OPC_CheckPredicate, 91, // Predicate_atomic_umax_global
/*8519*/        OPC_CheckType, MVT::i32,
/*8521*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*8523*/        OPC_Scope, 17, /*->8542*/ // 2 children in Scope
/*8525*/          OPC_CheckComplexPat, /*CP*/6, /*#*/1, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7
/*8528*/          OPC_EmitMergeInputChains1_0,
/*8529*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_UMAX_RTN_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (atomic_load_umax:i32 (MUBUFAddr64Atomic:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_umax_global>> - Complexity = 22
                  // Dst: (BUFFER_ATOMIC_UMAX_RTN_ADDR64:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*8542*/        /*Scope*/ 16, /*->8559*/
/*8543*/          OPC_CheckComplexPat, /*CP*/7, /*#*/1, // SelectMUBUFOffset:$ #3 #4 #5 #6
/*8546*/          OPC_EmitMergeInputChains1_0,
/*8547*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_UMAX_RTN_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 5/*#Ops*/, 2, 3, 4, 5, 6, 
                  // Src: (atomic_load_umax:i32 (MUBUFOffsetAtomic:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_umax_global>> - Complexity = 19
                  // Dst: (BUFFER_ATOMIC_UMAX_RTN_OFFSET:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*8559*/        0, /*End of Scope*/
/*8560*/      /*Scope*/ 57, /*->8618*/
/*8561*/        OPC_CaptureGlueInput,
/*8562*/        OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*8563*/        OPC_RecordChild2, // #2 = $value
/*8564*/        OPC_CheckPredicate, 92, // Predicate_si_atomic_load_umax_local
/*8566*/        OPC_SwitchType /*2 cases */, 23, MVT::i32,// ->8592
/*8569*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*8571*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*8574*/          OPC_EmitMergeInputChains1_0,
/*8575*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*8578*/          OPC_EmitInteger, MVT::i1, 0, 
/*8581*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_MAX_RTN_U32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_umax_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i32:i32:$value)<<P:Predicate_si_atomic_load_umax_local>> - Complexity = 13
                  // Dst: (DS_MAX_RTN_U32:i32 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*8592*/        /*SwitchType*/ 23, MVT::i64,// ->8617
/*8594*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*8596*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*8599*/          OPC_EmitMergeInputChains1_0,
/*8600*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*8603*/          OPC_EmitInteger, MVT::i1, 0, 
/*8606*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_MAX_RTN_U64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i64, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_umax_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i64:i64:$value)<<P:Predicate_si_atomic_load_umax_local>> - Complexity = 13
                  // Dst: (DS_MAX_RTN_U64:i64 ?:i32:$ptr, ?:i64:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*8617*/        0, // EndSwitchType
/*8618*/      /*Scope*/ 95, /*->8714*/
/*8619*/        OPC_RecordChild1, // #1 = $addr
/*8620*/        OPC_CheckType, MVT::i32,
/*8622*/        OPC_Scope, 25, /*->8649*/ // 2 children in Scope
/*8624*/          OPC_CheckChild1Type, MVT::i64,
/*8626*/          OPC_RecordChild2, // #2 = $data
/*8627*/          OPC_CheckPredicate, 91, // Predicate_atomic_umax_global
/*8629*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*8631*/          OPC_EmitMergeInputChains1_0,
/*8632*/          OPC_EmitInteger, MVT::i1, 0, 
/*8635*/          OPC_EmitInteger, MVT::i1, 0, 
/*8638*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_ATOMIC_UMAX_RTN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                  // Src: (atomic_load_umax:i32 i64:i64:$addr, i32:i32:$data)<<P:Predicate_atomic_umax_global>> - Complexity = 4
                  // Dst: (FLAT_ATOMIC_UMAX_RTN:i32 ?:i64:$addr, ?:i32:$data, 0:i1, 0:i1)
/*8649*/        /*Scope*/ 63, /*->8713*/
/*8650*/          OPC_CheckChild1Type, MVT::i32,
/*8652*/          OPC_RecordChild2, // #2 = $src1
/*8653*/          OPC_CheckPredicate, 93, // Predicate_atomic_load_umax_local
/*8655*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*8657*/          OPC_EmitMergeInputChains1_0,
/*8658*/          OPC_EmitInteger, MVT::i32, 0, 
/*8661*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*8673*/          OPC_EmitInteger, MVT::i32, 0, 
/*8676*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*8688*/          OPC_EmitInteger, MVT::i32, 1, 
/*8691*/          OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*8694*/          OPC_EmitInteger, MVT::i32, 0, 
/*8697*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_MAX_UINT_RET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 9/*#Ops*/, 1, 3, 4, 2, 5, 6, 7, 8, 9, 
                  // Src: (atomic_load_umax:i32 i32:i32:$src0, i32:i32:$src1)<<P:Predicate_atomic_load_umax_local>> - Complexity = 4
                  // Dst: (LDS_MAX_UINT_RET:i32 i32:i32:$src0, i32:i32:$src1)
/*8713*/        0, /*End of Scope*/
/*8714*/      0, /*End of Scope*/
/*8715*/    /*SwitchOpcode*/ 76|128,1/*204*/, TARGET_VAL(ISD::ATOMIC_LOAD_AND),// ->8923
/*8719*/      OPC_RecordMemRef,
/*8720*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*8721*/      OPC_Scope, 45, /*->8768*/ // 3 children in Scope
/*8723*/        OPC_RecordChild1, // #1 = $MUBUFAddr64Atomic:srsrc:vaddr:soffset:offset:slc
/*8724*/        OPC_RecordChild2, // #2 = $vdata_in
/*8725*/        OPC_CheckPredicate, 94, // Predicate_atomic_and_global
/*8727*/        OPC_CheckType, MVT::i32,
/*8729*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*8731*/        OPC_Scope, 17, /*->8750*/ // 2 children in Scope
/*8733*/          OPC_CheckComplexPat, /*CP*/6, /*#*/1, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7
/*8736*/          OPC_EmitMergeInputChains1_0,
/*8737*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_AND_RTN_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (atomic_load_and:i32 (MUBUFAddr64Atomic:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_and_global>> - Complexity = 22
                  // Dst: (BUFFER_ATOMIC_AND_RTN_ADDR64:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*8750*/        /*Scope*/ 16, /*->8767*/
/*8751*/          OPC_CheckComplexPat, /*CP*/7, /*#*/1, // SelectMUBUFOffset:$ #3 #4 #5 #6
/*8754*/          OPC_EmitMergeInputChains1_0,
/*8755*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_AND_RTN_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 5/*#Ops*/, 2, 3, 4, 5, 6, 
                  // Src: (atomic_load_and:i32 (MUBUFOffsetAtomic:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_and_global>> - Complexity = 19
                  // Dst: (BUFFER_ATOMIC_AND_RTN_OFFSET:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*8767*/        0, /*End of Scope*/
/*8768*/      /*Scope*/ 57, /*->8826*/
/*8769*/        OPC_CaptureGlueInput,
/*8770*/        OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*8771*/        OPC_RecordChild2, // #2 = $value
/*8772*/        OPC_CheckPredicate, 95, // Predicate_si_atomic_load_and_local
/*8774*/        OPC_SwitchType /*2 cases */, 23, MVT::i32,// ->8800
/*8777*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*8779*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*8782*/          OPC_EmitMergeInputChains1_0,
/*8783*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*8786*/          OPC_EmitInteger, MVT::i1, 0, 
/*8789*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_AND_RTN_B32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_and_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i32:i32:$value)<<P:Predicate_si_atomic_load_and_local>> - Complexity = 13
                  // Dst: (DS_AND_RTN_B32:i32 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*8800*/        /*SwitchType*/ 23, MVT::i64,// ->8825
/*8802*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*8804*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*8807*/          OPC_EmitMergeInputChains1_0,
/*8808*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*8811*/          OPC_EmitInteger, MVT::i1, 0, 
/*8814*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_AND_RTN_B64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i64, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_and_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i64:i64:$value)<<P:Predicate_si_atomic_load_and_local>> - Complexity = 13
                  // Dst: (DS_AND_RTN_B64:i64 ?:i32:$ptr, ?:i64:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*8825*/        0, // EndSwitchType
/*8826*/      /*Scope*/ 95, /*->8922*/
/*8827*/        OPC_RecordChild1, // #1 = $addr
/*8828*/        OPC_CheckType, MVT::i32,
/*8830*/        OPC_Scope, 25, /*->8857*/ // 2 children in Scope
/*8832*/          OPC_CheckChild1Type, MVT::i64,
/*8834*/          OPC_RecordChild2, // #2 = $data
/*8835*/          OPC_CheckPredicate, 94, // Predicate_atomic_and_global
/*8837*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*8839*/          OPC_EmitMergeInputChains1_0,
/*8840*/          OPC_EmitInteger, MVT::i1, 0, 
/*8843*/          OPC_EmitInteger, MVT::i1, 0, 
/*8846*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_ATOMIC_AND_RTN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                  // Src: (atomic_load_and:i32 i64:i64:$addr, i32:i32:$data)<<P:Predicate_atomic_and_global>> - Complexity = 4
                  // Dst: (FLAT_ATOMIC_AND_RTN:i32 ?:i64:$addr, ?:i32:$data, 0:i1, 0:i1)
/*8857*/        /*Scope*/ 63, /*->8921*/
/*8858*/          OPC_CheckChild1Type, MVT::i32,
/*8860*/          OPC_RecordChild2, // #2 = $src1
/*8861*/          OPC_CheckPredicate, 96, // Predicate_atomic_load_and_local
/*8863*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*8865*/          OPC_EmitMergeInputChains1_0,
/*8866*/          OPC_EmitInteger, MVT::i32, 0, 
/*8869*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*8881*/          OPC_EmitInteger, MVT::i32, 0, 
/*8884*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*8896*/          OPC_EmitInteger, MVT::i32, 1, 
/*8899*/          OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*8902*/          OPC_EmitInteger, MVT::i32, 0, 
/*8905*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_AND_RET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 9/*#Ops*/, 1, 3, 4, 2, 5, 6, 7, 8, 9, 
                  // Src: (atomic_load_and:i32 i32:i32:$src0, i32:i32:$src1)<<P:Predicate_atomic_load_and_local>> - Complexity = 4
                  // Dst: (LDS_AND_RET:i32 i32:i32:$src0, i32:i32:$src1)
/*8921*/        0, /*End of Scope*/
/*8922*/      0, /*End of Scope*/
/*8923*/    /*SwitchOpcode*/ 76|128,1/*204*/, TARGET_VAL(ISD::ATOMIC_LOAD_OR),// ->9131
/*8927*/      OPC_RecordMemRef,
/*8928*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*8929*/      OPC_Scope, 45, /*->8976*/ // 3 children in Scope
/*8931*/        OPC_RecordChild1, // #1 = $MUBUFAddr64Atomic:srsrc:vaddr:soffset:offset:slc
/*8932*/        OPC_RecordChild2, // #2 = $vdata_in
/*8933*/        OPC_CheckPredicate, 97, // Predicate_atomic_or_global
/*8935*/        OPC_CheckType, MVT::i32,
/*8937*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*8939*/        OPC_Scope, 17, /*->8958*/ // 2 children in Scope
/*8941*/          OPC_CheckComplexPat, /*CP*/6, /*#*/1, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7
/*8944*/          OPC_EmitMergeInputChains1_0,
/*8945*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_OR_RTN_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (atomic_load_or:i32 (MUBUFAddr64Atomic:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_or_global>> - Complexity = 22
                  // Dst: (BUFFER_ATOMIC_OR_RTN_ADDR64:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*8958*/        /*Scope*/ 16, /*->8975*/
/*8959*/          OPC_CheckComplexPat, /*CP*/7, /*#*/1, // SelectMUBUFOffset:$ #3 #4 #5 #6
/*8962*/          OPC_EmitMergeInputChains1_0,
/*8963*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_OR_RTN_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 5/*#Ops*/, 2, 3, 4, 5, 6, 
                  // Src: (atomic_load_or:i32 (MUBUFOffsetAtomic:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_or_global>> - Complexity = 19
                  // Dst: (BUFFER_ATOMIC_OR_RTN_OFFSET:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*8975*/        0, /*End of Scope*/
/*8976*/      /*Scope*/ 57, /*->9034*/
/*8977*/        OPC_CaptureGlueInput,
/*8978*/        OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*8979*/        OPC_RecordChild2, // #2 = $value
/*8980*/        OPC_CheckPredicate, 98, // Predicate_si_atomic_load_or_local
/*8982*/        OPC_SwitchType /*2 cases */, 23, MVT::i32,// ->9008
/*8985*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*8987*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*8990*/          OPC_EmitMergeInputChains1_0,
/*8991*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*8994*/          OPC_EmitInteger, MVT::i1, 0, 
/*8997*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_OR_RTN_B32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_or_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i32:i32:$value)<<P:Predicate_si_atomic_load_or_local>> - Complexity = 13
                  // Dst: (DS_OR_RTN_B32:i32 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*9008*/        /*SwitchType*/ 23, MVT::i64,// ->9033
/*9010*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*9012*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*9015*/          OPC_EmitMergeInputChains1_0,
/*9016*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*9019*/          OPC_EmitInteger, MVT::i1, 0, 
/*9022*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_OR_RTN_B64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i64, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_or_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i64:i64:$value)<<P:Predicate_si_atomic_load_or_local>> - Complexity = 13
                  // Dst: (DS_OR_RTN_B64:i64 ?:i32:$ptr, ?:i64:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*9033*/        0, // EndSwitchType
/*9034*/      /*Scope*/ 95, /*->9130*/
/*9035*/        OPC_RecordChild1, // #1 = $addr
/*9036*/        OPC_CheckType, MVT::i32,
/*9038*/        OPC_Scope, 25, /*->9065*/ // 2 children in Scope
/*9040*/          OPC_CheckChild1Type, MVT::i64,
/*9042*/          OPC_RecordChild2, // #2 = $data
/*9043*/          OPC_CheckPredicate, 97, // Predicate_atomic_or_global
/*9045*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*9047*/          OPC_EmitMergeInputChains1_0,
/*9048*/          OPC_EmitInteger, MVT::i1, 0, 
/*9051*/          OPC_EmitInteger, MVT::i1, 0, 
/*9054*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_ATOMIC_OR_RTN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                  // Src: (atomic_load_or:i32 i64:i64:$addr, i32:i32:$data)<<P:Predicate_atomic_or_global>> - Complexity = 4
                  // Dst: (FLAT_ATOMIC_OR_RTN:i32 ?:i64:$addr, ?:i32:$data, 0:i1, 0:i1)
/*9065*/        /*Scope*/ 63, /*->9129*/
/*9066*/          OPC_CheckChild1Type, MVT::i32,
/*9068*/          OPC_RecordChild2, // #2 = $src1
/*9069*/          OPC_CheckPredicate, 99, // Predicate_atomic_load_or_local
/*9071*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*9073*/          OPC_EmitMergeInputChains1_0,
/*9074*/          OPC_EmitInteger, MVT::i32, 0, 
/*9077*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9089*/          OPC_EmitInteger, MVT::i32, 0, 
/*9092*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9104*/          OPC_EmitInteger, MVT::i32, 1, 
/*9107*/          OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*9110*/          OPC_EmitInteger, MVT::i32, 0, 
/*9113*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_OR_RET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 9/*#Ops*/, 1, 3, 4, 2, 5, 6, 7, 8, 9, 
                  // Src: (atomic_load_or:i32 i32:i32:$src0, i32:i32:$src1)<<P:Predicate_atomic_load_or_local>> - Complexity = 4
                  // Dst: (LDS_OR_RET:i32 i32:i32:$src0, i32:i32:$src1)
/*9129*/        0, /*End of Scope*/
/*9130*/      0, /*End of Scope*/
/*9131*/    /*SwitchOpcode*/ 76|128,1/*204*/, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),// ->9339
/*9135*/      OPC_RecordMemRef,
/*9136*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*9137*/      OPC_Scope, 45, /*->9184*/ // 3 children in Scope
/*9139*/        OPC_RecordChild1, // #1 = $MUBUFAddr64Atomic:srsrc:vaddr:soffset:offset:slc
/*9140*/        OPC_RecordChild2, // #2 = $vdata_in
/*9141*/        OPC_CheckPredicate, 100, // Predicate_atomic_xor_global
/*9143*/        OPC_CheckType, MVT::i32,
/*9145*/        OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*9147*/        OPC_Scope, 17, /*->9166*/ // 2 children in Scope
/*9149*/          OPC_CheckComplexPat, /*CP*/6, /*#*/1, // SelectMUBUFAddr64:$ #3 #4 #5 #6 #7
/*9152*/          OPC_EmitMergeInputChains1_0,
/*9153*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_XOR_RTN_ADDR64), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 6/*#Ops*/, 2, 3, 4, 5, 6, 7, 
                  // Src: (atomic_load_xor:i32 (MUBUFAddr64Atomic:iPTR v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_xor_global>> - Complexity = 22
                  // Dst: (BUFFER_ATOMIC_XOR_RTN_ADDR64:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i64:i64:$vaddr, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*9166*/        /*Scope*/ 16, /*->9183*/
/*9167*/          OPC_CheckComplexPat, /*CP*/7, /*#*/1, // SelectMUBUFOffset:$ #3 #4 #5 #6
/*9170*/          OPC_EmitMergeInputChains1_0,
/*9171*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BUFFER_ATOMIC_XOR_RTN_OFFSET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 5/*#Ops*/, 2, 3, 4, 5, 6, 
                  // Src: (atomic_load_xor:i32 (MUBUFOffsetAtomic:iPTR v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc), i32:i32:$vdata_in)<<P:Predicate_atomic_xor_global>> - Complexity = 19
                  // Dst: (BUFFER_ATOMIC_XOR_RTN_OFFSET:i32 i32:i32:$vdata_in, v4i32:v4i32:$srsrc, i32:i32:$soffset, i16:i16:$offset, i1:i1:$slc)
/*9183*/        0, /*End of Scope*/
/*9184*/      /*Scope*/ 57, /*->9242*/
/*9185*/        OPC_CaptureGlueInput,
/*9186*/        OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*9187*/        OPC_RecordChild2, // #2 = $value
/*9188*/        OPC_CheckPredicate, 101, // Predicate_si_atomic_load_xor_local
/*9190*/        OPC_SwitchType /*2 cases */, 23, MVT::i32,// ->9216
/*9193*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*9195*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*9198*/          OPC_EmitMergeInputChains1_0,
/*9199*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*9202*/          OPC_EmitInteger, MVT::i1, 0, 
/*9205*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_XOR_RTN_B32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_xor_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i32:i32:$value)<<P:Predicate_si_atomic_load_xor_local>> - Complexity = 13
                  // Dst: (DS_XOR_RTN_B32:i32 ?:i32:$ptr, ?:i32:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*9216*/        /*SwitchType*/ 23, MVT::i64,// ->9241
/*9218*/          OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*9220*/          OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #3 #4
/*9223*/          OPC_EmitMergeInputChains1_0,
/*9224*/          OPC_EmitNodeXForm, 0, 4, // as_i16imm
/*9227*/          OPC_EmitInteger, MVT::i1, 0, 
/*9230*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_XOR_RTN_B64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i64, 4/*#Ops*/, 3, 2, 5, 6, 
                  // Src: (si_atomic_load_xor_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i64:i64:$value)<<P:Predicate_si_atomic_load_xor_local>> - Complexity = 13
                  // Dst: (DS_XOR_RTN_B64:i64 ?:i32:$ptr, ?:i64:$value, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*9241*/        0, // EndSwitchType
/*9242*/      /*Scope*/ 95, /*->9338*/
/*9243*/        OPC_RecordChild1, // #1 = $addr
/*9244*/        OPC_CheckType, MVT::i32,
/*9246*/        OPC_Scope, 25, /*->9273*/ // 2 children in Scope
/*9248*/          OPC_CheckChild1Type, MVT::i64,
/*9250*/          OPC_RecordChild2, // #2 = $data
/*9251*/          OPC_CheckPredicate, 100, // Predicate_atomic_xor_global
/*9253*/          OPC_CheckPatternPredicate, 6, // (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
/*9255*/          OPC_EmitMergeInputChains1_0,
/*9256*/          OPC_EmitInteger, MVT::i1, 0, 
/*9259*/          OPC_EmitInteger, MVT::i1, 0, 
/*9262*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::FLAT_ATOMIC_XOR_RTN), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 4/*#Ops*/, 1, 2, 3, 4, 
                  // Src: (atomic_load_xor:i32 i64:i64:$addr, i32:i32:$data)<<P:Predicate_atomic_xor_global>> - Complexity = 4
                  // Dst: (FLAT_ATOMIC_XOR_RTN:i32 ?:i64:$addr, ?:i32:$data, 0:i1, 0:i1)
/*9273*/        /*Scope*/ 63, /*->9337*/
/*9274*/          OPC_CheckChild1Type, MVT::i32,
/*9276*/          OPC_RecordChild2, // #2 = $src1
/*9277*/          OPC_CheckPredicate, 102, // Predicate_atomic_load_xor_local
/*9279*/          OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*9281*/          OPC_EmitMergeInputChains1_0,
/*9282*/          OPC_EmitInteger, MVT::i32, 0, 
/*9285*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9297*/          OPC_EmitInteger, MVT::i32, 0, 
/*9300*/          OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9312*/          OPC_EmitInteger, MVT::i32, 1, 
/*9315*/          OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*9318*/          OPC_EmitInteger, MVT::i32, 0, 
/*9321*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_XOR_RET), 0|OPFL_Chain|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 9/*#Ops*/, 1, 3, 4, 2, 5, 6, 7, 8, 9, 
                  // Src: (atomic_load_xor:i32 i32:i32:$src0, i32:i32:$src1)<<P:Predicate_atomic_load_xor_local>> - Complexity = 4
                  // Dst: (LDS_XOR_RET:i32 i32:i32:$src0, i32:i32:$src1)
/*9337*/        0, /*End of Scope*/
/*9338*/      0, /*End of Scope*/
/*9339*/    /*SwitchOpcode*/ 6|128,1/*134*/, TARGET_VAL(AMDGPUISD::EXPORT),// ->9477
/*9343*/      OPC_RecordNode, // #0 = 'EXPORT' chained node
/*9344*/      OPC_RecordChild1, // #1 = $src
/*9345*/      OPC_CheckChild1Type, MVT::v4f32,
/*9347*/      OPC_RecordChild2, // #2 = $base
/*9348*/      OPC_MoveChild, 2,
/*9350*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9353*/      OPC_CheckType, MVT::i32,
/*9355*/      OPC_MoveParent,
/*9356*/      OPC_RecordChild3, // #3 = $type
/*9357*/      OPC_MoveChild, 3,
/*9359*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9362*/      OPC_CheckType, MVT::i32,
/*9364*/      OPC_MoveParent,
/*9365*/      OPC_RecordChild4, // #4 = $swz_x
/*9366*/      OPC_MoveChild, 4,
/*9368*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9371*/      OPC_CheckType, MVT::i32,
/*9373*/      OPC_MoveParent,
/*9374*/      OPC_RecordChild5, // #5 = $swz_y
/*9375*/      OPC_MoveChild, 5,
/*9377*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9380*/      OPC_CheckType, MVT::i32,
/*9382*/      OPC_MoveParent,
/*9383*/      OPC_RecordChild6, // #6 = $swz_z
/*9384*/      OPC_MoveChild, 6,
/*9386*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9389*/      OPC_CheckType, MVT::i32,
/*9391*/      OPC_MoveParent,
/*9392*/      OPC_RecordChild7, // #7 = $swz_w
/*9393*/      OPC_MoveChild, 7,
/*9395*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*9398*/      OPC_CheckType, MVT::i32,
/*9400*/      OPC_MoveParent,
/*9401*/      OPC_Scope, 36, /*->9439*/ // 2 children in Scope
/*9403*/        OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*9405*/        OPC_EmitMergeInputChains1_0,
/*9406*/        OPC_EmitConvertToTarget, 3,
/*9408*/        OPC_EmitConvertToTarget, 2,
/*9410*/        OPC_EmitConvertToTarget, 4,
/*9412*/        OPC_EmitConvertToTarget, 5,
/*9414*/        OPC_EmitConvertToTarget, 6,
/*9416*/        OPC_EmitConvertToTarget, 7,
/*9418*/        OPC_EmitInteger, MVT::i32, 39, 
/*9421*/        OPC_EmitInteger, MVT::i32, 0, 
/*9424*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_ExportSwz), 0|OPFL_Chain,
                    0/*#VTs*/, 9/*#Ops*/, 1, 8, 9, 10, 11, 12, 13, 14, 15, 
                // Src: (EXPORT R600_Reg128:v4f32:$src, (imm:i32):$base, (imm:i32):$type, (imm:i32):$swz_x, (imm:i32):$swz_y, (imm:i32):$swz_z, (imm:i32):$swz_w) - Complexity = 21
                // Dst: (R600_ExportSwz R600_Reg128:v4f32:$src, (imm:i32):$type, (imm:i32):$base, (imm:i32):$swz_x, (imm:i32):$swz_y, (imm:i32):$swz_z, (imm:i32):$swz_w, 39:i32, 0:i32)
/*9439*/      /*Scope*/ 36, /*->9476*/
/*9440*/        OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*9442*/        OPC_EmitMergeInputChains1_0,
/*9443*/        OPC_EmitConvertToTarget, 3,
/*9445*/        OPC_EmitConvertToTarget, 2,
/*9447*/        OPC_EmitConvertToTarget, 4,
/*9449*/        OPC_EmitConvertToTarget, 5,
/*9451*/        OPC_EmitConvertToTarget, 6,
/*9453*/        OPC_EmitConvertToTarget, 7,
/*9455*/        OPC_EmitInteger, MVT::i32, 83, 
/*9458*/        OPC_EmitInteger, MVT::i32, 0, 
/*9461*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::EG_ExportSwz), 0|OPFL_Chain,
                    0/*#VTs*/, 9/*#Ops*/, 1, 8, 9, 10, 11, 12, 13, 14, 15, 
                // Src: (EXPORT R600_Reg128:v4f32:$src, (imm:i32):$base, (imm:i32):$type, (imm:i32):$swz_x, (imm:i32):$swz_y, (imm:i32):$swz_z, (imm:i32):$swz_w) - Complexity = 21
                // Dst: (EG_ExportSwz R600_Reg128:v4f32:$src, (imm:i32):$type, (imm:i32):$base, (imm:i32):$swz_x, (imm:i32):$swz_y, (imm:i32):$swz_z, (imm:i32):$swz_w, 83:i32, 0:i32)
/*9476*/      0, /*End of Scope*/
/*9477*/    /*SwitchOpcode*/ 33|128,2/*289*/, TARGET_VAL(ISD::SHL),// ->9770
/*9481*/      OPC_Scope, 44, /*->9527*/ // 2 children in Scope
/*9483*/        OPC_MoveChild, 0,
/*9485*/        OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*9488*/        OPC_MoveChild, 0,
/*9490*/        OPC_CheckOpcode, TARGET_VAL(ISD::SHL),
/*9493*/        OPC_CheckChild0Integer, 1, 
/*9495*/        OPC_RecordChild1, // #0 = $a
/*9496*/        OPC_CheckChild1Type, MVT::i32,
/*9498*/        OPC_MoveParent,
/*9499*/        OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9510*/        OPC_MoveParent,
/*9511*/        OPC_RecordChild1, // #1 = $b
/*9512*/        OPC_CheckChild1Type, MVT::i32,
/*9514*/        OPC_CheckType, MVT::i32,
/*9516*/        OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*9518*/        OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_BFM_B32), 0,
                    1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (shl:i32 (add:i32 (shl:i32 1:i32, i32:i32:$a), -1:i32), i32:i32:$b) - Complexity = 19
                // Dst: (S_BFM_B32:i32 ?:i32:$a, ?:i32:$b)
/*9527*/      /*Scope*/ 112|128,1/*240*/, /*->9769*/
/*9529*/        OPC_RecordChild0, // #0 = $src0
/*9530*/        OPC_RecordChild1, // #1 = $src1
/*9531*/        OPC_CheckChild1Type, MVT::i32,
/*9533*/        OPC_SwitchType /*2 cases */, 90|128,1/*218*/, MVT::i32,// ->9755
/*9537*/          OPC_Scope, 11, /*->9550*/ // 3 children in Scope
/*9539*/            OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*9541*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LSHL_B32), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (shl:i32 i32:i32:$src0, i32:i32:$src1) - Complexity = 4
                    // Dst: (S_LSHL_B32:i32 i32:i32:$src0, i32:i32:$src1)
/*9550*/          /*Scope*/ 101, /*->9652*/
/*9551*/            OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*9553*/            OPC_EmitInteger, MVT::i32, 0, 
/*9556*/            OPC_EmitInteger, MVT::i32, 0, 
/*9559*/            OPC_EmitInteger, MVT::i32, 1, 
/*9562*/            OPC_EmitInteger, MVT::i32, 0, 
/*9565*/            OPC_EmitInteger, MVT::i32, 0, 
/*9568*/            OPC_EmitInteger, MVT::i32, 0, 
/*9571*/            OPC_EmitInteger, MVT::i32, 0, 
/*9574*/            OPC_EmitInteger, MVT::i32, 0, 
/*9577*/            OPC_EmitInteger, MVT::i32, 0, 
/*9580*/            OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9592*/            OPC_EmitInteger, MVT::i32, 0, 
/*9595*/            OPC_EmitInteger, MVT::i32, 0, 
/*9598*/            OPC_EmitInteger, MVT::i32, 0, 
/*9601*/            OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9613*/            OPC_EmitInteger, MVT::i32, 1, 
/*9616*/            OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*9619*/            OPC_EmitInteger, MVT::i32, 0, 
/*9622*/            OPC_EmitInteger, MVT::i32, 0, 
/*9625*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LSHL_r600), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                    // Src: (shl:i32 R600_Reg32:i32:$src0, R600_Reg32:i32:$src1) - Complexity = 3
                    // Dst: (LSHL_r600:i32 R600_Reg32:i32:$src0, R600_Reg32:i32:$src1)
/*9652*/          /*Scope*/ 101, /*->9754*/
/*9653*/            OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*9655*/            OPC_EmitInteger, MVT::i32, 0, 
/*9658*/            OPC_EmitInteger, MVT::i32, 0, 
/*9661*/            OPC_EmitInteger, MVT::i32, 1, 
/*9664*/            OPC_EmitInteger, MVT::i32, 0, 
/*9667*/            OPC_EmitInteger, MVT::i32, 0, 
/*9670*/            OPC_EmitInteger, MVT::i32, 0, 
/*9673*/            OPC_EmitInteger, MVT::i32, 0, 
/*9676*/            OPC_EmitInteger, MVT::i32, 0, 
/*9679*/            OPC_EmitInteger, MVT::i32, 0, 
/*9682*/            OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9694*/            OPC_EmitInteger, MVT::i32, 0, 
/*9697*/            OPC_EmitInteger, MVT::i32, 0, 
/*9700*/            OPC_EmitInteger, MVT::i32, 0, 
/*9703*/            OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9715*/            OPC_EmitInteger, MVT::i32, 1, 
/*9718*/            OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*9721*/            OPC_EmitInteger, MVT::i32, 0, 
/*9724*/            OPC_EmitInteger, MVT::i32, 0, 
/*9727*/            OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LSHL_eg), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                    // Src: (shl:i32 R600_Reg32:i32:$src0, R600_Reg32:i32:$src1) - Complexity = 3
                    // Dst: (LSHL_eg:i32 R600_Reg32:i32:$src0, R600_Reg32:i32:$src1)
/*9754*/          0, /*End of Scope*/
/*9755*/        /*SwitchType*/ 11, MVT::i64,// ->9768
/*9757*/          OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*9759*/          OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_LSHL_B64), 0,
                      1/*#VTs*/, MVT::i64, 2/*#Ops*/, 0, 1, 
                  // Src: (shl:i64 i64:i64:$src0, i32:i32:$src1) - Complexity = 4
                  // Dst: (S_LSHL_B64:i64 i64:i64:$src0, i32:i32:$src1)
/*9768*/        0, // EndSwitchType
/*9769*/      0, /*End of Scope*/
/*9770*/    /*SwitchOpcode*/ 89|128,40/*5209*/, TARGET_VAL(ISD::OR),// ->14983
/*9774*/      OPC_Scope, 63|128,39/*5055*/, /*->14832*/ // 2 children in Scope
/*9777*/        OPC_MoveChild, 0,
/*9779*/        OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*9782*/        OPC_Scope, 71|128,2/*327*/, /*->10112*/ // 8 children in Scope
/*9785*/          OPC_RecordChild0, // #0 = $y
/*9786*/          OPC_Scope, 1|128,2/*257*/, /*->10046*/ // 2 children in Scope
/*9789*/            OPC_RecordChild1, // #1 = $x
/*9790*/            OPC_MoveParent,
/*9791*/            OPC_MoveChild, 1,
/*9793*/            OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*9796*/            OPC_Scope, 10|128,1/*138*/, /*->9937*/ // 4 children in Scope
/*9799*/              OPC_RecordChild0, // #2 = $z
/*9800*/              OPC_MoveChild, 1,
/*9802*/              OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*9805*/              OPC_CheckChild0Same, 1,
/*9807*/              OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9818*/              OPC_MoveParent,
/*9819*/              OPC_MoveParent,
/*9820*/              OPC_CheckType, MVT::i32,
/*9822*/              OPC_Scope, 99, /*->9923*/ // 2 children in Scope
/*9824*/                OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*9826*/                OPC_EmitInteger, MVT::i32, 0, 
/*9829*/                OPC_EmitInteger, MVT::i32, 0, 
/*9832*/                OPC_EmitInteger, MVT::i32, 0, 
/*9835*/                OPC_EmitInteger, MVT::i32, 0, 
/*9838*/                OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9850*/                OPC_EmitInteger, MVT::i32, 0, 
/*9853*/                OPC_EmitInteger, MVT::i32, 0, 
/*9856*/                OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9868*/                OPC_EmitInteger, MVT::i32, 0, 
/*9871*/                OPC_EmitInteger, MVT::i32, 0, 
/*9874*/                OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9886*/                OPC_EmitInteger, MVT::i32, 1, 
/*9889*/                OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*9892*/                OPC_EmitInteger, MVT::i32, 0, 
/*9895*/                OPC_EmitInteger, MVT::i32, 0, 
/*9898*/                OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                            1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 1, 5, 6, 7, 0, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                        // Src: (or:i32 (and:i32 i32:i32:$y, i32:i32:$x), (and:i32 i32:i32:$z, (xor:i32 i32:i32:$x, -1:i32))) - Complexity = 17
                        // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*9923*/              /*Scope*/ 12, /*->9936*/
/*9924*/                OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*9926*/                OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                            1/*#VTs*/, MVT::i32, 3/*#Ops*/, 1, 0, 2, 
                        // Src: (or:i32 (and:i32 i32:i32:$y, i32:i32:$x), (and:i32 i32:i32:$z, (xor:i32 i32:i32:$x, -1:i32))) - Complexity = 17
                        // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*9936*/              0, /*End of Scope*/
/*9937*/            /*Scope*/ 35, /*->9973*/
/*9938*/              OPC_MoveChild, 0,
/*9940*/              OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*9943*/              OPC_CheckChild0Same, 1,
/*9945*/              OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9956*/              OPC_MoveParent,
/*9957*/              OPC_RecordChild1, // #2 = $z
/*9958*/              OPC_MoveParent,
/*9959*/              OPC_CheckType, MVT::i32,
/*9961*/              OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*9963*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                          1/*#VTs*/, MVT::i32, 3/*#Ops*/, 1, 0, 2, 
                      // Src: (or:i32 (and:i32 i32:i32:$y, i32:i32:$x), (and:i32 (xor:i32 i32:i32:$x, -1:i32), i32:i32:$z)) - Complexity = 17
                      // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*9973*/            /*Scope*/ 35, /*->10009*/
/*9974*/              OPC_RecordChild0, // #2 = $z
/*9975*/              OPC_MoveChild, 1,
/*9977*/              OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*9980*/              OPC_CheckChild0Same, 0,
/*9982*/              OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*9993*/              OPC_MoveParent,
/*9994*/              OPC_MoveParent,
/*9995*/              OPC_CheckType, MVT::i32,
/*9997*/              OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*9999*/              OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                          1/*#VTs*/, MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                      // Src: (or:i32 (and:i32 i32:i32:$x, i32:i32:$y), (and:i32 i32:i32:$z, (xor:i32 i32:i32:$x, -1:i32))) - Complexity = 17
                      // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*10009*/           /*Scope*/ 35, /*->10045*/
/*10010*/             OPC_MoveChild, 0,
/*10012*/             OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*10015*/             OPC_CheckChild0Same, 0,
/*10017*/             OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10028*/             OPC_MoveParent,
/*10029*/             OPC_RecordChild1, // #2 = $z
/*10030*/             OPC_MoveParent,
/*10031*/             OPC_CheckType, MVT::i32,
/*10033*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*10035*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                          1/*#VTs*/, MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                      // Src: (or:i32 (and:i32 i32:i32:$x, i32:i32:$y), (and:i32 (xor:i32 i32:i32:$x, -1:i32), i32:i32:$z)) - Complexity = 17
                      // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*10045*/           0, /*End of Scope*/
/*10046*/         /*Scope*/ 64, /*->10111*/
/*10047*/           OPC_MoveChild, 1,
/*10049*/           OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*10052*/           OPC_RecordChild0, // #1 = $x
/*10053*/           OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10064*/           OPC_MoveParent,
/*10065*/           OPC_MoveParent,
/*10066*/           OPC_MoveChild, 1,
/*10068*/           OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*10071*/           OPC_Scope, 18, /*->10091*/ // 2 children in Scope
/*10073*/             OPC_RecordChild0, // #2 = $y
/*10074*/             OPC_CheckChild1Same, 1,
/*10076*/             OPC_MoveParent,
/*10077*/             OPC_CheckType, MVT::i32,
/*10079*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*10081*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                          1/*#VTs*/, MVT::i32, 3/*#Ops*/, 1, 2, 0, 
                      // Src: (or:i32 (and:i32 i32:i32:$z, (xor:i32 i32:i32:$x, -1:i32)), (and:i32 i32:i32:$y, i32:i32:$x)) - Complexity = 17
                      // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*10091*/           /*Scope*/ 18, /*->10110*/
/*10092*/             OPC_CheckChild0Same, 1,
/*10094*/             OPC_RecordChild1, // #2 = $y
/*10095*/             OPC_MoveParent,
/*10096*/             OPC_CheckType, MVT::i32,
/*10098*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*10100*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                          1/*#VTs*/, MVT::i32, 3/*#Ops*/, 1, 2, 0, 
                      // Src: (or:i32 (and:i32 i32:i32:$z, (xor:i32 i32:i32:$x, -1:i32)), (and:i32 i32:i32:$x, i32:i32:$y)) - Complexity = 17
                      // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*10110*/           0, /*End of Scope*/
/*10111*/         0, /*End of Scope*/
/*10112*/       /*Scope*/ 65, /*->10178*/
/*10113*/         OPC_MoveChild, 0,
/*10115*/         OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*10118*/         OPC_RecordChild0, // #0 = $x
/*10119*/         OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10130*/         OPC_MoveParent,
/*10131*/         OPC_RecordChild1, // #1 = $z
/*10132*/         OPC_MoveParent,
/*10133*/         OPC_MoveChild, 1,
/*10135*/         OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*10138*/         OPC_Scope, 18, /*->10158*/ // 2 children in Scope
/*10140*/           OPC_RecordChild0, // #2 = $y
/*10141*/           OPC_CheckChild1Same, 0,
/*10143*/           OPC_MoveParent,
/*10144*/           OPC_CheckType, MVT::i32,
/*10146*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*10148*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 0, 2, 1, 
                    // Src: (or:i32 (and:i32 (xor:i32 i32:i32:$x, -1:i32), i32:i32:$z), (and:i32 i32:i32:$y, i32:i32:$x)) - Complexity = 17
                    // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*10158*/         /*Scope*/ 18, /*->10177*/
/*10159*/           OPC_CheckChild0Same, 0,
/*10161*/           OPC_RecordChild1, // #2 = $y
/*10162*/           OPC_MoveParent,
/*10163*/           OPC_CheckType, MVT::i32,
/*10165*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*10167*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 0, 2, 1, 
                    // Src: (or:i32 (and:i32 (xor:i32 i32:i32:$x, -1:i32), i32:i32:$z), (and:i32 i32:i32:$x, i32:i32:$y)) - Complexity = 17
                    // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*10177*/         0, /*End of Scope*/
/*10178*/       /*Scope*/ 111|128,4/*623*/, /*->10803*/
/*10180*/         OPC_RecordChild0, // #0 = $y
/*10181*/         OPC_Scope, 122|128,2/*378*/, /*->10562*/ // 2 children in Scope
/*10184*/           OPC_RecordChild1, // #1 = $x
/*10185*/           OPC_MoveParent,
/*10186*/           OPC_MoveChild, 1,
/*10188*/           OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*10191*/           OPC_Scope, 122, /*->10315*/ // 3 children in Scope
/*10193*/             OPC_MoveChild, 0,
/*10195*/             OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*10198*/             OPC_CheckChild0Same, 1,
/*10200*/             OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10211*/             OPC_MoveParent,
/*10212*/             OPC_RecordChild1, // #2 = $z
/*10213*/             OPC_MoveParent,
/*10214*/             OPC_CheckType, MVT::i32,
/*10216*/             OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*10218*/             OPC_EmitInteger, MVT::i32, 0, 
/*10221*/             OPC_EmitInteger, MVT::i32, 0, 
/*10224*/             OPC_EmitInteger, MVT::i32, 0, 
/*10227*/             OPC_EmitInteger, MVT::i32, 0, 
/*10230*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10242*/             OPC_EmitInteger, MVT::i32, 0, 
/*10245*/             OPC_EmitInteger, MVT::i32, 0, 
/*10248*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10260*/             OPC_EmitInteger, MVT::i32, 0, 
/*10263*/             OPC_EmitInteger, MVT::i32, 0, 
/*10266*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10278*/             OPC_EmitInteger, MVT::i32, 1, 
/*10281*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*10284*/             OPC_EmitInteger, MVT::i32, 0, 
/*10287*/             OPC_EmitInteger, MVT::i32, 0, 
/*10290*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 1, 5, 6, 7, 0, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                      // Src: (or:i32 (and:i32 i32:i32:$y, i32:i32:$x), (and:i32 (xor:i32 i32:i32:$x, -1:i32), i32:i32:$z)) - Complexity = 17
                      // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*10315*/           /*Scope*/ 122, /*->10438*/
/*10316*/             OPC_RecordChild0, // #2 = $z
/*10317*/             OPC_MoveChild, 1,
/*10319*/             OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*10322*/             OPC_CheckChild0Same, 0,
/*10324*/             OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10335*/             OPC_MoveParent,
/*10336*/             OPC_MoveParent,
/*10337*/             OPC_CheckType, MVT::i32,
/*10339*/             OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*10341*/             OPC_EmitInteger, MVT::i32, 0, 
/*10344*/             OPC_EmitInteger, MVT::i32, 0, 
/*10347*/             OPC_EmitInteger, MVT::i32, 0, 
/*10350*/             OPC_EmitInteger, MVT::i32, 0, 
/*10353*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10365*/             OPC_EmitInteger, MVT::i32, 0, 
/*10368*/             OPC_EmitInteger, MVT::i32, 0, 
/*10371*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10383*/             OPC_EmitInteger, MVT::i32, 0, 
/*10386*/             OPC_EmitInteger, MVT::i32, 0, 
/*10389*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10401*/             OPC_EmitInteger, MVT::i32, 1, 
/*10404*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*10407*/             OPC_EmitInteger, MVT::i32, 0, 
/*10410*/             OPC_EmitInteger, MVT::i32, 0, 
/*10413*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                      // Src: (or:i32 (and:i32 i32:i32:$x, i32:i32:$y), (and:i32 i32:i32:$z, (xor:i32 i32:i32:$x, -1:i32))) - Complexity = 17
                      // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*10438*/           /*Scope*/ 122, /*->10561*/
/*10439*/             OPC_MoveChild, 0,
/*10441*/             OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*10444*/             OPC_CheckChild0Same, 0,
/*10446*/             OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10457*/             OPC_MoveParent,
/*10458*/             OPC_RecordChild1, // #2 = $z
/*10459*/             OPC_MoveParent,
/*10460*/             OPC_CheckType, MVT::i32,
/*10462*/             OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*10464*/             OPC_EmitInteger, MVT::i32, 0, 
/*10467*/             OPC_EmitInteger, MVT::i32, 0, 
/*10470*/             OPC_EmitInteger, MVT::i32, 0, 
/*10473*/             OPC_EmitInteger, MVT::i32, 0, 
/*10476*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10488*/             OPC_EmitInteger, MVT::i32, 0, 
/*10491*/             OPC_EmitInteger, MVT::i32, 0, 
/*10494*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10506*/             OPC_EmitInteger, MVT::i32, 0, 
/*10509*/             OPC_EmitInteger, MVT::i32, 0, 
/*10512*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10524*/             OPC_EmitInteger, MVT::i32, 1, 
/*10527*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*10530*/             OPC_EmitInteger, MVT::i32, 0, 
/*10533*/             OPC_EmitInteger, MVT::i32, 0, 
/*10536*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                      // Src: (or:i32 (and:i32 i32:i32:$x, i32:i32:$y), (and:i32 (xor:i32 i32:i32:$x, -1:i32), i32:i32:$z)) - Complexity = 17
                      // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*10561*/           0, /*End of Scope*/
/*10562*/         /*Scope*/ 110|128,1/*238*/, /*->10802*/
/*10564*/           OPC_MoveChild, 1,
/*10566*/           OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*10569*/           OPC_RecordChild0, // #1 = $x
/*10570*/           OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10581*/           OPC_MoveParent,
/*10582*/           OPC_MoveParent,
/*10583*/           OPC_MoveChild, 1,
/*10585*/           OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*10588*/           OPC_Scope, 105, /*->10695*/ // 2 children in Scope
/*10590*/             OPC_RecordChild0, // #2 = $y
/*10591*/             OPC_CheckChild1Same, 1,
/*10593*/             OPC_MoveParent,
/*10594*/             OPC_CheckType, MVT::i32,
/*10596*/             OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*10598*/             OPC_EmitInteger, MVT::i32, 0, 
/*10601*/             OPC_EmitInteger, MVT::i32, 0, 
/*10604*/             OPC_EmitInteger, MVT::i32, 0, 
/*10607*/             OPC_EmitInteger, MVT::i32, 0, 
/*10610*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10622*/             OPC_EmitInteger, MVT::i32, 0, 
/*10625*/             OPC_EmitInteger, MVT::i32, 0, 
/*10628*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10640*/             OPC_EmitInteger, MVT::i32, 0, 
/*10643*/             OPC_EmitInteger, MVT::i32, 0, 
/*10646*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10658*/             OPC_EmitInteger, MVT::i32, 1, 
/*10661*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*10664*/             OPC_EmitInteger, MVT::i32, 0, 
/*10667*/             OPC_EmitInteger, MVT::i32, 0, 
/*10670*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 1, 5, 6, 7, 2, 8, 9, 10, 0, 11, 12, 13, 14, 15, 16, 17, 
                      // Src: (or:i32 (and:i32 i32:i32:$z, (xor:i32 i32:i32:$x, -1:i32)), (and:i32 i32:i32:$y, i32:i32:$x)) - Complexity = 17
                      // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*10695*/           /*Scope*/ 105, /*->10801*/
/*10696*/             OPC_CheckChild0Same, 1,
/*10698*/             OPC_RecordChild1, // #2 = $y
/*10699*/             OPC_MoveParent,
/*10700*/             OPC_CheckType, MVT::i32,
/*10702*/             OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*10704*/             OPC_EmitInteger, MVT::i32, 0, 
/*10707*/             OPC_EmitInteger, MVT::i32, 0, 
/*10710*/             OPC_EmitInteger, MVT::i32, 0, 
/*10713*/             OPC_EmitInteger, MVT::i32, 0, 
/*10716*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10728*/             OPC_EmitInteger, MVT::i32, 0, 
/*10731*/             OPC_EmitInteger, MVT::i32, 0, 
/*10734*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10746*/             OPC_EmitInteger, MVT::i32, 0, 
/*10749*/             OPC_EmitInteger, MVT::i32, 0, 
/*10752*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10764*/             OPC_EmitInteger, MVT::i32, 1, 
/*10767*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*10770*/             OPC_EmitInteger, MVT::i32, 0, 
/*10773*/             OPC_EmitInteger, MVT::i32, 0, 
/*10776*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 1, 5, 6, 7, 2, 8, 9, 10, 0, 11, 12, 13, 14, 15, 16, 17, 
                      // Src: (or:i32 (and:i32 i32:i32:$z, (xor:i32 i32:i32:$x, -1:i32)), (and:i32 i32:i32:$x, i32:i32:$y)) - Complexity = 17
                      // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*10801*/           0, /*End of Scope*/
/*10802*/         0, /*End of Scope*/
/*10803*/       /*Scope*/ 111|128,1/*239*/, /*->11044*/
/*10805*/         OPC_MoveChild, 0,
/*10807*/         OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*10810*/         OPC_RecordChild0, // #0 = $x
/*10811*/         OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10822*/         OPC_MoveParent,
/*10823*/         OPC_RecordChild1, // #1 = $z
/*10824*/         OPC_MoveParent,
/*10825*/         OPC_MoveChild, 1,
/*10827*/         OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*10830*/         OPC_Scope, 105, /*->10937*/ // 2 children in Scope
/*10832*/           OPC_RecordChild0, // #2 = $y
/*10833*/           OPC_CheckChild1Same, 0,
/*10835*/           OPC_MoveParent,
/*10836*/           OPC_CheckType, MVT::i32,
/*10838*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*10840*/           OPC_EmitInteger, MVT::i32, 0, 
/*10843*/           OPC_EmitInteger, MVT::i32, 0, 
/*10846*/           OPC_EmitInteger, MVT::i32, 0, 
/*10849*/           OPC_EmitInteger, MVT::i32, 0, 
/*10852*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10864*/           OPC_EmitInteger, MVT::i32, 0, 
/*10867*/           OPC_EmitInteger, MVT::i32, 0, 
/*10870*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10882*/           OPC_EmitInteger, MVT::i32, 0, 
/*10885*/           OPC_EmitInteger, MVT::i32, 0, 
/*10888*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10900*/           OPC_EmitInteger, MVT::i32, 1, 
/*10903*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*10906*/           OPC_EmitInteger, MVT::i32, 0, 
/*10909*/           OPC_EmitInteger, MVT::i32, 0, 
/*10912*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                        1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 2, 8, 9, 10, 1, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (or:i32 (and:i32 (xor:i32 i32:i32:$x, -1:i32), i32:i32:$z), (and:i32 i32:i32:$y, i32:i32:$x)) - Complexity = 17
                    // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*10937*/         /*Scope*/ 105, /*->11043*/
/*10938*/           OPC_CheckChild0Same, 0,
/*10940*/           OPC_RecordChild1, // #2 = $y
/*10941*/           OPC_MoveParent,
/*10942*/           OPC_CheckType, MVT::i32,
/*10944*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*10946*/           OPC_EmitInteger, MVT::i32, 0, 
/*10949*/           OPC_EmitInteger, MVT::i32, 0, 
/*10952*/           OPC_EmitInteger, MVT::i32, 0, 
/*10955*/           OPC_EmitInteger, MVT::i32, 0, 
/*10958*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10970*/           OPC_EmitInteger, MVT::i32, 0, 
/*10973*/           OPC_EmitInteger, MVT::i32, 0, 
/*10976*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*10988*/           OPC_EmitInteger, MVT::i32, 0, 
/*10991*/           OPC_EmitInteger, MVT::i32, 0, 
/*10994*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*11006*/           OPC_EmitInteger, MVT::i32, 1, 
/*11009*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*11012*/           OPC_EmitInteger, MVT::i32, 0, 
/*11015*/           OPC_EmitInteger, MVT::i32, 0, 
/*11018*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                        1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 2, 8, 9, 10, 1, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (or:i32 (and:i32 (xor:i32 i32:i32:$x, -1:i32), i32:i32:$z), (and:i32 i32:i32:$x, i32:i32:$y)) - Complexity = 17
                    // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*11043*/         0, /*End of Scope*/
/*11044*/       /*Scope*/ 112|128,4/*624*/, /*->11670*/
/*11046*/         OPC_RecordChild0, // #0 = $x
/*11047*/         OPC_Scope, 108|128,3/*492*/, /*->11542*/ // 2 children in Scope
/*11050*/           OPC_RecordChild1, // #1 = $z
/*11051*/           OPC_MoveParent,
/*11052*/           OPC_MoveChild, 1,
/*11054*/           OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*11057*/           OPC_Scope, 16|128,2/*272*/, /*->11332*/ // 4 children in Scope
/*11060*/             OPC_RecordChild0, // #2 = $y
/*11061*/             OPC_MoveChild, 1,
/*11063*/             OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*11066*/             OPC_Scope, 104|128,1/*232*/, /*->11301*/ // 2 children in Scope
/*11069*/               OPC_CheckChild0Same, 0,
/*11071*/               OPC_CheckChild1Same, 1,
/*11073*/               OPC_MoveParent,
/*11074*/               OPC_MoveParent,
/*11075*/               OPC_CheckType, MVT::i32,
/*11077*/               OPC_Scope, 70|128,1/*198*/, /*->11278*/ // 2 children in Scope
/*11080*/                 OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*11082*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11085*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11088*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11091*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11094*/                 OPC_EmitInteger, MVT::i32, 1, 
/*11097*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11100*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11103*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11106*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11109*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11112*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11115*/                 OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*11127*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11130*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11133*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11136*/                 OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*11148*/                 OPC_EmitInteger, MVT::i32, 1, 
/*11151*/                 OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*11154*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11157*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11160*/                 OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                              1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 0, 11, 12, 13, 14, 2, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*11187*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11190*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11193*/                 OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*11205*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11208*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11211*/                 OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*11223*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11226*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11229*/                 OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*11241*/                 OPC_EmitInteger, MVT::i32, 1, 
/*11244*/                 OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*11247*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11250*/                 OPC_EmitInteger, MVT::i32, 0, 
/*11253*/                 OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                              1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 1, 27, 28, 29, 2, 30, 31, 32, 33, 34, 35, 36, 
                          // Src: (or:i32 (and:i32 i32:i32:$x, i32:i32:$z), (and:i32 i32:i32:$y, (or:i32 i32:i32:$x, i32:i32:$z))) - Complexity = 12
                          // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11278*/               /*Scope*/ 21, /*->11300*/
/*11279*/                 OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11281*/                 OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                              1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 2,  // Results = #3
/*11290*/                 OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                              1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 1, 2, 
                          // Src: (or:i32 (and:i32 i32:i32:$x, i32:i32:$z), (and:i32 i32:i32:$y, (or:i32 i32:i32:$x, i32:i32:$z))) - Complexity = 12
                          // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11300*/               0, /*End of Scope*/
/*11301*/             /*Scope*/ 29, /*->11331*/
/*11302*/               OPC_CheckChild0Same, 1,
/*11304*/               OPC_CheckChild1Same, 0,
/*11306*/               OPC_MoveParent,
/*11307*/               OPC_MoveParent,
/*11308*/               OPC_CheckType, MVT::i32,
/*11310*/               OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11312*/               OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                            1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 2,  // Results = #3
/*11321*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                            1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 1, 2, 
                        // Src: (or:i32 (and:i32 i32:i32:$x, i32:i32:$z), (and:i32 i32:i32:$y, (or:i32 i32:i32:$z, i32:i32:$x))) - Complexity = 12
                        // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11331*/             0, /*End of Scope*/
/*11332*/           /*Scope*/ 69, /*->11402*/
/*11333*/             OPC_MoveChild, 0,
/*11335*/             OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*11338*/             OPC_Scope, 30, /*->11370*/ // 2 children in Scope
/*11340*/               OPC_CheckChild0Same, 0,
/*11342*/               OPC_CheckChild1Same, 1,
/*11344*/               OPC_MoveParent,
/*11345*/               OPC_RecordChild1, // #2 = $y
/*11346*/               OPC_MoveParent,
/*11347*/               OPC_CheckType, MVT::i32,
/*11349*/               OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11351*/               OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                            1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 2,  // Results = #3
/*11360*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                            1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 1, 2, 
                        // Src: (or:i32 (and:i32 i32:i32:$x, i32:i32:$z), (and:i32 (or:i32 i32:i32:$x, i32:i32:$z), i32:i32:$y)) - Complexity = 12
                        // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11370*/             /*Scope*/ 30, /*->11401*/
/*11371*/               OPC_CheckChild0Same, 1,
/*11373*/               OPC_CheckChild1Same, 0,
/*11375*/               OPC_MoveParent,
/*11376*/               OPC_RecordChild1, // #2 = $y
/*11377*/               OPC_MoveParent,
/*11378*/               OPC_CheckType, MVT::i32,
/*11380*/               OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11382*/               OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                            1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 2,  // Results = #3
/*11391*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                            1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 1, 2, 
                        // Src: (or:i32 (and:i32 i32:i32:$x, i32:i32:$z), (and:i32 (or:i32 i32:i32:$z, i32:i32:$x), i32:i32:$y)) - Complexity = 12
                        // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11401*/             0, /*End of Scope*/
/*11402*/           /*Scope*/ 68, /*->11471*/
/*11403*/             OPC_RecordChild0, // #2 = $y
/*11404*/             OPC_MoveChild, 1,
/*11406*/             OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*11409*/             OPC_Scope, 29, /*->11440*/ // 2 children in Scope
/*11411*/               OPC_CheckChild0Same, 1,
/*11413*/               OPC_CheckChild1Same, 0,
/*11415*/               OPC_MoveParent,
/*11416*/               OPC_MoveParent,
/*11417*/               OPC_CheckType, MVT::i32,
/*11419*/               OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11421*/               OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                            1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 2,  // Results = #3
/*11430*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                            1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 0, 2, 
                        // Src: (or:i32 (and:i32 i32:i32:$z, i32:i32:$x), (and:i32 i32:i32:$y, (or:i32 i32:i32:$x, i32:i32:$z))) - Complexity = 12
                        // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11440*/             /*Scope*/ 29, /*->11470*/
/*11441*/               OPC_CheckChild0Same, 0,
/*11443*/               OPC_CheckChild1Same, 1,
/*11445*/               OPC_MoveParent,
/*11446*/               OPC_MoveParent,
/*11447*/               OPC_CheckType, MVT::i32,
/*11449*/               OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11451*/               OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                            1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 2,  // Results = #3
/*11460*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                            1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 0, 2, 
                        // Src: (or:i32 (and:i32 i32:i32:$z, i32:i32:$x), (and:i32 i32:i32:$y, (or:i32 i32:i32:$z, i32:i32:$x))) - Complexity = 12
                        // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11470*/             0, /*End of Scope*/
/*11471*/           /*Scope*/ 69, /*->11541*/
/*11472*/             OPC_MoveChild, 0,
/*11474*/             OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*11477*/             OPC_Scope, 30, /*->11509*/ // 2 children in Scope
/*11479*/               OPC_CheckChild0Same, 1,
/*11481*/               OPC_CheckChild1Same, 0,
/*11483*/               OPC_MoveParent,
/*11484*/               OPC_RecordChild1, // #2 = $y
/*11485*/               OPC_MoveParent,
/*11486*/               OPC_CheckType, MVT::i32,
/*11488*/               OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11490*/               OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                            1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 2,  // Results = #3
/*11499*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                            1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 0, 2, 
                        // Src: (or:i32 (and:i32 i32:i32:$z, i32:i32:$x), (and:i32 (or:i32 i32:i32:$x, i32:i32:$z), i32:i32:$y)) - Complexity = 12
                        // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11509*/             /*Scope*/ 30, /*->11540*/
/*11510*/               OPC_CheckChild0Same, 0,
/*11512*/               OPC_CheckChild1Same, 1,
/*11514*/               OPC_MoveParent,
/*11515*/               OPC_RecordChild1, // #2 = $y
/*11516*/               OPC_MoveParent,
/*11517*/               OPC_CheckType, MVT::i32,
/*11519*/               OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11521*/               OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                            1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 2,  // Results = #3
/*11530*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                            1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 0, 2, 
                        // Src: (or:i32 (and:i32 i32:i32:$z, i32:i32:$x), (and:i32 (or:i32 i32:i32:$z, i32:i32:$x), i32:i32:$y)) - Complexity = 12
                        // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11540*/             0, /*End of Scope*/
/*11541*/           0, /*End of Scope*/
/*11542*/         /*Scope*/ 126, /*->11669*/
/*11543*/           OPC_MoveChild, 1,
/*11545*/           OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*11548*/           OPC_RecordChild0, // #1 = $x
/*11549*/           OPC_RecordChild1, // #2 = $z
/*11550*/           OPC_MoveParent,
/*11551*/           OPC_MoveParent,
/*11552*/           OPC_MoveChild, 1,
/*11554*/           OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*11557*/           OPC_Scope, 28, /*->11587*/ // 3 children in Scope
/*11559*/             OPC_CheckChild0Same, 1,
/*11561*/             OPC_CheckChild1Same, 2,
/*11563*/             OPC_MoveParent,
/*11564*/             OPC_CheckType, MVT::i32,
/*11566*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11568*/             OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 0,  // Results = #3
/*11577*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                          1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 2, 0, 
                      // Src: (or:i32 (and:i32 i32:i32:$y, (or:i32 i32:i32:$x, i32:i32:$z)), (and:i32 i32:i32:$x, i32:i32:$z)) - Complexity = 12
                      // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11587*/           /*Scope*/ 51, /*->11639*/
/*11588*/             OPC_CheckChild0Same, 2,
/*11590*/             OPC_CheckChild1Same, 1,
/*11592*/             OPC_MoveParent,
/*11593*/             OPC_CheckType, MVT::i32,
/*11595*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11597*/             OPC_Scope, 19, /*->11618*/ // 2 children in Scope
/*11599*/               OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                            1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 0,  // Results = #3
/*11608*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                            1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 2, 0, 
                        // Src: (or:i32 (and:i32 i32:i32:$y, (or:i32 i32:i32:$x, i32:i32:$z)), (and:i32 i32:i32:$z, i32:i32:$x)) - Complexity = 12
                        // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11618*/             /*Scope*/ 19, /*->11638*/
/*11619*/               OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                            1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 0,  // Results = #3
/*11628*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                            1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 1, 0, 
                        // Src: (or:i32 (and:i32 i32:i32:$y, (or:i32 i32:i32:$z, i32:i32:$x)), (and:i32 i32:i32:$x, i32:i32:$z)) - Complexity = 12
                        // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11638*/             0, /*End of Scope*/
/*11639*/           /*Scope*/ 28, /*->11668*/
/*11640*/             OPC_CheckChild0Same, 1,
/*11642*/             OPC_CheckChild1Same, 2,
/*11644*/             OPC_MoveParent,
/*11645*/             OPC_CheckType, MVT::i32,
/*11647*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11649*/             OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 2, 0,  // Results = #3
/*11658*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                          1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 1, 0, 
                      // Src: (or:i32 (and:i32 i32:i32:$y, (or:i32 i32:i32:$z, i32:i32:$x)), (and:i32 i32:i32:$z, i32:i32:$x)) - Complexity = 12
                      // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11668*/           0, /*End of Scope*/
/*11669*/         0, /*End of Scope*/
/*11670*/       /*Scope*/ 127, /*->11798*/
/*11671*/         OPC_MoveChild, 0,
/*11673*/         OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*11676*/         OPC_RecordChild0, // #0 = $x
/*11677*/         OPC_RecordChild1, // #1 = $z
/*11678*/         OPC_MoveParent,
/*11679*/         OPC_RecordChild1, // #2 = $y
/*11680*/         OPC_MoveParent,
/*11681*/         OPC_MoveChild, 1,
/*11683*/         OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*11686*/         OPC_Scope, 28, /*->11716*/ // 3 children in Scope
/*11688*/           OPC_CheckChild0Same, 0,
/*11690*/           OPC_CheckChild1Same, 1,
/*11692*/           OPC_MoveParent,
/*11693*/           OPC_CheckType, MVT::i32,
/*11695*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11697*/           OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 2,  // Results = #3
/*11706*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 1, 2, 
                    // Src: (or:i32 (and:i32 (or:i32 i32:i32:$x, i32:i32:$z), i32:i32:$y), (and:i32 i32:i32:$x, i32:i32:$z)) - Complexity = 12
                    // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11716*/         /*Scope*/ 51, /*->11768*/
/*11717*/           OPC_CheckChild0Same, 1,
/*11719*/           OPC_CheckChild1Same, 0,
/*11721*/           OPC_MoveParent,
/*11722*/           OPC_CheckType, MVT::i32,
/*11724*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11726*/           OPC_Scope, 19, /*->11747*/ // 2 children in Scope
/*11728*/             OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 2,  // Results = #3
/*11737*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                          1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 1, 2, 
                      // Src: (or:i32 (and:i32 (or:i32 i32:i32:$x, i32:i32:$z), i32:i32:$y), (and:i32 i32:i32:$z, i32:i32:$x)) - Complexity = 12
                      // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11747*/           /*Scope*/ 19, /*->11767*/
/*11748*/             OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 2,  // Results = #3
/*11757*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                          1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 0, 2, 
                      // Src: (or:i32 (and:i32 (or:i32 i32:i32:$z, i32:i32:$x), i32:i32:$y), (and:i32 i32:i32:$x, i32:i32:$z)) - Complexity = 12
                      // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11767*/           0, /*End of Scope*/
/*11768*/         /*Scope*/ 28, /*->11797*/
/*11769*/           OPC_CheckChild0Same, 0,
/*11771*/           OPC_CheckChild1Same, 1,
/*11773*/           OPC_MoveParent,
/*11774*/           OPC_CheckType, MVT::i32,
/*11776*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*11778*/           OPC_EmitNode, TARGET_VAL(AMDGPU::V_XOR_B32_e64), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 2,  // Results = #3
/*11787*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 0, 2, 
                    // Src: (or:i32 (and:i32 (or:i32 i32:i32:$z, i32:i32:$x), i32:i32:$y), (and:i32 i32:i32:$z, i32:i32:$x)) - Complexity = 12
                    // Dst: (V_BFI_B32:i32 (V_XOR_B32_e64:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*11797*/         0, /*End of Scope*/
/*11798*/       /*Scope*/ 93|128,17/*2269*/, /*->14069*/
/*11800*/         OPC_RecordChild0, // #0 = $x
/*11801*/         OPC_Scope, 95|128,11/*1503*/, /*->13307*/ // 2 children in Scope
/*11804*/           OPC_RecordChild1, // #1 = $z
/*11805*/           OPC_MoveParent,
/*11806*/           OPC_MoveChild, 1,
/*11808*/           OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*11811*/           OPC_Scope, 84|128,1/*212*/, /*->12026*/ // 4 children in Scope
/*11814*/             OPC_RecordChild0, // #2 = $y
/*11815*/             OPC_MoveChild, 1,
/*11817*/             OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*11820*/             OPC_CheckChild0Same, 1,
/*11822*/             OPC_CheckChild1Same, 0,
/*11824*/             OPC_MoveParent,
/*11825*/             OPC_MoveParent,
/*11826*/             OPC_CheckType, MVT::i32,
/*11828*/             OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*11830*/             OPC_EmitInteger, MVT::i32, 0, 
/*11833*/             OPC_EmitInteger, MVT::i32, 0, 
/*11836*/             OPC_EmitInteger, MVT::i32, 0, 
/*11839*/             OPC_EmitInteger, MVT::i32, 0, 
/*11842*/             OPC_EmitInteger, MVT::i32, 1, 
/*11845*/             OPC_EmitInteger, MVT::i32, 0, 
/*11848*/             OPC_EmitInteger, MVT::i32, 0, 
/*11851*/             OPC_EmitInteger, MVT::i32, 0, 
/*11854*/             OPC_EmitInteger, MVT::i32, 0, 
/*11857*/             OPC_EmitInteger, MVT::i32, 0, 
/*11860*/             OPC_EmitInteger, MVT::i32, 0, 
/*11863*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*11875*/             OPC_EmitInteger, MVT::i32, 0, 
/*11878*/             OPC_EmitInteger, MVT::i32, 0, 
/*11881*/             OPC_EmitInteger, MVT::i32, 0, 
/*11884*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*11896*/             OPC_EmitInteger, MVT::i32, 1, 
/*11899*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*11902*/             OPC_EmitInteger, MVT::i32, 0, 
/*11905*/             OPC_EmitInteger, MVT::i32, 0, 
/*11908*/             OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                          1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 0, 11, 12, 13, 14, 2, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*11935*/             OPC_EmitInteger, MVT::i32, 0, 
/*11938*/             OPC_EmitInteger, MVT::i32, 0, 
/*11941*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*11953*/             OPC_EmitInteger, MVT::i32, 0, 
/*11956*/             OPC_EmitInteger, MVT::i32, 0, 
/*11959*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*11971*/             OPC_EmitInteger, MVT::i32, 0, 
/*11974*/             OPC_EmitInteger, MVT::i32, 0, 
/*11977*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*11989*/             OPC_EmitInteger, MVT::i32, 1, 
/*11992*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*11995*/             OPC_EmitInteger, MVT::i32, 0, 
/*11998*/             OPC_EmitInteger, MVT::i32, 0, 
/*12001*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 1, 27, 28, 29, 2, 30, 31, 32, 33, 34, 35, 36, 
                      // Src: (or:i32 (and:i32 i32:i32:$x, i32:i32:$z), (and:i32 i32:i32:$y, (or:i32 i32:i32:$z, i32:i32:$x))) - Complexity = 12
                      // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*12026*/           /*Scope*/ 41|128,3/*425*/, /*->12453*/
/*12028*/             OPC_MoveChild, 0,
/*12030*/             OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*12033*/             OPC_Scope, 79|128,1/*207*/, /*->12243*/ // 2 children in Scope
/*12036*/               OPC_CheckChild0Same, 0,
/*12038*/               OPC_CheckChild1Same, 1,
/*12040*/               OPC_MoveParent,
/*12041*/               OPC_RecordChild1, // #2 = $y
/*12042*/               OPC_MoveParent,
/*12043*/               OPC_CheckType, MVT::i32,
/*12045*/               OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*12047*/               OPC_EmitInteger, MVT::i32, 0, 
/*12050*/               OPC_EmitInteger, MVT::i32, 0, 
/*12053*/               OPC_EmitInteger, MVT::i32, 0, 
/*12056*/               OPC_EmitInteger, MVT::i32, 0, 
/*12059*/               OPC_EmitInteger, MVT::i32, 1, 
/*12062*/               OPC_EmitInteger, MVT::i32, 0, 
/*12065*/               OPC_EmitInteger, MVT::i32, 0, 
/*12068*/               OPC_EmitInteger, MVT::i32, 0, 
/*12071*/               OPC_EmitInteger, MVT::i32, 0, 
/*12074*/               OPC_EmitInteger, MVT::i32, 0, 
/*12077*/               OPC_EmitInteger, MVT::i32, 0, 
/*12080*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12092*/               OPC_EmitInteger, MVT::i32, 0, 
/*12095*/               OPC_EmitInteger, MVT::i32, 0, 
/*12098*/               OPC_EmitInteger, MVT::i32, 0, 
/*12101*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12113*/               OPC_EmitInteger, MVT::i32, 1, 
/*12116*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*12119*/               OPC_EmitInteger, MVT::i32, 0, 
/*12122*/               OPC_EmitInteger, MVT::i32, 0, 
/*12125*/               OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                            1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 0, 11, 12, 13, 14, 2, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*12152*/               OPC_EmitInteger, MVT::i32, 0, 
/*12155*/               OPC_EmitInteger, MVT::i32, 0, 
/*12158*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12170*/               OPC_EmitInteger, MVT::i32, 0, 
/*12173*/               OPC_EmitInteger, MVT::i32, 0, 
/*12176*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12188*/               OPC_EmitInteger, MVT::i32, 0, 
/*12191*/               OPC_EmitInteger, MVT::i32, 0, 
/*12194*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12206*/               OPC_EmitInteger, MVT::i32, 1, 
/*12209*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*12212*/               OPC_EmitInteger, MVT::i32, 0, 
/*12215*/               OPC_EmitInteger, MVT::i32, 0, 
/*12218*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                            1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 1, 27, 28, 29, 2, 30, 31, 32, 33, 34, 35, 36, 
                        // Src: (or:i32 (and:i32 i32:i32:$x, i32:i32:$z), (and:i32 (or:i32 i32:i32:$x, i32:i32:$z), i32:i32:$y)) - Complexity = 12
                        // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*12243*/             /*Scope*/ 79|128,1/*207*/, /*->12452*/
/*12245*/               OPC_CheckChild0Same, 1,
/*12247*/               OPC_CheckChild1Same, 0,
/*12249*/               OPC_MoveParent,
/*12250*/               OPC_RecordChild1, // #2 = $y
/*12251*/               OPC_MoveParent,
/*12252*/               OPC_CheckType, MVT::i32,
/*12254*/               OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*12256*/               OPC_EmitInteger, MVT::i32, 0, 
/*12259*/               OPC_EmitInteger, MVT::i32, 0, 
/*12262*/               OPC_EmitInteger, MVT::i32, 0, 
/*12265*/               OPC_EmitInteger, MVT::i32, 0, 
/*12268*/               OPC_EmitInteger, MVT::i32, 1, 
/*12271*/               OPC_EmitInteger, MVT::i32, 0, 
/*12274*/               OPC_EmitInteger, MVT::i32, 0, 
/*12277*/               OPC_EmitInteger, MVT::i32, 0, 
/*12280*/               OPC_EmitInteger, MVT::i32, 0, 
/*12283*/               OPC_EmitInteger, MVT::i32, 0, 
/*12286*/               OPC_EmitInteger, MVT::i32, 0, 
/*12289*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12301*/               OPC_EmitInteger, MVT::i32, 0, 
/*12304*/               OPC_EmitInteger, MVT::i32, 0, 
/*12307*/               OPC_EmitInteger, MVT::i32, 0, 
/*12310*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12322*/               OPC_EmitInteger, MVT::i32, 1, 
/*12325*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*12328*/               OPC_EmitInteger, MVT::i32, 0, 
/*12331*/               OPC_EmitInteger, MVT::i32, 0, 
/*12334*/               OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                            1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 0, 11, 12, 13, 14, 2, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*12361*/               OPC_EmitInteger, MVT::i32, 0, 
/*12364*/               OPC_EmitInteger, MVT::i32, 0, 
/*12367*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12379*/               OPC_EmitInteger, MVT::i32, 0, 
/*12382*/               OPC_EmitInteger, MVT::i32, 0, 
/*12385*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12397*/               OPC_EmitInteger, MVT::i32, 0, 
/*12400*/               OPC_EmitInteger, MVT::i32, 0, 
/*12403*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12415*/               OPC_EmitInteger, MVT::i32, 1, 
/*12418*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*12421*/               OPC_EmitInteger, MVT::i32, 0, 
/*12424*/               OPC_EmitInteger, MVT::i32, 0, 
/*12427*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                            1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 1, 27, 28, 29, 2, 30, 31, 32, 33, 34, 35, 36, 
                        // Src: (or:i32 (and:i32 i32:i32:$x, i32:i32:$z), (and:i32 (or:i32 i32:i32:$z, i32:i32:$x), i32:i32:$y)) - Complexity = 12
                        // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*12452*/             0, /*End of Scope*/
/*12453*/           /*Scope*/ 40|128,3/*424*/, /*->12879*/
/*12455*/             OPC_RecordChild0, // #2 = $y
/*12456*/             OPC_MoveChild, 1,
/*12458*/             OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*12461*/             OPC_Scope, 78|128,1/*206*/, /*->12670*/ // 2 children in Scope
/*12464*/               OPC_CheckChild0Same, 1,
/*12466*/               OPC_CheckChild1Same, 0,
/*12468*/               OPC_MoveParent,
/*12469*/               OPC_MoveParent,
/*12470*/               OPC_CheckType, MVT::i32,
/*12472*/               OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*12474*/               OPC_EmitInteger, MVT::i32, 0, 
/*12477*/               OPC_EmitInteger, MVT::i32, 0, 
/*12480*/               OPC_EmitInteger, MVT::i32, 0, 
/*12483*/               OPC_EmitInteger, MVT::i32, 0, 
/*12486*/               OPC_EmitInteger, MVT::i32, 1, 
/*12489*/               OPC_EmitInteger, MVT::i32, 0, 
/*12492*/               OPC_EmitInteger, MVT::i32, 0, 
/*12495*/               OPC_EmitInteger, MVT::i32, 0, 
/*12498*/               OPC_EmitInteger, MVT::i32, 0, 
/*12501*/               OPC_EmitInteger, MVT::i32, 0, 
/*12504*/               OPC_EmitInteger, MVT::i32, 0, 
/*12507*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12519*/               OPC_EmitInteger, MVT::i32, 0, 
/*12522*/               OPC_EmitInteger, MVT::i32, 0, 
/*12525*/               OPC_EmitInteger, MVT::i32, 0, 
/*12528*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12540*/               OPC_EmitInteger, MVT::i32, 1, 
/*12543*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*12546*/               OPC_EmitInteger, MVT::i32, 0, 
/*12549*/               OPC_EmitInteger, MVT::i32, 0, 
/*12552*/               OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                            1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 1, 11, 12, 13, 14, 2, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*12579*/               OPC_EmitInteger, MVT::i32, 0, 
/*12582*/               OPC_EmitInteger, MVT::i32, 0, 
/*12585*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12597*/               OPC_EmitInteger, MVT::i32, 0, 
/*12600*/               OPC_EmitInteger, MVT::i32, 0, 
/*12603*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12615*/               OPC_EmitInteger, MVT::i32, 0, 
/*12618*/               OPC_EmitInteger, MVT::i32, 0, 
/*12621*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12633*/               OPC_EmitInteger, MVT::i32, 1, 
/*12636*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*12639*/               OPC_EmitInteger, MVT::i32, 0, 
/*12642*/               OPC_EmitInteger, MVT::i32, 0, 
/*12645*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                            1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 0, 27, 28, 29, 2, 30, 31, 32, 33, 34, 35, 36, 
                        // Src: (or:i32 (and:i32 i32:i32:$z, i32:i32:$x), (and:i32 i32:i32:$y, (or:i32 i32:i32:$x, i32:i32:$z))) - Complexity = 12
                        // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*12670*/             /*Scope*/ 78|128,1/*206*/, /*->12878*/
/*12672*/               OPC_CheckChild0Same, 0,
/*12674*/               OPC_CheckChild1Same, 1,
/*12676*/               OPC_MoveParent,
/*12677*/               OPC_MoveParent,
/*12678*/               OPC_CheckType, MVT::i32,
/*12680*/               OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*12682*/               OPC_EmitInteger, MVT::i32, 0, 
/*12685*/               OPC_EmitInteger, MVT::i32, 0, 
/*12688*/               OPC_EmitInteger, MVT::i32, 0, 
/*12691*/               OPC_EmitInteger, MVT::i32, 0, 
/*12694*/               OPC_EmitInteger, MVT::i32, 1, 
/*12697*/               OPC_EmitInteger, MVT::i32, 0, 
/*12700*/               OPC_EmitInteger, MVT::i32, 0, 
/*12703*/               OPC_EmitInteger, MVT::i32, 0, 
/*12706*/               OPC_EmitInteger, MVT::i32, 0, 
/*12709*/               OPC_EmitInteger, MVT::i32, 0, 
/*12712*/               OPC_EmitInteger, MVT::i32, 0, 
/*12715*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12727*/               OPC_EmitInteger, MVT::i32, 0, 
/*12730*/               OPC_EmitInteger, MVT::i32, 0, 
/*12733*/               OPC_EmitInteger, MVT::i32, 0, 
/*12736*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12748*/               OPC_EmitInteger, MVT::i32, 1, 
/*12751*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*12754*/               OPC_EmitInteger, MVT::i32, 0, 
/*12757*/               OPC_EmitInteger, MVT::i32, 0, 
/*12760*/               OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                            1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 1, 11, 12, 13, 14, 2, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*12787*/               OPC_EmitInteger, MVT::i32, 0, 
/*12790*/               OPC_EmitInteger, MVT::i32, 0, 
/*12793*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12805*/               OPC_EmitInteger, MVT::i32, 0, 
/*12808*/               OPC_EmitInteger, MVT::i32, 0, 
/*12811*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12823*/               OPC_EmitInteger, MVT::i32, 0, 
/*12826*/               OPC_EmitInteger, MVT::i32, 0, 
/*12829*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12841*/               OPC_EmitInteger, MVT::i32, 1, 
/*12844*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*12847*/               OPC_EmitInteger, MVT::i32, 0, 
/*12850*/               OPC_EmitInteger, MVT::i32, 0, 
/*12853*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                            1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 0, 27, 28, 29, 2, 30, 31, 32, 33, 34, 35, 36, 
                        // Src: (or:i32 (and:i32 i32:i32:$z, i32:i32:$x), (and:i32 i32:i32:$y, (or:i32 i32:i32:$z, i32:i32:$x))) - Complexity = 12
                        // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*12878*/             0, /*End of Scope*/
/*12879*/           /*Scope*/ 41|128,3/*425*/, /*->13306*/
/*12881*/             OPC_MoveChild, 0,
/*12883*/             OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*12886*/             OPC_Scope, 79|128,1/*207*/, /*->13096*/ // 2 children in Scope
/*12889*/               OPC_CheckChild0Same, 1,
/*12891*/               OPC_CheckChild1Same, 0,
/*12893*/               OPC_MoveParent,
/*12894*/               OPC_RecordChild1, // #2 = $y
/*12895*/               OPC_MoveParent,
/*12896*/               OPC_CheckType, MVT::i32,
/*12898*/               OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*12900*/               OPC_EmitInteger, MVT::i32, 0, 
/*12903*/               OPC_EmitInteger, MVT::i32, 0, 
/*12906*/               OPC_EmitInteger, MVT::i32, 0, 
/*12909*/               OPC_EmitInteger, MVT::i32, 0, 
/*12912*/               OPC_EmitInteger, MVT::i32, 1, 
/*12915*/               OPC_EmitInteger, MVT::i32, 0, 
/*12918*/               OPC_EmitInteger, MVT::i32, 0, 
/*12921*/               OPC_EmitInteger, MVT::i32, 0, 
/*12924*/               OPC_EmitInteger, MVT::i32, 0, 
/*12927*/               OPC_EmitInteger, MVT::i32, 0, 
/*12930*/               OPC_EmitInteger, MVT::i32, 0, 
/*12933*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12945*/               OPC_EmitInteger, MVT::i32, 0, 
/*12948*/               OPC_EmitInteger, MVT::i32, 0, 
/*12951*/               OPC_EmitInteger, MVT::i32, 0, 
/*12954*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*12966*/               OPC_EmitInteger, MVT::i32, 1, 
/*12969*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*12972*/               OPC_EmitInteger, MVT::i32, 0, 
/*12975*/               OPC_EmitInteger, MVT::i32, 0, 
/*12978*/               OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                            1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 1, 11, 12, 13, 14, 2, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*13005*/               OPC_EmitInteger, MVT::i32, 0, 
/*13008*/               OPC_EmitInteger, MVT::i32, 0, 
/*13011*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13023*/               OPC_EmitInteger, MVT::i32, 0, 
/*13026*/               OPC_EmitInteger, MVT::i32, 0, 
/*13029*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13041*/               OPC_EmitInteger, MVT::i32, 0, 
/*13044*/               OPC_EmitInteger, MVT::i32, 0, 
/*13047*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13059*/               OPC_EmitInteger, MVT::i32, 1, 
/*13062*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*13065*/               OPC_EmitInteger, MVT::i32, 0, 
/*13068*/               OPC_EmitInteger, MVT::i32, 0, 
/*13071*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                            1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 0, 27, 28, 29, 2, 30, 31, 32, 33, 34, 35, 36, 
                        // Src: (or:i32 (and:i32 i32:i32:$z, i32:i32:$x), (and:i32 (or:i32 i32:i32:$x, i32:i32:$z), i32:i32:$y)) - Complexity = 12
                        // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*13096*/             /*Scope*/ 79|128,1/*207*/, /*->13305*/
/*13098*/               OPC_CheckChild0Same, 0,
/*13100*/               OPC_CheckChild1Same, 1,
/*13102*/               OPC_MoveParent,
/*13103*/               OPC_RecordChild1, // #2 = $y
/*13104*/               OPC_MoveParent,
/*13105*/               OPC_CheckType, MVT::i32,
/*13107*/               OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*13109*/               OPC_EmitInteger, MVT::i32, 0, 
/*13112*/               OPC_EmitInteger, MVT::i32, 0, 
/*13115*/               OPC_EmitInteger, MVT::i32, 0, 
/*13118*/               OPC_EmitInteger, MVT::i32, 0, 
/*13121*/               OPC_EmitInteger, MVT::i32, 1, 
/*13124*/               OPC_EmitInteger, MVT::i32, 0, 
/*13127*/               OPC_EmitInteger, MVT::i32, 0, 
/*13130*/               OPC_EmitInteger, MVT::i32, 0, 
/*13133*/               OPC_EmitInteger, MVT::i32, 0, 
/*13136*/               OPC_EmitInteger, MVT::i32, 0, 
/*13139*/               OPC_EmitInteger, MVT::i32, 0, 
/*13142*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13154*/               OPC_EmitInteger, MVT::i32, 0, 
/*13157*/               OPC_EmitInteger, MVT::i32, 0, 
/*13160*/               OPC_EmitInteger, MVT::i32, 0, 
/*13163*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13175*/               OPC_EmitInteger, MVT::i32, 1, 
/*13178*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*13181*/               OPC_EmitInteger, MVT::i32, 0, 
/*13184*/               OPC_EmitInteger, MVT::i32, 0, 
/*13187*/               OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                            1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 1, 11, 12, 13, 14, 2, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*13214*/               OPC_EmitInteger, MVT::i32, 0, 
/*13217*/               OPC_EmitInteger, MVT::i32, 0, 
/*13220*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13232*/               OPC_EmitInteger, MVT::i32, 0, 
/*13235*/               OPC_EmitInteger, MVT::i32, 0, 
/*13238*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13250*/               OPC_EmitInteger, MVT::i32, 0, 
/*13253*/               OPC_EmitInteger, MVT::i32, 0, 
/*13256*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13268*/               OPC_EmitInteger, MVT::i32, 1, 
/*13271*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*13274*/               OPC_EmitInteger, MVT::i32, 0, 
/*13277*/               OPC_EmitInteger, MVT::i32, 0, 
/*13280*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                            1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 0, 27, 28, 29, 2, 30, 31, 32, 33, 34, 35, 36, 
                        // Src: (or:i32 (and:i32 i32:i32:$z, i32:i32:$x), (and:i32 (or:i32 i32:i32:$z, i32:i32:$x), i32:i32:$y)) - Complexity = 12
                        // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*13305*/             0, /*End of Scope*/
/*13306*/           0, /*End of Scope*/
/*13307*/         /*Scope*/ 119|128,5/*759*/, /*->14068*/
/*13309*/           OPC_MoveChild, 1,
/*13311*/           OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*13314*/           OPC_RecordChild0, // #1 = $x
/*13315*/           OPC_RecordChild1, // #2 = $z
/*13316*/           OPC_MoveParent,
/*13317*/           OPC_MoveParent,
/*13318*/           OPC_MoveChild, 1,
/*13320*/           OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*13323*/           OPC_Scope, 77|128,1/*205*/, /*->13531*/ // 3 children in Scope
/*13326*/             OPC_CheckChild0Same, 1,
/*13328*/             OPC_CheckChild1Same, 2,
/*13330*/             OPC_MoveParent,
/*13331*/             OPC_CheckType, MVT::i32,
/*13333*/             OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*13335*/             OPC_EmitInteger, MVT::i32, 0, 
/*13338*/             OPC_EmitInteger, MVT::i32, 0, 
/*13341*/             OPC_EmitInteger, MVT::i32, 0, 
/*13344*/             OPC_EmitInteger, MVT::i32, 0, 
/*13347*/             OPC_EmitInteger, MVT::i32, 1, 
/*13350*/             OPC_EmitInteger, MVT::i32, 0, 
/*13353*/             OPC_EmitInteger, MVT::i32, 0, 
/*13356*/             OPC_EmitInteger, MVT::i32, 0, 
/*13359*/             OPC_EmitInteger, MVT::i32, 0, 
/*13362*/             OPC_EmitInteger, MVT::i32, 0, 
/*13365*/             OPC_EmitInteger, MVT::i32, 0, 
/*13368*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13380*/             OPC_EmitInteger, MVT::i32, 0, 
/*13383*/             OPC_EmitInteger, MVT::i32, 0, 
/*13386*/             OPC_EmitInteger, MVT::i32, 0, 
/*13389*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13401*/             OPC_EmitInteger, MVT::i32, 1, 
/*13404*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*13407*/             OPC_EmitInteger, MVT::i32, 0, 
/*13410*/             OPC_EmitInteger, MVT::i32, 0, 
/*13413*/             OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                          1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 1, 11, 12, 13, 14, 0, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*13440*/             OPC_EmitInteger, MVT::i32, 0, 
/*13443*/             OPC_EmitInteger, MVT::i32, 0, 
/*13446*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13458*/             OPC_EmitInteger, MVT::i32, 0, 
/*13461*/             OPC_EmitInteger, MVT::i32, 0, 
/*13464*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13476*/             OPC_EmitInteger, MVT::i32, 0, 
/*13479*/             OPC_EmitInteger, MVT::i32, 0, 
/*13482*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13494*/             OPC_EmitInteger, MVT::i32, 1, 
/*13497*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*13500*/             OPC_EmitInteger, MVT::i32, 0, 
/*13503*/             OPC_EmitInteger, MVT::i32, 0, 
/*13506*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 2, 27, 28, 29, 0, 30, 31, 32, 33, 34, 35, 36, 
                      // Src: (or:i32 (and:i32 i32:i32:$y, (or:i32 i32:i32:$x, i32:i32:$z)), (and:i32 i32:i32:$x, i32:i32:$z)) - Complexity = 12
                      // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*13531*/           /*Scope*/ 71|128,2/*327*/, /*->13860*/
/*13533*/             OPC_CheckChild0Same, 2,
/*13535*/             OPC_CheckChild1Same, 1,
/*13537*/             OPC_MoveParent,
/*13538*/             OPC_CheckType, MVT::i32,
/*13540*/             OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*13542*/             OPC_EmitInteger, MVT::i32, 0, 
/*13545*/             OPC_EmitInteger, MVT::i32, 0, 
/*13548*/             OPC_EmitInteger, MVT::i32, 0, 
/*13551*/             OPC_EmitInteger, MVT::i32, 0, 
/*13554*/             OPC_EmitInteger, MVT::i32, 1, 
/*13557*/             OPC_EmitInteger, MVT::i32, 0, 
/*13560*/             OPC_EmitInteger, MVT::i32, 0, 
/*13563*/             OPC_EmitInteger, MVT::i32, 0, 
/*13566*/             OPC_EmitInteger, MVT::i32, 0, 
/*13569*/             OPC_EmitInteger, MVT::i32, 0, 
/*13572*/             OPC_EmitInteger, MVT::i32, 0, 
/*13575*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13587*/             OPC_EmitInteger, MVT::i32, 0, 
/*13590*/             OPC_EmitInteger, MVT::i32, 0, 
/*13593*/             OPC_EmitInteger, MVT::i32, 0, 
/*13596*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13608*/             OPC_EmitInteger, MVT::i32, 1, 
/*13611*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*13614*/             OPC_EmitInteger, MVT::i32, 0, 
/*13617*/             OPC_EmitInteger, MVT::i32, 0, 
/*13620*/             OPC_Scope, 118, /*->13740*/ // 2 children in Scope
/*13622*/               OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                            1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 1, 11, 12, 13, 14, 0, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*13649*/               OPC_EmitInteger, MVT::i32, 0, 
/*13652*/               OPC_EmitInteger, MVT::i32, 0, 
/*13655*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13667*/               OPC_EmitInteger, MVT::i32, 0, 
/*13670*/               OPC_EmitInteger, MVT::i32, 0, 
/*13673*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13685*/               OPC_EmitInteger, MVT::i32, 0, 
/*13688*/               OPC_EmitInteger, MVT::i32, 0, 
/*13691*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13703*/               OPC_EmitInteger, MVT::i32, 1, 
/*13706*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*13709*/               OPC_EmitInteger, MVT::i32, 0, 
/*13712*/               OPC_EmitInteger, MVT::i32, 0, 
/*13715*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                            1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 2, 27, 28, 29, 0, 30, 31, 32, 33, 34, 35, 36, 
                        // Src: (or:i32 (and:i32 i32:i32:$y, (or:i32 i32:i32:$x, i32:i32:$z)), (and:i32 i32:i32:$z, i32:i32:$x)) - Complexity = 12
                        // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*13740*/             /*Scope*/ 118, /*->13859*/
/*13741*/               OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                            1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 2, 11, 12, 13, 14, 0, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*13768*/               OPC_EmitInteger, MVT::i32, 0, 
/*13771*/               OPC_EmitInteger, MVT::i32, 0, 
/*13774*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13786*/               OPC_EmitInteger, MVT::i32, 0, 
/*13789*/               OPC_EmitInteger, MVT::i32, 0, 
/*13792*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13804*/               OPC_EmitInteger, MVT::i32, 0, 
/*13807*/               OPC_EmitInteger, MVT::i32, 0, 
/*13810*/               OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13822*/               OPC_EmitInteger, MVT::i32, 1, 
/*13825*/               OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*13828*/               OPC_EmitInteger, MVT::i32, 0, 
/*13831*/               OPC_EmitInteger, MVT::i32, 0, 
/*13834*/               OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                            1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 1, 27, 28, 29, 0, 30, 31, 32, 33, 34, 35, 36, 
                        // Src: (or:i32 (and:i32 i32:i32:$y, (or:i32 i32:i32:$z, i32:i32:$x)), (and:i32 i32:i32:$x, i32:i32:$z)) - Complexity = 12
                        // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*13859*/             0, /*End of Scope*/
/*13860*/           /*Scope*/ 77|128,1/*205*/, /*->14067*/
/*13862*/             OPC_CheckChild0Same, 1,
/*13864*/             OPC_CheckChild1Same, 2,
/*13866*/             OPC_MoveParent,
/*13867*/             OPC_CheckType, MVT::i32,
/*13869*/             OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*13871*/             OPC_EmitInteger, MVT::i32, 0, 
/*13874*/             OPC_EmitInteger, MVT::i32, 0, 
/*13877*/             OPC_EmitInteger, MVT::i32, 0, 
/*13880*/             OPC_EmitInteger, MVT::i32, 0, 
/*13883*/             OPC_EmitInteger, MVT::i32, 1, 
/*13886*/             OPC_EmitInteger, MVT::i32, 0, 
/*13889*/             OPC_EmitInteger, MVT::i32, 0, 
/*13892*/             OPC_EmitInteger, MVT::i32, 0, 
/*13895*/             OPC_EmitInteger, MVT::i32, 0, 
/*13898*/             OPC_EmitInteger, MVT::i32, 0, 
/*13901*/             OPC_EmitInteger, MVT::i32, 0, 
/*13904*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13916*/             OPC_EmitInteger, MVT::i32, 0, 
/*13919*/             OPC_EmitInteger, MVT::i32, 0, 
/*13922*/             OPC_EmitInteger, MVT::i32, 0, 
/*13925*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13937*/             OPC_EmitInteger, MVT::i32, 1, 
/*13940*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*13943*/             OPC_EmitInteger, MVT::i32, 0, 
/*13946*/             OPC_EmitInteger, MVT::i32, 0, 
/*13949*/             OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                          1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 2, 11, 12, 13, 14, 0, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*13976*/             OPC_EmitInteger, MVT::i32, 0, 
/*13979*/             OPC_EmitInteger, MVT::i32, 0, 
/*13982*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*13994*/             OPC_EmitInteger, MVT::i32, 0, 
/*13997*/             OPC_EmitInteger, MVT::i32, 0, 
/*14000*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14012*/             OPC_EmitInteger, MVT::i32, 0, 
/*14015*/             OPC_EmitInteger, MVT::i32, 0, 
/*14018*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14030*/             OPC_EmitInteger, MVT::i32, 1, 
/*14033*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*14036*/             OPC_EmitInteger, MVT::i32, 0, 
/*14039*/             OPC_EmitInteger, MVT::i32, 0, 
/*14042*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 1, 27, 28, 29, 0, 30, 31, 32, 33, 34, 35, 36, 
                      // Src: (or:i32 (and:i32 i32:i32:$y, (or:i32 i32:i32:$z, i32:i32:$x)), (and:i32 i32:i32:$z, i32:i32:$x)) - Complexity = 12
                      // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*14067*/           0, /*End of Scope*/
/*14068*/         0, /*End of Scope*/
/*14069*/       /*Scope*/ 120|128,5/*760*/, /*->14831*/
/*14071*/         OPC_MoveChild, 0,
/*14073*/         OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*14076*/         OPC_RecordChild0, // #0 = $x
/*14077*/         OPC_RecordChild1, // #1 = $z
/*14078*/         OPC_MoveParent,
/*14079*/         OPC_RecordChild1, // #2 = $y
/*14080*/         OPC_MoveParent,
/*14081*/         OPC_MoveChild, 1,
/*14083*/         OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*14086*/         OPC_Scope, 77|128,1/*205*/, /*->14294*/ // 3 children in Scope
/*14089*/           OPC_CheckChild0Same, 0,
/*14091*/           OPC_CheckChild1Same, 1,
/*14093*/           OPC_MoveParent,
/*14094*/           OPC_CheckType, MVT::i32,
/*14096*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*14098*/           OPC_EmitInteger, MVT::i32, 0, 
/*14101*/           OPC_EmitInteger, MVT::i32, 0, 
/*14104*/           OPC_EmitInteger, MVT::i32, 0, 
/*14107*/           OPC_EmitInteger, MVT::i32, 0, 
/*14110*/           OPC_EmitInteger, MVT::i32, 1, 
/*14113*/           OPC_EmitInteger, MVT::i32, 0, 
/*14116*/           OPC_EmitInteger, MVT::i32, 0, 
/*14119*/           OPC_EmitInteger, MVT::i32, 0, 
/*14122*/           OPC_EmitInteger, MVT::i32, 0, 
/*14125*/           OPC_EmitInteger, MVT::i32, 0, 
/*14128*/           OPC_EmitInteger, MVT::i32, 0, 
/*14131*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14143*/           OPC_EmitInteger, MVT::i32, 0, 
/*14146*/           OPC_EmitInteger, MVT::i32, 0, 
/*14149*/           OPC_EmitInteger, MVT::i32, 0, 
/*14152*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14164*/           OPC_EmitInteger, MVT::i32, 1, 
/*14167*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*14170*/           OPC_EmitInteger, MVT::i32, 0, 
/*14173*/           OPC_EmitInteger, MVT::i32, 0, 
/*14176*/           OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 0, 11, 12, 13, 14, 2, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*14203*/           OPC_EmitInteger, MVT::i32, 0, 
/*14206*/           OPC_EmitInteger, MVT::i32, 0, 
/*14209*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14221*/           OPC_EmitInteger, MVT::i32, 0, 
/*14224*/           OPC_EmitInteger, MVT::i32, 0, 
/*14227*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14239*/           OPC_EmitInteger, MVT::i32, 0, 
/*14242*/           OPC_EmitInteger, MVT::i32, 0, 
/*14245*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14257*/           OPC_EmitInteger, MVT::i32, 1, 
/*14260*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*14263*/           OPC_EmitInteger, MVT::i32, 0, 
/*14266*/           OPC_EmitInteger, MVT::i32, 0, 
/*14269*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                        1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 1, 27, 28, 29, 2, 30, 31, 32, 33, 34, 35, 36, 
                    // Src: (or:i32 (and:i32 (or:i32 i32:i32:$x, i32:i32:$z), i32:i32:$y), (and:i32 i32:i32:$x, i32:i32:$z)) - Complexity = 12
                    // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*14294*/         /*Scope*/ 71|128,2/*327*/, /*->14623*/
/*14296*/           OPC_CheckChild0Same, 1,
/*14298*/           OPC_CheckChild1Same, 0,
/*14300*/           OPC_MoveParent,
/*14301*/           OPC_CheckType, MVT::i32,
/*14303*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*14305*/           OPC_EmitInteger, MVT::i32, 0, 
/*14308*/           OPC_EmitInteger, MVT::i32, 0, 
/*14311*/           OPC_EmitInteger, MVT::i32, 0, 
/*14314*/           OPC_EmitInteger, MVT::i32, 0, 
/*14317*/           OPC_EmitInteger, MVT::i32, 1, 
/*14320*/           OPC_EmitInteger, MVT::i32, 0, 
/*14323*/           OPC_EmitInteger, MVT::i32, 0, 
/*14326*/           OPC_EmitInteger, MVT::i32, 0, 
/*14329*/           OPC_EmitInteger, MVT::i32, 0, 
/*14332*/           OPC_EmitInteger, MVT::i32, 0, 
/*14335*/           OPC_EmitInteger, MVT::i32, 0, 
/*14338*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14350*/           OPC_EmitInteger, MVT::i32, 0, 
/*14353*/           OPC_EmitInteger, MVT::i32, 0, 
/*14356*/           OPC_EmitInteger, MVT::i32, 0, 
/*14359*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14371*/           OPC_EmitInteger, MVT::i32, 1, 
/*14374*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*14377*/           OPC_EmitInteger, MVT::i32, 0, 
/*14380*/           OPC_EmitInteger, MVT::i32, 0, 
/*14383*/           OPC_Scope, 118, /*->14503*/ // 2 children in Scope
/*14385*/             OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                          1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 0, 11, 12, 13, 14, 2, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*14412*/             OPC_EmitInteger, MVT::i32, 0, 
/*14415*/             OPC_EmitInteger, MVT::i32, 0, 
/*14418*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14430*/             OPC_EmitInteger, MVT::i32, 0, 
/*14433*/             OPC_EmitInteger, MVT::i32, 0, 
/*14436*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14448*/             OPC_EmitInteger, MVT::i32, 0, 
/*14451*/             OPC_EmitInteger, MVT::i32, 0, 
/*14454*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14466*/             OPC_EmitInteger, MVT::i32, 1, 
/*14469*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*14472*/             OPC_EmitInteger, MVT::i32, 0, 
/*14475*/             OPC_EmitInteger, MVT::i32, 0, 
/*14478*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 1, 27, 28, 29, 2, 30, 31, 32, 33, 34, 35, 36, 
                      // Src: (or:i32 (and:i32 (or:i32 i32:i32:$x, i32:i32:$z), i32:i32:$y), (and:i32 i32:i32:$z, i32:i32:$x)) - Complexity = 12
                      // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*14503*/           /*Scope*/ 118, /*->14622*/
/*14504*/             OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                          1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 1, 11, 12, 13, 14, 2, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*14531*/             OPC_EmitInteger, MVT::i32, 0, 
/*14534*/             OPC_EmitInteger, MVT::i32, 0, 
/*14537*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14549*/             OPC_EmitInteger, MVT::i32, 0, 
/*14552*/             OPC_EmitInteger, MVT::i32, 0, 
/*14555*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14567*/             OPC_EmitInteger, MVT::i32, 0, 
/*14570*/             OPC_EmitInteger, MVT::i32, 0, 
/*14573*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14585*/             OPC_EmitInteger, MVT::i32, 1, 
/*14588*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*14591*/             OPC_EmitInteger, MVT::i32, 0, 
/*14594*/             OPC_EmitInteger, MVT::i32, 0, 
/*14597*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 0, 27, 28, 29, 2, 30, 31, 32, 33, 34, 35, 36, 
                      // Src: (or:i32 (and:i32 (or:i32 i32:i32:$z, i32:i32:$x), i32:i32:$y), (and:i32 i32:i32:$x, i32:i32:$z)) - Complexity = 12
                      // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*14622*/           0, /*End of Scope*/
/*14623*/         /*Scope*/ 77|128,1/*205*/, /*->14830*/
/*14625*/           OPC_CheckChild0Same, 0,
/*14627*/           OPC_CheckChild1Same, 1,
/*14629*/           OPC_MoveParent,
/*14630*/           OPC_CheckType, MVT::i32,
/*14632*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*14634*/           OPC_EmitInteger, MVT::i32, 0, 
/*14637*/           OPC_EmitInteger, MVT::i32, 0, 
/*14640*/           OPC_EmitInteger, MVT::i32, 0, 
/*14643*/           OPC_EmitInteger, MVT::i32, 0, 
/*14646*/           OPC_EmitInteger, MVT::i32, 1, 
/*14649*/           OPC_EmitInteger, MVT::i32, 0, 
/*14652*/           OPC_EmitInteger, MVT::i32, 0, 
/*14655*/           OPC_EmitInteger, MVT::i32, 0, 
/*14658*/           OPC_EmitInteger, MVT::i32, 0, 
/*14661*/           OPC_EmitInteger, MVT::i32, 0, 
/*14664*/           OPC_EmitInteger, MVT::i32, 0, 
/*14667*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14679*/           OPC_EmitInteger, MVT::i32, 0, 
/*14682*/           OPC_EmitInteger, MVT::i32, 0, 
/*14685*/           OPC_EmitInteger, MVT::i32, 0, 
/*14688*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14700*/           OPC_EmitInteger, MVT::i32, 1, 
/*14703*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*14706*/           OPC_EmitInteger, MVT::i32, 0, 
/*14709*/           OPC_EmitInteger, MVT::i32, 0, 
/*14712*/           OPC_EmitNode, TARGET_VAL(AMDGPU::XOR_INT), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 5, 6, 7, 8, 9, 10, 1, 11, 12, 13, 14, 2, 15, 16, 17, 18, 19, 20, 21, 22,  // Results = #23
/*14739*/           OPC_EmitInteger, MVT::i32, 0, 
/*14742*/           OPC_EmitInteger, MVT::i32, 0, 
/*14745*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14757*/           OPC_EmitInteger, MVT::i32, 0, 
/*14760*/           OPC_EmitInteger, MVT::i32, 0, 
/*14763*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14775*/           OPC_EmitInteger, MVT::i32, 0, 
/*14778*/           OPC_EmitInteger, MVT::i32, 0, 
/*14781*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14793*/           OPC_EmitInteger, MVT::i32, 1, 
/*14796*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*14799*/           OPC_EmitInteger, MVT::i32, 0, 
/*14802*/           OPC_EmitInteger, MVT::i32, 0, 
/*14805*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                        1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 23, 24, 25, 26, 0, 27, 28, 29, 2, 30, 31, 32, 33, 34, 35, 36, 
                    // Src: (or:i32 (and:i32 (or:i32 i32:i32:$z, i32:i32:$x), i32:i32:$y), (and:i32 i32:i32:$z, i32:i32:$x)) - Complexity = 12
                    // Dst: (BFI_INT_eg:i32 (XOR_INT:i32 i32:i32:$x, i32:i32:$y), i32:i32:$z, i32:i32:$y)
/*14830*/         0, /*End of Scope*/
/*14831*/       0, /*End of Scope*/
/*14832*/     /*Scope*/ 20|128,1/*148*/, /*->14982*/
/*14834*/       OPC_RecordChild0, // #0 = $src0
/*14835*/       OPC_RecordChild1, // #1 = $src1
/*14836*/       OPC_SwitchType /*3 cases */, 116, MVT::i32,// ->14955
/*14839*/         OPC_Scope, 101, /*->14942*/ // 2 children in Scope
/*14841*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*14843*/           OPC_EmitInteger, MVT::i32, 0, 
/*14846*/           OPC_EmitInteger, MVT::i32, 0, 
/*14849*/           OPC_EmitInteger, MVT::i32, 1, 
/*14852*/           OPC_EmitInteger, MVT::i32, 0, 
/*14855*/           OPC_EmitInteger, MVT::i32, 0, 
/*14858*/           OPC_EmitInteger, MVT::i32, 0, 
/*14861*/           OPC_EmitInteger, MVT::i32, 0, 
/*14864*/           OPC_EmitInteger, MVT::i32, 0, 
/*14867*/           OPC_EmitInteger, MVT::i32, 0, 
/*14870*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14882*/           OPC_EmitInteger, MVT::i32, 0, 
/*14885*/           OPC_EmitInteger, MVT::i32, 0, 
/*14888*/           OPC_EmitInteger, MVT::i32, 0, 
/*14891*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*14903*/           OPC_EmitInteger, MVT::i32, 1, 
/*14906*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*14909*/           OPC_EmitInteger, MVT::i32, 0, 
/*14912*/           OPC_EmitInteger, MVT::i32, 0, 
/*14915*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::OR_INT), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                    // Src: (or:i32 R600_Reg32:i32:$src0, R600_Reg32:i32:$src1) - Complexity = 3
                    // Dst: (OR_INT:i32 R600_Reg32:i32:$src0, R600_Reg32:i32:$src1)
/*14942*/         /*Scope*/ 11, /*->14954*/
/*14943*/           OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*14945*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_OR_B32), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (or:i32 i32:i32:$src0, i32:i32:$src1) - Complexity = 3
                    // Dst: (S_OR_B32:i32 i32:i32:$src0, i32:i32:$src1)
/*14954*/         0, /*End of Scope*/
/*14955*/       /*SwitchType*/ 11, MVT::i64,// ->14968
/*14957*/         OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*14959*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_OR_B64), 0,
                      1/*#VTs*/, MVT::i64, 2/*#Ops*/, 0, 1, 
                  // Src: (or:i64 i64:i64:$src0, i64:i64:$src1) - Complexity = 3
                  // Dst: (S_OR_B64:i64 i64:i64:$src0, i64:i64:$src1)
/*14968*/       /*SwitchType*/ 11, MVT::i1,// ->14981
/*14970*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*14972*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_OR_B64), 0,
                      1/*#VTs*/, MVT::i1, 2/*#Ops*/, 0, 1, 
                  // Src: (or:i1 i1:i1:$src0, i1:i1:$src1) - Complexity = 3
                  // Dst: (S_OR_B64:i1 ?:i1:$src0, ?:i1:$src1)
/*14981*/       0, // EndSwitchType
/*14982*/     0, /*End of Scope*/
/*14983*/   /*SwitchOpcode*/ 85|128,5/*725*/, TARGET_VAL(ISD::ADD),// ->15712
/*14987*/     OPC_Scope, 59|128,2/*315*/, /*->15305*/ // 2 children in Scope
/*14990*/       OPC_MoveChild, 0,
/*14992*/       OPC_SwitchOpcode /*4 cases */, 41, TARGET_VAL(ISD::SHL),// ->15037
/*14996*/         OPC_CheckChild0Integer, 1, 
/*14998*/         OPC_RecordChild1, // #0 = $a
/*14999*/         OPC_CheckChild1Type, MVT::i32,
/*15001*/         OPC_MoveParent,
/*15002*/         OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15013*/         OPC_CheckType, MVT::i32,
/*15015*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*15017*/         OPC_EmitInteger, MVT::i32, 0, 
/*15020*/         OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                      1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1,  // Results = #2
/*15028*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_BFM_B32), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 2, 
                  // Src: (add:i32 (shl:i32 1:i32, i32:i32:$a), -1:i32) - Complexity = 16
                  // Dst: (S_BFM_B32:i32 ?:i32:$a, (S_MOV_B32:i32 0:i32))
/*15037*/       /*SwitchOpcode*/ 121, TARGET_VAL(AMDGPUISD::MUL_U24),// ->15161
/*15040*/         OPC_RecordChild0, // #0 = $src0
/*15041*/         OPC_RecordChild1, // #1 = $src1
/*15042*/         OPC_MoveParent,
/*15043*/         OPC_RecordChild1, // #2 = $src2
/*15044*/         OPC_CheckType, MVT::i32,
/*15046*/         OPC_Scope, 99, /*->15147*/ // 2 children in Scope
/*15048*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*15050*/           OPC_EmitInteger, MVT::i32, 0, 
/*15053*/           OPC_EmitInteger, MVT::i32, 0, 
/*15056*/           OPC_EmitInteger, MVT::i32, 0, 
/*15059*/           OPC_EmitInteger, MVT::i32, 0, 
/*15062*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15074*/           OPC_EmitInteger, MVT::i32, 0, 
/*15077*/           OPC_EmitInteger, MVT::i32, 0, 
/*15080*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15092*/           OPC_EmitInteger, MVT::i32, 0, 
/*15095*/           OPC_EmitInteger, MVT::i32, 0, 
/*15098*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15110*/           OPC_EmitInteger, MVT::i32, 1, 
/*15113*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*15116*/           OPC_EmitInteger, MVT::i32, 0, 
/*15119*/           OPC_EmitInteger, MVT::i32, 0, 
/*15122*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::MULADD_UINT24_eg), 0,
                        1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (add:i32 (AMDGPUmul_u24:i32 i32:i32:$src0, i32:i32:$src1), i32:i32:$src2) - Complexity = 6
                    // Dst: (MULADD_UINT24_eg:i32 ?:i32:$src0, ?:i32:$src1, ?:i32:$src2)
/*15147*/         /*Scope*/ 12, /*->15160*/
/*15148*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*15150*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_MAD_U32_U24), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (add:i32 (AMDGPUmul_u24:i32 i32:i32:$src0, i32:i32:$src1), i32:i32:$src2) - Complexity = 6
                    // Dst: (V_MAD_U32_U24:i32 ?:i32:$src0, ?:i32:$src1, ?:i32:$src2)
/*15160*/         0, /*End of Scope*/
/*15161*/       /*SwitchOpcode*/ 121, TARGET_VAL(AMDGPUISD::MUL_I24),// ->15285
/*15164*/         OPC_RecordChild0, // #0 = $src0
/*15165*/         OPC_RecordChild1, // #1 = $src1
/*15166*/         OPC_MoveParent,
/*15167*/         OPC_RecordChild1, // #2 = $src2
/*15168*/         OPC_CheckType, MVT::i32,
/*15170*/         OPC_Scope, 99, /*->15271*/ // 2 children in Scope
/*15172*/           OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*15174*/           OPC_EmitInteger, MVT::i32, 0, 
/*15177*/           OPC_EmitInteger, MVT::i32, 0, 
/*15180*/           OPC_EmitInteger, MVT::i32, 0, 
/*15183*/           OPC_EmitInteger, MVT::i32, 0, 
/*15186*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15198*/           OPC_EmitInteger, MVT::i32, 0, 
/*15201*/           OPC_EmitInteger, MVT::i32, 0, 
/*15204*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15216*/           OPC_EmitInteger, MVT::i32, 0, 
/*15219*/           OPC_EmitInteger, MVT::i32, 0, 
/*15222*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15234*/           OPC_EmitInteger, MVT::i32, 1, 
/*15237*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*15240*/           OPC_EmitInteger, MVT::i32, 0, 
/*15243*/           OPC_EmitInteger, MVT::i32, 0, 
/*15246*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::MULADD_INT24_cm), 0,
                        1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (add:i32 (AMDGPUmul_i24:i32 i32:i32:$src0, i32:i32:$src1), i32:i32:$src2) - Complexity = 6
                    // Dst: (MULADD_INT24_cm:i32 ?:i32:$src0, ?:i32:$src1, ?:i32:$src2)
/*15271*/         /*Scope*/ 12, /*->15284*/
/*15272*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*15274*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_MAD_I32_I24), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (add:i32 (AMDGPUmul_i24:i32 i32:i32:$src0, i32:i32:$src1), i32:i32:$src2) - Complexity = 6
                    // Dst: (V_MAD_I32_I24:i32 ?:i32:$src0, ?:i32:$src1, ?:i32:$src2)
/*15284*/         0, /*End of Scope*/
/*15285*/       /*SwitchOpcode*/ 16, TARGET_VAL(ISD::CTPOP),// ->15304
/*15288*/         OPC_RecordChild0, // #0 = $popcnt
/*15289*/         OPC_MoveParent,
/*15290*/         OPC_RecordChild1, // #1 = $val
/*15291*/         OPC_CheckType, MVT::i32,
/*15293*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*15295*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BCNT_U32_B32_e64), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (add:i32 (ctpop:i32 i32:i32:$popcnt), i32:i32:$val) - Complexity = 6
                  // Dst: (V_BCNT_U32_B32_e64:i32 ?:i32:$popcnt, ?:i32:$val)
/*15304*/       0, // EndSwitchOpcode
/*15305*/     /*Scope*/ 20|128,3/*404*/, /*->15711*/
/*15307*/       OPC_RecordChild0, // #0 = $val
/*15308*/       OPC_Scope, 12|128,2/*268*/, /*->15579*/ // 2 children in Scope
/*15311*/         OPC_MoveChild, 1,
/*15313*/         OPC_SwitchOpcode /*3 cases */, 15, TARGET_VAL(ISD::CTPOP),// ->15332
/*15317*/           OPC_RecordChild0, // #1 = $popcnt
/*15318*/           OPC_MoveParent,
/*15319*/           OPC_CheckType, MVT::i32,
/*15321*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*15323*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BCNT_U32_B32_e64), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 0, 
                    // Src: (add:i32 i32:i32:$val, (ctpop:i32 i32:i32:$popcnt)) - Complexity = 6
                    // Dst: (V_BCNT_U32_B32_e64:i32 ?:i32:$popcnt, ?:i32:$val)
/*15332*/         /*SwitchOpcode*/ 120, TARGET_VAL(AMDGPUISD::MUL_I24),// ->15455
/*15335*/           OPC_RecordChild0, // #1 = $src0
/*15336*/           OPC_RecordChild1, // #2 = $src1
/*15337*/           OPC_MoveParent,
/*15338*/           OPC_CheckType, MVT::i32,
/*15340*/           OPC_Scope, 12, /*->15354*/ // 2 children in Scope
/*15342*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*15344*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_MAD_I32_I24), 0,
                          1/*#VTs*/, MVT::i32, 3/*#Ops*/, 1, 2, 0, 
                      // Src: (add:i32 i32:i32:$src2, (AMDGPUmul_i24:i32 i32:i32:$src0, i32:i32:$src1)) - Complexity = 6
                      // Dst: (V_MAD_I32_I24:i32 ?:i32:$src0, ?:i32:$src1, ?:i32:$src2)
/*15354*/           /*Scope*/ 99, /*->15454*/
/*15355*/             OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*15357*/             OPC_EmitInteger, MVT::i32, 0, 
/*15360*/             OPC_EmitInteger, MVT::i32, 0, 
/*15363*/             OPC_EmitInteger, MVT::i32, 0, 
/*15366*/             OPC_EmitInteger, MVT::i32, 0, 
/*15369*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15381*/             OPC_EmitInteger, MVT::i32, 0, 
/*15384*/             OPC_EmitInteger, MVT::i32, 0, 
/*15387*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15399*/             OPC_EmitInteger, MVT::i32, 0, 
/*15402*/             OPC_EmitInteger, MVT::i32, 0, 
/*15405*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15417*/             OPC_EmitInteger, MVT::i32, 1, 
/*15420*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*15423*/             OPC_EmitInteger, MVT::i32, 0, 
/*15426*/             OPC_EmitInteger, MVT::i32, 0, 
/*15429*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::MULADD_INT24_cm), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 1, 5, 6, 7, 2, 8, 9, 10, 0, 11, 12, 13, 14, 15, 16, 17, 
                      // Src: (add:i32 i32:i32:$src2, (AMDGPUmul_i24:i32 i32:i32:$src0, i32:i32:$src1)) - Complexity = 6
                      // Dst: (MULADD_INT24_cm:i32 ?:i32:$src0, ?:i32:$src1, ?:i32:$src2)
/*15454*/           0, /*End of Scope*/
/*15455*/         /*SwitchOpcode*/ 120, TARGET_VAL(AMDGPUISD::MUL_U24),// ->15578
/*15458*/           OPC_RecordChild0, // #1 = $src0
/*15459*/           OPC_RecordChild1, // #2 = $src1
/*15460*/           OPC_MoveParent,
/*15461*/           OPC_CheckType, MVT::i32,
/*15463*/           OPC_Scope, 12, /*->15477*/ // 2 children in Scope
/*15465*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*15467*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_MAD_U32_U24), 0,
                          1/*#VTs*/, MVT::i32, 3/*#Ops*/, 1, 2, 0, 
                      // Src: (add:i32 i32:i32:$src2, (AMDGPUmul_u24:i32 i32:i32:$src0, i32:i32:$src1)) - Complexity = 6
                      // Dst: (V_MAD_U32_U24:i32 ?:i32:$src0, ?:i32:$src1, ?:i32:$src2)
/*15477*/           /*Scope*/ 99, /*->15577*/
/*15478*/             OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*15480*/             OPC_EmitInteger, MVT::i32, 0, 
/*15483*/             OPC_EmitInteger, MVT::i32, 0, 
/*15486*/             OPC_EmitInteger, MVT::i32, 0, 
/*15489*/             OPC_EmitInteger, MVT::i32, 0, 
/*15492*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15504*/             OPC_EmitInteger, MVT::i32, 0, 
/*15507*/             OPC_EmitInteger, MVT::i32, 0, 
/*15510*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15522*/             OPC_EmitInteger, MVT::i32, 0, 
/*15525*/             OPC_EmitInteger, MVT::i32, 0, 
/*15528*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15540*/             OPC_EmitInteger, MVT::i32, 1, 
/*15543*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*15546*/             OPC_EmitInteger, MVT::i32, 0, 
/*15549*/             OPC_EmitInteger, MVT::i32, 0, 
/*15552*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::MULADD_UINT24_eg), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 1, 5, 6, 7, 2, 8, 9, 10, 0, 11, 12, 13, 14, 15, 16, 17, 
                      // Src: (add:i32 i32:i32:$src2, (AMDGPUmul_u24:i32 i32:i32:$src0, i32:i32:$src1)) - Complexity = 6
                      // Dst: (MULADD_UINT24_eg:i32 ?:i32:$src0, ?:i32:$src1, ?:i32:$src2)
/*15577*/           0, /*End of Scope*/
/*15578*/         0, // EndSwitchOpcode
/*15579*/       /*Scope*/ 1|128,1/*129*/, /*->15710*/
/*15581*/         OPC_RecordChild1, // #1 = $src1
/*15582*/         OPC_CheckType, MVT::i32,
/*15584*/         OPC_Scope, 101, /*->15687*/ // 3 children in Scope
/*15586*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*15588*/           OPC_EmitInteger, MVT::i32, 0, 
/*15591*/           OPC_EmitInteger, MVT::i32, 0, 
/*15594*/           OPC_EmitInteger, MVT::i32, 1, 
/*15597*/           OPC_EmitInteger, MVT::i32, 0, 
/*15600*/           OPC_EmitInteger, MVT::i32, 0, 
/*15603*/           OPC_EmitInteger, MVT::i32, 0, 
/*15606*/           OPC_EmitInteger, MVT::i32, 0, 
/*15609*/           OPC_EmitInteger, MVT::i32, 0, 
/*15612*/           OPC_EmitInteger, MVT::i32, 0, 
/*15615*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15627*/           OPC_EmitInteger, MVT::i32, 0, 
/*15630*/           OPC_EmitInteger, MVT::i32, 0, 
/*15633*/           OPC_EmitInteger, MVT::i32, 0, 
/*15636*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15648*/           OPC_EmitInteger, MVT::i32, 1, 
/*15651*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*15654*/           OPC_EmitInteger, MVT::i32, 0, 
/*15657*/           OPC_EmitInteger, MVT::i32, 0, 
/*15660*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::ADD_INT), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                    // Src: (add:i32 R600_Reg32:i32:$src0, R600_Reg32:i32:$src1) - Complexity = 3
                    // Dst: (ADD_INT:i32 R600_Reg32:i32:$src0, R600_Reg32:i32:$src1)
/*15687*/         /*Scope*/ 11, /*->15699*/
/*15688*/           OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*15690*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_ADD_I32), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (add:i32 SSrc_32:i32:$src0, SSrc_32:i32:$src1) - Complexity = 3
                    // Dst: (S_ADD_I32:i32 SSrc_32:i32:$src0, SSrc_32:i32:$src1)
/*15699*/         /*Scope*/ 9, /*->15709*/
/*15700*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_ADD_I32_e64), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (add:i32 i32:i32:$src0, i32:i32:$src1) - Complexity = -997
                    // Dst: (V_ADD_I32_e64:i32 i32:i32:$src0, i32:i32:$src1)
/*15709*/         0, /*End of Scope*/
/*15710*/       0, /*End of Scope*/
/*15711*/     0, /*End of Scope*/
/*15712*/   /*SwitchOpcode*/ 29, TARGET_VAL(AMDGPUISD::REGISTER_LOAD),// ->15744
/*15715*/     OPC_RecordNode, // #0 = 'AMDGPUregister_load' chained node
/*15716*/     OPC_RecordChild1, // #1 = $addr
/*15717*/     OPC_RecordChild2, // #2 = $chan
/*15718*/     OPC_MoveChild, 2,
/*15720*/     OPC_CheckOpcode, TARGET_VAL(ISD::TargetConstant),
/*15723*/     OPC_CheckType, MVT::i32,
/*15725*/     OPC_MoveParent,
/*15726*/     OPC_CheckType, MVT::i32,
/*15728*/     OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*15730*/     OPC_CheckComplexPat, /*CP*/8, /*#*/1, // SelectADDRIndirect:$addr #3 #4
/*15733*/     OPC_EmitMergeInputChains1_0,
/*15734*/     OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_RegisterLoad), 0|OPFL_Chain,
                  1/*#VTs*/, MVT::i32, 3/*#Ops*/, 3, 4, 2, 
              // Src: (AMDGPUregister_load:i32 ADDRIndirect:iPTR:$addr, (timm:i32):$chan) - Complexity = 15
              // Dst: (R600_RegisterLoad:i32 ADDRIndirect:iPTR:$addr, (timm:i32):$chan)
/*15744*/   /*SwitchOpcode*/ 30, TARGET_VAL(AMDGPUISD::REGISTER_STORE),// ->15777
/*15747*/     OPC_RecordNode, // #0 = 'AMDGPUregister_store' chained node
/*15748*/     OPC_RecordChild1, // #1 = $val
/*15749*/     OPC_CheckChild1Type, MVT::i32,
/*15751*/     OPC_RecordChild2, // #2 = $addr
/*15752*/     OPC_RecordChild3, // #3 = $chan
/*15753*/     OPC_MoveChild, 3,
/*15755*/     OPC_CheckOpcode, TARGET_VAL(ISD::TargetConstant),
/*15758*/     OPC_CheckType, MVT::i32,
/*15760*/     OPC_MoveParent,
/*15761*/     OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*15763*/     OPC_CheckComplexPat, /*CP*/8, /*#*/2, // SelectADDRIndirect:$addr #4 #5
/*15766*/     OPC_EmitMergeInputChains1_0,
/*15767*/     OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_RegisterStore), 0|OPFL_Chain,
                  0/*#VTs*/, 4/*#Ops*/, 1, 4, 5, 3, 
              // Src: (AMDGPUregister_store i32:i32:$val, ADDRIndirect:iPTR:$addr, (timm:i32):$chan) - Complexity = 15
              // Dst: (R600_RegisterStore i32:i32:$val, ADDRIndirect:iPTR:$addr, (timm:i32):$chan)
/*15777*/   /*SwitchOpcode*/ 60|128,23/*3004*/, TARGET_VAL(ISD::SELECT_CC),// ->18785
/*15781*/     OPC_RecordChild0, // #0 = $src0
/*15782*/     OPC_Scope, 25|128,12/*1561*/, /*->17346*/ // 2 children in Scope
/*15785*/       OPC_CheckChild0Type, MVT::f32,
/*15787*/       OPC_Scope, 10|128,7/*906*/, /*->16696*/ // 2 children in Scope
/*15790*/         OPC_RecordChild1, // #1 = $src1
/*15791*/         OPC_Scope, 64|128,3/*448*/, /*->16242*/ // 2 children in Scope
/*15794*/           OPC_CheckChild2Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15805*/           OPC_CheckChild3Integer, 0, 
/*15807*/           OPC_MoveChild, 4,
/*15809*/           OPC_CheckOpcode, TARGET_VAL(ISD::CONDCODE),
/*15812*/           OPC_Scope, 106, /*->15920*/ // 4 children in Scope
/*15814*/             OPC_CheckPredicate, 103, // Predicate_COND_OEQ
/*15816*/             OPC_MoveParent,
/*15817*/             OPC_CheckType, MVT::i32,
/*15819*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*15821*/             OPC_EmitInteger, MVT::i32, 0, 
/*15824*/             OPC_EmitInteger, MVT::i32, 0, 
/*15827*/             OPC_EmitInteger, MVT::i32, 1, 
/*15830*/             OPC_EmitInteger, MVT::i32, 0, 
/*15833*/             OPC_EmitInteger, MVT::i32, 0, 
/*15836*/             OPC_EmitInteger, MVT::i32, 0, 
/*15839*/             OPC_EmitInteger, MVT::i32, 0, 
/*15842*/             OPC_EmitInteger, MVT::i32, 0, 
/*15845*/             OPC_EmitInteger, MVT::i32, 0, 
/*15848*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15860*/             OPC_EmitInteger, MVT::i32, 0, 
/*15863*/             OPC_EmitInteger, MVT::i32, 0, 
/*15866*/             OPC_EmitInteger, MVT::i32, 0, 
/*15869*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15881*/             OPC_EmitInteger, MVT::i32, 1, 
/*15884*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*15887*/             OPC_EmitInteger, MVT::i32, 0, 
/*15890*/             OPC_EmitInteger, MVT::i32, 0, 
/*15893*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SETE_DX10), 0,
                          1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                      // Src: (selectcc:i32 f32:f32:$src0, f32:f32:$src1, -1:i32, 0:i32, (cond:Other)<<P:Predicate_COND_OEQ>>) - Complexity = 13
                      // Dst: (SETE_DX10:i32 f32:f32:$src0, f32:f32:$src1)
/*15920*/           /*Scope*/ 106, /*->16027*/
/*15921*/             OPC_CheckPredicate, 104, // Predicate_COND_OGT
/*15923*/             OPC_MoveParent,
/*15924*/             OPC_CheckType, MVT::i32,
/*15926*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*15928*/             OPC_EmitInteger, MVT::i32, 0, 
/*15931*/             OPC_EmitInteger, MVT::i32, 0, 
/*15934*/             OPC_EmitInteger, MVT::i32, 1, 
/*15937*/             OPC_EmitInteger, MVT::i32, 0, 
/*15940*/             OPC_EmitInteger, MVT::i32, 0, 
/*15943*/             OPC_EmitInteger, MVT::i32, 0, 
/*15946*/             OPC_EmitInteger, MVT::i32, 0, 
/*15949*/             OPC_EmitInteger, MVT::i32, 0, 
/*15952*/             OPC_EmitInteger, MVT::i32, 0, 
/*15955*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15967*/             OPC_EmitInteger, MVT::i32, 0, 
/*15970*/             OPC_EmitInteger, MVT::i32, 0, 
/*15973*/             OPC_EmitInteger, MVT::i32, 0, 
/*15976*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*15988*/             OPC_EmitInteger, MVT::i32, 1, 
/*15991*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*15994*/             OPC_EmitInteger, MVT::i32, 0, 
/*15997*/             OPC_EmitInteger, MVT::i32, 0, 
/*16000*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SETGT_DX10), 0,
                          1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                      // Src: (selectcc:i32 f32:f32:$src0, f32:f32:$src1, -1:i32, 0:i32, (cond:Other)<<P:Predicate_COND_OGT>>) - Complexity = 13
                      // Dst: (SETGT_DX10:i32 f32:f32:$src0, f32:f32:$src1)
/*16027*/           /*Scope*/ 106, /*->16134*/
/*16028*/             OPC_CheckPredicate, 105, // Predicate_COND_OGE
/*16030*/             OPC_MoveParent,
/*16031*/             OPC_CheckType, MVT::i32,
/*16033*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*16035*/             OPC_EmitInteger, MVT::i32, 0, 
/*16038*/             OPC_EmitInteger, MVT::i32, 0, 
/*16041*/             OPC_EmitInteger, MVT::i32, 1, 
/*16044*/             OPC_EmitInteger, MVT::i32, 0, 
/*16047*/             OPC_EmitInteger, MVT::i32, 0, 
/*16050*/             OPC_EmitInteger, MVT::i32, 0, 
/*16053*/             OPC_EmitInteger, MVT::i32, 0, 
/*16056*/             OPC_EmitInteger, MVT::i32, 0, 
/*16059*/             OPC_EmitInteger, MVT::i32, 0, 
/*16062*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16074*/             OPC_EmitInteger, MVT::i32, 0, 
/*16077*/             OPC_EmitInteger, MVT::i32, 0, 
/*16080*/             OPC_EmitInteger, MVT::i32, 0, 
/*16083*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16095*/             OPC_EmitInteger, MVT::i32, 1, 
/*16098*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*16101*/             OPC_EmitInteger, MVT::i32, 0, 
/*16104*/             OPC_EmitInteger, MVT::i32, 0, 
/*16107*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SETGE_DX10), 0,
                          1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                      // Src: (selectcc:i32 f32:f32:$src0, f32:f32:$src1, -1:i32, 0:i32, (cond:Other)<<P:Predicate_COND_OGE>>) - Complexity = 13
                      // Dst: (SETGE_DX10:i32 f32:f32:$src0, f32:f32:$src1)
/*16134*/           /*Scope*/ 106, /*->16241*/
/*16135*/             OPC_CheckPredicate, 106, // Predicate_COND_UNE_NE
/*16137*/             OPC_MoveParent,
/*16138*/             OPC_CheckType, MVT::i32,
/*16140*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*16142*/             OPC_EmitInteger, MVT::i32, 0, 
/*16145*/             OPC_EmitInteger, MVT::i32, 0, 
/*16148*/             OPC_EmitInteger, MVT::i32, 1, 
/*16151*/             OPC_EmitInteger, MVT::i32, 0, 
/*16154*/             OPC_EmitInteger, MVT::i32, 0, 
/*16157*/             OPC_EmitInteger, MVT::i32, 0, 
/*16160*/             OPC_EmitInteger, MVT::i32, 0, 
/*16163*/             OPC_EmitInteger, MVT::i32, 0, 
/*16166*/             OPC_EmitInteger, MVT::i32, 0, 
/*16169*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16181*/             OPC_EmitInteger, MVT::i32, 0, 
/*16184*/             OPC_EmitInteger, MVT::i32, 0, 
/*16187*/             OPC_EmitInteger, MVT::i32, 0, 
/*16190*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16202*/             OPC_EmitInteger, MVT::i32, 1, 
/*16205*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*16208*/             OPC_EmitInteger, MVT::i32, 0, 
/*16211*/             OPC_EmitInteger, MVT::i32, 0, 
/*16214*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SETNE_DX10), 0,
                          1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                      // Src: (selectcc:i32 f32:f32:$src0, f32:f32:$src1, -1:i32, 0:i32, (cond:Other)<<P:Predicate_COND_UNE_NE>>) - Complexity = 13
                      // Dst: (SETNE_DX10:i32 f32:f32:$src0, f32:f32:$src1)
/*16241*/           0, /*End of Scope*/
/*16242*/         /*Scope*/ 67|128,3/*451*/, /*->16695*/
/*16244*/           OPC_MoveChild, 2,
/*16246*/           OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*16249*/           OPC_CheckPredicate, 107, // Predicate_FP_ONE
/*16251*/           OPC_MoveParent,
/*16252*/           OPC_MoveChild, 3,
/*16254*/           OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*16257*/           OPC_CheckPredicate, 108, // Predicate_FP_ZERO
/*16259*/           OPC_MoveParent,
/*16260*/           OPC_MoveChild, 4,
/*16262*/           OPC_CheckOpcode, TARGET_VAL(ISD::CONDCODE),
/*16265*/           OPC_Scope, 106, /*->16373*/ // 4 children in Scope
/*16267*/             OPC_CheckPredicate, 103, // Predicate_COND_OEQ
/*16269*/             OPC_MoveParent,
/*16270*/             OPC_CheckType, MVT::f32,
/*16272*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*16274*/             OPC_EmitInteger, MVT::i32, 0, 
/*16277*/             OPC_EmitInteger, MVT::i32, 0, 
/*16280*/             OPC_EmitInteger, MVT::i32, 1, 
/*16283*/             OPC_EmitInteger, MVT::i32, 0, 
/*16286*/             OPC_EmitInteger, MVT::i32, 0, 
/*16289*/             OPC_EmitInteger, MVT::i32, 0, 
/*16292*/             OPC_EmitInteger, MVT::i32, 0, 
/*16295*/             OPC_EmitInteger, MVT::i32, 0, 
/*16298*/             OPC_EmitInteger, MVT::i32, 0, 
/*16301*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16313*/             OPC_EmitInteger, MVT::i32, 0, 
/*16316*/             OPC_EmitInteger, MVT::i32, 0, 
/*16319*/             OPC_EmitInteger, MVT::i32, 0, 
/*16322*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16334*/             OPC_EmitInteger, MVT::i32, 1, 
/*16337*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*16340*/             OPC_EmitInteger, MVT::i32, 0, 
/*16343*/             OPC_EmitInteger, MVT::i32, 0, 
/*16346*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SETE), 0,
                          1/*#VTs*/, MVT::f32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                      // Src: (selectcc:f32 f32:f32:$src0, f32:f32:$src1, (fpimm:f32)<<P:Predicate_FP_ONE>>, (fpimm:f32)<<P:Predicate_FP_ZERO>>, (cond:Other)<<P:Predicate_COND_OEQ>>) - Complexity = 11
                      // Dst: (SETE:f32 f32:f32:$src0, f32:f32:$src1)
/*16373*/           /*Scope*/ 106, /*->16480*/
/*16374*/             OPC_CheckPredicate, 104, // Predicate_COND_OGT
/*16376*/             OPC_MoveParent,
/*16377*/             OPC_CheckType, MVT::f32,
/*16379*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*16381*/             OPC_EmitInteger, MVT::i32, 0, 
/*16384*/             OPC_EmitInteger, MVT::i32, 0, 
/*16387*/             OPC_EmitInteger, MVT::i32, 1, 
/*16390*/             OPC_EmitInteger, MVT::i32, 0, 
/*16393*/             OPC_EmitInteger, MVT::i32, 0, 
/*16396*/             OPC_EmitInteger, MVT::i32, 0, 
/*16399*/             OPC_EmitInteger, MVT::i32, 0, 
/*16402*/             OPC_EmitInteger, MVT::i32, 0, 
/*16405*/             OPC_EmitInteger, MVT::i32, 0, 
/*16408*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16420*/             OPC_EmitInteger, MVT::i32, 0, 
/*16423*/             OPC_EmitInteger, MVT::i32, 0, 
/*16426*/             OPC_EmitInteger, MVT::i32, 0, 
/*16429*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16441*/             OPC_EmitInteger, MVT::i32, 1, 
/*16444*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*16447*/             OPC_EmitInteger, MVT::i32, 0, 
/*16450*/             OPC_EmitInteger, MVT::i32, 0, 
/*16453*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SGT), 0,
                          1/*#VTs*/, MVT::f32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                      // Src: (selectcc:f32 f32:f32:$src0, f32:f32:$src1, (fpimm:f32)<<P:Predicate_FP_ONE>>, (fpimm:f32)<<P:Predicate_FP_ZERO>>, (cond:Other)<<P:Predicate_COND_OGT>>) - Complexity = 11
                      // Dst: (SGT:f32 f32:f32:$src0, f32:f32:$src1)
/*16480*/           /*Scope*/ 106, /*->16587*/
/*16481*/             OPC_CheckPredicate, 105, // Predicate_COND_OGE
/*16483*/             OPC_MoveParent,
/*16484*/             OPC_CheckType, MVT::f32,
/*16486*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*16488*/             OPC_EmitInteger, MVT::i32, 0, 
/*16491*/             OPC_EmitInteger, MVT::i32, 0, 
/*16494*/             OPC_EmitInteger, MVT::i32, 1, 
/*16497*/             OPC_EmitInteger, MVT::i32, 0, 
/*16500*/             OPC_EmitInteger, MVT::i32, 0, 
/*16503*/             OPC_EmitInteger, MVT::i32, 0, 
/*16506*/             OPC_EmitInteger, MVT::i32, 0, 
/*16509*/             OPC_EmitInteger, MVT::i32, 0, 
/*16512*/             OPC_EmitInteger, MVT::i32, 0, 
/*16515*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16527*/             OPC_EmitInteger, MVT::i32, 0, 
/*16530*/             OPC_EmitInteger, MVT::i32, 0, 
/*16533*/             OPC_EmitInteger, MVT::i32, 0, 
/*16536*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16548*/             OPC_EmitInteger, MVT::i32, 1, 
/*16551*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*16554*/             OPC_EmitInteger, MVT::i32, 0, 
/*16557*/             OPC_EmitInteger, MVT::i32, 0, 
/*16560*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SGE), 0,
                          1/*#VTs*/, MVT::f32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                      // Src: (selectcc:f32 f32:f32:$src0, f32:f32:$src1, (fpimm:f32)<<P:Predicate_FP_ONE>>, (fpimm:f32)<<P:Predicate_FP_ZERO>>, (cond:Other)<<P:Predicate_COND_OGE>>) - Complexity = 11
                      // Dst: (SGE:f32 f32:f32:$src0, f32:f32:$src1)
/*16587*/           /*Scope*/ 106, /*->16694*/
/*16588*/             OPC_CheckPredicate, 106, // Predicate_COND_UNE_NE
/*16590*/             OPC_MoveParent,
/*16591*/             OPC_CheckType, MVT::f32,
/*16593*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*16595*/             OPC_EmitInteger, MVT::i32, 0, 
/*16598*/             OPC_EmitInteger, MVT::i32, 0, 
/*16601*/             OPC_EmitInteger, MVT::i32, 1, 
/*16604*/             OPC_EmitInteger, MVT::i32, 0, 
/*16607*/             OPC_EmitInteger, MVT::i32, 0, 
/*16610*/             OPC_EmitInteger, MVT::i32, 0, 
/*16613*/             OPC_EmitInteger, MVT::i32, 0, 
/*16616*/             OPC_EmitInteger, MVT::i32, 0, 
/*16619*/             OPC_EmitInteger, MVT::i32, 0, 
/*16622*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16634*/             OPC_EmitInteger, MVT::i32, 0, 
/*16637*/             OPC_EmitInteger, MVT::i32, 0, 
/*16640*/             OPC_EmitInteger, MVT::i32, 0, 
/*16643*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16655*/             OPC_EmitInteger, MVT::i32, 1, 
/*16658*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*16661*/             OPC_EmitInteger, MVT::i32, 0, 
/*16664*/             OPC_EmitInteger, MVT::i32, 0, 
/*16667*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SNE), 0,
                          1/*#VTs*/, MVT::f32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                      // Src: (selectcc:f32 f32:f32:$src0, f32:f32:$src1, (fpimm:f32)<<P:Predicate_FP_ONE>>, (fpimm:f32)<<P:Predicate_FP_ZERO>>, (cond:Other)<<P:Predicate_COND_UNE_NE>>) - Complexity = 11
                      // Dst: (SNE:f32 f32:f32:$src0, f32:f32:$src1)
/*16694*/           0, /*End of Scope*/
/*16695*/         0, /*End of Scope*/
/*16696*/       /*Scope*/ 7|128,5/*647*/, /*->17345*/
/*16698*/         OPC_MoveChild, 1,
/*16700*/         OPC_CheckOpcode, TARGET_VAL(ISD::ConstantFP),
/*16703*/         OPC_CheckPredicate, 108, // Predicate_FP_ZERO
/*16705*/         OPC_MoveParent,
/*16706*/         OPC_RecordChild2, // #1 = $src1
/*16707*/         OPC_RecordChild3, // #2 = $src2
/*16708*/         OPC_MoveChild, 4,
/*16710*/         OPC_CheckOpcode, TARGET_VAL(ISD::CONDCODE),
/*16713*/         OPC_Scope, 104, /*->16819*/ // 6 children in Scope
/*16715*/           OPC_CheckPredicate, 103, // Predicate_COND_OEQ
/*16717*/           OPC_MoveParent,
/*16718*/           OPC_CheckType, MVT::f32,
/*16720*/           OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*16722*/           OPC_EmitInteger, MVT::i32, 0, 
/*16725*/           OPC_EmitInteger, MVT::i32, 0, 
/*16728*/           OPC_EmitInteger, MVT::i32, 0, 
/*16731*/           OPC_EmitInteger, MVT::i32, 0, 
/*16734*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16746*/           OPC_EmitInteger, MVT::i32, 0, 
/*16749*/           OPC_EmitInteger, MVT::i32, 0, 
/*16752*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16764*/           OPC_EmitInteger, MVT::i32, 0, 
/*16767*/           OPC_EmitInteger, MVT::i32, 0, 
/*16770*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16782*/           OPC_EmitInteger, MVT::i32, 1, 
/*16785*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*16788*/           OPC_EmitInteger, MVT::i32, 0, 
/*16791*/           OPC_EmitInteger, MVT::i32, 0, 
/*16794*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDE_r600), 0,
                        1/*#VTs*/, MVT::f32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (selectcc:f32 f32:f32:$src0, (fpimm:f32)<<P:Predicate_FP_ZERO>>, f32:f32:$src1, f32:f32:$src2, (cond:Other)<<P:Predicate_COND_OEQ>>) - Complexity = 7
                    // Dst: (CNDE_r600:f32 f32:f32:$src0, f32:f32:$src1, f32:f32:$src2)
/*16819*/         /*Scope*/ 104, /*->16924*/
/*16820*/           OPC_CheckPredicate, 104, // Predicate_COND_OGT
/*16822*/           OPC_MoveParent,
/*16823*/           OPC_CheckType, MVT::f32,
/*16825*/           OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*16827*/           OPC_EmitInteger, MVT::i32, 0, 
/*16830*/           OPC_EmitInteger, MVT::i32, 0, 
/*16833*/           OPC_EmitInteger, MVT::i32, 0, 
/*16836*/           OPC_EmitInteger, MVT::i32, 0, 
/*16839*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16851*/           OPC_EmitInteger, MVT::i32, 0, 
/*16854*/           OPC_EmitInteger, MVT::i32, 0, 
/*16857*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16869*/           OPC_EmitInteger, MVT::i32, 0, 
/*16872*/           OPC_EmitInteger, MVT::i32, 0, 
/*16875*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16887*/           OPC_EmitInteger, MVT::i32, 1, 
/*16890*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*16893*/           OPC_EmitInteger, MVT::i32, 0, 
/*16896*/           OPC_EmitInteger, MVT::i32, 0, 
/*16899*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDGT_r600), 0,
                        1/*#VTs*/, MVT::f32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (selectcc:f32 f32:f32:$src0, (fpimm:f32)<<P:Predicate_FP_ZERO>>, f32:f32:$src1, f32:f32:$src2, (cond:Other)<<P:Predicate_COND_OGT>>) - Complexity = 7
                    // Dst: (CNDGT_r600:f32 f32:f32:$src0, f32:f32:$src1, f32:f32:$src2)
/*16924*/         /*Scope*/ 104, /*->17029*/
/*16925*/           OPC_CheckPredicate, 105, // Predicate_COND_OGE
/*16927*/           OPC_MoveParent,
/*16928*/           OPC_CheckType, MVT::f32,
/*16930*/           OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*16932*/           OPC_EmitInteger, MVT::i32, 0, 
/*16935*/           OPC_EmitInteger, MVT::i32, 0, 
/*16938*/           OPC_EmitInteger, MVT::i32, 0, 
/*16941*/           OPC_EmitInteger, MVT::i32, 0, 
/*16944*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16956*/           OPC_EmitInteger, MVT::i32, 0, 
/*16959*/           OPC_EmitInteger, MVT::i32, 0, 
/*16962*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16974*/           OPC_EmitInteger, MVT::i32, 0, 
/*16977*/           OPC_EmitInteger, MVT::i32, 0, 
/*16980*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*16992*/           OPC_EmitInteger, MVT::i32, 1, 
/*16995*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*16998*/           OPC_EmitInteger, MVT::i32, 0, 
/*17001*/           OPC_EmitInteger, MVT::i32, 0, 
/*17004*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDGE_r600), 0,
                        1/*#VTs*/, MVT::f32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (selectcc:f32 f32:f32:$src0, (fpimm:f32)<<P:Predicate_FP_ZERO>>, f32:f32:$src1, f32:f32:$src2, (cond:Other)<<P:Predicate_COND_OGE>>) - Complexity = 7
                    // Dst: (CNDGE_r600:f32 f32:f32:$src0, f32:f32:$src1, f32:f32:$src2)
/*17029*/         /*Scope*/ 104, /*->17134*/
/*17030*/           OPC_CheckPredicate, 103, // Predicate_COND_OEQ
/*17032*/           OPC_MoveParent,
/*17033*/           OPC_CheckType, MVT::f32,
/*17035*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*17037*/           OPC_EmitInteger, MVT::i32, 0, 
/*17040*/           OPC_EmitInteger, MVT::i32, 0, 
/*17043*/           OPC_EmitInteger, MVT::i32, 0, 
/*17046*/           OPC_EmitInteger, MVT::i32, 0, 
/*17049*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17061*/           OPC_EmitInteger, MVT::i32, 0, 
/*17064*/           OPC_EmitInteger, MVT::i32, 0, 
/*17067*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17079*/           OPC_EmitInteger, MVT::i32, 0, 
/*17082*/           OPC_EmitInteger, MVT::i32, 0, 
/*17085*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17097*/           OPC_EmitInteger, MVT::i32, 1, 
/*17100*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*17103*/           OPC_EmitInteger, MVT::i32, 0, 
/*17106*/           OPC_EmitInteger, MVT::i32, 0, 
/*17109*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDE_eg), 0,
                        1/*#VTs*/, MVT::f32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (selectcc:f32 f32:f32:$src0, (fpimm:f32)<<P:Predicate_FP_ZERO>>, f32:f32:$src1, f32:f32:$src2, (cond:Other)<<P:Predicate_COND_OEQ>>) - Complexity = 7
                    // Dst: (CNDE_eg:f32 f32:f32:$src0, f32:f32:$src1, f32:f32:$src2)
/*17134*/         /*Scope*/ 104, /*->17239*/
/*17135*/           OPC_CheckPredicate, 104, // Predicate_COND_OGT
/*17137*/           OPC_MoveParent,
/*17138*/           OPC_CheckType, MVT::f32,
/*17140*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*17142*/           OPC_EmitInteger, MVT::i32, 0, 
/*17145*/           OPC_EmitInteger, MVT::i32, 0, 
/*17148*/           OPC_EmitInteger, MVT::i32, 0, 
/*17151*/           OPC_EmitInteger, MVT::i32, 0, 
/*17154*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17166*/           OPC_EmitInteger, MVT::i32, 0, 
/*17169*/           OPC_EmitInteger, MVT::i32, 0, 
/*17172*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17184*/           OPC_EmitInteger, MVT::i32, 0, 
/*17187*/           OPC_EmitInteger, MVT::i32, 0, 
/*17190*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17202*/           OPC_EmitInteger, MVT::i32, 1, 
/*17205*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*17208*/           OPC_EmitInteger, MVT::i32, 0, 
/*17211*/           OPC_EmitInteger, MVT::i32, 0, 
/*17214*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDGT_eg), 0,
                        1/*#VTs*/, MVT::f32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (selectcc:f32 f32:f32:$src0, (fpimm:f32)<<P:Predicate_FP_ZERO>>, f32:f32:$src1, f32:f32:$src2, (cond:Other)<<P:Predicate_COND_OGT>>) - Complexity = 7
                    // Dst: (CNDGT_eg:f32 f32:f32:$src0, f32:f32:$src1, f32:f32:$src2)
/*17239*/         /*Scope*/ 104, /*->17344*/
/*17240*/           OPC_CheckPredicate, 105, // Predicate_COND_OGE
/*17242*/           OPC_MoveParent,
/*17243*/           OPC_CheckType, MVT::f32,
/*17245*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*17247*/           OPC_EmitInteger, MVT::i32, 0, 
/*17250*/           OPC_EmitInteger, MVT::i32, 0, 
/*17253*/           OPC_EmitInteger, MVT::i32, 0, 
/*17256*/           OPC_EmitInteger, MVT::i32, 0, 
/*17259*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17271*/           OPC_EmitInteger, MVT::i32, 0, 
/*17274*/           OPC_EmitInteger, MVT::i32, 0, 
/*17277*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17289*/           OPC_EmitInteger, MVT::i32, 0, 
/*17292*/           OPC_EmitInteger, MVT::i32, 0, 
/*17295*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17307*/           OPC_EmitInteger, MVT::i32, 1, 
/*17310*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*17313*/           OPC_EmitInteger, MVT::i32, 0, 
/*17316*/           OPC_EmitInteger, MVT::i32, 0, 
/*17319*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDGE_eg), 0,
                        1/*#VTs*/, MVT::f32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (selectcc:f32 f32:f32:$src0, (fpimm:f32)<<P:Predicate_FP_ZERO>>, f32:f32:$src1, f32:f32:$src2, (cond:Other)<<P:Predicate_COND_OGE>>) - Complexity = 7
                    // Dst: (CNDGE_eg:f32 f32:f32:$src0, f32:f32:$src1, f32:f32:$src2)
/*17344*/         0, /*End of Scope*/
/*17345*/       0, /*End of Scope*/
/*17346*/     /*Scope*/ 28|128,11/*1436*/, /*->18784*/
/*17348*/       OPC_CheckChild0Type, MVT::i32,
/*17350*/       OPC_Scope, 20|128,5/*660*/, /*->18013*/ // 3 children in Scope
/*17353*/         OPC_RecordChild1, // #1 = $src1
/*17354*/         OPC_CheckChild2Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17365*/         OPC_CheckChild3Integer, 0, 
/*17367*/         OPC_MoveChild, 4,
/*17369*/         OPC_Scope, 106, /*->17477*/ // 6 children in Scope
/*17371*/           OPC_CheckCondCode, ISD::SETEQ,
/*17373*/           OPC_MoveParent,
/*17374*/           OPC_CheckType, MVT::i32,
/*17376*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*17378*/           OPC_EmitInteger, MVT::i32, 0, 
/*17381*/           OPC_EmitInteger, MVT::i32, 0, 
/*17384*/           OPC_EmitInteger, MVT::i32, 1, 
/*17387*/           OPC_EmitInteger, MVT::i32, 0, 
/*17390*/           OPC_EmitInteger, MVT::i32, 0, 
/*17393*/           OPC_EmitInteger, MVT::i32, 0, 
/*17396*/           OPC_EmitInteger, MVT::i32, 0, 
/*17399*/           OPC_EmitInteger, MVT::i32, 0, 
/*17402*/           OPC_EmitInteger, MVT::i32, 0, 
/*17405*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17417*/           OPC_EmitInteger, MVT::i32, 0, 
/*17420*/           OPC_EmitInteger, MVT::i32, 0, 
/*17423*/           OPC_EmitInteger, MVT::i32, 0, 
/*17426*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17438*/           OPC_EmitInteger, MVT::i32, 1, 
/*17441*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*17444*/           OPC_EmitInteger, MVT::i32, 0, 
/*17447*/           OPC_EmitInteger, MVT::i32, 0, 
/*17450*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SETE_INT), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                    // Src: (selectcc:i32 i32:i32:$src0, i32:i32:$src1, -1:i32, 0:i32, SETEQ:Other) - Complexity = 13
                    // Dst: (SETE_INT:i32 i32:i32:$src0, i32:i32:$src1)
/*17477*/         /*Scope*/ 106, /*->17584*/
/*17478*/           OPC_CheckCondCode, ISD::SETGT,
/*17480*/           OPC_MoveParent,
/*17481*/           OPC_CheckType, MVT::i32,
/*17483*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*17485*/           OPC_EmitInteger, MVT::i32, 0, 
/*17488*/           OPC_EmitInteger, MVT::i32, 0, 
/*17491*/           OPC_EmitInteger, MVT::i32, 1, 
/*17494*/           OPC_EmitInteger, MVT::i32, 0, 
/*17497*/           OPC_EmitInteger, MVT::i32, 0, 
/*17500*/           OPC_EmitInteger, MVT::i32, 0, 
/*17503*/           OPC_EmitInteger, MVT::i32, 0, 
/*17506*/           OPC_EmitInteger, MVT::i32, 0, 
/*17509*/           OPC_EmitInteger, MVT::i32, 0, 
/*17512*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17524*/           OPC_EmitInteger, MVT::i32, 0, 
/*17527*/           OPC_EmitInteger, MVT::i32, 0, 
/*17530*/           OPC_EmitInteger, MVT::i32, 0, 
/*17533*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17545*/           OPC_EmitInteger, MVT::i32, 1, 
/*17548*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*17551*/           OPC_EmitInteger, MVT::i32, 0, 
/*17554*/           OPC_EmitInteger, MVT::i32, 0, 
/*17557*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SETGT_INT), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                    // Src: (selectcc:i32 i32:i32:$src0, i32:i32:$src1, -1:i32, 0:i32, SETGT:Other) - Complexity = 13
                    // Dst: (SETGT_INT:i32 i32:i32:$src0, i32:i32:$src1)
/*17584*/         /*Scope*/ 106, /*->17691*/
/*17585*/           OPC_CheckCondCode, ISD::SETGE,
/*17587*/           OPC_MoveParent,
/*17588*/           OPC_CheckType, MVT::i32,
/*17590*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*17592*/           OPC_EmitInteger, MVT::i32, 0, 
/*17595*/           OPC_EmitInteger, MVT::i32, 0, 
/*17598*/           OPC_EmitInteger, MVT::i32, 1, 
/*17601*/           OPC_EmitInteger, MVT::i32, 0, 
/*17604*/           OPC_EmitInteger, MVT::i32, 0, 
/*17607*/           OPC_EmitInteger, MVT::i32, 0, 
/*17610*/           OPC_EmitInteger, MVT::i32, 0, 
/*17613*/           OPC_EmitInteger, MVT::i32, 0, 
/*17616*/           OPC_EmitInteger, MVT::i32, 0, 
/*17619*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17631*/           OPC_EmitInteger, MVT::i32, 0, 
/*17634*/           OPC_EmitInteger, MVT::i32, 0, 
/*17637*/           OPC_EmitInteger, MVT::i32, 0, 
/*17640*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17652*/           OPC_EmitInteger, MVT::i32, 1, 
/*17655*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*17658*/           OPC_EmitInteger, MVT::i32, 0, 
/*17661*/           OPC_EmitInteger, MVT::i32, 0, 
/*17664*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SETGE_INT), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                    // Src: (selectcc:i32 i32:i32:$src0, i32:i32:$src1, -1:i32, 0:i32, SETGE:Other) - Complexity = 13
                    // Dst: (SETGE_INT:i32 i32:i32:$src0, i32:i32:$src1)
/*17691*/         /*Scope*/ 106, /*->17798*/
/*17692*/           OPC_CheckCondCode, ISD::SETNE,
/*17694*/           OPC_MoveParent,
/*17695*/           OPC_CheckType, MVT::i32,
/*17697*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*17699*/           OPC_EmitInteger, MVT::i32, 0, 
/*17702*/           OPC_EmitInteger, MVT::i32, 0, 
/*17705*/           OPC_EmitInteger, MVT::i32, 1, 
/*17708*/           OPC_EmitInteger, MVT::i32, 0, 
/*17711*/           OPC_EmitInteger, MVT::i32, 0, 
/*17714*/           OPC_EmitInteger, MVT::i32, 0, 
/*17717*/           OPC_EmitInteger, MVT::i32, 0, 
/*17720*/           OPC_EmitInteger, MVT::i32, 0, 
/*17723*/           OPC_EmitInteger, MVT::i32, 0, 
/*17726*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17738*/           OPC_EmitInteger, MVT::i32, 0, 
/*17741*/           OPC_EmitInteger, MVT::i32, 0, 
/*17744*/           OPC_EmitInteger, MVT::i32, 0, 
/*17747*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17759*/           OPC_EmitInteger, MVT::i32, 1, 
/*17762*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*17765*/           OPC_EmitInteger, MVT::i32, 0, 
/*17768*/           OPC_EmitInteger, MVT::i32, 0, 
/*17771*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SETNE_INT), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                    // Src: (selectcc:i32 i32:i32:$src0, i32:i32:$src1, -1:i32, 0:i32, SETNE:Other) - Complexity = 13
                    // Dst: (SETNE_INT:i32 i32:i32:$src0, i32:i32:$src1)
/*17798*/         /*Scope*/ 106, /*->17905*/
/*17799*/           OPC_CheckCondCode, ISD::SETUGT,
/*17801*/           OPC_MoveParent,
/*17802*/           OPC_CheckType, MVT::i32,
/*17804*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*17806*/           OPC_EmitInteger, MVT::i32, 0, 
/*17809*/           OPC_EmitInteger, MVT::i32, 0, 
/*17812*/           OPC_EmitInteger, MVT::i32, 1, 
/*17815*/           OPC_EmitInteger, MVT::i32, 0, 
/*17818*/           OPC_EmitInteger, MVT::i32, 0, 
/*17821*/           OPC_EmitInteger, MVT::i32, 0, 
/*17824*/           OPC_EmitInteger, MVT::i32, 0, 
/*17827*/           OPC_EmitInteger, MVT::i32, 0, 
/*17830*/           OPC_EmitInteger, MVT::i32, 0, 
/*17833*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17845*/           OPC_EmitInteger, MVT::i32, 0, 
/*17848*/           OPC_EmitInteger, MVT::i32, 0, 
/*17851*/           OPC_EmitInteger, MVT::i32, 0, 
/*17854*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17866*/           OPC_EmitInteger, MVT::i32, 1, 
/*17869*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*17872*/           OPC_EmitInteger, MVT::i32, 0, 
/*17875*/           OPC_EmitInteger, MVT::i32, 0, 
/*17878*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SETGT_UINT), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                    // Src: (selectcc:i32 i32:i32:$src0, i32:i32:$src1, -1:i32, 0:i32, SETUGT:Other) - Complexity = 13
                    // Dst: (SETGT_UINT:i32 i32:i32:$src0, i32:i32:$src1)
/*17905*/         /*Scope*/ 106, /*->18012*/
/*17906*/           OPC_CheckCondCode, ISD::SETUGE,
/*17908*/           OPC_MoveParent,
/*17909*/           OPC_CheckType, MVT::i32,
/*17911*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*17913*/           OPC_EmitInteger, MVT::i32, 0, 
/*17916*/           OPC_EmitInteger, MVT::i32, 0, 
/*17919*/           OPC_EmitInteger, MVT::i32, 1, 
/*17922*/           OPC_EmitInteger, MVT::i32, 0, 
/*17925*/           OPC_EmitInteger, MVT::i32, 0, 
/*17928*/           OPC_EmitInteger, MVT::i32, 0, 
/*17931*/           OPC_EmitInteger, MVT::i32, 0, 
/*17934*/           OPC_EmitInteger, MVT::i32, 0, 
/*17937*/           OPC_EmitInteger, MVT::i32, 0, 
/*17940*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17952*/           OPC_EmitInteger, MVT::i32, 0, 
/*17955*/           OPC_EmitInteger, MVT::i32, 0, 
/*17958*/           OPC_EmitInteger, MVT::i32, 0, 
/*17961*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*17973*/           OPC_EmitInteger, MVT::i32, 1, 
/*17976*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*17979*/           OPC_EmitInteger, MVT::i32, 0, 
/*17982*/           OPC_EmitInteger, MVT::i32, 0, 
/*17985*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SETGE_UINT), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                    // Src: (selectcc:i32 i32:i32:$src0, i32:i32:$src1, -1:i32, 0:i32, SETUGE:Other) - Complexity = 13
                    // Dst: (SETGE_UINT:i32 i32:i32:$src0, i32:i32:$src1)
/*18012*/         0, /*End of Scope*/
/*18013*/       /*Scope*/ 5|128,5/*645*/, /*->18660*/
/*18015*/         OPC_CheckChild1Integer, 0, 
/*18017*/         OPC_RecordChild2, // #1 = $src1
/*18018*/         OPC_RecordChild3, // #2 = $src2
/*18019*/         OPC_MoveChild, 4,
/*18021*/         OPC_Scope, 64|128,2/*320*/, /*->18344*/ // 4 children in Scope
/*18024*/           OPC_CheckOpcode, TARGET_VAL(ISD::CONDCODE),
/*18027*/           OPC_Scope, 104, /*->18133*/ // 3 children in Scope
/*18029*/             OPC_CheckPredicate, 109, // Predicate_COND_EQ
/*18031*/             OPC_MoveParent,
/*18032*/             OPC_CheckType, MVT::i32,
/*18034*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*18036*/             OPC_EmitInteger, MVT::i32, 0, 
/*18039*/             OPC_EmitInteger, MVT::i32, 0, 
/*18042*/             OPC_EmitInteger, MVT::i32, 0, 
/*18045*/             OPC_EmitInteger, MVT::i32, 0, 
/*18048*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18060*/             OPC_EmitInteger, MVT::i32, 0, 
/*18063*/             OPC_EmitInteger, MVT::i32, 0, 
/*18066*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18078*/             OPC_EmitInteger, MVT::i32, 0, 
/*18081*/             OPC_EmitInteger, MVT::i32, 0, 
/*18084*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18096*/             OPC_EmitInteger, MVT::i32, 1, 
/*18099*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*18102*/             OPC_EmitInteger, MVT::i32, 0, 
/*18105*/             OPC_EmitInteger, MVT::i32, 0, 
/*18108*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDE_INT), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                      // Src: (selectcc:i32 i32:i32:$src0, 0:i32, i32:i32:$src1, i32:i32:$src2, (cond:Other)<<P:Predicate_COND_EQ>>) - Complexity = 8
                      // Dst: (CNDE_INT:i32 i32:i32:$src0, i32:i32:$src1, i32:i32:$src2)
/*18133*/           /*Scope*/ 104, /*->18238*/
/*18134*/             OPC_CheckPredicate, 110, // Predicate_COND_SGE
/*18136*/             OPC_MoveParent,
/*18137*/             OPC_CheckType, MVT::i32,
/*18139*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*18141*/             OPC_EmitInteger, MVT::i32, 0, 
/*18144*/             OPC_EmitInteger, MVT::i32, 0, 
/*18147*/             OPC_EmitInteger, MVT::i32, 0, 
/*18150*/             OPC_EmitInteger, MVT::i32, 0, 
/*18153*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18165*/             OPC_EmitInteger, MVT::i32, 0, 
/*18168*/             OPC_EmitInteger, MVT::i32, 0, 
/*18171*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18183*/             OPC_EmitInteger, MVT::i32, 0, 
/*18186*/             OPC_EmitInteger, MVT::i32, 0, 
/*18189*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18201*/             OPC_EmitInteger, MVT::i32, 1, 
/*18204*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*18207*/             OPC_EmitInteger, MVT::i32, 0, 
/*18210*/             OPC_EmitInteger, MVT::i32, 0, 
/*18213*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDGE_INT), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                      // Src: (selectcc:i32 i32:i32:$src0, 0:i32, i32:i32:$src1, i32:i32:$src2, (cond:Other)<<P:Predicate_COND_SGE>>) - Complexity = 8
                      // Dst: (CNDGE_INT:i32 i32:i32:$src0, i32:i32:$src1, i32:i32:$src2)
/*18238*/           /*Scope*/ 104, /*->18343*/
/*18239*/             OPC_CheckPredicate, 111, // Predicate_COND_SGT
/*18241*/             OPC_MoveParent,
/*18242*/             OPC_CheckType, MVT::i32,
/*18244*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*18246*/             OPC_EmitInteger, MVT::i32, 0, 
/*18249*/             OPC_EmitInteger, MVT::i32, 0, 
/*18252*/             OPC_EmitInteger, MVT::i32, 0, 
/*18255*/             OPC_EmitInteger, MVT::i32, 0, 
/*18258*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18270*/             OPC_EmitInteger, MVT::i32, 0, 
/*18273*/             OPC_EmitInteger, MVT::i32, 0, 
/*18276*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18288*/             OPC_EmitInteger, MVT::i32, 0, 
/*18291*/             OPC_EmitInteger, MVT::i32, 0, 
/*18294*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18306*/             OPC_EmitInteger, MVT::i32, 1, 
/*18309*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*18312*/             OPC_EmitInteger, MVT::i32, 0, 
/*18315*/             OPC_EmitInteger, MVT::i32, 0, 
/*18318*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDGT_INT), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                      // Src: (selectcc:i32 i32:i32:$src0, 0:i32, i32:i32:$src1, i32:i32:$src2, (cond:Other)<<P:Predicate_COND_SGT>>) - Complexity = 8
                      // Dst: (CNDGT_INT:i32 i32:i32:$src0, i32:i32:$src1, i32:i32:$src2)
/*18343*/           0, /*End of Scope*/
/*18344*/         /*Scope*/ 104, /*->18449*/
/*18345*/           OPC_CheckCondCode, ISD::SETEQ,
/*18347*/           OPC_MoveParent,
/*18348*/           OPC_CheckType, MVT::f32,
/*18350*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*18352*/           OPC_EmitInteger, MVT::i32, 0, 
/*18355*/           OPC_EmitInteger, MVT::i32, 0, 
/*18358*/           OPC_EmitInteger, MVT::i32, 0, 
/*18361*/           OPC_EmitInteger, MVT::i32, 0, 
/*18364*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18376*/           OPC_EmitInteger, MVT::i32, 0, 
/*18379*/           OPC_EmitInteger, MVT::i32, 0, 
/*18382*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18394*/           OPC_EmitInteger, MVT::i32, 0, 
/*18397*/           OPC_EmitInteger, MVT::i32, 0, 
/*18400*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18412*/           OPC_EmitInteger, MVT::i32, 1, 
/*18415*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*18418*/           OPC_EmitInteger, MVT::i32, 0, 
/*18421*/           OPC_EmitInteger, MVT::i32, 0, 
/*18424*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDE_INT), 0,
                        1/*#VTs*/, MVT::f32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (selectcc:f32 i32:i32:$src0, 0:i32, f32:f32:$src1, f32:f32:$src2, SETEQ:Other) - Complexity = 8
                    // Dst: (CNDE_INT:f32 ?:i32:$src0, ?:f32:$src1, ?:f32:$src2)
/*18449*/         /*Scope*/ 104, /*->18554*/
/*18450*/           OPC_CheckCondCode, ISD::SETGT,
/*18452*/           OPC_MoveParent,
/*18453*/           OPC_CheckType, MVT::f32,
/*18455*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*18457*/           OPC_EmitInteger, MVT::i32, 0, 
/*18460*/           OPC_EmitInteger, MVT::i32, 0, 
/*18463*/           OPC_EmitInteger, MVT::i32, 0, 
/*18466*/           OPC_EmitInteger, MVT::i32, 0, 
/*18469*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18481*/           OPC_EmitInteger, MVT::i32, 0, 
/*18484*/           OPC_EmitInteger, MVT::i32, 0, 
/*18487*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18499*/           OPC_EmitInteger, MVT::i32, 0, 
/*18502*/           OPC_EmitInteger, MVT::i32, 0, 
/*18505*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18517*/           OPC_EmitInteger, MVT::i32, 1, 
/*18520*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*18523*/           OPC_EmitInteger, MVT::i32, 0, 
/*18526*/           OPC_EmitInteger, MVT::i32, 0, 
/*18529*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDGT_INT), 0,
                        1/*#VTs*/, MVT::f32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (selectcc:f32 i32:i32:$src0, 0:i32, f32:f32:$src1, f32:f32:$src2, SETGT:Other) - Complexity = 8
                    // Dst: (CNDGT_INT:f32 ?:i32:$src0, ?:f32:$src1, ?:f32:$src2)
/*18554*/         /*Scope*/ 104, /*->18659*/
/*18555*/           OPC_CheckCondCode, ISD::SETGE,
/*18557*/           OPC_MoveParent,
/*18558*/           OPC_CheckType, MVT::f32,
/*18560*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*18562*/           OPC_EmitInteger, MVT::i32, 0, 
/*18565*/           OPC_EmitInteger, MVT::i32, 0, 
/*18568*/           OPC_EmitInteger, MVT::i32, 0, 
/*18571*/           OPC_EmitInteger, MVT::i32, 0, 
/*18574*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18586*/           OPC_EmitInteger, MVT::i32, 0, 
/*18589*/           OPC_EmitInteger, MVT::i32, 0, 
/*18592*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18604*/           OPC_EmitInteger, MVT::i32, 0, 
/*18607*/           OPC_EmitInteger, MVT::i32, 0, 
/*18610*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18622*/           OPC_EmitInteger, MVT::i32, 1, 
/*18625*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*18628*/           OPC_EmitInteger, MVT::i32, 0, 
/*18631*/           OPC_EmitInteger, MVT::i32, 0, 
/*18634*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDGE_INT), 0,
                        1/*#VTs*/, MVT::f32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (selectcc:f32 i32:i32:$src0, 0:i32, f32:f32:$src1, f32:f32:$src2, SETGE:Other) - Complexity = 8
                    // Dst: (CNDGE_INT:f32 ?:i32:$src0, ?:f32:$src1, ?:f32:$src2)
/*18659*/         0, /*End of Scope*/
/*18660*/       /*Scope*/ 122, /*->18783*/
/*18661*/         OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18672*/         OPC_RecordChild2, // #1 = $src1
/*18673*/         OPC_RecordChild3, // #2 = $src2
/*18674*/         OPC_MoveChild, 4,
/*18676*/         OPC_CheckOpcode, TARGET_VAL(ISD::CONDCODE),
/*18679*/         OPC_CheckPredicate, 111, // Predicate_COND_SGT
/*18681*/         OPC_MoveParent,
/*18682*/         OPC_CheckType, MVT::i32,
/*18684*/         OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*18686*/         OPC_EmitInteger, MVT::i32, 0, 
/*18689*/         OPC_EmitInteger, MVT::i32, 0, 
/*18692*/         OPC_EmitInteger, MVT::i32, 0, 
/*18695*/         OPC_EmitInteger, MVT::i32, 0, 
/*18698*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18710*/         OPC_EmitInteger, MVT::i32, 0, 
/*18713*/         OPC_EmitInteger, MVT::i32, 0, 
/*18716*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18728*/         OPC_EmitInteger, MVT::i32, 0, 
/*18731*/         OPC_EmitInteger, MVT::i32, 0, 
/*18734*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18746*/         OPC_EmitInteger, MVT::i32, 1, 
/*18749*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*18752*/         OPC_EmitInteger, MVT::i32, 0, 
/*18755*/         OPC_EmitInteger, MVT::i32, 0, 
/*18758*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CNDGE_INT), 0,
                      1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                  // Src: (selectcc:i32 i32:i32:$src0, -1:i32, i32:i32:$src1, i32:i32:$src2, (cond:Other)<<P:Predicate_COND_SGT>>) - Complexity = 8
                  // Dst: (CNDGE_INT:i32 ?:i32:$src0, ?:i32:$src1, ?:i32:$src2)
/*18783*/       0, /*End of Scope*/
/*18784*/     0, /*End of Scope*/
/*18785*/   /*SwitchOpcode*/ 25|128,1/*153*/, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),// ->18942
/*18789*/     OPC_RecordMemRef,
/*18790*/     OPC_RecordNode, // #0 = 'si_atomic_cmp_swap_glue' chained node
/*18791*/     OPC_Scope, 62, /*->18855*/ // 2 children in Scope
/*18793*/       OPC_CaptureGlueInput,
/*18794*/       OPC_RecordChild1, // #1 = $DS1Addr1Offset:ptr:offset
/*18795*/       OPC_RecordChild2, // #2 = $cmp
/*18796*/       OPC_RecordChild3, // #3 = $swap
/*18797*/       OPC_SwitchType /*2 cases */, 26, MVT::i32,// ->18826
/*18800*/         OPC_CheckPredicate, 112, // Predicate_si_atomic_cmp_swap_32_local
/*18802*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*18804*/         OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #4 #5
/*18807*/         OPC_EmitMergeInputChains1_0,
/*18808*/         OPC_EmitNodeXForm, 0, 5, // as_i16imm
/*18811*/         OPC_EmitInteger, MVT::i1, 0, 
/*18814*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_CMPST_RTN_B32), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i32, 5/*#Ops*/, 4, 2, 3, 6, 7, 
                  // Src: (si_atomic_cmp_swap_glue:i32 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i32:i32:$cmp, i32:i32:$swap)<<P:Predicate_si_atomic_cmp_swap_32_local>> - Complexity = 13
                  // Dst: (DS_CMPST_RTN_B32:i32 ?:i32:$ptr, ?:i32:$cmp, ?:i32:$swap, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*18826*/       /*SwitchType*/ 26, MVT::i64,// ->18854
/*18828*/         OPC_CheckPredicate, 113, // Predicate_si_atomic_cmp_swap_64_local
/*18830*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*18832*/         OPC_CheckComplexPat, /*CP*/0, /*#*/1, // SelectDS1Addr1Offset:$ #4 #5
/*18835*/         OPC_EmitMergeInputChains1_0,
/*18836*/         OPC_EmitNodeXForm, 0, 5, // as_i16imm
/*18839*/         OPC_EmitInteger, MVT::i1, 0, 
/*18842*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::DS_CMPST_RTN_B64), 0|OPFL_Chain|OPFL_GlueInput|OPFL_MemRefs,
                      1/*#VTs*/, MVT::i64, 5/*#Ops*/, 4, 2, 3, 6, 7, 
                  // Src: (si_atomic_cmp_swap_glue:i64 (DS1Addr1Offset:iPTR i32:i32:$ptr, i32:i32:$offset), i64:i64:$cmp, i64:i64:$swap)<<P:Predicate_si_atomic_cmp_swap_64_local>> - Complexity = 13
                  // Dst: (DS_CMPST_RTN_B64:i64 ?:i32:$ptr, ?:i64:$cmp, ?:i64:$swap, (as_i16imm:i16 ?:i32:$offset), 0:i1)
/*18854*/       0, // EndSwitchType
/*18855*/     /*Scope*/ 85, /*->18941*/
/*18856*/       OPC_RecordChild1, // #1 = $src0
/*18857*/       OPC_CheckChild1Type, MVT::i32,
/*18859*/       OPC_RecordChild2, // #2 = $src1
/*18860*/       OPC_RecordChild3, // #3 = $src2
/*18861*/       OPC_CheckPredicate, 114, // Predicate_atomic_cmp_swap_32_local
/*18863*/       OPC_CheckType, MVT::i32,
/*18865*/       OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*18867*/       OPC_EmitMergeInputChains1_0,
/*18868*/       OPC_EmitInteger, MVT::i32, 0, 
/*18871*/       OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18883*/       OPC_EmitInteger, MVT::i32, 0, 
/*18886*/       OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18898*/       OPC_EmitInteger, MVT::i32, 0, 
/*18901*/       OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*18913*/       OPC_EmitInteger, MVT::i32, 1, 
/*18916*/       OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*18919*/       OPC_EmitInteger, MVT::i32, 0, 
/*18922*/       OPC_MorphNodeTo, TARGET_VAL(AMDGPU::LDS_CMPST_RET), 0|OPFL_Chain|OPFL_MemRefs,
                    1/*#VTs*/, MVT::i32, 12/*#Ops*/, 1, 4, 5, 2, 6, 7, 3, 8, 9, 10, 11, 12, 
                // Src: (atomic_cmp_swap:i32 i32:i32:$src0, i32:i32:$src1, i32:i32:$src2)<<P:Predicate_atomic_cmp_swap_32_local>> - Complexity = 4
                // Dst: (LDS_CMPST_RET:i32 i32:i32:$src0, i32:i32:$src1, i32:i32:$src2)
/*18941*/     0, /*End of Scope*/
/*18942*/   /*SwitchOpcode*/ 56|128,2/*312*/, TARGET_VAL(ISD::AND),// ->19258
/*18946*/     OPC_Scope, 30|128,1/*158*/, /*->19107*/ // 2 children in Scope
/*18949*/       OPC_MoveChild, 0,
/*18951*/       OPC_CheckOpcode, TARGET_VAL(ISD::SRL),
/*18954*/       OPC_RecordChild0, // #0 = $src
/*18955*/       OPC_RecordChild1, // #1 = $rshift
/*18956*/       OPC_CheckChild1Type, MVT::i32,
/*18958*/       OPC_MoveParent,
/*18959*/       OPC_RecordChild1, // #2 = $mask
/*18960*/       OPC_MoveChild, 1,
/*18962*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*18965*/       OPC_CheckPredicate, 115, // Predicate_IMMZeroBasedBitfieldMask
/*18967*/       OPC_MoveParent,
/*18968*/       OPC_CheckType, MVT::i32,
/*18970*/       OPC_Scope, 23, /*->18995*/ // 2 children in Scope
/*18972*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*18974*/         OPC_EmitNodeXForm, 5, 2, // IMMPopCount
/*18977*/         OPC_EmitNode, TARGET_VAL(AMDGPU::S_MOV_B32), 0,
                      1/*#VTs*/, MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/*18985*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFE_U32), 0,
                      1/*#VTs*/, MVT::i32, 3/*#Ops*/, 0, 1, 4, 
                  // Src: (and:i32 (srl:i32 i32:i32:$src, i32:i32:$rshift), (imm:i32)<<P:Predicate_IMMZeroBasedBitfieldMask>>:$mask) - Complexity = 10
                  // Dst: (V_BFE_U32:i32 ?:i32:$src, ?:i32:$rshift, (S_MOV_B32:i32 (IMMPopCount:i32 ?:i32:$mask)))
/*18995*/       /*Scope*/ 110, /*->19106*/
/*18996*/         OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*18998*/         OPC_EmitInteger, MVT::i32, 0, 
/*19001*/         OPC_EmitInteger, MVT::i32, 0, 
/*19004*/         OPC_EmitInteger, MVT::i32, 0, 
/*19007*/         OPC_EmitInteger, MVT::i32, 0, 
/*19010*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19022*/         OPC_EmitInteger, MVT::i32, 0, 
/*19025*/         OPC_EmitInteger, MVT::i32, 0, 
/*19028*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19040*/         OPC_EmitNodeXForm, 5, 2, // IMMPopCount
/*19043*/         OPC_EmitNode, TARGET_VAL(AMDGPU::MOV_IMM_I32), 0,
                      1/*#VTs*/, MVT::i32, 1/*#Ops*/, 11,  // Results = #12
/*19051*/         OPC_EmitInteger, MVT::i32, 0, 
/*19054*/         OPC_EmitInteger, MVT::i32, 0, 
/*19057*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19069*/         OPC_EmitInteger, MVT::i32, 1, 
/*19072*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*19075*/         OPC_EmitInteger, MVT::i32, 0, 
/*19078*/         OPC_EmitInteger, MVT::i32, 0, 
/*19081*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFE_UINT_eg), 0,
                      1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 
                  // Src: (and:i32 (srl:i32 i32:i32:$src, i32:i32:$rshift), (imm:i32)<<P:Predicate_IMMZeroBasedBitfieldMask>>:$mask) - Complexity = 10
                  // Dst: (BFE_UINT_eg:i32 ?:i32:$src, ?:i32:$rshift, (MOV_IMM_I32:i32 (IMMPopCount:i32 ?:i32:$mask)))
/*19106*/       0, /*End of Scope*/
/*19107*/     /*Scope*/ 20|128,1/*148*/, /*->19257*/
/*19109*/       OPC_RecordChild0, // #0 = $src0
/*19110*/       OPC_RecordChild1, // #1 = $src1
/*19111*/       OPC_SwitchType /*3 cases */, 116, MVT::i32,// ->19230
/*19114*/         OPC_Scope, 101, /*->19217*/ // 2 children in Scope
/*19116*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*19118*/           OPC_EmitInteger, MVT::i32, 0, 
/*19121*/           OPC_EmitInteger, MVT::i32, 0, 
/*19124*/           OPC_EmitInteger, MVT::i32, 1, 
/*19127*/           OPC_EmitInteger, MVT::i32, 0, 
/*19130*/           OPC_EmitInteger, MVT::i32, 0, 
/*19133*/           OPC_EmitInteger, MVT::i32, 0, 
/*19136*/           OPC_EmitInteger, MVT::i32, 0, 
/*19139*/           OPC_EmitInteger, MVT::i32, 0, 
/*19142*/           OPC_EmitInteger, MVT::i32, 0, 
/*19145*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19157*/           OPC_EmitInteger, MVT::i32, 0, 
/*19160*/           OPC_EmitInteger, MVT::i32, 0, 
/*19163*/           OPC_EmitInteger, MVT::i32, 0, 
/*19166*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19178*/           OPC_EmitInteger, MVT::i32, 1, 
/*19181*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*19184*/           OPC_EmitInteger, MVT::i32, 0, 
/*19187*/           OPC_EmitInteger, MVT::i32, 0, 
/*19190*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::AND_INT), 0,
                        1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                    // Src: (and:i32 R600_Reg32:i32:$src0, R600_Reg32:i32:$src1) - Complexity = 3
                    // Dst: (AND_INT:i32 R600_Reg32:i32:$src0, R600_Reg32:i32:$src1)
/*19217*/         /*Scope*/ 11, /*->19229*/
/*19218*/           OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*19220*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_AND_B32), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (and:i32 i32:i32:$src0, i32:i32:$src1) - Complexity = 3
                    // Dst: (S_AND_B32:i32 i32:i32:$src0, i32:i32:$src1)
/*19229*/         0, /*End of Scope*/
/*19230*/       /*SwitchType*/ 11, MVT::i64,// ->19243
/*19232*/         OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*19234*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_AND_B64), 0,
                      1/*#VTs*/, MVT::i64, 2/*#Ops*/, 0, 1, 
                  // Src: (and:i64 i64:i64:$src0, i64:i64:$src1) - Complexity = 3
                  // Dst: (S_AND_B64:i64 i64:i64:$src0, i64:i64:$src1)
/*19243*/       /*SwitchType*/ 11, MVT::i1,// ->19256
/*19245*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*19247*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_AND_B64), 0,
                      1/*#VTs*/, MVT::i1, 2/*#Ops*/, 0, 1, 
                  // Src: (and:i1 i1:i1:$src0, i1:i1:$src1) - Complexity = 3
                  // Dst: (S_AND_B64:i1 ?:i1:$src0, ?:i1:$src1)
/*19256*/       0, // EndSwitchType
/*19257*/     0, /*End of Scope*/
/*19258*/   /*SwitchOpcode*/ 93|128,10/*1373*/, TARGET_VAL(ISD::XOR),// ->20635
/*19262*/     OPC_Scope, 83|128,1/*211*/, /*->19476*/ // 5 children in Scope
/*19265*/       OPC_RecordChild0, // #0 = $z
/*19266*/       OPC_MoveChild, 1,
/*19268*/       OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*19271*/       OPC_Scope, 23|128,1/*151*/, /*->19425*/ // 2 children in Scope
/*19274*/         OPC_RecordChild0, // #1 = $x
/*19275*/         OPC_MoveChild, 1,
/*19277*/         OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*19280*/         OPC_Scope, 122, /*->19404*/ // 2 children in Scope
/*19282*/           OPC_RecordChild0, // #2 = $y
/*19283*/           OPC_CheckChild1Same, 0,
/*19285*/           OPC_MoveParent,
/*19286*/           OPC_MoveParent,
/*19287*/           OPC_CheckType, MVT::i32,
/*19289*/           OPC_Scope, 99, /*->19390*/ // 2 children in Scope
/*19291*/             OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*19293*/             OPC_EmitInteger, MVT::i32, 0, 
/*19296*/             OPC_EmitInteger, MVT::i32, 0, 
/*19299*/             OPC_EmitInteger, MVT::i32, 0, 
/*19302*/             OPC_EmitInteger, MVT::i32, 0, 
/*19305*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19317*/             OPC_EmitInteger, MVT::i32, 0, 
/*19320*/             OPC_EmitInteger, MVT::i32, 0, 
/*19323*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19335*/             OPC_EmitInteger, MVT::i32, 0, 
/*19338*/             OPC_EmitInteger, MVT::i32, 0, 
/*19341*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19353*/             OPC_EmitInteger, MVT::i32, 1, 
/*19356*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*19359*/             OPC_EmitInteger, MVT::i32, 0, 
/*19362*/             OPC_EmitInteger, MVT::i32, 0, 
/*19365*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                          1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 1, 5, 6, 7, 2, 8, 9, 10, 0, 11, 12, 13, 14, 15, 16, 17, 
                      // Src: (xor:i32 i32:i32:$z, (and:i32 i32:i32:$x, (xor:i32 i32:i32:$y, i32:i32:$z))) - Complexity = 9
                      // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*19390*/           /*Scope*/ 12, /*->19403*/
/*19391*/             OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*19393*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                          1/*#VTs*/, MVT::i32, 3/*#Ops*/, 1, 2, 0, 
                      // Src: (xor:i32 i32:i32:$z, (and:i32 i32:i32:$x, (xor:i32 i32:i32:$y, i32:i32:$z))) - Complexity = 9
                      // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*19403*/           0, /*End of Scope*/
/*19404*/         /*Scope*/ 19, /*->19424*/
/*19405*/           OPC_CheckChild0Same, 0,
/*19407*/           OPC_RecordChild1, // #2 = $y
/*19408*/           OPC_MoveParent,
/*19409*/           OPC_MoveParent,
/*19410*/           OPC_CheckType, MVT::i32,
/*19412*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*19414*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 1, 2, 0, 
                    // Src: (xor:i32 i32:i32:$z, (and:i32 i32:i32:$x, (xor:i32 i32:i32:$z, i32:i32:$y))) - Complexity = 9
                    // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*19424*/         0, /*End of Scope*/
/*19425*/       /*Scope*/ 49, /*->19475*/
/*19426*/         OPC_MoveChild, 0,
/*19428*/         OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*19431*/         OPC_Scope, 20, /*->19453*/ // 2 children in Scope
/*19433*/           OPC_RecordChild0, // #1 = $y
/*19434*/           OPC_CheckChild1Same, 0,
/*19436*/           OPC_MoveParent,
/*19437*/           OPC_RecordChild1, // #2 = $x
/*19438*/           OPC_MoveParent,
/*19439*/           OPC_CheckType, MVT::i32,
/*19441*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*19443*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 2, 1, 0, 
                    // Src: (xor:i32 i32:i32:$z, (and:i32 (xor:i32 i32:i32:$y, i32:i32:$z), i32:i32:$x)) - Complexity = 9
                    // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*19453*/         /*Scope*/ 20, /*->19474*/
/*19454*/           OPC_CheckChild0Same, 0,
/*19456*/           OPC_RecordChild1, // #1 = $y
/*19457*/           OPC_MoveParent,
/*19458*/           OPC_RecordChild1, // #2 = $x
/*19459*/           OPC_MoveParent,
/*19460*/           OPC_CheckType, MVT::i32,
/*19462*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*19464*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 2, 1, 0, 
                    // Src: (xor:i32 i32:i32:$z, (and:i32 (xor:i32 i32:i32:$z, i32:i32:$y), i32:i32:$x)) - Complexity = 9
                    // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*19474*/         0, /*End of Scope*/
/*19475*/       0, /*End of Scope*/
/*19476*/     /*Scope*/ 97, /*->19574*/
/*19477*/       OPC_MoveChild, 0,
/*19479*/       OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*19482*/       OPC_Scope, 44, /*->19528*/ // 2 children in Scope
/*19484*/         OPC_RecordChild0, // #0 = $x
/*19485*/         OPC_MoveChild, 1,
/*19487*/         OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*19490*/         OPC_RecordChild0, // #1 = $y
/*19491*/         OPC_RecordChild1, // #2 = $z
/*19492*/         OPC_MoveParent,
/*19493*/         OPC_MoveParent,
/*19494*/         OPC_CheckType, MVT::i32,
/*19496*/         OPC_Scope, 14, /*->19512*/ // 2 children in Scope
/*19498*/           OPC_CheckChild1Same, 2,
/*19500*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*19502*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (xor:i32 (and:i32 i32:i32:$x, (xor:i32 i32:i32:$y, i32:i32:$z)), i32:i32:$z) - Complexity = 9
                    // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*19512*/         /*Scope*/ 14, /*->19527*/
/*19513*/           OPC_CheckChild1Same, 1,
/*19515*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*19517*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 0, 2, 1, 
                    // Src: (xor:i32 (and:i32 i32:i32:$x, (xor:i32 i32:i32:$z, i32:i32:$y)), i32:i32:$z) - Complexity = 9
                    // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*19527*/         0, /*End of Scope*/
/*19528*/       /*Scope*/ 44, /*->19573*/
/*19529*/         OPC_MoveChild, 0,
/*19531*/         OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*19534*/         OPC_RecordChild0, // #0 = $y
/*19535*/         OPC_RecordChild1, // #1 = $z
/*19536*/         OPC_MoveParent,
/*19537*/         OPC_RecordChild1, // #2 = $x
/*19538*/         OPC_MoveParent,
/*19539*/         OPC_CheckType, MVT::i32,
/*19541*/         OPC_Scope, 14, /*->19557*/ // 2 children in Scope
/*19543*/           OPC_CheckChild1Same, 1,
/*19545*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*19547*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 2, 0, 1, 
                    // Src: (xor:i32 (and:i32 (xor:i32 i32:i32:$y, i32:i32:$z), i32:i32:$x), i32:i32:$z) - Complexity = 9
                    // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*19557*/         /*Scope*/ 14, /*->19572*/
/*19558*/           OPC_CheckChild1Same, 0,
/*19560*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*19562*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_BFI_B32), 0,
                        1/*#VTs*/, MVT::i32, 3/*#Ops*/, 2, 1, 0, 
                    // Src: (xor:i32 (and:i32 (xor:i32 i32:i32:$z, i32:i32:$y), i32:i32:$x), i32:i32:$z) - Complexity = 9
                    // Dst: (V_BFI_B32:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*19572*/         0, /*End of Scope*/
/*19573*/       0, /*End of Scope*/
/*19574*/     /*Scope*/ 90|128,2/*346*/, /*->19922*/
/*19576*/       OPC_RecordChild0, // #0 = $z
/*19577*/       OPC_MoveChild, 1,
/*19579*/       OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*19582*/       OPC_Scope, 112, /*->19696*/ // 2 children in Scope
/*19584*/         OPC_RecordChild0, // #1 = $x
/*19585*/         OPC_MoveChild, 1,
/*19587*/         OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*19590*/         OPC_CheckChild0Same, 0,
/*19592*/         OPC_RecordChild1, // #2 = $y
/*19593*/         OPC_MoveParent,
/*19594*/         OPC_MoveParent,
/*19595*/         OPC_CheckType, MVT::i32,
/*19597*/         OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*19599*/         OPC_EmitInteger, MVT::i32, 0, 
/*19602*/         OPC_EmitInteger, MVT::i32, 0, 
/*19605*/         OPC_EmitInteger, MVT::i32, 0, 
/*19608*/         OPC_EmitInteger, MVT::i32, 0, 
/*19611*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19623*/         OPC_EmitInteger, MVT::i32, 0, 
/*19626*/         OPC_EmitInteger, MVT::i32, 0, 
/*19629*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19641*/         OPC_EmitInteger, MVT::i32, 0, 
/*19644*/         OPC_EmitInteger, MVT::i32, 0, 
/*19647*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19659*/         OPC_EmitInteger, MVT::i32, 1, 
/*19662*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*19665*/         OPC_EmitInteger, MVT::i32, 0, 
/*19668*/         OPC_EmitInteger, MVT::i32, 0, 
/*19671*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                      1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 1, 5, 6, 7, 2, 8, 9, 10, 0, 11, 12, 13, 14, 15, 16, 17, 
                  // Src: (xor:i32 i32:i32:$z, (and:i32 i32:i32:$x, (xor:i32 i32:i32:$z, i32:i32:$y))) - Complexity = 9
                  // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*19696*/       /*Scope*/ 95|128,1/*223*/, /*->19921*/
/*19698*/         OPC_MoveChild, 0,
/*19700*/         OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*19703*/         OPC_Scope, 107, /*->19812*/ // 2 children in Scope
/*19705*/           OPC_RecordChild0, // #1 = $y
/*19706*/           OPC_CheckChild1Same, 0,
/*19708*/           OPC_MoveParent,
/*19709*/           OPC_RecordChild1, // #2 = $x
/*19710*/           OPC_MoveParent,
/*19711*/           OPC_CheckType, MVT::i32,
/*19713*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*19715*/           OPC_EmitInteger, MVT::i32, 0, 
/*19718*/           OPC_EmitInteger, MVT::i32, 0, 
/*19721*/           OPC_EmitInteger, MVT::i32, 0, 
/*19724*/           OPC_EmitInteger, MVT::i32, 0, 
/*19727*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19739*/           OPC_EmitInteger, MVT::i32, 0, 
/*19742*/           OPC_EmitInteger, MVT::i32, 0, 
/*19745*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19757*/           OPC_EmitInteger, MVT::i32, 0, 
/*19760*/           OPC_EmitInteger, MVT::i32, 0, 
/*19763*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19775*/           OPC_EmitInteger, MVT::i32, 1, 
/*19778*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*19781*/           OPC_EmitInteger, MVT::i32, 0, 
/*19784*/           OPC_EmitInteger, MVT::i32, 0, 
/*19787*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                        1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 2, 5, 6, 7, 1, 8, 9, 10, 0, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (xor:i32 i32:i32:$z, (and:i32 (xor:i32 i32:i32:$y, i32:i32:$z), i32:i32:$x)) - Complexity = 9
                    // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*19812*/         /*Scope*/ 107, /*->19920*/
/*19813*/           OPC_CheckChild0Same, 0,
/*19815*/           OPC_RecordChild1, // #1 = $y
/*19816*/           OPC_MoveParent,
/*19817*/           OPC_RecordChild1, // #2 = $x
/*19818*/           OPC_MoveParent,
/*19819*/           OPC_CheckType, MVT::i32,
/*19821*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*19823*/           OPC_EmitInteger, MVT::i32, 0, 
/*19826*/           OPC_EmitInteger, MVT::i32, 0, 
/*19829*/           OPC_EmitInteger, MVT::i32, 0, 
/*19832*/           OPC_EmitInteger, MVT::i32, 0, 
/*19835*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19847*/           OPC_EmitInteger, MVT::i32, 0, 
/*19850*/           OPC_EmitInteger, MVT::i32, 0, 
/*19853*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19865*/           OPC_EmitInteger, MVT::i32, 0, 
/*19868*/           OPC_EmitInteger, MVT::i32, 0, 
/*19871*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19883*/           OPC_EmitInteger, MVT::i32, 1, 
/*19886*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*19889*/           OPC_EmitInteger, MVT::i32, 0, 
/*19892*/           OPC_EmitInteger, MVT::i32, 0, 
/*19895*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                        1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 2, 5, 6, 7, 1, 8, 9, 10, 0, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (xor:i32 i32:i32:$z, (and:i32 (xor:i32 i32:i32:$z, i32:i32:$y), i32:i32:$x)) - Complexity = 9
                    // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*19920*/         0, /*End of Scope*/
/*19921*/       0, /*End of Scope*/
/*19922*/     /*Scope*/ 63|128,3/*447*/, /*->20371*/
/*19924*/       OPC_MoveChild, 0,
/*19926*/       OPC_CheckOpcode, TARGET_VAL(ISD::AND),
/*19929*/       OPC_Scope, 90|128,1/*218*/, /*->20150*/ // 2 children in Scope
/*19932*/         OPC_RecordChild0, // #0 = $x
/*19933*/         OPC_MoveChild, 1,
/*19935*/         OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*19938*/         OPC_RecordChild0, // #1 = $y
/*19939*/         OPC_RecordChild1, // #2 = $z
/*19940*/         OPC_MoveParent,
/*19941*/         OPC_MoveParent,
/*19942*/         OPC_CheckType, MVT::i32,
/*19944*/         OPC_Scope, 101, /*->20047*/ // 2 children in Scope
/*19946*/           OPC_CheckChild1Same, 2,
/*19948*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*19950*/           OPC_EmitInteger, MVT::i32, 0, 
/*19953*/           OPC_EmitInteger, MVT::i32, 0, 
/*19956*/           OPC_EmitInteger, MVT::i32, 0, 
/*19959*/           OPC_EmitInteger, MVT::i32, 0, 
/*19962*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19974*/           OPC_EmitInteger, MVT::i32, 0, 
/*19977*/           OPC_EmitInteger, MVT::i32, 0, 
/*19980*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*19992*/           OPC_EmitInteger, MVT::i32, 0, 
/*19995*/           OPC_EmitInteger, MVT::i32, 0, 
/*19998*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20010*/           OPC_EmitInteger, MVT::i32, 1, 
/*20013*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*20016*/           OPC_EmitInteger, MVT::i32, 0, 
/*20019*/           OPC_EmitInteger, MVT::i32, 0, 
/*20022*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                        1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 1, 8, 9, 10, 2, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (xor:i32 (and:i32 i32:i32:$x, (xor:i32 i32:i32:$y, i32:i32:$z)), i32:i32:$z) - Complexity = 9
                    // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*20047*/         /*Scope*/ 101, /*->20149*/
/*20048*/           OPC_CheckChild1Same, 1,
/*20050*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*20052*/           OPC_EmitInteger, MVT::i32, 0, 
/*20055*/           OPC_EmitInteger, MVT::i32, 0, 
/*20058*/           OPC_EmitInteger, MVT::i32, 0, 
/*20061*/           OPC_EmitInteger, MVT::i32, 0, 
/*20064*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20076*/           OPC_EmitInteger, MVT::i32, 0, 
/*20079*/           OPC_EmitInteger, MVT::i32, 0, 
/*20082*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20094*/           OPC_EmitInteger, MVT::i32, 0, 
/*20097*/           OPC_EmitInteger, MVT::i32, 0, 
/*20100*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20112*/           OPC_EmitInteger, MVT::i32, 1, 
/*20115*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*20118*/           OPC_EmitInteger, MVT::i32, 0, 
/*20121*/           OPC_EmitInteger, MVT::i32, 0, 
/*20124*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                        1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 0, 5, 6, 7, 2, 8, 9, 10, 1, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (xor:i32 (and:i32 i32:i32:$x, (xor:i32 i32:i32:$z, i32:i32:$y)), i32:i32:$z) - Complexity = 9
                    // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*20149*/         0, /*End of Scope*/
/*20150*/       /*Scope*/ 90|128,1/*218*/, /*->20370*/
/*20152*/         OPC_MoveChild, 0,
/*20154*/         OPC_CheckOpcode, TARGET_VAL(ISD::XOR),
/*20157*/         OPC_RecordChild0, // #0 = $y
/*20158*/         OPC_RecordChild1, // #1 = $z
/*20159*/         OPC_MoveParent,
/*20160*/         OPC_RecordChild1, // #2 = $x
/*20161*/         OPC_MoveParent,
/*20162*/         OPC_CheckType, MVT::i32,
/*20164*/         OPC_Scope, 101, /*->20267*/ // 2 children in Scope
/*20166*/           OPC_CheckChild1Same, 1,
/*20168*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*20170*/           OPC_EmitInteger, MVT::i32, 0, 
/*20173*/           OPC_EmitInteger, MVT::i32, 0, 
/*20176*/           OPC_EmitInteger, MVT::i32, 0, 
/*20179*/           OPC_EmitInteger, MVT::i32, 0, 
/*20182*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20194*/           OPC_EmitInteger, MVT::i32, 0, 
/*20197*/           OPC_EmitInteger, MVT::i32, 0, 
/*20200*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20212*/           OPC_EmitInteger, MVT::i32, 0, 
/*20215*/           OPC_EmitInteger, MVT::i32, 0, 
/*20218*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20230*/           OPC_EmitInteger, MVT::i32, 1, 
/*20233*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*20236*/           OPC_EmitInteger, MVT::i32, 0, 
/*20239*/           OPC_EmitInteger, MVT::i32, 0, 
/*20242*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                        1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 2, 5, 6, 7, 0, 8, 9, 10, 1, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (xor:i32 (and:i32 (xor:i32 i32:i32:$y, i32:i32:$z), i32:i32:$x), i32:i32:$z) - Complexity = 9
                    // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*20267*/         /*Scope*/ 101, /*->20369*/
/*20268*/           OPC_CheckChild1Same, 0,
/*20270*/           OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*20272*/           OPC_EmitInteger, MVT::i32, 0, 
/*20275*/           OPC_EmitInteger, MVT::i32, 0, 
/*20278*/           OPC_EmitInteger, MVT::i32, 0, 
/*20281*/           OPC_EmitInteger, MVT::i32, 0, 
/*20284*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20296*/           OPC_EmitInteger, MVT::i32, 0, 
/*20299*/           OPC_EmitInteger, MVT::i32, 0, 
/*20302*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20314*/           OPC_EmitInteger, MVT::i32, 0, 
/*20317*/           OPC_EmitInteger, MVT::i32, 0, 
/*20320*/           OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20332*/           OPC_EmitInteger, MVT::i32, 1, 
/*20335*/           OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*20338*/           OPC_EmitInteger, MVT::i32, 0, 
/*20341*/           OPC_EmitInteger, MVT::i32, 0, 
/*20344*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::BFI_INT_eg), 0,
                        1/*#VTs*/, MVT::i32, 18/*#Ops*/, 3, 4, 2, 5, 6, 7, 1, 8, 9, 10, 0, 11, 12, 13, 14, 15, 16, 17, 
                    // Src: (xor:i32 (and:i32 (xor:i32 i32:i32:$z, i32:i32:$y), i32:i32:$x), i32:i32:$z) - Complexity = 9
                    // Dst: (BFI_INT_eg:i32 ?:i32:$x, ?:i32:$y, ?:i32:$z)
/*20369*/         0, /*End of Scope*/
/*20370*/       0, /*End of Scope*/
/*20371*/     /*Scope*/ 5|128,2/*261*/, /*->20634*/
/*20373*/       OPC_RecordChild0, // #0 = $src0
/*20374*/       OPC_Scope, 108, /*->20484*/ // 2 children in Scope
/*20376*/         OPC_CheckChild1Integer, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20387*/         OPC_SwitchType /*2 cases */, 81, MVT::i32,// ->20471
/*20390*/           OPC_Scope, 67, /*->20459*/ // 2 children in Scope
/*20392*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*20394*/             OPC_EmitInteger, MVT::i32, 1, 
/*20397*/             OPC_EmitInteger, MVT::i32, 0, 
/*20400*/             OPC_EmitInteger, MVT::i32, 0, 
/*20403*/             OPC_EmitInteger, MVT::i32, 0, 
/*20406*/             OPC_EmitInteger, MVT::i32, 0, 
/*20409*/             OPC_EmitInteger, MVT::i32, 0, 
/*20412*/             OPC_EmitInteger, MVT::i32, 0, 
/*20415*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20427*/             OPC_EmitInteger, MVT::i32, 1, 
/*20430*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*20433*/             OPC_EmitInteger, MVT::i32, 0, 
/*20436*/             OPC_EmitInteger, MVT::i32, 0, 
/*20439*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::NOT_INT), 0,
                          1/*#VTs*/, MVT::i32, 13/*#Ops*/, 1, 2, 3, 4, 0, 5, 6, 7, 8, 9, 10, 11, 12, 
                      // Src: (xor:i32 R600_Reg32:i32:$src0, -1:i32) - Complexity = 8
                      // Dst: (NOT_INT:i32 R600_Reg32:i32:$src0)
/*20459*/           /*Scope*/ 10, /*->20470*/
/*20460*/             OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*20462*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_NOT_B32), 0,
                          1/*#VTs*/, MVT::i32, 1/*#Ops*/, 0, 
                      // Src: (xor:i32 i32:i32:$src0, -1:i32) - Complexity = 8
                      // Dst: (S_NOT_B32:i32 i32:i32:$src0)
/*20470*/           0, /*End of Scope*/
/*20471*/         /*SwitchType*/ 10, MVT::i64,// ->20483
/*20473*/           OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*20475*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_NOT_B64), 0,
                        1/*#VTs*/, MVT::i64, 1/*#Ops*/, 0, 
                    // Src: (xor:i64 i64:i64:$src0, -1:i64) - Complexity = 8
                    // Dst: (S_NOT_B64:i64 i64:i64:$src0)
/*20483*/         0, // EndSwitchType
/*20484*/       /*Scope*/ 19|128,1/*147*/, /*->20633*/
/*20486*/         OPC_RecordChild1, // #1 = $src1
/*20487*/         OPC_SwitchType /*3 cases */, 116, MVT::i32,// ->20606
/*20490*/           OPC_Scope, 101, /*->20593*/ // 2 children in Scope
/*20492*/             OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*20494*/             OPC_EmitInteger, MVT::i32, 0, 
/*20497*/             OPC_EmitInteger, MVT::i32, 0, 
/*20500*/             OPC_EmitInteger, MVT::i32, 1, 
/*20503*/             OPC_EmitInteger, MVT::i32, 0, 
/*20506*/             OPC_EmitInteger, MVT::i32, 0, 
/*20509*/             OPC_EmitInteger, MVT::i32, 0, 
/*20512*/             OPC_EmitInteger, MVT::i32, 0, 
/*20515*/             OPC_EmitInteger, MVT::i32, 0, 
/*20518*/             OPC_EmitInteger, MVT::i32, 0, 
/*20521*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20533*/             OPC_EmitInteger, MVT::i32, 0, 
/*20536*/             OPC_EmitInteger, MVT::i32, 0, 
/*20539*/             OPC_EmitInteger, MVT::i32, 0, 
/*20542*/             OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*20554*/             OPC_EmitInteger, MVT::i32, 1, 
/*20557*/             OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*20560*/             OPC_EmitInteger, MVT::i32, 0, 
/*20563*/             OPC_EmitInteger, MVT::i32, 0, 
/*20566*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::XOR_INT), 0,
                          1/*#VTs*/, MVT::i32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                      // Src: (xor:i32 R600_Reg32:i32:$src0, R600_Reg32:i32:$src1) - Complexity = 3
                      // Dst: (XOR_INT:i32 R600_Reg32:i32:$src0, R600_Reg32:i32:$src1)
/*20593*/           /*Scope*/ 11, /*->20605*/
/*20594*/             OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*20596*/             OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_XOR_B32), 0,
                          1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                      // Src: (xor:i32 i32:i32:$src0, i32:i32:$src1) - Complexity = 3
                      // Dst: (S_XOR_B32:i32 i32:i32:$src0, i32:i32:$src1)
/*20605*/           0, /*End of Scope*/
/*20606*/         /*SwitchType*/ 11, MVT::i64,// ->20619
/*20608*/           OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*20610*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_XOR_B64), 0,
                        1/*#VTs*/, MVT::i64, 2/*#Ops*/, 0, 1, 
                    // Src: (xor:i64 i64:i64:$src0, i64:i64:$src1) - Complexity = 3
                    // Dst: (S_XOR_B64:i64 i64:i64:$src0, i64:i64:$src1)
/*20619*/         /*SwitchType*/ 11, MVT::i1,// ->20632
/*20621*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*20623*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_XOR_B64), 0,
                        1/*#VTs*/, MVT::i1, 2/*#Ops*/, 0, 1, 
                    // Src: (xor:i1 i1:i1:$src0, i1:i1:$src1) - Complexity = 3
                    // Dst: (S_XOR_B64:i1 ?:i1:$src0, ?:i1:$src1)
/*20632*/         0, // EndSwitchType
/*20633*/       0, /*End of Scope*/
/*20634*/     0, /*End of Scope*/
/*20635*/   /*SwitchOpcode*/ 33|128,15/*1953*/, TARGET_VAL(ISD::EXTRACT_VECTOR_ELT),// ->22592
/*20639*/     OPC_RecordChild0, // #0 = $vec
/*20640*/     OPC_Scope, 40|128,1/*168*/, /*->20811*/ // 8 children in Scope
/*20643*/       OPC_CheckChild0Type, MVT::v2i32,
/*20645*/       OPC_Scope, 33, /*->20680*/ // 5 children in Scope
/*20647*/         OPC_MoveChild, 1,
/*20649*/         OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*20652*/         OPC_RecordChild0, // #1 = $idx
/*20653*/         OPC_RecordChild1, // #2 = $off
/*20654*/         OPC_MoveChild, 1,
/*20656*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*20659*/         OPC_MoveParent,
/*20660*/         OPC_CheckType, MVT::i32,
/*20662*/         OPC_MoveParent,
/*20663*/         OPC_CheckType, MVT::i32,
/*20665*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*20667*/         OPC_EmitConvertToTarget, 2,
/*20669*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                      2/*#VTs*/, MVT::i32, MVT::i1, 3/*#Ops*/, 0, 1, 3, 
                  // Src: (vector_extract:i32 v2i32:v2i32:$vec, (add:i32 i32:i32:$idx, (imm:i32):$off)) - Complexity = 9
                  // Dst: (SI_INDIRECT_SRC:i32:i1 ?:v2i32:$vec, ?:i32:$idx, (imm:i32):$off)
/*20680*/       /*Scope*/ 36, /*->20717*/
/*20681*/         OPC_CheckChild1Integer, 0, 
/*20683*/         OPC_CheckType, MVT::i32,
/*20685*/         OPC_Scope, 14, /*->20701*/ // 2 children in Scope
/*20687*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*20689*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*20692*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:i32 v2i32:v2i32:$src, 0:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:i32 ?:v2i32:$src, sub0:i32)
/*20701*/         /*Scope*/ 14, /*->20716*/
/*20702*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*20704*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*20707*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:i32 v2i32:v2i32:$src, 0:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:i32 ?:v2i32:$src, sub0:i32)
/*20716*/         0, /*End of Scope*/
/*20717*/       /*Scope*/ 36, /*->20754*/
/*20718*/         OPC_CheckChild1Integer, 1, 
/*20720*/         OPC_CheckType, MVT::i32,
/*20722*/         OPC_Scope, 14, /*->20738*/ // 2 children in Scope
/*20724*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*20726*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*20729*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:i32 v2i32:v2i32:$src, 1:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:i32 ?:v2i32:$src, sub1:i32)
/*20738*/         /*Scope*/ 14, /*->20753*/
/*20739*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*20741*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*20744*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:i32 v2i32:v2i32:$src, 1:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:i32 ?:v2i32:$src, sub1:i32)
/*20753*/         0, /*End of Scope*/
/*20754*/       /*Scope*/ 18, /*->20773*/
/*20755*/         OPC_CheckChild1Integer, 2, 
/*20757*/         OPC_CheckType, MVT::i32,
/*20759*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*20761*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*20764*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v2i32:v2i32:$src, 2:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v2i32:$src, sub2:i32)
/*20773*/       /*Scope*/ 36, /*->20810*/
/*20774*/         OPC_RecordChild1, // #1 = $index
/*20775*/         OPC_CheckChild1Type, MVT::i32,
/*20777*/         OPC_CheckType, MVT::i32,
/*20779*/         OPC_Scope, 11, /*->20792*/ // 2 children in Scope
/*20781*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*20783*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_EXTRACT_ELT_V2), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (extractelt:i32 v2i32:v2i32:$vec, i32:i32:$index) - Complexity = 3
                    // Dst: (R600_EXTRACT_ELT_V2:i32 ?:v2i32:$vec, ?:i32:$index)
/*20792*/         /*Scope*/ 16, /*->20809*/
/*20793*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*20795*/           OPC_EmitInteger, MVT::i32, 0, 
/*20798*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                        2/*#VTs*/, MVT::i32, MVT::i1, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (vector_extract:i32 v2i32:v2i32:$vec, i32:i32:$idx) - Complexity = 3
                    // Dst: (SI_INDIRECT_SRC:i32:i1 ?:v2i32:$vec, ?:i32:$idx, 0:i32)
/*20809*/         0, /*End of Scope*/
/*20810*/       0, /*End of Scope*/
/*20811*/     /*Scope*/ 95|128,1/*223*/, /*->21036*/
/*20813*/       OPC_CheckChild0Type, MVT::v4i32,
/*20815*/       OPC_Scope, 33, /*->20850*/ // 6 children in Scope
/*20817*/         OPC_MoveChild, 1,
/*20819*/         OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*20822*/         OPC_RecordChild0, // #1 = $idx
/*20823*/         OPC_RecordChild1, // #2 = $off
/*20824*/         OPC_MoveChild, 1,
/*20826*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*20829*/         OPC_MoveParent,
/*20830*/         OPC_CheckType, MVT::i32,
/*20832*/         OPC_MoveParent,
/*20833*/         OPC_CheckType, MVT::i32,
/*20835*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*20837*/         OPC_EmitConvertToTarget, 2,
/*20839*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                      2/*#VTs*/, MVT::i32, MVT::i1, 3/*#Ops*/, 0, 1, 3, 
                  // Src: (vector_extract:i32 v4i32:v4i32:$vec, (add:i32 i32:i32:$idx, (imm:i32):$off)) - Complexity = 9
                  // Dst: (SI_INDIRECT_SRC:i32:i1 ?:v4i32:$vec, ?:i32:$idx, (imm:i32):$off)
/*20850*/       /*Scope*/ 36, /*->20887*/
/*20851*/         OPC_CheckChild1Integer, 0, 
/*20853*/         OPC_CheckType, MVT::i32,
/*20855*/         OPC_Scope, 14, /*->20871*/ // 2 children in Scope
/*20857*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*20859*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*20862*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:i32 v4i32:v4i32:$src, 0:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:i32 ?:v4i32:$src, sub0:i32)
/*20871*/         /*Scope*/ 14, /*->20886*/
/*20872*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*20874*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*20877*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:i32 v4i32:v4i32:$src, 0:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:i32 ?:v4i32:$src, sub0:i32)
/*20886*/         0, /*End of Scope*/
/*20887*/       /*Scope*/ 36, /*->20924*/
/*20888*/         OPC_CheckChild1Integer, 1, 
/*20890*/         OPC_CheckType, MVT::i32,
/*20892*/         OPC_Scope, 14, /*->20908*/ // 2 children in Scope
/*20894*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*20896*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*20899*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:i32 v4i32:v4i32:$src, 1:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:i32 ?:v4i32:$src, sub1:i32)
/*20908*/         /*Scope*/ 14, /*->20923*/
/*20909*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*20911*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*20914*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:i32 v4i32:v4i32:$src, 1:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:i32 ?:v4i32:$src, sub1:i32)
/*20923*/         0, /*End of Scope*/
/*20924*/       /*Scope*/ 36, /*->20961*/
/*20925*/         OPC_CheckChild1Integer, 2, 
/*20927*/         OPC_CheckType, MVT::i32,
/*20929*/         OPC_Scope, 14, /*->20945*/ // 2 children in Scope
/*20931*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*20933*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*20936*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:i32 v4i32:v4i32:$src, 2:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:i32 ?:v4i32:$src, sub2:i32)
/*20945*/         /*Scope*/ 14, /*->20960*/
/*20946*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*20948*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*20951*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:i32 v4i32:v4i32:$src, 2:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:i32 ?:v4i32:$src, sub2:i32)
/*20960*/         0, /*End of Scope*/
/*20961*/       /*Scope*/ 36, /*->20998*/
/*20962*/         OPC_CheckChild1Integer, 3, 
/*20964*/         OPC_CheckType, MVT::i32,
/*20966*/         OPC_Scope, 14, /*->20982*/ // 2 children in Scope
/*20968*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*20970*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub3,
/*20973*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:i32 v4i32:v4i32:$src, 3:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:i32 ?:v4i32:$src, sub3:i32)
/*20982*/         /*Scope*/ 14, /*->20997*/
/*20983*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*20985*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub3,
/*20988*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:i32 v4i32:v4i32:$src, 3:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:i32 ?:v4i32:$src, sub3:i32)
/*20997*/         0, /*End of Scope*/
/*20998*/       /*Scope*/ 36, /*->21035*/
/*20999*/         OPC_RecordChild1, // #1 = $index
/*21000*/         OPC_CheckChild1Type, MVT::i32,
/*21002*/         OPC_CheckType, MVT::i32,
/*21004*/         OPC_Scope, 11, /*->21017*/ // 2 children in Scope
/*21006*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*21008*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_EXTRACT_ELT_V4), 0,
                        1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                    // Src: (extractelt:i32 v4i32:v4i32:$vec, i32:i32:$index) - Complexity = 3
                    // Dst: (R600_EXTRACT_ELT_V4:i32 ?:v4i32:$vec, ?:i32:$index)
/*21017*/         /*Scope*/ 16, /*->21034*/
/*21018*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21020*/           OPC_EmitInteger, MVT::i32, 0, 
/*21023*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                        2/*#VTs*/, MVT::i32, MVT::i1, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (vector_extract:i32 v4i32:v4i32:$vec, i32:i32:$idx) - Complexity = 3
                    // Dst: (SI_INDIRECT_SRC:i32:i1 ?:v4i32:$vec, ?:i32:$idx, 0:i32)
/*21034*/         0, /*End of Scope*/
/*21035*/       0, /*End of Scope*/
/*21036*/     /*Scope*/ 84|128,1/*212*/, /*->21250*/
/*21038*/       OPC_CheckChild0Type, MVT::v8i32,
/*21040*/       OPC_Scope, 33, /*->21075*/ // 10 children in Scope
/*21042*/         OPC_MoveChild, 1,
/*21044*/         OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*21047*/         OPC_RecordChild0, // #1 = $idx
/*21048*/         OPC_RecordChild1, // #2 = $off
/*21049*/         OPC_MoveChild, 1,
/*21051*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*21054*/         OPC_MoveParent,
/*21055*/         OPC_CheckType, MVT::i32,
/*21057*/         OPC_MoveParent,
/*21058*/         OPC_CheckType, MVT::i32,
/*21060*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21062*/         OPC_EmitConvertToTarget, 2,
/*21064*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                      2/*#VTs*/, MVT::i32, MVT::i1, 3/*#Ops*/, 0, 1, 3, 
                  // Src: (vector_extract:i32 v8i32:v8i32:$vec, (add:i32 i32:i32:$idx, (imm:i32):$off)) - Complexity = 9
                  // Dst: (SI_INDIRECT_SRC:i32:i1 ?:v8i32:$vec, ?:i32:$idx, (imm:i32):$off)
/*21075*/       /*Scope*/ 18, /*->21094*/
/*21076*/         OPC_CheckChild1Integer, 0, 
/*21078*/         OPC_CheckType, MVT::i32,
/*21080*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21082*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*21085*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v8i32:v8i32:$src, 0:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v8i32:$src, sub0:i32)
/*21094*/       /*Scope*/ 18, /*->21113*/
/*21095*/         OPC_CheckChild1Integer, 1, 
/*21097*/         OPC_CheckType, MVT::i32,
/*21099*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21101*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*21104*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v8i32:v8i32:$src, 1:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v8i32:$src, sub1:i32)
/*21113*/       /*Scope*/ 18, /*->21132*/
/*21114*/         OPC_CheckChild1Integer, 2, 
/*21116*/         OPC_CheckType, MVT::i32,
/*21118*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21120*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*21123*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v8i32:v8i32:$src, 2:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v8i32:$src, sub2:i32)
/*21132*/       /*Scope*/ 18, /*->21151*/
/*21133*/         OPC_CheckChild1Integer, 3, 
/*21135*/         OPC_CheckType, MVT::i32,
/*21137*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21139*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub3,
/*21142*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v8i32:v8i32:$src, 3:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v8i32:$src, sub3:i32)
/*21151*/       /*Scope*/ 18, /*->21170*/
/*21152*/         OPC_CheckChild1Integer, 4, 
/*21154*/         OPC_CheckType, MVT::i32,
/*21156*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21158*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub4,
/*21161*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v8i32:v8i32:$src, 4:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v8i32:$src, sub4:i32)
/*21170*/       /*Scope*/ 18, /*->21189*/
/*21171*/         OPC_CheckChild1Integer, 5, 
/*21173*/         OPC_CheckType, MVT::i32,
/*21175*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21177*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub5,
/*21180*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v8i32:v8i32:$src, 5:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v8i32:$src, sub5:i32)
/*21189*/       /*Scope*/ 18, /*->21208*/
/*21190*/         OPC_CheckChild1Integer, 6, 
/*21192*/         OPC_CheckType, MVT::i32,
/*21194*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21196*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub6,
/*21199*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v8i32:v8i32:$src, 6:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v8i32:$src, sub6:i32)
/*21208*/       /*Scope*/ 18, /*->21227*/
/*21209*/         OPC_CheckChild1Integer, 7, 
/*21211*/         OPC_CheckType, MVT::i32,
/*21213*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21215*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub7,
/*21218*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v8i32:v8i32:$src, 7:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v8i32:$src, sub7:i32)
/*21227*/       /*Scope*/ 21, /*->21249*/
/*21228*/         OPC_RecordChild1, // #1 = $idx
/*21229*/         OPC_CheckChild1Type, MVT::i32,
/*21231*/         OPC_CheckType, MVT::i32,
/*21233*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21235*/         OPC_EmitInteger, MVT::i32, 0, 
/*21238*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                      2/*#VTs*/, MVT::i32, MVT::i1, 3/*#Ops*/, 0, 1, 2, 
                  // Src: (vector_extract:i32 v8i32:v8i32:$vec, i32:i32:$idx) - Complexity = 3
                  // Dst: (SI_INDIRECT_SRC:i32:i1 ?:v8i32:$vec, ?:i32:$idx, 0:i32)
/*21249*/       0, /*End of Scope*/
/*21250*/     /*Scope*/ 108|128,2/*364*/, /*->21616*/
/*21252*/       OPC_CheckChild0Type, MVT::v16i32,
/*21254*/       OPC_Scope, 33, /*->21289*/ // 18 children in Scope
/*21256*/         OPC_MoveChild, 1,
/*21258*/         OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*21261*/         OPC_RecordChild0, // #1 = $idx
/*21262*/         OPC_RecordChild1, // #2 = $off
/*21263*/         OPC_MoveChild, 1,
/*21265*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*21268*/         OPC_MoveParent,
/*21269*/         OPC_CheckType, MVT::i32,
/*21271*/         OPC_MoveParent,
/*21272*/         OPC_CheckType, MVT::i32,
/*21274*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21276*/         OPC_EmitConvertToTarget, 2,
/*21278*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                      2/*#VTs*/, MVT::i32, MVT::i1, 3/*#Ops*/, 0, 1, 3, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$vec, (add:i32 i32:i32:$idx, (imm:i32):$off)) - Complexity = 9
                  // Dst: (SI_INDIRECT_SRC:i32:i1 ?:v16i32:$vec, ?:i32:$idx, (imm:i32):$off)
/*21289*/       /*Scope*/ 18, /*->21308*/
/*21290*/         OPC_CheckChild1Integer, 0, 
/*21292*/         OPC_CheckType, MVT::i32,
/*21294*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21296*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*21299*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 0:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub0:i32)
/*21308*/       /*Scope*/ 18, /*->21327*/
/*21309*/         OPC_CheckChild1Integer, 1, 
/*21311*/         OPC_CheckType, MVT::i32,
/*21313*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21315*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*21318*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 1:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub1:i32)
/*21327*/       /*Scope*/ 18, /*->21346*/
/*21328*/         OPC_CheckChild1Integer, 2, 
/*21330*/         OPC_CheckType, MVT::i32,
/*21332*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21334*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*21337*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 2:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub2:i32)
/*21346*/       /*Scope*/ 18, /*->21365*/
/*21347*/         OPC_CheckChild1Integer, 3, 
/*21349*/         OPC_CheckType, MVT::i32,
/*21351*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21353*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub3,
/*21356*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 3:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub3:i32)
/*21365*/       /*Scope*/ 18, /*->21384*/
/*21366*/         OPC_CheckChild1Integer, 4, 
/*21368*/         OPC_CheckType, MVT::i32,
/*21370*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21372*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub4,
/*21375*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 4:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub4:i32)
/*21384*/       /*Scope*/ 18, /*->21403*/
/*21385*/         OPC_CheckChild1Integer, 5, 
/*21387*/         OPC_CheckType, MVT::i32,
/*21389*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21391*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub5,
/*21394*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 5:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub5:i32)
/*21403*/       /*Scope*/ 18, /*->21422*/
/*21404*/         OPC_CheckChild1Integer, 6, 
/*21406*/         OPC_CheckType, MVT::i32,
/*21408*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21410*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub6,
/*21413*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 6:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub6:i32)
/*21422*/       /*Scope*/ 18, /*->21441*/
/*21423*/         OPC_CheckChild1Integer, 7, 
/*21425*/         OPC_CheckType, MVT::i32,
/*21427*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21429*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub7,
/*21432*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 7:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub7:i32)
/*21441*/       /*Scope*/ 18, /*->21460*/
/*21442*/         OPC_CheckChild1Integer, 8, 
/*21444*/         OPC_CheckType, MVT::i32,
/*21446*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21448*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub8,
/*21451*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 8:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub8:i32)
/*21460*/       /*Scope*/ 18, /*->21479*/
/*21461*/         OPC_CheckChild1Integer, 9, 
/*21463*/         OPC_CheckType, MVT::i32,
/*21465*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21467*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub9,
/*21470*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 9:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub9:i32)
/*21479*/       /*Scope*/ 18, /*->21498*/
/*21480*/         OPC_CheckChild1Integer, 10, 
/*21482*/         OPC_CheckType, MVT::i32,
/*21484*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21486*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub10,
/*21489*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 10:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub10:i32)
/*21498*/       /*Scope*/ 18, /*->21517*/
/*21499*/         OPC_CheckChild1Integer, 11, 
/*21501*/         OPC_CheckType, MVT::i32,
/*21503*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21505*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub11,
/*21508*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 11:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub11:i32)
/*21517*/       /*Scope*/ 18, /*->21536*/
/*21518*/         OPC_CheckChild1Integer, 12, 
/*21520*/         OPC_CheckType, MVT::i32,
/*21522*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21524*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub12,
/*21527*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 12:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub12:i32)
/*21536*/       /*Scope*/ 18, /*->21555*/
/*21537*/         OPC_CheckChild1Integer, 13, 
/*21539*/         OPC_CheckType, MVT::i32,
/*21541*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21543*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub13,
/*21546*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 13:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub13:i32)
/*21555*/       /*Scope*/ 18, /*->21574*/
/*21556*/         OPC_CheckChild1Integer, 14, 
/*21558*/         OPC_CheckType, MVT::i32,
/*21560*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21562*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub14,
/*21565*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 14:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub14:i32)
/*21574*/       /*Scope*/ 18, /*->21593*/
/*21575*/         OPC_CheckChild1Integer, 15, 
/*21577*/         OPC_CheckType, MVT::i32,
/*21579*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21581*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub15,
/*21584*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$src, 15:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:i32 ?:v16i32:$src, sub15:i32)
/*21593*/       /*Scope*/ 21, /*->21615*/
/*21594*/         OPC_RecordChild1, // #1 = $idx
/*21595*/         OPC_CheckChild1Type, MVT::i32,
/*21597*/         OPC_CheckType, MVT::i32,
/*21599*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21601*/         OPC_EmitInteger, MVT::i32, 0, 
/*21604*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                      2/*#VTs*/, MVT::i32, MVT::i1, 3/*#Ops*/, 0, 1, 2, 
                  // Src: (vector_extract:i32 v16i32:v16i32:$vec, i32:i32:$idx) - Complexity = 3
                  // Dst: (SI_INDIRECT_SRC:i32:i1 ?:v16i32:$vec, ?:i32:$idx, 0:i32)
/*21615*/       0, /*End of Scope*/
/*21616*/     /*Scope*/ 40|128,1/*168*/, /*->21786*/
/*21618*/       OPC_CheckChild0Type, MVT::v2f32,
/*21620*/       OPC_Scope, 33, /*->21655*/ // 5 children in Scope
/*21622*/         OPC_MoveChild, 1,
/*21624*/         OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*21627*/         OPC_RecordChild0, // #1 = $idx
/*21628*/         OPC_RecordChild1, // #2 = $off
/*21629*/         OPC_MoveChild, 1,
/*21631*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*21634*/         OPC_MoveParent,
/*21635*/         OPC_CheckType, MVT::i32,
/*21637*/         OPC_MoveParent,
/*21638*/         OPC_CheckType, MVT::f32,
/*21640*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21642*/         OPC_EmitConvertToTarget, 2,
/*21644*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                      2/*#VTs*/, MVT::f32, MVT::i1, 3/*#Ops*/, 0, 1, 3, 
                  // Src: (vector_extract:f32 v2f32:v2f32:$vec, (add:i32 i32:i32:$idx, (imm:i32):$off)) - Complexity = 9
                  // Dst: (SI_INDIRECT_SRC:f32:i1 ?:v2f32:$vec, ?:i32:$idx, (imm:i32):$off)
/*21655*/       /*Scope*/ 36, /*->21692*/
/*21656*/         OPC_CheckChild1Integer, 0, 
/*21658*/         OPC_CheckType, MVT::f32,
/*21660*/         OPC_Scope, 14, /*->21676*/ // 2 children in Scope
/*21662*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*21664*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*21667*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:f32 v2f32:v2f32:$src, 0:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:f32 ?:v2f32:$src, sub0:i32)
/*21676*/         /*Scope*/ 14, /*->21691*/
/*21677*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21679*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*21682*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:f32 v2f32:v2f32:$src, 0:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:f32 ?:v2f32:$src, sub0:i32)
/*21691*/         0, /*End of Scope*/
/*21692*/       /*Scope*/ 36, /*->21729*/
/*21693*/         OPC_CheckChild1Integer, 1, 
/*21695*/         OPC_CheckType, MVT::f32,
/*21697*/         OPC_Scope, 14, /*->21713*/ // 2 children in Scope
/*21699*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*21701*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*21704*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:f32 v2f32:v2f32:$src, 1:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:f32 ?:v2f32:$src, sub1:i32)
/*21713*/         /*Scope*/ 14, /*->21728*/
/*21714*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21716*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*21719*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:f32 v2f32:v2f32:$src, 1:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:f32 ?:v2f32:$src, sub1:i32)
/*21728*/         0, /*End of Scope*/
/*21729*/       /*Scope*/ 18, /*->21748*/
/*21730*/         OPC_CheckChild1Integer, 2, 
/*21732*/         OPC_CheckType, MVT::f32,
/*21734*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21736*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*21739*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v2f32:v2f32:$src, 2:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v2f32:$src, sub2:i32)
/*21748*/       /*Scope*/ 36, /*->21785*/
/*21749*/         OPC_RecordChild1, // #1 = $index
/*21750*/         OPC_CheckChild1Type, MVT::i32,
/*21752*/         OPC_CheckType, MVT::f32,
/*21754*/         OPC_Scope, 11, /*->21767*/ // 2 children in Scope
/*21756*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*21758*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_EXTRACT_ELT_V2), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (extractelt:f32 v2f32:v2f32:$vec, i32:i32:$index) - Complexity = 3
                    // Dst: (R600_EXTRACT_ELT_V2:f32 ?:v2f32:$vec, ?:i32:$index)
/*21767*/         /*Scope*/ 16, /*->21784*/
/*21768*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21770*/           OPC_EmitInteger, MVT::i32, 0, 
/*21773*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                        2/*#VTs*/, MVT::f32, MVT::i1, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (vector_extract:f32 v2f32:v2f32:$vec, i32:i32:$idx) - Complexity = 3
                    // Dst: (SI_INDIRECT_SRC:f32:i1 ?:v2f32:$vec, ?:i32:$idx, 0:i32)
/*21784*/         0, /*End of Scope*/
/*21785*/       0, /*End of Scope*/
/*21786*/     /*Scope*/ 95|128,1/*223*/, /*->22011*/
/*21788*/       OPC_CheckChild0Type, MVT::v4f32,
/*21790*/       OPC_Scope, 33, /*->21825*/ // 6 children in Scope
/*21792*/         OPC_MoveChild, 1,
/*21794*/         OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*21797*/         OPC_RecordChild0, // #1 = $idx
/*21798*/         OPC_RecordChild1, // #2 = $off
/*21799*/         OPC_MoveChild, 1,
/*21801*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*21804*/         OPC_MoveParent,
/*21805*/         OPC_CheckType, MVT::i32,
/*21807*/         OPC_MoveParent,
/*21808*/         OPC_CheckType, MVT::f32,
/*21810*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21812*/         OPC_EmitConvertToTarget, 2,
/*21814*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                      2/*#VTs*/, MVT::f32, MVT::i1, 3/*#Ops*/, 0, 1, 3, 
                  // Src: (vector_extract:f32 v4f32:v4f32:$vec, (add:i32 i32:i32:$idx, (imm:i32):$off)) - Complexity = 9
                  // Dst: (SI_INDIRECT_SRC:f32:i1 ?:v4f32:$vec, ?:i32:$idx, (imm:i32):$off)
/*21825*/       /*Scope*/ 36, /*->21862*/
/*21826*/         OPC_CheckChild1Integer, 0, 
/*21828*/         OPC_CheckType, MVT::f32,
/*21830*/         OPC_Scope, 14, /*->21846*/ // 2 children in Scope
/*21832*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*21834*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*21837*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:f32 v4f32:v4f32:$src, 0:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:f32 ?:v4f32:$src, sub0:i32)
/*21846*/         /*Scope*/ 14, /*->21861*/
/*21847*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21849*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*21852*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:f32 v4f32:v4f32:$src, 0:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:f32 ?:v4f32:$src, sub0:i32)
/*21861*/         0, /*End of Scope*/
/*21862*/       /*Scope*/ 36, /*->21899*/
/*21863*/         OPC_CheckChild1Integer, 1, 
/*21865*/         OPC_CheckType, MVT::f32,
/*21867*/         OPC_Scope, 14, /*->21883*/ // 2 children in Scope
/*21869*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*21871*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*21874*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:f32 v4f32:v4f32:$src, 1:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:f32 ?:v4f32:$src, sub1:i32)
/*21883*/         /*Scope*/ 14, /*->21898*/
/*21884*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21886*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*21889*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:f32 v4f32:v4f32:$src, 1:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:f32 ?:v4f32:$src, sub1:i32)
/*21898*/         0, /*End of Scope*/
/*21899*/       /*Scope*/ 36, /*->21936*/
/*21900*/         OPC_CheckChild1Integer, 2, 
/*21902*/         OPC_CheckType, MVT::f32,
/*21904*/         OPC_Scope, 14, /*->21920*/ // 2 children in Scope
/*21906*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*21908*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*21911*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:f32 v4f32:v4f32:$src, 2:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:f32 ?:v4f32:$src, sub2:i32)
/*21920*/         /*Scope*/ 14, /*->21935*/
/*21921*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21923*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*21926*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:f32 v4f32:v4f32:$src, 2:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:f32 ?:v4f32:$src, sub2:i32)
/*21935*/         0, /*End of Scope*/
/*21936*/       /*Scope*/ 36, /*->21973*/
/*21937*/         OPC_CheckChild1Integer, 3, 
/*21939*/         OPC_CheckType, MVT::f32,
/*21941*/         OPC_Scope, 14, /*->21957*/ // 2 children in Scope
/*21943*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*21945*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub3,
/*21948*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:f32 v4f32:v4f32:$src, 3:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:f32 ?:v4f32:$src, sub3:i32)
/*21957*/         /*Scope*/ 14, /*->21972*/
/*21958*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21960*/           OPC_EmitInteger, MVT::i32, AMDGPU::sub3,
/*21963*/           OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (vector_extract:f32 v4f32:v4f32:$src, 3:iPTR) - Complexity = 8
                    // Dst: (EXTRACT_SUBREG:f32 ?:v4f32:$src, sub3:i32)
/*21972*/         0, /*End of Scope*/
/*21973*/       /*Scope*/ 36, /*->22010*/
/*21974*/         OPC_RecordChild1, // #1 = $index
/*21975*/         OPC_CheckChild1Type, MVT::i32,
/*21977*/         OPC_CheckType, MVT::f32,
/*21979*/         OPC_Scope, 11, /*->21992*/ // 2 children in Scope
/*21981*/           OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*21983*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::R600_EXTRACT_ELT_V4), 0,
                        1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                    // Src: (extractelt:f32 v4f32:v4f32:$vec, i32:i32:$index) - Complexity = 3
                    // Dst: (R600_EXTRACT_ELT_V4:f32 ?:v4f32:$vec, ?:i32:$index)
/*21992*/         /*Scope*/ 16, /*->22009*/
/*21993*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*21995*/           OPC_EmitInteger, MVT::i32, 0, 
/*21998*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                        2/*#VTs*/, MVT::f32, MVT::i1, 3/*#Ops*/, 0, 1, 2, 
                    // Src: (vector_extract:f32 v4f32:v4f32:$vec, i32:i32:$idx) - Complexity = 3
                    // Dst: (SI_INDIRECT_SRC:f32:i1 ?:v4f32:$vec, ?:i32:$idx, 0:i32)
/*22009*/         0, /*End of Scope*/
/*22010*/       0, /*End of Scope*/
/*22011*/     /*Scope*/ 84|128,1/*212*/, /*->22225*/
/*22013*/       OPC_CheckChild0Type, MVT::v8f32,
/*22015*/       OPC_Scope, 33, /*->22050*/ // 10 children in Scope
/*22017*/         OPC_MoveChild, 1,
/*22019*/         OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*22022*/         OPC_RecordChild0, // #1 = $idx
/*22023*/         OPC_RecordChild1, // #2 = $off
/*22024*/         OPC_MoveChild, 1,
/*22026*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*22029*/         OPC_MoveParent,
/*22030*/         OPC_CheckType, MVT::i32,
/*22032*/         OPC_MoveParent,
/*22033*/         OPC_CheckType, MVT::f32,
/*22035*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22037*/         OPC_EmitConvertToTarget, 2,
/*22039*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                      2/*#VTs*/, MVT::f32, MVT::i1, 3/*#Ops*/, 0, 1, 3, 
                  // Src: (vector_extract:f32 v8f32:v8f32:$vec, (add:i32 i32:i32:$idx, (imm:i32):$off)) - Complexity = 9
                  // Dst: (SI_INDIRECT_SRC:f32:i1 ?:v8f32:$vec, ?:i32:$idx, (imm:i32):$off)
/*22050*/       /*Scope*/ 18, /*->22069*/
/*22051*/         OPC_CheckChild1Integer, 0, 
/*22053*/         OPC_CheckType, MVT::f32,
/*22055*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22057*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*22060*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v8f32:v8f32:$src, 0:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v8f32:$src, sub0:i32)
/*22069*/       /*Scope*/ 18, /*->22088*/
/*22070*/         OPC_CheckChild1Integer, 1, 
/*22072*/         OPC_CheckType, MVT::f32,
/*22074*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22076*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*22079*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v8f32:v8f32:$src, 1:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v8f32:$src, sub1:i32)
/*22088*/       /*Scope*/ 18, /*->22107*/
/*22089*/         OPC_CheckChild1Integer, 2, 
/*22091*/         OPC_CheckType, MVT::f32,
/*22093*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22095*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*22098*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v8f32:v8f32:$src, 2:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v8f32:$src, sub2:i32)
/*22107*/       /*Scope*/ 18, /*->22126*/
/*22108*/         OPC_CheckChild1Integer, 3, 
/*22110*/         OPC_CheckType, MVT::f32,
/*22112*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22114*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub3,
/*22117*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v8f32:v8f32:$src, 3:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v8f32:$src, sub3:i32)
/*22126*/       /*Scope*/ 18, /*->22145*/
/*22127*/         OPC_CheckChild1Integer, 4, 
/*22129*/         OPC_CheckType, MVT::f32,
/*22131*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22133*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub4,
/*22136*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v8f32:v8f32:$src, 4:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v8f32:$src, sub4:i32)
/*22145*/       /*Scope*/ 18, /*->22164*/
/*22146*/         OPC_CheckChild1Integer, 5, 
/*22148*/         OPC_CheckType, MVT::f32,
/*22150*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22152*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub5,
/*22155*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v8f32:v8f32:$src, 5:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v8f32:$src, sub5:i32)
/*22164*/       /*Scope*/ 18, /*->22183*/
/*22165*/         OPC_CheckChild1Integer, 6, 
/*22167*/         OPC_CheckType, MVT::f32,
/*22169*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22171*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub6,
/*22174*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v8f32:v8f32:$src, 6:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v8f32:$src, sub6:i32)
/*22183*/       /*Scope*/ 18, /*->22202*/
/*22184*/         OPC_CheckChild1Integer, 7, 
/*22186*/         OPC_CheckType, MVT::f32,
/*22188*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22190*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub7,
/*22193*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v8f32:v8f32:$src, 7:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v8f32:$src, sub7:i32)
/*22202*/       /*Scope*/ 21, /*->22224*/
/*22203*/         OPC_RecordChild1, // #1 = $idx
/*22204*/         OPC_CheckChild1Type, MVT::i32,
/*22206*/         OPC_CheckType, MVT::f32,
/*22208*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22210*/         OPC_EmitInteger, MVT::i32, 0, 
/*22213*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                      2/*#VTs*/, MVT::f32, MVT::i1, 3/*#Ops*/, 0, 1, 2, 
                  // Src: (vector_extract:f32 v8f32:v8f32:$vec, i32:i32:$idx) - Complexity = 3
                  // Dst: (SI_INDIRECT_SRC:f32:i1 ?:v8f32:$vec, ?:i32:$idx, 0:i32)
/*22224*/       0, /*End of Scope*/
/*22225*/     /*Scope*/ 108|128,2/*364*/, /*->22591*/
/*22227*/       OPC_CheckChild0Type, MVT::v16f32,
/*22229*/       OPC_Scope, 33, /*->22264*/ // 18 children in Scope
/*22231*/         OPC_MoveChild, 1,
/*22233*/         OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*22236*/         OPC_RecordChild0, // #1 = $idx
/*22237*/         OPC_RecordChild1, // #2 = $off
/*22238*/         OPC_MoveChild, 1,
/*22240*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*22243*/         OPC_MoveParent,
/*22244*/         OPC_CheckType, MVT::i32,
/*22246*/         OPC_MoveParent,
/*22247*/         OPC_CheckType, MVT::f32,
/*22249*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22251*/         OPC_EmitConvertToTarget, 2,
/*22253*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                      2/*#VTs*/, MVT::f32, MVT::i1, 3/*#Ops*/, 0, 1, 3, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$vec, (add:i32 i32:i32:$idx, (imm:i32):$off)) - Complexity = 9
                  // Dst: (SI_INDIRECT_SRC:f32:i1 ?:v16f32:$vec, ?:i32:$idx, (imm:i32):$off)
/*22264*/       /*Scope*/ 18, /*->22283*/
/*22265*/         OPC_CheckChild1Integer, 0, 
/*22267*/         OPC_CheckType, MVT::f32,
/*22269*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22271*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*22274*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 0:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub0:i32)
/*22283*/       /*Scope*/ 18, /*->22302*/
/*22284*/         OPC_CheckChild1Integer, 1, 
/*22286*/         OPC_CheckType, MVT::f32,
/*22288*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22290*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*22293*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 1:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub1:i32)
/*22302*/       /*Scope*/ 18, /*->22321*/
/*22303*/         OPC_CheckChild1Integer, 2, 
/*22305*/         OPC_CheckType, MVT::f32,
/*22307*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22309*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*22312*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 2:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub2:i32)
/*22321*/       /*Scope*/ 18, /*->22340*/
/*22322*/         OPC_CheckChild1Integer, 3, 
/*22324*/         OPC_CheckType, MVT::f32,
/*22326*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22328*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub3,
/*22331*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 3:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub3:i32)
/*22340*/       /*Scope*/ 18, /*->22359*/
/*22341*/         OPC_CheckChild1Integer, 4, 
/*22343*/         OPC_CheckType, MVT::f32,
/*22345*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22347*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub4,
/*22350*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 4:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub4:i32)
/*22359*/       /*Scope*/ 18, /*->22378*/
/*22360*/         OPC_CheckChild1Integer, 5, 
/*22362*/         OPC_CheckType, MVT::f32,
/*22364*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22366*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub5,
/*22369*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 5:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub5:i32)
/*22378*/       /*Scope*/ 18, /*->22397*/
/*22379*/         OPC_CheckChild1Integer, 6, 
/*22381*/         OPC_CheckType, MVT::f32,
/*22383*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22385*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub6,
/*22388*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 6:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub6:i32)
/*22397*/       /*Scope*/ 18, /*->22416*/
/*22398*/         OPC_CheckChild1Integer, 7, 
/*22400*/         OPC_CheckType, MVT::f32,
/*22402*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22404*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub7,
/*22407*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 7:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub7:i32)
/*22416*/       /*Scope*/ 18, /*->22435*/
/*22417*/         OPC_CheckChild1Integer, 8, 
/*22419*/         OPC_CheckType, MVT::f32,
/*22421*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22423*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub8,
/*22426*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 8:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub8:i32)
/*22435*/       /*Scope*/ 18, /*->22454*/
/*22436*/         OPC_CheckChild1Integer, 9, 
/*22438*/         OPC_CheckType, MVT::f32,
/*22440*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22442*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub9,
/*22445*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 9:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub9:i32)
/*22454*/       /*Scope*/ 18, /*->22473*/
/*22455*/         OPC_CheckChild1Integer, 10, 
/*22457*/         OPC_CheckType, MVT::f32,
/*22459*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22461*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub10,
/*22464*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 10:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub10:i32)
/*22473*/       /*Scope*/ 18, /*->22492*/
/*22474*/         OPC_CheckChild1Integer, 11, 
/*22476*/         OPC_CheckType, MVT::f32,
/*22478*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22480*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub11,
/*22483*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 11:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub11:i32)
/*22492*/       /*Scope*/ 18, /*->22511*/
/*22493*/         OPC_CheckChild1Integer, 12, 
/*22495*/         OPC_CheckType, MVT::f32,
/*22497*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22499*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub12,
/*22502*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 12:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub12:i32)
/*22511*/       /*Scope*/ 18, /*->22530*/
/*22512*/         OPC_CheckChild1Integer, 13, 
/*22514*/         OPC_CheckType, MVT::f32,
/*22516*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22518*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub13,
/*22521*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 13:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub13:i32)
/*22530*/       /*Scope*/ 18, /*->22549*/
/*22531*/         OPC_CheckChild1Integer, 14, 
/*22533*/         OPC_CheckType, MVT::f32,
/*22535*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22537*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub14,
/*22540*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 14:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub14:i32)
/*22549*/       /*Scope*/ 18, /*->22568*/
/*22550*/         OPC_CheckChild1Integer, 15, 
/*22552*/         OPC_CheckType, MVT::f32,
/*22554*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22556*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub15,
/*22559*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 1, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$src, 15:iPTR) - Complexity = 8
                  // Dst: (EXTRACT_SUBREG:f32 ?:v16f32:$src, sub15:i32)
/*22568*/       /*Scope*/ 21, /*->22590*/
/*22569*/         OPC_RecordChild1, // #1 = $idx
/*22570*/         OPC_CheckChild1Type, MVT::i32,
/*22572*/         OPC_CheckType, MVT::f32,
/*22574*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22576*/         OPC_EmitInteger, MVT::i32, 0, 
/*22579*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::SI_INDIRECT_SRC), 0,
                      2/*#VTs*/, MVT::f32, MVT::i1, 3/*#Ops*/, 0, 1, 2, 
                  // Src: (vector_extract:f32 v16f32:v16f32:$vec, i32:i32:$idx) - Complexity = 3
                  // Dst: (SI_INDIRECT_SRC:f32:i1 ?:v16f32:$vec, ?:i32:$idx, 0:i32)
/*22590*/       0, /*End of Scope*/
/*22591*/     0, /*End of Scope*/
/*22592*/   /*SwitchOpcode*/ 50, TARGET_VAL(AMDGPUISD::CONST_ADDRESS),// ->22645
/*22595*/     OPC_RecordChild0, // #0 = $src
/*22596*/     OPC_CheckChild0Type, MVT::i32,
/*22598*/     OPC_Scope, 15, /*->22615*/ // 2 children in Scope
/*22600*/       OPC_CheckType, MVT::i32,
/*22602*/       OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*22604*/       OPC_CheckComplexPat, /*CP*/9, /*#*/0, // SelectGlobalValueConstantOffset:$src #1
/*22607*/       OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CONST_COPY), 0|OPFL_Variadic1,
                    1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1, 
                // Src: (CONST_ADDRESS:i32 ADDRGA_CONST_OFFSET:i32:$src) - Complexity = 9
                // Dst: (CONST_COPY:i32 ADDRGA_CONST_OFFSET:i32:$src)
/*22615*/     /*Scope*/ 28, /*->22644*/
/*22616*/       OPC_RecordChild1, // #1 = $BUFFER_ID
/*22617*/       OPC_MoveChild, 1,
/*22619*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*22622*/       OPC_CheckType, MVT::i32,
/*22624*/       OPC_MoveParent,
/*22625*/       OPC_CheckType, MVT::v4i32,
/*22627*/       OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*22629*/       OPC_CheckComplexPat, /*CP*/10, /*#*/0, // SelectGlobalValueVariableOffset:$ptr #2 #3
/*22632*/       OPC_EmitConvertToTarget, 1,
/*22634*/       OPC_MorphNodeTo, TARGET_VAL(AMDGPU::TEX_VTX_CONSTBUF), 0|OPFL_Variadic2,
                    1/*#VTs*/, MVT::v4i32, 3/*#Ops*/, 2, 3, 4, 
                // Src: (CONST_ADDRESS:v4i32 ADDRGA_VAR_OFFSET:i32:$ptr, (imm:i32):$BUFFER_ID) - Complexity = 15
                // Dst: (TEX_VTX_CONSTBUF:v4i32 ADDRGA_VAR_OFFSET:i32:$ptr, (imm:i32):$BUFFER_ID)
/*22644*/     0, /*End of Scope*/
/*22645*/   /*SwitchOpcode*/ 25|128,27|128,1/*19865*/, TARGET_VAL(ISD::INTRINSIC_WO_CHAIN),// ->42515
/*22650*/     OPC_Scope, 14, /*->22666*/ // 81 children in Scope
/*22652*/       OPC_CheckChild0Integer, 74|128,38/*4938*/, 
/*22655*/       OPC_RecordChild1, // #0 = $src0
/*22656*/       OPC_CheckPatternPredicate, 1, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS) && (true)
/*22658*/       OPC_MorphNodeTo, TARGET_VAL(AMDGPU::S_FLBIT_I32), 0,
                    1/*#VTs*/, MVT::i32, 1/*#Ops*/, 0, 
                // Src: (intrinsic_wo_chain:i32 4938:iPTR, i32:i32:$src0) - Complexity = 8
                // Dst: (S_FLBIT_I32:i32 i32:i32:$src0)
/*22666*/     /*Scope*/ 40, /*->22707*/
/*22667*/       OPC_CheckChild0Integer, 93|128,39/*5085*/, 
/*22670*/       OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*22672*/       OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,15/*4294967295*/, 
/*22679*/       OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,15/*4294967295*/, 
/*22686*/       OPC_EmitInteger, MVT::i32, 0, 
/*22689*/       OPC_EmitNode, TARGET_VAL(AMDGPU::V_MBCNT_LO_U32_B32_e64), 0,
                    1/*#VTs*/, MVT::i32, 2/*#Ops*/, 1, 2,  // Results = #3
/*22698*/       OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_MBCNT_HI_U32_B32_e64), 0,
                    1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 3, 
                // Src: (intrinsic_wo_chain:i32 5085:iPTR) - Complexity = 8
                // Dst: (V_MBCNT_HI_U32_B32_e64:i32 4294967295:i32, (V_MBCNT_LO_U32_B32_e64:i32 4294967295:i32, 0:i32))
/*22707*/     /*Scope*/ 24, /*->22732*/
/*22708*/       OPC_CheckChild0Integer, 85|128,39/*5077*/, 
/*22711*/       OPC_RecordChild1, // #0 = $VOP3Mods0:src0:src0_modifiers:clamp:omod
/*22712*/       OPC_RecordChild2, // #1 = $VOP3Mods:src1:src1_modifiers
/*22713*/       OPC_CheckComplexPat, /*CP*/11, /*#*/0, // SelectVOP3Mods0:$ #2 #3 #4 #5
/*22716*/       OPC_CheckComplexPat, /*CP*/12, /*#*/1, // SelectVOP3Mods:$ #6 #7
/*22719*/       OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_CVT_PKRTZ_F16_F32_e64), 0,
                    1/*#VTs*/, MVT::i32, 6/*#Ops*/, 3, 2, 7, 6, 4, 5, 
                // Src: (intrinsic_wo_chain:i32 5077:iPTR, (VOP3Mods0:f32 f32:f32:$src0, i32:i32:$src0_modifiers, i1:i1:$clamp, i32:i32:$omod), (VOP3Mods:f32 f32:f32:$src1, i32:i32:$src1_modifiers)) - Complexity = -968
                // Dst: (V_CVT_PKRTZ_F16_F32_e64:i32 i32:i32:$src0_modifiers, f32:f32:$src0, i32:i32:$src1_modifiers, f32:f32:$src1, i1:i1:$clamp, i32:i32:$omod)
/*22732*/     /*Scope*/ 1|128,1/*129*/, /*->22863*/
/*22734*/       OPC_CheckChild0Integer, 84|128,38/*4948*/, 
/*22737*/       OPC_RecordChild1, // #0 = $src0
/*22738*/       OPC_RecordChild2, // #1 = $src1
/*22739*/       OPC_Scope, 101, /*->22842*/ // 2 children in Scope
/*22741*/         OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*22743*/         OPC_EmitInteger, MVT::i32, 0, 
/*22746*/         OPC_EmitInteger, MVT::i32, 0, 
/*22749*/         OPC_EmitInteger, MVT::i32, 1, 
/*22752*/         OPC_EmitInteger, MVT::i32, 0, 
/*22755*/         OPC_EmitInteger, MVT::i32, 0, 
/*22758*/         OPC_EmitInteger, MVT::i32, 0, 
/*22761*/         OPC_EmitInteger, MVT::i32, 0, 
/*22764*/         OPC_EmitInteger, MVT::i32, 0, 
/*22767*/         OPC_EmitInteger, MVT::i32, 0, 
/*22770*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*22782*/         OPC_EmitInteger, MVT::i32, 0, 
/*22785*/         OPC_EmitInteger, MVT::i32, 0, 
/*22788*/         OPC_EmitInteger, MVT::i32, 0, 
/*22791*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*22803*/         OPC_EmitInteger, MVT::i32, 1, 
/*22806*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*22809*/         OPC_EmitInteger, MVT::i32, 0, 
/*22812*/         OPC_EmitInteger, MVT::i32, 0, 
/*22815*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::MUL), 0,
                      1/*#VTs*/, MVT::f32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 1, 12, 13, 14, 15, 16, 17, 18, 19, 
                  // Src: (intrinsic_wo_chain:f32 4948:iPTR, R600_Reg32:f32:$src0, R600_Reg32:f32:$src1) - Complexity = 8
                  // Dst: (MUL:f32 R600_Reg32:f32:$src0, R600_Reg32:f32:$src1)
/*22842*/       /*Scope*/ 19, /*->22862*/
/*22843*/         OPC_CheckComplexPat, /*CP*/11, /*#*/0, // SelectVOP3Mods0:$ #2 #3 #4 #5
/*22846*/         OPC_CheckComplexPat, /*CP*/12, /*#*/1, // SelectVOP3Mods:$ #6 #7
/*22849*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_MUL_LEGACY_F32_e64), 0,
                      1/*#VTs*/, MVT::f32, 6/*#Ops*/, 3, 2, 7, 6, 4, 5, 
                  // Src: (intrinsic_wo_chain:f32 4948:iPTR, (VOP3Mods0:f32 f32:f32:$src0, i32:i32:$src0_modifiers, i1:i1:$clamp, i32:i32:$omod), (VOP3Mods:f32 f32:f32:$src1, i32:i32:$src1_modifiers)) - Complexity = -968
                  // Dst: (V_MUL_LEGACY_F32_e64:f32 i32:i32:$src0_modifiers, f32:f32:$src0, i32:i32:$src1_modifiers, f32:f32:$src1, i1:i1:$clamp, i32:i32:$omod)
/*22862*/       0, /*End of Scope*/
/*22863*/     /*Scope*/ 19|128,4/*531*/, /*->23396*/
/*22865*/       OPC_CheckChild0Integer, 72|128,38/*4936*/, 
/*22868*/       OPC_RecordChild1, // #0 = $src0
/*22869*/       OPC_RecordChild2, // #1 = $src1
/*22870*/       OPC_Scope, 38|128,1/*166*/, /*->23039*/ // 4 children in Scope
/*22873*/         OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*22875*/         OPC_EmitInteger, MVT::i32, 0, 
/*22878*/         OPC_EmitInteger, MVT::i32, 0, 
/*22881*/         OPC_EmitInteger, MVT::i32, 1, 
/*22884*/         OPC_EmitInteger, MVT::i32, 0, 
/*22887*/         OPC_EmitInteger, MVT::i32, 0, 
/*22890*/         OPC_EmitInteger, MVT::i32, 0, 
/*22893*/         OPC_EmitInteger, MVT::i32, 0, 
/*22896*/         OPC_EmitInteger, MVT::i32, 0, 
/*22899*/         OPC_EmitInteger, MVT::i32, 0, 
/*22902*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*22914*/         OPC_EmitInteger, MVT::i32, 1, 
/*22917*/         OPC_EmitInteger, MVT::i32, 0, 
/*22920*/         OPC_EmitInteger, MVT::i32, 0, 
/*22923*/         OPC_EmitInteger, MVT::i32, 0, 
/*22926*/         OPC_EmitInteger, MVT::i32, 0, 
/*22929*/         OPC_EmitInteger, MVT::i32, 0, 
/*22932*/         OPC_EmitInteger, MVT::i32, 0, 
/*22935*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*22947*/         OPC_EmitInteger, MVT::i32, 1, 
/*22950*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*22953*/         OPC_EmitInteger, MVT::i32, 0, 
/*22956*/         OPC_EmitInteger, MVT::i32, 0, 
/*22959*/         OPC_EmitNode, TARGET_VAL(AMDGPU::RECIP_IEEE_r600), 0,
                      1/*#VTs*/, MVT::i32, 13/*#Ops*/, 12, 13, 14, 15, 1, 16, 17, 18, 19, 20, 21, 22, 23,  // Results = #24
/*22979*/         OPC_EmitInteger, MVT::i32, 0, 
/*22982*/         OPC_EmitInteger, MVT::i32, 0, 
/*22985*/         OPC_EmitInteger, MVT::i32, 0, 
/*22988*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23000*/         OPC_EmitInteger, MVT::i32, 1, 
/*23003*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*23006*/         OPC_EmitInteger, MVT::i32, 0, 
/*23009*/         OPC_EmitInteger, MVT::i32, 0, 
/*23012*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::MUL_IEEE), 0,
                      1/*#VTs*/, MVT::f32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
                  // Src: (intrinsic_wo_chain:f32 4936:iPTR, f32:f32:$src0, f32:f32:$src1) - Complexity = 8
                  // Dst: (MUL_IEEE:f32 ?:f32:$src0, (RECIP_IEEE_r600:i32 ?:f32:$src1))
/*23039*/       /*Scope*/ 38|128,1/*166*/, /*->23207*/
/*23041*/         OPC_CheckPatternPredicate, 4, // (Subtarget->getGeneration() >= AMDGPUSubtarget::EVERGREEN && Subtarget->getGeneration() < AMDGPUSubtarget::SOUTHERN_ISLANDS && !Subtarget->hasCaymanISA())
/*23043*/         OPC_EmitInteger, MVT::i32, 0, 
/*23046*/         OPC_EmitInteger, MVT::i32, 0, 
/*23049*/         OPC_EmitInteger, MVT::i32, 1, 
/*23052*/         OPC_EmitInteger, MVT::i32, 0, 
/*23055*/         OPC_EmitInteger, MVT::i32, 0, 
/*23058*/         OPC_EmitInteger, MVT::i32, 0, 
/*23061*/         OPC_EmitInteger, MVT::i32, 0, 
/*23064*/         OPC_EmitInteger, MVT::i32, 0, 
/*23067*/         OPC_EmitInteger, MVT::i32, 0, 
/*23070*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23082*/         OPC_EmitInteger, MVT::i32, 1, 
/*23085*/         OPC_EmitInteger, MVT::i32, 0, 
/*23088*/         OPC_EmitInteger, MVT::i32, 0, 
/*23091*/         OPC_EmitInteger, MVT::i32, 0, 
/*23094*/         OPC_EmitInteger, MVT::i32, 0, 
/*23097*/         OPC_EmitInteger, MVT::i32, 0, 
/*23100*/         OPC_EmitInteger, MVT::i32, 0, 
/*23103*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23115*/         OPC_EmitInteger, MVT::i32, 1, 
/*23118*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*23121*/         OPC_EmitInteger, MVT::i32, 0, 
/*23124*/         OPC_EmitInteger, MVT::i32, 0, 
/*23127*/         OPC_EmitNode, TARGET_VAL(AMDGPU::RECIP_IEEE_eg), 0,
                      1/*#VTs*/, MVT::i32, 13/*#Ops*/, 12, 13, 14, 15, 1, 16, 17, 18, 19, 20, 21, 22, 23,  // Results = #24
/*23147*/         OPC_EmitInteger, MVT::i32, 0, 
/*23150*/         OPC_EmitInteger, MVT::i32, 0, 
/*23153*/         OPC_EmitInteger, MVT::i32, 0, 
/*23156*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23168*/         OPC_EmitInteger, MVT::i32, 1, 
/*23171*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*23174*/         OPC_EmitInteger, MVT::i32, 0, 
/*23177*/         OPC_EmitInteger, MVT::i32, 0, 
/*23180*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::MUL_IEEE), 0,
                      1/*#VTs*/, MVT::f32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
                  // Src: (intrinsic_wo_chain:f32 4936:iPTR, f32:f32:$src0, f32:f32:$src1) - Complexity = 8
                  // Dst: (MUL_IEEE:f32 ?:f32:$src0, (RECIP_IEEE_eg:i32 ?:f32:$src1))
/*23207*/       /*Scope*/ 38|128,1/*166*/, /*->23375*/
/*23209*/         OPC_CheckPatternPredicate, 3, // (Subtarget->hasCaymanISA())
/*23211*/         OPC_EmitInteger, MVT::i32, 0, 
/*23214*/         OPC_EmitInteger, MVT::i32, 0, 
/*23217*/         OPC_EmitInteger, MVT::i32, 1, 
/*23220*/         OPC_EmitInteger, MVT::i32, 0, 
/*23223*/         OPC_EmitInteger, MVT::i32, 0, 
/*23226*/         OPC_EmitInteger, MVT::i32, 0, 
/*23229*/         OPC_EmitInteger, MVT::i32, 0, 
/*23232*/         OPC_EmitInteger, MVT::i32, 0, 
/*23235*/         OPC_EmitInteger, MVT::i32, 0, 
/*23238*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23250*/         OPC_EmitInteger, MVT::i32, 1, 
/*23253*/         OPC_EmitInteger, MVT::i32, 0, 
/*23256*/         OPC_EmitInteger, MVT::i32, 0, 
/*23259*/         OPC_EmitInteger, MVT::i32, 0, 
/*23262*/         OPC_EmitInteger, MVT::i32, 0, 
/*23265*/         OPC_EmitInteger, MVT::i32, 0, 
/*23268*/         OPC_EmitInteger, MVT::i32, 0, 
/*23271*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23283*/         OPC_EmitInteger, MVT::i32, 1, 
/*23286*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*23289*/         OPC_EmitInteger, MVT::i32, 0, 
/*23292*/         OPC_EmitInteger, MVT::i32, 0, 
/*23295*/         OPC_EmitNode, TARGET_VAL(AMDGPU::RECIP_IEEE_cm), 0,
                      1/*#VTs*/, MVT::i32, 13/*#Ops*/, 12, 13, 14, 15, 1, 16, 17, 18, 19, 20, 21, 22, 23,  // Results = #24
/*23315*/         OPC_EmitInteger, MVT::i32, 0, 
/*23318*/         OPC_EmitInteger, MVT::i32, 0, 
/*23321*/         OPC_EmitInteger, MVT::i32, 0, 
/*23324*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23336*/         OPC_EmitInteger, MVT::i32, 1, 
/*23339*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*23342*/         OPC_EmitInteger, MVT::i32, 0, 
/*23345*/         OPC_EmitInteger, MVT::i32, 0, 
/*23348*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::MUL_IEEE), 0,
                      1/*#VTs*/, MVT::f32, 20/*#Ops*/, 2, 3, 4, 5, 6, 7, 0, 8, 9, 10, 11, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
                  // Src: (intrinsic_wo_chain:f32 4936:iPTR, f32:f32:$src0, f32:f32:$src1) - Complexity = 8
                  // Dst: (MUL_IEEE:f32 ?:f32:$src0, (RECIP_IEEE_cm:i32 ?:f32:$src1))
/*23375*/       /*Scope*/ 19, /*->23395*/
/*23376*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*23378*/         OPC_EmitNode, TARGET_VAL(AMDGPU::V_RCP_LEGACY_F32_e32), 0,
                      1/*#VTs*/, MVT::i32, 1/*#Ops*/, 1,  // Results = #2
/*23386*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_MUL_LEGACY_F32_e32), 0,
                      1/*#VTs*/, MVT::f32, 2/*#Ops*/, 0, 2, 
                  // Src: (intrinsic_wo_chain:f32 4936:iPTR, f32:f32:$src0, f32:f32:$src1) - Complexity = 8
                  // Dst: (V_MUL_LEGACY_F32_e32:f32 ?:f32:$src0, (V_RCP_LEGACY_F32_e32:i32 ?:f32:$src1))
/*23395*/       0, /*End of Scope*/
/*23396*/     /*Scope*/ 46, /*->23443*/
/*23397*/       OPC_CheckChild0Integer, 64|128,38/*4928*/, 
/*23400*/       OPC_RecordChild1, // #0 = $src0
/*23401*/       OPC_RecordChild2, // #1 = $src1
/*23402*/       OPC_RecordChild3, // #2 = $src2
/*23403*/       OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*23405*/       OPC_EmitInteger, MVT::i32, 0, 
/*23408*/       OPC_EmitInteger, MVT::i32, 0, 
/*23411*/       OPC_EmitInteger, MVT::i32, 0, 
/*23414*/       OPC_EmitInteger, MVT::i1, 0, 
/*23417*/       OPC_EmitInteger, MVT::i32, 0, 
/*23420*/       OPC_EmitNode, TARGET_VAL(AMDGPU::V_CMP_GT_F32_e64), 0,
                    1/*#VTs*/, MVT::i1, 6/*#Ops*/, 3, 4, 5, 0, 6, 7,  // Results = #8
/*23433*/       OPC_MorphNodeTo, TARGET_VAL(AMDGPU::V_CNDMASK_B32_e64), 0,
                    1/*#VTs*/, MVT::f32, 3/*#Ops*/, 2, 1, 8, 
                // Src: (intrinsic_wo_chain:f32 4928:iPTR, f32:f32:$src0, f32:f32:$src1, f32:f32:$src2) - Complexity = 8
                // Dst: (V_CNDMASK_B32_e64:f32 ?:f32:$src2, ?:f32:$src1, (V_CMP_GT_F32_e64:i1 0:i32, 0:i32, 0:i32, ?:f32:$src0, 0:i1, 0:i32))
/*23443*/     /*Scope*/ 34|128,5/*674*/, /*->24119*/
/*23445*/       OPC_CheckChild0Integer, 95|128,39/*5087*/, 
/*23448*/       OPC_RecordChild1, // #0 = $src_x
/*23449*/       OPC_RecordChild2, // #1 = $src_y
/*23450*/       OPC_RecordChild3, // #2 = $src_w
/*23451*/       OPC_Scope, 75|128,2/*331*/, /*->23785*/ // 2 children in Scope
/*23454*/         OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*23456*/         OPC_EmitInteger, MVT::i32, 1, 
/*23459*/         OPC_EmitInteger, MVT::i32, 0, 
/*23462*/         OPC_EmitInteger, MVT::i32, 0, 
/*23465*/         OPC_EmitInteger, MVT::i32, 0, 
/*23468*/         OPC_EmitInteger, MVT::i32, 0, 
/*23471*/         OPC_EmitInteger, MVT::i32, 0, 
/*23474*/         OPC_EmitInteger, MVT::i32, 1, 
/*23477*/         OPC_EmitInteger, MVT::i32, 0, 
/*23480*/         OPC_EmitInteger, MVT::i32, 0, 
/*23483*/         OPC_EmitInteger, MVT::i32, 0, 
/*23486*/         OPC_EmitInteger, MVT::i32, 0, 
/*23489*/         OPC_EmitInteger, MVT::i32, 0, 
/*23492*/         OPC_EmitInteger, MVT::i32, 1, 
/*23495*/         OPC_EmitInteger, MVT::i32, 0, 
/*23498*/         OPC_EmitInteger, MVT::i32, 0, 
/*23501*/         OPC_EmitInteger, MVT::i32, 0, 
/*23504*/         OPC_EmitInteger, MVT::i32, 0, 
/*23507*/         OPC_EmitInteger, MVT::i32, 0, 
/*23510*/         OPC_EmitInteger, MVT::i32, 0, 
/*23513*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23525*/         OPC_EmitRegister, MVT::f32, AMDGPU::ZERO,
/*23528*/         OPC_EmitInteger, MVT::i32, 0, 
/*23531*/         OPC_EmitInteger, MVT::i32, 0, 
/*23534*/         OPC_EmitInteger, MVT::i32, 0, 
/*23537*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23549*/         OPC_EmitInteger, MVT::i32, 1, 
/*23552*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*23555*/         OPC_EmitInteger, MVT::i32, 0, 
/*23558*/         OPC_EmitInteger, MVT::i32, 0, 
/*23561*/         OPC_EmitNode, TARGET_VAL(AMDGPU::MAX), 0,
                      1/*#VTs*/, MVT::i32, 20/*#Ops*/, 13, 14, 15, 16, 17, 18, 1, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,  // Results = #32
/*23588*/         OPC_EmitInteger, MVT::i32, 0, 
/*23591*/         OPC_EmitInteger, MVT::i32, 0, 
/*23594*/         OPC_EmitInteger, MVT::i32, 0, 
/*23597*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23609*/         OPC_EmitInteger, MVT::i32, 1, 
/*23612*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*23615*/         OPC_EmitInteger, MVT::i32, 0, 
/*23618*/         OPC_EmitInteger, MVT::i32, 0, 
/*23621*/         OPC_EmitNode, TARGET_VAL(AMDGPU::LOG_CLAMPED_r600), 0,
                      1/*#VTs*/, MVT::i32, 13/*#Ops*/, 9, 10, 11, 12, 32, 33, 34, 35, 36, 37, 38, 39, 40,  // Results = #41
/*23641*/         OPC_EmitInteger, MVT::i32, 0, 
/*23644*/         OPC_EmitInteger, MVT::i32, 0, 
/*23647*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23659*/         OPC_EmitInteger, MVT::i32, 0, 
/*23662*/         OPC_EmitInteger, MVT::i32, 0, 
/*23665*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23677*/         OPC_EmitInteger, MVT::i32, 0, 
/*23680*/         OPC_EmitInteger, MVT::i32, 0, 
/*23683*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23695*/         OPC_EmitInteger, MVT::i32, 1, 
/*23698*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*23701*/         OPC_EmitInteger, MVT::i32, 0, 
/*23704*/         OPC_EmitInteger, MVT::i32, 0, 
/*23707*/         OPC_EmitNode, TARGET_VAL(AMDGPU::MUL_LIT_r600), 0,
                      1/*#VTs*/, MVT::i32, 18/*#Ops*/, 7, 8, 41, 42, 43, 44, 2, 45, 46, 47, 0, 48, 49, 50, 51, 52, 53, 54,  // Results = #55
/*23732*/         OPC_EmitInteger, MVT::i32, 0, 
/*23735*/         OPC_EmitInteger, MVT::i32, 0, 
/*23738*/         OPC_EmitInteger, MVT::i32, 0, 
/*23741*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23753*/         OPC_EmitInteger, MVT::i32, 1, 
/*23756*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*23759*/         OPC_EmitInteger, MVT::i32, 0, 
/*23762*/         OPC_EmitInteger, MVT::i32, 0, 
/*23765*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::EXP_IEEE_r600), 0,
                      1/*#VTs*/, MVT::f32, 13/*#Ops*/, 3, 4, 5, 6, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
                  // Src: (intrinsic_wo_chain:f32 5087:iPTR, f32:f32:$src_x, f32:f32:$src_y, f32:f32:$src_w) - Complexity = 8
                  // Dst: (EXP_IEEE_r600:f32 (MUL_LIT_r600:i32 (LOG_CLAMPED_r600:i32 (MAX:i32 ?:f32:$src_y, ZERO:f32)), ?:f32:$src_w, ?:f32:$src_x))
/*23785*/       /*Scope*/ 75|128,2/*331*/, /*->24118*/
/*23787*/         OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*23789*/         OPC_EmitInteger, MVT::i32, 1, 
/*23792*/         OPC_EmitInteger, MVT::i32, 0, 
/*23795*/         OPC_EmitInteger, MVT::i32, 0, 
/*23798*/         OPC_EmitInteger, MVT::i32, 0, 
/*23801*/         OPC_EmitInteger, MVT::i32, 0, 
/*23804*/         OPC_EmitInteger, MVT::i32, 0, 
/*23807*/         OPC_EmitInteger, MVT::i32, 1, 
/*23810*/         OPC_EmitInteger, MVT::i32, 0, 
/*23813*/         OPC_EmitInteger, MVT::i32, 0, 
/*23816*/         OPC_EmitInteger, MVT::i32, 0, 
/*23819*/         OPC_EmitInteger, MVT::i32, 0, 
/*23822*/         OPC_EmitInteger, MVT::i32, 0, 
/*23825*/         OPC_EmitInteger, MVT::i32, 1, 
/*23828*/         OPC_EmitInteger, MVT::i32, 0, 
/*23831*/         OPC_EmitInteger, MVT::i32, 0, 
/*23834*/         OPC_EmitInteger, MVT::i32, 0, 
/*23837*/         OPC_EmitInteger, MVT::i32, 0, 
/*23840*/         OPC_EmitInteger, MVT::i32, 0, 
/*23843*/         OPC_EmitInteger, MVT::i32, 0, 
/*23846*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23858*/         OPC_EmitRegister, MVT::f32, AMDGPU::ZERO,
/*23861*/         OPC_EmitInteger, MVT::i32, 0, 
/*23864*/         OPC_EmitInteger, MVT::i32, 0, 
/*23867*/         OPC_EmitInteger, MVT::i32, 0, 
/*23870*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23882*/         OPC_EmitInteger, MVT::i32, 1, 
/*23885*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*23888*/         OPC_EmitInteger, MVT::i32, 0, 
/*23891*/         OPC_EmitInteger, MVT::i32, 0, 
/*23894*/         OPC_EmitNode, TARGET_VAL(AMDGPU::MAX), 0,
                      1/*#VTs*/, MVT::i32, 20/*#Ops*/, 13, 14, 15, 16, 17, 18, 1, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,  // Results = #32
/*23921*/         OPC_EmitInteger, MVT::i32, 0, 
/*23924*/         OPC_EmitInteger, MVT::i32, 0, 
/*23927*/         OPC_EmitInteger, MVT::i32, 0, 
/*23930*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23942*/         OPC_EmitInteger, MVT::i32, 1, 
/*23945*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*23948*/         OPC_EmitInteger, MVT::i32, 0, 
/*23951*/         OPC_EmitInteger, MVT::i32, 0, 
/*23954*/         OPC_EmitNode, TARGET_VAL(AMDGPU::LOG_CLAMPED_eg), 0,
                      1/*#VTs*/, MVT::i32, 13/*#Ops*/, 9, 10, 11, 12, 32, 33, 34, 35, 36, 37, 38, 39, 40,  // Results = #41
/*23974*/         OPC_EmitInteger, MVT::i32, 0, 
/*23977*/         OPC_EmitInteger, MVT::i32, 0, 
/*23980*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*23992*/         OPC_EmitInteger, MVT::i32, 0, 
/*23995*/         OPC_EmitInteger, MVT::i32, 0, 
/*23998*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*24010*/         OPC_EmitInteger, MVT::i32, 0, 
/*24013*/         OPC_EmitInteger, MVT::i32, 0, 
/*24016*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*24028*/         OPC_EmitInteger, MVT::i32, 1, 
/*24031*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*24034*/         OPC_EmitInteger, MVT::i32, 0, 
/*24037*/         OPC_EmitInteger, MVT::i32, 0, 
/*24040*/         OPC_EmitNode, TARGET_VAL(AMDGPU::MUL_LIT_eg), 0,
                      1/*#VTs*/, MVT::i32, 18/*#Ops*/, 7, 8, 41, 42, 43, 44, 2, 45, 46, 47, 0, 48, 49, 50, 51, 52, 53, 54,  // Results = #55
/*24065*/         OPC_EmitInteger, MVT::i32, 0, 
/*24068*/         OPC_EmitInteger, MVT::i32, 0, 
/*24071*/         OPC_EmitInteger, MVT::i32, 0, 
/*24074*/         OPC_EmitInteger, MVT::i32, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1/*18446744073709551615*/, 
/*24086*/         OPC_EmitInteger, MVT::i32, 1, 
/*24089*/         OPC_EmitRegister, MVT::i32, AMDGPU::PRED_SEL_OFF,
/*24092*/         OPC_EmitInteger, MVT::i32, 0, 
/*24095*/         OPC_EmitInteger, MVT::i32, 0, 
/*24098*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::EXP_IEEE_eg), 0,
                      1/*#VTs*/, MVT::f32, 13/*#Ops*/, 3, 4, 5, 6, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
                  // Src: (intrinsic_wo_chain:f32 5087:iPTR, f32:f32:$src_x, f32:f32:$src_y, f32:f32:$src_w) - Complexity = 8
                  // Dst: (EXP_IEEE_eg:f32 (MUL_LIT_eg:i32 (LOG_CLAMPED_eg:i32 (MAX:i32 ?:f32:$src_y, ZERO:f32)), ?:f32:$src_w, ?:f32:$src_x))
/*24118*/       0, /*End of Scope*/
/*24119*/     /*Scope*/ 18|128,3/*402*/, /*->24523*/
/*24121*/       OPC_CheckChild0Integer, 82|128,39/*5074*/, 
/*24124*/       OPC_RecordChild1, // #0 = $addr
/*24125*/       OPC_Scope, 68|128,1/*196*/, /*->24324*/ // 2 children in Scope
/*24128*/         OPC_CheckChild1Type, MVT::v2i32,
/*24130*/         OPC_RecordChild2, // #1 = $rsrc
/*24131*/         OPC_MoveChild, 3,
/*24133*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*24136*/         OPC_Scope, 46, /*->24184*/ // 4 children in Scope
/*24138*/           OPC_CheckPredicate, 116, // Predicate_TEX_ARRAY
/*24140*/           OPC_MoveParent,
/*24141*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*24143*/           OPC_EmitInteger, MVT::i32, 15, 
/*24146*/           OPC_EmitInteger, MVT::i1, 0, 
/*24149*/           OPC_EmitInteger, MVT::i1, 0, 
/*24152*/           OPC_EmitInteger, MVT::i1, 1, 
/*24155*/           OPC_EmitInteger, MVT::i1, 0, 
/*24158*/           OPC_EmitInteger, MVT::i1, 0, 
/*24161*/           OPC_EmitInteger, MVT::i1, 0, 
/*24164*/           OPC_EmitInteger, MVT::i1, 0, 
/*24167*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_LOAD_MIP_V4_V2), 0,
                        1/*#VTs*/, MVT::v4i32, 10/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 
                    // Src: (intrinsic_wo_chain:v4i32 5074:iPTR, v2i32:v2i32:$addr, v32i8:v32i8:$rsrc, (imm:i32)<<P:Predicate_TEX_ARRAY>>) - Complexity = 12
                    // Dst: (IMAGE_LOAD_MIP_V4_V2:v4i32 15:i32, 0:i1, 0:i1, 1:i1, 0:i1, 0:i1, 0:i1, 0:i1, ?:v2i32:$addr, ?:v32i8:$rsrc)
/*24184*/         /*Scope*/ 46, /*->24231*/
/*24185*/           OPC_CheckPredicate, 117, // Predicate_TEX_MSAA
/*24187*/           OPC_MoveParent,
/*24188*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*24190*/           OPC_EmitInteger, MVT::i32, 15, 
/*24193*/           OPC_EmitInteger, MVT::i1, 0, 
/*24196*/           OPC_EmitInteger, MVT::i1, 0, 
/*24199*/           OPC_EmitInteger, MVT::i1, 0, 
/*24202*/           OPC_EmitInteger, MVT::i1, 0, 
/*24205*/           OPC_EmitInteger, MVT::i1, 0, 
/*24208*/           OPC_EmitInteger, MVT::i1, 0, 
/*24211*/           OPC_EmitInteger, MVT::i1, 0, 
/*24214*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_LOAD_V4_V2), 0,
                        1/*#VTs*/, MVT::v4i32, 10/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 
                    // Src: (intrinsic_wo_chain:v4i32 5074:iPTR, v2i32:v2i32:$addr, v32i8:v32i8:$rsrc, (imm:i32)<<P:Predicate_TEX_MSAA>>) - Complexity = 12
                    // Dst: (IMAGE_LOAD_V4_V2:v4i32 15:i32, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, ?:v2i32:$addr, ?:v32i8:$rsrc)
/*24231*/         /*Scope*/ 46, /*->24278*/
/*24232*/           OPC_CheckPredicate, 118, // Predicate_TEX_ARRAY_MSAA
/*24234*/           OPC_MoveParent,
/*24235*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*24237*/           OPC_EmitInteger, MVT::i32, 15, 
/*24240*/           OPC_EmitInteger, MVT::i1, 0, 
/*24243*/           OPC_EmitInteger, MVT::i1, 0, 
/*24246*/           OPC_EmitInteger, MVT::i1, 1, 
/*24249*/           OPC_EmitInteger, MVT::i1, 0, 
/*24252*/           OPC_EmitInteger, MVT::i1, 0, 
/*24255*/           OPC_EmitInteger, MVT::i1, 0, 
/*24258*/           OPC_EmitInteger, MVT::i1, 0, 
/*24261*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_LOAD_V4_V2), 0,
                        1/*#VTs*/, MVT::v4i32, 10/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 
                    // Src: (intrinsic_wo_chain:v4i32 5074:iPTR, v2i32:v2i32:$addr, v32i8:v32i8:$rsrc, (imm:i32)<<P:Predicate_TEX_ARRAY_MSAA>>) - Complexity = 12
                    // Dst: (IMAGE_LOAD_V4_V2:v4i32 15:i32, 0:i1, 0:i1, 1:i1, 0:i1, 0:i1, 0:i1, 0:i1, ?:v2i32:$addr, ?:v32i8:$rsrc)
/*24278*/         /*Scope*/ 44, /*->24323*/
/*24279*/           OPC_MoveParent,
/*24280*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*24282*/           OPC_EmitInteger, MVT::i32, 15, 
/*24285*/           OPC_EmitInteger, MVT::i1, 0, 
/*24288*/           OPC_EmitInteger, MVT::i1, 0, 
/*24291*/           OPC_EmitInteger, MVT::i1, 0, 
/*24294*/           OPC_EmitInteger, MVT::i1, 0, 
/*24297*/           OPC_EmitInteger, MVT::i1, 0, 
/*24300*/           OPC_EmitInteger, MVT::i1, 0, 
/*24303*/           OPC_EmitInteger, MVT::i1, 0, 
/*24306*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_LOAD_MIP_V4_V2), 0,
                        1/*#VTs*/, MVT::v4i32, 10/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 
                    // Src: (intrinsic_wo_chain:v4i32 5074:iPTR, v2i32:v2i32:$addr, v32i8:v32i8:$rsrc, (imm:i32)) - Complexity = 11
                    // Dst: (IMAGE_LOAD_MIP_V4_V2:v4i32 15:i32, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, ?:v2i32:$addr, ?:v32i8:$rsrc)
/*24323*/         0, /*End of Scope*/
/*24324*/       /*Scope*/ 68|128,1/*196*/, /*->24522*/
/*24326*/         OPC_CheckChild1Type, MVT::v4i32,
/*24328*/         OPC_RecordChild2, // #1 = $rsrc
/*24329*/         OPC_MoveChild, 3,
/*24331*/         OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*24334*/         OPC_Scope, 46, /*->24382*/ // 4 children in Scope
/*24336*/           OPC_CheckPredicate, 116, // Predicate_TEX_ARRAY
/*24338*/           OPC_MoveParent,
/*24339*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*24341*/           OPC_EmitInteger, MVT::i32, 15, 
/*24344*/           OPC_EmitInteger, MVT::i1, 0, 
/*24347*/           OPC_EmitInteger, MVT::i1, 0, 
/*24350*/           OPC_EmitInteger, MVT::i1, 1, 
/*24353*/           OPC_EmitInteger, MVT::i1, 0, 
/*24356*/           OPC_EmitInteger, MVT::i1, 0, 
/*24359*/           OPC_EmitInteger, MVT::i1, 0, 
/*24362*/           OPC_EmitInteger, MVT::i1, 0, 
/*24365*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_LOAD_MIP_V4_V4), 0,
                        1/*#VTs*/, MVT::v4i32, 10/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 
                    // Src: (intrinsic_wo_chain:v4i32 5074:iPTR, v4i32:v4i32:$addr, v32i8:v32i8:$rsrc, (imm:i32)<<P:Predicate_TEX_ARRAY>>) - Complexity = 12
                    // Dst: (IMAGE_LOAD_MIP_V4_V4:v4i32 15:i32, 0:i1, 0:i1, 1:i1, 0:i1, 0:i1, 0:i1, 0:i1, ?:v4i32:$addr, ?:v32i8:$rsrc)
/*24382*/         /*Scope*/ 46, /*->24429*/
/*24383*/           OPC_CheckPredicate, 117, // Predicate_TEX_MSAA
/*24385*/           OPC_MoveParent,
/*24386*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*24388*/           OPC_EmitInteger, MVT::i32, 15, 
/*24391*/           OPC_EmitInteger, MVT::i1, 0, 
/*24394*/           OPC_EmitInteger, MVT::i1, 0, 
/*24397*/           OPC_EmitInteger, MVT::i1, 0, 
/*24400*/           OPC_EmitInteger, MVT::i1, 0, 
/*24403*/           OPC_EmitInteger, MVT::i1, 0, 
/*24406*/           OPC_EmitInteger, MVT::i1, 0, 
/*24409*/           OPC_EmitInteger, MVT::i1, 0, 
/*24412*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_LOAD_V4_V4), 0,
                        1/*#VTs*/, MVT::v4i32, 10/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 
                    // Src: (intrinsic_wo_chain:v4i32 5074:iPTR, v4i32:v4i32:$addr, v32i8:v32i8:$rsrc, (imm:i32)<<P:Predicate_TEX_MSAA>>) - Complexity = 12
                    // Dst: (IMAGE_LOAD_V4_V4:v4i32 15:i32, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, ?:v4i32:$addr, ?:v32i8:$rsrc)
/*24429*/         /*Scope*/ 46, /*->24476*/
/*24430*/           OPC_CheckPredicate, 118, // Predicate_TEX_ARRAY_MSAA
/*24432*/           OPC_MoveParent,
/*24433*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*24435*/           OPC_EmitInteger, MVT::i32, 15, 
/*24438*/           OPC_EmitInteger, MVT::i1, 0, 
/*24441*/           OPC_EmitInteger, MVT::i1, 0, 
/*24444*/           OPC_EmitInteger, MVT::i1, 1, 
/*24447*/           OPC_EmitInteger, MVT::i1, 0, 
/*24450*/           OPC_EmitInteger, MVT::i1, 0, 
/*24453*/           OPC_EmitInteger, MVT::i1, 0, 
/*24456*/           OPC_EmitInteger, MVT::i1, 0, 
/*24459*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_LOAD_V4_V4), 0,
                        1/*#VTs*/, MVT::v4i32, 10/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 
                    // Src: (intrinsic_wo_chain:v4i32 5074:iPTR, v4i32:v4i32:$addr, v32i8:v32i8:$rsrc, (imm:i32)<<P:Predicate_TEX_ARRAY_MSAA>>) - Complexity = 12
                    // Dst: (IMAGE_LOAD_V4_V4:v4i32 15:i32, 0:i1, 0:i1, 1:i1, 0:i1, 0:i1, 0:i1, 0:i1, ?:v4i32:$addr, ?:v32i8:$rsrc)
/*24476*/         /*Scope*/ 44, /*->24521*/
/*24477*/           OPC_MoveParent,
/*24478*/           OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*24480*/           OPC_EmitInteger, MVT::i32, 15, 
/*24483*/           OPC_EmitInteger, MVT::i1, 0, 
/*24486*/           OPC_EmitInteger, MVT::i1, 0, 
/*24489*/           OPC_EmitInteger, MVT::i1, 0, 
/*24492*/           OPC_EmitInteger, MVT::i1, 0, 
/*24495*/           OPC_EmitInteger, MVT::i1, 0, 
/*24498*/           OPC_EmitInteger, MVT::i1, 0, 
/*24501*/           OPC_EmitInteger, MVT::i1, 0, 
/*24504*/           OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_LOAD_MIP_V4_V4), 0,
                        1/*#VTs*/, MVT::v4i32, 10/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 
                    // Src: (intrinsic_wo_chain:v4i32 5074:iPTR, v4i32:v4i32:$addr, v32i8:v32i8:$rsrc, (imm:i32)) - Complexity = 11
                    // Dst: (IMAGE_LOAD_MIP_V4_V4:v4i32 15:i32, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, ?:v4i32:$addr, ?:v32i8:$rsrc)
/*24521*/         0, /*End of Scope*/
/*24522*/       0, /*End of Scope*/
/*24523*/     /*Scope*/ 47|128,1/*175*/, /*->24700*/
/*24525*/       OPC_CheckChild0Integer, 86|128,39/*5078*/, 
/*24528*/       OPC_RecordChild1, // #0 = $mipid
/*24529*/       OPC_RecordChild2, // #1 = $rsrc
/*24530*/       OPC_MoveChild, 3,
/*24532*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*24535*/       OPC_Scope, 54, /*->24591*/ // 3 children in Scope
/*24537*/         OPC_CheckPredicate, 116, // Predicate_TEX_ARRAY
/*24539*/         OPC_MoveParent,
/*24540*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*24542*/         OPC_EmitInteger, MVT::i32, 15, 
/*24545*/         OPC_EmitInteger, MVT::i1, 0, 
/*24548*/         OPC_EmitInteger, MVT::i1, 0, 
/*24551*/         OPC_EmitInteger, MVT::i1, 1, 
/*24554*/         OPC_EmitInteger, MVT::i1, 0, 
/*24557*/         OPC_EmitInteger, MVT::i1, 0, 
/*24560*/         OPC_EmitInteger, MVT::i1, 0, 
/*24563*/         OPC_EmitInteger, MVT::i1, 0, 
/*24566*/         OPC_EmitNode, TARGET_VAL(AMDGPU::V_MOV_B32_e32), 0,
                      1/*#VTs*/, MVT::i32, 1/*#Ops*/, 0,  // Results = #10
/*24574*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_GET_RESINFO_V4_V1), 0,
                      1/*#VTs*/, MVT::v4i32, 10/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 
                  // Src: (intrinsic_wo_chain:v4i32 5078:iPTR, i32:i32:$mipid, v32i8:v32i8:$rsrc, (imm:i32)<<P:Predicate_TEX_ARRAY>>) - Complexity = 12
                  // Dst: (IMAGE_GET_RESINFO_V4_V1:v4i32 15:i32, 0:i1, 0:i1, 1:i1, 0:i1, 0:i1, 0:i1, 0:i1, (V_MOV_B32_e32:i32 ?:i32:$mipid), ?:v32i8:$rsrc)
/*24591*/       /*Scope*/ 54, /*->24646*/
/*24592*/         OPC_CheckPredicate, 118, // Predicate_TEX_ARRAY_MSAA
/*24594*/         OPC_MoveParent,
/*24595*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*24597*/         OPC_EmitInteger, MVT::i32, 15, 
/*24600*/         OPC_EmitInteger, MVT::i1, 0, 
/*24603*/         OPC_EmitInteger, MVT::i1, 0, 
/*24606*/         OPC_EmitInteger, MVT::i1, 1, 
/*24609*/         OPC_EmitInteger, MVT::i1, 0, 
/*24612*/         OPC_EmitInteger, MVT::i1, 0, 
/*24615*/         OPC_EmitInteger, MVT::i1, 0, 
/*24618*/         OPC_EmitInteger, MVT::i1, 0, 
/*24621*/         OPC_EmitNode, TARGET_VAL(AMDGPU::V_MOV_B32_e32), 0,
                      1/*#VTs*/, MVT::i32, 1/*#Ops*/, 0,  // Results = #10
/*24629*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_GET_RESINFO_V4_V1), 0,
                      1/*#VTs*/, MVT::v4i32, 10/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 
                  // Src: (intrinsic_wo_chain:v4i32 5078:iPTR, i32:i32:$mipid, v32i8:v32i8:$rsrc, (imm:i32)<<P:Predicate_TEX_ARRAY_MSAA>>) - Complexity = 12
                  // Dst: (IMAGE_GET_RESINFO_V4_V1:v4i32 15:i32, 0:i1, 0:i1, 1:i1, 0:i1, 0:i1, 0:i1, 0:i1, (V_MOV_B32_e32:i32 ?:i32:$mipid), ?:v32i8:$rsrc)
/*24646*/       /*Scope*/ 52, /*->24699*/
/*24647*/         OPC_MoveParent,
/*24648*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*24650*/         OPC_EmitInteger, MVT::i32, 15, 
/*24653*/         OPC_EmitInteger, MVT::i1, 0, 
/*24656*/         OPC_EmitInteger, MVT::i1, 0, 
/*24659*/         OPC_EmitInteger, MVT::i1, 0, 
/*24662*/         OPC_EmitInteger, MVT::i1, 0, 
/*24665*/         OPC_EmitInteger, MVT::i1, 0, 
/*24668*/         OPC_EmitInteger, MVT::i1, 0, 
/*24671*/         OPC_EmitInteger, MVT::i1, 0, 
/*24674*/         OPC_EmitNode, TARGET_VAL(AMDGPU::V_MOV_B32_e32), 0,
                      1/*#VTs*/, MVT::i32, 1/*#Ops*/, 0,  // Results = #10
/*24682*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_GET_RESINFO_V4_V1), 0,
                      1/*#VTs*/, MVT::v4i32, 10/*#Ops*/, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 
                  // Src: (intrinsic_wo_chain:v4i32 5078:iPTR, i32:i32:$mipid, v32i8:v32i8:$rsrc, (imm:i32)) - Complexity = 11
                  // Dst: (IMAGE_GET_RESINFO_V4_V1:v4i32 15:i32, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, 0:i1, (V_MOV_B32_e32:i32 ?:i32:$mipid), ?:v32i8:$rsrc)
/*24699*/       0, /*End of Scope*/
/*24700*/     /*Scope*/ 28, /*->24729*/
/*24701*/       OPC_CheckChild0Integer, 118|128,38/*4982*/, 
/*24704*/       OPC_RecordChild1, // #0 = $ptr
/*24705*/       OPC_RecordChild2, // #1 = $BUFFER_ID
/*24706*/       OPC_MoveChild, 2,
/*24708*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*24711*/       OPC_MoveParent,
/*24712*/       OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*24714*/       OPC_CheckComplexPat, /*CP*/10, /*#*/0, // SelectGlobalValueVariableOffset:$ptr #2 #3
/*24717*/       OPC_EmitConvertToTarget, 1,
/*24719*/       OPC_MorphNodeTo, TARGET_VAL(AMDGPU::TEX_VTX_TEXBUF), 0,
                    1/*#VTs*/, MVT::v4f32, 3/*#Ops*/, 2, 3, 4, 
                // Src: (intrinsic_wo_chain:v4f32 4982:iPTR, ADDRGA_VAR_OFFSET:i32:$ptr, (imm:i32):$BUFFER_ID) - Complexity = 20
                // Dst: (TEX_VTX_TEXBUF:v4f32 ADDRGA_VAR_OFFSET:i32:$ptr, (imm:i32):$BUFFER_ID)
/*24729*/     /*Scope*/ 76, /*->24806*/
/*24730*/       OPC_CheckChild0Integer, 97|128,38/*4961*/, 
/*24733*/       OPC_RecordChild1, // #0 = $src0
/*24734*/       OPC_RecordChild2, // #1 = $src1
/*24735*/       OPC_RecordChild3, // #2 = $src2
/*24736*/       OPC_RecordChild4, // #3 = $resourceId
/*24737*/       OPC_MoveChild, 4,
/*24739*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*24742*/       OPC_MoveParent,
/*24743*/       OPC_RecordChild5, // #4 = $samplerId
/*24744*/       OPC_MoveChild, 5,
/*24746*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*24749*/       OPC_MoveParent,
/*24750*/       OPC_RecordChild6, // #5 = $textureTarget
/*24751*/       OPC_MoveChild, 6,
/*24753*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*24756*/       OPC_Scope, 24, /*->24782*/ // 2 children in Scope
/*24758*/         OPC_CheckPredicate, 119, // Predicate_TEX_SHADOW
/*24760*/         OPC_MoveParent,
/*24761*/         OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*24763*/         OPC_EmitConvertToTarget, 3,
/*24765*/         OPC_EmitConvertToTarget, 4,
/*24767*/         OPC_EmitConvertToTarget, 5,
/*24769*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::TXD_SHADOW), 0,
                      1/*#VTs*/, MVT::v4f32, 6/*#Ops*/, 0, 1, 2, 6, 7, 8, 
                  // Src: (intrinsic_wo_chain:v4f32 4961:iPTR, v4f32:v4f32:$src0, v4f32:v4f32:$src1, v4f32:v4f32:$src2, (imm:i32):$resourceId, (imm:i32):$samplerId, (imm:i32)<<P:Predicate_TEX_SHADOW>>:$textureTarget) - Complexity = 18
                  // Dst: (TXD_SHADOW:v4f32 v4f32:v4f32:$src0, v4f32:v4f32:$src1, v4f32:v4f32:$src2, (imm:i32):$resourceId, (imm:i32):$samplerId, (imm:i32):$textureTarget)
/*24782*/       /*Scope*/ 22, /*->24805*/
/*24783*/         OPC_MoveParent,
/*24784*/         OPC_CheckPatternPredicate, 9, // (Subtarget->getGeneration() <= AMDGPUSubtarget::NORTHERN_ISLANDS)
/*24786*/         OPC_EmitConvertToTarget, 3,
/*24788*/         OPC_EmitConvertToTarget, 4,
/*24790*/         OPC_EmitConvertToTarget, 5,
/*24792*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::TXD), 0,
                      1/*#VTs*/, MVT::v4f32, 6/*#Ops*/, 0, 1, 2, 6, 7, 8, 
                  // Src: (intrinsic_wo_chain:v4f32 4961:iPTR, v4f32:v4f32:$src0, v4f32:v4f32:$src1, v4f32:v4f32:$src2, (imm:i32):$resourceId, (imm:i32):$samplerId, (imm:i32):$textureTarget) - Complexity = 17
                  // Dst: (TXD:v4f32 v4f32:v4f32:$src0, v4f32:v4f32:$src1, v4f32:v4f32:$src2, (imm:i32):$resourceId, (imm:i32):$samplerId, (imm:i32):$textureTarget)
/*24805*/       0, /*End of Scope*/
/*24806*/     /*Scope*/ 20, /*->24827*/
/*24807*/       OPC_CheckChild0Integer, 112|128,38/*4976*/, 
/*24810*/       OPC_RecordChild1, // #0 = $src0
/*24811*/       OPC_MoveChild, 1,
/*24813*/       OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*24816*/       OPC_MoveParent,
/*24817*/       OPC_EmitConvertToTarget, 0,
/*24819*/       OPC_MorphNodeTo, TARGET_VAL(AMDGPU::INTERP_VEC_LOAD), 0,
                    1/*#VTs*/, MVT::v4f32, 1/*#Ops*/, 1, 
                // Src: (intrinsic_wo_chain:v4f32 4976:iPTR, (imm:i32):$src0) - Complexity = 11
                // Dst: (INTERP_VEC_LOAD:v4f32 (imm:i32):$src0)
/*24827*/     /*Scope*/ 71|128,2/*327*/, /*->25156*/
/*24829*/       OPC_CheckChild0Integer, 65|128,38/*4929*/, 
/*24832*/       OPC_RecordChild1, // #0 = $src0
/*24833*/       OPC_Scope, 10, /*->24845*/ // 3 children in Scope
/*24835*/         OPC_CheckPatternPredicate, 8, // (Subtarget->getGeneration() <= AMDGPUSubtarget::R700)
/*24837*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CUBE_r600_pseudo), 0,
                      1/*#VTs*/, MVT::v4f32, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:v4f32 4929:iPTR, v4f32:v4f32:$src0) - Complexity = 8
                  // Dst: (CUBE_r600_pseudo:v4f32 v4f32:v4f32:$src0)
/*24845*/       /*Scope*/ 10, /*->24856*/
/*24846*/         OPC_CheckPatternPredicate, 2, // (Subtarget->getGeneration() == AMDGPUSubtarget::EVERGREEN ||Subtarget->getGeneration() ==AMDGPUSubtarget::NORTHERN_ISLANDS)
/*24848*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::CUBE_eg_pseudo), 0,
                      1/*#VTs*/, MVT::v4f32, 1/*#Ops*/, 0, 
                  // Src: (intrinsic_wo_chain:v4f32 4929:iPTR, v4f32:v4f32:$src0) - Complexity = 8
                  // Dst: (CUBE_eg_pseudo:v4f32 v4f32:v4f32:$src0)
/*24856*/       /*Scope*/ 41|128,2/*297*/, /*->25155*/
/*24858*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*24860*/         OPC_EmitInteger, MVT::i32, AMDGPU::VReg_128RegClassID,
/*24863*/         OPC_EmitInteger, MVT::i32, 0, 
/*24866*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*24869*/         OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 3,  // Results = #4
/*24878*/         OPC_EmitInteger, MVT::i32, 0, 
/*24881*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*24884*/         OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 6,  // Results = #7
/*24893*/         OPC_EmitInteger, MVT::i32, 0, 
/*24896*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*24899*/         OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 9,  // Results = #10
/*24908*/         OPC_EmitInteger, MVT::i1, 0, 
/*24911*/         OPC_EmitInteger, MVT::i32, 0, 
/*24914*/         OPC_EmitNode, TARGET_VAL(AMDGPU::V_CUBETC_F32), 0,
                      1/*#VTs*/, MVT::i32, 8/*#Ops*/, 2, 4, 5, 7, 8, 10, 11, 12,  // Results = #13
/*24929*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*24932*/         OPC_EmitInteger, MVT::i32, 0, 
/*24935*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*24938*/         OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 16,  // Results = #17
/*24947*/         OPC_EmitInteger, MVT::i32, 0, 
/*24950*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*24953*/         OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 19,  // Results = #20
/*24962*/         OPC_EmitInteger, MVT::i32, 0, 
/*24965*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*24968*/         OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 22,  // Results = #23
/*24977*/         OPC_EmitInteger, MVT::i1, 0, 
/*24980*/         OPC_EmitInteger, MVT::i32, 0, 
/*24983*/         OPC_EmitNode, TARGET_VAL(AMDGPU::V_CUBESC_F32), 0,
                      1/*#VTs*/, MVT::i32, 8/*#Ops*/, 15, 17, 18, 20, 21, 23, 24, 25,  // Results = #26
/*24998*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*25001*/         OPC_EmitInteger, MVT::i32, 0, 
/*25004*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*25007*/         OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 29,  // Results = #30
/*25016*/         OPC_EmitInteger, MVT::i32, 0, 
/*25019*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*25022*/         OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 32,  // Results = #33
/*25031*/         OPC_EmitInteger, MVT::i32, 0, 
/*25034*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*25037*/         OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 35,  // Results = #36
/*25046*/         OPC_EmitInteger, MVT::i1, 0, 
/*25049*/         OPC_EmitInteger, MVT::i32, 0, 
/*25052*/         OPC_EmitNode, TARGET_VAL(AMDGPU::V_CUBEMA_F32), 0,
                      1/*#VTs*/, MVT::i32, 8/*#Ops*/, 28, 30, 31, 33, 34, 36, 37, 38,  // Results = #39
/*25067*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*25070*/         OPC_EmitInteger, MVT::i32, 0, 
/*25073*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub0,
/*25076*/         OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 42,  // Results = #43
/*25085*/         OPC_EmitInteger, MVT::i32, 0, 
/*25088*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub1,
/*25091*/         OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 45,  // Results = #46
/*25100*/         OPC_EmitInteger, MVT::i32, 0, 
/*25103*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub2,
/*25106*/         OPC_EmitNode, TARGET_VAL(TargetOpcode::EXTRACT_SUBREG), 0,
                      1/*#VTs*/, MVT::i32, 2/*#Ops*/, 0, 48,  // Results = #49
/*25115*/         OPC_EmitInteger, MVT::i1, 0, 
/*25118*/         OPC_EmitInteger, MVT::i32, 0, 
/*25121*/         OPC_EmitNode, TARGET_VAL(AMDGPU::V_CUBEID_F32), 0,
                      1/*#VTs*/, MVT::i32, 8/*#Ops*/, 41, 43, 44, 46, 47, 49, 50, 51,  // Results = #52
/*25136*/         OPC_EmitInteger, MVT::i32, AMDGPU::sub3,
/*25139*/         OPC_MorphNodeTo, TARGET_VAL(TargetOpcode::REG_SEQUENCE), 0,
                      1/*#VTs*/, MVT::v4f32, 9/*#Ops*/, 1, 13, 14, 26, 27, 39, 40, 52, 53, 
                  // Src: (intrinsic_wo_chain:v4f32 4929:iPTR, v4f32:v4f32:$src) - Complexity = 8
                  // Dst: (REG_SEQUENCE:v4f32 VReg_128:i32, (V_CUBETC_F32:i32 0:i32, (EXTRACT_SUBREG:i32 ?:v4f32:$src, sub0:i32), 0:i32, (EXTRACT_SUBREG:i32 ?:v4f32:$src, sub1:i32), 0:i32, (EXTRACT_SUBREG:i32 ?:v4f32:$src, sub2:i32), 0:i1, 0:i32), sub0:i32, (V_CUBESC_F32:i32 0:i32, (EXTRACT_SUBREG:i32 ?:v4f32:$src, sub0:i32), 0:i32, (EXTRACT_SUBREG:i32 ?:v4f32:$src, sub1:i32), 0:i32, (EXTRACT_SUBREG:i32 ?:v4f32:$src, sub2:i32), 0:i1, 0:i32), sub1:i32, (V_CUBEMA_F32:i32 0:i32, (EXTRACT_SUBREG:i32 ?:v4f32:$src, sub0:i32), 0:i32, (EXTRACT_SUBREG:i32 ?:v4f32:$src, sub1:i32), 0:i32, (EXTRACT_SUBREG:i32 ?:v4f32:$src, sub2:i32), 0:i1, 0:i32), sub2:i32, (V_CUBEID_F32:i32 0:i32, (EXTRACT_SUBREG:i32 ?:v4f32:$src, sub0:i32), 0:i32, (EXTRACT_SUBREG:i32 ?:v4f32:$src, sub1:i32), 0:i32, (EXTRACT_SUBREG:i32 ?:v4f32:$src, sub2:i32), 0:i1, 0:i32), sub3:i32)
/*25155*/       0, /*End of Scope*/
/*25156*/     /*Scope*/ 95|128,2/*351*/, /*->25509*/
/*25158*/       OPC_CheckChild0Integer, 42|128,39/*5034*/, 
/*25161*/       OPC_RecordChild1, // #0 = $addr
/*25162*/       OPC_Scope, 68, /*->25232*/ // 5 children in Scope
/*25164*/         OPC_CheckChild1Type, MVT::i32,
/*25166*/         OPC_RecordChild2, // #1 = $rsrc
/*25167*/         OPC_RecordChild3, // #2 = $sampler
/*25168*/         OPC_RecordChild4, // #3 = $dmask
/*25169*/         OPC_RecordChild5, // #4 = $unorm
/*25170*/         OPC_RecordChild6, // #5 = $r128
/*25171*/         OPC_RecordChild7, // #6 = $da
/*25172*/         OPC_MoveChild, 8,
/*25174*/         OPC_RecordNode, // #7 = $glc
/*25175*/         OPC_MoveParent,
/*25176*/         OPC_MoveChild, 9,
/*25178*/         OPC_RecordNode, // #8 = $slc
/*25179*/         OPC_MoveParent,
/*25180*/         OPC_MoveChild, 10,
/*25182*/         OPC_RecordNode, // #9 = $tfe
/*25183*/         OPC_MoveParent,
/*25184*/         OPC_MoveChild, 11,
/*25186*/         OPC_RecordNode, // #10 = $lwe
/*25187*/         OPC_MoveParent,
/*25188*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*25190*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*25193*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*25196*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*25199*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*25202*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*25205*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*25208*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*25211*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*25214*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5034:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*25232*/       /*Scope*/ 68, /*->25301*/
/*25233*/         OPC_CheckChild1Type, MVT::v2i32,
/*25235*/         OPC_RecordChild2, // #1 = $rsrc
/*25236*/         OPC_RecordChild3, // #2 = $sampler
/*25237*/         OPC_RecordChild4, // #3 = $dmask
/*25238*/         OPC_RecordChild5, // #4 = $unorm
/*25239*/         OPC_RecordChild6, // #5 = $r128
/*25240*/         OPC_RecordChild7, // #6 = $da
/*25241*/         OPC_MoveChild, 8,
/*25243*/         OPC_RecordNode, // #7 = $glc
/*25244*/         OPC_MoveParent,
/*25245*/         OPC_MoveChild, 9,
/*25247*/         OPC_RecordNode, // #8 = $slc
/*25248*/         OPC_MoveParent,
/*25249*/         OPC_MoveChild, 10,
/*25251*/         OPC_RecordNode, // #9 = $tfe
/*25252*/         OPC_MoveParent,
/*25253*/         OPC_MoveChild, 11,
/*25255*/         OPC_RecordNode, // #10 = $lwe
/*25256*/         OPC_MoveParent,
/*25257*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*25259*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*25262*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*25265*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*25268*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*25271*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*25274*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*25277*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*25280*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*25283*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5034:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*25301*/       /*Scope*/ 68, /*->25370*/
/*25302*/         OPC_CheckChild1Type, MVT::v4i32,
/*25304*/         OPC_RecordChild2, // #1 = $rsrc
/*25305*/         OPC_RecordChild3, // #2 = $sampler
/*25306*/         OPC_RecordChild4, // #3 = $dmask
/*25307*/         OPC_RecordChild5, // #4 = $unorm
/*25308*/         OPC_RecordChild6, // #5 = $r128
/*25309*/         OPC_RecordChild7, // #6 = $da
/*25310*/         OPC_MoveChild, 8,
/*25312*/         OPC_RecordNode, // #7 = $glc
/*25313*/         OPC_MoveParent,
/*25314*/         OPC_MoveChild, 9,
/*25316*/         OPC_RecordNode, // #8 = $slc
/*25317*/         OPC_MoveParent,
/*25318*/         OPC_MoveChild, 10,
/*25320*/         OPC_RecordNode, // #9 = $tfe
/*25321*/         OPC_MoveParent,
/*25322*/         OPC_MoveChild, 11,
/*25324*/         OPC_RecordNode, // #10 = $lwe
/*25325*/         OPC_MoveParent,
/*25326*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*25328*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*25331*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*25334*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*25337*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*25340*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*25343*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*25346*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*25349*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*25352*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5034:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*25370*/       /*Scope*/ 68, /*->25439*/
/*25371*/         OPC_CheckChild1Type, MVT::v8i32,
/*25373*/         OPC_RecordChild2, // #1 = $rsrc
/*25374*/         OPC_RecordChild3, // #2 = $sampler
/*25375*/         OPC_RecordChild4, // #3 = $dmask
/*25376*/         OPC_RecordChild5, // #4 = $unorm
/*25377*/         OPC_RecordChild6, // #5 = $r128
/*25378*/         OPC_RecordChild7, // #6 = $da
/*25379*/         OPC_MoveChild, 8,
/*25381*/         OPC_RecordNode, // #7 = $glc
/*25382*/         OPC_MoveParent,
/*25383*/         OPC_MoveChild, 9,
/*25385*/         OPC_RecordNode, // #8 = $slc
/*25386*/         OPC_MoveParent,
/*25387*/         OPC_MoveChild, 10,
/*25389*/         OPC_RecordNode, // #9 = $tfe
/*25390*/         OPC_MoveParent,
/*25391*/         OPC_MoveChild, 11,
/*25393*/         OPC_RecordNode, // #10 = $lwe
/*25394*/         OPC_MoveParent,
/*25395*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*25397*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*25400*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*25403*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*25406*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*25409*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*25412*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*25415*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*25418*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*25421*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5034:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*25439*/       /*Scope*/ 68, /*->25508*/
/*25440*/         OPC_CheckChild1Type, MVT::v16i32,
/*25442*/         OPC_RecordChild2, // #1 = $rsrc
/*25443*/         OPC_RecordChild3, // #2 = $sampler
/*25444*/         OPC_RecordChild4, // #3 = $dmask
/*25445*/         OPC_RecordChild5, // #4 = $unorm
/*25446*/         OPC_RecordChild6, // #5 = $r128
/*25447*/         OPC_RecordChild7, // #6 = $da
/*25448*/         OPC_MoveChild, 8,
/*25450*/         OPC_RecordNode, // #7 = $glc
/*25451*/         OPC_MoveParent,
/*25452*/         OPC_MoveChild, 9,
/*25454*/         OPC_RecordNode, // #8 = $slc
/*25455*/         OPC_MoveParent,
/*25456*/         OPC_MoveChild, 10,
/*25458*/         OPC_RecordNode, // #9 = $tfe
/*25459*/         OPC_MoveParent,
/*25460*/         OPC_MoveChild, 11,
/*25462*/         OPC_RecordNode, // #10 = $lwe
/*25463*/         OPC_MoveParent,
/*25464*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*25466*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*25469*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*25472*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*25475*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*25478*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*25481*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*25484*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*25487*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*25490*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5034:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*25508*/       0, /*End of Scope*/
/*25509*/     /*Scope*/ 95|128,2/*351*/, /*->25862*/
/*25511*/       OPC_CheckChild0Integer, 71|128,39/*5063*/, 
/*25514*/       OPC_RecordChild1, // #0 = $addr
/*25515*/       OPC_Scope, 68, /*->25585*/ // 5 children in Scope
/*25517*/         OPC_CheckChild1Type, MVT::i32,
/*25519*/         OPC_RecordChild2, // #1 = $rsrc
/*25520*/         OPC_RecordChild3, // #2 = $sampler
/*25521*/         OPC_RecordChild4, // #3 = $dmask
/*25522*/         OPC_RecordChild5, // #4 = $unorm
/*25523*/         OPC_RecordChild6, // #5 = $r128
/*25524*/         OPC_RecordChild7, // #6 = $da
/*25525*/         OPC_MoveChild, 8,
/*25527*/         OPC_RecordNode, // #7 = $glc
/*25528*/         OPC_MoveParent,
/*25529*/         OPC_MoveChild, 9,
/*25531*/         OPC_RecordNode, // #8 = $slc
/*25532*/         OPC_MoveParent,
/*25533*/         OPC_MoveChild, 10,
/*25535*/         OPC_RecordNode, // #9 = $tfe
/*25536*/         OPC_MoveParent,
/*25537*/         OPC_MoveChild, 11,
/*25539*/         OPC_RecordNode, // #10 = $lwe
/*25540*/         OPC_MoveParent,
/*25541*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*25543*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*25546*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*25549*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*25552*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*25555*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*25558*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*25561*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*25564*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*25567*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CL_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5063:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CL_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*25585*/       /*Scope*/ 68, /*->25654*/
/*25586*/         OPC_CheckChild1Type, MVT::v2i32,
/*25588*/         OPC_RecordChild2, // #1 = $rsrc
/*25589*/         OPC_RecordChild3, // #2 = $sampler
/*25590*/         OPC_RecordChild4, // #3 = $dmask
/*25591*/         OPC_RecordChild5, // #4 = $unorm
/*25592*/         OPC_RecordChild6, // #5 = $r128
/*25593*/         OPC_RecordChild7, // #6 = $da
/*25594*/         OPC_MoveChild, 8,
/*25596*/         OPC_RecordNode, // #7 = $glc
/*25597*/         OPC_MoveParent,
/*25598*/         OPC_MoveChild, 9,
/*25600*/         OPC_RecordNode, // #8 = $slc
/*25601*/         OPC_MoveParent,
/*25602*/         OPC_MoveChild, 10,
/*25604*/         OPC_RecordNode, // #9 = $tfe
/*25605*/         OPC_MoveParent,
/*25606*/         OPC_MoveChild, 11,
/*25608*/         OPC_RecordNode, // #10 = $lwe
/*25609*/         OPC_MoveParent,
/*25610*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*25612*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*25615*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*25618*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*25621*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*25624*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*25627*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*25630*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*25633*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*25636*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CL_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5063:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CL_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*25654*/       /*Scope*/ 68, /*->25723*/
/*25655*/         OPC_CheckChild1Type, MVT::v4i32,
/*25657*/         OPC_RecordChild2, // #1 = $rsrc
/*25658*/         OPC_RecordChild3, // #2 = $sampler
/*25659*/         OPC_RecordChild4, // #3 = $dmask
/*25660*/         OPC_RecordChild5, // #4 = $unorm
/*25661*/         OPC_RecordChild6, // #5 = $r128
/*25662*/         OPC_RecordChild7, // #6 = $da
/*25663*/         OPC_MoveChild, 8,
/*25665*/         OPC_RecordNode, // #7 = $glc
/*25666*/         OPC_MoveParent,
/*25667*/         OPC_MoveChild, 9,
/*25669*/         OPC_RecordNode, // #8 = $slc
/*25670*/         OPC_MoveParent,
/*25671*/         OPC_MoveChild, 10,
/*25673*/         OPC_RecordNode, // #9 = $tfe
/*25674*/         OPC_MoveParent,
/*25675*/         OPC_MoveChild, 11,
/*25677*/         OPC_RecordNode, // #10 = $lwe
/*25678*/         OPC_MoveParent,
/*25679*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*25681*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*25684*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*25687*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*25690*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*25693*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*25696*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*25699*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*25702*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*25705*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CL_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5063:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CL_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*25723*/       /*Scope*/ 68, /*->25792*/
/*25724*/         OPC_CheckChild1Type, MVT::v8i32,
/*25726*/         OPC_RecordChild2, // #1 = $rsrc
/*25727*/         OPC_RecordChild3, // #2 = $sampler
/*25728*/         OPC_RecordChild4, // #3 = $dmask
/*25729*/         OPC_RecordChild5, // #4 = $unorm
/*25730*/         OPC_RecordChild6, // #5 = $r128
/*25731*/         OPC_RecordChild7, // #6 = $da
/*25732*/         OPC_MoveChild, 8,
/*25734*/         OPC_RecordNode, // #7 = $glc
/*25735*/         OPC_MoveParent,
/*25736*/         OPC_MoveChild, 9,
/*25738*/         OPC_RecordNode, // #8 = $slc
/*25739*/         OPC_MoveParent,
/*25740*/         OPC_MoveChild, 10,
/*25742*/         OPC_RecordNode, // #9 = $tfe
/*25743*/         OPC_MoveParent,
/*25744*/         OPC_MoveChild, 11,
/*25746*/         OPC_RecordNode, // #10 = $lwe
/*25747*/         OPC_MoveParent,
/*25748*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*25750*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*25753*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*25756*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*25759*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*25762*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*25765*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*25768*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*25771*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*25774*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CL_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5063:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CL_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*25792*/       /*Scope*/ 68, /*->25861*/
/*25793*/         OPC_CheckChild1Type, MVT::v16i32,
/*25795*/         OPC_RecordChild2, // #1 = $rsrc
/*25796*/         OPC_RecordChild3, // #2 = $sampler
/*25797*/         OPC_RecordChild4, // #3 = $dmask
/*25798*/         OPC_RecordChild5, // #4 = $unorm
/*25799*/         OPC_RecordChild6, // #5 = $r128
/*25800*/         OPC_RecordChild7, // #6 = $da
/*25801*/         OPC_MoveChild, 8,
/*25803*/         OPC_RecordNode, // #7 = $glc
/*25804*/         OPC_MoveParent,
/*25805*/         OPC_MoveChild, 9,
/*25807*/         OPC_RecordNode, // #8 = $slc
/*25808*/         OPC_MoveParent,
/*25809*/         OPC_MoveChild, 10,
/*25811*/         OPC_RecordNode, // #9 = $tfe
/*25812*/         OPC_MoveParent,
/*25813*/         OPC_MoveChild, 11,
/*25815*/         OPC_RecordNode, // #10 = $lwe
/*25816*/         OPC_MoveParent,
/*25817*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*25819*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*25822*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*25825*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*25828*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*25831*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*25834*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*25837*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*25840*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*25843*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CL_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5063:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CL_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*25861*/       0, /*End of Scope*/
/*25862*/     /*Scope*/ 95|128,2/*351*/, /*->26215*/
/*25864*/       OPC_CheckChild0Integer, 73|128,39/*5065*/, 
/*25867*/       OPC_RecordChild1, // #0 = $addr
/*25868*/       OPC_Scope, 68, /*->25938*/ // 5 children in Scope
/*25870*/         OPC_CheckChild1Type, MVT::i32,
/*25872*/         OPC_RecordChild2, // #1 = $rsrc
/*25873*/         OPC_RecordChild3, // #2 = $sampler
/*25874*/         OPC_RecordChild4, // #3 = $dmask
/*25875*/         OPC_RecordChild5, // #4 = $unorm
/*25876*/         OPC_RecordChild6, // #5 = $r128
/*25877*/         OPC_RecordChild7, // #6 = $da
/*25878*/         OPC_MoveChild, 8,
/*25880*/         OPC_RecordNode, // #7 = $glc
/*25881*/         OPC_MoveParent,
/*25882*/         OPC_MoveChild, 9,
/*25884*/         OPC_RecordNode, // #8 = $slc
/*25885*/         OPC_MoveParent,
/*25886*/         OPC_MoveChild, 10,
/*25888*/         OPC_RecordNode, // #9 = $tfe
/*25889*/         OPC_MoveParent,
/*25890*/         OPC_MoveChild, 11,
/*25892*/         OPC_RecordNode, // #10 = $lwe
/*25893*/         OPC_MoveParent,
/*25894*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*25896*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*25899*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*25902*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*25905*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*25908*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*25911*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*25914*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*25917*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*25920*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5065:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*25938*/       /*Scope*/ 68, /*->26007*/
/*25939*/         OPC_CheckChild1Type, MVT::v2i32,
/*25941*/         OPC_RecordChild2, // #1 = $rsrc
/*25942*/         OPC_RecordChild3, // #2 = $sampler
/*25943*/         OPC_RecordChild4, // #3 = $dmask
/*25944*/         OPC_RecordChild5, // #4 = $unorm
/*25945*/         OPC_RecordChild6, // #5 = $r128
/*25946*/         OPC_RecordChild7, // #6 = $da
/*25947*/         OPC_MoveChild, 8,
/*25949*/         OPC_RecordNode, // #7 = $glc
/*25950*/         OPC_MoveParent,
/*25951*/         OPC_MoveChild, 9,
/*25953*/         OPC_RecordNode, // #8 = $slc
/*25954*/         OPC_MoveParent,
/*25955*/         OPC_MoveChild, 10,
/*25957*/         OPC_RecordNode, // #9 = $tfe
/*25958*/         OPC_MoveParent,
/*25959*/         OPC_MoveChild, 11,
/*25961*/         OPC_RecordNode, // #10 = $lwe
/*25962*/         OPC_MoveParent,
/*25963*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*25965*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*25968*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*25971*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*25974*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*25977*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*25980*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*25983*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*25986*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*25989*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5065:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26007*/       /*Scope*/ 68, /*->26076*/
/*26008*/         OPC_CheckChild1Type, MVT::v4i32,
/*26010*/         OPC_RecordChild2, // #1 = $rsrc
/*26011*/         OPC_RecordChild3, // #2 = $sampler
/*26012*/         OPC_RecordChild4, // #3 = $dmask
/*26013*/         OPC_RecordChild5, // #4 = $unorm
/*26014*/         OPC_RecordChild6, // #5 = $r128
/*26015*/         OPC_RecordChild7, // #6 = $da
/*26016*/         OPC_MoveChild, 8,
/*26018*/         OPC_RecordNode, // #7 = $glc
/*26019*/         OPC_MoveParent,
/*26020*/         OPC_MoveChild, 9,
/*26022*/         OPC_RecordNode, // #8 = $slc
/*26023*/         OPC_MoveParent,
/*26024*/         OPC_MoveChild, 10,
/*26026*/         OPC_RecordNode, // #9 = $tfe
/*26027*/         OPC_MoveParent,
/*26028*/         OPC_MoveChild, 11,
/*26030*/         OPC_RecordNode, // #10 = $lwe
/*26031*/         OPC_MoveParent,
/*26032*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26034*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26037*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26040*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26043*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26046*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26049*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26052*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26055*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26058*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5065:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26076*/       /*Scope*/ 68, /*->26145*/
/*26077*/         OPC_CheckChild1Type, MVT::v8i32,
/*26079*/         OPC_RecordChild2, // #1 = $rsrc
/*26080*/         OPC_RecordChild3, // #2 = $sampler
/*26081*/         OPC_RecordChild4, // #3 = $dmask
/*26082*/         OPC_RecordChild5, // #4 = $unorm
/*26083*/         OPC_RecordChild6, // #5 = $r128
/*26084*/         OPC_RecordChild7, // #6 = $da
/*26085*/         OPC_MoveChild, 8,
/*26087*/         OPC_RecordNode, // #7 = $glc
/*26088*/         OPC_MoveParent,
/*26089*/         OPC_MoveChild, 9,
/*26091*/         OPC_RecordNode, // #8 = $slc
/*26092*/         OPC_MoveParent,
/*26093*/         OPC_MoveChild, 10,
/*26095*/         OPC_RecordNode, // #9 = $tfe
/*26096*/         OPC_MoveParent,
/*26097*/         OPC_MoveChild, 11,
/*26099*/         OPC_RecordNode, // #10 = $lwe
/*26100*/         OPC_MoveParent,
/*26101*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26103*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26106*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26109*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26112*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26115*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26118*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26121*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26124*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26127*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5065:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26145*/       /*Scope*/ 68, /*->26214*/
/*26146*/         OPC_CheckChild1Type, MVT::v16i32,
/*26148*/         OPC_RecordChild2, // #1 = $rsrc
/*26149*/         OPC_RecordChild3, // #2 = $sampler
/*26150*/         OPC_RecordChild4, // #3 = $dmask
/*26151*/         OPC_RecordChild5, // #4 = $unorm
/*26152*/         OPC_RecordChild6, // #5 = $r128
/*26153*/         OPC_RecordChild7, // #6 = $da
/*26154*/         OPC_MoveChild, 8,
/*26156*/         OPC_RecordNode, // #7 = $glc
/*26157*/         OPC_MoveParent,
/*26158*/         OPC_MoveChild, 9,
/*26160*/         OPC_RecordNode, // #8 = $slc
/*26161*/         OPC_MoveParent,
/*26162*/         OPC_MoveChild, 10,
/*26164*/         OPC_RecordNode, // #9 = $tfe
/*26165*/         OPC_MoveParent,
/*26166*/         OPC_MoveChild, 11,
/*26168*/         OPC_RecordNode, // #10 = $lwe
/*26169*/         OPC_MoveParent,
/*26170*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26172*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26175*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26178*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26181*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26184*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26187*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26190*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26193*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26196*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5065:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26214*/       0, /*End of Scope*/
/*26215*/     /*Scope*/ 95|128,2/*351*/, /*->26568*/
/*26217*/       OPC_CheckChild0Integer, 74|128,39/*5066*/, 
/*26220*/       OPC_RecordChild1, // #0 = $addr
/*26221*/       OPC_Scope, 68, /*->26291*/ // 5 children in Scope
/*26223*/         OPC_CheckChild1Type, MVT::i32,
/*26225*/         OPC_RecordChild2, // #1 = $rsrc
/*26226*/         OPC_RecordChild3, // #2 = $sampler
/*26227*/         OPC_RecordChild4, // #3 = $dmask
/*26228*/         OPC_RecordChild5, // #4 = $unorm
/*26229*/         OPC_RecordChild6, // #5 = $r128
/*26230*/         OPC_RecordChild7, // #6 = $da
/*26231*/         OPC_MoveChild, 8,
/*26233*/         OPC_RecordNode, // #7 = $glc
/*26234*/         OPC_MoveParent,
/*26235*/         OPC_MoveChild, 9,
/*26237*/         OPC_RecordNode, // #8 = $slc
/*26238*/         OPC_MoveParent,
/*26239*/         OPC_MoveChild, 10,
/*26241*/         OPC_RecordNode, // #9 = $tfe
/*26242*/         OPC_MoveParent,
/*26243*/         OPC_MoveChild, 11,
/*26245*/         OPC_RecordNode, // #10 = $lwe
/*26246*/         OPC_MoveParent,
/*26247*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26249*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26252*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26255*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26258*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26261*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26264*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26267*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26270*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26273*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_CL_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5066:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_CL_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26291*/       /*Scope*/ 68, /*->26360*/
/*26292*/         OPC_CheckChild1Type, MVT::v2i32,
/*26294*/         OPC_RecordChild2, // #1 = $rsrc
/*26295*/         OPC_RecordChild3, // #2 = $sampler
/*26296*/         OPC_RecordChild4, // #3 = $dmask
/*26297*/         OPC_RecordChild5, // #4 = $unorm
/*26298*/         OPC_RecordChild6, // #5 = $r128
/*26299*/         OPC_RecordChild7, // #6 = $da
/*26300*/         OPC_MoveChild, 8,
/*26302*/         OPC_RecordNode, // #7 = $glc
/*26303*/         OPC_MoveParent,
/*26304*/         OPC_MoveChild, 9,
/*26306*/         OPC_RecordNode, // #8 = $slc
/*26307*/         OPC_MoveParent,
/*26308*/         OPC_MoveChild, 10,
/*26310*/         OPC_RecordNode, // #9 = $tfe
/*26311*/         OPC_MoveParent,
/*26312*/         OPC_MoveChild, 11,
/*26314*/         OPC_RecordNode, // #10 = $lwe
/*26315*/         OPC_MoveParent,
/*26316*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26318*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26321*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26324*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26327*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26330*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26333*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26336*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26339*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26342*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_CL_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5066:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_CL_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26360*/       /*Scope*/ 68, /*->26429*/
/*26361*/         OPC_CheckChild1Type, MVT::v4i32,
/*26363*/         OPC_RecordChild2, // #1 = $rsrc
/*26364*/         OPC_RecordChild3, // #2 = $sampler
/*26365*/         OPC_RecordChild4, // #3 = $dmask
/*26366*/         OPC_RecordChild5, // #4 = $unorm
/*26367*/         OPC_RecordChild6, // #5 = $r128
/*26368*/         OPC_RecordChild7, // #6 = $da
/*26369*/         OPC_MoveChild, 8,
/*26371*/         OPC_RecordNode, // #7 = $glc
/*26372*/         OPC_MoveParent,
/*26373*/         OPC_MoveChild, 9,
/*26375*/         OPC_RecordNode, // #8 = $slc
/*26376*/         OPC_MoveParent,
/*26377*/         OPC_MoveChild, 10,
/*26379*/         OPC_RecordNode, // #9 = $tfe
/*26380*/         OPC_MoveParent,
/*26381*/         OPC_MoveChild, 11,
/*26383*/         OPC_RecordNode, // #10 = $lwe
/*26384*/         OPC_MoveParent,
/*26385*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26387*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26390*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26393*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26396*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26399*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26402*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26405*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26408*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26411*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_CL_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5066:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_CL_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26429*/       /*Scope*/ 68, /*->26498*/
/*26430*/         OPC_CheckChild1Type, MVT::v8i32,
/*26432*/         OPC_RecordChild2, // #1 = $rsrc
/*26433*/         OPC_RecordChild3, // #2 = $sampler
/*26434*/         OPC_RecordChild4, // #3 = $dmask
/*26435*/         OPC_RecordChild5, // #4 = $unorm
/*26436*/         OPC_RecordChild6, // #5 = $r128
/*26437*/         OPC_RecordChild7, // #6 = $da
/*26438*/         OPC_MoveChild, 8,
/*26440*/         OPC_RecordNode, // #7 = $glc
/*26441*/         OPC_MoveParent,
/*26442*/         OPC_MoveChild, 9,
/*26444*/         OPC_RecordNode, // #8 = $slc
/*26445*/         OPC_MoveParent,
/*26446*/         OPC_MoveChild, 10,
/*26448*/         OPC_RecordNode, // #9 = $tfe
/*26449*/         OPC_MoveParent,
/*26450*/         OPC_MoveChild, 11,
/*26452*/         OPC_RecordNode, // #10 = $lwe
/*26453*/         OPC_MoveParent,
/*26454*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26456*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26459*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26462*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26465*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26468*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26471*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26474*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26477*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26480*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_CL_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5066:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_CL_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26498*/       /*Scope*/ 68, /*->26567*/
/*26499*/         OPC_CheckChild1Type, MVT::v16i32,
/*26501*/         OPC_RecordChild2, // #1 = $rsrc
/*26502*/         OPC_RecordChild3, // #2 = $sampler
/*26503*/         OPC_RecordChild4, // #3 = $dmask
/*26504*/         OPC_RecordChild5, // #4 = $unorm
/*26505*/         OPC_RecordChild6, // #5 = $r128
/*26506*/         OPC_RecordChild7, // #6 = $da
/*26507*/         OPC_MoveChild, 8,
/*26509*/         OPC_RecordNode, // #7 = $glc
/*26510*/         OPC_MoveParent,
/*26511*/         OPC_MoveChild, 9,
/*26513*/         OPC_RecordNode, // #8 = $slc
/*26514*/         OPC_MoveParent,
/*26515*/         OPC_MoveChild, 10,
/*26517*/         OPC_RecordNode, // #9 = $tfe
/*26518*/         OPC_MoveParent,
/*26519*/         OPC_MoveChild, 11,
/*26521*/         OPC_RecordNode, // #10 = $lwe
/*26522*/         OPC_MoveParent,
/*26523*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26525*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26528*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26531*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26534*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26537*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26540*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26543*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26546*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26549*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_CL_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5066:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_CL_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26567*/       0, /*End of Scope*/
/*26568*/     /*Scope*/ 95|128,2/*351*/, /*->26921*/
/*26570*/       OPC_CheckChild0Integer, 77|128,39/*5069*/, 
/*26573*/       OPC_RecordChild1, // #0 = $addr
/*26574*/       OPC_Scope, 68, /*->26644*/ // 5 children in Scope
/*26576*/         OPC_CheckChild1Type, MVT::i32,
/*26578*/         OPC_RecordChild2, // #1 = $rsrc
/*26579*/         OPC_RecordChild3, // #2 = $sampler
/*26580*/         OPC_RecordChild4, // #3 = $dmask
/*26581*/         OPC_RecordChild5, // #4 = $unorm
/*26582*/         OPC_RecordChild6, // #5 = $r128
/*26583*/         OPC_RecordChild7, // #6 = $da
/*26584*/         OPC_MoveChild, 8,
/*26586*/         OPC_RecordNode, // #7 = $glc
/*26587*/         OPC_MoveParent,
/*26588*/         OPC_MoveChild, 9,
/*26590*/         OPC_RecordNode, // #8 = $slc
/*26591*/         OPC_MoveParent,
/*26592*/         OPC_MoveChild, 10,
/*26594*/         OPC_RecordNode, // #9 = $tfe
/*26595*/         OPC_MoveParent,
/*26596*/         OPC_MoveChild, 11,
/*26598*/         OPC_RecordNode, // #10 = $lwe
/*26599*/         OPC_MoveParent,
/*26600*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26602*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26605*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26608*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26611*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26614*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26617*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26620*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26623*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26626*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_L_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5069:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_L_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26644*/       /*Scope*/ 68, /*->26713*/
/*26645*/         OPC_CheckChild1Type, MVT::v2i32,
/*26647*/         OPC_RecordChild2, // #1 = $rsrc
/*26648*/         OPC_RecordChild3, // #2 = $sampler
/*26649*/         OPC_RecordChild4, // #3 = $dmask
/*26650*/         OPC_RecordChild5, // #4 = $unorm
/*26651*/         OPC_RecordChild6, // #5 = $r128
/*26652*/         OPC_RecordChild7, // #6 = $da
/*26653*/         OPC_MoveChild, 8,
/*26655*/         OPC_RecordNode, // #7 = $glc
/*26656*/         OPC_MoveParent,
/*26657*/         OPC_MoveChild, 9,
/*26659*/         OPC_RecordNode, // #8 = $slc
/*26660*/         OPC_MoveParent,
/*26661*/         OPC_MoveChild, 10,
/*26663*/         OPC_RecordNode, // #9 = $tfe
/*26664*/         OPC_MoveParent,
/*26665*/         OPC_MoveChild, 11,
/*26667*/         OPC_RecordNode, // #10 = $lwe
/*26668*/         OPC_MoveParent,
/*26669*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26671*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26674*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26677*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26680*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26683*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26686*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26689*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26692*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26695*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_L_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5069:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_L_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26713*/       /*Scope*/ 68, /*->26782*/
/*26714*/         OPC_CheckChild1Type, MVT::v4i32,
/*26716*/         OPC_RecordChild2, // #1 = $rsrc
/*26717*/         OPC_RecordChild3, // #2 = $sampler
/*26718*/         OPC_RecordChild4, // #3 = $dmask
/*26719*/         OPC_RecordChild5, // #4 = $unorm
/*26720*/         OPC_RecordChild6, // #5 = $r128
/*26721*/         OPC_RecordChild7, // #6 = $da
/*26722*/         OPC_MoveChild, 8,
/*26724*/         OPC_RecordNode, // #7 = $glc
/*26725*/         OPC_MoveParent,
/*26726*/         OPC_MoveChild, 9,
/*26728*/         OPC_RecordNode, // #8 = $slc
/*26729*/         OPC_MoveParent,
/*26730*/         OPC_MoveChild, 10,
/*26732*/         OPC_RecordNode, // #9 = $tfe
/*26733*/         OPC_MoveParent,
/*26734*/         OPC_MoveChild, 11,
/*26736*/         OPC_RecordNode, // #10 = $lwe
/*26737*/         OPC_MoveParent,
/*26738*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26740*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26743*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26746*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26749*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26752*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26755*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26758*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26761*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26764*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_L_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5069:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_L_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26782*/       /*Scope*/ 68, /*->26851*/
/*26783*/         OPC_CheckChild1Type, MVT::v8i32,
/*26785*/         OPC_RecordChild2, // #1 = $rsrc
/*26786*/         OPC_RecordChild3, // #2 = $sampler
/*26787*/         OPC_RecordChild4, // #3 = $dmask
/*26788*/         OPC_RecordChild5, // #4 = $unorm
/*26789*/         OPC_RecordChild6, // #5 = $r128
/*26790*/         OPC_RecordChild7, // #6 = $da
/*26791*/         OPC_MoveChild, 8,
/*26793*/         OPC_RecordNode, // #7 = $glc
/*26794*/         OPC_MoveParent,
/*26795*/         OPC_MoveChild, 9,
/*26797*/         OPC_RecordNode, // #8 = $slc
/*26798*/         OPC_MoveParent,
/*26799*/         OPC_MoveChild, 10,
/*26801*/         OPC_RecordNode, // #9 = $tfe
/*26802*/         OPC_MoveParent,
/*26803*/         OPC_MoveChild, 11,
/*26805*/         OPC_RecordNode, // #10 = $lwe
/*26806*/         OPC_MoveParent,
/*26807*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26809*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26812*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26815*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26818*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26821*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26824*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26827*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26830*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26833*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_L_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5069:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_L_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26851*/       /*Scope*/ 68, /*->26920*/
/*26852*/         OPC_CheckChild1Type, MVT::v16i32,
/*26854*/         OPC_RecordChild2, // #1 = $rsrc
/*26855*/         OPC_RecordChild3, // #2 = $sampler
/*26856*/         OPC_RecordChild4, // #3 = $dmask
/*26857*/         OPC_RecordChild5, // #4 = $unorm
/*26858*/         OPC_RecordChild6, // #5 = $r128
/*26859*/         OPC_RecordChild7, // #6 = $da
/*26860*/         OPC_MoveChild, 8,
/*26862*/         OPC_RecordNode, // #7 = $glc
/*26863*/         OPC_MoveParent,
/*26864*/         OPC_MoveChild, 9,
/*26866*/         OPC_RecordNode, // #8 = $slc
/*26867*/         OPC_MoveParent,
/*26868*/         OPC_MoveChild, 10,
/*26870*/         OPC_RecordNode, // #9 = $tfe
/*26871*/         OPC_MoveParent,
/*26872*/         OPC_MoveChild, 11,
/*26874*/         OPC_RecordNode, // #10 = $lwe
/*26875*/         OPC_MoveParent,
/*26876*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26878*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26881*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26884*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26887*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26890*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26893*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26896*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26899*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26902*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_L_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5069:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_L_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26920*/       0, /*End of Scope*/
/*26921*/     /*Scope*/ 95|128,2/*351*/, /*->27274*/
/*26923*/       OPC_CheckChild0Integer, 43|128,39/*5035*/, 
/*26926*/       OPC_RecordChild1, // #0 = $addr
/*26927*/       OPC_Scope, 68, /*->26997*/ // 5 children in Scope
/*26929*/         OPC_CheckChild1Type, MVT::i32,
/*26931*/         OPC_RecordChild2, // #1 = $rsrc
/*26932*/         OPC_RecordChild3, // #2 = $sampler
/*26933*/         OPC_RecordChild4, // #3 = $dmask
/*26934*/         OPC_RecordChild5, // #4 = $unorm
/*26935*/         OPC_RecordChild6, // #5 = $r128
/*26936*/         OPC_RecordChild7, // #6 = $da
/*26937*/         OPC_MoveChild, 8,
/*26939*/         OPC_RecordNode, // #7 = $glc
/*26940*/         OPC_MoveParent,
/*26941*/         OPC_MoveChild, 9,
/*26943*/         OPC_RecordNode, // #8 = $slc
/*26944*/         OPC_MoveParent,
/*26945*/         OPC_MoveChild, 10,
/*26947*/         OPC_RecordNode, // #9 = $tfe
/*26948*/         OPC_MoveParent,
/*26949*/         OPC_MoveChild, 11,
/*26951*/         OPC_RecordNode, // #10 = $lwe
/*26952*/         OPC_MoveParent,
/*26953*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*26955*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*26958*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*26961*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*26964*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*26967*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*26970*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*26973*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*26976*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*26979*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5035:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*26997*/       /*Scope*/ 68, /*->27066*/
/*26998*/         OPC_CheckChild1Type, MVT::v2i32,
/*27000*/         OPC_RecordChild2, // #1 = $rsrc
/*27001*/         OPC_RecordChild3, // #2 = $sampler
/*27002*/         OPC_RecordChild4, // #3 = $dmask
/*27003*/         OPC_RecordChild5, // #4 = $unorm
/*27004*/         OPC_RecordChild6, // #5 = $r128
/*27005*/         OPC_RecordChild7, // #6 = $da
/*27006*/         OPC_MoveChild, 8,
/*27008*/         OPC_RecordNode, // #7 = $glc
/*27009*/         OPC_MoveParent,
/*27010*/         OPC_MoveChild, 9,
/*27012*/         OPC_RecordNode, // #8 = $slc
/*27013*/         OPC_MoveParent,
/*27014*/         OPC_MoveChild, 10,
/*27016*/         OPC_RecordNode, // #9 = $tfe
/*27017*/         OPC_MoveParent,
/*27018*/         OPC_MoveChild, 11,
/*27020*/         OPC_RecordNode, // #10 = $lwe
/*27021*/         OPC_MoveParent,
/*27022*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27024*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27027*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27030*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27033*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27036*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27039*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27042*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27045*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27048*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5035:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27066*/       /*Scope*/ 68, /*->27135*/
/*27067*/         OPC_CheckChild1Type, MVT::v4i32,
/*27069*/         OPC_RecordChild2, // #1 = $rsrc
/*27070*/         OPC_RecordChild3, // #2 = $sampler
/*27071*/         OPC_RecordChild4, // #3 = $dmask
/*27072*/         OPC_RecordChild5, // #4 = $unorm
/*27073*/         OPC_RecordChild6, // #5 = $r128
/*27074*/         OPC_RecordChild7, // #6 = $da
/*27075*/         OPC_MoveChild, 8,
/*27077*/         OPC_RecordNode, // #7 = $glc
/*27078*/         OPC_MoveParent,
/*27079*/         OPC_MoveChild, 9,
/*27081*/         OPC_RecordNode, // #8 = $slc
/*27082*/         OPC_MoveParent,
/*27083*/         OPC_MoveChild, 10,
/*27085*/         OPC_RecordNode, // #9 = $tfe
/*27086*/         OPC_MoveParent,
/*27087*/         OPC_MoveChild, 11,
/*27089*/         OPC_RecordNode, // #10 = $lwe
/*27090*/         OPC_MoveParent,
/*27091*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27093*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27096*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27099*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27102*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27105*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27108*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27111*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27114*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27117*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5035:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27135*/       /*Scope*/ 68, /*->27204*/
/*27136*/         OPC_CheckChild1Type, MVT::v8i32,
/*27138*/         OPC_RecordChild2, // #1 = $rsrc
/*27139*/         OPC_RecordChild3, // #2 = $sampler
/*27140*/         OPC_RecordChild4, // #3 = $dmask
/*27141*/         OPC_RecordChild5, // #4 = $unorm
/*27142*/         OPC_RecordChild6, // #5 = $r128
/*27143*/         OPC_RecordChild7, // #6 = $da
/*27144*/         OPC_MoveChild, 8,
/*27146*/         OPC_RecordNode, // #7 = $glc
/*27147*/         OPC_MoveParent,
/*27148*/         OPC_MoveChild, 9,
/*27150*/         OPC_RecordNode, // #8 = $slc
/*27151*/         OPC_MoveParent,
/*27152*/         OPC_MoveChild, 10,
/*27154*/         OPC_RecordNode, // #9 = $tfe
/*27155*/         OPC_MoveParent,
/*27156*/         OPC_MoveChild, 11,
/*27158*/         OPC_RecordNode, // #10 = $lwe
/*27159*/         OPC_MoveParent,
/*27160*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27162*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27165*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27168*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27171*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27174*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27177*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27180*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27183*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27186*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5035:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27204*/       /*Scope*/ 68, /*->27273*/
/*27205*/         OPC_CheckChild1Type, MVT::v16i32,
/*27207*/         OPC_RecordChild2, // #1 = $rsrc
/*27208*/         OPC_RecordChild3, // #2 = $sampler
/*27209*/         OPC_RecordChild4, // #3 = $dmask
/*27210*/         OPC_RecordChild5, // #4 = $unorm
/*27211*/         OPC_RecordChild6, // #5 = $r128
/*27212*/         OPC_RecordChild7, // #6 = $da
/*27213*/         OPC_MoveChild, 8,
/*27215*/         OPC_RecordNode, // #7 = $glc
/*27216*/         OPC_MoveParent,
/*27217*/         OPC_MoveChild, 9,
/*27219*/         OPC_RecordNode, // #8 = $slc
/*27220*/         OPC_MoveParent,
/*27221*/         OPC_MoveChild, 10,
/*27223*/         OPC_RecordNode, // #9 = $tfe
/*27224*/         OPC_MoveParent,
/*27225*/         OPC_MoveChild, 11,
/*27227*/         OPC_RecordNode, // #10 = $lwe
/*27228*/         OPC_MoveParent,
/*27229*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27231*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27234*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27237*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27240*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27243*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27246*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27249*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27252*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27255*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5035:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27273*/       0, /*End of Scope*/
/*27274*/     /*Scope*/ 95|128,2/*351*/, /*->27627*/
/*27276*/       OPC_CheckChild0Integer, 44|128,39/*5036*/, 
/*27279*/       OPC_RecordChild1, // #0 = $addr
/*27280*/       OPC_Scope, 68, /*->27350*/ // 5 children in Scope
/*27282*/         OPC_CheckChild1Type, MVT::i32,
/*27284*/         OPC_RecordChild2, // #1 = $rsrc
/*27285*/         OPC_RecordChild3, // #2 = $sampler
/*27286*/         OPC_RecordChild4, // #3 = $dmask
/*27287*/         OPC_RecordChild5, // #4 = $unorm
/*27288*/         OPC_RecordChild6, // #5 = $r128
/*27289*/         OPC_RecordChild7, // #6 = $da
/*27290*/         OPC_MoveChild, 8,
/*27292*/         OPC_RecordNode, // #7 = $glc
/*27293*/         OPC_MoveParent,
/*27294*/         OPC_MoveChild, 9,
/*27296*/         OPC_RecordNode, // #8 = $slc
/*27297*/         OPC_MoveParent,
/*27298*/         OPC_MoveChild, 10,
/*27300*/         OPC_RecordNode, // #9 = $tfe
/*27301*/         OPC_MoveParent,
/*27302*/         OPC_MoveChild, 11,
/*27304*/         OPC_RecordNode, // #10 = $lwe
/*27305*/         OPC_MoveParent,
/*27306*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27308*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27311*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27314*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27317*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27320*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27323*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27326*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27329*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27332*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_CL_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5036:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_CL_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27350*/       /*Scope*/ 68, /*->27419*/
/*27351*/         OPC_CheckChild1Type, MVT::v2i32,
/*27353*/         OPC_RecordChild2, // #1 = $rsrc
/*27354*/         OPC_RecordChild3, // #2 = $sampler
/*27355*/         OPC_RecordChild4, // #3 = $dmask
/*27356*/         OPC_RecordChild5, // #4 = $unorm
/*27357*/         OPC_RecordChild6, // #5 = $r128
/*27358*/         OPC_RecordChild7, // #6 = $da
/*27359*/         OPC_MoveChild, 8,
/*27361*/         OPC_RecordNode, // #7 = $glc
/*27362*/         OPC_MoveParent,
/*27363*/         OPC_MoveChild, 9,
/*27365*/         OPC_RecordNode, // #8 = $slc
/*27366*/         OPC_MoveParent,
/*27367*/         OPC_MoveChild, 10,
/*27369*/         OPC_RecordNode, // #9 = $tfe
/*27370*/         OPC_MoveParent,
/*27371*/         OPC_MoveChild, 11,
/*27373*/         OPC_RecordNode, // #10 = $lwe
/*27374*/         OPC_MoveParent,
/*27375*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27377*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27380*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27383*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27386*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27389*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27392*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27395*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27398*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27401*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_CL_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5036:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_CL_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27419*/       /*Scope*/ 68, /*->27488*/
/*27420*/         OPC_CheckChild1Type, MVT::v4i32,
/*27422*/         OPC_RecordChild2, // #1 = $rsrc
/*27423*/         OPC_RecordChild3, // #2 = $sampler
/*27424*/         OPC_RecordChild4, // #3 = $dmask
/*27425*/         OPC_RecordChild5, // #4 = $unorm
/*27426*/         OPC_RecordChild6, // #5 = $r128
/*27427*/         OPC_RecordChild7, // #6 = $da
/*27428*/         OPC_MoveChild, 8,
/*27430*/         OPC_RecordNode, // #7 = $glc
/*27431*/         OPC_MoveParent,
/*27432*/         OPC_MoveChild, 9,
/*27434*/         OPC_RecordNode, // #8 = $slc
/*27435*/         OPC_MoveParent,
/*27436*/         OPC_MoveChild, 10,
/*27438*/         OPC_RecordNode, // #9 = $tfe
/*27439*/         OPC_MoveParent,
/*27440*/         OPC_MoveChild, 11,
/*27442*/         OPC_RecordNode, // #10 = $lwe
/*27443*/         OPC_MoveParent,
/*27444*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27446*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27449*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27452*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27455*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27458*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27461*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27464*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27467*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27470*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_CL_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5036:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_CL_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27488*/       /*Scope*/ 68, /*->27557*/
/*27489*/         OPC_CheckChild1Type, MVT::v8i32,
/*27491*/         OPC_RecordChild2, // #1 = $rsrc
/*27492*/         OPC_RecordChild3, // #2 = $sampler
/*27493*/         OPC_RecordChild4, // #3 = $dmask
/*27494*/         OPC_RecordChild5, // #4 = $unorm
/*27495*/         OPC_RecordChild6, // #5 = $r128
/*27496*/         OPC_RecordChild7, // #6 = $da
/*27497*/         OPC_MoveChild, 8,
/*27499*/         OPC_RecordNode, // #7 = $glc
/*27500*/         OPC_MoveParent,
/*27501*/         OPC_MoveChild, 9,
/*27503*/         OPC_RecordNode, // #8 = $slc
/*27504*/         OPC_MoveParent,
/*27505*/         OPC_MoveChild, 10,
/*27507*/         OPC_RecordNode, // #9 = $tfe
/*27508*/         OPC_MoveParent,
/*27509*/         OPC_MoveChild, 11,
/*27511*/         OPC_RecordNode, // #10 = $lwe
/*27512*/         OPC_MoveParent,
/*27513*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27515*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27518*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27521*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27524*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27527*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27530*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27533*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27536*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27539*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_CL_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5036:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_CL_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27557*/       /*Scope*/ 68, /*->27626*/
/*27558*/         OPC_CheckChild1Type, MVT::v16i32,
/*27560*/         OPC_RecordChild2, // #1 = $rsrc
/*27561*/         OPC_RecordChild3, // #2 = $sampler
/*27562*/         OPC_RecordChild4, // #3 = $dmask
/*27563*/         OPC_RecordChild5, // #4 = $unorm
/*27564*/         OPC_RecordChild6, // #5 = $r128
/*27565*/         OPC_RecordChild7, // #6 = $da
/*27566*/         OPC_MoveChild, 8,
/*27568*/         OPC_RecordNode, // #7 = $glc
/*27569*/         OPC_MoveParent,
/*27570*/         OPC_MoveChild, 9,
/*27572*/         OPC_RecordNode, // #8 = $slc
/*27573*/         OPC_MoveParent,
/*27574*/         OPC_MoveChild, 10,
/*27576*/         OPC_RecordNode, // #9 = $tfe
/*27577*/         OPC_MoveParent,
/*27578*/         OPC_MoveChild, 11,
/*27580*/         OPC_RecordNode, // #10 = $lwe
/*27581*/         OPC_MoveParent,
/*27582*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27584*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27587*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27590*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27593*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27596*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27599*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27602*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27605*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27608*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_CL_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5036:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_CL_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27626*/       0, /*End of Scope*/
/*27627*/     /*Scope*/ 95|128,2/*351*/, /*->27980*/
/*27629*/       OPC_CheckChild0Integer, 79|128,39/*5071*/, 
/*27632*/       OPC_RecordChild1, // #0 = $addr
/*27633*/       OPC_Scope, 68, /*->27703*/ // 5 children in Scope
/*27635*/         OPC_CheckChild1Type, MVT::i32,
/*27637*/         OPC_RecordChild2, // #1 = $rsrc
/*27638*/         OPC_RecordChild3, // #2 = $sampler
/*27639*/         OPC_RecordChild4, // #3 = $dmask
/*27640*/         OPC_RecordChild5, // #4 = $unorm
/*27641*/         OPC_RecordChild6, // #5 = $r128
/*27642*/         OPC_RecordChild7, // #6 = $da
/*27643*/         OPC_MoveChild, 8,
/*27645*/         OPC_RecordNode, // #7 = $glc
/*27646*/         OPC_MoveParent,
/*27647*/         OPC_MoveChild, 9,
/*27649*/         OPC_RecordNode, // #8 = $slc
/*27650*/         OPC_MoveParent,
/*27651*/         OPC_MoveChild, 10,
/*27653*/         OPC_RecordNode, // #9 = $tfe
/*27654*/         OPC_MoveParent,
/*27655*/         OPC_MoveChild, 11,
/*27657*/         OPC_RecordNode, // #10 = $lwe
/*27658*/         OPC_MoveParent,
/*27659*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27661*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27664*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27667*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27670*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27673*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27676*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27679*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27682*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27685*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_LZ_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5071:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_LZ_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27703*/       /*Scope*/ 68, /*->27772*/
/*27704*/         OPC_CheckChild1Type, MVT::v2i32,
/*27706*/         OPC_RecordChild2, // #1 = $rsrc
/*27707*/         OPC_RecordChild3, // #2 = $sampler
/*27708*/         OPC_RecordChild4, // #3 = $dmask
/*27709*/         OPC_RecordChild5, // #4 = $unorm
/*27710*/         OPC_RecordChild6, // #5 = $r128
/*27711*/         OPC_RecordChild7, // #6 = $da
/*27712*/         OPC_MoveChild, 8,
/*27714*/         OPC_RecordNode, // #7 = $glc
/*27715*/         OPC_MoveParent,
/*27716*/         OPC_MoveChild, 9,
/*27718*/         OPC_RecordNode, // #8 = $slc
/*27719*/         OPC_MoveParent,
/*27720*/         OPC_MoveChild, 10,
/*27722*/         OPC_RecordNode, // #9 = $tfe
/*27723*/         OPC_MoveParent,
/*27724*/         OPC_MoveChild, 11,
/*27726*/         OPC_RecordNode, // #10 = $lwe
/*27727*/         OPC_MoveParent,
/*27728*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27730*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27733*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27736*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27739*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27742*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27745*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27748*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27751*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27754*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_LZ_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5071:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_LZ_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27772*/       /*Scope*/ 68, /*->27841*/
/*27773*/         OPC_CheckChild1Type, MVT::v4i32,
/*27775*/         OPC_RecordChild2, // #1 = $rsrc
/*27776*/         OPC_RecordChild3, // #2 = $sampler
/*27777*/         OPC_RecordChild4, // #3 = $dmask
/*27778*/         OPC_RecordChild5, // #4 = $unorm
/*27779*/         OPC_RecordChild6, // #5 = $r128
/*27780*/         OPC_RecordChild7, // #6 = $da
/*27781*/         OPC_MoveChild, 8,
/*27783*/         OPC_RecordNode, // #7 = $glc
/*27784*/         OPC_MoveParent,
/*27785*/         OPC_MoveChild, 9,
/*27787*/         OPC_RecordNode, // #8 = $slc
/*27788*/         OPC_MoveParent,
/*27789*/         OPC_MoveChild, 10,
/*27791*/         OPC_RecordNode, // #9 = $tfe
/*27792*/         OPC_MoveParent,
/*27793*/         OPC_MoveChild, 11,
/*27795*/         OPC_RecordNode, // #10 = $lwe
/*27796*/         OPC_MoveParent,
/*27797*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27799*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27802*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27805*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27808*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27811*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27814*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27817*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27820*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27823*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_LZ_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5071:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_LZ_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27841*/       /*Scope*/ 68, /*->27910*/
/*27842*/         OPC_CheckChild1Type, MVT::v8i32,
/*27844*/         OPC_RecordChild2, // #1 = $rsrc
/*27845*/         OPC_RecordChild3, // #2 = $sampler
/*27846*/         OPC_RecordChild4, // #3 = $dmask
/*27847*/         OPC_RecordChild5, // #4 = $unorm
/*27848*/         OPC_RecordChild6, // #5 = $r128
/*27849*/         OPC_RecordChild7, // #6 = $da
/*27850*/         OPC_MoveChild, 8,
/*27852*/         OPC_RecordNode, // #7 = $glc
/*27853*/         OPC_MoveParent,
/*27854*/         OPC_MoveChild, 9,
/*27856*/         OPC_RecordNode, // #8 = $slc
/*27857*/         OPC_MoveParent,
/*27858*/         OPC_MoveChild, 10,
/*27860*/         OPC_RecordNode, // #9 = $tfe
/*27861*/         OPC_MoveParent,
/*27862*/         OPC_MoveChild, 11,
/*27864*/         OPC_RecordNode, // #10 = $lwe
/*27865*/         OPC_MoveParent,
/*27866*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27868*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27871*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27874*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27877*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27880*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27883*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27886*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27889*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27892*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_LZ_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5071:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_LZ_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27910*/       /*Scope*/ 68, /*->27979*/
/*27911*/         OPC_CheckChild1Type, MVT::v16i32,
/*27913*/         OPC_RecordChild2, // #1 = $rsrc
/*27914*/         OPC_RecordChild3, // #2 = $sampler
/*27915*/         OPC_RecordChild4, // #3 = $dmask
/*27916*/         OPC_RecordChild5, // #4 = $unorm
/*27917*/         OPC_RecordChild6, // #5 = $r128
/*27918*/         OPC_RecordChild7, // #6 = $da
/*27919*/         OPC_MoveChild, 8,
/*27921*/         OPC_RecordNode, // #7 = $glc
/*27922*/         OPC_MoveParent,
/*27923*/         OPC_MoveChild, 9,
/*27925*/         OPC_RecordNode, // #8 = $slc
/*27926*/         OPC_MoveParent,
/*27927*/         OPC_MoveChild, 10,
/*27929*/         OPC_RecordNode, // #9 = $tfe
/*27930*/         OPC_MoveParent,
/*27931*/         OPC_MoveChild, 11,
/*27933*/         OPC_RecordNode, // #10 = $lwe
/*27934*/         OPC_MoveParent,
/*27935*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*27937*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*27940*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*27943*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*27946*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*27949*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*27952*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*27955*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*27958*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*27961*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_LZ_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5071:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_LZ_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*27979*/       0, /*End of Scope*/
/*27980*/     /*Scope*/ 95|128,2/*351*/, /*->28333*/
/*27982*/       OPC_CheckChild0Integer, 67|128,39/*5059*/, 
/*27985*/       OPC_RecordChild1, // #0 = $addr
/*27986*/       OPC_Scope, 68, /*->28056*/ // 5 children in Scope
/*27988*/         OPC_CheckChild1Type, MVT::i32,
/*27990*/         OPC_RecordChild2, // #1 = $rsrc
/*27991*/         OPC_RecordChild3, // #2 = $sampler
/*27992*/         OPC_RecordChild4, // #3 = $dmask
/*27993*/         OPC_RecordChild5, // #4 = $unorm
/*27994*/         OPC_RecordChild6, // #5 = $r128
/*27995*/         OPC_RecordChild7, // #6 = $da
/*27996*/         OPC_MoveChild, 8,
/*27998*/         OPC_RecordNode, // #7 = $glc
/*27999*/         OPC_MoveParent,
/*28000*/         OPC_MoveChild, 9,
/*28002*/         OPC_RecordNode, // #8 = $slc
/*28003*/         OPC_MoveParent,
/*28004*/         OPC_MoveChild, 10,
/*28006*/         OPC_RecordNode, // #9 = $tfe
/*28007*/         OPC_MoveParent,
/*28008*/         OPC_MoveChild, 11,
/*28010*/         OPC_RecordNode, // #10 = $lwe
/*28011*/         OPC_MoveParent,
/*28012*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28014*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28017*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28020*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28023*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28026*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28029*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28032*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28035*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28038*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5059:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28056*/       /*Scope*/ 68, /*->28125*/
/*28057*/         OPC_CheckChild1Type, MVT::v2i32,
/*28059*/         OPC_RecordChild2, // #1 = $rsrc
/*28060*/         OPC_RecordChild3, // #2 = $sampler
/*28061*/         OPC_RecordChild4, // #3 = $dmask
/*28062*/         OPC_RecordChild5, // #4 = $unorm
/*28063*/         OPC_RecordChild6, // #5 = $r128
/*28064*/         OPC_RecordChild7, // #6 = $da
/*28065*/         OPC_MoveChild, 8,
/*28067*/         OPC_RecordNode, // #7 = $glc
/*28068*/         OPC_MoveParent,
/*28069*/         OPC_MoveChild, 9,
/*28071*/         OPC_RecordNode, // #8 = $slc
/*28072*/         OPC_MoveParent,
/*28073*/         OPC_MoveChild, 10,
/*28075*/         OPC_RecordNode, // #9 = $tfe
/*28076*/         OPC_MoveParent,
/*28077*/         OPC_MoveChild, 11,
/*28079*/         OPC_RecordNode, // #10 = $lwe
/*28080*/         OPC_MoveParent,
/*28081*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28083*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28086*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28089*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28092*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28095*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28098*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28101*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28104*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28107*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5059:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28125*/       /*Scope*/ 68, /*->28194*/
/*28126*/         OPC_CheckChild1Type, MVT::v4i32,
/*28128*/         OPC_RecordChild2, // #1 = $rsrc
/*28129*/         OPC_RecordChild3, // #2 = $sampler
/*28130*/         OPC_RecordChild4, // #3 = $dmask
/*28131*/         OPC_RecordChild5, // #4 = $unorm
/*28132*/         OPC_RecordChild6, // #5 = $r128
/*28133*/         OPC_RecordChild7, // #6 = $da
/*28134*/         OPC_MoveChild, 8,
/*28136*/         OPC_RecordNode, // #7 = $glc
/*28137*/         OPC_MoveParent,
/*28138*/         OPC_MoveChild, 9,
/*28140*/         OPC_RecordNode, // #8 = $slc
/*28141*/         OPC_MoveParent,
/*28142*/         OPC_MoveChild, 10,
/*28144*/         OPC_RecordNode, // #9 = $tfe
/*28145*/         OPC_MoveParent,
/*28146*/         OPC_MoveChild, 11,
/*28148*/         OPC_RecordNode, // #10 = $lwe
/*28149*/         OPC_MoveParent,
/*28150*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28152*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28155*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28158*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28161*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28164*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28167*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28170*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28173*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28176*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5059:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28194*/       /*Scope*/ 68, /*->28263*/
/*28195*/         OPC_CheckChild1Type, MVT::v8i32,
/*28197*/         OPC_RecordChild2, // #1 = $rsrc
/*28198*/         OPC_RecordChild3, // #2 = $sampler
/*28199*/         OPC_RecordChild4, // #3 = $dmask
/*28200*/         OPC_RecordChild5, // #4 = $unorm
/*28201*/         OPC_RecordChild6, // #5 = $r128
/*28202*/         OPC_RecordChild7, // #6 = $da
/*28203*/         OPC_MoveChild, 8,
/*28205*/         OPC_RecordNode, // #7 = $glc
/*28206*/         OPC_MoveParent,
/*28207*/         OPC_MoveChild, 9,
/*28209*/         OPC_RecordNode, // #8 = $slc
/*28210*/         OPC_MoveParent,
/*28211*/         OPC_MoveChild, 10,
/*28213*/         OPC_RecordNode, // #9 = $tfe
/*28214*/         OPC_MoveParent,
/*28215*/         OPC_MoveChild, 11,
/*28217*/         OPC_RecordNode, // #10 = $lwe
/*28218*/         OPC_MoveParent,
/*28219*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28221*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28224*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28227*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28230*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28233*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28236*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28239*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28242*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28245*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5059:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28263*/       /*Scope*/ 68, /*->28332*/
/*28264*/         OPC_CheckChild1Type, MVT::v16i32,
/*28266*/         OPC_RecordChild2, // #1 = $rsrc
/*28267*/         OPC_RecordChild3, // #2 = $sampler
/*28268*/         OPC_RecordChild4, // #3 = $dmask
/*28269*/         OPC_RecordChild5, // #4 = $unorm
/*28270*/         OPC_RecordChild6, // #5 = $r128
/*28271*/         OPC_RecordChild7, // #6 = $da
/*28272*/         OPC_MoveChild, 8,
/*28274*/         OPC_RecordNode, // #7 = $glc
/*28275*/         OPC_MoveParent,
/*28276*/         OPC_MoveChild, 9,
/*28278*/         OPC_RecordNode, // #8 = $slc
/*28279*/         OPC_MoveParent,
/*28280*/         OPC_MoveChild, 10,
/*28282*/         OPC_RecordNode, // #9 = $tfe
/*28283*/         OPC_MoveParent,
/*28284*/         OPC_MoveChild, 11,
/*28286*/         OPC_RecordNode, // #10 = $lwe
/*28287*/         OPC_MoveParent,
/*28288*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28290*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28293*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28296*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28299*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28302*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28305*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28308*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28311*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28314*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5059:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28332*/       0, /*End of Scope*/
/*28333*/     /*Scope*/ 95|128,2/*351*/, /*->28686*/
/*28335*/       OPC_CheckChild0Integer, 68|128,39/*5060*/, 
/*28338*/       OPC_RecordChild1, // #0 = $addr
/*28339*/       OPC_Scope, 68, /*->28409*/ // 5 children in Scope
/*28341*/         OPC_CheckChild1Type, MVT::i32,
/*28343*/         OPC_RecordChild2, // #1 = $rsrc
/*28344*/         OPC_RecordChild3, // #2 = $sampler
/*28345*/         OPC_RecordChild4, // #3 = $dmask
/*28346*/         OPC_RecordChild5, // #4 = $unorm
/*28347*/         OPC_RecordChild6, // #5 = $r128
/*28348*/         OPC_RecordChild7, // #6 = $da
/*28349*/         OPC_MoveChild, 8,
/*28351*/         OPC_RecordNode, // #7 = $glc
/*28352*/         OPC_MoveParent,
/*28353*/         OPC_MoveChild, 9,
/*28355*/         OPC_RecordNode, // #8 = $slc
/*28356*/         OPC_MoveParent,
/*28357*/         OPC_MoveChild, 10,
/*28359*/         OPC_RecordNode, // #9 = $tfe
/*28360*/         OPC_MoveParent,
/*28361*/         OPC_MoveChild, 11,
/*28363*/         OPC_RecordNode, // #10 = $lwe
/*28364*/         OPC_MoveParent,
/*28365*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28367*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28370*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28373*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28376*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28379*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28382*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28385*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28388*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28391*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_CL_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5060:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_CL_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28409*/       /*Scope*/ 68, /*->28478*/
/*28410*/         OPC_CheckChild1Type, MVT::v2i32,
/*28412*/         OPC_RecordChild2, // #1 = $rsrc
/*28413*/         OPC_RecordChild3, // #2 = $sampler
/*28414*/         OPC_RecordChild4, // #3 = $dmask
/*28415*/         OPC_RecordChild5, // #4 = $unorm
/*28416*/         OPC_RecordChild6, // #5 = $r128
/*28417*/         OPC_RecordChild7, // #6 = $da
/*28418*/         OPC_MoveChild, 8,
/*28420*/         OPC_RecordNode, // #7 = $glc
/*28421*/         OPC_MoveParent,
/*28422*/         OPC_MoveChild, 9,
/*28424*/         OPC_RecordNode, // #8 = $slc
/*28425*/         OPC_MoveParent,
/*28426*/         OPC_MoveChild, 10,
/*28428*/         OPC_RecordNode, // #9 = $tfe
/*28429*/         OPC_MoveParent,
/*28430*/         OPC_MoveChild, 11,
/*28432*/         OPC_RecordNode, // #10 = $lwe
/*28433*/         OPC_MoveParent,
/*28434*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28436*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28439*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28442*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28445*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28448*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28451*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28454*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28457*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28460*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_CL_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5060:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_CL_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28478*/       /*Scope*/ 68, /*->28547*/
/*28479*/         OPC_CheckChild1Type, MVT::v4i32,
/*28481*/         OPC_RecordChild2, // #1 = $rsrc
/*28482*/         OPC_RecordChild3, // #2 = $sampler
/*28483*/         OPC_RecordChild4, // #3 = $dmask
/*28484*/         OPC_RecordChild5, // #4 = $unorm
/*28485*/         OPC_RecordChild6, // #5 = $r128
/*28486*/         OPC_RecordChild7, // #6 = $da
/*28487*/         OPC_MoveChild, 8,
/*28489*/         OPC_RecordNode, // #7 = $glc
/*28490*/         OPC_MoveParent,
/*28491*/         OPC_MoveChild, 9,
/*28493*/         OPC_RecordNode, // #8 = $slc
/*28494*/         OPC_MoveParent,
/*28495*/         OPC_MoveChild, 10,
/*28497*/         OPC_RecordNode, // #9 = $tfe
/*28498*/         OPC_MoveParent,
/*28499*/         OPC_MoveChild, 11,
/*28501*/         OPC_RecordNode, // #10 = $lwe
/*28502*/         OPC_MoveParent,
/*28503*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28505*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28508*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28511*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28514*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28517*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28520*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28523*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28526*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28529*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_CL_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5060:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_CL_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28547*/       /*Scope*/ 68, /*->28616*/
/*28548*/         OPC_CheckChild1Type, MVT::v8i32,
/*28550*/         OPC_RecordChild2, // #1 = $rsrc
/*28551*/         OPC_RecordChild3, // #2 = $sampler
/*28552*/         OPC_RecordChild4, // #3 = $dmask
/*28553*/         OPC_RecordChild5, // #4 = $unorm
/*28554*/         OPC_RecordChild6, // #5 = $r128
/*28555*/         OPC_RecordChild7, // #6 = $da
/*28556*/         OPC_MoveChild, 8,
/*28558*/         OPC_RecordNode, // #7 = $glc
/*28559*/         OPC_MoveParent,
/*28560*/         OPC_MoveChild, 9,
/*28562*/         OPC_RecordNode, // #8 = $slc
/*28563*/         OPC_MoveParent,
/*28564*/         OPC_MoveChild, 10,
/*28566*/         OPC_RecordNode, // #9 = $tfe
/*28567*/         OPC_MoveParent,
/*28568*/         OPC_MoveChild, 11,
/*28570*/         OPC_RecordNode, // #10 = $lwe
/*28571*/         OPC_MoveParent,
/*28572*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28574*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28577*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28580*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28583*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28586*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28589*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28592*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28595*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28598*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_CL_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5060:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_CL_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28616*/       /*Scope*/ 68, /*->28685*/
/*28617*/         OPC_CheckChild1Type, MVT::v16i32,
/*28619*/         OPC_RecordChild2, // #1 = $rsrc
/*28620*/         OPC_RecordChild3, // #2 = $sampler
/*28621*/         OPC_RecordChild4, // #3 = $dmask
/*28622*/         OPC_RecordChild5, // #4 = $unorm
/*28623*/         OPC_RecordChild6, // #5 = $r128
/*28624*/         OPC_RecordChild7, // #6 = $da
/*28625*/         OPC_MoveChild, 8,
/*28627*/         OPC_RecordNode, // #7 = $glc
/*28628*/         OPC_MoveParent,
/*28629*/         OPC_MoveChild, 9,
/*28631*/         OPC_RecordNode, // #8 = $slc
/*28632*/         OPC_MoveParent,
/*28633*/         OPC_MoveChild, 10,
/*28635*/         OPC_RecordNode, // #9 = $tfe
/*28636*/         OPC_MoveParent,
/*28637*/         OPC_MoveChild, 11,
/*28639*/         OPC_RecordNode, // #10 = $lwe
/*28640*/         OPC_MoveParent,
/*28641*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28643*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28646*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28649*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28652*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28655*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28658*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28661*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28664*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28667*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_CL_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5060:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_CL_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28685*/       0, /*End of Scope*/
/*28686*/     /*Scope*/ 95|128,2/*351*/, /*->29039*/
/*28688*/       OPC_CheckChild0Integer, 47|128,39/*5039*/, 
/*28691*/       OPC_RecordChild1, // #0 = $addr
/*28692*/       OPC_Scope, 68, /*->28762*/ // 5 children in Scope
/*28694*/         OPC_CheckChild1Type, MVT::i32,
/*28696*/         OPC_RecordChild2, // #1 = $rsrc
/*28697*/         OPC_RecordChild3, // #2 = $sampler
/*28698*/         OPC_RecordChild4, // #3 = $dmask
/*28699*/         OPC_RecordChild5, // #4 = $unorm
/*28700*/         OPC_RecordChild6, // #5 = $r128
/*28701*/         OPC_RecordChild7, // #6 = $da
/*28702*/         OPC_MoveChild, 8,
/*28704*/         OPC_RecordNode, // #7 = $glc
/*28705*/         OPC_MoveParent,
/*28706*/         OPC_MoveChild, 9,
/*28708*/         OPC_RecordNode, // #8 = $slc
/*28709*/         OPC_MoveParent,
/*28710*/         OPC_MoveChild, 10,
/*28712*/         OPC_RecordNode, // #9 = $tfe
/*28713*/         OPC_MoveParent,
/*28714*/         OPC_MoveChild, 11,
/*28716*/         OPC_RecordNode, // #10 = $lwe
/*28717*/         OPC_MoveParent,
/*28718*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28720*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28723*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28726*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28729*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28732*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28735*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28738*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28741*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28744*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5039:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28762*/       /*Scope*/ 68, /*->28831*/
/*28763*/         OPC_CheckChild1Type, MVT::v2i32,
/*28765*/         OPC_RecordChild2, // #1 = $rsrc
/*28766*/         OPC_RecordChild3, // #2 = $sampler
/*28767*/         OPC_RecordChild4, // #3 = $dmask
/*28768*/         OPC_RecordChild5, // #4 = $unorm
/*28769*/         OPC_RecordChild6, // #5 = $r128
/*28770*/         OPC_RecordChild7, // #6 = $da
/*28771*/         OPC_MoveChild, 8,
/*28773*/         OPC_RecordNode, // #7 = $glc
/*28774*/         OPC_MoveParent,
/*28775*/         OPC_MoveChild, 9,
/*28777*/         OPC_RecordNode, // #8 = $slc
/*28778*/         OPC_MoveParent,
/*28779*/         OPC_MoveChild, 10,
/*28781*/         OPC_RecordNode, // #9 = $tfe
/*28782*/         OPC_MoveParent,
/*28783*/         OPC_MoveChild, 11,
/*28785*/         OPC_RecordNode, // #10 = $lwe
/*28786*/         OPC_MoveParent,
/*28787*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28789*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28792*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28795*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28798*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28801*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28804*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28807*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28810*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28813*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5039:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28831*/       /*Scope*/ 68, /*->28900*/
/*28832*/         OPC_CheckChild1Type, MVT::v4i32,
/*28834*/         OPC_RecordChild2, // #1 = $rsrc
/*28835*/         OPC_RecordChild3, // #2 = $sampler
/*28836*/         OPC_RecordChild4, // #3 = $dmask
/*28837*/         OPC_RecordChild5, // #4 = $unorm
/*28838*/         OPC_RecordChild6, // #5 = $r128
/*28839*/         OPC_RecordChild7, // #6 = $da
/*28840*/         OPC_MoveChild, 8,
/*28842*/         OPC_RecordNode, // #7 = $glc
/*28843*/         OPC_MoveParent,
/*28844*/         OPC_MoveChild, 9,
/*28846*/         OPC_RecordNode, // #8 = $slc
/*28847*/         OPC_MoveParent,
/*28848*/         OPC_MoveChild, 10,
/*28850*/         OPC_RecordNode, // #9 = $tfe
/*28851*/         OPC_MoveParent,
/*28852*/         OPC_MoveChild, 11,
/*28854*/         OPC_RecordNode, // #10 = $lwe
/*28855*/         OPC_MoveParent,
/*28856*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28858*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28861*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28864*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28867*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28870*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28873*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28876*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28879*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28882*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5039:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28900*/       /*Scope*/ 68, /*->28969*/
/*28901*/         OPC_CheckChild1Type, MVT::v8i32,
/*28903*/         OPC_RecordChild2, // #1 = $rsrc
/*28904*/         OPC_RecordChild3, // #2 = $sampler
/*28905*/         OPC_RecordChild4, // #3 = $dmask
/*28906*/         OPC_RecordChild5, // #4 = $unorm
/*28907*/         OPC_RecordChild6, // #5 = $r128
/*28908*/         OPC_RecordChild7, // #6 = $da
/*28909*/         OPC_MoveChild, 8,
/*28911*/         OPC_RecordNode, // #7 = $glc
/*28912*/         OPC_MoveParent,
/*28913*/         OPC_MoveChild, 9,
/*28915*/         OPC_RecordNode, // #8 = $slc
/*28916*/         OPC_MoveParent,
/*28917*/         OPC_MoveChild, 10,
/*28919*/         OPC_RecordNode, // #9 = $tfe
/*28920*/         OPC_MoveParent,
/*28921*/         OPC_MoveChild, 11,
/*28923*/         OPC_RecordNode, // #10 = $lwe
/*28924*/         OPC_MoveParent,
/*28925*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28927*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28930*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*28933*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*28936*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*28939*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*28942*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*28945*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*28948*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*28951*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5039:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*28969*/       /*Scope*/ 68, /*->29038*/
/*28970*/         OPC_CheckChild1Type, MVT::v16i32,
/*28972*/         OPC_RecordChild2, // #1 = $rsrc
/*28973*/         OPC_RecordChild3, // #2 = $sampler
/*28974*/         OPC_RecordChild4, // #3 = $dmask
/*28975*/         OPC_RecordChild5, // #4 = $unorm
/*28976*/         OPC_RecordChild6, // #5 = $r128
/*28977*/         OPC_RecordChild7, // #6 = $da
/*28978*/         OPC_MoveChild, 8,
/*28980*/         OPC_RecordNode, // #7 = $glc
/*28981*/         OPC_MoveParent,
/*28982*/         OPC_MoveChild, 9,
/*28984*/         OPC_RecordNode, // #8 = $slc
/*28985*/         OPC_MoveParent,
/*28986*/         OPC_MoveChild, 10,
/*28988*/         OPC_RecordNode, // #9 = $tfe
/*28989*/         OPC_MoveParent,
/*28990*/         OPC_MoveChild, 11,
/*28992*/         OPC_RecordNode, // #10 = $lwe
/*28993*/         OPC_MoveParent,
/*28994*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*28996*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*28999*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29002*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29005*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29008*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29011*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29014*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29017*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29020*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5039:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29038*/       0, /*End of Scope*/
/*29039*/     /*Scope*/ 95|128,2/*351*/, /*->29392*/
/*29041*/       OPC_CheckChild0Integer, 56|128,39/*5048*/, 
/*29044*/       OPC_RecordChild1, // #0 = $addr
/*29045*/       OPC_Scope, 68, /*->29115*/ // 5 children in Scope
/*29047*/         OPC_CheckChild1Type, MVT::i32,
/*29049*/         OPC_RecordChild2, // #1 = $rsrc
/*29050*/         OPC_RecordChild3, // #2 = $sampler
/*29051*/         OPC_RecordChild4, // #3 = $dmask
/*29052*/         OPC_RecordChild5, // #4 = $unorm
/*29053*/         OPC_RecordChild6, // #5 = $r128
/*29054*/         OPC_RecordChild7, // #6 = $da
/*29055*/         OPC_MoveChild, 8,
/*29057*/         OPC_RecordNode, // #7 = $glc
/*29058*/         OPC_MoveParent,
/*29059*/         OPC_MoveChild, 9,
/*29061*/         OPC_RecordNode, // #8 = $slc
/*29062*/         OPC_MoveParent,
/*29063*/         OPC_MoveChild, 10,
/*29065*/         OPC_RecordNode, // #9 = $tfe
/*29066*/         OPC_MoveParent,
/*29067*/         OPC_MoveChild, 11,
/*29069*/         OPC_RecordNode, // #10 = $lwe
/*29070*/         OPC_MoveParent,
/*29071*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29073*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29076*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29079*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29082*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29085*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29088*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29091*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29094*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29097*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CL_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5048:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CL_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29115*/       /*Scope*/ 68, /*->29184*/
/*29116*/         OPC_CheckChild1Type, MVT::v2i32,
/*29118*/         OPC_RecordChild2, // #1 = $rsrc
/*29119*/         OPC_RecordChild3, // #2 = $sampler
/*29120*/         OPC_RecordChild4, // #3 = $dmask
/*29121*/         OPC_RecordChild5, // #4 = $unorm
/*29122*/         OPC_RecordChild6, // #5 = $r128
/*29123*/         OPC_RecordChild7, // #6 = $da
/*29124*/         OPC_MoveChild, 8,
/*29126*/         OPC_RecordNode, // #7 = $glc
/*29127*/         OPC_MoveParent,
/*29128*/         OPC_MoveChild, 9,
/*29130*/         OPC_RecordNode, // #8 = $slc
/*29131*/         OPC_MoveParent,
/*29132*/         OPC_MoveChild, 10,
/*29134*/         OPC_RecordNode, // #9 = $tfe
/*29135*/         OPC_MoveParent,
/*29136*/         OPC_MoveChild, 11,
/*29138*/         OPC_RecordNode, // #10 = $lwe
/*29139*/         OPC_MoveParent,
/*29140*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29142*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29145*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29148*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29151*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29154*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29157*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29160*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29163*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29166*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CL_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5048:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CL_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29184*/       /*Scope*/ 68, /*->29253*/
/*29185*/         OPC_CheckChild1Type, MVT::v4i32,
/*29187*/         OPC_RecordChild2, // #1 = $rsrc
/*29188*/         OPC_RecordChild3, // #2 = $sampler
/*29189*/         OPC_RecordChild4, // #3 = $dmask
/*29190*/         OPC_RecordChild5, // #4 = $unorm
/*29191*/         OPC_RecordChild6, // #5 = $r128
/*29192*/         OPC_RecordChild7, // #6 = $da
/*29193*/         OPC_MoveChild, 8,
/*29195*/         OPC_RecordNode, // #7 = $glc
/*29196*/         OPC_MoveParent,
/*29197*/         OPC_MoveChild, 9,
/*29199*/         OPC_RecordNode, // #8 = $slc
/*29200*/         OPC_MoveParent,
/*29201*/         OPC_MoveChild, 10,
/*29203*/         OPC_RecordNode, // #9 = $tfe
/*29204*/         OPC_MoveParent,
/*29205*/         OPC_MoveChild, 11,
/*29207*/         OPC_RecordNode, // #10 = $lwe
/*29208*/         OPC_MoveParent,
/*29209*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29211*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29214*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29217*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29220*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29223*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29226*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29229*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29232*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29235*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CL_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5048:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CL_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29253*/       /*Scope*/ 68, /*->29322*/
/*29254*/         OPC_CheckChild1Type, MVT::v8i32,
/*29256*/         OPC_RecordChild2, // #1 = $rsrc
/*29257*/         OPC_RecordChild3, // #2 = $sampler
/*29258*/         OPC_RecordChild4, // #3 = $dmask
/*29259*/         OPC_RecordChild5, // #4 = $unorm
/*29260*/         OPC_RecordChild6, // #5 = $r128
/*29261*/         OPC_RecordChild7, // #6 = $da
/*29262*/         OPC_MoveChild, 8,
/*29264*/         OPC_RecordNode, // #7 = $glc
/*29265*/         OPC_MoveParent,
/*29266*/         OPC_MoveChild, 9,
/*29268*/         OPC_RecordNode, // #8 = $slc
/*29269*/         OPC_MoveParent,
/*29270*/         OPC_MoveChild, 10,
/*29272*/         OPC_RecordNode, // #9 = $tfe
/*29273*/         OPC_MoveParent,
/*29274*/         OPC_MoveChild, 11,
/*29276*/         OPC_RecordNode, // #10 = $lwe
/*29277*/         OPC_MoveParent,
/*29278*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29280*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29283*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29286*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29289*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29292*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29295*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29298*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29301*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29304*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CL_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5048:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CL_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29322*/       /*Scope*/ 68, /*->29391*/
/*29323*/         OPC_CheckChild1Type, MVT::v16i32,
/*29325*/         OPC_RecordChild2, // #1 = $rsrc
/*29326*/         OPC_RecordChild3, // #2 = $sampler
/*29327*/         OPC_RecordChild4, // #3 = $dmask
/*29328*/         OPC_RecordChild5, // #4 = $unorm
/*29329*/         OPC_RecordChild6, // #5 = $r128
/*29330*/         OPC_RecordChild7, // #6 = $da
/*29331*/         OPC_MoveChild, 8,
/*29333*/         OPC_RecordNode, // #7 = $glc
/*29334*/         OPC_MoveParent,
/*29335*/         OPC_MoveChild, 9,
/*29337*/         OPC_RecordNode, // #8 = $slc
/*29338*/         OPC_MoveParent,
/*29339*/         OPC_MoveChild, 10,
/*29341*/         OPC_RecordNode, // #9 = $tfe
/*29342*/         OPC_MoveParent,
/*29343*/         OPC_MoveChild, 11,
/*29345*/         OPC_RecordNode, // #10 = $lwe
/*29346*/         OPC_MoveParent,
/*29347*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29349*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29352*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29355*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29358*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29361*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29364*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29367*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29370*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29373*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CL_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5048:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CL_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29391*/       0, /*End of Scope*/
/*29392*/     /*Scope*/ 95|128,2/*351*/, /*->29745*/
/*29394*/       OPC_CheckChild0Integer, 58|128,39/*5050*/, 
/*29397*/       OPC_RecordChild1, // #0 = $addr
/*29398*/       OPC_Scope, 68, /*->29468*/ // 5 children in Scope
/*29400*/         OPC_CheckChild1Type, MVT::i32,
/*29402*/         OPC_RecordChild2, // #1 = $rsrc
/*29403*/         OPC_RecordChild3, // #2 = $sampler
/*29404*/         OPC_RecordChild4, // #3 = $dmask
/*29405*/         OPC_RecordChild5, // #4 = $unorm
/*29406*/         OPC_RecordChild6, // #5 = $r128
/*29407*/         OPC_RecordChild7, // #6 = $da
/*29408*/         OPC_MoveChild, 8,
/*29410*/         OPC_RecordNode, // #7 = $glc
/*29411*/         OPC_MoveParent,
/*29412*/         OPC_MoveChild, 9,
/*29414*/         OPC_RecordNode, // #8 = $slc
/*29415*/         OPC_MoveParent,
/*29416*/         OPC_MoveChild, 10,
/*29418*/         OPC_RecordNode, // #9 = $tfe
/*29419*/         OPC_MoveParent,
/*29420*/         OPC_MoveChild, 11,
/*29422*/         OPC_RecordNode, // #10 = $lwe
/*29423*/         OPC_MoveParent,
/*29424*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29426*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29429*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29432*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29435*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29438*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29441*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29444*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29447*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29450*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_D_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5050:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_D_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29468*/       /*Scope*/ 68, /*->29537*/
/*29469*/         OPC_CheckChild1Type, MVT::v2i32,
/*29471*/         OPC_RecordChild2, // #1 = $rsrc
/*29472*/         OPC_RecordChild3, // #2 = $sampler
/*29473*/         OPC_RecordChild4, // #3 = $dmask
/*29474*/         OPC_RecordChild5, // #4 = $unorm
/*29475*/         OPC_RecordChild6, // #5 = $r128
/*29476*/         OPC_RecordChild7, // #6 = $da
/*29477*/         OPC_MoveChild, 8,
/*29479*/         OPC_RecordNode, // #7 = $glc
/*29480*/         OPC_MoveParent,
/*29481*/         OPC_MoveChild, 9,
/*29483*/         OPC_RecordNode, // #8 = $slc
/*29484*/         OPC_MoveParent,
/*29485*/         OPC_MoveChild, 10,
/*29487*/         OPC_RecordNode, // #9 = $tfe
/*29488*/         OPC_MoveParent,
/*29489*/         OPC_MoveChild, 11,
/*29491*/         OPC_RecordNode, // #10 = $lwe
/*29492*/         OPC_MoveParent,
/*29493*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29495*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29498*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29501*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29504*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29507*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29510*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29513*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29516*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29519*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_D_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5050:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_D_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29537*/       /*Scope*/ 68, /*->29606*/
/*29538*/         OPC_CheckChild1Type, MVT::v4i32,
/*29540*/         OPC_RecordChild2, // #1 = $rsrc
/*29541*/         OPC_RecordChild3, // #2 = $sampler
/*29542*/         OPC_RecordChild4, // #3 = $dmask
/*29543*/         OPC_RecordChild5, // #4 = $unorm
/*29544*/         OPC_RecordChild6, // #5 = $r128
/*29545*/         OPC_RecordChild7, // #6 = $da
/*29546*/         OPC_MoveChild, 8,
/*29548*/         OPC_RecordNode, // #7 = $glc
/*29549*/         OPC_MoveParent,
/*29550*/         OPC_MoveChild, 9,
/*29552*/         OPC_RecordNode, // #8 = $slc
/*29553*/         OPC_MoveParent,
/*29554*/         OPC_MoveChild, 10,
/*29556*/         OPC_RecordNode, // #9 = $tfe
/*29557*/         OPC_MoveParent,
/*29558*/         OPC_MoveChild, 11,
/*29560*/         OPC_RecordNode, // #10 = $lwe
/*29561*/         OPC_MoveParent,
/*29562*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29564*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29567*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29570*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29573*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29576*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29579*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29582*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29585*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29588*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_D_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5050:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_D_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29606*/       /*Scope*/ 68, /*->29675*/
/*29607*/         OPC_CheckChild1Type, MVT::v8i32,
/*29609*/         OPC_RecordChild2, // #1 = $rsrc
/*29610*/         OPC_RecordChild3, // #2 = $sampler
/*29611*/         OPC_RecordChild4, // #3 = $dmask
/*29612*/         OPC_RecordChild5, // #4 = $unorm
/*29613*/         OPC_RecordChild6, // #5 = $r128
/*29614*/         OPC_RecordChild7, // #6 = $da
/*29615*/         OPC_MoveChild, 8,
/*29617*/         OPC_RecordNode, // #7 = $glc
/*29618*/         OPC_MoveParent,
/*29619*/         OPC_MoveChild, 9,
/*29621*/         OPC_RecordNode, // #8 = $slc
/*29622*/         OPC_MoveParent,
/*29623*/         OPC_MoveChild, 10,
/*29625*/         OPC_RecordNode, // #9 = $tfe
/*29626*/         OPC_MoveParent,
/*29627*/         OPC_MoveChild, 11,
/*29629*/         OPC_RecordNode, // #10 = $lwe
/*29630*/         OPC_MoveParent,
/*29631*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29633*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29636*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29639*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29642*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29645*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29648*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29651*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29654*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29657*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_D_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5050:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_D_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29675*/       /*Scope*/ 68, /*->29744*/
/*29676*/         OPC_CheckChild1Type, MVT::v16i32,
/*29678*/         OPC_RecordChild2, // #1 = $rsrc
/*29679*/         OPC_RecordChild3, // #2 = $sampler
/*29680*/         OPC_RecordChild4, // #3 = $dmask
/*29681*/         OPC_RecordChild5, // #4 = $unorm
/*29682*/         OPC_RecordChild6, // #5 = $r128
/*29683*/         OPC_RecordChild7, // #6 = $da
/*29684*/         OPC_MoveChild, 8,
/*29686*/         OPC_RecordNode, // #7 = $glc
/*29687*/         OPC_MoveParent,
/*29688*/         OPC_MoveChild, 9,
/*29690*/         OPC_RecordNode, // #8 = $slc
/*29691*/         OPC_MoveParent,
/*29692*/         OPC_MoveChild, 10,
/*29694*/         OPC_RecordNode, // #9 = $tfe
/*29695*/         OPC_MoveParent,
/*29696*/         OPC_MoveChild, 11,
/*29698*/         OPC_RecordNode, // #10 = $lwe
/*29699*/         OPC_MoveParent,
/*29700*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29702*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29705*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29708*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29711*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29714*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29717*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29720*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29723*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29726*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_D_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5050:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_D_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29744*/       0, /*End of Scope*/
/*29745*/     /*Scope*/ 95|128,2/*351*/, /*->30098*/
/*29747*/       OPC_CheckChild0Integer, 59|128,39/*5051*/, 
/*29750*/       OPC_RecordChild1, // #0 = $addr
/*29751*/       OPC_Scope, 68, /*->29821*/ // 5 children in Scope
/*29753*/         OPC_CheckChild1Type, MVT::i32,
/*29755*/         OPC_RecordChild2, // #1 = $rsrc
/*29756*/         OPC_RecordChild3, // #2 = $sampler
/*29757*/         OPC_RecordChild4, // #3 = $dmask
/*29758*/         OPC_RecordChild5, // #4 = $unorm
/*29759*/         OPC_RecordChild6, // #5 = $r128
/*29760*/         OPC_RecordChild7, // #6 = $da
/*29761*/         OPC_MoveChild, 8,
/*29763*/         OPC_RecordNode, // #7 = $glc
/*29764*/         OPC_MoveParent,
/*29765*/         OPC_MoveChild, 9,
/*29767*/         OPC_RecordNode, // #8 = $slc
/*29768*/         OPC_MoveParent,
/*29769*/         OPC_MoveChild, 10,
/*29771*/         OPC_RecordNode, // #9 = $tfe
/*29772*/         OPC_MoveParent,
/*29773*/         OPC_MoveChild, 11,
/*29775*/         OPC_RecordNode, // #10 = $lwe
/*29776*/         OPC_MoveParent,
/*29777*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29779*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29782*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29785*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29788*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29791*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29794*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29797*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29800*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29803*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_D_CL_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5051:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_D_CL_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29821*/       /*Scope*/ 68, /*->29890*/
/*29822*/         OPC_CheckChild1Type, MVT::v2i32,
/*29824*/         OPC_RecordChild2, // #1 = $rsrc
/*29825*/         OPC_RecordChild3, // #2 = $sampler
/*29826*/         OPC_RecordChild4, // #3 = $dmask
/*29827*/         OPC_RecordChild5, // #4 = $unorm
/*29828*/         OPC_RecordChild6, // #5 = $r128
/*29829*/         OPC_RecordChild7, // #6 = $da
/*29830*/         OPC_MoveChild, 8,
/*29832*/         OPC_RecordNode, // #7 = $glc
/*29833*/         OPC_MoveParent,
/*29834*/         OPC_MoveChild, 9,
/*29836*/         OPC_RecordNode, // #8 = $slc
/*29837*/         OPC_MoveParent,
/*29838*/         OPC_MoveChild, 10,
/*29840*/         OPC_RecordNode, // #9 = $tfe
/*29841*/         OPC_MoveParent,
/*29842*/         OPC_MoveChild, 11,
/*29844*/         OPC_RecordNode, // #10 = $lwe
/*29845*/         OPC_MoveParent,
/*29846*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29848*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29851*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29854*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29857*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29860*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29863*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29866*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29869*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29872*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_D_CL_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5051:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_D_CL_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29890*/       /*Scope*/ 68, /*->29959*/
/*29891*/         OPC_CheckChild1Type, MVT::v4i32,
/*29893*/         OPC_RecordChild2, // #1 = $rsrc
/*29894*/         OPC_RecordChild3, // #2 = $sampler
/*29895*/         OPC_RecordChild4, // #3 = $dmask
/*29896*/         OPC_RecordChild5, // #4 = $unorm
/*29897*/         OPC_RecordChild6, // #5 = $r128
/*29898*/         OPC_RecordChild7, // #6 = $da
/*29899*/         OPC_MoveChild, 8,
/*29901*/         OPC_RecordNode, // #7 = $glc
/*29902*/         OPC_MoveParent,
/*29903*/         OPC_MoveChild, 9,
/*29905*/         OPC_RecordNode, // #8 = $slc
/*29906*/         OPC_MoveParent,
/*29907*/         OPC_MoveChild, 10,
/*29909*/         OPC_RecordNode, // #9 = $tfe
/*29910*/         OPC_MoveParent,
/*29911*/         OPC_MoveChild, 11,
/*29913*/         OPC_RecordNode, // #10 = $lwe
/*29914*/         OPC_MoveParent,
/*29915*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29917*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29920*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29923*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29926*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29929*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*29932*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*29935*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*29938*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*29941*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_D_CL_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5051:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_D_CL_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*29959*/       /*Scope*/ 68, /*->30028*/
/*29960*/         OPC_CheckChild1Type, MVT::v8i32,
/*29962*/         OPC_RecordChild2, // #1 = $rsrc
/*29963*/         OPC_RecordChild3, // #2 = $sampler
/*29964*/         OPC_RecordChild4, // #3 = $dmask
/*29965*/         OPC_RecordChild5, // #4 = $unorm
/*29966*/         OPC_RecordChild6, // #5 = $r128
/*29967*/         OPC_RecordChild7, // #6 = $da
/*29968*/         OPC_MoveChild, 8,
/*29970*/         OPC_RecordNode, // #7 = $glc
/*29971*/         OPC_MoveParent,
/*29972*/         OPC_MoveChild, 9,
/*29974*/         OPC_RecordNode, // #8 = $slc
/*29975*/         OPC_MoveParent,
/*29976*/         OPC_MoveChild, 10,
/*29978*/         OPC_RecordNode, // #9 = $tfe
/*29979*/         OPC_MoveParent,
/*29980*/         OPC_MoveChild, 11,
/*29982*/         OPC_RecordNode, // #10 = $lwe
/*29983*/         OPC_MoveParent,
/*29984*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*29986*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*29989*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*29992*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*29995*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*29998*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30001*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30004*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30007*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30010*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_D_CL_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5051:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_D_CL_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30028*/       /*Scope*/ 68, /*->30097*/
/*30029*/         OPC_CheckChild1Type, MVT::v16i32,
/*30031*/         OPC_RecordChild2, // #1 = $rsrc
/*30032*/         OPC_RecordChild3, // #2 = $sampler
/*30033*/         OPC_RecordChild4, // #3 = $dmask
/*30034*/         OPC_RecordChild5, // #4 = $unorm
/*30035*/         OPC_RecordChild6, // #5 = $r128
/*30036*/         OPC_RecordChild7, // #6 = $da
/*30037*/         OPC_MoveChild, 8,
/*30039*/         OPC_RecordNode, // #7 = $glc
/*30040*/         OPC_MoveParent,
/*30041*/         OPC_MoveChild, 9,
/*30043*/         OPC_RecordNode, // #8 = $slc
/*30044*/         OPC_MoveParent,
/*30045*/         OPC_MoveChild, 10,
/*30047*/         OPC_RecordNode, // #9 = $tfe
/*30048*/         OPC_MoveParent,
/*30049*/         OPC_MoveChild, 11,
/*30051*/         OPC_RecordNode, // #10 = $lwe
/*30052*/         OPC_MoveParent,
/*30053*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30055*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30058*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30061*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30064*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30067*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30070*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30073*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30076*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30079*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_D_CL_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5051:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_D_CL_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30097*/       0, /*End of Scope*/
/*30098*/     /*Scope*/ 95|128,2/*351*/, /*->30451*/
/*30100*/       OPC_CheckChild0Integer, 62|128,39/*5054*/, 
/*30103*/       OPC_RecordChild1, // #0 = $addr
/*30104*/       OPC_Scope, 68, /*->30174*/ // 5 children in Scope
/*30106*/         OPC_CheckChild1Type, MVT::i32,
/*30108*/         OPC_RecordChild2, // #1 = $rsrc
/*30109*/         OPC_RecordChild3, // #2 = $sampler
/*30110*/         OPC_RecordChild4, // #3 = $dmask
/*30111*/         OPC_RecordChild5, // #4 = $unorm
/*30112*/         OPC_RecordChild6, // #5 = $r128
/*30113*/         OPC_RecordChild7, // #6 = $da
/*30114*/         OPC_MoveChild, 8,
/*30116*/         OPC_RecordNode, // #7 = $glc
/*30117*/         OPC_MoveParent,
/*30118*/         OPC_MoveChild, 9,
/*30120*/         OPC_RecordNode, // #8 = $slc
/*30121*/         OPC_MoveParent,
/*30122*/         OPC_MoveChild, 10,
/*30124*/         OPC_RecordNode, // #9 = $tfe
/*30125*/         OPC_MoveParent,
/*30126*/         OPC_MoveChild, 11,
/*30128*/         OPC_RecordNode, // #10 = $lwe
/*30129*/         OPC_MoveParent,
/*30130*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30132*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30135*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30138*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30141*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30144*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30147*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30150*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30153*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30156*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_L_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5054:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_L_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30174*/       /*Scope*/ 68, /*->30243*/
/*30175*/         OPC_CheckChild1Type, MVT::v2i32,
/*30177*/         OPC_RecordChild2, // #1 = $rsrc
/*30178*/         OPC_RecordChild3, // #2 = $sampler
/*30179*/         OPC_RecordChild4, // #3 = $dmask
/*30180*/         OPC_RecordChild5, // #4 = $unorm
/*30181*/         OPC_RecordChild6, // #5 = $r128
/*30182*/         OPC_RecordChild7, // #6 = $da
/*30183*/         OPC_MoveChild, 8,
/*30185*/         OPC_RecordNode, // #7 = $glc
/*30186*/         OPC_MoveParent,
/*30187*/         OPC_MoveChild, 9,
/*30189*/         OPC_RecordNode, // #8 = $slc
/*30190*/         OPC_MoveParent,
/*30191*/         OPC_MoveChild, 10,
/*30193*/         OPC_RecordNode, // #9 = $tfe
/*30194*/         OPC_MoveParent,
/*30195*/         OPC_MoveChild, 11,
/*30197*/         OPC_RecordNode, // #10 = $lwe
/*30198*/         OPC_MoveParent,
/*30199*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30201*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30204*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30207*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30210*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30213*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30216*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30219*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30222*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30225*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_L_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5054:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_L_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30243*/       /*Scope*/ 68, /*->30312*/
/*30244*/         OPC_CheckChild1Type, MVT::v4i32,
/*30246*/         OPC_RecordChild2, // #1 = $rsrc
/*30247*/         OPC_RecordChild3, // #2 = $sampler
/*30248*/         OPC_RecordChild4, // #3 = $dmask
/*30249*/         OPC_RecordChild5, // #4 = $unorm
/*30250*/         OPC_RecordChild6, // #5 = $r128
/*30251*/         OPC_RecordChild7, // #6 = $da
/*30252*/         OPC_MoveChild, 8,
/*30254*/         OPC_RecordNode, // #7 = $glc
/*30255*/         OPC_MoveParent,
/*30256*/         OPC_MoveChild, 9,
/*30258*/         OPC_RecordNode, // #8 = $slc
/*30259*/         OPC_MoveParent,
/*30260*/         OPC_MoveChild, 10,
/*30262*/         OPC_RecordNode, // #9 = $tfe
/*30263*/         OPC_MoveParent,
/*30264*/         OPC_MoveChild, 11,
/*30266*/         OPC_RecordNode, // #10 = $lwe
/*30267*/         OPC_MoveParent,
/*30268*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30270*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30273*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30276*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30279*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30282*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30285*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30288*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30291*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30294*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_L_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5054:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_L_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30312*/       /*Scope*/ 68, /*->30381*/
/*30313*/         OPC_CheckChild1Type, MVT::v8i32,
/*30315*/         OPC_RecordChild2, // #1 = $rsrc
/*30316*/         OPC_RecordChild3, // #2 = $sampler
/*30317*/         OPC_RecordChild4, // #3 = $dmask
/*30318*/         OPC_RecordChild5, // #4 = $unorm
/*30319*/         OPC_RecordChild6, // #5 = $r128
/*30320*/         OPC_RecordChild7, // #6 = $da
/*30321*/         OPC_MoveChild, 8,
/*30323*/         OPC_RecordNode, // #7 = $glc
/*30324*/         OPC_MoveParent,
/*30325*/         OPC_MoveChild, 9,
/*30327*/         OPC_RecordNode, // #8 = $slc
/*30328*/         OPC_MoveParent,
/*30329*/         OPC_MoveChild, 10,
/*30331*/         OPC_RecordNode, // #9 = $tfe
/*30332*/         OPC_MoveParent,
/*30333*/         OPC_MoveChild, 11,
/*30335*/         OPC_RecordNode, // #10 = $lwe
/*30336*/         OPC_MoveParent,
/*30337*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30339*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30342*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30345*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30348*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30351*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30354*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30357*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30360*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30363*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_L_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5054:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_L_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30381*/       /*Scope*/ 68, /*->30450*/
/*30382*/         OPC_CheckChild1Type, MVT::v16i32,
/*30384*/         OPC_RecordChild2, // #1 = $rsrc
/*30385*/         OPC_RecordChild3, // #2 = $sampler
/*30386*/         OPC_RecordChild4, // #3 = $dmask
/*30387*/         OPC_RecordChild5, // #4 = $unorm
/*30388*/         OPC_RecordChild6, // #5 = $r128
/*30389*/         OPC_RecordChild7, // #6 = $da
/*30390*/         OPC_MoveChild, 8,
/*30392*/         OPC_RecordNode, // #7 = $glc
/*30393*/         OPC_MoveParent,
/*30394*/         OPC_MoveChild, 9,
/*30396*/         OPC_RecordNode, // #8 = $slc
/*30397*/         OPC_MoveParent,
/*30398*/         OPC_MoveChild, 10,
/*30400*/         OPC_RecordNode, // #9 = $tfe
/*30401*/         OPC_MoveParent,
/*30402*/         OPC_MoveChild, 11,
/*30404*/         OPC_RecordNode, // #10 = $lwe
/*30405*/         OPC_MoveParent,
/*30406*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30408*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30411*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30414*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30417*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30420*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30423*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30426*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30429*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30432*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_L_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5054:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_L_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30450*/       0, /*End of Scope*/
/*30451*/     /*Scope*/ 95|128,2/*351*/, /*->30804*/
/*30453*/       OPC_CheckChild0Integer, 48|128,39/*5040*/, 
/*30456*/       OPC_RecordChild1, // #0 = $addr
/*30457*/       OPC_Scope, 68, /*->30527*/ // 5 children in Scope
/*30459*/         OPC_CheckChild1Type, MVT::i32,
/*30461*/         OPC_RecordChild2, // #1 = $rsrc
/*30462*/         OPC_RecordChild3, // #2 = $sampler
/*30463*/         OPC_RecordChild4, // #3 = $dmask
/*30464*/         OPC_RecordChild5, // #4 = $unorm
/*30465*/         OPC_RecordChild6, // #5 = $r128
/*30466*/         OPC_RecordChild7, // #6 = $da
/*30467*/         OPC_MoveChild, 8,
/*30469*/         OPC_RecordNode, // #7 = $glc
/*30470*/         OPC_MoveParent,
/*30471*/         OPC_MoveChild, 9,
/*30473*/         OPC_RecordNode, // #8 = $slc
/*30474*/         OPC_MoveParent,
/*30475*/         OPC_MoveChild, 10,
/*30477*/         OPC_RecordNode, // #9 = $tfe
/*30478*/         OPC_MoveParent,
/*30479*/         OPC_MoveChild, 11,
/*30481*/         OPC_RecordNode, // #10 = $lwe
/*30482*/         OPC_MoveParent,
/*30483*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30485*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30488*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30491*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30494*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30497*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30500*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30503*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30506*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30509*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_B_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5040:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_B_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30527*/       /*Scope*/ 68, /*->30596*/
/*30528*/         OPC_CheckChild1Type, MVT::v2i32,
/*30530*/         OPC_RecordChild2, // #1 = $rsrc
/*30531*/         OPC_RecordChild3, // #2 = $sampler
/*30532*/         OPC_RecordChild4, // #3 = $dmask
/*30533*/         OPC_RecordChild5, // #4 = $unorm
/*30534*/         OPC_RecordChild6, // #5 = $r128
/*30535*/         OPC_RecordChild7, // #6 = $da
/*30536*/         OPC_MoveChild, 8,
/*30538*/         OPC_RecordNode, // #7 = $glc
/*30539*/         OPC_MoveParent,
/*30540*/         OPC_MoveChild, 9,
/*30542*/         OPC_RecordNode, // #8 = $slc
/*30543*/         OPC_MoveParent,
/*30544*/         OPC_MoveChild, 10,
/*30546*/         OPC_RecordNode, // #9 = $tfe
/*30547*/         OPC_MoveParent,
/*30548*/         OPC_MoveChild, 11,
/*30550*/         OPC_RecordNode, // #10 = $lwe
/*30551*/         OPC_MoveParent,
/*30552*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30554*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30557*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30560*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30563*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30566*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30569*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30572*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30575*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30578*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_B_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5040:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_B_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30596*/       /*Scope*/ 68, /*->30665*/
/*30597*/         OPC_CheckChild1Type, MVT::v4i32,
/*30599*/         OPC_RecordChild2, // #1 = $rsrc
/*30600*/         OPC_RecordChild3, // #2 = $sampler
/*30601*/         OPC_RecordChild4, // #3 = $dmask
/*30602*/         OPC_RecordChild5, // #4 = $unorm
/*30603*/         OPC_RecordChild6, // #5 = $r128
/*30604*/         OPC_RecordChild7, // #6 = $da
/*30605*/         OPC_MoveChild, 8,
/*30607*/         OPC_RecordNode, // #7 = $glc
/*30608*/         OPC_MoveParent,
/*30609*/         OPC_MoveChild, 9,
/*30611*/         OPC_RecordNode, // #8 = $slc
/*30612*/         OPC_MoveParent,
/*30613*/         OPC_MoveChild, 10,
/*30615*/         OPC_RecordNode, // #9 = $tfe
/*30616*/         OPC_MoveParent,
/*30617*/         OPC_MoveChild, 11,
/*30619*/         OPC_RecordNode, // #10 = $lwe
/*30620*/         OPC_MoveParent,
/*30621*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30623*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30626*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30629*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30632*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30635*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30638*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30641*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30644*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30647*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_B_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5040:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_B_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30665*/       /*Scope*/ 68, /*->30734*/
/*30666*/         OPC_CheckChild1Type, MVT::v8i32,
/*30668*/         OPC_RecordChild2, // #1 = $rsrc
/*30669*/         OPC_RecordChild3, // #2 = $sampler
/*30670*/         OPC_RecordChild4, // #3 = $dmask
/*30671*/         OPC_RecordChild5, // #4 = $unorm
/*30672*/         OPC_RecordChild6, // #5 = $r128
/*30673*/         OPC_RecordChild7, // #6 = $da
/*30674*/         OPC_MoveChild, 8,
/*30676*/         OPC_RecordNode, // #7 = $glc
/*30677*/         OPC_MoveParent,
/*30678*/         OPC_MoveChild, 9,
/*30680*/         OPC_RecordNode, // #8 = $slc
/*30681*/         OPC_MoveParent,
/*30682*/         OPC_MoveChild, 10,
/*30684*/         OPC_RecordNode, // #9 = $tfe
/*30685*/         OPC_MoveParent,
/*30686*/         OPC_MoveChild, 11,
/*30688*/         OPC_RecordNode, // #10 = $lwe
/*30689*/         OPC_MoveParent,
/*30690*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30692*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30695*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30698*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30701*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30704*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30707*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30710*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30713*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30716*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_B_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5040:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_B_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30734*/       /*Scope*/ 68, /*->30803*/
/*30735*/         OPC_CheckChild1Type, MVT::v16i32,
/*30737*/         OPC_RecordChild2, // #1 = $rsrc
/*30738*/         OPC_RecordChild3, // #2 = $sampler
/*30739*/         OPC_RecordChild4, // #3 = $dmask
/*30740*/         OPC_RecordChild5, // #4 = $unorm
/*30741*/         OPC_RecordChild6, // #5 = $r128
/*30742*/         OPC_RecordChild7, // #6 = $da
/*30743*/         OPC_MoveChild, 8,
/*30745*/         OPC_RecordNode, // #7 = $glc
/*30746*/         OPC_MoveParent,
/*30747*/         OPC_MoveChild, 9,
/*30749*/         OPC_RecordNode, // #8 = $slc
/*30750*/         OPC_MoveParent,
/*30751*/         OPC_MoveChild, 10,
/*30753*/         OPC_RecordNode, // #9 = $tfe
/*30754*/         OPC_MoveParent,
/*30755*/         OPC_MoveChild, 11,
/*30757*/         OPC_RecordNode, // #10 = $lwe
/*30758*/         OPC_MoveParent,
/*30759*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30761*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30764*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30767*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30770*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30773*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30776*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30779*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30782*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30785*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_B_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5040:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_B_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30803*/       0, /*End of Scope*/
/*30804*/     /*Scope*/ 95|128,2/*351*/, /*->31157*/
/*30806*/       OPC_CheckChild0Integer, 49|128,39/*5041*/, 
/*30809*/       OPC_RecordChild1, // #0 = $addr
/*30810*/       OPC_Scope, 68, /*->30880*/ // 5 children in Scope
/*30812*/         OPC_CheckChild1Type, MVT::i32,
/*30814*/         OPC_RecordChild2, // #1 = $rsrc
/*30815*/         OPC_RecordChild3, // #2 = $sampler
/*30816*/         OPC_RecordChild4, // #3 = $dmask
/*30817*/         OPC_RecordChild5, // #4 = $unorm
/*30818*/         OPC_RecordChild6, // #5 = $r128
/*30819*/         OPC_RecordChild7, // #6 = $da
/*30820*/         OPC_MoveChild, 8,
/*30822*/         OPC_RecordNode, // #7 = $glc
/*30823*/         OPC_MoveParent,
/*30824*/         OPC_MoveChild, 9,
/*30826*/         OPC_RecordNode, // #8 = $slc
/*30827*/         OPC_MoveParent,
/*30828*/         OPC_MoveChild, 10,
/*30830*/         OPC_RecordNode, // #9 = $tfe
/*30831*/         OPC_MoveParent,
/*30832*/         OPC_MoveChild, 11,
/*30834*/         OPC_RecordNode, // #10 = $lwe
/*30835*/         OPC_MoveParent,
/*30836*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30838*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30841*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30844*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30847*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30850*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30853*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30856*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30859*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30862*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_B_CL_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5041:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_B_CL_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30880*/       /*Scope*/ 68, /*->30949*/
/*30881*/         OPC_CheckChild1Type, MVT::v2i32,
/*30883*/         OPC_RecordChild2, // #1 = $rsrc
/*30884*/         OPC_RecordChild3, // #2 = $sampler
/*30885*/         OPC_RecordChild4, // #3 = $dmask
/*30886*/         OPC_RecordChild5, // #4 = $unorm
/*30887*/         OPC_RecordChild6, // #5 = $r128
/*30888*/         OPC_RecordChild7, // #6 = $da
/*30889*/         OPC_MoveChild, 8,
/*30891*/         OPC_RecordNode, // #7 = $glc
/*30892*/         OPC_MoveParent,
/*30893*/         OPC_MoveChild, 9,
/*30895*/         OPC_RecordNode, // #8 = $slc
/*30896*/         OPC_MoveParent,
/*30897*/         OPC_MoveChild, 10,
/*30899*/         OPC_RecordNode, // #9 = $tfe
/*30900*/         OPC_MoveParent,
/*30901*/         OPC_MoveChild, 11,
/*30903*/         OPC_RecordNode, // #10 = $lwe
/*30904*/         OPC_MoveParent,
/*30905*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30907*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30910*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30913*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30916*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30919*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30922*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30925*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30928*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*30931*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_B_CL_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5041:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_B_CL_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*30949*/       /*Scope*/ 68, /*->31018*/
/*30950*/         OPC_CheckChild1Type, MVT::v4i32,
/*30952*/         OPC_RecordChild2, // #1 = $rsrc
/*30953*/         OPC_RecordChild3, // #2 = $sampler
/*30954*/         OPC_RecordChild4, // #3 = $dmask
/*30955*/         OPC_RecordChild5, // #4 = $unorm
/*30956*/         OPC_RecordChild6, // #5 = $r128
/*30957*/         OPC_RecordChild7, // #6 = $da
/*30958*/         OPC_MoveChild, 8,
/*30960*/         OPC_RecordNode, // #7 = $glc
/*30961*/         OPC_MoveParent,
/*30962*/         OPC_MoveChild, 9,
/*30964*/         OPC_RecordNode, // #8 = $slc
/*30965*/         OPC_MoveParent,
/*30966*/         OPC_MoveChild, 10,
/*30968*/         OPC_RecordNode, // #9 = $tfe
/*30969*/         OPC_MoveParent,
/*30970*/         OPC_MoveChild, 11,
/*30972*/         OPC_RecordNode, // #10 = $lwe
/*30973*/         OPC_MoveParent,
/*30974*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*30976*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*30979*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*30982*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*30985*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*30988*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*30991*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*30994*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*30997*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31000*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_B_CL_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5041:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_B_CL_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31018*/       /*Scope*/ 68, /*->31087*/
/*31019*/         OPC_CheckChild1Type, MVT::v8i32,
/*31021*/         OPC_RecordChild2, // #1 = $rsrc
/*31022*/         OPC_RecordChild3, // #2 = $sampler
/*31023*/         OPC_RecordChild4, // #3 = $dmask
/*31024*/         OPC_RecordChild5, // #4 = $unorm
/*31025*/         OPC_RecordChild6, // #5 = $r128
/*31026*/         OPC_RecordChild7, // #6 = $da
/*31027*/         OPC_MoveChild, 8,
/*31029*/         OPC_RecordNode, // #7 = $glc
/*31030*/         OPC_MoveParent,
/*31031*/         OPC_MoveChild, 9,
/*31033*/         OPC_RecordNode, // #8 = $slc
/*31034*/         OPC_MoveParent,
/*31035*/         OPC_MoveChild, 10,
/*31037*/         OPC_RecordNode, // #9 = $tfe
/*31038*/         OPC_MoveParent,
/*31039*/         OPC_MoveChild, 11,
/*31041*/         OPC_RecordNode, // #10 = $lwe
/*31042*/         OPC_MoveParent,
/*31043*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31045*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31048*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31051*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31054*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31057*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31060*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31063*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31066*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31069*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_B_CL_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5041:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_B_CL_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31087*/       /*Scope*/ 68, /*->31156*/
/*31088*/         OPC_CheckChild1Type, MVT::v16i32,
/*31090*/         OPC_RecordChild2, // #1 = $rsrc
/*31091*/         OPC_RecordChild3, // #2 = $sampler
/*31092*/         OPC_RecordChild4, // #3 = $dmask
/*31093*/         OPC_RecordChild5, // #4 = $unorm
/*31094*/         OPC_RecordChild6, // #5 = $r128
/*31095*/         OPC_RecordChild7, // #6 = $da
/*31096*/         OPC_MoveChild, 8,
/*31098*/         OPC_RecordNode, // #7 = $glc
/*31099*/         OPC_MoveParent,
/*31100*/         OPC_MoveChild, 9,
/*31102*/         OPC_RecordNode, // #8 = $slc
/*31103*/         OPC_MoveParent,
/*31104*/         OPC_MoveChild, 10,
/*31106*/         OPC_RecordNode, // #9 = $tfe
/*31107*/         OPC_MoveParent,
/*31108*/         OPC_MoveChild, 11,
/*31110*/         OPC_RecordNode, // #10 = $lwe
/*31111*/         OPC_MoveParent,
/*31112*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31114*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31117*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31120*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31123*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31126*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31129*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31132*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31135*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31138*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_B_CL_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5041:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_B_CL_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31156*/       0, /*End of Scope*/
/*31157*/     /*Scope*/ 95|128,2/*351*/, /*->31510*/
/*31159*/       OPC_CheckChild0Integer, 64|128,39/*5056*/, 
/*31162*/       OPC_RecordChild1, // #0 = $addr
/*31163*/       OPC_Scope, 68, /*->31233*/ // 5 children in Scope
/*31165*/         OPC_CheckChild1Type, MVT::i32,
/*31167*/         OPC_RecordChild2, // #1 = $rsrc
/*31168*/         OPC_RecordChild3, // #2 = $sampler
/*31169*/         OPC_RecordChild4, // #3 = $dmask
/*31170*/         OPC_RecordChild5, // #4 = $unorm
/*31171*/         OPC_RecordChild6, // #5 = $r128
/*31172*/         OPC_RecordChild7, // #6 = $da
/*31173*/         OPC_MoveChild, 8,
/*31175*/         OPC_RecordNode, // #7 = $glc
/*31176*/         OPC_MoveParent,
/*31177*/         OPC_MoveChild, 9,
/*31179*/         OPC_RecordNode, // #8 = $slc
/*31180*/         OPC_MoveParent,
/*31181*/         OPC_MoveChild, 10,
/*31183*/         OPC_RecordNode, // #9 = $tfe
/*31184*/         OPC_MoveParent,
/*31185*/         OPC_MoveChild, 11,
/*31187*/         OPC_RecordNode, // #10 = $lwe
/*31188*/         OPC_MoveParent,
/*31189*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31191*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31194*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31197*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31200*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31203*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31206*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31209*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31212*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31215*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_LZ_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5056:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_LZ_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31233*/       /*Scope*/ 68, /*->31302*/
/*31234*/         OPC_CheckChild1Type, MVT::v2i32,
/*31236*/         OPC_RecordChild2, // #1 = $rsrc
/*31237*/         OPC_RecordChild3, // #2 = $sampler
/*31238*/         OPC_RecordChild4, // #3 = $dmask
/*31239*/         OPC_RecordChild5, // #4 = $unorm
/*31240*/         OPC_RecordChild6, // #5 = $r128
/*31241*/         OPC_RecordChild7, // #6 = $da
/*31242*/         OPC_MoveChild, 8,
/*31244*/         OPC_RecordNode, // #7 = $glc
/*31245*/         OPC_MoveParent,
/*31246*/         OPC_MoveChild, 9,
/*31248*/         OPC_RecordNode, // #8 = $slc
/*31249*/         OPC_MoveParent,
/*31250*/         OPC_MoveChild, 10,
/*31252*/         OPC_RecordNode, // #9 = $tfe
/*31253*/         OPC_MoveParent,
/*31254*/         OPC_MoveChild, 11,
/*31256*/         OPC_RecordNode, // #10 = $lwe
/*31257*/         OPC_MoveParent,
/*31258*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31260*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31263*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31266*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31269*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31272*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31275*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31278*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31281*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31284*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_LZ_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5056:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_LZ_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31302*/       /*Scope*/ 68, /*->31371*/
/*31303*/         OPC_CheckChild1Type, MVT::v4i32,
/*31305*/         OPC_RecordChild2, // #1 = $rsrc
/*31306*/         OPC_RecordChild3, // #2 = $sampler
/*31307*/         OPC_RecordChild4, // #3 = $dmask
/*31308*/         OPC_RecordChild5, // #4 = $unorm
/*31309*/         OPC_RecordChild6, // #5 = $r128
/*31310*/         OPC_RecordChild7, // #6 = $da
/*31311*/         OPC_MoveChild, 8,
/*31313*/         OPC_RecordNode, // #7 = $glc
/*31314*/         OPC_MoveParent,
/*31315*/         OPC_MoveChild, 9,
/*31317*/         OPC_RecordNode, // #8 = $slc
/*31318*/         OPC_MoveParent,
/*31319*/         OPC_MoveChild, 10,
/*31321*/         OPC_RecordNode, // #9 = $tfe
/*31322*/         OPC_MoveParent,
/*31323*/         OPC_MoveChild, 11,
/*31325*/         OPC_RecordNode, // #10 = $lwe
/*31326*/         OPC_MoveParent,
/*31327*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31329*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31332*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31335*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31338*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31341*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31344*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31347*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31350*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31353*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_LZ_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5056:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_LZ_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31371*/       /*Scope*/ 68, /*->31440*/
/*31372*/         OPC_CheckChild1Type, MVT::v8i32,
/*31374*/         OPC_RecordChild2, // #1 = $rsrc
/*31375*/         OPC_RecordChild3, // #2 = $sampler
/*31376*/         OPC_RecordChild4, // #3 = $dmask
/*31377*/         OPC_RecordChild5, // #4 = $unorm
/*31378*/         OPC_RecordChild6, // #5 = $r128
/*31379*/         OPC_RecordChild7, // #6 = $da
/*31380*/         OPC_MoveChild, 8,
/*31382*/         OPC_RecordNode, // #7 = $glc
/*31383*/         OPC_MoveParent,
/*31384*/         OPC_MoveChild, 9,
/*31386*/         OPC_RecordNode, // #8 = $slc
/*31387*/         OPC_MoveParent,
/*31388*/         OPC_MoveChild, 10,
/*31390*/         OPC_RecordNode, // #9 = $tfe
/*31391*/         OPC_MoveParent,
/*31392*/         OPC_MoveChild, 11,
/*31394*/         OPC_RecordNode, // #10 = $lwe
/*31395*/         OPC_MoveParent,
/*31396*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31398*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31401*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31404*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31407*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31410*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31413*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31416*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31419*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31422*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_LZ_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5056:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_LZ_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31440*/       /*Scope*/ 68, /*->31509*/
/*31441*/         OPC_CheckChild1Type, MVT::v16i32,
/*31443*/         OPC_RecordChild2, // #1 = $rsrc
/*31444*/         OPC_RecordChild3, // #2 = $sampler
/*31445*/         OPC_RecordChild4, // #3 = $dmask
/*31446*/         OPC_RecordChild5, // #4 = $unorm
/*31447*/         OPC_RecordChild6, // #5 = $r128
/*31448*/         OPC_RecordChild7, // #6 = $da
/*31449*/         OPC_MoveChild, 8,
/*31451*/         OPC_RecordNode, // #7 = $glc
/*31452*/         OPC_MoveParent,
/*31453*/         OPC_MoveChild, 9,
/*31455*/         OPC_RecordNode, // #8 = $slc
/*31456*/         OPC_MoveParent,
/*31457*/         OPC_MoveChild, 10,
/*31459*/         OPC_RecordNode, // #9 = $tfe
/*31460*/         OPC_MoveParent,
/*31461*/         OPC_MoveChild, 11,
/*31463*/         OPC_RecordNode, // #10 = $lwe
/*31464*/         OPC_MoveParent,
/*31465*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31467*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31470*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31473*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31476*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31479*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31482*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31485*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31488*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31491*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_LZ_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5056:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_LZ_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31509*/       0, /*End of Scope*/
/*31510*/     /*Scope*/ 95|128,2/*351*/, /*->31863*/
/*31512*/       OPC_CheckChild0Integer, 52|128,39/*5044*/, 
/*31515*/       OPC_RecordChild1, // #0 = $addr
/*31516*/       OPC_Scope, 68, /*->31586*/ // 5 children in Scope
/*31518*/         OPC_CheckChild1Type, MVT::i32,
/*31520*/         OPC_RecordChild2, // #1 = $rsrc
/*31521*/         OPC_RecordChild3, // #2 = $sampler
/*31522*/         OPC_RecordChild4, // #3 = $dmask
/*31523*/         OPC_RecordChild5, // #4 = $unorm
/*31524*/         OPC_RecordChild6, // #5 = $r128
/*31525*/         OPC_RecordChild7, // #6 = $da
/*31526*/         OPC_MoveChild, 8,
/*31528*/         OPC_RecordNode, // #7 = $glc
/*31529*/         OPC_MoveParent,
/*31530*/         OPC_MoveChild, 9,
/*31532*/         OPC_RecordNode, // #8 = $slc
/*31533*/         OPC_MoveParent,
/*31534*/         OPC_MoveChild, 10,
/*31536*/         OPC_RecordNode, // #9 = $tfe
/*31537*/         OPC_MoveParent,
/*31538*/         OPC_MoveChild, 11,
/*31540*/         OPC_RecordNode, // #10 = $lwe
/*31541*/         OPC_MoveParent,
/*31542*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31544*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31547*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31550*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31553*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31556*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31559*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31562*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31565*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31568*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CD_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5044:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CD_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31586*/       /*Scope*/ 68, /*->31655*/
/*31587*/         OPC_CheckChild1Type, MVT::v2i32,
/*31589*/         OPC_RecordChild2, // #1 = $rsrc
/*31590*/         OPC_RecordChild3, // #2 = $sampler
/*31591*/         OPC_RecordChild4, // #3 = $dmask
/*31592*/         OPC_RecordChild5, // #4 = $unorm
/*31593*/         OPC_RecordChild6, // #5 = $r128
/*31594*/         OPC_RecordChild7, // #6 = $da
/*31595*/         OPC_MoveChild, 8,
/*31597*/         OPC_RecordNode, // #7 = $glc
/*31598*/         OPC_MoveParent,
/*31599*/         OPC_MoveChild, 9,
/*31601*/         OPC_RecordNode, // #8 = $slc
/*31602*/         OPC_MoveParent,
/*31603*/         OPC_MoveChild, 10,
/*31605*/         OPC_RecordNode, // #9 = $tfe
/*31606*/         OPC_MoveParent,
/*31607*/         OPC_MoveChild, 11,
/*31609*/         OPC_RecordNode, // #10 = $lwe
/*31610*/         OPC_MoveParent,
/*31611*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31613*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31616*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31619*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31622*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31625*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31628*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31631*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31634*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31637*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CD_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5044:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CD_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31655*/       /*Scope*/ 68, /*->31724*/
/*31656*/         OPC_CheckChild1Type, MVT::v4i32,
/*31658*/         OPC_RecordChild2, // #1 = $rsrc
/*31659*/         OPC_RecordChild3, // #2 = $sampler
/*31660*/         OPC_RecordChild4, // #3 = $dmask
/*31661*/         OPC_RecordChild5, // #4 = $unorm
/*31662*/         OPC_RecordChild6, // #5 = $r128
/*31663*/         OPC_RecordChild7, // #6 = $da
/*31664*/         OPC_MoveChild, 8,
/*31666*/         OPC_RecordNode, // #7 = $glc
/*31667*/         OPC_MoveParent,
/*31668*/         OPC_MoveChild, 9,
/*31670*/         OPC_RecordNode, // #8 = $slc
/*31671*/         OPC_MoveParent,
/*31672*/         OPC_MoveChild, 10,
/*31674*/         OPC_RecordNode, // #9 = $tfe
/*31675*/         OPC_MoveParent,
/*31676*/         OPC_MoveChild, 11,
/*31678*/         OPC_RecordNode, // #10 = $lwe
/*31679*/         OPC_MoveParent,
/*31680*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31682*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31685*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31688*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31691*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31694*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31697*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31700*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31703*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31706*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CD_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5044:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CD_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31724*/       /*Scope*/ 68, /*->31793*/
/*31725*/         OPC_CheckChild1Type, MVT::v8i32,
/*31727*/         OPC_RecordChild2, // #1 = $rsrc
/*31728*/         OPC_RecordChild3, // #2 = $sampler
/*31729*/         OPC_RecordChild4, // #3 = $dmask
/*31730*/         OPC_RecordChild5, // #4 = $unorm
/*31731*/         OPC_RecordChild6, // #5 = $r128
/*31732*/         OPC_RecordChild7, // #6 = $da
/*31733*/         OPC_MoveChild, 8,
/*31735*/         OPC_RecordNode, // #7 = $glc
/*31736*/         OPC_MoveParent,
/*31737*/         OPC_MoveChild, 9,
/*31739*/         OPC_RecordNode, // #8 = $slc
/*31740*/         OPC_MoveParent,
/*31741*/         OPC_MoveChild, 10,
/*31743*/         OPC_RecordNode, // #9 = $tfe
/*31744*/         OPC_MoveParent,
/*31745*/         OPC_MoveChild, 11,
/*31747*/         OPC_RecordNode, // #10 = $lwe
/*31748*/         OPC_MoveParent,
/*31749*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31751*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31754*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31757*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31760*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31763*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31766*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31769*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31772*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31775*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CD_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5044:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CD_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31793*/       /*Scope*/ 68, /*->31862*/
/*31794*/         OPC_CheckChild1Type, MVT::v16i32,
/*31796*/         OPC_RecordChild2, // #1 = $rsrc
/*31797*/         OPC_RecordChild3, // #2 = $sampler
/*31798*/         OPC_RecordChild4, // #3 = $dmask
/*31799*/         OPC_RecordChild5, // #4 = $unorm
/*31800*/         OPC_RecordChild6, // #5 = $r128
/*31801*/         OPC_RecordChild7, // #6 = $da
/*31802*/         OPC_MoveChild, 8,
/*31804*/         OPC_RecordNode, // #7 = $glc
/*31805*/         OPC_MoveParent,
/*31806*/         OPC_MoveChild, 9,
/*31808*/         OPC_RecordNode, // #8 = $slc
/*31809*/         OPC_MoveParent,
/*31810*/         OPC_MoveChild, 10,
/*31812*/         OPC_RecordNode, // #9 = $tfe
/*31813*/         OPC_MoveParent,
/*31814*/         OPC_MoveChild, 11,
/*31816*/         OPC_RecordNode, // #10 = $lwe
/*31817*/         OPC_MoveParent,
/*31818*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31820*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31823*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31826*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31829*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31832*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31835*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31838*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31841*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31844*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CD_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5044:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CD_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31862*/       0, /*End of Scope*/
/*31863*/     /*Scope*/ 95|128,2/*351*/, /*->32216*/
/*31865*/       OPC_CheckChild0Integer, 53|128,39/*5045*/, 
/*31868*/       OPC_RecordChild1, // #0 = $addr
/*31869*/       OPC_Scope, 68, /*->31939*/ // 5 children in Scope
/*31871*/         OPC_CheckChild1Type, MVT::i32,
/*31873*/         OPC_RecordChild2, // #1 = $rsrc
/*31874*/         OPC_RecordChild3, // #2 = $sampler
/*31875*/         OPC_RecordChild4, // #3 = $dmask
/*31876*/         OPC_RecordChild5, // #4 = $unorm
/*31877*/         OPC_RecordChild6, // #5 = $r128
/*31878*/         OPC_RecordChild7, // #6 = $da
/*31879*/         OPC_MoveChild, 8,
/*31881*/         OPC_RecordNode, // #7 = $glc
/*31882*/         OPC_MoveParent,
/*31883*/         OPC_MoveChild, 9,
/*31885*/         OPC_RecordNode, // #8 = $slc
/*31886*/         OPC_MoveParent,
/*31887*/         OPC_MoveChild, 10,
/*31889*/         OPC_RecordNode, // #9 = $tfe
/*31890*/         OPC_MoveParent,
/*31891*/         OPC_MoveChild, 11,
/*31893*/         OPC_RecordNode, // #10 = $lwe
/*31894*/         OPC_MoveParent,
/*31895*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31897*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31900*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31903*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31906*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31909*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31912*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31915*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31918*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31921*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CD_CL_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5045:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CD_CL_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*31939*/       /*Scope*/ 68, /*->32008*/
/*31940*/         OPC_CheckChild1Type, MVT::v2i32,
/*31942*/         OPC_RecordChild2, // #1 = $rsrc
/*31943*/         OPC_RecordChild3, // #2 = $sampler
/*31944*/         OPC_RecordChild4, // #3 = $dmask
/*31945*/         OPC_RecordChild5, // #4 = $unorm
/*31946*/         OPC_RecordChild6, // #5 = $r128
/*31947*/         OPC_RecordChild7, // #6 = $da
/*31948*/         OPC_MoveChild, 8,
/*31950*/         OPC_RecordNode, // #7 = $glc
/*31951*/         OPC_MoveParent,
/*31952*/         OPC_MoveChild, 9,
/*31954*/         OPC_RecordNode, // #8 = $slc
/*31955*/         OPC_MoveParent,
/*31956*/         OPC_MoveChild, 10,
/*31958*/         OPC_RecordNode, // #9 = $tfe
/*31959*/         OPC_MoveParent,
/*31960*/         OPC_MoveChild, 11,
/*31962*/         OPC_RecordNode, // #10 = $lwe
/*31963*/         OPC_MoveParent,
/*31964*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*31966*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*31969*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*31972*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*31975*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*31978*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*31981*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*31984*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*31987*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*31990*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CD_CL_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5045:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CD_CL_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32008*/       /*Scope*/ 68, /*->32077*/
/*32009*/         OPC_CheckChild1Type, MVT::v4i32,
/*32011*/         OPC_RecordChild2, // #1 = $rsrc
/*32012*/         OPC_RecordChild3, // #2 = $sampler
/*32013*/         OPC_RecordChild4, // #3 = $dmask
/*32014*/         OPC_RecordChild5, // #4 = $unorm
/*32015*/         OPC_RecordChild6, // #5 = $r128
/*32016*/         OPC_RecordChild7, // #6 = $da
/*32017*/         OPC_MoveChild, 8,
/*32019*/         OPC_RecordNode, // #7 = $glc
/*32020*/         OPC_MoveParent,
/*32021*/         OPC_MoveChild, 9,
/*32023*/         OPC_RecordNode, // #8 = $slc
/*32024*/         OPC_MoveParent,
/*32025*/         OPC_MoveChild, 10,
/*32027*/         OPC_RecordNode, // #9 = $tfe
/*32028*/         OPC_MoveParent,
/*32029*/         OPC_MoveChild, 11,
/*32031*/         OPC_RecordNode, // #10 = $lwe
/*32032*/         OPC_MoveParent,
/*32033*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32035*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32038*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32041*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32044*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32047*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32050*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32053*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32056*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32059*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CD_CL_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5045:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CD_CL_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32077*/       /*Scope*/ 68, /*->32146*/
/*32078*/         OPC_CheckChild1Type, MVT::v8i32,
/*32080*/         OPC_RecordChild2, // #1 = $rsrc
/*32081*/         OPC_RecordChild3, // #2 = $sampler
/*32082*/         OPC_RecordChild4, // #3 = $dmask
/*32083*/         OPC_RecordChild5, // #4 = $unorm
/*32084*/         OPC_RecordChild6, // #5 = $r128
/*32085*/         OPC_RecordChild7, // #6 = $da
/*32086*/         OPC_MoveChild, 8,
/*32088*/         OPC_RecordNode, // #7 = $glc
/*32089*/         OPC_MoveParent,
/*32090*/         OPC_MoveChild, 9,
/*32092*/         OPC_RecordNode, // #8 = $slc
/*32093*/         OPC_MoveParent,
/*32094*/         OPC_MoveChild, 10,
/*32096*/         OPC_RecordNode, // #9 = $tfe
/*32097*/         OPC_MoveParent,
/*32098*/         OPC_MoveChild, 11,
/*32100*/         OPC_RecordNode, // #10 = $lwe
/*32101*/         OPC_MoveParent,
/*32102*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32104*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32107*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32110*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32113*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32116*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32119*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32122*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32125*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32128*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CD_CL_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5045:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CD_CL_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32146*/       /*Scope*/ 68, /*->32215*/
/*32147*/         OPC_CheckChild1Type, MVT::v16i32,
/*32149*/         OPC_RecordChild2, // #1 = $rsrc
/*32150*/         OPC_RecordChild3, // #2 = $sampler
/*32151*/         OPC_RecordChild4, // #3 = $dmask
/*32152*/         OPC_RecordChild5, // #4 = $unorm
/*32153*/         OPC_RecordChild6, // #5 = $r128
/*32154*/         OPC_RecordChild7, // #6 = $da
/*32155*/         OPC_MoveChild, 8,
/*32157*/         OPC_RecordNode, // #7 = $glc
/*32158*/         OPC_MoveParent,
/*32159*/         OPC_MoveChild, 9,
/*32161*/         OPC_RecordNode, // #8 = $slc
/*32162*/         OPC_MoveParent,
/*32163*/         OPC_MoveChild, 10,
/*32165*/         OPC_RecordNode, // #9 = $tfe
/*32166*/         OPC_MoveParent,
/*32167*/         OPC_MoveChild, 11,
/*32169*/         OPC_RecordNode, // #10 = $lwe
/*32170*/         OPC_MoveParent,
/*32171*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32173*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32176*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32179*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32182*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32185*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32188*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32191*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32194*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32197*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CD_CL_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5045:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CD_CL_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32215*/       0, /*End of Scope*/
/*32216*/     /*Scope*/ 95|128,2/*351*/, /*->32569*/
/*32218*/       OPC_CheckChild0Integer, 81|128,39/*5073*/, 
/*32221*/       OPC_RecordChild1, // #0 = $addr
/*32222*/       OPC_Scope, 68, /*->32292*/ // 5 children in Scope
/*32224*/         OPC_CheckChild1Type, MVT::i32,
/*32226*/         OPC_RecordChild2, // #1 = $rsrc
/*32227*/         OPC_RecordChild3, // #2 = $sampler
/*32228*/         OPC_RecordChild4, // #3 = $dmask
/*32229*/         OPC_RecordChild5, // #4 = $unorm
/*32230*/         OPC_RecordChild6, // #5 = $r128
/*32231*/         OPC_RecordChild7, // #6 = $da
/*32232*/         OPC_MoveChild, 8,
/*32234*/         OPC_RecordNode, // #7 = $glc
/*32235*/         OPC_MoveParent,
/*32236*/         OPC_MoveChild, 9,
/*32238*/         OPC_RecordNode, // #8 = $slc
/*32239*/         OPC_MoveParent,
/*32240*/         OPC_MoveChild, 10,
/*32242*/         OPC_RecordNode, // #9 = $tfe
/*32243*/         OPC_MoveParent,
/*32244*/         OPC_MoveChild, 11,
/*32246*/         OPC_RecordNode, // #10 = $lwe
/*32247*/         OPC_MoveParent,
/*32248*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32250*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32253*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32256*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32259*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32262*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32265*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32268*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32271*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32274*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_O_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5073:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_O_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32292*/       /*Scope*/ 68, /*->32361*/
/*32293*/         OPC_CheckChild1Type, MVT::v2i32,
/*32295*/         OPC_RecordChild2, // #1 = $rsrc
/*32296*/         OPC_RecordChild3, // #2 = $sampler
/*32297*/         OPC_RecordChild4, // #3 = $dmask
/*32298*/         OPC_RecordChild5, // #4 = $unorm
/*32299*/         OPC_RecordChild6, // #5 = $r128
/*32300*/         OPC_RecordChild7, // #6 = $da
/*32301*/         OPC_MoveChild, 8,
/*32303*/         OPC_RecordNode, // #7 = $glc
/*32304*/         OPC_MoveParent,
/*32305*/         OPC_MoveChild, 9,
/*32307*/         OPC_RecordNode, // #8 = $slc
/*32308*/         OPC_MoveParent,
/*32309*/         OPC_MoveChild, 10,
/*32311*/         OPC_RecordNode, // #9 = $tfe
/*32312*/         OPC_MoveParent,
/*32313*/         OPC_MoveChild, 11,
/*32315*/         OPC_RecordNode, // #10 = $lwe
/*32316*/         OPC_MoveParent,
/*32317*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32319*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32322*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32325*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32328*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32331*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32334*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32337*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32340*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32343*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_O_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5073:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_O_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32361*/       /*Scope*/ 68, /*->32430*/
/*32362*/         OPC_CheckChild1Type, MVT::v4i32,
/*32364*/         OPC_RecordChild2, // #1 = $rsrc
/*32365*/         OPC_RecordChild3, // #2 = $sampler
/*32366*/         OPC_RecordChild4, // #3 = $dmask
/*32367*/         OPC_RecordChild5, // #4 = $unorm
/*32368*/         OPC_RecordChild6, // #5 = $r128
/*32369*/         OPC_RecordChild7, // #6 = $da
/*32370*/         OPC_MoveChild, 8,
/*32372*/         OPC_RecordNode, // #7 = $glc
/*32373*/         OPC_MoveParent,
/*32374*/         OPC_MoveChild, 9,
/*32376*/         OPC_RecordNode, // #8 = $slc
/*32377*/         OPC_MoveParent,
/*32378*/         OPC_MoveChild, 10,
/*32380*/         OPC_RecordNode, // #9 = $tfe
/*32381*/         OPC_MoveParent,
/*32382*/         OPC_MoveChild, 11,
/*32384*/         OPC_RecordNode, // #10 = $lwe
/*32385*/         OPC_MoveParent,
/*32386*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32388*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32391*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32394*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32397*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32400*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32403*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32406*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32409*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32412*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_O_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5073:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_O_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32430*/       /*Scope*/ 68, /*->32499*/
/*32431*/         OPC_CheckChild1Type, MVT::v8i32,
/*32433*/         OPC_RecordChild2, // #1 = $rsrc
/*32434*/         OPC_RecordChild3, // #2 = $sampler
/*32435*/         OPC_RecordChild4, // #3 = $dmask
/*32436*/         OPC_RecordChild5, // #4 = $unorm
/*32437*/         OPC_RecordChild6, // #5 = $r128
/*32438*/         OPC_RecordChild7, // #6 = $da
/*32439*/         OPC_MoveChild, 8,
/*32441*/         OPC_RecordNode, // #7 = $glc
/*32442*/         OPC_MoveParent,
/*32443*/         OPC_MoveChild, 9,
/*32445*/         OPC_RecordNode, // #8 = $slc
/*32446*/         OPC_MoveParent,
/*32447*/         OPC_MoveChild, 10,
/*32449*/         OPC_RecordNode, // #9 = $tfe
/*32450*/         OPC_MoveParent,
/*32451*/         OPC_MoveChild, 11,
/*32453*/         OPC_RecordNode, // #10 = $lwe
/*32454*/         OPC_MoveParent,
/*32455*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32457*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32460*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32463*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32466*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32469*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32472*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32475*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32478*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32481*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_O_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5073:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_O_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32499*/       /*Scope*/ 68, /*->32568*/
/*32500*/         OPC_CheckChild1Type, MVT::v16i32,
/*32502*/         OPC_RecordChild2, // #1 = $rsrc
/*32503*/         OPC_RecordChild3, // #2 = $sampler
/*32504*/         OPC_RecordChild4, // #3 = $dmask
/*32505*/         OPC_RecordChild5, // #4 = $unorm
/*32506*/         OPC_RecordChild6, // #5 = $r128
/*32507*/         OPC_RecordChild7, // #6 = $da
/*32508*/         OPC_MoveChild, 8,
/*32510*/         OPC_RecordNode, // #7 = $glc
/*32511*/         OPC_MoveParent,
/*32512*/         OPC_MoveChild, 9,
/*32514*/         OPC_RecordNode, // #8 = $slc
/*32515*/         OPC_MoveParent,
/*32516*/         OPC_MoveChild, 10,
/*32518*/         OPC_RecordNode, // #9 = $tfe
/*32519*/         OPC_MoveParent,
/*32520*/         OPC_MoveChild, 11,
/*32522*/         OPC_RecordNode, // #10 = $lwe
/*32523*/         OPC_MoveParent,
/*32524*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32526*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32529*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32532*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32535*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32538*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32541*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32544*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32547*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32550*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_O_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5073:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_O_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32568*/       0, /*End of Scope*/
/*32569*/     /*Scope*/ 95|128,2/*351*/, /*->32922*/
/*32571*/       OPC_CheckChild0Integer, 72|128,39/*5064*/, 
/*32574*/       OPC_RecordChild1, // #0 = $addr
/*32575*/       OPC_Scope, 68, /*->32645*/ // 5 children in Scope
/*32577*/         OPC_CheckChild1Type, MVT::i32,
/*32579*/         OPC_RecordChild2, // #1 = $rsrc
/*32580*/         OPC_RecordChild3, // #2 = $sampler
/*32581*/         OPC_RecordChild4, // #3 = $dmask
/*32582*/         OPC_RecordChild5, // #4 = $unorm
/*32583*/         OPC_RecordChild6, // #5 = $r128
/*32584*/         OPC_RecordChild7, // #6 = $da
/*32585*/         OPC_MoveChild, 8,
/*32587*/         OPC_RecordNode, // #7 = $glc
/*32588*/         OPC_MoveParent,
/*32589*/         OPC_MoveChild, 9,
/*32591*/         OPC_RecordNode, // #8 = $slc
/*32592*/         OPC_MoveParent,
/*32593*/         OPC_MoveChild, 10,
/*32595*/         OPC_RecordNode, // #9 = $tfe
/*32596*/         OPC_MoveParent,
/*32597*/         OPC_MoveChild, 11,
/*32599*/         OPC_RecordNode, // #10 = $lwe
/*32600*/         OPC_MoveParent,
/*32601*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32603*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32606*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32609*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32612*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32615*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32618*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32621*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32624*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32627*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CL_O_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5064:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CL_O_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32645*/       /*Scope*/ 68, /*->32714*/
/*32646*/         OPC_CheckChild1Type, MVT::v2i32,
/*32648*/         OPC_RecordChild2, // #1 = $rsrc
/*32649*/         OPC_RecordChild3, // #2 = $sampler
/*32650*/         OPC_RecordChild4, // #3 = $dmask
/*32651*/         OPC_RecordChild5, // #4 = $unorm
/*32652*/         OPC_RecordChild6, // #5 = $r128
/*32653*/         OPC_RecordChild7, // #6 = $da
/*32654*/         OPC_MoveChild, 8,
/*32656*/         OPC_RecordNode, // #7 = $glc
/*32657*/         OPC_MoveParent,
/*32658*/         OPC_MoveChild, 9,
/*32660*/         OPC_RecordNode, // #8 = $slc
/*32661*/         OPC_MoveParent,
/*32662*/         OPC_MoveChild, 10,
/*32664*/         OPC_RecordNode, // #9 = $tfe
/*32665*/         OPC_MoveParent,
/*32666*/         OPC_MoveChild, 11,
/*32668*/         OPC_RecordNode, // #10 = $lwe
/*32669*/         OPC_MoveParent,
/*32670*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32672*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32675*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32678*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32681*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32684*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32687*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32690*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32693*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32696*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CL_O_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5064:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CL_O_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32714*/       /*Scope*/ 68, /*->32783*/
/*32715*/         OPC_CheckChild1Type, MVT::v4i32,
/*32717*/         OPC_RecordChild2, // #1 = $rsrc
/*32718*/         OPC_RecordChild3, // #2 = $sampler
/*32719*/         OPC_RecordChild4, // #3 = $dmask
/*32720*/         OPC_RecordChild5, // #4 = $unorm
/*32721*/         OPC_RecordChild6, // #5 = $r128
/*32722*/         OPC_RecordChild7, // #6 = $da
/*32723*/         OPC_MoveChild, 8,
/*32725*/         OPC_RecordNode, // #7 = $glc
/*32726*/         OPC_MoveParent,
/*32727*/         OPC_MoveChild, 9,
/*32729*/         OPC_RecordNode, // #8 = $slc
/*32730*/         OPC_MoveParent,
/*32731*/         OPC_MoveChild, 10,
/*32733*/         OPC_RecordNode, // #9 = $tfe
/*32734*/         OPC_MoveParent,
/*32735*/         OPC_MoveChild, 11,
/*32737*/         OPC_RecordNode, // #10 = $lwe
/*32738*/         OPC_MoveParent,
/*32739*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32741*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32744*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32747*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32750*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32753*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32756*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32759*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32762*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32765*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CL_O_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5064:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CL_O_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32783*/       /*Scope*/ 68, /*->32852*/
/*32784*/         OPC_CheckChild1Type, MVT::v8i32,
/*32786*/         OPC_RecordChild2, // #1 = $rsrc
/*32787*/         OPC_RecordChild3, // #2 = $sampler
/*32788*/         OPC_RecordChild4, // #3 = $dmask
/*32789*/         OPC_RecordChild5, // #4 = $unorm
/*32790*/         OPC_RecordChild6, // #5 = $r128
/*32791*/         OPC_RecordChild7, // #6 = $da
/*32792*/         OPC_MoveChild, 8,
/*32794*/         OPC_RecordNode, // #7 = $glc
/*32795*/         OPC_MoveParent,
/*32796*/         OPC_MoveChild, 9,
/*32798*/         OPC_RecordNode, // #8 = $slc
/*32799*/         OPC_MoveParent,
/*32800*/         OPC_MoveChild, 10,
/*32802*/         OPC_RecordNode, // #9 = $tfe
/*32803*/         OPC_MoveParent,
/*32804*/         OPC_MoveChild, 11,
/*32806*/         OPC_RecordNode, // #10 = $lwe
/*32807*/         OPC_MoveParent,
/*32808*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32810*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32813*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32816*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32819*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32822*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32825*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32828*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32831*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32834*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CL_O_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5064:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CL_O_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32852*/       /*Scope*/ 68, /*->32921*/
/*32853*/         OPC_CheckChild1Type, MVT::v16i32,
/*32855*/         OPC_RecordChild2, // #1 = $rsrc
/*32856*/         OPC_RecordChild3, // #2 = $sampler
/*32857*/         OPC_RecordChild4, // #3 = $dmask
/*32858*/         OPC_RecordChild5, // #4 = $unorm
/*32859*/         OPC_RecordChild6, // #5 = $r128
/*32860*/         OPC_RecordChild7, // #6 = $da
/*32861*/         OPC_MoveChild, 8,
/*32863*/         OPC_RecordNode, // #7 = $glc
/*32864*/         OPC_MoveParent,
/*32865*/         OPC_MoveChild, 9,
/*32867*/         OPC_RecordNode, // #8 = $slc
/*32868*/         OPC_MoveParent,
/*32869*/         OPC_MoveChild, 10,
/*32871*/         OPC_RecordNode, // #9 = $tfe
/*32872*/         OPC_MoveParent,
/*32873*/         OPC_MoveChild, 11,
/*32875*/         OPC_RecordNode, // #10 = $lwe
/*32876*/         OPC_MoveParent,
/*32877*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32879*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32882*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32885*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32888*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32891*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32894*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32897*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32900*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32903*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CL_O_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5064:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CL_O_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32921*/       0, /*End of Scope*/
/*32922*/     /*Scope*/ 95|128,2/*351*/, /*->33275*/
/*32924*/       OPC_CheckChild0Integer, 76|128,39/*5068*/, 
/*32927*/       OPC_RecordChild1, // #0 = $addr
/*32928*/       OPC_Scope, 68, /*->32998*/ // 5 children in Scope
/*32930*/         OPC_CheckChild1Type, MVT::i32,
/*32932*/         OPC_RecordChild2, // #1 = $rsrc
/*32933*/         OPC_RecordChild3, // #2 = $sampler
/*32934*/         OPC_RecordChild4, // #3 = $dmask
/*32935*/         OPC_RecordChild5, // #4 = $unorm
/*32936*/         OPC_RecordChild6, // #5 = $r128
/*32937*/         OPC_RecordChild7, // #6 = $da
/*32938*/         OPC_MoveChild, 8,
/*32940*/         OPC_RecordNode, // #7 = $glc
/*32941*/         OPC_MoveParent,
/*32942*/         OPC_MoveChild, 9,
/*32944*/         OPC_RecordNode, // #8 = $slc
/*32945*/         OPC_MoveParent,
/*32946*/         OPC_MoveChild, 10,
/*32948*/         OPC_RecordNode, // #9 = $tfe
/*32949*/         OPC_MoveParent,
/*32950*/         OPC_MoveChild, 11,
/*32952*/         OPC_RecordNode, // #10 = $lwe
/*32953*/         OPC_MoveParent,
/*32954*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*32956*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*32959*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*32962*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*32965*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*32968*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*32971*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*32974*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*32977*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*32980*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_O_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5068:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_O_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*32998*/       /*Scope*/ 68, /*->33067*/
/*32999*/         OPC_CheckChild1Type, MVT::v2i32,
/*33001*/         OPC_RecordChild2, // #1 = $rsrc
/*33002*/         OPC_RecordChild3, // #2 = $sampler
/*33003*/         OPC_RecordChild4, // #3 = $dmask
/*33004*/         OPC_RecordChild5, // #4 = $unorm
/*33005*/         OPC_RecordChild6, // #5 = $r128
/*33006*/         OPC_RecordChild7, // #6 = $da
/*33007*/         OPC_MoveChild, 8,
/*33009*/         OPC_RecordNode, // #7 = $glc
/*33010*/         OPC_MoveParent,
/*33011*/         OPC_MoveChild, 9,
/*33013*/         OPC_RecordNode, // #8 = $slc
/*33014*/         OPC_MoveParent,
/*33015*/         OPC_MoveChild, 10,
/*33017*/         OPC_RecordNode, // #9 = $tfe
/*33018*/         OPC_MoveParent,
/*33019*/         OPC_MoveChild, 11,
/*33021*/         OPC_RecordNode, // #10 = $lwe
/*33022*/         OPC_MoveParent,
/*33023*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33025*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33028*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33031*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33034*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33037*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33040*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33043*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33046*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33049*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_O_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5068:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_O_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33067*/       /*Scope*/ 68, /*->33136*/
/*33068*/         OPC_CheckChild1Type, MVT::v4i32,
/*33070*/         OPC_RecordChild2, // #1 = $rsrc
/*33071*/         OPC_RecordChild3, // #2 = $sampler
/*33072*/         OPC_RecordChild4, // #3 = $dmask
/*33073*/         OPC_RecordChild5, // #4 = $unorm
/*33074*/         OPC_RecordChild6, // #5 = $r128
/*33075*/         OPC_RecordChild7, // #6 = $da
/*33076*/         OPC_MoveChild, 8,
/*33078*/         OPC_RecordNode, // #7 = $glc
/*33079*/         OPC_MoveParent,
/*33080*/         OPC_MoveChild, 9,
/*33082*/         OPC_RecordNode, // #8 = $slc
/*33083*/         OPC_MoveParent,
/*33084*/         OPC_MoveChild, 10,
/*33086*/         OPC_RecordNode, // #9 = $tfe
/*33087*/         OPC_MoveParent,
/*33088*/         OPC_MoveChild, 11,
/*33090*/         OPC_RecordNode, // #10 = $lwe
/*33091*/         OPC_MoveParent,
/*33092*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33094*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33097*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33100*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33103*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33106*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33109*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33112*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33115*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33118*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_O_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5068:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_O_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33136*/       /*Scope*/ 68, /*->33205*/
/*33137*/         OPC_CheckChild1Type, MVT::v8i32,
/*33139*/         OPC_RecordChild2, // #1 = $rsrc
/*33140*/         OPC_RecordChild3, // #2 = $sampler
/*33141*/         OPC_RecordChild4, // #3 = $dmask
/*33142*/         OPC_RecordChild5, // #4 = $unorm
/*33143*/         OPC_RecordChild6, // #5 = $r128
/*33144*/         OPC_RecordChild7, // #6 = $da
/*33145*/         OPC_MoveChild, 8,
/*33147*/         OPC_RecordNode, // #7 = $glc
/*33148*/         OPC_MoveParent,
/*33149*/         OPC_MoveChild, 9,
/*33151*/         OPC_RecordNode, // #8 = $slc
/*33152*/         OPC_MoveParent,
/*33153*/         OPC_MoveChild, 10,
/*33155*/         OPC_RecordNode, // #9 = $tfe
/*33156*/         OPC_MoveParent,
/*33157*/         OPC_MoveChild, 11,
/*33159*/         OPC_RecordNode, // #10 = $lwe
/*33160*/         OPC_MoveParent,
/*33161*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33163*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33166*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33169*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33172*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33175*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33178*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33181*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33184*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33187*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_O_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5068:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_O_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33205*/       /*Scope*/ 68, /*->33274*/
/*33206*/         OPC_CheckChild1Type, MVT::v16i32,
/*33208*/         OPC_RecordChild2, // #1 = $rsrc
/*33209*/         OPC_RecordChild3, // #2 = $sampler
/*33210*/         OPC_RecordChild4, // #3 = $dmask
/*33211*/         OPC_RecordChild5, // #4 = $unorm
/*33212*/         OPC_RecordChild6, // #5 = $r128
/*33213*/         OPC_RecordChild7, // #6 = $da
/*33214*/         OPC_MoveChild, 8,
/*33216*/         OPC_RecordNode, // #7 = $glc
/*33217*/         OPC_MoveParent,
/*33218*/         OPC_MoveChild, 9,
/*33220*/         OPC_RecordNode, // #8 = $slc
/*33221*/         OPC_MoveParent,
/*33222*/         OPC_MoveChild, 10,
/*33224*/         OPC_RecordNode, // #9 = $tfe
/*33225*/         OPC_MoveParent,
/*33226*/         OPC_MoveChild, 11,
/*33228*/         OPC_RecordNode, // #10 = $lwe
/*33229*/         OPC_MoveParent,
/*33230*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33232*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33235*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33238*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33241*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33244*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33247*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33250*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33253*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33256*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_O_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5068:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_O_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33274*/       0, /*End of Scope*/
/*33275*/     /*Scope*/ 95|128,2/*351*/, /*->33628*/
/*33277*/       OPC_CheckChild0Integer, 75|128,39/*5067*/, 
/*33280*/       OPC_RecordChild1, // #0 = $addr
/*33281*/       OPC_Scope, 68, /*->33351*/ // 5 children in Scope
/*33283*/         OPC_CheckChild1Type, MVT::i32,
/*33285*/         OPC_RecordChild2, // #1 = $rsrc
/*33286*/         OPC_RecordChild3, // #2 = $sampler
/*33287*/         OPC_RecordChild4, // #3 = $dmask
/*33288*/         OPC_RecordChild5, // #4 = $unorm
/*33289*/         OPC_RecordChild6, // #5 = $r128
/*33290*/         OPC_RecordChild7, // #6 = $da
/*33291*/         OPC_MoveChild, 8,
/*33293*/         OPC_RecordNode, // #7 = $glc
/*33294*/         OPC_MoveParent,
/*33295*/         OPC_MoveChild, 9,
/*33297*/         OPC_RecordNode, // #8 = $slc
/*33298*/         OPC_MoveParent,
/*33299*/         OPC_MoveChild, 10,
/*33301*/         OPC_RecordNode, // #9 = $tfe
/*33302*/         OPC_MoveParent,
/*33303*/         OPC_MoveChild, 11,
/*33305*/         OPC_RecordNode, // #10 = $lwe
/*33306*/         OPC_MoveParent,
/*33307*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33309*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33312*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33315*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33318*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33321*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33324*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33327*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33330*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33333*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_CL_O_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5067:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_CL_O_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33351*/       /*Scope*/ 68, /*->33420*/
/*33352*/         OPC_CheckChild1Type, MVT::v2i32,
/*33354*/         OPC_RecordChild2, // #1 = $rsrc
/*33355*/         OPC_RecordChild3, // #2 = $sampler
/*33356*/         OPC_RecordChild4, // #3 = $dmask
/*33357*/         OPC_RecordChild5, // #4 = $unorm
/*33358*/         OPC_RecordChild6, // #5 = $r128
/*33359*/         OPC_RecordChild7, // #6 = $da
/*33360*/         OPC_MoveChild, 8,
/*33362*/         OPC_RecordNode, // #7 = $glc
/*33363*/         OPC_MoveParent,
/*33364*/         OPC_MoveChild, 9,
/*33366*/         OPC_RecordNode, // #8 = $slc
/*33367*/         OPC_MoveParent,
/*33368*/         OPC_MoveChild, 10,
/*33370*/         OPC_RecordNode, // #9 = $tfe
/*33371*/         OPC_MoveParent,
/*33372*/         OPC_MoveChild, 11,
/*33374*/         OPC_RecordNode, // #10 = $lwe
/*33375*/         OPC_MoveParent,
/*33376*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33378*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33381*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33384*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33387*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33390*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33393*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33396*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33399*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33402*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_CL_O_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5067:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_CL_O_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33420*/       /*Scope*/ 68, /*->33489*/
/*33421*/         OPC_CheckChild1Type, MVT::v4i32,
/*33423*/         OPC_RecordChild2, // #1 = $rsrc
/*33424*/         OPC_RecordChild3, // #2 = $sampler
/*33425*/         OPC_RecordChild4, // #3 = $dmask
/*33426*/         OPC_RecordChild5, // #4 = $unorm
/*33427*/         OPC_RecordChild6, // #5 = $r128
/*33428*/         OPC_RecordChild7, // #6 = $da
/*33429*/         OPC_MoveChild, 8,
/*33431*/         OPC_RecordNode, // #7 = $glc
/*33432*/         OPC_MoveParent,
/*33433*/         OPC_MoveChild, 9,
/*33435*/         OPC_RecordNode, // #8 = $slc
/*33436*/         OPC_MoveParent,
/*33437*/         OPC_MoveChild, 10,
/*33439*/         OPC_RecordNode, // #9 = $tfe
/*33440*/         OPC_MoveParent,
/*33441*/         OPC_MoveChild, 11,
/*33443*/         OPC_RecordNode, // #10 = $lwe
/*33444*/         OPC_MoveParent,
/*33445*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33447*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33450*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33453*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33456*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33459*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33462*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33465*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33468*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33471*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_CL_O_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5067:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_CL_O_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33489*/       /*Scope*/ 68, /*->33558*/
/*33490*/         OPC_CheckChild1Type, MVT::v8i32,
/*33492*/         OPC_RecordChild2, // #1 = $rsrc
/*33493*/         OPC_RecordChild3, // #2 = $sampler
/*33494*/         OPC_RecordChild4, // #3 = $dmask
/*33495*/         OPC_RecordChild5, // #4 = $unorm
/*33496*/         OPC_RecordChild6, // #5 = $r128
/*33497*/         OPC_RecordChild7, // #6 = $da
/*33498*/         OPC_MoveChild, 8,
/*33500*/         OPC_RecordNode, // #7 = $glc
/*33501*/         OPC_MoveParent,
/*33502*/         OPC_MoveChild, 9,
/*33504*/         OPC_RecordNode, // #8 = $slc
/*33505*/         OPC_MoveParent,
/*33506*/         OPC_MoveChild, 10,
/*33508*/         OPC_RecordNode, // #9 = $tfe
/*33509*/         OPC_MoveParent,
/*33510*/         OPC_MoveChild, 11,
/*33512*/         OPC_RecordNode, // #10 = $lwe
/*33513*/         OPC_MoveParent,
/*33514*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33516*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33519*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33522*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33525*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33528*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33531*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33534*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33537*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33540*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_CL_O_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5067:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_CL_O_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33558*/       /*Scope*/ 68, /*->33627*/
/*33559*/         OPC_CheckChild1Type, MVT::v16i32,
/*33561*/         OPC_RecordChild2, // #1 = $rsrc
/*33562*/         OPC_RecordChild3, // #2 = $sampler
/*33563*/         OPC_RecordChild4, // #3 = $dmask
/*33564*/         OPC_RecordChild5, // #4 = $unorm
/*33565*/         OPC_RecordChild6, // #5 = $r128
/*33566*/         OPC_RecordChild7, // #6 = $da
/*33567*/         OPC_MoveChild, 8,
/*33569*/         OPC_RecordNode, // #7 = $glc
/*33570*/         OPC_MoveParent,
/*33571*/         OPC_MoveChild, 9,
/*33573*/         OPC_RecordNode, // #8 = $slc
/*33574*/         OPC_MoveParent,
/*33575*/         OPC_MoveChild, 10,
/*33577*/         OPC_RecordNode, // #9 = $tfe
/*33578*/         OPC_MoveParent,
/*33579*/         OPC_MoveChild, 11,
/*33581*/         OPC_RecordNode, // #10 = $lwe
/*33582*/         OPC_MoveParent,
/*33583*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33585*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33588*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33591*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33594*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33597*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33600*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33603*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33606*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33609*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_D_CL_O_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5067:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_D_CL_O_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33627*/       0, /*End of Scope*/
/*33628*/     /*Scope*/ 95|128,2/*351*/, /*->33981*/
/*33630*/       OPC_CheckChild0Integer, 78|128,39/*5070*/, 
/*33633*/       OPC_RecordChild1, // #0 = $addr
/*33634*/       OPC_Scope, 68, /*->33704*/ // 5 children in Scope
/*33636*/         OPC_CheckChild1Type, MVT::i32,
/*33638*/         OPC_RecordChild2, // #1 = $rsrc
/*33639*/         OPC_RecordChild3, // #2 = $sampler
/*33640*/         OPC_RecordChild4, // #3 = $dmask
/*33641*/         OPC_RecordChild5, // #4 = $unorm
/*33642*/         OPC_RecordChild6, // #5 = $r128
/*33643*/         OPC_RecordChild7, // #6 = $da
/*33644*/         OPC_MoveChild, 8,
/*33646*/         OPC_RecordNode, // #7 = $glc
/*33647*/         OPC_MoveParent,
/*33648*/         OPC_MoveChild, 9,
/*33650*/         OPC_RecordNode, // #8 = $slc
/*33651*/         OPC_MoveParent,
/*33652*/         OPC_MoveChild, 10,
/*33654*/         OPC_RecordNode, // #9 = $tfe
/*33655*/         OPC_MoveParent,
/*33656*/         OPC_MoveChild, 11,
/*33658*/         OPC_RecordNode, // #10 = $lwe
/*33659*/         OPC_MoveParent,
/*33660*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33662*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33665*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33668*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33671*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33674*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33677*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33680*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33683*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33686*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_L_O_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5070:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_L_O_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33704*/       /*Scope*/ 68, /*->33773*/
/*33705*/         OPC_CheckChild1Type, MVT::v2i32,
/*33707*/         OPC_RecordChild2, // #1 = $rsrc
/*33708*/         OPC_RecordChild3, // #2 = $sampler
/*33709*/         OPC_RecordChild4, // #3 = $dmask
/*33710*/         OPC_RecordChild5, // #4 = $unorm
/*33711*/         OPC_RecordChild6, // #5 = $r128
/*33712*/         OPC_RecordChild7, // #6 = $da
/*33713*/         OPC_MoveChild, 8,
/*33715*/         OPC_RecordNode, // #7 = $glc
/*33716*/         OPC_MoveParent,
/*33717*/         OPC_MoveChild, 9,
/*33719*/         OPC_RecordNode, // #8 = $slc
/*33720*/         OPC_MoveParent,
/*33721*/         OPC_MoveChild, 10,
/*33723*/         OPC_RecordNode, // #9 = $tfe
/*33724*/         OPC_MoveParent,
/*33725*/         OPC_MoveChild, 11,
/*33727*/         OPC_RecordNode, // #10 = $lwe
/*33728*/         OPC_MoveParent,
/*33729*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33731*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33734*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33737*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33740*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33743*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33746*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33749*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33752*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33755*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_L_O_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5070:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_L_O_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33773*/       /*Scope*/ 68, /*->33842*/
/*33774*/         OPC_CheckChild1Type, MVT::v4i32,
/*33776*/         OPC_RecordChild2, // #1 = $rsrc
/*33777*/         OPC_RecordChild3, // #2 = $sampler
/*33778*/         OPC_RecordChild4, // #3 = $dmask
/*33779*/         OPC_RecordChild5, // #4 = $unorm
/*33780*/         OPC_RecordChild6, // #5 = $r128
/*33781*/         OPC_RecordChild7, // #6 = $da
/*33782*/         OPC_MoveChild, 8,
/*33784*/         OPC_RecordNode, // #7 = $glc
/*33785*/         OPC_MoveParent,
/*33786*/         OPC_MoveChild, 9,
/*33788*/         OPC_RecordNode, // #8 = $slc
/*33789*/         OPC_MoveParent,
/*33790*/         OPC_MoveChild, 10,
/*33792*/         OPC_RecordNode, // #9 = $tfe
/*33793*/         OPC_MoveParent,
/*33794*/         OPC_MoveChild, 11,
/*33796*/         OPC_RecordNode, // #10 = $lwe
/*33797*/         OPC_MoveParent,
/*33798*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33800*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33803*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33806*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33809*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33812*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33815*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33818*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33821*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33824*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_L_O_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5070:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_L_O_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33842*/       /*Scope*/ 68, /*->33911*/
/*33843*/         OPC_CheckChild1Type, MVT::v8i32,
/*33845*/         OPC_RecordChild2, // #1 = $rsrc
/*33846*/         OPC_RecordChild3, // #2 = $sampler
/*33847*/         OPC_RecordChild4, // #3 = $dmask
/*33848*/         OPC_RecordChild5, // #4 = $unorm
/*33849*/         OPC_RecordChild6, // #5 = $r128
/*33850*/         OPC_RecordChild7, // #6 = $da
/*33851*/         OPC_MoveChild, 8,
/*33853*/         OPC_RecordNode, // #7 = $glc
/*33854*/         OPC_MoveParent,
/*33855*/         OPC_MoveChild, 9,
/*33857*/         OPC_RecordNode, // #8 = $slc
/*33858*/         OPC_MoveParent,
/*33859*/         OPC_MoveChild, 10,
/*33861*/         OPC_RecordNode, // #9 = $tfe
/*33862*/         OPC_MoveParent,
/*33863*/         OPC_MoveChild, 11,
/*33865*/         OPC_RecordNode, // #10 = $lwe
/*33866*/         OPC_MoveParent,
/*33867*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33869*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33872*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33875*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33878*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33881*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33884*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33887*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33890*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33893*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_L_O_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5070:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_L_O_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33911*/       /*Scope*/ 68, /*->33980*/
/*33912*/         OPC_CheckChild1Type, MVT::v16i32,
/*33914*/         OPC_RecordChild2, // #1 = $rsrc
/*33915*/         OPC_RecordChild3, // #2 = $sampler
/*33916*/         OPC_RecordChild4, // #3 = $dmask
/*33917*/         OPC_RecordChild5, // #4 = $unorm
/*33918*/         OPC_RecordChild6, // #5 = $r128
/*33919*/         OPC_RecordChild7, // #6 = $da
/*33920*/         OPC_MoveChild, 8,
/*33922*/         OPC_RecordNode, // #7 = $glc
/*33923*/         OPC_MoveParent,
/*33924*/         OPC_MoveChild, 9,
/*33926*/         OPC_RecordNode, // #8 = $slc
/*33927*/         OPC_MoveParent,
/*33928*/         OPC_MoveChild, 10,
/*33930*/         OPC_RecordNode, // #9 = $tfe
/*33931*/         OPC_MoveParent,
/*33932*/         OPC_MoveChild, 11,
/*33934*/         OPC_RecordNode, // #10 = $lwe
/*33935*/         OPC_MoveParent,
/*33936*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*33938*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*33941*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*33944*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*33947*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*33950*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*33953*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*33956*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*33959*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*33962*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_L_O_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5070:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_L_O_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*33980*/       0, /*End of Scope*/
/*33981*/     /*Scope*/ 95|128,2/*351*/, /*->34334*/
/*33983*/       OPC_CheckChild0Integer, 46|128,39/*5038*/, 
/*33986*/       OPC_RecordChild1, // #0 = $addr
/*33987*/       OPC_Scope, 68, /*->34057*/ // 5 children in Scope
/*33989*/         OPC_CheckChild1Type, MVT::i32,
/*33991*/         OPC_RecordChild2, // #1 = $rsrc
/*33992*/         OPC_RecordChild3, // #2 = $sampler
/*33993*/         OPC_RecordChild4, // #3 = $dmask
/*33994*/         OPC_RecordChild5, // #4 = $unorm
/*33995*/         OPC_RecordChild6, // #5 = $r128
/*33996*/         OPC_RecordChild7, // #6 = $da
/*33997*/         OPC_MoveChild, 8,
/*33999*/         OPC_RecordNode, // #7 = $glc
/*34000*/         OPC_MoveParent,
/*34001*/         OPC_MoveChild, 9,
/*34003*/         OPC_RecordNode, // #8 = $slc
/*34004*/         OPC_MoveParent,
/*34005*/         OPC_MoveChild, 10,
/*34007*/         OPC_RecordNode, // #9 = $tfe
/*34008*/         OPC_MoveParent,
/*34009*/         OPC_MoveChild, 11,
/*34011*/         OPC_RecordNode, // #10 = $lwe
/*34012*/         OPC_MoveParent,
/*34013*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34015*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34018*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34021*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34024*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34027*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34030*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34033*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34036*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34039*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_O_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5038:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_O_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34057*/       /*Scope*/ 68, /*->34126*/
/*34058*/         OPC_CheckChild1Type, MVT::v2i32,
/*34060*/         OPC_RecordChild2, // #1 = $rsrc
/*34061*/         OPC_RecordChild3, // #2 = $sampler
/*34062*/         OPC_RecordChild4, // #3 = $dmask
/*34063*/         OPC_RecordChild5, // #4 = $unorm
/*34064*/         OPC_RecordChild6, // #5 = $r128
/*34065*/         OPC_RecordChild7, // #6 = $da
/*34066*/         OPC_MoveChild, 8,
/*34068*/         OPC_RecordNode, // #7 = $glc
/*34069*/         OPC_MoveParent,
/*34070*/         OPC_MoveChild, 9,
/*34072*/         OPC_RecordNode, // #8 = $slc
/*34073*/         OPC_MoveParent,
/*34074*/         OPC_MoveChild, 10,
/*34076*/         OPC_RecordNode, // #9 = $tfe
/*34077*/         OPC_MoveParent,
/*34078*/         OPC_MoveChild, 11,
/*34080*/         OPC_RecordNode, // #10 = $lwe
/*34081*/         OPC_MoveParent,
/*34082*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34084*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34087*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34090*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34093*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34096*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34099*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34102*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34105*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34108*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_O_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5038:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_O_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34126*/       /*Scope*/ 68, /*->34195*/
/*34127*/         OPC_CheckChild1Type, MVT::v4i32,
/*34129*/         OPC_RecordChild2, // #1 = $rsrc
/*34130*/         OPC_RecordChild3, // #2 = $sampler
/*34131*/         OPC_RecordChild4, // #3 = $dmask
/*34132*/         OPC_RecordChild5, // #4 = $unorm
/*34133*/         OPC_RecordChild6, // #5 = $r128
/*34134*/         OPC_RecordChild7, // #6 = $da
/*34135*/         OPC_MoveChild, 8,
/*34137*/         OPC_RecordNode, // #7 = $glc
/*34138*/         OPC_MoveParent,
/*34139*/         OPC_MoveChild, 9,
/*34141*/         OPC_RecordNode, // #8 = $slc
/*34142*/         OPC_MoveParent,
/*34143*/         OPC_MoveChild, 10,
/*34145*/         OPC_RecordNode, // #9 = $tfe
/*34146*/         OPC_MoveParent,
/*34147*/         OPC_MoveChild, 11,
/*34149*/         OPC_RecordNode, // #10 = $lwe
/*34150*/         OPC_MoveParent,
/*34151*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34153*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34156*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34159*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34162*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34165*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34168*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34171*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34174*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34177*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_O_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5038:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_O_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34195*/       /*Scope*/ 68, /*->34264*/
/*34196*/         OPC_CheckChild1Type, MVT::v8i32,
/*34198*/         OPC_RecordChild2, // #1 = $rsrc
/*34199*/         OPC_RecordChild3, // #2 = $sampler
/*34200*/         OPC_RecordChild4, // #3 = $dmask
/*34201*/         OPC_RecordChild5, // #4 = $unorm
/*34202*/         OPC_RecordChild6, // #5 = $r128
/*34203*/         OPC_RecordChild7, // #6 = $da
/*34204*/         OPC_MoveChild, 8,
/*34206*/         OPC_RecordNode, // #7 = $glc
/*34207*/         OPC_MoveParent,
/*34208*/         OPC_MoveChild, 9,
/*34210*/         OPC_RecordNode, // #8 = $slc
/*34211*/         OPC_MoveParent,
/*34212*/         OPC_MoveChild, 10,
/*34214*/         OPC_RecordNode, // #9 = $tfe
/*34215*/         OPC_MoveParent,
/*34216*/         OPC_MoveChild, 11,
/*34218*/         OPC_RecordNode, // #10 = $lwe
/*34219*/         OPC_MoveParent,
/*34220*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34222*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34225*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34228*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34231*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34234*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34237*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34240*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34243*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34246*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_O_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5038:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_O_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34264*/       /*Scope*/ 68, /*->34333*/
/*34265*/         OPC_CheckChild1Type, MVT::v16i32,
/*34267*/         OPC_RecordChild2, // #1 = $rsrc
/*34268*/         OPC_RecordChild3, // #2 = $sampler
/*34269*/         OPC_RecordChild4, // #3 = $dmask
/*34270*/         OPC_RecordChild5, // #4 = $unorm
/*34271*/         OPC_RecordChild6, // #5 = $r128
/*34272*/         OPC_RecordChild7, // #6 = $da
/*34273*/         OPC_MoveChild, 8,
/*34275*/         OPC_RecordNode, // #7 = $glc
/*34276*/         OPC_MoveParent,
/*34277*/         OPC_MoveChild, 9,
/*34279*/         OPC_RecordNode, // #8 = $slc
/*34280*/         OPC_MoveParent,
/*34281*/         OPC_MoveChild, 10,
/*34283*/         OPC_RecordNode, // #9 = $tfe
/*34284*/         OPC_MoveParent,
/*34285*/         OPC_MoveChild, 11,
/*34287*/         OPC_RecordNode, // #10 = $lwe
/*34288*/         OPC_MoveParent,
/*34289*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34291*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34294*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34297*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34300*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34303*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34306*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34309*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34312*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34315*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_O_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5038:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_O_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34333*/       0, /*End of Scope*/
/*34334*/     /*Scope*/ 95|128,2/*351*/, /*->34687*/
/*34336*/       OPC_CheckChild0Integer, 45|128,39/*5037*/, 
/*34339*/       OPC_RecordChild1, // #0 = $addr
/*34340*/       OPC_Scope, 68, /*->34410*/ // 5 children in Scope
/*34342*/         OPC_CheckChild1Type, MVT::i32,
/*34344*/         OPC_RecordChild2, // #1 = $rsrc
/*34345*/         OPC_RecordChild3, // #2 = $sampler
/*34346*/         OPC_RecordChild4, // #3 = $dmask
/*34347*/         OPC_RecordChild5, // #4 = $unorm
/*34348*/         OPC_RecordChild6, // #5 = $r128
/*34349*/         OPC_RecordChild7, // #6 = $da
/*34350*/         OPC_MoveChild, 8,
/*34352*/         OPC_RecordNode, // #7 = $glc
/*34353*/         OPC_MoveParent,
/*34354*/         OPC_MoveChild, 9,
/*34356*/         OPC_RecordNode, // #8 = $slc
/*34357*/         OPC_MoveParent,
/*34358*/         OPC_MoveChild, 10,
/*34360*/         OPC_RecordNode, // #9 = $tfe
/*34361*/         OPC_MoveParent,
/*34362*/         OPC_MoveChild, 11,
/*34364*/         OPC_RecordNode, // #10 = $lwe
/*34365*/         OPC_MoveParent,
/*34366*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34368*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34371*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34374*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34377*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34380*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34383*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34386*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34389*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34392*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_CL_O_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5037:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_CL_O_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34410*/       /*Scope*/ 68, /*->34479*/
/*34411*/         OPC_CheckChild1Type, MVT::v2i32,
/*34413*/         OPC_RecordChild2, // #1 = $rsrc
/*34414*/         OPC_RecordChild3, // #2 = $sampler
/*34415*/         OPC_RecordChild4, // #3 = $dmask
/*34416*/         OPC_RecordChild5, // #4 = $unorm
/*34417*/         OPC_RecordChild6, // #5 = $r128
/*34418*/         OPC_RecordChild7, // #6 = $da
/*34419*/         OPC_MoveChild, 8,
/*34421*/         OPC_RecordNode, // #7 = $glc
/*34422*/         OPC_MoveParent,
/*34423*/         OPC_MoveChild, 9,
/*34425*/         OPC_RecordNode, // #8 = $slc
/*34426*/         OPC_MoveParent,
/*34427*/         OPC_MoveChild, 10,
/*34429*/         OPC_RecordNode, // #9 = $tfe
/*34430*/         OPC_MoveParent,
/*34431*/         OPC_MoveChild, 11,
/*34433*/         OPC_RecordNode, // #10 = $lwe
/*34434*/         OPC_MoveParent,
/*34435*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34437*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34440*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34443*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34446*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34449*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34452*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34455*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34458*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34461*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_CL_O_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5037:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_CL_O_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34479*/       /*Scope*/ 68, /*->34548*/
/*34480*/         OPC_CheckChild1Type, MVT::v4i32,
/*34482*/         OPC_RecordChild2, // #1 = $rsrc
/*34483*/         OPC_RecordChild3, // #2 = $sampler
/*34484*/         OPC_RecordChild4, // #3 = $dmask
/*34485*/         OPC_RecordChild5, // #4 = $unorm
/*34486*/         OPC_RecordChild6, // #5 = $r128
/*34487*/         OPC_RecordChild7, // #6 = $da
/*34488*/         OPC_MoveChild, 8,
/*34490*/         OPC_RecordNode, // #7 = $glc
/*34491*/         OPC_MoveParent,
/*34492*/         OPC_MoveChild, 9,
/*34494*/         OPC_RecordNode, // #8 = $slc
/*34495*/         OPC_MoveParent,
/*34496*/         OPC_MoveChild, 10,
/*34498*/         OPC_RecordNode, // #9 = $tfe
/*34499*/         OPC_MoveParent,
/*34500*/         OPC_MoveChild, 11,
/*34502*/         OPC_RecordNode, // #10 = $lwe
/*34503*/         OPC_MoveParent,
/*34504*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34506*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34509*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34512*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34515*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34518*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34521*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34524*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34527*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34530*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_CL_O_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5037:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_CL_O_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34548*/       /*Scope*/ 68, /*->34617*/
/*34549*/         OPC_CheckChild1Type, MVT::v8i32,
/*34551*/         OPC_RecordChild2, // #1 = $rsrc
/*34552*/         OPC_RecordChild3, // #2 = $sampler
/*34553*/         OPC_RecordChild4, // #3 = $dmask
/*34554*/         OPC_RecordChild5, // #4 = $unorm
/*34555*/         OPC_RecordChild6, // #5 = $r128
/*34556*/         OPC_RecordChild7, // #6 = $da
/*34557*/         OPC_MoveChild, 8,
/*34559*/         OPC_RecordNode, // #7 = $glc
/*34560*/         OPC_MoveParent,
/*34561*/         OPC_MoveChild, 9,
/*34563*/         OPC_RecordNode, // #8 = $slc
/*34564*/         OPC_MoveParent,
/*34565*/         OPC_MoveChild, 10,
/*34567*/         OPC_RecordNode, // #9 = $tfe
/*34568*/         OPC_MoveParent,
/*34569*/         OPC_MoveChild, 11,
/*34571*/         OPC_RecordNode, // #10 = $lwe
/*34572*/         OPC_MoveParent,
/*34573*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34575*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34578*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34581*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34584*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34587*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34590*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34593*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34596*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34599*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_CL_O_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5037:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_CL_O_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34617*/       /*Scope*/ 68, /*->34686*/
/*34618*/         OPC_CheckChild1Type, MVT::v16i32,
/*34620*/         OPC_RecordChild2, // #1 = $rsrc
/*34621*/         OPC_RecordChild3, // #2 = $sampler
/*34622*/         OPC_RecordChild4, // #3 = $dmask
/*34623*/         OPC_RecordChild5, // #4 = $unorm
/*34624*/         OPC_RecordChild6, // #5 = $r128
/*34625*/         OPC_RecordChild7, // #6 = $da
/*34626*/         OPC_MoveChild, 8,
/*34628*/         OPC_RecordNode, // #7 = $glc
/*34629*/         OPC_MoveParent,
/*34630*/         OPC_MoveChild, 9,
/*34632*/         OPC_RecordNode, // #8 = $slc
/*34633*/         OPC_MoveParent,
/*34634*/         OPC_MoveChild, 10,
/*34636*/         OPC_RecordNode, // #9 = $tfe
/*34637*/         OPC_MoveParent,
/*34638*/         OPC_MoveChild, 11,
/*34640*/         OPC_RecordNode, // #10 = $lwe
/*34641*/         OPC_MoveParent,
/*34642*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34644*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34647*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34650*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34653*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34656*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34659*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34662*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34665*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34668*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_B_CL_O_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5037:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_B_CL_O_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34686*/       0, /*End of Scope*/
/*34687*/     /*Scope*/ 95|128,2/*351*/, /*->35040*/
/*34689*/       OPC_CheckChild0Integer, 80|128,39/*5072*/, 
/*34692*/       OPC_RecordChild1, // #0 = $addr
/*34693*/       OPC_Scope, 68, /*->34763*/ // 5 children in Scope
/*34695*/         OPC_CheckChild1Type, MVT::i32,
/*34697*/         OPC_RecordChild2, // #1 = $rsrc
/*34698*/         OPC_RecordChild3, // #2 = $sampler
/*34699*/         OPC_RecordChild4, // #3 = $dmask
/*34700*/         OPC_RecordChild5, // #4 = $unorm
/*34701*/         OPC_RecordChild6, // #5 = $r128
/*34702*/         OPC_RecordChild7, // #6 = $da
/*34703*/         OPC_MoveChild, 8,
/*34705*/         OPC_RecordNode, // #7 = $glc
/*34706*/         OPC_MoveParent,
/*34707*/         OPC_MoveChild, 9,
/*34709*/         OPC_RecordNode, // #8 = $slc
/*34710*/         OPC_MoveParent,
/*34711*/         OPC_MoveChild, 10,
/*34713*/         OPC_RecordNode, // #9 = $tfe
/*34714*/         OPC_MoveParent,
/*34715*/         OPC_MoveChild, 11,
/*34717*/         OPC_RecordNode, // #10 = $lwe
/*34718*/         OPC_MoveParent,
/*34719*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34721*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34724*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34727*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34730*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34733*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34736*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34739*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34742*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34745*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_LZ_O_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5072:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_LZ_O_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34763*/       /*Scope*/ 68, /*->34832*/
/*34764*/         OPC_CheckChild1Type, MVT::v2i32,
/*34766*/         OPC_RecordChild2, // #1 = $rsrc
/*34767*/         OPC_RecordChild3, // #2 = $sampler
/*34768*/         OPC_RecordChild4, // #3 = $dmask
/*34769*/         OPC_RecordChild5, // #4 = $unorm
/*34770*/         OPC_RecordChild6, // #5 = $r128
/*34771*/         OPC_RecordChild7, // #6 = $da
/*34772*/         OPC_MoveChild, 8,
/*34774*/         OPC_RecordNode, // #7 = $glc
/*34775*/         OPC_MoveParent,
/*34776*/         OPC_MoveChild, 9,
/*34778*/         OPC_RecordNode, // #8 = $slc
/*34779*/         OPC_MoveParent,
/*34780*/         OPC_MoveChild, 10,
/*34782*/         OPC_RecordNode, // #9 = $tfe
/*34783*/         OPC_MoveParent,
/*34784*/         OPC_MoveChild, 11,
/*34786*/         OPC_RecordNode, // #10 = $lwe
/*34787*/         OPC_MoveParent,
/*34788*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34790*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34793*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34796*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34799*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34802*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34805*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34808*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34811*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34814*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_LZ_O_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5072:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_LZ_O_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34832*/       /*Scope*/ 68, /*->34901*/
/*34833*/         OPC_CheckChild1Type, MVT::v4i32,
/*34835*/         OPC_RecordChild2, // #1 = $rsrc
/*34836*/         OPC_RecordChild3, // #2 = $sampler
/*34837*/         OPC_RecordChild4, // #3 = $dmask
/*34838*/         OPC_RecordChild5, // #4 = $unorm
/*34839*/         OPC_RecordChild6, // #5 = $r128
/*34840*/         OPC_RecordChild7, // #6 = $da
/*34841*/         OPC_MoveChild, 8,
/*34843*/         OPC_RecordNode, // #7 = $glc
/*34844*/         OPC_MoveParent,
/*34845*/         OPC_MoveChild, 9,
/*34847*/         OPC_RecordNode, // #8 = $slc
/*34848*/         OPC_MoveParent,
/*34849*/         OPC_MoveChild, 10,
/*34851*/         OPC_RecordNode, // #9 = $tfe
/*34852*/         OPC_MoveParent,
/*34853*/         OPC_MoveChild, 11,
/*34855*/         OPC_RecordNode, // #10 = $lwe
/*34856*/         OPC_MoveParent,
/*34857*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34859*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34862*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34865*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34868*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34871*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34874*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34877*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34880*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34883*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_LZ_O_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5072:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_LZ_O_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34901*/       /*Scope*/ 68, /*->34970*/
/*34902*/         OPC_CheckChild1Type, MVT::v8i32,
/*34904*/         OPC_RecordChild2, // #1 = $rsrc
/*34905*/         OPC_RecordChild3, // #2 = $sampler
/*34906*/         OPC_RecordChild4, // #3 = $dmask
/*34907*/         OPC_RecordChild5, // #4 = $unorm
/*34908*/         OPC_RecordChild6, // #5 = $r128
/*34909*/         OPC_RecordChild7, // #6 = $da
/*34910*/         OPC_MoveChild, 8,
/*34912*/         OPC_RecordNode, // #7 = $glc
/*34913*/         OPC_MoveParent,
/*34914*/         OPC_MoveChild, 9,
/*34916*/         OPC_RecordNode, // #8 = $slc
/*34917*/         OPC_MoveParent,
/*34918*/         OPC_MoveChild, 10,
/*34920*/         OPC_RecordNode, // #9 = $tfe
/*34921*/         OPC_MoveParent,
/*34922*/         OPC_MoveChild, 11,
/*34924*/         OPC_RecordNode, // #10 = $lwe
/*34925*/         OPC_MoveParent,
/*34926*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34928*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*34931*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*34934*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*34937*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*34940*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*34943*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*34946*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*34949*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*34952*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_LZ_O_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5072:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_LZ_O_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*34970*/       /*Scope*/ 68, /*->35039*/
/*34971*/         OPC_CheckChild1Type, MVT::v16i32,
/*34973*/         OPC_RecordChild2, // #1 = $rsrc
/*34974*/         OPC_RecordChild3, // #2 = $sampler
/*34975*/         OPC_RecordChild4, // #3 = $dmask
/*34976*/         OPC_RecordChild5, // #4 = $unorm
/*34977*/         OPC_RecordChild6, // #5 = $r128
/*34978*/         OPC_RecordChild7, // #6 = $da
/*34979*/         OPC_MoveChild, 8,
/*34981*/         OPC_RecordNode, // #7 = $glc
/*34982*/         OPC_MoveParent,
/*34983*/         OPC_MoveChild, 9,
/*34985*/         OPC_RecordNode, // #8 = $slc
/*34986*/         OPC_MoveParent,
/*34987*/         OPC_MoveChild, 10,
/*34989*/         OPC_RecordNode, // #9 = $tfe
/*34990*/         OPC_MoveParent,
/*34991*/         OPC_MoveChild, 11,
/*34993*/         OPC_RecordNode, // #10 = $lwe
/*34994*/         OPC_MoveParent,
/*34995*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*34997*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35000*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35003*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35006*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35009*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35012*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35015*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35018*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35021*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_LZ_O_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5072:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_LZ_O_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35039*/       0, /*End of Scope*/
/*35040*/     /*Scope*/ 95|128,2/*351*/, /*->35393*/
/*35042*/       OPC_CheckChild0Integer, 70|128,39/*5062*/, 
/*35045*/       OPC_RecordChild1, // #0 = $addr
/*35046*/       OPC_Scope, 68, /*->35116*/ // 5 children in Scope
/*35048*/         OPC_CheckChild1Type, MVT::i32,
/*35050*/         OPC_RecordChild2, // #1 = $rsrc
/*35051*/         OPC_RecordChild3, // #2 = $sampler
/*35052*/         OPC_RecordChild4, // #3 = $dmask
/*35053*/         OPC_RecordChild5, // #4 = $unorm
/*35054*/         OPC_RecordChild6, // #5 = $r128
/*35055*/         OPC_RecordChild7, // #6 = $da
/*35056*/         OPC_MoveChild, 8,
/*35058*/         OPC_RecordNode, // #7 = $glc
/*35059*/         OPC_MoveParent,
/*35060*/         OPC_MoveChild, 9,
/*35062*/         OPC_RecordNode, // #8 = $slc
/*35063*/         OPC_MoveParent,
/*35064*/         OPC_MoveChild, 10,
/*35066*/         OPC_RecordNode, // #9 = $tfe
/*35067*/         OPC_MoveParent,
/*35068*/         OPC_MoveChild, 11,
/*35070*/         OPC_RecordNode, // #10 = $lwe
/*35071*/         OPC_MoveParent,
/*35072*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35074*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35077*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35080*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35083*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35086*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35089*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35092*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35095*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35098*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_O_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5062:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_O_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35116*/       /*Scope*/ 68, /*->35185*/
/*35117*/         OPC_CheckChild1Type, MVT::v2i32,
/*35119*/         OPC_RecordChild2, // #1 = $rsrc
/*35120*/         OPC_RecordChild3, // #2 = $sampler
/*35121*/         OPC_RecordChild4, // #3 = $dmask
/*35122*/         OPC_RecordChild5, // #4 = $unorm
/*35123*/         OPC_RecordChild6, // #5 = $r128
/*35124*/         OPC_RecordChild7, // #6 = $da
/*35125*/         OPC_MoveChild, 8,
/*35127*/         OPC_RecordNode, // #7 = $glc
/*35128*/         OPC_MoveParent,
/*35129*/         OPC_MoveChild, 9,
/*35131*/         OPC_RecordNode, // #8 = $slc
/*35132*/         OPC_MoveParent,
/*35133*/         OPC_MoveChild, 10,
/*35135*/         OPC_RecordNode, // #9 = $tfe
/*35136*/         OPC_MoveParent,
/*35137*/         OPC_MoveChild, 11,
/*35139*/         OPC_RecordNode, // #10 = $lwe
/*35140*/         OPC_MoveParent,
/*35141*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35143*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35146*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35149*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35152*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35155*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35158*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35161*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35164*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35167*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_O_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5062:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_O_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35185*/       /*Scope*/ 68, /*->35254*/
/*35186*/         OPC_CheckChild1Type, MVT::v4i32,
/*35188*/         OPC_RecordChild2, // #1 = $rsrc
/*35189*/         OPC_RecordChild3, // #2 = $sampler
/*35190*/         OPC_RecordChild4, // #3 = $dmask
/*35191*/         OPC_RecordChild5, // #4 = $unorm
/*35192*/         OPC_RecordChild6, // #5 = $r128
/*35193*/         OPC_RecordChild7, // #6 = $da
/*35194*/         OPC_MoveChild, 8,
/*35196*/         OPC_RecordNode, // #7 = $glc
/*35197*/         OPC_MoveParent,
/*35198*/         OPC_MoveChild, 9,
/*35200*/         OPC_RecordNode, // #8 = $slc
/*35201*/         OPC_MoveParent,
/*35202*/         OPC_MoveChild, 10,
/*35204*/         OPC_RecordNode, // #9 = $tfe
/*35205*/         OPC_MoveParent,
/*35206*/         OPC_MoveChild, 11,
/*35208*/         OPC_RecordNode, // #10 = $lwe
/*35209*/         OPC_MoveParent,
/*35210*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35212*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35215*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35218*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35221*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35224*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35227*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35230*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35233*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35236*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_O_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5062:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_O_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35254*/       /*Scope*/ 68, /*->35323*/
/*35255*/         OPC_CheckChild1Type, MVT::v8i32,
/*35257*/         OPC_RecordChild2, // #1 = $rsrc
/*35258*/         OPC_RecordChild3, // #2 = $sampler
/*35259*/         OPC_RecordChild4, // #3 = $dmask
/*35260*/         OPC_RecordChild5, // #4 = $unorm
/*35261*/         OPC_RecordChild6, // #5 = $r128
/*35262*/         OPC_RecordChild7, // #6 = $da
/*35263*/         OPC_MoveChild, 8,
/*35265*/         OPC_RecordNode, // #7 = $glc
/*35266*/         OPC_MoveParent,
/*35267*/         OPC_MoveChild, 9,
/*35269*/         OPC_RecordNode, // #8 = $slc
/*35270*/         OPC_MoveParent,
/*35271*/         OPC_MoveChild, 10,
/*35273*/         OPC_RecordNode, // #9 = $tfe
/*35274*/         OPC_MoveParent,
/*35275*/         OPC_MoveChild, 11,
/*35277*/         OPC_RecordNode, // #10 = $lwe
/*35278*/         OPC_MoveParent,
/*35279*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35281*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35284*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35287*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35290*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35293*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35296*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35299*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35302*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35305*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_O_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5062:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_O_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35323*/       /*Scope*/ 68, /*->35392*/
/*35324*/         OPC_CheckChild1Type, MVT::v16i32,
/*35326*/         OPC_RecordChild2, // #1 = $rsrc
/*35327*/         OPC_RecordChild3, // #2 = $sampler
/*35328*/         OPC_RecordChild4, // #3 = $dmask
/*35329*/         OPC_RecordChild5, // #4 = $unorm
/*35330*/         OPC_RecordChild6, // #5 = $r128
/*35331*/         OPC_RecordChild7, // #6 = $da
/*35332*/         OPC_MoveChild, 8,
/*35334*/         OPC_RecordNode, // #7 = $glc
/*35335*/         OPC_MoveParent,
/*35336*/         OPC_MoveChild, 9,
/*35338*/         OPC_RecordNode, // #8 = $slc
/*35339*/         OPC_MoveParent,
/*35340*/         OPC_MoveChild, 10,
/*35342*/         OPC_RecordNode, // #9 = $tfe
/*35343*/         OPC_MoveParent,
/*35344*/         OPC_MoveChild, 11,
/*35346*/         OPC_RecordNode, // #10 = $lwe
/*35347*/         OPC_MoveParent,
/*35348*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35350*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35353*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35356*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35359*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35362*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35365*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35368*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35371*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35374*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_O_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5062:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_O_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35392*/       0, /*End of Scope*/
/*35393*/     /*Scope*/ 95|128,2/*351*/, /*->35746*/
/*35395*/       OPC_CheckChild0Integer, 69|128,39/*5061*/, 
/*35398*/       OPC_RecordChild1, // #0 = $addr
/*35399*/       OPC_Scope, 68, /*->35469*/ // 5 children in Scope
/*35401*/         OPC_CheckChild1Type, MVT::i32,
/*35403*/         OPC_RecordChild2, // #1 = $rsrc
/*35404*/         OPC_RecordChild3, // #2 = $sampler
/*35405*/         OPC_RecordChild4, // #3 = $dmask
/*35406*/         OPC_RecordChild5, // #4 = $unorm
/*35407*/         OPC_RecordChild6, // #5 = $r128
/*35408*/         OPC_RecordChild7, // #6 = $da
/*35409*/         OPC_MoveChild, 8,
/*35411*/         OPC_RecordNode, // #7 = $glc
/*35412*/         OPC_MoveParent,
/*35413*/         OPC_MoveChild, 9,
/*35415*/         OPC_RecordNode, // #8 = $slc
/*35416*/         OPC_MoveParent,
/*35417*/         OPC_MoveChild, 10,
/*35419*/         OPC_RecordNode, // #9 = $tfe
/*35420*/         OPC_MoveParent,
/*35421*/         OPC_MoveChild, 11,
/*35423*/         OPC_RecordNode, // #10 = $lwe
/*35424*/         OPC_MoveParent,
/*35425*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35427*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35430*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35433*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35436*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35439*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35442*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35445*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35448*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35451*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_CL_O_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5061:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_CL_O_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35469*/       /*Scope*/ 68, /*->35538*/
/*35470*/         OPC_CheckChild1Type, MVT::v2i32,
/*35472*/         OPC_RecordChild2, // #1 = $rsrc
/*35473*/         OPC_RecordChild3, // #2 = $sampler
/*35474*/         OPC_RecordChild4, // #3 = $dmask
/*35475*/         OPC_RecordChild5, // #4 = $unorm
/*35476*/         OPC_RecordChild6, // #5 = $r128
/*35477*/         OPC_RecordChild7, // #6 = $da
/*35478*/         OPC_MoveChild, 8,
/*35480*/         OPC_RecordNode, // #7 = $glc
/*35481*/         OPC_MoveParent,
/*35482*/         OPC_MoveChild, 9,
/*35484*/         OPC_RecordNode, // #8 = $slc
/*35485*/         OPC_MoveParent,
/*35486*/         OPC_MoveChild, 10,
/*35488*/         OPC_RecordNode, // #9 = $tfe
/*35489*/         OPC_MoveParent,
/*35490*/         OPC_MoveChild, 11,
/*35492*/         OPC_RecordNode, // #10 = $lwe
/*35493*/         OPC_MoveParent,
/*35494*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35496*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35499*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35502*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35505*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35508*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35511*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35514*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35517*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35520*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_CL_O_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5061:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_CL_O_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35538*/       /*Scope*/ 68, /*->35607*/
/*35539*/         OPC_CheckChild1Type, MVT::v4i32,
/*35541*/         OPC_RecordChild2, // #1 = $rsrc
/*35542*/         OPC_RecordChild3, // #2 = $sampler
/*35543*/         OPC_RecordChild4, // #3 = $dmask
/*35544*/         OPC_RecordChild5, // #4 = $unorm
/*35545*/         OPC_RecordChild6, // #5 = $r128
/*35546*/         OPC_RecordChild7, // #6 = $da
/*35547*/         OPC_MoveChild, 8,
/*35549*/         OPC_RecordNode, // #7 = $glc
/*35550*/         OPC_MoveParent,
/*35551*/         OPC_MoveChild, 9,
/*35553*/         OPC_RecordNode, // #8 = $slc
/*35554*/         OPC_MoveParent,
/*35555*/         OPC_MoveChild, 10,
/*35557*/         OPC_RecordNode, // #9 = $tfe
/*35558*/         OPC_MoveParent,
/*35559*/         OPC_MoveChild, 11,
/*35561*/         OPC_RecordNode, // #10 = $lwe
/*35562*/         OPC_MoveParent,
/*35563*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35565*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35568*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35571*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35574*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35577*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35580*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35583*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35586*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35589*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_CL_O_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5061:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_CL_O_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35607*/       /*Scope*/ 68, /*->35676*/
/*35608*/         OPC_CheckChild1Type, MVT::v8i32,
/*35610*/         OPC_RecordChild2, // #1 = $rsrc
/*35611*/         OPC_RecordChild3, // #2 = $sampler
/*35612*/         OPC_RecordChild4, // #3 = $dmask
/*35613*/         OPC_RecordChild5, // #4 = $unorm
/*35614*/         OPC_RecordChild6, // #5 = $r128
/*35615*/         OPC_RecordChild7, // #6 = $da
/*35616*/         OPC_MoveChild, 8,
/*35618*/         OPC_RecordNode, // #7 = $glc
/*35619*/         OPC_MoveParent,
/*35620*/         OPC_MoveChild, 9,
/*35622*/         OPC_RecordNode, // #8 = $slc
/*35623*/         OPC_MoveParent,
/*35624*/         OPC_MoveChild, 10,
/*35626*/         OPC_RecordNode, // #9 = $tfe
/*35627*/         OPC_MoveParent,
/*35628*/         OPC_MoveChild, 11,
/*35630*/         OPC_RecordNode, // #10 = $lwe
/*35631*/         OPC_MoveParent,
/*35632*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35634*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35637*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35640*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35643*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35646*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35649*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35652*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35655*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35658*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_CL_O_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5061:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_CL_O_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35676*/       /*Scope*/ 68, /*->35745*/
/*35677*/         OPC_CheckChild1Type, MVT::v16i32,
/*35679*/         OPC_RecordChild2, // #1 = $rsrc
/*35680*/         OPC_RecordChild3, // #2 = $sampler
/*35681*/         OPC_RecordChild4, // #3 = $dmask
/*35682*/         OPC_RecordChild5, // #4 = $unorm
/*35683*/         OPC_RecordChild6, // #5 = $r128
/*35684*/         OPC_RecordChild7, // #6 = $da
/*35685*/         OPC_MoveChild, 8,
/*35687*/         OPC_RecordNode, // #7 = $glc
/*35688*/         OPC_MoveParent,
/*35689*/         OPC_MoveChild, 9,
/*35691*/         OPC_RecordNode, // #8 = $slc
/*35692*/         OPC_MoveParent,
/*35693*/         OPC_MoveChild, 10,
/*35695*/         OPC_RecordNode, // #9 = $tfe
/*35696*/         OPC_MoveParent,
/*35697*/         OPC_MoveChild, 11,
/*35699*/         OPC_RecordNode, // #10 = $lwe
/*35700*/         OPC_MoveParent,
/*35701*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35703*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35706*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35709*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35712*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35715*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35718*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35721*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35724*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35727*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_CD_CL_O_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5061:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_CD_CL_O_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35745*/       0, /*End of Scope*/
/*35746*/     /*Scope*/ 95|128,2/*351*/, /*->36099*/
/*35748*/       OPC_CheckChild0Integer, 66|128,39/*5058*/, 
/*35751*/       OPC_RecordChild1, // #0 = $addr
/*35752*/       OPC_Scope, 68, /*->35822*/ // 5 children in Scope
/*35754*/         OPC_CheckChild1Type, MVT::i32,
/*35756*/         OPC_RecordChild2, // #1 = $rsrc
/*35757*/         OPC_RecordChild3, // #2 = $sampler
/*35758*/         OPC_RecordChild4, // #3 = $dmask
/*35759*/         OPC_RecordChild5, // #4 = $unorm
/*35760*/         OPC_RecordChild6, // #5 = $r128
/*35761*/         OPC_RecordChild7, // #6 = $da
/*35762*/         OPC_MoveChild, 8,
/*35764*/         OPC_RecordNode, // #7 = $glc
/*35765*/         OPC_MoveParent,
/*35766*/         OPC_MoveChild, 9,
/*35768*/         OPC_RecordNode, // #8 = $slc
/*35769*/         OPC_MoveParent,
/*35770*/         OPC_MoveChild, 10,
/*35772*/         OPC_RecordNode, // #9 = $tfe
/*35773*/         OPC_MoveParent,
/*35774*/         OPC_MoveChild, 11,
/*35776*/         OPC_RecordNode, // #10 = $lwe
/*35777*/         OPC_MoveParent,
/*35778*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35780*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35783*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35786*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35789*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35792*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35795*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35798*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35801*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35804*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_O_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5058:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_O_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35822*/       /*Scope*/ 68, /*->35891*/
/*35823*/         OPC_CheckChild1Type, MVT::v2i32,
/*35825*/         OPC_RecordChild2, // #1 = $rsrc
/*35826*/         OPC_RecordChild3, // #2 = $sampler
/*35827*/         OPC_RecordChild4, // #3 = $dmask
/*35828*/         OPC_RecordChild5, // #4 = $unorm
/*35829*/         OPC_RecordChild6, // #5 = $r128
/*35830*/         OPC_RecordChild7, // #6 = $da
/*35831*/         OPC_MoveChild, 8,
/*35833*/         OPC_RecordNode, // #7 = $glc
/*35834*/         OPC_MoveParent,
/*35835*/         OPC_MoveChild, 9,
/*35837*/         OPC_RecordNode, // #8 = $slc
/*35838*/         OPC_MoveParent,
/*35839*/         OPC_MoveChild, 10,
/*35841*/         OPC_RecordNode, // #9 = $tfe
/*35842*/         OPC_MoveParent,
/*35843*/         OPC_MoveChild, 11,
/*35845*/         OPC_RecordNode, // #10 = $lwe
/*35846*/         OPC_MoveParent,
/*35847*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35849*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35852*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35855*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35858*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35861*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35864*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35867*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35870*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35873*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_O_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5058:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_O_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35891*/       /*Scope*/ 68, /*->35960*/
/*35892*/         OPC_CheckChild1Type, MVT::v4i32,
/*35894*/         OPC_RecordChild2, // #1 = $rsrc
/*35895*/         OPC_RecordChild3, // #2 = $sampler
/*35896*/         OPC_RecordChild4, // #3 = $dmask
/*35897*/         OPC_RecordChild5, // #4 = $unorm
/*35898*/         OPC_RecordChild6, // #5 = $r128
/*35899*/         OPC_RecordChild7, // #6 = $da
/*35900*/         OPC_MoveChild, 8,
/*35902*/         OPC_RecordNode, // #7 = $glc
/*35903*/         OPC_MoveParent,
/*35904*/         OPC_MoveChild, 9,
/*35906*/         OPC_RecordNode, // #8 = $slc
/*35907*/         OPC_MoveParent,
/*35908*/         OPC_MoveChild, 10,
/*35910*/         OPC_RecordNode, // #9 = $tfe
/*35911*/         OPC_MoveParent,
/*35912*/         OPC_MoveChild, 11,
/*35914*/         OPC_RecordNode, // #10 = $lwe
/*35915*/         OPC_MoveParent,
/*35916*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35918*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35921*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35924*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35927*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35930*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*35933*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*35936*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*35939*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*35942*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_O_V4_V4), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5058:iPTR, v4i32:v4i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_O_V4_V4:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v4i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*35960*/       /*Scope*/ 68, /*->36029*/
/*35961*/         OPC_CheckChild1Type, MVT::v8i32,
/*35963*/         OPC_RecordChild2, // #1 = $rsrc
/*35964*/         OPC_RecordChild3, // #2 = $sampler
/*35965*/         OPC_RecordChild4, // #3 = $dmask
/*35966*/         OPC_RecordChild5, // #4 = $unorm
/*35967*/         OPC_RecordChild6, // #5 = $r128
/*35968*/         OPC_RecordChild7, // #6 = $da
/*35969*/         OPC_MoveChild, 8,
/*35971*/         OPC_RecordNode, // #7 = $glc
/*35972*/         OPC_MoveParent,
/*35973*/         OPC_MoveChild, 9,
/*35975*/         OPC_RecordNode, // #8 = $slc
/*35976*/         OPC_MoveParent,
/*35977*/         OPC_MoveChild, 10,
/*35979*/         OPC_RecordNode, // #9 = $tfe
/*35980*/         OPC_MoveParent,
/*35981*/         OPC_MoveChild, 11,
/*35983*/         OPC_RecordNode, // #10 = $lwe
/*35984*/         OPC_MoveParent,
/*35985*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*35987*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*35990*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*35993*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*35996*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*35999*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*36002*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*36005*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*36008*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*36011*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_O_V4_V8), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5058:iPTR, v8i32:v8i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_O_V4_V8:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v8i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*36029*/       /*Scope*/ 68, /*->36098*/
/*36030*/         OPC_CheckChild1Type, MVT::v16i32,
/*36032*/         OPC_RecordChild2, // #1 = $rsrc
/*36033*/         OPC_RecordChild3, // #2 = $sampler
/*36034*/         OPC_RecordChild4, // #3 = $dmask
/*36035*/         OPC_RecordChild5, // #4 = $unorm
/*36036*/         OPC_RecordChild6, // #5 = $r128
/*36037*/         OPC_RecordChild7, // #6 = $da
/*36038*/         OPC_MoveChild, 8,
/*36040*/         OPC_RecordNode, // #7 = $glc
/*36041*/         OPC_MoveParent,
/*36042*/         OPC_MoveChild, 9,
/*36044*/         OPC_RecordNode, // #8 = $slc
/*36045*/         OPC_MoveParent,
/*36046*/         OPC_MoveChild, 10,
/*36048*/         OPC_RecordNode, // #9 = $tfe
/*36049*/         OPC_MoveParent,
/*36050*/         OPC_MoveChild, 11,
/*36052*/         OPC_RecordNode, // #10 = $lwe
/*36053*/         OPC_MoveParent,
/*36054*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*36056*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*36059*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*36062*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*36065*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*36068*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*36071*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*36074*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*36077*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*36080*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_O_V4_V16), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5058:iPTR, v16i32:v16i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_O_V4_V16:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v16i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*36098*/       0, /*End of Scope*/
/*36099*/     /*Scope*/ 95|128,2/*351*/, /*->36452*/
/*36101*/       OPC_CheckChild0Integer, 57|128,39/*5049*/, 
/*36104*/       OPC_RecordChild1, // #0 = $addr
/*36105*/       OPC_Scope, 68, /*->36175*/ // 5 children in Scope
/*36107*/         OPC_CheckChild1Type, MVT::i32,
/*36109*/         OPC_RecordChild2, // #1 = $rsrc
/*36110*/         OPC_RecordChild3, // #2 = $sampler
/*36111*/         OPC_RecordChild4, // #3 = $dmask
/*36112*/         OPC_RecordChild5, // #4 = $unorm
/*36113*/         OPC_RecordChild6, // #5 = $r128
/*36114*/         OPC_RecordChild7, // #6 = $da
/*36115*/         OPC_MoveChild, 8,
/*36117*/         OPC_RecordNode, // #7 = $glc
/*36118*/         OPC_MoveParent,
/*36119*/         OPC_MoveChild, 9,
/*36121*/         OPC_RecordNode, // #8 = $slc
/*36122*/         OPC_MoveParent,
/*36123*/         OPC_MoveChild, 10,
/*36125*/         OPC_RecordNode, // #9 = $tfe
/*36126*/         OPC_MoveParent,
/*36127*/         OPC_MoveChild, 11,
/*36129*/         OPC_RecordNode, // #10 = $lwe
/*36130*/         OPC_MoveParent,
/*36131*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*36133*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*36136*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*36139*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*36142*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*36145*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*36148*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*36151*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*36154*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*36157*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CL_O_V4_V1), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5049:iPTR, i32:i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CL_O_V4_V1:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*36175*/       /*Scope*/ 68, /*->36244*/
/*36176*/         OPC_CheckChild1Type, MVT::v2i32,
/*36178*/         OPC_RecordChild2, // #1 = $rsrc
/*36179*/         OPC_RecordChild3, // #2 = $sampler
/*36180*/         OPC_RecordChild4, // #3 = $dmask
/*36181*/         OPC_RecordChild5, // #4 = $unorm
/*36182*/         OPC_RecordChild6, // #5 = $r128
/*36183*/         OPC_RecordChild7, // #6 = $da
/*36184*/         OPC_MoveChild, 8,
/*36186*/         OPC_RecordNode, // #7 = $glc
/*36187*/         OPC_MoveParent,
/*36188*/         OPC_MoveChild, 9,
/*36190*/         OPC_RecordNode, // #8 = $slc
/*36191*/         OPC_MoveParent,
/*36192*/         OPC_MoveChild, 10,
/*36194*/         OPC_RecordNode, // #9 = $tfe
/*36195*/         OPC_MoveParent,
/*36196*/         OPC_MoveChild, 11,
/*36198*/         OPC_RecordNode, // #10 = $lwe
/*36199*/         OPC_MoveParent,
/*36200*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*36202*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*36205*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*36208*/         OPC_EmitNodeXForm, 1, 7, // as_i1imm
/*36211*/         OPC_EmitNodeXForm, 1, 6, // as_i1imm
/*36214*/         OPC_EmitNodeXForm, 1, 5, // as_i1imm
/*36217*/         OPC_EmitNodeXForm, 1, 9, // as_i1imm
/*36220*/         OPC_EmitNodeXForm, 1, 10, // as_i1imm
/*36223*/         OPC_EmitNodeXForm, 1, 8, // as_i1imm
/*36226*/         OPC_MorphNodeTo, TARGET_VAL(AMDGPU::IMAGE_SAMPLE_C_CL_O_V4_V2), 0,
                      1/*#VTs*/, MVT::v4f32, 11/*#Ops*/, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 
                  // Src: (intrinsic_wo_chain:v4f32 5049:iPTR, v2i32:v2i32:$addr, v8i32:v8i32:$rsrc, v4i32:v4i32:$sampler, i32:i32:$dmask, i32:i32:$unorm, i32:i32:$r128, i32:i32:$da, i32:i32:$glc, i32:i32:$slc, i32:i32:$tfe, i32:i32:$lwe) - Complexity = 8
                  // Dst: (IMAGE_SAMPLE_C_CL_O_V4_V2:v4f32 (as_i32imm:i32 ?:i32:$dmask), (as_i1imm:i1 ?:i32:$unorm), (as_i1imm:i1 ?:i32:$glc), (as_i1imm:i1 ?:i32:$da), (as_i1imm:i1 ?:i32:$r128), (as_i1imm:i1 ?:i32:$tfe), (as_i1imm:i1 ?:i32:$lwe), (as_i1imm:i1 ?:i32:$slc), ?:v2i32:$addr, ?:v8i32:$rsrc, ?:v4i32:$sampler)
/*36244*/       /*Scope*/ 68, /*->36313*/
/*36245*/         OPC_CheckChild1Type, MVT::v4i32,
/*36247*/         OPC_RecordChild2, // #1 = $rsrc
/*36248*/         OPC_RecordChild3, // #2 = $sampler
/*36249*/         OPC_RecordChild4, // #3 = $dmask
/*36250*/         OPC_RecordChild5, // #4 = $unorm
/*36251*/         OPC_RecordChild6, // #5 = $r128
/*36252*/         OPC_RecordChild7, // #6 = $da
/*36253*/         OPC_MoveChild, 8,
/*36255*/         OPC_RecordNode, // #7 = $glc
/*36256*/         OPC_MoveParent,
/*36257*/         OPC_MoveChild, 9,
/*36259*/         OPC_RecordNode, // #8 = $slc
/*36260*/         OPC_MoveParent,
/*36261*/         OPC_MoveChild, 10,
/*36263*/         OPC_RecordNode, // #9 = $tfe
/*36264*/         OPC_MoveParent,
/*36265*/         OPC_MoveChild, 11,
/*36267*/         OPC_RecordNode, // #10 = $lwe
/*36268*/         OPC_MoveParent,
/*36269*/         OPC_CheckPatternPredicate, 0, // (Subtarget->getGeneration() >= AMDGPUSubtarget::SOUTHERN_ISLANDS)
/*36271*/         OPC_EmitNodeXForm, 4, 3, // as_i32imm
/*36274*/         OPC_EmitNodeXForm, 1, 4, // as_i1imm
/*36277*/         OPC_EmitNodeXForm, 1, 7, // 