/*
 * $XTermId: builtin.c,v 1.2 2013/01/28 10:00:55 tom Exp $
 * This file was generated by ./make-tables
 */
#include <other.h>
#include <sys.h>
#include <luitconv.h>

static const BuiltInMapping dec_special[] =
{
    /* This file is derived from the file data.c in the XTerm sources */
    {0x5F, 0x25ae},	/* black vertical rectangle */
    {0x60, 0x25c6},	/* black diamond */
    {0x61, 0x2592},	/* medium shade */
    {0x62, 0x2409},	/* symbol for horizontal tabulation */
    {0x63, 0x240c},	/* symbol for form feed */
    {0x64, 0x240d},	/* symbol for carriage return */
    {0x65, 0x240a},	/* symbol for line feed */
    {0x66, 0x00b0},	/* degree sign */
    {0x67, 0x00b1},	/* plus-minus sign */
    {0x68, 0x2424},	/* symbol for newline */
    {0x69, 0x240b},	/* symbol for vertical tabulation */
    {0x6A, 0x2518},	/* box drawings light up and left */
    {0x6B, 0x2510},	/* box drawings light down and left */
    {0x6C, 0x250c},	/* box drawings light down and right */
    {0x6D, 0x2514},	/* box drawings light up and right */
    {0x6E, 0x253c},	/* box drawings light vertical and horizontal */
    {0x6F, 0x23BA},	/* box drawings scan 1 */
    {0x70, 0x23BB},	/* box drawings scan 3 */
    {0x71, 0x2500},	/* box drawings light horizontal */
    {0x72, 0x23BC},	/* box drawings scan 7 */
    {0x73, 0x23BD},	/* box drawings scan 9 */
    {0x74, 0x251c},	/* box drawings light vertical and right */
    {0x75, 0x2524},	/* box drawings light vertical and left */
    {0x76, 0x2534},	/* box drawings light up and horizontal */
    {0x77, 0x252c},	/* box drawings light down and horizontal */
    {0x78, 0x2502},	/* box drawings light vertical */
    {0x79, 0x2264},	/* less-than or equal to */
    {0x7A, 0x2265},	/* greater-than or equal to */
    {0x7B, 0x03c0},	/* greek small letter pi */
    {0x7C, 0x2260},	/* not equal to */
    {0x7D, 0x00a3},	/* pound sign */
    {0x7E, 0x00b7},	/* middle dot */
};

static const BuiltInMapping dec_technical[] =
{
    /* derived from http://www.vt100.net/charsets/technical.html */
    {0x21, 0x23b7},	/* RADICAL SYMBOL BOTTOM Centred left to right, so that it joins up with 02/02 */
    {0x22, 0x250c},	/* BOX DRAWINGS LIGHT DOWN AND RIGHT */
    {0x23, 0x2500},	/* BOX DRAWINGS LIGHT HORIZONTAL */
    {0x24, 0x2320},	/* TOP HALF INTEGRAL with the proviso that the stem is vertical, to join with 02/06 */
    {0x25, 0x2321},	/* BOTTOM HALF INTEGRAL with the proviso above. */
    {0x26, 0x2502},	/* BOX DRAWINGS LIGHT VERTICAL */
    {0x27, 0x23a1},	/* LEFT SQUARE BRACKET UPPER CORNER Joins vertically to 02/06, 02/08. Doesn't join to its right. */
    {0x28, 0x23a3},	/* LEFT SQUARE BRACKET LOWER CORNER Joins vertically to 02/06, 02/07. Doesn't join to its right. */
    {0x29, 0x23a4},	/* RIGHT SQUARE BRACKET UPPER CORNER Joins vertically to 026, 02a. Doesn't join to its left. */
    {0x2a, 0x23a6},	/* RIGHT SQUARE BRACKET LOWER CORNER Joins vertically to 026, 029. Doesn't join to its left. */
    {0x2b, 0x239b},	/* LEFT PARENTHESIS UPPER HOOK Joins vertically to 026, 02c, 02/15. Doesn't join to its right. */
    {0x2c, 0x239d},	/* LEFT PARENTHESIS LOWER HOOK Joins vertically to 026, 02b, 02/15. Doesn't join to its right. */
    {0x2d, 0x239e},	/* RIGHT PARENTHESIS UPPER HOOK Joins vertically to 026, 02e, 03/00. Doesn't join to its left. */
    {0x2e, 0x23a0},	/* RIGHT PARENTHESIS LOWER HOOK Joins vertically to 026, 02d, 03/00. Doesn't join to its left. */
    {0x2f, 0x23a8},	/* LEFT CURLY BRACKET MIDDLE PIECE Joins vertically to 026, 02b, 02c. */
    {0x30, 0x23ac},	/* RIGHT CURLY BRACKET MIDDLE PIECE Joins vertically to 02/06, 02d, 02e. */
    {0x31, 0x2426},	/* Top Left Sigma. Joins to right with 02/03, 03/05. Joins diagonally below right with 03/03, 03/07. */
    {0x32, 0x2426},	/* Bottom Left Sigma. Joins to right with 02/03, 03/06. Joins diagonally above right with 03/04, 03/07. */
    {0x33, 0x2426},	/* Top Diagonal Sigma. Line for joining 03/01 to 03/04 or 03/07. */
    {0x34, 0x2426},	/* Bottom Diagonal Sigma. Line for joining 03/02 to 03/03 or 03/07. */
    {0x35, 0x2426},	/* Top Right Sigma. Joins to left with 02/03, 03/01. */
    {0x36, 0x2426},	/* Bottom Right Sigma. Joins to left with 02/03, 03/02. */
    {0x37, 0x2426},	/* Middle Sigma. Joins diagonally with 03/01, 03/02, 03/03, 03/04. */
    {0x38, 0x2426},	/* undefined */
    {0x39, 0x2426},	/* undefined */
    {0x3a, 0x2426},	/* undefined */
    {0x3b, 0x2426},	/* undefined */
    {0x3c, 0x2264},	/* LESS-THAN OR EQUAL TO */
    {0x3d, 0x2260},	/* NOT EQUAL TO */
    {0x3e, 0x2265},	/* GREATER-THAN OR EQUAL TO */
    {0x3f, 0x222B},	/* INTEGRAL */
    {0x40, 0x2234},	/* THEREFORE */
    {0x41, 0x221d},	/* PROPORTIONAL TO */
    {0x42, 0x221e},	/* INFINITY */
    {0x43, 0x00f7},	/* DIVISION SIGN */
    {0x44, 0x039a},	/* GREEK CAPITAL DELTA */
    {0x45, 0x2207},	/* NABLA */
    {0x46, 0x03a6},	/* GREEK CAPITAL LETTER PHI */
    {0x47, 0x0393},	/* GREEK CAPITAL LETTER GAMMA */
    {0x48, 0x223c},	/* TILDE OPERATOR */
    {0x49, 0x2243},	/* ASYMPTOTICALLY EQUAL TO */
    {0x4a, 0x0398},	/* GREEK CAPITAL LETTER THETA */
    {0x4b, 0x00d7},	/* MULTIPLICATION SIGN */
    {0x4c, 0x039b},	/* GREEK CAPITAL LETTER LAMDA */
    {0x4d, 0x21d4},	/* LEFT RIGHT DOUBLE ARROW */
    {0x4e, 0x21d2},	/* RIGHTWARDS DOUBLE ARROW */
    {0x4f, 0x2261},	/* IDENTICAL TO */
    {0x50, 0x03a0},	/* GREEK CAPITAL LETTER PI */
    {0x51, 0x03a8},	/* GREEK CAPITAL LETTER PSI */
    {0x52, 0x2426},	/* undefined */
    {0x53, 0x03a3},	/* GREEK CAPITAL LETTER SIGMA */
    {0x54, 0x2426},	/* undefined */
    {0x55, 0x2426},	/* undefined */
    {0x56, 0x221a},	/* SQUARE ROOT */
    {0x57, 0x03a9},	/* GREEK CAPITAL LETTER OMEGA */
    {0x58, 0x039e},	/* GREEK CAPITAL LETTER XI */
    {0x59, 0x03a5},	/* GREEK CAPITAL LETTER UPSILON */
    {0x5a, 0x2282},	/* SUBSET OF */
    {0x5b, 0x2283},	/* SUPERSET OF */
    {0x5c, 0x2229},	/* INTERSECTION */
    {0x5d, 0x222a},	/* UNION */
    {0x5e, 0x2227},	/* LOGICAL AND */
    {0x5f, 0x2228},	/* LOGICAL OR */
    {0x60, 0x00ac},	/* NOT SIGN */
    {0x61, 0x03b1},	/* GREEK SMALL LETTER ALPHA */
    {0x62, 0x03b2},	/* GREEK SMALL LETTER BETA */
    {0x63, 0x03c7},	/* GREEK SMALL LETTER CHI */
    {0x64, 0x03b4},	/* GREEK SMALL LETTER DELTA */
    {0x65, 0x03b5},	/* GREEK SMALL LETTER EPSILON */
    {0x66, 0x03c6},	/* GREEK SMALL LETTER PHI */
    {0x67, 0x03b3},	/* GREEK SMALL LETTER GAMMA */
    {0x68, 0x03b7},	/* GREEK SMALL LETTER ETA */
    {0x69, 0x03b9},	/* GREEK SMALL LETTER IOTA */
    {0x6a, 0x03b8},	/* GREEK SMALL LETTER THETA */
    {0x6b, 0x03ba},	/* GREEK SMALL LETTER KAPPA */
    {0x6c, 0x03bb},	/* GREEK SMALL LETTER LAMDA */
    {0x6d, 0x2426},	/* undefined */
    {0x6e, 0x03bd},	/* GREEK SMALL LETTER NU */
    {0x6f, 0x2202},	/* PARTIAL DIFFERENTIAL */
    {0x70, 0x03c0},	/* GREEK SMALL LETTER PI */
    {0x71, 0x03c8},	/* GREEK SMALL LETTER PSI */
    {0x72, 0x03c1},	/* GREEK SMALL LETTER RHO */
    {0x73, 0x03c3},	/* GREEK SMALL LETTER SIGMA */
    {0x74, 0x03c4},	/* GREEK SMALL LETTER TAU */
    {0x75, 0x2426},	/* undefined */
    {0x76, 0x0192},	/* LATIN SMALL LETTER F WITH HOOK Probably chosen for its meaning of "function" */
    {0x77, 0x03c9},	/* GREEK SMALL LETTER OMEGA */
    {0x78, 0x03bE},	/* GREEK SMALL LETTER XI */
    {0x79, 0x03c5},	/* GREEK SMALL LETTER UPSILON */
    {0x7a, 0x03b6},	/* GREEK SMALL LETTER ZETA */
    {0x7b, 0x2190},	/* LEFTWARDS ARROW */
    {0x7c, 0x2191},	/* UPWARDS ARROW */
    {0x7d, 0x2192},	/* RIGHTWARDS ARROW */
    {0x7e, 0x2193},	/* DOWNWARDS ARROW */
};

static const BuiltInMapping iso8859_1[] =
{
    /* iso8859-1 */
    {0, 0},	/* empty table is illegal syntax */
};

static const BuiltInMapping iso8859_10[] =
{
    /* iso8859-10 */
    {0x00A1, 0x0104},
    {0x00A2, 0x0112},
    {0x00A3, 0x0122},
    {0x00A4, 0x012A},
    {0x00A5, 0x0128},
    {0x00A6, 0x0136},
    {0x00A8, 0x013B},
    {0x00A9, 0x0110},
    {0x00AA, 0x0160},
    {0x00AB, 0x0166},
    {0x00AC, 0x017D},
    {0x00AE, 0x016A},
    {0x00AF, 0x014A},
    {0x00B1, 0x0105},
    {0x00B2, 0x0113},
    {0x00B3, 0x0123},
    {0x00B4, 0x012B},
    {0x00B5, 0x0129},
    {0x00B6, 0x0137},
    {0x00B8, 0x013C},
    {0x00B9, 0x0111},
    {0x00BA, 0x0161},
    {0x00BB, 0x0167},
    {0x00BC, 0x017E},
    {0x00BD, 0x2015},
    {0x00BE, 0x016B},
    {0x00BF, 0x014B},
    {0x00C0, 0x0100},
    {0x00C7, 0x012E},
    {0x00C8, 0x010C},
    {0x00CA, 0x0118},
    {0x00CC, 0x0116},
    {0x00D1, 0x0145},
    {0x00D2, 0x014C},
    {0x00D7, 0x0168},
    {0x00D9, 0x0172},
    {0x00E0, 0x0101},
    {0x00E7, 0x012F},
    {0x00E8, 0x010D},
    {0x00EA, 0x0119},
    {0x00EC, 0x0117},
    {0x00F1, 0x0146},
    {0x00F2, 0x014D},
    {0x00F7, 0x0169},
    {0x00F9, 0x0173},
    {0x00FF, 0x0138},
};

static const BuiltInMapping iso8859_15[] =
{
    /* iso8859-15 */
    {0x00A4, 0x20AC},
    {0x00A6, 0x0160},
    {0x00A8, 0x0161},
    {0x00B4, 0x017D},
    {0x00B8, 0x017E},
    {0x00BC, 0x0152},
    {0x00BD, 0x0153},
    {0x00BE, 0x0178},
};

static const BuiltInMapping iso8859_2[] =
{
    /* iso8859-2 */
    {0x00A1, 0x0104},
    {0x00A2, 0x02D8},
    {0x00A3, 0x0141},
    {0x00A5, 0x013D},
    {0x00A6, 0x015A},
    {0x00A9, 0x0160},
    {0x00AA, 0x015E},
    {0x00AB, 0x0164},
    {0x00AC, 0x0179},
    {0x00AE, 0x017D},
    {0x00AF, 0x017B},
    {0x00B1, 0x0105},
    {0x00B2, 0x02DB},
    {0x00B3, 0x0142},
    {0x00B5, 0x013E},
    {0x00B6, 0x015B},
    {0x00B7, 0x02C7},
    {0x00B9, 0x0161},
    {0x00BA, 0x015F},
    {0x00BB, 0x0165},
    {0x00BC, 0x017A},
    {0x00BD, 0x02DD},
    {0x00BE, 0x017E},
    {0x00BF, 0x017C},
    {0x00C0, 0x0154},
    {0x00C3, 0x0102},
    {0x00C5, 0x0139},
    {0x00C6, 0x0106},
    {0x00C8, 0x010C},
    {0x00CA, 0x0118},
    {0x00CC, 0x011A},
    {0x00CF, 0x010E},
    {0x00D0, 0x0110},
    {0x00D1, 0x0143},
    {0x00D2, 0x0147},
    {0x00D5, 0x0150},
    {0x00D8, 0x0158},
    {0x00D9, 0x016E},
    {0x00DB, 0x0170},
    {0x00DE, 0x0162},
    {0x00E0, 0x0155},
    {0x00E3, 0x0103},
    {0x00E5, 0x013A},
    {0x00E6, 0x0107},
    {0x00E8, 0x010D},
    {0x00EA, 0x0119},
    {0x00EC, 0x011B},
    {0x00EF, 0x010F},
    {0x00F0, 0x0111},
    {0x00F1, 0x0144},
    {0x00F2, 0x0148},
    {0x00F5, 0x0151},
    {0x00F8, 0x0159},
    {0x00F9, 0x016F},
    {0x00FB, 0x0171},
    {0x00FE, 0x0163},
    {0x00FF, 0x02D9},
};

static const BuiltInMapping iso8859_3[] =
{
    /* iso8859-3 */
    {0x00A1, 0x0126},
    {0x00A2, 0x02D8},
    {0x00A6, 0x0124},
    {0x00A9, 0x0130},
    {0x00AA, 0x015E},
    {0x00AB, 0x011E},
    {0x00AC, 0x0134},
    {0x00AF, 0x017B},
    {0x00B1, 0x0127},
    {0x00B6, 0x0125},
    {0x00B9, 0x0131},
    {0x00BA, 0x015F},
    {0x00BB, 0x011F},
    {0x00BC, 0x0135},
    {0x00BF, 0x017C},
    {0x00C5, 0x010A},
    {0x00C6, 0x0108},
    {0x00D5, 0x0120},
    {0x00D8, 0x011C},
    {0x00DD, 0x016C},
    {0x00DE, 0x015C},
    {0x00E5, 0x010B},
    {0x00E6, 0x0109},
    {0x00F5, 0x0121},
    {0x00F8, 0x011D},
    {0x00FD, 0x016D},
    {0x00FE, 0x015D},
    {0x00FF, 0x02D9},
};

static const BuiltInMapping iso8859_4[] =
{
    /* iso8859-4 */
    {0x00A1, 0x0104},
    {0x00A2, 0x0138},
    {0x00A3, 0x0156},
    {0x00A5, 0x0128},
    {0x00A6, 0x013B},
    {0x00A9, 0x0160},
    {0x00AA, 0x0112},
    {0x00AB, 0x0122},
    {0x00AC, 0x0166},
    {0x00AE, 0x017D},
    {0x00B1, 0x0105},
    {0x00B2, 0x02DB},
    {0x00B3, 0x0157},
    {0x00B5, 0x0129},
    {0x00B6, 0x013C},
    {0x00B7, 0x02C7},
    {0x00B9, 0x0161},
    {0x00BA, 0x0113},
    {0x00BB, 0x0123},
    {0x00BC, 0x0167},
    {0x00BD, 0x014A},
    {0x00BE, 0x017E},
    {0x00BF, 0x014B},
    {0x00C0, 0x0100},
    {0x00C7, 0x012E},
    {0x00C8, 0x010C},
    {0x00CA, 0x0118},
    {0x00CC, 0x0116},
    {0x00CF, 0x012A},
    {0x00D0, 0x0110},
    {0x00D1, 0x0145},
    {0x00D2, 0x014C},
    {0x00D3, 0x0136},
    {0x00D9, 0x0172},
    {0x00DD, 0x0168},
    {0x00DE, 0x016A},
    {0x00E0, 0x0101},
    {0x00E7, 0x012F},
    {0x00E8, 0x010D},
    {0x00EA, 0x0119},
    {0x00EC, 0x0117},
    {0x00EF, 0x012B},
    {0x00F0, 0x0111},
    {0x00F1, 0x0146},
    {0x00F2, 0x014D},
    {0x00F3, 0x0137},
    {0x00F9, 0x0173},
    {0x00FD, 0x0169},
    {0x00FE, 0x016B},
    {0x00FF, 0x02D9},
};

static const BuiltInMapping iso8859_5[] =
{
    /* iso8859-5 */
    {0x00A1, 0x0401},
    {0x00A2, 0x0402},
    {0x00A3, 0x0403},
    {0x00A4, 0x0404},
    {0x00A5, 0x0405},
    {0x00A6, 0x0406},
    {0x00A7, 0x0407},
    {0x00A8, 0x0408},
    {0x00A9, 0x0409},
    {0x00AA, 0x040A},
    {0x00AB, 0x040B},
    {0x00AC, 0x040C},
    {0x00AE, 0x040E},
    {0x00AF, 0x040F},
    {0x00B0, 0x0410},
    {0x00B1, 0x0411},
    {0x00B2, 0x0412},
    {0x00B3, 0x0413},
    {0x00B4, 0x0414},
    {0x00B5, 0x0415},
    {0x00B6, 0x0416},
    {0x00B7, 0x0417},
    {0x00B8, 0x0418},
    {0x00B9, 0x0419},
    {0x00BA, 0x041A},
    {0x00BB, 0x041B},
    {0x00BC, 0x041C},
    {0x00BD, 0x041D},
    {0x00BE, 0x041E},
    {0x00BF, 0x041F},
    {0x00C0, 0x0420},
    {0x00C1, 0x0421},
    {0x00C2, 0x0422},
    {0x00C3, 0x0423},
    {0x00C4, 0x0424},
    {0x00C5, 0x0425},
    {0x00C6, 0x0426},
    {0x00C7, 0x0427},
    {0x00C8, 0x0428},
    {0x00C9, 0x0429},
    {0x00CA, 0x042A},
    {0x00CB, 0x042B},
    {0x00CC, 0x042C},
    {0x00CD, 0x042D},
    {0x00CE, 0x042E},
    {0x00CF, 0x042F},
    {0x00D0, 0x0430},
    {0x00D1, 0x0431},
    {0x00D2, 0x0432},
    {0x00D3, 0x0433},
    {0x00D4, 0x0434},
    {0x00D5, 0x0435},
    {0x00D6, 0x0436},
    {0x00D7, 0x0437},
    {0x00D8, 0x0438},
    {0x00D9, 0x0439},
    {0x00DA, 0x043A},
    {0x00DB, 0x043B},
    {0x00DC, 0x043C},
    {0x00DD, 0x043D},
    {0x00DE, 0x043E},
    {0x00DF, 0x043F},
    {0x00E0, 0x0440},
    {0x00E1, 0x0441},
    {0x00E2, 0x0442},
    {0x00E3, 0x0443},
    {0x00E4, 0x0444},
    {0x00E5, 0x0445},
    {0x00E6, 0x0446},
    {0x00E7, 0x0447},
    {0x00E8, 0x0448},
    {0x00E9, 0x0449},
    {0x00EA, 0x044A},
    {0x00EB, 0x044B},
    {0x00EC, 0x044C},
    {0x00ED, 0x044D},
    {0x00EE, 0x044E},
    {0x00EF, 0x044F},
    {0x00F0, 0x2116},
    {0x00F1, 0x0451},
    {0x00F2, 0x0452},
    {0x00F3, 0x0453},
    {0x00F4, 0x0454},
    {0x00F5, 0x0455},
    {0x00F6, 0x0456},
    {0x00F7, 0x0457},
    {0x00F8, 0x0458},
    {0x00F9, 0x0459},
    {0x00FA, 0x045A},
    {0x00FB, 0x045B},
    {0x00FC, 0x045C},
    {0x00FD, 0x00A7},
    {0x00FE, 0x045E},
    {0x00FF, 0x045F},
};

static const BuiltInMapping iso8859_6[] =
{
    /* iso8859-6 */
    {0x00AC, 0x060C},
    {0x00BB, 0x061B},
    {0x00BF, 0x061F},
    {0x00C1, 0x0621},
    {0x00C2, 0x0622},
    {0x00C3, 0x0623},
    {0x00C4, 0x0624},
    {0x00C5, 0x0625},
    {0x00C6, 0x0626},
    {0x00C7, 0x0627},
    {0x00C8, 0x0628},
    {0x00C9, 0x0629},
    {0x00CA, 0x062A},
    {0x00CB, 0x062B},
    {0x00CC, 0x062C},
    {0x00CD, 0x062D},
    {0x00CE, 0x062E},
    {0x00CF, 0x062F},
    {0x00D0, 0x0630},
    {0x00D1, 0x0631},
    {0x00D2, 0x0632},
    {0x00D3, 0x0633},
    {0x00D4, 0x0634},
    {0x00D5, 0x0635},
    {0x00D6, 0x0636},
    {0x00D7, 0x0637},
    {0x00D8, 0x0638},
    {0x00D9, 0x0639},
    {0x00DA, 0x063A},
    {0x00E0, 0x0640},
    {0x00E1, 0x0641},
    {0x00E2, 0x0642},
    {0x00E3, 0x0643},
    {0x00E4, 0x0644},
    {0x00E5, 0x0645},
    {0x00E6, 0x0646},
    {0x00E7, 0x0647},
    {0x00E8, 0x0648},
    {0x00E9, 0x0649},
    {0x00EA, 0x064A},
    {0x00EB, 0x064B},
    {0x00EC, 0x064C},
    {0x00ED, 0x064D},
    {0x00EE, 0x064E},
    {0x00EF, 0x064F},
    {0x00F0, 0x0650},
    {0x00F1, 0x0651},
    {0x00F2, 0x0652},
};

static const BuiltInMapping iso8859_7[] =
{
    /* iso8859-7 */
    {0x00A1, 0x2018},
    {0x00A2, 0x2019},
    {0x00A4, 0x20AC},
    {0x00A5, 0x20AF},
    {0x00AA, 0x037A},
    {0x00AF, 0x2015},
    {0x00B4, 0x0384},
    {0x00B5, 0x0385},
    {0x00B6, 0x0386},
    {0x00B8, 0x0388},
    {0x00B9, 0x0389},
    {0x00BA, 0x038A},
    {0x00BC, 0x038C},
    {0x00BE, 0x038E},
    {0x00BF, 0x038F},
    {0x00C0, 0x0390},
    {0x00C1, 0x0391},
    {0x00C2, 0x0392},
    {0x00C3, 0x0393},
    {0x00C4, 0x0394},
    {0x00C5, 0x0395},
    {0x00C6, 0x0396},
    {0x00C7, 0x0397},
    {0x00C8, 0x0398},
    {0x00C9, 0x0399},
    {0x00CA, 0x039A},
    {0x00CB, 0x039B},
    {0x00CC, 0x039C},
    {0x00CD, 0x039D},
    {0x00CE, 0x039E},
    {0x00CF, 0x039F},
    {0x00D0, 0x03A0},
    {0x00D1, 0x03A1},
    {0x00D3, 0x03A3},
    {0x00D4, 0x03A4},
    {0x00D5, 0x03A5},
    {0x00D6, 0x03A6},
    {0x00D7, 0x03A7},
    {0x00D8, 0x03A8},
    {0x00D9, 0x03A9},
    {0x00DA, 0x03AA},
    {0x00DB, 0x03AB},
    {0x00DC, 0x03AC},
    {0x00DD, 0x03AD},
    {0x00DE, 0x03AE},
    {0x00DF, 0x03AF},
    {0x00E0, 0x03B0},
    {0x00E1, 0x03B1},
    {0x00E2, 0x03B2},
    {0x00E3, 0x03B3},
    {0x00E4, 0x03B4},
    {0x00E5, 0x03B5},
    {0x00E6, 0x03B6},
    {0x00E7, 0x03B7},
    {0x00E8, 0x03B8},
    {0x00E9, 0x03B9},
    {0x00EA, 0x03BA},
    {0x00EB, 0x03BB},
    {0x00EC, 0x03BC},
    {0x00ED, 0x03BD},
    {0x00EE, 0x03BE},
    {0x00EF, 0x03BF},
    {0x00F0, 0x03C0},
    {0x00F1, 0x03C1},
    {0x00F2, 0x03C2},
    {0x00F3, 0x03C3},
    {0x00F4, 0x03C4},
    {0x00F5, 0x03C5},
    {0x00F6, 0x03C6},
    {0x00F7, 0x03C7},
    {0x00F8, 0x03C8},
    {0x00F9, 0x03C9},
    {0x00FA, 0x03CA},
    {0x00FB, 0x03CB},
    {0x00FC, 0x03CC},
    {0x00FD, 0x03CD},
    {0x00FE, 0x03CE},
};

static const BuiltInMapping iso8859_8[] =
{
    /* iso8859-8 */
    {0x00AA, 0x00D7},
    {0x00BA, 0x00F7},
    {0x00DF, 0x2017},
    {0x00E0, 0x05D0},
    {0x00E1, 0x05D1},
    {0x00E2, 0x05D2},
    {0x00E3, 0x05D3},
    {0x00E4, 0x05D4},
    {0x00E5, 0x05D5},
    {0x00E6, 0x05D6},
    {0x00E7, 0x05D7},
    {0x00E8, 0x05D8},
    {0x00E9, 0x05D9},
    {0x00EA, 0x05DA},
    {0x00EB, 0x05DB},
    {0x00EC, 0x05DC},
    {0x00ED, 0x05DD},
    {0x00EE, 0x05DE},
    {0x00EF, 0x05DF},
    {0x00F0, 0x05E0},
    {0x00F1, 0x05E1},
    {0x00F2, 0x05E2},
    {0x00F3, 0x05E3},
    {0x00F4, 0x05E4},
    {0x00F5, 0x05E5},
    {0x00F6, 0x05E6},
    {0x00F7, 0x05E7},
    {0x00F8, 0x05E8},
    {0x00F9, 0x05E9},
    {0x00FA, 0x05EA},
    {0x00FD, 0x200E},
    {0x00FE, 0x200F},
};

static const BuiltInMapping iso8859_9[] =
{
    /* iso8859-9 */
    {0x00D0, 0x011E},
    {0x00DD, 0x0130},
    {0x00DE, 0x015E},
    {0x00F0, 0x011F},
    {0x00FD, 0x0131},
    {0x00FE, 0x015F},
};

static const BuiltInMapping koi8_e[] =
{
    /* koi8-e */
    {0x00A1, 0x0452},
    {0x00A2, 0x0453},
    {0x00A3, 0x0451},
    {0x00A4, 0x0454},
    {0x00A5, 0x0455},
    {0x00A6, 0x0456},
    {0x00A7, 0x0457},
    {0x00A8, 0x0458},
    {0x00A9, 0x0459},
    {0x00AA, 0x045A},
    {0x00AB, 0x045B},
    {0x00AC, 0x045C},
    {0x00AE, 0x045E},
    {0x00AF, 0x045F},
    {0x00B0, 0x2116},
    {0x00B1, 0x0402},
    {0x00B2, 0x0403},
    {0x00B3, 0x0401},
    {0x00B4, 0x0404},
    {0x00B5, 0x0405},
    {0x00B6, 0x0406},
    {0x00B7, 0x0407},
    {0x00B8, 0x0408},
    {0x00B9, 0x0409},
    {0x00BA, 0x040A},
    {0x00BB, 0x040B},
    {0x00BC, 0x040C},
    {0x00BD, 0x00A4},
    {0x00BE, 0x040E},
    {0x00BF, 0x040F},
    {0x00C0, 0x044E},
    {0x00C1, 0x0430},
    {0x00C2, 0x0431},
    {0x00C3, 0x0446},
    {0x00C4, 0x0434},
    {0x00C5, 0x0435},
    {0x00C6, 0x0444},
    {0x00C7, 0x0433},
    {0x00C8, 0x0445},
    {0x00C9, 0x0438},
    {0x00CA, 0x0439},
    {0x00CB, 0x043A},
    {0x00CC, 0x043B},
    {0x00CD, 0x043C},
    {0x00CE, 0x043D},
    {0x00CF, 0x043E},
    {0x00D0, 0x043F},
    {0x00D1, 0x044F},
    {0x00D2, 0x0440},
    {0x00D3, 0x0441},
    {0x00D4, 0x0442},
    {0x00D5, 0x0443},
    {0x00D6, 0x0436},
    {0x00D7, 0x0432},
    {0x00D8, 0x044C},
    {0x00D9, 0x044B},
    {0x00DA, 0x0437},
    {0x00DB, 0x0448},
    {0x00DC, 0x044D},
    {0x00DD, 0x0449},
    {0x00DE, 0x0447},
    {0x00DF, 0x044A},
    {0x00E0, 0x042E},
    {0x00E1, 0x0410},
    {0x00E2, 0x0411},
    {0x00E3, 0x0426},
    {0x00E4, 0x0414},
    {0x00E5, 0x0415},
    {0x00E6, 0x0424},
    {0x00E7, 0x0413},
    {0x00E8, 0x0425},
    {0x00E9, 0x0418},
    {0x00EA, 0x0419},
    {0x00EB, 0x041A},
    {0x00EC, 0x041B},
    {0x00ED, 0x041C},
    {0x00EE, 0x041D},
    {0x00EF, 0x041E},
    {0x00F0, 0x041F},
    {0x00F1, 0x042F},
    {0x00F2, 0x0420},
    {0x00F3, 0x0421},
    {0x00F4, 0x0422},
    {0x00F5, 0x0423},
    {0x00F6, 0x0416},
    {0x00F7, 0x0412},
    {0x00F8, 0x042C},
    {0x00F9, 0x042B},
    {0x00FA, 0x0417},
    {0x00FB, 0x0428},
    {0x00FC, 0x042D},
    {0x00FD, 0x0429},
    {0x00FE, 0x0427},
    {0x00FF, 0x042A},
};

static const BuiltInMapping koi8_r[] =
{
    /* koi8-r */
    {0x0080, 0x2500},
    {0x0081, 0x2502},
    {0x0082, 0x250C},
    {0x0083, 0x2510},
    {0x0084, 0x2514},
    {0x0085, 0x2518},
    {0x0086, 0x251C},
    {0x0087, 0x2524},
    {0x0088, 0x252C},
    {0x0089, 0x2534},
    {0x008A, 0x253C},
    {0x008B, 0x2580},
    {0x008C, 0x2584},
    {0x008D, 0x2588},
    {0x008E, 0x258C},
    {0x008F, 0x2590},
    {0x0090, 0x2591},
    {0x0091, 0x2592},
    {0x0092, 0x2593},
    {0x0093, 0x2320},
    {0x0094, 0x25A0},
    {0x0095, 0x2219},
    {0x0096, 0x221A},
    {0x0097, 0x2248},
    {0x0098, 0x2264},
    {0x0099, 0x2265},
    {0x009A, 0x00A0},
    {0x009B, 0x2321},
    {0x009C, 0x00B0},
    {0x009D, 0x00B2},
    {0x009E, 0x00B7},
    {0x009F, 0x00F7},
    {0x00A0, 0x2550},
    {0x00A1, 0x2551},
    {0x00A2, 0x2552},
    {0x00A3, 0x0451},
    {0x00A4, 0x2553},
    {0x00A5, 0x2554},
    {0x00A6, 0x2555},
    {0x00A7, 0x2556},
    {0x00A8, 0x2557},
    {0x00A9, 0x2558},
    {0x00AA, 0x2559},
    {0x00AB, 0x255A},
    {0x00AC, 0x255B},
    {0x00AD, 0x255C},
    {0x00AE, 0x255D},
    {0x00AF, 0x255E},
    {0x00B0, 0x255F},
    {0x00B1, 0x2560},
    {0x00B2, 0x2561},
    {0x00B3, 0x0401},
    {0x00B4, 0x2562},
    {0x00B5, 0x2563},
    {0x00B6, 0x2564},
    {0x00B7, 0x2565},
    {0x00B8, 0x2566},
    {0x00B9, 0x2567},
    {0x00BA, 0x2568},
    {0x00BB, 0x2569},
    {0x00BC, 0x256A},
    {0x00BD, 0x256B},
    {0x00BE, 0x256C},
    {0x00BF, 0x00A9},
    {0x00C0, 0x044E},
    {0x00C1, 0x0430},
    {0x00C2, 0x0431},
    {0x00C3, 0x0446},
    {0x00C4, 0x0434},
    {0x00C5, 0x0435},
    {0x00C6, 0x0444},
    {0x00C7, 0x0433},
    {0x00C8, 0x0445},
    {0x00C9, 0x0438},
    {0x00CA, 0x0439},
    {0x00CB, 0x043A},
    {0x00CC, 0x043B},
    {0x00CD, 0x043C},
    {0x00CE, 0x043D},
    {0x00CF, 0x043E},
    {0x00D0, 0x043F},
    {0x00D1, 0x044F},
    {0x00D2, 0x0440},
    {0x00D3, 0x0441},
    {0x00D4, 0x0442},
    {0x00D5, 0x0443},
    {0x00D6, 0x0436},
    {0x00D7, 0x0432},
    {0x00D8, 0x044C},
    {0x00D9, 0x044B},
    {0x00DA, 0x0437},
    {0x00DB, 0x0448},
    {0x00DC, 0x044D},
    {0x00DD, 0x0449},
    {0x00DE, 0x0447},
    {0x00DF, 0x044A},
    {0x00E0, 0x042E},
    {0x00E1, 0x0410},
    {0x00E2, 0x0411},
    {0x00E3, 0x0426},
    {0x00E4, 0x0414},
    {0x00E5, 0x0415},
    {0x00E6, 0x0424},
    {0x00E7, 0x0413},
    {0x00E8, 0x0425},
    {0x00E9, 0x0418},
    {0x00EA, 0x0419},
    {0x00EB, 0x041A},
    {0x00EC, 0x041B},
    {0x00ED, 0x041C},
    {0x00EE, 0x041D},
    {0x00EF, 0x041E},
    {0x00F0, 0x041F},
    {0x00F1, 0x042F},
    {0x00F2, 0x0420},
    {0x00F3, 0x0421},
    {0x00F4, 0x0422},
    {0x00F5, 0x0423},
    {0x00F6, 0x0416},
    {0x00F7, 0x0412},
    {0x00F8, 0x042C},
    {0x00F9, 0x042B},
    {0x00FA, 0x0417},
    {0x00FB, 0x0428},
    {0x00FC, 0x042D},
    {0x00FD, 0x0429},
    {0x00FE, 0x0427},
    {0x00FF, 0x042A},
};

static const BuiltInMapping koi8_ru[] =
{
    /* koi8-ru */
    {0x0080, 0x2500},
    {0x0081, 0x2502},
    {0x0082, 0x250C},
    {0x0083, 0x2510},
    {0x0084, 0x2514},
    {0x0085, 0x2518},
    {0x0086, 0x251C},
    {0x0087, 0x2524},
    {0x0088, 0x252C},
    {0x0089, 0x2534},
    {0x008A, 0x253C},
    {0x008B, 0x2580},
    {0x008C, 0x2584},
    {0x008D, 0x2588},
    {0x008E, 0x258C},
    {0x008F, 0x2590},
    {0x0090, 0x2591},
    {0x0091, 0x2592},
    {0x0092, 0x2593},
    {0x0093, 0x201C},
    {0x0094, 0x25A0},
    {0x0095, 0x2219},
    {0x0096, 0x201D},
    {0x0097, 0x2014},
    {0x0098, 0x2116},
    {0x0099, 0x2122},
    {0x009A, 0x00A0},
    {0x009B, 0x00BB},
    {0x009C, 0x00AE},
    {0x009D, 0x00AB},
    {0x009E, 0x00B7},
    {0x009F, 0x00A4},
    {0x00A0, 0x2550},
    {0x00A1, 0x2551},
    {0x00A2, 0x2552},
    {0x00A3, 0x0451},
    {0x00A4, 0x0454},
    {0x00A5, 0x2554},
    {0x00A6, 0x0456},
    {0x00A7, 0x0457},
    {0x00A8, 0x2557},
    {0x00A9, 0x2558},
    {0x00AA, 0x2559},
    {0x00AB, 0x255A},
    {0x00AC, 0x255B},
    {0x00AD, 0x0491},
    {0x00AE, 0x045E},
    {0x00AF, 0x255E},
    {0x00B0, 0x255F},
    {0x00B1, 0x2560},
    {0x00B2, 0x2561},
    {0x00B3, 0x0401},
    {0x00B4, 0x0404},
    {0x00B5, 0x2563},
    {0x00B6, 0x0406},
    {0x00B7, 0x0407},
    {0x00B8, 0x2566},
    {0x00B9, 0x2567},
    {0x00BA, 0x2568},
    {0x00BB, 0x2569},
    {0x00BC, 0x256A},
    {0x00BD, 0x0490},
    {0x00BE, 0x040E},
    {0x00BF, 0x00A9},
    {0x00C0, 0x044E},
    {0x00C1, 0x0430},
    {0x00C2, 0x0431},
    {0x00C3, 0x0446},
    {0x00C4, 0x0434},
    {0x00C5, 0x0435},
    {0x00C6, 0x0444},
    {0x00C7, 0x0433},
    {0x00C8, 0x0445},
    {0x00C9, 0x0438},
    {0x00CA, 0x0439},
    {0x00CB, 0x043A},
    {0x00CC, 0x043B},
    {0x00CD, 0x043C},
    {0x00CE, 0x043D},
    {0x00CF, 0x043E},
    {0x00D0, 0x043F},
    {0x00D1, 0x044F},
    {0x00D2, 0x0440},
    {0x00D3, 0x0441},
    {0x00D4, 0x0442},
    {0x00D5, 0x0443},
    {0x00D6, 0x0436},
    {0x00D7, 0x0432},
    {0x00D8, 0x044C},
    {0x00D9, 0x044B},
    {0x00DA, 0x0437},
    {0x00DB, 0x0448},
    {0x00DC, 0x044D},
    {0x00DD, 0x0449},
    {0x00DE, 0x0447},
    {0x00DF, 0x044A},
    {0x00E0, 0x042E},
    {0x00E1, 0x0410},
    {0x00E2, 0x0411},
    {0x00E3, 0x0426},
    {0x00E4, 0x0414},
    {0x00E5, 0x0415},
    {0x00E6, 0x0424},
    {0x00E7, 0x0413},
    {0x00E8, 0x0425},
    {0x00E9, 0x0418},
    {0x00EA, 0x0419},
    {0x00EB, 0x041A},
    {0x00EC, 0x041B},
    {0x00ED, 0x041C},
    {0x00EE, 0x041D},
    {0x00EF, 0x041E},
    {0x00F0, 0x041F},
    {0x00F1, 0x042F},
    {0x00F2, 0x0420},
    {0x00F3, 0x0421},
    {0x00F4, 0x0422},
    {0x00F5, 0x0423},
    {0x00F6, 0x0416},
    {0x00F7, 0x0412},
    {0x00F8, 0x042C},
    {0x00F9, 0x042B},
    {0x00FA, 0x0417},
    {0x00FB, 0x0428},
    {0x00FC, 0x042D},
    {0x00FD, 0x0429},
    {0x00FE, 0x0427},
    {0x00FF, 0x042A},
};

static const BuiltInMapping koi8_u[] =
{
    /* koi8-u */
    {0x0080, 0x2500},
    {0x0081, 0x2502},
    {0x0082, 0x250C},
    {0x0083, 0x2510},
    {0x0084, 0x2514},
    {0x0085, 0x2518},
    {0x0086, 0x251C},
    {0x0087, 0x2524},
    {0x0088, 0x252C},
    {0x0089, 0x2534},
    {0x008A, 0x253C},
    {0x008B, 0x2580},
    {0x008C, 0x2584},
    {0x008D, 0x2588},
    {0x008E, 0x258C},
    {0x008F, 0x2590},
    {0x0090, 0x2591},
    {0x0091, 0x2592},
    {0x0092, 0x2593},
    {0x0093, 0x2320},
    {0x0094, 0x25A0},
    {0x0095, 0x2219},
    {0x0096, 0x221A},
    {0x0097, 0x2248},
    {0x0098, 0x2264},
    {0x0099, 0x2265},
    {0x009A, 0x00A0},
    {0x009B, 0x2321},
    {0x009C, 0x00B0},
    {0x009D, 0x00B2},
    {0x009E, 0x00B7},
    {0x009F, 0x00F7},
    {0x00A0, 0x2550},
    {0x00A1, 0x2551},
    {0x00A2, 0x2552},
    {0x00A3, 0x0451},
    {0x00A4, 0x0454},
    {0x00A5, 0x2554},
    {0x00A6, 0x0456},
    {0x00A7, 0x0457},
    {0x00A8, 0x2557},
    {0x00A9, 0x2558},
    {0x00AA, 0x2559},
    {0x00AB, 0x255A},
    {0x00AC, 0x255B},
    {0x00AD, 0x0491},
    {0x00AE, 0x255D},
    {0x00AF, 0x255E},
    {0x00B0, 0x255F},
    {0x00B1, 0x2560},
    {0x00B2, 0x2561},
    {0x00B3, 0x0401},
    {0x00B4, 0x0404},
    {0x00B5, 0x2563},
    {0x00B6, 0x0406},
    {0x00B7, 0x0407},
    {0x00B8, 0x2566},
    {0x00B9, 0x2567},
    {0x00BA, 0x2568},
    {0x00BB, 0x2569},
    {0x00BC, 0x256A},
    {0x00BD, 0x0490},
    {0x00BE, 0x256C},
    {0x00BF, 0x00A9},
    {0x00C0, 0x044E},
    {0x00C1, 0x0430},
    {0x00C2, 0x0431},
    {0x00C3, 0x0446},
    {0x00C4, 0x0434},
    {0x00C5, 0x0435},
    {0x00C6, 0x0444},
    {0x00C7, 0x0433},
    {0x00C8, 0x0445},
    {0x00C9, 0x0438},
    {0x00CA, 0x0439},
    {0x00CB, 0x043A},
    {0x00CC, 0x043B},
    {0x00CD, 0x043C},
    {0x00CE, 0x043D},
    {0x00CF, 0x043E},
    {0x00D0, 0x043F},
    {0x00D1, 0x044F},
    {0x00D2, 0x0440},
    {0x00D3, 0x0441},
    {0x00D4, 0x0442},
    {0x00D5, 0x0443},
    {0x00D6, 0x0436},
    {0x00D7, 0x0432},
    {0x00D8, 0x044C},
    {0x00D9, 0x044B},
    {0x00DA, 0x0437},
    {0x00DB, 0x0448},
    {0x00DC, 0x044D},
    {0x00DD, 0x0449},
    {0x00DE, 0x0447},
    {0x00DF, 0x044A},
    {0x00E0, 0x042E},
    {0x00E1, 0x0410},
    {0x00E2, 0x0411},
    {0x00E3, 0x0426},
    {0x00E4, 0x0414},
    {0x00E5, 0x0415},
    {0x00E6, 0x0424},
    {0x00E7, 0x0413},
    {0x00E8, 0x0425},
    {0x00E9, 0x0418},
    {0x00EA, 0x0419},
    {0x00EB, 0x041A},
    {0x00EC, 0x041B},
    {0x00ED, 0x041C},
    {0x00EE, 0x041D},
    {0x00EF, 0x041E},
    {0x00F0, 0x041F},
    {0x00F1, 0x042F},
    {0x00F2, 0x0420},
    {0x00F3, 0x0421},
    {0x00F4, 0x0422},
    {0x00F5, 0x0423},
    {0x00F6, 0x0416},
    {0x00F7, 0x0412},
    {0x00F8, 0x042C},
    {0x00F9, 0x042B},
    {0x00FA, 0x0417},
    {0x00FB, 0x0428},
    {0x00FC, 0x042D},
    {0x00FD, 0x0429},
    {0x00FE, 0x0427},
    {0x00FF, 0x042A},
};

#define DATA(name) name, SizeOf(name)
const BuiltInCharsetRec builtin_encodings[] =
{
    { "dec-special", DATA(dec_special) },
    { "dec-technical", DATA(dec_technical) },
    { "iso8859-1", DATA(iso8859_1) },
    { "iso8859-10", DATA(iso8859_10) },
    { "iso8859-15", DATA(iso8859_15) },
    { "iso8859-2", DATA(iso8859_2) },
    { "iso8859-3", DATA(iso8859_3) },
    { "iso8859-4", DATA(iso8859_4) },
    { "iso8859-5", DATA(iso8859_5) },
    { "iso8859-6", DATA(iso8859_6) },
    { "iso8859-7", DATA(iso8859_7) },
    { "iso8859-8", DATA(iso8859_8) },
    { "iso8859-9", DATA(iso8859_9) },
    { "koi8-e", DATA(koi8_e) },
    { "koi8-r", DATA(koi8_r) },
    { "koi8-ru", DATA(koi8_ru) },
    { "koi8-u", DATA(koi8_u) },
    { 0, 0, 0 }
};
