.TH DP %manext8% "March 6, 2012" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
dp \- parse dates 822-style
.SH SYNOPSIS
.HP 5
.na
.B %libdir%/dp
.RB [ \-form
.IR formatfile ]
.RB [ \-format
.IR string ]
.RB [ \-width
.IR columns ]
.RB [ \-version ]
.RB [ \-help ] 
.I dates
\&...
.ad
.SH DESCRIPTION
.B Dp
is a program that parses dates according to the ARPA Internet standard.
It also understands many non\-standard formats,
such as those produced by TOPS\-20 sites and some UNIX sites using
.IR ctime (3).
It is useful for seeing how
.B nmh
will interpret a date.
.PP
The
.B dp
program treats each argument as a single date,
and prints the date out in the official 822\-format.
Hence, it is usually best to enclose each argument in quotes for the
shell.
.PP
To override the output format used by
.BR dp ,
the
.B \-format
.I string
or
.B \-format
.I file
switches are used.
This permits individual fields of the address to be extracted with ease.
The string is simply a format string and the file is simply a format file.
See
.IR mh\-format (5)
for the details.
.PP
Here is the default format string used by
.BR dp :
.PP
.RS 5
%<(nodate{text})error: %{text}%|%(putstr(pretty{text}))%>
.RE
.PP
which says that if an error was detected, print the error, a `:',
and the date in error.
Otherwise, output the 822\-proper format of the date.
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
.fi
.SH "PROFILE COMPONENTS"
None
.SH "SEE ALSO"
.IR ap (8),
.PP
.I "Standard for the Format of ARPA Internet Text Messages"
(RFC\-822)
.SH DEFAULTS
.nf
.RB ` \-format "' default as described above"
.RB ` \-width "' default to the width of the terminal"
.fi
.SH CONTEXT
None
.SH BUGS
The argument to the
.B \-format
switch must be interpreted as a single token by the shell that invokes
.BR dp .
Therefore, one must usually place the argument to this switch inside quotes.
