#include <stdlib.h>
#include <stdio.h>
#include <pth.h>
#include <string.h>
#include <sys/errno.h>

void *test (void *arg);

int
main (int argc, char *argv[])
{
  int err;
  pth_t thread;
  void *threadrv;

  if ((err = pth_init ()) != TRUE)
    {
      printf ("Error on pth_init: %d: %s\n", errno, strerror (errno));
      exit (1);
    }

  if ((thread = pth_spawn (PTH_ATTR_DEFAULT, test, NULL)) == (pid_t) NULL)
    {
      printf ("Error on pth_spawn: %d: %s\n", errno, strerror (errno));
      exit (1);
    }

  if ((err = pth_join (thread, &threadrv)) != TRUE)
    {
      printf ("Error on pthread_join %d: %s\n", errno, strerror (errno));
      exit (1);
    }
  return 0;
}

void *
test (void *arg)
{
  int pid;

  pid = fork ();
  if (pid < 0)
    {
      printf ("FORKFAILED\n");
    }
  else if (pid == 0)
    {
      printf ("FORKCHILD: mypid=%d\n", getpid ());
    }
  else
    {
      printf ("FORKPARENT: mypid=%d childpid=%d\n", getpid (), pid);
    }
}

