/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInt32Array.h"

#include "ExceptionCode.h"
#include "JSArrayBufferViewHelper.h"
#include "JSDOMBinding.h"
#include "JSInt32Array.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>
#include <wtf/Int32Array.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSInt32ArrayTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInt32ArrayLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInt32ArrayConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInt32ArrayTable = { 5, 3, JSInt32ArrayTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSInt32ArrayConstructorTableValues[] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInt32ArrayBYTES_PER_ELEMENT), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInt32ArrayConstructorTable = { 2, 1, JSInt32ArrayConstructorTableValues, 0 };
static const HashTable* getJSInt32ArrayConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSInt32ArrayConstructorTable);
}

const ClassInfo JSInt32ArrayConstructor::s_info = { "Int32ArrayConstructor", &Base::s_info, 0, getJSInt32ArrayConstructorTable, CREATE_METHOD_TABLE(JSInt32ArrayConstructor) };

JSInt32ArrayConstructor::JSInt32ArrayConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSInt32ArrayConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSInt32ArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSInt32ArrayConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSInt32ArrayConstructor, JSDOMWrapper>(exec, getJSInt32ArrayConstructorTable(exec), jsCast<JSInt32ArrayConstructor*>(cell), propertyName, slot);
}

bool JSInt32ArrayConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSInt32ArrayConstructor, JSDOMWrapper>(exec, getJSInt32ArrayConstructorTable(exec), jsCast<JSInt32ArrayConstructor*>(object), propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSInt32ArrayConstructor::constructJSInt32Array(ExecState* exec)
{
    JSInt32ArrayConstructor* jsConstructor = jsCast<JSInt32ArrayConstructor*>(exec->callee());
    RefPtr<Int32Array> array = constructArrayBufferView<Int32Array, int>(exec);
    if (!array.get())
        // Exception has already been thrown.
        return JSValue::encode(JSValue());
    return JSValue::encode(asObject(toJS(exec, jsConstructor->globalObject(), array.get())));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Int32Array* object)
{
    return toJSArrayBufferView<JSInt32Array>(exec, globalObject, object);
}

void JSInt32Array::indexSetter(JSC::ExecState* exec, unsigned index, JSC::JSValue value)
{
    impl()->set(index, value.toNumber(exec));
}

ConstructType JSInt32ArrayConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSInt32Array;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSInt32ArrayPrototypeTableValues[] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInt32ArrayBYTES_PER_ELEMENT), (intptr_t)0, NoIntrinsic },
    { "subarray", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInt32ArrayPrototypeFunctionSubarray), (intptr_t)2, NoIntrinsic },
    { "set", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInt32ArrayPrototypeFunctionSet), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInt32ArrayPrototypeTable = { 8, 7, JSInt32ArrayPrototypeTableValues, 0 };
static const HashTable* getJSInt32ArrayPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSInt32ArrayPrototypeTable);
}

const ClassInfo JSInt32ArrayPrototype::s_info = { "Int32ArrayPrototype", &Base::s_info, 0, getJSInt32ArrayPrototypeTable, CREATE_METHOD_TABLE(JSInt32ArrayPrototype) };

JSObject* JSInt32ArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInt32Array>(exec, globalObject);
}

bool JSInt32ArrayPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInt32ArrayPrototype* thisObject = jsCast<JSInt32ArrayPrototype*>(cell);
    return getStaticPropertySlot<JSInt32ArrayPrototype, JSObject>(exec, getJSInt32ArrayPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSInt32ArrayPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInt32ArrayPrototype* thisObject = jsCast<JSInt32ArrayPrototype*>(object);
    return getStaticPropertyDescriptor<JSInt32ArrayPrototype, JSObject>(exec, getJSInt32ArrayPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSInt32ArrayTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSInt32ArrayTable);
}

const ClassInfo JSInt32Array::s_info = { "Int32Array", &Base::s_info, 0, getJSInt32ArrayTable , CREATE_METHOD_TABLE(JSInt32Array) };

JSInt32Array::JSInt32Array(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Int32Array> impl)
    : JSArrayBufferView(structure, globalObject, impl)
{
}

void JSInt32Array::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    TypedArrayDescriptor descriptor(&JSInt32Array::s_info, OBJECT_OFFSETOF(JSInt32Array, m_storage), OBJECT_OFFSETOF(JSInt32Array, m_storageLength));
    globalData.registerTypedArrayDescriptor(impl(), descriptor);
    m_storage = impl()->data();
    m_storageLength = impl()->length();
    ASSERT(inherits(&s_info));
}

JSObject* JSInt32Array::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSInt32ArrayPrototype::create(exec->globalData(), globalObject, JSInt32ArrayPrototype::createStructure(exec->globalData(), globalObject, JSArrayBufferViewPrototype::self(exec, globalObject)));
}

bool JSInt32Array::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInt32Array* thisObject = jsCast<JSInt32Array*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<Int32Array*>(thisObject->impl())->length()) {
        slot.setValue(thisObject->getByIndex(exec, index));
        return true;
    }
    return getStaticValueSlot<JSInt32Array, Base>(exec, getJSInt32ArrayTable(exec), thisObject, propertyName, slot);
}

bool JSInt32Array::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInt32Array* thisObject = jsCast<JSInt32Array*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<Int32Array*>(thisObject->impl())->length()) {
        descriptor.setDescriptor(thisObject->getByIndex(exec, index), DontDelete);
        return true;
    }
    return getStaticValueDescriptor<JSInt32Array, Base>(exec, getJSInt32ArrayTable(exec), thisObject, propertyName, descriptor);
}

bool JSInt32Array::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSInt32Array* thisObject = jsCast<JSInt32Array*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<Int32Array*>(thisObject->impl())->length()) {
        slot.setValue(thisObject->getByIndex(exec, index));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsInt32ArrayLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSInt32Array* castedThis = jsCast<JSInt32Array*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Int32Array* impl = static_cast<Int32Array*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsInt32ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSInt32Array* domObject = jsCast<JSInt32Array*>(asObject(slotBase));
    return JSInt32Array::getConstructor(exec, domObject->globalObject());
}

void JSInt32Array::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSInt32Array* thisObject = jsCast<JSInt32Array*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex) {
        thisObject->indexSetter(exec, index, value);
        return;
    }
    Base::put(thisObject, exec, propertyName, value, slot);
}

void JSInt32Array::putByIndex(JSCell* cell, ExecState* exec, unsigned index, JSValue value, bool shouldThrow)
{
    JSInt32Array* thisObject = jsCast<JSInt32Array*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index <= MAX_ARRAY_INDEX) {
        UNUSED_PARAM(shouldThrow);
        thisObject->indexSetter(exec, index, value);
        return;
    }
    Base::putByIndex(cell, exec, index, value, shouldThrow);
}

void JSInt32Array::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSInt32Array* thisObject = jsCast<JSInt32Array*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<Int32Array*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSInt32Array::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSInt32ArrayConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsInt32ArrayPrototypeFunctionSubarray(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInt32Array::s_info))
        return throwVMTypeError(exec);
    JSInt32Array* castedThis = jsCast<JSInt32Array*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInt32Array::s_info);
    Int32Array* impl = static_cast<Int32Array*>(castedThis->impl());
    int start(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->subarray(start)));
        return JSValue::encode(result);
    }

    int end(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->subarray(start, end)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInt32ArrayPrototypeFunctionSet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInt32Array::s_info))
        return throwVMTypeError(exec);
    JSInt32Array* castedThis = jsCast<JSInt32Array*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInt32Array::s_info);
    return JSValue::encode(setWebGLArrayHelper<Int32Array, int>(exec, castedThis->impl()));
}

// Constant getters

JSValue jsInt32ArrayBYTES_PER_ELEMENT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}


JSValue JSInt32Array::getByIndex(ExecState*, unsigned index)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    double result = static_cast<Int32Array*>(impl())->item(index);
    if (isnan(result))
        return jsNaN();
    return JSValue(result);
}

Int32Array* toInt32Array(JSC::JSValue value)
{
    return value.inherits(&JSInt32Array::s_info) ? jsCast<JSInt32Array*>(asObject(value))->impl() : 0;
}

}
