/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFEPointLightElement.h"

#include "JSSVGAnimatedNumber.h"
#include "SVGFEPointLightElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFEPointLightElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEPointLightElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEPointLightElementY), (intptr_t)0, NoIntrinsic },
    { "z", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEPointLightElementZ), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEPointLightElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEPointLightElementTable = { 9, 7, JSSVGFEPointLightElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFEPointLightElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEPointLightElementConstructorTable = { 1, 0, JSSVGFEPointLightElementConstructorTableValues, 0 };
const ClassInfo JSSVGFEPointLightElementConstructor::s_info = { "SVGFEPointLightElementConstructor", &Base::s_info, &JSSVGFEPointLightElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFEPointLightElementConstructor) };

JSSVGFEPointLightElementConstructor::JSSVGFEPointLightElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEPointLightElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFEPointLightElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFEPointLightElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEPointLightElementConstructor, JSDOMWrapper>(exec, &JSSVGFEPointLightElementConstructorTable, jsCast<JSSVGFEPointLightElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFEPointLightElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEPointLightElementConstructor, JSDOMWrapper>(exec, &JSSVGFEPointLightElementConstructorTable, jsCast<JSSVGFEPointLightElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEPointLightElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEPointLightElementPrototypeTable = { 1, 0, JSSVGFEPointLightElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEPointLightElementPrototype::s_info = { "SVGFEPointLightElementPrototype", &Base::s_info, &JSSVGFEPointLightElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFEPointLightElementPrototype) };

JSObject* JSSVGFEPointLightElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEPointLightElement>(exec, globalObject);
}

const ClassInfo JSSVGFEPointLightElement::s_info = { "SVGFEPointLightElement", &Base::s_info, &JSSVGFEPointLightElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFEPointLightElement) };

JSSVGFEPointLightElement::JSSVGFEPointLightElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEPointLightElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGFEPointLightElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEPointLightElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEPointLightElementPrototype::create(exec->globalData(), globalObject, JSSVGFEPointLightElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEPointLightElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEPointLightElement* thisObject = jsCast<JSSVGFEPointLightElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFEPointLightElement, Base>(exec, &JSSVGFEPointLightElementTable, thisObject, propertyName, slot);
}

bool JSSVGFEPointLightElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEPointLightElement* thisObject = jsCast<JSSVGFEPointLightElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFEPointLightElement, Base>(exec, &JSSVGFEPointLightElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFEPointLightElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEPointLightElement* castedThis = jsCast<JSSVGFEPointLightElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEPointLightElement* impl = static_cast<SVGFEPointLightElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEPointLightElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEPointLightElement* castedThis = jsCast<JSSVGFEPointLightElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEPointLightElement* impl = static_cast<SVGFEPointLightElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEPointLightElementZ(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEPointLightElement* castedThis = jsCast<JSSVGFEPointLightElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEPointLightElement* impl = static_cast<SVGFEPointLightElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->zAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEPointLightElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEPointLightElement* domObject = jsCast<JSSVGFEPointLightElement*>(asObject(slotBase));
    return JSSVGFEPointLightElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFEPointLightElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEPointLightElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
