/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPolygonElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGPointList.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGMatrix.h"
#include "SVGPointList.h"
#include "SVGPolygonElement.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPolygonElementTableValues[] =
{
    { "points", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementPoints), (intptr_t)0, NoIntrinsic },
    { "animatedPoints", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementAnimatedPoints), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementXmllang), (intptr_t)setJSSVGPolygonElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementXmlspace), (intptr_t)setJSSVGPolygonElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolygonElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPolygonElementTable = { 34, 31, JSSVGPolygonElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPolygonElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPolygonElementConstructorTable = { 1, 0, JSSVGPolygonElementConstructorTableValues, 0 };
const ClassInfo JSSVGPolygonElementConstructor::s_info = { "SVGPolygonElementConstructor", &Base::s_info, &JSSVGPolygonElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPolygonElementConstructor) };

JSSVGPolygonElementConstructor::JSSVGPolygonElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPolygonElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGPolygonElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGPolygonElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPolygonElementConstructor, JSDOMWrapper>(exec, &JSSVGPolygonElementConstructorTable, jsCast<JSSVGPolygonElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGPolygonElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPolygonElementConstructor, JSDOMWrapper>(exec, &JSSVGPolygonElementConstructorTable, jsCast<JSSVGPolygonElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPolygonElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPolygonElementPrototypeFunctionHasExtension), (intptr_t)1, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPolygonElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPolygonElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPolygonElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPolygonElementPrototypeFunctionGetTransformToElement), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPolygonElementPrototypeTable = { 17, 15, JSSVGPolygonElementPrototypeTableValues, 0 };
const ClassInfo JSSVGPolygonElementPrototype::s_info = { "SVGPolygonElementPrototype", &Base::s_info, &JSSVGPolygonElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPolygonElementPrototype) };

JSObject* JSSVGPolygonElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPolygonElement>(exec, globalObject);
}

bool JSSVGPolygonElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPolygonElementPrototype* thisObject = jsCast<JSSVGPolygonElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPolygonElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGPolygonElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPolygonElementPrototype* thisObject = jsCast<JSSVGPolygonElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGPolygonElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGPolygonElement::s_info = { "SVGPolygonElement", &Base::s_info, &JSSVGPolygonElementTable, 0 , CREATE_METHOD_TABLE(JSSVGPolygonElement) };

JSSVGPolygonElement::JSSVGPolygonElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPolygonElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGPolygonElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPolygonElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPolygonElementPrototype::create(exec->globalData(), globalObject, JSSVGPolygonElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGPolygonElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPolygonElement* thisObject = jsCast<JSSVGPolygonElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPolygonElement, Base>(exec, &JSSVGPolygonElementTable, thisObject, propertyName, slot);
}

bool JSSVGPolygonElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPolygonElement* thisObject = jsCast<JSSVGPolygonElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPolygonElement, Base>(exec, &JSSVGPolygonElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPolygonElementPoints(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->points()));
    return result;
}


JSValue jsSVGPolygonElementAnimatedPoints(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->animatedPoints()));
    return result;
}


JSValue jsSVGPolygonElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGPolygonElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGPolygonElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGPolygonElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGPolygonElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGPolygonElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGPolygonElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGPolygonElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGPolygonElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGPolygonElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolygonElement* domObject = jsCast<JSSVGPolygonElement*>(asObject(slotBase));
    return JSSVGPolygonElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGPolygonElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGPolygonElement* thisObject = jsCast<JSSVGPolygonElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGPolygonElement, Base>(exec, propertyName, value, &JSSVGPolygonElementTable, thisObject, slot);
}

void setJSSVGPolygonElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(thisObject);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGPolygonElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(thisObject);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGPolygonElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPolygonElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGPolygonElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPolygonElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPolygonElement::s_info);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPolygonElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPolygonElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPolygonElement::s_info);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPolygonElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPolygonElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPolygonElement::s_info);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPolygonElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPolygonElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPolygonElement::s_info);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPolygonElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPolygonElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPolygonElement* castedThis = jsCast<JSSVGPolygonElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPolygonElement::s_info);
    SVGPolygonElement* impl = static_cast<SVGPolygonElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
