/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLObjectElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDocumentPrivate.h"
#include "WebKitDOMHTMLFormElementPrivate.h"
#include "WebKitDOMHTMLObjectElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMValidityStatePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLObjectElement* kit(WebCore::HTMLObjectElement* obj)
{
    return WEBKIT_DOM_HTML_OBJECT_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLObjectElement* core(WebKitDOMHTMLObjectElement* request)
{
    return request ? static_cast<WebCore::HTMLObjectElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLObjectElement* wrapHTMLObjectElement(WebCore::HTMLObjectElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_OBJECT_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_OBJECT_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLObjectElement, webkit_dom_html_object_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_FORM,
    PROP_CODE,
    PROP_ALIGN,
    PROP_ARCHIVE,
    PROP_BORDER,
    PROP_CODE_BASE,
    PROP_CODE_TYPE,
    PROP_DATA,
    PROP_DECLARE,
    PROP_HEIGHT,
    PROP_HSPACE,
    PROP_NAME,
    PROP_STANDBY,
    PROP_TYPE,
    PROP_USE_MAP,
    PROP_VSPACE,
    PROP_WIDTH,
    PROP_WILL_VALIDATE,
    PROP_VALIDITY,
    PROP_VALIDATION_MESSAGE,
    PROP_CONTENT_DOCUMENT,
};

static void webkit_dom_html_object_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLObjectElement* self = WEBKIT_DOM_HTML_OBJECT_ELEMENT(object);
    WebCore::HTMLObjectElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_CODE: {
        coreSelf->setAttribute(WebCore::HTMLNames::codeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::alignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ARCHIVE: {
        coreSelf->setAttribute(WebCore::HTMLNames::archiveAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_BORDER: {
        coreSelf->setAttribute(WebCore::HTMLNames::borderAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CODE_BASE: {
        coreSelf->setAttribute(WebCore::HTMLNames::codebaseAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CODE_TYPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::codetypeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DATA: {
        coreSelf->setAttribute(WebCore::HTMLNames::dataAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DECLARE: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::declareAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_HEIGHT: {
        coreSelf->setAttribute(WebCore::HTMLNames::heightAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HSPACE: {
        coreSelf->setIntegralAttribute(WebCore::HTMLNames::hspaceAttr, (g_value_get_long(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_STANDBY: {
        coreSelf->setAttribute(WebCore::HTMLNames::standbyAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TYPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::typeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_USE_MAP: {
        coreSelf->setAttribute(WebCore::HTMLNames::usemapAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_VSPACE: {
        coreSelf->setIntegralAttribute(WebCore::HTMLNames::vspaceAttr, (g_value_get_long(value)));
        break;
    }
    case PROP_WIDTH: {
        coreSelf->setAttribute(WebCore::HTMLNames::widthAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_object_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLObjectElement* self = WEBKIT_DOM_HTML_OBJECT_ELEMENT(object);
    WebCore::HTMLObjectElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_FORM: {
        RefPtr<WebCore::HTMLFormElement> ptr = coreSelf->form();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CODE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::codeAttr)));
        break;
    }
    case PROP_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::alignAttr)));
        break;
    }
    case PROP_ARCHIVE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::archiveAttr)));
        break;
    }
    case PROP_BORDER: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::borderAttr)));
        break;
    }
    case PROP_CODE_BASE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::codebaseAttr)));
        break;
    }
    case PROP_CODE_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::codetypeAttr)));
        break;
    }
    case PROP_DATA: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::dataAttr)));
        break;
    }
    case PROP_DECLARE: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::declareAttr));
        break;
    }
    case PROP_HEIGHT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::heightAttr)));
        break;
    }
    case PROP_HSPACE: {
        g_value_set_long(value, coreSelf->getIntegralAttribute(WebCore::HTMLNames::hspaceAttr));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_STANDBY: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::standbyAttr)));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::typeAttr)));
        break;
    }
    case PROP_USE_MAP: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::usemapAttr)));
        break;
    }
    case PROP_VSPACE: {
        g_value_set_long(value, coreSelf->getIntegralAttribute(WebCore::HTMLNames::vspaceAttr));
        break;
    }
    case PROP_WIDTH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::widthAttr)));
        break;
    }
    case PROP_WILL_VALIDATE: {
        g_value_set_boolean(value, coreSelf->willValidate());
        break;
    }
    case PROP_VALIDITY: {
        RefPtr<WebCore::ValidityState> ptr = coreSelf->validity();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_VALIDATION_MESSAGE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->validationMessage()));
        break;
    }
    case PROP_CONTENT_DOCUMENT: {
        RefPtr<WebCore::Document> ptr = coreSelf->contentDocument();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_object_element_class_init(WebKitDOMHTMLObjectElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_object_element_set_property;
    gobjectClass->get_property = webkit_dom_html_object_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_FORM,
                                    g_param_spec_object("form", /* name */
                                                           "html_object_element_form", /* short description */
                                                           "read-only  WebKitDOMHTMLFormElement* HTMLObjectElement.form", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_FORM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CODE,
                                    g_param_spec_string("code", /* name */
                                                           "html_object_element_code", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.code", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALIGN,
                                    g_param_spec_string("align", /* name */
                                                           "html_object_element_align", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ARCHIVE,
                                    g_param_spec_string("archive", /* name */
                                                           "html_object_element_archive", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.archive", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BORDER,
                                    g_param_spec_string("border", /* name */
                                                           "html_object_element_border", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.border", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CODE_BASE,
                                    g_param_spec_string("code-base", /* name */
                                                           "html_object_element_code-base", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.code-base", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CODE_TYPE,
                                    g_param_spec_string("code-type", /* name */
                                                           "html_object_element_code-type", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.code-type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DATA,
                                    g_param_spec_string("data", /* name */
                                                           "html_object_element_data", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.data", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DECLARE,
                                    g_param_spec_boolean("declare", /* name */
                                                           "html_object_element_declare", /* short description */
                                                           "read-write  gboolean HTMLObjectElement.declare", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_string("height", /* name */
                                                           "html_object_element_height", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.height", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HSPACE,
                                    g_param_spec_long("hspace", /* name */
                                                           "html_object_element_hspace", /* short description */
                                                           "read-write  glong HTMLObjectElement.hspace", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_object_element_name", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_STANDBY,
                                    g_param_spec_string("standby", /* name */
                                                           "html_object_element_standby", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.standby", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_object_element_type", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_USE_MAP,
                                    g_param_spec_string("use-map", /* name */
                                                           "html_object_element_use-map", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.use-map", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VSPACE,
                                    g_param_spec_long("vspace", /* name */
                                                           "html_object_element_vspace", /* short description */
                                                           "read-write  glong HTMLObjectElement.vspace", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_string("width", /* name */
                                                           "html_object_element_width", /* short description */
                                                           "read-write  gchar* HTMLObjectElement.width", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WILL_VALIDATE,
                                    g_param_spec_boolean("will-validate", /* name */
                                                           "html_object_element_will-validate", /* short description */
                                                           "read-only  gboolean HTMLObjectElement.will-validate", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDITY,
                                    g_param_spec_object("validity", /* name */
                                                           "html_object_element_validity", /* short description */
                                                           "read-only  WebKitDOMValidityState* HTMLObjectElement.validity", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_VALIDITY_STATE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDATION_MESSAGE,
                                    g_param_spec_string("validation-message", /* name */
                                                           "html_object_element_validation-message", /* short description */
                                                           "read-only  gchar* HTMLObjectElement.validation-message", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CONTENT_DOCUMENT,
                                    g_param_spec_object("content-document", /* name */
                                                           "html_object_element_content-document", /* short description */
                                                           "read-only  WebKitDOMDocument* HTMLObjectElement.content-document", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOCUMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_object_element_init(WebKitDOMHTMLObjectElement* request)
{
}

gboolean
webkit_dom_html_object_element_check_validity(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), FALSE);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gboolean result = item->checkValidity();
    return result;
}

void
webkit_dom_html_object_element_set_custom_validity(WebKitDOMHTMLObjectElement* self, const gchar* error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(error);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedError = WTF::String::fromUTF8(error);
    item->setCustomValidity(convertedError);
}

WebKitDOMHTMLFormElement*
webkit_dom_html_object_element_get_form(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLFormElement> gobjectResult = WTF::getPtr(item->form());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_object_element_get_code(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::codeAttr));
    return result;
}

void
webkit_dom_html_object_element_set_code(WebKitDOMHTMLObjectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::codeAttr, convertedValue);
}

gchar*
webkit_dom_html_object_element_get_align(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}

void
webkit_dom_html_object_element_set_align(WebKitDOMHTMLObjectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::alignAttr, convertedValue);
}

gchar*
webkit_dom_html_object_element_get_archive(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::archiveAttr));
    return result;
}

void
webkit_dom_html_object_element_set_archive(WebKitDOMHTMLObjectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::archiveAttr, convertedValue);
}

gchar*
webkit_dom_html_object_element_get_border(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::borderAttr));
    return result;
}

void
webkit_dom_html_object_element_set_border(WebKitDOMHTMLObjectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::borderAttr, convertedValue);
}

gchar*
webkit_dom_html_object_element_get_code_base(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::codebaseAttr));
    return result;
}

void
webkit_dom_html_object_element_set_code_base(WebKitDOMHTMLObjectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::codebaseAttr, convertedValue);
}

gchar*
webkit_dom_html_object_element_get_code_type(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::codetypeAttr));
    return result;
}

void
webkit_dom_html_object_element_set_code_type(WebKitDOMHTMLObjectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::codetypeAttr, convertedValue);
}

gchar*
webkit_dom_html_object_element_get_data(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::dataAttr));
    return result;
}

void
webkit_dom_html_object_element_set_data(WebKitDOMHTMLObjectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::dataAttr, convertedValue);
}

gboolean
webkit_dom_html_object_element_get_declare(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), FALSE);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::declareAttr);
    return result;
}

void
webkit_dom_html_object_element_set_declare(WebKitDOMHTMLObjectElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::declareAttr, value);
}

gchar*
webkit_dom_html_object_element_get_height(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::heightAttr));
    return result;
}

void
webkit_dom_html_object_element_set_height(WebKitDOMHTMLObjectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::heightAttr, convertedValue);
}

glong
webkit_dom_html_object_element_get_hspace(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    glong result = item->getIntegralAttribute(WebCore::HTMLNames::hspaceAttr);
    return result;
}

void
webkit_dom_html_object_element_set_hspace(WebKitDOMHTMLObjectElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    item->setIntegralAttribute(WebCore::HTMLNames::hspaceAttr, value);
}

gchar*
webkit_dom_html_object_element_get_name(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_object_element_set_name(WebKitDOMHTMLObjectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gchar*
webkit_dom_html_object_element_get_standby(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::standbyAttr));
    return result;
}

void
webkit_dom_html_object_element_set_standby(WebKitDOMHTMLObjectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::standbyAttr, convertedValue);
}

gchar*
webkit_dom_html_object_element_get_use_map(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::usemapAttr));
    return result;
}

void
webkit_dom_html_object_element_set_use_map(WebKitDOMHTMLObjectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::usemapAttr, convertedValue);
}

glong
webkit_dom_html_object_element_get_vspace(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    glong result = item->getIntegralAttribute(WebCore::HTMLNames::vspaceAttr);
    return result;
}

void
webkit_dom_html_object_element_set_vspace(WebKitDOMHTMLObjectElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    item->setIntegralAttribute(WebCore::HTMLNames::vspaceAttr, value);
}

gchar*
webkit_dom_html_object_element_get_width(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}

void
webkit_dom_html_object_element_set_width(WebKitDOMHTMLObjectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::widthAttr, convertedValue);
}

gboolean
webkit_dom_html_object_element_get_will_validate(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), FALSE);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gboolean result = item->willValidate();
    return result;
}

WebKitDOMValidityState*
webkit_dom_html_object_element_get_validity(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    RefPtr<WebCore::ValidityState> gobjectResult = WTF::getPtr(item->validity());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_object_element_get_validation_message(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->validationMessage());
    return result;
}

WebKitDOMDocument*
webkit_dom_html_object_element_get_content_document(WebKitDOMHTMLObjectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OBJECT_ELEMENT(self), 0);
    WebCore::HTMLObjectElement* item = WebKit::core(self);
    RefPtr<WebCore::Document> gobjectResult = WTF::getPtr(item->contentDocument());
    return WebKit::kit(gobjectResult.get());
}

