// File is generated by Source/WebCore/inspector/CodeGeneratorInspector.py

// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


#include "config.h"

#if ENABLE(INSPECTOR)

#include "InspectorBackendDispatcher.h"
#include <wtf/text/WTFString.h>
#include <wtf/text/CString.h>

#include "InspectorAgent.h"
#include "InspectorValues.h"
#include "InspectorFrontendChannel.h"
#include <wtf/text/WTFString.h>

namespace WebCore {

const char* InspectorBackendDispatcher::commandNames[] = {
    "Inspector.enable",
    "Inspector.disable",
    "Memory.getDOMCounters",
    "Memory.getProcessMemoryDistribution",
    "Page.enable",
    "Page.disable",
    "Page.addScriptToEvaluateOnLoad",
    "Page.removeScriptToEvaluateOnLoad",
    "Page.reload",
    "Page.navigate",
    "Page.getCookies",
    "Page.deleteCookie",
    "Page.getResourceTree",
    "Page.getResourceContent",
    "Page.searchInResource",
    "Page.searchInResources",
    "Page.setDocumentContent",
    "Page.canOverrideDeviceMetrics",
    "Page.setDeviceMetricsOverride",
    "Page.setShowPaintRects",
    "Page.canShowDebugBorders",
    "Page.setShowDebugBorders",
    "Page.canShowFPSCounter",
    "Page.setShowFPSCounter",
    "Page.canContinuouslyPaint",
    "Page.setContinuousPaintingEnabled",
    "Page.getScriptExecutionStatus",
    "Page.setScriptExecutionDisabled",
    "Page.setGeolocationOverride",
    "Page.clearGeolocationOverride",
    "Page.canOverrideGeolocation",
    "Page.setDeviceOrientationOverride",
    "Page.clearDeviceOrientationOverride",
    "Page.canOverrideDeviceOrientation",
    "Page.setTouchEmulationEnabled",
    "Page.setEmulatedMedia",
    "Page.getCompositingBordersVisible",
    "Page.setCompositingBordersVisible",
    "Page.captureScreenshot",
    "Page.handleJavaScriptDialog",
    "Runtime.evaluate",
    "Runtime.callFunctionOn",
    "Runtime.getProperties",
    "Runtime.releaseObject",
    "Runtime.releaseObjectGroup",
    "Runtime.run",
    "Runtime.enable",
    "Runtime.disable",
    "Console.enable",
    "Console.disable",
    "Console.clearMessages",
    "Console.setMonitoringXHREnabled",
    "Console.addInspectedNode",
    "Console.addInspectedHeapObject",
    "Network.enable",
    "Network.disable",
    "Network.setUserAgentOverride",
    "Network.setExtraHTTPHeaders",
    "Network.getResponseBody",
    "Network.replayXHR",
    "Network.canClearBrowserCache",
    "Network.clearBrowserCache",
    "Network.canClearBrowserCookies",
    "Network.clearBrowserCookies",
    "Network.setCacheDisabled",
#if ENABLE(SQL_DATABASE)

    "Database.enable",
    "Database.disable",
    "Database.getDatabaseTableNames",
    "Database.executeSQL",
#endif // ENABLE(SQL_DATABASE)

#if ENABLE(INDEXED_DATABASE)

    "IndexedDB.enable",
    "IndexedDB.disable",
    "IndexedDB.requestDatabaseNamesForFrame",
    "IndexedDB.requestDatabase",
    "IndexedDB.requestData",
#endif // ENABLE(INDEXED_DATABASE)

    "DOMStorage.enable",
    "DOMStorage.disable",
    "DOMStorage.getDOMStorageEntries",
    "DOMStorage.setDOMStorageItem",
    "DOMStorage.removeDOMStorageItem",
    "ApplicationCache.getFramesWithManifests",
    "ApplicationCache.enable",
    "ApplicationCache.getManifestForFrame",
    "ApplicationCache.getApplicationCacheForFrame",
#if ENABLE(FILE_SYSTEM)

    "FileSystem.enable",
    "FileSystem.disable",
    "FileSystem.requestFileSystemRoot",
    "FileSystem.requestDirectoryContent",
    "FileSystem.requestMetadata",
    "FileSystem.requestFileContent",
    "FileSystem.deleteEntry",
#endif // ENABLE(FILE_SYSTEM)

    "DOM.getDocument",
    "DOM.requestChildNodes",
    "DOM.querySelector",
    "DOM.querySelectorAll",
    "DOM.setNodeName",
    "DOM.setNodeValue",
    "DOM.removeNode",
    "DOM.setAttributeValue",
    "DOM.setAttributesAsText",
    "DOM.removeAttribute",
    "DOM.getEventListenersForNode",
    "DOM.getOuterHTML",
    "DOM.setOuterHTML",
    "DOM.performSearch",
    "DOM.getSearchResults",
    "DOM.discardSearchResults",
    "DOM.requestNode",
    "DOM.setInspectModeEnabled",
    "DOM.highlightRect",
    "DOM.highlightNode",
    "DOM.hideHighlight",
    "DOM.highlightFrame",
    "DOM.pushNodeByPathToFrontend",
    "DOM.resolveNode",
    "DOM.getAttributes",
    "DOM.moveTo",
    "DOM.undo",
    "DOM.redo",
    "DOM.markUndoableState",
    "DOM.focus",
    "DOM.setFileInputFiles",
    "CSS.enable",
    "CSS.disable",
    "CSS.getMatchedStylesForNode",
    "CSS.getInlineStylesForNode",
    "CSS.getComputedStyleForNode",
    "CSS.getAllStyleSheets",
    "CSS.getStyleSheet",
    "CSS.getStyleSheetText",
    "CSS.setStyleSheetText",
    "CSS.setPropertyText",
    "CSS.toggleProperty",
    "CSS.setRuleSelector",
    "CSS.addRule",
    "CSS.getSupportedCSSProperties",
    "CSS.forcePseudoState",
    "CSS.startSelectorProfiler",
    "CSS.stopSelectorProfiler",
    "CSS.getNamedFlowCollection",
    "Timeline.start",
    "Timeline.stop",
    "Timeline.setIncludeDomCounters",
    "Timeline.setIncludeNativeMemoryStatistics",
    "Timeline.supportsFrameInstrumentation",
    "Timeline.canMonitorMainThread",
#if ENABLE(JAVASCRIPT_DEBUGGER)

    "Debugger.causesRecompilation",
    "Debugger.supportsSeparateScriptCompilationAndExecution",
    "Debugger.enable",
    "Debugger.disable",
    "Debugger.setBreakpointsActive",
    "Debugger.setBreakpointByUrl",
    "Debugger.setBreakpoint",
    "Debugger.removeBreakpoint",
    "Debugger.continueToLocation",
    "Debugger.stepOver",
    "Debugger.stepInto",
    "Debugger.stepOut",
    "Debugger.pause",
    "Debugger.resume",
    "Debugger.searchInContent",
    "Debugger.canSetScriptSource",
    "Debugger.setScriptSource",
    "Debugger.restartFrame",
    "Debugger.getScriptSource",
    "Debugger.getFunctionDetails",
    "Debugger.setPauseOnExceptions",
    "Debugger.evaluateOnCallFrame",
    "Debugger.compileScript",
    "Debugger.runScript",
    "Debugger.setOverlayMessage",
    "Debugger.setVariableValue",
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

    "DOMDebugger.setDOMBreakpoint",
    "DOMDebugger.removeDOMBreakpoint",
    "DOMDebugger.setEventListenerBreakpoint",
    "DOMDebugger.removeEventListenerBreakpoint",
    "DOMDebugger.setInstrumentationBreakpoint",
    "DOMDebugger.removeInstrumentationBreakpoint",
    "DOMDebugger.setXHRBreakpoint",
    "DOMDebugger.removeXHRBreakpoint",
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

    "Profiler.causesRecompilation",
    "Profiler.isSampling",
    "Profiler.hasHeapProfiler",
    "Profiler.enable",
    "Profiler.disable",
    "Profiler.start",
    "Profiler.stop",
    "Profiler.getProfileHeaders",
    "Profiler.getCPUProfile",
    "Profiler.getHeapSnapshot",
    "Profiler.removeProfile",
    "Profiler.clearProfiles",
    "Profiler.takeHeapSnapshot",
    "Profiler.collectGarbage",
    "Profiler.getObjectByHeapObjectId",
    "Profiler.getHeapObjectId",
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

    "HeapProfiler.hasHeapProfiler",
    "HeapProfiler.getProfileHeaders",
    "HeapProfiler.getHeapSnapshot",
    "HeapProfiler.removeProfile",
    "HeapProfiler.clearProfiles",
    "HeapProfiler.takeHeapSnapshot",
    "HeapProfiler.collectGarbage",
    "HeapProfiler.getObjectByHeapObjectId",
    "HeapProfiler.getHeapObjectId",
#if ENABLE(WORKERS)

    "Worker.enable",
    "Worker.disable",
    "Worker.sendMessageToWorker",
    "Worker.connectToWorker",
    "Worker.disconnectFromWorker",
    "Worker.setAutoconnectToWorkers",
#endif // ENABLE(WORKERS)

    "Canvas.enable",
    "Canvas.disable",
    "Canvas.dropTraceLog",
    "Canvas.hasUninstrumentedCanvases",
    "Canvas.captureFrame",
    "Canvas.startCapturing",
    "Canvas.stopCapturing",
    "Canvas.getTraceLog",
    "Canvas.replayTraceLog",
    "Canvas.getResourceInfo",
    "Canvas.getResourceState",
    "Input.dispatchKeyEvent",
    "Input.dispatchMouseEvent",
    "LayerTree.enable",
    "LayerTree.disable",
    "LayerTree.getLayerTree",
    "LayerTree.nodeIdForLayerId",
};


class InspectorBackendDispatcherImpl : public InspectorBackendDispatcher {
public:
    InspectorBackendDispatcherImpl(InspectorFrontendChannel* inspectorFrontendChannel)
        : m_inspectorFrontendChannel(inspectorFrontendChannel)
        , m_inspectorAgent(0)
        , m_memoryAgent(0)
        , m_pageAgent(0)
        , m_runtimeAgent(0)
        , m_consoleAgent(0)
        , m_networkAgent(0)
#if ENABLE(SQL_DATABASE)

        , m_databaseAgent(0)
#endif // ENABLE(SQL_DATABASE)

#if ENABLE(INDEXED_DATABASE)

        , m_indexedDBAgent(0)
#endif // ENABLE(INDEXED_DATABASE)

        , m_domStorageAgent(0)
        , m_applicationCacheAgent(0)
#if ENABLE(FILE_SYSTEM)

        , m_fileSystemAgent(0)
#endif // ENABLE(FILE_SYSTEM)

        , m_domAgent(0)
        , m_cssAgent(0)
        , m_timelineAgent(0)
#if ENABLE(JAVASCRIPT_DEBUGGER)

        , m_debuggerAgent(0)
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

        , m_domDebuggerAgent(0)
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

        , m_profilerAgent(0)
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

        , m_heapProfilerAgent(0)
#if ENABLE(WORKERS)

        , m_workerAgent(0)
#endif // ENABLE(WORKERS)

        , m_canvasAgent(0)
        , m_inputAgent(0)
        , m_layerTreeAgent(0)
    { }

    virtual void clearFrontend() { m_inspectorFrontendChannel = 0; }
    virtual void dispatch(const String& message);
    virtual void reportProtocolError(const long* const callId, CommonErrorCode, const String& errorMessage, PassRefPtr<InspectorArray> data) const;
    using InspectorBackendDispatcher::reportProtocolError;

    void sendResponse(long callId, PassRefPtr<InspectorObject> result, const ErrorString& invocationError);
    bool isActive() { return m_inspectorFrontendChannel; }

    virtual void registerAgent(InspectorCommandHandler* inspectorAgent) { ASSERT(!m_inspectorAgent); m_inspectorAgent = inspectorAgent; }
    virtual void registerAgent(MemoryCommandHandler* memoryAgent) { ASSERT(!m_memoryAgent); m_memoryAgent = memoryAgent; }
    virtual void registerAgent(PageCommandHandler* pageAgent) { ASSERT(!m_pageAgent); m_pageAgent = pageAgent; }
    virtual void registerAgent(RuntimeCommandHandler* runtimeAgent) { ASSERT(!m_runtimeAgent); m_runtimeAgent = runtimeAgent; }
    virtual void registerAgent(ConsoleCommandHandler* consoleAgent) { ASSERT(!m_consoleAgent); m_consoleAgent = consoleAgent; }
    virtual void registerAgent(NetworkCommandHandler* networkAgent) { ASSERT(!m_networkAgent); m_networkAgent = networkAgent; }
#if ENABLE(SQL_DATABASE)

    virtual void registerAgent(DatabaseCommandHandler* databaseAgent) { ASSERT(!m_databaseAgent); m_databaseAgent = databaseAgent; }
#endif // ENABLE(SQL_DATABASE)

#if ENABLE(INDEXED_DATABASE)

    virtual void registerAgent(IndexedDBCommandHandler* indexedDBAgent) { ASSERT(!m_indexedDBAgent); m_indexedDBAgent = indexedDBAgent; }
#endif // ENABLE(INDEXED_DATABASE)

    virtual void registerAgent(DOMStorageCommandHandler* domStorageAgent) { ASSERT(!m_domStorageAgent); m_domStorageAgent = domStorageAgent; }
    virtual void registerAgent(ApplicationCacheCommandHandler* applicationCacheAgent) { ASSERT(!m_applicationCacheAgent); m_applicationCacheAgent = applicationCacheAgent; }
#if ENABLE(FILE_SYSTEM)

    virtual void registerAgent(FileSystemCommandHandler* fileSystemAgent) { ASSERT(!m_fileSystemAgent); m_fileSystemAgent = fileSystemAgent; }
#endif // ENABLE(FILE_SYSTEM)

    virtual void registerAgent(DOMCommandHandler* domAgent) { ASSERT(!m_domAgent); m_domAgent = domAgent; }
    virtual void registerAgent(CSSCommandHandler* cssAgent) { ASSERT(!m_cssAgent); m_cssAgent = cssAgent; }
    virtual void registerAgent(TimelineCommandHandler* timelineAgent) { ASSERT(!m_timelineAgent); m_timelineAgent = timelineAgent; }
#if ENABLE(JAVASCRIPT_DEBUGGER)

    virtual void registerAgent(DebuggerCommandHandler* debuggerAgent) { ASSERT(!m_debuggerAgent); m_debuggerAgent = debuggerAgent; }
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

    virtual void registerAgent(DOMDebuggerCommandHandler* domDebuggerAgent) { ASSERT(!m_domDebuggerAgent); m_domDebuggerAgent = domDebuggerAgent; }
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

    virtual void registerAgent(ProfilerCommandHandler* profilerAgent) { ASSERT(!m_profilerAgent); m_profilerAgent = profilerAgent; }
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

    virtual void registerAgent(HeapProfilerCommandHandler* heapProfilerAgent) { ASSERT(!m_heapProfilerAgent); m_heapProfilerAgent = heapProfilerAgent; }
#if ENABLE(WORKERS)

    virtual void registerAgent(WorkerCommandHandler* workerAgent) { ASSERT(!m_workerAgent); m_workerAgent = workerAgent; }
#endif // ENABLE(WORKERS)

    virtual void registerAgent(CanvasCommandHandler* canvasAgent) { ASSERT(!m_canvasAgent); m_canvasAgent = canvasAgent; }
    virtual void registerAgent(InputCommandHandler* inputAgent) { ASSERT(!m_inputAgent); m_inputAgent = inputAgent; }
    virtual void registerAgent(LayerTreeCommandHandler* layerTreeAgent) { ASSERT(!m_layerTreeAgent); m_layerTreeAgent = layerTreeAgent; }
private:
    void Inspector_enable(long callId, InspectorObject* requestMessageObject);
    void Inspector_disable(long callId, InspectorObject* requestMessageObject);
    void Memory_getDOMCounters(long callId, InspectorObject* requestMessageObject);
    void Memory_getProcessMemoryDistribution(long callId, InspectorObject* requestMessageObject);
    void Page_enable(long callId, InspectorObject* requestMessageObject);
    void Page_disable(long callId, InspectorObject* requestMessageObject);
    void Page_addScriptToEvaluateOnLoad(long callId, InspectorObject* requestMessageObject);
    void Page_removeScriptToEvaluateOnLoad(long callId, InspectorObject* requestMessageObject);
    void Page_reload(long callId, InspectorObject* requestMessageObject);
    void Page_navigate(long callId, InspectorObject* requestMessageObject);
    void Page_getCookies(long callId, InspectorObject* requestMessageObject);
    void Page_deleteCookie(long callId, InspectorObject* requestMessageObject);
    void Page_getResourceTree(long callId, InspectorObject* requestMessageObject);
    void Page_getResourceContent(long callId, InspectorObject* requestMessageObject);
    void Page_searchInResource(long callId, InspectorObject* requestMessageObject);
    void Page_searchInResources(long callId, InspectorObject* requestMessageObject);
    void Page_setDocumentContent(long callId, InspectorObject* requestMessageObject);
    void Page_canOverrideDeviceMetrics(long callId, InspectorObject* requestMessageObject);
    void Page_setDeviceMetricsOverride(long callId, InspectorObject* requestMessageObject);
    void Page_setShowPaintRects(long callId, InspectorObject* requestMessageObject);
    void Page_canShowDebugBorders(long callId, InspectorObject* requestMessageObject);
    void Page_setShowDebugBorders(long callId, InspectorObject* requestMessageObject);
    void Page_canShowFPSCounter(long callId, InspectorObject* requestMessageObject);
    void Page_setShowFPSCounter(long callId, InspectorObject* requestMessageObject);
    void Page_canContinuouslyPaint(long callId, InspectorObject* requestMessageObject);
    void Page_setContinuousPaintingEnabled(long callId, InspectorObject* requestMessageObject);
    void Page_getScriptExecutionStatus(long callId, InspectorObject* requestMessageObject);
    void Page_setScriptExecutionDisabled(long callId, InspectorObject* requestMessageObject);
    void Page_setGeolocationOverride(long callId, InspectorObject* requestMessageObject);
    void Page_clearGeolocationOverride(long callId, InspectorObject* requestMessageObject);
    void Page_canOverrideGeolocation(long callId, InspectorObject* requestMessageObject);
    void Page_setDeviceOrientationOverride(long callId, InspectorObject* requestMessageObject);
    void Page_clearDeviceOrientationOverride(long callId, InspectorObject* requestMessageObject);
    void Page_canOverrideDeviceOrientation(long callId, InspectorObject* requestMessageObject);
    void Page_setTouchEmulationEnabled(long callId, InspectorObject* requestMessageObject);
    void Page_setEmulatedMedia(long callId, InspectorObject* requestMessageObject);
    void Page_getCompositingBordersVisible(long callId, InspectorObject* requestMessageObject);
    void Page_setCompositingBordersVisible(long callId, InspectorObject* requestMessageObject);
    void Page_captureScreenshot(long callId, InspectorObject* requestMessageObject);
    void Page_handleJavaScriptDialog(long callId, InspectorObject* requestMessageObject);
    void Runtime_evaluate(long callId, InspectorObject* requestMessageObject);
    void Runtime_callFunctionOn(long callId, InspectorObject* requestMessageObject);
    void Runtime_getProperties(long callId, InspectorObject* requestMessageObject);
    void Runtime_releaseObject(long callId, InspectorObject* requestMessageObject);
    void Runtime_releaseObjectGroup(long callId, InspectorObject* requestMessageObject);
    void Runtime_run(long callId, InspectorObject* requestMessageObject);
    void Runtime_enable(long callId, InspectorObject* requestMessageObject);
    void Runtime_disable(long callId, InspectorObject* requestMessageObject);
    void Console_enable(long callId, InspectorObject* requestMessageObject);
    void Console_disable(long callId, InspectorObject* requestMessageObject);
    void Console_clearMessages(long callId, InspectorObject* requestMessageObject);
    void Console_setMonitoringXHREnabled(long callId, InspectorObject* requestMessageObject);
    void Console_addInspectedNode(long callId, InspectorObject* requestMessageObject);
    void Console_addInspectedHeapObject(long callId, InspectorObject* requestMessageObject);
    void Network_enable(long callId, InspectorObject* requestMessageObject);
    void Network_disable(long callId, InspectorObject* requestMessageObject);
    void Network_setUserAgentOverride(long callId, InspectorObject* requestMessageObject);
    void Network_setExtraHTTPHeaders(long callId, InspectorObject* requestMessageObject);
    void Network_getResponseBody(long callId, InspectorObject* requestMessageObject);
    void Network_replayXHR(long callId, InspectorObject* requestMessageObject);
    void Network_canClearBrowserCache(long callId, InspectorObject* requestMessageObject);
    void Network_clearBrowserCache(long callId, InspectorObject* requestMessageObject);
    void Network_canClearBrowserCookies(long callId, InspectorObject* requestMessageObject);
    void Network_clearBrowserCookies(long callId, InspectorObject* requestMessageObject);
    void Network_setCacheDisabled(long callId, InspectorObject* requestMessageObject);
#if ENABLE(SQL_DATABASE)

    void Database_enable(long callId, InspectorObject* requestMessageObject);
    void Database_disable(long callId, InspectorObject* requestMessageObject);
    void Database_getDatabaseTableNames(long callId, InspectorObject* requestMessageObject);
    void Database_executeSQL(long callId, InspectorObject* requestMessageObject);
#endif // ENABLE(SQL_DATABASE)

#if ENABLE(INDEXED_DATABASE)

    void IndexedDB_enable(long callId, InspectorObject* requestMessageObject);
    void IndexedDB_disable(long callId, InspectorObject* requestMessageObject);
    void IndexedDB_requestDatabaseNamesForFrame(long callId, InspectorObject* requestMessageObject);
    void IndexedDB_requestDatabase(long callId, InspectorObject* requestMessageObject);
    void IndexedDB_requestData(long callId, InspectorObject* requestMessageObject);
#endif // ENABLE(INDEXED_DATABASE)

    void DOMStorage_enable(long callId, InspectorObject* requestMessageObject);
    void DOMStorage_disable(long callId, InspectorObject* requestMessageObject);
    void DOMStorage_getDOMStorageEntries(long callId, InspectorObject* requestMessageObject);
    void DOMStorage_setDOMStorageItem(long callId, InspectorObject* requestMessageObject);
    void DOMStorage_removeDOMStorageItem(long callId, InspectorObject* requestMessageObject);
    void ApplicationCache_getFramesWithManifests(long callId, InspectorObject* requestMessageObject);
    void ApplicationCache_enable(long callId, InspectorObject* requestMessageObject);
    void ApplicationCache_getManifestForFrame(long callId, InspectorObject* requestMessageObject);
    void ApplicationCache_getApplicationCacheForFrame(long callId, InspectorObject* requestMessageObject);
#if ENABLE(FILE_SYSTEM)

    void FileSystem_enable(long callId, InspectorObject* requestMessageObject);
    void FileSystem_disable(long callId, InspectorObject* requestMessageObject);
    void FileSystem_requestFileSystemRoot(long callId, InspectorObject* requestMessageObject);
    void FileSystem_requestDirectoryContent(long callId, InspectorObject* requestMessageObject);
    void FileSystem_requestMetadata(long callId, InspectorObject* requestMessageObject);
    void FileSystem_requestFileContent(long callId, InspectorObject* requestMessageObject);
    void FileSystem_deleteEntry(long callId, InspectorObject* requestMessageObject);
#endif // ENABLE(FILE_SYSTEM)

    void DOM_getDocument(long callId, InspectorObject* requestMessageObject);
    void DOM_requestChildNodes(long callId, InspectorObject* requestMessageObject);
    void DOM_querySelector(long callId, InspectorObject* requestMessageObject);
    void DOM_querySelectorAll(long callId, InspectorObject* requestMessageObject);
    void DOM_setNodeName(long callId, InspectorObject* requestMessageObject);
    void DOM_setNodeValue(long callId, InspectorObject* requestMessageObject);
    void DOM_removeNode(long callId, InspectorObject* requestMessageObject);
    void DOM_setAttributeValue(long callId, InspectorObject* requestMessageObject);
    void DOM_setAttributesAsText(long callId, InspectorObject* requestMessageObject);
    void DOM_removeAttribute(long callId, InspectorObject* requestMessageObject);
    void DOM_getEventListenersForNode(long callId, InspectorObject* requestMessageObject);
    void DOM_getOuterHTML(long callId, InspectorObject* requestMessageObject);
    void DOM_setOuterHTML(long callId, InspectorObject* requestMessageObject);
    void DOM_performSearch(long callId, InspectorObject* requestMessageObject);
    void DOM_getSearchResults(long callId, InspectorObject* requestMessageObject);
    void DOM_discardSearchResults(long callId, InspectorObject* requestMessageObject);
    void DOM_requestNode(long callId, InspectorObject* requestMessageObject);
    void DOM_setInspectModeEnabled(long callId, InspectorObject* requestMessageObject);
    void DOM_highlightRect(long callId, InspectorObject* requestMessageObject);
    void DOM_highlightNode(long callId, InspectorObject* requestMessageObject);
    void DOM_hideHighlight(long callId, InspectorObject* requestMessageObject);
    void DOM_highlightFrame(long callId, InspectorObject* requestMessageObject);
    void DOM_pushNodeByPathToFrontend(long callId, InspectorObject* requestMessageObject);
    void DOM_resolveNode(long callId, InspectorObject* requestMessageObject);
    void DOM_getAttributes(long callId, InspectorObject* requestMessageObject);
    void DOM_moveTo(long callId, InspectorObject* requestMessageObject);
    void DOM_undo(long callId, InspectorObject* requestMessageObject);
    void DOM_redo(long callId, InspectorObject* requestMessageObject);
    void DOM_markUndoableState(long callId, InspectorObject* requestMessageObject);
    void DOM_focus(long callId, InspectorObject* requestMessageObject);
    void DOM_setFileInputFiles(long callId, InspectorObject* requestMessageObject);
    void CSS_enable(long callId, InspectorObject* requestMessageObject);
    void CSS_disable(long callId, InspectorObject* requestMessageObject);
    void CSS_getMatchedStylesForNode(long callId, InspectorObject* requestMessageObject);
    void CSS_getInlineStylesForNode(long callId, InspectorObject* requestMessageObject);
    void CSS_getComputedStyleForNode(long callId, InspectorObject* requestMessageObject);
    void CSS_getAllStyleSheets(long callId, InspectorObject* requestMessageObject);
    void CSS_getStyleSheet(long callId, InspectorObject* requestMessageObject);
    void CSS_getStyleSheetText(long callId, InspectorObject* requestMessageObject);
    void CSS_setStyleSheetText(long callId, InspectorObject* requestMessageObject);
    void CSS_setPropertyText(long callId, InspectorObject* requestMessageObject);
    void CSS_toggleProperty(long callId, InspectorObject* requestMessageObject);
    void CSS_setRuleSelector(long callId, InspectorObject* requestMessageObject);
    void CSS_addRule(long callId, InspectorObject* requestMessageObject);
    void CSS_getSupportedCSSProperties(long callId, InspectorObject* requestMessageObject);
    void CSS_forcePseudoState(long callId, InspectorObject* requestMessageObject);
    void CSS_startSelectorProfiler(long callId, InspectorObject* requestMessageObject);
    void CSS_stopSelectorProfiler(long callId, InspectorObject* requestMessageObject);
    void CSS_getNamedFlowCollection(long callId, InspectorObject* requestMessageObject);
    void Timeline_start(long callId, InspectorObject* requestMessageObject);
    void Timeline_stop(long callId, InspectorObject* requestMessageObject);
    void Timeline_setIncludeDomCounters(long callId, InspectorObject* requestMessageObject);
    void Timeline_setIncludeNativeMemoryStatistics(long callId, InspectorObject* requestMessageObject);
    void Timeline_supportsFrameInstrumentation(long callId, InspectorObject* requestMessageObject);
    void Timeline_canMonitorMainThread(long callId, InspectorObject* requestMessageObject);
#if ENABLE(JAVASCRIPT_DEBUGGER)

    void Debugger_causesRecompilation(long callId, InspectorObject* requestMessageObject);
    void Debugger_supportsSeparateScriptCompilationAndExecution(long callId, InspectorObject* requestMessageObject);
    void Debugger_enable(long callId, InspectorObject* requestMessageObject);
    void Debugger_disable(long callId, InspectorObject* requestMessageObject);
    void Debugger_setBreakpointsActive(long callId, InspectorObject* requestMessageObject);
    void Debugger_setBreakpointByUrl(long callId, InspectorObject* requestMessageObject);
    void Debugger_setBreakpoint(long callId, InspectorObject* requestMessageObject);
    void Debugger_removeBreakpoint(long callId, InspectorObject* requestMessageObject);
    void Debugger_continueToLocation(long callId, InspectorObject* requestMessageObject);
    void Debugger_stepOver(long callId, InspectorObject* requestMessageObject);
    void Debugger_stepInto(long callId, InspectorObject* requestMessageObject);
    void Debugger_stepOut(long callId, InspectorObject* requestMessageObject);
    void Debugger_pause(long callId, InspectorObject* requestMessageObject);
    void Debugger_resume(long callId, InspectorObject* requestMessageObject);
    void Debugger_searchInContent(long callId, InspectorObject* requestMessageObject);
    void Debugger_canSetScriptSource(long callId, InspectorObject* requestMessageObject);
    void Debugger_setScriptSource(long callId, InspectorObject* requestMessageObject);
    void Debugger_restartFrame(long callId, InspectorObject* requestMessageObject);
    void Debugger_getScriptSource(long callId, InspectorObject* requestMessageObject);
    void Debugger_getFunctionDetails(long callId, InspectorObject* requestMessageObject);
    void Debugger_setPauseOnExceptions(long callId, InspectorObject* requestMessageObject);
    void Debugger_evaluateOnCallFrame(long callId, InspectorObject* requestMessageObject);
    void Debugger_compileScript(long callId, InspectorObject* requestMessageObject);
    void Debugger_runScript(long callId, InspectorObject* requestMessageObject);
    void Debugger_setOverlayMessage(long callId, InspectorObject* requestMessageObject);
    void Debugger_setVariableValue(long callId, InspectorObject* requestMessageObject);
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

    void DOMDebugger_setDOMBreakpoint(long callId, InspectorObject* requestMessageObject);
    void DOMDebugger_removeDOMBreakpoint(long callId, InspectorObject* requestMessageObject);
    void DOMDebugger_setEventListenerBreakpoint(long callId, InspectorObject* requestMessageObject);
    void DOMDebugger_removeEventListenerBreakpoint(long callId, InspectorObject* requestMessageObject);
    void DOMDebugger_setInstrumentationBreakpoint(long callId, InspectorObject* requestMessageObject);
    void DOMDebugger_removeInstrumentationBreakpoint(long callId, InspectorObject* requestMessageObject);
    void DOMDebugger_setXHRBreakpoint(long callId, InspectorObject* requestMessageObject);
    void DOMDebugger_removeXHRBreakpoint(long callId, InspectorObject* requestMessageObject);
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

    void Profiler_causesRecompilation(long callId, InspectorObject* requestMessageObject);
    void Profiler_isSampling(long callId, InspectorObject* requestMessageObject);
    void Profiler_hasHeapProfiler(long callId, InspectorObject* requestMessageObject);
    void Profiler_enable(long callId, InspectorObject* requestMessageObject);
    void Profiler_disable(long callId, InspectorObject* requestMessageObject);
    void Profiler_start(long callId, InspectorObject* requestMessageObject);
    void Profiler_stop(long callId, InspectorObject* requestMessageObject);
    void Profiler_getProfileHeaders(long callId, InspectorObject* requestMessageObject);
    void Profiler_getCPUProfile(long callId, InspectorObject* requestMessageObject);
    void Profiler_getHeapSnapshot(long callId, InspectorObject* requestMessageObject);
    void Profiler_removeProfile(long callId, InspectorObject* requestMessageObject);
    void Profiler_clearProfiles(long callId, InspectorObject* requestMessageObject);
    void Profiler_takeHeapSnapshot(long callId, InspectorObject* requestMessageObject);
    void Profiler_collectGarbage(long callId, InspectorObject* requestMessageObject);
    void Profiler_getObjectByHeapObjectId(long callId, InspectorObject* requestMessageObject);
    void Profiler_getHeapObjectId(long callId, InspectorObject* requestMessageObject);
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

    void HeapProfiler_hasHeapProfiler(long callId, InspectorObject* requestMessageObject);
    void HeapProfiler_getProfileHeaders(long callId, InspectorObject* requestMessageObject);
    void HeapProfiler_getHeapSnapshot(long callId, InspectorObject* requestMessageObject);
    void HeapProfiler_removeProfile(long callId, InspectorObject* requestMessageObject);
    void HeapProfiler_clearProfiles(long callId, InspectorObject* requestMessageObject);
    void HeapProfiler_takeHeapSnapshot(long callId, InspectorObject* requestMessageObject);
    void HeapProfiler_collectGarbage(long callId, InspectorObject* requestMessageObject);
    void HeapProfiler_getObjectByHeapObjectId(long callId, InspectorObject* requestMessageObject);
    void HeapProfiler_getHeapObjectId(long callId, InspectorObject* requestMessageObject);
#if ENABLE(WORKERS)

    void Worker_enable(long callId, InspectorObject* requestMessageObject);
    void Worker_disable(long callId, InspectorObject* requestMessageObject);
    void Worker_sendMessageToWorker(long callId, InspectorObject* requestMessageObject);
    void Worker_connectToWorker(long callId, InspectorObject* requestMessageObject);
    void Worker_disconnectFromWorker(long callId, InspectorObject* requestMessageObject);
    void Worker_setAutoconnectToWorkers(long callId, InspectorObject* requestMessageObject);
#endif // ENABLE(WORKERS)

    void Canvas_enable(long callId, InspectorObject* requestMessageObject);
    void Canvas_disable(long callId, InspectorObject* requestMessageObject);
    void Canvas_dropTraceLog(long callId, InspectorObject* requestMessageObject);
    void Canvas_hasUninstrumentedCanvases(long callId, InspectorObject* requestMessageObject);
    void Canvas_captureFrame(long callId, InspectorObject* requestMessageObject);
    void Canvas_startCapturing(long callId, InspectorObject* requestMessageObject);
    void Canvas_stopCapturing(long callId, InspectorObject* requestMessageObject);
    void Canvas_getTraceLog(long callId, InspectorObject* requestMessageObject);
    void Canvas_replayTraceLog(long callId, InspectorObject* requestMessageObject);
    void Canvas_getResourceInfo(long callId, InspectorObject* requestMessageObject);
    void Canvas_getResourceState(long callId, InspectorObject* requestMessageObject);
    void Input_dispatchKeyEvent(long callId, InspectorObject* requestMessageObject);
    void Input_dispatchMouseEvent(long callId, InspectorObject* requestMessageObject);
    void LayerTree_enable(long callId, InspectorObject* requestMessageObject);
    void LayerTree_disable(long callId, InspectorObject* requestMessageObject);
    void LayerTree_getLayerTree(long callId, InspectorObject* requestMessageObject);
    void LayerTree_nodeIdForLayerId(long callId, InspectorObject* requestMessageObject);

    InspectorFrontendChannel* m_inspectorFrontendChannel;
    InspectorCommandHandler* m_inspectorAgent;
    MemoryCommandHandler* m_memoryAgent;
    PageCommandHandler* m_pageAgent;
    RuntimeCommandHandler* m_runtimeAgent;
    ConsoleCommandHandler* m_consoleAgent;
    NetworkCommandHandler* m_networkAgent;
#if ENABLE(SQL_DATABASE)

    DatabaseCommandHandler* m_databaseAgent;
#endif // ENABLE(SQL_DATABASE)

#if ENABLE(INDEXED_DATABASE)

    IndexedDBCommandHandler* m_indexedDBAgent;
#endif // ENABLE(INDEXED_DATABASE)

    DOMStorageCommandHandler* m_domStorageAgent;
    ApplicationCacheCommandHandler* m_applicationCacheAgent;
#if ENABLE(FILE_SYSTEM)

    FileSystemCommandHandler* m_fileSystemAgent;
#endif // ENABLE(FILE_SYSTEM)

    DOMCommandHandler* m_domAgent;
    CSSCommandHandler* m_cssAgent;
    TimelineCommandHandler* m_timelineAgent;
#if ENABLE(JAVASCRIPT_DEBUGGER)

    DebuggerCommandHandler* m_debuggerAgent;
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

    DOMDebuggerCommandHandler* m_domDebuggerAgent;
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

    ProfilerCommandHandler* m_profilerAgent;
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

    HeapProfilerCommandHandler* m_heapProfilerAgent;
#if ENABLE(WORKERS)

    WorkerCommandHandler* m_workerAgent;
#endif // ENABLE(WORKERS)

    CanvasCommandHandler* m_canvasAgent;
    InputCommandHandler* m_inputAgent;
    LayerTreeCommandHandler* m_layerTreeAgent;

    template<typename R, typename V, typename V0>
    static R getPropertyValueImpl(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors, V0 initial_value, bool (*as_method)(InspectorValue*, V*), const char* type_name);

    static int getInt(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors);
    static double getDouble(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors);
    static String getString(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors);
    static bool getBoolean(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors);
    static PassRefPtr<InspectorObject> getObject(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors);
    static PassRefPtr<InspectorArray> getArray(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors);

    void sendResponse(long callId, PassRefPtr<InspectorObject> result, const char* commandName, PassRefPtr<InspectorArray> protocolErrors, ErrorString invocationError);

};

void InspectorBackendDispatcherImpl::Inspector_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_inspectorAgent)
        protocolErrors->pushString("Inspector handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_inspectorAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kInspector_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Inspector_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_inspectorAgent)
        protocolErrors->pushString("Inspector handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_inspectorAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kInspector_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Memory_getDOMCounters(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_memoryAgent)
        protocolErrors->pushString("Memory handler is not available.");

    int out_documents;
    int out_nodes;
    int out_jsEventListeners;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_memoryAgent->getDOMCounters(&error, &out_documents, &out_nodes, &out_jsEventListeners);

        if (!error.length()) {
            result->setNumber("documents", out_documents);
            result->setNumber("nodes", out_nodes);
            result->setNumber("jsEventListeners", out_jsEventListeners);
        }
    }
    sendResponse(callId, result, commandNames[kMemory_getDOMCountersCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Memory_getProcessMemoryDistribution(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_memoryAgent)
        protocolErrors->pushString("Memory handler is not available.");

    RefPtr<TypeBuilder::Memory::MemoryBlock> out_distribution;
    RefPtr<InspectorObject> out_graphMetaInformation;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool reportGraph_valueFound = false;
    bool in_reportGraph = getBoolean(paramsContainerPtr, "reportGraph", &reportGraph_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_memoryAgent->getProcessMemoryDistribution(&error, reportGraph_valueFound ? &in_reportGraph : 0, out_distribution, out_graphMetaInformation);

        if (!error.length()) {
            result->setValue("distribution", out_distribution);
            if (out_graphMetaInformation)
                result->setValue("graphMetaInformation", out_graphMetaInformation);
        }
    }
    sendResponse(callId, result, commandNames[kMemory_getProcessMemoryDistributionCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kPage_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kPage_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_addScriptToEvaluateOnLoad(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    TypeBuilder::Page::ScriptIdentifier out_identifier;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_scriptSource = getString(paramsContainerPtr, "scriptSource", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->addScriptToEvaluateOnLoad(&error, in_scriptSource, &out_identifier);

        if (!error.length()) {
            result->setString("identifier", out_identifier);
        }
    }
    sendResponse(callId, result, commandNames[kPage_addScriptToEvaluateOnLoadCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_removeScriptToEvaluateOnLoad(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_identifier = getString(paramsContainerPtr, "identifier", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->removeScriptToEvaluateOnLoad(&error, in_identifier);


    }
    sendResponse(callId, result, commandNames[kPage_removeScriptToEvaluateOnLoadCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_reload(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool ignoreCache_valueFound = false;
    bool in_ignoreCache = getBoolean(paramsContainerPtr, "ignoreCache", &ignoreCache_valueFound, protocolErrorsPtr);
    bool scriptToEvaluateOnLoad_valueFound = false;
    String in_scriptToEvaluateOnLoad = getString(paramsContainerPtr, "scriptToEvaluateOnLoad", &scriptToEvaluateOnLoad_valueFound, protocolErrorsPtr);
    bool scriptPreprocessor_valueFound = false;
    String in_scriptPreprocessor = getString(paramsContainerPtr, "scriptPreprocessor", &scriptPreprocessor_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->reload(&error, ignoreCache_valueFound ? &in_ignoreCache : 0, scriptToEvaluateOnLoad_valueFound ? &in_scriptToEvaluateOnLoad : 0, scriptPreprocessor_valueFound ? &in_scriptPreprocessor : 0);


    }
    sendResponse(callId, result, commandNames[kPage_reloadCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_navigate(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_url = getString(paramsContainerPtr, "url", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->navigate(&error, in_url);


    }
    sendResponse(callId, result, commandNames[kPage_navigateCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_getCookies(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::Page::Cookie> > out_cookies;
    String out_cookiesString;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->getCookies(&error, out_cookies, &out_cookiesString);

        if (!error.length()) {
            result->setValue("cookies", out_cookies);
            result->setString("cookiesString", out_cookiesString);
        }
    }
    sendResponse(callId, result, commandNames[kPage_getCookiesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_deleteCookie(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_cookieName = getString(paramsContainerPtr, "cookieName", 0, protocolErrorsPtr);
    String in_url = getString(paramsContainerPtr, "url", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->deleteCookie(&error, in_cookieName, in_url);


    }
    sendResponse(callId, result, commandNames[kPage_deleteCookieCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_getResourceTree(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    RefPtr<TypeBuilder::Page::FrameResourceTree> out_frameTree;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->getResourceTree(&error, out_frameTree);

        if (!error.length()) {
            result->setValue("frameTree", out_frameTree);
        }
    }
    sendResponse(callId, result, commandNames[kPage_getResourceTreeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_getResourceContent(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    String out_content;
    bool out_base64Encoded;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_frameId = getString(paramsContainerPtr, "frameId", 0, protocolErrorsPtr);
    String in_url = getString(paramsContainerPtr, "url", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->getResourceContent(&error, in_frameId, in_url, &out_content, &out_base64Encoded);

        if (!error.length()) {
            result->setString("content", out_content);
            result->setBoolean("base64Encoded", out_base64Encoded);
        }
    }
    sendResponse(callId, result, commandNames[kPage_getResourceContentCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_searchInResource(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::Page::SearchMatch> > out_result;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_frameId = getString(paramsContainerPtr, "frameId", 0, protocolErrorsPtr);
    String in_url = getString(paramsContainerPtr, "url", 0, protocolErrorsPtr);
    String in_query = getString(paramsContainerPtr, "query", 0, protocolErrorsPtr);
    bool caseSensitive_valueFound = false;
    bool in_caseSensitive = getBoolean(paramsContainerPtr, "caseSensitive", &caseSensitive_valueFound, protocolErrorsPtr);
    bool isRegex_valueFound = false;
    bool in_isRegex = getBoolean(paramsContainerPtr, "isRegex", &isRegex_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->searchInResource(&error, in_frameId, in_url, in_query, caseSensitive_valueFound ? &in_caseSensitive : 0, isRegex_valueFound ? &in_isRegex : 0, out_result);

        if (!error.length()) {
            result->setValue("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kPage_searchInResourceCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_searchInResources(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::Page::SearchResult> > out_result;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_text = getString(paramsContainerPtr, "text", 0, protocolErrorsPtr);
    bool caseSensitive_valueFound = false;
    bool in_caseSensitive = getBoolean(paramsContainerPtr, "caseSensitive", &caseSensitive_valueFound, protocolErrorsPtr);
    bool isRegex_valueFound = false;
    bool in_isRegex = getBoolean(paramsContainerPtr, "isRegex", &isRegex_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->searchInResources(&error, in_text, caseSensitive_valueFound ? &in_caseSensitive : 0, isRegex_valueFound ? &in_isRegex : 0, out_result);

        if (!error.length()) {
            result->setValue("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kPage_searchInResourcesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_setDocumentContent(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_frameId = getString(paramsContainerPtr, "frameId", 0, protocolErrorsPtr);
    String in_html = getString(paramsContainerPtr, "html", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->setDocumentContent(&error, in_frameId, in_html);


    }
    sendResponse(callId, result, commandNames[kPage_setDocumentContentCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_canOverrideDeviceMetrics(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->canOverrideDeviceMetrics(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kPage_canOverrideDeviceMetricsCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_setDeviceMetricsOverride(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_width = getInt(paramsContainerPtr, "width", 0, protocolErrorsPtr);
    int in_height = getInt(paramsContainerPtr, "height", 0, protocolErrorsPtr);
    double in_fontScaleFactor = getDouble(paramsContainerPtr, "fontScaleFactor", 0, protocolErrorsPtr);
    bool in_fitWindow = getBoolean(paramsContainerPtr, "fitWindow", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->setDeviceMetricsOverride(&error, in_width, in_height, in_fontScaleFactor, in_fitWindow);


    }
    sendResponse(callId, result, commandNames[kPage_setDeviceMetricsOverrideCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_setShowPaintRects(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_result = getBoolean(paramsContainerPtr, "result", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->setShowPaintRects(&error, in_result);


    }
    sendResponse(callId, result, commandNames[kPage_setShowPaintRectsCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_canShowDebugBorders(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    bool out_show;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->canShowDebugBorders(&error, &out_show);

        if (!error.length()) {
            result->setBoolean("show", out_show);
        }
    }
    sendResponse(callId, result, commandNames[kPage_canShowDebugBordersCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_setShowDebugBorders(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_show = getBoolean(paramsContainerPtr, "show", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->setShowDebugBorders(&error, in_show);


    }
    sendResponse(callId, result, commandNames[kPage_setShowDebugBordersCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_canShowFPSCounter(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    bool out_show;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->canShowFPSCounter(&error, &out_show);

        if (!error.length()) {
            result->setBoolean("show", out_show);
        }
    }
    sendResponse(callId, result, commandNames[kPage_canShowFPSCounterCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_setShowFPSCounter(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_show = getBoolean(paramsContainerPtr, "show", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->setShowFPSCounter(&error, in_show);


    }
    sendResponse(callId, result, commandNames[kPage_setShowFPSCounterCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_canContinuouslyPaint(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    bool out_value;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->canContinuouslyPaint(&error, &out_value);

        if (!error.length()) {
            result->setBoolean("value", out_value);
        }
    }
    sendResponse(callId, result, commandNames[kPage_canContinuouslyPaintCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_setContinuousPaintingEnabled(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_enabled = getBoolean(paramsContainerPtr, "enabled", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->setContinuousPaintingEnabled(&error, in_enabled);


    }
    sendResponse(callId, result, commandNames[kPage_setContinuousPaintingEnabledCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_getScriptExecutionStatus(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    PageCommandHandler::Result::Enum out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->getScriptExecutionStatus(&error, &out_result);

        if (!error.length()) {
            result->setString("result", TypeBuilder::getEnumConstantValue(out_result));
        }
    }
    sendResponse(callId, result, commandNames[kPage_getScriptExecutionStatusCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_setScriptExecutionDisabled(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_value = getBoolean(paramsContainerPtr, "value", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->setScriptExecutionDisabled(&error, in_value);


    }
    sendResponse(callId, result, commandNames[kPage_setScriptExecutionDisabledCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_setGeolocationOverride(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool latitude_valueFound = false;
    double in_latitude = getDouble(paramsContainerPtr, "latitude", &latitude_valueFound, protocolErrorsPtr);
    bool longitude_valueFound = false;
    double in_longitude = getDouble(paramsContainerPtr, "longitude", &longitude_valueFound, protocolErrorsPtr);
    bool accuracy_valueFound = false;
    double in_accuracy = getDouble(paramsContainerPtr, "accuracy", &accuracy_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->setGeolocationOverride(&error, latitude_valueFound ? &in_latitude : 0, longitude_valueFound ? &in_longitude : 0, accuracy_valueFound ? &in_accuracy : 0);


    }
    sendResponse(callId, result, commandNames[kPage_setGeolocationOverrideCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_clearGeolocationOverride(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->clearGeolocationOverride(&error);


    }
    sendResponse(callId, result, commandNames[kPage_clearGeolocationOverrideCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_canOverrideGeolocation(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->canOverrideGeolocation(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kPage_canOverrideGeolocationCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_setDeviceOrientationOverride(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    double in_alpha = getDouble(paramsContainerPtr, "alpha", 0, protocolErrorsPtr);
    double in_beta = getDouble(paramsContainerPtr, "beta", 0, protocolErrorsPtr);
    double in_gamma = getDouble(paramsContainerPtr, "gamma", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->setDeviceOrientationOverride(&error, in_alpha, in_beta, in_gamma);


    }
    sendResponse(callId, result, commandNames[kPage_setDeviceOrientationOverrideCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_clearDeviceOrientationOverride(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->clearDeviceOrientationOverride(&error);


    }
    sendResponse(callId, result, commandNames[kPage_clearDeviceOrientationOverrideCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_canOverrideDeviceOrientation(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->canOverrideDeviceOrientation(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kPage_canOverrideDeviceOrientationCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_setTouchEmulationEnabled(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_enabled = getBoolean(paramsContainerPtr, "enabled", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->setTouchEmulationEnabled(&error, in_enabled);


    }
    sendResponse(callId, result, commandNames[kPage_setTouchEmulationEnabledCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_setEmulatedMedia(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_media = getString(paramsContainerPtr, "media", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->setEmulatedMedia(&error, in_media);


    }
    sendResponse(callId, result, commandNames[kPage_setEmulatedMediaCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_getCompositingBordersVisible(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->getCompositingBordersVisible(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kPage_getCompositingBordersVisibleCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_setCompositingBordersVisible(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_visible = getBoolean(paramsContainerPtr, "visible", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->setCompositingBordersVisible(&error, in_visible);


    }
    sendResponse(callId, result, commandNames[kPage_setCompositingBordersVisibleCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_captureScreenshot(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");

    String out_data;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->captureScreenshot(&error, &out_data);

        if (!error.length()) {
            result->setString("data", out_data);
        }
    }
    sendResponse(callId, result, commandNames[kPage_captureScreenshotCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Page_handleJavaScriptDialog(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_pageAgent)
        protocolErrors->pushString("Page handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_accept = getBoolean(paramsContainerPtr, "accept", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_pageAgent->handleJavaScriptDialog(&error, in_accept);


    }
    sendResponse(callId, result, commandNames[kPage_handleJavaScriptDialogCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Runtime_evaluate(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_runtimeAgent)
        protocolErrors->pushString("Runtime handler is not available.");

    RefPtr<TypeBuilder::Runtime::RemoteObject> out_result;
    TypeBuilder::OptOutput<bool> out_wasThrown;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_expression = getString(paramsContainerPtr, "expression", 0, protocolErrorsPtr);
    bool objectGroup_valueFound = false;
    String in_objectGroup = getString(paramsContainerPtr, "objectGroup", &objectGroup_valueFound, protocolErrorsPtr);
    bool includeCommandLineAPI_valueFound = false;
    bool in_includeCommandLineAPI = getBoolean(paramsContainerPtr, "includeCommandLineAPI", &includeCommandLineAPI_valueFound, protocolErrorsPtr);
    bool doNotPauseOnExceptionsAndMuteConsole_valueFound = false;
    bool in_doNotPauseOnExceptionsAndMuteConsole = getBoolean(paramsContainerPtr, "doNotPauseOnExceptionsAndMuteConsole", &doNotPauseOnExceptionsAndMuteConsole_valueFound, protocolErrorsPtr);
    bool contextId_valueFound = false;
    int in_contextId = getInt(paramsContainerPtr, "contextId", &contextId_valueFound, protocolErrorsPtr);
    bool returnByValue_valueFound = false;
    bool in_returnByValue = getBoolean(paramsContainerPtr, "returnByValue", &returnByValue_valueFound, protocolErrorsPtr);
    bool generatePreview_valueFound = false;
    bool in_generatePreview = getBoolean(paramsContainerPtr, "generatePreview", &generatePreview_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_runtimeAgent->evaluate(&error, in_expression, objectGroup_valueFound ? &in_objectGroup : 0, includeCommandLineAPI_valueFound ? &in_includeCommandLineAPI : 0, doNotPauseOnExceptionsAndMuteConsole_valueFound ? &in_doNotPauseOnExceptionsAndMuteConsole : 0, contextId_valueFound ? &in_contextId : 0, returnByValue_valueFound ? &in_returnByValue : 0, generatePreview_valueFound ? &in_generatePreview : 0, out_result, &out_wasThrown);

        if (!error.length()) {
            result->setValue("result", out_result);
            if (out_wasThrown.isAssigned())
                result->setBoolean("wasThrown", out_wasThrown.getValue());
        }
    }
    sendResponse(callId, result, commandNames[kRuntime_evaluateCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Runtime_callFunctionOn(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_runtimeAgent)
        protocolErrors->pushString("Runtime handler is not available.");

    RefPtr<TypeBuilder::Runtime::RemoteObject> out_result;
    TypeBuilder::OptOutput<bool> out_wasThrown;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_objectId = getString(paramsContainerPtr, "objectId", 0, protocolErrorsPtr);
    String in_functionDeclaration = getString(paramsContainerPtr, "functionDeclaration", 0, protocolErrorsPtr);
    bool arguments_valueFound = false;
    RefPtr<InspectorArray> in_arguments = getArray(paramsContainerPtr, "arguments", &arguments_valueFound, protocolErrorsPtr);
    bool doNotPauseOnExceptionsAndMuteConsole_valueFound = false;
    bool in_doNotPauseOnExceptionsAndMuteConsole = getBoolean(paramsContainerPtr, "doNotPauseOnExceptionsAndMuteConsole", &doNotPauseOnExceptionsAndMuteConsole_valueFound, protocolErrorsPtr);
    bool returnByValue_valueFound = false;
    bool in_returnByValue = getBoolean(paramsContainerPtr, "returnByValue", &returnByValue_valueFound, protocolErrorsPtr);
    bool generatePreview_valueFound = false;
    bool in_generatePreview = getBoolean(paramsContainerPtr, "generatePreview", &generatePreview_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_runtimeAgent->callFunctionOn(&error, in_objectId, in_functionDeclaration, arguments_valueFound ? &in_arguments : 0, doNotPauseOnExceptionsAndMuteConsole_valueFound ? &in_doNotPauseOnExceptionsAndMuteConsole : 0, returnByValue_valueFound ? &in_returnByValue : 0, generatePreview_valueFound ? &in_generatePreview : 0, out_result, &out_wasThrown);

        if (!error.length()) {
            result->setValue("result", out_result);
            if (out_wasThrown.isAssigned())
                result->setBoolean("wasThrown", out_wasThrown.getValue());
        }
    }
    sendResponse(callId, result, commandNames[kRuntime_callFunctionOnCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Runtime_getProperties(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_runtimeAgent)
        protocolErrors->pushString("Runtime handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::Runtime::PropertyDescriptor> > out_result;
    RefPtr<TypeBuilder::Array<TypeBuilder::Runtime::InternalPropertyDescriptor> > out_internalProperties;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_objectId = getString(paramsContainerPtr, "objectId", 0, protocolErrorsPtr);
    bool ownProperties_valueFound = false;
    bool in_ownProperties = getBoolean(paramsContainerPtr, "ownProperties", &ownProperties_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_runtimeAgent->getProperties(&error, in_objectId, ownProperties_valueFound ? &in_ownProperties : 0, out_result, out_internalProperties);

        if (!error.length()) {
            result->setValue("result", out_result);
            if (out_internalProperties)
                result->setValue("internalProperties", out_internalProperties);
        }
    }
    sendResponse(callId, result, commandNames[kRuntime_getPropertiesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Runtime_releaseObject(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_runtimeAgent)
        protocolErrors->pushString("Runtime handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_objectId = getString(paramsContainerPtr, "objectId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_runtimeAgent->releaseObject(&error, in_objectId);


    }
    sendResponse(callId, result, commandNames[kRuntime_releaseObjectCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Runtime_releaseObjectGroup(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_runtimeAgent)
        protocolErrors->pushString("Runtime handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_objectGroup = getString(paramsContainerPtr, "objectGroup", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_runtimeAgent->releaseObjectGroup(&error, in_objectGroup);


    }
    sendResponse(callId, result, commandNames[kRuntime_releaseObjectGroupCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Runtime_run(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_runtimeAgent)
        protocolErrors->pushString("Runtime handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_runtimeAgent->run(&error);


    }
    sendResponse(callId, result, commandNames[kRuntime_runCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Runtime_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_runtimeAgent)
        protocolErrors->pushString("Runtime handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_runtimeAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kRuntime_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Runtime_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_runtimeAgent)
        protocolErrors->pushString("Runtime handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_runtimeAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kRuntime_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Console_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_consoleAgent)
        protocolErrors->pushString("Console handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_consoleAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kConsole_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Console_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_consoleAgent)
        protocolErrors->pushString("Console handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_consoleAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kConsole_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Console_clearMessages(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_consoleAgent)
        protocolErrors->pushString("Console handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_consoleAgent->clearMessages(&error);


    }
    sendResponse(callId, result, commandNames[kConsole_clearMessagesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Console_setMonitoringXHREnabled(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_consoleAgent)
        protocolErrors->pushString("Console handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_enabled = getBoolean(paramsContainerPtr, "enabled", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_consoleAgent->setMonitoringXHREnabled(&error, in_enabled);


    }
    sendResponse(callId, result, commandNames[kConsole_setMonitoringXHREnabledCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Console_addInspectedNode(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_consoleAgent)
        protocolErrors->pushString("Console handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_consoleAgent->addInspectedNode(&error, in_nodeId);


    }
    sendResponse(callId, result, commandNames[kConsole_addInspectedNodeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Console_addInspectedHeapObject(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_consoleAgent)
        protocolErrors->pushString("Console handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_heapObjectId = getInt(paramsContainerPtr, "heapObjectId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_consoleAgent->addInspectedHeapObject(&error, in_heapObjectId);


    }
    sendResponse(callId, result, commandNames[kConsole_addInspectedHeapObjectCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Network_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_networkAgent)
        protocolErrors->pushString("Network handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_networkAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kNetwork_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Network_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_networkAgent)
        protocolErrors->pushString("Network handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_networkAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kNetwork_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Network_setUserAgentOverride(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_networkAgent)
        protocolErrors->pushString("Network handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_userAgent = getString(paramsContainerPtr, "userAgent", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_networkAgent->setUserAgentOverride(&error, in_userAgent);


    }
    sendResponse(callId, result, commandNames[kNetwork_setUserAgentOverrideCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Network_setExtraHTTPHeaders(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_networkAgent)
        protocolErrors->pushString("Network handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    RefPtr<InspectorObject> in_headers = getObject(paramsContainerPtr, "headers", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_networkAgent->setExtraHTTPHeaders(&error, in_headers);


    }
    sendResponse(callId, result, commandNames[kNetwork_setExtraHTTPHeadersCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Network_getResponseBody(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_networkAgent)
        protocolErrors->pushString("Network handler is not available.");

    String out_body;
    bool out_base64Encoded;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_requestId = getString(paramsContainerPtr, "requestId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_networkAgent->getResponseBody(&error, in_requestId, &out_body, &out_base64Encoded);

        if (!error.length()) {
            result->setString("body", out_body);
            result->setBoolean("base64Encoded", out_base64Encoded);
        }
    }
    sendResponse(callId, result, commandNames[kNetwork_getResponseBodyCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Network_replayXHR(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_networkAgent)
        protocolErrors->pushString("Network handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_requestId = getString(paramsContainerPtr, "requestId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_networkAgent->replayXHR(&error, in_requestId);


    }
    sendResponse(callId, result, commandNames[kNetwork_replayXHRCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Network_canClearBrowserCache(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_networkAgent)
        protocolErrors->pushString("Network handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_networkAgent->canClearBrowserCache(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kNetwork_canClearBrowserCacheCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Network_clearBrowserCache(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_networkAgent)
        protocolErrors->pushString("Network handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_networkAgent->clearBrowserCache(&error);


    }
    sendResponse(callId, result, commandNames[kNetwork_clearBrowserCacheCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Network_canClearBrowserCookies(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_networkAgent)
        protocolErrors->pushString("Network handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_networkAgent->canClearBrowserCookies(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kNetwork_canClearBrowserCookiesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Network_clearBrowserCookies(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_networkAgent)
        protocolErrors->pushString("Network handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_networkAgent->clearBrowserCookies(&error);


    }
    sendResponse(callId, result, commandNames[kNetwork_clearBrowserCookiesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Network_setCacheDisabled(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_networkAgent)
        protocolErrors->pushString("Network handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_cacheDisabled = getBoolean(paramsContainerPtr, "cacheDisabled", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_networkAgent->setCacheDisabled(&error, in_cacheDisabled);


    }
    sendResponse(callId, result, commandNames[kNetwork_setCacheDisabledCmd], protocolErrors, error);
}

#if ENABLE(SQL_DATABASE)

void InspectorBackendDispatcherImpl::Database_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_databaseAgent)
        protocolErrors->pushString("Database handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_databaseAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kDatabase_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Database_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_databaseAgent)
        protocolErrors->pushString("Database handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_databaseAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kDatabase_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Database_getDatabaseTableNames(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_databaseAgent)
        protocolErrors->pushString("Database handler is not available.");

    RefPtr<TypeBuilder::Array<String> > out_tableNames;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_databaseId = getString(paramsContainerPtr, "databaseId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_databaseAgent->getDatabaseTableNames(&error, in_databaseId, out_tableNames);

        if (!error.length()) {
            result->setValue("tableNames", out_tableNames);
        }
    }
    sendResponse(callId, result, commandNames[kDatabase_getDatabaseTableNamesCmd], protocolErrors, error);
}

InspectorBackendDispatcher::DatabaseCommandHandler::ExecuteSQLCallback::ExecuteSQLCallback(PassRefPtr<InspectorBackendDispatcherImpl> backendImpl, int id) : CallbackBase(backendImpl, id) {}

void InspectorBackendDispatcher::DatabaseCommandHandler::ExecuteSQLCallback::sendSuccess(PassRefPtr<TypeBuilder::Array<String> > columnNames, PassRefPtr<TypeBuilder::Array<InspectorValue> > values, PassRefPtr<TypeBuilder::Database::Error> sqlError)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    if (columnNames)
        jsonMessage->setValue("columnNames", columnNames);
    if (values)
        jsonMessage->setValue("values", values);
    if (sqlError)
        jsonMessage->setValue("sqlError", sqlError);
    sendIfActive(jsonMessage, ErrorString());
}

void InspectorBackendDispatcherImpl::Database_executeSQL(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_databaseAgent)
        protocolErrors->pushString("Database handler is not available.");
    RefPtr<DatabaseCommandHandler::ExecuteSQLCallback> callback = adoptRef(new DatabaseCommandHandler::ExecuteSQLCallback(this, callId));


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_databaseId = getString(paramsContainerPtr, "databaseId", 0, protocolErrorsPtr);
    String in_query = getString(paramsContainerPtr, "query", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_databaseAgent->executeSQL(&error, in_databaseId, in_query, callback);

        if (!error.length()) 
            return;
        callback->disable();

    }
    sendResponse(callId, result, commandNames[kDatabase_executeSQLCmd], protocolErrors, error);
}

#endif // ENABLE(SQL_DATABASE)

#if ENABLE(INDEXED_DATABASE)

void InspectorBackendDispatcherImpl::IndexedDB_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_indexedDBAgent)
        protocolErrors->pushString("IndexedDB handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_indexedDBAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kIndexedDB_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::IndexedDB_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_indexedDBAgent)
        protocolErrors->pushString("IndexedDB handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_indexedDBAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kIndexedDB_disableCmd], protocolErrors, error);
}

InspectorBackendDispatcher::IndexedDBCommandHandler::RequestDatabaseNamesForFrameCallback::RequestDatabaseNamesForFrameCallback(PassRefPtr<InspectorBackendDispatcherImpl> backendImpl, int id) : CallbackBase(backendImpl, id) {}

void InspectorBackendDispatcher::IndexedDBCommandHandler::RequestDatabaseNamesForFrameCallback::sendSuccess(PassRefPtr<TypeBuilder::IndexedDB::SecurityOriginWithDatabaseNames> securityOriginWithDatabaseNames)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setValue("securityOriginWithDatabaseNames", securityOriginWithDatabaseNames);
    sendIfActive(jsonMessage, ErrorString());
}

void InspectorBackendDispatcherImpl::IndexedDB_requestDatabaseNamesForFrame(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_indexedDBAgent)
        protocolErrors->pushString("IndexedDB handler is not available.");
    RefPtr<IndexedDBCommandHandler::RequestDatabaseNamesForFrameCallback> callback = adoptRef(new IndexedDBCommandHandler::RequestDatabaseNamesForFrameCallback(this, callId));


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_frameId = getString(paramsContainerPtr, "frameId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_indexedDBAgent->requestDatabaseNamesForFrame(&error, in_frameId, callback);

        if (!error.length()) 
            return;
        callback->disable();

    }
    sendResponse(callId, result, commandNames[kIndexedDB_requestDatabaseNamesForFrameCmd], protocolErrors, error);
}

InspectorBackendDispatcher::IndexedDBCommandHandler::RequestDatabaseCallback::RequestDatabaseCallback(PassRefPtr<InspectorBackendDispatcherImpl> backendImpl, int id) : CallbackBase(backendImpl, id) {}

void InspectorBackendDispatcher::IndexedDBCommandHandler::RequestDatabaseCallback::sendSuccess(PassRefPtr<TypeBuilder::IndexedDB::DatabaseWithObjectStores> databaseWithObjectStores)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setValue("databaseWithObjectStores", databaseWithObjectStores);
    sendIfActive(jsonMessage, ErrorString());
}

void InspectorBackendDispatcherImpl::IndexedDB_requestDatabase(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_indexedDBAgent)
        protocolErrors->pushString("IndexedDB handler is not available.");
    RefPtr<IndexedDBCommandHandler::RequestDatabaseCallback> callback = adoptRef(new IndexedDBCommandHandler::RequestDatabaseCallback(this, callId));


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_frameId = getString(paramsContainerPtr, "frameId", 0, protocolErrorsPtr);
    String in_databaseName = getString(paramsContainerPtr, "databaseName", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_indexedDBAgent->requestDatabase(&error, in_frameId, in_databaseName, callback);

        if (!error.length()) 
            return;
        callback->disable();

    }
    sendResponse(callId, result, commandNames[kIndexedDB_requestDatabaseCmd], protocolErrors, error);
}

InspectorBackendDispatcher::IndexedDBCommandHandler::RequestDataCallback::RequestDataCallback(PassRefPtr<InspectorBackendDispatcherImpl> backendImpl, int id) : CallbackBase(backendImpl, id) {}

void InspectorBackendDispatcher::IndexedDBCommandHandler::RequestDataCallback::sendSuccess(PassRefPtr<TypeBuilder::Array<TypeBuilder::IndexedDB::DataEntry> > objectStoreDataEntries, bool hasMore)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setValue("objectStoreDataEntries", objectStoreDataEntries);
    jsonMessage->setBoolean("hasMore", hasMore);
    sendIfActive(jsonMessage, ErrorString());
}

void InspectorBackendDispatcherImpl::IndexedDB_requestData(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_indexedDBAgent)
        protocolErrors->pushString("IndexedDB handler is not available.");
    RefPtr<IndexedDBCommandHandler::RequestDataCallback> callback = adoptRef(new IndexedDBCommandHandler::RequestDataCallback(this, callId));


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_frameId = getString(paramsContainerPtr, "frameId", 0, protocolErrorsPtr);
    String in_databaseName = getString(paramsContainerPtr, "databaseName", 0, protocolErrorsPtr);
    String in_objectStoreName = getString(paramsContainerPtr, "objectStoreName", 0, protocolErrorsPtr);
    String in_indexName = getString(paramsContainerPtr, "indexName", 0, protocolErrorsPtr);
    int in_skipCount = getInt(paramsContainerPtr, "skipCount", 0, protocolErrorsPtr);
    int in_pageSize = getInt(paramsContainerPtr, "pageSize", 0, protocolErrorsPtr);
    bool keyRange_valueFound = false;
    RefPtr<InspectorObject> in_keyRange = getObject(paramsContainerPtr, "keyRange", &keyRange_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_indexedDBAgent->requestData(&error, in_frameId, in_databaseName, in_objectStoreName, in_indexName, in_skipCount, in_pageSize, keyRange_valueFound ? &in_keyRange : 0, callback);

        if (!error.length()) 
            return;
        callback->disable();

    }
    sendResponse(callId, result, commandNames[kIndexedDB_requestDataCmd], protocolErrors, error);
}

#endif // ENABLE(INDEXED_DATABASE)

void InspectorBackendDispatcherImpl::DOMStorage_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domStorageAgent)
        protocolErrors->pushString("DOMStorage handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domStorageAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kDOMStorage_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOMStorage_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domStorageAgent)
        protocolErrors->pushString("DOMStorage handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domStorageAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kDOMStorage_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOMStorage_getDOMStorageEntries(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domStorageAgent)
        protocolErrors->pushString("DOMStorage handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::Array<String> > > out_entries;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_storageId = getString(paramsContainerPtr, "storageId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domStorageAgent->getDOMStorageEntries(&error, in_storageId, out_entries);

        if (!error.length()) {
            result->setValue("entries", out_entries);
        }
    }
    sendResponse(callId, result, commandNames[kDOMStorage_getDOMStorageEntriesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOMStorage_setDOMStorageItem(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domStorageAgent)
        protocolErrors->pushString("DOMStorage handler is not available.");

    bool out_success;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_storageId = getString(paramsContainerPtr, "storageId", 0, protocolErrorsPtr);
    String in_key = getString(paramsContainerPtr, "key", 0, protocolErrorsPtr);
    String in_value = getString(paramsContainerPtr, "value", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domStorageAgent->setDOMStorageItem(&error, in_storageId, in_key, in_value, &out_success);

        if (!error.length()) {
            result->setBoolean("success", out_success);
        }
    }
    sendResponse(callId, result, commandNames[kDOMStorage_setDOMStorageItemCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOMStorage_removeDOMStorageItem(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domStorageAgent)
        protocolErrors->pushString("DOMStorage handler is not available.");

    bool out_success;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_storageId = getString(paramsContainerPtr, "storageId", 0, protocolErrorsPtr);
    String in_key = getString(paramsContainerPtr, "key", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domStorageAgent->removeDOMStorageItem(&error, in_storageId, in_key, &out_success);

        if (!error.length()) {
            result->setBoolean("success", out_success);
        }
    }
    sendResponse(callId, result, commandNames[kDOMStorage_removeDOMStorageItemCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::ApplicationCache_getFramesWithManifests(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_applicationCacheAgent)
        protocolErrors->pushString("ApplicationCache handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::ApplicationCache::FrameWithManifest> > out_frameIds;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_applicationCacheAgent->getFramesWithManifests(&error, out_frameIds);

        if (!error.length()) {
            result->setValue("frameIds", out_frameIds);
        }
    }
    sendResponse(callId, result, commandNames[kApplicationCache_getFramesWithManifestsCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::ApplicationCache_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_applicationCacheAgent)
        protocolErrors->pushString("ApplicationCache handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_applicationCacheAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kApplicationCache_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::ApplicationCache_getManifestForFrame(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_applicationCacheAgent)
        protocolErrors->pushString("ApplicationCache handler is not available.");

    String out_manifestURL;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_frameId = getString(paramsContainerPtr, "frameId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_applicationCacheAgent->getManifestForFrame(&error, in_frameId, &out_manifestURL);

        if (!error.length()) {
            result->setString("manifestURL", out_manifestURL);
        }
    }
    sendResponse(callId, result, commandNames[kApplicationCache_getManifestForFrameCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::ApplicationCache_getApplicationCacheForFrame(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_applicationCacheAgent)
        protocolErrors->pushString("ApplicationCache handler is not available.");

    RefPtr<TypeBuilder::ApplicationCache::ApplicationCache> out_applicationCache;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_frameId = getString(paramsContainerPtr, "frameId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_applicationCacheAgent->getApplicationCacheForFrame(&error, in_frameId, out_applicationCache);

        if (!error.length()) {
            result->setValue("applicationCache", out_applicationCache);
        }
    }
    sendResponse(callId, result, commandNames[kApplicationCache_getApplicationCacheForFrameCmd], protocolErrors, error);
}

#if ENABLE(FILE_SYSTEM)

void InspectorBackendDispatcherImpl::FileSystem_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_fileSystemAgent)
        protocolErrors->pushString("FileSystem handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_fileSystemAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kFileSystem_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::FileSystem_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_fileSystemAgent)
        protocolErrors->pushString("FileSystem handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_fileSystemAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kFileSystem_disableCmd], protocolErrors, error);
}

InspectorBackendDispatcher::FileSystemCommandHandler::RequestFileSystemRootCallback::RequestFileSystemRootCallback(PassRefPtr<InspectorBackendDispatcherImpl> backendImpl, int id) : CallbackBase(backendImpl, id) {}

void InspectorBackendDispatcher::FileSystemCommandHandler::RequestFileSystemRootCallback::sendSuccess(int errorCode, PassRefPtr<TypeBuilder::FileSystem::Entry> root)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setNumber("errorCode", errorCode);
    if (root)
        jsonMessage->setValue("root", root);
    sendIfActive(jsonMessage, ErrorString());
}

void InspectorBackendDispatcherImpl::FileSystem_requestFileSystemRoot(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_fileSystemAgent)
        protocolErrors->pushString("FileSystem handler is not available.");
    RefPtr<FileSystemCommandHandler::RequestFileSystemRootCallback> callback = adoptRef(new FileSystemCommandHandler::RequestFileSystemRootCallback(this, callId));


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_origin = getString(paramsContainerPtr, "origin", 0, protocolErrorsPtr);
    String in_type = getString(paramsContainerPtr, "type", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_fileSystemAgent->requestFileSystemRoot(&error, in_origin, in_type, callback);

        if (!error.length()) 
            return;
        callback->disable();

    }
    sendResponse(callId, result, commandNames[kFileSystem_requestFileSystemRootCmd], protocolErrors, error);
}

InspectorBackendDispatcher::FileSystemCommandHandler::RequestDirectoryContentCallback::RequestDirectoryContentCallback(PassRefPtr<InspectorBackendDispatcherImpl> backendImpl, int id) : CallbackBase(backendImpl, id) {}

void InspectorBackendDispatcher::FileSystemCommandHandler::RequestDirectoryContentCallback::sendSuccess(int errorCode, PassRefPtr<TypeBuilder::Array<TypeBuilder::FileSystem::Entry> > entries)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setNumber("errorCode", errorCode);
    if (entries)
        jsonMessage->setValue("entries", entries);
    sendIfActive(jsonMessage, ErrorString());
}

void InspectorBackendDispatcherImpl::FileSystem_requestDirectoryContent(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_fileSystemAgent)
        protocolErrors->pushString("FileSystem handler is not available.");
    RefPtr<FileSystemCommandHandler::RequestDirectoryContentCallback> callback = adoptRef(new FileSystemCommandHandler::RequestDirectoryContentCallback(this, callId));


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_url = getString(paramsContainerPtr, "url", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_fileSystemAgent->requestDirectoryContent(&error, in_url, callback);

        if (!error.length()) 
            return;
        callback->disable();

    }
    sendResponse(callId, result, commandNames[kFileSystem_requestDirectoryContentCmd], protocolErrors, error);
}

InspectorBackendDispatcher::FileSystemCommandHandler::RequestMetadataCallback::RequestMetadataCallback(PassRefPtr<InspectorBackendDispatcherImpl> backendImpl, int id) : CallbackBase(backendImpl, id) {}

void InspectorBackendDispatcher::FileSystemCommandHandler::RequestMetadataCallback::sendSuccess(int errorCode, PassRefPtr<TypeBuilder::FileSystem::Metadata> metadata)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setNumber("errorCode", errorCode);
    if (metadata)
        jsonMessage->setValue("metadata", metadata);
    sendIfActive(jsonMessage, ErrorString());
}

void InspectorBackendDispatcherImpl::FileSystem_requestMetadata(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_fileSystemAgent)
        protocolErrors->pushString("FileSystem handler is not available.");
    RefPtr<FileSystemCommandHandler::RequestMetadataCallback> callback = adoptRef(new FileSystemCommandHandler::RequestMetadataCallback(this, callId));


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_url = getString(paramsContainerPtr, "url", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_fileSystemAgent->requestMetadata(&error, in_url, callback);

        if (!error.length()) 
            return;
        callback->disable();

    }
    sendResponse(callId, result, commandNames[kFileSystem_requestMetadataCmd], protocolErrors, error);
}

InspectorBackendDispatcher::FileSystemCommandHandler::RequestFileContentCallback::RequestFileContentCallback(PassRefPtr<InspectorBackendDispatcherImpl> backendImpl, int id) : CallbackBase(backendImpl, id) {}

void InspectorBackendDispatcher::FileSystemCommandHandler::RequestFileContentCallback::sendSuccess(int errorCode, const String* const content, const String* const charset)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setNumber("errorCode", errorCode);
    if (content)
        jsonMessage->setString("content", *content);
    if (charset)
        jsonMessage->setString("charset", *charset);
    sendIfActive(jsonMessage, ErrorString());
}

void InspectorBackendDispatcherImpl::FileSystem_requestFileContent(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_fileSystemAgent)
        protocolErrors->pushString("FileSystem handler is not available.");
    RefPtr<FileSystemCommandHandler::RequestFileContentCallback> callback = adoptRef(new FileSystemCommandHandler::RequestFileContentCallback(this, callId));


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_url = getString(paramsContainerPtr, "url", 0, protocolErrorsPtr);
    bool in_readAsText = getBoolean(paramsContainerPtr, "readAsText", 0, protocolErrorsPtr);
    bool start_valueFound = false;
    int in_start = getInt(paramsContainerPtr, "start", &start_valueFound, protocolErrorsPtr);
    bool end_valueFound = false;
    int in_end = getInt(paramsContainerPtr, "end", &end_valueFound, protocolErrorsPtr);
    bool charset_valueFound = false;
    String in_charset = getString(paramsContainerPtr, "charset", &charset_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_fileSystemAgent->requestFileContent(&error, in_url, in_readAsText, start_valueFound ? &in_start : 0, end_valueFound ? &in_end : 0, charset_valueFound ? &in_charset : 0, callback);

        if (!error.length()) 
            return;
        callback->disable();

    }
    sendResponse(callId, result, commandNames[kFileSystem_requestFileContentCmd], protocolErrors, error);
}

InspectorBackendDispatcher::FileSystemCommandHandler::DeleteEntryCallback::DeleteEntryCallback(PassRefPtr<InspectorBackendDispatcherImpl> backendImpl, int id) : CallbackBase(backendImpl, id) {}

void InspectorBackendDispatcher::FileSystemCommandHandler::DeleteEntryCallback::sendSuccess(int errorCode)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setNumber("errorCode", errorCode);
    sendIfActive(jsonMessage, ErrorString());
}

void InspectorBackendDispatcherImpl::FileSystem_deleteEntry(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_fileSystemAgent)
        protocolErrors->pushString("FileSystem handler is not available.");
    RefPtr<FileSystemCommandHandler::DeleteEntryCallback> callback = adoptRef(new FileSystemCommandHandler::DeleteEntryCallback(this, callId));


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_url = getString(paramsContainerPtr, "url", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_fileSystemAgent->deleteEntry(&error, in_url, callback);

        if (!error.length()) 
            return;
        callback->disable();

    }
    sendResponse(callId, result, commandNames[kFileSystem_deleteEntryCmd], protocolErrors, error);
}

#endif // ENABLE(FILE_SYSTEM)

void InspectorBackendDispatcherImpl::DOM_getDocument(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    RefPtr<TypeBuilder::DOM::Node> out_root;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->getDocument(&error, out_root);

        if (!error.length()) {
            result->setValue("root", out_root);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_getDocumentCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_requestChildNodes(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    bool depth_valueFound = false;
    int in_depth = getInt(paramsContainerPtr, "depth", &depth_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->requestChildNodes(&error, in_nodeId, depth_valueFound ? &in_depth : 0);


    }
    sendResponse(callId, result, commandNames[kDOM_requestChildNodesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_querySelector(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    int out_nodeId;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    String in_selector = getString(paramsContainerPtr, "selector", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->querySelector(&error, in_nodeId, in_selector, &out_nodeId);

        if (!error.length()) {
            result->setNumber("nodeId", out_nodeId);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_querySelectorCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_querySelectorAll(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    RefPtr<TypeBuilder::Array<int> > out_nodeIds;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    String in_selector = getString(paramsContainerPtr, "selector", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->querySelectorAll(&error, in_nodeId, in_selector, out_nodeIds);

        if (!error.length()) {
            result->setValue("nodeIds", out_nodeIds);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_querySelectorAllCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_setNodeName(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    int out_nodeId;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    String in_name = getString(paramsContainerPtr, "name", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->setNodeName(&error, in_nodeId, in_name, &out_nodeId);

        if (!error.length()) {
            result->setNumber("nodeId", out_nodeId);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_setNodeNameCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_setNodeValue(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    String in_value = getString(paramsContainerPtr, "value", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->setNodeValue(&error, in_nodeId, in_value);


    }
    sendResponse(callId, result, commandNames[kDOM_setNodeValueCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_removeNode(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->removeNode(&error, in_nodeId);


    }
    sendResponse(callId, result, commandNames[kDOM_removeNodeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_setAttributeValue(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    String in_name = getString(paramsContainerPtr, "name", 0, protocolErrorsPtr);
    String in_value = getString(paramsContainerPtr, "value", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->setAttributeValue(&error, in_nodeId, in_name, in_value);


    }
    sendResponse(callId, result, commandNames[kDOM_setAttributeValueCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_setAttributesAsText(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    String in_text = getString(paramsContainerPtr, "text", 0, protocolErrorsPtr);
    bool name_valueFound = false;
    String in_name = getString(paramsContainerPtr, "name", &name_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->setAttributesAsText(&error, in_nodeId, in_text, name_valueFound ? &in_name : 0);


    }
    sendResponse(callId, result, commandNames[kDOM_setAttributesAsTextCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_removeAttribute(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    String in_name = getString(paramsContainerPtr, "name", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->removeAttribute(&error, in_nodeId, in_name);


    }
    sendResponse(callId, result, commandNames[kDOM_removeAttributeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_getEventListenersForNode(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::DOM::EventListener> > out_listeners;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    bool objectGroup_valueFound = false;
    String in_objectGroup = getString(paramsContainerPtr, "objectGroup", &objectGroup_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->getEventListenersForNode(&error, in_nodeId, objectGroup_valueFound ? &in_objectGroup : 0, out_listeners);

        if (!error.length()) {
            result->setValue("listeners", out_listeners);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_getEventListenersForNodeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_getOuterHTML(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    String out_outerHTML;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->getOuterHTML(&error, in_nodeId, &out_outerHTML);

        if (!error.length()) {
            result->setString("outerHTML", out_outerHTML);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_getOuterHTMLCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_setOuterHTML(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    String in_outerHTML = getString(paramsContainerPtr, "outerHTML", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->setOuterHTML(&error, in_nodeId, in_outerHTML);


    }
    sendResponse(callId, result, commandNames[kDOM_setOuterHTMLCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_performSearch(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    String out_searchId;
    int out_resultCount;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_query = getString(paramsContainerPtr, "query", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->performSearch(&error, in_query, &out_searchId, &out_resultCount);

        if (!error.length()) {
            result->setString("searchId", out_searchId);
            result->setNumber("resultCount", out_resultCount);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_performSearchCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_getSearchResults(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    RefPtr<TypeBuilder::Array<int> > out_nodeIds;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_searchId = getString(paramsContainerPtr, "searchId", 0, protocolErrorsPtr);
    int in_fromIndex = getInt(paramsContainerPtr, "fromIndex", 0, protocolErrorsPtr);
    int in_toIndex = getInt(paramsContainerPtr, "toIndex", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->getSearchResults(&error, in_searchId, in_fromIndex, in_toIndex, out_nodeIds);

        if (!error.length()) {
            result->setValue("nodeIds", out_nodeIds);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_getSearchResultsCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_discardSearchResults(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_searchId = getString(paramsContainerPtr, "searchId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->discardSearchResults(&error, in_searchId);


    }
    sendResponse(callId, result, commandNames[kDOM_discardSearchResultsCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_requestNode(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    int out_nodeId;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_objectId = getString(paramsContainerPtr, "objectId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->requestNode(&error, in_objectId, &out_nodeId);

        if (!error.length()) {
            result->setNumber("nodeId", out_nodeId);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_requestNodeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_setInspectModeEnabled(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_enabled = getBoolean(paramsContainerPtr, "enabled", 0, protocolErrorsPtr);
    bool highlightConfig_valueFound = false;
    RefPtr<InspectorObject> in_highlightConfig = getObject(paramsContainerPtr, "highlightConfig", &highlightConfig_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->setInspectModeEnabled(&error, in_enabled, highlightConfig_valueFound ? &in_highlightConfig : 0);


    }
    sendResponse(callId, result, commandNames[kDOM_setInspectModeEnabledCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_highlightRect(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_x = getInt(paramsContainerPtr, "x", 0, protocolErrorsPtr);
    int in_y = getInt(paramsContainerPtr, "y", 0, protocolErrorsPtr);
    int in_width = getInt(paramsContainerPtr, "width", 0, protocolErrorsPtr);
    int in_height = getInt(paramsContainerPtr, "height", 0, protocolErrorsPtr);
    bool color_valueFound = false;
    RefPtr<InspectorObject> in_color = getObject(paramsContainerPtr, "color", &color_valueFound, protocolErrorsPtr);
    bool outlineColor_valueFound = false;
    RefPtr<InspectorObject> in_outlineColor = getObject(paramsContainerPtr, "outlineColor", &outlineColor_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->highlightRect(&error, in_x, in_y, in_width, in_height, color_valueFound ? &in_color : 0, outlineColor_valueFound ? &in_outlineColor : 0);


    }
    sendResponse(callId, result, commandNames[kDOM_highlightRectCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_highlightNode(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    RefPtr<InspectorObject> in_highlightConfig = getObject(paramsContainerPtr, "highlightConfig", 0, protocolErrorsPtr);
    bool nodeId_valueFound = false;
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", &nodeId_valueFound, protocolErrorsPtr);
    bool objectId_valueFound = false;
    String in_objectId = getString(paramsContainerPtr, "objectId", &objectId_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->highlightNode(&error, in_highlightConfig, nodeId_valueFound ? &in_nodeId : 0, objectId_valueFound ? &in_objectId : 0);


    }
    sendResponse(callId, result, commandNames[kDOM_highlightNodeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_hideHighlight(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->hideHighlight(&error);


    }
    sendResponse(callId, result, commandNames[kDOM_hideHighlightCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_highlightFrame(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_frameId = getString(paramsContainerPtr, "frameId", 0, protocolErrorsPtr);
    bool contentColor_valueFound = false;
    RefPtr<InspectorObject> in_contentColor = getObject(paramsContainerPtr, "contentColor", &contentColor_valueFound, protocolErrorsPtr);
    bool contentOutlineColor_valueFound = false;
    RefPtr<InspectorObject> in_contentOutlineColor = getObject(paramsContainerPtr, "contentOutlineColor", &contentOutlineColor_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->highlightFrame(&error, in_frameId, contentColor_valueFound ? &in_contentColor : 0, contentOutlineColor_valueFound ? &in_contentOutlineColor : 0);


    }
    sendResponse(callId, result, commandNames[kDOM_highlightFrameCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_pushNodeByPathToFrontend(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    int out_nodeId;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_path = getString(paramsContainerPtr, "path", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->pushNodeByPathToFrontend(&error, in_path, &out_nodeId);

        if (!error.length()) {
            result->setNumber("nodeId", out_nodeId);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_pushNodeByPathToFrontendCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_resolveNode(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    RefPtr<TypeBuilder::Runtime::RemoteObject> out_object;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    bool objectGroup_valueFound = false;
    String in_objectGroup = getString(paramsContainerPtr, "objectGroup", &objectGroup_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->resolveNode(&error, in_nodeId, objectGroup_valueFound ? &in_objectGroup : 0, out_object);

        if (!error.length()) {
            result->setValue("object", out_object);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_resolveNodeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_getAttributes(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    RefPtr<TypeBuilder::Array<String> > out_attributes;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->getAttributes(&error, in_nodeId, out_attributes);

        if (!error.length()) {
            result->setValue("attributes", out_attributes);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_getAttributesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_moveTo(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");

    int out_nodeId;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    int in_targetNodeId = getInt(paramsContainerPtr, "targetNodeId", 0, protocolErrorsPtr);
    bool insertBeforeNodeId_valueFound = false;
    int in_insertBeforeNodeId = getInt(paramsContainerPtr, "insertBeforeNodeId", &insertBeforeNodeId_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->moveTo(&error, in_nodeId, in_targetNodeId, insertBeforeNodeId_valueFound ? &in_insertBeforeNodeId : 0, &out_nodeId);

        if (!error.length()) {
            result->setNumber("nodeId", out_nodeId);
        }
    }
    sendResponse(callId, result, commandNames[kDOM_moveToCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_undo(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->undo(&error);


    }
    sendResponse(callId, result, commandNames[kDOM_undoCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_redo(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->redo(&error);


    }
    sendResponse(callId, result, commandNames[kDOM_redoCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_markUndoableState(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->markUndoableState(&error);


    }
    sendResponse(callId, result, commandNames[kDOM_markUndoableStateCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_focus(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->focus(&error, in_nodeId);


    }
    sendResponse(callId, result, commandNames[kDOM_focusCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOM_setFileInputFiles(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domAgent)
        protocolErrors->pushString("DOM handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    RefPtr<InspectorArray> in_files = getArray(paramsContainerPtr, "files", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domAgent->setFileInputFiles(&error, in_nodeId, in_files);


    }
    sendResponse(callId, result, commandNames[kDOM_setFileInputFilesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kCSS_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kCSS_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_getMatchedStylesForNode(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::CSS::RuleMatch> > out_matchedCSSRules;
    RefPtr<TypeBuilder::Array<TypeBuilder::CSS::PseudoIdMatches> > out_pseudoElements;
    RefPtr<TypeBuilder::Array<TypeBuilder::CSS::InheritedStyleEntry> > out_inherited;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    bool includePseudo_valueFound = false;
    bool in_includePseudo = getBoolean(paramsContainerPtr, "includePseudo", &includePseudo_valueFound, protocolErrorsPtr);
    bool includeInherited_valueFound = false;
    bool in_includeInherited = getBoolean(paramsContainerPtr, "includeInherited", &includeInherited_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->getMatchedStylesForNode(&error, in_nodeId, includePseudo_valueFound ? &in_includePseudo : 0, includeInherited_valueFound ? &in_includeInherited : 0, out_matchedCSSRules, out_pseudoElements, out_inherited);

        if (!error.length()) {
            if (out_matchedCSSRules)
                result->setValue("matchedCSSRules", out_matchedCSSRules);
            if (out_pseudoElements)
                result->setValue("pseudoElements", out_pseudoElements);
            if (out_inherited)
                result->setValue("inherited", out_inherited);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_getMatchedStylesForNodeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_getInlineStylesForNode(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    RefPtr<TypeBuilder::CSS::CSSStyle> out_inlineStyle;
    RefPtr<TypeBuilder::CSS::CSSStyle> out_attributesStyle;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->getInlineStylesForNode(&error, in_nodeId, out_inlineStyle, out_attributesStyle);

        if (!error.length()) {
            if (out_inlineStyle)
                result->setValue("inlineStyle", out_inlineStyle);
            if (out_attributesStyle)
                result->setValue("attributesStyle", out_attributesStyle);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_getInlineStylesForNodeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_getComputedStyleForNode(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::CSS::CSSComputedStyleProperty> > out_computedStyle;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->getComputedStyleForNode(&error, in_nodeId, out_computedStyle);

        if (!error.length()) {
            result->setValue("computedStyle", out_computedStyle);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_getComputedStyleForNodeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_getAllStyleSheets(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::CSS::CSSStyleSheetHeader> > out_headers;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->getAllStyleSheets(&error, out_headers);

        if (!error.length()) {
            result->setValue("headers", out_headers);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_getAllStyleSheetsCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_getStyleSheet(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    RefPtr<TypeBuilder::CSS::CSSStyleSheetBody> out_styleSheet;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_styleSheetId = getString(paramsContainerPtr, "styleSheetId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->getStyleSheet(&error, in_styleSheetId, out_styleSheet);

        if (!error.length()) {
            result->setValue("styleSheet", out_styleSheet);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_getStyleSheetCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_getStyleSheetText(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    String out_text;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_styleSheetId = getString(paramsContainerPtr, "styleSheetId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->getStyleSheetText(&error, in_styleSheetId, &out_text);

        if (!error.length()) {
            result->setString("text", out_text);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_getStyleSheetTextCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_setStyleSheetText(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_styleSheetId = getString(paramsContainerPtr, "styleSheetId", 0, protocolErrorsPtr);
    String in_text = getString(paramsContainerPtr, "text", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->setStyleSheetText(&error, in_styleSheetId, in_text);


    }
    sendResponse(callId, result, commandNames[kCSS_setStyleSheetTextCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_setPropertyText(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    RefPtr<TypeBuilder::CSS::CSSStyle> out_style;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    RefPtr<InspectorObject> in_styleId = getObject(paramsContainerPtr, "styleId", 0, protocolErrorsPtr);
    int in_propertyIndex = getInt(paramsContainerPtr, "propertyIndex", 0, protocolErrorsPtr);
    String in_text = getString(paramsContainerPtr, "text", 0, protocolErrorsPtr);
    bool in_overwrite = getBoolean(paramsContainerPtr, "overwrite", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->setPropertyText(&error, in_styleId, in_propertyIndex, in_text, in_overwrite, out_style);

        if (!error.length()) {
            result->setValue("style", out_style);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_setPropertyTextCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_toggleProperty(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    RefPtr<TypeBuilder::CSS::CSSStyle> out_style;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    RefPtr<InspectorObject> in_styleId = getObject(paramsContainerPtr, "styleId", 0, protocolErrorsPtr);
    int in_propertyIndex = getInt(paramsContainerPtr, "propertyIndex", 0, protocolErrorsPtr);
    bool in_disable = getBoolean(paramsContainerPtr, "disable", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->toggleProperty(&error, in_styleId, in_propertyIndex, in_disable, out_style);

        if (!error.length()) {
            result->setValue("style", out_style);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_togglePropertyCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_setRuleSelector(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    RefPtr<TypeBuilder::CSS::CSSRule> out_rule;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    RefPtr<InspectorObject> in_ruleId = getObject(paramsContainerPtr, "ruleId", 0, protocolErrorsPtr);
    String in_selector = getString(paramsContainerPtr, "selector", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->setRuleSelector(&error, in_ruleId, in_selector, out_rule);

        if (!error.length()) {
            result->setValue("rule", out_rule);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_setRuleSelectorCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_addRule(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    RefPtr<TypeBuilder::CSS::CSSRule> out_rule;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_contextNodeId = getInt(paramsContainerPtr, "contextNodeId", 0, protocolErrorsPtr);
    String in_selector = getString(paramsContainerPtr, "selector", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->addRule(&error, in_contextNodeId, in_selector, out_rule);

        if (!error.length()) {
            result->setValue("rule", out_rule);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_addRuleCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_getSupportedCSSProperties(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::CSS::CSSPropertyInfo> > out_cssProperties;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->getSupportedCSSProperties(&error, out_cssProperties);

        if (!error.length()) {
            result->setValue("cssProperties", out_cssProperties);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_getSupportedCSSPropertiesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_forcePseudoState(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    RefPtr<InspectorArray> in_forcedPseudoClasses = getArray(paramsContainerPtr, "forcedPseudoClasses", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->forcePseudoState(&error, in_nodeId, in_forcedPseudoClasses);


    }
    sendResponse(callId, result, commandNames[kCSS_forcePseudoStateCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_startSelectorProfiler(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->startSelectorProfiler(&error);


    }
    sendResponse(callId, result, commandNames[kCSS_startSelectorProfilerCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_stopSelectorProfiler(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    RefPtr<TypeBuilder::CSS::SelectorProfile> out_profile;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->stopSelectorProfiler(&error, out_profile);

        if (!error.length()) {
            result->setValue("profile", out_profile);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_stopSelectorProfilerCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::CSS_getNamedFlowCollection(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_cssAgent)
        protocolErrors->pushString("CSS handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::CSS::NamedFlow> > out_namedFlows;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_documentNodeId = getInt(paramsContainerPtr, "documentNodeId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_cssAgent->getNamedFlowCollection(&error, in_documentNodeId, out_namedFlows);

        if (!error.length()) {
            result->setValue("namedFlows", out_namedFlows);
        }
    }
    sendResponse(callId, result, commandNames[kCSS_getNamedFlowCollectionCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Timeline_start(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_timelineAgent)
        protocolErrors->pushString("Timeline handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool maxCallStackDepth_valueFound = false;
    int in_maxCallStackDepth = getInt(paramsContainerPtr, "maxCallStackDepth", &maxCallStackDepth_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_timelineAgent->start(&error, maxCallStackDepth_valueFound ? &in_maxCallStackDepth : 0);


    }
    sendResponse(callId, result, commandNames[kTimeline_startCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Timeline_stop(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_timelineAgent)
        protocolErrors->pushString("Timeline handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_timelineAgent->stop(&error);


    }
    sendResponse(callId, result, commandNames[kTimeline_stopCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Timeline_setIncludeDomCounters(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_timelineAgent)
        protocolErrors->pushString("Timeline handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_enabled = getBoolean(paramsContainerPtr, "enabled", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_timelineAgent->setIncludeDomCounters(&error, in_enabled);


    }
    sendResponse(callId, result, commandNames[kTimeline_setIncludeDomCountersCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Timeline_setIncludeNativeMemoryStatistics(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_timelineAgent)
        protocolErrors->pushString("Timeline handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_enabled = getBoolean(paramsContainerPtr, "enabled", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_timelineAgent->setIncludeNativeMemoryStatistics(&error, in_enabled);


    }
    sendResponse(callId, result, commandNames[kTimeline_setIncludeNativeMemoryStatisticsCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Timeline_supportsFrameInstrumentation(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_timelineAgent)
        protocolErrors->pushString("Timeline handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_timelineAgent->supportsFrameInstrumentation(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kTimeline_supportsFrameInstrumentationCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Timeline_canMonitorMainThread(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_timelineAgent)
        protocolErrors->pushString("Timeline handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_timelineAgent->canMonitorMainThread(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kTimeline_canMonitorMainThreadCmd], protocolErrors, error);
}

#if ENABLE(JAVASCRIPT_DEBUGGER)

void InspectorBackendDispatcherImpl::Debugger_causesRecompilation(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->causesRecompilation(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_causesRecompilationCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_supportsSeparateScriptCompilationAndExecution(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->supportsSeparateScriptCompilationAndExecution(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_supportsSeparateScriptCompilationAndExecutionCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kDebugger_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kDebugger_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_setBreakpointsActive(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_active = getBoolean(paramsContainerPtr, "active", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->setBreakpointsActive(&error, in_active);


    }
    sendResponse(callId, result, commandNames[kDebugger_setBreakpointsActiveCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_setBreakpointByUrl(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    TypeBuilder::Debugger::BreakpointId out_breakpointId;
    RefPtr<TypeBuilder::Array<TypeBuilder::Debugger::Location> > out_locations;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_lineNumber = getInt(paramsContainerPtr, "lineNumber", 0, protocolErrorsPtr);
    bool url_valueFound = false;
    String in_url = getString(paramsContainerPtr, "url", &url_valueFound, protocolErrorsPtr);
    bool urlRegex_valueFound = false;
    String in_urlRegex = getString(paramsContainerPtr, "urlRegex", &urlRegex_valueFound, protocolErrorsPtr);
    bool columnNumber_valueFound = false;
    int in_columnNumber = getInt(paramsContainerPtr, "columnNumber", &columnNumber_valueFound, protocolErrorsPtr);
    bool condition_valueFound = false;
    String in_condition = getString(paramsContainerPtr, "condition", &condition_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->setBreakpointByUrl(&error, in_lineNumber, url_valueFound ? &in_url : 0, urlRegex_valueFound ? &in_urlRegex : 0, columnNumber_valueFound ? &in_columnNumber : 0, condition_valueFound ? &in_condition : 0, &out_breakpointId, out_locations);

        if (!error.length()) {
            result->setString("breakpointId", out_breakpointId);
            result->setValue("locations", out_locations);
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_setBreakpointByUrlCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_setBreakpoint(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    TypeBuilder::Debugger::BreakpointId out_breakpointId;
    RefPtr<TypeBuilder::Debugger::Location> out_actualLocation;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    RefPtr<InspectorObject> in_location = getObject(paramsContainerPtr, "location", 0, protocolErrorsPtr);
    bool condition_valueFound = false;
    String in_condition = getString(paramsContainerPtr, "condition", &condition_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->setBreakpoint(&error, in_location, condition_valueFound ? &in_condition : 0, &out_breakpointId, out_actualLocation);

        if (!error.length()) {
            result->setString("breakpointId", out_breakpointId);
            result->setValue("actualLocation", out_actualLocation);
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_setBreakpointCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_removeBreakpoint(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_breakpointId = getString(paramsContainerPtr, "breakpointId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->removeBreakpoint(&error, in_breakpointId);


    }
    sendResponse(callId, result, commandNames[kDebugger_removeBreakpointCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_continueToLocation(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    RefPtr<InspectorObject> in_location = getObject(paramsContainerPtr, "location", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->continueToLocation(&error, in_location);


    }
    sendResponse(callId, result, commandNames[kDebugger_continueToLocationCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_stepOver(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->stepOver(&error);


    }
    sendResponse(callId, result, commandNames[kDebugger_stepOverCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_stepInto(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->stepInto(&error);


    }
    sendResponse(callId, result, commandNames[kDebugger_stepIntoCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_stepOut(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->stepOut(&error);


    }
    sendResponse(callId, result, commandNames[kDebugger_stepOutCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_pause(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->pause(&error);


    }
    sendResponse(callId, result, commandNames[kDebugger_pauseCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_resume(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->resume(&error);


    }
    sendResponse(callId, result, commandNames[kDebugger_resumeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_searchInContent(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::Page::SearchMatch> > out_result;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_scriptId = getString(paramsContainerPtr, "scriptId", 0, protocolErrorsPtr);
    String in_query = getString(paramsContainerPtr, "query", 0, protocolErrorsPtr);
    bool caseSensitive_valueFound = false;
    bool in_caseSensitive = getBoolean(paramsContainerPtr, "caseSensitive", &caseSensitive_valueFound, protocolErrorsPtr);
    bool isRegex_valueFound = false;
    bool in_isRegex = getBoolean(paramsContainerPtr, "isRegex", &isRegex_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->searchInContent(&error, in_scriptId, in_query, caseSensitive_valueFound ? &in_caseSensitive : 0, isRegex_valueFound ? &in_isRegex : 0, out_result);

        if (!error.length()) {
            result->setValue("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_searchInContentCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_canSetScriptSource(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->canSetScriptSource(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_canSetScriptSourceCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_setScriptSource(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::Debugger::CallFrame> > out_callFrames;
    RefPtr<InspectorObject> out_result;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_scriptId = getString(paramsContainerPtr, "scriptId", 0, protocolErrorsPtr);
    String in_scriptSource = getString(paramsContainerPtr, "scriptSource", 0, protocolErrorsPtr);
    bool preview_valueFound = false;
    bool in_preview = getBoolean(paramsContainerPtr, "preview", &preview_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->setScriptSource(&error, in_scriptId, in_scriptSource, preview_valueFound ? &in_preview : 0, out_callFrames, out_result);

        if (!error.length()) {
            if (out_callFrames)
                result->setValue("callFrames", out_callFrames);
            if (out_result)
                result->setValue("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_setScriptSourceCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_restartFrame(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::Debugger::CallFrame> > out_callFrames;
    RefPtr<InspectorObject> out_result;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_callFrameId = getString(paramsContainerPtr, "callFrameId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->restartFrame(&error, in_callFrameId, out_callFrames, out_result);

        if (!error.length()) {
            result->setValue("callFrames", out_callFrames);
            result->setValue("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_restartFrameCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_getScriptSource(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    String out_scriptSource;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_scriptId = getString(paramsContainerPtr, "scriptId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->getScriptSource(&error, in_scriptId, &out_scriptSource);

        if (!error.length()) {
            result->setString("scriptSource", out_scriptSource);
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_getScriptSourceCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_getFunctionDetails(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    RefPtr<TypeBuilder::Debugger::FunctionDetails> out_details;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_functionId = getString(paramsContainerPtr, "functionId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->getFunctionDetails(&error, in_functionId, out_details);

        if (!error.length()) {
            result->setValue("details", out_details);
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_getFunctionDetailsCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_setPauseOnExceptions(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_state = getString(paramsContainerPtr, "state", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->setPauseOnExceptions(&error, in_state);


    }
    sendResponse(callId, result, commandNames[kDebugger_setPauseOnExceptionsCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_evaluateOnCallFrame(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    RefPtr<TypeBuilder::Runtime::RemoteObject> out_result;
    TypeBuilder::OptOutput<bool> out_wasThrown;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_callFrameId = getString(paramsContainerPtr, "callFrameId", 0, protocolErrorsPtr);
    String in_expression = getString(paramsContainerPtr, "expression", 0, protocolErrorsPtr);
    bool objectGroup_valueFound = false;
    String in_objectGroup = getString(paramsContainerPtr, "objectGroup", &objectGroup_valueFound, protocolErrorsPtr);
    bool includeCommandLineAPI_valueFound = false;
    bool in_includeCommandLineAPI = getBoolean(paramsContainerPtr, "includeCommandLineAPI", &includeCommandLineAPI_valueFound, protocolErrorsPtr);
    bool doNotPauseOnExceptionsAndMuteConsole_valueFound = false;
    bool in_doNotPauseOnExceptionsAndMuteConsole = getBoolean(paramsContainerPtr, "doNotPauseOnExceptionsAndMuteConsole", &doNotPauseOnExceptionsAndMuteConsole_valueFound, protocolErrorsPtr);
    bool returnByValue_valueFound = false;
    bool in_returnByValue = getBoolean(paramsContainerPtr, "returnByValue", &returnByValue_valueFound, protocolErrorsPtr);
    bool generatePreview_valueFound = false;
    bool in_generatePreview = getBoolean(paramsContainerPtr, "generatePreview", &generatePreview_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->evaluateOnCallFrame(&error, in_callFrameId, in_expression, objectGroup_valueFound ? &in_objectGroup : 0, includeCommandLineAPI_valueFound ? &in_includeCommandLineAPI : 0, doNotPauseOnExceptionsAndMuteConsole_valueFound ? &in_doNotPauseOnExceptionsAndMuteConsole : 0, returnByValue_valueFound ? &in_returnByValue : 0, generatePreview_valueFound ? &in_generatePreview : 0, out_result, &out_wasThrown);

        if (!error.length()) {
            result->setValue("result", out_result);
            if (out_wasThrown.isAssigned())
                result->setBoolean("wasThrown", out_wasThrown.getValue());
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_evaluateOnCallFrameCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_compileScript(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    TypeBuilder::OptOutput<TypeBuilder::Debugger::ScriptId> out_scriptId;
    TypeBuilder::OptOutput<String> out_syntaxErrorMessage;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_expression = getString(paramsContainerPtr, "expression", 0, protocolErrorsPtr);
    String in_sourceURL = getString(paramsContainerPtr, "sourceURL", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->compileScript(&error, in_expression, in_sourceURL, &out_scriptId, &out_syntaxErrorMessage);

        if (!error.length()) {
            if (out_scriptId.isAssigned())
                result->setString("scriptId", out_scriptId.getValue());
            if (out_syntaxErrorMessage.isAssigned())
                result->setString("syntaxErrorMessage", out_syntaxErrorMessage.getValue());
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_compileScriptCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_runScript(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");

    RefPtr<TypeBuilder::Runtime::RemoteObject> out_result;
    TypeBuilder::OptOutput<bool> out_wasThrown;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_scriptId = getString(paramsContainerPtr, "scriptId", 0, protocolErrorsPtr);
    bool contextId_valueFound = false;
    int in_contextId = getInt(paramsContainerPtr, "contextId", &contextId_valueFound, protocolErrorsPtr);
    bool objectGroup_valueFound = false;
    String in_objectGroup = getString(paramsContainerPtr, "objectGroup", &objectGroup_valueFound, protocolErrorsPtr);
    bool doNotPauseOnExceptionsAndMuteConsole_valueFound = false;
    bool in_doNotPauseOnExceptionsAndMuteConsole = getBoolean(paramsContainerPtr, "doNotPauseOnExceptionsAndMuteConsole", &doNotPauseOnExceptionsAndMuteConsole_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->runScript(&error, in_scriptId, contextId_valueFound ? &in_contextId : 0, objectGroup_valueFound ? &in_objectGroup : 0, doNotPauseOnExceptionsAndMuteConsole_valueFound ? &in_doNotPauseOnExceptionsAndMuteConsole : 0, out_result, &out_wasThrown);

        if (!error.length()) {
            result->setValue("result", out_result);
            if (out_wasThrown.isAssigned())
                result->setBoolean("wasThrown", out_wasThrown.getValue());
        }
    }
    sendResponse(callId, result, commandNames[kDebugger_runScriptCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_setOverlayMessage(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool message_valueFound = false;
    String in_message = getString(paramsContainerPtr, "message", &message_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->setOverlayMessage(&error, message_valueFound ? &in_message : 0);


    }
    sendResponse(callId, result, commandNames[kDebugger_setOverlayMessageCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Debugger_setVariableValue(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_debuggerAgent)
        protocolErrors->pushString("Debugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_scopeNumber = getInt(paramsContainerPtr, "scopeNumber", 0, protocolErrorsPtr);
    String in_variableName = getString(paramsContainerPtr, "variableName", 0, protocolErrorsPtr);
    RefPtr<InspectorObject> in_newValue = getObject(paramsContainerPtr, "newValue", 0, protocolErrorsPtr);
    bool callFrameId_valueFound = false;
    String in_callFrameId = getString(paramsContainerPtr, "callFrameId", &callFrameId_valueFound, protocolErrorsPtr);
    bool functionObjectId_valueFound = false;
    String in_functionObjectId = getString(paramsContainerPtr, "functionObjectId", &functionObjectId_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_debuggerAgent->setVariableValue(&error, in_scopeNumber, in_variableName, in_newValue, callFrameId_valueFound ? &in_callFrameId : 0, functionObjectId_valueFound ? &in_functionObjectId : 0);


    }
    sendResponse(callId, result, commandNames[kDebugger_setVariableValueCmd], protocolErrors, error);
}

#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

void InspectorBackendDispatcherImpl::DOMDebugger_setDOMBreakpoint(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domDebuggerAgent)
        protocolErrors->pushString("DOMDebugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    String in_type = getString(paramsContainerPtr, "type", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domDebuggerAgent->setDOMBreakpoint(&error, in_nodeId, in_type);


    }
    sendResponse(callId, result, commandNames[kDOMDebugger_setDOMBreakpointCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOMDebugger_removeDOMBreakpoint(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domDebuggerAgent)
        protocolErrors->pushString("DOMDebugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_nodeId = getInt(paramsContainerPtr, "nodeId", 0, protocolErrorsPtr);
    String in_type = getString(paramsContainerPtr, "type", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domDebuggerAgent->removeDOMBreakpoint(&error, in_nodeId, in_type);


    }
    sendResponse(callId, result, commandNames[kDOMDebugger_removeDOMBreakpointCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOMDebugger_setEventListenerBreakpoint(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domDebuggerAgent)
        protocolErrors->pushString("DOMDebugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_eventName = getString(paramsContainerPtr, "eventName", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domDebuggerAgent->setEventListenerBreakpoint(&error, in_eventName);


    }
    sendResponse(callId, result, commandNames[kDOMDebugger_setEventListenerBreakpointCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOMDebugger_removeEventListenerBreakpoint(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domDebuggerAgent)
        protocolErrors->pushString("DOMDebugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_eventName = getString(paramsContainerPtr, "eventName", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domDebuggerAgent->removeEventListenerBreakpoint(&error, in_eventName);


    }
    sendResponse(callId, result, commandNames[kDOMDebugger_removeEventListenerBreakpointCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOMDebugger_setInstrumentationBreakpoint(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domDebuggerAgent)
        protocolErrors->pushString("DOMDebugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_eventName = getString(paramsContainerPtr, "eventName", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domDebuggerAgent->setInstrumentationBreakpoint(&error, in_eventName);


    }
    sendResponse(callId, result, commandNames[kDOMDebugger_setInstrumentationBreakpointCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOMDebugger_removeInstrumentationBreakpoint(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domDebuggerAgent)
        protocolErrors->pushString("DOMDebugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_eventName = getString(paramsContainerPtr, "eventName", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domDebuggerAgent->removeInstrumentationBreakpoint(&error, in_eventName);


    }
    sendResponse(callId, result, commandNames[kDOMDebugger_removeInstrumentationBreakpointCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOMDebugger_setXHRBreakpoint(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domDebuggerAgent)
        protocolErrors->pushString("DOMDebugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_url = getString(paramsContainerPtr, "url", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domDebuggerAgent->setXHRBreakpoint(&error, in_url);


    }
    sendResponse(callId, result, commandNames[kDOMDebugger_setXHRBreakpointCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::DOMDebugger_removeXHRBreakpoint(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_domDebuggerAgent)
        protocolErrors->pushString("DOMDebugger handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_url = getString(paramsContainerPtr, "url", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_domDebuggerAgent->removeXHRBreakpoint(&error, in_url);


    }
    sendResponse(callId, result, commandNames[kDOMDebugger_removeXHRBreakpointCmd], protocolErrors, error);
}

#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

void InspectorBackendDispatcherImpl::Profiler_causesRecompilation(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->causesRecompilation(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kProfiler_causesRecompilationCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_isSampling(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->isSampling(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kProfiler_isSamplingCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_hasHeapProfiler(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->hasHeapProfiler(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kProfiler_hasHeapProfilerCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kProfiler_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kProfiler_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_start(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->start(&error);


    }
    sendResponse(callId, result, commandNames[kProfiler_startCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_stop(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->stop(&error);


    }
    sendResponse(callId, result, commandNames[kProfiler_stopCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_getProfileHeaders(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::Profiler::ProfileHeader> > out_headers;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->getProfileHeaders(&error, out_headers);

        if (!error.length()) {
            result->setValue("headers", out_headers);
        }
    }
    sendResponse(callId, result, commandNames[kProfiler_getProfileHeadersCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_getCPUProfile(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");

    RefPtr<TypeBuilder::Profiler::CPUProfile> out_profile;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_uid = getInt(paramsContainerPtr, "uid", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->getCPUProfile(&error, in_uid, out_profile);

        if (!error.length()) {
            result->setValue("profile", out_profile);
        }
    }
    sendResponse(callId, result, commandNames[kProfiler_getCPUProfileCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_getHeapSnapshot(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_uid = getInt(paramsContainerPtr, "uid", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->getHeapSnapshot(&error, in_uid);


    }
    sendResponse(callId, result, commandNames[kProfiler_getHeapSnapshotCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_removeProfile(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_type = getString(paramsContainerPtr, "type", 0, protocolErrorsPtr);
    int in_uid = getInt(paramsContainerPtr, "uid", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->removeProfile(&error, in_type, in_uid);


    }
    sendResponse(callId, result, commandNames[kProfiler_removeProfileCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_clearProfiles(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->clearProfiles(&error);


    }
    sendResponse(callId, result, commandNames[kProfiler_clearProfilesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_takeHeapSnapshot(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool reportProgress_valueFound = false;
    bool in_reportProgress = getBoolean(paramsContainerPtr, "reportProgress", &reportProgress_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->takeHeapSnapshot(&error, reportProgress_valueFound ? &in_reportProgress : 0);


    }
    sendResponse(callId, result, commandNames[kProfiler_takeHeapSnapshotCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_collectGarbage(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->collectGarbage(&error);


    }
    sendResponse(callId, result, commandNames[kProfiler_collectGarbageCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_getObjectByHeapObjectId(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");

    RefPtr<TypeBuilder::Runtime::RemoteObject> out_result;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_objectId = getString(paramsContainerPtr, "objectId", 0, protocolErrorsPtr);
    bool objectGroup_valueFound = false;
    String in_objectGroup = getString(paramsContainerPtr, "objectGroup", &objectGroup_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->getObjectByHeapObjectId(&error, in_objectId, objectGroup_valueFound ? &in_objectGroup : 0, out_result);

        if (!error.length()) {
            result->setValue("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kProfiler_getObjectByHeapObjectIdCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Profiler_getHeapObjectId(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_profilerAgent)
        protocolErrors->pushString("Profiler handler is not available.");

    TypeBuilder::Profiler::HeapSnapshotObjectId out_heapSnapshotObjectId;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_objectId = getString(paramsContainerPtr, "objectId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_profilerAgent->getHeapObjectId(&error, in_objectId, &out_heapSnapshotObjectId);

        if (!error.length()) {
            result->setString("heapSnapshotObjectId", out_heapSnapshotObjectId);
        }
    }
    sendResponse(callId, result, commandNames[kProfiler_getHeapObjectIdCmd], protocolErrors, error);
}

#endif // ENABLE(JAVASCRIPT_DEBUGGER)

void InspectorBackendDispatcherImpl::HeapProfiler_hasHeapProfiler(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_heapProfilerAgent)
        protocolErrors->pushString("HeapProfiler handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_heapProfilerAgent->hasHeapProfiler(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kHeapProfiler_hasHeapProfilerCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::HeapProfiler_getProfileHeaders(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_heapProfilerAgent)
        protocolErrors->pushString("HeapProfiler handler is not available.");

    RefPtr<TypeBuilder::Array<TypeBuilder::HeapProfiler::ProfileHeader> > out_headers;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_heapProfilerAgent->getProfileHeaders(&error, out_headers);

        if (!error.length()) {
            result->setValue("headers", out_headers);
        }
    }
    sendResponse(callId, result, commandNames[kHeapProfiler_getProfileHeadersCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::HeapProfiler_getHeapSnapshot(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_heapProfilerAgent)
        protocolErrors->pushString("HeapProfiler handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_uid = getInt(paramsContainerPtr, "uid", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_heapProfilerAgent->getHeapSnapshot(&error, in_uid);


    }
    sendResponse(callId, result, commandNames[kHeapProfiler_getHeapSnapshotCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::HeapProfiler_removeProfile(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_heapProfilerAgent)
        protocolErrors->pushString("HeapProfiler handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_uid = getInt(paramsContainerPtr, "uid", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_heapProfilerAgent->removeProfile(&error, in_uid);


    }
    sendResponse(callId, result, commandNames[kHeapProfiler_removeProfileCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::HeapProfiler_clearProfiles(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_heapProfilerAgent)
        protocolErrors->pushString("HeapProfiler handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_heapProfilerAgent->clearProfiles(&error);


    }
    sendResponse(callId, result, commandNames[kHeapProfiler_clearProfilesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::HeapProfiler_takeHeapSnapshot(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_heapProfilerAgent)
        protocolErrors->pushString("HeapProfiler handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool reportProgress_valueFound = false;
    bool in_reportProgress = getBoolean(paramsContainerPtr, "reportProgress", &reportProgress_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_heapProfilerAgent->takeHeapSnapshot(&error, reportProgress_valueFound ? &in_reportProgress : 0);


    }
    sendResponse(callId, result, commandNames[kHeapProfiler_takeHeapSnapshotCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::HeapProfiler_collectGarbage(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_heapProfilerAgent)
        protocolErrors->pushString("HeapProfiler handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_heapProfilerAgent->collectGarbage(&error);


    }
    sendResponse(callId, result, commandNames[kHeapProfiler_collectGarbageCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::HeapProfiler_getObjectByHeapObjectId(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_heapProfilerAgent)
        protocolErrors->pushString("HeapProfiler handler is not available.");

    RefPtr<TypeBuilder::Runtime::RemoteObject> out_result;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_objectId = getString(paramsContainerPtr, "objectId", 0, protocolErrorsPtr);
    bool objectGroup_valueFound = false;
    String in_objectGroup = getString(paramsContainerPtr, "objectGroup", &objectGroup_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_heapProfilerAgent->getObjectByHeapObjectId(&error, in_objectId, objectGroup_valueFound ? &in_objectGroup : 0, out_result);

        if (!error.length()) {
            result->setValue("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kHeapProfiler_getObjectByHeapObjectIdCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::HeapProfiler_getHeapObjectId(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_heapProfilerAgent)
        protocolErrors->pushString("HeapProfiler handler is not available.");

    TypeBuilder::HeapProfiler::HeapSnapshotObjectId out_heapSnapshotObjectId;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_objectId = getString(paramsContainerPtr, "objectId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_heapProfilerAgent->getHeapObjectId(&error, in_objectId, &out_heapSnapshotObjectId);

        if (!error.length()) {
            result->setString("heapSnapshotObjectId", out_heapSnapshotObjectId);
        }
    }
    sendResponse(callId, result, commandNames[kHeapProfiler_getHeapObjectIdCmd], protocolErrors, error);
}

#if ENABLE(WORKERS)

void InspectorBackendDispatcherImpl::Worker_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_workerAgent)
        protocolErrors->pushString("Worker handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_workerAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kWorker_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Worker_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_workerAgent)
        protocolErrors->pushString("Worker handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_workerAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kWorker_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Worker_sendMessageToWorker(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_workerAgent)
        protocolErrors->pushString("Worker handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_workerId = getInt(paramsContainerPtr, "workerId", 0, protocolErrorsPtr);
    RefPtr<InspectorObject> in_message = getObject(paramsContainerPtr, "message", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_workerAgent->sendMessageToWorker(&error, in_workerId, in_message);


    }
    sendResponse(callId, result, commandNames[kWorker_sendMessageToWorkerCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Worker_connectToWorker(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_workerAgent)
        protocolErrors->pushString("Worker handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_workerId = getInt(paramsContainerPtr, "workerId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_workerAgent->connectToWorker(&error, in_workerId);


    }
    sendResponse(callId, result, commandNames[kWorker_connectToWorkerCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Worker_disconnectFromWorker(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_workerAgent)
        protocolErrors->pushString("Worker handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    int in_workerId = getInt(paramsContainerPtr, "workerId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_workerAgent->disconnectFromWorker(&error, in_workerId);


    }
    sendResponse(callId, result, commandNames[kWorker_disconnectFromWorkerCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Worker_setAutoconnectToWorkers(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_workerAgent)
        protocolErrors->pushString("Worker handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool in_value = getBoolean(paramsContainerPtr, "value", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_workerAgent->setAutoconnectToWorkers(&error, in_value);


    }
    sendResponse(callId, result, commandNames[kWorker_setAutoconnectToWorkersCmd], protocolErrors, error);
}

#endif // ENABLE(WORKERS)

void InspectorBackendDispatcherImpl::Canvas_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_canvasAgent)
        protocolErrors->pushString("Canvas handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_canvasAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kCanvas_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Canvas_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_canvasAgent)
        protocolErrors->pushString("Canvas handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_canvasAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kCanvas_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Canvas_dropTraceLog(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_canvasAgent)
        protocolErrors->pushString("Canvas handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_traceLogId = getString(paramsContainerPtr, "traceLogId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_canvasAgent->dropTraceLog(&error, in_traceLogId);


    }
    sendResponse(callId, result, commandNames[kCanvas_dropTraceLogCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Canvas_hasUninstrumentedCanvases(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_canvasAgent)
        protocolErrors->pushString("Canvas handler is not available.");

    bool out_result;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_canvasAgent->hasUninstrumentedCanvases(&error, &out_result);

        if (!error.length()) {
            result->setBoolean("result", out_result);
        }
    }
    sendResponse(callId, result, commandNames[kCanvas_hasUninstrumentedCanvasesCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Canvas_captureFrame(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_canvasAgent)
        protocolErrors->pushString("Canvas handler is not available.");

    TypeBuilder::Canvas::TraceLogId out_traceLogId;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool frameId_valueFound = false;
    String in_frameId = getString(paramsContainerPtr, "frameId", &frameId_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_canvasAgent->captureFrame(&error, frameId_valueFound ? &in_frameId : 0, &out_traceLogId);

        if (!error.length()) {
            result->setString("traceLogId", out_traceLogId);
        }
    }
    sendResponse(callId, result, commandNames[kCanvas_captureFrameCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Canvas_startCapturing(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_canvasAgent)
        protocolErrors->pushString("Canvas handler is not available.");

    TypeBuilder::Canvas::TraceLogId out_traceLogId;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    bool frameId_valueFound = false;
    String in_frameId = getString(paramsContainerPtr, "frameId", &frameId_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_canvasAgent->startCapturing(&error, frameId_valueFound ? &in_frameId : 0, &out_traceLogId);

        if (!error.length()) {
            result->setString("traceLogId", out_traceLogId);
        }
    }
    sendResponse(callId, result, commandNames[kCanvas_startCapturingCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Canvas_stopCapturing(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_canvasAgent)
        protocolErrors->pushString("Canvas handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_traceLogId = getString(paramsContainerPtr, "traceLogId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_canvasAgent->stopCapturing(&error, in_traceLogId);


    }
    sendResponse(callId, result, commandNames[kCanvas_stopCapturingCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Canvas_getTraceLog(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_canvasAgent)
        protocolErrors->pushString("Canvas handler is not available.");

    RefPtr<TypeBuilder::Canvas::TraceLog> out_traceLog;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_traceLogId = getString(paramsContainerPtr, "traceLogId", 0, protocolErrorsPtr);
    bool startOffset_valueFound = false;
    int in_startOffset = getInt(paramsContainerPtr, "startOffset", &startOffset_valueFound, protocolErrorsPtr);
    bool maxLength_valueFound = false;
    int in_maxLength = getInt(paramsContainerPtr, "maxLength", &maxLength_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_canvasAgent->getTraceLog(&error, in_traceLogId, startOffset_valueFound ? &in_startOffset : 0, maxLength_valueFound ? &in_maxLength : 0, out_traceLog);

        if (!error.length()) {
            result->setValue("traceLog", out_traceLog);
        }
    }
    sendResponse(callId, result, commandNames[kCanvas_getTraceLogCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Canvas_replayTraceLog(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_canvasAgent)
        protocolErrors->pushString("Canvas handler is not available.");

    RefPtr<TypeBuilder::Canvas::ResourceState> out_resourceState;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_traceLogId = getString(paramsContainerPtr, "traceLogId", 0, protocolErrorsPtr);
    int in_stepNo = getInt(paramsContainerPtr, "stepNo", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_canvasAgent->replayTraceLog(&error, in_traceLogId, in_stepNo, out_resourceState);

        if (!error.length()) {
            result->setValue("resourceState", out_resourceState);
        }
    }
    sendResponse(callId, result, commandNames[kCanvas_replayTraceLogCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Canvas_getResourceInfo(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_canvasAgent)
        protocolErrors->pushString("Canvas handler is not available.");

    RefPtr<TypeBuilder::Canvas::ResourceInfo> out_resourceInfo;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_resourceId = getString(paramsContainerPtr, "resourceId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_canvasAgent->getResourceInfo(&error, in_resourceId, out_resourceInfo);

        if (!error.length()) {
            result->setValue("resourceInfo", out_resourceInfo);
        }
    }
    sendResponse(callId, result, commandNames[kCanvas_getResourceInfoCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Canvas_getResourceState(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_canvasAgent)
        protocolErrors->pushString("Canvas handler is not available.");

    RefPtr<TypeBuilder::Canvas::ResourceState> out_resourceState;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_traceLogId = getString(paramsContainerPtr, "traceLogId", 0, protocolErrorsPtr);
    String in_resourceId = getString(paramsContainerPtr, "resourceId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_canvasAgent->getResourceState(&error, in_traceLogId, in_resourceId, out_resourceState);

        if (!error.length()) {
            result->setValue("resourceState", out_resourceState);
        }
    }
    sendResponse(callId, result, commandNames[kCanvas_getResourceStateCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Input_dispatchKeyEvent(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_inputAgent)
        protocolErrors->pushString("Input handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_type = getString(paramsContainerPtr, "type", 0, protocolErrorsPtr);
    bool modifiers_valueFound = false;
    int in_modifiers = getInt(paramsContainerPtr, "modifiers", &modifiers_valueFound, protocolErrorsPtr);
    bool timestamp_valueFound = false;
    double in_timestamp = getDouble(paramsContainerPtr, "timestamp", &timestamp_valueFound, protocolErrorsPtr);
    bool text_valueFound = false;
    String in_text = getString(paramsContainerPtr, "text", &text_valueFound, protocolErrorsPtr);
    bool unmodifiedText_valueFound = false;
    String in_unmodifiedText = getString(paramsContainerPtr, "unmodifiedText", &unmodifiedText_valueFound, protocolErrorsPtr);
    bool keyIdentifier_valueFound = false;
    String in_keyIdentifier = getString(paramsContainerPtr, "keyIdentifier", &keyIdentifier_valueFound, protocolErrorsPtr);
    bool windowsVirtualKeyCode_valueFound = false;
    int in_windowsVirtualKeyCode = getInt(paramsContainerPtr, "windowsVirtualKeyCode", &windowsVirtualKeyCode_valueFound, protocolErrorsPtr);
    bool nativeVirtualKeyCode_valueFound = false;
    int in_nativeVirtualKeyCode = getInt(paramsContainerPtr, "nativeVirtualKeyCode", &nativeVirtualKeyCode_valueFound, protocolErrorsPtr);
    bool macCharCode_valueFound = false;
    int in_macCharCode = getInt(paramsContainerPtr, "macCharCode", &macCharCode_valueFound, protocolErrorsPtr);
    bool autoRepeat_valueFound = false;
    bool in_autoRepeat = getBoolean(paramsContainerPtr, "autoRepeat", &autoRepeat_valueFound, protocolErrorsPtr);
    bool isKeypad_valueFound = false;
    bool in_isKeypad = getBoolean(paramsContainerPtr, "isKeypad", &isKeypad_valueFound, protocolErrorsPtr);
    bool isSystemKey_valueFound = false;
    bool in_isSystemKey = getBoolean(paramsContainerPtr, "isSystemKey", &isSystemKey_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_inputAgent->dispatchKeyEvent(&error, in_type, modifiers_valueFound ? &in_modifiers : 0, timestamp_valueFound ? &in_timestamp : 0, text_valueFound ? &in_text : 0, unmodifiedText_valueFound ? &in_unmodifiedText : 0, keyIdentifier_valueFound ? &in_keyIdentifier : 0, windowsVirtualKeyCode_valueFound ? &in_windowsVirtualKeyCode : 0, nativeVirtualKeyCode_valueFound ? &in_nativeVirtualKeyCode : 0, macCharCode_valueFound ? &in_macCharCode : 0, autoRepeat_valueFound ? &in_autoRepeat : 0, isKeypad_valueFound ? &in_isKeypad : 0, isSystemKey_valueFound ? &in_isSystemKey : 0);


    }
    sendResponse(callId, result, commandNames[kInput_dispatchKeyEventCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::Input_dispatchMouseEvent(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_inputAgent)
        protocolErrors->pushString("Input handler is not available.");


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_type = getString(paramsContainerPtr, "type", 0, protocolErrorsPtr);
    int in_x = getInt(paramsContainerPtr, "x", 0, protocolErrorsPtr);
    int in_y = getInt(paramsContainerPtr, "y", 0, protocolErrorsPtr);
    bool modifiers_valueFound = false;
    int in_modifiers = getInt(paramsContainerPtr, "modifiers", &modifiers_valueFound, protocolErrorsPtr);
    bool timestamp_valueFound = false;
    double in_timestamp = getDouble(paramsContainerPtr, "timestamp", &timestamp_valueFound, protocolErrorsPtr);
    bool button_valueFound = false;
    String in_button = getString(paramsContainerPtr, "button", &button_valueFound, protocolErrorsPtr);
    bool clickCount_valueFound = false;
    int in_clickCount = getInt(paramsContainerPtr, "clickCount", &clickCount_valueFound, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_inputAgent->dispatchMouseEvent(&error, in_type, in_x, in_y, modifiers_valueFound ? &in_modifiers : 0, timestamp_valueFound ? &in_timestamp : 0, button_valueFound ? &in_button : 0, clickCount_valueFound ? &in_clickCount : 0);


    }
    sendResponse(callId, result, commandNames[kInput_dispatchMouseEventCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::LayerTree_enable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_layerTreeAgent)
        protocolErrors->pushString("LayerTree handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_layerTreeAgent->enable(&error);


    }
    sendResponse(callId, result, commandNames[kLayerTree_enableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::LayerTree_disable(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_layerTreeAgent)
        protocolErrors->pushString("LayerTree handler is not available.");


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_layerTreeAgent->disable(&error);


    }
    sendResponse(callId, result, commandNames[kLayerTree_disableCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::LayerTree_getLayerTree(long callId, InspectorObject*)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_layerTreeAgent)
        protocolErrors->pushString("LayerTree handler is not available.");

    RefPtr<TypeBuilder::LayerTree::Layer> out_layerTree;


    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_layerTreeAgent->getLayerTree(&error, out_layerTree);

        if (!error.length()) {
            result->setValue("layerTree", out_layerTree);
        }
    }
    sendResponse(callId, result, commandNames[kLayerTree_getLayerTreeCmd], protocolErrors, error);
}

void InspectorBackendDispatcherImpl::LayerTree_nodeIdForLayerId(long callId, InspectorObject* requestMessageObject)
{
    RefPtr<InspectorArray> protocolErrors = InspectorArray::create();

    if (!m_layerTreeAgent)
        protocolErrors->pushString("LayerTree handler is not available.");

    int out_nodeId;


    RefPtr<InspectorObject> paramsContainer = requestMessageObject->getObject("params");
    InspectorObject* paramsContainerPtr = paramsContainer.get();
    InspectorArray* protocolErrorsPtr = protocolErrors.get();
    String in_layerId = getString(paramsContainerPtr, "layerId", 0, protocolErrorsPtr);

    RefPtr<InspectorObject> result = InspectorObject::create();
    ErrorString error;
    if (!protocolErrors->length()) {
        m_layerTreeAgent->nodeIdForLayerId(&error, in_layerId, &out_nodeId);

        if (!error.length()) {
            result->setNumber("nodeId", out_nodeId);
        }
    }
    sendResponse(callId, result, commandNames[kLayerTree_nodeIdForLayerIdCmd], protocolErrors, error);
}


PassRefPtr<InspectorBackendDispatcher> InspectorBackendDispatcher::create(InspectorFrontendChannel* inspectorFrontendChannel)
{
    return adoptRef(new InspectorBackendDispatcherImpl(inspectorFrontendChannel));
}


void InspectorBackendDispatcherImpl::dispatch(const String& message)
{
    RefPtr<InspectorBackendDispatcher> protect = this;
    typedef void (InspectorBackendDispatcherImpl::*CallHandler)(long callId, InspectorObject* messageObject);
    typedef HashMap<String, CallHandler> DispatchMap;
    DEFINE_STATIC_LOCAL(DispatchMap, dispatchMap, );
    long callId = 0;

    if (dispatchMap.isEmpty()) {
        static CallHandler handlers[] = {
            &InspectorBackendDispatcherImpl::Inspector_enable,
            &InspectorBackendDispatcherImpl::Inspector_disable,
            &InspectorBackendDispatcherImpl::Memory_getDOMCounters,
            &InspectorBackendDispatcherImpl::Memory_getProcessMemoryDistribution,
            &InspectorBackendDispatcherImpl::Page_enable,
            &InspectorBackendDispatcherImpl::Page_disable,
            &InspectorBackendDispatcherImpl::Page_addScriptToEvaluateOnLoad,
            &InspectorBackendDispatcherImpl::Page_removeScriptToEvaluateOnLoad,
            &InspectorBackendDispatcherImpl::Page_reload,
            &InspectorBackendDispatcherImpl::Page_navigate,
            &InspectorBackendDispatcherImpl::Page_getCookies,
            &InspectorBackendDispatcherImpl::Page_deleteCookie,
            &InspectorBackendDispatcherImpl::Page_getResourceTree,
            &InspectorBackendDispatcherImpl::Page_getResourceContent,
            &InspectorBackendDispatcherImpl::Page_searchInResource,
            &InspectorBackendDispatcherImpl::Page_searchInResources,
            &InspectorBackendDispatcherImpl::Page_setDocumentContent,
            &InspectorBackendDispatcherImpl::Page_canOverrideDeviceMetrics,
            &InspectorBackendDispatcherImpl::Page_setDeviceMetricsOverride,
            &InspectorBackendDispatcherImpl::Page_setShowPaintRects,
            &InspectorBackendDispatcherImpl::Page_canShowDebugBorders,
            &InspectorBackendDispatcherImpl::Page_setShowDebugBorders,
            &InspectorBackendDispatcherImpl::Page_canShowFPSCounter,
            &InspectorBackendDispatcherImpl::Page_setShowFPSCounter,
            &InspectorBackendDispatcherImpl::Page_canContinuouslyPaint,
            &InspectorBackendDispatcherImpl::Page_setContinuousPaintingEnabled,
            &InspectorBackendDispatcherImpl::Page_getScriptExecutionStatus,
            &InspectorBackendDispatcherImpl::Page_setScriptExecutionDisabled,
            &InspectorBackendDispatcherImpl::Page_setGeolocationOverride,
            &InspectorBackendDispatcherImpl::Page_clearGeolocationOverride,
            &InspectorBackendDispatcherImpl::Page_canOverrideGeolocation,
            &InspectorBackendDispatcherImpl::Page_setDeviceOrientationOverride,
            &InspectorBackendDispatcherImpl::Page_clearDeviceOrientationOverride,
            &InspectorBackendDispatcherImpl::Page_canOverrideDeviceOrientation,
            &InspectorBackendDispatcherImpl::Page_setTouchEmulationEnabled,
            &InspectorBackendDispatcherImpl::Page_setEmulatedMedia,
            &InspectorBackendDispatcherImpl::Page_getCompositingBordersVisible,
            &InspectorBackendDispatcherImpl::Page_setCompositingBordersVisible,
            &InspectorBackendDispatcherImpl::Page_captureScreenshot,
            &InspectorBackendDispatcherImpl::Page_handleJavaScriptDialog,
            &InspectorBackendDispatcherImpl::Runtime_evaluate,
            &InspectorBackendDispatcherImpl::Runtime_callFunctionOn,
            &InspectorBackendDispatcherImpl::Runtime_getProperties,
            &InspectorBackendDispatcherImpl::Runtime_releaseObject,
            &InspectorBackendDispatcherImpl::Runtime_releaseObjectGroup,
            &InspectorBackendDispatcherImpl::Runtime_run,
            &InspectorBackendDispatcherImpl::Runtime_enable,
            &InspectorBackendDispatcherImpl::Runtime_disable,
            &InspectorBackendDispatcherImpl::Console_enable,
            &InspectorBackendDispatcherImpl::Console_disable,
            &InspectorBackendDispatcherImpl::Console_clearMessages,
            &InspectorBackendDispatcherImpl::Console_setMonitoringXHREnabled,
            &InspectorBackendDispatcherImpl::Console_addInspectedNode,
            &InspectorBackendDispatcherImpl::Console_addInspectedHeapObject,
            &InspectorBackendDispatcherImpl::Network_enable,
            &InspectorBackendDispatcherImpl::Network_disable,
            &InspectorBackendDispatcherImpl::Network_setUserAgentOverride,
            &InspectorBackendDispatcherImpl::Network_setExtraHTTPHeaders,
            &InspectorBackendDispatcherImpl::Network_getResponseBody,
            &InspectorBackendDispatcherImpl::Network_replayXHR,
            &InspectorBackendDispatcherImpl::Network_canClearBrowserCache,
            &InspectorBackendDispatcherImpl::Network_clearBrowserCache,
            &InspectorBackendDispatcherImpl::Network_canClearBrowserCookies,
            &InspectorBackendDispatcherImpl::Network_clearBrowserCookies,
            &InspectorBackendDispatcherImpl::Network_setCacheDisabled,
#if ENABLE(SQL_DATABASE)

            &InspectorBackendDispatcherImpl::Database_enable,
            &InspectorBackendDispatcherImpl::Database_disable,
            &InspectorBackendDispatcherImpl::Database_getDatabaseTableNames,
            &InspectorBackendDispatcherImpl::Database_executeSQL,
#endif // ENABLE(SQL_DATABASE)

#if ENABLE(INDEXED_DATABASE)

            &InspectorBackendDispatcherImpl::IndexedDB_enable,
            &InspectorBackendDispatcherImpl::IndexedDB_disable,
            &InspectorBackendDispatcherImpl::IndexedDB_requestDatabaseNamesForFrame,
            &InspectorBackendDispatcherImpl::IndexedDB_requestDatabase,
            &InspectorBackendDispatcherImpl::IndexedDB_requestData,
#endif // ENABLE(INDEXED_DATABASE)

            &InspectorBackendDispatcherImpl::DOMStorage_enable,
            &InspectorBackendDispatcherImpl::DOMStorage_disable,
            &InspectorBackendDispatcherImpl::DOMStorage_getDOMStorageEntries,
            &InspectorBackendDispatcherImpl::DOMStorage_setDOMStorageItem,
            &InspectorBackendDispatcherImpl::DOMStorage_removeDOMStorageItem,
            &InspectorBackendDispatcherImpl::ApplicationCache_getFramesWithManifests,
            &InspectorBackendDispatcherImpl::ApplicationCache_enable,
            &InspectorBackendDispatcherImpl::ApplicationCache_getManifestForFrame,
            &InspectorBackendDispatcherImpl::ApplicationCache_getApplicationCacheForFrame,
#if ENABLE(FILE_SYSTEM)

            &InspectorBackendDispatcherImpl::FileSystem_enable,
            &InspectorBackendDispatcherImpl::FileSystem_disable,
            &InspectorBackendDispatcherImpl::FileSystem_requestFileSystemRoot,
            &InspectorBackendDispatcherImpl::FileSystem_requestDirectoryContent,
            &InspectorBackendDispatcherImpl::FileSystem_requestMetadata,
            &InspectorBackendDispatcherImpl::FileSystem_requestFileContent,
            &InspectorBackendDispatcherImpl::FileSystem_deleteEntry,
#endif // ENABLE(FILE_SYSTEM)

            &InspectorBackendDispatcherImpl::DOM_getDocument,
            &InspectorBackendDispatcherImpl::DOM_requestChildNodes,
            &InspectorBackendDispatcherImpl::DOM_querySelector,
            &InspectorBackendDispatcherImpl::DOM_querySelectorAll,
            &InspectorBackendDispatcherImpl::DOM_setNodeName,
            &InspectorBackendDispatcherImpl::DOM_setNodeValue,
            &InspectorBackendDispatcherImpl::DOM_removeNode,
            &InspectorBackendDispatcherImpl::DOM_setAttributeValue,
            &InspectorBackendDispatcherImpl::DOM_setAttributesAsText,
            &InspectorBackendDispatcherImpl::DOM_removeAttribute,
            &InspectorBackendDispatcherImpl::DOM_getEventListenersForNode,
            &InspectorBackendDispatcherImpl::DOM_getOuterHTML,
            &InspectorBackendDispatcherImpl::DOM_setOuterHTML,
            &InspectorBackendDispatcherImpl::DOM_performSearch,
            &InspectorBackendDispatcherImpl::DOM_getSearchResults,
            &InspectorBackendDispatcherImpl::DOM_discardSearchResults,
            &InspectorBackendDispatcherImpl::DOM_requestNode,
            &InspectorBackendDispatcherImpl::DOM_setInspectModeEnabled,
            &InspectorBackendDispatcherImpl::DOM_highlightRect,
            &InspectorBackendDispatcherImpl::DOM_highlightNode,
            &InspectorBackendDispatcherImpl::DOM_hideHighlight,
            &InspectorBackendDispatcherImpl::DOM_highlightFrame,
            &InspectorBackendDispatcherImpl::DOM_pushNodeByPathToFrontend,
            &InspectorBackendDispatcherImpl::DOM_resolveNode,
            &InspectorBackendDispatcherImpl::DOM_getAttributes,
            &InspectorBackendDispatcherImpl::DOM_moveTo,
            &InspectorBackendDispatcherImpl::DOM_undo,
            &InspectorBackendDispatcherImpl::DOM_redo,
            &InspectorBackendDispatcherImpl::DOM_markUndoableState,
            &InspectorBackendDispatcherImpl::DOM_focus,
            &InspectorBackendDispatcherImpl::DOM_setFileInputFiles,
            &InspectorBackendDispatcherImpl::CSS_enable,
            &InspectorBackendDispatcherImpl::CSS_disable,
            &InspectorBackendDispatcherImpl::CSS_getMatchedStylesForNode,
            &InspectorBackendDispatcherImpl::CSS_getInlineStylesForNode,
            &InspectorBackendDispatcherImpl::CSS_getComputedStyleForNode,
            &InspectorBackendDispatcherImpl::CSS_getAllStyleSheets,
            &InspectorBackendDispatcherImpl::CSS_getStyleSheet,
            &InspectorBackendDispatcherImpl::CSS_getStyleSheetText,
            &InspectorBackendDispatcherImpl::CSS_setStyleSheetText,
            &InspectorBackendDispatcherImpl::CSS_setPropertyText,
            &InspectorBackendDispatcherImpl::CSS_toggleProperty,
            &InspectorBackendDispatcherImpl::CSS_setRuleSelector,
            &InspectorBackendDispatcherImpl::CSS_addRule,
            &InspectorBackendDispatcherImpl::CSS_getSupportedCSSProperties,
            &InspectorBackendDispatcherImpl::CSS_forcePseudoState,
            &InspectorBackendDispatcherImpl::CSS_startSelectorProfiler,
            &InspectorBackendDispatcherImpl::CSS_stopSelectorProfiler,
            &InspectorBackendDispatcherImpl::CSS_getNamedFlowCollection,
            &InspectorBackendDispatcherImpl::Timeline_start,
            &InspectorBackendDispatcherImpl::Timeline_stop,
            &InspectorBackendDispatcherImpl::Timeline_setIncludeDomCounters,
            &InspectorBackendDispatcherImpl::Timeline_setIncludeNativeMemoryStatistics,
            &InspectorBackendDispatcherImpl::Timeline_supportsFrameInstrumentation,
            &InspectorBackendDispatcherImpl::Timeline_canMonitorMainThread,
#if ENABLE(JAVASCRIPT_DEBUGGER)

            &InspectorBackendDispatcherImpl::Debugger_causesRecompilation,
            &InspectorBackendDispatcherImpl::Debugger_supportsSeparateScriptCompilationAndExecution,
            &InspectorBackendDispatcherImpl::Debugger_enable,
            &InspectorBackendDispatcherImpl::Debugger_disable,
            &InspectorBackendDispatcherImpl::Debugger_setBreakpointsActive,
            &InspectorBackendDispatcherImpl::Debugger_setBreakpointByUrl,
            &InspectorBackendDispatcherImpl::Debugger_setBreakpoint,
            &InspectorBackendDispatcherImpl::Debugger_removeBreakpoint,
            &InspectorBackendDispatcherImpl::Debugger_continueToLocation,
            &InspectorBackendDispatcherImpl::Debugger_stepOver,
            &InspectorBackendDispatcherImpl::Debugger_stepInto,
            &InspectorBackendDispatcherImpl::Debugger_stepOut,
            &InspectorBackendDispatcherImpl::Debugger_pause,
            &InspectorBackendDispatcherImpl::Debugger_resume,
            &InspectorBackendDispatcherImpl::Debugger_searchInContent,
            &InspectorBackendDispatcherImpl::Debugger_canSetScriptSource,
            &InspectorBackendDispatcherImpl::Debugger_setScriptSource,
            &InspectorBackendDispatcherImpl::Debugger_restartFrame,
            &InspectorBackendDispatcherImpl::Debugger_getScriptSource,
            &InspectorBackendDispatcherImpl::Debugger_getFunctionDetails,
            &InspectorBackendDispatcherImpl::Debugger_setPauseOnExceptions,
            &InspectorBackendDispatcherImpl::Debugger_evaluateOnCallFrame,
            &InspectorBackendDispatcherImpl::Debugger_compileScript,
            &InspectorBackendDispatcherImpl::Debugger_runScript,
            &InspectorBackendDispatcherImpl::Debugger_setOverlayMessage,
            &InspectorBackendDispatcherImpl::Debugger_setVariableValue,
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

            &InspectorBackendDispatcherImpl::DOMDebugger_setDOMBreakpoint,
            &InspectorBackendDispatcherImpl::DOMDebugger_removeDOMBreakpoint,
            &InspectorBackendDispatcherImpl::DOMDebugger_setEventListenerBreakpoint,
            &InspectorBackendDispatcherImpl::DOMDebugger_removeEventListenerBreakpoint,
            &InspectorBackendDispatcherImpl::DOMDebugger_setInstrumentationBreakpoint,
            &InspectorBackendDispatcherImpl::DOMDebugger_removeInstrumentationBreakpoint,
            &InspectorBackendDispatcherImpl::DOMDebugger_setXHRBreakpoint,
            &InspectorBackendDispatcherImpl::DOMDebugger_removeXHRBreakpoint,
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

            &InspectorBackendDispatcherImpl::Profiler_causesRecompilation,
            &InspectorBackendDispatcherImpl::Profiler_isSampling,
            &InspectorBackendDispatcherImpl::Profiler_hasHeapProfiler,
            &InspectorBackendDispatcherImpl::Profiler_enable,
            &InspectorBackendDispatcherImpl::Profiler_disable,
            &InspectorBackendDispatcherImpl::Profiler_start,
            &InspectorBackendDispatcherImpl::Profiler_stop,
            &InspectorBackendDispatcherImpl::Profiler_getProfileHeaders,
            &InspectorBackendDispatcherImpl::Profiler_getCPUProfile,
            &InspectorBackendDispatcherImpl::Profiler_getHeapSnapshot,
            &InspectorBackendDispatcherImpl::Profiler_removeProfile,
            &InspectorBackendDispatcherImpl::Profiler_clearProfiles,
            &InspectorBackendDispatcherImpl::Profiler_takeHeapSnapshot,
            &InspectorBackendDispatcherImpl::Profiler_collectGarbage,
            &InspectorBackendDispatcherImpl::Profiler_getObjectByHeapObjectId,
            &InspectorBackendDispatcherImpl::Profiler_getHeapObjectId,
#endif // ENABLE(JAVASCRIPT_DEBUGGER)

            &InspectorBackendDispatcherImpl::HeapProfiler_hasHeapProfiler,
            &InspectorBackendDispatcherImpl::HeapProfiler_getProfileHeaders,
            &InspectorBackendDispatcherImpl::HeapProfiler_getHeapSnapshot,
            &InspectorBackendDispatcherImpl::HeapProfiler_removeProfile,
            &InspectorBackendDispatcherImpl::HeapProfiler_clearProfiles,
            &InspectorBackendDispatcherImpl::HeapProfiler_takeHeapSnapshot,
            &InspectorBackendDispatcherImpl::HeapProfiler_collectGarbage,
            &InspectorBackendDispatcherImpl::HeapProfiler_getObjectByHeapObjectId,
            &InspectorBackendDispatcherImpl::HeapProfiler_getHeapObjectId,
#if ENABLE(WORKERS)

            &InspectorBackendDispatcherImpl::Worker_enable,
            &InspectorBackendDispatcherImpl::Worker_disable,
            &InspectorBackendDispatcherImpl::Worker_sendMessageToWorker,
            &InspectorBackendDispatcherImpl::Worker_connectToWorker,
            &InspectorBackendDispatcherImpl::Worker_disconnectFromWorker,
            &InspectorBackendDispatcherImpl::Worker_setAutoconnectToWorkers,
#endif // ENABLE(WORKERS)

            &InspectorBackendDispatcherImpl::Canvas_enable,
            &InspectorBackendDispatcherImpl::Canvas_disable,
            &InspectorBackendDispatcherImpl::Canvas_dropTraceLog,
            &InspectorBackendDispatcherImpl::Canvas_hasUninstrumentedCanvases,
            &InspectorBackendDispatcherImpl::Canvas_captureFrame,
            &InspectorBackendDispatcherImpl::Canvas_startCapturing,
            &InspectorBackendDispatcherImpl::Canvas_stopCapturing,
            &InspectorBackendDispatcherImpl::Canvas_getTraceLog,
            &InspectorBackendDispatcherImpl::Canvas_replayTraceLog,
            &InspectorBackendDispatcherImpl::Canvas_getResourceInfo,
            &InspectorBackendDispatcherImpl::Canvas_getResourceState,
            &InspectorBackendDispatcherImpl::Input_dispatchKeyEvent,
            &InspectorBackendDispatcherImpl::Input_dispatchMouseEvent,
            &InspectorBackendDispatcherImpl::LayerTree_enable,
            &InspectorBackendDispatcherImpl::LayerTree_disable,
            &InspectorBackendDispatcherImpl::LayerTree_getLayerTree,
            &InspectorBackendDispatcherImpl::LayerTree_nodeIdForLayerId,
        };
        size_t length = WTF_ARRAY_LENGTH(commandNames);
        for (size_t i = 0; i < length; ++i)
            dispatchMap.add(commandNames[i], handlers[i]);
    }

    RefPtr<InspectorValue> parsedMessage = InspectorValue::parseJSON(message);
    if (!parsedMessage) {
        reportProtocolError(0, ParseError, "Message must be in JSON format");
        return;
    }

    RefPtr<InspectorObject> messageObject = parsedMessage->asObject();
    if (!messageObject) {
        reportProtocolError(0, InvalidRequest, "Message must be a JSONified object");
        return;
    }

    RefPtr<InspectorValue> callIdValue = messageObject->get("id");
    if (!callIdValue) {
        reportProtocolError(0, InvalidRequest, "'id' property was not found");
        return;
    }

    if (!callIdValue->asNumber(&callId)) {
        reportProtocolError(0, InvalidRequest, "The type of 'id' property must be number");
        return;
    }

    RefPtr<InspectorValue> methodValue = messageObject->get("method");
    if (!methodValue) {
        reportProtocolError(&callId, InvalidRequest, "'method' property wasn't found");
        return;
    }

    String method;
    if (!methodValue->asString(&method)) {
        reportProtocolError(&callId, InvalidRequest, "The type of 'method' property must be string");
        return;
    }

    HashMap<String, CallHandler>::iterator it = dispatchMap.find(method);
    if (it == dispatchMap.end()) {
        reportProtocolError(&callId, MethodNotFound, "'" + method + "' wasn't found");
        return;
    }

    ((*this).*it->value)(callId, messageObject.get());
}

void InspectorBackendDispatcherImpl::sendResponse(long callId, PassRefPtr<InspectorObject> result, const char* commandName, PassRefPtr<InspectorArray> protocolErrors, ErrorString invocationError)
{
    if (protocolErrors->length()) {
        String errorMessage = String::format("Some arguments of method '%s' can't be processed", commandName);
        reportProtocolError(&callId, InvalidParams, errorMessage, protocolErrors);
        return;
    }
    sendResponse(callId, result, invocationError);
}

void InspectorBackendDispatcherImpl::sendResponse(long callId, PassRefPtr<InspectorObject> result, const ErrorString& invocationError)
{
    if (invocationError.length()) {
        reportProtocolError(&callId, ServerError, invocationError);
        return;
    }

    RefPtr<InspectorObject> responseMessage = InspectorObject::create();
    responseMessage->setObject("result", result);
    responseMessage->setNumber("id", callId);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(responseMessage->toJSONString());
}

void InspectorBackendDispatcher::reportProtocolError(const long* const callId, CommonErrorCode code, const String& errorMessage) const
{
    reportProtocolError(callId, code, errorMessage, 0);
}

void InspectorBackendDispatcherImpl::reportProtocolError(const long* const callId, CommonErrorCode code, const String& errorMessage, PassRefPtr<InspectorArray> data) const
{
    DEFINE_STATIC_LOCAL(Vector<int>,s_commonErrors,);
    if (!s_commonErrors.size()) {
        s_commonErrors.insert(ParseError, -32700);
        s_commonErrors.insert(InvalidRequest, -32600);
        s_commonErrors.insert(MethodNotFound, -32601);
        s_commonErrors.insert(InvalidParams, -32602);
        s_commonErrors.insert(InternalError, -32603);
        s_commonErrors.insert(ServerError, -32000);
    }
    ASSERT(code >=0);
    ASSERT((unsigned)code < s_commonErrors.size());
    ASSERT(s_commonErrors[code]);
    RefPtr<InspectorObject> error = InspectorObject::create();
    error->setNumber("code", s_commonErrors[code]);
    error->setString("message", errorMessage);
    ASSERT(error);
    if (data)
        error->setArray("data", data);
    RefPtr<InspectorObject> message = InspectorObject::create();
    message->setObject("error", error);
    if (callId)
        message->setNumber("id", *callId);
    else
        message->setValue("id", InspectorValue::null());
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(message->toJSONString());
}

template<typename R, typename V, typename V0>
R InspectorBackendDispatcherImpl::getPropertyValueImpl(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors, V0 initial_value, bool (*as_method)(InspectorValue*, V*), const char* type_name)
{
    ASSERT(protocolErrors);

    if (valueFound)
        *valueFound = false;

    V value = initial_value;

    if (!object) {
        if (!valueFound) {
            // Required parameter in missing params container.
            protocolErrors->pushString(String::format("'params' object must contain required parameter '%s' with type '%s'.", name.utf8().data(), type_name));
        }
        return value;
    }

    InspectorObject::const_iterator end = object->end();
    InspectorObject::const_iterator valueIterator = object->find(name);

    if (valueIterator == end) {
        if (!valueFound)
            protocolErrors->pushString(String::format("Parameter '%s' with type '%s' was not found.", name.utf8().data(), type_name));
        return value;
    }

    if (!as_method(valueIterator->value.get(), &value))
        protocolErrors->pushString(String::format("Parameter '%s' has wrong type. It must be '%s'.", name.utf8().data(), type_name));
    else
        if (valueFound)
            *valueFound = true;
    return value;
}

struct AsMethodBridges {
    static bool asInt(InspectorValue* value, int* output) { return value->asNumber(output); }
    static bool asDouble(InspectorValue* value, double* output) { return value->asNumber(output); }
    static bool asString(InspectorValue* value, String* output) { return value->asString(output); }
    static bool asBoolean(InspectorValue* value, bool* output) { return value->asBoolean(output); }
    static bool asObject(InspectorValue* value, RefPtr<InspectorObject>* output) { return value->asObject(output); }
    static bool asArray(InspectorValue* value, RefPtr<InspectorArray>* output) { return value->asArray(output); }
};

int InspectorBackendDispatcherImpl::getInt(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors)
{
    return getPropertyValueImpl<int, int, int>(object, name, valueFound, protocolErrors, 0, AsMethodBridges::asInt, "Number");
}

double InspectorBackendDispatcherImpl::getDouble(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors)
{
    return getPropertyValueImpl<double, double, double>(object, name, valueFound, protocolErrors, 0, AsMethodBridges::asDouble, "Number");
}

String InspectorBackendDispatcherImpl::getString(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors)
{
    return getPropertyValueImpl<String, String, String>(object, name, valueFound, protocolErrors, "", AsMethodBridges::asString, "String");
}

bool InspectorBackendDispatcherImpl::getBoolean(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors)
{
    return getPropertyValueImpl<bool, bool, bool>(object, name, valueFound, protocolErrors, false, AsMethodBridges::asBoolean, "Boolean");
}

PassRefPtr<InspectorObject> InspectorBackendDispatcherImpl::getObject(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors)
{
    return getPropertyValueImpl<PassRefPtr<InspectorObject>, RefPtr<InspectorObject>, InspectorObject*>(object, name, valueFound, protocolErrors, 0, AsMethodBridges::asObject, "Object");
}

PassRefPtr<InspectorArray> InspectorBackendDispatcherImpl::getArray(InspectorObject* object, const String& name, bool* valueFound, InspectorArray* protocolErrors)
{
    return getPropertyValueImpl<PassRefPtr<InspectorArray>, RefPtr<InspectorArray>, InspectorArray*>(object, name, valueFound, protocolErrors, 0, AsMethodBridges::asArray, "Array");
}

bool InspectorBackendDispatcher::getCommandName(const String& message, String* result)
{
    RefPtr<InspectorValue> value = InspectorValue::parseJSON(message);
    if (!value)
        return false;

    RefPtr<InspectorObject> object = value->asObject();
    if (!object)
        return false;

    if (!object->getString("method", result))
        return false;

    return true;
}

InspectorBackendDispatcher::CallbackBase::CallbackBase(PassRefPtr<InspectorBackendDispatcherImpl> backendImpl, int id)
    : m_backendImpl(backendImpl), m_id(id), m_alreadySent(false) {}

InspectorBackendDispatcher::CallbackBase::~CallbackBase() {}

void InspectorBackendDispatcher::CallbackBase::sendFailure(const ErrorString& error)
{
    ASSERT(error.length());
    sendIfActive(0, error);
}

bool InspectorBackendDispatcher::CallbackBase::isActive()
{
    return !m_alreadySent && m_backendImpl->isActive();
}

void InspectorBackendDispatcher::CallbackBase::sendIfActive(PassRefPtr<InspectorObject> partialMessage, const ErrorString& invocationError)
{
    if (m_alreadySent)
        return;
    m_backendImpl->sendResponse(m_id, partialMessage, invocationError);
    m_alreadySent = true;
}

COMPILE_ASSERT(static_cast<int>(InspectorBackendDispatcher::kMethodNamesEnumSize) == WTF_ARRAY_LENGTH(InspectorBackendDispatcher::commandNames), command_name_array_problem);

} // namespace WebCore

#endif // ENABLE(INSPECTOR)
