/*
 * File: cursor_convert.h
 * Purpose: interface for X->Windows cursor conversion
 *
 * Copyright (c) Jon TURNEY 2012
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE ABOVE LISTED COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef WMUTILS_CURSOR_H
#define WMUTILS_CURSOR_H

#include <stdbool.h>
#include <stdint.h>

typedef struct _WMUTIL_CURSOR
{
  // this is the data for cursor created with RENDER CreateCusor or read
  // with XFIXES GetCursorImage
  int width;
  int height;
  int xhot;
  int yhot;
  uint32_t *argb;

  // for a core CreateCursor, we might need the following...
  unsigned char *source;
  unsigned char *mask;
  bool emptyMask;
  unsigned short foreRed, foreGreen, foreBlue;
  unsigned short backRed, backGreen, backBlue;

} WMUTIL_CURSOR;

HCURSOR
winXCursorToHCURSOR(WMUTIL_CURSOR *cursordata);

#endif /* WMUTILS_CURSOR_H */
