/* index.c generated by valac 0.26.1, the Vala compiler
 * generated from index.vala, do not modify */

/*
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * Based upon a C implementation (© 2010-2012 Canonical Ltd) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *  Michal Hruby <michal.hruby@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "zeitgeist-datamodel.h"


#define ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER (zeitgeist_queued_proxy_wrapper_get_type ())
#define ZEITGEIST_QUEUED_PROXY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER, ZeitgeistQueuedProxyWrapper))
#define ZEITGEIST_QUEUED_PROXY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER, ZeitgeistQueuedProxyWrapperClass))
#define ZEITGEIST_IS_QUEUED_PROXY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER))
#define ZEITGEIST_IS_QUEUED_PROXY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER))
#define ZEITGEIST_QUEUED_PROXY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER, ZeitgeistQueuedProxyWrapperClass))

typedef struct _ZeitgeistQueuedProxyWrapper ZeitgeistQueuedProxyWrapper;
typedef struct _ZeitgeistQueuedProxyWrapperClass ZeitgeistQueuedProxyWrapperClass;
typedef struct _ZeitgeistQueuedProxyWrapperPrivate ZeitgeistQueuedProxyWrapperPrivate;

#define ZEITGEIST_TYPE_INDEX (zeitgeist_index_get_type ())
#define ZEITGEIST_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_INDEX, ZeitgeistIndex))
#define ZEITGEIST_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_INDEX, ZeitgeistIndexClass))
#define ZEITGEIST_IS_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_INDEX))
#define ZEITGEIST_IS_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_INDEX))
#define ZEITGEIST_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_INDEX, ZeitgeistIndexClass))

typedef struct _ZeitgeistIndex ZeitgeistIndex;
typedef struct _ZeitgeistIndexClass ZeitgeistIndexClass;
typedef struct _ZeitgeistIndexPrivate ZeitgeistIndexPrivate;

#define ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER (zeitgeist_remote_simple_indexer_get_type ())
#define ZEITGEIST_REMOTE_SIMPLE_INDEXER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER, ZeitgeistRemoteSimpleIndexer))
#define ZEITGEIST_IS_REMOTE_SIMPLE_INDEXER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER))
#define ZEITGEIST_REMOTE_SIMPLE_INDEXER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER, ZeitgeistRemoteSimpleIndexerIface))

typedef struct _ZeitgeistRemoteSimpleIndexer ZeitgeistRemoteSimpleIndexer;
typedef struct _ZeitgeistRemoteSimpleIndexerIface ZeitgeistRemoteSimpleIndexerIface;

#define ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER_PROXY (zeitgeist_remote_simple_indexer_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ZeitgeistIndexSearchData ZeitgeistIndexSearchData;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _ZeitgeistIndexSearchWithRelevanciesData ZeitgeistIndexSearchWithRelevanciesData;

struct _ZeitgeistQueuedProxyWrapper {
	GObject parent_instance;
	ZeitgeistQueuedProxyWrapperPrivate * priv;
};

struct _ZeitgeistQueuedProxyWrapperClass {
	GObjectClass parent_class;
	void (*on_connection_established) (ZeitgeistQueuedProxyWrapper* self);
	void (*on_connection_lost) (ZeitgeistQueuedProxyWrapper* self);
};

struct _ZeitgeistIndex {
	ZeitgeistQueuedProxyWrapper parent_instance;
	ZeitgeistIndexPrivate * priv;
};

struct _ZeitgeistIndexClass {
	ZeitgeistQueuedProxyWrapperClass parent_class;
};

struct _ZeitgeistRemoteSimpleIndexerIface {
	GTypeInterface parent_iface;
	void (*search) (ZeitgeistRemoteSimpleIndexer* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_finish) (ZeitgeistRemoteSimpleIndexer* self, GAsyncResult* _res_, GVariant** events, guint* matches, GError** error);
	void (*search_with_relevancies) (ZeitgeistRemoteSimpleIndexer* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_with_relevancies_finish) (ZeitgeistRemoteSimpleIndexer* self, GAsyncResult* _res_, GVariant** events, gdouble** relevancies, int* relevancies_length1, guint* matches, GError** error);
};

struct _ZeitgeistIndexPrivate {
	ZeitgeistRemoteSimpleIndexer* proxy;
};

struct _ZeitgeistIndexSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistIndex* self;
	gchar* query;
	ZeitgeistTimeRange* time_range;
	GPtrArray* event_templates;
	guint32 offset;
	guint32 num_events;
	ZeitgeistResultType result_type;
	GCancellable* cancellable;
	ZeitgeistResultSet* result;
	GPtrArray* event_templates_cp;
	GPtrArray* _tmp0_;
	gint i;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GPtrArray* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GPtrArray* _tmp7_;
	GPtrArray* _tmp8_;
	gint _tmp9_;
	gconstpointer _tmp10_;
	ZeitgeistEvent* _tmp11_;
	GVariant* _result_;
	guint matches;
	ZeitgeistRemoteSimpleIndexer* _tmp12_;
	const gchar* _tmp13_;
	ZeitgeistTimeRange* _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	GPtrArray* _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	guint32 _tmp20_;
	guint32 _tmp21_;
	ZeitgeistResultType _tmp22_;
	GCancellable* _tmp23_;
	GVariant* _tmp24_;
	guint _tmp25_;
	GPtrArray* _tmp26_;
	GVariant* _tmp27_;
	GPtrArray* _tmp28_;
	guint _tmp29_;
	ZeitgeistSimpleResultSet* _tmp30_;
	GError * _inner_error_;
};

struct _ZeitgeistIndexSearchWithRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistIndex* self;
	gchar* query;
	ZeitgeistTimeRange* time_range;
	GPtrArray* event_templates;
	ZeitgeistStorageState storage_state;
	guint32 offset;
	guint32 num_events;
	ZeitgeistResultType result_type;
	GCancellable* cancellable;
	gdouble* relevancies;
	gint relevancies_length1;
	ZeitgeistResultSet* result;
	GPtrArray* event_templates_cp;
	GPtrArray* _tmp0_;
	gint i;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GPtrArray* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GPtrArray* _tmp7_;
	GPtrArray* _tmp8_;
	gint _tmp9_;
	gconstpointer _tmp10_;
	ZeitgeistEvent* _tmp11_;
	GVariant* _result_;
	GVariant* relevancies_variant;
	guint matches;
	ZeitgeistRemoteSimpleIndexer* _tmp12_;
	const gchar* _tmp13_;
	ZeitgeistTimeRange* _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	GPtrArray* _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	ZeitgeistStorageState _tmp20_;
	guint32 _tmp21_;
	guint32 _tmp22_;
	ZeitgeistResultType _tmp23_;
	GCancellable* _tmp24_;
	GVariant* _tmp25_;
	gdouble* _tmp26_;
	gint _tmp27_;
	guint _tmp28_;
	gdouble* _tmp29_;
	gint _tmp29__length1;
	GVariant* _tmp33_;
	GVariant* _tmp34_;
	gsize _tmp35_;
	gdouble* _tmp36_;
	GVariantIter* iter;
	GVariant* _tmp37_;
	GVariantIter* _tmp38_;
	gint _vala1_i;
	gboolean _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	GVariantIter* _tmp42_;
	gsize _tmp43_;
	gdouble relevancy;
	GVariantIter* _tmp44_;
	gdouble* _tmp45_;
	gint _tmp45__length1;
	gint _tmp46_;
	gdouble _tmp47_;
	gdouble _tmp48_;
	GPtrArray* _tmp49_;
	GVariant* _tmp50_;
	GPtrArray* _tmp51_;
	guint _tmp52_;
	ZeitgeistSimpleResultSet* _tmp53_;
	GError * _inner_error_;
};


static gpointer zeitgeist_index_parent_class = NULL;

GType zeitgeist_queued_proxy_wrapper_get_type (void) G_GNUC_CONST;
GType zeitgeist_index_get_type (void) G_GNUC_CONST;
GType zeitgeist_remote_simple_indexer_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_simple_indexer_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_simple_indexer_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_INDEX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_INDEX, ZeitgeistIndexPrivate))
enum  {
	ZEITGEIST_INDEX_DUMMY_PROPERTY
};
ZeitgeistIndex* zeitgeist_index_new (void);
ZeitgeistIndex* zeitgeist_index_construct (GType object_type);
ZeitgeistQueuedProxyWrapper* zeitgeist_queued_proxy_wrapper_construct (GType object_type);
static void __lambda8_ (ZeitgeistIndex* self, GObject* obj, GAsyncResult* res);
void zeitgeist_queued_proxy_wrapper_proxy_acquired (ZeitgeistQueuedProxyWrapper* self, GObject* proxy);
void zeitgeist_queued_proxy_wrapper_proxy_unavailable (ZeitgeistQueuedProxyWrapper* self, GError* err);
static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void zeitgeist_index_real_on_connection_established (ZeitgeistQueuedProxyWrapper* base);
static void zeitgeist_index_real_on_connection_lost (ZeitgeistQueuedProxyWrapper* base);
static void zeitgeist_index_search_data_free (gpointer _data);
void zeitgeist_index_search (ZeitgeistIndex* self, const gchar* query, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint32 offset, guint32 num_events, ZeitgeistResultType result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
ZeitgeistResultSet* zeitgeist_index_search_finish (ZeitgeistIndex* self, GAsyncResult* _res_, GError** error);
static gboolean zeitgeist_index_search_co (ZeitgeistIndexSearchData* _data_);
static void _g_object_unref0_ (gpointer var);
void zeitgeist_queued_proxy_wrapper_wait_for_proxy (ZeitgeistQueuedProxyWrapper* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish (ZeitgeistQueuedProxyWrapper* self, GAsyncResult* _res_, GError** error);
static void zeitgeist_index_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void zeitgeist_remote_simple_indexer_search (ZeitgeistRemoteSimpleIndexer* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_simple_indexer_search_finish (ZeitgeistRemoteSimpleIndexer* self, GAsyncResult* _res_, GVariant** events, guint* matches, GError** error);
static void zeitgeist_index_search_with_relevancies_data_free (gpointer _data);
void zeitgeist_index_search_with_relevancies (ZeitgeistIndex* self, const gchar* query, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, ZeitgeistStorageState storage_state, guint32 offset, guint32 num_events, ZeitgeistResultType result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
ZeitgeistResultSet* zeitgeist_index_search_with_relevancies_finish (ZeitgeistIndex* self, GAsyncResult* _res_, gdouble** relevancies, int* relevancies_length1, GError** error);
static gboolean zeitgeist_index_search_with_relevancies_co (ZeitgeistIndexSearchWithRelevanciesData* _data_);
static void zeitgeist_index_search_with_relevancies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void zeitgeist_remote_simple_indexer_search_with_relevancies (ZeitgeistRemoteSimpleIndexer* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_simple_indexer_search_with_relevancies_finish (ZeitgeistRemoteSimpleIndexer* self, GAsyncResult* _res_, GVariant** events, gdouble** relevancies, int* relevancies_length1, guint* matches, GError** error);
static GVariant* _variant_new1 (gdouble* value, gint value_length1);
static void zeitgeist_index_finalize (GObject* obj);


/**
     * Create a new index that interfaces with the default event index of the
     * Zeitgeist daemon.
     *
     * Create a new {@link Index} instance. The index will start to connect
     * to Zeitgeist asynchronously. You can however start calling methods on
     * the returned instance immediately, any method calls issued before the
     * connection has been established will simply be queued and executed once
     * the connection is up.
     *
     * Returns: A reference to a newly allocated index. Free with g_object_unref().
     */
static void __lambda8_ (ZeitgeistIndex* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ZeitgeistRemoteSimpleIndexer* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		ZeitgeistRemoteSimpleIndexer* _tmp2_ = NULL;
		ZeitgeistRemoteSimpleIndexer* _tmp3_ = NULL;
		ZeitgeistRemoteSimpleIndexer* _tmp4_ = NULL;
		ZeitgeistRemoteSimpleIndexer* _tmp5_ = NULL;
		_tmp1_ = res;
		_tmp2_ = g_async_result_get_source_object (_tmp1_);
		_tmp3_ = g_async_initable_new_finish (_tmp2_, _tmp1_, &_inner_error_);
		g_object_unref (_tmp2_);
		_tmp0_ = (ZeitgeistRemoteSimpleIndexer*) _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->proxy);
		self->priv->proxy = _tmp4_;
		_tmp5_ = self->priv->proxy;
		zeitgeist_queued_proxy_wrapper_proxy_acquired ((ZeitgeistQueuedProxyWrapper*) self, (GObject*) _tmp5_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_critical ("index.vala:61: Unable to connect to Zeitgeist FTS: %s", _tmp7_);
		_tmp8_ = err;
		zeitgeist_queued_proxy_wrapper_proxy_unavailable ((ZeitgeistQueuedProxyWrapper*) self, _tmp8_);
		_g_error_free0 (err);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda8_ ((ZeitgeistIndex*) self, source_object, res);
	g_object_unref (self);
}


ZeitgeistIndex* zeitgeist_index_construct (GType object_type) {
	ZeitgeistIndex * self = NULL;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistIndex*) zeitgeist_queued_proxy_wrapper_construct (object_type);
	g_async_initable_new_async (ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER_PROXY, 0, NULL, ___lambda8__gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", ZEITGEIST_UTILS_ENGINE_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/zeitgeist/index/activity", "g-interface-name", "org.gnome.zeitgeist.Index", "g-interface-info", g_type_get_qdata (ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	return self;
}


ZeitgeistIndex* zeitgeist_index_new (void) {
	return zeitgeist_index_construct (ZEITGEIST_TYPE_INDEX);
}


static void zeitgeist_index_real_on_connection_established (ZeitgeistQueuedProxyWrapper* base) {
	ZeitgeistIndex * self;
	self = (ZeitgeistIndex*) base;
}


static void zeitgeist_index_real_on_connection_lost (ZeitgeistQueuedProxyWrapper* base) {
	ZeitgeistIndex * self;
	self = (ZeitgeistIndex*) base;
}


static void zeitgeist_index_search_data_free (gpointer _data) {
	ZeitgeistIndexSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query);
	_g_object_unref0 (_data_->time_range);
	_g_ptr_array_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistIndexSearchData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


void zeitgeist_index_search (ZeitgeistIndex* self, const gchar* query, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint32 offset, guint32 num_events, ZeitgeistResultType result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistIndexSearchData* _data_;
	ZeitgeistIndex* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	ZeitgeistTimeRange* _tmp3_ = NULL;
	ZeitgeistTimeRange* _tmp4_ = NULL;
	GPtrArray* _tmp5_ = NULL;
	GPtrArray* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	guint32 _tmp8_ = 0U;
	ZeitgeistResultType _tmp9_ = 0;
	GCancellable* _tmp10_ = NULL;
	GCancellable* _tmp11_ = NULL;
	_data_ = g_slice_new0 (ZeitgeistIndexSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_index_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_index_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = query;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->query);
	_data_->query = _tmp2_;
	_tmp3_ = time_range;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->time_range);
	_data_->time_range = _tmp4_;
	_tmp5_ = event_templates;
	_tmp6_ = _g_ptr_array_ref0 (_tmp5_);
	_g_ptr_array_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp6_;
	_tmp7_ = offset;
	_data_->offset = _tmp7_;
	_tmp8_ = num_events;
	_data_->num_events = _tmp8_;
	_tmp9_ = result_type;
	_data_->result_type = _tmp9_;
	_tmp10_ = cancellable;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp11_;
	zeitgeist_index_search_co (_data_);
}


ZeitgeistResultSet* zeitgeist_index_search_finish (ZeitgeistIndex* self, GAsyncResult* _res_, GError** error) {
	ZeitgeistResultSet* result;
	ZeitgeistIndexSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Perform a full text search possibly restricted to a {@link TimeRange}
     * and/or set of event templates.
     *
     * The default boolean operator is %AND. Thus the query
     * //foo bar// will be interpreted as //foo AND bar//. To exclude a term
     * from the result set prepend it with a minus sign - eg. //foo -bar//.
     * Phrase queries can be done by double quoting the string
     * //"foo is a bar"//. You can truncate terms by appending a *.
     *
     * There are a few keys you can prefix to a term or phrase to search within
     * a specific set of metadata. They are used like //key:value//. The keys
     * //name// and //title// search strictly within the text field of the
     * event subjects. The key //app// searches within the application name or
     * description that is found in the actor attribute of the events. Lastly,
     * you can use the //site// key to search within the domain name of subject
     * URIs.
     *
     * You can also control the results with the boolean operators //AND// and
     * //OR// and you may use brackets, ( and ), to control the operator
     * precedence.
     *
     * FIXME: how do we put documentation into _finish?
     * The total hit count of the query will be available via the returned
     * result set by calling zeitgeist_result_set_estimated_matches(). This will
     * often be bigger than the actual number of events held in the result set,
     * which is limited by the @num_events parameter passed to
     * zeitgeist_index_search().
     *
     * @param query The search string to send to Zeitgeist
     * @param time_range Restrict matched events to ones within this time
     *     range. If you are not interested in restricting the timerange pass
     *     zeitgeist_time_range_new_anytime() as Zeitgeist will detect
     *     this and optimize the query accordingly
     * @param event_templates Restrict matches events to ones matching these
     *     templates
     * @param offset Offset into the result set to read events from
     * @param num_events Maximal number of events to retrieve
     * @param result_type The {@link ResultType} determining the sort order.
     *     You may pass {@link ResultType.RELEVANCY} to this
     *     method to have the results ordered by relevancy calculated
     *     in relation to @query
     * @param cancellable A {@link GLib.Cancellable} used to cancel the
     *     call or %NULL
     */
static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void zeitgeist_index_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistIndexSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_index_search_co (_data_);
}


static gboolean zeitgeist_index_search_co (ZeitgeistIndexSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->event_templates_cp = _data_->_tmp0_;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = 0;
					_data_->_tmp2_ = _data_->i;
					_data_->i = _data_->_tmp2_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				_data_->_tmp3_ = 0;
				_data_->_tmp3_ = _data_->i;
				_data_->_tmp4_ = NULL;
				_data_->_tmp4_ = _data_->event_templates;
				_data_->_tmp5_ = 0;
				_data_->_tmp5_ = g_ptr_array_get_length (_data_->_tmp4_);
				_data_->_tmp6_ = 0;
				_data_->_tmp6_ = _data_->_tmp5_;
				if (!(_data_->_tmp3_ < _data_->_tmp6_)) {
					break;
				}
				_data_->_tmp7_ = NULL;
				_data_->_tmp7_ = _data_->event_templates_cp;
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = _data_->event_templates;
				_data_->_tmp9_ = 0;
				_data_->_tmp9_ = _data_->i;
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = g_ptr_array_index (_data_->_tmp8_, (guint) _data_->_tmp9_);
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp10_);
				g_ptr_array_add (_data_->_tmp7_, _data_->_tmp11_);
			}
		}
	}
	_data_->_state_ = 1;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_index_search_ready, _data_);
	return FALSE;
	_state_1:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->event_templates_cp);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->self->priv->proxy;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->query;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->time_range;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = zeitgeist_time_range_to_variant (_data_->_tmp14_);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->event_templates_cp;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = zeitgeist_events_to_variant (_data_->_tmp17_);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp20_ = 0U;
	_data_->_tmp20_ = _data_->offset;
	_data_->_tmp21_ = 0U;
	_data_->_tmp21_ = _data_->num_events;
	_data_->_tmp22_ = 0;
	_data_->_tmp22_ = _data_->result_type;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->cancellable;
	_data_->_tmp24_ = NULL;
	_data_->_tmp25_ = 0U;
	_data_->_state_ = 2;
	zeitgeist_remote_simple_indexer_search (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp16_, _data_->_tmp19_, (guint) _data_->_tmp20_, (guint) _data_->_tmp21_, (guint) _data_->_tmp22_, _data_->_tmp23_, zeitgeist_index_search_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_remote_simple_indexer_search_finish (_data_->_tmp12_, _data_->_res_, &_data_->_tmp24_, &_data_->_tmp25_, &_data_->_inner_error_);
	_g_variant_unref0 (_data_->_result_);
	_data_->_result_ = _data_->_tmp24_;
	_data_->matches = _data_->_tmp25_;
	_g_variant_unref0 (_data_->_tmp19_);
	_g_variant_unref0 (_data_->_tmp16_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_variant_unref0 (_data_->_result_);
		_g_ptr_array_unref0 (_data_->event_templates_cp);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->_result_;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = zeitgeist_events_from_variant (_data_->_tmp27_, &_data_->_inner_error_);
	_data_->_tmp26_ = _data_->_tmp28_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_variant_unref0 (_data_->_result_);
		_g_ptr_array_unref0 (_data_->event_templates_cp);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp29_ = 0U;
	_data_->_tmp29_ = _data_->matches;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = zeitgeist_simple_result_set_new_with_num_matches (_data_->_tmp26_, _data_->_tmp29_);
	_data_->result = (ZeitgeistResultSet*) _data_->_tmp30_;
	_g_ptr_array_unref0 (_data_->_tmp26_);
	_g_variant_unref0 (_data_->_result_);
	_g_ptr_array_unref0 (_data_->event_templates_cp);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_ptr_array_unref0 (_data_->_tmp26_);
	_g_variant_unref0 (_data_->_result_);
	_g_ptr_array_unref0 (_data_->event_templates_cp);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_index_search_with_relevancies_data_free (gpointer _data) {
	ZeitgeistIndexSearchWithRelevanciesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query);
	_g_object_unref0 (_data_->time_range);
	_g_ptr_array_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistIndexSearchWithRelevanciesData, _data_);
}


void zeitgeist_index_search_with_relevancies (ZeitgeistIndex* self, const gchar* query, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, ZeitgeistStorageState storage_state, guint32 offset, guint32 num_events, ZeitgeistResultType result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistIndexSearchWithRelevanciesData* _data_;
	ZeitgeistIndex* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	ZeitgeistTimeRange* _tmp3_ = NULL;
	ZeitgeistTimeRange* _tmp4_ = NULL;
	GPtrArray* _tmp5_ = NULL;
	GPtrArray* _tmp6_ = NULL;
	ZeitgeistStorageState _tmp7_ = 0;
	guint32 _tmp8_ = 0U;
	guint32 _tmp9_ = 0U;
	ZeitgeistResultType _tmp10_ = 0;
	GCancellable* _tmp11_ = NULL;
	GCancellable* _tmp12_ = NULL;
	_data_ = g_slice_new0 (ZeitgeistIndexSearchWithRelevanciesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_index_search_with_relevancies);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_index_search_with_relevancies_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = query;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->query);
	_data_->query = _tmp2_;
	_tmp3_ = time_range;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->time_range);
	_data_->time_range = _tmp4_;
	_tmp5_ = event_templates;
	_tmp6_ = _g_ptr_array_ref0 (_tmp5_);
	_g_ptr_array_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp6_;
	_tmp7_ = storage_state;
	_data_->storage_state = _tmp7_;
	_tmp8_ = offset;
	_data_->offset = _tmp8_;
	_tmp9_ = num_events;
	_data_->num_events = _tmp9_;
	_tmp10_ = result_type;
	_data_->result_type = _tmp10_;
	_tmp11_ = cancellable;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp12_;
	zeitgeist_index_search_with_relevancies_co (_data_);
}


ZeitgeistResultSet* zeitgeist_index_search_with_relevancies_finish (ZeitgeistIndex* self, GAsyncResult* _res_, gdouble** relevancies, int* relevancies_length1, GError** error) {
	ZeitgeistResultSet* result;
	ZeitgeistIndexSearchWithRelevanciesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (relevancies) {
		*relevancies = _data_->relevancies;
	} else {
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
	}
	if (relevancies_length1) {
		*relevancies_length1 = _data_->relevancies_length1;
	}
	_data_->relevancies = NULL;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Perform a full text search possibly restricted to a {@link TimeRange}
     * and/or set of event templates. As opposed to zeitgeist_index_search(),
     * this call will also return numeric relevancies of the events
     * in the {@link ResultSet}.
     *
     * See zeitgeist_index_search() for more details on how to create the
     * query.
     *
     * @param query The search string to send to Zeitgeist
     * @param time_range Restrict matched events to ones within this time
     *     range. If you are not interested in restricting the timerange pass
     *     zeitgeist_time_range_new_anytime() as Zeitgeist will detect
     *     this and optimize the query accordingly
     * @param event_templates Restrict matched events to ones matching these
     *     templates
     * @param storage_state Filter the events by availability of the storage
     *     medium.
     * @param offset Offset into the result set to read events from
     * @param num_events Maximal number of events to retrieve
     * @param result_type The {@link ResultType} determining the sort order
     *     You may pass {@link ResultType.RELEVANCY} to this method to
     *     have the results ordered by relevancy calculated in relation
     *     to "query"
     * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
     *
     * @param relevancies numeric relevancies of the events returned by result_set
     * @return {@link ResultSet} result_set.
     */
static void zeitgeist_index_search_with_relevancies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistIndexSearchWithRelevanciesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_index_search_with_relevancies_co (_data_);
}


static GVariant* _variant_new1 (gdouble* value, gint value_length1) {
	gdouble* _tmp30_;
	GVariantBuilder _tmp31_;
	int _tmp32_;
	_tmp30_ = value;
	g_variant_builder_init (&_tmp31_, G_VARIANT_TYPE ("ad"));
	for (_tmp32_ = 0; _tmp32_ < value_length1; _tmp32_++) {
		g_variant_builder_add_value (&_tmp31_, g_variant_new_double (*_tmp30_));
		_tmp30_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp31_));
}


static gboolean zeitgeist_index_search_with_relevancies_co (ZeitgeistIndexSearchWithRelevanciesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->event_templates_cp = _data_->_tmp0_;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = 0;
					_data_->_tmp2_ = _data_->i;
					_data_->i = _data_->_tmp2_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				_data_->_tmp3_ = 0;
				_data_->_tmp3_ = _data_->i;
				_data_->_tmp4_ = NULL;
				_data_->_tmp4_ = _data_->event_templates;
				_data_->_tmp5_ = 0;
				_data_->_tmp5_ = g_ptr_array_get_length (_data_->_tmp4_);
				_data_->_tmp6_ = 0;
				_data_->_tmp6_ = _data_->_tmp5_;
				if (!(_data_->_tmp3_ < _data_->_tmp6_)) {
					break;
				}
				_data_->_tmp7_ = NULL;
				_data_->_tmp7_ = _data_->event_templates_cp;
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = _data_->event_templates;
				_data_->_tmp9_ = 0;
				_data_->_tmp9_ = _data_->i;
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = g_ptr_array_index (_data_->_tmp8_, (guint) _data_->_tmp9_);
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp10_);
				g_ptr_array_add (_data_->_tmp7_, _data_->_tmp11_);
			}
		}
	}
	_data_->_state_ = 1;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_index_search_with_relevancies_ready, _data_);
	return FALSE;
	_state_1:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_ptr_array_unref0 (_data_->event_templates_cp);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->self->priv->proxy;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->query;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->time_range;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = zeitgeist_time_range_to_variant (_data_->_tmp14_);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->event_templates_cp;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = zeitgeist_events_to_variant (_data_->_tmp17_);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp20_ = 0;
	_data_->_tmp20_ = _data_->storage_state;
	_data_->_tmp21_ = 0U;
	_data_->_tmp21_ = _data_->offset;
	_data_->_tmp22_ = 0U;
	_data_->_tmp22_ = _data_->num_events;
	_data_->_tmp23_ = 0;
	_data_->_tmp23_ = _data_->result_type;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->cancellable;
	_data_->_tmp25_ = NULL;
	_data_->_tmp26_ = NULL;
	_data_->_tmp27_ = 0;
	_data_->_tmp28_ = 0U;
	_data_->_state_ = 2;
	zeitgeist_remote_simple_indexer_search_with_relevancies (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp16_, _data_->_tmp19_, (guint) _data_->_tmp20_, (guint) _data_->_tmp21_, (guint) _data_->_tmp22_, (guint) _data_->_tmp23_, _data_->_tmp24_, zeitgeist_index_search_with_relevancies_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_remote_simple_indexer_search_with_relevancies_finish (_data_->_tmp12_, _data_->_res_, &_data_->_tmp25_, &_data_->_tmp26_, &_data_->_tmp27_, &_data_->_tmp28_, &_data_->_inner_error_);
	_g_variant_unref0 (_data_->relevancies_variant);
	_data_->relevancies_variant = _data_->_tmp25_;
	_g_variant_unref0 (_data_->_result_);
	_data_->_tmp29_ = NULL;
	_data_->_tmp29__length1 = 0;
	_data_->_tmp29_ = _data_->_tmp26_;
	_data_->_tmp29__length1 = _data_->_tmp27_;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _variant_new1 (_data_->_tmp29_, _data_->_tmp27_);
	_data_->_result_ = _data_->_tmp33_;
	_data_->matches = _data_->_tmp28_;
	_data_->_tmp29_ = (g_free (_data_->_tmp29_), NULL);
	_g_variant_unref0 (_data_->_tmp19_);
	_g_variant_unref0 (_data_->_tmp16_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_variant_unref0 (_data_->relevancies_variant);
		_g_variant_unref0 (_data_->_result_);
		_g_ptr_array_unref0 (_data_->event_templates_cp);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->relevancies_variant;
	_data_->_tmp35_ = 0UL;
	_data_->_tmp35_ = g_variant_n_children (_data_->_tmp34_);
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = g_new0 (gdouble, _data_->_tmp35_);
	_data_->relevancies = (g_free (_data_->relevancies), NULL);
	_data_->relevancies = _data_->_tmp36_;
	_data_->relevancies_length1 = _data_->_tmp35_;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->relevancies_variant;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = g_variant_iter_new (_data_->_tmp37_);
	_data_->iter = _data_->_tmp38_;
	{
		_data_->_vala1_i = 0;
		{
			_data_->_tmp39_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp39_) {
					_data_->_tmp40_ = 0;
					_data_->_tmp40_ = _data_->_vala1_i;
					_data_->_vala1_i = _data_->_tmp40_ + 1;
				}
				_data_->_tmp39_ = FALSE;
				_data_->_tmp41_ = 0;
				_data_->_tmp41_ = _data_->_vala1_i;
				_data_->_tmp42_ = NULL;
				_data_->_tmp42_ = _data_->iter;
				_data_->_tmp43_ = 0UL;
				_data_->_tmp43_ = g_variant_iter_n_children (_data_->_tmp42_);
				if (!(((gsize) _data_->_tmp41_) < _data_->_tmp43_)) {
					break;
				}
				_data_->_tmp44_ = NULL;
				_data_->_tmp44_ = _data_->iter;
				g_variant_iter_next (_data_->_tmp44_, "d", &_data_->relevancy, NULL);
				_data_->_tmp45_ = NULL;
				_data_->_tmp45__length1 = 0;
				_data_->_tmp45_ = _data_->relevancies;
				_data_->_tmp45__length1 = _data_->relevancies_length1;
				_data_->_tmp46_ = 0;
				_data_->_tmp46_ = _data_->_vala1_i;
				_data_->_tmp47_ = 0.0;
				_data_->_tmp47_ = _data_->relevancy;
				_data_->_tmp45_[_data_->_tmp46_] = _data_->_tmp47_;
				_data_->_tmp48_ = 0.0;
				_data_->_tmp48_ = _data_->_tmp45_[_data_->_tmp46_];
			}
		}
	}
	_data_->_tmp50_ = NULL;
	_data_->_tmp50_ = _data_->_result_;
	_data_->_tmp51_ = NULL;
	_data_->_tmp51_ = zeitgeist_events_from_variant (_data_->_tmp50_, &_data_->_inner_error_);
	_data_->_tmp49_ = _data_->_tmp51_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_variant_iter_free0 (_data_->iter);
		_g_variant_unref0 (_data_->relevancies_variant);
		_g_variant_unref0 (_data_->_result_);
		_g_ptr_array_unref0 (_data_->event_templates_cp);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp52_ = 0U;
	_data_->_tmp52_ = _data_->matches;
	_data_->_tmp53_ = NULL;
	_data_->_tmp53_ = zeitgeist_simple_result_set_new_with_num_matches (_data_->_tmp49_, _data_->_tmp52_);
	_data_->result = (ZeitgeistResultSet*) _data_->_tmp53_;
	_g_ptr_array_unref0 (_data_->_tmp49_);
	_g_variant_iter_free0 (_data_->iter);
	_g_variant_unref0 (_data_->relevancies_variant);
	_g_variant_unref0 (_data_->_result_);
	_g_ptr_array_unref0 (_data_->event_templates_cp);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_ptr_array_unref0 (_data_->_tmp49_);
	_g_variant_iter_free0 (_data_->iter);
	_g_variant_unref0 (_data_->relevancies_variant);
	_g_variant_unref0 (_data_->_result_);
	_g_ptr_array_unref0 (_data_->event_templates_cp);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_index_class_init (ZeitgeistIndexClass * klass) {
	zeitgeist_index_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistIndexPrivate));
	((ZeitgeistQueuedProxyWrapperClass *) klass)->on_connection_established = zeitgeist_index_real_on_connection_established;
	((ZeitgeistQueuedProxyWrapperClass *) klass)->on_connection_lost = zeitgeist_index_real_on_connection_lost;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_index_finalize;
}


static void zeitgeist_index_instance_init (ZeitgeistIndex * self) {
	self->priv = ZEITGEIST_INDEX_GET_PRIVATE (self);
}


static void zeitgeist_index_finalize (GObject* obj) {
	ZeitgeistIndex * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_INDEX, ZeitgeistIndex);
	_g_object_unref0 (self->priv->proxy);
	G_OBJECT_CLASS (zeitgeist_index_parent_class)->finalize (obj);
}


/**
 * Query the Zeitgeist Full Text Search Extension
 *
 * include: zeitgeist.h
 */
GType zeitgeist_index_get_type (void) {
	static volatile gsize zeitgeist_index_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_index_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistIndexClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_index_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistIndex), 0, (GInstanceInitFunc) zeitgeist_index_instance_init, NULL };
		GType zeitgeist_index_type_id;
		zeitgeist_index_type_id = g_type_register_static (ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER, "ZeitgeistIndex", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_index_type_id__volatile, zeitgeist_index_type_id);
	}
	return zeitgeist_index_type_id__volatile;
}



