/* utils.c generated by valac 0.26.1, the Vala compiler
 * generated from utils.vala, do not modify */

/* utils.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Seif Lotfy <seif@lotfy.com>
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2013 Seif Lotfy <seif@lotfy.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_DATA_MODEL_ERROR_NULL_EVENT,
	ZEITGEIST_DATA_MODEL_ERROR_TOO_MANY_RESULTS
} ZeitgeistDataModelError;
#define ZEITGEIST_DATA_MODEL_ERROR zeitgeist_data_model_error_quark ()

extern gchar* zeitgeist_utils_DATA_PATH;
gchar* zeitgeist_utils_DATA_PATH = NULL;
extern gchar* zeitgeist_utils_DATABASE_FILE_PATH;
gchar* zeitgeist_utils_DATABASE_FILE_PATH = NULL;
extern gchar* zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
gchar* zeitgeist_utils_DATABASE_FILE_BACKUP_PATH = NULL;
extern gchar* zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
gchar* zeitgeist_utils_LOCAL_EXTENSIONS_PATH = NULL;

#define ZEITGEIST_UTILS_DATA_FOLDER "zeitgeist"
#define ZEITGEIST_UTILS_DATABASE_BASENAME "activity.sqlite"
#define ZEITGEIST_UTILS_USER_EXTENSION_PATH ""
#define ZEITGEIST_UTILS_ENGINE_DBUS_NAME "org.gnome.zeitgeist.Engine"
#define ZEITGEIST_UTILS_ENGINE_DBUS_PATH "/org/gnome/zeitgeist/log/activity"
#define ZEITGEIST_UTILS_SIG_EVENT "asaasay"
#define ZEITGEIST_UTILS_MAX_DBUS_RESULT_SIZE ((gsize) ((4 * 1024) * 1024))
#define ZEITGEIST_UTILS_CACHE_SIZE ((guint) 0)
const gchar* zeitgeist_utils_get_data_path (void);
gchar* zeitgeist_utils_get_default_data_path (void);
const gchar* zeitgeist_utils_get_database_file_path (void);
void zeitgeist_utils_set_database_file_path (const gchar* path);
const gchar* zeitgeist_utils_get_database_file_backup_path (void);
gchar* zeitgeist_utils_get_database_file_retire_name (void);
const gchar* zeitgeist_utils_get_local_extensions_path (void);
gboolean zeitgeist_utils_using_in_memory_database (void);
void zeitgeist_utils_backup_database (GError** error);
gboolean zeitgeist_utils_parse_negation (gchar** val);
gboolean zeitgeist_utils_parse_noexpand (gchar** val);
gboolean zeitgeist_utils_parse_wildcard (gchar** val);
gboolean zeitgeist_utils_is_empty_string (const gchar* s);
GQuark zeitgeist_data_model_error_quark (void);
void zeitgeist_utils_assert_sig (gboolean condition, const gchar* error_message, GError** error);
gboolean zeitgeist_utils_log_may_read_directly (void);


const gchar* zeitgeist_utils_get_data_path (void) {
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	_tmp0_ = zeitgeist_utils_DATA_PATH;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = zeitgeist_utils_DATA_PATH;
		result = _tmp1_;
		return result;
	}
	_tmp3_ = g_getenv ("ZEITGEIST_DATA_PATH");
	_tmp4_ = g_strdup (_tmp3_);
	_tmp2_ = _tmp4_;
	if (_tmp2_ == NULL) {
		gchar* _tmp5_ = NULL;
		_tmp5_ = zeitgeist_utils_get_default_data_path ();
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp5_;
	}
	_tmp6_ = _tmp2_;
	_tmp2_ = NULL;
	_g_free0 (zeitgeist_utils_DATA_PATH);
	zeitgeist_utils_DATA_PATH = _tmp6_;
	_tmp7_ = zeitgeist_utils_DATA_PATH;
	_tmp8_ = g_file_test (_tmp7_, G_FILE_TEST_IS_DIR);
	if (!_tmp8_) {
		const gchar* _tmp9_ = NULL;
		_tmp9_ = zeitgeist_utils_DATA_PATH;
		g_mkdir_with_parents (_tmp9_, 0755);
	}
	_tmp10_ = zeitgeist_utils_DATA_PATH;
	g_debug ("utils.vala:67: DATA_PATH = %s", _tmp10_);
	_tmp11_ = zeitgeist_utils_DATA_PATH;
	result = _tmp11_;
	_g_free0 (_tmp2_);
	return result;
}


gchar* zeitgeist_utils_get_default_data_path (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, ZEITGEIST_UTILS_DATA_FOLDER, NULL);
	result = _tmp1_;
	return result;
}


const gchar* zeitgeist_utils_get_database_file_path (void) {
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	_tmp0_ = zeitgeist_utils_DATABASE_FILE_PATH;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = zeitgeist_utils_DATABASE_FILE_PATH;
		result = _tmp1_;
		return result;
	}
	_tmp3_ = g_getenv ("ZEITGEIST_DATABASE_PATH");
	_tmp4_ = g_strdup (_tmp3_);
	_tmp2_ = _tmp4_;
	if (_tmp2_ == NULL) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = zeitgeist_utils_get_data_path ();
		_tmp6_ = g_build_filename (_tmp5_, ZEITGEIST_UTILS_DATABASE_BASENAME, NULL);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp6_;
	}
	_tmp7_ = _tmp2_;
	_tmp2_ = NULL;
	_g_free0 (zeitgeist_utils_DATABASE_FILE_PATH);
	zeitgeist_utils_DATABASE_FILE_PATH = _tmp7_;
	_tmp8_ = zeitgeist_utils_DATABASE_FILE_PATH;
	g_debug ("utils.vala:86: DATABASE_FILE_PATH = %s", _tmp8_);
	_tmp9_ = zeitgeist_utils_DATABASE_FILE_PATH;
	result = _tmp9_;
	_g_free0 (_tmp2_);
	return result;
}


/**
         * Sets the filepath of the database.
         * @param path a {@link string}
         */
void zeitgeist_utils_set_database_file_path (const gchar* path) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (zeitgeist_utils_DATABASE_FILE_PATH);
	zeitgeist_utils_DATABASE_FILE_PATH = _tmp1_;
}


const gchar* zeitgeist_utils_get_database_file_backup_path (void) {
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	_tmp0_ = zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
		result = _tmp1_;
		return result;
	}
	_tmp3_ = g_getenv ("ZEITGEIST_DATABASE_BACKUP_PATH");
	_tmp4_ = g_strdup (_tmp3_);
	_tmp2_ = _tmp4_;
	if (_tmp2_ == NULL) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = zeitgeist_utils_get_data_path ();
		_tmp6_ = g_build_filename (_tmp5_, ZEITGEIST_UTILS_DATABASE_BASENAME ".bck", NULL);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp6_;
	}
	_tmp7_ = _tmp2_;
	_tmp2_ = NULL;
	_g_free0 (zeitgeist_utils_DATABASE_FILE_BACKUP_PATH);
	zeitgeist_utils_DATABASE_FILE_BACKUP_PATH = _tmp7_;
	_tmp8_ = zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
	g_debug ("utils.vala:109: DATABASE_FILE_BACKUP_PATH = %s", _tmp8_);
	_tmp9_ = zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
	result = _tmp9_;
	_g_free0 (_tmp2_);
	return result;
}


gchar* zeitgeist_utils_get_database_file_retire_name (void) {
	gchar* result = NULL;
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (_tmp1_, "%Y%m%d-%H%M%S");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (".%s.bck", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (ZEITGEIST_UTILS_DATABASE_BASENAME, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_date_time_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


const gchar* zeitgeist_utils_get_local_extensions_path (void) {
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	_tmp0_ = zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = zeitgeist_utils_get_data_path ();
	_tmp3_ = g_build_filename (_tmp2_, "extensions", NULL);
	_g_free0 (zeitgeist_utils_LOCAL_EXTENSIONS_PATH);
	zeitgeist_utils_LOCAL_EXTENSIONS_PATH = _tmp3_;
	_tmp4_ = zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
	g_debug ("utils.vala:127: LOCAL_EXTENSIONS_PATH = %s", _tmp4_);
	_tmp5_ = zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
	result = _tmp5_;
	return result;
}


/**
         * @return Whether a in-memory SQLite database is in use (vs.
         *         a file-based one).
         */
gboolean zeitgeist_utils_using_in_memory_database (void) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = zeitgeist_utils_get_database_file_path ();
	result = g_strcmp0 (_tmp0_, ":memory:") == 0;
	return result;
}


void zeitgeist_utils_backup_database (GError** error) {
	GFile* original = NULL;
	GFile* destination = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = zeitgeist_utils_get_database_file_path ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (original);
	original = _tmp1_;
	_tmp2_ = zeitgeist_utils_get_database_file_backup_path ();
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_g_object_unref0 (destination);
	destination = _tmp3_;
	_tmp4_ = zeitgeist_utils_get_database_file_backup_path ();
	g_message ("utils.vala:148: Backing up database to \"%s\" for schema upgrade...", _tmp4_);
	g_file_copy (original, destination, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (destination);
		_g_object_unref0 (original);
		return;
	}
	_g_object_unref0 (destination);
	_g_object_unref0 (original);
}


/**
         * Check if the value starts with the negation operator. If it does,
         * remove the operator from the value and return true. Otherwise,
         * return false.
         *
         * @param val value to check
         */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


gboolean zeitgeist_utils_parse_negation (gchar** val) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (*val != NULL, FALSE);
	_tmp0_ = *val;
	_tmp1_ = g_str_has_prefix (_tmp0_, "!");
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *val;
	_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) (-1));
	_g_free0 (*val);
	*val = _tmp3_;
	result = TRUE;
	return result;
}


/**
         * Check if the value starts with the noexpand operator. If it does,
         * remove the operator from the value and return true. Otherwise,
         * return false.
         *
         * Check for the negation operator before calling this function.
         *
         * @param val value to check
         */
gboolean zeitgeist_utils_parse_noexpand (gchar** val) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (*val != NULL, FALSE);
	_tmp0_ = *val;
	_tmp1_ = g_str_has_prefix (_tmp0_, "+");
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *val;
	_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) (-1));
	_g_free0 (*val);
	*val = _tmp3_;
	result = TRUE;
	return result;
}


/**
         * Check if the value ends with the wildcard character. If it does,
         * remove the wildcard character from the value and return true.
         * Otherwise, return false.
         *
         * @param val value to check
         */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


gboolean zeitgeist_utils_parse_wildcard (gchar** val) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	guint8* val_data = NULL;
	const gchar* _tmp2_ = NULL;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint val_data_length1 = 0;
	gint _val_data_size_ = 0;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	guint8 _tmp7_ = 0U;
	g_return_val_if_fail (*val != NULL, FALSE);
	_tmp0_ = *val;
	_tmp1_ = g_str_has_suffix (_tmp0_, "*");
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *val;
	_tmp3_ = string_get_data (_tmp2_, &_tmp3__length1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	val_data = _tmp4_;
	val_data_length1 = _tmp4__length1;
	_val_data_size_ = val_data_length1;
	_tmp5_ = val_data;
	_tmp5__length1 = val_data_length1;
	_tmp6_ = val_data;
	_tmp6__length1 = val_data_length1;
	_tmp5_[_tmp6__length1 - 1] = (guint8) '\0';
	_tmp7_ = _tmp5_[_tmp6__length1 - 1];
	result = TRUE;
	return result;
}


/**
         * Return true if a string is empty (null or containing just a null
         * byte).
         *
         * @param s string to check
         */
gboolean zeitgeist_utils_is_empty_string (const gchar* s) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	_tmp1_ = s;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = s;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	result = _tmp0_;
	return result;
}


void zeitgeist_utils_assert_sig (gboolean condition, const gchar* error_message, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (error_message != NULL);
	_tmp0_ = condition;
	_tmp1_ = G_UNLIKELY (!_tmp0_);
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		_tmp2_ = error_message;
		_tmp3_ = g_error_new_literal (ZEITGEIST_DATA_MODEL_ERROR, ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE, _tmp2_);
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
         * @return True if direct reading of the DB is enabled for Log, default is True.
         */
gboolean zeitgeist_utils_log_may_read_directly (void) {
	gboolean result = FALSE;
	gchar* env_var = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	_tmp0_ = g_getenv ("ZEITGEIST_LOG_DIRECT_READ");
	_tmp1_ = g_strdup (_tmp0_);
	env_var = _tmp1_;
	_tmp2_ = env_var;
	if (_tmp2_ == NULL) {
		result = TRUE;
		_g_free0 (env_var);
		return result;
	}
	_tmp3_ = env_var;
	_tmp4_ = atoi (_tmp3_);
	result = _tmp4_ != 0;
	_g_free0 (env_var);
	return result;
}



