/* logging.c generated by valac 0.26.1, the Vala compiler
 * generated from logging.vala, do not modify */

/* logging.vala
 *
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <glib/gstdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))


extern FILE* zeitgeist_logging_log_file;
FILE* zeitgeist_logging_log_file = NULL;

#define ZEITGEIST_LOGGING_BLUE "\x1b[34m"
#define ZEITGEIST_LOGGING_GREEN "\x1b[32m"
#define ZEITGEIST_LOGGING_RED "\x1b[31m"
#define ZEITGEIST_LOGGING_YELLOW "\x1b[33m"
#define ZEITGEIST_LOGGING_RESET "\x1b[0m"
gchar* zeitgeist_logging_get_log_level_string (GLogLevelFlags log_levels, gchar** color);
void zeitgeist_logging_log_handler (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message);
void zeitgeist_logging_setup_logging (const gchar* log_level, const gchar* log_file);
static void ___lambda5_ (void);
static void ____lambda5__glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void _zeitgeist_logging_log_handler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);


gchar* zeitgeist_logging_get_log_level_string (GLogLevelFlags log_levels, gchar** color) {
	gchar* _vala_color = NULL;
	gchar* result = NULL;
	gchar* log_level = NULL;
	GLogLevelFlags _tmp0_ = 0;
	_tmp0_ = log_levels;
	if ((_tmp0_ & G_LOG_LEVEL_ERROR) != 0) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = g_strdup ("ERROR");
		_g_free0 (log_level);
		log_level = _tmp1_;
		_tmp2_ = g_strdup (ZEITGEIST_LOGGING_RED);
		_g_free0 (_vala_color);
		_vala_color = _tmp2_;
	} else {
		GLogLevelFlags _tmp3_ = 0;
		_tmp3_ = log_levels;
		if ((_tmp3_ & G_LOG_LEVEL_CRITICAL) != 0) {
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			_tmp4_ = g_strdup ("CRITICAL");
			_g_free0 (log_level);
			log_level = _tmp4_;
			_tmp5_ = g_strdup (ZEITGEIST_LOGGING_RED);
			_g_free0 (_vala_color);
			_vala_color = _tmp5_;
		} else {
			GLogLevelFlags _tmp6_ = 0;
			_tmp6_ = log_levels;
			if ((_tmp6_ & G_LOG_LEVEL_WARNING) != 0) {
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				_tmp7_ = g_strdup ("WARNING");
				_g_free0 (log_level);
				log_level = _tmp7_;
				_tmp8_ = g_strdup (ZEITGEIST_LOGGING_RED);
				_g_free0 (_vala_color);
				_vala_color = _tmp8_;
			} else {
				GLogLevelFlags _tmp9_ = 0;
				_tmp9_ = log_levels;
				if ((_tmp9_ & G_LOG_LEVEL_MESSAGE) != 0) {
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					_tmp10_ = g_strdup ("MESSAGE");
					_g_free0 (log_level);
					log_level = _tmp10_;
					_tmp11_ = g_strdup (ZEITGEIST_LOGGING_BLUE);
					_g_free0 (_vala_color);
					_vala_color = _tmp11_;
				} else {
					GLogLevelFlags _tmp12_ = 0;
					_tmp12_ = log_levels;
					if ((_tmp12_ & G_LOG_LEVEL_INFO) != 0) {
						gchar* _tmp13_ = NULL;
						gchar* _tmp14_ = NULL;
						_tmp13_ = g_strdup ("INFO");
						_g_free0 (log_level);
						log_level = _tmp13_;
						_tmp14_ = g_strdup (ZEITGEIST_LOGGING_BLUE);
						_g_free0 (_vala_color);
						_vala_color = _tmp14_;
					} else {
						GLogLevelFlags _tmp15_ = 0;
						_tmp15_ = log_levels;
						if ((_tmp15_ & G_LOG_LEVEL_DEBUG) != 0) {
							gchar* _tmp16_ = NULL;
							gchar* _tmp17_ = NULL;
							_tmp16_ = g_strdup ("DEBUG");
							_g_free0 (log_level);
							log_level = _tmp16_;
							_tmp17_ = g_strdup (ZEITGEIST_LOGGING_GREEN);
							_g_free0 (_vala_color);
							_vala_color = _tmp17_;
						} else {
							gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
							_tmp18_ = g_strdup ("UNKNOWN");
							_g_free0 (log_level);
							log_level = _tmp18_;
							_tmp19_ = g_strdup (ZEITGEIST_LOGGING_BLUE);
							_g_free0 (_vala_color);
							_vala_color = _tmp19_;
						}
					}
				}
			}
		}
	}
	result = log_level;
	if (color) {
		*color = _vala_color;
	} else {
		_g_free0 (_vala_color);
	}
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


void zeitgeist_logging_log_handler (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message) {
	gchar* color = NULL;
	gchar* log_level = NULL;
	GLogLevelFlags _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* timestamp = NULL;
	GTimeVal _tmp3_ = {0};
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	FILE* output = NULL;
	GLogLevelFlags _tmp8_ = 0;
	FILE* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	FILE* _tmp16_ = NULL;
	g_return_if_fail (message != NULL);
	_tmp0_ = log_levels;
	_tmp2_ = zeitgeist_logging_get_log_level_string (_tmp0_, &_tmp1_);
	_g_free0 (color);
	color = _tmp1_;
	log_level = _tmp2_;
	g_get_current_time (&_tmp3_);
	_tmp4_ = g_time_val_to_iso8601 (&_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_substring (_tmp5_, (glong) 11, (glong) 15);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	timestamp = _tmp7_;
	_tmp8_ = log_levels;
	if (_tmp8_ >= G_LOG_LEVEL_MESSAGE) {
		FILE* _tmp9_ = NULL;
		_tmp9_ = stdout;
		output = _tmp9_;
	} else {
		FILE* _tmp10_ = NULL;
		_tmp10_ = stderr;
		output = _tmp10_;
	}
	_tmp11_ = output;
	_tmp12_ = color;
	_tmp13_ = timestamp;
	_tmp14_ = log_level;
	_tmp15_ = message;
	fprintf (_tmp11_, "%s[%s %s]%s %s\n", _tmp12_, _tmp13_, _tmp14_, ZEITGEIST_LOGGING_RESET, _tmp15_);
	_tmp16_ = zeitgeist_logging_log_file;
	if (_tmp16_ != NULL) {
		GDateTime* datetime = NULL;
		GDateTime* _tmp17_ = NULL;
		gchar* date_string = NULL;
		GDateTime* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GDateTime* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gint pid = 0;
		pid_t _tmp25_ = 0;
		FILE* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		_tmp17_ = g_date_time_new_now_local ();
		datetime = _tmp17_;
		_tmp18_ = datetime;
		_tmp19_ = g_date_time_format (_tmp18_, "%Y-%m-%d %H:%M:%S");
		_tmp20_ = _tmp19_;
		_tmp21_ = datetime;
		_tmp22_ = g_date_time_get_microsecond (_tmp21_);
		_tmp23_ = g_strdup_printf ("%s,%.3d", _tmp20_, (gint) (_tmp22_ / 1000.0));
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp20_);
		date_string = _tmp24_;
		_tmp25_ = getpid ();
		pid = (gint) _tmp25_;
		_tmp26_ = zeitgeist_logging_log_file;
		_tmp27_ = pid;
		_tmp28_ = date_string;
		_tmp29_ = log_level;
		_tmp30_ = message;
		fprintf (_tmp26_, "%d [%s] - %s - %s\n", _tmp27_, _tmp28_, _tmp29_, _tmp30_);
		_g_free0 (date_string);
		_g_date_time_unref0 (datetime);
	}
	_g_free0 (timestamp);
	_g_free0 (log_level);
	_g_free0 (color);
}


static void ___lambda5_ (void) {
}


static void ____lambda5__glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	___lambda5_ ();
}


static void _zeitgeist_logging_log_handler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	zeitgeist_logging_log_handler (log_domain, log_levels, message);
}


void zeitgeist_logging_setup_logging (const gchar* log_level, const gchar* log_file) {
	GLogLevelFlags discarded = 0;
	const gchar* _tmp0_ = NULL;
	GLogLevelFlags _tmp19_ = 0;
	const gchar* _tmp21_ = NULL;
	GLogLevelFlags logged = 0;
	GLogLevelFlags _tmp24_ = 0;
	discarded = G_LOG_LEVEL_DEBUG;
	_tmp0_ = log_level;
	if (_tmp0_ != NULL) {
		GLogLevelFlags ld = 0;
		GLogLevelFlags li = 0;
		GLogLevelFlags lm = 0;
		GLogLevelFlags lw = 0;
		GLogLevelFlags lc = 0;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GQuark _tmp5_ = 0U;
		static GQuark _tmp4_label0 = 0;
		static GQuark _tmp4_label1 = 0;
		static GQuark _tmp4_label2 = 0;
		static GQuark _tmp4_label3 = 0;
		static GQuark _tmp4_label4 = 0;
		ld = G_LOG_LEVEL_DEBUG;
		li = G_LOG_LEVEL_INFO;
		lm = G_LOG_LEVEL_MESSAGE;
		lw = G_LOG_LEVEL_WARNING;
		lc = G_LOG_LEVEL_CRITICAL;
		_tmp1_ = log_level;
		_tmp2_ = g_utf8_strup (_tmp1_, (gssize) (-1));
		_tmp3_ = _tmp2_;
		_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
		g_free (_tmp3_);
		if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("DEBUG")))) {
			switch (0) {
				default:
				{
					discarded = 0;
					break;
				}
			}
		} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("INFO")))) {
			switch (0) {
				default:
				{
					GLogLevelFlags _tmp6_ = 0;
					_tmp6_ = ld;
					discarded = _tmp6_;
					break;
				}
			}
		} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("WARNING")))) {
			switch (0) {
				default:
				{
					GLogLevelFlags _tmp7_ = 0;
					GLogLevelFlags _tmp8_ = 0;
					GLogLevelFlags _tmp9_ = 0;
					_tmp7_ = ld;
					_tmp8_ = li;
					_tmp9_ = lm;
					discarded = (_tmp7_ | _tmp8_) | _tmp9_;
					break;
				}
			}
		} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("CRITICAL")))) {
			switch (0) {
				default:
				{
					GLogLevelFlags _tmp10_ = 0;
					GLogLevelFlags _tmp11_ = 0;
					GLogLevelFlags _tmp12_ = 0;
					GLogLevelFlags _tmp13_ = 0;
					_tmp10_ = ld;
					_tmp11_ = li;
					_tmp12_ = lm;
					_tmp13_ = lw;
					discarded = ((_tmp10_ | _tmp11_) | _tmp12_) | _tmp13_;
					break;
				}
			}
		} else if (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("ERROR")))) {
			switch (0) {
				default:
				{
					GLogLevelFlags _tmp14_ = 0;
					GLogLevelFlags _tmp15_ = 0;
					GLogLevelFlags _tmp16_ = 0;
					GLogLevelFlags _tmp17_ = 0;
					GLogLevelFlags _tmp18_ = 0;
					_tmp14_ = ld;
					_tmp15_ = li;
					_tmp16_ = lm;
					_tmp17_ = lw;
					_tmp18_ = lc;
					discarded = (((_tmp14_ | _tmp15_) | _tmp16_) | _tmp17_) | _tmp18_;
					break;
				}
			}
		}
	}
	_tmp19_ = discarded;
	if (_tmp19_ != 0) {
		GLogLevelFlags _tmp20_ = 0;
		_tmp20_ = discarded;
		g_log_set_handler (NULL, _tmp20_, ____lambda5__glog_func, NULL);
	}
	_tmp21_ = log_file;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_ = NULL;
		FILE* _tmp23_ = NULL;
		_tmp22_ = log_file;
		_tmp23_ = g_fopen (_tmp22_, "a");
		_fclose0 (zeitgeist_logging_log_file);
		zeitgeist_logging_log_file = _tmp23_;
	}
	_tmp24_ = discarded;
	logged = (~_tmp24_) & (~G_LOG_FLAG_RECURSION);
	g_log_set_handler (NULL, logged, _zeitgeist_logging_log_handler_glog_func, NULL);
}



