% File src/library/base/man/tempfile.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2014 R Core Team
% Distributed under GPL 2 or later

\newcommand{\CRANpkg}{\href{http://CRAN.R-project.org/package=#1}{\pkg{#1}}}

\name{tempfile}
\alias{tempfile}
\alias{tempdir}
\title{Create Names for Temporary Files}
\description{
  \code{tempfile} returns a vector of character strings which can be used as
  names for temporary files.
}
\usage{
tempfile(pattern = "file", tmpdir = tempdir(), fileext = "")
tempdir()
}
\arguments{
  \item{pattern}{a non-empty character vector giving the initial part
    of the name.}
  \item{tmpdir}{a non-empty character vector giving the directory name}
  \item{fileext}{a non-empty character vector giving the file extension}
}
\value{
  For \code{tempfile} a character vector giving the names of possible
  (temporary) files.  Note that no files are generated by \code{tempfile}.

  For \code{tempdir}, the path of the per-session temporary directory.
#ifdef windows

  Both will use backslash as the path separator.
#endif
}
\details{
  The length of the result is the maximum of the lengths of the three
  arguments; values of shorter arguments are recycled.

  The names are very likely to be unique among calls to \code{tempfile}
  in an \R session and across simultaneous \R sessions (unless
  \code{tmpdir} is specified).  The filenames are guaranteed not to be
  currently in use.

  The file name is made by concatenating the path given by
  \code{tmpdir}, the \code{pattern} string, a random string in hex and
  a suffix of \code{fileext}.

  By default, \code{tmpdir} will be the directory given by
  \code{tempdir()}.  This will be a subdirectory of the per-session
  temporary directory found by the following rule when the \R session is
  started.  The environment variables \env{TMPDIR}, \env{TMP} and
  \env{TEMP} are checked in turn and the first found which points to a
  writable directory is used:
#ifdef unix
  if none succeeds \file{/tmp} is used.  The path should not contain spaces.
#endif
#ifdef windows
  if none succeeds the value of \env{R_USER} (see
  \code{\link{Rconsole}}) is used.  If the path to the directory
  contains a space in any of the components, the path returned will use
  the shortnames version of the path.
#endif
  Note that setting any of these environment variables in the \R session
  has no effect on \code{tempdir()}: the per-session temporary directory
  is created before the interpreter is started.
}
\section{Note on parallel}{
  \R processes forked by functions such as \code{\link{mclapply}} in
  package \pkg{parallel} (or \CRANpkg{multicore}) share a per-session
  temporary directory.  Further, the \sQuote{guaranteed not to be
    currently in use} applies only at the time of asking, and two
  children could ask simultaneously.  This is circumvented
  by ensuring that \code{tempfile} calls in different children try
  different names.
}

\references{
  Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988)
  \emph{The New S Language}.
  Wadsworth & Brooks/Cole.
}
\seealso{\code{\link{unlink}} for deleting files.}
\examples{\donttest{
tempfile(c("ab", "a b c"))   # give file name with spaces in!

tempfile("plot", fileext = c(".ps", ".pdf"))

tempdir() # works on all platforms with a platform-dependent result
}}
\keyword{file}
