/* Corebird.c generated by valac 0.26.2, the Vala compiler
 * generated from Corebird.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;
typedef struct _CorebirdPrivate CorebirdPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SETTINGS_DIALOG (settings_dialog_get_type ())
#define SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_DIALOG, SettingsDialog))
#define SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_DIALOG, SettingsDialogClass))
#define IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_DIALOG))
#define IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_DIALOG))
#define SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_DIALOG, SettingsDialogClass))

typedef struct _SettingsDialog SettingsDialog;
typedef struct _SettingsDialogClass SettingsDialogClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ABOUT_DIALOG (about_dialog_get_type ())
#define ABOUT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABOUT_DIALOG, AboutDialog))
#define ABOUT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABOUT_DIALOG, AboutDialogClass))
#define IS_ABOUT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABOUT_DIALOG))
#define IS_ABOUT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABOUT_DIALOG))
#define ABOUT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABOUT_DIALOG, AboutDialogClass))

typedef struct _AboutDialog AboutDialog;
typedef struct _AboutDialogClass AboutDialogClass;

#define TYPE_LAZY_MENU_BUTTON (lazy_menu_button_get_type ())
#define LAZY_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAZY_MENU_BUTTON, LazyMenuButton))
#define LAZY_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAZY_MENU_BUTTON, LazyMenuButtonClass))
#define IS_LAZY_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAZY_MENU_BUTTON))
#define IS_LAZY_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAZY_MENU_BUTTON))
#define LAZY_MENU_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAZY_MENU_BUTTON, LazyMenuButtonClass))

typedef struct _LazyMenuButton LazyMenuButton;
typedef struct _LazyMenuButtonClass LazyMenuButtonClass;
#define _sql_database_unref0(var) ((var == NULL) ? NULL : (var = (sql_database_unref (var), NULL)))

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _Block1Data Block1Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

struct _Corebird {
	GtkApplication parent_instance;
	CorebirdPrivate * priv;
};

struct _CorebirdClass {
	GtkApplicationClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	Corebird* self;
	Account* acc;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;


static gpointer corebird_parent_class = NULL;
extern SqlDatabase* corebird_db;
SqlDatabase* corebird_db = NULL;
extern GMenu* corebird_account_menu;
GMenu* corebird_account_menu = NULL;

GType corebird_get_type (void) G_GNUC_CONST;
enum  {
	COREBIRD_DUMMY_PROPERTY
};
gpointer sql_database_ref (gpointer instance);
void sql_database_unref (gpointer instance);
GParamSpec* sql_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_database (GValue* value, gpointer v_object);
void sql_value_take_database (GValue* value, gpointer v_object);
gpointer sql_value_get_database (const GValue* value);
GType sql_database_get_type (void) G_GNUC_CONST;
static void corebird_show_settings_activated (Corebird* self);
static void _corebird_show_settings_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_quit_application (Corebird* self);
static void _corebird_quit_application_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_about_activated (Corebird* self);
static void _corebird_about_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_show_dm_thread (Corebird* self, GSimpleAction* a, GVariant* value);
static void _corebird_show_dm_thread_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_mark_seen (Corebird* self, GSimpleAction* a, GVariant* value);
static void _corebird_mark_seen_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_show_window (Corebird* self, GSimpleAction* a, GVariant* value);
static void _corebird_show_window_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Corebird* corebird_new (GError** error);
Corebird* corebird_construct (GType object_type, GError** error);
static gint corebird_real_command_line (GApplication* base, GApplicationCommandLine* cmd);
#define GETTEXT_PACKAGE "corebird"
static void corebird_open_startup_windows (Corebird* self, const gchar* compose_screen_name);
static void corebird_real_activate (GApplication* base);
GType settings_dialog_get_type (void) G_GNUC_CONST;
SettingsDialog* settings_dialog_new (Corebird* application);
SettingsDialog* settings_dialog_construct (GType object_type, Corebird* application);
GType about_dialog_get_type (void) G_GNUC_CONST;
AboutDialog* about_dialog_new (void);
AboutDialog* about_dialog_construct (GType object_type);
static void corebird_real_startup (GApplication* base);
LazyMenuButton* lazy_menu_button_new (void);
LazyMenuButton* lazy_menu_button_construct (GType object_type);
GType lazy_menu_button_get_type (void) G_GNUC_CONST;
void dirs_create_dirs (void);
gchar* dirs_config (const gchar* path);
#define DATADIR "/usr/share/corebird/"
#define SQL_COREBIRD_INIT_FILE DATADIR "/sql/init/Create.%d.sql"
SqlDatabase* sql_database_new (const gchar* filename, const gchar* init_file);
SqlDatabase* sql_database_construct (GType object_type, const gchar* filename, const gchar* init_file);
#define LOCALEDIR "/usr/share/locale"
void utils_load_custom_css (void);
void utils_load_custom_icons (void);
void utils_init_soup_session (void);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
void twitter_init (Twitter* self);
GType account_get_type (void) G_GNUC_CONST;
GSList* account_list_accounts (void);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void corebird_account_info_changed (Corebird* self, Account* source, const gchar* screen_name, const gchar* s, GdkPixbuf* a, GdkPixbuf* b);
static void _corebird_account_info_changed_account_info_changed (Account* _sender, const gchar* screen_name, const gchar* name, GdkPixbuf* avatar_small, GdkPixbuf* avatar, gpointer self);
gint64 account_get_id (Account* self);
static void ____lambda215_ (Block1Data* _data1_);
void corebird_add_window_for_account (Corebird* self, Account* account);
static void _____lambda215__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static GMenuItem* corebird_create_accout_menu_item (Corebird* self, Account* account);
gchar* settings_get_accel (const gchar* accel_name);
gboolean settings_use_dark_theme (void);
static void corebird_real_shutdown (GApplication* base);
const gchar* account_get_screen_name (Account* self);
Account* account_query_account (const gchar* screen_name);
void account_init_proxy (Account* self, gboolean load_secrets, gboolean force);
void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode, GtkApplication* app);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode, GtkApplication* app);
GSettings* settings_get (void);
gboolean corebird_add_window_for_screen_name (Corebird* self, const gchar* screen_name);
GType main_window_get_type (void) G_GNUC_CONST;
MainWindow* main_window_new (GtkApplication* app, Account* account);
MainWindow* main_window_construct (GType object_type, GtkApplication* app, Account* account);
gboolean corebird_is_window_open_for_screen_name (Corebird* self, const gchar* screen_name, MainWindow** window);
gboolean corebird_is_window_open_for_user_id (Corebird* self, gint64 user_id, MainWindow** window);
Account* main_window_get_account (MainWindow* self);
#define ACCOUNT_DUMMY "screen_name"
void main_window_save_geometry (MainWindow* self);
GType bundle_get_type (void) G_GNUC_CONST;
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void g_cclosure_user_marshal_VOID__INT64_INT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void corebird_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry COREBIRD_app_entries[6] = {{"show-settings", _corebird_show_settings_activated_gsimple_action_activate_callback}, {"quit", _corebird_quit_application_gsimple_action_activate_callback}, {"show-about-dialog", _corebird_about_activated_gsimple_action_activate_callback}, {"show-dm-thread", _corebird_show_dm_thread_gsimple_action_activate_callback, "(sx)"}, {"mark-seen", _corebird_mark_seen_gsimple_action_activate_callback, "(sx)"}, {"show-window", _corebird_show_window_gsimple_action_activate_callback, "x"}};

static void _corebird_show_settings_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_show_settings_activated ((Corebird*) self);
}


static void _corebird_quit_application_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_quit_application ((Corebird*) self);
}


static void _corebird_about_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_about_activated ((Corebird*) self);
}


static void _corebird_show_dm_thread_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_show_dm_thread ((Corebird*) self, action, parameter);
}


static void _corebird_mark_seen_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_mark_seen ((Corebird*) self, action, parameter);
}


static void _corebird_show_window_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_show_window ((Corebird*) self, action, parameter);
}


Corebird* corebird_construct (GType object_type, GError** error) {
	Corebird * self = NULL;
	self = (Corebird*) g_object_new (object_type, "application-id", "org.baedert.corebird", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	g_application_set_inactivity_timeout (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication), (guint) 500);
	return self;
}


Corebird* corebird_new (GError** error) {
	return corebird_construct (TYPE_COREBIRD, error);
}


static gint corebird_real_command_line (GApplication* base, GApplicationCommandLine* cmd) {
	Corebird * self;
	gint result = 0;
	gchar* compose_screen_name = NULL;
	GOptionEntry* options = NULL;
	GOptionEntry* _tmp0_ = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	GOptionEntry* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GOptionEntry _tmp2_ = {0};
	GOptionEntry _tmp3_ = {0};
	GOptionEntry* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GOptionEntry _tmp5_ = {0};
	GOptionEntry _tmp6_ = {0};
	gchar** args = NULL;
	GApplicationCommandLine* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gchar** _tmp9_ = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	const gchar** _args = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gchar** _tmp11_ = NULL;
	gint _args_length1 = 0;
	gint __args_size_ = 0;
	const gchar* _tmp31_ = NULL;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COREBIRD, Corebird);
	g_return_val_if_fail (G_IS_APPLICATION_COMMAND_LINE (cmd), 0);
	g_application_hold (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
	compose_screen_name = NULL;
	_tmp0_ = g_new0 (GOptionEntry, 2);
	options = _tmp0_;
	options_length1 = 2;
	_options_size_ = options_length1;
	_tmp1_ = options;
	_tmp1__length1 = options_length1;
	_tmp2_.long_name = "tweet";
	_tmp2_.short_name = 't';
	_tmp2_.flags = 0;
	_tmp2_.arg = G_OPTION_ARG_STRING;
	_tmp2_.arg_data = &compose_screen_name;
	_tmp2_.description = "Shows only the 'compose tweet' window for the given account, nothing e" \
"lse.";
	_tmp2_.arg_description = "SCREEN_NAME";
	_tmp1_[0] = _tmp2_;
	_tmp3_ = _tmp1_[0];
	_tmp4_ = options;
	_tmp4__length1 = options_length1;
	_tmp5_.long_name = NULL;
	_tmp4_[1] = _tmp5_;
	_tmp6_ = _tmp4_[1];
	_tmp7_ = cmd;
	_tmp9_ = g_application_command_line_get_arguments (_tmp7_, &_tmp8_);
	args = _tmp9_;
	args_length1 = _tmp8_;
	_args_size_ = args_length1;
	_tmp10_ = args;
	_tmp10__length1 = args_length1;
	_tmp11_ = g_new0 (gchar*, _tmp10__length1 + 1);
	_args = _tmp11_;
	_args_length1 = _tmp10__length1;
	__args_size_ = _args_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint _tmp14_ = 0;
				gchar** _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				const gchar** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				gchar** _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				gint _tmp19_ = 0;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = args;
				_tmp15__length1 = args_length1;
				if (!(_tmp14_ < _tmp15__length1)) {
					break;
				}
				_tmp16_ = _args;
				_tmp16__length1 = _args_length1;
				_tmp17_ = i;
				_tmp18_ = args;
				_tmp18__length1 = args_length1;
				_tmp19_ = i;
				_tmp20_ = _tmp18_[_tmp19_];
				_tmp16_[_tmp17_] = _tmp20_;
				_tmp21_ = _tmp16_[_tmp17_];
			}
		}
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp22_ = NULL;
		GOptionContext* _tmp23_ = NULL;
		GOptionContext* _tmp24_ = NULL;
		GOptionEntry* _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		GOptionContext* _tmp26_ = NULL;
		GOptionGroup* _tmp27_ = NULL;
		gchar** tmp = NULL;
		const gchar** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gint tmp_length1 = 0;
		gint _tmp_size_ = 0;
		GOptionContext* _tmp29_ = NULL;
		_tmp22_ = g_option_context_new ("");
		opt_context = _tmp22_;
		_tmp23_ = opt_context;
		g_option_context_set_help_enabled (_tmp23_, TRUE);
		_tmp24_ = opt_context;
		_tmp25_ = options;
		_tmp25__length1 = options_length1;
		g_option_context_add_main_entries (_tmp24_, _tmp25_, GETTEXT_PACKAGE);
		_tmp26_ = opt_context;
		_tmp27_ = gst_init_get_option_group ();
		g_option_context_add_group (_tmp26_, _tmp27_);
		_tmp28_ = _args;
		_tmp28__length1 = _args_length1;
		tmp = _tmp28_;
		tmp_length1 = _tmp28__length1;
		_tmp_size_ = tmp_length1;
		_tmp29_ = opt_context;
		g_option_context_parse (_tmp29_, &tmp_length1, &tmp, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			_args = (g_free (_args), NULL);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			options = (g_free (options), NULL);
			_g_free0 (compose_screen_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		GApplicationCommandLine* _tmp30_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = cmd;
		g_application_command_line_print (_tmp30_, "Use --help to see available options\n");
		g_application_quit (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
		result = -1;
		_g_error_free0 (e);
		_args = (g_free (_args), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		options = (g_free (options), NULL);
		_g_free0 (compose_screen_name);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_args = (g_free (_args), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		options = (g_free (options), NULL);
		_g_free0 (compose_screen_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp31_ = compose_screen_name;
	corebird_open_startup_windows (self, _tmp31_);
	g_application_release (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
	result = 0;
	_args = (g_free (_args), NULL);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	options = (g_free (options), NULL);
	_g_free0 (compose_screen_name);
	return result;
}


static void corebird_real_activate (GApplication* base) {
	Corebird * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COREBIRD, Corebird);
	corebird_open_startup_windows (self, NULL);
}


static void corebird_show_settings_activated (Corebird* self) {
	SettingsDialog* dialog = NULL;
	SettingsDialog* _tmp0_ = NULL;
	g_return_if_fail (IS_COREBIRD (self));
	_tmp0_ = settings_dialog_new (self);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (dialog);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void corebird_about_activated (Corebird* self) {
	GtkWindow* active_window = NULL;
	GtkWindow* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	AboutDialog* ad = NULL;
	AboutDialog* _tmp2_ = NULL;
	g_return_if_fail (IS_COREBIRD (self));
	_tmp0_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	active_window = _tmp1_;
	_tmp2_ = about_dialog_new ();
	g_object_ref_sink (_tmp2_);
	ad = _tmp2_;
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (ad, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (ad, gtk_window_get_type (), GtkWindow), active_window);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (ad, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ad);
	_g_object_unref0 (active_window);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Corebird* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->acc);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _corebird_account_info_changed_account_info_changed (Account* _sender, const gchar* screen_name, const gchar* name, GdkPixbuf* avatar_small, GdkPixbuf* avatar, gpointer self) {
	corebird_account_info_changed ((Corebird*) self, _sender, screen_name, name, avatar_small, avatar);
}


static void ____lambda215_ (Block1Data* _data1_) {
	Corebird* self;
	Account* _tmp0_ = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->acc;
	corebird_add_window_for_account (self, _tmp0_);
}


static void _____lambda215__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	____lambda215_ (self);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void corebird_real_startup (GApplication* base) {
	Corebird * self;
	LazyMenuButton* _tmp0_ = NULL;
	LazyMenuButton* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	SqlDatabase* _tmp4_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp5_ = NULL;
	GMenuModel* app_menu = NULL;
	GObject* _tmp8_ = NULL;
	GMenuModel* _tmp9_ = NULL;
	GMenuModel* acc_menu = NULL;
	GMenuModel* _tmp10_ = NULL;
	GMenuModel* _tmp11_ = NULL;
	GMenu* _tmp12_ = NULL;
	Twitter* _tmp13_ = NULL;
	Twitter* _tmp14_ = NULL;
	GSList* accounts = NULL;
	GSList* _tmp15_ = NULL;
	GSList* _tmp16_ = NULL;
	GMenuModel* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GMenu* _tmp36_ = NULL;
	GMenuModel* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar** _tmp39_ = NULL;
	gchar** _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	gchar* _tmp41_ = NULL;
	gchar** _tmp42_ = NULL;
	gchar** _tmp43_ = NULL;
	gint _tmp43__length1 = 0;
	gchar* _tmp44_ = NULL;
	gchar** _tmp45_ = NULL;
	gchar** _tmp46_ = NULL;
	gint _tmp46__length1 = 0;
	gchar* _tmp47_ = NULL;
	gchar** _tmp48_ = NULL;
	gchar** _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	gchar* _tmp50_ = NULL;
	gchar** _tmp51_ = NULL;
	gchar** _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	gchar* _tmp53_ = NULL;
	gchar** _tmp54_ = NULL;
	gchar** _tmp55_ = NULL;
	gint _tmp55__length1 = 0;
	gchar* _tmp56_ = NULL;
	gchar** _tmp57_ = NULL;
	gchar** _tmp58_ = NULL;
	gint _tmp58__length1 = 0;
	gchar* _tmp59_ = NULL;
	gchar** _tmp60_ = NULL;
	gchar** _tmp61_ = NULL;
	gint _tmp61__length1 = 0;
	gchar* _tmp62_ = NULL;
	gchar** _tmp63_ = NULL;
	gchar** _tmp64_ = NULL;
	gint _tmp64__length1 = 0;
	gchar* _tmp65_ = NULL;
	gchar** _tmp66_ = NULL;
	gchar** _tmp67_ = NULL;
	gint _tmp67__length1 = 0;
	gchar* _tmp68_ = NULL;
	gchar** _tmp69_ = NULL;
	gchar** _tmp70_ = NULL;
	gint _tmp70__length1 = 0;
	gchar* _tmp71_ = NULL;
	gchar** _tmp72_ = NULL;
	gchar** _tmp73_ = NULL;
	gint _tmp73__length1 = 0;
	gchar* _tmp74_ = NULL;
	gchar** _tmp75_ = NULL;
	gchar** _tmp76_ = NULL;
	gint _tmp76__length1 = 0;
	GtkSettings* gtk_s = NULL;
	GtkSettings* _tmp77_ = NULL;
	GtkSettings* _tmp78_ = NULL;
	gboolean _tmp79_ = FALSE;
	GtkSettings* _tmp81_ = NULL;
	gchar* _tmp82_ = NULL;
	gchar* _tmp83_ = NULL;
	gchar* _tmp84_ = NULL;
	gboolean _tmp85_ = FALSE;
	gboolean _tmp86_ = FALSE;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COREBIRD, Corebird);
	G_APPLICATION_CLASS (corebird_parent_class)->startup (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
	_tmp0_ = lazy_menu_button_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	dirs_create_dirs ();
	g_debug ("Corebird.vala:110: startup");
	_tmp2_ = dirs_config ("Corebird.db");
	_tmp3_ = _tmp2_;
	_tmp4_ = sql_database_new (_tmp3_, SQL_COREBIRD_INIT_FILE);
	_sql_database_unref0 (corebird_db);
	corebird_db = _tmp4_;
	_g_free0 (_tmp3_);
	setlocale (LC_ALL, LOCALEDIR);
	bindtextdomain (GETTEXT_PACKAGE, NULL);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp5_ = gtk_builder_new ();
	builder = _tmp5_;
	{
		gtk_builder_add_from_resource (builder, "/org/baedert/corebird/ui/menu.ui", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("Corebird.vala:125: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = gtk_builder_get_object (builder, "app-menu");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_menu_model_get_type (), GMenuModel));
	app_menu = _tmp9_;
	_tmp10_ = app_menu;
	_tmp11_ = g_menu_model_get_item_link (_tmp10_, 0, "section");
	acc_menu = _tmp11_;
	_tmp12_ = g_menu_new ();
	_g_object_unref0 (corebird_account_menu);
	corebird_account_menu = _tmp12_;
	utils_load_custom_css ();
	utils_load_custom_icons ();
	utils_init_soup_session ();
	_tmp13_ = twitter_get ();
	_tmp14_ = _tmp13_;
	twitter_init (_tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = account_list_accounts ();
	accounts = _tmp15_;
	_tmp16_ = accounts;
	{
		GSList* acc_collection = NULL;
		GSList* acc_it = NULL;
		acc_collection = _tmp16_;
		for (acc_it = acc_collection; acc_it != NULL; acc_it = acc_it->next) {
			Account* _tmp17_ = NULL;
			Account* acc = NULL;
			_tmp17_ = _g_object_ref0 ((Account*) acc_it->data);
			acc = _tmp17_;
			{
				Block1Data* _data1_;
				Account* _tmp18_ = NULL;
				GSimpleAction* show_win_action = NULL;
				Account* _tmp19_ = NULL;
				gint64 _tmp20_ = 0LL;
				gint64 _tmp21_ = 0LL;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				GSimpleAction* _tmp26_ = NULL;
				GSimpleAction* _tmp27_ = NULL;
				GSimpleAction* _tmp28_ = NULL;
				GSimpleAction* _tmp29_ = NULL;
				GMenuItem* mi = NULL;
				Account* _tmp30_ = NULL;
				GMenuItem* _tmp31_ = NULL;
				GMenu* _tmp32_ = NULL;
				GMenuItem* _tmp33_ = NULL;
				_data1_ = g_slice_new0 (Block1Data);
				_data1_->_ref_count_ = 1;
				_data1_->self = g_object_ref (self);
				_data1_->acc = acc;
				_tmp18_ = _data1_->acc;
				g_signal_connect_object (_tmp18_, "info-changed", (GCallback) _corebird_account_info_changed_account_info_changed, self, 0);
				_tmp19_ = _data1_->acc;
				_tmp20_ = account_get_id (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat ("show-", _tmp23_, NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_simple_action_new (_tmp25_, NULL);
				_tmp27_ = _tmp26_;
				_g_free0 (_tmp25_);
				_g_free0 (_tmp23_);
				show_win_action = _tmp27_;
				_tmp28_ = show_win_action;
				g_signal_connect_data (_tmp28_, "activate", (GCallback) _____lambda215__g_simple_action_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
				_tmp29_ = show_win_action;
				g_action_map_add_action (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, g_action_get_type (), GAction));
				_tmp30_ = _data1_->acc;
				_tmp31_ = corebird_create_accout_menu_item (self, _tmp30_);
				mi = _tmp31_;
				_tmp32_ = corebird_account_menu;
				_tmp33_ = mi;
				g_menu_append_item (_tmp32_, _tmp33_);
				_g_object_unref0 (mi);
				_g_object_unref0 (show_win_action);
				block1_data_unref (_data1_);
				_data1_ = NULL;
			}
		}
	}
	_tmp34_ = acc_menu;
	_tmp35_ = _ ("Open Account");
	_tmp36_ = corebird_account_menu;
	g_menu_append_submenu (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_menu_get_type (), GMenu), _tmp35_, G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, g_menu_model_get_type (), GMenuModel));
	_tmp37_ = app_menu;
	gtk_application_set_app_menu (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp37_);
	_tmp38_ = settings_get_accel ("compose-tweet");
	_tmp39_ = g_new0 (gchar*, 1 + 1);
	_tmp39_[0] = _tmp38_;
	_tmp40_ = _tmp39_;
	_tmp40__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.compose-tweet", _tmp40_);
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
	_tmp41_ = settings_get_accel ("toggle-sidebar");
	_tmp42_ = g_new0 (gchar*, 1 + 1);
	_tmp42_[0] = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp43__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.toggle-sidebar", _tmp43_);
	_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
	_tmp44_ = g_strdup ("<Alt>1");
	_tmp45_ = g_new0 (gchar*, 1 + 1);
	_tmp45_[0] = _tmp44_;
	_tmp46_ = _tmp45_;
	_tmp46__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(0)", _tmp46_);
	_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_free), NULL);
	_tmp47_ = g_strdup ("<Alt>2");
	_tmp48_ = g_new0 (gchar*, 1 + 1);
	_tmp48_[0] = _tmp47_;
	_tmp49_ = _tmp48_;
	_tmp49__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(1)", _tmp49_);
	_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
	_tmp50_ = g_strdup ("<Alt>3");
	_tmp51_ = g_new0 (gchar*, 1 + 1);
	_tmp51_[0] = _tmp50_;
	_tmp52_ = _tmp51_;
	_tmp52__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(2)", _tmp52_);
	_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
	_tmp53_ = g_strdup ("<Alt>4");
	_tmp54_ = g_new0 (gchar*, 1 + 1);
	_tmp54_[0] = _tmp53_;
	_tmp55_ = _tmp54_;
	_tmp55__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(3)", _tmp55_);
	_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
	_tmp56_ = g_strdup ("<Alt>5");
	_tmp57_ = g_new0 (gchar*, 1 + 1);
	_tmp57_[0] = _tmp56_;
	_tmp58_ = _tmp57_;
	_tmp58__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(4)", _tmp58_);
	_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
	_tmp59_ = g_strdup ("<Alt>6");
	_tmp60_ = g_new0 (gchar*, 1 + 1);
	_tmp60_[0] = _tmp59_;
	_tmp61_ = _tmp60_;
	_tmp61__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(5)", _tmp61_);
	_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) g_free), NULL);
	_tmp62_ = g_strdup ("<Alt>7");
	_tmp63_ = g_new0 (gchar*, 1 + 1);
	_tmp63_[0] = _tmp62_;
	_tmp64_ = _tmp63_;
	_tmp64__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(6)", _tmp64_);
	_tmp64_ = (_vala_array_free (_tmp64_, _tmp64__length1, (GDestroyNotify) g_free), NULL);
	_tmp65_ = settings_get_accel ("show-settings");
	_tmp66_ = g_new0 (gchar*, 1 + 1);
	_tmp66_[0] = _tmp65_;
	_tmp67_ = _tmp66_;
	_tmp67__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "app.show-settings", _tmp67_);
	_tmp67_ = (_vala_array_free (_tmp67_, _tmp67__length1, (GDestroyNotify) g_free), NULL);
	_tmp68_ = g_strdup ("<Control>Q");
	_tmp69_ = g_new0 (gchar*, 1 + 1);
	_tmp69_[0] = _tmp68_;
	_tmp70_ = _tmp69_;
	_tmp70__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "app.quit", _tmp70_);
	_tmp70_ = (_vala_array_free (_tmp70_, _tmp70__length1, (GDestroyNotify) g_free), NULL);
	_tmp71_ = settings_get_accel ("show-account-dialog");
	_tmp72_ = g_new0 (gchar*, 1 + 1);
	_tmp72_[0] = _tmp71_;
	_tmp73_ = _tmp72_;
	_tmp73__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.show-account-dialog", _tmp73_);
	_tmp73_ = (_vala_array_free (_tmp73_, _tmp73__length1, (GDestroyNotify) g_free), NULL);
	_tmp74_ = settings_get_accel ("show-account-list");
	_tmp75_ = g_new0 (gchar*, 1 + 1);
	_tmp75_[0] = _tmp74_;
	_tmp76_ = _tmp75_;
	_tmp76__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.show-account-list", _tmp76_);
	_tmp76_ = (_vala_array_free (_tmp76_, _tmp76__length1, (GDestroyNotify) g_free), NULL);
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), COREBIRD_app_entries, G_N_ELEMENTS (COREBIRD_app_entries), self);
	_tmp77_ = gtk_settings_get_default ();
	_tmp78_ = _g_object_ref0 (_tmp77_);
	gtk_s = _tmp78_;
	_tmp79_ = settings_use_dark_theme ();
	if (_tmp79_) {
		GtkSettings* _tmp80_ = NULL;
		_tmp80_ = gtk_s;
		g_object_set (_tmp80_, "gtk-application-prefer-dark-theme", TRUE, NULL);
	}
	_tmp81_ = gtk_s;
	g_object_get (_tmp81_, "gtk-decoration-layout", &_tmp82_, NULL);
	_tmp83_ = _tmp82_;
	_tmp84_ = _tmp83_;
	_tmp85_ = string_contains (_tmp84_, "menu");
	_tmp86_ = _tmp85_;
	_g_free0 (_tmp84_);
	if (_tmp86_) {
		GtkSettings* _tmp87_ = NULL;
		GtkSettings* _tmp88_ = NULL;
		gchar* _tmp89_ = NULL;
		gchar* _tmp90_ = NULL;
		gchar* _tmp91_ = NULL;
		gchar* _tmp92_ = NULL;
		gchar* _tmp93_ = NULL;
		_tmp87_ = gtk_s;
		_tmp88_ = gtk_s;
		g_object_get (_tmp88_, "gtk-decoration-layout", &_tmp89_, NULL);
		_tmp90_ = _tmp89_;
		_tmp91_ = _tmp90_;
		_tmp92_ = string_replace (_tmp91_, "menu", "");
		_tmp93_ = _tmp92_;
		g_object_set (_tmp87_, "gtk-decoration-layout", _tmp93_, NULL);
		_g_free0 (_tmp93_);
		_g_free0 (_tmp91_);
	}
	_g_object_unref0 (gtk_s);
	_g_object_unref0 (acc_menu);
	_g_object_unref0 (app_menu);
	_g_object_unref0 (builder);
}


static void corebird_real_shutdown (GApplication* base) {
	Corebird * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COREBIRD, Corebird);
	G_APPLICATION_CLASS (corebird_parent_class)->shutdown (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
}


static GMenuItem* corebird_create_accout_menu_item (Corebird* self, Account* account) {
	GMenuItem* result = NULL;
	GMenuItem* mi = NULL;
	Account* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	Account* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GMenuItem* _tmp14_ = NULL;
	GMenuItem* _tmp15_ = NULL;
	Account* _tmp16_ = NULL;
	gint64 _tmp17_ = 0LL;
	gint64 _tmp18_ = 0LL;
	GVariant* _tmp19_ = NULL;
	GVariant* _tmp20_ = NULL;
	g_return_val_if_fail (IS_COREBIRD (self), NULL);
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_tmp0_ = account;
	_tmp1_ = account_get_screen_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_replace (_tmp2_, "_", "__");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("@", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = account;
	_tmp8_ = account_get_id (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat ("app.show-", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_menu_item_new (_tmp6_, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	mi = _tmp15_;
	_tmp16_ = account;
	_tmp17_ = account_get_id (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_variant_new_int64 (_tmp18_);
	g_variant_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	g_menu_item_set_attribute_value (mi, "user-id", _tmp20_);
	_g_variant_unref0 (_tmp20_);
	result = mi;
	return result;
}


static void corebird_account_info_changed (Corebird* self, Account* source, const gchar* screen_name, const gchar* s, GdkPixbuf* a, GdkPixbuf* b) {
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (IS_ACCOUNT (source));
	g_return_if_fail (screen_name != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (GDK_IS_PIXBUF (a));
	g_return_if_fail (GDK_IS_PIXBUF (b));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GMenu* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint64 item_id = 0LL;
				GMenu* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				const GVariantType* _tmp7_ = NULL;
				GVariant* _tmp8_ = NULL;
				GVariant* _tmp9_ = NULL;
				gint64 _tmp10_ = 0LL;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				Account* _tmp13_ = NULL;
				gint64 _tmp14_ = 0LL;
				gint64 _tmp15_ = 0LL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = corebird_account_menu;
				_tmp4_ = g_menu_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_menu_model_get_type (), GMenuModel));
				if (!(_tmp2_ < _tmp4_)) {
					break;
				}
				_tmp5_ = corebird_account_menu;
				_tmp6_ = i;
				_tmp7_ = G_VARIANT_TYPE_INT64;
				_tmp8_ = g_menu_model_get_item_attribute_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_menu_model_get_type (), GMenuModel), _tmp6_, "user-id", _tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_variant_get_int64 (_tmp9_);
				_tmp11_ = _tmp10_;
				_g_variant_unref0 (_tmp9_);
				item_id = _tmp11_;
				_tmp12_ = item_id;
				_tmp13_ = source;
				_tmp14_ = account_get_id (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp12_ == _tmp15_) {
					GMenuItem* new_menu_item = NULL;
					Account* _tmp16_ = NULL;
					GMenuItem* _tmp17_ = NULL;
					GMenu* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					GMenu* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					GMenuItem* _tmp22_ = NULL;
					_tmp16_ = source;
					_tmp17_ = corebird_create_accout_menu_item (self, _tmp16_);
					new_menu_item = _tmp17_;
					_tmp18_ = corebird_account_menu;
					_tmp19_ = i;
					g_menu_remove (_tmp18_, _tmp19_);
					_tmp20_ = corebird_account_menu;
					_tmp21_ = i;
					_tmp22_ = new_menu_item;
					g_menu_insert_item (_tmp20_, _tmp21_, _tmp22_);
					_g_object_unref0 (new_menu_item);
					return;
				}
			}
		}
	}
}


/**
   * Open startup windows.
   * Semantics: Open a window for every account in the startup-accounts array.
   * If that array is empty, look at all the account and if there is one, open that one.
   * If there is none, open a MainWindow with a null account.
   */
static void corebird_open_startup_windows (Corebird* self, const gchar* compose_screen_name) {
	const gchar* _tmp0_ = NULL;
	gchar** startup_accounts = NULL;
	GSettings* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gboolean _tmp17_ = FALSE;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	guint n_accounts = 0U;
	GSList* _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	gchar** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	g_return_if_fail (IS_COREBIRD (self));
	_tmp0_ = compose_screen_name;
	if (_tmp0_ != NULL) {
		Account* acc = NULL;
		const gchar* _tmp1_ = NULL;
		Account* _tmp2_ = NULL;
		Account* _tmp3_ = NULL;
		Account* _tmp4_ = NULL;
		Account* _tmp6_ = NULL;
		Account* _tmp7_ = NULL;
		ComposeTweetWindow* cw = NULL;
		Account* _tmp8_ = NULL;
		ComposeTweetWindow* _tmp9_ = NULL;
		ComposeTweetWindow* _tmp10_ = NULL;
		ComposeTweetWindow* _tmp11_ = NULL;
		_tmp1_ = compose_screen_name;
		_tmp2_ = account_query_account (_tmp1_);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		acc = _tmp3_;
		_tmp4_ = acc;
		if (_tmp4_ == NULL) {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = compose_screen_name;
			g_critical ("Corebird.vala:226: No account named `%s` is configured. Exiting.", _tmp5_);
			_g_object_unref0 (acc);
			return;
		}
		_tmp6_ = acc;
		account_init_proxy (_tmp6_, TRUE, FALSE);
		_tmp7_ = acc;
		account_query_user_info_by_screen_name (_tmp7_, NULL, NULL, NULL);
		_tmp8_ = acc;
		_tmp9_ = compose_tweet_window_new (NULL, _tmp8_, NULL, COMPOSE_TWEET_WINDOW_MODE_NORMAL, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
		g_object_ref_sink (_tmp9_);
		cw = _tmp9_;
		_tmp10_ = cw;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
		_tmp11_ = cw;
		gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_window_get_type (), GtkWindow));
		_g_object_unref0 (cw);
		_g_object_unref0 (acc);
		return;
	}
	_tmp12_ = settings_get ();
	_tmp13_ = _tmp12_;
	_tmp15_ = _tmp14_ = g_settings_get_strv (_tmp13_, "startup-accounts");
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _vala_array_length (_tmp14_);
	_g_object_unref0 (_tmp13_);
	startup_accounts = _tmp16_;
	startup_accounts_length1 = _tmp16__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp18_ = startup_accounts;
	_tmp18__length1 = startup_accounts_length1;
	if (_tmp18__length1 == 1) {
		gchar** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		const gchar* _tmp20_ = NULL;
		_tmp19_ = startup_accounts;
		_tmp19__length1 = startup_accounts_length1;
		_tmp20_ = _tmp19_[0];
		_tmp17_ = g_strcmp0 (_tmp20_, "") == 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		gint _tmp21_ = 0;
		_tmp21_ = 0;
		startup_accounts = g_renew (gchar*, startup_accounts, 0);
		(_tmp21_ > startup_accounts_length1) ? memset (startup_accounts + startup_accounts_length1, 0, sizeof (gchar*) * (_tmp21_ - startup_accounts_length1)) : NULL;
		startup_accounts_length1 = _tmp21_;
		_startup_accounts_size_ = _tmp21_;
	}
	_tmp22_ = account_list_accounts ();
	_tmp23_ = g_slist_length (_tmp22_);
	n_accounts = _tmp23_;
	_tmp24_ = startup_accounts;
	_tmp24__length1 = startup_accounts_length1;
	if (_tmp24__length1 == 0) {
		guint _tmp25_ = 0U;
		_tmp25_ = n_accounts;
		if (_tmp25_ == ((guint) 1)) {
			GSList* _tmp26_ = NULL;
			gconstpointer _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			_tmp26_ = account_list_accounts ();
			_tmp27_ = g_slist_nth_data (_tmp26_, (guint) 0);
			_tmp28_ = account_get_screen_name ((Account*) _tmp27_);
			_tmp29_ = _tmp28_;
			corebird_add_window_for_screen_name (self, _tmp29_);
		} else {
			guint _tmp30_ = 0U;
			_tmp30_ = n_accounts;
			if (_tmp30_ == ((guint) 0)) {
				MainWindow* window = NULL;
				MainWindow* _tmp31_ = NULL;
				MainWindow* _tmp32_ = NULL;
				MainWindow* _tmp33_ = NULL;
				_tmp31_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), NULL);
				g_object_ref_sink (_tmp31_);
				window = _tmp31_;
				_tmp32_ = window;
				gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_window_get_type (), GtkWindow));
				_tmp33_ = window;
				gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (window);
			} else {
				GSList* _tmp34_ = NULL;
				gconstpointer _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				_tmp34_ = account_list_accounts ();
				_tmp35_ = g_slist_nth_data (_tmp34_, (guint) 0);
				_tmp36_ = account_get_screen_name ((Account*) _tmp35_);
				_tmp37_ = _tmp36_;
				corebird_add_window_for_screen_name (self, _tmp37_);
			}
		}
	} else {
		gboolean opened_window = FALSE;
		gchar** _tmp38_ = NULL;
		gint _tmp38__length1 = 0;
		gboolean _tmp44_ = FALSE;
		opened_window = FALSE;
		_tmp38_ = startup_accounts;
		_tmp38__length1 = startup_accounts_length1;
		{
			gchar** account_collection = NULL;
			gint account_collection_length1 = 0;
			gint _account_collection_size_ = 0;
			gint account_it = 0;
			account_collection = _tmp38_;
			account_collection_length1 = _tmp38__length1;
			for (account_it = 0; account_it < _tmp38__length1; account_it = account_it + 1) {
				gchar* _tmp39_ = NULL;
				gchar* account = NULL;
				_tmp39_ = g_strdup (account_collection[account_it]);
				account = _tmp39_;
				{
					const gchar* _tmp40_ = NULL;
					gboolean _tmp41_ = FALSE;
					_tmp40_ = account;
					_tmp41_ = corebird_is_window_open_for_screen_name (self, _tmp40_, NULL);
					if (!_tmp41_) {
						const gchar* _tmp42_ = NULL;
						gboolean _tmp43_ = FALSE;
						_tmp42_ = account;
						_tmp43_ = corebird_add_window_for_screen_name (self, _tmp42_);
						if (_tmp43_) {
							opened_window = TRUE;
						}
					}
					_g_free0 (account);
				}
			}
		}
		_tmp44_ = opened_window;
		if (!_tmp44_) {
			guint _tmp45_ = 0U;
			GList* _tmp53_ = NULL;
			MainWindow* m = NULL;
			MainWindow* _tmp60_ = NULL;
			MainWindow* _tmp61_ = NULL;
			MainWindow* _tmp62_ = NULL;
			_tmp45_ = n_accounts;
			if (_tmp45_ > ((guint) 0)) {
				GSList* _tmp46_ = NULL;
				_tmp46_ = account_list_accounts ();
				{
					GSList* account_collection = NULL;
					GSList* account_it = NULL;
					account_collection = _tmp46_;
					for (account_it = account_collection; account_it != NULL; account_it = account_it->next) {
						Account* _tmp47_ = NULL;
						Account* account = NULL;
						_tmp47_ = _g_object_ref0 ((Account*) account_it->data);
						account = _tmp47_;
						{
							Account* _tmp48_ = NULL;
							gint64 _tmp49_ = 0LL;
							gint64 _tmp50_ = 0LL;
							gboolean _tmp51_ = FALSE;
							_tmp48_ = account;
							_tmp49_ = account_get_id (_tmp48_);
							_tmp50_ = _tmp49_;
							_tmp51_ = corebird_is_window_open_for_user_id (self, _tmp50_, NULL);
							if (!_tmp51_) {
								Account* _tmp52_ = NULL;
								_tmp52_ = account;
								corebird_add_window_for_account (self, _tmp52_);
								_g_object_unref0 (account);
								startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
								return;
							}
							_g_object_unref0 (account);
						}
					}
				}
			}
			_tmp53_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
			{
				GList* w_collection = NULL;
				GList* w_it = NULL;
				w_collection = _tmp53_;
				for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
					GtkWindow* _tmp54_ = NULL;
					GtkWindow* w = NULL;
					_tmp54_ = _g_object_ref0 ((GtkWindow*) w_it->data);
					w = _tmp54_;
					{
						GtkWindow* _tmp55_ = NULL;
						Account* _tmp56_ = NULL;
						Account* _tmp57_ = NULL;
						const gchar* _tmp58_ = NULL;
						const gchar* _tmp59_ = NULL;
						_tmp55_ = w;
						_tmp56_ = main_window_get_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, TYPE_MAIN_WINDOW, MainWindow));
						_tmp57_ = _tmp56_;
						_tmp58_ = account_get_screen_name (_tmp57_);
						_tmp59_ = _tmp58_;
						if (g_strcmp0 (_tmp59_, ACCOUNT_DUMMY) == 0) {
							_g_object_unref0 (w);
							startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
							return;
						}
						_g_object_unref0 (w);
					}
				}
			}
			_tmp60_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), NULL);
			g_object_ref_sink (_tmp60_);
			m = _tmp60_;
			_tmp61_ = m;
			gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_window_get_type (), GtkWindow));
			_tmp62_ = m;
			gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_widget_get_type (), GtkWidget));
			_g_object_unref0 (m);
		}
	}
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


/**
   * Adds a new MainWindow instance with the account that
   * has the given screen name.
   * Note that this only works if the account is already properly
   * set up and won't warn or fail if if isn't.
   *
   * @param screen_name The screen name of the account do add a
   *                    MainWindow for.
   *
   * @return true if a window has been opened, false otherwise
   */
gboolean corebird_add_window_for_screen_name (Corebird* self, const gchar* screen_name) {
	gboolean result = FALSE;
	GSList* accs = NULL;
	GSList* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_val_if_fail (IS_COREBIRD (self), FALSE);
	g_return_val_if_fail (screen_name != NULL, FALSE);
	_tmp0_ = account_list_accounts ();
	accs = _tmp0_;
	_tmp1_ = accs;
	{
		GSList* a_collection = NULL;
		GSList* a_it = NULL;
		a_collection = _tmp1_;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			Account* _tmp2_ = NULL;
			Account* a = NULL;
			_tmp2_ = _g_object_ref0 ((Account*) a_it->data);
			a = _tmp2_;
			{
				Account* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				_tmp3_ = a;
				_tmp4_ = account_get_screen_name (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = screen_name;
				if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
					Account* _tmp7_ = NULL;
					_tmp7_ = a;
					corebird_add_window_for_account (self, _tmp7_);
					result = TRUE;
					_g_object_unref0 (a);
					return result;
				}
				_g_object_unref0 (a);
			}
		}
	}
	_tmp8_ = screen_name;
	g_warning ("Corebird.vala:314: Could not add window for account '%s'", _tmp8_);
	result = FALSE;
	return result;
}


void corebird_add_window_for_account (Corebird* self, Account* account) {
	MainWindow* window = NULL;
	Account* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = account;
	_tmp1_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp0_);
	g_object_ref_sink (_tmp1_);
	window = _tmp1_;
	gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (window, gtk_window_get_type (), GtkWindow));
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (window, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (window);
}


/**
   * Checks if there's currently a MainWindow instance open that has a
   * reference to the account with the given screen name.
   * (This makes a linear search over all open windows, with a text comparison
   * in each iteration)
   *
   * @param screen_name The screen name to search for
   * @return TRUE if a window with the account associated to the given
   *         screen name is open, FALSE otherwise.
   */
gboolean corebird_is_window_open_for_screen_name (Corebird* self, const gchar* screen_name, MainWindow** window) {
	MainWindow* _vala_window = NULL;
	gboolean result = FALSE;
	GList* windows = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (IS_COREBIRD (self), FALSE);
	g_return_val_if_fail (screen_name != NULL, FALSE);
	_tmp0_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	windows = _tmp0_;
	_tmp1_ = windows;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp1_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* _tmp2_ = NULL;
			GtkWindow* win = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) win_it->data);
			win = _tmp2_;
			{
				GtkWindow* _tmp3_ = NULL;
				_tmp3_ = win;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW)) {
					GtkWindow* _tmp4_ = NULL;
					Account* _tmp5_ = NULL;
					Account* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					_tmp4_ = win;
					_tmp5_ = main_window_get_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MAIN_WINDOW, MainWindow));
					_tmp6_ = _tmp5_;
					_tmp7_ = account_get_screen_name (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = screen_name;
					if (g_strcmp0 (_tmp8_, _tmp9_) == 0) {
						GtkWindow* _tmp10_ = NULL;
						MainWindow* _tmp11_ = NULL;
						_tmp10_ = win;
						_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MAIN_WINDOW, MainWindow));
						_g_object_unref0 (_vala_window);
						_vala_window = _tmp11_;
						result = TRUE;
						_g_object_unref0 (win);
						if (window) {
							*window = _vala_window;
						} else {
							_g_object_unref0 (_vala_window);
						}
						return result;
					}
				}
				_g_object_unref0 (win);
			}
		}
	}
	_g_object_unref0 (_vala_window);
	_vala_window = NULL;
	result = FALSE;
	if (window) {
		*window = _vala_window;
	} else {
		_g_object_unref0 (_vala_window);
	}
	return result;
}


gboolean corebird_is_window_open_for_user_id (Corebird* self, gint64 user_id, MainWindow** window) {
	MainWindow* _vala_window = NULL;
	gboolean result = FALSE;
	GList* windows = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (IS_COREBIRD (self), FALSE);
	_tmp0_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	windows = _tmp0_;
	_tmp1_ = windows;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp1_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* _tmp2_ = NULL;
			GtkWindow* win = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) win_it->data);
			win = _tmp2_;
			{
				GtkWindow* _tmp3_ = NULL;
				_tmp3_ = win;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW)) {
					GtkWindow* _tmp4_ = NULL;
					Account* _tmp5_ = NULL;
					Account* _tmp6_ = NULL;
					gint64 _tmp7_ = 0LL;
					gint64 _tmp8_ = 0LL;
					gint64 _tmp9_ = 0LL;
					_tmp4_ = win;
					_tmp5_ = main_window_get_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MAIN_WINDOW, MainWindow));
					_tmp6_ = _tmp5_;
					_tmp7_ = account_get_id (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = user_id;
					if (_tmp8_ == _tmp9_) {
						GtkWindow* _tmp10_ = NULL;
						MainWindow* _tmp11_ = NULL;
						_tmp10_ = win;
						_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MAIN_WINDOW, MainWindow));
						_g_object_unref0 (_vala_window);
						_vala_window = _tmp11_;
						result = TRUE;
						_g_object_unref0 (win);
						if (window) {
							*window = _vala_window;
						} else {
							_g_object_unref0 (_vala_window);
						}
						return result;
					}
				}
				_g_object_unref0 (win);
			}
		}
	}
	_g_object_unref0 (_vala_window);
	_vala_window = NULL;
	result = FALSE;
	if (window) {
		*window = _vala_window;
	} else {
		_g_object_unref0 (_vala_window);
	}
	return result;
}


/**
   * Quits the application, saving all open windows and their geometries.
   */
static void corebird_quit_application (Corebird* self) {
	GList* windows = NULL;
	GList* _tmp0_ = NULL;
	gchar** startup_accounts = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gboolean _tmp6_ = FALSE;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar** account_names = NULL;
	GList* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	gchar** _tmp14_ = NULL;
	gint account_names_length1 = 0;
	gint _account_names_size_ = 0;
	gint index = 0;
	GList* _tmp15_ = NULL;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	GSettings* _tmp34_ = NULL;
	GSettings* _tmp35_ = NULL;
	gchar** _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	g_return_if_fail (IS_COREBIRD (self));
	_tmp0_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	windows = _tmp0_;
	_tmp1_ = settings_get ();
	_tmp2_ = _tmp1_;
	_tmp4_ = _tmp3_ = g_settings_get_strv (_tmp2_, "startup-accounts");
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	_g_object_unref0 (_tmp2_);
	startup_accounts = _tmp5_;
	startup_accounts_length1 = _tmp5__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp7_ = startup_accounts;
	_tmp7__length1 = startup_accounts_length1;
	if (_tmp7__length1 == 1) {
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = startup_accounts;
		_tmp8__length1 = startup_accounts_length1;
		_tmp9_ = _tmp8_[0];
		_tmp6_ = g_strcmp0 (_tmp9_, "") == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gint _tmp10_ = 0;
		_tmp10_ = 0;
		startup_accounts = g_renew (gchar*, startup_accounts, 0);
		(_tmp10_ > startup_accounts_length1) ? memset (startup_accounts + startup_accounts_length1, 0, sizeof (gchar*) * (_tmp10_ - startup_accounts_length1)) : NULL;
		startup_accounts_length1 = _tmp10_;
		_startup_accounts_size_ = _tmp10_;
	}
	_tmp11_ = startup_accounts;
	_tmp11__length1 = startup_accounts_length1;
	if (_tmp11__length1 != 0) {
		g_application_quit (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
		startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp12_ = windows;
	_tmp13_ = g_list_length (_tmp12_);
	_tmp14_ = g_new0 (gchar*, _tmp13_ + 1);
	account_names = _tmp14_;
	account_names_length1 = _tmp13_;
	_account_names_size_ = account_names_length1;
	index = 0;
	_tmp15_ = windows;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp15_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* win = NULL;
			win = (GtkWindow*) win_it->data;
			{
				GtkWindow* _tmp16_ = NULL;
				MainWindow* mw = NULL;
				GtkWindow* _tmp17_ = NULL;
				MainWindow* _tmp18_ = NULL;
				gchar* screen_name = NULL;
				MainWindow* _tmp19_ = NULL;
				Account* _tmp20_ = NULL;
				Account* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				MainWindow* _tmp25_ = NULL;
				gchar** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				const gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				_tmp16_ = win;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, TYPE_MAIN_WINDOW)) {
					continue;
				}
				_tmp17_ = win;
				_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MAIN_WINDOW, MainWindow));
				mw = _tmp18_;
				_tmp19_ = mw;
				_tmp20_ = main_window_get_account (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = account_get_screen_name (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strdup (_tmp23_);
				screen_name = _tmp24_;
				_tmp25_ = mw;
				main_window_save_geometry (_tmp25_);
				_tmp26_ = account_names;
				_tmp26__length1 = account_names_length1;
				_tmp27_ = index;
				_tmp28_ = screen_name;
				_tmp29_ = g_strdup (_tmp28_);
				_g_free0 (_tmp26_[_tmp27_]);
				_tmp26_[_tmp27_] = _tmp29_;
				_tmp30_ = _tmp26_[_tmp27_];
				_tmp31_ = index;
				index = _tmp31_ + 1;
				_g_free0 (screen_name);
				_g_object_unref0 (mw);
			}
		}
	}
	_tmp32_ = index;
	_tmp33_ = _tmp32_ + 1;
	account_names = g_renew (gchar*, account_names, _tmp32_ + 1);
	(_tmp33_ > account_names_length1) ? memset (account_names + account_names_length1, 0, sizeof (gchar*) * (_tmp33_ - account_names_length1)) : NULL;
	account_names_length1 = _tmp33_;
	_account_names_size_ = _tmp33_;
	_tmp34_ = settings_get ();
	_tmp35_ = _tmp34_;
	_tmp36_ = account_names;
	_tmp36__length1 = account_names_length1;
	g_settings_set_strv (_tmp35_, "startup-accounts", _tmp36_);
	_g_object_unref0 (_tmp35_);
	g_application_quit (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
	account_names = (_vala_array_free (account_names, account_names_length1, (GDestroyNotify) g_free), NULL);
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


/********************************************************/
static void corebird_show_dm_thread (Corebird* self, GSimpleAction* a, GVariant* value) {
	gint64 account_id = 0LL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 sender_id = 0LL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	MainWindow* main_window = NULL;
	gint64 _tmp10_ = 0LL;
	MainWindow* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = value;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_int64 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp2_);
	account_id = _tmp4_;
	_tmp5_ = value;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_get_int64 (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp7_);
	sender_id = _tmp9_;
	_tmp10_ = account_id;
	_tmp12_ = corebird_is_window_open_for_user_id (self, _tmp10_, &_tmp11_);
	_g_object_unref0 (main_window);
	main_window = _tmp11_;
	if (_tmp12_) {
		Bundle* bundle = NULL;
		Bundle* _tmp13_ = NULL;
		Bundle* _tmp14_ = NULL;
		gint64 _tmp15_ = 0LL;
		MainWindow* _tmp16_ = NULL;
		MainWidget* _tmp17_ = NULL;
		Bundle* _tmp18_ = NULL;
		MainWindow* _tmp19_ = NULL;
		_tmp13_ = bundle_new ();
		bundle = _tmp13_;
		_tmp14_ = bundle;
		_tmp15_ = sender_id;
		bundle_put_int64 (_tmp14_, "sender_id", _tmp15_);
		_tmp16_ = main_window;
		_tmp17_ = _tmp16_->main_widget;
		_tmp18_ = bundle;
		main_widget_switch_page (_tmp17_, (gint) PAGE_DM, _tmp18_);
		_tmp19_ = main_window;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_window_get_type (), GtkWindow));
		_g_object_unref0 (bundle);
	} else {
		gint64 _tmp20_ = 0LL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_tmp20_ = account_id;
		_tmp21_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp20_);
		_tmp22_ = _tmp21_;
		g_warning ("Corebird.vala:409: Window for Account %s is not open, abort.", _tmp22_);
		_g_free0 (_tmp22_);
	}
	_g_object_unref0 (main_window);
}


static void corebird_mark_seen (Corebird* self, GSimpleAction* a, GVariant* value) {
	gchar* screen_name = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint64 tweet_id = 0LL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	MainWindow* main_window = NULL;
	const gchar* _tmp11_ = NULL;
	MainWindow* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = value;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_string (_tmp2_, NULL);
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp2_);
	screen_name = _tmp5_;
	_tmp6_ = value;
	_tmp7_ = g_variant_get_child_value (_tmp6_, (gsize) 1);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_variant_get_int64 (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_variant_unref0 (_tmp8_);
	tweet_id = _tmp10_;
	_tmp11_ = screen_name;
	_tmp13_ = corebird_is_window_open_for_screen_name (self, _tmp11_, &_tmp12_);
	_g_object_unref0 (main_window);
	main_window = _tmp12_;
	if (_tmp13_) {
		g_message ("Corebird.vala:417: Mark as read...");
	} else {
		const gchar* _tmp14_ = NULL;
		_tmp14_ = screen_name;
		g_warning ("Corebird.vala:419: No window for Account %s found", _tmp14_);
	}
	_g_object_unref0 (main_window);
	_g_free0 (screen_name);
}


static void corebird_show_window (Corebird* self, GSimpleAction* a, GVariant* value) {
	gint64 user_id = 0LL;
	GVariant* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	MainWindow* main_window = NULL;
	gint64 _tmp2_ = 0LL;
	MainWindow* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = value;
	_tmp1_ = g_variant_get_int64 (_tmp0_);
	user_id = _tmp1_;
	_tmp2_ = user_id;
	_tmp4_ = corebird_is_window_open_for_user_id (self, _tmp2_, &_tmp3_);
	_g_object_unref0 (main_window);
	main_window = _tmp3_;
	if (_tmp4_) {
		MainWindow* _tmp5_ = NULL;
		_tmp5_ = main_window;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow));
	} else {
		g_warning ("Corebird.vala:428: TODO: Implement");
	}
	_g_object_unref0 (main_window);
}


static void g_cclosure_user_marshal_VOID__INT64_INT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT64_INT64) (gpointer data1, gint64 arg_1, gint64 arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT64_INT64 callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT64_INT64) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int64 (param_values + 1), g_value_get_int64 (param_values + 2), data2);
}


static void corebird_class_init (CorebirdClass * klass) {
	corebird_parent_class = g_type_class_peek_parent (klass);
	((GApplicationClass *) klass)->command_line = corebird_real_command_line;
	((GApplicationClass *) klass)->activate = corebird_real_activate;
	((GApplicationClass *) klass)->startup = corebird_real_startup;
	((GApplicationClass *) klass)->shutdown = corebird_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = corebird_finalize;
	g_signal_new ("account_added", TYPE_COREBIRD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_ACCOUNT);
	g_signal_new ("account_removed", TYPE_COREBIRD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_ACCOUNT);
	g_signal_new ("account_window_changed", TYPE_COREBIRD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT64_INT64, G_TYPE_NONE, 2, G_TYPE_INT64, G_TYPE_INT64);
}


static void corebird_instance_init (Corebird * self) {
}


static void corebird_finalize (GObject* obj) {
	Corebird * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COREBIRD, Corebird);
	G_OBJECT_CLASS (corebird_parent_class)->finalize (obj);
}


GType corebird_get_type (void) {
	static volatile gsize corebird_type_id__volatile = 0;
	if (g_once_init_enter (&corebird_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CorebirdClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) corebird_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Corebird), 0, (GInstanceInitFunc) corebird_instance_init, NULL };
		GType corebird_type_id;
		corebird_type_id = g_type_register_static (gtk_application_get_type (), "Corebird", &g_define_type_info, 0);
		g_once_init_leave (&corebird_type_id__volatile, corebird_type_id);
	}
	return corebird_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



