/* DeltaUpdater.c generated by valac 0.26.2, the Vala compiler
 * generated from DeltaUpdater.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gtk/gtk.h>


#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;
typedef struct _DeltaUpdaterPrivate DeltaUpdaterPrivate;

#define TYPE_WEAK_REF (weak_ref_get_type ())
#define WEAK_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WEAK_REF, WeakRef))
#define WEAK_REF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WEAK_REF, WeakRefClass))
#define IS_WEAK_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WEAK_REF))
#define IS_WEAK_REF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WEAK_REF))
#define WEAK_REF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WEAK_REF, WeakRefClass))

typedef struct _WeakRef WeakRef;
typedef struct _WeakRefClass WeakRefClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _DeltaUpdater {
	GObject parent_instance;
	DeltaUpdaterPrivate * priv;
};

struct _DeltaUpdaterClass {
	GObjectClass parent_class;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
	gboolean (*get_seen) (ITwitterItem* self);
	void (*set_seen) (ITwitterItem* self, gboolean value);
};

struct _DeltaUpdaterPrivate {
	GeeArrayList* minutely;
	GeeArrayList* hourly;
	guint minutely_id;
	guint hourly_id;
};


static gpointer delta_updater_parent_class = NULL;

GType delta_updater_get_type (void) G_GNUC_CONST;
GType weak_ref_get_type (void) G_GNUC_CONST;
GType itwitter_item_get_type (void) G_GNUC_CONST;
#define DELTA_UPDATER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DELTA_UPDATER, DeltaUpdaterPrivate))
enum  {
	DELTA_UPDATER_DUMMY_PROPERTY
};
DeltaUpdater* delta_updater_new (void);
DeltaUpdater* delta_updater_construct (GType object_type);
static gboolean __lambda45_ (DeltaUpdater* self);
gpointer weak_ref_get (WeakRef* self);
gint itwitter_item_update_time_delta (ITwitterItem* self, GDateTime* now);
static gboolean ___lambda45__gsource_func (gpointer self);
static gboolean __lambda46_ (DeltaUpdater* self);
static gboolean ___lambda46__gsource_func (gpointer self);
void delta_updater_add (DeltaUpdater* self, ITwitterItem* entry);
gint64 itwitter_item_get_sort_factor (ITwitterItem* self);
WeakRef* weak_ref_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer obj);
WeakRef* weak_ref_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer obj);
static void delta_updater_finalize (GObject* obj);


static gboolean __lambda45_ (DeltaUpdater* self) {
	gboolean result = FALSE;
	{
		gint i = 0;
		gint size = 0;
		GeeArrayList* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		i = 0;
		_tmp0_ = self->priv->minutely;
		_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp2_ = _tmp1_;
		size = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				WeakRef* item_ref = NULL;
				GeeArrayList* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gpointer _tmp9_ = NULL;
				ITwitterItem* item = NULL;
				GeeArrayList* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gpointer _tmp12_ = NULL;
				WeakRef* _tmp13_ = NULL;
				gpointer _tmp14_ = NULL;
				ITwitterItem* _tmp15_ = NULL;
				ITwitterItem* _tmp16_ = NULL;
				gint seconds = 0;
				ITwitterItem* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->minutely;
				_tmp8_ = i;
				_tmp9_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp8_);
				item_ref = (WeakRef*) _tmp9_;
				_tmp10_ = self->priv->minutely;
				_tmp11_ = i;
				_tmp12_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp11_);
				_tmp13_ = (WeakRef*) _tmp12_;
				_tmp14_ = weak_ref_get (_tmp13_);
				_tmp15_ = (ITwitterItem*) _tmp14_;
				_g_object_unref0 (_tmp13_);
				item = _tmp15_;
				_tmp16_ = item;
				if (_tmp16_ == NULL) {
					GeeArrayList* _tmp17_ = NULL;
					WeakRef* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					_tmp17_ = self->priv->minutely;
					_tmp18_ = item_ref;
					gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp18_);
					_tmp19_ = size;
					size = _tmp19_ - 1;
					_g_object_unref0 (item);
					_g_object_unref0 (item_ref);
					continue;
				}
				_tmp20_ = item;
				_tmp21_ = itwitter_item_update_time_delta (_tmp20_, NULL);
				seconds = _tmp21_;
				_tmp22_ = seconds;
				if (_tmp22_ >= 3600) {
					GeeArrayList* _tmp23_ = NULL;
					WeakRef* _tmp24_ = NULL;
					GeeArrayList* _tmp25_ = NULL;
					WeakRef* _tmp26_ = NULL;
					gint _tmp27_ = 0;
					_tmp23_ = self->priv->minutely;
					_tmp24_ = item_ref;
					gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp24_);
					_tmp25_ = self->priv->hourly;
					_tmp26_ = item_ref;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp26_);
					_tmp27_ = size;
					size = _tmp27_ - 1;
				}
				_g_object_unref0 (item);
				_g_object_unref0 (item_ref);
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean ___lambda45__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda45_ ((DeltaUpdater*) self);
	return result;
}


static gboolean __lambda46_ (DeltaUpdater* self) {
	gboolean result = FALSE;
	{
		gint i = 0;
		gint size = 0;
		GeeArrayList* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		i = 0;
		_tmp0_ = self->priv->hourly;
		_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp2_ = _tmp1_;
		size = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				WeakRef* item_ref = NULL;
				GeeArrayList* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gpointer _tmp9_ = NULL;
				WeakRef* _tmp10_ = NULL;
				gpointer _tmp11_ = NULL;
				ITwitterItem* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				WeakRef* _tmp17_ = NULL;
				gpointer _tmp18_ = NULL;
				ITwitterItem* _tmp19_ = NULL;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->hourly;
				_tmp8_ = i;
				_tmp9_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp8_);
				item_ref = (WeakRef*) _tmp9_;
				_tmp10_ = item_ref;
				_tmp11_ = weak_ref_get (_tmp10_);
				_tmp12_ = (ITwitterItem*) _tmp11_;
				_tmp13_ = _tmp12_ == NULL;
				_g_object_unref0 (_tmp12_);
				if (_tmp13_) {
					GeeArrayList* _tmp14_ = NULL;
					WeakRef* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					_tmp14_ = self->priv->hourly;
					_tmp15_ = item_ref;
					gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
					_tmp16_ = size;
					size = _tmp16_ - 1;
					_g_object_unref0 (item_ref);
					continue;
				}
				_tmp17_ = item_ref;
				_tmp18_ = weak_ref_get (_tmp17_);
				_tmp19_ = (ITwitterItem*) _tmp18_;
				itwitter_item_update_time_delta (_tmp19_, NULL);
				_g_object_unref0 (_tmp19_);
				_g_object_unref0 (item_ref);
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean ___lambda46__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda46_ ((DeltaUpdater*) self);
	return result;
}


DeltaUpdater* delta_updater_construct (GType object_type) {
	DeltaUpdater * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	self = (DeltaUpdater*) g_object_new (object_type, NULL);
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (60 * 1000), ___lambda45__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->minutely_id = _tmp0_;
	_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((60 * 60) * 1000), ___lambda46__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->hourly_id = _tmp1_;
	return self;
}


DeltaUpdater* delta_updater_new (void) {
	return delta_updater_construct (TYPE_DELTA_UPDATER);
}


void delta_updater_add (DeltaUpdater* self, ITwitterItem* entry) {
	GDateTime* now = NULL;
	GDateTime* _tmp0_ = NULL;
	GTimeSpan diff = 0LL;
	GDateTime* _tmp1_ = NULL;
	ITwitterItem* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	GDateTime* _tmp5_ = NULL;
	GDateTime* _tmp6_ = NULL;
	GTimeSpan _tmp7_ = 0LL;
	GTimeSpan _tmp8_ = 0LL;
	gint seconds = 0;
	GTimeSpan _tmp9_ = 0LL;
	WeakRef* r = NULL;
	ITwitterItem* _tmp10_ = NULL;
	WeakRef* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	g_return_if_fail (IS_DELTA_UPDATER (self));
	g_return_if_fail (IS_ITWITTER_ITEM (entry));
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = now;
	_tmp2_ = entry;
	_tmp3_ = itwitter_item_get_sort_factor (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_date_time_new_from_unix_local (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_date_time_difference (_tmp1_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_date_time_unref0 (_tmp6_);
	diff = _tmp8_;
	_tmp9_ = diff;
	seconds = (gint) ((_tmp9_ / 1000.0) / 1000.0);
	_tmp10_ = entry;
	_tmp11_ = weak_ref_new (TYPE_ITWITTER_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp10_);
	r = _tmp11_;
	_tmp12_ = seconds;
	if (_tmp12_ < 3600) {
		GeeArrayList* _tmp13_ = NULL;
		WeakRef* _tmp14_ = NULL;
		_tmp13_ = self->priv->minutely;
		_tmp14_ = r;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp14_);
	} else {
		gint _tmp15_ = 0;
		_tmp15_ = seconds;
		if (_tmp15_ < ((60 * 60) * 24)) {
			GeeArrayList* _tmp16_ = NULL;
			WeakRef* _tmp17_ = NULL;
			_tmp16_ = self->priv->hourly;
			_tmp17_ = r;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
		}
	}
	_g_object_unref0 (r);
	_g_date_time_unref0 (now);
}


static void delta_updater_class_init (DeltaUpdaterClass * klass) {
	delta_updater_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DeltaUpdaterPrivate));
	G_OBJECT_CLASS (klass)->finalize = delta_updater_finalize;
}


static void delta_updater_instance_init (DeltaUpdater * self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	self->priv = DELTA_UPDATER_GET_PRIVATE (self);
	_tmp0_ = gee_array_list_new (TYPE_WEAK_REF, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->minutely = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_WEAK_REF, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->hourly = _tmp1_;
}


static void delta_updater_finalize (GObject* obj) {
	DeltaUpdater * self;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DELTA_UPDATER, DeltaUpdater);
	_tmp0_ = self->priv->minutely_id;
	g_source_remove (_tmp0_);
	_tmp1_ = self->priv->hourly_id;
	g_source_remove (_tmp1_);
	_g_object_unref0 (self->priv->minutely);
	_g_object_unref0 (self->priv->hourly);
	G_OBJECT_CLASS (delta_updater_parent_class)->finalize (obj);
}


GType delta_updater_get_type (void) {
	static volatile gsize delta_updater_type_id__volatile = 0;
	if (g_once_init_enter (&delta_updater_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DeltaUpdaterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) delta_updater_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DeltaUpdater), 0, (GInstanceInitFunc) delta_updater_instance_init, NULL };
		GType delta_updater_type_id;
		delta_updater_type_id = g_type_register_static (G_TYPE_OBJECT, "DeltaUpdater", &g_define_type_info, 0);
		g_once_init_leave (&delta_updater_type_id__volatile, delta_updater_type_id);
	}
	return delta_updater_type_id__volatile;
}



