/* FilterPage.c generated by valac 0.26.2, the Vala compiler
 * generated from FilterPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>


#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_FILTER_PAGE (filter_page_get_type ())
#define FILTER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER_PAGE, FilterPage))
#define FILTER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER_PAGE, FilterPageClass))
#define IS_FILTER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER_PAGE))
#define IS_FILTER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER_PAGE))
#define FILTER_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER_PAGE, FilterPageClass))

typedef struct _FilterPage FilterPage;
typedef struct _FilterPageClass FilterPageClass;
typedef struct _FilterPagePrivate FilterPagePrivate;

#define TYPE_BADGE_RADIO_TOOL_BUTTON (badge_radio_tool_button_get_type ())
#define BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButton))
#define BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))
#define IS_BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define IS_BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define BADGE_RADIO_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))

typedef struct _BadgeRadioToolButton BadgeRadioToolButton;
typedef struct _BadgeRadioToolButtonClass BadgeRadioToolButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ADD_LIST_ENTRY (add_list_entry_get_type ())
#define ADD_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_LIST_ENTRY, AddListEntry))
#define ADD_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_LIST_ENTRY, AddListEntryClass))
#define IS_ADD_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_LIST_ENTRY))
#define IS_ADD_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_LIST_ENTRY))
#define ADD_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_LIST_ENTRY, AddListEntryClass))

typedef struct _AddListEntry AddListEntry;
typedef struct _AddListEntryClass AddListEntryClass;

#define TYPE_MODIFY_FILTER_DIALOG (modify_filter_dialog_get_type ())
#define MODIFY_FILTER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFY_FILTER_DIALOG, ModifyFilterDialog))
#define MODIFY_FILTER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFY_FILTER_DIALOG, ModifyFilterDialogClass))
#define IS_MODIFY_FILTER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFY_FILTER_DIALOG))
#define IS_MODIFY_FILTER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFY_FILTER_DIALOG))
#define MODIFY_FILTER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFY_FILTER_DIALOG, ModifyFilterDialogClass))

typedef struct _ModifyFilterDialog ModifyFilterDialog;
typedef struct _ModifyFilterDialogClass ModifyFilterDialogClass;

#define TYPE_FILTER (filter_get_type ())
#define FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER, Filter))
#define FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER, FilterClass))
#define IS_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER))
#define IS_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER))
#define FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER, FilterClass))

typedef struct _Filter Filter;
typedef struct _FilterClass FilterClass;

#define TYPE_FILTER_LIST_ENTRY (filter_list_entry_get_type ())
#define FILTER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER_LIST_ENTRY, FilterListEntry))
#define FILTER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER_LIST_ENTRY, FilterListEntryClass))
#define IS_FILTER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER_LIST_ENTRY))
#define IS_FILTER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER_LIST_ENTRY))
#define FILTER_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER_LIST_ENTRY, FilterListEntryClass))

typedef struct _FilterListEntry FilterListEntry;
typedef struct _FilterListEntryClass FilterListEntryClass;
typedef struct _AccountPrivate AccountPrivate;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_USER_FILTER_ENTRY (user_filter_entry_get_type ())
#define USER_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_FILTER_ENTRY, UserFilterEntry))
#define USER_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_FILTER_ENTRY, UserFilterEntryClass))
#define IS_USER_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_FILTER_ENTRY))
#define IS_USER_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_FILTER_ENTRY))
#define USER_FILTER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_FILTER_ENTRY, UserFilterEntryClass))

typedef struct _UserFilterEntry UserFilterEntry;
typedef struct _UserFilterEntryClass UserFilterEntryClass;
typedef struct _Block38Data Block38Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _FilterPage {
	GtkScrolledWindow parent_instance;
	FilterPagePrivate * priv;
};

struct _FilterPageClass {
	GtkScrolledWindowClass parent_class;
};

struct _FilterPagePrivate {
	gint _id;
	MainWindow* _main_window;
	Account* _account;
	BadgeRadioToolButton* tool_button;
	GtkListBox* filter_list;
	GtkListBox* user_list;
	GtkLabel* user_list_label;
	GtkFrame* user_list_frame;
	gboolean filters_loaded;
	gboolean users_loaded;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GeeArrayList* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block38Data {
	int _ref_count_;
	FilterPage* self;
	RestProxyCall* call;
};


static gpointer filter_page_parent_class = NULL;
static IPageIface* filter_page_ipage_parent_iface = NULL;
static IMessageReceiverIface* filter_page_imessage_receiver_parent_iface = NULL;

GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType filter_page_get_type (void) G_GNUC_CONST;
GType badge_radio_tool_button_get_type (void) G_GNUC_CONST;
#define FILTER_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FILTER_PAGE, FilterPagePrivate))
enum  {
	FILTER_PAGE_DUMMY_PROPERTY,
	FILTER_PAGE_ID,
	FILTER_PAGE_MAIN_WINDOW,
	FILTER_PAGE_ACCOUNT
};
FilterPage* filter_page_new (gint id);
FilterPage* filter_page_construct (GType object_type, gint id);
void ipage_set_id (IPage* self, gint value);
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
AddListEntry* add_list_entry_new (const gchar* label);
AddListEntry* add_list_entry_construct (GType object_type, const gchar* label);
GType add_list_entry_get_type (void) G_GNUC_CONST;
static void __lambda145_ (FilterPage* self, GtkListBoxRow* row);
GType modify_filter_dialog_get_type (void) G_GNUC_CONST;
MainWindow* ipage_get_main_window (IPage* self);
Account* ipage_get_account (IPage* self);
GType filter_get_type (void) G_GNUC_CONST;
ModifyFilterDialog* modify_filter_dialog_new (MainWindow* parent, Account* account, Filter* filter);
ModifyFilterDialog* modify_filter_dialog_construct (GType object_type, MainWindow* parent, Account* account, Filter* filter);
static void filter_page_filter_added_cb (FilterPage* self, Filter* f, gboolean created);
static void _filter_page_filter_added_cb_modify_filter_dialog_filter_added (ModifyFilterDialog* _sender, Filter* filter, gboolean created, gpointer self);
GType filter_list_entry_get_type (void) G_GNUC_CONST;
Filter* filter_list_entry_get_filter (FilterListEntry* self);
static void ___lambda145__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void filter_page_real_on_join (IPage* base, gint page_id, Bundle* args);
FilterListEntry* filter_list_entry_new (Filter* f, Account* account, MainWindow* main_window);
FilterListEntry* filter_list_entry_construct (GType object_type, Filter* f, Account* account, MainWindow* main_window);
OAuthProxy* account_get_proxy (Account* self);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_);
static void __lambda147_ (FilterPage* self, GObject* _, GAsyncResult* res);
static void __lambda148_ (FilterPage* self, JsonArray* arr, guint index, JsonNode* node);
static void filter_page_add_user (FilterPage* self, JsonObject* user_obj);
static void ___lambda148__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void _vala_JsonNode_free (JsonNode* self);
static void ___lambda147__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gint filter_get_id (Filter* self);
const gchar* filter_get_content (Filter* self);
void filter_list_entry_set_content (FilterListEntry* self, const gchar* value);
static void filter_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root_node);
static void filter_page_remove_user (FilterPage* self, gint64 id);
GType user_filter_entry_get_type (void) G_GNUC_CONST;
UserFilterEntry* user_filter_entry_new (void);
UserFilterEntry* user_filter_entry_construct (GType object_type);
void user_filter_entry_set_user_id (UserFilterEntry* self, gint64 value);
void user_filter_entry_set_name (UserFilterEntry* self, const gchar* value);
void user_filter_entry_set_screen_name (UserFilterEntry* self, const gchar* value);
void user_filter_entry_set_avatar (UserFilterEntry* self, const gchar* value);
static void __lambda151_ (FilterPage* self, gint64 id);
static void filter_page_unblock_user (FilterPage* self, gint64 id);
static void ___lambda151__user_filter_entry_deleted (UserFilterEntry* _sender, gint64 id, gpointer self);
gint64 user_filter_entry_get_user_id (UserFilterEntry* self);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static void __lambda152_ (Block38Data* _data38_, GObject* o, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
static void ___lambda152__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean filter_page_filter_list_keynav_failed_cb (FilterPage* self, GtkDirectionType direction);
static gboolean _filter_page_filter_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self);
static gboolean filter_page_user_list_keynav_failed_cb (FilterPage* self, GtkDirectionType direction);
static gboolean _filter_page_user_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self);
static void filter_page_real_on_leave (IPage* base);
static void filter_page_real_create_tool_button (IPage* base, GtkRadioButton* group);
BadgeRadioToolButton* badge_radio_tool_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioToolButton* badge_radio_tool_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
static GtkRadioButton* filter_page_real_get_tool_button (IPage* base);
static gchar* filter_page_real_get_title (IPage* base);
static void filter_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_filter_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_main_window (IPage* self, MainWindow* value);
void ipage_set_account (IPage* self, Account* value);
static void _vala_filter_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	default_header_func (row, before);
}


static void _filter_page_filter_added_cb_modify_filter_dialog_filter_added (ModifyFilterDialog* _sender, Filter* filter, gboolean created, gpointer self) {
	filter_page_filter_added_cb ((FilterPage*) self, filter, created);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda145_ (FilterPage* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_ADD_LIST_ENTRY)) {
		ModifyFilterDialog* dialog = NULL;
		MainWindow* _tmp1_ = NULL;
		MainWindow* _tmp2_ = NULL;
		Account* _tmp3_ = NULL;
		Account* _tmp4_ = NULL;
		ModifyFilterDialog* _tmp5_ = NULL;
		ModifyFilterDialog* _tmp6_ = NULL;
		ModifyFilterDialog* _tmp7_ = NULL;
		_tmp1_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp2_ = _tmp1_;
		_tmp3_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp4_ = _tmp3_;
		_tmp5_ = modify_filter_dialog_new (_tmp2_, _tmp4_, NULL);
		g_object_ref_sink (_tmp5_);
		dialog = _tmp5_;
		_tmp6_ = dialog;
		g_signal_connect_object (_tmp6_, "filter-added", (GCallback) _filter_page_filter_added_cb_modify_filter_dialog_filter_added, self, 0);
		_tmp7_ = dialog;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (dialog);
	} else {
		GtkListBoxRow* _tmp8_ = NULL;
		_tmp8_ = row;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_FILTER_LIST_ENTRY)) {
			FilterListEntry* filter_row = NULL;
			GtkListBoxRow* _tmp9_ = NULL;
			FilterListEntry* _tmp10_ = NULL;
			ModifyFilterDialog* dialog = NULL;
			MainWindow* _tmp11_ = NULL;
			MainWindow* _tmp12_ = NULL;
			Account* _tmp13_ = NULL;
			Account* _tmp14_ = NULL;
			FilterListEntry* _tmp15_ = NULL;
			Filter* _tmp16_ = NULL;
			Filter* _tmp17_ = NULL;
			ModifyFilterDialog* _tmp18_ = NULL;
			ModifyFilterDialog* _tmp19_ = NULL;
			ModifyFilterDialog* _tmp20_ = NULL;
			_tmp9_ = row;
			_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_FILTER_LIST_ENTRY, FilterListEntry));
			filter_row = _tmp10_;
			_tmp11_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp12_ = _tmp11_;
			_tmp13_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp14_ = _tmp13_;
			_tmp15_ = filter_row;
			_tmp16_ = filter_list_entry_get_filter (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = modify_filter_dialog_new (_tmp12_, _tmp14_, _tmp17_);
			g_object_ref_sink (_tmp18_);
			dialog = _tmp18_;
			_tmp19_ = dialog;
			g_signal_connect_object (_tmp19_, "filter-added", (GCallback) _filter_page_filter_added_cb_modify_filter_dialog_filter_added, self, 0);
			_tmp20_ = dialog;
			gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
			_g_object_unref0 (dialog);
			_g_object_unref0 (filter_row);
		}
	}
}


static void ___lambda145__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda145_ ((FilterPage*) self, row);
}


FilterPage* filter_page_construct (GType object_type, gint id) {
	FilterPage * self = NULL;
	gint _tmp0_ = 0;
	GtkListBox* _tmp1_ = NULL;
	GtkListBox* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	AddListEntry* _tmp4_ = NULL;
	AddListEntry* _tmp5_ = NULL;
	GtkListBox* _tmp6_ = NULL;
	GtkListBox* _tmp7_ = NULL;
	self = (FilterPage*) g_object_new (object_type, NULL);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = self->priv->filter_list;
	gtk_list_box_set_header_func (_tmp1_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp2_ = self->priv->filter_list;
	_tmp3_ = _ ("Add new Filter");
	_tmp4_ = add_list_entry_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->filter_list;
	g_signal_connect_object (_tmp6_, "row-activated", (GCallback) ___lambda145__gtk_list_box_row_activated, self, 0);
	_tmp7_ = self->priv->user_list;
	gtk_list_box_set_header_func (_tmp7_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	return self;
}


FilterPage* filter_page_new (gint id) {
	return filter_page_construct (TYPE_FILTER_PAGE, id);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void __lambda148_ (FilterPage* self, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	obj = _tmp2_;
	filter_page_add_user (self, obj);
	_json_object_unref0 (obj);
}


static void ___lambda148__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda148_ ((FilterPage*) self, array, index_, element_node);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void __lambda147_ (FilterPage* self, GObject* _, GAsyncResult* res) {
	JsonNode* root = NULL;
	GAsyncResult* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonArray* users = NULL;
	JsonNode* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonArray* _tmp4_ = NULL;
	JsonArray* _tmp5_ = NULL;
	guint n_users = 0U;
	JsonArray* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	JsonArray* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_);
	root = _tmp1_;
	_tmp2_ = root;
	_tmp3_ = json_node_get_object (_tmp2_);
	_tmp4_ = json_object_get_array_member (_tmp3_, "users");
	_tmp5_ = _json_array_ref0 (_tmp4_);
	users = _tmp5_;
	_tmp6_ = users;
	_tmp7_ = json_array_get_length (_tmp6_);
	n_users = _tmp7_;
	_tmp8_ = users;
	json_array_foreach_element (_tmp8_, ___lambda148__json_array_foreach, self);
	_tmp9_ = n_users;
	if (_tmp9_ > ((guint) 0)) {
		GtkFrame* _tmp10_ = NULL;
		GtkLabel* _tmp11_ = NULL;
		_tmp10_ = self->priv->user_list_frame;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
		_tmp11_ = self->priv->user_list_label;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	}
	_json_array_unref0 (users);
	__vala_JsonNode_free0 (root);
}


static void ___lambda147__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda147_ ((FilterPage*) self, source_object, res);
	g_object_unref (self);
}


static void filter_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	FilterPage * self;
	gboolean _tmp0_ = FALSE;
	GNetworkMonitor* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	RestProxyCall* call = NULL;
	Account* _tmp25_ = NULL;
	Account* _tmp26_ = NULL;
	OAuthProxy* _tmp27_ = NULL;
	OAuthProxy* _tmp28_ = NULL;
	RestProxyCall* _tmp29_ = NULL;
	RestProxyCall* _tmp30_ = NULL;
	RestProxyCall* _tmp31_ = NULL;
	RestProxyCall* _tmp32_ = NULL;
	RestProxyCall* _tmp33_ = NULL;
	RestProxyCall* _tmp34_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp0_ = self->priv->filters_loaded;
	if (!_tmp0_) {
		{
			GeeArrayList* _f_list = NULL;
			Account* _tmp1_ = NULL;
			Account* _tmp2_ = NULL;
			GeeArrayList* _tmp3_ = NULL;
			GeeArrayList* _tmp4_ = NULL;
			gint _f_size = 0;
			GeeArrayList* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _f_index = 0;
			_tmp1_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp2_ = _tmp1_;
			_tmp3_ = _tmp2_->filters;
			_tmp4_ = _g_object_ref0 (_tmp3_);
			_f_list = _tmp4_;
			_tmp5_ = _f_list;
			_tmp6_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp7_ = _tmp6_;
			_f_size = _tmp7_;
			_f_index = -1;
			while (TRUE) {
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				Filter* f = NULL;
				GeeArrayList* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gpointer _tmp13_ = NULL;
				FilterListEntry* entry = NULL;
				Filter* _tmp14_ = NULL;
				Account* _tmp15_ = NULL;
				Account* _tmp16_ = NULL;
				MainWindow* _tmp17_ = NULL;
				MainWindow* _tmp18_ = NULL;
				FilterListEntry* _tmp19_ = NULL;
				GtkListBox* _tmp20_ = NULL;
				FilterListEntry* _tmp21_ = NULL;
				_tmp8_ = _f_index;
				_f_index = _tmp8_ + 1;
				_tmp9_ = _f_index;
				_tmp10_ = _f_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _f_list;
				_tmp12_ = _f_index;
				_tmp13_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp12_);
				f = (Filter*) _tmp13_;
				_tmp14_ = f;
				_tmp15_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
				_tmp16_ = _tmp15_;
				_tmp17_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
				_tmp18_ = _tmp17_;
				_tmp19_ = filter_list_entry_new (_tmp14_, _tmp16_, _tmp18_);
				g_object_ref_sink (_tmp19_);
				entry = _tmp19_;
				_tmp20_ = self->priv->filter_list;
				_tmp21_ = entry;
				gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (entry);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_list);
		}
		self->priv->filters_loaded = TRUE;
	}
	_tmp22_ = g_network_monitor_get_default ();
	_tmp23_ = g_network_monitor_get_network_available (_tmp22_);
	if (!_tmp23_) {
		return;
	}
	_tmp24_ = self->priv->users_loaded;
	if (_tmp24_) {
		return;
	}
	_tmp25_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp26_ = _tmp25_;
	_tmp27_ = account_get_proxy (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, rest_proxy_get_type (), RestProxy));
	call = _tmp29_;
	_tmp30_ = call;
	rest_proxy_call_set_function (_tmp30_, "1.1/blocks/list.json");
	_tmp31_ = call;
	rest_proxy_call_set_method (_tmp31_, "GET");
	_tmp32_ = call;
	rest_proxy_call_add_param (_tmp32_, "include_entities", "false");
	_tmp33_ = call;
	rest_proxy_call_add_param (_tmp33_, "skip_status", "true");
	_tmp34_ = call;
	tweet_utils_load_threaded (_tmp34_, ___lambda147__gasync_ready_callback, g_object_ref (self));
	self->priv->users_loaded = TRUE;
	_g_object_unref0 (call);
}


/**
   * Called when the user adds a new Filter via the AddFilterDialog
   *
   **/
static void filter_page_filter_added_cb (FilterPage* self, Filter* f, gboolean created) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_FILTER_PAGE (self));
	g_return_if_fail (IS_FILTER (f));
	_tmp0_ = created;
	if (_tmp0_) {
		FilterListEntry* entry = NULL;
		Filter* _tmp1_ = NULL;
		Account* _tmp2_ = NULL;
		Account* _tmp3_ = NULL;
		MainWindow* _tmp4_ = NULL;
		MainWindow* _tmp5_ = NULL;
		FilterListEntry* _tmp6_ = NULL;
		GtkListBox* _tmp7_ = NULL;
		FilterListEntry* _tmp8_ = NULL;
		_tmp1_ = f;
		_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp3_ = _tmp2_;
		_tmp4_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp5_ = _tmp4_;
		_tmp6_ = filter_list_entry_new (_tmp1_, _tmp3_, _tmp5_);
		g_object_ref_sink (_tmp6_);
		entry = _tmp6_;
		_tmp7_ = self->priv->filter_list;
		_tmp8_ = entry;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (entry);
	} else {
		GList* children = NULL;
		GtkListBox* _tmp9_ = NULL;
		GList* _tmp10_ = NULL;
		GList* _tmp11_ = NULL;
		_tmp9_ = self->priv->filter_list;
		_tmp10_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_container_get_type (), GtkContainer));
		children = _tmp10_;
		_tmp11_ = children;
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp11_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp12_ = NULL;
				GtkWidget* w = NULL;
				_tmp12_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp12_;
				{
					GtkWidget* _tmp13_ = NULL;
					FilterListEntry* le = NULL;
					GtkWidget* _tmp14_ = NULL;
					FilterListEntry* _tmp15_ = NULL;
					FilterListEntry* _tmp16_ = NULL;
					Filter* _tmp17_ = NULL;
					Filter* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					Filter* _tmp21_ = NULL;
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					_tmp13_ = w;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, TYPE_FILTER_LIST_ENTRY)) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp14_ = w;
					_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_FILTER_LIST_ENTRY, FilterListEntry));
					le = _tmp15_;
					_tmp16_ = le;
					_tmp17_ = filter_list_entry_get_filter (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = filter_get_id (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = f;
					_tmp22_ = filter_get_id (_tmp21_);
					_tmp23_ = _tmp22_;
					if (_tmp20_ == _tmp23_) {
						FilterListEntry* _tmp24_ = NULL;
						Filter* _tmp25_ = NULL;
						const gchar* _tmp26_ = NULL;
						const gchar* _tmp27_ = NULL;
						_tmp24_ = le;
						_tmp25_ = f;
						_tmp26_ = filter_get_content (_tmp25_);
						_tmp27_ = _tmp26_;
						filter_list_entry_set_content (_tmp24_, _tmp27_);
						_g_object_unref0 (le);
						_g_object_unref0 (w);
						break;
					}
					_g_object_unref0 (le);
					_g_object_unref0 (w);
				}
			}
		}
		_g_list_free0 (children);
	}
}


static void filter_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root_node) {
	FilterPage * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	g_return_if_fail (root_node != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_EVENT_BLOCK) {
		JsonObject* obj = NULL;
		JsonNode* _tmp1_ = NULL;
		JsonObject* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_ = NULL;
		JsonObject* _tmp5_ = NULL;
		_tmp1_ = root_node;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = json_object_get_object_member (_tmp2_, "target");
		_tmp4_ = _json_object_ref0 (_tmp3_);
		obj = _tmp4_;
		_tmp5_ = obj;
		filter_page_add_user (self, _tmp5_);
		_json_object_unref0 (obj);
	} else {
		StreamMessageType _tmp6_ = 0;
		_tmp6_ = type;
		if (_tmp6_ == STREAM_MESSAGE_TYPE_EVENT_UNBLOCK) {
			JsonObject* obj = NULL;
			JsonNode* _tmp7_ = NULL;
			JsonObject* _tmp8_ = NULL;
			JsonObject* _tmp9_ = NULL;
			JsonObject* _tmp10_ = NULL;
			gint64 user_id = 0LL;
			JsonObject* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			gint64 _tmp13_ = 0LL;
			_tmp7_ = root_node;
			_tmp8_ = json_node_get_object (_tmp7_);
			_tmp9_ = json_object_get_object_member (_tmp8_, "target");
			_tmp10_ = _json_object_ref0 (_tmp9_);
			obj = _tmp10_;
			_tmp11_ = obj;
			_tmp12_ = json_object_get_int_member (_tmp11_, "id");
			user_id = _tmp12_;
			_tmp13_ = user_id;
			filter_page_remove_user (self, _tmp13_);
			_json_object_unref0 (obj);
		}
	}
}


static void __lambda151_ (FilterPage* self, gint64 id) {
	gint64 _tmp0_ = 0LL;
	_tmp0_ = id;
	filter_page_unblock_user (self, _tmp0_);
}


static void ___lambda151__user_filter_entry_deleted (UserFilterEntry* _sender, gint64 id, gpointer self) {
	__lambda151_ ((FilterPage*) self, id);
}


static void filter_page_add_user (FilterPage* self, JsonObject* user_obj) {
	gint64 id = 0LL;
	JsonObject* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	UserFilterEntry* entry = NULL;
	UserFilterEntry* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	JsonObject* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	JsonObject* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkListBox* _tmp9_ = NULL;
	GtkFrame* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	g_return_if_fail (IS_FILTER_PAGE (self));
	g_return_if_fail (user_obj != NULL);
	_tmp0_ = user_obj;
	_tmp1_ = json_object_get_int_member (_tmp0_, "id");
	id = _tmp1_;
	filter_page_remove_user (self, id);
	_tmp2_ = user_filter_entry_new ();
	g_object_ref_sink (_tmp2_);
	entry = _tmp2_;
	user_filter_entry_set_user_id (entry, id);
	_tmp3_ = user_obj;
	_tmp4_ = json_object_get_string_member (_tmp3_, "name");
	user_filter_entry_set_name (entry, _tmp4_);
	_tmp5_ = user_obj;
	_tmp6_ = json_object_get_string_member (_tmp5_, "screen_name");
	user_filter_entry_set_screen_name (entry, _tmp6_);
	_tmp7_ = user_obj;
	_tmp8_ = json_object_get_string_member (_tmp7_, "profile_image_url");
	user_filter_entry_set_avatar (entry, _tmp8_);
	g_signal_connect_object (entry, "deleted", (GCallback) ___lambda151__user_filter_entry_deleted, self, 0);
	_tmp9_ = self->priv->user_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = self->priv->user_list_frame;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	_tmp11_ = self->priv->user_list_label;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (entry);
}


static void filter_page_remove_user (FilterPage* self, gint64 id) {
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GtkListBox* _tmp10_ = NULL;
	GList* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	gboolean _tmp14_ = FALSE;
	g_return_if_fail (IS_FILTER_PAGE (self));
	_tmp0_ = self->priv->user_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp1_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp2_ = NULL;
			GtkWidget* w = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp2_;
			{
				GtkWidget* _tmp3_ = NULL;
				GtkWidget* _tmp4_ = NULL;
				gint64 _tmp5_ = 0LL;
				gint64 _tmp6_ = 0LL;
				gint64 _tmp7_ = 0LL;
				_tmp3_ = w;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_USER_FILTER_ENTRY)) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp4_ = w;
				_tmp5_ = user_filter_entry_get_user_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_USER_FILTER_ENTRY, UserFilterEntry));
				_tmp6_ = _tmp5_;
				_tmp7_ = id;
				if (_tmp6_ == _tmp7_) {
					GtkListBox* _tmp8_ = NULL;
					GtkWidget* _tmp9_ = NULL;
					_tmp8_ = self->priv->user_list;
					_tmp9_ = w;
					gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_container_get_type (), GtkContainer), _tmp9_);
				}
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
	_tmp10_ = self->priv->user_list;
	_tmp11_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_container_get_type (), GtkContainer));
	_tmp12_ = _tmp11_;
	_tmp13_ = g_list_length (_tmp12_);
	_tmp14_ = _tmp13_ == ((guint) 0);
	_g_list_free0 (_tmp12_);
	if (_tmp14_) {
		GtkFrame* _tmp15_ = NULL;
		GtkLabel* _tmp16_ = NULL;
		_tmp15_ = self->priv->user_list_frame;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
		_tmp16_ = self->priv->user_list_label;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
	}
}


static Block38Data* block38_data_ref (Block38Data* _data38_) {
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}


static void block38_data_unref (void * _userdata_) {
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		FilterPage* self;
		self = _data38_->self;
		_g_object_unref0 (_data38_->call);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}


static void __lambda152_ (Block38Data* _data38_, GObject* o, GAsyncResult* res) {
	FilterPage* self;
	GError * _inner_error_ = NULL;
	self = _data38_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data38_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch43_g_error;
		}
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data38_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		utils_show_error_object (_tmp1_, _tmp3_, 171, "FilterPage.vala");
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("FilterPage.vala:172: %s", _tmp5_);
		_g_error_free0 (e);
		return;
	}
	__finally43:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda152__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda152_ (self, source_object, res);
	block38_data_unref (self);
}


static void filter_page_unblock_user (FilterPage* self, gint64 id) {
	Block38Data* _data38_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	OAuthProxy* _tmp2_ = NULL;
	OAuthProxy* _tmp3_ = NULL;
	RestProxyCall* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	g_return_if_fail (IS_FILTER_PAGE (self));
	_data38_ = g_slice_new0 (Block38Data);
	_data38_->_ref_count_ = 1;
	_data38_->self = g_object_ref (self);
	_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = account_get_proxy (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, rest_proxy_get_type (), RestProxy));
	_data38_->call = _tmp4_;
	rest_proxy_call_set_method (_data38_->call, "POST");
	rest_proxy_call_set_function (_data38_->call, "1.1/blocks/destroy.json");
	rest_proxy_call_add_param (_data38_->call, "include_entities", "false");
	rest_proxy_call_add_param (_data38_->call, "skip_status", "true");
	_tmp5_ = id;
	_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
	_tmp7_ = _tmp6_;
	rest_proxy_call_add_param (_data38_->call, "user_id", _tmp7_);
	_g_free0 (_tmp7_);
	rest_proxy_call_invoke_async (_data38_->call, NULL, ___lambda152__gasync_ready_callback, block38_data_ref (_data38_));
	_tmp8_ = id;
	filter_page_remove_user (self, _tmp8_);
	block38_data_unref (_data38_);
	_data38_ = NULL;
}


static gboolean filter_page_filter_list_keynav_failed_cb (FilterPage* self, GtkDirectionType direction) {
	gboolean result = FALSE;
	GtkDirectionType _tmp0_ = 0;
	g_return_val_if_fail (IS_FILTER_PAGE (self), FALSE);
	_tmp0_ = direction;
	if (_tmp0_ == GTK_DIR_DOWN) {
		GtkListBox* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->user_list;
		_tmp2_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			GtkListBox* _tmp4_ = NULL;
			GtkDirectionType _tmp5_ = 0;
			_tmp4_ = self->priv->user_list;
			_tmp5_ = direction;
			gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp5_);
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean _filter_page_filter_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self) {
	gboolean result;
	result = filter_page_filter_list_keynav_failed_cb ((FilterPage*) self, direction);
	return result;
}


static gboolean filter_page_user_list_keynav_failed_cb (FilterPage* self, GtkDirectionType direction) {
	gboolean result = FALSE;
	GtkDirectionType _tmp0_ = 0;
	g_return_val_if_fail (IS_FILTER_PAGE (self), FALSE);
	_tmp0_ = direction;
	if (_tmp0_ == GTK_DIR_UP) {
		GtkListBox* _tmp1_ = NULL;
		GtkDirectionType _tmp2_ = 0;
		_tmp1_ = self->priv->filter_list;
		_tmp2_ = direction;
		gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), _tmp2_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean _filter_page_user_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self) {
	gboolean result;
	result = filter_page_user_list_keynav_failed_cb ((FilterPage*) self, direction);
	return result;
}


static void filter_page_real_on_leave (IPage* base) {
	FilterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
}


static void filter_page_real_create_tool_button (IPage* base, GtkRadioButton* group) {
	FilterPage * self;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	BadgeRadioToolButton* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = _ ("Filters");
	_tmp2_ = badge_radio_tool_button_new (_tmp0_, "corebird-filter-symbolic", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->tool_button);
	self->priv->tool_button = _tmp2_;
}


static GtkRadioButton* filter_page_real_get_tool_button (IPage* base) {
	FilterPage * self;
	GtkRadioButton* result = NULL;
	BadgeRadioToolButton* _tmp0_ = NULL;
	GtkRadioButton* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = self->priv->tool_button;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton));
	result = _tmp1_;
	return result;
}


static gchar* filter_page_real_get_title (IPage* base) {
	FilterPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = _ ("Filters");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gint filter_page_real_get_id (IPage* base) {
	gint result;
	FilterPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void filter_page_real_set_id (IPage* base, gint value) {
	FilterPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static MainWindow* filter_page_real_get_main_window (IPage* base) {
	MainWindow* result;
	FilterPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


static void filter_page_real_set_main_window (IPage* base, MainWindow* value) {
	FilterPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = value;
	self->priv->_main_window = _tmp0_;
	g_object_notify ((GObject *) self, "main-window");
}


static Account* filter_page_real_get_account (IPage* base) {
	Account* result;
	FilterPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void filter_page_real_set_account (IPage* base, Account* value) {
	FilterPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = value;
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


static void filter_page_class_init (FilterPageClass * klass) {
	gint FilterPage_private_offset;
	filter_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FilterPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_filter_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_filter_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = filter_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILTER_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILTER_PAGE_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILTER_PAGE_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	FilterPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/filter-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "filter_list", FALSE, FilterPage_private_offset + G_STRUCT_OFFSET (FilterPagePrivate, filter_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list", FALSE, FilterPage_private_offset + G_STRUCT_OFFSET (FilterPagePrivate, user_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list_label", FALSE, FilterPage_private_offset + G_STRUCT_OFFSET (FilterPagePrivate, user_list_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list_frame", FALSE, FilterPage_private_offset + G_STRUCT_OFFSET (FilterPagePrivate, user_list_frame));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "filter_list_keynav_failed_cb", G_CALLBACK(_filter_page_filter_list_keynav_failed_cb_gtk_widget_keynav_failed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "user_list_keynav_failed_cb", G_CALLBACK(_filter_page_user_list_keynav_failed_cb_gtk_widget_keynav_failed));
}


static void filter_page_ipage_interface_init (IPageIface * iface) {
	filter_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) filter_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) filter_page_real_on_leave;
	iface->create_tool_button = (void (*)(IPage*, GtkRadioButton*)) filter_page_real_create_tool_button;
	iface->get_tool_button = (GtkRadioButton* (*)(IPage*)) filter_page_real_get_tool_button;
	iface->get_title = (gchar* (*)(IPage*)) filter_page_real_get_title;
	iface->get_id = filter_page_real_get_id;
	iface->set_id = filter_page_real_set_id;
	iface->get_main_window = filter_page_real_get_main_window;
	iface->set_main_window = filter_page_real_set_main_window;
	iface->get_account = filter_page_real_get_account;
	iface->set_account = filter_page_real_set_account;
}


static void filter_page_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	filter_page_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) filter_page_real_stream_message_received;
}


static void filter_page_instance_init (FilterPage * self) {
	self->priv = FILTER_PAGE_GET_PRIVATE (self);
	self->priv->filters_loaded = FALSE;
	self->priv->users_loaded = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void filter_page_finalize (GObject* obj) {
	FilterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILTER_PAGE, FilterPage);
	_g_object_unref0 (self->priv->tool_button);
	_g_object_unref0 (self->priv->filter_list);
	_g_object_unref0 (self->priv->user_list);
	_g_object_unref0 (self->priv->user_list_label);
	_g_object_unref0 (self->priv->user_list_frame);
	G_OBJECT_CLASS (filter_page_parent_class)->finalize (obj);
}


GType filter_page_get_type (void) {
	static volatile gsize filter_page_type_id__volatile = 0;
	if (g_once_init_enter (&filter_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FilterPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) filter_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilterPage), 0, (GInstanceInitFunc) filter_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) filter_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) filter_page_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType filter_page_type_id;
		filter_page_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "FilterPage", &g_define_type_info, 0);
		g_type_add_interface_static (filter_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (filter_page_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&filter_page_type_id__volatile, filter_page_type_id);
	}
	return filter_page_type_id__volatile;
}


static void _vala_filter_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FilterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILTER_PAGE, FilterPage);
	switch (property_id) {
		case FILTER_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case FILTER_PAGE_MAIN_WINDOW:
		g_value_set_object (value, ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case FILTER_PAGE_ACCOUNT:
		g_value_set_object (value, ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_filter_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FilterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILTER_PAGE, FilterPage);
	switch (property_id) {
		case FILTER_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case FILTER_PAGE_MAIN_WINDOW:
		ipage_set_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case FILTER_PAGE_ACCOUNT:
		ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



