/* UserCounter.c generated by valac 0.26.2, the Vala compiler
 * generated from UserCounter.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
  So, this is the plan:
  we wil just save every single time the user encounters another user.
  We then save the first 200 or so results and load them on startup.
  If the user types a name and no result is found, we try to search
  for that name via Twitter's search API.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define TYPE_USER_INFO (user_info_get_type ())
#define USER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INFO, UserInfo))
#define USER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INFO, UserInfoClass))
#define IS_USER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INFO))
#define IS_USER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INFO))
#define USER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INFO, UserInfoClass))

typedef struct _UserInfo UserInfo;
typedef struct _UserInfoClass UserInfoClass;
typedef struct _UserInfoPrivate UserInfoPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_USER_COUNTER (user_counter_get_type ())
#define USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COUNTER, UserCounter))
#define USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COUNTER, UserCounterClass))
#define IS_USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COUNTER))
#define IS_USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COUNTER))
#define USER_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COUNTER, UserCounterClass))

typedef struct _UserCounter UserCounter;
typedef struct _UserCounterClass UserCounterClass;
typedef struct _UserCounterPrivate UserCounterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
#define _sql_select_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_select_statement_unref (var), NULL)))

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;
#define _sql_insert_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_insert_statement_unref (var), NULL)))

struct _UserInfo {
	GObject parent_instance;
	UserInfoPrivate * priv;
	gint64 id;
	gchar* screen_name;
	gchar* name;
	gint score;
	gboolean changed;
};

struct _UserInfoClass {
	GObjectClass parent_class;
};

struct _UserCounter {
	GObject parent_instance;
	UserCounterPrivate * priv;
};

struct _UserCounterClass {
	GObjectClass parent_class;
};

struct _UserCounterPrivate {
	gboolean changed;
	GeeArrayList* names;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);

static gpointer user_info_parent_class = NULL;
static gpointer user_counter_parent_class = NULL;

GType user_info_get_type (void) G_GNUC_CONST;
enum  {
	USER_INFO_DUMMY_PROPERTY
};
UserInfo* user_info_new (void);
UserInfo* user_info_construct (GType object_type);
static void user_info_finalize (GObject* obj);
GType user_counter_get_type (void) G_GNUC_CONST;
#define USER_COUNTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_COUNTER, UserCounterPrivate))
enum  {
	USER_COUNTER_DUMMY_PROPERTY
};
UserCounter* user_counter_new (void);
UserCounter* user_counter_construct (GType object_type);
void user_counter_user_seen (UserCounter* self, gint64 id, const gchar* screen_name, const gchar* name);
UserInfo** user_counter_query_by_prefix (UserCounter* self, const gchar* prefix, gint max_results, gint* num_results, int* result_length1);
gpointer sql_database_ref (gpointer instance);
void sql_database_unref (gpointer instance);
GParamSpec* sql_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_database (GValue* value, gpointer v_object);
void sql_value_take_database (GValue* value, gpointer v_object);
gpointer sql_value_get_database (const GValue* value);
GType sql_database_get_type (void) G_GNUC_CONST;
void user_counter_load (UserCounter* self, SqlDatabase* db);
gpointer sql_select_statement_ref (gpointer instance);
void sql_select_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_select_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_select_statement (GValue* value, gpointer v_object);
void sql_value_take_select_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_select_statement (const GValue* value);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean __lambda13_ (UserCounter* self, gchar** vals, int vals_length1);
static gboolean ___lambda13__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
gint user_counter_save (UserCounter* self, SqlDatabase* db);
void sql_database_begin_transaction (SqlDatabase* self);
gpointer sql_insert_statement_ref (gpointer instance);
void sql_insert_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_insert_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_insert_statement (GValue* value, gpointer v_object);
void sql_value_take_insert_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_insert_statement (const GValue* value);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_replace (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_vali64 (SqlInsertStatement* self, const gchar* col_name, gint64 col_value);
SqlInsertStatement* sql_insert_statement_vali (SqlInsertStatement* self, const gchar* col_name, gint col_value);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
void sql_database_end_transaction (SqlDatabase* self);
static void user_counter_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


UserInfo* user_info_construct (GType object_type) {
	UserInfo * self = NULL;
	self = (UserInfo*) g_object_new (object_type, NULL);
	return self;
}


UserInfo* user_info_new (void) {
	return user_info_construct (TYPE_USER_INFO);
}


static void user_info_class_init (UserInfoClass * klass) {
	user_info_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = user_info_finalize;
}


static void user_info_instance_init (UserInfo * self) {
}


static void user_info_finalize (GObject* obj) {
	UserInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_INFO, UserInfo);
	_g_free0 (self->screen_name);
	_g_free0 (self->name);
	G_OBJECT_CLASS (user_info_parent_class)->finalize (obj);
}


GType user_info_get_type (void) {
	static volatile gsize user_info_type_id__volatile = 0;
	if (g_once_init_enter (&user_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserInfo), 0, (GInstanceInitFunc) user_info_instance_init, NULL };
		GType user_info_type_id;
		user_info_type_id = g_type_register_static (G_TYPE_OBJECT, "UserInfo", &g_define_type_info, 0);
		g_once_init_leave (&user_info_type_id__volatile, user_info_type_id);
	}
	return user_info_type_id__volatile;
}


UserCounter* user_counter_construct (GType object_type) {
	UserCounter * self = NULL;
	self = (UserCounter*) g_object_new (object_type, NULL);
	return self;
}


UserCounter* user_counter_new (void) {
	return user_counter_construct (TYPE_USER_COUNTER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void user_counter_user_seen (UserCounter* self, gint64 id, const gchar* screen_name, const gchar* name) {
	gboolean found = FALSE;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (IS_USER_COUNTER (self));
	g_return_if_fail (screen_name != NULL);
	g_return_if_fail (name != NULL);
	found = FALSE;
	self->priv->changed = TRUE;
	{
		GeeArrayList* _ui_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _ui_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _ui_index = 0;
		_tmp0_ = self->priv->names;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_ui_list = _tmp1_;
		_tmp2_ = _ui_list;
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_ui_size = _tmp4_;
		_ui_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			UserInfo* ui = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			UserInfo* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			gint64 _tmp13_ = 0LL;
			_tmp5_ = _ui_index;
			_ui_index = _tmp5_ + 1;
			_tmp6_ = _ui_index;
			_tmp7_ = _ui_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _ui_list;
			_tmp9_ = _ui_index;
			_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp9_);
			ui = (UserInfo*) _tmp10_;
			_tmp11_ = ui;
			_tmp12_ = _tmp11_->id;
			_tmp13_ = id;
			if (_tmp12_ == _tmp13_) {
				UserInfo* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				UserInfo* _tmp16_ = NULL;
				found = TRUE;
				_tmp14_ = ui;
				_tmp15_ = _tmp14_->score;
				_tmp14_->score = _tmp15_ + 1;
				_tmp16_ = ui;
				_tmp16_->changed = TRUE;
				_g_object_unref0 (ui);
				break;
			}
			_g_object_unref0 (ui);
		}
		_g_object_unref0 (_ui_list);
	}
	_tmp17_ = found;
	if (!_tmp17_) {
		UserInfo* ui = NULL;
		UserInfo* _tmp18_ = NULL;
		UserInfo* _tmp19_ = NULL;
		gint64 _tmp20_ = 0LL;
		UserInfo* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		UserInfo* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		UserInfo* _tmp27_ = NULL;
		UserInfo* _tmp28_ = NULL;
		GeeArrayList* _tmp29_ = NULL;
		UserInfo* _tmp30_ = NULL;
		_tmp18_ = user_info_new ();
		ui = _tmp18_;
		_tmp19_ = ui;
		_tmp20_ = id;
		_tmp19_->id = _tmp20_;
		_tmp21_ = ui;
		_tmp22_ = screen_name;
		_tmp23_ = g_strdup (_tmp22_);
		_g_free0 (_tmp21_->screen_name);
		_tmp21_->screen_name = _tmp23_;
		_tmp24_ = ui;
		_tmp25_ = name;
		_tmp26_ = g_strdup (_tmp25_);
		_g_free0 (_tmp24_->name);
		_tmp24_->name = _tmp26_;
		_tmp27_ = ui;
		_tmp27_->changed = TRUE;
		_tmp28_ = ui;
		_tmp28_->score = 1;
		_tmp29_ = self->priv->names;
		_tmp30_ = ui;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp30_);
		_g_object_unref0 (ui);
	}
}


UserInfo** user_counter_query_by_prefix (UserCounter* self, const gchar* prefix, gint max_results, gint* num_results, int* result_length1) {
	gint _vala_num_results = 0;
	UserInfo** result = NULL;
	gint n_results = 0;
	gchar* p = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	UserInfo** results = NULL;
	gint _tmp2_ = 0;
	UserInfo** _tmp3_ = NULL;
	gint results_length1 = 0;
	gint _results_size_ = 0;
	gint _tmp37_ = 0;
	UserInfo** _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	g_return_val_if_fail (IS_USER_COUNTER (self), NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	n_results = 0;
	_tmp0_ = prefix;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
	p = _tmp1_;
	_tmp2_ = max_results;
	_tmp3_ = g_new0 (UserInfo*, _tmp2_ + 1);
	results = _tmp3_;
	results_length1 = _tmp2_;
	_results_size_ = results_length1;
	{
		GeeArrayList* _ui_list = NULL;
		GeeArrayList* _tmp4_ = NULL;
		GeeArrayList* _tmp5_ = NULL;
		gint _ui_size = 0;
		GeeArrayList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _ui_index = 0;
		_tmp4_ = self->priv->names;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_ui_list = _tmp5_;
		_tmp6_ = _ui_list;
		_tmp7_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp8_ = _tmp7_;
		_ui_size = _tmp8_;
		_ui_index = -1;
		while (TRUE) {
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			UserInfo* ui = NULL;
			GeeArrayList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gboolean _tmp17_ = FALSE;
			UserInfo* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_ = FALSE;
			_tmp9_ = _ui_index;
			_ui_index = _tmp9_ + 1;
			_tmp10_ = _ui_index;
			_tmp11_ = _ui_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _ui_list;
			_tmp13_ = _ui_index;
			_tmp14_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp13_);
			ui = (UserInfo*) _tmp14_;
			_tmp15_ = n_results;
			_tmp16_ = max_results;
			if (_tmp15_ >= _tmp16_) {
				_g_object_unref0 (ui);
				break;
			}
			_tmp18_ = ui;
			_tmp19_ = _tmp18_->name;
			_tmp20_ = g_utf8_strdown (_tmp19_, (gssize) (-1));
			_tmp21_ = _tmp20_;
			_tmp22_ = p;
			_tmp23_ = g_str_has_prefix (_tmp21_, _tmp22_);
			_tmp24_ = _tmp23_;
			_g_free0 (_tmp21_);
			if (_tmp24_) {
				_tmp17_ = TRUE;
			} else {
				UserInfo* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				_tmp25_ = ui;
				_tmp26_ = _tmp25_->screen_name;
				_tmp27_ = g_utf8_strdown (_tmp26_, (gssize) (-1));
				_tmp28_ = _tmp27_;
				_tmp29_ = p;
				_tmp30_ = g_str_has_prefix (_tmp28_, _tmp29_);
				_tmp17_ = _tmp30_;
				_g_free0 (_tmp28_);
			}
			if (_tmp17_) {
				UserInfo** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				UserInfo* _tmp33_ = NULL;
				UserInfo* _tmp34_ = NULL;
				UserInfo* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				_tmp31_ = results;
				_tmp31__length1 = results_length1;
				_tmp32_ = n_results;
				_tmp33_ = ui;
				_tmp34_ = _g_object_ref0 (_tmp33_);
				_g_object_unref0 (_tmp31_[_tmp32_]);
				_tmp31_[_tmp32_] = _tmp34_;
				_tmp35_ = _tmp31_[_tmp32_];
				_tmp36_ = n_results;
				n_results = _tmp36_ + 1;
			}
			_g_object_unref0 (ui);
		}
		_g_object_unref0 (_ui_list);
	}
	_tmp37_ = n_results;
	_vala_num_results = _tmp37_;
	_tmp38_ = results;
	_tmp38__length1 = results_length1;
	if (result_length1) {
		*result_length1 = _tmp38__length1;
	}
	result = _tmp38_;
	_g_free0 (p);
	if (num_results) {
		*num_results = _vala_num_results;
	}
	return result;
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean __lambda13_ (UserCounter* self, gchar** vals, int vals_length1) {
	gboolean result = FALSE;
	UserInfo* ui = NULL;
	UserInfo* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GeeArrayList* _tmp13_ = NULL;
	_tmp0_ = user_info_new ();
	ui = _tmp0_;
	_tmp1_ = vals;
	_tmp1__length1 = vals_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = int64_parse (_tmp2_);
	ui->id = _tmp3_;
	_tmp4_ = vals;
	_tmp4__length1 = vals_length1;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (ui->screen_name);
	ui->screen_name = _tmp6_;
	_tmp7_ = vals;
	_tmp7__length1 = vals_length1;
	_tmp8_ = _tmp7_[2];
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (ui->name);
	ui->name = _tmp9_;
	ui->changed = FALSE;
	_tmp10_ = vals;
	_tmp10__length1 = vals_length1;
	_tmp11_ = _tmp10_[3];
	_tmp12_ = atoi (_tmp11_);
	ui->score = _tmp12_;
	_tmp13_ = self->priv->names;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), ui);
	result = TRUE;
	_g_object_unref0 (ui);
	return result;
}


static gboolean ___lambda13__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda13_ ((UserCounter*) self, vals, vals_length1);
	return result;
}


void user_counter_load (UserCounter* self, SqlDatabase* db) {
	SqlDatabase* _tmp0_ = NULL;
	SqlSelectStatement* _tmp1_ = NULL;
	SqlSelectStatement* _tmp2_ = NULL;
	SqlSelectStatement* _tmp3_ = NULL;
	SqlSelectStatement* _tmp4_ = NULL;
	SqlSelectStatement* _tmp5_ = NULL;
	SqlSelectStatement* _tmp6_ = NULL;
	g_return_if_fail (IS_USER_COUNTER (self));
	g_return_if_fail (SQL_IS_DATABASE (db));
	_tmp0_ = db;
	_tmp1_ = sql_database_select (_tmp0_, "user_cache");
	_tmp2_ = _tmp1_;
	_tmp3_ = sql_select_statement_cols (_tmp2_, "id", "screen_name", "user_name", "score", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = sql_select_statement_order (_tmp4_, "score DESC");
	_tmp6_ = _tmp5_;
	sql_select_statement_run (_tmp6_, ___lambda13__sql_select_callback, self);
	_sql_select_statement_unref0 (_tmp6_);
	_sql_select_statement_unref0 (_tmp4_);
	_sql_select_statement_unref0 (_tmp2_);
}


/**
   * Saves all the changed user counts into the database.
   *
   * @return The number of changes users.
   */
gint user_counter_save (UserCounter* self, SqlDatabase* db) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint saved = 0;
	SqlDatabase* _tmp1_ = NULL;
	SqlDatabase* _tmp36_ = NULL;
	g_return_val_if_fail (IS_USER_COUNTER (self), 0);
	g_return_val_if_fail (SQL_IS_DATABASE (db), 0);
	_tmp0_ = self->priv->changed;
	if (!_tmp0_) {
		result = 0;
		return result;
	}
	saved = 0;
	_tmp1_ = db;
	sql_database_begin_transaction (_tmp1_);
	{
		GeeArrayList* _ui_list = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		gint _ui_size = 0;
		GeeArrayList* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _ui_index = 0;
		_tmp2_ = self->priv->names;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_ui_list = _tmp3_;
		_tmp4_ = _ui_list;
		_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp6_ = _tmp5_;
		_ui_size = _tmp6_;
		_ui_index = -1;
		while (TRUE) {
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			UserInfo* ui = NULL;
			GeeArrayList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			UserInfo* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			UserInfo* _tmp15_ = NULL;
			SqlDatabase* _tmp16_ = NULL;
			SqlInsertStatement* _tmp17_ = NULL;
			SqlInsertStatement* _tmp18_ = NULL;
			UserInfo* _tmp19_ = NULL;
			gint64 _tmp20_ = 0LL;
			SqlInsertStatement* _tmp21_ = NULL;
			SqlInsertStatement* _tmp22_ = NULL;
			UserInfo* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			SqlInsertStatement* _tmp25_ = NULL;
			SqlInsertStatement* _tmp26_ = NULL;
			UserInfo* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			SqlInsertStatement* _tmp29_ = NULL;
			SqlInsertStatement* _tmp30_ = NULL;
			UserInfo* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			SqlInsertStatement* _tmp33_ = NULL;
			SqlInsertStatement* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			_tmp7_ = _ui_index;
			_ui_index = _tmp7_ + 1;
			_tmp8_ = _ui_index;
			_tmp9_ = _ui_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _ui_list;
			_tmp11_ = _ui_index;
			_tmp12_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp11_);
			ui = (UserInfo*) _tmp12_;
			_tmp13_ = ui;
			_tmp14_ = _tmp13_->changed;
			if (!_tmp14_) {
				_g_object_unref0 (ui);
				continue;
			}
			_tmp15_ = ui;
			_tmp15_->changed = FALSE;
			_tmp16_ = db;
			_tmp17_ = sql_database_replace (_tmp16_, "user_cache");
			_tmp18_ = _tmp17_;
			_tmp19_ = ui;
			_tmp20_ = _tmp19_->id;
			_tmp21_ = sql_insert_statement_vali64 (_tmp18_, "id", _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = ui;
			_tmp24_ = _tmp23_->score;
			_tmp25_ = sql_insert_statement_vali (_tmp22_, "score", _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = ui;
			_tmp28_ = _tmp27_->screen_name;
			_tmp29_ = sql_insert_statement_val (_tmp26_, "screen_name", _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = ui;
			_tmp32_ = _tmp31_->name;
			_tmp33_ = sql_insert_statement_val (_tmp30_, "user_name", _tmp32_);
			_tmp34_ = _tmp33_;
			sql_insert_statement_run (_tmp34_);
			_sql_insert_statement_unref0 (_tmp34_);
			_sql_insert_statement_unref0 (_tmp30_);
			_sql_insert_statement_unref0 (_tmp26_);
			_sql_insert_statement_unref0 (_tmp22_);
			_sql_insert_statement_unref0 (_tmp18_);
			_tmp35_ = saved;
			saved = _tmp35_ + 1;
			_g_object_unref0 (ui);
		}
		_g_object_unref0 (_ui_list);
	}
	_tmp36_ = db;
	sql_database_end_transaction (_tmp36_);
	self->priv->changed = FALSE;
	result = saved;
	return result;
}


static void user_counter_class_init (UserCounterClass * klass) {
	user_counter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserCounterPrivate));
	G_OBJECT_CLASS (klass)->finalize = user_counter_finalize;
}


static void user_counter_instance_init (UserCounter * self) {
	GeeArrayList* _tmp0_ = NULL;
	self->priv = USER_COUNTER_GET_PRIVATE (self);
	self->priv->changed = FALSE;
	_tmp0_ = gee_array_list_new (TYPE_USER_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->names = _tmp0_;
}


static void user_counter_finalize (GObject* obj) {
	UserCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_COUNTER, UserCounter);
	_g_object_unref0 (self->priv->names);
	G_OBJECT_CLASS (user_counter_parent_class)->finalize (obj);
}


GType user_counter_get_type (void) {
	static volatile gsize user_counter_type_id__volatile = 0;
	if (g_once_init_enter (&user_counter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserCounterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_counter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserCounter), 0, (GInstanceInitFunc) user_counter_instance_init, NULL };
		GType user_counter_type_id;
		user_counter_type_id = g_type_register_static (G_TYPE_OBJECT, "UserCounter", &g_define_type_info, 0);
		g_once_init_leave (&user_counter_type_id__volatile, user_counter_type_id);
	}
	return user_counter_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



