/* Utils.c generated by valac 0.26.2, the Vala compiler
 * generated from Utils.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>


#define TYPE_PAGE (page_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block57Data Block57Data;
typedef struct _Block58Data Block58Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block59Data Block59Data;
typedef struct _UtilsDownloadFileAsyncData UtilsDownloadFileAsyncData;
typedef struct _Block60Data Block60Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _UtilsWritePixbufAsyncData UtilsWritePixbufAsyncData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block57Data {
	int _ref_count_;
	GtkMessageDialog* dialog;
};

struct _Block58Data {
	int _ref_count_;
	GString* sb;
};

struct _Block59Data {
	int _ref_count_;
	GSourceFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	gchar* path;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _UtilsDownloadFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* url;
	gchar* path;
	GCancellable* cancellable;
	Block59Data* _data59_;
	const gchar* _tmp0_;
	GCancellable* _tmp1_;
	SoupMessage* msg;
	const gchar* _tmp2_;
	SoupMessage* _tmp3_;
	SoupSession* _tmp4_;
	SoupMessage* _tmp5_;
};

struct _Block60Data {
	int _ref_count_;
	GdkPixbuf* pixbuf;
	GOutputStream* out_stream;
	gchar* type;
	gpointer _async_data_;
};

struct _UtilsWritePixbufAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GdkPixbuf* pixbuf;
	GOutputStream* out_stream;
	gchar* type;
	Block60Data* _data60_;
	GdkPixbuf* _tmp0_;
	GOutputStream* _tmp1_;
	const gchar* _tmp2_;
	GThread* _tmp3_;
	GThread* _tmp4_;
};


extern SoupSession* SOUP_SESSION;
SoupSession* SOUP_SESSION = NULL;

GType page_get_type (void) G_GNUC_CONST;
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
GDateTime* utils_parse_date (const gchar* input);
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now);
gchar* utils_get_file_name (const gchar* path);
gchar* utils_get_file_type (const gchar* path);
gchar* utils_get_avatar_name (const gchar* path);
void utils_show_error_dialog (const gchar* message);
static Block57Data* block57_data_ref (Block57Data* _data57_);
static void block57_data_unref (void * _userdata_);
static void __lambda55_ (Block57Data* _data57_, gint id);
static void ___lambda55__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
static Block58Data* block58_data_ref (Block58Data* _data58_);
static void block58_data_unref (void * _userdata_);
static void ___lambda56_ (Block58Data* _data58_, JsonArray* arr, guint index, JsonNode* node);
static void ____lambda56__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void utils_download_file_async_data_free (gpointer _data);
void utils_download_file_async (const gchar* url, const gchar* path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void utils_download_file_finish (GAsyncResult* _res_);
static gboolean utils_download_file_async_co (UtilsDownloadFileAsyncData* _data_);
static Block59Data* block59_data_ref (Block59Data* _data59_);
static void block59_data_unref (void * _userdata_);
static gboolean _utils_download_file_async_co_gsource_func (gpointer self);
static void __lambda159_ (Block59Data* _data59_, SoupSession* _s, SoupMessage* _msg);
static void ___lambda159__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void utils_write_pixbuf_async_data_free (gpointer _data);
void utils_write_pixbuf_async (GdkPixbuf* pixbuf, GOutputStream* out_stream, const gchar* type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void utils_write_pixbuf_finish (GAsyncResult* _res_);
static gboolean utils_write_pixbuf_async_co (UtilsWritePixbufAsyncData* _data_);
static Block60Data* block60_data_ref (Block60Data* _data60_);
static void block60_data_unref (void * _userdata_);
static void* __lambda34_ (Block60Data* _data60_);
static gboolean __lambda35_ (Block60Data* _data60_);
static gboolean ___lambda35__gsource_func (gpointer self);
static gpointer ___lambda34__gthread_func (gpointer self);
gchar* utils_unescape_html (const gchar* input);
void utils_load_custom_icons (void);
void utils_load_custom_css (void);
void utils_init_soup_session (void);
gchar* utils_capitalize (const gchar* s);
guint utils_int64_hash_func (gint64* k);
gboolean utils_int64_equal_func (gint64* a, gint64* b);
static gboolean _int64_equal (const gint64* s1, const gint64* s2);
void utils_calc_thumb_square (gint img_width, gint img_height, gint* x, gint* y, gint* width, gint* height);
void utils_calc_thumb_rect (gint img_width, gint img_height, gint thumb_width, gint thumb_height, gint* x, gint* y, gint* w, gint* h);
GdkPixbuf* utils_slice_pixbuf (GdkPixbuf* pic, gint thumb_width, gint thumb_height);
gint utils_get_json_array_size (JsonObject* node, const gchar* object_name);
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name);
gchar* utils_get_banner_name (gint64 user_id);
void utils_update_startup_account (const gchar* old_screen_name, const gchar* new_screen_name);
GSettings* settings_get (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType page_get_type (void) {
	static volatile gsize page_type_id__volatile = 0;
	if (g_once_init_enter (&page_type_id__volatile)) {
		static const GEnumValue values[] = {{PAGE_STREAM, "PAGE_STREAM", "stream"}, {PAGE_MENTIONS, "PAGE_MENTIONS", "mentions"}, {PAGE_FAVORITES, "PAGE_FAVORITES", "favorites"}, {PAGE_DM_THREADS, "PAGE_DM_THREADS", "dm-threads"}, {PAGE_LISTS, "PAGE_LISTS", "lists"}, {PAGE_FILTERS, "PAGE_FILTERS", "filters"}, {PAGE_SEARCH, "PAGE_SEARCH", "search"}, {PAGE_PROFILE, "PAGE_PROFILE", "profile"}, {PAGE_TWEET_INFO, "PAGE_TWEET_INFO", "tweet-info"}, {PAGE_DM, "PAGE_DM", "dm"}, {PAGE_LIST_STATUSES, "PAGE_LIST_STATUSES", "list-statuses"}, {PAGE_PREVIOUS, "PAGE_PREVIOUS", "previous"}, {PAGE_NEXT, "PAGE_NEXT", "next"}, {0, NULL, NULL}};
		GType page_type_id;
		page_type_id = g_enum_register_static ("Page", values);
		g_once_init_leave (&page_type_id__volatile, page_type_id);
	}
	return page_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before) {
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* header = NULL;
	GtkListBoxRow* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkSeparator* _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
	GtkListBoxRow* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	g_return_if_fail ((row_before == NULL) || GTK_IS_LIST_BOX_ROW (row_before));
	_tmp0_ = row_before;
	if (_tmp0_ == NULL) {
		GtkListBoxRow* _tmp1_ = NULL;
		_tmp1_ = row;
		gtk_list_box_row_set_header (_tmp1_, NULL);
		return;
	}
	_tmp2_ = row;
	_tmp3_ = gtk_list_box_row_get_header (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	header = _tmp4_;
	_tmp5_ = header;
	if (_tmp5_ != NULL) {
		_g_object_unref0 (header);
		return;
	}
	_tmp6_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (header);
	header = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget);
	_tmp7_ = header;
	gtk_widget_show (_tmp7_);
	_tmp8_ = row;
	_tmp9_ = header;
	gtk_list_box_row_set_header (_tmp8_, _tmp9_);
	_g_object_unref0 (header);
}


/**
  * Parses a date given by Twitter in the form 'Wed Jun 20 19:01:28 +0000 2012'
  * and creates a GLib.DateTime in the local time zone to work with.
  *
  * @return The given date as GLib.DateTime in the current time zone.
  */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


GDateTime* utils_parse_date (const gchar* input) {
	GDateTime* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* month_str = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint day = 0;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint year = 0;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gchar* timezone = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gint month = 0;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GQuark _tmp22_ = 0U;
	static GQuark _tmp21_label0 = 0;
	static GQuark _tmp21_label1 = 0;
	static GQuark _tmp21_label2 = 0;
	static GQuark _tmp21_label3 = 0;
	static GQuark _tmp21_label4 = 0;
	static GQuark _tmp21_label5 = 0;
	static GQuark _tmp21_label6 = 0;
	static GQuark _tmp21_label7 = 0;
	static GQuark _tmp21_label8 = 0;
	static GQuark _tmp21_label9 = 0;
	static GQuark _tmp21_label10 = 0;
	static GQuark _tmp21_label11 = 0;
	gint hour = 0;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint minute = 0;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint second = 0;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	GDateTime* dt = NULL;
	const gchar* _tmp38_ = NULL;
	GTimeZone* _tmp39_ = NULL;
	GTimeZone* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	GDateTime* _tmp47_ = NULL;
	GDateTime* _tmp48_ = NULL;
	GDateTime* _tmp49_ = NULL;
	GTimeZone* _tmp50_ = NULL;
	GTimeZone* _tmp51_ = NULL;
	GDateTime* _tmp52_ = NULL;
	GDateTime* _tmp53_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		GDateTime* _tmp1_ = NULL;
		_tmp1_ = g_date_time_new_now_local ();
		result = _tmp1_;
		return result;
	}
	_tmp2_ = input;
	_tmp3_ = string_substring (_tmp2_, (glong) 4, (glong) 3);
	month_str = _tmp3_;
	_tmp4_ = input;
	_tmp5_ = string_substring (_tmp4_, (glong) 8, (glong) 2);
	_tmp6_ = _tmp5_;
	_tmp7_ = atoi (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	day = _tmp8_;
	_tmp9_ = input;
	_tmp10_ = input;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = string_substring (_tmp9_, (glong) (_tmp12_ - 4), (glong) (-1));
	_tmp14_ = _tmp13_;
	_tmp15_ = atoi (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	year = _tmp16_;
	_tmp17_ = input;
	_tmp18_ = string_substring (_tmp17_, (glong) 20, (glong) 5);
	timezone = _tmp18_;
	month = -1;
	_tmp19_ = month_str;
	_tmp20_ = _tmp19_;
	_tmp22_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
	if (_tmp22_ == ((0 != _tmp21_label0) ? _tmp21_label0 : (_tmp21_label0 = g_quark_from_static_string ("Jan")))) {
		switch (0) {
			default:
			{
				month = 1;
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label1) ? _tmp21_label1 : (_tmp21_label1 = g_quark_from_static_string ("Feb")))) {
		switch (0) {
			default:
			{
				month = 2;
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label2) ? _tmp21_label2 : (_tmp21_label2 = g_quark_from_static_string ("Mar")))) {
		switch (0) {
			default:
			{
				month = 3;
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label3) ? _tmp21_label3 : (_tmp21_label3 = g_quark_from_static_string ("Apr")))) {
		switch (0) {
			default:
			{
				month = 4;
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label4) ? _tmp21_label4 : (_tmp21_label4 = g_quark_from_static_string ("May")))) {
		switch (0) {
			default:
			{
				month = 5;
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label5) ? _tmp21_label5 : (_tmp21_label5 = g_quark_from_static_string ("Jun")))) {
		switch (0) {
			default:
			{
				month = 6;
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label6) ? _tmp21_label6 : (_tmp21_label6 = g_quark_from_static_string ("Jul")))) {
		switch (0) {
			default:
			{
				month = 7;
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label7) ? _tmp21_label7 : (_tmp21_label7 = g_quark_from_static_string ("Aug")))) {
		switch (0) {
			default:
			{
				month = 8;
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label8) ? _tmp21_label8 : (_tmp21_label8 = g_quark_from_static_string ("Sep")))) {
		switch (0) {
			default:
			{
				month = 9;
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label9) ? _tmp21_label9 : (_tmp21_label9 = g_quark_from_static_string ("Oct")))) {
		switch (0) {
			default:
			{
				month = 10;
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label10) ? _tmp21_label10 : (_tmp21_label10 = g_quark_from_static_string ("Nov")))) {
		switch (0) {
			default:
			{
				month = 11;
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label11) ? _tmp21_label11 : (_tmp21_label11 = g_quark_from_static_string ("Dec")))) {
		switch (0) {
			default:
			{
				month = 12;
				break;
			}
		}
	}
	_tmp23_ = input;
	_tmp24_ = string_substring (_tmp23_, (glong) 11, (glong) 2);
	_tmp25_ = _tmp24_;
	_tmp26_ = atoi (_tmp25_);
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp25_);
	hour = _tmp27_;
	_tmp28_ = input;
	_tmp29_ = string_substring (_tmp28_, (glong) 14, (glong) 2);
	_tmp30_ = _tmp29_;
	_tmp31_ = atoi (_tmp30_);
	_tmp32_ = _tmp31_;
	_g_free0 (_tmp30_);
	minute = _tmp32_;
	_tmp33_ = input;
	_tmp34_ = string_substring (_tmp33_, (glong) 17, (glong) 2);
	_tmp35_ = _tmp34_;
	_tmp36_ = atoi (_tmp35_);
	_tmp37_ = _tmp36_;
	_g_free0 (_tmp35_);
	second = _tmp37_;
	_tmp38_ = timezone;
	_tmp39_ = g_time_zone_new (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = year;
	_tmp42_ = month;
	_tmp43_ = day;
	_tmp44_ = hour;
	_tmp45_ = minute;
	_tmp46_ = second;
	_tmp47_ = g_date_time_new (_tmp40_, _tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_, (gdouble) _tmp46_);
	_tmp48_ = _tmp47_;
	_g_time_zone_unref0 (_tmp40_);
	dt = _tmp48_;
	_tmp49_ = dt;
	_tmp50_ = g_time_zone_new_local ();
	_tmp51_ = _tmp50_;
	_tmp52_ = g_date_time_to_timezone (_tmp49_, _tmp51_);
	_tmp53_ = _tmp52_;
	_g_time_zone_unref0 (_tmp51_);
	result = _tmp53_;
	_g_date_time_unref0 (dt);
	_g_free0 (timezone);
	_g_free0 (month_str);
	return result;
}


/**
   * Calculates an easily human-readable version of the time difference between
   * time and now.
   * Example: "5m" or "3h" or "26m" or "16 Nov"
   */
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now) {
	gchar* result = NULL;
	GTimeSpan diff = 0LL;
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GTimeSpan _tmp2_ = 0LL;
	gint minutes = 0;
	GTimeSpan _tmp3_ = 0LL;
	gint _tmp4_ = 0;
	gint hours = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gchar* month = NULL;
	GDateTime* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GDateTime* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (time != NULL, NULL);
	g_return_val_if_fail (now != NULL, NULL);
	_tmp0_ = now;
	_tmp1_ = time;
	_tmp2_ = g_date_time_difference (_tmp0_, _tmp1_);
	diff = _tmp2_;
	_tmp3_ = diff;
	minutes = (gint) (((_tmp3_ / 1000.0) / 1000.0) / 60.0);
	_tmp4_ = minutes;
	if (_tmp4_ == 0) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = _ ("Now");
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		return result;
	} else {
		gint _tmp7_ = 0;
		_tmp7_ = minutes;
		if (_tmp7_ < 60) {
			const gchar* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gchar* _tmp10_ = NULL;
			_tmp8_ = _ ("%dm");
			_tmp9_ = minutes;
			_tmp10_ = g_strdup_printf (_tmp8_, _tmp9_);
			result = _tmp10_;
			return result;
		}
	}
	_tmp11_ = minutes;
	hours = (gint) (_tmp11_ / 60.0);
	_tmp12_ = hours;
	if (_tmp12_ < 24) {
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		_tmp13_ = _ ("%dh");
		_tmp14_ = hours;
		_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
		result = _tmp15_;
		return result;
	}
	_tmp16_ = time;
	_tmp17_ = g_date_time_format (_tmp16_, "%b");
	month = _tmp17_;
	_tmp18_ = time;
	_tmp19_ = g_date_time_get_day_of_month (_tmp18_);
	_tmp20_ = month;
	_tmp21_ = g_strdup_printf ("%d %s", _tmp19_, _tmp20_);
	result = _tmp21_;
	_g_free0 (month);
	return result;
}


/**
   * Extracts the actual filename out of a given path.
   * E.g. for /home/foo/bar.png, it will return "bar.png"
   *
   * @return The filename of the given path, and nothing else.
   */
static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* utils_get_file_name (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = path;
	_tmp2_ = string_last_index_of_char (_tmp1_, (gunichar) '/', 0);
	_tmp3_ = string_substring (_tmp0_, (glong) (_tmp2_ + 1), (glong) (-1));
	result = _tmp3_;
	return result;
}


/**
   * Extracts the file type from the given path.
   * E.g. for http://foo.org/bar/bla.png, this will just return "png"
   */
static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* utils_get_file_type (const gchar* path) {
	gchar* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* type = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = utils_get_file_name (_tmp0_);
	filename = _tmp1_;
	_tmp2_ = filename;
	_tmp3_ = string_index_of_char (_tmp2_, (gunichar) '.', 0);
	if (_tmp3_ == (-1)) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_strdup ("");
		result = _tmp4_;
		_g_free0 (filename);
		return result;
	}
	_tmp5_ = filename;
	_tmp6_ = filename;
	_tmp7_ = string_last_index_of_char (_tmp6_, (gunichar) '.', 0);
	_tmp8_ = string_substring (_tmp5_, (glong) (_tmp7_ + 1), (glong) (-1));
	type = _tmp8_;
	_tmp9_ = type;
	_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) (-1));
	_g_free0 (type);
	type = _tmp10_;
	_tmp11_ = type;
	if (g_strcmp0 (_tmp11_, "jpg") == 0) {
		gchar* _tmp12_ = NULL;
		_tmp12_ = g_strdup ("jpeg");
		result = _tmp12_;
		_g_free0 (type);
		_g_free0 (filename);
		return result;
	}
	result = type;
	_g_free0 (filename);
	return result;
}


/**
   * Returns the avatar name for the given path
   *
   * @return the 'calculated' avatar name
   */
gchar* utils_get_avatar_name (const gchar* path) {
	gchar* result = NULL;
	gchar** parts = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint parts_length1 = 0;
	gint _parts_size_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "/", 0);
	parts = _tmp2_;
	parts_length1 = _vala_array_length (_tmp1_);
	_parts_size_ = parts_length1;
	_tmp3_ = parts[parts_length1 - 2];
	_tmp4_ = g_strconcat (_tmp3_, "_", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = parts[parts_length1 - 1];
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp5_);
	result = _tmp8_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


/**
   * Shows an error dialog with the given error message
   *
   * @param message The error message to show
   */
static Block57Data* block57_data_ref (Block57Data* _data57_) {
	g_atomic_int_inc (&_data57_->_ref_count_);
	return _data57_;
}


static void block57_data_unref (void * _userdata_) {
	Block57Data* _data57_;
	_data57_ = (Block57Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data57_->_ref_count_)) {
		_g_object_unref0 (_data57_->dialog);
		g_slice_free (Block57Data, _data57_);
	}
}


static void __lambda55_ (Block57Data* _data57_, gint id) {
	gint _tmp0_ = 0;
	_tmp0_ = id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_data57_->dialog, gtk_widget_get_type (), GtkWidget));
	}
}


static void ___lambda55__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda55_ (self, response_id);
}


void utils_show_error_dialog (const gchar* message) {
	Block57Data* _data57_;
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_ = NULL;
	g_return_if_fail (message != NULL);
	_data57_ = g_slice_new0 (Block57Data);
	_data57_->_ref_count_ = 1;
	_tmp0_ = message;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp0_);
	g_object_ref_sink (_tmp1_);
	_data57_->dialog = _tmp1_;
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_data57_->dialog, gtk_dialog_get_type (), GtkDialog), "response", (GCallback) ___lambda55__gtk_dialog_response, block57_data_ref (_data57_), (GClosureNotify) block57_data_unref, 0);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_data57_->dialog, gtk_widget_get_type (), GtkWidget));
	block57_data_unref (_data57_);
	_data57_ = NULL;
}


/**
   * Shows the given json error object in an error dialog.
   * Example object data:
   * {"errors":[{"message":"Could not authenticate you","code":32}]
   *
   * @param json_data The json data to show
   * @param alternative If the given json data is not valid,
   *                    show this alternative error message.
   */
static Block58Data* block58_data_ref (Block58Data* _data58_) {
	g_atomic_int_inc (&_data58_->_ref_count_);
	return _data58_;
}


static void block58_data_unref (void * _userdata_) {
	Block58Data* _data58_;
	_data58_ = (Block58Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data58_->_ref_count_)) {
		_g_string_free0 (_data58_->sb);
		g_slice_free (Block58Data, _data58_);
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void ___lambda56_ (Block58Data* _data58_, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	GString* _tmp3_ = NULL;
	GString* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GString* _tmp8_ = NULL;
	GString* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GString* _tmp11_ = NULL;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	obj = _tmp2_;
	_tmp3_ = _data58_->sb;
	_tmp4_ = g_string_append (_tmp3_, "<li>");
	_tmp5_ = json_object_get_int_member (obj, "code");
	_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_string_append (_tmp4_, _tmp7_);
	_tmp9_ = g_string_append (_tmp8_, ": ");
	_tmp10_ = json_object_get_string_member (obj, "message");
	_tmp11_ = g_string_append (_tmp9_, _tmp10_);
	g_string_append (_tmp11_, "</li>");
	_g_free0 (_tmp7_);
	_json_object_unref0 (obj);
}


static void ____lambda56__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda56_ (self, array, index_, element_node);
}


void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file) {
	Block58Data* _data58_;
	gchar* error_message = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp6_ = NULL;
	GString* _tmp7_ = NULL;
	JsonParser* _tmp11_ = NULL;
	JsonNode* _tmp12_ = NULL;
	JsonNodeType _tmp13_ = 0;
	JsonObject* root = NULL;
	JsonParser* _tmp15_ = NULL;
	JsonNode* _tmp16_ = NULL;
	JsonObject* _tmp17_ = NULL;
	JsonObject* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	JsonObject* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	JsonObject* _tmp29_ = NULL;
	JsonNode* _tmp30_ = NULL;
	JsonNodeType _tmp31_ = 0;
	JsonArray* errors = NULL;
	JsonObject* _tmp36_ = NULL;
	JsonArray* _tmp37_ = NULL;
	JsonArray* _tmp38_ = NULL;
	JsonArray* _tmp39_ = NULL;
	guint _tmp40_ = 0U;
	GString* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	const gchar* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (alternative != NULL);
	g_return_if_fail (file != NULL);
	_data58_ = g_slice_new0 (Block58Data);
	_data58_->_ref_count_ = 1;
	_tmp0_ = alternative;
	_tmp1_ = file;
	_tmp2_ = line;
	_tmp3_ = g_strdup_printf ("Exception: %s in %s:%d", _tmp0_, _tmp1_, _tmp2_);
	error_message = _tmp3_;
	_tmp4_ = json_data;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = error_message;
		utils_show_error_dialog (_tmp5_);
		_g_free0 (error_message);
		block58_data_unref (_data58_);
		_data58_ = NULL;
		return;
	}
	_tmp6_ = json_parser_new ();
	parser = _tmp6_;
	_tmp7_ = g_string_new ("");
	_data58_->sb = _tmp7_;
	{
		JsonParser* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = parser;
		_tmp9_ = json_data;
		json_parser_load_from_data (_tmp8_, _tmp9_, (gssize) (-1), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch69_g_error;
		}
	}
	goto __finally69;
	__catch69_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = error_message;
		utils_show_error_dialog (_tmp10_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block58_data_unref (_data58_);
		_data58_ = NULL;
		return;
	}
	__finally69:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block58_data_unref (_data58_);
		_data58_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = parser;
	_tmp12_ = json_parser_get_root (_tmp11_);
	_tmp13_ = json_node_get_node_type (_tmp12_);
	if (_tmp13_ != JSON_NODE_OBJECT) {
		const gchar* _tmp14_ = NULL;
		_tmp14_ = error_message;
		utils_show_error_dialog (_tmp14_);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block58_data_unref (_data58_);
		_data58_ = NULL;
		return;
	}
	_tmp15_ = parser;
	_tmp16_ = json_parser_get_root (_tmp15_);
	_tmp17_ = json_node_get_object (_tmp16_);
	_tmp18_ = _json_object_ref0 (_tmp17_);
	root = _tmp18_;
	_tmp20_ = root;
	_tmp21_ = json_object_has_member (_tmp20_, "error");
	if (_tmp21_) {
		JsonObject* _tmp22_ = NULL;
		JsonNode* _tmp23_ = NULL;
		JsonNodeType _tmp24_ = 0;
		_tmp22_ = root;
		_tmp23_ = json_object_get_member (_tmp22_, "error");
		_tmp24_ = json_node_get_node_type (_tmp23_);
		_tmp19_ = _tmp24_ == JSON_NODE_VALUE;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		const gchar* _tmp25_ = NULL;
		JsonObject* _tmp26_ = NULL;
		JsonNode* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		_tmp25_ = json_data;
		g_message ("Utils.vala:214: %s", _tmp25_);
		_tmp26_ = root;
		_tmp27_ = json_object_get_member (_tmp26_, "error");
		_tmp28_ = json_node_get_string (_tmp27_);
		utils_show_error_dialog (_tmp28_);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block58_data_unref (_data58_);
		_data58_ = NULL;
		return;
	}
	_tmp29_ = root;
	_tmp30_ = json_object_get_member (_tmp29_, "errors");
	_tmp31_ = json_node_get_node_type (_tmp30_);
	if (_tmp31_ == JSON_NODE_VALUE) {
		const gchar* _tmp32_ = NULL;
		JsonObject* _tmp33_ = NULL;
		JsonNode* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		_tmp32_ = json_data;
		g_message ("Utils.vala:220: %s", _tmp32_);
		_tmp33_ = root;
		_tmp34_ = json_object_get_member (_tmp33_, "errors");
		_tmp35_ = json_node_get_string (_tmp34_);
		utils_show_error_dialog (_tmp35_);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block58_data_unref (_data58_);
		_data58_ = NULL;
		return;
	}
	_tmp36_ = root;
	_tmp37_ = json_object_get_array_member (_tmp36_, "errors");
	_tmp38_ = _json_array_ref0 (_tmp37_);
	errors = _tmp38_;
	_tmp39_ = errors;
	_tmp40_ = json_array_get_length (_tmp39_);
	if (_tmp40_ == ((guint) 1)) {
		JsonObject* err = NULL;
		JsonArray* _tmp41_ = NULL;
		JsonObject* _tmp42_ = NULL;
		JsonObject* _tmp43_ = NULL;
		GString* _tmp44_ = NULL;
		JsonObject* _tmp45_ = NULL;
		gint64 _tmp46_ = 0LL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		GString* _tmp49_ = NULL;
		GString* _tmp50_ = NULL;
		JsonObject* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		GString* _tmp53_ = NULL;
		GString* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		GString* _tmp56_ = NULL;
		GString* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		GString* _tmp61_ = NULL;
		_tmp41_ = errors;
		_tmp42_ = json_array_get_object_element (_tmp41_, (guint) 0);
		_tmp43_ = _json_object_ref0 (_tmp42_);
		err = _tmp43_;
		_tmp44_ = _data58_->sb;
		_tmp45_ = err;
		_tmp46_ = json_object_get_int_member (_tmp45_, "code");
		_tmp47_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_string_append (_tmp44_, _tmp48_);
		_tmp50_ = g_string_append (_tmp49_, ": ");
		_tmp51_ = err;
		_tmp52_ = json_object_get_string_member (_tmp51_, "message");
		_tmp53_ = g_string_append (_tmp50_, _tmp52_);
		_tmp54_ = g_string_append (_tmp53_, "(");
		_tmp55_ = file;
		_tmp56_ = g_string_append (_tmp54_, _tmp55_);
		_tmp57_ = g_string_append (_tmp56_, ":");
		_tmp58_ = line;
		_tmp59_ = g_strdup_printf ("%i", _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = g_string_append (_tmp57_, _tmp60_);
		g_string_append (_tmp61_, ")");
		_g_free0 (_tmp60_);
		_g_free0 (_tmp48_);
		_json_object_unref0 (err);
	} else {
		GString* _tmp62_ = NULL;
		JsonArray* _tmp63_ = NULL;
		GString* _tmp64_ = NULL;
		_tmp62_ = _data58_->sb;
		g_string_append (_tmp62_, "<ul>");
		_tmp63_ = errors;
		json_array_foreach_element (_tmp63_, ____lambda56__json_array_foreach, _data58_);
		_tmp64_ = _data58_->sb;
		g_string_append (_tmp64_, "</ul>");
	}
	_tmp65_ = _data58_->sb;
	_tmp66_ = _tmp65_->str;
	_tmp67_ = g_strdup (_tmp66_);
	_g_free0 (error_message);
	error_message = _tmp67_;
	_tmp68_ = json_data;
	g_critical ("Utils.vala:243: %s", _tmp68_);
	_tmp69_ = error_message;
	utils_show_error_dialog (_tmp69_);
	_json_array_unref0 (errors);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	_g_free0 (error_message);
	block58_data_unref (_data58_);
	_data58_ = NULL;
}


static void utils_download_file_async_data_free (gpointer _data) {
	UtilsDownloadFileAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->url);
	g_slice_free (UtilsDownloadFileAsyncData, _data_);
}


void utils_download_file_async (const gchar* url, const gchar* path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UtilsDownloadFileAsyncData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	_data_ = g_slice_new0 (UtilsDownloadFileAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, utils_download_file_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, utils_download_file_async_data_free);
	_tmp0_ = url;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->url);
	_data_->url = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data_->path);
	_data_->path = _tmp3_;
	_tmp4_ = cancellable;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp5_;
	utils_download_file_async_co (_data_);
}


void utils_download_file_finish (GAsyncResult* _res_) {
	UtilsDownloadFileAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * download_file_async:
   * Downloads the given file asynchronously to the given location.
   *
   * @param url The URL of the file to download
   * @param path The filesystem path to save the file to
   *
   */
static Block59Data* block59_data_ref (Block59Data* _data59_) {
	g_atomic_int_inc (&_data59_->_ref_count_);
	return _data59_;
}


static void block59_data_unref (void * _userdata_) {
	Block59Data* _data59_;
	_data59_ = (Block59Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data59_->_ref_count_)) {
		(_data59_->cb_target_destroy_notify == NULL) ? NULL : (_data59_->cb_target_destroy_notify (_data59_->cb_target), NULL);
		_data59_->cb = NULL;
		_data59_->cb_target = NULL;
		_data59_->cb_target_destroy_notify = NULL;
		_g_free0 (_data59_->path);
		_g_object_unref0 (_data59_->cancellable);
		g_slice_free (Block59Data, _data59_);
	}
}


static gboolean _utils_download_file_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = utils_download_file_async_co (self);
	return result;
}


static void __lambda159_ (Block59Data* _data59_, SoupSession* _s, SoupMessage* _msg) {
	GCancellable* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (SOUP_IS_SESSION (_s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _data59_->cancellable;
	_tmp1_ = g_cancellable_is_cancelled (_tmp0_);
	if (_tmp1_) {
		return;
	}
	{
		GFile* out_file = NULL;
		const gchar* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		GFileOutputStream* out_stream = NULL;
		GFile* _tmp4_ = NULL;
		GFileOutputStream* _tmp5_ = NULL;
		GFileOutputStream* _tmp6_ = NULL;
		SoupMessage* _tmp7_ = NULL;
		SoupMessageBody* _tmp8_ = NULL;
		guint8* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		GFileOutputStream* _tmp10_ = NULL;
		_tmp2_ = _data59_->path;
		_tmp3_ = g_file_new_for_path (_tmp2_);
		out_file = _tmp3_;
		_tmp4_ = out_file;
		_tmp5_ = g_file_replace (_tmp4_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error_);
		out_stream = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (out_file);
			goto __catch70_g_error;
		}
		_tmp6_ = out_stream;
		_tmp7_ = _msg;
		_tmp8_ = _tmp7_->response_body;
		_tmp9_ = _tmp8_->data;
		_tmp9__length1 = (gint) _tmp8_->length;
		g_output_stream_write_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, G_TYPE_OUTPUT_STREAM, GOutputStream), _tmp9_, (gsize) _tmp9__length1, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (out_stream);
			_g_object_unref0 (out_file);
			goto __catch70_g_error;
		}
		_tmp10_ = out_stream;
		g_output_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OUTPUT_STREAM, GOutputStream), NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (out_stream);
			_g_object_unref0 (out_file);
			goto __catch70_g_error;
		}
		_data59_->cb (_data59_->cb_target);
		_g_object_unref0 (out_stream);
		_g_object_unref0 (out_file);
	}
	goto __finally70;
	__catch70_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("Utils.vala:272: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally70:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda159__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda159_ (self, session, msg);
	block59_data_unref (self);
}


static gboolean utils_download_file_async_co (UtilsDownloadFileAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data59_ = g_slice_new0 (Block59Data);
	_data_->_data59_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->path;
	_g_free0 (_data_->_data59_->path);
	_data_->_data59_->path = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->cancellable;
	_g_object_unref0 (_data_->_data59_->cancellable);
	_data_->_data59_->cancellable = _data_->_tmp1_;
	_data_->_data59_->_async_data_ = _data_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->url;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = soup_message_new ("GET", _data_->_tmp2_);
	_data_->msg = _data_->_tmp3_;
	_data_->_data59_->cb = _utils_download_file_async_co_gsource_func;
	_data_->_data59_->cb_target = _data_;
	_data_->_data59_->cb_target_destroy_notify = NULL;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = SOUP_SESSION;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _g_object_ref0 (_data_->msg);
	soup_session_queue_message (_data_->_tmp4_, _data_->_tmp5_, ___lambda159__soup_session_callback, block59_data_ref (_data_->_data59_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_g_object_unref0 (_data_->msg);
	block59_data_unref (_data_->_data59_);
	_data_->_data59_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void utils_write_pixbuf_async_data_free (gpointer _data) {
	UtilsWritePixbufAsyncData* _data_;
	_data_ = _data;
	g_slice_free (UtilsWritePixbufAsyncData, _data_);
}


void utils_write_pixbuf_async (GdkPixbuf* pixbuf, GOutputStream* out_stream, const gchar* type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UtilsWritePixbufAsyncData* _data_;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GOutputStream* _tmp2_ = NULL;
	GOutputStream* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	_data_ = g_slice_new0 (UtilsWritePixbufAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, utils_write_pixbuf_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, utils_write_pixbuf_async_data_free);
	_tmp0_ = pixbuf;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->pixbuf);
	_data_->pixbuf = _tmp1_;
	_tmp2_ = out_stream;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->out_stream);
	_data_->out_stream = _tmp3_;
	_tmp4_ = type;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (_data_->type);
	_data_->type = _tmp5_;
	utils_write_pixbuf_async_co (_data_);
}


void utils_write_pixbuf_finish (GAsyncResult* _res_) {
	UtilsWritePixbufAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block60Data* block60_data_ref (Block60Data* _data60_) {
	g_atomic_int_inc (&_data60_->_ref_count_);
	return _data60_;
}


static void block60_data_unref (void * _userdata_) {
	Block60Data* _data60_;
	_data60_ = (Block60Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data60_->_ref_count_)) {
		_g_object_unref0 (_data60_->pixbuf);
		_g_object_unref0 (_data60_->out_stream);
		_g_free0 (_data60_->type);
		g_slice_free (Block60Data, _data60_);
	}
}


static gboolean __lambda35_ (Block60Data* _data60_) {
	gboolean result = FALSE;
	utils_write_pixbuf_async_co (_data60_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean ___lambda35__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda35_ (self);
	return result;
}


static void* __lambda34_ (Block60Data* _data60_) {
	void* result = NULL;
	GError * _inner_error_ = NULL;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GOutputStream* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp0_ = _data60_->pixbuf;
		_tmp1_ = _data60_->out_stream;
		_tmp2_ = _data60_->type;
		gdk_pixbuf_save_to_stream (_tmp0_, _tmp1_, _tmp2_, NULL, &_inner_error_, NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch71_g_error;
		}
	}
	goto __finally71;
	__catch71_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Utils.vala:283: %s", _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally71:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda35__gsource_func, block60_data_ref (_data60_), block60_data_unref);
	result = NULL;
	return result;
}


static gpointer ___lambda34__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda34_ (self);
	block60_data_unref (self);
	return result;
}


static gboolean utils_write_pixbuf_async_co (UtilsWritePixbufAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data60_ = g_slice_new0 (Block60Data);
	_data_->_data60_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->pixbuf;
	_g_object_unref0 (_data_->_data60_->pixbuf);
	_data_->_data60_->pixbuf = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->out_stream;
	_g_object_unref0 (_data_->_data60_->out_stream);
	_data_->_data60_->out_stream = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->type;
	_g_free0 (_data_->_data60_->type);
	_data_->_data60_->type = _data_->_tmp2_;
	_data_->_data60_->_async_data_ = _data_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_thread_new ("write_pixbuf", ___lambda34__gthread_func, block60_data_ref (_data_->_data60_));
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_thread_unref0 (_data_->_tmp4_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block60_data_unref (_data_->_data60_);
	_data_->_data60_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch72_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch72_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally72;
	__catch72_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally72:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* utils_unescape_html (const gchar* input) {
	gchar* result = NULL;
	gchar* back = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = string_replace (_tmp0_, "&lt;", "<");
	back = _tmp1_;
	_tmp2_ = back;
	_tmp3_ = string_replace (_tmp2_, "&gt;", ">");
	_g_free0 (back);
	back = _tmp3_;
	_tmp4_ = back;
	_tmp5_ = string_replace (_tmp4_, "&amp;", "&");
	_g_free0 (back);
	back = _tmp5_;
	result = back;
	return result;
}


void utils_load_custom_icons (void) {
	GtkIconTheme* icon_theme = NULL;
	GtkIconTheme* _tmp0_ = NULL;
	GtkIconTheme* _tmp1_ = NULL;
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	icon_theme = _tmp1_;
	gtk_icon_theme_add_resource_path (icon_theme, "/org/baedert/corebird/data/");
	_g_object_unref0 (icon_theme);
}


void utils_load_custom_css (void) {
	GError * _inner_error_ = NULL;
	{
		GtkCssProvider* provider = NULL;
		GtkCssProvider* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GdkScreen* _tmp3_ = NULL;
		_tmp0_ = gtk_css_provider_new ();
		provider = _tmp0_;
		_tmp1_ = g_file_new_for_uri ("resource:///org/baedert/corebird/ui/style.css");
		_tmp2_ = _tmp1_;
		gtk_css_provider_load_from_file (provider, _tmp2_, &_inner_error_);
		_g_object_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (provider);
			goto __catch73_g_error;
		}
		_tmp3_ = gdk_screen_get_default ();
		gtk_style_context_add_provider_for_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GDK_TYPE_SCREEN, GdkScreen), G_TYPE_CHECK_INSTANCE_CAST (provider, GTK_TYPE_STYLE_PROVIDER, GtkStyleProvider), (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (provider);
	}
	goto __finally73;
	__catch73_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("Utils.vala:316: Error while loading ui/style.css: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally73:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void utils_init_soup_session (void) {
	SoupSession* _tmp0_ = NULL;
	SoupSession* _tmp1_ = NULL;
	_tmp0_ = SOUP_SESSION;
	_vala_assert (_tmp0_ == NULL, "SOUP_SESSION == null");
	_tmp1_ = soup_session_new ();
	_g_object_unref0 (SOUP_SESSION);
	SOUP_SESSION = _tmp1_;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


gchar* utils_capitalize (const gchar* s) {
	gchar* result = NULL;
	gchar* back = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gunichar _tmp3_ = 0U;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp1_ = g_strdup (_tmp0_);
	back = _tmp1_;
	_tmp2_ = s;
	_tmp3_ = string_get_char (_tmp2_, (glong) 0);
	_tmp4_ = g_unichar_islower (_tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		gunichar _tmp6_ = 0U;
		gunichar _tmp7_ = 0U;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp5_ = s;
		_tmp6_ = string_get_char (_tmp5_, (glong) 0);
		_tmp7_ = g_unichar_toupper (_tmp6_);
		_tmp8_ = g_unichar_to_string (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = s;
		_tmp11_ = string_substring (_tmp10_, (glong) 1, (glong) (-1));
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
		_g_free0 (back);
		back = _tmp13_;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp9_);
	}
	result = back;
	return result;
}


guint utils_int64_hash_func (gint64* k) {
	guint result = 0U;
	gint64* _tmp0_ = NULL;
	_tmp0_ = k;
	result = (guint) (*_tmp0_);
	return result;
}


static gboolean _int64_equal (const gint64* s1, const gint64* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


gboolean utils_int64_equal_func (gint64* a, gint64* b) {
	gboolean result = FALSE;
	gint64* _tmp0_ = NULL;
	gint64* _tmp1_ = NULL;
	_tmp0_ = a;
	_tmp1_ = b;
	result = _int64_equal (_tmp0_, _tmp1_) == TRUE;
	return result;
}


/**
   * Calculates the region of the image the thumbnail should be composed of.
   *
   * @param img_width  The width of the original image
   * @param img_height The height of the original image
   *
   */
void utils_calc_thumb_square (gint img_width, gint img_height, gint* x, gint* y, gint* width, gint* height) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	gfloat ratio = 0.0F;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gfloat _tmp3_ = 0.0F;
	_tmp0_ = img_width;
	_tmp1_ = img_height;
	ratio = _tmp0_ / ((gfloat) _tmp1_);
	_tmp3_ = ratio;
	if (((gdouble) _tmp3_) >= 0.9) {
		gfloat _tmp4_ = 0.0F;
		_tmp4_ = ratio;
		_tmp2_ = ((gdouble) _tmp4_) <= 1.1;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_vala_y = 0;
		_tmp5_ = _vala_y;
		_vala_x = _tmp5_;
		_tmp6_ = img_width;
		_vala_width = _tmp6_;
		_tmp7_ = img_height;
		_vala_height = _tmp7_;
	} else {
		gfloat _tmp8_ = 0.0F;
		_tmp8_ = ratio;
		if (((gdouble) _tmp8_) > 1.1) {
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			_tmp9_ = img_width;
			_tmp10_ = img_height;
			_vala_x = (_tmp9_ / 2) - (_tmp10_ / 2);
			_vala_y = 0;
			_tmp11_ = img_height;
			_vala_height = _tmp11_;
			_tmp12_ = _vala_height;
			_vala_width = _tmp12_;
		} else {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			_vala_x = 0;
			_tmp13_ = img_height;
			_tmp14_ = img_width;
			_vala_y = (_tmp13_ / 2) - (_tmp14_ / 2);
			_tmp15_ = img_width;
			_vala_height = _tmp15_;
			_tmp16_ = _vala_height;
			_vala_width = _tmp16_;
		}
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}


void utils_calc_thumb_rect (gint img_width, gint img_height, gint thumb_width, gint thumb_height, gint* x, gint* y, gint* w, gint* h) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _vala_w = 0;
	gint _vala_h = 0;
	gfloat f = 0.0F;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gfloat _tmp4_ = 0.0F;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	_tmp0_ = img_width;
	_tmp1_ = thumb_width;
	f = ((gfloat) _tmp0_) / ((gfloat) _tmp1_);
	_tmp2_ = img_width;
	_vala_w = _tmp2_;
	_tmp3_ = thumb_height;
	_tmp4_ = f;
	_vala_h = (gint) (_tmp3_ * _tmp4_);
	_tmp5_ = _vala_h;
	_tmp6_ = img_height;
	if (_tmp5_ > _tmp6_) {
		gint _tmp7_ = 0;
		_tmp7_ = img_height;
		_vala_h = _tmp7_;
	}
	_vala_x = 0;
	_tmp8_ = img_height;
	_tmp9_ = _vala_h;
	_vala_y = (_tmp8_ / 2) - (_tmp9_ / 2);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (w) {
		*w = _vala_w;
	}
	if (h) {
		*h = _vala_h;
	}
}


/**
   * Slices the given pixbuf to a smaller thumbnail image.
   *
   * @param pic The Gdk.Pixbuf to use as base image
   *
   * @return The created thumbnail
   */
GdkPixbuf* utils_slice_pixbuf (GdkPixbuf* pic, gint thumb_width, gint thumb_height) {
	GdkPixbuf* result = NULL;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gint _tmp0_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GdkPixbuf* big_thumb = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	GdkPixbuf* _tmp24_ = NULL;
	GdkPixbuf* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	GdkPixbuf* thumb = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	GdkPixbuf* _tmp32_ = NULL;
	g_return_val_if_fail (GDK_IS_PIXBUF (pic), NULL);
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	_tmp0_ = thumb_height;
	if (_tmp0_ == (-1)) {
		gint _tmp1_ = 0;
		_tmp1_ = thumb_width;
		thumb_height = _tmp1_;
	}
	_tmp2_ = thumb_width;
	_tmp3_ = thumb_height;
	if (_tmp2_ == _tmp3_) {
		GdkPixbuf* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GdkPixbuf* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp4_ = pic;
		_tmp5_ = gdk_pixbuf_get_width (_tmp4_);
		_tmp6_ = pic;
		_tmp7_ = gdk_pixbuf_get_height (_tmp6_);
		utils_calc_thumb_square (_tmp5_, _tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
		x = _tmp8_;
		y = _tmp9_;
		w = _tmp10_;
		h = _tmp11_;
	} else {
		GdkPixbuf* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		GdkPixbuf* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp12_ = pic;
		_tmp13_ = gdk_pixbuf_get_width (_tmp12_);
		_tmp14_ = pic;
		_tmp15_ = gdk_pixbuf_get_height (_tmp14_);
		_tmp16_ = thumb_width;
		_tmp17_ = thumb_height;
		utils_calc_thumb_rect (_tmp13_, _tmp15_, _tmp16_, _tmp17_, &_tmp18_, &_tmp19_, &_tmp20_, &_tmp21_);
		x = _tmp18_;
		y = _tmp19_;
		w = _tmp20_;
		h = _tmp21_;
	}
	_tmp22_ = w;
	_tmp23_ = h;
	_tmp24_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, _tmp22_, _tmp23_);
	big_thumb = _tmp24_;
	_tmp25_ = pic;
	_tmp26_ = x;
	_tmp27_ = y;
	_tmp28_ = w;
	_tmp29_ = h;
	gdk_pixbuf_copy_area (_tmp25_, _tmp26_, _tmp27_, _tmp28_, _tmp29_, big_thumb, 0, 0);
	_tmp30_ = thumb_width;
	_tmp31_ = thumb_height;
	_tmp32_ = gdk_pixbuf_scale_simple (big_thumb, _tmp30_, _tmp31_, GDK_INTERP_TILES);
	thumb = _tmp32_;
	result = thumb;
	_g_object_unref0 (big_thumb);
	return result;
}


gint utils_get_json_array_size (JsonObject* node, const gchar* object_name) {
	gint result = 0;
	JsonObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	JsonArray* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	g_return_val_if_fail (node != NULL, 0);
	g_return_val_if_fail (object_name != NULL, 0);
	_tmp0_ = node;
	_tmp1_ = object_name;
	_tmp2_ = json_object_has_member (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		result = 0;
		return result;
	}
	_tmp3_ = node;
	_tmp4_ = object_name;
	_tmp5_ = json_object_get_array_member (_tmp3_, _tmp4_);
	_tmp6_ = json_array_get_length (_tmp5_);
	result = (gint) _tmp6_;
	return result;
}


/**
   * Checks if @value is existing in @node and if it is, non-null.
   *
   * Returns TRUE if the @value does both exist and is non-null.
   */
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name) {
	gboolean result = FALSE;
	JsonObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (node != NULL, FALSE);
	g_return_val_if_fail (value_name != NULL, FALSE);
	_tmp0_ = node;
	_tmp1_ = value_name;
	_tmp2_ = json_object_get_null_member (_tmp0_, _tmp1_);
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = node;
	_tmp4_ = value_name;
	_tmp5_ = json_object_has_member (_tmp3_, _tmp4_);
	result = _tmp5_;
	return result;
}


gchar* utils_get_banner_name (gint64 user_id) {
	gchar* result = NULL;
	gint64 _tmp0_ = 0LL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_tmp0_ = user_id;
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ".png", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


void utils_update_startup_account (const gchar* old_screen_name, const gchar* new_screen_name) {
	gchar** startup_accounts = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gchar** new_startup_accounts = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint new_startup_accounts_length1 = 0;
	gint _new_startup_accounts_size_ = 0;
	GSettings* _tmp27_ = NULL;
	GSettings* _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	g_return_if_fail (old_screen_name != NULL);
	g_return_if_fail (new_screen_name != NULL);
	_tmp0_ = settings_get ();
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "startup-accounts");
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_object_unref0 (_tmp1_);
	startup_accounts = _tmp4_;
	startup_accounts_length1 = _tmp4__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp5_ = startup_accounts;
	_tmp5__length1 = startup_accounts_length1;
	_tmp6_ = g_new0 (gchar*, _tmp5__length1 + 1);
	new_startup_accounts = _tmp6_;
	new_startup_accounts_length1 = _tmp5__length1;
	_new_startup_accounts_size_ = new_startup_accounts_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = startup_accounts;
				_tmp10__length1 = startup_accounts_length1;
				if (!(_tmp9_ < _tmp10__length1)) {
					break;
				}
				_tmp11_ = startup_accounts;
				_tmp11__length1 = startup_accounts_length1;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				_tmp14_ = old_screen_name;
				if (g_strcmp0 (_tmp13_, _tmp14_) != 0) {
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					gint _tmp16_ = 0;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp18_ = 0;
					const gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					_tmp15_ = new_startup_accounts;
					_tmp15__length1 = new_startup_accounts_length1;
					_tmp16_ = i;
					_tmp17_ = startup_accounts;
					_tmp17__length1 = startup_accounts_length1;
					_tmp18_ = i;
					_tmp19_ = _tmp17_[_tmp18_];
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (_tmp15_[_tmp16_]);
					_tmp15_[_tmp16_] = _tmp20_;
					_tmp21_ = _tmp15_[_tmp16_];
				} else {
					gchar** _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					gint _tmp23_ = 0;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					_tmp22_ = new_startup_accounts;
					_tmp22__length1 = new_startup_accounts_length1;
					_tmp23_ = i;
					_tmp24_ = new_screen_name;
					_tmp25_ = g_strdup (_tmp24_);
					_g_free0 (_tmp22_[_tmp23_]);
					_tmp22_[_tmp23_] = _tmp25_;
					_tmp26_ = _tmp22_[_tmp23_];
				}
			}
		}
	}
	_tmp27_ = settings_get ();
	_tmp28_ = _tmp27_;
	_tmp29_ = new_startup_accounts;
	_tmp29__length1 = new_startup_accounts_length1;
	g_settings_set_strv (_tmp28_, "startup-accounts", _tmp29_);
	_g_object_unref0 (_tmp28_);
	new_startup_accounts = (_vala_array_free (new_startup_accounts, new_startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



