/* UserListsWidget.c generated by valac 0.26.2, the Vala compiler
 * generated from UserListsWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>


#define TYPE_USER_LISTS_WIDGET (user_lists_widget_get_type ())
#define USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidget))
#define USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))
#define IS_USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LISTS_WIDGET))
#define IS_USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LISTS_WIDGET))
#define USER_LISTS_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))

typedef struct _UserListsWidget UserListsWidget;
typedef struct _UserListsWidgetClass UserListsWidgetClass;
typedef struct _UserListsWidgetPrivate UserListsWidgetPrivate;

#define TYPE_NEW_LIST_ENTRY (new_list_entry_get_type ())
#define NEW_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEW_LIST_ENTRY, NewListEntry))
#define NEW_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEW_LIST_ENTRY, NewListEntryClass))
#define IS_NEW_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEW_LIST_ENTRY))
#define IS_NEW_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEW_LIST_ENTRY))
#define NEW_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEW_LIST_ENTRY, NewListEntryClass))

typedef struct _NewListEntry NewListEntry;
typedef struct _NewListEntryClass NewListEntryClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_LIST_LIST_ENTRY (list_list_entry_get_type ())
#define LIST_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_LIST_ENTRY, ListListEntry))
#define LIST_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_LIST_ENTRY, ListListEntryClass))
#define IS_LIST_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_LIST_ENTRY))
#define IS_LIST_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_LIST_ENTRY))
#define LIST_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_LIST_ENTRY, ListListEntryClass))

typedef struct _ListListEntry ListListEntry;
typedef struct _ListListEntryClass ListListEntryClass;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;
typedef struct _ListListEntryPrivate ListListEntryPrivate;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
typedef struct _Block42Data Block42Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _UserListsWidgetLoadListsData UserListsWidgetLoadListsData;
typedef struct _Block43Data Block43Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block44Data Block44Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block45Data Block45Data;

#define TYPE_TWITTER_LIST (twitter_list_get_type ())
typedef struct _TwitterList TwitterList;
typedef struct _Block46Data Block46Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _UserListsWidget {
	GtkBox parent_instance;
	UserListsWidgetPrivate * priv;
};

struct _UserListsWidgetClass {
	GtkBoxClass parent_class;
};

struct _UserListsWidgetPrivate {
	GtkLabel* user_list_label;
	GtkListBox* user_list_box;
	GtkFrame* user_list_frame;
	GtkLabel* subscribed_list_label;
	GtkListBox* subscribed_list_box;
	GtkFrame* subscribed_list_frame;
	NewListEntry* new_list_entry;
	MainWindow* _main_window;
	Account* _account;
	gboolean show_create_entry;
};

struct _ListListEntry {
	GtkListBoxRow parent_instance;
	ListListEntryPrivate * priv;
	gint64 id;
	gboolean user_list;
	gchar* creator_screen_name;
	gint n_subscribers;
	gint n_members;
	gint64 created_at;
	gchar* mode;
};

struct _ListListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block42Data {
	int _ref_count_;
	UserListsWidget* self;
	Collect* collect_obj;
	gpointer _async_data_;
};

struct _UserListsWidgetLoadListsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UserListsWidget* self;
	gint64 user_id;
	Block42Data* _data42_;
	gint64 _tmp0_;
	Account* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	Collect* _tmp4_;
	RestProxyCall* call;
	Account* _tmp5_;
	OAuthProxy* _tmp6_;
	OAuthProxy* _tmp7_;
	RestProxyCall* _tmp8_;
	gint64 _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	RestProxyCall* user_call;
	Account* _tmp12_;
	OAuthProxy* _tmp13_;
	OAuthProxy* _tmp14_;
	RestProxyCall* _tmp15_;
	gint64 _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
};

struct _Block43Data {
	int _ref_count_;
	UserListsWidget* self;
	GtkListBox* list_box;
};

struct _Block44Data {
	int _ref_count_;
	UserListsWidget* self;
	gint64 list_id;
};

struct _Block45Data {
	int _ref_count_;
	UserListsWidget* self;
	gint64 list_id;
	gchar* name;
	gchar* description;
	gchar* mode;
};

struct _TwitterList {
	gint64 id;
	gchar* name;
	gchar* description;
	gchar* mode;
};

struct _Block46Data {
	int _ref_count_;
	UserListsWidget* self;
	RestProxyCall* call;
};


static gpointer user_lists_widget_parent_class = NULL;

GType user_lists_widget_get_type (void) G_GNUC_CONST;
GType new_list_entry_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define USER_LISTS_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_LISTS_WIDGET, UserListsWidgetPrivate))
enum  {
	USER_LISTS_WIDGET_DUMMY_PROPERTY,
	USER_LISTS_WIDGET_MAIN_WINDOW,
	USER_LISTS_WIDGET_ACCOUNT
};
void user_lists_widget_hide_user_list_entry (UserListsWidget* self);
static void user_lists_widget_row_activated (UserListsWidget* self, GtkListBoxRow* row);
void new_list_entry_reveal (NewListEntry* self);
GType list_list_entry_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
const gchar* list_list_entry_get_name (ListListEntry* self);
void bundle_put_bool (Bundle* self, const gchar* key, gboolean value);
const gchar* list_list_entry_get_description (ListListEntry* self);
void bundle_put_int (Bundle* self, const gchar* key, gint value);
MainWindow* user_lists_widget_get_main_window (UserListsWidget* self);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void _user_lists_widget_row_activated_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void user_lists_widget_load_lists_data_free (gpointer _data);
void user_lists_widget_load_lists (UserListsWidget* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void user_lists_widget_load_lists_finish (UserListsWidget* self, GAsyncResult* _res_);
static gboolean user_lists_widget_load_lists_co (UserListsWidgetLoadListsData* _data_);
GType collect_get_type (void) G_GNUC_CONST;
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
Account* user_lists_widget_get_account (UserListsWidget* self);
gint64 account_get_id (Account* self);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
OAuthProxy* account_get_proxy (Account* self);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_);
static void __lambda135_ (Block42Data* _data42_, GObject* _, GAsyncResult* res);
static guint user_lists_widget_lists_received_cb (UserListsWidget* self, JsonNode* root, GtkListBox* list_box);
void collect_emit (Collect* self, GError* _error_);
static void _vala_JsonNode_free (JsonNode* self);
static void ___lambda135__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda137_ (Block42Data* _data42_, GObject* _, GAsyncResult* res);
static void ___lambda137__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda138_ (Block42Data* _data42_);
static void ___lambda138__collect_finished (Collect* _sender, GError* _error_, gpointer self);
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
static void __lambda136_ (Block43Data* _data43_, JsonArray* array, guint index, JsonNode* node);
ListListEntry* list_list_entry_new_from_json_data (JsonObject* obj, Account* account);
ListListEntry* list_list_entry_construct_from_json_data (GType object_type, JsonObject* obj, Account* account);
static void ___lambda136__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void user_lists_widget_remove_list (UserListsWidget* self, gint64 list_id);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static void __lambda139_ (Block44Data* _data44_, GtkWidget* w);
static void ___lambda139__gtk_callback (GtkWidget* widget, gpointer self);
static void __lambda140_ (Block44Data* _data44_, GtkWidget* w);
static void ___lambda140__gtk_callback (GtkWidget* widget, gpointer self);
void user_lists_widget_add_list (UserListsWidget* self, ListListEntry* entry);
void user_lists_widget_update_list (UserListsWidget* self, gint64 list_id, const gchar* name, const gchar* description, const gchar* mode);
static Block45Data* block45_data_ref (Block45Data* _data45_);
static void block45_data_unref (void * _userdata_);
static void __lambda141_ (Block45Data* _data45_, GtkWidget* w);
void list_list_entry_set_name (ListListEntry* self, const gchar* value);
void list_list_entry_set_description (ListListEntry* self, const gchar* value);
static void ___lambda141__gtk_callback (GtkWidget* widget, gpointer self);
void user_lists_widget_update_member_count (UserListsWidget* self, gint64 list_id, gint increase);
GType twitter_list_get_type (void) G_GNUC_CONST;
TwitterList* twitter_list_dup (const TwitterList* self);
void twitter_list_free (TwitterList* self);
void twitter_list_copy (const TwitterList* self, TwitterList* dest);
void twitter_list_destroy (TwitterList* self);
TwitterList* user_lists_widget_get_user_lists (UserListsWidget* self, int* result_length1);
static void _vala_TwitterList_array_free (TwitterList* array, gint array_length);
void user_lists_widget_clear_lists (UserListsWidget* self);
static void __lambda142_ (UserListsWidget* self, GtkWidget* w);
static void ___lambda142__gtk_callback (GtkWidget* widget, gpointer self);
static void __lambda143_ (UserListsWidget* self, GtkWidget* w);
static void ___lambda143__gtk_callback (GtkWidget* widget, gpointer self);
static void user_lists_widget_new_list_create_activated_cb (UserListsWidget* self, const gchar* list_name);
static Block46Data* block46_data_ref (Block46Data* _data46_);
static void block46_data_unref (void * _userdata_);
static void __lambda144_ (Block46Data* _data46_, GObject* o, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
static void ___lambda144__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _user_lists_widget_new_list_create_activated_cb_new_list_entry_create_activated (NewListEntry* _sender, const gchar* list_name, gpointer self);
void user_lists_widget_unreveal (UserListsWidget* self);
void new_list_entry_unreveal (NewListEntry* self);
UserListsWidget* user_lists_widget_new (void);
UserListsWidget* user_lists_widget_construct (GType object_type);
void user_lists_widget_set_main_window (UserListsWidget* self, MainWindow* value);
void user_lists_widget_set_account (UserListsWidget* self, Account* value);
static GObject * user_lists_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
gint list_list_entry_sort_func (GtkListBoxRow* r1, GtkListBoxRow* r2);
static gint _list_list_entry_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static void user_lists_widget_finalize (GObject* obj);
static void _vala_user_lists_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_user_lists_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void user_lists_widget_hide_user_list_entry (UserListsWidget* self) {
	NewListEntry* _tmp0_ = NULL;
	NewListEntry* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	_tmp0_ = self->priv->new_list_entry;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->new_list_entry;
	gtk_widget_set_no_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp2_ = self->priv->user_list_label;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), TRUE);
	self->priv->show_create_entry = FALSE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void user_lists_widget_row_activated (UserListsWidget* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_NEW_LIST_ENTRY)) {
		GtkListBoxRow* _tmp1_ = NULL;
		_tmp1_ = row;
		new_list_entry_reveal (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_NEW_LIST_ENTRY, NewListEntry));
	} else {
		ListListEntry* entry = NULL;
		GtkListBoxRow* _tmp2_ = NULL;
		ListListEntry* _tmp3_ = NULL;
		Bundle* bundle = NULL;
		Bundle* _tmp4_ = NULL;
		Bundle* _tmp5_ = NULL;
		ListListEntry* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		Bundle* _tmp8_ = NULL;
		ListListEntry* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		Bundle* _tmp12_ = NULL;
		ListListEntry* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		Bundle* _tmp15_ = NULL;
		ListListEntry* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		Bundle* _tmp19_ = NULL;
		ListListEntry* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		Bundle* _tmp22_ = NULL;
		ListListEntry* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		Bundle* _tmp25_ = NULL;
		ListListEntry* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		Bundle* _tmp28_ = NULL;
		ListListEntry* _tmp29_ = NULL;
		gint64 _tmp30_ = 0LL;
		Bundle* _tmp31_ = NULL;
		ListListEntry* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		MainWindow* _tmp34_ = NULL;
		MainWidget* _tmp35_ = NULL;
		Bundle* _tmp36_ = NULL;
		_tmp2_ = row;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_LIST_LIST_ENTRY, ListListEntry));
		entry = _tmp3_;
		_tmp4_ = bundle_new ();
		bundle = _tmp4_;
		_tmp5_ = bundle;
		_tmp6_ = entry;
		_tmp7_ = _tmp6_->id;
		bundle_put_int64 (_tmp5_, "list_id", _tmp7_);
		_tmp8_ = bundle;
		_tmp9_ = entry;
		_tmp10_ = list_list_entry_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		bundle_put_string (_tmp8_, "name", _tmp11_);
		_tmp12_ = bundle;
		_tmp13_ = entry;
		_tmp14_ = _tmp13_->user_list;
		bundle_put_bool (_tmp12_, "user_list", _tmp14_);
		_tmp15_ = bundle;
		_tmp16_ = entry;
		_tmp17_ = list_list_entry_get_description (_tmp16_);
		_tmp18_ = _tmp17_;
		bundle_put_string (_tmp15_, "description", _tmp18_);
		_tmp19_ = bundle;
		_tmp20_ = entry;
		_tmp21_ = _tmp20_->creator_screen_name;
		bundle_put_string (_tmp19_, "creator", _tmp21_);
		_tmp22_ = bundle;
		_tmp23_ = entry;
		_tmp24_ = _tmp23_->n_subscribers;
		bundle_put_int (_tmp22_, "n_subscribers", _tmp24_);
		_tmp25_ = bundle;
		_tmp26_ = entry;
		_tmp27_ = _tmp26_->n_members;
		bundle_put_int (_tmp25_, "n_members", _tmp27_);
		_tmp28_ = bundle;
		_tmp29_ = entry;
		_tmp30_ = _tmp29_->created_at;
		bundle_put_int64 (_tmp28_, "created_at", _tmp30_);
		_tmp31_ = bundle;
		_tmp32_ = entry;
		_tmp33_ = _tmp32_->mode;
		bundle_put_string (_tmp31_, "mode", _tmp33_);
		_tmp34_ = self->priv->_main_window;
		_tmp35_ = _tmp34_->main_widget;
		_tmp36_ = bundle;
		main_widget_switch_page (_tmp35_, (gint) PAGE_LIST_STATUSES, _tmp36_);
		_g_object_unref0 (bundle);
		_g_object_unref0 (entry);
	}
}


static void _user_lists_widget_row_activated_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	user_lists_widget_row_activated ((UserListsWidget*) self, row);
}


static void user_lists_widget_load_lists_data_free (gpointer _data) {
	UserListsWidgetLoadListsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UserListsWidgetLoadListsData, _data_);
}


void user_lists_widget_load_lists (UserListsWidget* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UserListsWidgetLoadListsData* _data_;
	UserListsWidget* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	_data_ = g_slice_new0 (UserListsWidgetLoadListsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, user_lists_widget_load_lists);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, user_lists_widget_load_lists_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = user_id;
	_data_->user_id = _tmp1_;
	user_lists_widget_load_lists_co (_data_);
}


void user_lists_widget_load_lists_finish (UserListsWidget* self, GAsyncResult* _res_) {
	UserListsWidgetLoadListsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block42Data* block42_data_ref (Block42Data* _data42_) {
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}


static void block42_data_unref (void * _userdata_) {
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		UserListsWidget* self;
		self = _data42_->self;
		_g_object_unref0 (_data42_->collect_obj);
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void __lambda135_ (Block42Data* _data42_, GObject* _, GAsyncResult* res) {
	UserListsWidget* self;
	JsonNode* root = NULL;
	GAsyncResult* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	guint n_subscribed_list = 0U;
	JsonNode* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	self = _data42_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_);
	root = _tmp1_;
	_tmp2_ = root;
	_tmp3_ = self->priv->subscribed_list_box;
	_tmp4_ = user_lists_widget_lists_received_cb (self, _tmp2_, _tmp3_);
	n_subscribed_list = _tmp4_;
	_tmp5_ = n_subscribed_list;
	if (_tmp5_ == ((guint) 0)) {
		GtkListBox* _tmp6_ = NULL;
		GtkFrame* _tmp7_ = NULL;
		GtkLabel* _tmp8_ = NULL;
		_tmp6_ = self->priv->subscribed_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
		_tmp7_ = self->priv->subscribed_list_frame;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
		_tmp8_ = self->priv->subscribed_list_label;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	} else {
		GtkListBox* _tmp9_ = NULL;
		GtkFrame* _tmp10_ = NULL;
		GtkLabel* _tmp11_ = NULL;
		_tmp9_ = self->priv->subscribed_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
		_tmp10_ = self->priv->subscribed_list_frame;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
		_tmp11_ = self->priv->subscribed_list_label;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	}
	collect_emit (_data42_->collect_obj, NULL);
	__vala_JsonNode_free0 (root);
}


static void ___lambda135__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda135_ (self, source_object, res);
	block42_data_unref (self);
}


static void __lambda137_ (Block42Data* _data42_, GObject* _, GAsyncResult* res) {
	UserListsWidget* self;
	JsonNode* root = NULL;
	GAsyncResult* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	guint n_user_list = 0U;
	JsonNode* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	guint _tmp6_ = 0U;
	self = _data42_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_);
	root = _tmp1_;
	_tmp2_ = root;
	_tmp3_ = self->priv->user_list_box;
	_tmp4_ = user_lists_widget_lists_received_cb (self, _tmp2_, _tmp3_);
	n_user_list = _tmp4_;
	_tmp6_ = n_user_list;
	if (_tmp6_ == ((guint) 0)) {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = self->priv->show_create_entry;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GtkLabel* _tmp8_ = NULL;
		GtkListBox* _tmp9_ = NULL;
		GtkFrame* _tmp10_ = NULL;
		GtkFrame* _tmp11_ = NULL;
		_tmp8_ = self->priv->user_list_label;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		_tmp9_ = self->priv->user_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
		_tmp10_ = self->priv->user_list_frame;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
		_tmp11_ = self->priv->user_list_frame;
		gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), 0);
	} else {
		GtkLabel* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
		GtkFrame* _tmp16_ = NULL;
		GtkListBox* _tmp17_ = NULL;
		GtkFrame* _tmp18_ = NULL;
		_tmp12_ = self->priv->user_list_label;
		_tmp13_ = self->priv->show_create_entry;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), !_tmp13_);
		_tmp15_ = self->priv->show_create_entry;
		if (_tmp15_) {
			_tmp14_ = 24;
		} else {
			_tmp14_ = 0;
		}
		_tmp16_ = self->priv->user_list_frame;
		gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), _tmp14_);
		_tmp17_ = self->priv->user_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
		_tmp18_ = self->priv->user_list_frame;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
	}
	collect_emit (_data42_->collect_obj, NULL);
	__vala_JsonNode_free0 (root);
}


static void ___lambda137__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda137_ (self, source_object, res);
	block42_data_unref (self);
}


static void __lambda138_ (Block42Data* _data42_) {
	UserListsWidget* self;
	self = _data42_->self;
	user_lists_widget_load_lists_co (_data42_->_async_data_);
}


static void ___lambda138__collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	__lambda138_ (self);
}


static gboolean user_lists_widget_load_lists_co (UserListsWidgetLoadListsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data42_ = g_slice_new0 (Block42Data);
	_data_->_data42_->_ref_count_ = 1;
	_data_->_data42_->self = g_object_ref (_data_->self);
	_data_->_data42_->_async_data_ = _data_;
	_data_->_tmp0_ = 0LL;
	_data_->_tmp0_ = _data_->user_id;
	if (_data_->_tmp0_ == ((gint64) 0)) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->self->priv->_account;
		_data_->_tmp2_ = 0LL;
		_data_->_tmp2_ = account_get_id (_data_->_tmp1_);
		_data_->_tmp3_ = 0LL;
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->user_id = _data_->_tmp3_;
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = collect_new (2);
	_data_->_data42_->collect_obj = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->self->priv->_account;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = account_get_proxy (_data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp8_;
	rest_proxy_call_set_function (_data_->call, "1.1/lists/subscriptions.json");
	rest_proxy_call_set_method (_data_->call, "GET");
	_data_->_tmp9_ = 0LL;
	_data_->_tmp9_ = _data_->user_id;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp9_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	rest_proxy_call_add_param (_data_->call, "user_id", _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	tweet_utils_load_threaded (_data_->call, ___lambda135__gasync_ready_callback, block42_data_ref (_data_->_data42_));
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->self->priv->_account;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = account_get_proxy (_data_->_tmp12_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, rest_proxy_get_type (), RestProxy));
	_data_->user_call = _data_->_tmp15_;
	rest_proxy_call_set_function (_data_->user_call, "1.1/lists/ownerships.json");
	rest_proxy_call_set_method (_data_->user_call, "GET");
	_data_->_tmp16_ = 0LL;
	_data_->_tmp16_ = _data_->user_id;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp16_);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->_tmp17_;
	rest_proxy_call_add_param (_data_->user_call, "user_id", _data_->_tmp18_);
	_g_free0 (_data_->_tmp18_);
	tweet_utils_load_threaded (_data_->user_call, ___lambda137__gasync_ready_callback, block42_data_ref (_data_->_data42_));
	g_signal_connect_data (_data_->_data42_->collect_obj, "finished", (GCallback) ___lambda138__collect_finished, block42_data_ref (_data_->_data42_), (GClosureNotify) block42_data_unref, 0);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_g_object_unref0 (_data_->user_call);
	_g_object_unref0 (_data_->call);
	block42_data_unref (_data_->_data42_);
	_data_->_data42_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block43Data* block43_data_ref (Block43Data* _data43_) {
	g_atomic_int_inc (&_data43_->_ref_count_);
	return _data43_;
}


static void block43_data_unref (void * _userdata_) {
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
		UserListsWidget* self;
		self = _data43_->self;
		_g_object_unref0 (_data43_->list_box);
		_g_object_unref0 (self);
		g_slice_free (Block43Data, _data43_);
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void __lambda136_ (Block43Data* _data43_, JsonArray* array, guint index, JsonNode* node) {
	UserListsWidget* self;
	JsonObject* obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	ListListEntry* entry = NULL;
	Account* _tmp3_ = NULL;
	ListListEntry* _tmp4_ = NULL;
	GtkListBox* _tmp5_ = NULL;
	self = _data43_->self;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	obj = _tmp2_;
	_tmp3_ = self->priv->_account;
	_tmp4_ = list_list_entry_new_from_json_data (obj, _tmp3_);
	g_object_ref_sink (_tmp4_);
	entry = _tmp4_;
	_tmp5_ = _data43_->list_box;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (entry);
	_json_object_unref0 (obj);
}


static void ___lambda136__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda136_ (self, array, index_, element_node);
}


static guint user_lists_widget_lists_received_cb (UserListsWidget* self, JsonNode* root, GtkListBox* list_box) {
	guint result = 0U;
	Block43Data* _data43_;
	GtkListBox* _tmp0_ = NULL;
	GtkListBox* _tmp1_ = NULL;
	JsonNode* _tmp2_ = NULL;
	JsonArray* arr = NULL;
	JsonNode* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	JsonArray* _tmp7_ = NULL;
	JsonArray* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	g_return_val_if_fail (IS_USER_LISTS_WIDGET (self), 0U);
	g_return_val_if_fail (GTK_IS_LIST_BOX (list_box), 0U);
	_data43_ = g_slice_new0 (Block43Data);
	_data43_->_ref_count_ = 1;
	_data43_->self = g_object_ref (self);
	_tmp0_ = list_box;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data43_->list_box);
	_data43_->list_box = _tmp1_;
	_tmp2_ = root;
	if (_tmp2_ == NULL) {
		result = (guint) 0;
		block43_data_unref (_data43_);
		_data43_ = NULL;
		return result;
	}
	_tmp3_ = root;
	_tmp4_ = json_node_get_object (_tmp3_);
	_tmp5_ = json_object_get_array_member (_tmp4_, "lists");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	arr = _tmp6_;
	_tmp7_ = arr;
	json_array_foreach_element (_tmp7_, ___lambda136__json_array_foreach, _data43_);
	_tmp8_ = arr;
	_tmp9_ = json_array_get_length (_tmp8_);
	result = _tmp9_;
	_json_array_unref0 (arr);
	block43_data_unref (_data43_);
	_data43_ = NULL;
	return result;
}


static Block44Data* block44_data_ref (Block44Data* _data44_) {
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}


static void block44_data_unref (void * _userdata_) {
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		UserListsWidget* self;
		self = _data44_->self;
		_g_object_unref0 (self);
		g_slice_free (Block44Data, _data44_);
	}
}


static void __lambda139_ (Block44Data* _data44_, GtkWidget* w) {
	UserListsWidget* self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	self = _data44_->self;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LIST_LIST_ENTRY)) {
		return;
	}
	_tmp1_ = w;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIST_LIST_ENTRY, ListListEntry)->id;
	_tmp3_ = _data44_->list_id;
	if (_tmp2_ == _tmp3_) {
		GtkListBox* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		_tmp4_ = self->priv->user_list_box;
		_tmp5_ = w;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer), _tmp5_);
	}
}


static void ___lambda139__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda139_ (self, widget);
}


static void __lambda140_ (Block44Data* _data44_, GtkWidget* w) {
	UserListsWidget* self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	self = _data44_->self;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LIST_LIST_ENTRY)) {
		return;
	}
	_tmp1_ = w;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIST_LIST_ENTRY, ListListEntry)->id;
	_tmp3_ = _data44_->list_id;
	if (_tmp2_ == _tmp3_) {
		GtkListBox* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		_tmp4_ = self->priv->subscribed_list_box;
		_tmp5_ = w;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer), _tmp5_);
	}
}


static void ___lambda140__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda140_ (self, widget);
}


void user_lists_widget_remove_list (UserListsWidget* self, gint64 list_id) {
	Block44Data* _data44_;
	gint64 _tmp0_ = 0LL;
	GtkListBox* _tmp1_ = NULL;
	GtkListBox* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	_data44_ = g_slice_new0 (Block44Data);
	_data44_->_ref_count_ = 1;
	_data44_->self = g_object_ref (self);
	_tmp0_ = list_id;
	_data44_->list_id = _tmp0_;
	_tmp1_ = self->priv->user_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer), ___lambda139__gtk_callback, _data44_);
	_tmp2_ = self->priv->subscribed_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer), ___lambda140__gtk_callback, _data44_);
	_tmp3_ = self->priv->subscribed_list_box;
	_tmp4_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_list_length (_tmp5_);
	_tmp7_ = _tmp6_ == ((guint) 0);
	_g_list_free0 (_tmp5_);
	if (_tmp7_) {
		GtkLabel* _tmp8_ = NULL;
		GtkFrame* _tmp9_ = NULL;
		_tmp8_ = self->priv->subscribed_list_label;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		_tmp9_ = self->priv->subscribed_list_frame;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	}
	block44_data_unref (_data44_);
	_data44_ = NULL;
}


void user_lists_widget_add_list (UserListsWidget* self, ListListEntry* entry) {
	ListListEntry* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	g_return_if_fail (IS_LIST_LIST_ENTRY (entry));
	_tmp0_ = entry;
	_tmp1_ = _tmp0_->user_list;
	if (_tmp1_) {
		GList* user_lists = NULL;
		GtkListBox* _tmp2_ = NULL;
		GList* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		GtkListBox* _tmp11_ = NULL;
		ListListEntry* _tmp12_ = NULL;
		_tmp2_ = self->priv->user_list_box;
		_tmp3_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer));
		user_lists = _tmp3_;
		_tmp4_ = user_lists;
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp4_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp5_ = NULL;
				GtkWidget* w = NULL;
				_tmp5_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp5_;
				{
					GtkWidget* _tmp6_ = NULL;
					GtkWidget* _tmp7_ = NULL;
					gint64 _tmp8_ = 0LL;
					ListListEntry* _tmp9_ = NULL;
					gint64 _tmp10_ = 0LL;
					_tmp6_ = w;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_LIST_LIST_ENTRY)) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp7_ = w;
					_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_LIST_LIST_ENTRY, ListListEntry)->id;
					_tmp9_ = entry;
					_tmp10_ = _tmp9_->id;
					if (_tmp8_ == _tmp10_) {
						_g_object_unref0 (w);
						_g_list_free0 (user_lists);
						return;
					}
					_g_object_unref0 (w);
				}
			}
		}
		_tmp11_ = self->priv->user_list_box;
		_tmp12_ = entry;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
		_g_list_free0 (user_lists);
	} else {
		GList* subscribed_lists = NULL;
		GtkListBox* _tmp13_ = NULL;
		GList* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		GtkListBox* _tmp22_ = NULL;
		ListListEntry* _tmp23_ = NULL;
		GtkFrame* _tmp24_ = NULL;
		GtkListBox* _tmp25_ = NULL;
		GtkLabel* _tmp26_ = NULL;
		_tmp13_ = self->priv->subscribed_list_box;
		_tmp14_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_container_get_type (), GtkContainer));
		subscribed_lists = _tmp14_;
		_tmp15_ = subscribed_lists;
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp15_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp16_ = NULL;
				GtkWidget* w = NULL;
				_tmp16_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp16_;
				{
					GtkWidget* _tmp17_ = NULL;
					GtkWidget* _tmp18_ = NULL;
					gint64 _tmp19_ = 0LL;
					ListListEntry* _tmp20_ = NULL;
					gint64 _tmp21_ = 0LL;
					_tmp17_ = w;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, TYPE_LIST_LIST_ENTRY)) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp18_ = w;
					_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_LIST_LIST_ENTRY, ListListEntry)->id;
					_tmp20_ = entry;
					_tmp21_ = _tmp20_->id;
					if (_tmp19_ == _tmp21_) {
						_g_object_unref0 (w);
						_g_list_free0 (subscribed_lists);
						return;
					}
					_g_object_unref0 (w);
				}
			}
		}
		_tmp22_ = self->priv->subscribed_list_box;
		_tmp23_ = entry;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget));
		_tmp24_ = self->priv->subscribed_list_frame;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
		_tmp25_ = self->priv->subscribed_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
		_tmp26_ = self->priv->subscribed_list_label;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget));
		_g_list_free0 (subscribed_lists);
	}
}


static Block45Data* block45_data_ref (Block45Data* _data45_) {
	g_atomic_int_inc (&_data45_->_ref_count_);
	return _data45_;
}


static void block45_data_unref (void * _userdata_) {
	Block45Data* _data45_;
	_data45_ = (Block45Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data45_->_ref_count_)) {
		UserListsWidget* self;
		self = _data45_->self;
		_g_free0 (_data45_->name);
		_g_free0 (_data45_->description);
		_g_free0 (_data45_->mode);
		_g_object_unref0 (self);
		g_slice_free (Block45Data, _data45_);
	}
}


static void __lambda141_ (Block45Data* _data45_, GtkWidget* w) {
	UserListsWidget* self;
	GtkWidget* _tmp0_ = NULL;
	ListListEntry* lle = NULL;
	GtkWidget* _tmp1_ = NULL;
	ListListEntry* _tmp2_ = NULL;
	ListListEntry* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	self = _data45_->self;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LIST_LIST_ENTRY)) {
		return;
	}
	_tmp1_ = w;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIST_LIST_ENTRY, ListListEntry));
	lle = _tmp2_;
	_tmp3_ = lle;
	_tmp4_ = _tmp3_->id;
	_tmp5_ = _data45_->list_id;
	if (_tmp4_ == _tmp5_) {
		ListListEntry* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		ListListEntry* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		ListListEntry* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		ListListEntry* _tmp13_ = NULL;
		_tmp6_ = lle;
		_tmp7_ = _data45_->name;
		list_list_entry_set_name (_tmp6_, _tmp7_);
		_tmp8_ = lle;
		_tmp9_ = _data45_->description;
		list_list_entry_set_description (_tmp8_, _tmp9_);
		_tmp10_ = lle;
		_tmp11_ = _data45_->mode;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (_tmp10_->mode);
		_tmp10_->mode = _tmp12_;
		_tmp13_ = lle;
		gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
	}
	_g_object_unref0 (lle);
}


static void ___lambda141__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda141_ (self, widget);
}


void user_lists_widget_update_list (UserListsWidget* self, gint64 list_id, const gchar* name, const gchar* description, const gchar* mode) {
	Block45Data* _data45_;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GtkListBox* _tmp7_ = NULL;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	g_return_if_fail (name != NULL);
	g_return_if_fail (description != NULL);
	g_return_if_fail (mode != NULL);
	_data45_ = g_slice_new0 (Block45Data);
	_data45_->_ref_count_ = 1;
	_data45_->self = g_object_ref (self);
	_tmp0_ = list_id;
	_data45_->list_id = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data45_->name);
	_data45_->name = _tmp2_;
	_tmp3_ = description;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data45_->description);
	_data45_->description = _tmp4_;
	_tmp5_ = mode;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data45_->mode);
	_data45_->mode = _tmp6_;
	_tmp7_ = self->priv->user_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer), ___lambda141__gtk_callback, _data45_);
	block45_data_unref (_data45_);
	_data45_ = NULL;
}


void user_lists_widget_update_member_count (UserListsWidget* self, gint64 list_id, gint increase) {
	GList* lists = NULL;
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	_tmp0_ = self->priv->user_list_box;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	lists = _tmp1_;
	_tmp2_ = lists;
	{
		GList* list_collection = NULL;
		GList* list_it = NULL;
		list_collection = _tmp2_;
		for (list_it = list_collection; list_it != NULL; list_it = list_it->next) {
			GtkWidget* list = NULL;
			list = (GtkWidget*) list_it->data;
			{
				GtkWidget* _tmp3_ = NULL;
				ListListEntry* lle = NULL;
				GtkWidget* _tmp4_ = NULL;
				ListListEntry* _tmp5_ = NULL;
				ListListEntry* _tmp6_ = NULL;
				gint64 _tmp7_ = 0LL;
				gint64 _tmp8_ = 0LL;
				_tmp3_ = list;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_LIST_LIST_ENTRY)) {
					continue;
				}
				_tmp4_ = list;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_LIST_LIST_ENTRY, ListListEntry));
				lle = _tmp5_;
				_tmp6_ = lle;
				_tmp7_ = _tmp6_->id;
				_tmp8_ = list_id;
				if (_tmp7_ == _tmp8_) {
					ListListEntry* _tmp9_ = NULL;
					ListListEntry* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					_tmp9_ = lle;
					_tmp10_ = lle;
					_tmp11_ = _tmp10_->n_members;
					_tmp12_ = increase;
					_tmp10_->n_members = _tmp11_ + _tmp12_;
					_g_object_unref0 (lle);
					break;
				}
				_g_object_unref0 (lle);
			}
		}
	}
	_g_list_free0 (lists);
}


static void _vala_TwitterList_array_free (TwitterList* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			twitter_list_destroy (&array[i]);
		}
	}
	g_free (array);
}


TwitterList* user_lists_widget_get_user_lists (UserListsWidget* self, int* result_length1) {
	TwitterList* result = NULL;
	GList* children = NULL;
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	TwitterList* lists = NULL;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	TwitterList* _tmp4_ = NULL;
	gint lists_length1 = 0;
	gint _lists_size_ = 0;
	gint i = 0;
	GList* _tmp5_ = NULL;
	TwitterList* _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	g_return_val_if_fail (IS_USER_LISTS_WIDGET (self), NULL);
	_tmp0_ = self->priv->user_list_box;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	children = _tmp1_;
	_tmp2_ = children;
	_tmp3_ = g_list_length (_tmp2_);
	_tmp4_ = g_new0 (TwitterList, _tmp3_ - 1);
	lists = _tmp4_;
	lists_length1 = _tmp3_ - 1;
	_lists_size_ = lists_length1;
	i = 0;
	_tmp5_ = children;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp5_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp6_ = NULL;
			GtkWidget* w = NULL;
			_tmp6_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp6_;
			{
				GtkWidget* _tmp7_ = NULL;
				ListListEntry* lle = NULL;
				GtkWidget* _tmp8_ = NULL;
				ListListEntry* _tmp9_ = NULL;
				TwitterList* _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				ListListEntry* _tmp12_ = NULL;
				gint64 _tmp13_ = 0LL;
				TwitterList* _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gint _tmp15_ = 0;
				ListListEntry* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				TwitterList* _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				gint _tmp21_ = 0;
				ListListEntry* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				TwitterList* _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				ListListEntry* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				_tmp7_ = w;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_LIST_LIST_ENTRY)) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp8_ = w;
				_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_LIST_LIST_ENTRY, ListListEntry));
				lle = _tmp9_;
				_tmp10_ = lists;
				_tmp10__length1 = lists_length1;
				_tmp11_ = i;
				_tmp12_ = lle;
				_tmp13_ = _tmp12_->id;
				_tmp10_[_tmp11_].id = _tmp13_;
				_tmp14_ = lists;
				_tmp14__length1 = lists_length1;
				_tmp15_ = i;
				_tmp16_ = lle;
				_tmp17_ = list_list_entry_get_name (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strdup (_tmp18_);
				_g_free0 (_tmp14_[_tmp15_].name);
				_tmp14_[_tmp15_].name = _tmp19_;
				_tmp20_ = lists;
				_tmp20__length1 = lists_length1;
				_tmp21_ = i;
				_tmp22_ = lle;
				_tmp23_ = list_list_entry_get_description (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strdup (_tmp24_);
				_g_free0 (_tmp20_[_tmp21_].description);
				_tmp20_[_tmp21_].description = _tmp25_;
				_tmp26_ = lists;
				_tmp26__length1 = lists_length1;
				_tmp27_ = i;
				_tmp28_ = lle;
				_tmp29_ = _tmp28_->mode;
				_tmp30_ = g_strdup (_tmp29_);
				_g_free0 (_tmp26_[_tmp27_].mode);
				_tmp26_[_tmp27_].mode = _tmp30_;
				_tmp31_ = i;
				i = _tmp31_ + 1;
				_g_object_unref0 (lle);
				_g_object_unref0 (w);
			}
		}
	}
	_tmp32_ = lists;
	_tmp32__length1 = lists_length1;
	if (result_length1) {
		*result_length1 = _tmp32__length1;
	}
	result = _tmp32_;
	_g_list_free0 (children);
	return result;
}


static void __lambda142_ (UserListsWidget* self, GtkWidget* w) {
	GtkListBox* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->user_list_box;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda142__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda142_ ((UserListsWidget*) self, widget);
}


static void __lambda143_ (UserListsWidget* self, GtkWidget* w) {
	GtkListBox* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->subscribed_list_box;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda143__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda143_ ((UserListsWidget*) self, widget);
}


void user_lists_widget_clear_lists (UserListsWidget* self) {
	GtkListBox* _tmp0_ = NULL;
	GtkListBox* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	_tmp0_ = self->priv->user_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), ___lambda142__gtk_callback, self);
	_tmp1_ = self->priv->subscribed_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer), ___lambda143__gtk_callback, self);
}


static Block46Data* block46_data_ref (Block46Data* _data46_) {
	g_atomic_int_inc (&_data46_->_ref_count_);
	return _data46_;
}


static void block46_data_unref (void * _userdata_) {
	Block46Data* _data46_;
	_data46_ = (Block46Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data46_->_ref_count_)) {
		UserListsWidget* self;
		self = _data46_->self;
		_g_object_unref0 (_data46_->call);
		_g_object_unref0 (self);
		g_slice_free (Block46Data, _data46_);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda144_ (Block46Data* _data46_, GObject* o, GAsyncResult* res) {
	UserListsWidget* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp7_ = NULL;
	JsonObject* root = NULL;
	JsonParser* _tmp13_ = NULL;
	JsonNode* _tmp14_ = NULL;
	JsonObject* _tmp15_ = NULL;
	JsonObject* _tmp16_ = NULL;
	ListListEntry* entry = NULL;
	JsonObject* _tmp17_ = NULL;
	Account* _tmp18_ = NULL;
	ListListEntry* _tmp19_ = NULL;
	ListListEntry* _tmp20_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp21_ = NULL;
	Bundle* _tmp22_ = NULL;
	ListListEntry* _tmp23_ = NULL;
	gint64 _tmp24_ = 0LL;
	Bundle* _tmp25_ = NULL;
	ListListEntry* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	Bundle* _tmp29_ = NULL;
	Bundle* _tmp30_ = NULL;
	ListListEntry* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	Bundle* _tmp34_ = NULL;
	ListListEntry* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	Bundle* _tmp37_ = NULL;
	ListListEntry* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	Bundle* _tmp40_ = NULL;
	ListListEntry* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	Bundle* _tmp43_ = NULL;
	ListListEntry* _tmp44_ = NULL;
	gint64 _tmp45_ = 0LL;
	Bundle* _tmp46_ = NULL;
	ListListEntry* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	MainWindow* _tmp49_ = NULL;
	MainWidget* _tmp50_ = NULL;
	Bundle* _tmp51_ = NULL;
	NewListEntry* _tmp52_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data46_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data46_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch48_g_error;
		}
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		NewListEntry* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data46_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 270, "UserListsWidget.vala");
		_tmp6_ = self->priv->new_list_entry;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), TRUE);
		_g_error_free0 (e);
		return;
	}
	__finally48:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = json_parser_new ();
	parser = _tmp7_;
	{
		JsonParser* _tmp8_ = NULL;
		RestProxyCall* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp8_ = parser;
		_tmp9_ = _data46_->call;
		_tmp10_ = rest_proxy_call_get_payload (_tmp9_);
		json_parser_load_from_data (_tmp8_, _tmp10_, (gssize) (-1), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch49_g_error;
		}
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("UserListsWidget.vala:278: %s", _tmp12_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return;
	}
	__finally49:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = parser;
	_tmp14_ = json_parser_get_root (_tmp13_);
	_tmp15_ = json_node_get_object (_tmp14_);
	_tmp16_ = _json_object_ref0 (_tmp15_);
	root = _tmp16_;
	_tmp17_ = root;
	_tmp18_ = self->priv->_account;
	_tmp19_ = list_list_entry_new_from_json_data (_tmp17_, _tmp18_);
	g_object_ref_sink (_tmp19_);
	entry = _tmp19_;
	_tmp20_ = entry;
	user_lists_widget_add_list (self, _tmp20_);
	_tmp21_ = bundle_new ();
	bundle = _tmp21_;
	_tmp22_ = bundle;
	_tmp23_ = entry;
	_tmp24_ = _tmp23_->id;
	bundle_put_int64 (_tmp22_, "list_id", _tmp24_);
	_tmp25_ = bundle;
	_tmp26_ = entry;
	_tmp27_ = list_list_entry_get_name (_tmp26_);
	_tmp28_ = _tmp27_;
	bundle_put_string (_tmp25_, "name", _tmp28_);
	_tmp29_ = bundle;
	bundle_put_bool (_tmp29_, "user_list", TRUE);
	_tmp30_ = bundle;
	_tmp31_ = entry;
	_tmp32_ = list_list_entry_get_description (_tmp31_);
	_tmp33_ = _tmp32_;
	bundle_put_string (_tmp30_, "description", _tmp33_);
	_tmp34_ = bundle;
	_tmp35_ = entry;
	_tmp36_ = _tmp35_->creator_screen_name;
	bundle_put_string (_tmp34_, "creator", _tmp36_);
	_tmp37_ = bundle;
	_tmp38_ = entry;
	_tmp39_ = _tmp38_->n_subscribers;
	bundle_put_int (_tmp37_, "n_subscribers", _tmp39_);
	_tmp40_ = bundle;
	_tmp41_ = entry;
	_tmp42_ = _tmp41_->n_members;
	bundle_put_int (_tmp40_, "n_members", _tmp42_);
	_tmp43_ = bundle;
	_tmp44_ = entry;
	_tmp45_ = _tmp44_->created_at;
	bundle_put_int64 (_tmp43_, "created_at", _tmp45_);
	_tmp46_ = bundle;
	_tmp47_ = entry;
	_tmp48_ = _tmp47_->mode;
	bundle_put_string (_tmp46_, "mode", _tmp48_);
	_tmp49_ = self->priv->_main_window;
	_tmp50_ = _tmp49_->main_widget;
	_tmp51_ = bundle;
	main_widget_switch_page (_tmp50_, (gint) PAGE_LIST_STATUSES, _tmp51_);
	_tmp52_ = self->priv->new_list_entry;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_widget_get_type (), GtkWidget), TRUE);
	_g_object_unref0 (bundle);
	_g_object_unref0 (entry);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
}


static void ___lambda144__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda144_ (self, source_object, res);
	block46_data_unref (self);
}


static void user_lists_widget_new_list_create_activated_cb (UserListsWidget* self, const gchar* list_name) {
	Block46Data* _data46_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	NewListEntry* _tmp6_ = NULL;
	Account* _tmp7_ = NULL;
	OAuthProxy* _tmp8_ = NULL;
	OAuthProxy* _tmp9_ = NULL;
	RestProxyCall* _tmp10_ = NULL;
	RestProxyCall* _tmp11_ = NULL;
	RestProxyCall* _tmp12_ = NULL;
	RestProxyCall* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	RestProxyCall* _tmp15_ = NULL;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	g_return_if_fail (list_name != NULL);
	_data46_ = g_slice_new0 (Block46Data);
	_data46_->_ref_count_ = 1;
	_data46_->self = g_object_ref (self);
	_tmp0_ = list_name;
	_tmp1_ = string_strip (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ <= 0;
	_g_free0 (_tmp2_);
	if (_tmp5_) {
		block46_data_unref (_data46_);
		_data46_ = NULL;
		return;
	}
	_tmp6_ = self->priv->new_list_entry;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp7_ = self->priv->_account;
	_tmp8_ = account_get_proxy (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, rest_proxy_get_type (), RestProxy));
	_data46_->call = _tmp10_;
	_tmp11_ = _data46_->call;
	rest_proxy_call_set_function (_tmp11_, "1.1/lists/create.json");
	_tmp12_ = _data46_->call;
	rest_proxy_call_set_method (_tmp12_, "POST");
	_tmp13_ = _data46_->call;
	_tmp14_ = list_name;
	rest_proxy_call_add_param (_tmp13_, "name", _tmp14_);
	_tmp15_ = _data46_->call;
	rest_proxy_call_invoke_async (_tmp15_, NULL, ___lambda144__gasync_ready_callback, block46_data_ref (_data46_));
	block46_data_unref (_data46_);
	_data46_ = NULL;
}


static void _user_lists_widget_new_list_create_activated_cb_new_list_entry_create_activated (NewListEntry* _sender, const gchar* list_name, gpointer self) {
	user_lists_widget_new_list_create_activated_cb ((UserListsWidget*) self, list_name);
}


void user_lists_widget_unreveal (UserListsWidget* self) {
	NewListEntry* _tmp0_ = NULL;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	_tmp0_ = self->priv->new_list_entry;
	new_list_entry_unreveal (_tmp0_);
}


UserListsWidget* user_lists_widget_construct (GType object_type) {
	UserListsWidget * self = NULL;
	self = (UserListsWidget*) g_object_new (object_type, NULL);
	return self;
}


UserListsWidget* user_lists_widget_new (void) {
	return user_lists_widget_construct (TYPE_USER_LISTS_WIDGET);
}


MainWindow* user_lists_widget_get_main_window (UserListsWidget* self) {
	MainWindow* result;
	MainWindow* _tmp0_ = NULL;
	g_return_val_if_fail (IS_USER_LISTS_WIDGET (self), NULL);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


void user_lists_widget_set_main_window (UserListsWidget* self, MainWindow* value) {
	MainWindow* _tmp0_ = NULL;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	_tmp0_ = value;
	self->priv->_main_window = _tmp0_;
	g_object_notify ((GObject *) self, "main-window");
}


Account* user_lists_widget_get_account (UserListsWidget* self) {
	Account* result;
	Account* _tmp0_ = NULL;
	g_return_val_if_fail (IS_USER_LISTS_WIDGET (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


void user_lists_widget_set_account (UserListsWidget* self, Account* value) {
	Account* _tmp0_ = NULL;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	_tmp0_ = value;
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	default_header_func (row, before);
}


static gint _list_list_entry_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = list_list_entry_sort_func (row1, row2);
	return result;
}


static GObject * user_lists_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UserListsWidget * self;
	GtkListBox* _tmp0_ = NULL;
	GtkListBox* _tmp1_ = NULL;
	GtkListBox* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (user_lists_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_LISTS_WIDGET, UserListsWidget);
	_tmp0_ = self->priv->user_list_box;
	gtk_list_box_set_header_func (_tmp0_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp1_ = self->priv->user_list_box;
	gtk_list_box_set_sort_func (_tmp1_, _list_list_entry_sort_func_gtk_list_box_sort_func, NULL, NULL);
	_tmp2_ = self->priv->subscribed_list_box;
	gtk_list_box_set_header_func (_tmp2_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp3_ = self->priv->subscribed_list_box;
	gtk_list_box_set_sort_func (_tmp3_, _list_list_entry_sort_func_gtk_list_box_sort_func, NULL, NULL);
	return obj;
}


static void user_lists_widget_class_init (UserListsWidgetClass * klass) {
	gint UserListsWidget_private_offset;
	user_lists_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserListsWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_user_lists_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_user_lists_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = user_lists_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = user_lists_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LISTS_WIDGET_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LISTS_WIDGET_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	UserListsWidget_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/user-lists-widget.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list_label", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, user_list_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list_box", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, user_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list_frame", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, user_list_frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "subscribed_list_label", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, subscribed_list_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "subscribed_list_box", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, subscribed_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "subscribed_list_frame", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, subscribed_list_frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_list_entry", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, new_list_entry));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "row_activated", G_CALLBACK(_user_lists_widget_row_activated_gtk_list_box_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "new_list_create_activated_cb", G_CALLBACK(_user_lists_widget_new_list_create_activated_cb_new_list_entry_create_activated));
}


static void user_lists_widget_instance_init (UserListsWidget * self) {
	self->priv = USER_LISTS_WIDGET_GET_PRIVATE (self);
	self->priv->show_create_entry = TRUE;
	g_type_ensure (TYPE_NEW_LIST_ENTRY);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void user_lists_widget_finalize (GObject* obj) {
	UserListsWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_LISTS_WIDGET, UserListsWidget);
	_g_object_unref0 (self->priv->user_list_label);
	_g_object_unref0 (self->priv->user_list_box);
	_g_object_unref0 (self->priv->user_list_frame);
	_g_object_unref0 (self->priv->subscribed_list_label);
	_g_object_unref0 (self->priv->subscribed_list_box);
	_g_object_unref0 (self->priv->subscribed_list_frame);
	_g_object_unref0 (self->priv->new_list_entry);
	G_OBJECT_CLASS (user_lists_widget_parent_class)->finalize (obj);
}


GType user_lists_widget_get_type (void) {
	static volatile gsize user_lists_widget_type_id__volatile = 0;
	if (g_once_init_enter (&user_lists_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserListsWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_lists_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserListsWidget), 0, (GInstanceInitFunc) user_lists_widget_instance_init, NULL };
		GType user_lists_widget_type_id;
		user_lists_widget_type_id = g_type_register_static (gtk_box_get_type (), "UserListsWidget", &g_define_type_info, 0);
		g_once_init_leave (&user_lists_widget_type_id__volatile, user_lists_widget_type_id);
	}
	return user_lists_widget_type_id__volatile;
}


static void _vala_user_lists_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UserListsWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_LISTS_WIDGET, UserListsWidget);
	switch (property_id) {
		case USER_LISTS_WIDGET_MAIN_WINDOW:
		g_value_set_object (value, user_lists_widget_get_main_window (self));
		break;
		case USER_LISTS_WIDGET_ACCOUNT:
		g_value_set_object (value, user_lists_widget_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_user_lists_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UserListsWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_LISTS_WIDGET, UserListsWidget);
	switch (property_id) {
		case USER_LISTS_WIDGET_MAIN_WINDOW:
		user_lists_widget_set_main_window (self, g_value_get_object (value));
		break;
		case USER_LISTS_WIDGET_ACCOUNT:
		user_lists_widget_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



