/* ComposeTweetWindow.c generated by valac 0.26.2, the Vala compiler
 * generated from ComposeTweetWindow.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <rest/oauth-proxy.h>
#include <gio/gio.h>
#include <rest/rest-proxy.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-param.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;
typedef struct _ComposeTweetWindowPrivate ComposeTweetWindowPrivate;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())

#define TYPE_ADD_IMAGE_BUTTON (add_image_button_get_type ())
#define ADD_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_IMAGE_BUTTON, AddImageButton))
#define ADD_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_IMAGE_BUTTON, AddImageButtonClass))
#define IS_ADD_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_IMAGE_BUTTON))
#define IS_ADD_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_IMAGE_BUTTON))
#define ADD_IMAGE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_IMAGE_BUTTON, AddImageButtonClass))

typedef struct _AddImageButton AddImageButton;
typedef struct _AddImageButtonClass AddImageButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
typedef struct _Block66Data Block66Data;
typedef struct _Block67Data Block67Data;
typedef struct _Block68Data Block68Data;
typedef struct _AddImageButtonPrivate AddImageButtonPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block69Data Block69Data;
#define _rest_param_unref0(var) ((var == NULL) ? NULL : (var = (rest_param_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _ComposeTweetWindowUploadMediaData ComposeTweetWindowUploadMediaData;
typedef struct _Block70Data Block70Data;
typedef struct _Block71Data Block71Data;
typedef struct _Block72Data Block72Data;

struct _ComposeTweetWindow {
	GtkApplicationWindow parent_instance;
	ComposeTweetWindowPrivate * priv;
};

struct _ComposeTweetWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _ComposeTweetWindowPrivate {
	AvatarWidget* avatar_image;
	GtkBox* content_box;
	CompletionTextView* tweet_text;
	GtkLabel* length_label;
	GtkButton* send_button;
	GtkButton* cancel_button;
	GtkSpinner* title_spinner;
	GtkLabel* title_label;
	GtkStack* title_stack;
	Account* account;
	Tweet* reply_to;
	ComposeTweetWindowMode mode;
	GeeArrayList* image_buttons;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	gint64 id;
	gint64 rt_id;
	gchar* text;
	gint64 user_id;
	gchar* user_name;
	gchar* retweeted_by;
	gchar* rt_by_screen_name;
	gint64 rt_by_id;
	gboolean is_retweet;
	GdkPixbuf* inline_media;
	gchar* time_delta;
	gchar* avatar_url;
	gchar* avatar_name;
	gchar* screen_name;
	gint64 created_at;
	gint64 rt_created_at;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gint64 reply_id;
	Media** medias;
	gint medias_length1;
	gint retweet_count;
	gint favorite_count;
	gchar** mentions;
	gint mentions_length1;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _Block66Data {
	int _ref_count_;
	ComposeTweetWindow* self;
	Collect* collect_obj;
	gint64* media_ids;
	gint media_ids_length1;
	gint _media_ids_size_;
};

struct _Block67Data {
	int _ref_count_;
	Block66Data * _data66_;
	AddImageButton* aib;
};

struct _Block68Data {
	int _ref_count_;
	Block67Data * _data67_;
	gint k;
};

struct _AddImageButton {
	GtkButton parent_instance;
	AddImageButtonPrivate * priv;
	gchar* image_path;
};

struct _AddImageButtonClass {
	GtkButtonClass parent_class;
};

struct _Block69Data {
	int _ref_count_;
	ComposeTweetWindow* self;
	RestProxyCall* call;
};

struct _ComposeTweetWindowUploadMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ComposeTweetWindow* self;
	gchar* path;
	RestProxy* proxy;
	gint64 result;
	RestProxyCall* call;
	RestProxy* _tmp0_;
	RestProxyCall* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	guint8* file_contents;
	gint file_contents_length1;
	gint _file_contents_size_;
	GFile* media_file;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	guint8* _tmp7_;
	gsize _tmp8_;
	RestParam* param;
	guint8* _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	RestParam* _tmp11_;
	RestProxyCall* _tmp12_;
	RestParam* _tmp13_;
	RestProxyCall* _tmp14_;
	JsonParser* parser;
	JsonParser* _tmp15_;
	JsonParser* _tmp16_;
	RestProxyCall* _tmp17_;
	const gchar* _tmp18_;
	GError* e;
	GError* _tmp19_;
	const gchar* _tmp20_;
	JsonObject* root;
	JsonParser* _tmp21_;
	JsonNode* _tmp22_;
	JsonObject* _tmp23_;
	JsonObject* _tmp24_;
	JsonObject* _tmp25_;
	gint64 _tmp26_;
	GError * _inner_error_;
};

struct _Block70Data {
	int _ref_count_;
	ComposeTweetWindow* self;
	AddImageButton* image_button;
};

struct _Block71Data {
	int _ref_count_;
	ComposeTweetWindow* self;
	GtkFileChooserDialog* fcd;
	GtkImage* preview_widget;
};

struct _Block72Data {
	int _ref_count_;
	ComposeTweetWindow* self;
	GtkRevealer* revealer;
	AddImageButton* source;
};


static gpointer compose_tweet_window_parent_class = NULL;

GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType completion_text_view_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
GType add_image_button_get_type (void) G_GNUC_CONST;
#define COMPOSE_TWEET_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowPrivate))
enum  {
	COMPOSE_TWEET_WINDOW_DUMMY_PROPERTY
};
ComposeTweetWindow* compose_tweet_window_new (GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode, GtkApplication* app);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode, GtkApplication* app);
void completion_text_view_set_account (CompletionTextView* self, Account* account);
GdkPixbuf* account_get_avatar (Account* self);
#define TWEET_MAX_LENGTH 140
static void compose_tweet_window_buffer_changed_cb (ComposeTweetWindow* self);
static void _compose_tweet_window_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
TweetListEntry* tweet_list_entry_new (Tweet* tweet, MainWindow* window, Account* account);
TweetListEntry* tweet_list_entry_construct (GType object_type, Tweet* tweet, MainWindow* window, Account* account);
void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value);
GType media_get_type (void) G_GNUC_CONST;
const gchar* account_get_screen_name (Account* self);
gchar* utils_unescape_html (const gchar* input);
gchar* tweet_get_real_text (Tweet* self);
static gboolean compose_tweet_window_escape_pressed_cb (ComposeTweetWindow* self);
static gboolean _compose_tweet_window_escape_pressed_cb_gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda51_ (ComposeTweetWindow* self);
static void compose_tweet_window_start_send_tweet (ComposeTweetWindow* self);
static gboolean ___lambda51__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static void compose_tweet_window_add_image_button (ComposeTweetWindow* self, gboolean initially_visible);
static void compose_tweet_window_recalc_tweet_length (ComposeTweetWindow* self);
static gint compose_tweet_window_get_effective_media_count (ComposeTweetWindow* self);
gint tweet_utils_calc_tweet_length (const gchar* text, gint media_count);
GType collect_get_type (void) G_GNUC_CONST;
static Block66Data* block66_data_ref (Block66Data* _data66_);
static void block66_data_unref (void * _userdata_);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
GdkPixbuf* add_image_button_get_image (AddImageButton* self);
gchar* settings_get_consumer_key (void);
gchar* settings_get_consumer_secret (void);
OAuthProxy* account_get_proxy (Account* self);
static Block67Data* block67_data_ref (Block67Data* _data67_);
static void block67_data_unref (void * _userdata_);
static Block68Data* block68_data_ref (Block68Data* _data68_);
static void block68_data_unref (void * _userdata_);
void add_image_button_start_progress (AddImageButton* self);
static void compose_tweet_window_upload_media (ComposeTweetWindow* self, const gchar* path, RestProxy* proxy, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gint64 compose_tweet_window_upload_media_finish (ComposeTweetWindow* self, GAsyncResult* _res_, GError** error);
static void ______lambda52_ (Block68Data* _data68_, GObject* obj, GAsyncResult* res);
void collect_emit (Collect* self, GError* _error_);
void add_image_button_set_error (AddImageButton* self, const gchar* error_message);
void add_image_button_set_success (AddImageButton* self);
static void _______lambda52__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda53_ (Block66Data* _data66_, GError* _error_);
static void compose_tweet_window_send_tweet (ComposeTweetWindow* self, GError* _error_, gint64* ids, int ids_length1);
static void ____lambda53__collect_finished (Collect* _sender, GError* _error_, gpointer self);
static void _compose_tweet_window_start_send_tweet_gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block69Data* block69_data_ref (Block69Data* _data69_);
static void block69_data_unref (void * _userdata_);
static void __lambda54_ (Block69Data* _data69_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
static void ___lambda54__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void compose_tweet_window_upload_media_data_free (gpointer _data);
static gboolean compose_tweet_window_upload_media_co (ComposeTweetWindowUploadMediaData* _data_);
static void compose_tweet_window_upload_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void compose_tweet_window_cancel_clicked (ComposeTweetWindow* self, GtkWidget* source);
static void _compose_tweet_window_cancel_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
void compose_tweet_window_set_text (ComposeTweetWindow* self, const gchar* text);
static Block70Data* block70_data_ref (Block70Data* _data70_);
static void block70_data_unref (void * _userdata_);
gint twitter_get_max_media_per_upload (void);
AddImageButton* add_image_button_new (void);
AddImageButton* add_image_button_construct (GType object_type);
static void compose_tweet_window_remove_image_clicked_cb (ComposeTweetWindow* self, AddImageButton* source);
static void _compose_tweet_window_remove_image_clicked_cb_add_image_button_remove_clicked (AddImageButton* _sender, gpointer self);
static void compose_tweet_window_add_image_clicked_cb (ComposeTweetWindow* self, AddImageButton* source);
static void _compose_tweet_window_add_image_clicked_cb_add_image_button_add_clicked (AddImageButton* _sender, gpointer self);
static void __lambda59_ (Block70Data* _data70_);
static void ___lambda59__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block71Data* block71_data_ref (Block71Data* _data71_);
static void block71_data_unref (void * _userdata_);
static void __lambda58_ (Block71Data* _data71_);
static void ___lambda58__gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self);
GdkPixbuf* utils_slice_pixbuf (GdkPixbuf* pic, gint thumb_width, gint thumb_height);
#define MULTI_MEDIA_WIDGET_HEIGHT 60
void add_image_button_set_image (AddImageButton* self, GdkPixbuf* value);
static Block72Data* block72_data_ref (Block72Data* _data72_);
static void block72_data_unref (void * _userdata_);
static void __lambda57_ (Block72Data* _data72_);
static void ___lambda57__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void compose_tweet_window_finalize (GObject* obj);


GType compose_tweet_window_mode_get_type (void) {
	static volatile gsize compose_tweet_window_mode_type_id__volatile = 0;
	if (g_once_init_enter (&compose_tweet_window_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{COMPOSE_TWEET_WINDOW_MODE_NORMAL, "COMPOSE_TWEET_WINDOW_MODE_NORMAL", "normal"}, {COMPOSE_TWEET_WINDOW_MODE_REPLY, "COMPOSE_TWEET_WINDOW_MODE_REPLY", "reply"}, {COMPOSE_TWEET_WINDOW_MODE_QUOTE, "COMPOSE_TWEET_WINDOW_MODE_QUOTE", "quote"}, {0, NULL, NULL}};
		GType compose_tweet_window_mode_type_id;
		compose_tweet_window_mode_type_id = g_enum_register_static ("ComposeTweetWindowMode", values);
		g_once_init_leave (&compose_tweet_window_mode_type_id__volatile, compose_tweet_window_mode_type_id);
	}
	return compose_tweet_window_mode_type_id__volatile;
}


static void _compose_tweet_window_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	compose_tweet_window_buffer_changed_cb ((ComposeTweetWindow*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _compose_tweet_window_escape_pressed_cb_gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = compose_tweet_window_escape_pressed_cb ((ComposeTweetWindow*) self);
	return result;
}


static gboolean __lambda51_ (ComposeTweetWindow* self) {
	gboolean result = FALSE;
	compose_tweet_window_start_send_tweet (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda51__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda51_ ((ComposeTweetWindow*) self);
	return result;
}


ComposeTweetWindow* compose_tweet_window_construct (GType object_type, GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode, GtkApplication* app) {
	ComposeTweetWindow * self = NULL;
	Account* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	ComposeTweetWindowMode _tmp2_ = 0;
	CompletionTextView* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkApplication* _tmp6_ = NULL;
	GeeArrayList* _tmp12_ = NULL;
	AvatarWidget* _tmp13_ = NULL;
	Account* _tmp14_ = NULL;
	GdkPixbuf* _tmp15_ = NULL;
	GdkPixbuf* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	CompletionTextView* _tmp20_ = NULL;
	GtkTextBuffer* _tmp21_ = NULL;
	GtkTextBuffer* _tmp22_ = NULL;
	GtkWindow* _tmp23_ = NULL;
	ComposeTweetWindowMode _tmp25_ = 0;
	ComposeTweetWindowMode _tmp43_ = 0;
	CompletionTextView* _tmp100_ = NULL;
	GtkAccelGroup* ag = NULL;
	GtkAccelGroup* _tmp101_ = NULL;
	g_return_val_if_fail ((parent == NULL) || GTK_IS_WINDOW (parent), NULL);
	g_return_val_if_fail (IS_ACCOUNT (acc), NULL);
	g_return_val_if_fail ((reply_to == NULL) || IS_TWEET (reply_to), NULL);
	g_return_val_if_fail ((app == NULL) || GTK_IS_APPLICATION (app), NULL);
	self = (ComposeTweetWindow*) g_object_new (object_type, NULL);
	gtk_application_window_set_show_menubar (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), FALSE);
	_tmp0_ = acc;
	self->priv->account = _tmp0_;
	_tmp1_ = reply_to;
	self->priv->reply_to = _tmp1_;
	_tmp2_ = mode;
	self->priv->mode = _tmp2_;
	_tmp3_ = self->priv->tweet_text;
	_tmp4_ = acc;
	completion_text_view_set_account (_tmp3_, _tmp4_);
	_tmp6_ = app;
	if (_tmp6_ == NULL) {
		GtkWindow* _tmp7_ = NULL;
		_tmp7_ = parent;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_application_window_get_type ());
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GtkWindow* _tmp8_ = NULL;
		GtkApplication* _tmp9_ = NULL;
		GtkApplication* _tmp10_ = NULL;
		_tmp8_ = parent;
		_tmp9_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_application_window_get_type (), GtkApplicationWindow), gtk_window_get_type (), GtkWindow));
		_tmp10_ = _tmp9_;
		gtk_window_set_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp10_);
	} else {
		GtkApplication* _tmp11_ = NULL;
		_tmp11_ = app;
		gtk_window_set_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp11_);
	}
	_tmp12_ = gee_array_list_new (TYPE_ADD_IMAGE_BUTTON, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->image_buttons);
	self->priv->image_buttons = _tmp12_;
	_tmp13_ = self->priv->avatar_image;
	_tmp14_ = acc;
	_tmp15_ = account_get_avatar (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_image_set_from_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_image_get_type (), GtkImage), _tmp16_);
	_tmp17_ = self->priv->length_label;
	_tmp18_ = g_strdup_printf ("%i", TWEET_MAX_LENGTH);
	_tmp19_ = _tmp18_;
	gtk_label_set_label (_tmp17_, _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = self->priv->tweet_text;
	_tmp21_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_text_view_get_type (), GtkTextView));
	_tmp22_ = _tmp21_;
	g_signal_connect_object (_tmp22_, "changed", (GCallback) _compose_tweet_window_buffer_changed_cb_gtk_text_buffer_changed, self, 0);
	_tmp23_ = parent;
	if (_tmp23_ != NULL) {
		GtkWindow* _tmp24_ = NULL;
		_tmp24_ = parent;
		gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp24_);
	}
	_tmp25_ = mode;
	if (_tmp25_ != COMPOSE_TWEET_WINDOW_MODE_NORMAL) {
		GtkListBox* list = NULL;
		GtkListBox* _tmp26_ = NULL;
		GtkListBox* _tmp27_ = NULL;
		TweetListEntry* reply_entry = NULL;
		Tweet* _tmp28_ = NULL;
		Tweet* _tmp29_ = NULL;
		GtkWindow* _tmp30_ = NULL;
		Account* _tmp31_ = NULL;
		TweetListEntry* _tmp32_ = NULL;
		TweetListEntry* _tmp33_ = NULL;
		TweetListEntry* _tmp34_ = NULL;
		TweetListEntry* _tmp35_ = NULL;
		GtkListBox* _tmp36_ = NULL;
		TweetListEntry* _tmp37_ = NULL;
		GtkListBox* _tmp38_ = NULL;
		GtkBox* _tmp39_ = NULL;
		GtkListBox* _tmp40_ = NULL;
		GtkBox* _tmp41_ = NULL;
		GtkListBox* _tmp42_ = NULL;
		_tmp26_ = (GtkListBox*) gtk_list_box_new ();
		g_object_ref_sink (_tmp26_);
		list = _tmp26_;
		_tmp27_ = list;
		gtk_list_box_set_selection_mode (_tmp27_, GTK_SELECTION_NONE);
		_tmp28_ = reply_to;
		_tmp29_ = _g_object_ref0 (_tmp28_);
		_tmp30_ = parent;
		_tmp31_ = acc;
		_tmp32_ = tweet_list_entry_new (_tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_MAIN_WINDOW, MainWindow), _tmp31_);
		g_object_ref_sink (_tmp32_);
		reply_entry = _tmp32_;
		_tmp33_ = reply_entry;
		gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
		_tmp34_ = reply_entry;
		tweet_list_entry_set_read_only (_tmp34_, TRUE);
		_tmp35_ = reply_entry;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget));
		_tmp36_ = list;
		_tmp37_ = reply_entry;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
		_tmp38_ = list;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget));
		_tmp39_ = self->priv->content_box;
		_tmp40_ = list;
		gtk_box_pack_start (_tmp39_, G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_widget_get_type (), GtkWidget), FALSE, TRUE, (guint) 0);
		_tmp41_ = self->priv->content_box;
		_tmp42_ = list;
		gtk_box_reorder_child (_tmp41_, G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_widget_get_type (), GtkWidget), 0);
		_g_object_unref0 (reply_entry);
		_g_object_unref0 (list);
	}
	_tmp43_ = mode;
	if (_tmp43_ == COMPOSE_TWEET_WINDOW_MODE_REPLY) {
		GString* mention_builder = NULL;
		GString* _tmp44_ = NULL;
		Tweet* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		Account* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		Tweet* _tmp54_ = NULL;
		gboolean _tmp55_ = FALSE;
		Tweet* _tmp63_ = NULL;
		gchar** _tmp64_ = NULL;
		gint _tmp64__length1 = 0;
		GString* _tmp71_ = NULL;
		gssize _tmp72_ = 0L;
		CompletionTextView* _tmp74_ = NULL;
		GtkTextBuffer* _tmp75_ = NULL;
		GtkTextBuffer* _tmp76_ = NULL;
		GString* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
		_tmp44_ = g_string_new ("");
		mention_builder = _tmp44_;
		_tmp45_ = reply_to;
		_tmp46_ = _tmp45_->screen_name;
		_tmp47_ = self->priv->account;
		_tmp48_ = account_get_screen_name (_tmp47_);
		_tmp49_ = _tmp48_;
		if (g_strcmp0 (_tmp46_, _tmp49_) != 0) {
			GString* _tmp50_ = NULL;
			GString* _tmp51_ = NULL;
			Tweet* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			_tmp50_ = mention_builder;
			_tmp51_ = g_string_append (_tmp50_, "@");
			_tmp52_ = reply_to;
			_tmp53_ = _tmp52_->screen_name;
			g_string_append (_tmp51_, _tmp53_);
		}
		_tmp54_ = reply_to;
		_tmp55_ = _tmp54_->is_retweet;
		if (_tmp55_) {
			GString* _tmp56_ = NULL;
			gssize _tmp57_ = 0L;
			GString* _tmp59_ = NULL;
			GString* _tmp60_ = NULL;
			Tweet* _tmp61_ = NULL;
			const gchar* _tmp62_ = NULL;
			_tmp56_ = mention_builder;
			_tmp57_ = _tmp56_->len;
			if (_tmp57_ > ((gssize) 0)) {
				GString* _tmp58_ = NULL;
				_tmp58_ = mention_builder;
				g_string_append (_tmp58_, " ");
			}
			_tmp59_ = mention_builder;
			_tmp60_ = g_string_append (_tmp59_, "@");
			_tmp61_ = reply_to;
			_tmp62_ = _tmp61_->rt_by_screen_name;
			g_string_append (_tmp60_, _tmp62_);
		}
		_tmp63_ = reply_to;
		_tmp64_ = _tmp63_->mentions;
		_tmp64__length1 = _tmp63_->mentions_length1;
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp64_;
			s_collection_length1 = _tmp64__length1;
			for (s_it = 0; s_it < _tmp64__length1; s_it = s_it + 1) {
				gchar* _tmp65_ = NULL;
				gchar* s = NULL;
				_tmp65_ = g_strdup (s_collection[s_it]);
				s = _tmp65_;
				{
					GString* _tmp66_ = NULL;
					gssize _tmp67_ = 0L;
					GString* _tmp69_ = NULL;
					const gchar* _tmp70_ = NULL;
					_tmp66_ = mention_builder;
					_tmp67_ = _tmp66_->len;
					if (_tmp67_ > ((gssize) 0)) {
						GString* _tmp68_ = NULL;
						_tmp68_ = mention_builder;
						g_string_append (_tmp68_, " ");
					}
					_tmp69_ = mention_builder;
					_tmp70_ = s;
					g_string_append (_tmp69_, _tmp70_);
					_g_free0 (s);
				}
			}
		}
		_tmp71_ = mention_builder;
		_tmp72_ = _tmp71_->len;
		if (_tmp72_ > ((gssize) 0)) {
			GString* _tmp73_ = NULL;
			_tmp73_ = mention_builder;
			g_string_append (_tmp73_, " ");
		}
		_tmp74_ = self->priv->tweet_text;
		_tmp75_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, gtk_text_view_get_type (), GtkTextView));
		_tmp76_ = _tmp75_;
		_tmp77_ = mention_builder;
		_tmp78_ = _tmp77_->str;
		g_object_set (_tmp76_, "text", _tmp78_, NULL);
		_g_string_free0 (mention_builder);
	} else {
		ComposeTweetWindowMode _tmp79_ = 0;
		_tmp79_ = mode;
		if (_tmp79_ == COMPOSE_TWEET_WINDOW_MODE_QUOTE) {
			CompletionTextView* _tmp80_ = NULL;
			GtkTextBuffer* _tmp81_ = NULL;
			GtkTextBuffer* _tmp82_ = NULL;
			Tweet* _tmp83_ = NULL;
			const gchar* _tmp84_ = NULL;
			Tweet* _tmp85_ = NULL;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_ = NULL;
			gchar* _tmp88_ = NULL;
			gchar* _tmp89_ = NULL;
			gchar* _tmp90_ = NULL;
			gchar* _tmp91_ = NULL;
			GtkTextIter start_iter = {0};
			CompletionTextView* _tmp92_ = NULL;
			GtkTextBuffer* _tmp93_ = NULL;
			GtkTextBuffer* _tmp94_ = NULL;
			GtkTextIter _tmp95_ = {0};
			CompletionTextView* _tmp96_ = NULL;
			GtkTextBuffer* _tmp97_ = NULL;
			GtkTextBuffer* _tmp98_ = NULL;
			GtkTextIter _tmp99_ = {0};
			_tmp80_ = self->priv->tweet_text;
			_tmp81_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, gtk_text_view_get_type (), GtkTextView));
			_tmp82_ = _tmp81_;
			_tmp83_ = reply_to;
			_tmp84_ = _tmp83_->screen_name;
			_tmp85_ = reply_to;
			_tmp86_ = tweet_get_real_text (_tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = utils_unescape_html (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = g_strdup_printf (" RT @%s “%s“", _tmp84_, _tmp89_);
			_tmp91_ = _tmp90_;
			g_object_set (_tmp82_, "text", _tmp91_, NULL);
			_g_free0 (_tmp91_);
			_g_free0 (_tmp89_);
			_g_free0 (_tmp87_);
			_tmp92_ = self->priv->tweet_text;
			_tmp93_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, gtk_text_view_get_type (), GtkTextView));
			_tmp94_ = _tmp93_;
			gtk_text_buffer_get_start_iter (_tmp94_, &_tmp95_);
			start_iter = _tmp95_;
			_tmp96_ = self->priv->tweet_text;
			_tmp97_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, gtk_text_view_get_type (), GtkTextView));
			_tmp98_ = _tmp97_;
			_tmp99_ = start_iter;
			gtk_text_buffer_place_cursor (_tmp98_, &_tmp99_);
		}
	}
	_tmp100_ = self->priv->tweet_text;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, gtk_widget_get_type (), GtkWidget));
	_tmp101_ = gtk_accel_group_new ();
	ag = _tmp101_;
	gtk_accel_group_connect (ag, (guint) GDK_KEY_Escape, 0, GTK_ACCEL_LOCKED, (GClosure*) ((_compose_tweet_window_escape_pressed_cb_gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) _compose_tweet_window_escape_pressed_cb_gtk_accel_group_activate, g_object_ref (self), g_object_unref)));
	gtk_accel_group_connect (ag, (guint) GDK_KEY_Return, GDK_CONTROL_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda51__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda51__gtk_accel_group_activate, g_object_ref (self), g_object_unref)));
	gtk_window_add_accel_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), ag);
	compose_tweet_window_add_image_button (self, TRUE);
	_g_object_unref0 (ag);
	return self;
}


ComposeTweetWindow* compose_tweet_window_new (GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode, GtkApplication* app) {
	return compose_tweet_window_construct (TYPE_COMPOSE_TWEET_WINDOW, parent, acc, reply_to, mode, app);
}


static void compose_tweet_window_buffer_changed_cb (ComposeTweetWindow* self) {
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	compose_tweet_window_recalc_tweet_length (self);
}


static void compose_tweet_window_recalc_tweet_length (ComposeTweetWindow* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	CompletionTextView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gchar* text = NULL;
	CompletionTextView* _tmp5_ = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextBuffer* _tmp7_ = NULL;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gchar* _tmp10_ = NULL;
	gint media_count = 0;
	gint _tmp11_ = 0;
	gint length = 0;
	const gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GtkLabel* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_ = 0;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	_tmp0_ = self->priv->tweet_text;
	_tmp1_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_text_view_get_type (), GtkTextView));
	_tmp2_ = _tmp1_;
	gtk_text_buffer_get_bounds (_tmp2_, &_tmp3_, &_tmp4_);
	start = _tmp3_;
	end = _tmp4_;
	_tmp5_ = self->priv->tweet_text;
	_tmp6_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_text_view_get_type (), GtkTextView));
	_tmp7_ = _tmp6_;
	_tmp8_ = start;
	_tmp9_ = end;
	_tmp10_ = gtk_text_buffer_get_text (_tmp7_, &_tmp8_, &_tmp9_, TRUE);
	text = _tmp10_;
	media_count = 0;
	_tmp11_ = compose_tweet_window_get_effective_media_count (self);
	if (_tmp11_ > 0) {
		media_count = 1;
	}
	_tmp12_ = text;
	_tmp13_ = media_count;
	_tmp14_ = tweet_utils_calc_tweet_length (_tmp12_, _tmp13_);
	length = _tmp14_;
	_tmp15_ = self->priv->length_label;
	_tmp16_ = length;
	_tmp17_ = g_strdup_printf ("%i", TWEET_MAX_LENGTH - _tmp16_);
	_tmp18_ = _tmp17_;
	gtk_label_set_label (_tmp15_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp20_ = length;
	if (_tmp20_ > 0) {
		gint _tmp21_ = 0;
		_tmp21_ = length;
		_tmp19_ = _tmp21_ <= TWEET_MAX_LENGTH;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		GtkButton* _tmp22_ = NULL;
		_tmp22_ = self->priv->send_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), TRUE);
	} else {
		GtkButton* _tmp23_ = NULL;
		_tmp23_ = self->priv->send_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_g_free0 (text);
}


static Block66Data* block66_data_ref (Block66Data* _data66_) {
	g_atomic_int_inc (&_data66_->_ref_count_);
	return _data66_;
}


static void block66_data_unref (void * _userdata_) {
	Block66Data* _data66_;
	_data66_ = (Block66Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data66_->_ref_count_)) {
		ComposeTweetWindow* self;
		self = _data66_->self;
		_data66_->media_ids = (g_free (_data66_->media_ids), NULL);
		_g_object_unref0 (_data66_->collect_obj);
		_g_object_unref0 (self);
		g_slice_free (Block66Data, _data66_);
	}
}


static Block67Data* block67_data_ref (Block67Data* _data67_) {
	g_atomic_int_inc (&_data67_->_ref_count_);
	return _data67_;
}


static void block67_data_unref (void * _userdata_) {
	Block67Data* _data67_;
	_data67_ = (Block67Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data67_->_ref_count_)) {
		ComposeTweetWindow* self;
		self = _data67_->_data66_->self;
		_g_object_unref0 (_data67_->aib);
		block66_data_unref (_data67_->_data66_);
		_data67_->_data66_ = NULL;
		g_slice_free (Block67Data, _data67_);
	}
}


static Block68Data* block68_data_ref (Block68Data* _data68_) {
	g_atomic_int_inc (&_data68_->_ref_count_);
	return _data68_;
}


static void block68_data_unref (void * _userdata_) {
	Block68Data* _data68_;
	_data68_ = (Block68Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data68_->_ref_count_)) {
		ComposeTweetWindow* self;
		self = _data68_->_data67_->_data66_->self;
		block67_data_unref (_data68_->_data67_);
		_data68_->_data67_ = NULL;
		g_slice_free (Block68Data, _data68_);
	}
}


static void ______lambda52_ (Block68Data* _data68_, GObject* obj, GAsyncResult* res) {
	Block67Data* _data67_;
	Block66Data* _data66_;
	ComposeTweetWindow* self;
	gint64 id = 0LL;
	AddImageButton* _tmp10_ = NULL;
	gint64* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp12_ = 0;
	gint64 _tmp13_ = 0LL;
	gint64 _tmp14_ = 0LL;
	Collect* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
	_data67_ = _data68_->_data67_;
	_data66_ = _data67_->_data66_;
	self = _data66_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		gint64 _tmp0_ = 0LL;
		GAsyncResult* _tmp1_ = NULL;
		gint64 _tmp2_ = 0LL;
		_tmp1_ = res;
		_tmp2_ = compose_tweet_window_upload_media_finish (self, _tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch81_g_error;
		}
		id = _tmp0_;
	}
	goto __finally81;
	__catch81_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		Collect* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		AddImageButton* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("ComposeTweetWindow.vala:199: %s", _tmp4_);
		_tmp5_ = _data66_->collect_obj;
		_tmp6_ = e;
		collect_emit (_tmp5_, _tmp6_);
		_tmp7_ = _data67_->aib;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		add_image_button_set_error (_tmp7_, _tmp9_);
		_g_error_free0 (e);
		return;
	}
	__finally81:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = _data67_->aib;
	add_image_button_set_success (_tmp10_);
	_tmp11_ = _data66_->media_ids;
	_tmp11__length1 = _data66_->media_ids_length1;
	_tmp12_ = _data68_->k;
	_tmp13_ = id;
	_tmp11_[_tmp12_] = _tmp13_;
	_tmp14_ = _tmp11_[_tmp12_];
	_tmp15_ = _data66_->collect_obj;
	collect_emit (_tmp15_, NULL);
}


static void _______lambda52__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	______lambda52_ (self, source_object, res);
	block68_data_unref (self);
}


static void ___lambda53_ (Block66Data* _data66_, GError* _error_) {
	ComposeTweetWindow* self;
	GtkStack* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	CompletionTextView* _tmp4_ = NULL;
	GError* _tmp5_ = NULL;
	gint64* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	self = _data66_->self;
	_tmp0_ = self->priv->title_stack;
	_tmp1_ = self->priv->title_label;
	gtk_stack_set_visible_child (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = self->priv->cancel_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp3_ = self->priv->send_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp4_ = self->priv->tweet_text;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp5_ = _error_;
	_tmp6_ = _data66_->media_ids;
	_tmp6__length1 = _data66_->media_ids_length1;
	compose_tweet_window_send_tweet (self, _tmp5_, _tmp6_, _tmp6__length1);
}


static void ____lambda53__collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	___lambda53_ (self, _error_);
}


static void compose_tweet_window_start_send_tweet (ComposeTweetWindow* self) {
	Block66Data* _data66_;
	GtkButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint media_count = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Collect* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint64* _tmp7_ = NULL;
	GtkStack* _tmp8_ = NULL;
	GtkSpinner* _tmp9_ = NULL;
	GtkSpinner* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	CompletionTextView* _tmp13_ = NULL;
	gint _tmp29_ = 0;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	_data66_ = g_slice_new0 (Block66Data);
	_data66_->_ref_count_ = 1;
	_data66_->self = g_object_ref (self);
	_tmp0_ = self->priv->send_button;
	_tmp1_ = gtk_widget_get_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		block66_data_unref (_data66_);
		_data66_ = NULL;
		return;
	}
	_tmp3_ = compose_tweet_window_get_effective_media_count (self);
	media_count = _tmp3_;
	_tmp4_ = media_count;
	_tmp5_ = collect_new (_tmp4_);
	_data66_->collect_obj = _tmp5_;
	_tmp6_ = media_count;
	_tmp7_ = g_new0 (gint64, _tmp6_);
	_data66_->media_ids = _tmp7_;
	_data66_->media_ids_length1 = _tmp6_;
	_data66_->_media_ids_size_ = _data66_->media_ids_length1;
	_tmp8_ = self->priv->title_stack;
	_tmp9_ = self->priv->title_spinner;
	gtk_stack_set_visible_child (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = self->priv->title_spinner;
	gtk_spinner_start (_tmp10_);
	_tmp11_ = self->priv->cancel_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp12_ = self->priv->send_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp13_ = self->priv->tweet_text;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), FALSE);
	{
		GeeArrayList* _btn_list = NULL;
		GeeArrayList* _tmp14_ = NULL;
		GeeArrayList* _tmp15_ = NULL;
		gint _btn_size = 0;
		GeeArrayList* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _btn_index = 0;
		_tmp14_ = self->priv->image_buttons;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_btn_list = _tmp15_;
		_tmp16_ = _btn_list;
		_tmp17_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp18_ = _tmp17_;
		_btn_size = _tmp18_;
		_btn_index = -1;
		while (TRUE) {
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			AddImageButton* btn = NULL;
			GeeArrayList* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gpointer _tmp24_ = NULL;
			AddImageButton* _tmp25_ = NULL;
			GdkPixbuf* _tmp26_ = NULL;
			GdkPixbuf* _tmp27_ = NULL;
			_tmp19_ = _btn_index;
			_btn_index = _tmp19_ + 1;
			_tmp20_ = _btn_index;
			_tmp21_ = _btn_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _btn_list;
			_tmp23_ = _btn_index;
			_tmp24_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp23_);
			btn = (AddImageButton*) _tmp24_;
			_tmp25_ = btn;
			_tmp26_ = add_image_button_get_image (_tmp25_);
			_tmp27_ = _tmp26_;
			if (_tmp27_ == NULL) {
				AddImageButton* _tmp28_ = NULL;
				_tmp28_ = btn;
				gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget), FALSE);
				_g_object_unref0 (btn);
				break;
			}
			_g_object_unref0 (btn);
		}
		_g_object_unref0 (_btn_list);
	}
	_tmp29_ = media_count;
	if (_tmp29_ > 0) {
		OAuthProxy* proxy = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		OAuthProxy* _tmp34_ = NULL;
		OAuthProxy* _tmp35_ = NULL;
		OAuthProxy* _tmp36_ = NULL;
		Account* _tmp37_ = NULL;
		OAuthProxy* _tmp38_ = NULL;
		OAuthProxy* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		OAuthProxy* _tmp42_ = NULL;
		Account* _tmp43_ = NULL;
		OAuthProxy* _tmp44_ = NULL;
		OAuthProxy* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gint i = 0;
		Collect* _tmp68_ = NULL;
		_tmp30_ = settings_get_consumer_key ();
		_tmp31_ = _tmp30_;
		_tmp32_ = settings_get_consumer_secret ();
		_tmp33_ = _tmp32_;
		_tmp34_ = (OAuthProxy*) oauth_proxy_new (_tmp31_, _tmp33_, "https://upload.twitter.com/", FALSE);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		proxy = _tmp35_;
		_tmp36_ = proxy;
		_tmp37_ = self->priv->account;
		_tmp38_ = account_get_proxy (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = oauth_proxy_get_token (_tmp39_);
		_tmp41_ = _tmp40_;
		oauth_proxy_set_token (_tmp36_, _tmp41_);
		_tmp42_ = proxy;
		_tmp43_ = self->priv->account;
		_tmp44_ = account_get_proxy (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = oauth_proxy_get_token_secret (_tmp45_);
		_tmp47_ = _tmp46_;
		oauth_proxy_set_token_secret (_tmp42_, _tmp47_);
		i = 0;
		{
			GeeArrayList* _aib_list = NULL;
			GeeArrayList* _tmp48_ = NULL;
			GeeArrayList* _tmp49_ = NULL;
			gint _aib_size = 0;
			GeeArrayList* _tmp50_ = NULL;
			gint _tmp51_ = 0;
			gint _tmp52_ = 0;
			gint _aib_index = 0;
			_tmp48_ = self->priv->image_buttons;
			_tmp49_ = _g_object_ref0 (_tmp48_);
			_aib_list = _tmp49_;
			_tmp50_ = _aib_list;
			_tmp51_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp52_ = _tmp51_;
			_aib_size = _tmp52_;
			_aib_index = -1;
			while (TRUE) {
				Block67Data* _data67_;
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				gint _tmp55_ = 0;
				GeeArrayList* _tmp56_ = NULL;
				gint _tmp57_ = 0;
				gpointer _tmp58_ = NULL;
				AddImageButton* _tmp59_ = NULL;
				GdkPixbuf* _tmp60_ = NULL;
				GdkPixbuf* _tmp61_ = NULL;
				_data67_ = g_slice_new0 (Block67Data);
				_data67_->_ref_count_ = 1;
				_data67_->_data66_ = block66_data_ref (_data66_);
				_tmp53_ = _aib_index;
				_aib_index = _tmp53_ + 1;
				_tmp54_ = _aib_index;
				_tmp55_ = _aib_size;
				if (!(_tmp54_ < _tmp55_)) {
					block67_data_unref (_data67_);
					_data67_ = NULL;
					break;
				}
				_tmp56_ = _aib_list;
				_tmp57_ = _aib_index;
				_tmp58_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp57_);
				_data67_->aib = (AddImageButton*) _tmp58_;
				_tmp59_ = _data67_->aib;
				_tmp60_ = add_image_button_get_image (_tmp59_);
				_tmp61_ = _tmp60_;
				if (_tmp61_ != NULL) {
					Block68Data* _data68_;
					gint _tmp62_ = 0;
					AddImageButton* _tmp63_ = NULL;
					AddImageButton* _tmp64_ = NULL;
					const gchar* _tmp65_ = NULL;
					OAuthProxy* _tmp66_ = NULL;
					gint _tmp67_ = 0;
					_data68_ = g_slice_new0 (Block68Data);
					_data68_->_ref_count_ = 1;
					_data68_->_data67_ = block67_data_ref (_data67_);
					_tmp62_ = i;
					_data68_->k = _tmp62_;
					_tmp63_ = _data67_->aib;
					add_image_button_start_progress (_tmp63_);
					_tmp64_ = _data67_->aib;
					_tmp65_ = _tmp64_->image_path;
					_tmp66_ = proxy;
					compose_tweet_window_upload_media (self, _tmp65_, G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, rest_proxy_get_type (), RestProxy), _______lambda52__gasync_ready_callback, block68_data_ref (_data68_));
					_tmp67_ = i;
					i = _tmp67_ + 1;
					block68_data_unref (_data68_);
					_data68_ = NULL;
				}
				block67_data_unref (_data67_);
				_data67_ = NULL;
			}
			_g_object_unref0 (_aib_list);
		}
		_tmp68_ = _data66_->collect_obj;
		g_signal_connect_data (_tmp68_, "finished", (GCallback) ____lambda53__collect_finished, block66_data_ref (_data66_), (GClosureNotify) block66_data_unref, 0);
		_g_object_unref0 (proxy);
	} else {
		gint64* _tmp69_ = NULL;
		gint _tmp69__length1 = 0;
		_tmp69_ = _data66_->media_ids;
		_tmp69__length1 = _data66_->media_ids_length1;
		compose_tweet_window_send_tweet (self, NULL, _tmp69_, _tmp69__length1);
	}
	block66_data_unref (_data66_);
	_data66_ = NULL;
}


static void _compose_tweet_window_start_send_tweet_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	compose_tweet_window_start_send_tweet ((ComposeTweetWindow*) self);
}


static Block69Data* block69_data_ref (Block69Data* _data69_) {
	g_atomic_int_inc (&_data69_->_ref_count_);
	return _data69_;
}


static void block69_data_unref (void * _userdata_) {
	Block69Data* _data69_;
	_data69_ = (Block69Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data69_->_ref_count_)) {
		ComposeTweetWindow* self;
		self = _data69_->self;
		_g_object_unref0 (_data69_->call);
		_g_object_unref0 (self);
		g_slice_free (Block69Data, _data69_);
	}
}


static void __lambda54_ (Block69Data* _data69_, GObject* obj, GAsyncResult* res) {
	ComposeTweetWindow* self;
	GError * _inner_error_ = NULL;
	self = _data69_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data69_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch82_g_error;
		}
	}
	goto __finally82;
	__catch82_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		RestProxyCall* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("ComposeTweetWindow.vala:256: %s", _tmp3_);
		_tmp4_ = _data69_->call;
		_tmp5_ = rest_proxy_call_get_payload (_tmp4_);
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		utils_show_error_object (_tmp5_, _tmp7_, 258, "ComposeTweetWindow.vala");
		_g_error_free0 (e);
	}
	__finally82:
	{
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda54__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda54_ (self, source_object, res);
	block69_data_unref (self);
}


static void compose_tweet_window_send_tweet (ComposeTweetWindow* self, GError* _error_, gint64* ids, int ids_length1) {
	Block69Data* _data69_;
	GError* _tmp0_ = NULL;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	CompletionTextView* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextIter _tmp6_ = {0};
	CompletionTextView* _tmp7_ = NULL;
	GtkTextBuffer* _tmp8_ = NULL;
	GtkTextBuffer* _tmp9_ = NULL;
	GtkTextIter _tmp10_ = {0};
	gchar* text = NULL;
	CompletionTextView* _tmp11_ = NULL;
	GtkTextBuffer* _tmp12_ = NULL;
	GtkTextBuffer* _tmp13_ = NULL;
	GtkTextIter _tmp14_ = {0};
	GtkTextIter _tmp15_ = {0};
	gchar* _tmp16_ = NULL;
	Account* _tmp17_ = NULL;
	OAuthProxy* _tmp18_ = NULL;
	OAuthProxy* _tmp19_ = NULL;
	RestProxyCall* _tmp20_ = NULL;
	RestProxyCall* _tmp21_ = NULL;
	RestProxyCall* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	Tweet* _tmp25_ = NULL;
	gint64* _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	RestProxyCall* _tmp53_ = NULL;
	RestProxyCall* _tmp54_ = NULL;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	_data69_ = g_slice_new0 (Block69Data);
	_data69_->_ref_count_ = 1;
	_data69_->self = g_object_ref (self);
	_tmp0_ = _error_;
	if (_tmp0_ != NULL) {
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_error ("ComposeTweetWindow.vala:227: %s", _tmp2_);
	}
	_tmp3_ = self->priv->tweet_text;
	_tmp4_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_text_view_get_type (), GtkTextView));
	_tmp5_ = _tmp4_;
	gtk_text_buffer_get_start_iter (_tmp5_, &_tmp6_);
	start = _tmp6_;
	_tmp7_ = self->priv->tweet_text;
	_tmp8_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_text_view_get_type (), GtkTextView));
	_tmp9_ = _tmp8_;
	gtk_text_buffer_get_end_iter (_tmp9_, &_tmp10_);
	end = _tmp10_;
	_tmp11_ = self->priv->tweet_text;
	_tmp12_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_text_view_get_type (), GtkTextView));
	_tmp13_ = _tmp12_;
	_tmp14_ = start;
	_tmp15_ = end;
	_tmp16_ = gtk_text_buffer_get_text (_tmp13_, &_tmp14_, &_tmp15_, TRUE);
	text = _tmp16_;
	_tmp17_ = self->priv->account;
	_tmp18_ = account_get_proxy (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, rest_proxy_get_type (), RestProxy));
	_data69_->call = _tmp20_;
	_tmp21_ = _data69_->call;
	rest_proxy_call_set_method (_tmp21_, "POST");
	_tmp22_ = _data69_->call;
	_tmp23_ = text;
	rest_proxy_call_add_param (_tmp22_, "status", _tmp23_);
	_tmp25_ = self->priv->reply_to;
	if (_tmp25_ != NULL) {
		ComposeTweetWindowMode _tmp26_ = 0;
		_tmp26_ = self->priv->mode;
		_tmp24_ = _tmp26_ == COMPOSE_TWEET_WINDOW_MODE_REPLY;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		RestProxyCall* _tmp27_ = NULL;
		Tweet* _tmp28_ = NULL;
		gint64 _tmp29_ = 0LL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		_tmp27_ = _data69_->call;
		_tmp28_ = self->priv->reply_to;
		_tmp29_ = _tmp28_->id;
		_tmp30_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp29_);
		_tmp31_ = _tmp30_;
		rest_proxy_call_add_param (_tmp27_, "in_reply_to_status_id", _tmp31_);
		_g_free0 (_tmp31_);
	}
	_tmp32_ = ids;
	_tmp32__length1 = ids_length1;
	if (_tmp32__length1 > 0) {
		GString* id_str = NULL;
		GString* _tmp33_ = NULL;
		GString* _tmp34_ = NULL;
		gint64* _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		gint64 _tmp36_ = 0LL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		RestProxyCall* _tmp50_ = NULL;
		GString* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		_tmp33_ = g_string_new ("");
		id_str = _tmp33_;
		_tmp34_ = id_str;
		_tmp35_ = ids;
		_tmp35__length1 = ids_length1;
		_tmp36_ = _tmp35_[0];
		_tmp37_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp36_);
		_tmp38_ = _tmp37_;
		g_string_append (_tmp34_, _tmp38_);
		_g_free0 (_tmp38_);
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp39_ = FALSE;
				_tmp39_ = TRUE;
				while (TRUE) {
					gint _tmp41_ = 0;
					gint64* _tmp42_ = NULL;
					gint _tmp42__length1 = 0;
					GString* _tmp43_ = NULL;
					GString* _tmp44_ = NULL;
					gint64* _tmp45_ = NULL;
					gint _tmp45__length1 = 0;
					gint _tmp46_ = 0;
					gint64 _tmp47_ = 0LL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					if (!_tmp39_) {
						gint _tmp40_ = 0;
						_tmp40_ = i;
						i = _tmp40_ + 1;
					}
					_tmp39_ = FALSE;
					_tmp41_ = i;
					_tmp42_ = ids;
					_tmp42__length1 = ids_length1;
					if (!(_tmp41_ < _tmp42__length1)) {
						break;
					}
					_tmp43_ = id_str;
					_tmp44_ = g_string_append (_tmp43_, ",");
					_tmp45_ = ids;
					_tmp45__length1 = ids_length1;
					_tmp46_ = i;
					_tmp47_ = _tmp45_[_tmp46_];
					_tmp48_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp47_);
					_tmp49_ = _tmp48_;
					g_string_append (_tmp44_, _tmp49_);
					_g_free0 (_tmp49_);
				}
			}
		}
		_tmp50_ = _data69_->call;
		_tmp51_ = id_str;
		_tmp52_ = _tmp51_->str;
		rest_proxy_call_add_param (_tmp50_, "media_ids", _tmp52_);
		_g_string_free0 (id_str);
	}
	_tmp53_ = _data69_->call;
	rest_proxy_call_set_function (_tmp53_, "1.1/statuses/update.json");
	_tmp54_ = _data69_->call;
	rest_proxy_call_invoke_async (_tmp54_, NULL, ___lambda54__gasync_ready_callback, block69_data_ref (_data69_));
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_free0 (text);
	block69_data_unref (_data69_);
	_data69_ = NULL;
}


static void compose_tweet_window_upload_media_data_free (gpointer _data) {
	ComposeTweetWindowUploadMediaData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->proxy);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComposeTweetWindowUploadMediaData, _data_);
}


static void compose_tweet_window_upload_media (ComposeTweetWindow* self, const gchar* path, RestProxy* proxy, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ComposeTweetWindowUploadMediaData* _data_;
	ComposeTweetWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RestProxy* _tmp3_ = NULL;
	RestProxy* _tmp4_ = NULL;
	_data_ = g_slice_new0 (ComposeTweetWindowUploadMediaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, compose_tweet_window_upload_media);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, compose_tweet_window_upload_media_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->path);
	_data_->path = _tmp2_;
	_tmp3_ = proxy;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->proxy);
	_data_->proxy = _tmp4_;
	compose_tweet_window_upload_media_co (_data_);
}


static gint64 compose_tweet_window_upload_media_finish (ComposeTweetWindow* self, GAsyncResult* _res_, GError** error) {
	gint64 result;
	ComposeTweetWindowUploadMediaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0LL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void compose_tweet_window_upload_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ComposeTweetWindowUploadMediaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	compose_tweet_window_upload_media_co (_data_);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gboolean compose_tweet_window_upload_media_co (ComposeTweetWindowUploadMediaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->proxy;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = rest_proxy_new_call (_data_->_tmp0_);
	_data_->call = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp2_, "1.1/media/upload.json");
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp3_, "POST");
	_data_->file_contents_length1 = 0;
	_data_->_file_contents_size_ = 0;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->path;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_file_new_for_path (_data_->_tmp4_);
	_data_->media_file = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->media_file;
	_data_->_tmp7_ = NULL;
	memset (&_data_->_tmp8_, 0, sizeof (gsize));
	g_file_load_contents (_data_->_tmp6_, NULL, &_data_->_tmp7_, &_data_->_tmp8_, NULL, &_data_->_inner_error_);
	_data_->file_contents = (g_free (_data_->file_contents), NULL);
	_data_->file_contents = _data_->_tmp7_;
	_data_->file_contents_length1 = _data_->_tmp8_;
	_data_->_file_contents_size_ = _data_->file_contents_length1;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->media_file);
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = NULL;
	_data_->_tmp9__length1 = 0;
	_data_->_tmp9_ = _data_->file_contents;
	_data_->_tmp9__length1 = _data_->file_contents_length1;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->path;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = rest_param_new_full ("media", REST_MEMORY_COPY, _data_->_tmp9_, _data_->_tmp9__length1, "multipart/form-data", _data_->_tmp10_);
	_data_->param = _data_->_tmp11_;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->call;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->param;
	rest_proxy_call_add_param_full (_data_->_tmp12_, _data_->_tmp13_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->call;
	_data_->_state_ = 1;
	rest_proxy_call_invoke_async (_data_->_tmp14_, NULL, compose_tweet_window_upload_media_ready, _data_);
	return FALSE;
	_state_1:
	rest_proxy_call_invoke_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_rest_param_unref0 (_data_->param);
		_g_object_unref0 (_data_->media_file);
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = json_parser_new ();
	_data_->parser = _data_->_tmp15_;
	{
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->parser;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->call;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = rest_proxy_call_get_payload (_data_->_tmp17_);
		json_parser_load_from_data (_data_->_tmp16_, _data_->_tmp18_, (gssize) (-1), &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch83_g_error;
		}
	}
	goto __finally83;
	__catch83_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->e;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_warning ("ComposeTweetWindow.vala:286: %s", _data_->_tmp20_);
		_data_->result = (gint64) (-1);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->parser);
		_rest_param_unref0 (_data_->param);
		_g_object_unref0 (_data_->media_file);
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally83:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->parser);
		_rest_param_unref0 (_data_->param);
		_g_object_unref0 (_data_->media_file);
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->parser;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = json_parser_get_root (_data_->_tmp21_);
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = json_node_get_object (_data_->_tmp22_);
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _json_object_ref0 (_data_->_tmp23_);
	_data_->root = _data_->_tmp24_;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->root;
	_data_->_tmp26_ = 0LL;
	_data_->_tmp26_ = json_object_get_int_member (_data_->_tmp25_, "media_id");
	_data_->result = _data_->_tmp26_;
	_json_object_unref0 (_data_->root);
	_g_object_unref0 (_data_->parser);
	_rest_param_unref0 (_data_->param);
	_g_object_unref0 (_data_->media_file);
	_data_->file_contents = (g_free (_data_->file_contents), NULL);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_json_object_unref0 (_data_->root);
	_g_object_unref0 (_data_->parser);
	_rest_param_unref0 (_data_->param);
	_g_object_unref0 (_data_->media_file);
	_data_->file_contents = (g_free (_data_->file_contents), NULL);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void compose_tweet_window_cancel_clicked (ComposeTweetWindow* self, GtkWidget* source) {
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	g_return_if_fail (GTK_IS_WIDGET (source));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


static void _compose_tweet_window_cancel_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	compose_tweet_window_cancel_clicked ((ComposeTweetWindow*) self, _sender);
}


static gboolean compose_tweet_window_escape_pressed_cb (ComposeTweetWindow* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_COMPOSE_TWEET_WINDOW (self), FALSE);
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = TRUE;
	return result;
}


void compose_tweet_window_set_text (ComposeTweetWindow* self, const gchar* text) {
	CompletionTextView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->tweet_text;
	_tmp1_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_text_view_get_type (), GtkTextView));
	_tmp2_ = _tmp1_;
	_tmp3_ = text;
	g_object_set (_tmp2_, "text", _tmp3_, NULL);
}


static Block70Data* block70_data_ref (Block70Data* _data70_) {
	g_atomic_int_inc (&_data70_->_ref_count_);
	return _data70_;
}


static void block70_data_unref (void * _userdata_) {
	Block70Data* _data70_;
	_data70_ = (Block70Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data70_->_ref_count_)) {
		ComposeTweetWindow* self;
		self = _data70_->self;
		_g_object_unref0 (_data70_->image_button);
		_g_object_unref0 (self);
		g_slice_free (Block70Data, _data70_);
	}
}


static void _compose_tweet_window_remove_image_clicked_cb_add_image_button_remove_clicked (AddImageButton* _sender, gpointer self) {
	compose_tweet_window_remove_image_clicked_cb ((ComposeTweetWindow*) self, _sender);
}


static void _compose_tweet_window_add_image_clicked_cb_add_image_button_add_clicked (AddImageButton* _sender, gpointer self) {
	compose_tweet_window_add_image_clicked_cb ((ComposeTweetWindow*) self, _sender);
}


static void __lambda59_ (Block70Data* _data70_) {
	ComposeTweetWindow* self;
	AddImageButton* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	self = _data70_->self;
	_tmp0_ = _data70_->image_button;
	_tmp1_ = add_image_button_get_image (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		compose_tweet_window_add_image_button (self, FALSE);
		compose_tweet_window_recalc_tweet_length (self);
	}
}


static void ___lambda59__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda59_ (self);
}


static void compose_tweet_window_add_image_button (ComposeTweetWindow* self, gboolean initially_visible) {
	Block70Data* _data70_;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	AddImageButton* _tmp5_ = NULL;
	GtkRevealer* revealer = NULL;
	GtkRevealer* _tmp6_ = NULL;
	AddImageButton* _tmp7_ = NULL;
	AddImageButton* _tmp8_ = NULL;
	AddImageButton* _tmp9_ = NULL;
	GtkRevealer* _tmp10_ = NULL;
	AddImageButton* _tmp11_ = NULL;
	GtkRevealer* _tmp12_ = NULL;
	GtkRevealer* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GtkRevealer* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkRevealer* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GeeArrayList* _tmp20_ = NULL;
	AddImageButton* _tmp21_ = NULL;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	_data70_ = g_slice_new0 (Block70Data);
	_data70_->_ref_count_ = 1;
	_data70_->self = g_object_ref (self);
	_tmp0_ = self->priv->image_buttons;
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	_tmp3_ = twitter_get_max_media_per_upload ();
	_tmp4_ = _tmp3_;
	if (_tmp2_ >= _tmp4_) {
		block70_data_unref (_data70_);
		_data70_ = NULL;
		return;
	}
	_tmp5_ = add_image_button_new ();
	g_object_ref_sink (_tmp5_);
	_data70_->image_button = _tmp5_;
	_tmp6_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp6_);
	revealer = _tmp6_;
	_tmp7_ = _data70_->image_button;
	g_signal_connect_object (_tmp7_, "remove-clicked", (GCallback) _compose_tweet_window_remove_image_clicked_cb_add_image_button_remove_clicked, self, 0);
	_tmp8_ = _data70_->image_button;
	g_signal_connect_object (_tmp8_, "add-clicked", (GCallback) _compose_tweet_window_add_image_clicked_cb_add_image_button_add_clicked, self, 0);
	_tmp9_ = _data70_->image_button;
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, G_TYPE_OBJECT, GObject), "notify::image", (GCallback) ___lambda59__g_object_notify, block70_data_ref (_data70_), (GClosureNotify) block70_data_unref, 0);
	_tmp10_ = revealer;
	_tmp11_ = _data70_->image_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	_tmp12_ = revealer;
	gtk_revealer_set_transition_type (_tmp12_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	_tmp13_ = revealer;
	_tmp14_ = initially_visible;
	gtk_revealer_set_reveal_child (_tmp13_, _tmp14_);
	_tmp15_ = revealer;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
	_tmp16_ = self->priv->content_box;
	_tmp17_ = revealer;
	gtk_box_pack_start (_tmp16_, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp18_ = initially_visible;
	if (!_tmp18_) {
		GtkRevealer* _tmp19_ = NULL;
		_tmp19_ = revealer;
		gtk_revealer_set_reveal_child (_tmp19_, TRUE);
	}
	_tmp20_ = self->priv->image_buttons;
	_tmp21_ = _data70_->image_button;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp21_);
	_g_object_unref0 (revealer);
	block70_data_unref (_data70_);
	_data70_ = NULL;
}


static Block71Data* block71_data_ref (Block71Data* _data71_) {
	g_atomic_int_inc (&_data71_->_ref_count_);
	return _data71_;
}


static void block71_data_unref (void * _userdata_) {
	Block71Data* _data71_;
	_data71_ = (Block71Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data71_->_ref_count_)) {
		ComposeTweetWindow* self;
		self = _data71_->self;
		_g_object_unref0 (_data71_->preview_widget);
		_g_object_unref0 (_data71_->fcd);
		_g_object_unref0 (self);
		g_slice_free (Block71Data, _data71_);
	}
}


static void __lambda58_ (Block71Data* _data71_) {
	ComposeTweetWindow* self;
	gchar* uri = NULL;
	GtkFileChooserDialog* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data71_->self;
	_tmp0_ = _data71_->fcd;
	_tmp1_ = gtk_file_chooser_get_preview_uri (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
	uri = _tmp1_;
	_tmp3_ = uri;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = uri;
		_tmp5_ = g_str_has_prefix (_tmp4_, "file://");
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		{
			gint final_size = 0;
			GdkPixbuf* p = NULL;
			const gchar* _tmp6_ = NULL;
			GFile* _tmp7_ = NULL;
			GFile* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			GdkPixbuf* _tmp11_ = NULL;
			GdkPixbuf* _tmp12_ = NULL;
			gint w = 0;
			GdkPixbuf* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint h = 0;
			GdkPixbuf* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			GdkPixbuf* scaled = NULL;
			GdkPixbuf* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			GdkPixbuf* _tmp32_ = NULL;
			GtkImage* _tmp33_ = NULL;
			GdkPixbuf* _tmp34_ = NULL;
			GtkImage* _tmp35_ = NULL;
			final_size = 130;
			_tmp6_ = uri;
			_tmp7_ = g_file_new_for_uri (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_file_get_path (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = gdk_pixbuf_new_from_file (_tmp10_, &_inner_error_);
			_tmp12_ = _tmp11_;
			_g_free0 (_tmp10_);
			_g_object_unref0 (_tmp8_);
			p = _tmp12_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch84_g_error;
			}
			_tmp13_ = p;
			_tmp14_ = gdk_pixbuf_get_width (_tmp13_);
			w = _tmp14_;
			_tmp15_ = p;
			_tmp16_ = gdk_pixbuf_get_height (_tmp15_);
			h = _tmp16_;
			_tmp17_ = w;
			_tmp18_ = h;
			if (_tmp17_ > _tmp18_) {
				gdouble ratio = 0.0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gdouble _tmp23_ = 0.0;
				_tmp19_ = final_size;
				_tmp20_ = w;
				ratio = _tmp19_ / ((gdouble) _tmp20_);
				_tmp21_ = final_size;
				w = _tmp21_;
				_tmp22_ = h;
				_tmp23_ = ratio;
				h = (gint) (_tmp22_ * _tmp23_);
			} else {
				gdouble ratio = 0.0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gdouble _tmp27_ = 0.0;
				gint _tmp28_ = 0;
				_tmp24_ = final_size;
				_tmp25_ = h;
				ratio = _tmp24_ / ((gdouble) _tmp25_);
				_tmp26_ = w;
				_tmp27_ = ratio;
				w = (gint) (_tmp26_ * _tmp27_);
				_tmp28_ = final_size;
				h = _tmp28_;
			}
			_tmp29_ = p;
			_tmp30_ = w;
			_tmp31_ = h;
			_tmp32_ = gdk_pixbuf_scale_simple (_tmp29_, _tmp30_, _tmp31_, GDK_INTERP_BILINEAR);
			scaled = _tmp32_;
			_tmp33_ = _data71_->preview_widget;
			_tmp34_ = scaled;
			gtk_image_set_from_pixbuf (_tmp33_, _tmp34_);
			_tmp35_ = _data71_->preview_widget;
			gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget));
			_g_object_unref0 (scaled);
			_g_object_unref0 (p);
		}
		goto __finally84;
		__catch84_g_error:
		{
			GError* e = NULL;
			GtkImage* _tmp36_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp36_ = _data71_->preview_widget;
			gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
			_g_error_free0 (e);
		}
		__finally84:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		GtkImage* _tmp37_ = NULL;
		_tmp37_ = _data71_->preview_widget;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
	}
	_g_free0 (uri);
}


static void ___lambda58__gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self) {
	__lambda58_ (self);
}


static void compose_tweet_window_add_image_clicked_cb (ComposeTweetWindow* self, AddImageButton* source) {
	Block71Data* _data71_;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkFileChooserDialog* _tmp3_ = NULL;
	GtkFileChooserDialog* _tmp4_ = NULL;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp5_ = NULL;
	GtkFileFilter* _tmp6_ = NULL;
	GtkFileFilter* _tmp7_ = NULL;
	GtkFileFilter* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkFileFilter* _tmp10_ = NULL;
	GtkImage* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	GtkImage* _tmp13_ = NULL;
	GtkFileChooserDialog* _tmp14_ = NULL;
	GtkFileChooserDialog* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	GtkFileChooserDialog* _tmp30_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	g_return_if_fail (IS_ADD_IMAGE_BUTTON (source));
	_data71_ = g_slice_new0 (Block71Data);
	_data71_->_ref_count_ = 1;
	_data71_->self = g_object_ref (self);
	_tmp0_ = _ ("Select Image");
	_tmp1_ = _ ("Cancel");
	_tmp2_ = _ ("Choose");
	_tmp3_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, _tmp1_, GTK_RESPONSE_CANCEL, _tmp2_, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp3_);
	_data71_->fcd = _tmp3_;
	_tmp4_ = _data71_->fcd;
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow), TRUE);
	_tmp5_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp5_);
	filter = _tmp5_;
	_tmp6_ = filter;
	gtk_file_filter_add_mime_type (_tmp6_, "image/png");
	_tmp7_ = filter;
	gtk_file_filter_add_mime_type (_tmp7_, "image/jpeg");
	_tmp8_ = filter;
	gtk_file_filter_add_mime_type (_tmp8_, "image/gif");
	_tmp9_ = _data71_->fcd;
	_tmp10_ = filter;
	gtk_file_chooser_set_filter (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), _tmp10_);
	_tmp11_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp11_);
	_data71_->preview_widget = _tmp11_;
	_tmp12_ = _data71_->fcd;
	_tmp13_ = _data71_->preview_widget;
	gtk_file_chooser_set_preview_widget (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
	_tmp14_ = _data71_->fcd;
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), "update-preview", (GCallback) ___lambda58__gtk_file_chooser_update_preview, block71_data_ref (_data71_), (GClosureNotify) block71_data_unref, 0);
	_tmp15_ = _data71_->fcd;
	_tmp16_ = gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_dialog_get_type (), GtkDialog));
	if (_tmp16_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* file = NULL;
		GtkFileChooserDialog* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp17_ = _data71_->fcd;
		_tmp18_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
		file = _tmp18_;
		{
			GdkPixbuf* pixbuf = NULL;
			const gchar* _tmp19_ = NULL;
			GdkPixbuf* _tmp20_ = NULL;
			GdkPixbuf* thumb = NULL;
			GdkPixbuf* _tmp21_ = NULL;
			GdkPixbuf* _tmp22_ = NULL;
			AddImageButton* _tmp23_ = NULL;
			GdkPixbuf* _tmp24_ = NULL;
			AddImageButton* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			_tmp19_ = file;
			_tmp20_ = gdk_pixbuf_new_from_file (_tmp19_, &_inner_error_);
			pixbuf = _tmp20_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch85_g_error;
			}
			_tmp21_ = pixbuf;
			_tmp22_ = utils_slice_pixbuf (_tmp21_, 500, MULTI_MEDIA_WIDGET_HEIGHT);
			thumb = _tmp22_;
			_tmp23_ = source;
			_tmp24_ = thumb;
			add_image_button_set_image (_tmp23_, _tmp24_);
			_tmp25_ = source;
			_tmp26_ = file;
			_tmp27_ = g_strdup (_tmp26_);
			_g_free0 (_tmp25_->image_path);
			_tmp25_->image_path = _tmp27_;
			_g_object_unref0 (thumb);
			_g_object_unref0 (pixbuf);
		}
		goto __finally85;
		__catch85_g_error:
		{
			GError* e = NULL;
			GError* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			g_warning ("ComposeTweetWindow.vala:384: %s", _tmp29_);
			_g_error_free0 (e);
		}
		__finally85:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (file);
			_g_object_unref0 (filter);
			block71_data_unref (_data71_);
			_data71_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (file);
	}
	_tmp30_ = _data71_->fcd;
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_dialog_get_type (), GtkDialog), "close");
	_g_object_unref0 (filter);
	block71_data_unref (_data71_);
	_data71_ = NULL;
}


static Block72Data* block72_data_ref (Block72Data* _data72_) {
	g_atomic_int_inc (&_data72_->_ref_count_);
	return _data72_;
}


static void block72_data_unref (void * _userdata_) {
	Block72Data* _data72_;
	_data72_ = (Block72Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data72_->_ref_count_)) {
		ComposeTweetWindow* self;
		self = _data72_->self;
		_g_object_unref0 (_data72_->revealer);
		_g_object_unref0 (_data72_->source);
		_g_object_unref0 (self);
		g_slice_free (Block72Data, _data72_);
	}
}


static void __lambda57_ (Block72Data* _data72_) {
	ComposeTweetWindow* self;
	GtkBox* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	AddImageButton* _tmp2_ = NULL;
	self = _data72_->self;
	_tmp0_ = self->priv->content_box;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_data72_->revealer, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->image_buttons;
	_tmp2_ = _data72_->source;
	gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp2_);
}


static void ___lambda57__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda57_ (self);
}


static void compose_tweet_window_remove_image_clicked_cb (ComposeTweetWindow* self, AddImageButton* source) {
	Block72Data* _data72_;
	AddImageButton* _tmp0_ = NULL;
	AddImageButton* _tmp1_ = NULL;
	AddImageButton* _tmp2_ = NULL;
	AddImageButton* _tmp3_ = NULL;
	GtkContainer* _tmp4_ = NULL;
	GtkContainer* _tmp5_ = NULL;
	GtkRevealer* _tmp6_ = NULL;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	g_return_if_fail (IS_ADD_IMAGE_BUTTON (source));
	_data72_ = g_slice_new0 (Block72Data);
	_data72_->_ref_count_ = 1;
	_data72_->self = g_object_ref (self);
	_tmp0_ = source;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data72_->source);
	_data72_->source = _tmp1_;
	_tmp2_ = _data72_->source;
	add_image_button_set_image (_tmp2_, NULL);
	_tmp3_ = _data72_->source;
	_tmp4_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_revealer_get_type (), GtkRevealer));
	_data72_->revealer = _tmp6_;
	gtk_revealer_set_reveal_child (_data72_->revealer, FALSE);
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_data72_->revealer, G_TYPE_OBJECT, GObject), "notify::child-revealed", (GCallback) ___lambda57__g_object_notify, block72_data_ref (_data72_), (GClosureNotify) block72_data_unref, 0);
	compose_tweet_window_recalc_tweet_length (self);
	block72_data_unref (_data72_);
	_data72_ = NULL;
}


static gint compose_tweet_window_get_effective_media_count (ComposeTweetWindow* self) {
	gint result = 0;
	gint c = 0;
	g_return_val_if_fail (IS_COMPOSE_TWEET_WINDOW (self), 0);
	c = 0;
	{
		GeeArrayList* _btn_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _btn_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _btn_index = 0;
		_tmp0_ = self->priv->image_buttons;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_btn_list = _tmp1_;
		_tmp2_ = _btn_list;
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_btn_size = _tmp4_;
		_btn_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			AddImageButton* btn = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			AddImageButton* _tmp11_ = NULL;
			GdkPixbuf* _tmp12_ = NULL;
			GdkPixbuf* _tmp13_ = NULL;
			_tmp5_ = _btn_index;
			_btn_index = _tmp5_ + 1;
			_tmp6_ = _btn_index;
			_tmp7_ = _btn_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _btn_list;
			_tmp9_ = _btn_index;
			_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp9_);
			btn = (AddImageButton*) _tmp10_;
			_tmp11_ = btn;
			_tmp12_ = add_image_button_get_image (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				gint _tmp14_ = 0;
				_tmp14_ = c;
				c = _tmp14_ + 1;
			}
			_g_object_unref0 (btn);
		}
		_g_object_unref0 (_btn_list);
	}
	result = c;
	return result;
}


static void compose_tweet_window_class_init (ComposeTweetWindowClass * klass) {
	gint ComposeTweetWindow_private_offset;
	compose_tweet_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ComposeTweetWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = compose_tweet_window_finalize;
	ComposeTweetWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/compose-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_box", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, content_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweet_text", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, tweet_text));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "length_label", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, length_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "send_button", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, send_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_spinner", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, title_spinner));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_label", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, title_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_stack", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, title_stack));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "start_send_tweet", G_CALLBACK(_compose_tweet_window_start_send_tweet_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_clicked", G_CALLBACK(_compose_tweet_window_cancel_clicked_gtk_button_clicked));
}


static void compose_tweet_window_instance_init (ComposeTweetWindow * self) {
	self->priv = COMPOSE_TWEET_WINDOW_GET_PRIVATE (self);
	g_type_ensure (TYPE_COMPLETION_TEXT_VIEW);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void compose_tweet_window_finalize (GObject* obj) {
	ComposeTweetWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->content_box);
	_g_object_unref0 (self->priv->tweet_text);
	_g_object_unref0 (self->priv->length_label);
	_g_object_unref0 (self->priv->send_button);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->title_spinner);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->title_stack);
	_g_object_unref0 (self->priv->image_buttons);
	G_OBJECT_CLASS (compose_tweet_window_parent_class)->finalize (obj);
}


GType compose_tweet_window_get_type (void) {
	static volatile gsize compose_tweet_window_type_id__volatile = 0;
	if (g_once_init_enter (&compose_tweet_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComposeTweetWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) compose_tweet_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComposeTweetWindow), 0, (GInstanceInitFunc) compose_tweet_window_instance_init, NULL };
		GType compose_tweet_window_type_id;
		compose_tweet_window_type_id = g_type_register_static (gtk_application_window_get_type (), "ComposeTweetWindow", &g_define_type_info, 0);
		g_once_init_leave (&compose_tweet_window_type_id__volatile, compose_tweet_window_type_id);
	}
	return compose_tweet_window_type_id__volatile;
}



