/* MentionsTimeline.c generated by valac 0.30.0, the Vala compiler
 * generated from MentionsTimeline.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_ITIMELINE (itimeline_get_type ())
#define ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITIMELINE, ITimeline))
#define IS_ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITIMELINE))
#define ITIMELINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITIMELINE, ITimelineIface))

typedef struct _ITimeline ITimeline;
typedef struct _ITimelineIface ITimelineIface;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_BADGE_RADIO_TOOL_BUTTON (badge_radio_tool_button_get_type ())
#define BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButton))
#define BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))
#define IS_BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define IS_BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define BADGE_RADIO_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))

typedef struct _BadgeRadioToolButton BadgeRadioToolButton;
typedef struct _BadgeRadioToolButtonClass BadgeRadioToolButtonClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_MENTIONS_TIMELINE (mentions_timeline_get_type ())
#define MENTIONS_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENTIONS_TIMELINE, MentionsTimeline))
#define MENTIONS_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENTIONS_TIMELINE, MentionsTimelineClass))
#define IS_MENTIONS_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENTIONS_TIMELINE))
#define IS_MENTIONS_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENTIONS_TIMELINE))
#define MENTIONS_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENTIONS_TIMELINE, MentionsTimelineClass))

typedef struct _MentionsTimeline MentionsTimeline;
typedef struct _MentionsTimelineClass MentionsTimelineClass;
typedef struct _MentionsTimelinePrivate MentionsTimelinePrivate;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;
typedef struct _MiniTweetPrivate MiniTweetPrivate;

#define TYPE_USER_IDENTITY (user_identity_get_type ())
typedef struct _UserIdentity UserIdentity;

#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

struct _ITimelineIface {
	GTypeInterface parent_iface;
	TweetListBox* (*get_tweet_list) (ITimeline* self);
	void (*set_tweet_list) (ITimeline* self, TweetListBox* value);
	gint (*get_unread_count) (ITimeline* self);
	void (*set_unread_count) (ITimeline* self, gint value);
	DeltaUpdater* (*get_delta_updater) (ITimeline* self);
	void (*set_delta_updater) (ITimeline* self, DeltaUpdater* value);
	const gchar* (*get_function) (ITimeline* self);
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	BadgeRadioToolButton* tool_button;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, Bundle* args);
	void (*on_leave) (DefaultTimeline* self);
	void (*load_newest) (DefaultTimeline* self);
	void (*load_older) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_tool_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _MentionsTimeline {
	DefaultTimeline parent_instance;
	MentionsTimelinePrivate * priv;
};

struct _MentionsTimelineClass {
	DefaultTimelineClass parent_class;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	guint hidden_flags;
	gint64 id;
	MiniTweet* source_tweet;
	MiniTweet* retweeted_tweet;
	MiniTweet* quoted_tweet;
	gchar* avatar_url;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gchar* notification_id;
	gint64 reply_id;
	gint retweet_count;
	gint favorite_count;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _UserIdentity {
	gint64 id;
	gchar* screen_name;
	gchar* user_name;
};

struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

struct _MiniTweet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MiniTweetPrivate * priv;
	gint64 id;
	gint64 created_at;
	UserIdentity author;
	gchar* text;
	TextEntity* entities;
	gint entities_length1;
	Media** medias;
	gint medias_length1;
};

struct _MiniTweetClass {
	GTypeClass parent_class;
	void (*finalize) (MiniTweet *self);
};


static gpointer mentions_timeline_parent_class = NULL;
static IMessageReceiverIface* mentions_timeline_imessage_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType itimeline_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType badge_radio_tool_button_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType mentions_timeline_get_type (void) G_GNUC_CONST;
enum  {
	MENTIONS_TIMELINE_DUMMY_PROPERTY,
	MENTIONS_TIMELINE_FUNCTION
};
MentionsTimeline* mentions_timeline_new (gint id, Account* account);
MentionsTimeline* mentions_timeline_construct (GType object_type, gint id, Account* account);
DefaultTimeline* default_timeline_construct (GType object_type, gint id);
void ipage_set_account (IPage* self, Account* value);
TweetListBox* itimeline_get_tweet_list (ITimeline* self);
GType tweet_model_get_type (void) G_GNUC_CONST;
static void mentions_timeline_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root);
static void mentions_timeline_add_tweet (MentionsTimeline* self, JsonNode* root_node);
void default_timeline_delete_tweet (DefaultTimeline* self, gint64 tweet_id);
void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode);
Account* ipage_get_account (IPage* self);
gint64 account_get_id (Account* self);
void default_timeline_mark_seen (DefaultTimeline* self, gint64 id);
const gchar* account_get_screen_name (Account* self);
GType tweet_get_type (void) G_GNUC_CONST;
Tweet* tweet_new (void);
Tweet* tweet_construct (GType object_type);
void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account);
gint64 tweet_get_user_id (Tweet* self);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
guint default_timeline_get_rt_flags (DefaultTimeline* self, Tweet* t);
gboolean account_filter_matches (Account* self, Tweet* t);
gboolean account_blocked_or_muted (Account* self, gint64 user_id);
void tweet_set_seen (Tweet* self, gboolean value);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define TOP 1
void tweet_model_add (TweetModel* self, Tweet* tweet);
void default_timeline_scroll_up (DefaultTimeline* self, Tweet* t);
gint itimeline_get_unread_count (ITimeline* self);
void itimeline_set_unread_count (ITimeline* self, gint value);
gboolean settings_notify_new_mentions (void);
GType user_identity_get_type (void) G_GNUC_CONST;
UserIdentity* user_identity_dup (const UserIdentity* self);
void user_identity_free (UserIdentity* self);
void user_identity_copy (const UserIdentity* self, UserIdentity* dest);
void user_identity_destroy (UserIdentity* self);
GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
GType media_get_type (void) G_GNUC_CONST;
static gchar* mentions_timeline_send_notification (MentionsTimeline* self, const gchar* sender_screen_name, gint64 tweet_id, const gchar* text);
const gchar* tweet_get_screen_name (Tweet* self);
gchar* utils_unescape_html (const gchar* input);
static GVariant* _variant_new1 (gint64 value);
static void mentions_timeline_real_load_newest (DefaultTimeline* base);
void itimeline_load_newest_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void itimeline_load_newest_internal_finish (ITimeline* self, GAsyncResult* _res_);
static void __lambda93_ (MentionsTimeline* self);
static void ___lambda93__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void mentions_timeline_real_load_older (DefaultTimeline* base);
#define BOTTOM 2
void itimeline_load_older_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void itimeline_load_older_internal_finish (ITimeline* self, GAsyncResult* _res_);
static void __lambda94_ (MentionsTimeline* self);
static void ___lambda94__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gchar* mentions_timeline_real_get_title (DefaultTimeline* base);
static void mentions_timeline_real_create_tool_button (DefaultTimeline* base, GtkRadioButton* group);
BadgeRadioToolButton* badge_radio_tool_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioToolButton* badge_radio_tool_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
const gchar* default_timeline_get_function (DefaultTimeline* self);
static void _vala_mentions_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


MentionsTimeline* mentions_timeline_construct (GType object_type, gint id, Account* account) {
	MentionsTimeline * self = NULL;
	gint _tmp0_ = 0;
	Account* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	TweetListBox* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_tmp0_ = id;
	self = (MentionsTimeline*) default_timeline_construct (object_type, _tmp0_);
	_tmp1_ = account;
	ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp1_);
	_tmp2_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
	_tmp3_ = _tmp2_;
	_tmp4_ = account;
	_tmp3_->account = _tmp4_;
	return self;
}


MentionsTimeline* mentions_timeline_new (gint id, Account* account) {
	return mentions_timeline_construct (TYPE_MENTIONS_TIMELINE, id, account);
}


static void mentions_timeline_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root) {
	MentionsTimeline * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_TWEET) {
		JsonNode* _tmp1_ = NULL;
		_tmp1_ = root;
		mentions_timeline_add_tweet (self, _tmp1_);
	} else {
		StreamMessageType _tmp2_ = 0;
		_tmp2_ = type;
		if (_tmp2_ == STREAM_MESSAGE_TYPE_DELETE) {
			gint64 id = 0LL;
			JsonNode* _tmp3_ = NULL;
			JsonObject* _tmp4_ = NULL;
			JsonObject* _tmp5_ = NULL;
			JsonObject* _tmp6_ = NULL;
			gint64 _tmp7_ = 0LL;
			gint64 _tmp8_ = 0LL;
			_tmp3_ = root;
			_tmp4_ = json_node_get_object (_tmp3_);
			_tmp5_ = json_object_get_object_member (_tmp4_, "delete");
			_tmp6_ = json_object_get_object_member (_tmp5_, "status");
			_tmp7_ = json_object_get_int_member (_tmp6_, "id");
			id = _tmp7_;
			_tmp8_ = id;
			default_timeline_delete_tweet (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp8_);
		} else {
			StreamMessageType _tmp9_ = 0;
			_tmp9_ = type;
			if (_tmp9_ == STREAM_MESSAGE_TYPE_EVENT_FAVORITE) {
				gint64 id = 0LL;
				JsonNode* _tmp10_ = NULL;
				JsonObject* _tmp11_ = NULL;
				JsonObject* _tmp12_ = NULL;
				gint64 _tmp13_ = 0LL;
				gint64 _tmp14_ = 0LL;
				_tmp10_ = root;
				_tmp11_ = json_node_get_object (_tmp10_);
				_tmp12_ = json_object_get_object_member (_tmp11_, "target_object");
				_tmp13_ = json_object_get_int_member (_tmp12_, "id");
				id = _tmp13_;
				_tmp14_ = id;
				default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp14_, TRUE);
			} else {
				StreamMessageType _tmp15_ = 0;
				_tmp15_ = type;
				if (_tmp15_ == STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE) {
					gint64 id = 0LL;
					JsonNode* _tmp16_ = NULL;
					JsonObject* _tmp17_ = NULL;
					JsonObject* _tmp18_ = NULL;
					gint64 _tmp19_ = 0LL;
					gint64 _tmp20_ = 0LL;
					_tmp16_ = root;
					_tmp17_ = json_node_get_object (_tmp16_);
					_tmp18_ = json_object_get_object_member (_tmp17_, "target_object");
					_tmp19_ = json_object_get_int_member (_tmp18_, "id");
					id = _tmp19_;
					_tmp20_ = id;
					default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp20_, FALSE);
				}
			}
		}
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void mentions_timeline_add_tweet (MentionsTimeline* self, JsonNode* root_node) {
	JsonObject* root = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* author = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	JsonObject* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	JsonObject* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	Account* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	gint64 _tmp12_ = 0LL;
	JsonObject* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	Account* _tmp19_ = NULL;
	Account* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	g_return_if_fail (IS_MENTIONS_TIMELINE (self));
	g_return_if_fail (root_node != NULL);
	_tmp0_ = root_node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	root = _tmp2_;
	_tmp3_ = root;
	_tmp4_ = json_object_get_object_member (_tmp3_, "user");
	_tmp5_ = _json_object_ref0 (_tmp4_);
	author = _tmp5_;
	_tmp7_ = author;
	_tmp8_ = json_object_get_int_member (_tmp7_, "id");
	_tmp9_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp10_ = _tmp9_;
	_tmp11_ = account_get_id (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp8_ == _tmp12_) {
		JsonObject* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = root;
		_tmp14_ = json_object_get_null_member (_tmp13_, "in_reply_to_status_id");
		_tmp6_ = !_tmp14_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		JsonObject* _tmp15_ = NULL;
		gint64 _tmp16_ = 0LL;
		_tmp15_ = root;
		_tmp16_ = json_object_get_int_member (_tmp15_, "in_reply_to_status_id");
		default_timeline_mark_seen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp16_);
		_json_object_unref0 (author);
		_json_object_unref0 (root);
		return;
	}
	_tmp17_ = root;
	_tmp18_ = json_object_get_string_member (_tmp17_, "text");
	_tmp19_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp20_ = _tmp19_;
	_tmp21_ = account_get_screen_name (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat ("@", _tmp22_, NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = string_contains (_tmp18_, _tmp24_);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp24_);
	if (_tmp26_) {
		GDateTime* now = NULL;
		GDateTime* _tmp27_ = NULL;
		Tweet* t = NULL;
		Tweet* _tmp28_ = NULL;
		Tweet* _tmp29_ = NULL;
		JsonNode* _tmp30_ = NULL;
		GDateTime* _tmp31_ = NULL;
		Account* _tmp32_ = NULL;
		Account* _tmp33_ = NULL;
		Tweet* _tmp34_ = NULL;
		gint64 _tmp35_ = 0LL;
		gint64 _tmp36_ = 0LL;
		Account* _tmp37_ = NULL;
		Account* _tmp38_ = NULL;
		gint64 _tmp39_ = 0LL;
		gint64 _tmp40_ = 0LL;
		gboolean _tmp41_ = FALSE;
		Tweet* _tmp42_ = NULL;
		MiniTweet* _tmp43_ = NULL;
		Account* _tmp46_ = NULL;
		Account* _tmp47_ = NULL;
		Tweet* _tmp48_ = NULL;
		gboolean _tmp49_ = FALSE;
		Account* _tmp50_ = NULL;
		Account* _tmp51_ = NULL;
		Tweet* _tmp52_ = NULL;
		gint64 _tmp53_ = 0LL;
		gint64 _tmp54_ = 0LL;
		gboolean _tmp55_ = FALSE;
		Tweet* _tmp56_ = NULL;
		TweetListBox* _tmp57_ = NULL;
		TweetListBox* _tmp58_ = NULL;
		TweetModel* _tmp59_ = NULL;
		Tweet* _tmp60_ = NULL;
		Tweet* _tmp61_ = NULL;
		gint _tmp62_ = 0;
		gint _tmp63_ = 0;
		gboolean _tmp64_ = FALSE;
		_tmp27_ = g_date_time_new_now_local ();
		now = _tmp27_;
		_tmp28_ = tweet_new ();
		t = _tmp28_;
		_tmp29_ = t;
		_tmp30_ = root_node;
		_tmp31_ = now;
		_tmp32_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp33_ = _tmp32_;
		tweet_load_from_json (_tmp29_, _tmp30_, _tmp31_, _tmp33_);
		_tmp34_ = t;
		_tmp35_ = tweet_get_user_id (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp38_ = _tmp37_;
		_tmp39_ = account_get_id (_tmp38_);
		_tmp40_ = _tmp39_;
		if (_tmp36_ == _tmp40_) {
			_g_object_unref0 (t);
			_g_date_time_unref0 (now);
			_json_object_unref0 (author);
			_json_object_unref0 (root);
			return;
		}
		_tmp42_ = t;
		_tmp43_ = _tmp42_->retweeted_tweet;
		if (_tmp43_ != NULL) {
			Tweet* _tmp44_ = NULL;
			guint _tmp45_ = 0U;
			_tmp44_ = t;
			_tmp45_ = default_timeline_get_rt_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp44_);
			_tmp41_ = _tmp45_ > ((guint) 0);
		} else {
			_tmp41_ = FALSE;
		}
		if (_tmp41_) {
			_g_object_unref0 (t);
			_g_date_time_unref0 (now);
			_json_object_unref0 (author);
			_json_object_unref0 (root);
			return;
		}
		_tmp46_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp47_ = _tmp46_;
		_tmp48_ = t;
		_tmp49_ = account_filter_matches (_tmp47_, _tmp48_);
		if (_tmp49_) {
			_g_object_unref0 (t);
			_g_date_time_unref0 (now);
			_json_object_unref0 (author);
			_json_object_unref0 (root);
			return;
		}
		_tmp50_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp51_ = _tmp50_;
		_tmp52_ = t;
		_tmp53_ = tweet_get_user_id (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = account_blocked_or_muted (_tmp51_, _tmp54_);
		if (_tmp55_) {
			_g_object_unref0 (t);
			_g_date_time_unref0 (now);
			_json_object_unref0 (author);
			_json_object_unref0 (root);
			return;
		}
		_tmp56_ = t;
		tweet_set_seen (_tmp56_, FALSE);
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), TOP);
		_tmp57_ = itimeline_get_tweet_list (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
		_tmp58_ = _tmp57_;
		_tmp59_ = _tmp58_->model;
		_tmp60_ = t;
		tweet_model_add (_tmp59_, _tmp60_);
		_tmp61_ = t;
		default_timeline_scroll_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp61_);
		_tmp62_ = itimeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline));
		_tmp63_ = _tmp62_;
		itimeline_set_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), _tmp63_ + 1);
		_tmp64_ = settings_notify_new_mentions ();
		if (_tmp64_) {
			gchar* text = NULL;
			Tweet* _tmp65_ = NULL;
			MiniTweet* _tmp66_ = NULL;
			Tweet* _tmp75_ = NULL;
			Tweet* _tmp76_ = NULL;
			const gchar* _tmp77_ = NULL;
			const gchar* _tmp78_ = NULL;
			Tweet* _tmp79_ = NULL;
			gint64 _tmp80_ = 0LL;
			const gchar* _tmp81_ = NULL;
			gchar* _tmp82_ = NULL;
			gchar* _tmp83_ = NULL;
			gchar* _tmp84_ = NULL;
			_tmp65_ = t;
			_tmp66_ = _tmp65_->retweeted_tweet;
			if (_tmp66_ != NULL) {
				Tweet* _tmp67_ = NULL;
				MiniTweet* _tmp68_ = NULL;
				const gchar* _tmp69_ = NULL;
				gchar* _tmp70_ = NULL;
				_tmp67_ = t;
				_tmp68_ = _tmp67_->retweeted_tweet;
				_tmp69_ = _tmp68_->text;
				_tmp70_ = g_strdup (_tmp69_);
				_g_free0 (text);
				text = _tmp70_;
			} else {
				Tweet* _tmp71_ = NULL;
				MiniTweet* _tmp72_ = NULL;
				const gchar* _tmp73_ = NULL;
				gchar* _tmp74_ = NULL;
				_tmp71_ = t;
				_tmp72_ = _tmp71_->source_tweet;
				_tmp73_ = _tmp72_->text;
				_tmp74_ = g_strdup (_tmp73_);
				_g_free0 (text);
				text = _tmp74_;
			}
			_tmp75_ = t;
			_tmp76_ = t;
			_tmp77_ = tweet_get_screen_name (_tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = t;
			_tmp80_ = _tmp79_->id;
			_tmp81_ = text;
			_tmp82_ = utils_unescape_html (_tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = mentions_timeline_send_notification (self, _tmp78_, _tmp80_, _tmp83_);
			_g_free0 (_tmp75_->notification_id);
			_tmp75_->notification_id = _tmp84_;
			_g_free0 (_tmp83_);
			_g_free0 (text);
		}
		_g_object_unref0 (t);
		_g_date_time_unref0 (now);
	}
	_json_object_unref0 (author);
	_json_object_unref0 (root);
}


/**
   * @return The notification's ID
   */
static GVariant* _variant_new1 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


static gchar* mentions_timeline_send_notification (MentionsTimeline* self, const gchar* sender_screen_name, gint64 tweet_id, const gchar* text) {
	gchar* result = NULL;
	GNotification* n = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GNotification* _tmp4_ = NULL;
	GNotification* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GVariant* value = NULL;
	Account* _tmp7_ = NULL;
	Account* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	GVariant* _tmp13_ = NULL;
	GVariant** _tmp14_ = NULL;
	GVariant** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	Account* _tmp18_ = NULL;
	Account* _tmp19_ = NULL;
	gint64 _tmp20_ = 0LL;
	gint64 _tmp21_ = 0LL;
	GVariant* _tmp22_ = NULL;
	gchar* id = NULL;
	gint64 _tmp23_ = 0LL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GApplication* _tmp28_ = NULL;
	g_return_val_if_fail (IS_MENTIONS_TIMELINE (self), NULL);
	g_return_val_if_fail (sender_screen_name != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = _ ("New Mention from @%s");
	_tmp1_ = sender_screen_name;
	_tmp2_ = g_strdup_printf (_tmp0_, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_notification_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	n = _tmp5_;
	_tmp6_ = text;
	g_notification_set_body (n, _tmp6_);
	_tmp7_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp8_ = _tmp7_;
	_tmp9_ = account_get_screen_name (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_new_string (_tmp10_);
	g_variant_ref_sink (_tmp11_);
	_tmp12_ = tweet_id;
	_tmp13_ = g_variant_new_int64 (_tmp12_);
	g_variant_ref_sink (_tmp13_);
	_tmp14_ = g_new0 (GVariant*, 2 + 1);
	_tmp14_[0] = _tmp11_;
	_tmp14_[1] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 2;
	_tmp16_ = g_variant_new_tuple (_tmp15_, 2);
	g_variant_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_variant_unref), NULL);
	value = _tmp17_;
	_tmp18_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp19_ = _tmp18_;
	_tmp20_ = account_get_id (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _variant_new1 (_tmp21_);
	g_notification_set_default_action_and_target_value (n, "app.show-window", _tmp22_);
	_g_variant_unref0 (_tmp22_);
	_tmp23_ = tweet_id;
	_tmp24_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat ("new-dm-", _tmp25_, NULL);
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp25_);
	id = _tmp27_;
	_tmp28_ = g_application_get_default ();
	g_application_send_notification (_tmp28_, id, n);
	result = id;
	_g_variant_unref0 (value);
	_g_object_unref0 (n);
	return result;
}


static void __lambda93_ (MentionsTimeline* self) {
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->loading = FALSE;
}


static void ___lambda93__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda93_ ((MentionsTimeline*) self);
	g_object_unref (self);
}


static void mentions_timeline_real_load_newest (DefaultTimeline* base) {
	MentionsTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->loading = TRUE;
	itimeline_load_newest_internal (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), ___lambda93__gasync_ready_callback, g_object_ref (self));
}


static void __lambda94_ (MentionsTimeline* self) {
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->loading = FALSE;
}


static void ___lambda94__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda94_ ((MentionsTimeline*) self);
	g_object_unref (self);
}


static void mentions_timeline_real_load_older (DefaultTimeline* base) {
	MentionsTimeline * self;
	gboolean _tmp0_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->initialized;
	if (!_tmp0_) {
		return;
	}
	scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), BOTTOM);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->loading = TRUE;
	itimeline_load_older_internal (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITIMELINE, ITimeline), ___lambda94__gasync_ready_callback, g_object_ref (self));
}


static gchar* mentions_timeline_real_get_title (DefaultTimeline* base) {
	MentionsTimeline * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	_tmp0_ = _ ("Mentions");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void mentions_timeline_real_create_tool_button (DefaultTimeline* base, GtkRadioButton* group) {
	MentionsTimeline * self;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	BadgeRadioToolButton* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = _ ("Mentions");
	_tmp2_ = badge_radio_tool_button_new (_tmp0_, "corebird-mentions-symbolic", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tool_button);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tool_button = _tmp2_;
}


static const gchar* mentions_timeline_real_get_function (DefaultTimeline* base) {
	const gchar* result;
	MentionsTimeline* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	result = "1.1/statuses/mentions_timeline.json";
	return result;
}


static void mentions_timeline_class_init (MentionsTimelineClass * klass) {
	mentions_timeline_parent_class = g_type_class_peek_parent (klass);
	((DefaultTimelineClass *) klass)->load_newest = mentions_timeline_real_load_newest;
	((DefaultTimelineClass *) klass)->load_older = mentions_timeline_real_load_older;
	((DefaultTimelineClass *) klass)->get_title = mentions_timeline_real_get_title;
	((DefaultTimelineClass *) klass)->create_tool_button = mentions_timeline_real_create_tool_button;
	DEFAULT_TIMELINE_CLASS (klass)->get_function = mentions_timeline_real_get_function;
	G_OBJECT_CLASS (klass)->get_property = _vala_mentions_timeline_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENTIONS_TIMELINE_FUNCTION, g_param_spec_string ("function", "function", "function", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void mentions_timeline_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	mentions_timeline_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) mentions_timeline_real_stream_message_received;
}


static void mentions_timeline_instance_init (MentionsTimeline * self) {
}


GType mentions_timeline_get_type (void) {
	static volatile gsize mentions_timeline_type_id__volatile = 0;
	if (g_once_init_enter (&mentions_timeline_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MentionsTimelineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mentions_timeline_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MentionsTimeline), 0, (GInstanceInitFunc) mentions_timeline_instance_init, NULL };
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) mentions_timeline_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType mentions_timeline_type_id;
		mentions_timeline_type_id = g_type_register_static (TYPE_DEFAULT_TIMELINE, "MentionsTimeline", &g_define_type_info, 0);
		g_type_add_interface_static (mentions_timeline_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&mentions_timeline_type_id__volatile, mentions_timeline_type_id);
	}
	return mentions_timeline_type_id__volatile;
}


static void _vala_mentions_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MentionsTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	switch (property_id) {
		case MENTIONS_TIMELINE_FUNCTION:
		g_value_set_string (value, default_timeline_get_function (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



