/* Settings.c generated by valac 0.30.0, the Vala compiler
 * generated from Settings.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
typedef struct _SettingsPrivate SettingsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TRANSFORM_FLAGS (transform_flags_get_type ())

struct _Settings {
	GObject parent_instance;
	SettingsPrivate * priv;
};

struct _SettingsClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS = 1 << 0,
	TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS = 1 << 1,
	TRANSFORM_FLAGS_EXPAND_LINKS = 1 << 2
} TransformFlags;


static gpointer settings_parent_class = NULL;
static GSettings* settings_settings;
static GSettings* settings_settings = NULL;

GType settings_get_type (void) G_GNUC_CONST;
enum  {
	SETTINGS_DUMMY_PROPERTY
};
void settings_init (void);
GSettings* settings_get (void);
gint settings_get_tweet_stack_count (void);
gboolean settings_use_dark_theme (void);
gboolean settings_notify_new_mentions (void);
gboolean settings_notify_new_dms (void);
gboolean settings_show_inline_media (void);
gboolean settings_auto_scroll_on_new_tweets (void);
gchar* settings_get_accel (const gchar* accel_name);
gdouble settings_max_media_size (void);
void settings_toggle_sidebar_visible (void);
gchar* settings_get_consumer_key (void);
gchar* settings_get_consumer_secret (void);
GType transform_flags_get_type (void) G_GNUC_CONST;
void settings_add_text_transform_flag (TransformFlags flag);
void settings_remove_text_transform_flag (TransformFlags flag);
TransformFlags settings_get_text_transform_flags (void);
Settings* settings_new (void);
Settings* settings_construct (GType object_type);
static void settings_finalize (GObject* obj);


void settings_init (void) {
	GSettings* _tmp0_ = NULL;
	_tmp0_ = g_settings_new ("org.baedert.corebird");
	_g_object_unref0 (settings_settings);
	settings_settings = _tmp0_;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GSettings* settings_get (void) {
	GSettings* result = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	_tmp0_ = settings_settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * Returns how many tweets should be stacked before a
   * notification should be created.
   */
gint settings_get_tweet_stack_count (void) {
	gint result = 0;
	gint setting_val = 0;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	_tmp0_ = settings_settings;
	_tmp1_ = g_settings_get_enum (_tmp0_, "new-tweets-notify");
	setting_val = _tmp1_;
	result = setting_val;
	return result;
}


/**
  * Check whether the user wants Corebird to always use the dark gtk theme variant.
  */
gboolean settings_use_dark_theme (void) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = settings_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "use-dark-theme");
	result = _tmp1_;
	return result;
}


gboolean settings_notify_new_mentions (void) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = settings_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "new-mentions-notify");
	result = _tmp1_;
	return result;
}


gboolean settings_notify_new_dms (void) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = settings_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "new-dms-notify");
	result = _tmp1_;
	return result;
}


gboolean settings_show_inline_media (void) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = settings_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "show-inline-media");
	result = _tmp1_;
	return result;
}


gboolean settings_auto_scroll_on_new_tweets (void) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = settings_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "auto-scroll-on-new-tweets");
	result = _tmp1_;
	return result;
}


gchar* settings_get_accel (const gchar* accel_name) {
	gchar* result = NULL;
	GSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (accel_name != NULL, NULL);
	_tmp0_ = settings_settings;
	_tmp1_ = accel_name;
	_tmp2_ = g_strconcat ("accel-", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_settings_get_string (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


gdouble settings_max_media_size (void) {
	gdouble result = 0.0;
	GSettings* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	_tmp0_ = settings_settings;
	_tmp1_ = g_settings_get_double (_tmp0_, "max-media-size");
	result = _tmp1_;
	return result;
}


void settings_toggle_sidebar_visible (void) {
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = settings_settings;
	_tmp1_ = settings_settings;
	_tmp2_ = g_settings_get_boolean (_tmp1_, "sidebar-visible");
	g_settings_set_boolean (_tmp0_, "sidebar-visible", !_tmp2_);
}


gchar* settings_get_consumer_key (void) {
	gchar* result = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = settings_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "consumer-key");
	result = _tmp1_;
	return result;
}


gchar* settings_get_consumer_secret (void) {
	gchar* result = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = settings_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "consumer-secret");
	result = _tmp1_;
	return result;
}


void settings_add_text_transform_flag (TransformFlags flag) {
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	TransformFlags _tmp3_ = 0;
	_tmp0_ = settings_settings;
	_tmp1_ = settings_settings;
	_tmp2_ = g_settings_get_uint (_tmp1_, "text-transform-flags");
	_tmp3_ = flag;
	g_settings_set_uint (_tmp0_, "text-transform-flags", _tmp2_ | _tmp3_);
}


void settings_remove_text_transform_flag (TransformFlags flag) {
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	TransformFlags _tmp3_ = 0;
	_tmp0_ = settings_settings;
	_tmp1_ = settings_settings;
	_tmp2_ = g_settings_get_uint (_tmp1_, "text-transform-flags");
	_tmp3_ = flag;
	g_settings_set_uint (_tmp0_, "text-transform-flags", _tmp2_ & (~_tmp3_));
}


TransformFlags settings_get_text_transform_flags (void) {
	TransformFlags result = 0;
	GSettings* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	_tmp0_ = settings_settings;
	_tmp1_ = g_settings_get_uint (_tmp0_, "text-transform-flags");
	result = (TransformFlags) _tmp1_;
	return result;
}


Settings* settings_construct (GType object_type) {
	Settings * self = NULL;
	self = (Settings*) g_object_new (object_type, NULL);
	return self;
}


Settings* settings_new (void) {
	return settings_construct (TYPE_SETTINGS);
}


static void settings_class_init (SettingsClass * klass) {
	settings_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = settings_finalize;
}


static void settings_instance_init (Settings * self) {
}


static void settings_finalize (GObject* obj) {
	Settings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTINGS, Settings);
	G_OBJECT_CLASS (settings_parent_class)->finalize (obj);
}


GType settings_get_type (void) {
	static volatile gsize settings_type_id__volatile = 0;
	if (g_once_init_enter (&settings_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Settings), 0, (GInstanceInitFunc) settings_instance_init, NULL };
		GType settings_type_id;
		settings_type_id = g_type_register_static (G_TYPE_OBJECT, "Settings", &g_define_type_info, 0);
		g_once_init_leave (&settings_type_id__volatile, settings_type_id);
	}
	return settings_type_id__volatile;
}



