/* SnippetManager.c generated by valac 0.30.0, the Vala compiler
 * generated from SnippetManager.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>


#define TYPE_SNIPPET_MANAGER (snippet_manager_get_type ())
#define SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNIPPET_MANAGER, SnippetManager))
#define SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNIPPET_MANAGER, SnippetManagerClass))
#define IS_SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNIPPET_MANAGER))
#define IS_SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNIPPET_MANAGER))
#define SNIPPET_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNIPPET_MANAGER, SnippetManagerClass))

typedef struct _SnippetManager SnippetManager;
typedef struct _SnippetManagerClass SnippetManagerClass;
typedef struct _SnippetManagerPrivate SnippetManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
#define _sql_select_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_select_statement_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;
#define _sql_insert_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_insert_statement_unref (var), NULL)))

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
#define _sql_update_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_update_statement_unref (var), NULL)))

struct _SnippetManager {
	GObject parent_instance;
	SnippetManagerPrivate * priv;
};

struct _SnippetManagerClass {
	GObjectClass parent_class;
};

struct _SnippetManagerPrivate {
	GeeHashMap* snippets;
	gboolean inited;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
typedef void (*SnippetManagerSnippetQueryFunc) (const gchar* key, const gchar* value, void* user_data);

static gpointer snippet_manager_parent_class = NULL;
extern SqlDatabase* corebird_db;

GType snippet_manager_get_type (void) G_GNUC_CONST;
#define SNIPPET_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SNIPPET_MANAGER, SnippetManagerPrivate))
enum  {
	SNIPPET_MANAGER_DUMMY_PROPERTY
};
SnippetManager* snippet_manager_new (void);
SnippetManager* snippet_manager_construct (GType object_type);
static void snippet_manager_load_snippets (SnippetManager* self);
gpointer sql_database_ref (gpointer instance);
void sql_database_unref (gpointer instance);
GParamSpec* sql_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_database (GValue* value, gpointer v_object);
void sql_value_take_database (GValue* value, gpointer v_object);
gpointer sql_value_get_database (const GValue* value);
GType sql_database_get_type (void) G_GNUC_CONST;
gpointer sql_select_statement_ref (gpointer instance);
void sql_select_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_select_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_select_statement (GValue* value, gpointer v_object);
void sql_value_take_select_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_select_statement (const GValue* value);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean __lambda7_ (SnippetManager* self, gchar** vals, int vals_length1);
static gboolean ___lambda7__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
void snippet_manager_remove_snippet (SnippetManager* self, const gchar* snippet_key);
void sql_database_exec (SqlDatabase* self, const gchar* sql, sqlite3_callback callback, void* callback_target);
void snippet_manager_insert_snippet (SnippetManager* self, const gchar* key, const gchar* value);
gpointer sql_insert_statement_ref (gpointer instance);
void sql_insert_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_insert_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_insert_statement (GValue* value, gpointer v_object);
void sql_value_take_insert_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_insert_statement (const GValue* value);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
gchar* snippet_manager_get_snippet (SnippetManager* self, const gchar* key);
void snippet_manager_query_snippets (SnippetManager* self, SnippetManagerSnippetQueryFunc func, void* func_target);
gint snippet_manager_n_snippets (SnippetManager* self);
void snippet_manager_set_snippet (SnippetManager* self, const gchar* old_key, const gchar* key, const gchar* new_value);
gpointer sql_update_statement_ref (gpointer instance);
void sql_update_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_update_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_update_statement (GValue* value, gpointer v_object);
void sql_value_take_update_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_update_statement (const GValue* value);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_val (SqlUpdateStatement* self, const gchar* col_name, const gchar* col_value);
SqlUpdateStatement* sql_update_statement_where_eq (SqlUpdateStatement* self, const gchar* col, const gchar* value);
gint64 sql_update_statement_run (SqlUpdateStatement* self);
static void snippet_manager_finalize (GObject* obj);


SnippetManager* snippet_manager_construct (GType object_type) {
	SnippetManager * self = NULL;
	self = (SnippetManager*) g_object_new (object_type, NULL);
	return self;
}


SnippetManager* snippet_manager_new (void) {
	return snippet_manager_construct (TYPE_SNIPPET_MANAGER);
}


static gboolean __lambda7_ (SnippetManager* self, gchar** vals, int vals_length1) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	_tmp0_ = self->priv->snippets;
	_tmp1_ = vals;
	_tmp1__length1 = vals_length1;
	_tmp2_ = _tmp1_[1];
	_tmp3_ = vals;
	_tmp3__length1 = vals_length1;
	_tmp4_ = _tmp3_[2];
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_, _tmp4_);
	result = TRUE;
	return result;
}


static gboolean ___lambda7__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda7_ ((SnippetManager*) self, vals, vals_length1);
	return result;
}


static void snippet_manager_load_snippets (SnippetManager* self) {
	SqlDatabase* _tmp0_ = NULL;
	SqlSelectStatement* _tmp1_ = NULL;
	SqlSelectStatement* _tmp2_ = NULL;
	SqlSelectStatement* _tmp3_ = NULL;
	SqlSelectStatement* _tmp4_ = NULL;
	SqlSelectStatement* _tmp5_ = NULL;
	SqlSelectStatement* _tmp6_ = NULL;
	g_return_if_fail (IS_SNIPPET_MANAGER (self));
	_tmp0_ = corebird_db;
	_tmp1_ = sql_database_select (_tmp0_, "snippets");
	_tmp2_ = _tmp1_;
	_tmp3_ = sql_select_statement_cols (_tmp2_, "id", "key", "value", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = sql_select_statement_order (_tmp4_, "id");
	_tmp6_ = _tmp5_;
	sql_select_statement_run (_tmp6_, ___lambda7__sql_select_callback, self);
	_sql_select_statement_unref0 (_tmp6_);
	_sql_select_statement_unref0 (_tmp4_);
	_sql_select_statement_unref0 (_tmp2_);
	self->priv->inited = TRUE;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void snippet_manager_remove_snippet (SnippetManager* self, const gchar* snippet_key) {
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	SqlDatabase* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_if_fail (IS_SNIPPET_MANAGER (self));
	g_return_if_fail (snippet_key != NULL);
	_tmp0_ = self->priv->inited;
	if (!_tmp0_) {
		snippet_manager_load_snippets (self);
	}
	_tmp1_ = self->priv->snippets;
	_tmp2_ = snippet_key;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_, NULL);
	_tmp3_ = corebird_db;
	_tmp4_ = snippet_key;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("DELETE FROM `snippets` WHERE `key`='", _tmp5_, "'", NULL);
	_tmp7_ = _tmp6_;
	sql_database_exec (_tmp3_, _tmp7_, NULL, NULL);
	_g_free0 (_tmp7_);
}


void snippet_manager_insert_snippet (SnippetManager* self, const gchar* key, const gchar* value) {
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	SqlDatabase* _tmp5_ = NULL;
	SqlInsertStatement* _tmp6_ = NULL;
	SqlInsertStatement* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	SqlInsertStatement* _tmp9_ = NULL;
	SqlInsertStatement* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	SqlInsertStatement* _tmp12_ = NULL;
	SqlInsertStatement* _tmp13_ = NULL;
	GeeHashMap* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	g_return_if_fail (IS_SNIPPET_MANAGER (self));
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->inited;
	if (!_tmp0_) {
		snippet_manager_load_snippets (self);
	}
	_tmp1_ = self->priv->snippets;
	_tmp2_ = key;
	_tmp3_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_);
	if (_tmp3_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = key;
		g_error ("SnippetManager.vala:52: Snippet already exists: %s", _tmp4_);
	}
	_tmp5_ = corebird_db;
	_tmp6_ = sql_database_insert (_tmp5_, "snippets");
	_tmp7_ = _tmp6_;
	_tmp8_ = key;
	_tmp9_ = sql_insert_statement_val (_tmp7_, "key", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = value;
	_tmp12_ = sql_insert_statement_val (_tmp10_, "value", _tmp11_);
	_tmp13_ = _tmp12_;
	sql_insert_statement_run (_tmp13_);
	_sql_insert_statement_unref0 (_tmp13_);
	_sql_insert_statement_unref0 (_tmp10_);
	_sql_insert_statement_unref0 (_tmp7_);
	_tmp14_ = self->priv->snippets;
	_tmp15_ = key;
	_tmp16_ = value;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp15_, _tmp16_);
}


gchar* snippet_manager_get_snippet (SnippetManager* self, const gchar* key) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	g_return_val_if_fail (IS_SNIPPET_MANAGER (self), NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->inited;
	if (!_tmp0_) {
		snippet_manager_load_snippets (self);
	}
	_tmp1_ = self->priv->snippets;
	_tmp2_ = key;
	_tmp3_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_);
	result = (gchar*) _tmp3_;
	return result;
}


void snippet_manager_query_snippets (SnippetManager* self, SnippetManagerSnippetQueryFunc func, void* func_target) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_SNIPPET_MANAGER (self));
	_tmp0_ = self->priv->inited;
	if (!_tmp0_) {
		snippet_manager_load_snippets (self);
	}
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeSet* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		_tmp1_ = self->priv->snippets;
		_tmp2_ = gee_abstract_map_get_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MAP, GeeMap));
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_entry_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			SnippetManagerSnippetQueryFunc _tmp11_ = NULL;
			void* _tmp11__target = NULL;
			GeeMapEntry* _tmp12_ = NULL;
			gconstpointer _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			GeeMapEntry* _tmp15_ = NULL;
			gconstpointer _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			_tmp7_ = _entry_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _entry_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			entry = (GeeMapEntry*) _tmp10_;
			_tmp11_ = func;
			_tmp11__target = func_target;
			_tmp12_ = entry;
			_tmp13_ = gee_map_entry_get_key (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = entry;
			_tmp16_ = gee_map_entry_get_value (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp11_ ((const gchar*) _tmp14_, (const gchar*) _tmp17_, _tmp11__target);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
}


gint snippet_manager_n_snippets (SnippetManager* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (IS_SNIPPET_MANAGER (self), 0);
	_tmp0_ = self->priv->inited;
	if (!_tmp0_) {
		snippet_manager_load_snippets (self);
	}
	_tmp1_ = self->priv->snippets;
	_tmp2_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MAP, GeeMap));
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}


void snippet_manager_set_snippet (SnippetManager* self, const gchar* old_key, const gchar* key, const gchar* new_value) {
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeHashMap* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GeeHashMap* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	SqlDatabase* _tmp10_ = NULL;
	SqlUpdateStatement* _tmp11_ = NULL;
	SqlUpdateStatement* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	SqlUpdateStatement* _tmp14_ = NULL;
	SqlUpdateStatement* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	SqlUpdateStatement* _tmp17_ = NULL;
	SqlUpdateStatement* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	SqlUpdateStatement* _tmp20_ = NULL;
	SqlUpdateStatement* _tmp21_ = NULL;
	g_return_if_fail (IS_SNIPPET_MANAGER (self));
	g_return_if_fail (old_key != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (new_value != NULL);
	_tmp0_ = self->priv->inited;
	if (!_tmp0_) {
		snippet_manager_load_snippets (self);
	}
	_tmp1_ = self->priv->snippets;
	_tmp2_ = old_key;
	_tmp3_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_);
	if (!_tmp3_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = key;
		g_debug ("SnippetManager.vala:86: Key %s not in hashmap!", _tmp4_);
		return;
	}
	_tmp5_ = self->priv->snippets;
	_tmp6_ = key;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_, NULL);
	_tmp7_ = self->priv->snippets;
	_tmp8_ = key;
	_tmp9_ = new_value;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_, _tmp9_);
	_tmp10_ = corebird_db;
	_tmp11_ = sql_database_update (_tmp10_, "snippets");
	_tmp12_ = _tmp11_;
	_tmp13_ = key;
	_tmp14_ = sql_update_statement_val (_tmp12_, "key", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = new_value;
	_tmp17_ = sql_update_statement_val (_tmp15_, "value", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = old_key;
	_tmp20_ = sql_update_statement_where_eq (_tmp18_, "key", _tmp19_);
	_tmp21_ = _tmp20_;
	sql_update_statement_run (_tmp21_);
	_sql_update_statement_unref0 (_tmp21_);
	_sql_update_statement_unref0 (_tmp18_);
	_sql_update_statement_unref0 (_tmp15_);
	_sql_update_statement_unref0 (_tmp12_);
}


static void snippet_manager_class_init (SnippetManagerClass * klass) {
	snippet_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SnippetManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = snippet_manager_finalize;
}


static void snippet_manager_instance_init (SnippetManager * self) {
	GeeHashMap* _tmp0_ = NULL;
	self->priv = SNIPPET_MANAGER_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->snippets = _tmp0_;
	self->priv->inited = FALSE;
}


static void snippet_manager_finalize (GObject* obj) {
	SnippetManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SNIPPET_MANAGER, SnippetManager);
	_g_object_unref0 (self->priv->snippets);
	G_OBJECT_CLASS (snippet_manager_parent_class)->finalize (obj);
}


GType snippet_manager_get_type (void) {
	static volatile gsize snippet_manager_type_id__volatile = 0;
	if (g_once_init_enter (&snippet_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SnippetManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) snippet_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SnippetManager), 0, (GInstanceInitFunc) snippet_manager_instance_init, NULL };
		GType snippet_manager_type_id;
		snippet_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "SnippetManager", &g_define_type_info, 0);
		g_once_init_leave (&snippet_manager_type_id__volatile, snippet_manager_type_id);
	}
	return snippet_manager_type_id__volatile;
}



