/* TweetInfoPage.c generated by valac 0.30.0, the Vala compiler
 * generated from TweetInfoPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_TWEET_INFO_PAGE (tweet_info_page_get_type ())
#define TWEET_INFO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_INFO_PAGE, TweetInfoPage))
#define TWEET_INFO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_INFO_PAGE, TweetInfoPageClass))
#define IS_TWEET_INFO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_INFO_PAGE))
#define IS_TWEET_INFO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_INFO_PAGE))
#define TWEET_INFO_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_INFO_PAGE, TweetInfoPageClass))

typedef struct _TweetInfoPage TweetInfoPage;
typedef struct _TweetInfoPageClass TweetInfoPageClass;
typedef struct _TweetInfoPagePrivate TweetInfoPagePrivate;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;

#define TYPE_MULTI_MEDIA_WIDGET (multi_media_widget_get_type ())
#define MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget))
#define MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))
#define IS_MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_MEDIA_WIDGET))
#define IS_MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_MEDIA_WIDGET))
#define MULTI_MEDIA_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))

typedef struct _MultiMediaWidget MultiMediaWidget;
typedef struct _MultiMediaWidgetClass MultiMediaWidgetClass;

#define TYPE_TEXT_BUTTON (text_button_get_type ())
#define TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_BUTTON, TextButton))
#define TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_BUTTON, TextButtonClass))
#define IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_BUTTON))
#define IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_BUTTON))
#define TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_BUTTON, TextButtonClass))

typedef struct _TextButton TextButton;
typedef struct _TextButtonClass TextButtonClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_MAX_SIZE_CONTAINER (max_size_container_get_type ())
#define MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainer))
#define MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))
#define IS_MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAX_SIZE_CONTAINER))
#define IS_MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAX_SIZE_CONTAINER))
#define MAX_SIZE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))

typedef struct _MaxSizeContainer MaxSizeContainer;
typedef struct _MaxSizeContainerClass MaxSizeContainerClass;

#define TYPE_REPLY_INDICATOR (reply_indicator_get_type ())
#define REPLY_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REPLY_INDICATOR, ReplyIndicator))
#define REPLY_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REPLY_INDICATOR, ReplyIndicatorClass))
#define IS_REPLY_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REPLY_INDICATOR))
#define IS_REPLY_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REPLY_INDICATOR))
#define REPLY_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REPLY_INDICATOR, ReplyIndicatorClass))

typedef struct _ReplyIndicator ReplyIndicator;
typedef struct _ReplyIndicatorClass ReplyIndicatorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;
typedef struct _MiniTweetPrivate MiniTweetPrivate;

#define TYPE_USER_IDENTITY (user_identity_get_type ())
typedef struct _UserIdentity UserIdentity;

#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())
typedef struct _Block32Data Block32Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _Block33Data Block33Data;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block34Data Block34Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block35Data Block35Data;

#define TYPE_USER_COUNTER (user_counter_get_type ())
#define USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COUNTER, UserCounter))
#define USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COUNTER, UserCounterClass))
#define IS_USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COUNTER))
#define IS_USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COUNTER))
#define USER_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COUNTER, UserCounterClass))

typedef struct _UserCounter UserCounter;
typedef struct _UserCounterClass UserCounterClass;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _TweetInfoPage {
	ScrollWidget parent_instance;
	TweetInfoPagePrivate * priv;
};

struct _TweetInfoPageClass {
	ScrollWidgetClass parent_class;
};

struct _TweetInfoPagePrivate {
	gint _id;
	MainWindow* _main_window;
	Account* _account;
	gint64 tweet_id;
	gchar* screen_name;
	gboolean values_set;
	Tweet* tweet;
	GSimpleActionGroup* actions;
	GtkGrid* grid;
	MultiMediaWidget* mm_widget;
	GtkLabel* text_label;
	TextButton* name_button;
	GtkLabel* screen_name_label;
	AvatarWidget* avatar_image;
	GtkLabel* rt_label;
	GtkLabel* fav_label;
	TweetListBox* bottom_list_box;
	TweetListBox* top_list_box;
	GtkToggleButton* favorite_button;
	GtkToggleButton* retweet_button;
	GtkLabel* time_label;
	GtkLabel* source_label;
	MaxSizeContainer* max_size_container;
	ReplyIndicator* reply_indicator;
	GtkStack* main_stack;
	GtkLabel* error_label;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	Tweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	guint hidden_flags;
	gint64 id;
	MiniTweet* source_tweet;
	MiniTweet* retweeted_tweet;
	MiniTweet* quoted_tweet;
	gchar* avatar_url;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gchar* notification_id;
	gint64 reply_id;
	gint retweet_count;
	gint favorite_count;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _UserIdentity {
	gint64 id;
	gchar* screen_name;
	gchar* user_name;
};

struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

struct _MiniTweet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MiniTweetPrivate * priv;
	gint64 id;
	gint64 created_at;
	UserIdentity author;
	gchar* text;
	TextEntity* entities;
	gint entities_length1;
	Media** medias;
	gint medias_length1;
};

struct _MiniTweetClass {
	GTypeClass parent_class;
	void (*finalize) (MiniTweet *self);
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _Block32Data {
	int _ref_count_;
	TweetInfoPage* self;
	GDateTime* now;
	gboolean existing;
};

struct _Block33Data {
	int _ref_count_;
	Block32Data * _data32_;
	gint64 previous_tweet_id;
	gint n_replies;
};

struct _Block34Data {
	int _ref_count_;
	TweetInfoPage* self;
	RestProxyCall* call;
};

struct _Block35Data {
	int _ref_count_;
	TweetInfoPage* self;
	Tweet* tweet;
};


static gpointer tweet_info_page_parent_class = NULL;
static IPageIface* tweet_info_page_ipage_parent_iface = NULL;
static IMessageReceiverIface* tweet_info_page_imessage_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType tweet_info_page_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
GType multi_media_widget_get_type (void) G_GNUC_CONST;
GType text_button_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType max_size_container_get_type (void) G_GNUC_CONST;
GType reply_indicator_get_type (void) G_GNUC_CONST;
#define TWEET_INFO_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_INFO_PAGE, TweetInfoPagePrivate))
enum  {
	TWEET_INFO_PAGE_DUMMY_PROPERTY,
	TWEET_INFO_PAGE_UNREAD_COUNT,
	TWEET_INFO_PAGE_ID,
	TWEET_INFO_PAGE_MAIN_WINDOW,
	TWEET_INFO_PAGE_ACCOUNT,
	TWEET_INFO_PAGE_DELTA_UPDATER
};
#define TWEET_INFO_PAGE_BY_INSTANCE 1
#define TWEET_INFO_PAGE_BY_ID 2
static void tweet_info_page_quote_activated (TweetInfoPage* self);
static void _tweet_info_page_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
TweetInfoPage* tweet_info_page_new (gint id, Account* account);
TweetInfoPage* tweet_info_page_construct (GType object_type, gint id, Account* account);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
void ipage_set_account (IPage* self, Account* value);
GType delta_updater_get_type (void) G_GNUC_CONST;
GType tweet_model_get_type (void) G_GNUC_CONST;
GType media_get_type (void) G_GNUC_CONST;
static void __lambda70_ (TweetInfoPage* self, Media* m, gint i);
void tweet_utils_handle_media_click (Tweet* t, MainWindow* window, gint index);
MainWindow* ipage_get_main_window (IPage* self);
static void ___lambda70__multi_media_widget_media_clicked (MultiMediaWidget* _sender, Media* m, gint index, gpointer self);
static gboolean __lambda77_ (TweetInfoPage* self, GdkEventScroll* evt);
gboolean reply_indicator_get_replies_available (ReplyIndicator* self);
gint max_size_container_get_max_size (MaxSizeContainer* self);
void max_size_container_set_max_size (MaxSizeContainer* self, gint value);
static gboolean ___lambda77__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static void __lambda78_ (TweetInfoPage* self, GtkListBoxRow* row);
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int (Bundle* self, const gchar* key, gint value);
void bundle_put_object (Bundle* self, const gchar* key, GObject* object);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType itwitter_item_get_type (void) G_GNUC_CONST;
void bundle_put_bool (Bundle* self, const gchar* key, gboolean value);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda78__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void __lambda79_ (TweetInfoPage* self, GtkListBoxRow* row);
static void ___lambda79__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void tweet_info_page_real_on_join (IPage* base, gint page_id, Bundle* args);
gint bundle_get_int (Bundle* self, const gchar* key);
gboolean bundle_get_bool (Bundle* self, const gchar* key, gboolean _default_);
void reply_indicator_set_replies_available (ReplyIndicator* self, gboolean value);
GObject* bundle_get_object (Bundle* self, const gchar* key);
static void tweet_info_page_rearrange_tweets (TweetInfoPage* self, gint64 new_id);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
void tweet_model_clear (TweetModel* self);
GType user_identity_get_type (void) G_GNUC_CONST;
UserIdentity* user_identity_dup (const UserIdentity* self);
void user_identity_free (UserIdentity* self);
void user_identity_copy (const UserIdentity* self, UserIdentity* dest);
void user_identity_destroy (UserIdentity* self);
GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
const gchar* tweet_get_screen_name (Tweet* self);
static void tweet_info_page_set_tweet_data (TweetInfoPage* self, Tweet* tweet, const gchar* with);
gint64 bundle_get_int64 (Bundle* self, const gchar* key);
gchar* bundle_get_string (Bundle* self, const gchar* key);
static void tweet_info_page_query_tweet_info (TweetInfoPage* self, gboolean existing);
gboolean tweet_model_contains_id (TweetModel* self, gint64 tweet_id);
void tweet_model_add (TweetModel* self, Tweet* tweet);
Tweet* tweet_model_get_from_id (TweetModel* self, gint64 id, gint diff);
void tweet_model_remove_tweets_above (TweetModel* self, gint64 id);
static void tweet_info_page_real_on_leave (IPage* base);
static void tweet_info_page_favorite_button_toggled_cb (TweetInfoPage* self);
static void tweet_info_page_update_rt_fav_labels (TweetInfoPage* self);
void tweet_utils_toggle_favorite_tweet (Account* account, Tweet* tweet, gboolean unfavorite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_toggle_favorite_tweet_finish (GAsyncResult* _res_);
Account* ipage_get_account (IPage* self);
static void __lambda86_ (TweetInfoPage* self);
static void ___lambda86__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tweet_info_page_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_info_page_retweet_button_toggled_cb (TweetInfoPage* self);
void tweet_utils_toggle_retweet_tweet (Account* account, Tweet* tweet, gboolean unretweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_toggle_retweet_tweet_finish (GAsyncResult* _res_);
static void __lambda88_ (TweetInfoPage* self);
static void ___lambda88__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tweet_info_page_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_info_page_reply_button_clicked_cb (TweetInfoPage* self);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode);
static void _tweet_info_page_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean tweet_info_page_link_activated_cb (TweetInfoPage* self, const gchar* uri);
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
static gboolean _tweet_info_page_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
static void tweet_info_page_name_button_clicked_cb (TweetInfoPage* self);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
static void _tweet_info_page_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
OAuthProxy* account_get_proxy (Account* self);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static void __lambda81_ (Block32Data* _data32_, GObject* __, GAsyncResult* res);
static void _vala_JsonNode_free (JsonNode* self);
Tweet* tweet_new (void);
Tweet* tweet_construct (GType object_type);
void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account);
static gchar* tweet_info_page_extract_source (TweetInfoPage* self, const gchar* source_str);
static void tweet_info_page_load_replied_to_tweet (TweetInfoPage* self, gint64 reply_id);
static void ___lambda81__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda83_ (Block32Data* _data32_, GObject* _, GAsyncResult* res);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void __lambda84_ (Block33Data* _data33_, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda84__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda83__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
static void __lambda82_ (Block34Data* _data34_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
static void ___lambda82__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
GType user_counter_get_type (void) G_GNUC_CONST;
UserCounter* account_get_user_counter (Account* self);
void user_counter_user_seen (UserCounter* self, gint64 id, const gchar* screen_name, const gchar* name);
gint64 tweet_get_user_id (Tweet* self);
const gchar* tweet_get_user_name (Tweet* self);
gchar* tweet_get_formatted_text (Tweet* self);
void text_button_set_markup (TextButton* self, const gchar* text);
cairo_surface_t* tweet_get_avatar (Tweet* self);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static void __lambda80_ (Block35Data* _data35_);
static void ___lambda80__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean tweet_get_retweeted (Tweet* self);
gboolean tweet_get_favorited (Tweet* self);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
static void tweet_info_page_set_source_link (TweetInfoPage* self, gint64 id, const gchar* screen_name);
gboolean tweet_get_has_inline_media (Tweet* self);
void multi_media_widget_set_all_media (MultiMediaWidget* self, Media** medias, int medias_length1);
Media** tweet_get_medias (Tweet* self, int* result_length1);
gint64 account_get_id (Account* self);
static gchar* tweet_info_page_real_get_title (IPage* base);
static void tweet_info_page_real_create_tool_button (IPage* base, GtkRadioButton* group);
static GtkRadioButton* tweet_info_page_real_get_tool_button (IPage* base);
static void tweet_info_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root);
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name);
gint tweet_info_page_get_unread_count (TweetInfoPage* self);
void tweet_info_page_set_delta_updater (TweetInfoPage* self, DeltaUpdater* value);
static void tweet_info_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_tweet_info_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_main_window (IPage* self, MainWindow* value);
static void _vala_tweet_info_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry TWEET_INFO_PAGE_action_entries[1] = {{"quote", _tweet_info_page_quote_activated_gsimple_action_activate_callback}};

static void _tweet_info_page_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_info_page_quote_activated ((TweetInfoPage*) self);
}


static void __lambda70_ (TweetInfoPage* self, Media* m, gint i) {
	Tweet* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (IS_MEDIA (m));
	_tmp0_ = self->priv->tweet;
	_tmp1_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp2_ = _tmp1_;
	_tmp3_ = i;
	tweet_utils_handle_media_click (_tmp0_, _tmp2_, _tmp3_);
}


static void ___lambda70__multi_media_widget_media_clicked (MultiMediaWidget* _sender, Media* m, gint index, gpointer self) {
	__lambda70_ ((TweetInfoPage*) self, m, index);
}


static gboolean __lambda77_ (TweetInfoPage* self, GdkEventScroll* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkEventScroll* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp2_ = evt;
	_tmp3_ = _tmp2_->delta_y;
	if (_tmp3_ < ((gdouble) 0)) {
		GtkAdjustment* _tmp4_ = NULL;
		GtkAdjustment* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		_tmp4_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_adjustment_get_value (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ == ((gdouble) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ReplyIndicator* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = self->priv->reply_indicator;
		_tmp9_ = reply_indicator_get_replies_available (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint inc = 0;
		GtkAdjustment* _tmp11_ = NULL;
		GtkAdjustment* _tmp12_ = NULL;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		GdkEventScroll* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		MaxSizeContainer* _tmp17_ = NULL;
		MaxSizeContainer* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp11_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp12_ = _tmp11_;
		_tmp13_ = gtk_adjustment_get_step_increment (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = evt;
		_tmp16_ = _tmp15_->delta_y;
		inc = (gint) (_tmp14_ * (-_tmp16_));
		_tmp17_ = self->priv->max_size_container;
		_tmp18_ = self->priv->max_size_container;
		_tmp19_ = max_size_container_get_max_size (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = inc;
		max_size_container_set_max_size (_tmp18_, _tmp20_ + _tmp21_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda77__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = __lambda77_ ((TweetInfoPage*) self, event);
	return result;
}


static void __lambda78_ (TweetInfoPage* self, GtkListBoxRow* row) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	MainWidget* _tmp5_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	bundle_put_int (bundle, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
	_tmp1_ = row;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
	bundle_put_object (bundle, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
	bundle_put_bool (bundle, "existing", TRUE);
	_tmp3_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->main_widget;
	main_widget_switch_page (_tmp5_, (gint) PAGE_TWEET_INFO, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda78__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda78_ ((TweetInfoPage*) self, row);
}


static void __lambda79_ (TweetInfoPage* self, GtkListBoxRow* row) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	MainWidget* _tmp5_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	bundle_put_int (bundle, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
	_tmp1_ = row;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
	bundle_put_object (bundle, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
	bundle_put_bool (bundle, "existing", TRUE);
	_tmp3_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->main_widget;
	main_widget_switch_page (_tmp5_, (gint) PAGE_TWEET_INFO, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda79__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda79_ ((TweetInfoPage*) self, row);
}


TweetInfoPage* tweet_info_page_construct (GType object_type, gint id, Account* account) {
	TweetInfoPage * self = NULL;
	gint _tmp0_ = 0;
	Account* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	TweetListBox* _tmp4_ = NULL;
	Account* _tmp5_ = NULL;
	MultiMediaWidget* _tmp6_ = NULL;
	TweetListBox* _tmp7_ = NULL;
	TweetListBox* _tmp8_ = NULL;
	GSimpleActionGroup* _tmp9_ = NULL;
	GSimpleActionGroup* _tmp10_ = NULL;
	GSimpleActionGroup* _tmp11_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (TweetInfoPage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp1_);
	_tmp2_ = self->priv->top_list_box;
	_tmp3_ = account;
	_tmp2_->account = _tmp3_;
	_tmp4_ = self->priv->bottom_list_box;
	_tmp5_ = account;
	_tmp4_->account = _tmp5_;
	_tmp6_ = self->priv->mm_widget;
	g_signal_connect_object (_tmp6_, "media-clicked", (GCallback) ___lambda70__multi_media_widget_media_clicked, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "scroll-event", (GCallback) ___lambda77__gtk_widget_scroll_event, self, 0);
	_tmp7_ = self->priv->bottom_list_box;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda78__gtk_list_box_row_activated, self, 0);
	_tmp8_ = self->priv->top_list_box;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda79__gtk_list_box_row_activated, self, 0);
	_tmp9_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = _tmp9_;
	_tmp10_ = self->priv->actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_action_map_get_type (), GActionMap), TWEET_INFO_PAGE_action_entries, G_N_ELEMENTS (TWEET_INFO_PAGE_action_entries), self);
	_tmp11_ = self->priv->actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_action_group_get_type (), GActionGroup));
	return self;
}


TweetInfoPage* tweet_info_page_new (gint id, Account* account) {
	return tweet_info_page_construct (TYPE_TWEET_INFO_PAGE, id, account);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tweet_info_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	TweetInfoPage * self;
	gint mode = 0;
	Bundle* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean existing = FALSE;
	Bundle* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	ReplyIndicator* _tmp5_ = NULL;
	MaxSizeContainer* _tmp6_ = NULL;
	GtkStack* _tmp7_ = NULL;
	GtkGrid* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gint _tmp20_ = 0;
	gboolean _tmp42_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp0_ = args;
	_tmp1_ = bundle_get_int (_tmp0_, "mode");
	mode = _tmp1_;
	_tmp2_ = mode;
	if (_tmp2_ == 0) {
		return;
	}
	self->priv->values_set = FALSE;
	_tmp3_ = args;
	_tmp4_ = bundle_get_bool (_tmp3_, "existing", FALSE);
	existing = _tmp4_;
	_tmp5_ = self->priv->reply_indicator;
	reply_indicator_set_replies_available (_tmp5_, FALSE);
	_tmp6_ = self->priv->max_size_container;
	max_size_container_set_max_size (_tmp6_, 0);
	_tmp7_ = self->priv->main_stack;
	_tmp8_ = self->priv->grid;
	gtk_stack_set_visible_child (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = existing;
	if (_tmp9_) {
		Tweet* tweet = NULL;
		Bundle* _tmp10_ = NULL;
		GObject* _tmp11_ = NULL;
		Tweet* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		_tmp10_ = args;
		_tmp11_ = bundle_get_object (_tmp10_, "tweet");
		tweet = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_TWEET, Tweet);
		_tmp12_ = tweet;
		_tmp13_ = _tmp12_->id;
		tweet_info_page_rearrange_tweets (self, _tmp13_);
		_g_object_unref0 (tweet);
	} else {
		TweetListBox* _tmp14_ = NULL;
		TweetModel* _tmp15_ = NULL;
		TweetListBox* _tmp16_ = NULL;
		TweetListBox* _tmp17_ = NULL;
		TweetModel* _tmp18_ = NULL;
		TweetListBox* _tmp19_ = NULL;
		_tmp14_ = self->priv->bottom_list_box;
		_tmp15_ = _tmp14_->model;
		tweet_model_clear (_tmp15_);
		_tmp16_ = self->priv->bottom_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
		_tmp17_ = self->priv->top_list_box;
		_tmp18_ = _tmp17_->model;
		tweet_model_clear (_tmp18_);
		_tmp19_ = self->priv->top_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp20_ = mode;
	if (_tmp20_ == TWEET_INFO_PAGE_BY_INSTANCE) {
		Tweet* tweet = NULL;
		Bundle* _tmp21_ = NULL;
		GObject* _tmp22_ = NULL;
		Tweet* _tmp23_ = NULL;
		MiniTweet* _tmp24_ = NULL;
		Tweet* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		Tweet* _tmp34_ = NULL;
		Tweet* _tmp35_ = NULL;
		Tweet* _tmp36_ = NULL;
		_tmp21_ = args;
		_tmp22_ = bundle_get_object (_tmp21_, "tweet");
		tweet = G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_TWEET, Tweet);
		_tmp23_ = tweet;
		_tmp24_ = _tmp23_->retweeted_tweet;
		if (_tmp24_ != NULL) {
			Tweet* _tmp25_ = NULL;
			MiniTweet* _tmp26_ = NULL;
			gint64 _tmp27_ = 0LL;
			_tmp25_ = tweet;
			_tmp26_ = _tmp25_->retweeted_tweet;
			_tmp27_ = _tmp26_->id;
			self->priv->tweet_id = _tmp27_;
		} else {
			Tweet* _tmp28_ = NULL;
			gint64 _tmp29_ = 0LL;
			_tmp28_ = tweet;
			_tmp29_ = _tmp28_->id;
			self->priv->tweet_id = _tmp29_;
		}
		_tmp30_ = tweet;
		_tmp31_ = tweet_get_screen_name (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strdup (_tmp32_);
		_g_free0 (self->priv->screen_name);
		self->priv->screen_name = _tmp33_;
		_tmp34_ = tweet;
		_tmp35_ = _g_object_ref0 (_tmp34_);
		_g_object_unref0 (self->priv->tweet);
		self->priv->tweet = _tmp35_;
		_tmp36_ = tweet;
		tweet_info_page_set_tweet_data (self, _tmp36_, NULL);
		_g_object_unref0 (tweet);
	} else {
		gint _tmp37_ = 0;
		_tmp37_ = mode;
		if (_tmp37_ == TWEET_INFO_PAGE_BY_ID) {
			Bundle* _tmp38_ = NULL;
			gint64 _tmp39_ = 0LL;
			Bundle* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			_tmp38_ = args;
			_tmp39_ = bundle_get_int64 (_tmp38_, "tweet_id");
			self->priv->tweet_id = _tmp39_;
			_tmp40_ = args;
			_tmp41_ = bundle_get_string (_tmp40_, "screen_name");
			_g_free0 (self->priv->screen_name);
			self->priv->screen_name = _tmp41_;
		}
	}
	_tmp42_ = existing;
	tweet_info_page_query_tweet_info (self, _tmp42_);
}


static void tweet_info_page_rearrange_tweets (TweetInfoPage* self, gint64 new_id) {
	TweetListBox* _tmp0_ = NULL;
	TweetModel* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->top_list_box;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = new_id;
	_tmp3_ = tweet_model_contains_id (_tmp1_, _tmp2_);
	if (_tmp3_) {
		TweetListBox* _tmp4_ = NULL;
		TweetModel* _tmp5_ = NULL;
		Tweet* _tmp6_ = NULL;
		TweetListBox* _tmp7_ = NULL;
		TweetListBox* _tmp8_ = NULL;
		TweetModel* _tmp9_ = NULL;
		TweetListBox* _tmp10_ = NULL;
		_tmp4_ = self->priv->bottom_list_box;
		_tmp5_ = _tmp4_->model;
		_tmp6_ = self->priv->tweet;
		tweet_model_add (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->bottom_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
		_tmp8_ = self->priv->top_list_box;
		_tmp9_ = _tmp8_->model;
		tweet_model_clear (_tmp9_);
		_tmp10_ = self->priv->top_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	} else {
		TweetListBox* _tmp11_ = NULL;
		TweetModel* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		gboolean _tmp14_ = FALSE;
		_tmp11_ = self->priv->bottom_list_box;
		_tmp12_ = _tmp11_->model;
		_tmp13_ = new_id;
		_tmp14_ = tweet_model_contains_id (_tmp12_, _tmp13_);
		if (_tmp14_) {
			TweetListBox* _tmp15_ = NULL;
			TweetModel* _tmp16_ = NULL;
			TweetListBox* _tmp17_ = NULL;
			Tweet* t = NULL;
			TweetListBox* _tmp18_ = NULL;
			TweetModel* _tmp19_ = NULL;
			gint64 _tmp20_ = 0LL;
			Tweet* _tmp21_ = NULL;
			Tweet* _tmp22_ = NULL;
			ReplyIndicator* _tmp29_ = NULL;
			TweetListBox* _tmp30_ = NULL;
			TweetModel* _tmp31_ = NULL;
			gint64 _tmp32_ = 0LL;
			TweetListBox* _tmp33_ = NULL;
			TweetModel* _tmp34_ = NULL;
			guint _tmp35_ = 0U;
			_tmp15_ = self->priv->top_list_box;
			_tmp16_ = _tmp15_->model;
			tweet_model_clear (_tmp16_);
			_tmp17_ = self->priv->top_list_box;
			gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
			_tmp18_ = self->priv->bottom_list_box;
			_tmp19_ = _tmp18_->model;
			_tmp20_ = new_id;
			_tmp21_ = tweet_model_get_from_id (_tmp19_, _tmp20_, -1);
			t = _tmp21_;
			_tmp22_ = t;
			if (_tmp22_ != NULL) {
				TweetListBox* _tmp23_ = NULL;
				TweetModel* _tmp24_ = NULL;
				Tweet* _tmp25_ = NULL;
				_tmp23_ = self->priv->top_list_box;
				_tmp24_ = _tmp23_->model;
				_tmp25_ = t;
				tweet_model_add (_tmp24_, _tmp25_);
			} else {
				TweetListBox* _tmp26_ = NULL;
				TweetModel* _tmp27_ = NULL;
				Tweet* _tmp28_ = NULL;
				_tmp26_ = self->priv->top_list_box;
				_tmp27_ = _tmp26_->model;
				_tmp28_ = self->priv->tweet;
				tweet_model_add (_tmp27_, _tmp28_);
			}
			_tmp29_ = self->priv->reply_indicator;
			reply_indicator_set_replies_available (_tmp29_, TRUE);
			_tmp30_ = self->priv->bottom_list_box;
			_tmp31_ = _tmp30_->model;
			_tmp32_ = new_id;
			tweet_model_remove_tweets_above (_tmp31_, _tmp32_);
			_tmp33_ = self->priv->bottom_list_box;
			_tmp34_ = _tmp33_->model;
			_tmp35_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_list_model_get_type (), GListModel));
			if (_tmp35_ == ((guint) 0)) {
				TweetListBox* _tmp36_ = NULL;
				_tmp36_ = self->priv->bottom_list_box;
				gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
			}
			_g_object_unref0 (t);
		}
	}
}


static void tweet_info_page_real_on_leave (IPage* base) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
}


static void __lambda86_ (TweetInfoPage* self) {
	GtkToggleButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda86__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda86_ ((TweetInfoPage*) self);
	g_object_unref (self);
}


static void tweet_info_page_favorite_button_toggled_cb (TweetInfoPage* self) {
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Account* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	Tweet* _tmp11_ = NULL;
	GtkToggleButton* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->values_set;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = self->priv->favorite_button;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		Tweet* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp5_ = self->priv->tweet;
		_tmp6_ = _tmp5_->favorite_count;
		_tmp5_->favorite_count = _tmp6_ + 1;
	} else {
		Tweet* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp7_ = self->priv->tweet;
		_tmp8_ = _tmp7_->favorite_count;
		_tmp7_->favorite_count = _tmp8_ - 1;
	}
	tweet_info_page_update_rt_fav_labels (self);
	_tmp9_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->tweet;
	_tmp12_ = self->priv->favorite_button;
	_tmp13_ = gtk_toggle_button_get_active (_tmp12_);
	_tmp14_ = _tmp13_;
	tweet_utils_toggle_favorite_tweet (_tmp10_, _tmp11_, !_tmp14_, ___lambda86__gasync_ready_callback, g_object_ref (self));
}


static void _tweet_info_page_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_info_page_favorite_button_toggled_cb ((TweetInfoPage*) self);
}


static void __lambda88_ (TweetInfoPage* self) {
	GtkToggleButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda88__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda88_ ((TweetInfoPage*) self);
	g_object_unref (self);
}


static void tweet_info_page_retweet_button_toggled_cb (TweetInfoPage* self) {
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Account* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	Tweet* _tmp11_ = NULL;
	GtkToggleButton* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->values_set;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = self->priv->retweet_button;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		Tweet* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp5_ = self->priv->tweet;
		_tmp6_ = _tmp5_->retweet_count;
		_tmp5_->retweet_count = _tmp6_ + 1;
	} else {
		Tweet* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp7_ = self->priv->tweet;
		_tmp8_ = _tmp7_->retweet_count;
		_tmp7_->retweet_count = _tmp8_ - 1;
	}
	tweet_info_page_update_rt_fav_labels (self);
	_tmp9_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->tweet;
	_tmp12_ = self->priv->retweet_button;
	_tmp13_ = gtk_toggle_button_get_active (_tmp12_);
	_tmp14_ = _tmp13_;
	tweet_utils_toggle_retweet_tweet (_tmp10_, _tmp11_, !_tmp14_, ___lambda88__gasync_ready_callback, g_object_ref (self));
}


static void _tweet_info_page_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_info_page_retweet_button_toggled_cb ((TweetInfoPage*) self);
}


static void tweet_info_page_reply_button_clicked_cb (TweetInfoPage* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	Tweet* _tmp4_ = NULL;
	ComposeTweetWindow* _tmp5_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->tweet;
	_tmp5_ = compose_tweet_window_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow), _tmp3_, _tmp4_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp5_);
	ctw = _tmp5_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static void _tweet_info_page_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_info_page_reply_button_clicked_cb ((TweetInfoPage*) self);
}


static gboolean tweet_info_page_link_activated_cb (TweetInfoPage* self, const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (IS_TWEET_INFO_PAGE (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp2_ = _tmp1_;
	_tmp3_ = tweet_utils_activate_link (_tmp0_, _tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean _tweet_info_page_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = tweet_info_page_link_activated_cb ((TweetInfoPage*) self, uri);
	return result;
}


static void tweet_info_page_name_button_clicked_cb (TweetInfoPage* self) {
	gint64 id = 0LL;
	gchar* screen_name = NULL;
	Tweet* _tmp0_ = NULL;
	MiniTweet* _tmp1_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp20_ = NULL;
	gint64 _tmp21_ = 0LL;
	const gchar* _tmp22_ = NULL;
	MainWindow* _tmp23_ = NULL;
	MainWindow* _tmp24_ = NULL;
	MainWidget* _tmp25_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->tweet;
	_tmp1_ = _tmp0_->retweeted_tweet;
	if (_tmp1_ != NULL) {
		Tweet* _tmp2_ = NULL;
		MiniTweet* _tmp3_ = NULL;
		UserIdentity _tmp4_ = {0};
		gint64 _tmp5_ = 0LL;
		Tweet* _tmp6_ = NULL;
		MiniTweet* _tmp7_ = NULL;
		UserIdentity _tmp8_ = {0};
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp2_ = self->priv->tweet;
		_tmp3_ = _tmp2_->retweeted_tweet;
		_tmp4_ = _tmp3_->author;
		_tmp5_ = _tmp4_.id;
		id = _tmp5_;
		_tmp6_ = self->priv->tweet;
		_tmp7_ = _tmp6_->retweeted_tweet;
		_tmp8_ = _tmp7_->author;
		_tmp9_ = _tmp8_.screen_name;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (screen_name);
		screen_name = _tmp10_;
	} else {
		Tweet* _tmp11_ = NULL;
		MiniTweet* _tmp12_ = NULL;
		UserIdentity _tmp13_ = {0};
		gint64 _tmp14_ = 0LL;
		Tweet* _tmp15_ = NULL;
		MiniTweet* _tmp16_ = NULL;
		UserIdentity _tmp17_ = {0};
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp11_ = self->priv->tweet;
		_tmp12_ = _tmp11_->source_tweet;
		_tmp13_ = _tmp12_->author;
		_tmp14_ = _tmp13_.id;
		id = _tmp14_;
		_tmp15_ = self->priv->tweet;
		_tmp16_ = _tmp15_->source_tweet;
		_tmp17_ = _tmp16_->author;
		_tmp18_ = _tmp17_.screen_name;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (screen_name);
		screen_name = _tmp19_;
	}
	_tmp20_ = bundle_new ();
	bundle = _tmp20_;
	_tmp21_ = id;
	bundle_put_int64 (bundle, "user_id", _tmp21_);
	_tmp22_ = screen_name;
	bundle_put_string (bundle, "screen_name", _tmp22_);
	_tmp23_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_->main_widget;
	main_widget_switch_page (_tmp25_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
	_g_free0 (screen_name);
}


static void _tweet_info_page_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_info_page_name_button_clicked_cb ((TweetInfoPage*) self);
}


/**
   * Loads the data of the tweet with the id tweet_id from the Twitter server.
   */
static Block32Data* block32_data_ref (Block32Data* _data32_) {
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}


static void block32_data_unref (void * _userdata_) {
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data32_->self;
		_g_date_time_unref0 (_data32_->now);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void __lambda81_ (Block32Data* _data32_, GObject* __, GAsyncResult* res) {
	TweetInfoPage* self;
	JsonNode* root = NULL;
	Tweet* _tmp12_ = NULL;
	Tweet* _tmp13_ = NULL;
	JsonNode* _tmp14_ = NULL;
	Account* _tmp15_ = NULL;
	Account* _tmp16_ = NULL;
	JsonObject* root_object = NULL;
	JsonNode* _tmp17_ = NULL;
	JsonObject* _tmp18_ = NULL;
	JsonObject* _tmp19_ = NULL;
	gchar* with = NULL;
	JsonObject* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	Tweet* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data32_->self;
	g_return_if_fail ((__ == NULL) || G_IS_OBJECT (__));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		JsonNode* _tmp2_ = NULL;
		JsonNode* _tmp3_ = NULL;
		_tmp1_ = res;
		_tmp2_ = tweet_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch40_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* e = NULL;
		GtkLabel* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		GtkStack* _tmp10_ = NULL;
		GtkLabel* _tmp11_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = self->priv->error_label;
		_tmp5_ = _ ("Could not show tweet");
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_strdup_printf ("%s: %s", _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		gtk_label_set_label (_tmp4_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->main_stack;
		_tmp11_ = self->priv->error_label;
		gtk_stack_set_visible_child (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		return;
	}
	__finally40:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp12_ = tweet_new ();
	_g_object_unref0 (self->priv->tweet);
	self->priv->tweet = _tmp12_;
	_tmp13_ = self->priv->tweet;
	_tmp14_ = root;
	_tmp15_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp16_ = _tmp15_;
	tweet_load_from_json (_tmp13_, _tmp14_, _data32_->now, _tmp16_);
	_tmp17_ = root;
	_tmp18_ = json_node_get_object (_tmp17_);
	_tmp19_ = _json_object_ref0 (_tmp18_);
	root_object = _tmp19_;
	_tmp20_ = root_object;
	_tmp21_ = json_object_get_string_member (_tmp20_, "source");
	_tmp22_ = g_strdup (_tmp21_);
	with = _tmp22_;
	_tmp23_ = with;
	_tmp24_ = tweet_info_page_extract_source (self, _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat ("<span underline='none'>", _tmp25_, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp27_, "</span>", NULL);
	_g_free0 (with);
	with = _tmp28_;
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_tmp29_ = self->priv->tweet;
	_tmp30_ = with;
	tweet_info_page_set_tweet_data (self, _tmp29_, _tmp30_);
	_tmp31_ = _data32_->existing;
	if (!_tmp31_) {
		Tweet* _tmp32_ = NULL;
		gint64 _tmp33_ = 0LL;
		_tmp32_ = self->priv->tweet;
		_tmp33_ = _tmp32_->reply_id;
		tweet_info_page_load_replied_to_tweet (self, _tmp33_);
	}
	self->priv->values_set = TRUE;
	_g_free0 (with);
	_json_object_unref0 (root_object);
	__vala_JsonNode_free0 (root);
}


static void ___lambda81__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda81_ (self, source_object, res);
	block32_data_unref (self);
}


static Block33Data* block33_data_ref (Block33Data* _data33_) {
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}


static void block33_data_unref (void * _userdata_) {
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data33_->_data32_->self;
		block32_data_unref (_data33_->_data32_);
		_data33_->_data32_ = NULL;
		g_slice_free (Block33Data, _data33_);
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void __lambda84_ (Block33Data* _data33_, JsonArray* arr, guint index, JsonNode* node) {
	Block32Data* _data32_;
	TweetInfoPage* self;
	gint _tmp0_ = 0;
	JsonObject* obj = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	JsonObject* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gint64 reply_id = 0LL;
	JsonObject* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gint64 _tmp11_ = 0LL;
	gint64 _tmp12_ = 0LL;
	Tweet* t = NULL;
	Tweet* _tmp13_ = NULL;
	Tweet* _tmp14_ = NULL;
	JsonNode* _tmp15_ = NULL;
	Account* _tmp16_ = NULL;
	Account* _tmp17_ = NULL;
	Tweet* _tmp18_ = NULL;
	gint64 _tmp19_ = 0LL;
	gint64 _tmp20_ = 0LL;
	_data32_ = _data33_->_data32_;
	self = _data32_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = _data33_->n_replies;
	if (_tmp0_ >= 5) {
		return;
	}
	_tmp1_ = node;
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	obj = _tmp3_;
	_tmp5_ = obj;
	_tmp6_ = json_object_has_member (_tmp5_, "in_reply_to_status_id");
	if (!_tmp6_) {
		_tmp4_ = TRUE;
	} else {
		JsonObject* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = obj;
		_tmp8_ = json_object_get_null_member (_tmp7_, "in_reply_to_status_id");
		_tmp4_ = _tmp8_;
	}
	if (_tmp4_) {
		_json_object_unref0 (obj);
		return;
	}
	_tmp9_ = obj;
	_tmp10_ = json_object_get_int_member (_tmp9_, "in_reply_to_status_id");
	reply_id = _tmp10_;
	_tmp11_ = reply_id;
	_tmp12_ = self->priv->tweet_id;
	if (_tmp11_ != _tmp12_) {
		_json_object_unref0 (obj);
		return;
	}
	_tmp13_ = tweet_new ();
	t = _tmp13_;
	_tmp14_ = t;
	_tmp15_ = node;
	_tmp16_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp17_ = _tmp16_;
	tweet_load_from_json (_tmp14_, _tmp15_, _data32_->now, _tmp17_);
	_tmp18_ = t;
	_tmp19_ = _tmp18_->id;
	_tmp20_ = _data33_->previous_tweet_id;
	if (_tmp19_ != _tmp20_) {
		TweetListBox* _tmp21_ = NULL;
		TweetModel* _tmp22_ = NULL;
		Tweet* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		_tmp21_ = self->priv->top_list_box;
		_tmp22_ = _tmp21_->model;
		_tmp23_ = t;
		tweet_model_add (_tmp22_, _tmp23_);
		_tmp24_ = _data33_->n_replies;
		_data33_->n_replies = _tmp24_ + 1;
	}
	_g_object_unref0 (t);
	_json_object_unref0 (obj);
}


static void ___lambda84__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda84_ (self, array, index_, element_node);
}


static void __lambda83_ (Block32Data* _data32_, GObject* _, GAsyncResult* res) {
	TweetInfoPage* self;
	Block33Data* _data33_;
	JsonNode* root = NULL;
	JsonArray* statuses_node = NULL;
	JsonNode* _tmp6_ = NULL;
	JsonObject* _tmp7_ = NULL;
	JsonArray* _tmp8_ = NULL;
	JsonArray* _tmp9_ = NULL;
	TweetListBox* _tmp10_ = NULL;
	TweetModel* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	JsonArray* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GError * _inner_error_ = NULL;
	self = _data32_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_data33_ = g_slice_new0 (Block33Data);
	_data33_->_ref_count_ = 1;
	_data33_->_data32_ = block32_data_ref (_data32_);
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		JsonNode* _tmp2_ = NULL;
		JsonNode* _tmp3_ = NULL;
		_tmp1_ = res;
		_tmp2_ = tweet_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch41_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("TweetInfoPage.vala:310: %s", _tmp5_);
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		block33_data_unref (_data33_);
		_data33_ = NULL;
		return;
	}
	__finally41:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		block33_data_unref (_data33_);
		_data33_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = root;
	_tmp7_ = json_node_get_object (_tmp6_);
	_tmp8_ = json_object_get_array_member (_tmp7_, "statuses");
	_tmp9_ = _json_array_ref0 (_tmp8_);
	statuses_node = _tmp9_;
	_data33_->previous_tweet_id = (gint64) -1;
	_tmp10_ = self->priv->top_list_box;
	_tmp11_ = _tmp10_->model;
	_tmp12_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_list_model_get_type (), GListModel));
	if (_tmp12_ > ((guint) 0)) {
		TweetListBox* _tmp13_ = NULL;
		TweetModel* _tmp14_ = NULL;
		GObject* _tmp15_ = NULL;
		Tweet* _tmp16_ = NULL;
		gint64 _tmp17_ = 0LL;
		_tmp13_ = self->priv->top_list_box;
		_tmp14_ = _tmp13_->model;
		_tmp15_ = g_list_model_get_item (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_list_model_get_type (), GListModel), (guint) 0);
		_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_TWEET, Tweet);
		_tmp17_ = _tmp16_->id;
		_data33_->previous_tweet_id = _tmp17_;
		_g_object_unref0 (_tmp16_);
	}
	_data33_->n_replies = 0;
	_tmp18_ = statuses_node;
	json_array_foreach_element (_tmp18_, ___lambda84__json_array_foreach, _data33_);
	_tmp19_ = _data33_->n_replies;
	if (_tmp19_ > 0) {
		TweetListBox* _tmp20_ = NULL;
		ReplyIndicator* _tmp21_ = NULL;
		_tmp20_ = self->priv->top_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
		_tmp21_ = self->priv->reply_indicator;
		reply_indicator_set_replies_available (_tmp21_, TRUE);
	} else {
	}
	_json_array_unref0 (statuses_node);
	__vala_JsonNode_free0 (root);
	block33_data_unref (_data33_);
	_data33_ = NULL;
}


static void ___lambda83__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda83_ (self, source_object, res);
	block32_data_unref (self);
}


static void tweet_info_page_query_tweet_info (TweetInfoPage* self, gboolean existing) {
	Block32Data* _data32_;
	gboolean _tmp0_ = FALSE;
	GDateTime* _tmp1_ = NULL;
	RestProxyCall* call = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	OAuthProxy* _tmp4_ = NULL;
	OAuthProxy* _tmp5_ = NULL;
	RestProxyCall* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	RestProxyCall* reply_call = NULL;
	Account* _tmp10_ = NULL;
	Account* _tmp11_ = NULL;
	OAuthProxy* _tmp12_ = NULL;
	OAuthProxy* _tmp13_ = NULL;
	RestProxyCall* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gint64 _tmp18_ = 0LL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp0_ = existing;
	_data32_->existing = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	_data32_->now = _tmp1_;
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = account_get_proxy (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, rest_proxy_get_type (), RestProxy));
	call = _tmp6_;
	rest_proxy_call_set_method (call, "GET");
	rest_proxy_call_set_function (call, "1.1/statuses/show.json");
	_tmp7_ = self->priv->tweet_id;
	_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp7_);
	_tmp9_ = _tmp8_;
	rest_proxy_call_add_param (call, "id", _tmp9_);
	_g_free0 (_tmp9_);
	rest_proxy_call_add_param (call, "include_my_retweet", "true");
	tweet_utils_load_threaded (call, ___lambda81__gasync_ready_callback, block32_data_ref (_data32_));
	_tmp10_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp11_ = _tmp10_;
	_tmp12_ = account_get_proxy (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, rest_proxy_get_type (), RestProxy));
	reply_call = _tmp14_;
	rest_proxy_call_set_method (reply_call, "GET");
	rest_proxy_call_set_function (reply_call, "1.1/search/tweets.json");
	_tmp15_ = self->priv->screen_name;
	_tmp16_ = g_strconcat ("to:", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	rest_proxy_call_add_param (reply_call, "q", _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = self->priv->tweet_id;
	_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp18_);
	_tmp20_ = _tmp19_;
	rest_proxy_call_add_param (reply_call, "since_id", _tmp20_);
	_g_free0 (_tmp20_);
	rest_proxy_call_add_param (reply_call, "count", "200");
	tweet_utils_load_threaded (reply_call, ___lambda83__gasync_ready_callback, block32_data_ref (_data32_));
	_g_object_unref0 (reply_call);
	_g_object_unref0 (call);
	block32_data_unref (_data32_);
	_data32_ = NULL;
}


/**
   * Loads the tweet this tweet is a reply to.
   * This will recursively call itself until the end of the chain is reached.
   *
   * @param reply_id The id of the tweet the previous tweet was a reply to.
   */
static Block34Data* block34_data_ref (Block34Data* _data34_) {
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}


static void block34_data_unref (void * _userdata_) {
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data34_->self;
		_g_object_unref0 (_data34_->call);
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda82_ (Block34Data* _data34_, GObject* obj, GAsyncResult* res) {
	TweetInfoPage* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp18_ = NULL;
	Tweet* tweet = NULL;
	Tweet* _tmp24_ = NULL;
	Tweet* _tmp25_ = NULL;
	JsonParser* _tmp26_ = NULL;
	JsonNode* _tmp27_ = NULL;
	GDateTime* _tmp28_ = NULL;
	GDateTime* _tmp29_ = NULL;
	Account* _tmp30_ = NULL;
	Account* _tmp31_ = NULL;
	TweetListBox* _tmp32_ = NULL;
	TweetModel* _tmp33_ = NULL;
	Tweet* _tmp34_ = NULL;
	Tweet* _tmp35_ = NULL;
	gint64 _tmp36_ = 0LL;
	GError * _inner_error_ = NULL;
	self = _data34_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data34_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch42_g_error;
		}
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		TweetListBox* _tmp13_ = NULL;
		TweetListBox* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		GList* _tmp16_ = NULL;
		guint _tmp17_ = 0U;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("TweetInfoPage.vala:374: %s", _tmp3_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = string_strip (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strcmp0 (_tmp7_, "Forbidden") != 0;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			RestProxyCall* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			_tmp9_ = _data34_->call;
			_tmp10_ = rest_proxy_call_get_payload (_tmp9_);
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			utils_show_error_object (_tmp10_, _tmp12_, 377, "TweetInfoPage.vala");
		}
		_tmp13_ = self->priv->bottom_list_box;
		_tmp14_ = self->priv->bottom_list_box;
		_tmp15_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_container_get_type (), GtkContainer));
		_tmp16_ = _tmp15_;
		_tmp17_ = g_list_length (_tmp16_);
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), _tmp17_ > ((guint) 0));
		_g_list_free0 (_tmp16_);
		_g_error_free0 (e);
		return;
	}
	__finally42:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp18_ = json_parser_new ();
	parser = _tmp18_;
	{
		JsonParser* _tmp19_ = NULL;
		RestProxyCall* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_tmp19_ = parser;
		_tmp20_ = _data34_->call;
		_tmp21_ = rest_proxy_call_get_payload (_tmp20_);
		json_parser_load_from_data (_tmp19_, _tmp21_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch43_g_error;
		}
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_critical ("TweetInfoPage.vala:387: %s", _tmp23_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return;
	}
	__finally43:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp24_ = tweet_new ();
	tweet = _tmp24_;
	_tmp25_ = tweet;
	_tmp26_ = parser;
	_tmp27_ = json_parser_get_root (_tmp26_);
	_tmp28_ = g_date_time_new_now_local ();
	_tmp29_ = _tmp28_;
	_tmp30_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp31_ = _tmp30_;
	tweet_load_from_json (_tmp25_, _tmp27_, _tmp29_, _tmp31_);
	_g_date_time_unref0 (_tmp29_);
	_tmp32_ = self->priv->bottom_list_box;
	_tmp33_ = _tmp32_->model;
	_tmp34_ = tweet;
	tweet_model_add (_tmp33_, _tmp34_);
	_tmp35_ = tweet;
	_tmp36_ = _tmp35_->reply_id;
	tweet_info_page_load_replied_to_tweet (self, _tmp36_);
	_g_object_unref0 (tweet);
	_g_object_unref0 (parser);
}


static void ___lambda82__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda82_ (self, source_object, res);
	block34_data_unref (self);
}


static void tweet_info_page_load_replied_to_tweet (TweetInfoPage* self, gint64 reply_id) {
	Block34Data* _data34_;
	gint64 _tmp0_ = 0LL;
	TweetListBox* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	OAuthProxy* _tmp4_ = NULL;
	OAuthProxy* _tmp5_ = NULL;
	RestProxyCall* _tmp6_ = NULL;
	RestProxyCall* _tmp7_ = NULL;
	RestProxyCall* _tmp8_ = NULL;
	RestProxyCall* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	RestProxyCall* _tmp13_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_data34_ = g_slice_new0 (Block34Data);
	_data34_->_ref_count_ = 1;
	_data34_->self = g_object_ref (self);
	_tmp0_ = reply_id;
	if (_tmp0_ == ((gint64) 0)) {
		block34_data_unref (_data34_);
		_data34_ = NULL;
		return;
	}
	_tmp1_ = self->priv->bottom_list_box;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = account_get_proxy (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, rest_proxy_get_type (), RestProxy));
	_data34_->call = _tmp6_;
	_tmp7_ = _data34_->call;
	rest_proxy_call_set_function (_tmp7_, "1.1/statuses/show.json");
	_tmp8_ = _data34_->call;
	rest_proxy_call_set_method (_tmp8_, "GET");
	_tmp9_ = _data34_->call;
	_tmp10_ = reply_id;
	_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp10_);
	_tmp12_ = _tmp11_;
	rest_proxy_call_add_param (_tmp9_, "id", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = _data34_->call;
	rest_proxy_call_invoke_async (_tmp13_, NULL, ___lambda82__gasync_ready_callback, block34_data_ref (_data34_));
	block34_data_unref (_data34_);
	_data34_ = NULL;
}


/**
   *
   */
static Block35Data* block35_data_ref (Block35Data* _data35_) {
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}


static void block35_data_unref (void * _userdata_) {
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data35_->self;
		_g_object_unref0 (_data35_->tweet);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}


static void __lambda80_ (Block35Data* _data35_) {
	TweetInfoPage* self;
	AvatarWidget* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	self = _data35_->self;
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = _data35_->tweet;
	_tmp2_ = tweet_get_avatar (_tmp1_);
	_tmp3_ = _tmp2_;
	avatar_widget_set_surface (_tmp0_, _tmp3_);
}


static void ___lambda80__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda80_ (self);
}


static void tweet_info_page_set_tweet_data (TweetInfoPage* self, Tweet* tweet, const gchar* with) {
	Block35Data* _data35_;
	Tweet* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	UserCounter* _tmp4_ = NULL;
	UserCounter* _tmp5_ = NULL;
	Tweet* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	Tweet* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	Tweet* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gint64 _tmp15_ = 0LL;
	Tweet* _tmp16_ = NULL;
	MiniTweet* _tmp17_ = NULL;
	GDateTime* created_at = NULL;
	GDateTime* _tmp24_ = NULL;
	gchar* time_format = NULL;
	GDateTime* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GtkLabel* _tmp33_ = NULL;
	Tweet* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	TextButton* _tmp37_ = NULL;
	Tweet* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	GtkLabel* _tmp41_ = NULL;
	Tweet* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	AvatarWidget* _tmp47_ = NULL;
	Tweet* _tmp48_ = NULL;
	cairo_surface_t* _tmp49_ = NULL;
	cairo_surface_t* _tmp50_ = NULL;
	Tweet* _tmp51_ = NULL;
	GtkLabel* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	GtkToggleButton* _tmp54_ = NULL;
	Tweet* _tmp55_ = NULL;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	GtkToggleButton* _tmp58_ = NULL;
	Tweet* _tmp59_ = NULL;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	AvatarWidget* _tmp62_ = NULL;
	Tweet* _tmp63_ = NULL;
	gboolean _tmp64_ = FALSE;
	Tweet* _tmp65_ = NULL;
	gint64 _tmp66_ = 0LL;
	Tweet* _tmp67_ = NULL;
	const gchar* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	Tweet* _tmp70_ = NULL;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp79_ = FALSE;
	Tweet* _tmp80_ = NULL;
	gint64 _tmp81_ = 0LL;
	gint64 _tmp82_ = 0LL;
	Account* _tmp83_ = NULL;
	Account* _tmp84_ = NULL;
	gint64 _tmp85_ = 0LL;
	gint64 _tmp86_ = 0LL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	g_return_if_fail (IS_TWEET (tweet));
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_data35_->self = g_object_ref (self);
	_tmp0_ = tweet;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data35_->tweet);
	_data35_->tweet = _tmp1_;
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = account_get_user_counter (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _data35_->tweet;
	_tmp7_ = tweet_get_user_id (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _data35_->tweet;
	_tmp10_ = tweet_get_screen_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _data35_->tweet;
	_tmp13_ = tweet_get_user_name (_tmp12_);
	_tmp14_ = _tmp13_;
	user_counter_user_seen (_tmp5_, _tmp8_, _tmp11_, _tmp14_);
	_tmp16_ = _data35_->tweet;
	_tmp17_ = _tmp16_->retweeted_tweet;
	if (_tmp17_ != NULL) {
		Tweet* _tmp18_ = NULL;
		MiniTweet* _tmp19_ = NULL;
		gint64 _tmp20_ = 0LL;
		_tmp18_ = _data35_->tweet;
		_tmp19_ = _tmp18_->retweeted_tweet;
		_tmp20_ = _tmp19_->created_at;
		_tmp15_ = _tmp20_;
	} else {
		Tweet* _tmp21_ = NULL;
		MiniTweet* _tmp22_ = NULL;
		gint64 _tmp23_ = 0LL;
		_tmp21_ = _data35_->tweet;
		_tmp22_ = _tmp21_->source_tweet;
		_tmp23_ = _tmp22_->created_at;
		_tmp15_ = _tmp23_;
	}
	_tmp24_ = g_date_time_new_from_unix_local (_tmp15_);
	created_at = _tmp24_;
	_tmp25_ = created_at;
	_tmp26_ = g_date_time_format (_tmp25_, "%x, %X");
	time_format = _tmp26_;
	_tmp27_ = with;
	if (_tmp27_ != NULL) {
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		_tmp28_ = time_format;
		_tmp29_ = with;
		_tmp30_ = g_strconcat (" via ", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp28_, _tmp31_, NULL);
		_g_free0 (time_format);
		time_format = _tmp32_;
		_g_free0 (_tmp31_);
	}
	_tmp33_ = self->priv->text_label;
	_tmp34_ = _data35_->tweet;
	_tmp35_ = tweet_get_formatted_text (_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_label_set_label (_tmp33_, _tmp36_);
	_g_free0 (_tmp36_);
	_tmp37_ = self->priv->name_button;
	_tmp38_ = _data35_->tweet;
	_tmp39_ = tweet_get_user_name (_tmp38_);
	_tmp40_ = _tmp39_;
	text_button_set_markup (_tmp37_, _tmp40_);
	_tmp41_ = self->priv->screen_name_label;
	_tmp42_ = _data35_->tweet;
	_tmp43_ = tweet_get_screen_name (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_strconcat ("@", _tmp44_, NULL);
	_tmp46_ = _tmp45_;
	gtk_label_set_label (_tmp41_, _tmp46_);
	_g_free0 (_tmp46_);
	_tmp47_ = self->priv->avatar_image;
	_tmp48_ = _data35_->tweet;
	_tmp49_ = tweet_get_avatar (_tmp48_);
	_tmp50_ = _tmp49_;
	avatar_widget_set_surface (_tmp47_, _tmp50_);
	_tmp51_ = _data35_->tweet;
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, G_TYPE_OBJECT, GObject), "notify::avatar", (GCallback) ___lambda80__g_object_notify, block35_data_ref (_data35_), (GClosureNotify) block35_data_unref, 0);
	tweet_info_page_update_rt_fav_labels (self);
	_tmp52_ = self->priv->time_label;
	_tmp53_ = time_format;
	gtk_label_set_label (_tmp52_, _tmp53_);
	_tmp54_ = self->priv->retweet_button;
	_tmp55_ = _data35_->tweet;
	_tmp56_ = tweet_get_retweeted (_tmp55_);
	_tmp57_ = _tmp56_;
	gtk_toggle_button_set_active (_tmp54_, _tmp57_);
	_tmp58_ = self->priv->favorite_button;
	_tmp59_ = _data35_->tweet;
	_tmp60_ = tweet_get_favorited (_tmp59_);
	_tmp61_ = _tmp60_;
	gtk_toggle_button_set_active (_tmp58_, _tmp61_);
	_tmp62_ = self->priv->avatar_image;
	_tmp63_ = _data35_->tweet;
	_tmp64_ = _tmp63_->verified;
	avatar_widget_set_verified (_tmp62_, _tmp64_);
	_tmp65_ = _data35_->tweet;
	_tmp66_ = _tmp65_->id;
	_tmp67_ = _data35_->tweet;
	_tmp68_ = tweet_get_screen_name (_tmp67_);
	_tmp69_ = _tmp68_;
	tweet_info_page_set_source_link (self, _tmp66_, _tmp69_);
	_tmp70_ = _data35_->tweet;
	_tmp71_ = tweet_get_has_inline_media (_tmp70_);
	_tmp72_ = _tmp71_;
	if (_tmp72_) {
		MultiMediaWidget* _tmp73_ = NULL;
		Tweet* _tmp74_ = NULL;
		Media** _tmp75_ = NULL;
		gint _tmp75__length1 = 0;
		Media** _tmp76_ = NULL;
		gint _tmp76__length1 = 0;
		MultiMediaWidget* _tmp77_ = NULL;
		_tmp73_ = self->priv->mm_widget;
		_tmp74_ = _data35_->tweet;
		_tmp75_ = tweet_get_medias (_tmp74_, &_tmp75__length1);
		_tmp76_ = _tmp75_;
		_tmp76__length1 = _tmp75__length1;
		multi_media_widget_set_all_media (_tmp73_, _tmp76_, _tmp76__length1);
		_tmp77_ = self->priv->mm_widget;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, gtk_widget_get_type (), GtkWidget));
	} else {
		MultiMediaWidget* _tmp78_ = NULL;
		_tmp78_ = self->priv->mm_widget;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp80_ = _data35_->tweet;
	_tmp81_ = tweet_get_user_id (_tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp84_ = _tmp83_;
	_tmp85_ = account_get_id (_tmp84_);
	_tmp86_ = _tmp85_;
	if (_tmp82_ == _tmp86_) {
		_tmp79_ = TRUE;
	} else {
		Tweet* _tmp87_ = NULL;
		gboolean _tmp88_ = FALSE;
		_tmp87_ = _data35_->tweet;
		_tmp88_ = _tmp87_->protected;
		_tmp79_ = _tmp88_;
	}
	if (_tmp79_) {
		GtkToggleButton* _tmp89_ = NULL;
		GSimpleActionGroup* _tmp90_ = NULL;
		GAction* _tmp91_ = NULL;
		_tmp89_ = self->priv->retweet_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, gtk_widget_get_type (), GtkWidget));
		_tmp90_ = self->priv->actions;
		_tmp91_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, g_action_map_get_type (), GActionMap), "quote");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, g_simple_action_get_type (), GSimpleAction), FALSE);
	} else {
		GtkToggleButton* _tmp92_ = NULL;
		GSimpleActionGroup* _tmp93_ = NULL;
		GAction* _tmp94_ = NULL;
		_tmp92_ = self->priv->retweet_button;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, gtk_widget_get_type (), GtkWidget));
		_tmp93_ = self->priv->actions;
		_tmp94_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, g_action_map_get_type (), GActionMap), "quote");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, g_simple_action_get_type (), GSimpleAction), TRUE);
	}
	_g_free0 (time_format);
	_g_date_time_unref0 (created_at);
	block35_data_unref (_data35_);
	_data35_ = NULL;
}


static void tweet_info_page_update_rt_fav_labels (TweetInfoPage* self) {
	GtkLabel* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	Tweet* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->rt_label;
	_tmp1_ = self->priv->tweet;
	_tmp2_ = _tmp1_->retweet_count;
	_tmp3_ = _ ("Retweets");
	_tmp4_ = g_strdup_printf ("<big><b>%'d</b></big> %s", _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->fav_label;
	_tmp7_ = self->priv->tweet;
	_tmp8_ = _tmp7_->favorite_count;
	_tmp9_ = _ ("Favorites");
	_tmp10_ = g_strdup_printf ("<big><b>%'d</b></big> %s", _tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp6_, _tmp11_);
	_g_free0 (_tmp11_);
}


static void tweet_info_page_set_source_link (TweetInfoPage* self, gint64 id, const gchar* screen_name) {
	gchar* link = NULL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	g_return_if_fail (screen_name != NULL);
	_tmp0_ = screen_name;
	_tmp1_ = id;
	_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("https://twitter.com/%s/status/%s", _tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	link = _tmp5_;
	_tmp6_ = self->priv->source_label;
	_tmp7_ = _ ("Open in Browser");
	_tmp8_ = _ ("Source");
	_tmp9_ = g_strdup_printf ("<span underline='none'><a href='%s' title='%s'>%s</a></span>", link, _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	gtk_label_set_label (_tmp6_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (link);
}


static void tweet_info_page_quote_activated (TweetInfoPage* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	Tweet* _tmp4_ = NULL;
	ComposeTweetWindow* _tmp5_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->tweet;
	_tmp5_ = compose_tweet_window_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow), _tmp3_, _tmp4_, COMPOSE_TWEET_WINDOW_MODE_QUOTE);
	g_object_ref_sink (_tmp5_);
	ctw = _tmp5_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static gchar* tweet_info_page_real_get_title (IPage* base) {
	TweetInfoPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = _ ("Tweet Details");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * Twitter's source parameter of tweets includes a 'rel' parameter
   * that doesn't work as pango markup, so we just remove it here.
   *
   * Example string:
   *   <a href=\"http://www.tweetdeck.com\" rel=\"nofollow\">TweetDeck</a>
   *
   * @param source_str The source string from twitter
   *
   * @return The #source_string without the rel parameter
   */
static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* tweet_info_page_extract_source (TweetInfoPage* self, const gchar* source_str) {
	gchar* result = NULL;
	gint from = 0;
	gint to = 0;
	gint tmp = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	g_return_val_if_fail (IS_TWEET_INFO_PAGE (self), NULL);
	g_return_val_if_fail (source_str != NULL, NULL);
	tmp = 0;
	_tmp0_ = source_str;
	_tmp1_ = string_index_of_char (_tmp0_, (gunichar) '"', 0);
	tmp = _tmp1_;
	_tmp2_ = source_str;
	_tmp3_ = tmp;
	_tmp4_ = string_index_of_char (_tmp2_, (gunichar) '"', _tmp3_ + 1);
	tmp = _tmp4_;
	_tmp5_ = source_str;
	_tmp6_ = tmp;
	_tmp7_ = string_index_of_char (_tmp5_, (gunichar) '"', _tmp6_ + 1);
	from = _tmp7_;
	_tmp8_ = source_str;
	_tmp9_ = from;
	_tmp10_ = string_index_of_char (_tmp8_, (gunichar) '"', _tmp9_ + 1);
	to = _tmp10_;
	_tmp12_ = to;
	if (_tmp12_ == -1) {
		_tmp11_ = TRUE;
	} else {
		gint _tmp13_ = 0;
		_tmp13_ = from;
		_tmp11_ = _tmp13_ == -1;
	}
	if (_tmp11_) {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp14_ = source_str;
		_tmp15_ = g_strdup (_tmp14_);
		result = _tmp15_;
		return result;
	}
	_tmp16_ = source_str;
	_tmp17_ = from;
	_tmp18_ = string_substring (_tmp16_, (glong) 0, (glong) (_tmp17_ - 5));
	_tmp19_ = _tmp18_;
	_tmp20_ = source_str;
	_tmp21_ = to;
	_tmp22_ = string_substring (_tmp20_, (glong) (_tmp21_ + 1), (glong) -1);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp19_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp19_);
	result = _tmp25_;
	return result;
}


static void tweet_info_page_real_create_tool_button (IPage* base, GtkRadioButton* group) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static GtkRadioButton* tweet_info_page_real_get_tool_button (IPage* base) {
	TweetInfoPage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	result = NULL;
	return result;
}


static void tweet_info_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root) {
	TweetInfoPage * self;
	StreamMessageType _tmp0_ = 0;
	JsonObject* root_obj = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ != STREAM_MESSAGE_TYPE_TWEET) {
		return;
	}
	_tmp1_ = root;
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	root_obj = _tmp3_;
	_tmp4_ = root_obj;
	_tmp5_ = utils_usable_json_value (_tmp4_, "in_reply_to_status_id");
	if (_tmp5_) {
		gint64 reply_id = 0LL;
		JsonObject* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		gint64 _tmp8_ = 0LL;
		gint64 _tmp9_ = 0LL;
		_tmp6_ = root_obj;
		_tmp7_ = json_object_get_int_member (_tmp6_, "in_reply_to_status_id");
		reply_id = _tmp7_;
		_tmp8_ = reply_id;
		_tmp9_ = self->priv->tweet_id;
		if (_tmp8_ == _tmp9_) {
			Tweet* t = NULL;
			Tweet* _tmp10_ = NULL;
			Tweet* _tmp11_ = NULL;
			JsonNode* _tmp12_ = NULL;
			GDateTime* _tmp13_ = NULL;
			GDateTime* _tmp14_ = NULL;
			Account* _tmp15_ = NULL;
			Account* _tmp16_ = NULL;
			TweetListBox* _tmp17_ = NULL;
			TweetModel* _tmp18_ = NULL;
			Tweet* _tmp19_ = NULL;
			TweetListBox* _tmp20_ = NULL;
			ReplyIndicator* _tmp21_ = NULL;
			_tmp10_ = tweet_new ();
			t = _tmp10_;
			_tmp11_ = t;
			_tmp12_ = root;
			_tmp13_ = g_date_time_new_now_local ();
			_tmp14_ = _tmp13_;
			_tmp15_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp16_ = _tmp15_;
			tweet_load_from_json (_tmp11_, _tmp12_, _tmp14_, _tmp16_);
			_g_date_time_unref0 (_tmp14_);
			_tmp17_ = self->priv->top_list_box;
			_tmp18_ = _tmp17_->model;
			_tmp19_ = t;
			tweet_model_add (_tmp18_, _tmp19_);
			_tmp20_ = self->priv->top_list_box;
			gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
			_tmp21_ = self->priv->reply_indicator;
			reply_indicator_set_replies_available (_tmp21_, TRUE);
			_g_object_unref0 (t);
		}
	}
	_json_object_unref0 (root_obj);
}


gint tweet_info_page_get_unread_count (TweetInfoPage* self) {
	gint result;
	g_return_val_if_fail (IS_TWEET_INFO_PAGE (self), 0);
	result = 0;
	return result;
}


static gint tweet_info_page_real_get_id (IPage* base) {
	gint result;
	TweetInfoPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void tweet_info_page_real_set_id (IPage* base, gint value) {
	TweetInfoPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static MainWindow* tweet_info_page_real_get_main_window (IPage* base) {
	MainWindow* result;
	TweetInfoPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


static void tweet_info_page_real_set_main_window (IPage* base, MainWindow* value) {
	TweetInfoPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = value;
	self->priv->_main_window = _tmp0_;
	g_object_notify ((GObject *) self, "main-window");
}


static Account* tweet_info_page_real_get_account (IPage* base) {
	Account* result;
	TweetInfoPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void tweet_info_page_real_set_account (IPage* base, Account* value) {
	TweetInfoPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = value;
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


void tweet_info_page_set_delta_updater (TweetInfoPage* self, DeltaUpdater* value) {
	TweetListBox* _tmp0_ = NULL;
	DeltaUpdater* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	DeltaUpdater* _tmp3_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->top_list_box;
	_tmp1_ = value;
	_tmp0_->delta_updater = _tmp1_;
	_tmp2_ = self->priv->bottom_list_box;
	_tmp3_ = value;
	_tmp2_->delta_updater = _tmp3_;
	g_object_notify ((GObject *) self, "delta-updater");
}


static void tweet_info_page_class_init (TweetInfoPageClass * klass) {
	gint TweetInfoPage_private_offset;
	tweet_info_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetInfoPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_info_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tweet_info_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = tweet_info_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_DELTA_UPDATER, g_param_spec_object ("delta-updater", "delta-updater", "delta-updater", TYPE_DELTA_UPDATER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	TweetInfoPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/tweet-info-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mm_widget", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, mm_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, text_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_button", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, name_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, rt_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fav_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, fav_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bottom_list_box", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, bottom_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "top_list_box", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, top_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "favorite_button", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, favorite_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "retweet_button", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, retweet_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, time_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "source_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, source_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "max_size_container", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, max_size_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "reply_indicator", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, reply_indicator));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_stack", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, main_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, error_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "favorite_button_toggled_cb", G_CALLBACK(_tweet_info_page_favorite_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "retweet_button_toggled_cb", G_CALLBACK(_tweet_info_page_retweet_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "reply_button_clicked_cb", G_CALLBACK(_tweet_info_page_reply_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "link_activated_cb", G_CALLBACK(_tweet_info_page_link_activated_cb_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "name_button_clicked_cb", G_CALLBACK(_tweet_info_page_name_button_clicked_cb_gtk_button_clicked));
}


static void tweet_info_page_ipage_interface_init (IPageIface * iface) {
	tweet_info_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) tweet_info_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) tweet_info_page_real_on_leave;
	iface->get_title = (gchar* (*)(IPage*)) tweet_info_page_real_get_title;
	iface->create_tool_button = (void (*)(IPage*, GtkRadioButton*)) tweet_info_page_real_create_tool_button;
	iface->get_tool_button = (GtkRadioButton* (*)(IPage*)) tweet_info_page_real_get_tool_button;
	iface->get_id = tweet_info_page_real_get_id;
	iface->set_id = tweet_info_page_real_set_id;
	iface->get_main_window = tweet_info_page_real_get_main_window;
	iface->set_main_window = tweet_info_page_real_set_main_window;
	iface->get_account = tweet_info_page_real_get_account;
	iface->set_account = tweet_info_page_real_set_account;
}


static void tweet_info_page_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	tweet_info_page_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) tweet_info_page_real_stream_message_received;
}


static void tweet_info_page_instance_init (TweetInfoPage * self) {
	self->priv = TWEET_INFO_PAGE_GET_PRIVATE (self);
	self->priv->values_set = FALSE;
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_REPLY_INDICATOR);
	g_type_ensure (TYPE_MAX_SIZE_CONTAINER);
	g_type_ensure (TYPE_MULTI_MEDIA_WIDGET);
	g_type_ensure (TYPE_TEXT_BUTTON);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void tweet_info_page_finalize (GObject* obj) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_g_free0 (self->priv->screen_name);
	_g_object_unref0 (self->priv->tweet);
	_g_object_unref0 (self->priv->actions);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->mm_widget);
	_g_object_unref0 (self->priv->text_label);
	_g_object_unref0 (self->priv->name_button);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->rt_label);
	_g_object_unref0 (self->priv->fav_label);
	_g_object_unref0 (self->priv->bottom_list_box);
	_g_object_unref0 (self->priv->top_list_box);
	_g_object_unref0 (self->priv->favorite_button);
	_g_object_unref0 (self->priv->retweet_button);
	_g_object_unref0 (self->priv->time_label);
	_g_object_unref0 (self->priv->source_label);
	_g_object_unref0 (self->priv->max_size_container);
	_g_object_unref0 (self->priv->reply_indicator);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->error_label);
	G_OBJECT_CLASS (tweet_info_page_parent_class)->finalize (obj);
}


GType tweet_info_page_get_type (void) {
	static volatile gsize tweet_info_page_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_info_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetInfoPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_info_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetInfoPage), 0, (GInstanceInitFunc) tweet_info_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) tweet_info_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) tweet_info_page_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tweet_info_page_type_id;
		tweet_info_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "TweetInfoPage", &g_define_type_info, 0);
		g_type_add_interface_static (tweet_info_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (tweet_info_page_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&tweet_info_page_type_id__volatile, tweet_info_page_type_id);
	}
	return tweet_info_page_type_id__volatile;
}


static void _vala_tweet_info_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	switch (property_id) {
		case TWEET_INFO_PAGE_UNREAD_COUNT:
		g_value_set_int (value, tweet_info_page_get_unread_count (self));
		break;
		case TWEET_INFO_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case TWEET_INFO_PAGE_MAIN_WINDOW:
		g_value_set_object (value, ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case TWEET_INFO_PAGE_ACCOUNT:
		g_value_set_object (value, ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tweet_info_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	switch (property_id) {
		case TWEET_INFO_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case TWEET_INFO_PAGE_MAIN_WINDOW:
		ipage_set_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case TWEET_INFO_PAGE_ACCOUNT:
		ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case TWEET_INFO_PAGE_DELTA_UPDATER:
		tweet_info_page_set_delta_updater (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



