/* AvatarWidget.c generated by valac 0.30.0, the Vala compiler
 * generated from AvatarWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>


#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;
typedef struct _AvatarWidgetPrivate AvatarWidgetPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _AvatarWidget {
	GtkWidget parent_instance;
	AvatarWidgetPrivate * priv;
};

struct _AvatarWidgetClass {
	GtkWidgetClass parent_class;
};

struct _AvatarWidgetPrivate {
	gboolean _round;
	gboolean _verified;
	cairo_surface_t* _surface;
};


static gpointer avatar_widget_parent_class = NULL;
static cairo_surface_t** avatar_widget_verified_icons;
static gint avatar_widget_verified_icons_length1;
static cairo_surface_t** avatar_widget_verified_icons = NULL;
static gint avatar_widget_verified_icons_length1 = 0;
static gint _avatar_widget_verified_icons_size_ = 0;

GType avatar_widget_get_type (void) G_GNUC_CONST;
#define AVATAR_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVATAR_WIDGET, AvatarWidgetPrivate))
enum  {
	AVATAR_WIDGET_DUMMY_PROPERTY,
	AVATAR_WIDGET_MAKE_ROUND,
	AVATAR_WIDGET_VERIFIED,
	AVATAR_WIDGET_SURFACE
};
void twitter_unref_avatar (cairo_surface_t* surface);
#define AVATAR_WIDGET_SMALL 0
#define AVATAR_WIDGET_LARGE 1
static gboolean avatar_widget_real_draw (GtkWidget* base, cairo_t* ctx);
gboolean avatar_widget_get_verified (AvatarWidget* self);
static void avatar_widget_real_get_preferred_height (GtkWidget* base, gint* minimal, gint* natural);
AvatarWidget* avatar_widget_new (void);
AvatarWidget* avatar_widget_construct (GType object_type);
gboolean avatar_widget_get_make_round (AvatarWidget* self);
void avatar_widget_set_make_round (AvatarWidget* self, gboolean value);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
cairo_surface_t* avatar_widget_get_surface (AvatarWidget* self);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
void twitter_ref_avatar (cairo_surface_t* surface);
static GObject * avatar_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GSettings* settings_get (void);
static void avatar_widget_finalize (GObject* obj);
static void _vala_avatar_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_avatar_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gint AVATAR_WIDGET_VERIFIED_SIZES[2] = {12, 18};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static gboolean avatar_widget_real_draw (GtkWidget* base, cairo_t* ctx) {
	AvatarWidget * self;
	gboolean result = FALSE;
	gint width = 0;
	gint _tmp0_ = 0;
	gint height = 0;
	gint _tmp1_ = 0;
	cairo_surface_t* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	cairo_surface_t* surface = NULL;
	cairo_t* _tmp7_ = NULL;
	cairo_surface_t* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	cairo_surface_t* _tmp11_ = NULL;
	cairo_t* ct = NULL;
	cairo_surface_t* _tmp12_ = NULL;
	cairo_t* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	cairo_t* _tmp17_ = NULL;
	cairo_surface_t* _tmp18_ = NULL;
	cairo_t* _tmp19_ = NULL;
	GtkStyleContext* sc = NULL;
	GtkStyleContext* _tmp20_ = NULL;
	GtkStyleContext* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	cairo_t* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	cairo_t* _tmp36_ = NULL;
	cairo_surface_t* _tmp37_ = NULL;
	cairo_t* _tmp38_ = NULL;
	gboolean _tmp39_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_WIDGET, AvatarWidget);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	width = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	height = _tmp1_;
	_tmp2_ = self->priv->_surface;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = width;
	_tmp4_ = height;
	if (_tmp3_ != _tmp4_) {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp5_ = width;
		_tmp6_ = height;
		g_warning ("AvatarWidget.vala:103: Avatar with mapped with width %d and height %d", _tmp5_, _tmp6_);
	}
	_tmp7_ = ctx;
	_tmp8_ = cairo_get_target (_tmp7_);
	_tmp9_ = width;
	_tmp10_ = height;
	_tmp11_ = cairo_surface_create_similar (_tmp8_, CAIRO_CONTENT_COLOR_ALPHA, _tmp9_, _tmp10_);
	surface = _tmp11_;
	_tmp12_ = surface;
	_tmp13_ = cairo_create (_tmp12_);
	ct = _tmp13_;
	_tmp14_ = ct;
	_tmp15_ = width;
	_tmp16_ = height;
	cairo_rectangle (_tmp14_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp15_, (gdouble) _tmp16_);
	_tmp17_ = ct;
	_tmp18_ = self->priv->_surface;
	cairo_set_source_surface (_tmp17_, _tmp18_, (gdouble) 0, (gdouble) 0);
	_tmp19_ = ct;
	cairo_fill (_tmp19_);
	_tmp20_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp21_ = _g_object_ref0 (_tmp20_);
	sc = _tmp21_;
	_tmp22_ = self->priv->_round;
	if (_tmp22_) {
		cairo_t* _tmp23_ = NULL;
		cairo_t* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		cairo_t* _tmp28_ = NULL;
		GtkStyleContext* _tmp29_ = NULL;
		cairo_t* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		_tmp23_ = ct;
		cairo_set_operator (_tmp23_, CAIRO_OPERATOR_DEST_IN);
		_tmp24_ = ct;
		_tmp25_ = width;
		_tmp26_ = height;
		_tmp27_ = width;
		cairo_arc (_tmp24_, _tmp25_ / 2.0, _tmp26_ / 2.0, (_tmp27_ / 2.0) - 0.5, (gdouble) 0, 2 * G_PI);
		_tmp28_ = ct;
		cairo_fill (_tmp28_);
		_tmp29_ = sc;
		_tmp30_ = ctx;
		_tmp31_ = width;
		_tmp32_ = height;
		gtk_render_frame (_tmp29_, _tmp30_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp31_, (gdouble) _tmp32_);
	}
	_tmp33_ = ctx;
	_tmp34_ = width;
	_tmp35_ = height;
	cairo_rectangle (_tmp33_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp34_, (gdouble) _tmp35_);
	_tmp36_ = ctx;
	_tmp37_ = surface;
	cairo_set_source_surface (_tmp36_, _tmp37_, (gdouble) 0, (gdouble) 0);
	_tmp38_ = ctx;
	cairo_fill (_tmp38_);
	_tmp39_ = self->priv->_verified;
	if (_tmp39_) {
		gint index = 0;
		gint _tmp40_ = 0;
		gint scale_factor = 0;
		gint _tmp41_ = 0;
		cairo_surface_t* verified_img = NULL;
		cairo_surface_t** _tmp42_ = NULL;
		gint _tmp42__length1 = 0;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		cairo_surface_t* _tmp45_ = NULL;
		cairo_surface_t* _tmp46_ = NULL;
		cairo_t* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		cairo_t* _tmp50_ = NULL;
		cairo_surface_t* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		cairo_t* _tmp55_ = NULL;
		index = AVATAR_WIDGET_SMALL;
		_tmp40_ = width;
		if (_tmp40_ > 48) {
			index = AVATAR_WIDGET_LARGE;
		}
		_tmp41_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		scale_factor = _tmp41_ - 1;
		_tmp42_ = avatar_widget_verified_icons;
		_tmp42__length1 = avatar_widget_verified_icons_length1;
		_tmp43_ = scale_factor;
		_tmp44_ = index;
		_tmp45_ = _tmp42_[(_tmp43_ * 2) + _tmp44_];
		_tmp46_ = _cairo_surface_reference0 (_tmp45_);
		verified_img = _tmp46_;
		_tmp47_ = ctx;
		_tmp48_ = width;
		_tmp49_ = height;
		cairo_rectangle (_tmp47_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp48_, (gdouble) _tmp49_);
		_tmp50_ = ctx;
		_tmp51_ = verified_img;
		_tmp52_ = width;
		_tmp53_ = index;
		_tmp54_ = AVATAR_WIDGET_VERIFIED_SIZES[_tmp53_];
		cairo_set_source_surface (_tmp50_, _tmp51_, (gdouble) (_tmp52_ - _tmp54_), (gdouble) 0);
		_tmp55_ = ctx;
		cairo_fill (_tmp55_);
		_cairo_surface_destroy0 (verified_img);
	}
	result = G_SOURCE_CONTINUE;
	_g_object_unref0 (sc);
	_cairo_destroy0 (ct);
	_cairo_surface_destroy0 (surface);
	return result;
}


static void avatar_widget_real_get_preferred_height (GtkWidget* base, gint* minimal, gint* natural) {
	AvatarWidget * self;
	gint _vala_minimal = 0;
	gint _vala_natural = 0;
	cairo_surface_t* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_WIDGET, AvatarWidget);
	_tmp0_ = self->priv->_surface;
	if (_tmp0_ == NULL) {
		_vala_minimal = 0;
		_vala_natural = 0;
	} else {
		cairo_surface_t* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		cairo_surface_t* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp1_ = self->priv->_surface;
		_tmp2_ = cairo_image_surface_get_height ((cairo_surface_t*) _tmp1_);
		_vala_minimal = _tmp2_;
		_tmp3_ = self->priv->_surface;
		_tmp4_ = cairo_image_surface_get_height ((cairo_surface_t*) _tmp3_);
		_vala_natural = _tmp4_;
	}
	if (minimal) {
		*minimal = _vala_minimal;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


AvatarWidget* avatar_widget_construct (GType object_type) {
	AvatarWidget * self = NULL;
	self = (AvatarWidget*) gtk_widget_new (object_type, NULL);
	return self;
}


AvatarWidget* avatar_widget_new (void) {
	return avatar_widget_construct (TYPE_AVATAR_WIDGET);
}


gboolean avatar_widget_get_make_round (AvatarWidget* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (IS_AVATAR_WIDGET (self), FALSE);
	_tmp0_ = self->priv->_round;
	result = _tmp0_;
	return result;
}


void avatar_widget_set_make_round (AvatarWidget* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_AVATAR_WIDGET (self));
	_tmp0_ = value;
	if (_tmp0_) {
		GtkStyleContext* _tmp1_ = NULL;
		_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp1_, "avatar-round");
	} else {
		GtkStyleContext* _tmp2_ = NULL;
		_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_remove_class (_tmp2_, "avatar-round");
	}
	_tmp3_ = value;
	self->priv->_round = _tmp3_;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	g_object_notify ((GObject *) self, "make-round");
}


gboolean avatar_widget_get_verified (AvatarWidget* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (IS_AVATAR_WIDGET (self), FALSE);
	_tmp0_ = self->priv->_verified;
	result = _tmp0_;
	return result;
}


void avatar_widget_set_verified (AvatarWidget* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_AVATAR_WIDGET (self));
	_tmp0_ = value;
	self->priv->_verified = _tmp0_;
	g_object_notify ((GObject *) self, "verified");
}


cairo_surface_t* avatar_widget_get_surface (AvatarWidget* self) {
	cairo_surface_t* result;
	cairo_surface_t* _tmp0_ = NULL;
	g_return_val_if_fail (IS_AVATAR_WIDGET (self), NULL);
	_tmp0_ = self->priv->_surface;
	result = _tmp0_;
	return result;
}


void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value) {
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	g_return_if_fail (IS_AVATAR_WIDGET (self));
	_tmp0_ = self->priv->_surface;
	if (_tmp0_ != NULL) {
		cairo_surface_t* _tmp1_ = NULL;
		_tmp1_ = self->priv->_surface;
		twitter_unref_avatar (_tmp1_);
	}
	_tmp2_ = value;
	_tmp3_ = _cairo_surface_reference0 (_tmp2_);
	_cairo_surface_destroy0 (self->priv->_surface);
	self->priv->_surface = _tmp3_;
	_tmp4_ = self->priv->_surface;
	if (_tmp4_ != NULL) {
		cairo_surface_t* _tmp5_ = NULL;
		_tmp5_ = self->priv->_surface;
		twitter_ref_avatar (_tmp5_);
	}
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	g_object_notify ((GObject *) self, "surface");
}


static GObject * avatar_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AvatarWidget * self;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (avatar_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_WIDGET, AvatarWidget);
	gtk_widget_set_has_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp0_ = settings_get ();
	_tmp1_ = _tmp0_;
	g_settings_bind (_tmp1_, "round-avatars", G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "make_round", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp1_);
	return obj;
}


static void avatar_widget_class_init (AvatarWidgetClass * klass) {
	GError * _inner_error_ = NULL;
	avatar_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AvatarWidgetPrivate));
	((GtkWidgetClass *) klass)->draw = avatar_widget_real_draw;
	((GtkWidgetClass *) klass)->get_preferred_height = avatar_widget_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_avatar_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_avatar_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = avatar_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = avatar_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVATAR_WIDGET_MAKE_ROUND, g_param_spec_boolean ("make-round", "make-round", "make-round", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVATAR_WIDGET_VERIFIED, g_param_spec_boolean ("verified", "verified", "verified", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVATAR_WIDGET_SURFACE, g_param_spec_pointer ("surface", "surface", "surface", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_ = NULL;
		cairo_surface_t* _tmp8_ = NULL;
		cairo_surface_t* _tmp9_ = NULL;
		cairo_surface_t* _tmp10_ = NULL;
		cairo_surface_t* _tmp11_ = NULL;
		cairo_surface_t** _tmp12_ = NULL;
		_tmp1_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/verified-small.png", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch64_g_error;
		}
		_tmp3_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/verified-large.png", &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch64_g_error;
		}
		_tmp5_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/verified-small@2.png", &_inner_error_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (_tmp0_);
			goto __catch64_g_error;
		}
		_tmp7_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/verified-large@2.png", &_inner_error_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp4_);
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (_tmp0_);
			goto __catch64_g_error;
		}
		_tmp8_ = gdk_cairo_surface_create_from_pixbuf (_tmp0_, 1, NULL);
		_tmp9_ = gdk_cairo_surface_create_from_pixbuf (_tmp2_, 1, NULL);
		_tmp10_ = gdk_cairo_surface_create_from_pixbuf (_tmp4_, 2, NULL);
		_tmp11_ = gdk_cairo_surface_create_from_pixbuf (_tmp6_, 2, NULL);
		_tmp12_ = g_new0 (cairo_surface_t*, 4 + 1);
		_tmp12_[0] = _tmp8_;
		_tmp12_[1] = _tmp9_;
		_tmp12_[2] = _tmp10_;
		_tmp12_[3] = _tmp11_;
		avatar_widget_verified_icons = (_vala_array_free (avatar_widget_verified_icons, avatar_widget_verified_icons_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
		avatar_widget_verified_icons = _tmp12_;
		avatar_widget_verified_icons_length1 = 4;
		_avatar_widget_verified_icons_size_ = avatar_widget_verified_icons_length1;
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally64;
	__catch64_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_critical ("AvatarWidget.vala:78: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally64:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void avatar_widget_instance_init (AvatarWidget * self) {
	self->priv = AVATAR_WIDGET_GET_PRIVATE (self);
	self->priv->_round = TRUE;
	self->priv->_verified = FALSE;
}


static void avatar_widget_finalize (GObject* obj) {
	AvatarWidget * self;
	cairo_surface_t* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_WIDGET, AvatarWidget);
	_tmp0_ = self->priv->_surface;
	if (_tmp0_ != NULL) {
		cairo_surface_t* _tmp1_ = NULL;
		_tmp1_ = self->priv->_surface;
		twitter_unref_avatar (_tmp1_);
	}
	_cairo_surface_destroy0 (self->priv->_surface);
	G_OBJECT_CLASS (avatar_widget_parent_class)->finalize (obj);
}


GType avatar_widget_get_type (void) {
	static volatile gsize avatar_widget_type_id__volatile = 0;
	if (g_once_init_enter (&avatar_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AvatarWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avatar_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvatarWidget), 0, (GInstanceInitFunc) avatar_widget_instance_init, NULL };
		GType avatar_widget_type_id;
		avatar_widget_type_id = g_type_register_static (gtk_widget_get_type (), "AvatarWidget", &g_define_type_info, 0);
		g_once_init_leave (&avatar_widget_type_id__volatile, avatar_widget_type_id);
	}
	return avatar_widget_type_id__volatile;
}


static void _vala_avatar_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AvatarWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVATAR_WIDGET, AvatarWidget);
	switch (property_id) {
		case AVATAR_WIDGET_MAKE_ROUND:
		g_value_set_boolean (value, avatar_widget_get_make_round (self));
		break;
		case AVATAR_WIDGET_VERIFIED:
		g_value_set_boolean (value, avatar_widget_get_verified (self));
		break;
		case AVATAR_WIDGET_SURFACE:
		g_value_set_pointer (value, avatar_widget_get_surface (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_avatar_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AvatarWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVATAR_WIDGET, AvatarWidget);
	switch (property_id) {
		case AVATAR_WIDGET_MAKE_ROUND:
		avatar_widget_set_make_round (self, g_value_get_boolean (value));
		break;
		case AVATAR_WIDGET_VERIFIED:
		avatar_widget_set_verified (self, g_value_get_boolean (value));
		break;
		case AVATAR_WIDGET_SURFACE:
		avatar_widget_set_surface (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



