/* MediaVideoWidget.c generated by valac 0.30.0, the Vala compiler
 * generated from MediaVideoWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <gst/video/video.h>
#include <gdk/gdkx.h>
#include <libsoup/soup.h>
#include <float.h>
#include <math.h>


#define TYPE_MEDIA_VIDEO_WIDGET (media_video_widget_get_type ())
#define MEDIA_VIDEO_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidget))
#define MEDIA_VIDEO_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidgetClass))
#define IS_MEDIA_VIDEO_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_VIDEO_WIDGET))
#define IS_MEDIA_VIDEO_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_VIDEO_WIDGET))
#define MEDIA_VIDEO_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidgetClass))

typedef struct _MediaVideoWidget MediaVideoWidget;
typedef struct _MediaVideoWidgetClass MediaVideoWidgetClass;
typedef struct _MediaVideoWidgetPrivate MediaVideoWidgetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
typedef struct _MediaPrivate MediaPrivate;

#define TYPE_MEDIA_TYPE (media_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block51Data Block51Data;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MediaVideoWidgetFetchRealUrlData MediaVideoWidgetFetchRealUrlData;
typedef struct _Block52Data Block52Data;
typedef struct _MediaVideoWidgetDownloadVideoData MediaVideoWidgetDownloadVideoData;

struct _MediaVideoWidget {
	GtkStack parent_instance;
	MediaVideoWidgetPrivate * priv;
};

struct _MediaVideoWidgetClass {
	GtkStackClass parent_class;
};

struct _MediaVideoWidgetPrivate {
	GstElement* src;
	GstElement* sink;
	guint* xid;
	GtkProgressBar* progress_bar;
	GtkDrawingArea* drawing_area;
	gint64 file_content_length;
	gint64 current_content_length;
	GCancellable* cancellable;
	GtkLabel* error_label;
};

typedef enum  {
	MEDIA_TYPE_IMAGE,
	MEDIA_TYPE_VINE,
	MEDIA_TYPE_GIF,
	MEDIA_TYPE_ANIMATED_GIF,
	MEDIA_TYPE_TWITTER_VIDEO,
	MEDIA_TYPE_UNKNOWN
} MediaType;

struct _Media {
	GObject parent_instance;
	MediaPrivate * priv;
	gint64 id;
	gchar* path;
	gchar* thumb_path;
	gchar* url;
	MediaType type;
	cairo_surface_t* thumbnail;
	gboolean loaded;
	gboolean invalid;
};

struct _MediaClass {
	GObjectClass parent_class;
};

struct _Block51Data {
	int _ref_count_;
	MediaVideoWidget* self;
	SoupMessage* msg;
	gchar* regex_str;
	gpointer _async_data_;
};

struct _MediaVideoWidgetFetchRealUrlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MediaVideoWidget* self;
	gchar* first_url;
	gchar* regex_str;
	Block51Data* _data51_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	GCancellable* _tmp3_;
	SoupSession* _tmp4_;
	SoupMessage* _tmp5_;
};

struct _Block52Data {
	int _ref_count_;
	MediaVideoWidget* self;
	SoupMessage* msg;
	gpointer _async_data_;
};

struct _MediaVideoWidgetDownloadVideoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MediaVideoWidget* self;
	gchar* url;
	Block52Data* _data52_;
	const gchar* _tmp0_;
	SoupMessage* _tmp1_;
	GCancellable* _tmp2_;
	SoupSession* _tmp3_;
	SoupMessage* _tmp4_;
};


static gpointer media_video_widget_parent_class = NULL;
extern SoupSession* SOUP_SESSION;

GType media_video_widget_get_type (void) G_GNUC_CONST;
#define MEDIA_VIDEO_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidgetPrivate))
enum  {
	MEDIA_VIDEO_WIDGET_DUMMY_PROPERTY
};
GType media_get_type (void) G_GNUC_CONST;
MediaVideoWidget* media_video_widget_new (Media* media);
MediaVideoWidget* media_video_widget_construct (GType object_type, Media* media);
static void media_video_widget_realize_cb (MediaVideoWidget* self);
static void _media_video_widget_realize_cb_gtk_widget_realize (GtkWidget* _sender, gpointer self);
static GstBusSyncReply media_video_widget_bus_sync_handler (MediaVideoWidget* self, GstBus* bus, GstMessage* msg);
static GstBusSyncReply _media_video_widget_bus_sync_handler_gst_bus_sync_handler (GstBus* bus, GstMessage* message, gpointer self);
static gboolean media_video_widget_watch_cb (MediaVideoWidget* self, GstBus* bus, GstMessage* msg);
static gboolean _media_video_widget_watch_cb_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
GType media_type_get_type (void) G_GNUC_CONST;
static void media_video_widget_fetch_real_url (MediaVideoWidget* self, const gchar* first_url, const gchar* regex_str, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void media_video_widget_fetch_real_url_finish (MediaVideoWidget* self, GAsyncResult* _res_);
static void media_video_widget_download_video (MediaVideoWidget* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void media_video_widget_download_video_finish (MediaVideoWidget* self, GAsyncResult* _res_);
static gboolean media_video_widget_button_press_event_cb (MediaVideoWidget* self, GdkEventButton* evt);
static gboolean _media_video_widget_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean media_video_widget_key_press_event_cb (MediaVideoWidget* self, GdkEventKey* evt);
static gboolean _media_video_widget_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void media_video_widget_show_error (MediaVideoWidget* self, const gchar* error_message);
static void media_video_widget_stop (MediaVideoWidget* self);
static void media_video_widget_real_destroy (GtkWidget* base);
static void media_video_widget_fetch_real_url_data_free (gpointer _data);
static gboolean media_video_widget_fetch_real_url_co (MediaVideoWidgetFetchRealUrlData* _data_);
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
static void __lambda71_ (Block51Data* _data51_);
static void ___lambda71__g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void __lambda72_ (Block51Data* _data51_, SoupSession* s, SoupMessage* _msg);
static void ___lambda72__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void media_video_widget_download_video_data_free (gpointer _data);
static gboolean media_video_widget_download_video_co (MediaVideoWidgetDownloadVideoData* _data_);
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
static void __lambda73_ (Block52Data* _data52_);
static void ___lambda73__soup_message_got_headers (SoupMessage* _sender, gpointer self);
static void __lambda74_ (Block52Data* _data52_);
static void ___lambda74__g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void __lambda75_ (MediaVideoWidget* self, SoupBuffer* buffer);
static void ___lambda75__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void __lambda76_ (Block52Data* _data52_, SoupSession* s, SoupMessage* _msg);
static void ___lambda76__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void media_video_widget_finalize (GObject* obj);


static void _media_video_widget_realize_cb_gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	media_video_widget_realize_cb ((MediaVideoWidget*) self);
}


static GstBusSyncReply _media_video_widget_bus_sync_handler_gst_bus_sync_handler (GstBus* bus, GstMessage* message, gpointer self) {
	GstBusSyncReply result;
	result = media_video_widget_bus_sync_handler ((MediaVideoWidget*) self, bus, message);
	return result;
}


static gboolean _media_video_widget_watch_cb_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = media_video_widget_watch_cb ((MediaVideoWidget*) self, bus, message);
	return result;
}


static gboolean _media_video_widget_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = media_video_widget_button_press_event_cb ((MediaVideoWidget*) self, event);
	return result;
}


static gboolean _media_video_widget_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = media_video_widget_key_press_event_cb ((MediaVideoWidget*) self, event);
	return result;
}


MediaVideoWidget* media_video_widget_construct (GType object_type, Media* media) {
	MediaVideoWidget * self = NULL;
	GCancellable* _tmp0_ = NULL;
	GtkDrawingArea* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	GstElement* _tmp5_ = NULL;
	GstBus* bus = NULL;
	GstElement* _tmp6_ = NULL;
	GstBus* _tmp7_ = NULL;
	GstBus* _tmp8_ = NULL;
	GstBus* _tmp9_ = NULL;
	Media* _tmp10_ = NULL;
	MediaType _tmp11_ = 0;
	GtkDrawingArea* _tmp24_ = NULL;
	GtkProgressBar* _tmp25_ = NULL;
	GtkProgressBar* _tmp26_ = NULL;
	GtkProgressBar* _tmp27_ = NULL;
	GtkLabel* _tmp28_ = NULL;
	GtkLabel* _tmp29_ = NULL;
	GtkLabel* _tmp30_ = NULL;
	GtkProgressBar* _tmp31_ = NULL;
	GtkDrawingArea* _tmp32_ = NULL;
	GtkLabel* _tmp33_ = NULL;
	GtkProgressBar* _tmp34_ = NULL;
	g_return_val_if_fail (IS_MEDIA (media), NULL);
	self = (MediaVideoWidget*) g_object_new (object_type, NULL);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	_tmp1_ = self->priv->drawing_area;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), "realize", (GCallback) _media_video_widget_realize_cb_gtk_widget_realize, self, 0);
	_tmp2_ = gst_element_factory_make ("playbin", "video");
	if (_tmp2_ != NULL) {
		g_object_ref_sink (_tmp2_);
	}
	_g_object_unref0 (self->priv->src);
	self->priv->src = _tmp2_;
	_tmp3_ = gst_element_factory_make ("ximagesink", "sink");
	if (_tmp3_ != NULL) {
		g_object_ref_sink (_tmp3_);
	}
	_g_object_unref0 (self->priv->sink);
	self->priv->sink = _tmp3_;
	_tmp4_ = self->priv->src;
	_tmp5_ = self->priv->sink;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject), "video-sink", _tmp5_, NULL, NULL);
	_tmp6_ = self->priv->src;
	_tmp7_ = gst_element_get_bus (_tmp6_);
	bus = _tmp7_;
	_tmp8_ = bus;
	gst_bus_set_sync_handler (_tmp8_, _media_video_widget_bus_sync_handler_gst_bus_sync_handler, g_object_ref (self), g_object_unref);
	_tmp9_ = bus;
	gst_bus_add_watch_full (_tmp9_, G_PRIORITY_DEFAULT, _media_video_widget_watch_cb_gst_bus_func, g_object_ref (self), g_object_unref);
	_tmp10_ = media;
	_tmp11_ = _tmp10_->type;
	if (_tmp11_ == MEDIA_TYPE_VINE) {
		Media* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp12_ = media;
		_tmp13_ = _tmp12_->url;
		media_video_widget_fetch_real_url (self, _tmp13_, "<meta property=\"twitter:player:stream\" content=\"(.*?)\"", NULL, NULL);
	} else {
		Media* _tmp14_ = NULL;
		MediaType _tmp15_ = 0;
		_tmp14_ = media;
		_tmp15_ = _tmp14_->type;
		if (_tmp15_ == MEDIA_TYPE_ANIMATED_GIF) {
			Media* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			_tmp16_ = media;
			_tmp17_ = _tmp16_->url;
			media_video_widget_fetch_real_url (self, _tmp17_, "<source video-src=\"(.*?)\" type=\"video/mp4\"", NULL, NULL);
		} else {
			Media* _tmp18_ = NULL;
			MediaType _tmp19_ = 0;
			_tmp18_ = media;
			_tmp19_ = _tmp18_->type;
			if (_tmp19_ == MEDIA_TYPE_TWITTER_VIDEO) {
				Media* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				_tmp20_ = media;
				_tmp21_ = _tmp20_->url;
				media_video_widget_download_video (self, _tmp21_, NULL, NULL);
			} else {
				Media* _tmp22_ = NULL;
				MediaType _tmp23_ = 0;
				_tmp22_ = media;
				_tmp23_ = _tmp22_->type;
				g_critical ("MediaVideoWidget.vala:49: Unknown video media type: %d", (gint) _tmp23_);
			}
		}
	}
	_tmp24_ = self->priv->drawing_area;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget), 435, 435);
	_tmp25_ = self->priv->progress_bar;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp26_ = self->priv->progress_bar;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget), "margin", 20, NULL);
	_tmp27_ = self->priv->progress_bar;
	gtk_progress_bar_set_show_text (_tmp27_, TRUE);
	_tmp28_ = self->priv->error_label;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget), "margin", 20, NULL);
	_tmp29_ = self->priv->error_label;
	g_object_set (_tmp29_, "wrap", TRUE, NULL);
	_tmp30_ = self->priv->error_label;
	gtk_label_set_selectable (_tmp30_, TRUE);
	_tmp31_ = self->priv->progress_bar;
	gtk_stack_add_named (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget), "progress");
	_tmp32_ = self->priv->drawing_area;
	gtk_stack_add_named (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget), "video");
	_tmp33_ = self->priv->error_label;
	gtk_stack_add_named (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget), "error");
	_tmp34_ = self->priv->progress_bar;
	gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _media_video_widget_button_press_event_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) _media_video_widget_key_press_event_cb_gtk_widget_key_press_event, self, 0);
	_g_object_unref0 (bus);
	return self;
}


MediaVideoWidget* media_video_widget_new (Media* media) {
	return media_video_widget_construct (TYPE_MEDIA_VIDEO_WIDGET, media);
}


static void media_video_widget_show_error (MediaVideoWidget* self, const gchar* error_message) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_MEDIA_VIDEO_WIDGET (self));
	g_return_if_fail (error_message != NULL);
	_tmp0_ = self->priv->error_label;
	_tmp1_ = error_message;
	gtk_label_set_label (_tmp0_, _tmp1_);
	gtk_stack_set_visible_child_name (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), "error");
}


static gboolean media_video_widget_button_press_event_cb (MediaVideoWidget* self, GdkEventButton* evt) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_MEDIA_VIDEO_WIDGET (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	media_video_widget_stop (self);
	result = FALSE;
	return result;
}


static gboolean media_video_widget_key_press_event_cb (MediaVideoWidget* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_MEDIA_VIDEO_WIDGET (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	media_video_widget_stop (self);
	result = TRUE;
	return result;
}


static void media_video_widget_stop (MediaVideoWidget* self) {
	GCancellable* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	g_return_if_fail (IS_MEDIA_VIDEO_WIDGET (self));
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = self->priv->src;
	gst_element_set_state (_tmp1_, GST_STATE_NULL);
}


static void media_video_widget_real_destroy (GtkWidget* base) {
	MediaVideoWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidget);
	media_video_widget_stop (self);
	GTK_WIDGET_CLASS (media_video_widget_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), gtk_widget_get_type (), GtkWidget));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GstBusSyncReply media_video_widget_bus_sync_handler (MediaVideoWidget* self, GstBus* bus, GstMessage* msg) {
	GstBusSyncReply result = 0;
	GstMessage* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GstVideoOverlay* overlay = NULL;
	GstMessage* _tmp2_ = NULL;
	GstObject* _tmp3_ = NULL;
	GstVideoOverlay* _tmp4_ = NULL;
	GstVideoOverlay* _tmp5_ = NULL;
	guint* _tmp6_ = NULL;
	g_return_val_if_fail (IS_MEDIA_VIDEO_WIDGET (self), 0);
	g_return_val_if_fail (GST_IS_BUS (bus), 0);
	g_return_val_if_fail (msg != NULL, 0);
	_tmp0_ = msg;
	_tmp1_ = gst_is_video_overlay_prepare_window_handle_message (_tmp0_);
	if (!_tmp1_) {
		result = GST_BUS_PASS;
		return result;
	}
	_tmp2_ = msg;
	_tmp3_ = _tmp2_->src;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gst_video_overlay_get_type (), GstVideoOverlay));
	overlay = _tmp4_;
	_tmp5_ = overlay;
	_tmp6_ = self->priv->xid;
	gst_video_overlay_set_window_handle (_tmp5_, (guintptr) _tmp6_);
	result = GST_BUS_DROP;
	_g_object_unref0 (overlay);
	return result;
}


static gboolean media_video_widget_watch_cb (MediaVideoWidget* self, GstBus* bus, GstMessage* msg) {
	gboolean result = FALSE;
	GstMessage* _tmp0_ = NULL;
	GstMessageType _tmp1_ = 0;
	g_return_val_if_fail (IS_MEDIA_VIDEO_WIDGET (self), FALSE);
	g_return_val_if_fail (GST_IS_BUS (bus), FALSE);
	g_return_val_if_fail (msg != NULL, FALSE);
	_tmp0_ = msg;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ == GST_MESSAGE_EOS) {
		GstElement* _tmp2_ = NULL;
		_tmp2_ = self->priv->src;
		gst_element_seek (_tmp2_, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, (gint64) 0, GST_SEEK_TYPE_NONE, (gint64) -1);
	}
	result = TRUE;
	return result;
}


static void media_video_widget_realize_cb (MediaVideoWidget* self) {
	GtkDrawingArea* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	Window _tmp2_ = 0;
	g_return_if_fail (IS_MEDIA_VIDEO_WIDGET (self));
	_tmp0_ = self->priv->drawing_area;
	_tmp1_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = gdk_x11_window_get_xid (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gdk_x11_window_get_type (), GdkX11Window));
	self->priv->xid = (guint*) _tmp2_;
}


static void media_video_widget_fetch_real_url_data_free (gpointer _data) {
	MediaVideoWidgetFetchRealUrlData* _data_;
	_data_ = _data;
	_g_free0 (_data_->first_url);
	_g_object_unref0 (_data_->self);
	g_slice_free (MediaVideoWidgetFetchRealUrlData, _data_);
}


static void media_video_widget_fetch_real_url (MediaVideoWidget* self, const gchar* first_url, const gchar* regex_str, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MediaVideoWidgetFetchRealUrlData* _data_;
	MediaVideoWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_data_ = g_slice_new0 (MediaVideoWidgetFetchRealUrlData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, media_video_widget_fetch_real_url);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, media_video_widget_fetch_real_url_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = first_url;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->first_url);
	_data_->first_url = _tmp2_;
	_tmp3_ = regex_str;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->regex_str);
	_data_->regex_str = _tmp4_;
	media_video_widget_fetch_real_url_co (_data_);
}


static void media_video_widget_fetch_real_url_finish (MediaVideoWidget* self, GAsyncResult* _res_) {
	MediaVideoWidgetFetchRealUrlData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block51Data* block51_data_ref (Block51Data* _data51_) {
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}


static void block51_data_unref (void * _userdata_) {
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		MediaVideoWidget* self;
		self = _data51_->self;
		_g_object_unref0 (_data51_->msg);
		_g_free0 (_data51_->regex_str);
		_g_object_unref0 (self);
		g_slice_free (Block51Data, _data51_);
	}
}


static void __lambda71_ (Block51Data* _data51_) {
	MediaVideoWidget* self;
	SoupSession* _tmp0_ = NULL;
	self = _data51_->self;
	_tmp0_ = SOUP_SESSION;
	soup_session_cancel_message (_tmp0_, _data51_->msg, (guint) SOUP_STATUS_CANCELLED);
}


static void ___lambda71__g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	__lambda71_ (self);
}


static void __lambda72_ (Block51Data* _data51_, SoupSession* s, SoupMessage* _msg) {
	MediaVideoWidget* self;
	SoupMessage* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gchar* back = NULL;
	SoupMessage* _tmp18_ = NULL;
	SoupMessageBody* _tmp19_ = NULL;
	guint8* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data51_->self;
	g_return_if_fail (SOUP_IS_SESSION (s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _msg;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint) SOUP_STATUS_OK)) {
		SoupMessage* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		_tmp3_ = _msg;
		g_object_get (_tmp3_, "status-code", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != ((guint) SOUP_STATUS_CANCELLED)) {
			SoupMessage* _tmp6_ = NULL;
			guint _tmp7_ = 0U;
			guint _tmp8_ = 0U;
			SoupMessage* _tmp9_ = NULL;
			guint _tmp10_ = 0U;
			guint _tmp11_ = 0U;
			SoupMessage* _tmp12_ = NULL;
			guint _tmp13_ = 0U;
			guint _tmp14_ = 0U;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			_tmp6_ = _msg;
			g_object_get (_tmp6_, "status-code", &_tmp7_, NULL);
			_tmp8_ = _tmp7_;
			g_warning ("MediaVideoWidget.vala:138: Status Code %u", _tmp8_);
			_tmp9_ = _msg;
			g_object_get (_tmp9_, "status-code", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = _msg;
			g_object_get (_tmp12_, "status-code", &_tmp13_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = soup_status_get_phrase (_tmp14_);
			_tmp16_ = g_strdup_printf ("%u %s", _tmp11_, _tmp15_);
			_tmp17_ = _tmp16_;
			media_video_widget_show_error (self, _tmp17_);
			_g_free0 (_tmp17_);
		}
		media_video_widget_fetch_real_url_co (_data51_->_async_data_);
		return;
	}
	_tmp18_ = _msg;
	_tmp19_ = _tmp18_->response_body;
	_tmp20_ = _tmp19_->data;
	_tmp20__length1 = (gint) _tmp19_->length;
	_tmp21_ = g_strdup ((const gchar*) _tmp20_);
	back = _tmp21_;
	{
		GRegex* regex = NULL;
		const gchar* _tmp22_ = NULL;
		GRegex* _tmp23_ = NULL;
		GMatchInfo* info = NULL;
		GRegex* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		GMatchInfo* _tmp26_ = NULL;
		gchar* real_url = NULL;
		GMatchInfo* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		_tmp22_ = _data51_->regex_str;
		_tmp23_ = g_regex_new (_tmp22_, 0, 0, &_inner_error_);
		regex = _tmp23_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch70_g_regex_error;
			}
			_g_free0 (back);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp24_ = regex;
		_tmp25_ = back;
		g_regex_match (_tmp24_, _tmp25_, 0, &_tmp26_);
		_g_match_info_unref0 (info);
		info = _tmp26_;
		_tmp27_ = info;
		_tmp28_ = g_match_info_fetch (_tmp27_, 1);
		real_url = _tmp28_;
		_tmp29_ = real_url;
		if (_tmp29_ == NULL) {
			media_video_widget_show_error (self, "Error: Could not get real URL");
		} else {
			const gchar* _tmp30_ = NULL;
			_tmp30_ = real_url;
			media_video_widget_download_video (self, _tmp30_, NULL, NULL);
		}
		_g_free0 (real_url);
		_g_match_info_unref0 (info);
		_g_regex_unref0 (regex);
	}
	goto __finally70;
	__catch70_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		GError* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_warning ("MediaVideoWidget.vala:155: Regex error: %s", _tmp32_);
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		_tmp35_ = g_strdup_printf ("Regex error: %s", _tmp34_);
		_tmp36_ = _tmp35_;
		media_video_widget_show_error (self, _tmp36_);
		_g_free0 (_tmp36_);
		_g_error_free0 (e);
	}
	__finally70:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (back);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	media_video_widget_fetch_real_url_co (_data51_->_async_data_);
	_g_free0 (back);
}


static void ___lambda72__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda72_ (self, session, msg);
	block51_data_unref (self);
}


static gboolean media_video_widget_fetch_real_url_co (MediaVideoWidgetFetchRealUrlData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data51_ = g_slice_new0 (Block51Data);
	_data_->_data51_->_ref_count_ = 1;
	_data_->_data51_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->regex_str;
	_g_free0 (_data_->_data51_->regex_str);
	_data_->_data51_->regex_str = _data_->_tmp0_;
	_data_->_data51_->_async_data_ = _data_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->first_url;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = soup_message_new ("GET", _data_->_tmp1_);
	_data_->_data51_->msg = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->cancellable;
	g_signal_connect_data (_data_->_tmp3_, "cancelled", (GCallback) ___lambda71__g_cancellable_cancelled, block51_data_ref (_data_->_data51_), (GClosureNotify) block51_data_unref, 0);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = SOUP_SESSION;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _g_object_ref0 (_data_->_data51_->msg);
	soup_session_queue_message (_data_->_tmp4_, _data_->_tmp5_, ___lambda72__soup_session_callback, block51_data_ref (_data_->_data51_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block51_data_unref (_data_->_data51_);
	_data_->_data51_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void media_video_widget_download_video_data_free (gpointer _data) {
	MediaVideoWidgetDownloadVideoData* _data_;
	_data_ = _data;
	_g_free0 (_data_->url);
	_g_object_unref0 (_data_->self);
	g_slice_free (MediaVideoWidgetDownloadVideoData, _data_);
}


static void media_video_widget_download_video (MediaVideoWidget* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MediaVideoWidgetDownloadVideoData* _data_;
	MediaVideoWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (MediaVideoWidgetDownloadVideoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, media_video_widget_download_video);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, media_video_widget_download_video_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = url;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->url);
	_data_->url = _tmp2_;
	media_video_widget_download_video_co (_data_);
}


static void media_video_widget_download_video_finish (MediaVideoWidget* self, GAsyncResult* _res_) {
	MediaVideoWidgetDownloadVideoData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block52Data* block52_data_ref (Block52Data* _data52_) {
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}


static void block52_data_unref (void * _userdata_) {
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		MediaVideoWidget* self;
		self = _data52_->self;
		_g_object_unref0 (_data52_->msg);
		_g_object_unref0 (self);
		g_slice_free (Block52Data, _data52_);
	}
}


static void __lambda73_ (Block52Data* _data52_) {
	MediaVideoWidget* self;
	SoupMessageHeaders* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	self = _data52_->self;
	_tmp0_ = _data52_->msg->response_headers;
	_tmp1_ = soup_message_headers_get_content_length (_tmp0_);
	self->priv->file_content_length = _tmp1_;
}


static void ___lambda73__soup_message_got_headers (SoupMessage* _sender, gpointer self) {
	__lambda73_ (self);
}


static void __lambda74_ (Block52Data* _data52_) {
	MediaVideoWidget* self;
	SoupSession* _tmp0_ = NULL;
	self = _data52_->self;
	_tmp0_ = SOUP_SESSION;
	soup_session_cancel_message (_tmp0_, _data52_->msg, (guint) SOUP_STATUS_CANCELLED);
}


static void ___lambda74__g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	__lambda74_ (self);
}


static void __lambda75_ (MediaVideoWidget* self, SoupBuffer* buffer) {
	gint64 _tmp0_ = 0LL;
	SoupBuffer* _tmp1_ = NULL;
	gsize _tmp2_ = 0UL;
	gdouble fraction = 0.0;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	GtkProgressBar* _tmp5_ = NULL;
	GtkProgressBar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_if_fail (buffer != NULL);
	_tmp0_ = self->priv->current_content_length;
	_tmp1_ = buffer;
	_tmp2_ = _tmp1_->length;
	self->priv->current_content_length = _tmp0_ + _tmp2_;
	_tmp3_ = self->priv->current_content_length;
	_tmp4_ = self->priv->file_content_length;
	fraction = ((gdouble) _tmp3_) / ((gdouble) _tmp4_);
	_tmp5_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp5_, fraction);
	_tmp6_ = self->priv->progress_bar;
	_tmp7_ = g_strdup_printf ("%d %%", (gint) (fraction * 100));
	_tmp8_ = _tmp7_;
	gtk_progress_bar_set_text (_tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
}


static void ___lambda75__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
	__lambda75_ ((MediaVideoWidget*) self, chunk);
}


static void __lambda76_ (Block52Data* _data52_, SoupSession* s, SoupMessage* _msg) {
	MediaVideoWidget* self;
	SoupMessage* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gchar* b64 = NULL;
	SoupMessageBody* _tmp18_ = NULL;
	guint8* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gchar* _tmp20_ = NULL;
	gchar* sa = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	GstElement* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	GstElement* _tmp25_ = NULL;
	self = _data52_->self;
	g_return_if_fail (SOUP_IS_SESSION (s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _msg;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint) SOUP_STATUS_OK)) {
		SoupMessage* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		_tmp3_ = _msg;
		g_object_get (_tmp3_, "status-code", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != ((guint) SOUP_STATUS_CANCELLED)) {
			SoupMessage* _tmp6_ = NULL;
			guint _tmp7_ = 0U;
			guint _tmp8_ = 0U;
			SoupMessage* _tmp9_ = NULL;
			guint _tmp10_ = 0U;
			guint _tmp11_ = 0U;
			SoupMessage* _tmp12_ = NULL;
			guint _tmp13_ = 0U;
			guint _tmp14_ = 0U;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			_tmp6_ = _msg;
			g_object_get (_tmp6_, "status-code", &_tmp7_, NULL);
			_tmp8_ = _tmp7_;
			g_warning ("MediaVideoWidget.vala:182: Status Code %u", _tmp8_);
			_tmp9_ = _msg;
			g_object_get (_tmp9_, "status-code", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = _msg;
			g_object_get (_tmp12_, "status-code", &_tmp13_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = soup_status_get_phrase (_tmp14_);
			_tmp16_ = g_strdup_printf ("%u %s", _tmp11_, _tmp15_);
			_tmp17_ = _tmp16_;
			media_video_widget_show_error (self, _tmp17_);
			_g_free0 (_tmp17_);
		}
		media_video_widget_download_video_co (_data52_->_async_data_);
		return;
	}
	_tmp18_ = _data52_->msg->response_body;
	_tmp19_ = _tmp18_->data;
	_tmp19__length1 = (gint) _tmp18_->length;
	_tmp20_ = g_base64_encode ((guchar*) _tmp19_, (_tmp19__length1 * sizeof (guint8)) / sizeof (guchar));
	b64 = _tmp20_;
	_tmp21_ = b64;
	_tmp22_ = g_strconcat ("data:;base64,", _tmp21_, NULL);
	sa = _tmp22_;
	_tmp23_ = self->priv->src;
	_tmp24_ = sa;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, G_TYPE_OBJECT, GObject), "uri", _tmp24_, NULL);
	gtk_stack_set_visible_child_name (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), "video");
	_tmp25_ = self->priv->src;
	gst_element_set_state (_tmp25_, GST_STATE_PLAYING);
	media_video_widget_download_video_co (_data52_->_async_data_);
	_g_free0 (sa);
	_g_free0 (b64);
}


static void ___lambda76__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda76_ (self, session, msg);
	block52_data_unref (self);
}


static gboolean media_video_widget_download_video_co (MediaVideoWidgetDownloadVideoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data52_ = g_slice_new0 (Block52Data);
	_data_->_data52_->_ref_count_ = 1;
	_data_->_data52_->self = g_object_ref (_data_->self);
	_data_->_data52_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->url;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = soup_message_new ("GET", _data_->_tmp0_);
	_data_->_data52_->msg = _data_->_tmp1_;
	g_signal_connect_data (_data_->_data52_->msg, "got-headers", (GCallback) ___lambda73__soup_message_got_headers, block52_data_ref (_data_->_data52_), (GClosureNotify) block52_data_unref, 0);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->cancellable;
	g_signal_connect_data (_data_->_tmp2_, "cancelled", (GCallback) ___lambda74__g_cancellable_cancelled, block52_data_ref (_data_->_data52_), (GClosureNotify) block52_data_unref, 0);
	g_signal_connect_object (_data_->_data52_->msg, "got-chunk", (GCallback) ___lambda75__soup_message_got_chunk, _data_->self, 0);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = SOUP_SESSION;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_data52_->msg);
	soup_session_queue_message (_data_->_tmp3_, _data_->_tmp4_, ___lambda76__soup_session_callback, block52_data_ref (_data_->_data52_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block52_data_unref (_data_->_data52_);
	_data_->_data52_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void media_video_widget_class_init (MediaVideoWidgetClass * klass) {
	media_video_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MediaVideoWidgetPrivate));
	((GtkWidgetClass *) klass)->destroy = media_video_widget_real_destroy;
	G_OBJECT_CLASS (klass)->finalize = media_video_widget_finalize;
}


static void media_video_widget_instance_init (MediaVideoWidget * self) {
	GtkProgressBar* _tmp0_ = NULL;
	GtkDrawingArea* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	self->priv = MEDIA_VIDEO_WIDGET_GET_PRIVATE (self);
	_tmp0_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->progress_bar = _tmp0_;
	_tmp1_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp1_);
	self->priv->drawing_area = _tmp1_;
	self->priv->file_content_length = (gint64) -1;
	self->priv->current_content_length = (gint64) 0;
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp2_);
	self->priv->error_label = _tmp2_;
}


static void media_video_widget_finalize (GObject* obj) {
	MediaVideoWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidget);
	_g_object_unref0 (self->priv->src);
	_g_object_unref0 (self->priv->sink);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->drawing_area);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->error_label);
	G_OBJECT_CLASS (media_video_widget_parent_class)->finalize (obj);
}


GType media_video_widget_get_type (void) {
	static volatile gsize media_video_widget_type_id__volatile = 0;
	if (g_once_init_enter (&media_video_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaVideoWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_video_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaVideoWidget), 0, (GInstanceInitFunc) media_video_widget_instance_init, NULL };
		GType media_video_widget_type_id;
		media_video_widget_type_id = g_type_register_static (gtk_stack_get_type (), "MediaVideoWidget", &g_define_type_info, 0);
		g_once_init_leave (&media_video_widget_type_id__volatile, media_video_widget_type_id);
	}
	return media_video_widget_type_id__volatile;
}



