/* StatusIcon.c generated by valac 0.30.0, the Vala compiler
 * generated from StatusIcon.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libnotify/notify.h>
#include <gtk/gtk.h>
#include "deja.h"
#include "widgets.h"
#include <glib/gi18n-lib.h>


#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;
typedef struct _StatusIconPrivate StatusIconPrivate;

#define STATUS_ICON_TYPE_CLOSE_ACTION (status_icon_close_action_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SHELL_STATUS_ICON (shell_status_icon_get_type ())
#define SHELL_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHELL_STATUS_ICON, ShellStatusIcon))
#define SHELL_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHELL_STATUS_ICON, ShellStatusIconClass))
#define IS_SHELL_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHELL_STATUS_ICON))
#define IS_SHELL_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHELL_STATUS_ICON))
#define SHELL_STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHELL_STATUS_ICON, ShellStatusIconClass))

typedef struct _ShellStatusIcon ShellStatusIcon;
typedef struct _ShellStatusIconClass ShellStatusIconClass;

#define TYPE_LEGACY_STATUS_ICON (legacy_status_icon_get_type ())
#define LEGACY_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEGACY_STATUS_ICON, LegacyStatusIcon))
#define LEGACY_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEGACY_STATUS_ICON, LegacyStatusIconClass))
#define IS_LEGACY_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEGACY_STATUS_ICON))
#define IS_LEGACY_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEGACY_STATUS_ICON))
#define LEGACY_STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEGACY_STATUS_ICON, LegacyStatusIconClass))

typedef struct _LegacyStatusIcon LegacyStatusIcon;
typedef struct _LegacyStatusIconClass LegacyStatusIconClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ShellStatusIconPrivate ShellStatusIconPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _LegacyStatusIconPrivate LegacyStatusIconPrivate;

struct _StatusIcon {
	GObject parent_instance;
	StatusIconPrivate * priv;
	gchar* action;
	gdouble progress;
	gchar* later_label;
	gchar* skip_label;
	NotifyNotification* note;
};

struct _StatusIconClass {
	GObjectClass parent_class;
	void (*done) (StatusIcon* self, gboolean success, gboolean cancelled, const gchar* detail);
	void (*update_progress) (StatusIcon* self);
};

struct _StatusIconPrivate {
	GtkWindow* _window;
	DejaDupOperation* _op;
	gboolean _automatic;
	gboolean _show_automatic_progress;
};

typedef enum  {
	STATUS_ICON_CLOSE_ACTION_HIDE,
	STATUS_ICON_CLOSE_ACTION_MINIMIZE
} StatusIconCloseAction;

struct _ShellStatusIcon {
	StatusIcon parent_instance;
	ShellStatusIconPrivate * priv;
};

struct _ShellStatusIconClass {
	StatusIconClass parent_class;
};

struct _LegacyStatusIcon {
	StatusIcon parent_instance;
	LegacyStatusIconPrivate * priv;
};

struct _LegacyStatusIconClass {
	StatusIconClass parent_class;
};

struct _LegacyStatusIconPrivate {
	GtkMenu* menu;
	GtkStatusIcon* icon;
};


static gpointer status_icon_parent_class = NULL;
static gpointer shell_status_icon_parent_class = NULL;
static gpointer legacy_status_icon_parent_class = NULL;

GType status_icon_get_type (void) G_GNUC_CONST;
#define STATUS_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STATUS_ICON, StatusIconPrivate))
enum  {
	STATUS_ICON_DUMMY_PROPERTY,
	STATUS_ICON_WINDOW,
	STATUS_ICON_OP,
	STATUS_ICON_AUTOMATIC,
	STATUS_ICON_SHOW_AUTOMATIC_PROGRESS
};
GType status_icon_close_action_get_type (void) G_GNUC_CONST;
StatusIcon* status_icon_create (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
ShellStatusIcon* shell_status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
ShellStatusIcon* shell_status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic);
GType shell_status_icon_get_type (void) G_GNUC_CONST;
LegacyStatusIcon* legacy_status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
LegacyStatusIcon* legacy_status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic);
GType legacy_status_icon_get_type (void) G_GNUC_CONST;
static void status_icon_set_action_desc (StatusIcon* self, DejaDupOperation* op, const gchar* action);
void status_icon_update_progress (StatusIcon* self);
static void status_icon_note_progress (StatusIcon* self, DejaDupOperation* op, gdouble progress);
void status_icon_done (StatusIcon* self, gboolean success, gboolean cancelled, const gchar* detail);
static void status_icon_real_done (StatusIcon* self, gboolean success, gboolean cancelled, const gchar* detail);
DejaDupOperation* status_icon_get_op (StatusIcon* self);
static void status_icon_real_update_progress (StatusIcon* self);
void status_icon_later (StatusIcon* self);
void status_icon_skip (StatusIcon* self);
StatusIcon* status_icon_construct (GType object_type);
GtkWindow* status_icon_get_window (StatusIcon* self);
static void status_icon_set_window (StatusIcon* self, GtkWindow* value);
static void status_icon_set_op (StatusIcon* self, DejaDupOperation* value);
gboolean status_icon_get_automatic (StatusIcon* self);
static void status_icon_set_automatic (StatusIcon* self, gboolean value);
gboolean status_icon_get_show_automatic_progress (StatusIcon* self);
void status_icon_set_show_automatic_progress (StatusIcon* self, gboolean value);
static GObject * status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _status_icon_set_action_desc_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const gchar* action, gpointer self);
static void _status_icon_note_progress_deja_dup_operation_progress (DejaDupOperation* _sender, gdouble percent, gpointer self);
static void status_icon_finalize (GObject* obj);
static void _vala_status_icon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_status_icon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	SHELL_STATUS_ICON_DUMMY_PROPERTY
};
static GObject * shell_status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _shell_status_icon____lambda5_ (ShellStatusIcon* self);
static void __shell_status_icon____lambda5__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void _shell_status_icon____lambda6_ (ShellStatusIcon* self);
static void __shell_status_icon____lambda6__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void _shell_status_icon____lambda7_ (ShellStatusIcon* self);
static void __shell_status_icon____lambda7__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
#define LEGACY_STATUS_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LEGACY_STATUS_ICON, LegacyStatusIconPrivate))
enum  {
	LEGACY_STATUS_ICON_DUMMY_PROPERTY
};
static void legacy_status_icon_real_update_progress (StatusIcon* base);
static void legacy_status_icon_show_menu (LegacyStatusIcon* self, GtkStatusIcon* status_icon, guint button, guint activate_time);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void legacy_status_icon_ensure_menu (LegacyStatusIcon* self);
static void __lambda8_ (LegacyStatusIcon* self, GtkMenuItem* i);
static void ___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda9_ (LegacyStatusIcon* self, GtkMenuItem* i);
static void ____lambda9__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ____lambda10_ (LegacyStatusIcon* self, GtkMenuItem* i);
static void _____lambda10__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static GObject * legacy_status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _legacy_status_icon_show_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void _legacy_status_icon___lambda11_ (LegacyStatusIcon* self, GtkStatusIcon* s);
static void __legacy_status_icon___lambda11__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
static void legacy_status_icon_finalize (GObject* obj);


GType status_icon_close_action_get_type (void) {
	static volatile gsize status_icon_close_action_type_id__volatile = 0;
	if (g_once_init_enter (&status_icon_close_action_type_id__volatile)) {
		static const GEnumValue values[] = {{STATUS_ICON_CLOSE_ACTION_HIDE, "STATUS_ICON_CLOSE_ACTION_HIDE", "hide"}, {STATUS_ICON_CLOSE_ACTION_MINIMIZE, "STATUS_ICON_CLOSE_ACTION_MINIMIZE", "minimize"}, {0, NULL, NULL}};
		GType status_icon_close_action_type_id;
		status_icon_close_action_type_id = g_enum_register_static ("StatusIconCloseAction", values);
		g_once_init_leave (&status_icon_close_action_type_id__volatile, status_icon_close_action_type_id);
	}
	return status_icon_close_action_type_id__volatile;
}


StatusIcon* status_icon_create (GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	StatusIcon* result = NULL;
	StatusIcon* instance = NULL;
	DejaDupShellEnv _tmp0_ = 0;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (op != NULL, NULL);
	instance = NULL;
	_tmp0_ = deja_dup_get_shell ();
	switch (_tmp0_) {
		case DEJA_DUP_SHELL_ENV_GNOME:
		{
			GtkWindow* _tmp1_ = NULL;
			DejaDupOperation* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			ShellStatusIcon* _tmp4_ = NULL;
			_tmp1_ = window;
			_tmp2_ = op;
			_tmp3_ = automatic;
			_tmp4_ = shell_status_icon_new (_tmp1_, _tmp2_, _tmp3_);
			_g_object_unref0 (instance);
			instance = (StatusIcon*) _tmp4_;
			break;
		}
		default:
		{
			GtkWindow* _tmp5_ = NULL;
			DejaDupOperation* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			LegacyStatusIcon* _tmp8_ = NULL;
			_tmp5_ = window;
			_tmp6_ = op;
			_tmp7_ = automatic;
			_tmp8_ = legacy_status_icon_new (_tmp5_, _tmp6_, _tmp7_);
			_g_object_unref0 (instance);
			instance = (StatusIcon*) _tmp8_;
			break;
		}
	}
	result = instance;
	return result;
}


static void status_icon_set_action_desc (StatusIcon* self, DejaDupOperation* op, const gchar* action) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->action);
	self->action = _tmp1_;
	status_icon_update_progress (self);
}


static void status_icon_note_progress (StatusIcon* self, DejaDupOperation* op, gdouble progress) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	_tmp0_ = progress;
	self->progress = _tmp0_;
	status_icon_update_progress (self);
}


static void status_icon_real_done (StatusIcon* self, gboolean success, gboolean cancelled, const gchar* detail) {
	NotifyNotification* _tmp0_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->note;
	if (_tmp0_ != NULL) {
		{
			NotifyNotification* _tmp1_ = NULL;
			_tmp1_ = self->note;
			notify_notification_close (_tmp1_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch11_g_error;
			}
		}
		goto __finally11;
		__catch11_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_warning ("StatusIcon.vala:120: %s\n", _tmp3_);
			_g_error_free0 (e);
		}
		__finally11:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = success;
	if (_tmp6_) {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = cancelled;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		DejaDupOperation* _tmp8_ = NULL;
		DejaDupToolJobMode _tmp9_ = 0;
		DejaDupToolJobMode _tmp10_ = 0;
		_tmp8_ = self->priv->_op;
		_tmp9_ = deja_dup_operation_get_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* msg = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* more = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		NotifyNotification* _tmp21_ = NULL;
		NotifyNotification* _tmp22_ = NULL;
		_tmp11_ = _ ("Backup completed");
		_tmp12_ = g_strdup (_tmp11_);
		msg = _tmp12_;
		more = NULL;
		_tmp13_ = detail;
		if (_tmp13_ != NULL) {
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			_tmp14_ = _ ("Backup finished");
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (msg);
			msg = _tmp15_;
			_tmp16_ = _ ("Not all files were successfully backed up.  See dialog for more detail" \
"s.");
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (more);
			more = _tmp17_;
		}
		_tmp18_ = _ ("Backups");
		notify_init (_tmp18_);
		_tmp19_ = msg;
		_tmp20_ = more;
		_tmp21_ = notify_notification_new (_tmp19_, _tmp20_, "deja-dup");
		_g_object_unref0 (self->note);
		self->note = _tmp21_;
		_tmp22_ = self->note;
		notify_notification_set_hint_string (_tmp22_, "desktop-entry", "deja-dup");
		{
			NotifyNotification* _tmp23_ = NULL;
			_tmp23_ = self->note;
			notify_notification_show (_tmp23_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch12_g_error;
			}
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError* e = NULL;
			GError* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = e;
			_tmp25_ = _tmp24_->message;
			g_warning ("StatusIcon.vala:140: %s\n", _tmp25_);
			_g_error_free0 (e);
		}
		__finally12:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (more);
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (more);
		_g_free0 (msg);
	}
}


void status_icon_done (StatusIcon* self, gboolean success, gboolean cancelled, const gchar* detail) {
	g_return_if_fail (self != NULL);
	STATUS_ICON_GET_CLASS (self)->done (self, success, cancelled, detail);
}


static void status_icon_real_update_progress (StatusIcon* self) {
}


void status_icon_update_progress (StatusIcon* self) {
	g_return_if_fail (self != NULL);
	STATUS_ICON_GET_CLASS (self)->update_progress (self);
}


void status_icon_later (StatusIcon* self) {
	DejaDupOperation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "hide-all");
	_tmp0_ = self->priv->_op;
	deja_dup_operation_stop (_tmp0_);
}


void status_icon_skip (StatusIcon* self) {
	DejaDupOperation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "hide-all");
	deja_dup_update_last_run_timestamp (DEJA_DUP_TIMESTAMP_TYPE_NONE);
	_tmp0_ = self->priv->_op;
	deja_dup_operation_cancel (_tmp0_);
}


StatusIcon* status_icon_construct (GType object_type) {
	StatusIcon * self = NULL;
	self = (StatusIcon*) g_object_new (object_type, NULL);
	return self;
}


GtkWindow* status_icon_get_window (StatusIcon* self) {
	GtkWindow* result;
	GtkWindow* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void status_icon_set_window (StatusIcon* self, GtkWindow* value) {
	GtkWindow* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_window);
	self->priv->_window = _tmp1_;
	g_object_notify ((GObject *) self, "window");
}


DejaDupOperation* status_icon_get_op (StatusIcon* self) {
	DejaDupOperation* result;
	DejaDupOperation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_op;
	result = _tmp0_;
	return result;
}


static void status_icon_set_op (StatusIcon* self, DejaDupOperation* value) {
	DejaDupOperation* _tmp0_ = NULL;
	DejaDupOperation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_op);
	self->priv->_op = _tmp1_;
	g_object_notify ((GObject *) self, "op");
}


gboolean status_icon_get_automatic (StatusIcon* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_automatic;
	result = _tmp0_;
	return result;
}


static void status_icon_set_automatic (StatusIcon* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_automatic = _tmp0_;
	g_object_notify ((GObject *) self, "automatic");
}


gboolean status_icon_get_show_automatic_progress (StatusIcon* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_automatic_progress;
	result = _tmp0_;
	return result;
}


void status_icon_set_show_automatic_progress (StatusIcon* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_automatic_progress = _tmp0_;
	g_object_notify ((GObject *) self, "show-automatic-progress");
}


static void _status_icon_set_action_desc_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const gchar* action, gpointer self) {
	status_icon_set_action_desc ((StatusIcon*) self, _sender, action);
}


static void _status_icon_note_progress_deja_dup_operation_progress (DejaDupOperation* _sender, gdouble percent, gpointer self) {
	status_icon_note_progress ((StatusIcon*) self, _sender, percent);
}


static GObject * status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	StatusIcon * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	DejaDupOperation* _tmp4_ = NULL;
	DejaDupOperation* _tmp5_ = NULL;
	parent_class = G_OBJECT_CLASS (status_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STATUS_ICON, StatusIcon);
	_tmp0_ = _ ("_Resume Later");
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->later_label);
	self->later_label = _tmp1_;
	_tmp2_ = _ ("_Skip Backup");
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->skip_label);
	self->skip_label = _tmp3_;
	_tmp4_ = self->priv->_op;
	g_signal_connect_object (_tmp4_, "action-desc-changed", (GCallback) _status_icon_set_action_desc_deja_dup_operation_action_desc_changed, self, 0);
	_tmp5_ = self->priv->_op;
	g_signal_connect_object (_tmp5_, "progress", (GCallback) _status_icon_note_progress_deja_dup_operation_progress, self, 0);
	return obj;
}


static void status_icon_class_init (StatusIconClass * klass) {
	status_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StatusIconPrivate));
	((StatusIconClass *) klass)->done = status_icon_real_done;
	((StatusIconClass *) klass)->update_progress = status_icon_real_update_progress;
	G_OBJECT_CLASS (klass)->get_property = _vala_status_icon_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_status_icon_set_property;
	G_OBJECT_CLASS (klass)->constructor = status_icon_constructor;
	G_OBJECT_CLASS (klass)->finalize = status_icon_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_ICON_WINDOW, g_param_spec_object ("window", "window", "window", gtk_window_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_ICON_OP, g_param_spec_object ("op", "op", "op", DEJA_DUP_TYPE_OPERATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_ICON_AUTOMATIC, g_param_spec_boolean ("automatic", "automatic", "automatic", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_ICON_SHOW_AUTOMATIC_PROGRESS, g_param_spec_boolean ("show-automatic-progress", "show-automatic-progress", "show-automatic-progress", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("show_window", TYPE_STATUS_ICON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("hide_all", TYPE_STATUS_ICON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void status_icon_instance_init (StatusIcon * self) {
	self->priv = STATUS_ICON_GET_PRIVATE (self);
	self->priv->_automatic = FALSE;
	self->priv->_show_automatic_progress = FALSE;
}


static void status_icon_finalize (GObject* obj) {
	StatusIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STATUS_ICON, StatusIcon);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->_op);
	_g_free0 (self->action);
	_g_free0 (self->later_label);
	_g_free0 (self->skip_label);
	_g_object_unref0 (self->note);
	G_OBJECT_CLASS (status_icon_parent_class)->finalize (obj);
}


/**
 * There are three modes for 'shell' integration:
 * 1) GNOME Shell
 * 2) Unity
 * 3) Legacy
 * 
 * GNOME Shell:
 * No status icon at all.
 * Actions on persistent notifications.
 * Detected by 'persistent' capability of notification server.
 * Automatic-start and success notifications.
 * 
 * Unity:
 * Register as a launcher entry.
 * Always shows progress.
 * Success notification.
 * Detected by presence of Unity (usually on Ubuntu).
 * 
 * Legacy:
 * Standard GTK+ status icon.
 * Success notification.
 */
GType status_icon_get_type (void) {
	static volatile gsize status_icon_type_id__volatile = 0;
	if (g_once_init_enter (&status_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StatusIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) status_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StatusIcon), 0, (GInstanceInitFunc) status_icon_instance_init, NULL };
		GType status_icon_type_id;
		status_icon_type_id = g_type_register_static (G_TYPE_OBJECT, "StatusIcon", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&status_icon_type_id__volatile, status_icon_type_id);
	}
	return status_icon_type_id__volatile;
}


static void _vala_status_icon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	StatusIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STATUS_ICON, StatusIcon);
	switch (property_id) {
		case STATUS_ICON_WINDOW:
		g_value_set_object (value, status_icon_get_window (self));
		break;
		case STATUS_ICON_OP:
		g_value_set_object (value, status_icon_get_op (self));
		break;
		case STATUS_ICON_AUTOMATIC:
		g_value_set_boolean (value, status_icon_get_automatic (self));
		break;
		case STATUS_ICON_SHOW_AUTOMATIC_PROGRESS:
		g_value_set_boolean (value, status_icon_get_show_automatic_progress (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_status_icon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	StatusIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STATUS_ICON, StatusIcon);
	switch (property_id) {
		case STATUS_ICON_WINDOW:
		status_icon_set_window (self, g_value_get_object (value));
		break;
		case STATUS_ICON_OP:
		status_icon_set_op (self, g_value_get_object (value));
		break;
		case STATUS_ICON_AUTOMATIC:
		status_icon_set_automatic (self, g_value_get_boolean (value));
		break;
		case STATUS_ICON_SHOW_AUTOMATIC_PROGRESS:
		status_icon_set_show_automatic_progress (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


ShellStatusIcon* shell_status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	ShellStatusIcon * self = NULL;
	GtkWindow* _tmp0_ = NULL;
	DejaDupOperation* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (op != NULL, NULL);
	_tmp0_ = window;
	_tmp1_ = op;
	_tmp2_ = automatic;
	self = (ShellStatusIcon*) g_object_new (object_type, "window", _tmp0_, "op", _tmp1_, "automatic", _tmp2_, NULL);
	return self;
}


ShellStatusIcon* shell_status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	return shell_status_icon_construct (TYPE_SHELL_STATUS_ICON, window, op, automatic);
}


static void _shell_status_icon____lambda5_ (ShellStatusIcon* self) {
	g_signal_emit_by_name ((StatusIcon*) self, "show-window");
}


static void __shell_status_icon____lambda5__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	_shell_status_icon____lambda5_ ((ShellStatusIcon*) self);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void _shell_status_icon____lambda6_ (ShellStatusIcon* self) {
	status_icon_later ((StatusIcon*) self);
}


static void __shell_status_icon____lambda6__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	_shell_status_icon____lambda6_ ((ShellStatusIcon*) self);
}


static void _shell_status_icon____lambda7_ (ShellStatusIcon* self) {
	status_icon_skip ((StatusIcon*) self);
}


static void __shell_status_icon____lambda7__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	_shell_status_icon____lambda7_ ((ShellStatusIcon*) self);
}


static GObject * shell_status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ShellStatusIcon * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (shell_status_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHELL_STATUS_ICON, ShellStatusIcon);
	_tmp1_ = status_icon_get_automatic ((StatusIcon*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		DejaDupOperation* _tmp3_ = NULL;
		DejaDupOperation* _tmp4_ = NULL;
		DejaDupToolJobMode _tmp5_ = 0;
		DejaDupToolJobMode _tmp6_ = 0;
		_tmp3_ = status_icon_get_op ((StatusIcon*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = deja_dup_operation_get_mode (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		NotifyNotification* _tmp9_ = NULL;
		NotifyNotification* _tmp10_ = NULL;
		NotifyNotification* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		NotifyNotification* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		NotifyNotification* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp7_ = _ ("Backups");
		notify_init (_tmp7_);
		_tmp8_ = _ ("Starting scheduled backup");
		_tmp9_ = notify_notification_new (_tmp8_, NULL, "deja-dup");
		_g_object_unref0 (((StatusIcon*) self)->note);
		((StatusIcon*) self)->note = _tmp9_;
		_tmp10_ = ((StatusIcon*) self)->note;
		notify_notification_set_hint_string (_tmp10_, "desktop-entry", "deja-dup");
		_tmp11_ = ((StatusIcon*) self)->note;
		_tmp12_ = _ ("Show Progress");
		notify_notification_add_action (_tmp11_, "show-details", _tmp12_, __shell_status_icon____lambda5__notify_action_callback, g_object_ref (self), g_object_unref);
		_tmp13_ = ((StatusIcon*) self)->note;
		_tmp14_ = ((StatusIcon*) self)->later_label;
		_tmp15_ = string_replace (_tmp14_, "_", "");
		_tmp16_ = _tmp15_;
		notify_notification_add_action (_tmp13_, "later", _tmp16_, __shell_status_icon____lambda6__notify_action_callback, g_object_ref (self), g_object_unref);
		_g_free0 (_tmp16_);
		_tmp17_ = ((StatusIcon*) self)->note;
		_tmp18_ = ((StatusIcon*) self)->skip_label;
		_tmp19_ = string_replace (_tmp18_, "_", "");
		_tmp20_ = _tmp19_;
		notify_notification_add_action (_tmp17_, "skip", _tmp20_, __shell_status_icon____lambda7__notify_action_callback, g_object_ref (self), g_object_unref);
		_g_free0 (_tmp20_);
		{
			NotifyNotification* _tmp21_ = NULL;
			_tmp21_ = ((StatusIcon*) self)->note;
			notify_notification_show (_tmp21_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch14_g_error;
			}
		}
		goto __finally14;
		__catch14_g_error:
		{
			GError* e = NULL;
			GError* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			g_warning ("StatusIcon.vala:243: %s\n", _tmp23_);
			_g_error_free0 (e);
		}
		__finally14:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	return obj;
}


static void shell_status_icon_class_init (ShellStatusIconClass * klass) {
	shell_status_icon_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = shell_status_icon_constructor;
}


static void shell_status_icon_instance_init (ShellStatusIcon * self) {
}


GType shell_status_icon_get_type (void) {
	static volatile gsize shell_status_icon_type_id__volatile = 0;
	if (g_once_init_enter (&shell_status_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ShellStatusIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shell_status_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShellStatusIcon), 0, (GInstanceInitFunc) shell_status_icon_instance_init, NULL };
		GType shell_status_icon_type_id;
		shell_status_icon_type_id = g_type_register_static (TYPE_STATUS_ICON, "ShellStatusIcon", &g_define_type_info, 0);
		g_once_init_leave (&shell_status_icon_type_id__volatile, shell_status_icon_type_id);
	}
	return shell_status_icon_type_id__volatile;
}


LegacyStatusIcon* legacy_status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	LegacyStatusIcon * self = NULL;
	GtkWindow* _tmp0_ = NULL;
	DejaDupOperation* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (op != NULL, NULL);
	_tmp0_ = window;
	_tmp1_ = op;
	_tmp2_ = automatic;
	self = (LegacyStatusIcon*) g_object_new (object_type, "window", _tmp0_, "op", _tmp1_, "automatic", _tmp2_, NULL);
	return self;
}


LegacyStatusIcon* legacy_status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	return legacy_status_icon_construct (TYPE_LEGACY_STATUS_ICON, window, op, automatic);
}


static void legacy_status_icon_real_update_progress (StatusIcon* base) {
	LegacyStatusIcon * self;
	gchar* tooltip = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gdouble _tmp4_ = 0.0;
	GtkStatusIcon* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	self = (LegacyStatusIcon*) base;
	_tmp0_ = g_strdup ("");
	tooltip = _tmp0_;
	_tmp1_ = ((StatusIcon*) self)->action;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = ((StatusIcon*) self)->action;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (tooltip);
		tooltip = _tmp3_;
	}
	_tmp4_ = ((StatusIcon*) self)->progress;
	if (_tmp4_ > ((gdouble) 0)) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp5_ = tooltip;
		_tmp6_ = g_strconcat (_tmp5_, "\n", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = _ ("%.1f%% complete");
		_tmp9_ = ((StatusIcon*) self)->progress;
		_tmp10_ = g_strdup_printf (_tmp8_, _tmp9_ * 100);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp7_, _tmp11_, NULL);
		_g_free0 (tooltip);
		tooltip = _tmp12_;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp7_);
	}
	_tmp13_ = self->priv->icon;
	_tmp14_ = tooltip;
	gtk_status_icon_set_tooltip_text (_tmp13_, _tmp14_);
	_g_free0 (tooltip);
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, (GtkStatusIcon*) self);
	g_object_unref (self);
}


static void legacy_status_icon_show_menu (LegacyStatusIcon* self, GtkStatusIcon* status_icon, guint button, guint activate_time) {
	GtkMenu* _tmp0_ = NULL;
	GtkStatusIcon* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	_tmp0_ = self->priv->menu;
	_tmp1_ = status_icon;
	_tmp2_ = button;
	_tmp3_ = activate_time;
	gtk_menu_popup (_tmp0_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, g_object_ref (_tmp1_), _tmp2_, (guint32) _tmp3_);
}


static void __lambda8_ (LegacyStatusIcon* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	g_signal_emit_by_name ((StatusIcon*) self, "show-window");
}


static void ___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda8_ ((LegacyStatusIcon*) self, _sender);
}


static void ___lambda9_ (LegacyStatusIcon* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	status_icon_later ((StatusIcon*) self);
}


static void ____lambda9__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda9_ ((LegacyStatusIcon*) self, _sender);
}


static void ____lambda10_ (LegacyStatusIcon* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	status_icon_skip ((StatusIcon*) self);
}


static void _____lambda10__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	____lambda10_ ((LegacyStatusIcon*) self, _sender);
}


static void legacy_status_icon_ensure_menu (LegacyStatusIcon* self) {
	GtkMenu* _tmp0_ = NULL;
	GtkMenuItem* progressitem = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMenuItem* _tmp2_ = NULL;
	GtkMenuItem* _tmp3_ = NULL;
	GtkMenu* _tmp4_ = NULL;
	GtkMenuItem* _tmp5_ = NULL;
	DejaDupOperation* _tmp6_ = NULL;
	DejaDupOperation* _tmp7_ = NULL;
	DejaDupToolJobMode _tmp8_ = 0;
	DejaDupToolJobMode _tmp9_ = 0;
	GtkMenu* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp0_;
	_tmp1_ = _ ("Show _Progress");
	_tmp2_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp1_);
	g_object_ref_sink (_tmp2_);
	progressitem = _tmp2_;
	_tmp3_ = progressitem;
	g_signal_connect_object (_tmp3_, "activate", (GCallback) ___lambda8__gtk_menu_item_activate, self, 0);
	_tmp4_ = self->priv->menu;
	_tmp5_ = progressitem;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = status_icon_get_op ((StatusIcon*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = deja_dup_operation_get_mode (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
		GtkMenuItem* item = NULL;
		GtkMenu* _tmp10_ = NULL;
		GtkSeparatorMenuItem* _tmp11_ = NULL;
		GtkSeparatorMenuItem* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GtkMenuItem* _tmp14_ = NULL;
		GtkMenuItem* _tmp15_ = NULL;
		GtkMenu* _tmp16_ = NULL;
		GtkMenuItem* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		_tmp10_ = self->priv->menu;
		_tmp11_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp10_, (GtkWidget*) ((GtkMenuItem*) _tmp12_));
		_g_object_unref0 (_tmp12_);
		_tmp13_ = ((StatusIcon*) self)->later_label;
		_tmp14_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp13_);
		g_object_ref_sink (_tmp14_);
		_g_object_unref0 (item);
		item = _tmp14_;
		_tmp15_ = item;
		g_signal_connect_object (_tmp15_, "activate", (GCallback) ____lambda9__gtk_menu_item_activate, self, 0);
		_tmp16_ = self->priv->menu;
		_tmp17_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp16_, (GtkWidget*) _tmp17_);
		_tmp18_ = status_icon_get_automatic ((StatusIcon*) self);
		_tmp19_ = _tmp18_;
		if (_tmp19_) {
			const gchar* _tmp20_ = NULL;
			GtkMenuItem* _tmp21_ = NULL;
			GtkMenuItem* _tmp22_ = NULL;
			GtkMenu* _tmp23_ = NULL;
			GtkMenuItem* _tmp24_ = NULL;
			_tmp20_ = ((StatusIcon*) self)->skip_label;
			_tmp21_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp20_);
			g_object_ref_sink (_tmp21_);
			_g_object_unref0 (item);
			item = _tmp21_;
			_tmp22_ = item;
			g_signal_connect_object (_tmp22_, "activate", (GCallback) _____lambda10__gtk_menu_item_activate, self, 0);
			_tmp23_ = self->priv->menu;
			_tmp24_ = item;
			gtk_menu_shell_append ((GtkMenuShell*) _tmp23_, (GtkWidget*) _tmp24_);
		}
		_g_object_unref0 (item);
	}
	status_icon_update_progress ((StatusIcon*) self);
	_tmp25_ = self->priv->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp25_);
	_g_object_unref0 (progressitem);
}


static void _legacy_status_icon_show_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	legacy_status_icon_show_menu ((LegacyStatusIcon*) self, _sender, button, activate_time);
}


static void _legacy_status_icon___lambda11_ (LegacyStatusIcon* self, GtkStatusIcon* s) {
	GtkStatusIcon* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	_tmp1_ = gtk_get_current_event_time ();
	legacy_status_icon_show_menu (self, _tmp0_, (guint) 0, (guint) _tmp1_);
}


static void __legacy_status_icon___lambda11__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	_legacy_status_icon___lambda11_ ((LegacyStatusIcon*) self, _sender);
}


static GObject * legacy_status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	LegacyStatusIcon * self;
	GtkStatusIcon* _tmp0_ = NULL;
	GtkStatusIcon* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkStatusIcon* _tmp3_ = NULL;
	GtkStatusIcon* _tmp4_ = NULL;
	parent_class = G_OBJECT_CLASS (legacy_status_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LEGACY_STATUS_ICON, LegacyStatusIcon);
	_tmp0_ = gtk_status_icon_new ();
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp0_;
	_tmp1_ = self->priv->icon;
	_tmp2_ = g_get_application_name ();
	g_object_set ((GObject*) _tmp1_, "icon-name", "deja-dup-symbolic", "title", _tmp2_, NULL);
	legacy_status_icon_ensure_menu (self);
	_tmp3_ = self->priv->icon;
	g_signal_connect_object (_tmp3_, "popup-menu", (GCallback) _legacy_status_icon_show_menu_gtk_status_icon_popup_menu, self, 0);
	_tmp4_ = self->priv->icon;
	g_signal_connect_object (_tmp4_, "activate", (GCallback) __legacy_status_icon___lambda11__gtk_status_icon_activate, self, 0);
	return obj;
}


static void legacy_status_icon_class_init (LegacyStatusIconClass * klass) {
	legacy_status_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LegacyStatusIconPrivate));
	((StatusIconClass *) klass)->update_progress = legacy_status_icon_real_update_progress;
	G_OBJECT_CLASS (klass)->constructor = legacy_status_icon_constructor;
	G_OBJECT_CLASS (klass)->finalize = legacy_status_icon_finalize;
}


static void legacy_status_icon_instance_init (LegacyStatusIcon * self) {
	self->priv = LEGACY_STATUS_ICON_GET_PRIVATE (self);
}


static void legacy_status_icon_finalize (GObject* obj) {
	LegacyStatusIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LEGACY_STATUS_ICON, LegacyStatusIcon);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->icon);
	G_OBJECT_CLASS (legacy_status_icon_parent_class)->finalize (obj);
}


GType legacy_status_icon_get_type (void) {
	static volatile gsize legacy_status_icon_type_id__volatile = 0;
	if (g_once_init_enter (&legacy_status_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LegacyStatusIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) legacy_status_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LegacyStatusIcon), 0, (GInstanceInitFunc) legacy_status_icon_instance_init, NULL };
		GType legacy_status_icon_type_id;
		legacy_status_icon_type_id = g_type_register_static (TYPE_STATUS_ICON, "LegacyStatusIcon", &g_define_type_info, 0);
		g_once_init_leave (&legacy_status_icon_type_id__volatile, legacy_status_icon_type_id);
	}
	return legacy_status_icon_type_id__volatile;
}



